<?php
class npapi
{
	var $apikey;
	var $rsp;
	var $create_xml_object = true;
	var $userid;
	var $companyid;
	var $result;
	var $ok = false;
	var $errorcode = "";
	var $display_xml = false;
	var $fields = array();
	var $table = "";
	var $data_label = "data";
	var $debug = 0;
	var $baseurl = "";
	var $action = "";
	var $buffer = "";
	
	function __construct($apikey, $userid, $companyid, $baseurl) {
		$this->apikey = $apikey;
		$this->userid = $userid;
		$this->companyid = $companyid;
		$this->baseurl = $baseurl."/rest/";	  // Add res onto end
	}
	
	function set_data($name, $value="") {
		$varname = $this->data_label;
		if (is_array($name)) {
			if ($this->table) {
				$varname .= "[".$this->table."]";	
			}	
			foreach ($name as $key => $val) {
				if (is_array($val)) {
					foreach ($val as $k => $v) {
						$var = $varname."[$key][".$k."]";
						$this->fields[$var] = $v;	
					}
				} else {
					$var = $varname."[".$key."]";
					$this->fields[$var] = $val;
				}
			}
		} else if ($name) {
			if ($this->table) {
				$varname .= "[".$this->table."][".$name."]";
				$this->fields[$varname] = $value;	
			}	
		}
	}
	
	function set_table($name="") {
		$this->table = $name;
	}
	
	function clear_fields() {
		$this->fields = array();
	}
	
	function call_api($url="", $fieldarr="") {
		if (!is_array($fieldarr)) {
			$fieldarr = $this->fields;	
		}
		if (!$url) {
			$url = $this->baseurl.$this->action;	
		}
		// Create the hash -- Base64(HMAC-SHA1(UTF-8-Encode(String)))
		$urlsub = str_replace("://", "",$url);
		$posslash = strpos($urlsub, "/");
		$posq = strpos($urlsub, "?");
		if ($posq === false) $posq = strlen($urlsub);
		$urlsub = substr($urlsub, $posslash, $posq-$posslash);
		$fieldarr = array_merge($fieldarr, array("auth[url]" => $urlsub));
		$fieldarr = array_merge($fieldarr, array("auth[companyid]" => $this->companyid));
		$fieldarr = array_merge($fieldarr, array("auth[userid]" => $this->userid));
		$this->addhash($fieldarr, $this->apikey);
		
		//Start curl session
		$urlarray = array();

		foreach ($fieldarr as $key => $value) {
			$urlarray[] = "$key=".urlencode($value);
		}
		$fields = implode("&", $urlarray);
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_HEADER, 0); 
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);  // set the fields to post 
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);    // make sure we get the response back 
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); 
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); 
		$this->buffer = curl_exec($ch);
		curl_close($ch);
		$this->fields = array();
		$this->table = "";
		if ($this->debug) {	
		}
		$xmlerror = 0;
		if (substr($this->buffer, 0, 39) != '<?xml version="1.0" encoding="utf-8" ?>') {
			$xmlerror = 1;
		}
		if ($this->create_xml_object) {
			if ($xmlerror) {
				// A problem with the xml file
				$this->result = "fail";
				$this->errorcode = "Unknown error with script";
				$this->ok = false;
			} else {
				$this->rsp = new SimpleXMLElement($this->buffer);
				$this->result = $this->rsp['stat'];
				if ($this->result == 'ok') {
					$this->ok = true;
					$this->errorcode = "";
				} else {
					$this->ok = false;
					$this->errorcode = $this->rsp->err['code'];
				}
			}
		}
		if ($this->display_xml) {
			if (!$xmlerror) {
				header("Content-Type: text/xml");
			}
			echo $this->buffer;	
			return;
		}
		return $this->buffer;

	}
	
	function addhash(&$fieldarr, $apikey) {
		$text = "";
		$fieldarr = array_merge($fieldarr, array("auth[time]" => time()));
		foreach ($fieldarr as $key => $value) {
			$text .= "$key$value";
		}
		$hash = $this->hmacsha1($apikey, $text);
		$fieldarr = array_merge($fieldarr, array("auth[hash]" => $hash));
	}
	
	function hmacsha1($key,$data) {
	    $blocksize=64;
	    $hashfunc='sha1';
	    // Convert to utf-8
	    $data = mb_convert_encoding($data, "UTF-8", "auto");
	    $key = mb_convert_encoding($key, "UTF-8", "auto");
	    if (strlen($key)>$blocksize) {
	        $key=pack('H*', $hashfunc($key));
	    }
	    $key=str_pad($key,$blocksize,chr(0x00));
	    $ipad=str_repeat(chr(0x36),$blocksize);
	    $opad=str_repeat(chr(0x5c),$blocksize);
	    $hmac = pack(
	                'H*',$hashfunc(
	                    ($key^$opad).pack(
	                        'H*',$hashfunc(
	                            ($key^$ipad).$data
	                        )
	                    )
	                )
	            );
	    return base64_encode($hmac);
	}
}