<?php
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Send Accounts
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function nolapro_send_accounts($custid='', $flexfield='', $invcompany='', $arcompany='') {
	global $adb, $np, $msg;
	
	// Get som basic info from np
	if (!$flexfield) {
		$flexfieldid = nolapro_get_flexfield('vtigeraccountid');
	}
	if (!$flexfieldid) {
		$msg = "Please activate the vtiger plug-in inside NolaPro";
		return 0;
	}
	
	// Get company defaults
	if (!$invcompany) {
		$invcompany = nolapro_get_company_defaults("invcompany");
	}
	if (!$invcompany) {
		$msg = "Error retrieving NolaPro inventory defaults.";
		return 0;
	}
	if (!$arcompany) {
		$arcompany = nolapro_get_company_defaults("arcompany");
	}
	if (!$arcompany) {
		$msg = "Error retrieving NolaPro AR defaults.";
		return 0;
	}
	$extrasql = "";
	if ($custid) {
		$extrasql = " and a.accountid = '$custid' ";
	}
	// Get a list of accounts to check
	$sql = "select *
			from vtiger_account a, vtiger_accountbillads b
			where a.accountid = b.accountaddressid
				$extrasql";
	$rs = $adb->query($sql);
	
	if (!$rs) {
		die('Error searching vtiger account records.');
	}
	$api = new npapi($np['apikey'], $np['apiuserid'], $np['apicompanyid'], $np['apiurl']);
	$count = 0;
	$rt = array();  // Used if we need to return customer id
	while (!$rs->EOF) {
		$count++;
		$customerid = $rs->fields['accountid'];
		// Get contact info 
		$sql = "select * 
				from vtiger_contactdetails
				where accountid = '".$rs->fields['accountid']."'
				limit 1";
		$rsc = $adb->query($sql);
		if (!$rsc) {
			die('Error searching vtiger account records.');
		}
		
		$data = array();
		// See if this customer is already in there
		// Find NolaPro id for this vtigeraccountid
		$data = array("conditions" => "flexfieldid='$flexfieldid' and value='$customerid'");
		$api->set_data($data);
		$api->action = "flexvalue/search";
		$api->call_api();
		$np_customerid = 0;
		if ($api->ok) {
			$np_customerid = (string) $api->rsp->flexvalue->recordid;
		}
		$salesglacctid = 0;
		$customer_price_level = 0;
		$invoicetermsid = 0;
		if (!$np_customerid) {
			// Prepare to add a new customer			
			if (!$salesglacctid) {
				$salesglacctid = (string) $invcompany->sales;
			}
			if (!$customer_price_level) {
				$customer_price_level = (string) $invcompany->default_pricelevelid;
			}
			if (!$invoicetermsid) {
				$invoicetermsid = (string) $arcompany->default_invoicetermsid;
			}
			$data = array(	"salesglacctid" => $salesglacctid,
							"customer_price_level" => $customer_price_level,
							"invoicetermsid" => $invoicetermsid,
							"weather_cf" => "F");
			$api->set_table('customer');
			$api->set_data($data);
		} else {
			$api->set_table('customer');
			$api->set_data('id', $np_customerid);	
		}
		if (!$rs->fields['accountname']) {
			$rs->fields['accountname'] = $rsc->fields['firstname']. ' '. $rsc->fields['lastname'];	
		}
		$data = array(	"companyname" => $rs->fields['accountname'],
						"entry_firstname" => $rsc->fields['firstname'],
						"entry_lastname" => $rsc->fields['lastname'],
						"address1" => $rs->fields['bill_street'],
						"city" => $rs->fields['bill_city'],
						"state" => $rs->fields['bill_state'],
						"zip" => $rs->fields['bill_code'],
						"country" => $rs->fields['bill_country'],
						"phone1" => $rsc->fields['phone'],
						"email1" => $rsc->fields['email'],
						"weather_zip" => $rs->fields['bill_code']);
		// Save the customer
		$api->set_data($data);
		$api->action = "customer/save";
		$api->call_api();
		$addflexfield = 0;
		if ($api->errorcode == 90012) {  // Entry exists for this company
			$cond = array("conditions" => "companyname='".addslashes($rs->fields['accountname'])."' and cancel='0'");
			$api->set_data($cond);
			$api->action = "customer/search";
			$api->call_api();
			if (!$api->ok) {
				$data['companyname'] = $rs->fields['accountname']." ".date("Y-m-d");
			} else {
				$np_customerid = (string) $api->rsp->customer->id;
				$data['id'] = $np_customerid;
				$addflexfield = 1;  // Add a flexfield since one doesn't exist
			}
			$api->set_table('customer');
			$api->set_data($data);
			$api->action = "customer/save";
			$api->call_api();
		}
		if ($api->ok) {
			if (!$np_customerid || $addflexfield) {
				$np_customerid = (string) $api->rsp->customer['id'];
				// Add a record to tie vtiger id to nolapro id
				$api->set_table('flexvalue');
				$data = array(	"flexfieldid" => $flexfieldid,
								"recordid" => $np_customerid,
								"value" => $customerid);
				$api->set_data($data);
				$api->action = "flexvalue/save";
				$api->call_api();
			}	
			
			// Add a ship to record
			// Create a shipto record
			$shiptoid = 0;
			$api->set_table('shipto');
			
			if (!$rs->fields['accountname']) {
				$rs->fields['accountname'] = $rsc->fields['firstname']. ' '. $rsc->fields['lastname'];	
			}
			$data = array(	"shipname" => $rs->fields['accountname'],
							"entry_firstname" => $rsc->fields['firstname'],
							"entry_lastname" => $rsc->fields['lastname'],
							"address1" => $rs->fields['bill_street'],
							"city" => $rs->fields['bill_city'],
							"state" => $rs->fields['bill_state'],
							"zip" => $rs->fields['bill_code'],
							"country" => $rs->fields['bill_country'],
							"phone1" => $rsc->fields['phone'],
							"email1" => $rsc->fields['email'],
							"customerid" => $np_customerid,
							"weather_cf" => "F",
							"weather_zip" => $rs->fields['bill_code']);
			$api->set_data($data);
			$api->action = "shipto/save";
			$api->call_api();
			if ($api->errorcode == 90012) {  // Entry exists for this company
				$cond = array("conditions" => "shipname='".$rs->fields['accountname']."' and cancel='0'");
				$api->set_data($cond);
				$api->action = "shipto/search";
				$api->call_api();
				if (!$api->ok) {
					$data['shipname'] = $rs->fields['accountname']." ".date("Y-m-d");
				} else {
					$shiptoid = (string) $api->rsp->shipto->id;
					$data['id'] = $shiptoid;
					unset($data['weather_cf']); //Don't override this if this record already exists
				}
				$api->set_table('shipto');
				$api->set_data($data);
				$api->action = "shipto/save";
				$api->call_api();
			}
			if ($api->ok) {
				$shiptoid = (string) $api->rsp->shipto['id'];	
			} else {
				$msg .= "<br>Error adding ship-to record for account ".$rs->fields['accountname'];	
			}
		} else {
			$msg .= "<br>Error adding account ".$rs->fields['accountname'];	
			$count--;
		}
		$rt['customerid'] = $np_customerid;
		$rt['shiptoid'] = $shiptoid;
		$rs->movenext();
	}
	if ($custid) {
		return $rt;
	} else {
		$msg .= "Sent $count Account records to NolaPro<br>";
	}
	

}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Send Products
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function nolapro_send_products() {
	global $adb, $np, $msg;
	
	// Get som basic info from np
	$flexfieldid = nolapro_get_flexfield('vtigerproductid');
	if (!$flexfieldid) {
		$msg = "Please activate the vtiger plug-in inside NolaPro";
		return 0;
	}
	
	// Get company defaults
	$invcompany = nolapro_get_company_defaults("invcompany");
	if (!$invcompany) {
		$msg = "Error retrieving NolaPro inventory defaults.";
		return 0;
	}
	$arcompany = nolapro_get_company_defaults("arcompany");
	if (!$arcompany) {
		$msg = "Error retrieving NolaPro AR defaults.";
		return 0;
	}
	$api = new npapi($np['apikey'], $np['apiuserid'], $np['apicompanyid'], $np['apiurl']);

	$data = array("conditions" => "cancel = '0' and companyid = '$api->companyid' ",
				  "fields" => array('id', 'name'),
				  "limit" => 6000);
	$api->set_data($data);
	$api->action = "itemcategory/search";
	$api->call_api();
	$npitemcats = array();
	if ($api->ok) {
		foreach ($api->rsp->itemcategory as $cat) {
			$npitemcats[(string) $cat->name] = (string) $cat->id;
		}
	}
	
	// Make sure we have item categories
	$sql = "select distinct productcategory
			from vtiger_products";
	$rs = $adb->query($sql);
	if (!$rs) {
		die('Error searching vtiger product records.');
	}
	while ($r = $rs->fetchrow()) {
		if (!isset($npitemcats[$r['productcategory']])) {
			// Add this category
			$api->set_table('itemcategory');
			$data = array(	"name" => $r['productcategory'],
							"invtype" => 1);
			$api->set_data($data);
			$api->action = "itemcategory/save";
			$api->call_api();
			if ($api->ok) {
				$npitemcats[$r['productcategory']] = (string) $api->rsp->itemcategory['id'];
			} else {
				$msg .= $api->errorcode.": ".$api->rsp->err['msg']."<br>";
			}
		}
	}
	
	// Make sure we have entries for units of measure
	$data = array("conditions" => "cancel = '0' ",
				  "fields" => array('id', 'unitname'),
				  "limit" => 6000);
	$api->set_data($data);
	$api->action = "unitname/search";
	$api->call_api();
	$npunits = array();
	if ($api->ok) {
		foreach ($api->rsp->unitname as $cat) {
			$npunits[(string) $cat->unitname] = (string) $cat->id;
		}
	}

	$sql = "select distinct usageunit
			from vtiger_products";
	$rs = $adb->query($sql);
	if (!$rs) {
		die('Error searching vtiger product records.');
	}
	while ($r = $rs->fetchrow()) {
		if (!isset($npunits[$r['usageunit']])) {
			// Add this category
			$api->set_table('unitname');
			$data = array(	"unitname" => $r['usageunit']);
			$api->set_data($data);
			$api->action = "unitname/save";
			$api->call_api();
			if ($api->ok) {
				$npunits[$r['usageunit']] = (string) $api->rsp->unitname['id'];
				file_put_contents('testapi.xml', $api->buffer);
			} else {
				$msg .= $api->errorcode.": ".$api->rsp->err['msg']."<br>";
			}
		}
	}
	
	// Get GL accounts
	$data = array("conditions" => "cancel = '0' and companyid in (0, '$api->companyid') ",
				  "fields" => array('id', 'name', 'description'),
				  "limit" => 6000);
	$api->set_data($data);
	$api->action = "glaccount/search";
	$api->call_api();
	$npgl = array();  // Holds np glaccount IDs
	if ($api->ok) {
		foreach ($api->rsp->glaccount as $cat) {
			$npgl[(string) $cat->name.'-'.(string) $cat->description] = (string) $cat->id;
		}
	}
	
	// Get a list of products to check
	$sql = "select *
			from vtiger_products p";
	$rs = $adb->query($sql);
	
	if (!$rs) {
		die('Error searching vtiger product records.');
	}
	
	$count = 0;
	while (!$rs->EOF) {
		$count++;
		$productid = $rs->fields['productid'];
		
		$data = array();
		// See if this item is already in there
		// Find NolaPro id for this vtigerproductid
		$data = array("conditions" => "flexfieldid='$flexfieldid' and value='$productid'");
		$api->set_data($data);
		$api->action = "flexvalue/search";
		$api->call_api();
		$npitemid = 0;
		if ($api->ok) {
			$npitemid = (string) $api->rsp->flexvalue->recordid;
		}
		$salesglacctid = 0;
		if (!$npitemid) {
			// Prepare to add a new product		
			$salesglacctid = $npgl[$rs->fields['glacct']];	
			if (!$salesglacctid) {
				$salesglacctid = (string) $invcompany->sales;
			}	
			$api->set_table('item');
	
			$data = array(	"salesglacctid" => $salesglacctid,
							"itemcode" => $rs->fields['productcode'],
							"description" => $rs->fields['productname'],
							"categoryid" => $npitemcats[$rs->fields['productcategory']],
							"stockunitnameid" => $npunits[$rs->fields['usageunit']],
							"priceunitnameid" => $npunits[$rs->fields['usageunit']],
							"lbsperpriceunit" => $rs->fields['weight'],
							"priceunitsperstockunit" => (!$rs->fields['qty_per_unit']?1:1/$rs->fields['qty_per_unit']),
							"stockunitsperpriceunit" => (!$rs->fields['qty_per_unit']?1:$rs->fields['qty_per_unit']),
							"inventoryglacctid" => (string) $invcompany->default_inventoryglacct,
							"cogs" => (string) $invcompany->cost,
							"products_website" => $rs->fields['website'],
							"taxexempt" => '',
							"status" => ($rs->fields['discontinued']?0:1));
			// Save the product
			$api->set_data($data);
			$api->action = "item/save";
			$api->call_api();
			$addflexfield = 0;
			if ($api->ok) {
				$npitemid = (string) $api->rsp->item['id'];
				// Add a record to tie vtiger id to nolapro id
				$api->set_table('flexvalue');
				$data = array(	"flexfieldid" => $flexfieldid,
								"recordid" => $npitemid,
								"value" => $productid);
				$api->set_data($data);
				$api->action = "flexvalue/save";
				$api->call_api();
				
				// Add a itemlocation record
				$api->set_table('itemlocation');
				$data = array(	"itemid" => $npitemid,
								"inventorylocationid" => (string) $invcompany->locationid,
								"minstocklevelseason1" => $rs->fields['reorderlevel']);
				$api->set_data($data);
				$api->action = "itemlocation/save";
				$api->call_api();
				if (!$api->ok) {
					$msg .= "<br>Error adding itemlocation record for product ".$rs->fields['productname'].' '.$api->rsp->err['code'].': '.$api->rsp->err['msg'];	
				}
				
				// Add pricing
				$api->set_table('priceperpriceunit');
				$data = array(	"itemid" => $npitemid,
								"itemlocationid" => (string) $invcompany->locationid,
								"pricelevelid" => (string) $invcompany->default_pricelevelid,
								"price" => $rs->fields['unit_price']);
				$api->set_data($data);
				$api->action = "priceperpriceunit/save";
				$api->call_api();
				if (!$api->ok) {
					$msg .= "<br>Error adding priceperpriceunit record for product ".$rs->fields['productname'].' '.$api->rsp->err['code'].': '.$api->rsp->err['msg'];	
				}
				
				// Add beginning balance info
				$data = array(	'itemid' => $npitemid,
								'locationid' => (string) $invcompany->locationid,
								'qty' => $rs->fields['qtyinstock'],
								'cost' => 0,
								'offsetglaccountid' => '',
								'notes' => '- Beginning Inventory Balance From vtiger');
				$api->set_data($data);
				$api->action = "item/item_increase";
				$api->call_api();
				if (!$api->ok) {
					$msg .= "<br>Error setting the beginning inventory balance for product ".$rs->fields['productname'].' '.$api->rsp->err['code'].': '.$api->rsp->err['msg'];	
				}
			} else {
				$msg .= "<br>Error adding product ".$rs->fields['productname'].' '.$api->rsp->err['code'].': '.$api->rsp->err['msg'];
			}
		} else {
			//$msg .= "<br>Error adding account ".$rs->fields['accountname'];	
			// Item has been added to NP already
			$count--;
		}
		$rs->movenext();
	}
	$msg .= "<br>Sent $count Product records to NolaPro<br>";
	if ($count == 0) {
		$msg .= "<i>*Only new products are sent</i>";
	}
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Send Invoices
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function nolapro_send_invoices() {
	global $adb, $np, $msg;
	
	// Get som basic info from np
	$flexfieldid = nolapro_get_flexfield('vtigerinvoiceid');
	if (!$flexfieldid) {
		$msg = "Please activate the vtiger plug-in inside NolaPro";
		return 0;
	}
	$custflexfieldid = nolapro_get_flexfield('vtigeraccountid');
	if (!$custflexfieldid) {
		$msg = "Please activate the vtiger plug-in inside NolaPro";
		return 0;
	}
	$prodflexfieldid = nolapro_get_flexfield('vtigerproductid');
	if (!$prodflexfieldid) {
		$msg = "Please activate the vtiger plug-in inside NolaPro";
		return 0;
	}
	
	// Get company defaults
	$invcompany = nolapro_get_company_defaults("invcompany");
	if (!$invcompany) {
		$msg = "Error retrieving NolaPro inventory defaults.";
		return 0;
	}
	$arcompany = nolapro_get_company_defaults("arcompany");
	if (!$arcompany) {
		$msg = "Error retrieving NolaPro AR defaults.";
		return 0;
	}
	$api = new npapi($np['apikey'], $np['apiuserid'], $np['apicompanyid'], $np['apiurl']);
	
	// Make sure we have entries for units of measure
	$data = array("conditions" => "cancel = '0' ",
				  "fields" => array('id', 'unitname'),
				  "limit" => 6000);
	$api->set_data($data);
	$api->action = "unitname/search";
	$api->call_api();
	$npunits = array();
	if ($api->ok) {
		foreach ($api->rsp->unitname as $cat) {
			$npunits[(string) $cat->unitname] = (string) $cat->id;
		}
	}

	$sql = "select distinct usageunit
			from vtiger_products";
	$rs = $adb->query($sql);
	if (!$rs) {
		die('Error searching vtiger product records.');
	}
	while ($r = $rs->fetchrow()) {
		if (!isset($npunits[$r['usageunit']])) {
			// Add this category
			$api->set_table('unitname');
			$data = array(	"unitname" => $r['usageunit']);
			$api->set_data($data);
			$api->action = "unitname/save";
			$api->call_api();
			if ($api->ok) {
				$npunits[$r['usageunit']] = (string) $api->rsp->unitname['id'];
				file_put_contents('testapi.xml', $api->buffer);
			} else {
				$msg .= $api->errorcode.": ".$api->rsp->err['msg']."<br>";
			}
		}
	}
	
	// Get GL accounts
	$data = array("conditions" => "cancel = '0' and companyid in (0, '$api->companyid') ",
				  "fields" => array('id', 'name', 'description'),
				  "limit" => 6000);
	$api->set_data($data);
	$api->action = "glaccount/search";
	$api->call_api();
	$npgl = array();  // Holds np glaccount IDs
	if ($api->ok) {
		foreach ($api->rsp->glaccount as $cat) {
			$npgl[(string) $cat->name.'-'.(string) $cat->description] = (string) $cat->id;
		}
	}

	// Get taxes
	$data = array("conditions" => "cancel = '0' and gencompanyid in (0, '$api->companyid') ",
				  "fields" => array('id', 'taxname', 'taxrate'),
				  "limit" => 600);
	$api->set_data($data);
	$api->action = "salestax/search";
	$api->call_api();
	$nptax = array();  // Holds np glaccount IDs
	$taxsql = '';
	if ($api->ok) {
		foreach ($api->rsp->salestax as $cat) {
			$nptax[(string) $cat->taxname] = (string) $cat->id;
			$taxsql .= ",'".addslashes((string) $cat->taxname)."'";
		}
	} 

	// Make sure NP has all the taxes vtiger uses
	$sql = "select *
			from vtiger_inventorytaxinfo
			where deleted=0
				and taxlabel not in (''$taxsql)";
	$rs = $adb->query($sql);
	if (!$rs) {
		die('Error searching vtiger tax records.');
	}
	if (!$rs->EOF) {
		// There's a tax record that vtiger has the NP doesn't
		$msg .= "<br>NolaPro does not have all the taxes that vtiger uses. Please make sure NolaPro has the following sales taxes (the sales tax names must match between systems):<br>";
		while ($rtax = $rs->fetchrow()) {
			$msg .= "$rtax[taxlabel] $rtax[percentage]%<br>";
		}
		return 0;
	}
	$vttax = array();  // Used to help match up taxes
	$sql = "select *
			from vtiger_inventorytaxinfo
			where deleted=0";
	$rs = $adb->query($sql);
	if (!$rs) {
		die('Error searching vtiger tax records.');
	}
	while ($rtax = $rs->fetchrow()) {
		$vttax[$rtax['taxname']] = $rtax['taxlabel'];
	}
	
	// Get a list of invoices to check
	$sql = "select *
			from vtiger_invoice i, vtiger_invoiceshipads s, vtiger_account a
			where i.invoiceid = s.invoiceshipaddressid
				and i.accountid = a.accountid";
	$rs = $adb->query($sql);
	
	if (!$rs) {
		die('Error searching vtiger invoice records.');
	}
	
	$count = 0;
	while (!$rs->EOF) {
		$invoiceid = $rs->fields['invoiceid'];
		// See if this invoice is already in there
		// Find NolaPro id for this vtigerinvoiceid
		$data = array("conditions" => "flexfieldid='$flexfieldid' and value='$invoiceid'");
		$api->set_data($data);
		$api->action = "flexvalue/search";
		$api->call_api();
		$npinvoiceid = 0;
		if ($api->ok) {
			$npinvoiceid = (string) $api->rsp->flexvalue->recordid;
		}
		if ($npinvoiceid) {
			// We already have this invoice so move on
			$rs->movenext();
			continue;
		}
		$count++;
		$act = nolapro_send_accounts($rs->fields['accountid'], $custflexfield, $invcompany, $arcompany);
		
		if (!$act['customerid']) {
			$msg .= "Error locating account ID ".$rs->fields['accountid'].' for invoice '.$rs->fields['invoice_no'].'<br>';
			$rs->movenext();
			continue;
		}
		
		// See if the shipto needs modified
		$data = array("conditions" => "cancel = '0' and customerid = '".$act['customerid']."' and address1 = '".addslashes($rs->fields['ship_street'])."' ",
					  "fields" => array('id'),
					  "limit" => 50);
		$api->set_data($data);
		$api->action = "shipto/search";
		$api->call_api();
		if (!$api->ok) {
			if ($api->errorcode == 90001) {
				// Add new shipto for this address
				$api->set_table('shipto');
				$data = array(	"shipname" => $rs->fields['accountname'].' - '.$rs->fields['ship_street'],
								"address1" => $rs->fields['ship_street'],
								"city" => $rs->fields['ship_city'],
								"state" => $rs->fields['ship_state'],
								"zip" => $rs->fields['ship_code'],
								"country" => $rs->fields['ship_country'],
								"customerid" => $act['customerid'],
								"weather_cf" => "F",
								"weather_zip" => $rs->fields['ship_code']);
				$api->set_data($data);
				$api->action = "shipto/save";
				$api->call_api();
				if ($api->errorcode == 90012) {  // Entry exists for this company
					$data['shipname'] = $rs->fields['accountname'].' - '.$rs->fields['ship_street']." ".date("Y-m-d");
					$api->set_table('shipto');
					$api->set_data($data);
					$api->action = "shipto/save";
					$api->call_api();			
				}
				if ($api->ok) {
					$act['shiptoid'] = (string) $api->rsp->shipto['id'];	
				} else {
					$msg .= "<br>Error adding ship-to record for account ".$rs->fields['accountname'].' ('.$api->rsp->err['code'].' '.$api->rsp->err['msg'].')<br>';	
				}
			}
		} else {
			if ((string) $api->rsp->shipto->id) {
				$act['shiptoid'] = (string) $api->rsp->shipto->id;	
			}
		}
		$data = array();
		
		$salesglacctid = 0;
		if (!$npinvoiceid) {
			// Add new invoice
	
			$invoicedata = array("invoicenumber" => $rs->fields['invoice_no'],
								"orderbycompanyid" => $act['customerid'],  	
								"shiptocompanyid" => $act['shiptoid'],		
								"wherefrom" => 2,			// This should be 2 for AR
								"ponumber" => $rs->fields['purchaseorder'],
								"pricelevelid" => (string) $invcompany->default_pricelevelid,
								"inventorylocationid" => (string) $invcompany->locationid,
								"duedate"=>$rs->fields['duedate']?$rs->fields['duedate']:date("Y-m-d"),
								"invoicedate"=>$rs->fields['invoicedate']?$rs->fields['invoicedate']:date("Y-m-d"),
								"discountdate"=>$rs->fields['invoicedate']?$rs->fields['invoicedate']:date("Y-m-d"),
								"shipcost" => $rs->fields['s_h_amount'],
								"invoicetermsid" => (string) $arcompany->default_invoicetermsid,
								//"salesmanid" => 1,
								"sales_categories" => (string) $arcompany->default_default_salescategory_invoice,
								"arglaccountid" => (string) $arcompany->receivables		// The GL account ID where AR will post	
				);
			
			// General Invoice Note
			$notesdata = array(
						array('note' => $rs->fields['subject'])
					);
			
			// Add line item details
			$sql = "select *
					from vtiger_inventoryproductrel r, vtiger_products p
					where r.productid = p.productid
						and id = '".$rs->fields['invoiceid']."'";
			$rsd = $adb->query($sql);
			if (!$rsd) {
				die('Error searching vtiger invoice detail records.');
			}
			$invoicedetaildata = array();
			$detailnotedata = array();
			$linenum = 0;
			$totaltax = array(); // Keeps track of the total tax for each type
			while ($rd = $rsd->fetchrow()) {
				$linenum++;
				$salesglacctid = $npgl[$rd['glacct']];	
				if (!$salesglacctid) {
					$salesglacctid = (string) $invcompany->sales;
				}
				$taxflag = array();
				$taxflagid = array();
				$tcount = 0;
				// Figure out which taxes apply
				foreach ($vttax as $tcol => $tname) {
					if ($rd[$tcol]) {
						$tcount++;
						$taxflag[$tcount] = 1;
						$taxflagid[$tcount] = $nptax[$tname];
						$totaltax[$nptax[$tname]] += number_format(($rd['listprice'] - $rd['discount_amount'] - $rd['listprice']*($rd['discount_percent']/100))*$rd['quantity']*($rd[$tcol]/100),2, '.', '');
					}
				}
				// See if there is a match for this item in NP already
				$params = array("conditions" => "flexfieldid='$prodflexfieldid' and value='".$rd['productid']."'");
		        $api->set_data($params);
				$api->action = "flexvalue/search";
				$api->call_api();
				$np_itemid = 0;
				if ($api->ok) {
					$np_itemid = (string) $api->rsp->flexvalue->recordid;
				}
				$invoicedetaildata[] = array('linenumber' => $linenum, 
											'qty' => $rd['quantity'], 
											'glaccountid' => $salesglacctid, 
											'costglaccountid' => (string) $invcompany->cost, 
											'pricelevelid' => (string) $invcompany->default_pricelevelid, 
											'qtyunitnameid' => $npunits[$rd['usageunit']], 
											'priceunitnameid' => $npunits[$rd['usageunit']], 
											'qtyunitperpriceunit' => (!$rd['qty_per_unit']?1:$rd['qty_per_unit']),
											'description' => $rd['productname'], 
											'priceach' => number_format($rd['listprice'] - $rd['discount_amount'] - ($rd['listprice']*($rd['discount_percent']/100)),2, '.', ''), 
											'orig_priceach' => $rd['listprice'],
											'discount_amount' => $rd['discount_amount'],
											'discount_percent' => $rd['discount_percent'],
											'costeach' =>'', 
											'itemid' => $np_itemid,
											'taxflag' => $taxflag[1], 
											'taxflagid' => $taxflagid[1],
											'taxflag2' => $taxflag[2], 
											'taxflag2id' => $taxflagid[2],
											'taxflag3' => $taxflag[3], 
											'taxflag3id' => $taxflagid[3]);		
				
				// Detail Invoice Note
				$detailnotedata[] = array('linenumber' => $linenum, 'note' => $rd['comment']);
			}
			// Invoice Taxes
			// taxid links with the salestax table
			// taxamount is the total tax for this invoice for this tax type
			$taxdata = array();
			foreach ($totaltax as $taxid => $taxamt) {
				$taxdata[] = array('taxid' => $taxid, 'taxamount' => $taxamt) ;
			}
			
			$api->set_table('arinvoice');
			$api->set_data($invoicedata);
			$api->set_table('arinvoicedetail');
			$api->set_data($invoicedetaildata);
			$api->set_table('arinvoicenotes');
			$api->set_data($notesdata);
			$api->set_table('arinvoicedetailnotes');
			$api->set_data($detailnotesdata);
			$api->set_table('arinvoicetaxdetail');
			$api->set_data($taxdata);
			
			$api->action = "arinvoice/save";
			$api->call_api();
			$addflexfield = 0;
			if ($api->ok) {
				$npinvoiceid = (string) $api->rsp->arinvoice['id'];
				file_put_contents('testerror.xml', $api->buffer);
				// Add a record to tie vtiger id to nolapro id
				$api->set_table('flexvalue');
				$data = array(	"flexfieldid" => $flexfieldid,
								"recordid" => $npinvoiceid,
								"value" => $invoiceid);
				$api->set_data($data);
				$api->action = "flexvalue/save";
				$api->call_api();

			} else {
				$msg .= "<br>Error adding invoice ".$rs->fields['invoice_no'].' '.$api->rsp->err['code'].': '.$api->rsp->err['msg'];
				$count--;
			}
		} else {
			//$msg .= "<br>Error adding account ".$rs->fields['accountname'];	
			// Item has been added to NP already
			$count--;
		}
		$rs->movenext();
	}
	$msg .= "<br>Sent $count Invoice records to NolaPro<br>";
	if ($count == 0) {
		$msg .= "<i>*Only new invoices are sent</i>";
	}
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Get NP Company Defaults
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function nolapro_get_company_defaults($name="arcompany") {
	global $np;
	$api = new npapi($np['apikey'], $np['apiuserid'], $np['apicompanyid'], $np['apiurl']);
	// Set some useful defaults
	// Can be arcompany, apcompany, invcompany; tables where NolaPro default values are stored
	$api->action = "$name/search/id/$api->companyid";
	$api->call_api();
	if ($api->ok) {
		$defaultset = $api->rsp->$name;
		return $defaultset;
	} else {
		return 0;	
	}
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Get flexfield ID - Gets the flexfield that stores the vtiger-nolapro tie
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function nolapro_get_flexfield($internalname="9999999") {
	global $np;
	$api = new npapi($np['apikey'], $np['apiuserid'], $np['apicompanyid'], $np['apiurl']);
	$api->action = "flexfield/search/internalname/$internalname";
	$api->call_api();
	if ($api->ok) {
		return (string) $api->rsp->flexfield['id'];
	} else {
		return 0;
	}
}