<?php

/**
 * Schema object for: CreditMemoModRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_CreditMemoModRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = '';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'CreditMemoMod TxnID' => 'IDTYPE',
  'CreditMemoMod EditSequence' => 'STRTYPE',
  'CreditMemoMod CustomerRef ListID' => 'IDTYPE',
  'CreditMemoMod CustomerRef FullName' => 'STRTYPE',
  'CreditMemoMod ClassRef ListID' => 'IDTYPE',
  'CreditMemoMod ClassRef FullName' => 'STRTYPE',
  'CreditMemoMod ARAccountRef ListID' => 'IDTYPE',
  'CreditMemoMod ARAccountRef FullName' => 'STRTYPE',
  'CreditMemoMod TemplateRef ListID' => 'IDTYPE',
  'CreditMemoMod TemplateRef FullName' => 'STRTYPE',
  'CreditMemoMod TxnDate' => 'DATETYPE',
  'CreditMemoMod RefNumber' => 'STRTYPE',
  'CreditMemoMod BillAddress Addr1' => 'STRTYPE',
  'CreditMemoMod BillAddress Addr2' => 'STRTYPE',
  'CreditMemoMod BillAddress Addr3' => 'STRTYPE',
  'CreditMemoMod BillAddress Addr4' => 'STRTYPE',
  'CreditMemoMod BillAddress Addr5' => 'STRTYPE',
  'CreditMemoMod BillAddress City' => 'STRTYPE',
  'CreditMemoMod BillAddress State' => 'STRTYPE',
  'CreditMemoMod BillAddress PostalCode' => 'STRTYPE',
  'CreditMemoMod BillAddress Country' => 'STRTYPE',
  'CreditMemoMod BillAddress Note' => 'STRTYPE',
  'CreditMemoMod ShipAddress Addr1' => 'STRTYPE',
  'CreditMemoMod ShipAddress Addr2' => 'STRTYPE',
  'CreditMemoMod ShipAddress Addr3' => 'STRTYPE',
  'CreditMemoMod ShipAddress Addr4' => 'STRTYPE',
  'CreditMemoMod ShipAddress Addr5' => 'STRTYPE',
  'CreditMemoMod ShipAddress City' => 'STRTYPE',
  'CreditMemoMod ShipAddress State' => 'STRTYPE',
  'CreditMemoMod ShipAddress PostalCode' => 'STRTYPE',
  'CreditMemoMod ShipAddress Country' => 'STRTYPE',
  'CreditMemoMod ShipAddress Note' => 'STRTYPE',
  'CreditMemoMod IsPending' => 'BOOLTYPE',
  'CreditMemoMod PONumber' => 'STRTYPE',
  'CreditMemoMod TermsRef ListID' => 'IDTYPE',
  'CreditMemoMod TermsRef FullName' => 'STRTYPE',
  'CreditMemoMod DueDate' => 'DATETYPE',
  'CreditMemoMod SalesRepRef ListID' => 'IDTYPE',
  'CreditMemoMod SalesRepRef FullName' => 'STRTYPE',
  'CreditMemoMod FOB' => 'STRTYPE',
  'CreditMemoMod ShipDate' => 'DATETYPE',
  'CreditMemoMod ShipMethodRef ListID' => 'IDTYPE',
  'CreditMemoMod ShipMethodRef FullName' => 'STRTYPE',
  'CreditMemoMod ItemSalesTaxRef ListID' => 'IDTYPE',
  'CreditMemoMod ItemSalesTaxRef FullName' => 'STRTYPE',
  'CreditMemoMod Memo' => 'STRTYPE',
  'CreditMemoMod CustomerMsgRef ListID' => 'IDTYPE',
  'CreditMemoMod CustomerMsgRef FullName' => 'STRTYPE',
  'CreditMemoMod IsToBePrinted' => 'BOOLTYPE',
  'CreditMemoMod IsToBeEmailed' => 'BOOLTYPE',
  'CreditMemoMod IsTaxIncluded' => 'BOOLTYPE',
  'CreditMemoMod CustomerSalesTaxCodeRef ListID' => 'IDTYPE',
  'CreditMemoMod CustomerSalesTaxCodeRef FullName' => 'STRTYPE',
  'CreditMemoMod Other' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod TxnLineID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineMod ItemRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineMod ItemRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod Desc' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod Quantity' => 'QUANTYPE',
  'CreditMemoMod CreditMemoLineMod UnitOfMeasure' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod Rate' => 'PRICETYPE',
  'CreditMemoMod CreditMemoLineMod RatePercent' => 'PERCENTTYPE',
  'CreditMemoMod CreditMemoLineMod PriceLevelRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineMod PriceLevelRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod ClassRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineMod ClassRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod Amount' => 'AMTTYPE',
  'CreditMemoMod CreditMemoLineMod ServiceDate' => 'DATETYPE',
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod Other1' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineMod Other2' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod TxnLineID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod Quantity' => 'QUANTYPE',
  'CreditMemoMod CreditMemoLineGroupMod UnitOfMeasure' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod TxnLineID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Desc' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Quantity' => 'QUANTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod UnitOfMeasure' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Rate' => 'PRICETYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod RatePercent' => 'PERCENTTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Amount' => 'AMTTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ServiceDate' => 'DATETYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other1' => 'STRTYPE',
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other2' => 'STRTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'CreditMemoMod TxnID' => 0,
  'CreditMemoMod EditSequence' => 16,
  'CreditMemoMod CustomerRef ListID' => 0,
  'CreditMemoMod CustomerRef FullName' => 209,
  'CreditMemoMod ClassRef ListID' => 0,
  'CreditMemoMod ClassRef FullName' => 209,
  'CreditMemoMod ARAccountRef ListID' => 0,
  'CreditMemoMod ARAccountRef FullName' => 209,
  'CreditMemoMod TemplateRef ListID' => 0,
  'CreditMemoMod TemplateRef FullName' => 209,
  'CreditMemoMod TxnDate' => 0,
  'CreditMemoMod RefNumber' => 11,
  'CreditMemoMod BillAddress Addr1' => 41,
  'CreditMemoMod BillAddress Addr2' => 41,
  'CreditMemoMod BillAddress Addr3' => 41,
  'CreditMemoMod BillAddress Addr4' => 41,
  'CreditMemoMod BillAddress Addr5' => 41,
  'CreditMemoMod BillAddress City' => 31,
  'CreditMemoMod BillAddress State' => 21,
  'CreditMemoMod BillAddress PostalCode' => 13,
  'CreditMemoMod BillAddress Country' => 31,
  'CreditMemoMod BillAddress Note' => 41,
  'CreditMemoMod ShipAddress Addr1' => 41,
  'CreditMemoMod ShipAddress Addr2' => 41,
  'CreditMemoMod ShipAddress Addr3' => 41,
  'CreditMemoMod ShipAddress Addr4' => 41,
  'CreditMemoMod ShipAddress Addr5' => 41,
  'CreditMemoMod ShipAddress City' => 31,
  'CreditMemoMod ShipAddress State' => 21,
  'CreditMemoMod ShipAddress PostalCode' => 13,
  'CreditMemoMod ShipAddress Country' => 31,
  'CreditMemoMod ShipAddress Note' => 41,
  'CreditMemoMod IsPending' => 0,
  'CreditMemoMod PONumber' => 25,
  'CreditMemoMod TermsRef ListID' => 0,
  'CreditMemoMod TermsRef FullName' => 209,
  'CreditMemoMod DueDate' => 0,
  'CreditMemoMod SalesRepRef ListID' => 0,
  'CreditMemoMod SalesRepRef FullName' => 209,
  'CreditMemoMod FOB' => 13,
  'CreditMemoMod ShipDate' => 0,
  'CreditMemoMod ShipMethodRef ListID' => 0,
  'CreditMemoMod ShipMethodRef FullName' => 209,
  'CreditMemoMod ItemSalesTaxRef ListID' => 0,
  'CreditMemoMod ItemSalesTaxRef FullName' => 209,
  'CreditMemoMod Memo' => 4095,
  'CreditMemoMod CustomerMsgRef ListID' => 0,
  'CreditMemoMod CustomerMsgRef FullName' => 209,
  'CreditMemoMod IsToBePrinted' => 0,
  'CreditMemoMod IsToBeEmailed' => 0,
  'CreditMemoMod IsTaxIncluded' => 0,
  'CreditMemoMod CustomerSalesTaxCodeRef ListID' => 0,
  'CreditMemoMod CustomerSalesTaxCodeRef FullName' => 209,
  'CreditMemoMod Other' => 29,
  'CreditMemoMod CreditMemoLineMod TxnLineID' => 0,
  'CreditMemoMod CreditMemoLineMod ItemRef ListID' => 0,
  'CreditMemoMod CreditMemoLineMod ItemRef FullName' => 209,
  'CreditMemoMod CreditMemoLineMod Desc' => 4095,
  'CreditMemoMod CreditMemoLineMod Quantity' => 0,
  'CreditMemoMod CreditMemoLineMod UnitOfMeasure' => 31,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef ListID' => 0,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef FullName' => 209,
  'CreditMemoMod CreditMemoLineMod Rate' => 0,
  'CreditMemoMod CreditMemoLineMod RatePercent' => 0,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef ListID' => 0,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef FullName' => 209,
  'CreditMemoMod CreditMemoLineMod ClassRef ListID' => 0,
  'CreditMemoMod CreditMemoLineMod ClassRef FullName' => 209,
  'CreditMemoMod CreditMemoLineMod Amount' => 0,
  'CreditMemoMod CreditMemoLineMod ServiceDate' => 0,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef ListID' => 0,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef FullName' => 209,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef ListID' => 0,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef FullName' => 209,
  'CreditMemoMod CreditMemoLineMod Other1' => 29,
  'CreditMemoMod CreditMemoLineMod Other2' => 29,
  'CreditMemoMod CreditMemoLineGroupMod TxnLineID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod Quantity' => 0,
  'CreditMemoMod CreditMemoLineGroupMod UnitOfMeasure' => 31,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod TxnLineID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Desc' => 4095,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Quantity' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod UnitOfMeasure' => 31,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Rate' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod RatePercent' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Amount' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ServiceDate' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef ListID' => 0,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef FullName' => 209,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other1' => 29,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other2' => 29,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'CreditMemoMod TxnID' => false,
  'CreditMemoMod EditSequence' => false,
  'CreditMemoMod CustomerRef ListID' => true,
  'CreditMemoMod CustomerRef FullName' => true,
  'CreditMemoMod ClassRef ListID' => true,
  'CreditMemoMod ClassRef FullName' => true,
  'CreditMemoMod ARAccountRef ListID' => true,
  'CreditMemoMod ARAccountRef FullName' => true,
  'CreditMemoMod TemplateRef ListID' => true,
  'CreditMemoMod TemplateRef FullName' => true,
  'CreditMemoMod TxnDate' => true,
  'CreditMemoMod RefNumber' => true,
  'CreditMemoMod BillAddress Addr1' => true,
  'CreditMemoMod BillAddress Addr2' => true,
  'CreditMemoMod BillAddress Addr3' => true,
  'CreditMemoMod BillAddress Addr4' => true,
  'CreditMemoMod BillAddress Addr5' => true,
  'CreditMemoMod BillAddress City' => true,
  'CreditMemoMod BillAddress State' => true,
  'CreditMemoMod BillAddress PostalCode' => true,
  'CreditMemoMod BillAddress Country' => true,
  'CreditMemoMod BillAddress Note' => true,
  'CreditMemoMod ShipAddress Addr1' => true,
  'CreditMemoMod ShipAddress Addr2' => true,
  'CreditMemoMod ShipAddress Addr3' => true,
  'CreditMemoMod ShipAddress Addr4' => true,
  'CreditMemoMod ShipAddress Addr5' => true,
  'CreditMemoMod ShipAddress City' => true,
  'CreditMemoMod ShipAddress State' => true,
  'CreditMemoMod ShipAddress PostalCode' => true,
  'CreditMemoMod ShipAddress Country' => true,
  'CreditMemoMod ShipAddress Note' => true,
  'CreditMemoMod IsPending' => true,
  'CreditMemoMod PONumber' => true,
  'CreditMemoMod TermsRef ListID' => true,
  'CreditMemoMod TermsRef FullName' => true,
  'CreditMemoMod DueDate' => true,
  'CreditMemoMod SalesRepRef ListID' => true,
  'CreditMemoMod SalesRepRef FullName' => true,
  'CreditMemoMod FOB' => true,
  'CreditMemoMod ShipDate' => true,
  'CreditMemoMod ShipMethodRef ListID' => true,
  'CreditMemoMod ShipMethodRef FullName' => true,
  'CreditMemoMod ItemSalesTaxRef ListID' => true,
  'CreditMemoMod ItemSalesTaxRef FullName' => true,
  'CreditMemoMod Memo' => true,
  'CreditMemoMod CustomerMsgRef ListID' => true,
  'CreditMemoMod CustomerMsgRef FullName' => true,
  'CreditMemoMod IsToBePrinted' => true,
  'CreditMemoMod IsToBeEmailed' => true,
  'CreditMemoMod IsTaxIncluded' => true,
  'CreditMemoMod CustomerSalesTaxCodeRef ListID' => true,
  'CreditMemoMod CustomerSalesTaxCodeRef FullName' => true,
  'CreditMemoMod Other' => true,
  'CreditMemoMod CreditMemoLineMod TxnLineID' => false,
  'CreditMemoMod CreditMemoLineMod ItemRef ListID' => true,
  'CreditMemoMod CreditMemoLineMod ItemRef FullName' => true,
  'CreditMemoMod CreditMemoLineMod Desc' => true,
  'CreditMemoMod CreditMemoLineMod Quantity' => true,
  'CreditMemoMod CreditMemoLineMod UnitOfMeasure' => true,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef ListID' => true,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef FullName' => true,
  'CreditMemoMod CreditMemoLineMod Rate' => false,
  'CreditMemoMod CreditMemoLineMod RatePercent' => false,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef ListID' => true,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef FullName' => true,
  'CreditMemoMod CreditMemoLineMod ClassRef ListID' => true,
  'CreditMemoMod CreditMemoLineMod ClassRef FullName' => true,
  'CreditMemoMod CreditMemoLineMod Amount' => true,
  'CreditMemoMod CreditMemoLineMod ServiceDate' => true,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef ListID' => true,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef FullName' => true,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef ListID' => true,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef FullName' => true,
  'CreditMemoMod CreditMemoLineMod Other1' => true,
  'CreditMemoMod CreditMemoLineMod Other2' => true,
  'CreditMemoMod CreditMemoLineGroupMod TxnLineID' => false,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod Quantity' => true,
  'CreditMemoMod CreditMemoLineGroupMod UnitOfMeasure' => true,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod TxnLineID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Desc' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Quantity' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod UnitOfMeasure' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Rate' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod RatePercent' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Amount' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ServiceDate' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef ListID' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef FullName' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other1' => true,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other2' => true,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'CreditMemoMod TxnID' => 999.99,
  'CreditMemoMod EditSequence' => 999.99,
  'CreditMemoMod CustomerRef ListID' => 999.99,
  'CreditMemoMod CustomerRef FullName' => 999.99,
  'CreditMemoMod ClassRef ListID' => 999.99,
  'CreditMemoMod ClassRef FullName' => 999.99,
  'CreditMemoMod ARAccountRef ListID' => 999.99,
  'CreditMemoMod ARAccountRef FullName' => 999.99,
  'CreditMemoMod TemplateRef ListID' => 999.99,
  'CreditMemoMod TemplateRef FullName' => 999.99,
  'CreditMemoMod TxnDate' => 999.99,
  'CreditMemoMod RefNumber' => 999.99,
  'CreditMemoMod BillAddress Addr1' => 999.99,
  'CreditMemoMod BillAddress Addr2' => 999.99,
  'CreditMemoMod BillAddress Addr3' => 999.99,
  'CreditMemoMod BillAddress Addr4' => 2,
  'CreditMemoMod BillAddress Addr5' => 6,
  'CreditMemoMod BillAddress City' => 999.99,
  'CreditMemoMod BillAddress State' => 999.99,
  'CreditMemoMod BillAddress PostalCode' => 999.99,
  'CreditMemoMod BillAddress Country' => 999.99,
  'CreditMemoMod BillAddress Note' => 6,
  'CreditMemoMod ShipAddress Addr1' => 999.99,
  'CreditMemoMod ShipAddress Addr2' => 999.99,
  'CreditMemoMod ShipAddress Addr3' => 999.99,
  'CreditMemoMod ShipAddress Addr4' => 2,
  'CreditMemoMod ShipAddress Addr5' => 6,
  'CreditMemoMod ShipAddress City' => 999.99,
  'CreditMemoMod ShipAddress State' => 999.99,
  'CreditMemoMod ShipAddress PostalCode' => 999.99,
  'CreditMemoMod ShipAddress Country' => 999.99,
  'CreditMemoMod ShipAddress Note' => 6,
  'CreditMemoMod IsPending' => 999.99,
  'CreditMemoMod PONumber' => 999.99,
  'CreditMemoMod TermsRef ListID' => 999.99,
  'CreditMemoMod TermsRef FullName' => 999.99,
  'CreditMemoMod DueDate' => 999.99,
  'CreditMemoMod SalesRepRef ListID' => 999.99,
  'CreditMemoMod SalesRepRef FullName' => 999.99,
  'CreditMemoMod FOB' => 999.99,
  'CreditMemoMod ShipDate' => 999.99,
  'CreditMemoMod ShipMethodRef ListID' => 999.99,
  'CreditMemoMod ShipMethodRef FullName' => 999.99,
  'CreditMemoMod ItemSalesTaxRef ListID' => 999.99,
  'CreditMemoMod ItemSalesTaxRef FullName' => 999.99,
  'CreditMemoMod Memo' => 999.99,
  'CreditMemoMod CustomerMsgRef ListID' => 999.99,
  'CreditMemoMod CustomerMsgRef FullName' => 999.99,
  'CreditMemoMod IsToBePrinted' => 999.99,
  'CreditMemoMod IsToBeEmailed' => 6,
  'CreditMemoMod IsTaxIncluded' => 6,
  'CreditMemoMod CustomerSalesTaxCodeRef ListID' => 999.99,
  'CreditMemoMod CustomerSalesTaxCodeRef FullName' => 999.99,
  'CreditMemoMod Other' => 6,
  'CreditMemoMod CreditMemoLineMod TxnLineID' => 999.99,
  'CreditMemoMod CreditMemoLineMod ItemRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineMod ItemRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineMod Desc' => 999.99,
  'CreditMemoMod CreditMemoLineMod Quantity' => 999.99,
  'CreditMemoMod CreditMemoLineMod UnitOfMeasure' => 7,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineMod Rate' => 999.99,
  'CreditMemoMod CreditMemoLineMod RatePercent' => 999.99,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineMod ClassRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineMod ClassRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineMod Amount' => 999.99,
  'CreditMemoMod CreditMemoLineMod ServiceDate' => 999.99,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineMod Other1' => 6,
  'CreditMemoMod CreditMemoLineMod Other2' => 6,
  'CreditMemoMod CreditMemoLineGroupMod TxnLineID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod Quantity' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod UnitOfMeasure' => 7,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod TxnLineID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Desc' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Quantity' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod UnitOfMeasure' => 7,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Rate' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod RatePercent' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Amount' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ServiceDate' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef ListID' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef FullName' => 999.99,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other1' => 6,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other2' => 6,
  'IncludeRetElement' => 4,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'CreditMemoMod TxnID' => false,
  'CreditMemoMod EditSequence' => false,
  'CreditMemoMod CustomerRef ListID' => false,
  'CreditMemoMod CustomerRef FullName' => false,
  'CreditMemoMod ClassRef ListID' => false,
  'CreditMemoMod ClassRef FullName' => false,
  'CreditMemoMod ARAccountRef ListID' => false,
  'CreditMemoMod ARAccountRef FullName' => false,
  'CreditMemoMod TemplateRef ListID' => false,
  'CreditMemoMod TemplateRef FullName' => false,
  'CreditMemoMod TxnDate' => false,
  'CreditMemoMod RefNumber' => false,
  'CreditMemoMod BillAddress Addr1' => false,
  'CreditMemoMod BillAddress Addr2' => false,
  'CreditMemoMod BillAddress Addr3' => false,
  'CreditMemoMod BillAddress Addr4' => false,
  'CreditMemoMod BillAddress Addr5' => false,
  'CreditMemoMod BillAddress City' => false,
  'CreditMemoMod BillAddress State' => false,
  'CreditMemoMod BillAddress PostalCode' => false,
  'CreditMemoMod BillAddress Country' => false,
  'CreditMemoMod BillAddress Note' => false,
  'CreditMemoMod ShipAddress Addr1' => false,
  'CreditMemoMod ShipAddress Addr2' => false,
  'CreditMemoMod ShipAddress Addr3' => false,
  'CreditMemoMod ShipAddress Addr4' => false,
  'CreditMemoMod ShipAddress Addr5' => false,
  'CreditMemoMod ShipAddress City' => false,
  'CreditMemoMod ShipAddress State' => false,
  'CreditMemoMod ShipAddress PostalCode' => false,
  'CreditMemoMod ShipAddress Country' => false,
  'CreditMemoMod ShipAddress Note' => false,
  'CreditMemoMod IsPending' => false,
  'CreditMemoMod PONumber' => false,
  'CreditMemoMod TermsRef ListID' => false,
  'CreditMemoMod TermsRef FullName' => false,
  'CreditMemoMod DueDate' => false,
  'CreditMemoMod SalesRepRef ListID' => false,
  'CreditMemoMod SalesRepRef FullName' => false,
  'CreditMemoMod FOB' => false,
  'CreditMemoMod ShipDate' => false,
  'CreditMemoMod ShipMethodRef ListID' => false,
  'CreditMemoMod ShipMethodRef FullName' => false,
  'CreditMemoMod ItemSalesTaxRef ListID' => false,
  'CreditMemoMod ItemSalesTaxRef FullName' => false,
  'CreditMemoMod Memo' => false,
  'CreditMemoMod CustomerMsgRef ListID' => false,
  'CreditMemoMod CustomerMsgRef FullName' => false,
  'CreditMemoMod IsToBePrinted' => false,
  'CreditMemoMod IsToBeEmailed' => false,
  'CreditMemoMod IsTaxIncluded' => false,
  'CreditMemoMod CustomerSalesTaxCodeRef ListID' => false,
  'CreditMemoMod CustomerSalesTaxCodeRef FullName' => false,
  'CreditMemoMod Other' => false,
  'CreditMemoMod CreditMemoLineMod TxnLineID' => false,
  'CreditMemoMod CreditMemoLineMod ItemRef ListID' => false,
  'CreditMemoMod CreditMemoLineMod ItemRef FullName' => false,
  'CreditMemoMod CreditMemoLineMod Desc' => false,
  'CreditMemoMod CreditMemoLineMod Quantity' => false,
  'CreditMemoMod CreditMemoLineMod UnitOfMeasure' => false,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef ListID' => false,
  'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef FullName' => false,
  'CreditMemoMod CreditMemoLineMod Rate' => false,
  'CreditMemoMod CreditMemoLineMod RatePercent' => false,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef ListID' => false,
  'CreditMemoMod CreditMemoLineMod PriceLevelRef FullName' => false,
  'CreditMemoMod CreditMemoLineMod ClassRef ListID' => false,
  'CreditMemoMod CreditMemoLineMod ClassRef FullName' => false,
  'CreditMemoMod CreditMemoLineMod Amount' => false,
  'CreditMemoMod CreditMemoLineMod ServiceDate' => false,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef ListID' => false,
  'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef FullName' => false,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef ListID' => false,
  'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef FullName' => false,
  'CreditMemoMod CreditMemoLineMod Other1' => false,
  'CreditMemoMod CreditMemoLineMod Other2' => false,
  'CreditMemoMod CreditMemoLineGroupMod TxnLineID' => false,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod Quantity' => false,
  'CreditMemoMod CreditMemoLineGroupMod UnitOfMeasure' => false,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod TxnLineID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Desc' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Quantity' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod UnitOfMeasure' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Rate' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod RatePercent' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Amount' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ServiceDate' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef ListID' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef FullName' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other1' => false,
  'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other2' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'CreditMemoMod TxnID',
  1 => 'CreditMemoMod EditSequence',
  2 => 'CreditMemoMod CustomerRef ListID',
  3 => 'CreditMemoMod CustomerRef FullName',
  4 => 'CreditMemoMod ClassRef ListID',
  5 => 'CreditMemoMod ClassRef FullName',
  6 => 'CreditMemoMod ARAccountRef ListID',
  7 => 'CreditMemoMod ARAccountRef FullName',
  8 => 'CreditMemoMod TemplateRef ListID',
  9 => 'CreditMemoMod TemplateRef FullName',
  10 => 'CreditMemoMod TxnDate',
  11 => 'CreditMemoMod RefNumber',
  12 => 'CreditMemoMod BillAddress Addr1',
  13 => 'CreditMemoMod BillAddress Addr2',
  14 => 'CreditMemoMod BillAddress Addr3',
  15 => 'CreditMemoMod BillAddress Addr4',
  16 => 'CreditMemoMod BillAddress Addr5',
  17 => 'CreditMemoMod BillAddress City',
  18 => 'CreditMemoMod BillAddress State',
  19 => 'CreditMemoMod BillAddress PostalCode',
  20 => 'CreditMemoMod BillAddress Country',
  21 => 'CreditMemoMod BillAddress Note',
  22 => 'CreditMemoMod ShipAddress Addr1',
  23 => 'CreditMemoMod ShipAddress Addr2',
  24 => 'CreditMemoMod ShipAddress Addr3',
  25 => 'CreditMemoMod ShipAddress Addr4',
  26 => 'CreditMemoMod ShipAddress Addr5',
  27 => 'CreditMemoMod ShipAddress City',
  28 => 'CreditMemoMod ShipAddress State',
  29 => 'CreditMemoMod ShipAddress PostalCode',
  30 => 'CreditMemoMod ShipAddress Country',
  31 => 'CreditMemoMod ShipAddress Note',
  32 => 'CreditMemoMod IsPending',
  33 => 'CreditMemoMod PONumber',
  34 => 'CreditMemoMod TermsRef ListID',
  35 => 'CreditMemoMod TermsRef FullName',
  36 => 'CreditMemoMod DueDate',
  37 => 'CreditMemoMod SalesRepRef ListID',
  38 => 'CreditMemoMod SalesRepRef FullName',
  39 => 'CreditMemoMod FOB',
  40 => 'CreditMemoMod ShipDate',
  41 => 'CreditMemoMod ShipMethodRef ListID',
  42 => 'CreditMemoMod ShipMethodRef FullName',
  43 => 'CreditMemoMod ItemSalesTaxRef ListID',
  44 => 'CreditMemoMod ItemSalesTaxRef FullName',
  45 => 'CreditMemoMod Memo',
  46 => 'CreditMemoMod CustomerMsgRef ListID',
  47 => 'CreditMemoMod CustomerMsgRef FullName',
  48 => 'CreditMemoMod IsToBePrinted',
  49 => 'CreditMemoMod IsToBeEmailed',
  50 => 'CreditMemoMod IsTaxIncluded',
  51 => 'CreditMemoMod CustomerSalesTaxCodeRef ListID',
  52 => 'CreditMemoMod CustomerSalesTaxCodeRef FullName',
  53 => 'CreditMemoMod Other',
  54 => 'CreditMemoMod CreditMemoLineMod TxnLineID',
  55 => 'CreditMemoMod CreditMemoLineMod ItemRef ListID',
  56 => 'CreditMemoMod CreditMemoLineMod ItemRef FullName',
  57 => 'CreditMemoMod CreditMemoLineMod Desc',
  58 => 'CreditMemoMod CreditMemoLineMod Quantity',
  59 => 'CreditMemoMod CreditMemoLineMod UnitOfMeasure',
  60 => 'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef ListID',
  61 => 'CreditMemoMod CreditMemoLineMod OverrideUOMSetRef FullName',
  62 => 'CreditMemoMod CreditMemoLineMod Rate',
  63 => 'CreditMemoMod CreditMemoLineMod RatePercent',
  64 => 'CreditMemoMod CreditMemoLineMod PriceLevelRef ListID',
  65 => 'CreditMemoMod CreditMemoLineMod PriceLevelRef FullName',
  66 => 'CreditMemoMod CreditMemoLineMod ClassRef ListID',
  67 => 'CreditMemoMod CreditMemoLineMod ClassRef FullName',
  68 => 'CreditMemoMod CreditMemoLineMod Amount',
  69 => 'CreditMemoMod CreditMemoLineMod ServiceDate',
  70 => 'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef ListID',
  71 => 'CreditMemoMod CreditMemoLineMod SalesTaxCodeRef FullName',
  72 => 'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef ListID',
  73 => 'CreditMemoMod CreditMemoLineMod OverrideItemAccountRef FullName',
  74 => 'CreditMemoMod CreditMemoLineMod Other1',
  75 => 'CreditMemoMod CreditMemoLineMod Other2',
  76 => 'CreditMemoMod CreditMemoLineGroupMod TxnLineID',
  77 => 'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef ListID',
  78 => 'CreditMemoMod CreditMemoLineGroupMod ItemGroupRef FullName',
  79 => 'CreditMemoMod CreditMemoLineGroupMod Quantity',
  80 => 'CreditMemoMod CreditMemoLineGroupMod UnitOfMeasure',
  81 => 'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef ListID',
  82 => 'CreditMemoMod CreditMemoLineGroupMod OverrideUOMSetRef FullName',
  83 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod TxnLineID',
  84 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef ListID',
  85 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ItemRef FullName',
  86 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Desc',
  87 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Quantity',
  88 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod UnitOfMeasure',
  89 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef ListID',
  90 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideUOMSetRef FullName',
  91 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Rate',
  92 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod RatePercent',
  93 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef ListID',
  94 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod PriceLevelRef FullName',
  95 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef ListID',
  96 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ClassRef FullName',
  97 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Amount',
  98 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod ServiceDate',
  99 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef ListID',
  100 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod SalesTaxCodeRef FullName',
  101 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef ListID',
  102 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod OverrideItemAccountRef FullName',
  103 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other1',
  104 => 'CreditMemoMod CreditMemoLineGroupMod CreditMemoLineMod Other2',
  105 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>