<?php

    //Version Checks
    {
        define('MIN_PHP_VERSION',      '5.4.0');
        define('MIN_WIN_PHP_VERSION',  '5.4.0');
        define('MIN_IONCUBE_IVERSION', '40500');
        function __is_windows_desktop_install(){
            return stristr(php_uname('s'), 'Windows') && file_exists(dirname(__FILE__).'/../install/my.default.ini');
        }
        function __index_show_update_msg($msg = ''){
            // The Windows user needs to download our backend update
            ?>
            <!DOCTYPE html>
            <html>
                <head>
                    <title>Backend Update Required</title>
                    <link rel="stylesheet" type="text/css" href="css/layout.css">
                </head>
                <body style="padding: 12px;">
                    <?= $msg ? "<h2>$msg</h2>" : '' ?>
                    <?php 
                        if(__is_windows_desktop_install()){
                    ?>
                        <h2>Before proceeding you will need to run a special update for the backend of NolaPro (Apache & PHP).</h2>
                        <h2><a href="http://noguska.com/NolaPro-Backend-Update.exe">Click here to download the update.</a></h2>
                        <h2>Refresh this page after completing the update.</h2>
                    <?php 
                        }
                    ?>
                </body>
            </html>
            <?php
            die();
        }
        function __min_server_software_version_check(){
            //Skip checks if Cloud-Hosted or is Dev
            $hosted = in_array($_SERVER['SERVER_ADDR'], array('192.241.141.138'/*AP-NP1*/, '67.205.154.211' /*AP-PS1*/, '8.45.128.27' /*NP1*/, '8.45.128.28' /*PS*/));
            $dev    = substr($_SERVER['SERVER_NAME'], -11) == 'noguska.com';
            if($hosted || $dev) return;
            
            //Define Version Information
            if (!defined('PHP_VERSION_ID')) {
                $version = explode('.', PHP_VERSION);
                define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
            }
            $min_version = explode('.', MIN_PHP_VERSION);
            $min_version = ($min_version[0] * 10000 + $min_version[1] * 100 + $min_version[2]);
            $min_win_version = explode('.', MIN_WIN_PHP_VERSION);
            $min_win_version = ($min_win_version[0] * 10000 + $min_win_version[1] * 100 + $min_win_version[2]);
            $ioncube_loader_iversion = function_exists('ioncube_loader_iversion') ? ioncube_loader_iversion() : 0;
            
            //Check: ionCube Loader exists
            if(!extension_loaded('ionCube Loader'))
                __index_show_update_msg("Missing IonCube Loader!");
            
            //Check: Windows-PHP Min Version
            if (__is_windows_desktop_install() && PHP_VERSION_ID < $min_win_version)
                __index_show_update_msg();
            
            //Check: PHP Min Version
            if (PHP_VERSION_ID < $min_version)
                __index_show_update_msg('This software requires PHP '.MIN_PHP_VERSION.' or better. (Running PHP v'.PHP_VERSION.')');
            
            //Check: ionCube Min Version
            if(intval($ioncube_loader_iversion) < MIN_IONCUBE_IVERSION)
                __index_show_update_msg('You must <a target="_blank" href="http://www.ioncube.com/loaders.php">update your installation of ionCube</a> before this software can run.');
        }
        __min_server_software_version_check();
    }
    
    if (file_exists('install.php')) {
        include('install.php');
        die();
    }

    require_once(dirname(__FILE__)."/includes/classes/nptable.php");
    require_once(dirname(__FILE__)."/includes/classes/company_defaults.php");
    require_once(dirname(__FILE__)."/includes/classes/company.php");
    require_once(dirname(__FILE__)."/includes/classes/apcompany.php");
    require_once(dirname(__FILE__)."/includes/classes/arcompany.php");
    require_once(dirname(__FILE__)."/includes/classes/invcompany.php");
    require_once(dirname(__FILE__)."/includes/classes/prcompany.php");
    require_once(dirname(__FILE__)."/includes/functions.php");

	@session_start();
	if(@$_REQUEST['logout'] == 1){
		ini_set('display_errors',0);
		redirect('indexmain.php?logout=1'.(@$_REQUEST['qsdone']?'&qsdone=1':''), 0);
	}
	if(@$_REQUEST['qs_reset'] == 1)
		redirect('indexmain.php?createmenu=2&quick_setup=0&qs_reset=0'.(@$_REQUEST['qsdone']?'&qsdone=1':''), 0);
	    
	if(!isset($_GET['controller'])){
		require_once('includes/defines.php');
		require_once('includes/adodb/adodb.inc.php');
		$recordSet = $conn->execute("select max(id) from gencompany where active=1");
		if (!$recordSet||$recordSet->fields[0]<1||$quick_setup==1) {
	        $glog = isset($_REQUEST['glog']) ? '&glog=1' : '';
      		redirect('indexmain.php?quick_setup=1&qs_reset=0'.$glog, 0);
		}
    	if(!isset($_REQUEST['autoUpdateAction'])){
    		//NP6
    		$path = dirname(__FILE__).'/!/';
    		chdir($path);
	        require_once($path."index.php");
		}
		else{
			//NP5
		    include('indexmain.php');
	        require_once("includes/footer.php");
		}
    }
    else
        include('app/lib/application.php');