<?php
if (function_exists('session_start')) {
	@session_start();	
}

ini_set('auto_detect_line_endings', true);

$_SESSION['iconset'] = "deflt";
$headerpagetitle = 'NolaPro Business Management';
// Get any white label definitions for title
if (file_exists(dirname(__FILE__).'/wl/'.@$_SESSION['wlhost'].'wl.php')) {
	include_once(dirname(__FILE__).'/wl/'.@$_SESSION['wlhost'].'wl.php');
	if (defined('WL_NAME') && defined('WL_SUBNAME')) {
		$headerpagetitle = WL_NAME.' '.WL_SUBNAME;	
	}
} 
?><!DOCTYPE html>
<html>
<head>
<title><?php echo $headerpagetitle; ?> Installation</title>
<link rel="stylesheet" type="text/css" href="includes/style/bluish.css">
<link rel="stylesheet" type="text/css" href="includes/default.css">
<script type="text/javascript" src="js/jquery.min.js"></script>
</head>
<body>
<table align="center">
<tr>
<td align="center">
<div class="texttitle"><?php echo $headerpagetitle; ?> Initial Setup</div>

<?php 
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Check for System Dependencies
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	// Start output buffering so we can check the system state each time to make sure nothing changed
	ob_start();
?>
	<h2>We will now check your system to make sure it<br/>has everything it needs to run NolaPro properly.</h2>
	<table align="center" width="325 ">
	<tr>
	<td><img src="images/checkmarktesting.gif" width="25"></td><td>Green checks mean this setting is OK.</td>
	</tr>
	<tr>
	<td><img src="images/checkx.gif" width="25"></td><td>Red Xs mean this setting needs to be changed by you or a server administrator in order to continue.</td>
	</tr>
	<tr>
	<td colspan="2"><br/>After modifying a system setting refresh this page so it can verify your new configuration.</td>
	</tr>
	</table>
	<br/><br/>
<?php

	$system_ok = 1;
	$ok_img = '<img src="images/checkmarktesting.gif" width="25" style="padding-left: 8px;">';
	$bad_img = '<img src="images/checkx.gif" width="25" style="padding-left: 8px;">';
    $_bad_style = 'background-color: #cc3333; color: #ffffff;';
	$bad_style = ' style="'.$_bad_style.'" ';
	
	$required_extensions = array(	'gd' => array('title' => '<b>gd</b> - needed for creating dynamic charts',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with gd support or uncomment the ;extension= line in your php.ini file for gd.'),
									'session' => array('title' => '<b>session</b> - required for logging into the system',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with session support or uncomment the ;extension= line in your php.ini file for sessions. On Linux you may need to download a php-session rpm to get this functionality.'),
									'curl' => array('title' => '<b>curl</b> - required for credit card processing',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with curl support or uncomment the ;extension= line in your php.ini file for curl. On Linux you may need to download a php-curl rpm to get this functionality.'),
									'mbstring' => array('title' => '<b>mbstring</b> - required for multibyte string processing',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with mbstring support or uncomment the ;extension= line in your php.ini file for mbstring. On Linux you may need to download a php-mbstring rpm to get this functionality.'),
                                    'PDO' => array('title' => '<b>PDO</b> - required for database interaction',
                                        'resolution' => 'Please add this extension to your PHP installation. Either recompile with PDO support or uncomment the ;extension= line in your php.ini file for PDO. On Linux you may need to download a php-pdo rpm to get this functionality.'),
									'zlib' => array('title' => '<b>zlib</b> - required for working with PDF files',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with zlib support or uncomment the ;extension= line in your php.ini file for zlib. On Linux you may need to download a php-zlib rpm to get this functionality.'),
									//'Zend Optimizer' => array('title' => '<b>Zend Optimizer</b> - necessary for running encrypted NolaPro pages',
									//	'resolution' => 'You can download a current version of the Zend Optimizer <a href="http://www.zend.com/products/zend_optimizer" style="color: #ffffff; font-weight: bold;" target="_blank">here</a>. <br/><br/>Note: The Zend Optimizer will not run with Security Enhance Linux (SE Linux) turned on.  You must disable this first.')
									);
	if (!function_exists('utf8_encode')) {
		$required_extensions['xml'] = array('title' => '<b>xml</b> - UTF8 Support',
																			  'resolution' =>'Please add this extension to your PHP installation. Either recompile with session support or uncomment the ;extension= line in your php.ini file for sessions. On Linux you may need to download a php-xml rpm to get this functionality.');
	}
	echo '<table class="report" width="500">';
	echo '<tr>';
	echo '<th class="header" colspan="2">Required Extensions</th>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>Extension</th>';
	echo '<th width="75">Status</th>';
	echo '</tr>';
	if (function_exists('mysql_connect')) {
		$use_img = $ok_img;
		$res = "";
		$style = '';
	} else {
		$use_img = $bad_img;	
		$res = "<br/><br/>MySQL must be installed and be precompiled or loaded as an extension with PHP.";
		$style = $bad_style;
		$system_ok = 0;
	}
	echo '<tr>';
	echo '<td class="standard" '.$style.'><b>MySQL</b> - back-end database NolaPro utilizes'.$res.'</td>';
	echo '<td '.$style.'>';
	echo $use_img;
	echo '</td>';
	echo '</tr>';
	if (check_ion_cube()) {
		$use_img = $ok_img;
		$res = "";
		$style = '';
	} else {
		$use_img = $bad_img;	
		$res = "<br/><br/>The ionCube Loader could not be found. Please go to <a href='http://www.ioncube.com/loaders.php'>ionCube.com</a> to get and install a compatible loader.";
		$style = $bad_style;
		$system_ok = 0;
	}
	echo '<tr>';
	echo '<td class="standard" '.$style.'><b>ionCube Loader</b> - used to load encoded NolaPro files'.$res.'</td>';
	echo '<td '.$style.'>';
	echo $use_img;
	echo '</td>';
	echo '</tr>';
	foreach ($required_extensions as $ext => $desc) {
		if (extension_loaded($ext)) {
			$use_img = $ok_img;
			$style = '';
			$res = "";
		} else {
			$use_img = $bad_img;
			$style = $bad_style;
			$res = "<br/><br/>$desc[resolution]";
			$system_ok = 0;
		}
		echo '<tr>';
		echo '<td class="standard" '.$style.'>'.$desc['title'].$res.'</td>';
		echo '<td '.$style.'>';
		echo $use_img;
		echo '</td>';
		echo '</tr>';
	}
	echo '</table>';
	echo '<br/><br/>';
	echo '<table class="report" width="500">';
	echo '<tr>';
	echo '<th class="header" colspan="2">Required PHP Configuration Settings</th>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>Configuration Setting</th>';
	echo '<th width="75">Status</th>';
	echo '</tr>';
	$standard_setting_resolution = 'You can either change the setting in your php.ini file, add it to your Apache virtual host entry, 
	or use the htaccess.txt file in the main NolaPro directory and rename it to .htaccess. 
	To use the .htaccess file Apache must be set up to allow overrides for your domain (via the AllowOverride setting).';
	$php_settings = array('short_open_tag' => array('default' => 'on',
										'title' => '<b>short_open_tag</b> must be <b>on</b>',
										'resolution' => $standard_setting_resolution),
						'session.auto_start' => array('default' => 'off',
											'title' => '<b>session.auto_start</b> must be <b>off</b>',
											'resolution' => $standard_setting_resolution),
						'file_uploads' => array('default' => 'on',
											'title' => '<b>file_uploads</b> must be <b>on</b>',
											'resolution' => $standard_setting_resolution),
						'auto_detect_line_endings' => array('default' => 'on',
											'title' => '<b>auto_detect_line_endings</b> must be <b>on</b>',
											'resolution' => $standard_setting_resolution),
						/*'magic_quotes_gpc' => array('default' => 'on',
											'title' => '<b>magic_quotes_gpc</b> must be <b>on</b>',
											'resolution' => $standard_setting_resolution),
						'magic_quotes_runtime' => array('default' => 'off',
											'title' => '<b>magic_quotes_runtime</b> must be <b>off</b>',
											'resolution' => $standard_setting_resolution),*/
						//'register_long_arrays' => array('default' => 'on',
						//					'title' => '<b>register_long_arrays</b> must be <b>on</b>',
						//					'resolution' => $standard_setting_resolution),
						'safe_mode' => array('default' => 'off',
											'title' => '<b>safe_mode</b> must be <b>off</b>',
											'resolution' => $standard_setting_resolution),
						'register_globals' => array('default' => 'off',
											'title' => '<b>register_globals</b> must be <b>off</b>',
											'resolution' => $standard_setting_resolution));
	if (!defined('PHP_VERSION_ID')) {
        $version = explode('.', PHP_VERSION);
        define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
    }

	foreach ($php_settings as $setting => $details) {
        //Lookup setting
		$ini_setting = ini_get($setting);
		$cur_value = ($ini_setting && strtolower($ini_setting) != 'off') ? 'on' : 'off';
        
        //Skip magic quotes check for php 5.4+
        if(PHP_VERSION_ID > 50400 && preg_match('/^magic_quotes_/i', $setting))
            $cur_value = null;

        //Prepare Output
		if ($cur_value == $details['default'] || $cur_value === null) {
			$use_img = $ok_img;
			$res = "";
			$style = '';
		} 
        else {
			$use_img = $bad_img;
			$res = ", current value is <b>$cur_value</b><br/><br/>$details[resolution]";
			$style = $bad_style;
			$system_ok = 0;
		}
        
        //Output Table Row
		echo '<tr>';
		echo '  <td class="standard" '.$style.'>'.$details['title'].'<i>'.$res.'</i></td>';
		echo '  <td '.$style.'>';
		echo        $use_img;
		echo '  </td>';
		echo '</tr>';
	}
	echo '</table>';
	
	echo '<br/><br/>';
	echo '<table class="report" width="500">';
	echo '<tr>';
	echo '<th class="header" colspan="2">Required Permissions for Files and Directories</th>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>File or Directory</th>';
	echo '<th width="75">Status</th>';
	echo '</tr>';
	$session_path = ini_get('session.save_path');
	$standard_directory_resolution = 'Change permissions to allow the web server to write files in this directory. For Linux this directory can have 777 permissions (read, write, execute for all)';
	$standard_file_resolution = 'Change permissions to allow the web server to write to this file. For Linux this file can have 777 permissions (read, write, execute for all)';
	$dir_check = array(	dirname(__FILE__) => array('title' => '<b>nolapro (Linux) or htdocs (Windows)</b> main directory must be writable by the web server',
										'resolution' => $standard_directory_resolution),
						'uploads' => array('title' => '<b>uploads</b> NolaPro directory must be writable',
										'resolution' => $standard_directory_resolution),
						'includes/my_defines.php' => array('title' => '<b>includes/my_defines.php</b> NolaPro file must be writable',
											'resolution' => $standard_file_resolution),
						'install.php' => array('title' => '<b>install.php</b> NolaPro file must be writable',
											'resolution' => $standard_file_resolution));
	
	if (file_exists(dirname(__FILE__).'/api/app/config/database.php')) {
		$dir_check[dirname(__FILE__).'/api/app/config/database.php'] = array('title' => '<b>api/app/config/database.php</b> NolaPro API file must be writable',
											'resolution' => $standard_file_resolution);
	}
	foreach ($dir_check as $dir => $details) {
		if (is_writable($dir)) {
			$use_img = $ok_img;
			$res = "";
			$style = '';
		} else {
			$use_img = $bad_img;
			$res = "<br/><br/>$details[resolution]";
			$style = $bad_style;	
			$system_ok = 0;
		}
		echo '<tr>';
		echo '<td class="standard" '.$style.'>'.$details['title'].'<i>'.$res.'</i></td>';
		echo '<td '.$style.'>';
		echo $use_img;
		echo '</td>';
		echo '</tr>';
	}
	echo '</table>';
	
	// Get the contents of the buffer and display if there was an error
	$html = ob_get_clean();
	
	$check_database = 0;
	if ($system_ok) {
		if ((!isset($_POST['phase']) && !isset($_GET['phase'])) || (isset($_POST['phase']) && $_POST['phase'] < 2)) {
			echo $html;
			echo '<form id="frmMain" method="post" action="'.$_SERVER['PHP_SELF'].'">';
			echo '<table class="buttons">';
			echo '<tr><td><input type="image" src="menuicons/'.$_SESSION['iconset'].'/next.png"</td></tr>';
			echo '<tr><td>Next</td></tr>';
			echo '</table>';
			echo '<input type="hidden" name="phase" value="2">';
			echo '</form>';
			if (stristr(php_uname('s'), 'Windows')) {
				// Move to the next page if this is windows
				echo '<META HTTP-EQUIV="refresh" content=0;URL='.$_SERVER['PHP_SELF'].'?phase=2>';
			}
		}
		$check_database = 1;
	} else {
		echo $html;
		echo '<br/><br/><b>You must resolve the issues marked in red above before you can continue with the installation.</b>';
	} 

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Set up the database
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	if ($check_database) {
		include_once('includes/my_defines.php');
		echo '<h2>NolaPro Database Installation</h2>';
		
		if (isset($_GET['phase']) && $_GET['phase'] == 4) {
			// Load the database file now
			$conn = mysqli_connect($_SESSION['setup']['np_host'].$_SESSION['np_mysql_port'], $_SESSION['setup']['np_user'], $_SESSION['setup']['np_pass']);
			$mysql_ok = 1;
			// Connect again and send back the person if it fails for some reason
			if ($conn == false || !mysqli_select_db($conn,$_SESSION['setup']['np_db'])) {
				$mysql_ok = 0;
				$_POST['phase'] = 3;
			}
			
			if ($mysql_ok) {
				set_time_limit(0);
				// Read in the database file
				echo "<h3>Creating NolaPro tables...</h3>";
				//Open the file
				$fh=@fopen("nolapro.sql","rb");
				if(!$fh)die(STR_DB_FILE_NOT_FOUND."<p>");
				$query = "";
				$errorfound=0; // Whether any errors were found
				while($sql=fgets($fh))
				{
					if (substr(trim($sql), 0, 2) != "--") // Ignore comments
					{
						// Find out where semi-colon is
						if(substr(trim($sql),strlen(trim($sql))-1,1)==";")
						{
							$query.=trim($sql);
							// Execute this sql statement
							$res = mysqli_query($conn,$query);
							if(!$res) {
								echo htmlspecialchars($query)."<br/><br/><span style=\"color:#cc0000;\">Error #".mysqli_errno($conn)." ".mysqli_error($conn)."</span><hr><br/>";
								$errorfound=1;
							}
							$query="";
						}
						else 
						{
							$query .= $sql;
						}
					}
				}
				
				//Save DB Version
				function getBuildVersion(){
					define('LOAD_DEFINES_FOR_VERSION', 1);
					require(dirname(__FILE__).'/includes/defines.php');
				}
				getBuildVersion();
				
				mysqli_query($conn,'DELETE FROM `serversetup` WHERE `definename` = \'np_build\'');
				$rs = mysqli_query($conn,'SELECT (MAX(`id`) + 1) as `next` FROM `serversetup`');
				if($rs){
					if($r = mysqli_fetch_assoc($rs)){
						$id = intval($r['next']);
						mysqli_query($conn,'INSERT INTO `serversetup` (`id`, `definename`, `definevalue`) VALUES ('.$id.', \'np_build\', \''.intval(BUILD_VERSION).'\')');
					}
				}

				if (!$errorfound) {
					echo "<h3>The database has been created successfully!</h3>";
					echo "<h3><a href='index.php'>Click here to continue with the NolaPro setup.</a></h3>";
					@unlink('install.php');
				} else {
					echo "<h3>There was a problem creating the database.</h3>";
					// Clean up the database by deleting all of the tables currently in there
					$res = mysqli_query($conn,"show tables");
					while ($row = mysqli_fetch_row($res)) {
						$tablename=$row[0];
						$res2=mysqli_query($conn,"drop table $tablename");
					}
				}
			}
		}
		
		if (isset($_POST['phase']) && $_POST['phase'] == 3) {
			$mysql_ok = 1;
			$error_msg = "";
			$_SESSION['np_mysql_port'] = ":53306";
			// Verify the login information provided
			$conn = mysqli_connect($_POST['np_host'].$_SESSION['np_mysql_port'], $_POST['np_user'], $_POST['np_pass']);
			
			// Try without alt 53306 port
			if ($conn == false) {
				$_SESSION['np_mysql_port'] = "";
				$conn = mysqli_connect($_POST['np_host'].$_SESSION['np_mysql_port'], $_POST['np_user'], $_POST['np_pass']);
			}
			if ($conn == false) {
				$mysql_ok = 0;
				$error_msg = "Could not connect to the MySQL database with the host,<br/>user account and password provided. Please try again.";
				$error_msg .= "<br/><br/><span style='font-size: 8pt; font-style: italic;'>Error #".mysqli_errno($conn)." ".mysqli_error($conn)."</span>";
				$_POST['phase'] = 2;
			}
			
			// Make sure the database exists
			if ($mysql_ok && !mysqli_select_db($conn,$_POST['np_db'])) { 
				// Attempt to create the mysql database if we couldn't connect
				$res = mysqli_query($conn,"create database if not exists $_POST[np_db]");
				if (!$res || !mysqli_select_db($conn,$_POST['np_db'])) {
					$mysql_ok = 0;
					$error_msg = "Could not connect to the <i>$_POST[np_db]</i> MySQL database. <br/>Make sure the database exists and that the user <i>$_POST[np_user]</i><br/>has the proper rights to access it.";
					$_POST['phase'] = 2;
				}
			}
			
			// See if the version of mysql is correct
			if ($mysql_ok) {
				$res = mysqli_query($conn,"select version()");
				if (!$res) {
					$mysql_ok = 0;
					$error_msg = "There was an error checking for the current version of mysql.";
					$_POST['phase'] = 2;
				}
				$row = mysqli_fetch_row($res);
				if ($mysql_ok && substr($row[0], 0, 3) < "4.1") {
					$mysql_ok = 0;
					$error_msg = "NolaPro requires MySQL version 4.1.x or higher. MySQL $row[0] is currently installed.<br/>Please choose a 4.1.x or greater server for NolaPro to connect to.";
					$_POST['phase'] = 2;
				}
			}
			
			// See if the database has any tables and display an error
			if ($mysql_ok) {
				$res = mysqli_query($conn,"show tables");
				if (!$res) {
					$mysql_ok = 0;
					$error_msg = "There was an error checking for existing tables in the <i>$_POST[np_db]</i> database.<br/>Make sure this user has rights for the database.";
					$_POST['phase'] = 2;
				}
				if ($mysql_ok && mysqli_num_rows($res) > 0) {
					$mysql_ok = 0;
					$error_msg = "There are some tables already in the <i>$_POST[np_db]</i> database.<br/>NolaPro requires an empty database.";
					$_POST['phase'] = 2;
				}
			}
			
			// See if the mysql file exists
			if ($mysql_ok) {
				if (!file_exists("nolapro.sql")) {
					$mysql_ok = 0;
					$error_msg = "The database file, <i>nolapro.sql</i>, is missing. Cannot continue until this file is placed in the top-level NolaPro directory.";
					$_POST['phase'] = 2;
				} else {
					echo "<h3>The database connection is OK.</h3>";
					echo "<h3>Reading in the database file...<br/>
							This may take a few minutes...</h3>";
					// Write the new values to my_defines.php
					include('includes/class.search_replace.inc');
					
					$files_to_change = array('includes/my_defines.php');
					$sr = new search_replace("define('DB_SERVER', '".DB_SERVER."')", "define('DB_SERVER', '".$_POST['np_host']."')", $files_to_change, '', 1, array('##'));
					$sr->set_search_function('normal');
			        $sr->do_search();
			        
			        $sr->find = "define('DB_SERVER_USERNAME', '".DB_SERVER_USERNAME."')";
			        $sr->replace = "define('DB_SERVER_USERNAME', '".$_POST['np_user']."')";
			        $sr->do_search();
			        
			        $sr->find = "define('DB_SERVER_PASSWORD', '".DB_SERVER_PASSWORD."')";
			        $sr->replace = "define('DB_SERVER_PASSWORD', '".$_POST['np_pass']."')";
			        $sr->do_search();
			        
			        $sr->find = "define('DB_DATABASE', '".DB_DATABASE."')";
			        $sr->replace = "define('DB_DATABASE', '".$_POST['np_db']."')";
			        $sr->do_search();
					
			        if (file_exists(dirname(__FILE__).'/api/app/config/database.php')) {
						$files_to_change = array('api/app/config/database.php');
						$sr = new search_replace("'host' => '127.0.0.1',", "'host' => '".$_POST['np_host']."',", $files_to_change, '', 1, array('##'));
						$sr->set_search_function('normal');
						$sr->do_search();
						
						$sr->find = "'login' => 'root',";
						$sr->replace = "'login' => '".$_POST['np_user']."',";
						$sr->do_search();
						
						$sr->find = "'password' => '',";
						$sr->replace = "'password' => '".$_POST['np_pass']."',";
						$sr->do_search();
						
						$sr->find = "'database' => 'nolapro',";
						$sr->replace = "'database' => '".$_POST['np_db']."',";
						$sr->do_search();
					}        
					$_SESSION['setup'] = array();
					$_SESSION['setup'] = $_POST; 
					
					echo '<META HTTP-EQUIV="refresh" content=2;URL='.$_SERVER['PHP_SELF'].'?phase=4>';
				}
			}
		}
		
		if (isset($_POST['phase']) && $_POST['phase'] == 2 || isset($_GET['phase']) && $_GET['phase'] == 2) {
			if (isset($error_msg) && $error_msg != "") {
				echo '<span style="color: #cc0000; font-weight: bold; font-size: 10pt;">'.$error_msg.'</span><br/><br/>';	
			}
			?>
			<b>*Windows users can accept all defaults and click the Next button</b><br/><br/>			
			<form method="post" action="<?php echo $_SERVER['PHP_SELF'] ?>" name="mainform">
			<table align="center" width="600" class="report">
			<tr>
				<th colspan="2">Enter the host name of the MySQL server</th>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">MySQL Host Name:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_host" value="<?php echo (isset($_POST['np_host']) && $_POST['np_host'] != "" ? $_POST['np_host'] : DB_SERVER)?>"></td>
			</tr>
			<tr>
				<th colspan="2">Enter the name of the MySQL database NolaPro should use</th>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">MySQL Database:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_db" value="<?php echo (isset($_POST['np_db']) && $_POST['np_db'] != "" ? $_POST['np_db'] : DB_DATABASE)?>"></td>
			</tr>
			<tr>
				<th colspan="2">Enter the MySQL user information for the account<br/>you want to use to access your NolaPro database<br/>
				<span style="font-style: italic; font-size: 8pt; font-weight: normal;">(You can download a free administrative tool from<br/><a href="http://www.mysql.com/products/tools" target="_blank">MySQL</a> to create a database and user account.)</span></th>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">MySQL User Account:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_user" value="<?php echo (isset($_POST['np_user']) && $_POST['np_user'] != "" ? $_POST['np_user'] : DB_SERVER_USERNAME)?>"></td>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">Password:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_pass" value="<?php echo (isset($_POST['np_pass']) ? $_POST['np_pass'] : DB_SERVER_PASSWORD)?>"></td>
			</tr>
			</table>
			<table class="buttons">
			<tr><td><input type="image" src="menuicons/<?php echo $_SESSION['iconset']; ?>/next.png"></td></tr>
			<tr><td>Next</td></tr>
			</table>
			<input type="hidden" name="phase" value="3">
			</form>
			<br/><br/>
			<?php
			if (stristr(php_uname('s'), 'Windows') && (!isset($error_msg) || $error_msg == "")) {
				// Move to the next page if this is windows
				?>
				<script language="javascript">
				document.mainform.submit();
				</script>
				<?php
			}
		}
	}
?>
</td>
</tr>
</table>
<br/>
<br/>
</body>
</html>
<?php
function check_ion_cube() {
	$already_loaded = extension_loaded('ionCube Loader');
	if ($already_loaded) return true;
	$ok = true;
	$status = "";
	$msg = "";
	$nl = "<br/>";
	if (!isset($_SERVER))
    	$_SERVER = &$_SERVER;  
    
	if (!isset($_GET))
	    $_GET = &$_GET; 

	
	$php_version = phpversion();
	$php_flavour = substr($php_version,0,3);
	
	
	//
	// Get the full name and short name for the OS
	//
	
	$os_name = substr(php_uname(),0,strpos(php_uname(),' '));
	$os_code = strtolower(substr($os_name,0,3));
	
	$dll_sfix = (($os_code == 'win') ? '.dll' : '.so');
	//
	// Look for a Loader
	//

	// Old style naming should be long gone now
	$test_old_name = false;

	$_u = php_uname();
	$_os = substr($_u,0,strpos($_u,' '));
	$_os_key = strtolower(substr($_u,0,3));

	$_php_version = phpversion();
	$_php_family = substr($_php_version,0,3);

	$_loader_sfix = (($_os_key == 'win') ? '.dll' : '.so');

	$_ln_old="ioncube_loader.$_loader_sfix";
	$_ln_old_loc="/ioncube/$_ln_old";

	$_ln_new="ioncube_loader_${_os_key}_${_php_family}${_loader_sfix}";
	$_ln_new_loc="/ioncube/$_ln_new";

	$_extdir = ini_get('extension_dir');
	if ($_extdir == './') {
	  $_extdir = '.';
	}

	$_oid = $_id = realpath($_extdir);

	$_here = dirname(__FILE__);
	if ((@$_id[1]) == ':') {
	  $_id = str_replace('\\','/',substr($_id,2));
	  $_here = str_replace('\\','/',substr($_here,2));
	}
	$_rd=str_repeat('/..',substr_count($_id,'/')).$_here.'/';

	if ($_oid !== false) {
	  $status .= "Extensions Dir: $_extdir ($_id)$nl";
	  $status .= "Relative Path:  $_rd$nl";
	} else {
	  $status .= "Extensions Dir: $_extdir (NOT FOUND)$nl$nl";

		$status .= "The directory set for the extension_dir entry in the\n"
.	"php.ini file may not exist, and run time loading will not be possible.$nl";
		$status .=   "Please ask your hosting provider or system administrator to create the\n"
		.		    "directory$nl$nl"
		.		    "$_extdir$nl$nl"
		.		    "ensuring that it is accessible by the web server software. They do not\n"
		.		    "need to restart the server. Then rerun this script. As an alternative,\n"
		.		    "your host could install the Loader in the php.ini file.$nl";
	  $ok = false;
	}

	if ($ok) {
	  $_ln = '';
	  $_i=strlen($_rd);
	  while($_i--) {
	if($_rd[$_i]=='/') {
	  if ($test_old_name) {
		// Try the old style Loader name
		$_lp=substr($_rd,0,$_i).$_ln_old_loc;
		$_fqlp=$_oid.$_lp;
		if(@file_exists($_fqlp)) {
		  $status .= "Found Loader:   $_fqlp$nl";
		  $_ln=$_lp;
		  break;
		}
	  }
	  // Try the new style Loader name
	  $_lp=substr($_rd,0,$_i).$_ln_new_loc;
	  $_fqlp=$_oid.$_lp;
	  if(@file_exists($_fqlp)) {
		$status .= "Found Loader:   $_fqlp$nl";
		$_ln=$_lp;
		break;
	  }
	}
	  }

	  //
	  // If Loader not found, try the fallback of in the extensions directory
	  //
	  if (!$_ln) {
	    if ($test_old_name) {
	      if (@file_exists($_id.$_ln_old_loc)) {
		    $_ln = $_ln_old_loc;
	      }
	    }
	    if (@file_exists($_id.$_ln_new_loc)) {
	      $_ln = $_ln_new_loc;
	    }

	    if ($_ln) {
	      $status .= "Found Loader $_ln in extensions directory.$nl";
	    }
	  }

	  if ($_ln && function_exists('dl')) {
		$status .= "Trying to install Loader - this may produce an error...$nl$nl";
		dl($_ln);
	  }
	}

	if(extension_loaded('ionCube Loader')) {
		return true;
	} else {
		return false;
	}	
}