///////////////////////////////////////////////
// Makes table headers float down the screen //
///////////////////////////////////////////////

var iev = getInternetExplorerVersion();
var floating_headers_enabled = (iev == -1 || iev > 8);
if(floating_headers_enabled){
    var Opera = /opera/i.test(navigator.userAgent);
    floating_headers_enabled = !Opera;
}

var FloatingHeader = {
    
    v_table_list: [],
    h_table_list: [],
    last_id_given: 0,
    last_class_given: 0,
    
    Initialize: function(){
        if(!floating_headers_enabled || UI.large_page_mode) return;
        
		var view = $(FloatingHeader.view());
		var x = view[0].scrollLeft;
		var y = view[0].scrollTop;
		view[0].scrollTop = 0;
		view[0].scrollLeft = 0;
		
        $('#main_menu>ul>li>a').click(function(){ UpdateFloatingHeaderPositions(true) });
        FloatingHeader.GetTableList();
        FloatingHeader.MakeAllStaticSized();
        
		view[0].scrollTop = x;
		view[0].scrollLeft = y;
		
        setTimeout('FloatingHeader.MakeAllHorzFloatingHeaders();FloatingHeader.MakeAllVertFloatingHeaders();FloatingHeader.SyncFloatingCellsToParent();FloatingHeader.OnWindowResize();', 100);
        setTimeout('FloatingHeader.InvalidateLocations();UpdateFloatingHeaderPositions(true);', 500);
        setTimeout('FloatingHeader.InvalidateLocations();UpdateFloatingHeaderPositions(true);', 3000);
    },
    
    GetTableList: function(){
        FloatingHeader.table_list = [];
        $('table').each(function(){
            var q_elm  = $(this);
            var d_elm  = q_elm[0];
            if(q_elm.hasClass('nofloat')) return true;
            if(q_elm.hasClass('mobile_collapse') && typeof(window.isMobile) != 'undefined' && window.isMobile) return true;
            
            //Add horizontal floats
            var hs = q_elm.find('.h_float');
            if(hs.length > 0){
	            if(typeof(d_elm.id) == undefined || d_elm.id == "") d_elm.id = FloatingHeader.GetNextId();
                FloatingHeader.h_table_list.push(d_elm.id);
            }
            
            //add vertical floats
            if(q_elm.hasClass('report')){
	            if(typeof(d_elm.id) == undefined || d_elm.id == "") d_elm.id = FloatingHeader.GetNextId();
                var rows = q_elm.find('tr');
                if(rows.length > 8 || q_elm.hasClass('reportcache'))
                    FloatingHeader.v_table_list.push(d_elm.id);
            }
                
        });
    },
    GetNextId: function(){
        var id = "FloatingHeadersAutoId_"+FloatingHeader.last_id_given;
        FloatingHeader.last_id_given++;
        return id;
    },
    
    MakeAllStaticSized: function(){
        var handled_tables = [];
        for(var i = 0; i < FloatingHeader.v_table_list.length; i++){
            var tid = FloatingHeader.v_table_list[i];
            if($.inArray(tid,handled_tables) == -1){
                FloatingHeader.MakeStaticSized(tid);
                handled_tables.push(tid);
            }
        }
        for(var i = 0; i < FloatingHeader.h_table_list.length; i++){
            var tid = FloatingHeader.h_table_list[i];
            if($.inArray(tid,handled_tables) == -1){
                FloatingHeader.MakeStaticSized(tid);
                handled_tables.push(tid);
            }
        }
    },
    MakeStaticSized: function(id){
        //Set Static Width
        {
            //Find largest row of <td>
            var largest_td_collection = [];
            var largest_rs_collection = [];
            var row_span_stack = [];
            $('#'+id+' tr').each(function(index){
                if(index > 10) return false;//only check the first rows
                var tds = $(this).children('td, th');
                var prev_rowspan_stack = row_span_stack.slice(0);
                
                //Clean up row_span_stack (ie count down the 'remaining' rows
                for(var i = 0; i < row_span_stack.length; i++){
                    row_span_stack[i].remaining--;
                    if(row_span_stack[i].remaining <= 1){
                        row_span_stack.splice(i,1);
                        i--;
                    }
                }
                
                //Is this the largest collection?
                if(largest_td_collection.length < tds.length + row_span_stack.length){
                    //Splice largest_td_collection with row_span_stack
                    var add_tds_from_rowspans = [];
                    var add_tds_from_rowspans_index = [];
                    for(var i = 0; i < prev_rowspan_stack.length; i++){
                        add_tds_from_rowspans_index.push(prev_rowspan_stack[i].index);
                        add_tds_from_rowspans[prev_rowspan_stack[i].index] = prev_rowspan_stack[i].elm;
                    }
                    add_tds_from_rowspans_index.sort();
                    add_tds_from_rowspans_index.reverse();
                    for(var i = add_tds_from_rowspans_index.length - 1; i >= 0; i--){
                        var index = add_tds_from_rowspans_index[i];
                        tds.splice(index, 0, add_tds_from_rowspans[index]);
                    }
                    
                    largest_td_collection = tds;
                    largest_rs_collection = prev_rowspan_stack.slice(0);
                }
                
                //Find any row spans...
                tds.each(function(_index){
                    if(typeof(this.rowSpan) != 'undefined' && this.rowSpan > 1){
                        var c = parseInt(this.rowSpan);
                        row_span_stack.push({'index': _index, 'elm': this, 'rows': c, 'remaining': c});
                    } 
                });
            });
        }
        
        //Set Static Heights
        {
            var sizes = [];
            $('#'+id+' tr').each(function(index){
                sizes[index] = $(this).height();
            });
            
            $('#'+id+' tr').each(function(index){
                $(this).css('height', sizes[index]+'px');
            });
        }
    },

    MakeAllHorzFloatingHeaders: function(){
        for(var i = 0; i < FloatingHeader.h_table_list.length; i++){
            var id = FloatingHeader.MakeHorzFloatingHeader(FloatingHeader.h_table_list[i]);
            FloatingHeader.MakeVertFloatingHeader(id, 2, false);
        }
    },
    MakeAllVertFloatingHeaders: function(){
        for(var i = 0; i < FloatingHeader.v_table_list.length; i++)
            FloatingHeader.MakeVertFloatingHeader(FloatingHeader.v_table_list[i], 1);
    },
    
    MakeHorzFloatingHeader: function(id){
        var elm = $('#'+id);
        var html = elm.html();

        //Crop out non-.h_float <td>'s
        html = html.replace(/(<t[dh]\b[^>]*>)((.|\r|\n)*?)(<\/t[dh]\b[^>]*>)/ig, function(match, p1, p2, p3){
            if(p1.match(/h_float/i))
                return match;
            else
                return "";
        });
        
        //Find largest row of <td>
        var largest_td_collection = 0;
        $('#'+id+' tr').each(function(index){
            if(index > 10) return false;//only check the first rows
            var tds = $(this).children('.h_float');
            if(largest_td_collection < tds.length)
                largest_td_collection = tds.length;
        });

        //Get Cell Widths
        var colgroup_html = '';
        colgroup_html += '<colgroup>';
        var first_tr = $(elm).find('tr')[0];
        var total_width = 0;
        $(first_tr).find('td, th').each(function(index){
            if(index < largest_td_collection){
                var _w = ($(this).width()+(index == largest_td_collection-1 ? 1 : 0));
                total_width += $(this).outerWidth();
                colgroup_html += '<col width="'+_w+'" style="width: '+_w+'px !important; min-width: '+_w+'px !important; max-width: '+_w+'px !important;">';
            }
        });
        total_width+=2;
        colgroup_html += '</colgroup>';
        
        //Setup the table
        var tbl = document.createElement('table');
        tbl.parent = elm[0];
        tbl.top_min  = elm.offset().top;
        tbl.left_min = elm.offset().left;
        tbl.left_min -= this.viewOffsetLeft();
        
        var style  = ((typeof(elm.attr('style')) != 'undefined') ? elm.attr('style') : "");
        var classn = ((typeof(elm.attr('class')) != 'undefined') ? elm.attr('class') : "");
        var id     = FloatingHeader.GetNextId();
        
        $(tbl).attr('class', "floating_header_h "+classn);
        $(tbl).attr('style', style+"; border-bottom: none; border-right: none; margin-top: 0;");
        $(tbl).attr('cellpadding', elm.attr('cellpadding'));
        $(tbl).attr('cellspacing', elm.attr('cellspacing'));
        $(tbl).attr('id', id);
        $(tbl).css('position', "absolute");
        $(tbl).css('top',  tbl.top_min+"px");
        $(tbl).css('left', tbl.left_min+"px");
        $(tbl).css('width', total_width+"px");
        $(tbl).html(colgroup_html+html);
        elm[0].parentNode.appendChild(tbl);
        tbl.top_max  = (tbl.top_min +elm.height() - $(tbl).height());
        tbl.left_max = (tbl.left_min+elm.width()  - $(tbl).width());
        
        //Trim the <colgroup>
        $(tbl).find('colgroup > col').each(function(index){
            if(index > largest_td_collection){
                $(this).remove();   
            }
        });
        
        //Remove rowover's
        $(tbl).find('.rowover').each(function(){
            $(this).removeClass('rowover'); 
        });
        
        $(tbl).css('border-top-right-radius', '0px');
        $(tbl).css('border-bottom-right-radius', '0px');
		$(tbl).find('tr:first').find(':last').css('border-top-right-radius', '0');
		$(tbl).find('tr:last').find(':last').css('border-bottom-right-radius', '0');
        
        return id;
    },
    MakeVertFloatingHeader: function(id, z_index, avoid_table_width){
        if(typeof(avoid_table_width) == 'undefined') avoid_table_width = false;
        var this_elm = document.getElementById(id);
        if(typeof(this_elm) == 'undefined' || this_elm == null) return;
        $(this_elm).addClass('floating_table_parent');
        var pop_rows = new Array();
        var trs = $.merge($(this_elm).children('tr'), $(this_elm).find('tbody tr, thead tr'));

        var found_as_headers = 0;
        trs.each(function(index){
            //Check if is header row
            var isHeaderRow = (this.childNodes.length > 0);
            for(var i = 0; i < this.childNodes.length; i++){
                var node = this.childNodes[i];
                if(typeof(node.tagName) != 'undefined'){
                    var tag  = node.tagName.toLowerCase();
                    if(tag != "th" || $(node).hasClass('nofloat') || $(node).hasClass('sub_header')){
                        isHeaderRow = false;
                        break;
                    }
                }
            }
            if(isHeaderRow){
                found_as_headers++;
                pop_rows[index] = this;
                $(pop_rows[index]).find('th').each(function(){
                    if($(this).attr('class')) $(this).attr('class', $(this).attr('class').replace(/floating_class_\d+/ig, ''));
                    $(this).addClass('floating_cell floating_class_'+FloatingHeader.last_class_given);
                    FloatingHeader.last_class_given++;
                })
            }
            else
                return false;
        });
        if(found_as_headers + 5 >= trs.length && !$(this_elm).is('.reportcache')) pop_rows = new Array();
       
        var rowCount = this_elm.rows.length;
        var newHtml = '';
        for (var i in pop_rows){
            newHtml += "<tr class=\""+$(pop_rows[i]).attr('class')+"\" style=\""+$(pop_rows[i]).attr('style')+"\">"+$(pop_rows[i]).html()+"</tr>";
        }
        
        if(newHtml){
            newHtml = '<tbody>' + newHtml + '</tbody>';
            
            var tbl = document.createElement('table');
            tbl.parent = this_elm;
            tbl.top_min  = $(this_elm).offset().top;
            tbl.left_min = $(this_elm).offset().left;
            tbl.left_min -= this.viewOffsetLeft();
            tbl.left_max = tbl.left_min+$(this_elm).width();
            
            var style  = ((typeof($(this_elm).attr('style')) != 'undefined') ? $(this_elm).attr('style') : "");
            var classn = ((typeof($(this_elm).attr('class')) != 'undefined') ? $(this_elm).attr('class') : "");
            //var width  = $(this_elm).outerWidth();
            var width  = /*/Chrome/.test(navigator.userAgent) ? $(this_elm).width() :*/ $(this_elm).outerWidth();;
            
            $(tbl).attr('class', "floating_header "+classn);
            $(tbl).attr('style', style+"; border-bottom: none; margin-top: 0;"+(avoid_table_width ? '' : "width: "+width+"px;"));
            $(tbl).attr('cellpadding', $(this_elm).attr('cellpadding'));
            $(tbl).attr('cellspacing', $(this_elm).attr('cellspacing'));
            $(tbl).html(newHtml);
            $(tbl).css('position', "absolute");
            $(tbl).css('top',  tbl.top_min+"px");
            $(tbl).css('left', tbl.left_min+"px");
            $(tbl).css('z-index', z_index);
            $(tbl).removeClass('floating_table_parent');
            this_elm.parentNode.appendChild(tbl);

            //Send clicks from floating to parent...
            $(tbl).find('td, th').click(function(){
            	var myClass = $(this).attr('class').match(/floating_class_\d+/);
            	if(typeof(myClass) == 'undefined' || myClass == null || typeof(myClass[0]) == 'undefined') return;
				$('table.floating_table_parent th.'+myClass[0]).click();
            });
            
            tbl.top_max  = (tbl.top_min+$(this_elm).height()) - ($(tbl).height());
        }
    },
    
    SyncFloatingCellsToParent: function(){
        $('.floating_table_parent .floating_cell').each(function(){
            var w = ($(this).width()+1)+'px';
            var h = $(this).height()+'px';
            var classname = this.getAttribute('class').match(/floating_class_\d+/);
            classname = '.'+classname[0];
            $(classname).css('width', w).css('height', h);
        });
    },
    
    OnScroll: function(){
        FloatingHeader.InvalidateLocations();
    },
    
    OnWindowResize: function(){
		var view = $(FloatingHeader.view());
		var x = view[0].scrollLeft;
		var y = view[0].scrollTop;
		view[0].scrollTop = 0;
		view[0].scrollLeft = 0;
    
        $('.floating_header, .floating_header_h, .colgroup_floating_gen').remove();
        FloatingHeader.MakeAllStaticSized();
        FloatingHeader.MakeAllHorzFloatingHeaders();
        FloatingHeader.MakeAllVertFloatingHeaders();
        FloatingHeader.InvalidateLocations(true);
        
		view[0].scrollLeft = x;
		view[0].scrollTop = y;
    },
    
    view: function(){
    	if(typeof(this._view) == 'undefined'){
	        this._view = $('#subpage > div.section > div.section_content')[0];
	        if(typeof(this._view) == 'undefined') this._view = $('body')[0];	
		}
		return this._view;
	},
    
    viewOffsetLeft: function(){
    	var off = $(FloatingHeader.view()).offset().left;
    	var pl = $(FloatingHeader.view()).css('padding-left');
    	if(typeof(pl) == 'undefined') return off;
    	off += parseFloat(pl.replace(/[^\d\.\-]/gi, ''));
    	return off;
	},
	
	viewOffsetTop: function(){
    	var off = $(this.view()).offset().top;
    	off += parseFloat($(this.view()).css('padding-top').replace(/[^\d\.\-]/gi, ''));
    	if($(this.view()).is('body')){
    		off += $('.uiTaskBarIFrameBackground').height();
		}
    	return off;
	},
    
    viewScrollTop: function(){
    	if($(FloatingHeader.view()).is('body')){
    		var feib = $('#firstElmInBody');
    		if(typeof(feib[0]) != 'undefined')
    			return feib.offset().top * -1;
		}
		return FloatingHeader.view().scrollTop;
	},
    
    viewScrollLeft: function(){
    	var left = 0;
    	if($(FloatingHeader.view()).is('body')){
    		var feib = $('#firstElmInBody');
    		if(typeof(feib[0]) != 'undefined')
    			left = feib.offset().left * -1;
		}
		else
			left = FloatingHeader.view().scrollLeft;
		if(typeof(left) == 'undefined') return 0;
		return left;
	},
	
    InvalidateLocations: function(update_top){
        if(!floating_headers_enabled) return;

        var view = this.view();
        var vscroll = FloatingHeader.viewScrollTop() - 1;
        var hscroll = FloatingHeader.viewScrollLeft();

        $('.floating_header_h').each(function(){
            if(typeof(this.parent) == 'undefined') return;
            
            var top = $(this.parent).offset().top  + vscroll - FloatingHeader.viewOffsetTop() + 1;
            
            $('.ui_message_notice').each(function(){ top -= $(this).fullHeight(); });
            
            $(this).css('top', top+"px");
            $(this).css('position', 'absolute');

            var marg = parseFloat($(this.parent).css('margin-top').replace(/[^\-\d\.]/gi, '')) * -1;
            $(this).css('margin-top', marg+'px');
            
            if(this.left_min < hscroll && this.left_max > hscroll){//Floating position...
                $(this).css('left', hscroll+"px").css('box-shadow', '');
                
                $(this).find('tr:last').find(':first').css('border-bottom-left-radius', '0');
                $(this).find('tr:first').find(':first').css('border-top-left-radius', '0');
                $(this).css('border-bottom-left-radius', '0').css('border-top-left-radius', '0');
                
            }
            else{
                var left = (this.left_max + 4 > hscroll) ? this.left_min : this.left_max;
                $(this).css('left', left+"px").css('box-shadow', 'none');
                $(this).find('tr:last').find(':first').css('border-bottom-left-radius', '');
                $(this).find('tr:first').find(':first').css('border-top-left-radius', '');
                $(this).css('border-bottom-left-radius', '').css('border-top-left-radius', '');
            }
        });

        $('.floating_header').each(function(){
            if(typeof(this.parent) == 'undefined') return;
            if($(this.parent).is('.floating_header_h')) { $(this).hide(); return; }

            //Calc Taskbar Height (for when its a floating taskbar)
            var taskBarHeightOffset = 0;
            var uiTaskBar = $('.uiTaskBar');
            if(typeof(uiTaskBar) != 'undefined')
	            uiTaskBar.each(function(){
	            	if($(this).css('position') == 'fixed' && $(this).css('display') != 'none'){
	            		taskBarHeightOffset += $(this).fullHeight();
					}
	            });
            	
            var viewOffset = $(view).offset();            
            if(update_top){
	            var mt = $(this.parent).css('margin-top');
	            if(typeof(mt) == 'undefined') mt = '0';
	            var marg = parseFloat(mt.replace(/[^\-\d\.]/gi, '')) * -1;
	            $(this).css('margin-top', marg+'px');
	            
            	this.view_offset_top = viewOffset.top;
                this.top_min = $(this.parent).offset().top + vscroll - this.view_offset_top - taskBarHeightOffset; 
                this.top_max = (this.top_min+$(this.parent).height()) - ($(this).height());
                
		        var tableOffsetInView = 0;
		        var offsetParent = $(this.parent);
		        this.tableOffsetInParent =  $(offsetParent).position().top + $($(offsetParent).offsetParent()).scrollTop();
        		for(var _i = 0; _i < 10; _i++){
					if(typeof(offsetParent) == 'undefined' || offsetParent == null || offsetParent.is('html') || offsetParent.is('body') || offsetParent[0] == view) break;
					var inc = $(offsetParent).position().top + $($(offsetParent).offsetParent()).scrollTop();
					tableOffsetInView += inc;
					offsetParent = $(offsetParent).offsetParent();
        		}
        		this.tableOffsetInView = Math.floor(tableOffsetInView - this.tableOffsetInParent);
        		
                $(this).css('position', 'absolute');
            }
        	
            setTop = ((vscroll - this.tableOffsetInView) + taskBarHeightOffset); 
            if(this.top_min < vscroll && this.top_max > vscroll){
                $(this).css('display', 'block');
                $(this).css('top', setTop +'px');

                var left =  FloatingHeader.viewOffsetLeft() + ((this.left_max + 4 > hscroll) ? this.left_min : this.left_max);
                if($(this).offsetParent() != FloatingHeader.view()) left -= $(this).offsetParent().offset().left;
                $(this).css('left', left+"px");
            }
            else{
                $(this).css('display', 'none');
            }
                
            var bw     = (this.parent.style.border.width != 'undefined') ? this.parent.style.border.width : 0;
            var width  =  (($(this).width())+(bw*2));
            $(this).css('width', width+"px");
        });

    }
}

var waitForFinalEvent = (function () {
    var timer_list = {};
    return function (callback, ms, Timer_Id){
        if (!Timer_Id) Timer_Id = "???";
        if (timer_list[Timer_Id]) clearTimeout (timer_list[Timer_Id]);
        timer_list[Timer_Id] = setTimeout(callback, ms);
    };
})();

function UpdateFloatingHeaderPositions(update_top){
    FloatingHeader.InvalidateLocations(update_top);
}
function getInternetExplorerVersion(){
  var rv = -1;
  if (navigator.appName == 'Microsoft Internet Explorer'){
    var ua = navigator.userAgent;
    var re  = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
    if (re.exec(ua) != null)
      rv = parseFloat( RegExp.$1 );
  }
  return rv;
}

function FloatingHeader_On_Doc_Ready(){
    setTimeout('FloatingHeader.Initialize()', 333);

	var view = $(FloatingHeader.view());
    view.scroll(function(){ 
        if(!floating_headers_enabled) return;
        FloatingHeader.OnScroll();
    });
    $(window).resize(function(){
        if(!floating_headers_enabled) return;
        waitForFinalEvent(function(){
            FloatingHeader.OnWindowResize();
        }, 500, "ID_Resize_WaitA");
        waitForFinalEvent(function(){
            FloatingHeader.OnScroll();
        }, 10, "ID_Resize_WaitB");
    });
}

$(document).ready(function(){
	FloatingHeader_On_Doc_Ready();
});