/* Greybox Redux
 * Required: http://jquery.com/
 * Written by: John Resig
 * Based on code by: 4mir Salihefendic (http://amix.dk)
 * License: LGPL (read more in LGPL.txt)
 */

var GB_DONE = false;
var GB_HEIGHT = 400;
var GB_WIDTH = 400;
var GB_ANIMATION = 0;
var greyboxurl = '';
function GB_show(caption, url, height, width) {
  GB_HEIGHT = height || 400;
  GB_WIDTH = width || 400;
  if(url.indexOf('framed_id') == -1) url += (url.indexOf('?') == -1 ? '?' :'&')+'framed_id=GB_frame' ;
  if(!GB_DONE) {
    $(document.body)
      .append("<div id='GB_overlay'></div><div id='GB_window'><div id='GB_caption'></div>"
        + "<img id=\"GB_btnClose\" src='"+greyboxurl+"images/close.png' alt='Close window'/></div>");
    $("#GB_window img").click(GB_hide);
    $("#GB_overlay").click(GB_hide);
    $(window).resize(GB_position);
    GB_DONE = true;
  }

  $("#GB_frame").remove();
  $("#GB_window").append("<iframe id='GB_frame'></iframe>");
  if(typeof(UI) != 'undefined' && typeof(UI.setFrameContentsAsLoading) != 'undefined') UI.setFrameContentsAsLoading($("#GB_frame"));
  $('#GB_frame').attr('src', url);

  $("#GB_caption").html(caption);
  $("#GB_overlay").show();
  GB_position();

  if(GB_ANIMATION)
    $("#GB_window").slideDown("slow");
  else
    $("#GB_window").show();
}

function GB_hide() {
  $("#GB_window,#GB_overlay").hide();

  if (typeof(window.parent.reload_payment_cim) === 'function') {
	  window.parent.reload_payment_cim();
  }
  else if (typeof(window.reload_payment_cim) === 'function') {
	  window.reload_payment_cim();
  }
}

function GB_position() {
  var de = document.documentElement;
  var GB_TOP = GB_HEIGHT >= $(window).height() ? 10 : 54;
  var w = self.innerWidth || (de&&de.clientWidth) || document.body.clientWidth;
  var max_width = $(window).width() - 30;
  var max_height = $(window).height() - (8 + GB_TOP);
  var set_width = (GB_WIDTH < max_width) ? GB_WIDTH : max_width;
  var set_height = (GB_HEIGHT < max_height) ? GB_HEIGHT : max_height;
  
  $("#GB_window").css({width: set_width+"px", height: set_height+"px", left: ((w - set_width)/2)+"px", top: GB_TOP+'px'});
  $("#GB_frame").css("height", set_height - 32 +"px");
}
