
$.editable.lang = [];
$.editable.namepicker_fields = ['company', 'fname', 'mname', 'lname'];

$.editable.addInputType( 'namepicker', {

    element: function( settings, original ) {
        var _form  = this;
        var form   = $(this);
        var hidden = $('<input type="hidden" class="send-value">');
        var table  = $('<table />');

        var data   = $.parseJSON($(original).parents('[type_data]').attr('type_data'));

        for(var i in $.editable.namepicker_fields){
            var f = $.editable.namepicker_fields[i];
            var tr = $('<tr />').addClass('editable-namepicker-'+f);
            var th = $('<th />').text($.editable.lang[f]);
            var td = $('<td />');

            var input = $('<input />').attr( 'autocomplete','off' ).val(data[f]);
            input.type = 'text';
            $(input).blur(function(){
                var self = this;
                setTimeout(function(){
                    var parent = $(self).parents('form')[0];
                    if($(parent).find(':focus').length == 0){//Focus lost
                        _form.submit();
                    }
                }, 100);
            });

            $(input).appendTo(td);
            $(th).appendTo(tr);
            $(td).appendTo(tr);
            $(tr).appendTo(table);
        }

        form.append(hidden).append(table).addClass('editable-namepicker-form');
        return (hidden);
    },

    submit : function (settings, original) {
        var value = '';
        for(var i in $.editable.namepicker_fields){
            var f = $.editable.namepicker_fields[i];
            var i = $(this).find('tr.editable-namepicker-'+f+' input');
            var val = $(i).val();
            value += '&'+f+'='+URL_Param.encode(val);
        }
        $(this).find('.send-value').val(value);
    }

} );
