var UI = {
    /*Vars*/
    mouseConfirmed: false,
    warnOnWindowUnload: true,
    uiView: null,
    mainMenu: null,
    mainMenuMode: 'default',
    defaultPage: null,
    menuType: 'left_wide',
    menuShown: false,
    flyOutTime: 100,
    small_ui_max_width: 980,
    animationSpeedFloatingPanes: 300,
    mobileMenuSlideSpeed: 300,
    leftMenuIconHolderSizeWidth: 40,
    leftMenuIconHolderSizeHeight: 40,
    enableSettingsSearch: false,
    menuIconLeftOffsetCorrection: 4,
    resize_callbacks: [],
    altKeyEvents: [],
    autoHide_FullFrameOverlayView: true,
    suspend_layout: false,
    large_page_mode: false,
    window_width: 0,
    window_height: 0,
    loadFromMenuPageStack: [],
	onWindowResize_UpdateUITaskBar_isAuto: false,
	lastActiveIframeView: null,
	hold_onWindowResize_ResizeUITabsOverflow: false,
	onDocumentReady_Callables: [],
	dataTable_RegisteredTableUse: [],
	
    /*DOM EVENTS*/
    resize: function(func){
        if(typeof(func) == 'function')
            UI.resize_callbacks.push(func);
        else if(typeof(func) == 'undefined')
            UI.onWindowResize();
    },
    onDocumentReady: function(func){
        if(typeof(func) == 'function' && typeof(func.attr) == 'undefined'){
            UI.onDocumentReady_Callables.push(func);
            return;
		}
        UI.window_width  = $(window).width();
        UI.window_height = $(window).height();
        
        UI.createMenu();
        UI.uiView = $('#content');
        if(UI.uiView.length == 0) UI.uiView = $('body');
        UI.uiView.click(function(){ 
            UI.animateLeftMenuSizes(-1); 
            top.UI.hideAllMenuPanes();
            $('.searchHighlighed').removeClass('searchHighlighed');
        });
        UI.uiView.mouseenter(function(){ if(!UI.menuShown){ UI.animateLeftMenuSizes(-1); }});
        if(UI.enableSettingsSearch) UI.startSettingsSearch();
        UI.processView();
        UI.onWindowResize();
        setTimeout('UI.onWindowResize();', 10);
        
        setTimeout(function(){
            //Focus First Found Form/Input
            var textBoxes = $('#section_view form input[type="text"]');
            if(textBoxes.length > 0){
                textBoxes[0].focus();
            }
        }, 15);
        
        //Size Top Menu Logo Container
        var imageSrc = $('.npLogo').css('background-image');
        imageSrc = typeof(imageSrc) != 'undefined' && imageSrc != '' && imageSrc != null ? imageSrc.replace(/url\((['"])?(.*?)\1\)/gi, '$2').split(',')[0] : null;

        // I just broke it up on newlines for readability
        if(imageSrc != '' && imageSrc != null){
            var image = new Image();
            image.src = imageSrc;
            image.onload = function(){
                var width = image.width;
                var height = image.height;
                var maxHeight = $('.npLogo').height();
                var k = maxHeight / height;
                var newW = k*width;
                $('.npLogo').css('width', newW+'px');
                var menuSandwich = $('#uiTopBarMobileSandwich').css('display') != 'none' ? $('#uiTopBarMobileSandwich').fullWidth() : 0;
                var mL = $('.npLogo').css('margin-left');  mL = typeof(mL) != 'undefined' && mL != null ? parseInt(mL.replace(/[^\d]/g, '')) : 0;
                var mR = $('.npLogo').css('margin-right'); mR = typeof(mR) != 'undefined' && mR != null ? parseInt(mR.replace(/[^\d]/g, '')) : 0;
                $('#npLogoHeader').css('width', (menuSandwich+newW+mL+mR)+'px');
                UI.onWindowResize_CenterPageTitle();
            }
            image.onerror = function(){
                $('#pagetitle').css('display', 'inline-block');
                $('#pagesubtitle').css('display', 'inline-block');
            }
        }
        else{
        	$('#pagetitle').css('display', 'inline-block');
        	$('#pagesubtitle').css('display', 'inline-block');
		}
        
        //Hightlight main menu if needed...
        var label = $('#pagetitle').text();
        $('.menu-left .itemText').each(function(){
           if($(this).text() == label){
                $($(this).parents('li')[0]).addClass('activateMenuItem');   
           }
        });
        
        //Show the page's content
        $('#section_view').show();
        
        //Detect Print (Chrome)
        if(typeof(window.matchMedia) != 'undefined'){
            var mediaQueryList = window.matchMedia('print');
            if(mediaQueryList != null){
                mediaQueryList.addListener(function(mql) {
                    if (mql.matches)
                        window.onbeforeprint();
                    else
                        setTimeout(function(){window.onafterprint(false);}, 1000);
                });
            }
            else{
			    $(window).on('beforeprint', window.onbeforeprint);
			    $(window).on('afterprint', window.onafterprint);
			}
        }
        
	    //Place Holder Text for auto-complete boxes
	    $('input.autocomplete').attr('placeholder', STR_AUTOCOMPLETE_PLACEHOLDER);

	    //Prevent <form> double submit
	    $('form').each(function(){
	         if(typeof(this.target) == 'undefined' || this.target == '' || this.target == '_self'){
	         	 if(typeof($(this).attr('newtab')) == 'undefined')
		             $(this).preventDoubleSubmission();
	         }
	         if(typeof(window.active_company) != 'undefined' && this.name != 'company'){
	            $('<input type="hidden" value="'+window.active_company+'" name="submitted_companyid">').appendTo(this);   
	         }
	    });
	    
        for(var i = 0; i < UI.onDocumentReady_Callables.length; i++) UI.onDocumentReady_Callables[i]();
        
        //Search Menu Key Event
        $(document).on('keydown', function ( e ) {
            if(typeof(top.MainMenuSearch) == 'undefined') return;
            if(e.keyCode == 27 && top.MainMenuSearch.isOpened) top.MainMenuSearch.Close();
            if ((e.metaKey || e.ctrlKey) && (e.key == ';' || String.fromCharCode(e.which).toLowerCase() == ';') ) {
                top.MainMenuSearch.Toggle();
            }
        });
    }, 
    onWindowResize: function(){
        UI.window_width  = $(window).width();
        UI.window_height = $(window).height();
        
        if(typeof(window.top) != 'undefined' && window.top != null && window.top.UI.suspend_layout) return;

        var hWindow   = UI.window_height;
        var wWindow   = UI.window_width;
        var hTopMenu  = $('#uiTopBar').height();
        var hView     = hWindow - hTopMenu;
        
        if(wWindow > UI.small_ui_max_width)
            $('body').removeClass('small-ui');
        else if(!$('body').is('.small-ui'))
            $('body').addClass('small-ui');
        
        //Mobile Menus
        var wLeftMenu = 0;
        var leftBackground = $('#uiLeftBarBackground');
        if(leftBackground.length > 0){
            var mTop = leftBackground.css('margin-top');
            mTop = typeof(mTop) == 'undefined' || mTop == null ? 0 : parseInt(mTop.replace(/[^\d]/ig, ''));
            var mBottom = leftBackground.css('margin-bottom');
            mBottom = typeof(mBottom) == 'undefined' || mBottom == null ? 0 : parseInt(mBottom.replace(/[^\d]/ig, ''));
            if(UI.menuType == 'left') leftBackground.css('height', (hView-(mTop+mBottom))+'px');
            else if(UI.menuType == 'left_wide') leftBackground.css('max-height', (hView-(mTop+mBottom))+'px');
            UI.onWindowResize_UpdateLeftBarSize();
            var wLeftMenu = leftBackground[0]._width;
        }
        
        //Top-Menu floating panes
        $('.uiTopBar_FloatingPane').css('max-height', hView+'px');

        if(window.isMobile) UI.MobileHideLeftMenu(true);
        
        //Resize Sub-Functions
        UI.onWindowResize_UpdateUITaskBar();
        UI.onWindowResize_UpdateViewPortal(wLeftMenu, hWindow, wWindow, hTopMenu, hView);
        UI.onWindowResize_ResizeUITabsOverflow();
        UI.onWindowResize_CenterPageTitle();
        UI.onWindowResize_CollapsePopertySets();
        UI.onWindowResize_CollapseTopMenu(wWindow);
        UI.onWindowResize_FullFrameOverlayView();
        UI.hideAllMenuPanes();
        UI.hideAllMenuPanes();
        UI.show_mobile_nav_resize();
        
        for(var i in UI.resize_callbacks) UI.resize_callbacks[i]();
    
		UI.onWindowResize_FixIOSIframeLocations();
    },
    onWindowResize_FixIOSIframeLocations: function(){
	    var isIOS = ua.match( /iPad/i ) || ua.match( /iPhone/i ) || ua.match( /iPod/i ); 
	    if(isIOS){
		    if(typeof(window.frameElement) != 'undefined'){
        		if($(window.frameElement).is('.frame-view')){
        			if(typeof(window.frameElement.parentElement) != 'undefined'){
        				if($(window.frameElement.parentElement).is('.main_index_page_active')){
        					var org_val = $(window.frameElement).css('left');
						    setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 500);
						    setTimeout(function(){ $(window.frameElement).css('left', org_val); },  501);
						    setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 1000);
						    setTimeout(function(){ $(window.frameElement).css('left', org_val); },  1001);
						    setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 2000);
						    setTimeout(function(){ $(window.frameElement).css('left', org_val); },  2001);
						    setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 5000);
						    setTimeout(function(){ $(window.frameElement).css('left', org_val); },  5001);
						}
					}
				}
			}
		}
    },
    onWindowResize_UpdateViewPortal: function(wLeftMenu, hWindow, wWindow, hTopMenu, hView){
        if(typeof(wLeftMenu) == 'undefined') wLeftMenu = $('#uiLeftBarBackground').length > 0 ? $('#uiLeftBarBackground')[0]._width : 0;
        if(typeof(hWindow) == 'undefined')   hWindow   = UI.window_height;
        if(typeof(wWindow) == 'undefined')   wWindow   = UI.window_width;
        if(typeof(hTopMenu) == 'undefined')  hTopMenu  = $('#uiTopBar').height();
        var section_content = $('#section_view');
        var scrollBar = section_content.scrollBarWidth();

        if(window.isMobile) wLeftMenu = 0;
        $('#uiTopBarMobileSandwich').css('display', window.isMobile ? 'inline-block' : 'none');
        if(window.isMobile){
        	$('body').css('position', 'fixed').css('left', '0px').css('top', '0px').css('height', window.availHeight+'px');
        	$('body').css('top', window.innerHeight - window.availHeight + 'px');
		}
        
        var taskBarBack = $('.uiTaskBarBackground');
        var viewWidth = window.isMobile ? wWindow : (wWindow-wLeftMenu);
        taskBarBack.css('width', '100%');
        var taskBarHeight = taskBarBack.css('position') == 'fixed' ? taskBarBack.height() : 0;
        if(typeof(taskBarHeight) == 'undefined' || taskBarHeight == null) taskBarHeight = 0;
        if(typeof(hView) == 'undefined') hView = hWindow - hTopMenu;

        var content = $('#content');
        content.css('height', hView+'px');
        content.css('top', hTopMenu+'px');

        if(section_content.length > 0){
            var padding = section_content.paddingHeight();
            section_content.css('width', viewWidth+'px');
            section_content.css('height', (hView-(taskBarHeight + padding))+'px');
            section_content.css('top', taskBarHeight+'px');
            section_content.css('left', '0px');
            section_content.css('padding-left', wLeftMenu+'px');
        }
        
        var internal_tabs = section_content.children('.main_index_page_container').children('.main_index_internal_tab');
        if(internal_tabs.length > 0){
            var leftBackground = $('#uiLeftBarBackground');
            var lBW = (typeof(leftBackground[0]) != 'undefined' && typeof(leftBackground[0]._width) != 'undefined') ? leftBackground[0]._width : 0;
            var vWidth = UI.window_width - lBW - 24;//section_content.scrollBarWidth()
            var hViewIn = hView/* - 24*/;// section_content.scrollBarHeight();
            if(leftBackground.length > 0){
                internal_tabs.each(function(){
                    //$(this).width(vWidth+'px').height(hViewIn+'px').css('overflow', 'hidden');
                    $(this).children('iframe').width(vWidth+'px').height(hViewIn+'px');
                });
            }
        }
    },
    onWindowResize_CenterPageTitle: function(){
        var pt = $('#uiTopBar #pagetitle');
        if(typeof(pt[0]) == 'undefined' || pt[0].innerHTML == '') return;
        
        var topBarHeight = $('#uiTopBar').height();
        var fontSize = 16;
        
        //Reset Title styles
        pt.css('left', '0px').css('font-size', fontSize+'px').css('white-space', '');
        
        //Find best font-size
        while(pt.height() - 1 > topBarHeight && fontSize > 11){
            fontSize--;
            pt.css('font-size', fontSize+'px')
        }
        
        //Center
        var lg = $('#uiTopBar .npLogo').outerWidth();
        var vs = $('#uiSearchSettingsContainer').css('display') == 'none' ? 0 : $('#uiSearchSettingsContainer').outerWidth();
        var mn = ($('#uiTopBar .uiTopBarMenu').css('display') != 'none') ? $('#uiTopBar .uiTopBarMenu').outerWidth() : 0;
        var tl = pt.outerWidth();
        
        var sz = $('#uiTopBar').width() - (lg+vs+mn);
        var x  = ((sz / 2) - (tl / 2)) + lg + vs;
        
        pt.css('position', 'fixed')
        pt.css('left', x+'px');
        pt.css('top', '0px');
        
        
        //Find best font-size
        while(pt.height() - 1 > topBarHeight && fontSize > 11){
            fontSize--;
            pt.css('font-size', fontSize+'px')
        }
        
        pt.css('white-space', 'nowrap');
    },
    onWindowResize_CollapseTopMenu: function(wWindow){
        if(window.template == 'iframe') return;
        
        //Elms
        var logo = $('#npLogoHeader');
        var pageTitle = $('#pagetitle');
        var menu = $('#uiTopBarMenu');
        
        //Reset
        logo.removeClass('no-logo-background').find('.npLogo').css('display', 'inline-block');
        pageTitle.css('display', 'inline-block');
        $('#pagesubtitle').css('display', 'inline-block');
        
        //Measure
        var pageTitleOffset = pageTitle.offset();
        var pageTitleWidth  = pageTitle.width();
        var menuOffset = menu.offset();
        var menuOffsetLeft = typeof(menuOffset) != 'undefined' ? menuOffset.left : 0;
        var logoWidth = logo.width();
        var pageTitleOffsetLeft = typeof(pageTitleOffset) != 'undefined' ? pageTitleOffset.left : 0;
        
        //Hide as needed
        if(pageTitleOffsetLeft + pageTitleWidth > menuOffsetLeft) pageTitle.hide();
        if(logoWidth > menuOffsetLeft) logo.addClass('no-logo-background').find('.npLogo').hide();
    },
    onWindowResize_UpdateLeftBarSize: function(){
        if(UI.menuType != 'left' && UI.menuType != 'left_wide') return;
        
        //Calc View Sizes
        var ul = $("#uiLeftItems");
        if(ul.length == 0) return;
        var hWindow  = UI.window_height;
        var hTopMenu = $('#uiTopBar').height();
        var htView   = hWindow - hTopMenu;
        var liCount  = $("#uiLeftItems > li").length;
        
        //Account for padding
        var padding = 0;
        var li = $($("#uiLeftItems > li")[0]);
        if(typeof(li.css) != 'undefined'){
            var mt = li.css('marginTop');
            var pt = li.css('paddingTop');
            var mb = li.css('marginBottom');
            var pb = li.css('paddingBottom');
            if(typeof(mt) != 'undefined') padding += parseInt(mt.replace(/[^\d]/gi, ''));
            if(typeof(pt) != 'undefined') padding += parseInt(pt.replace(/[^\d]/gi, ''));
            if(typeof(mb) != 'undefined') padding += parseInt(mb.replace(/[^\d]/gi, ''));
            if(typeof(pb) != 'undefined') padding += parseInt(pb.replace(/[^\d]/gi, ''));
        }
        htView -= (padding * liCount) + (UI.menuType == 'left_wide' ? 10 : 0);
        
        //Calc Icon Sizes
        var maxSize  = UI.leftMenuIconHolderSizeHeight;
        var avgSize  = htView / liCount;
        var minSize  = (htView - maxSize) / (liCount - 1);
        ul[0].maxSize = parseInt(maxSize);
        ul[0].avgSize = parseInt(Math.min(ul[0].maxSize, avgSize));
        ul[0].minSize = parseInt(Math.min(ul[0].avgSize, minSize));
        UI.animateLeftMenuSizes();
        
        $('#content > .uiTaskBarContainer > .uiTaskBarBackground div.uiTaskBar').css('padding-left', window.isMobile ? 0 : $('#uiLeftBarBackground').fullWidth()+'px');
        $('.ui-tabs-panel > .uiTaskBarContainer > .uiTaskBarBackground div.uiTaskBar').css('padding-left', '0px');
    },
    onWindowResize_UpdateUITaskBar: function(){
        if($('.uiTaskBarContainer').is('.uiTaskBarContainerUnderTabs')){//Resize Each in its tab
        	if(!UI.onWindowResize_UpdateUITaskBar_isAuto){
    			UI.onWindowResize_UpdateUITaskBar_isAuto = true;
	            $('.uiTaskBarContainerUnderTabs').css('height', 'auto');
	            $('.uiTaskBarBackground').css('height', 'auto');
	            $('.uiTaskBar').css('height', 'auto');
	        }
		}
        else{//Resize single taskbar
    		UI.onWindowResize_UpdateUITaskBar_isAuto = false;
            var h = $('.uiTaskBarTable').outerHeight();
            $('.uiTaskBarBackground').css('min-height', h+'px');
            $('.uiTaskBarContainer').css('margin-bottom', $('.uiTaskBarBackground').outerHeight()+'px');
        }
        
        //Taskbar In Frame
        $('body > div.uiTaskBarIFrameBackground, #section_view > div.uiTaskBarIFrameBackground, .section_content > div.uiTaskBarIFrameBackground, #content > div.uiTaskBarContainer > div.uiTaskBarBackground').each(function(){
        	var backW = $(this).width(); if(!backW) backW = 99999;
        	var viewW = $(UI.uiView).width(); if(!viewW) viewW = 99999;
			var w = Math.min(backW, viewW);
			var isInBody = $(this.parentNode).is('body');

			if(!isInBody)
				$(this).children('.uiTaskBarTable').css('width', '100%');
			else
				$(this).children('.uiTaskBarTable').css('width', $(this).width()+'px');
        	$(this).height($(this).children('.uiTaskBarTable').height()+'px');
		});

    },
    onWindowResize_CollapsePopertySets: function(){
        if(UI.large_page_mode) return;
        
        var targetViewPortal = $('#section_view');
        if(targetViewPortal.length == 0) targetViewPortal = UI.uiView;
        if(targetViewPortal == null) targetViewPortal = $('body');

        $('.properties_set:not(.no_auto_size)').css('margin-left', '').css('width', '');
        $('.properties_set:not(.no_auto_size) td, .properties_set:not(.no_auto_size) th').css('display', 'table-cell');
        var maxWidth = targetViewPortal.width() - 24;
        $('.properties_set:not(.no_auto_size)').each(function(){
            if($(this).outerWidth() > maxWidth){
                $(this).find('td, th').css('display', 'block');
                $(this).css('margin-left', '0').css('width', maxWidth+'px');
            }
        });
    },
    onWindowResize_FullFrameOverlayView: function(){
        var leftBackground = $('#uiLeftBarBackground');
        if(leftBackground.length > 0){
            $('.frame-overlay-view').width('0px');
            $('.frame-overlay-view').width((UI.window_width - leftBackground[0]._width)+'px').css('left', leftBackground[0]._width+'px');
        }
    },
    onBeforePrint: function(e){
    	
    },
    onAfterPrint: function(e){
    	if(typeof(e) != 'undefined' && e === false) return;
    	top.had_print = true;
    },
    onWindowResize_ResizeUITabsOverflow: function(){
    	if(UI.hold_onWindowResize_ResizeUITabsOverflow) return;
        $('#section_view .ui-tabs-nav:not(.no-resize)').each(function(){
            if(!$(this).is(':visible')) return;
            
            //Vars
            var tabContainer = $(this);
            var window_width = $(tabContainer[0].parentNode).width();
            var tabs = tabContainer.children('li:visible');

            //Reset
            tabContainer.addClass('ui-tabs-nav-multi-line');
            var newW = Math.floor(window_width - (tabContainer.marginWidth() + tabContainer.paddingWidth()));
            tabContainer.css('width', newW+ 'px');
            tabs.css('width', 'auto');

            //Group Groups based on DOM elm wrapping (by y-value)
            var wrappingGroups = {};
            tabs.each(function(){
                if(typeof(this) == 'undefined') return;
                var t = $(this).offset().top;
                if(typeof(t) == 'undefined') return;
                if(typeof(wrappingGroups[t]) == 'undefined') wrappingGroups[t] = [];
                wrappingGroups[t.toString()].push(this);
            });
            var groupCount = 0;
            for(var i in wrappingGroups) groupCount++;
            if(groupCount <= 1){
	            tabContainer.removeClass('ui-tabs-nav-multi-line');
            	return;
			}
            
            //Divide tabs into even groups
            var avg_per_group = Math.ceil(tabs.length / groupCount);
            if(avg_per_group <= 0) avg_per_group = 1;
            var newWrappingGroups = [];
            var c = 0;
            for(var i in wrappingGroups){
                for(var x in wrappingGroups[i]){
                    var li = wrappingGroups[i][x];
                    var line = Math.floor(c/avg_per_group);
                    if(typeof(newWrappingGroups[line]) == 'undefined') newWrappingGroups[line] = [];
                    newWrappingGroups[line].push(li);
                    c++;
                }
            }
            wrappingGroups = newWrappingGroups;
            
            //Size Each <li>
            var targetWidth = newW;
            var c = 0;
            for(var t in wrappingGroups){
                if(typeof(wrappingGroups[t]) == 'undefined') continue;
                
                //Get Current Width of tabs in this row...
                var currentWidth = 0;
                for(var i in wrappingGroups[t]) currentWidth += Math.floor($(wrappingGroups[t][i]).outerWidth());
                
                //Apply Extra Width to each...
                var addWidth = Math.floor(((targetWidth - currentWidth) / wrappingGroups[t].length));
                var appliedWidth = 0;
                var last_i = null;
                for(var i in wrappingGroups[t]) last_i = i;
                for(var i in wrappingGroups[t]){
                	var w    = Math.ceil($(wrappingGroups[t][i]).width());
                	var setW = Math.floor(w + addWidth);
                	if(last_i == i){
                		$(wrappingGroups[t][i]).width('0px');
                		setW = Math.floor(targetWidth - appliedWidth - ($(wrappingGroups[t][i]).outerWidth()));
					}
                    $(wrappingGroups[t][i]).width(setW+'px');
                    appliedWidth += Math.floor($(wrappingGroups[t][i]).outerWidth());
                }
                c++;
            }
            
        });
    },
    
    /*UI.load Page Methods*/
    load: function(href_or_elm, elm, as_template, ignore_target, dont_open_new_ui_tab, is_redirect){
        //Default
        if(typeof(href_or_elm) == 'object' && typeof(href_or_elm.jquery) != 'undefined') href_or_elm = href_or_elm[0];
        if(typeof(dont_open_new_ui_tab) == 'undefined' || dont_open_new_ui_tab == null) dont_open_new_ui_tab = true;
        if(typeof(as_template) == 'undefined' || as_template == '' || as_template == null) as_template = window.template;
        if(typeof(ignore_target) == 'undefined' || ignore_target == '' || ignore_target == null) ignore_target = false;
        if(typeof(is_redirect) == 'undefined' || is_redirect == '' || is_redirect == null) is_redirect = false;

        //Get Elm
        if(typeof(href_or_elm) == 'object'){
            href = href_or_elm.href; 
            elm  = href_or_elm;
        }
        else{
            elm = $('<a>').addClass('ui-load-gen')[0];
            elm.href = href_or_elm;
            href = href_or_elm;
        }

        //Nav
        var target = $(elm).attr('target');
        if(target && !ignore_target){
            var a = $('<form>');
            a.attr('action', href);
            a.attr('target', target);
            a.attr('method', 'post');
			a.appendTo('body');
			if(href.match(/[\?&]trackdownload=1/)){
				a.attr('trackdownload', '1');
				UI.processView_FormTrackDownload();
			}
            a[0].submit();
        }
        else{
            if(as_template != '' && !href.match(/(&|\?)tmpl=/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl='+as_template;
            UI.Navigate(elm, href, null, $(elm).parents((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView'), dont_open_new_ui_tab, is_redirect);
        }
        
        return false;
    },
    popup: function(url_or_elm, name, specs, replace_history, do_not_append_caller_one){

        //Default Values
        var elm  = null;
        var href = url_or_elm;
        if(typeof(url_or_elm) == 'undefined' || url_or_elm == null) url_or_elm = location.href;
        if(typeof(specs) == 'undefined' || specs == null) specs = {};
        if(typeof(name) == 'undefined' || name == null) name = '_blank';
        if(typeof(replace_history) == 'undefined' || replace_history == null) replace_history  = false;
        if(typeof(do_not_append_caller_one) == 'undefined' || do_not_append_caller_one == null) do_not_append_caller_one  = false;
        
        //Parse Href
        if(typeof(href) != 'string'){
            elm = href;
            if(typeof(url_or_elm.href) != 'undefined')
                href = elm.href;
            else if(typeof(url_or_elm.action) != 'undefined')
                href = elm.action;
            else if(typeof(url_or_elm.src) != 'undefined')
                href = elm.src;
            else
                href = location.href;
        }
        //if(!do_not_append_caller_one && !href.match(/(\?|&)caller=1/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&')+'caller=1';

        //Set Specs (width, height, toolbars, etc...)
        if(typeof(specs) == 'string'){
            var _specs = {};
            var cParts = specs.split(',');
            for(var i in cParts){
                var kvp = cParts[i].split('=',2);
                if(kvp.length >= 2)
                    _specs[kvp[0]] = kvp[1];
            }
            specs = _specs;
        }
        
        var w = Math.min(screen.width, 800);
        var l = (screen.width - w) / 2;
        var _specs = {
            top: 0,
            left: l,
            width: w,
            height: screen.height,
            toolbar: null,
            scrollbars: 1,
            menubar: null,
            location: 0,
            resizable: 1,
            channelmode: null,
            directories: null,
            fullscreen: null,
            status: null,
            titlebar: 1,
            dependent: 1
        }
        for(var i in specs) _specs[i] = specs[i];
        var sSpecs = '';
        for(var i in _specs){
            if(_specs[i] == null) continue;
            sSpecs += i+'='+_specs[i]+',';
        }

        //Open the window
        var win = window.open(href, name, sSpecs, replace_history);
        win.focus();
        return win;
    },
    browserTab: function(url){
        var form = document.createElement("form");
        form.method = "POST";
        form.action = url;
        form.target = "_blank";
        document.body.appendChild(form);
        form.submit();
    },
    viewReady: function(func){
        if(confirm(func))
            func();
        return $(document);
    },
    viewShown: function(view_iframe, func){
    	if(typeof(view_iframe.onViewShown) == 'undefined') view_iframe.onViewShown = [];
    		
    	if(typeof(func) != 'undefined'){
    		view_iframe.onViewShown.push(func);
		}
		else{
    		UI.lastActiveIframeView = view_iframe.id;
			for(var i = 0; i < view_iframe.onViewShown.length; i++) view_iframe.onViewShown[i]();
		}
	},
    processView: function(txt){
        viewReadyStack = [];
        var view = $('#content');
        if(view.length == 0) view = $('body');
        
        UI.processView_ElementsStyle();
        
        //Datatables
        view.find('table.data:not(.dataTable):not(.floating_header)').attr('cellpadding', '0').attr('cellspacing', '0').each(function(){
            var thead = $(this).find('thead');
            if(thead.length == 0) return;
            if(thead.find('[rowspan]').length != 0) return;
            
            $(this).dataTable({
                "aaSorting": [[ 0, "desc" ]],
                "bAutoWidth": false
            })
        });

        UI.processView_GetInfoFromFooter();
        UI.processView_createAcordianFieldSets();
        MetaMenu.processView_createMetaMenus();
        UI.processView_uiTaskBar();
		UI.processView_SetNavHooks();
		UI.processView_FormTrackDownload();
        UI.processView_SetAltKeyShortcuts();
        UI.processView_CollapseMobileTables();
        UI.processView_AlphaSortPropTables();
        UI.processView_ConvertMissingTHeadTables();
        UI.onWindowResize();
        
        setTimeout('UI.processView_PostDocumentLoad()', 100);
    },
    processView_ElementsStyle: function(section){
    	if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu){
    		if(typeof(window.processView_ElementsStyle_noCBFix) == 'undefined'){
    			$('<style type="text/css"> input[type="checkbox"]:not(.system-style) { display: inline-block !important; height: auto !important; visibility: visible !important; width: auto !important; } </style>').appendTo( "head" )
    			window.processView_ElementsStyle_noCBFix = true;
			}
    		return;
		}
    	
    	var view = null;
    	if(typeof(section) == 'undefined'){
    		view = $('#content');
	        if(view.length == 0) view = $('body');
		}
		else{
	        view = $(section);
		}
        
        //Checkboxes
        view.find('input[type="checkbox"]:not(.system-style):not(.was-styled)').addClass('was-styled').after($('<span class="checkboxOverlay"></span>'));
        $('.checkboxOverlay:not(.event-set)').each(function(){
			var cb = $($(this).prev()[0]);
			$(this).attr('title', cb.attr('title'));
        });
        $('.checkboxOverlay:not(.event-set)').addClass('event-set').click(function(){
            var cb = $($(this).prev()[0]);
            if(cb.is('[readonly]')) return;
            cb.click();
            
            if(document.selection)
                document.selection.empty();
            else
                window.getSelection().removeAllRanges();
            
        });
        
        //Radios
        view.find('input[type="radio"]:not(.system-style):not(.was-styled)').addClass('was-styled').after($('<span class="radioOverlay"></span>'));
        $('.radioOverlay:not(.event-set)').addClass('event-set').each(function(){
            var cb = $(this).prev()[0];
            $(cb).change(function(){
                if($(this).is(':checked')){
                    $('input[type="radio"][name="'+$(this).attr('name')+'"]').removeAttr('checked').each(function(){this.checked=false;});
                    $(this).attr('checked', 'checked');
                    this.checked = true;
                }
            });
        }).click(function(){
            var cb = $($(this).prev()[0]);
            if(cb.is('[readonly]')) return;
            $(cb).click();
            if(document.selection)
                document.selection.empty();
            else
                window.getSelection().removeAllRanges();
        });
        
        //Select Boxes
        view.find('select:not(.system-style):not(.was-styled)').addClass('was-styled').each(function(){
            if(typeof($(this).attr('multiple')) != 'undefined' || typeof($(this).attr('size')) != 'undefined'){
return;
                //$(this).addClass('selectlist');
                //$(this).replaceWith($('<div class="selectListOverlay">').append($(this).clone()));
            }
            else{
	            var originalID = $(this).attr('id');
	            var originalName = $(this).attr('name');
	            
	            //Read-only select boxes by hiding and linking to shown disabled select box
                if($(this).is('[readonly]') && (originalID || originalName)){
	                
	                var actualSelect = $(this).clone();
	                $(this).attr('disabled','disabled');
	                $(this).parent().append(actualSelect);
	                $(actualSelect).hide();
	                
                    if(originalID){
                        //link the changes by id
	                    var disabledID = originalID+'_disabled';
	                    $(this).attr('id',disabledID);
                        $(actualSelect).change(function(){
                            var findID = $(this).attr('id')+'_disabled';
                            $('#'+findID.replace(/\[/g,'\\[').replace(/]/g,'\\]')).val($(this).val());
                        });
                    } else {
	                    //link the changes by name
	                    var disabledName = originalName+'_disabled';
	                    $(this).attr('name',disabledName);
	                    $(actualSelect).change(function(){
		                    var findName = $(this).attr('name')+'_disabled';
		                    $('select[name='+findName.replace(/\[/g,'\\[').replace(/]/g,'\\]')+']').val($(this).val());
	                    });
                    }
                }
	            //system styling
	            $(this).addClass('selectbox');
	            var elm = $('<div>');
	            elm.addClass('selectOverlay');
	            elm.attr('style', $(this).attr('style'));
	            elm.css('display', 'inline-block');
	            $(this).replaceWith(elm.append($(this).clone()));
            }
        });
        
    },
    processView_GetInfoFromFooter: function(){
        $('#footer_QuickLinks').appendTo($('#uiTopBar_LinkPane'));
        $('#footer_HelpLinks').appendTo($('#uiTopBar_HelpPane').empty());
        if($('#uiTopBar_HelpPane a').length == 0) $('#uiTopBarMenuItems .btnHelp').hide();
        if($('#uiTopBar_LinkPane a').length == 0) $('#uiTopBarMenuItems .btnLinks').hide();
        $('<div class="version_text_in_help"><a newtab href="upgrade.php">'+PRODUCT_NAME+' v'+NUMBER_VERSION+'.'+BUILD_VERSION+'</a></div>').appendTo($('#uiTopBar_HelpPane'));
        
    },
    processView_PostDocumentLoad: function(){

        //Tabs click on LI vs A tag
        $('ul.ui-tabs-nav > li').css('cursor', 'pointer');
        $('ul.ui-tabs-nav > li > a').css('text-decoration', 'none');
		$('ul.ui-tabs-nav > li').click(function(event){
			var ul = $(this).parent('ul');
			if($(ul).is('.tabs-emulated')){
				UI.load($(this).find('a')[0]);
			}
			else{
				var div = ul.parent('div');
				div.tabs({ active: $(this).index() });
			}
			UI.resize();
			return false;
		});
        
        $('ul.ui-tabs-nav').contents().filter(function() {
            return this.nodeType == 3; //Node.TEXT_NODE
        }).remove();
    },
    processView_createAcordianFieldSets: function(){
        if(UI.large_page_mode) return;
        
        if(!window.no_adv_options && !window.slow_cpu){
            //Show Advanced in own section
            $(".jqui_accordion").accordion(
                {
                	header:'h3',
                    autoHeight: false,
                    heightStyle: "content",
                    change: function(event, ui){
                        this.activePane = $(ui.oldContent[0]).is('.advanced_body') ? 1 : 2;
                    }
                }
            );
            $(".advanced.ui-accordion-header").click(function(){
                var basic = $(this.parentNode).find('.basic')[0];
                
                if(typeof(this.advText)   == 'undefined') this.advText = $(this).html();
                if(typeof(this.basicText) == 'undefined') this.basicText = $(basic).html();
                if(typeof(this.parentNode._activePane) == 'undefined') this.parentNode._activePane = 1;
                
                if(this.parentNode._activePane == 2){
                    this.parentNode._activePane = 1;
                    $(basic).click();
                    $(this).html(this.advText);
                }
                else{
                    this.parentNode._activePane = 2;
                    $(this).html(this.basicText);
                }
            });
        }
        else{
            //No advanced section
            $('.jqui_accordion h3.advanced').hide();
        }
    },
    processView_uiTaskBar: function(){
    	
        var btnId       = 0;
        var elm_SelectA = '#section_view '+(UI.mainMenuMode == 'main_index' ? '.main_index_page' : '')+' .uiTaskBar';
        var elm_SelectB = '#section_view .uiTaskBarConvertOld';
        var elms = $(elm_SelectA+', '+elm_SelectB);
        if(elms.length > 0){
            elms.each(function(){
                var elm = $(this); var isOld = elm.is('.uiTaskBarConvertOld');
                var showOnlyInTabs = elm.is('.uiTaskBarShowOnlyInTabs');
                
                var parent = null;
                if(UI.mainMenuMode == 'main_index')
                    parent = elm.parents('.main_index_page')[0];
                else
                    parent = $('#content')[0];
                        
                var floatingDivContainerCreated = false;
                var floatingDivContainer = $(parent).find('.uiTaskBarContainer')[0];
                if(typeof(floatingDivContainer) == 'undefined'){
                    floatingDivContainer = document.createElement('div');
                    floatingDivContainerCreated = true
                    $(floatingDivContainer).addClass('uiTaskBarContainer');
                    $(floatingDivContainer).css('height', 0).css('overflow', 'visible');
                    if(showOnlyInTabs){
                        $(floatingDivContainer).css('display', 'none');
                    }
                    
                    var floatingDiv = document.createElement('div');
                    $(floatingDiv).addClass('uiTaskBarBackground');
                    $(floatingDiv).attr('id', floatingDiv.id);
                    $(floatingDiv).appendTo(floatingDivContainer);
                    
                    //Append Copy...
                    if(floatingDivContainerCreated){
						$(floatingDivContainer).prependTo(parent);
					}
                }
                
                elm.find('input, a').each(function(i){
                    if(typeof(this.id) == 'undefined' || this.id == '') this.id = 'uiTaskBar_'+btnId.toString();
                    btnId++;
                });
                
                var copy = elm.clone(true, true);
                copy.find('input, a').addClass('uiTaskBarCloneElm').each(function(){
                    this.id += '_clone';   
                });

                if(isOld){
                    var rows = copy.find('tr');
                    if(rows.length != 2){
                        log('UI ERROR: Failed to convert the following to uiTaskBar, table should be 2 rows.');
                        log(elm);
                        return;
                    }
                    
                    a = [];
                    icons = [];
                    texts = [];
                    
                    $(rows[1]).find('th, td').each(function(i){
                        texts[i] = $(this).html();
                    });
                    
                    $(rows[0]).find('th, td').each(function(i){
                        if($(this).find('a').length > 0){
                            icons[i] = $($(this).find('a')[0]).clone();
                        }
                        else{
                            icons[i] = $($(this).find('img, input[type="image"]')[0]).clone();
                        }
                        $(icons[i]).attr('td_class', $(this).attr('class')).addClass("taskBarClickEventElm");
                    });
                    
                    var divTaskBarTable = null;
                    divTaskBarTable = $('.uiTaskBarConvertedFromOld')[0];
                    if(typeof(divTaskBarTable) == 'undefined'){
                        divTaskBarTable = $(document.createElement('div'));
                        divTaskBarTable.addClass('uiTaskBar uiTaskBarTable uiTaskBarConvertedFromOld');
                        divTaskBarTable.appendTo(floatingDiv);
                    }

                    for(var i = 0; i < icons.length; i++){
                        var divButton = $(document.createElement('div'));
                        divButton.attr('class', $(icons[i]).attr('td_class'));
                        divButton.addClass('uiTaskBarButton');
                        divButton.addClass('uiTaskBarButtonFor_0');
                        divButton.append(icons[i]);
                        divButton.append(texts[i]);
                        divButton.appendTo(divTaskBarTable);
                        divButton.click(function(event){
                        	
							//Prevent Double Click
							if(!$(this).is('.no-click-limit')){
								var tempFnc = function(){
									minElapsedTime = 1500;
									if(typeof(this.lastClickEventTime) == 'undefined') this.lastClickEventTime = 0; var now = (new Date()).getTime(); var span = now - this.lastClickEventTime; if(span < minElapsedTime) return true; this.lastClickEventTime = now; UI.fadeOutAndIn(this); return false;
								}
								if((tempFnc).bind(this)()) return true;
							}
                        	
                            var alink = $(this).find('.taskBarClickEventElm')[0];
                            event.stopImmediatePropagation();
                            event.preventDefault();
                            event.stopPropagation();
                            var id = alink.id.replace(/_clone$/, '');
                            var p  = $('#'+id);
                            if(p.length > 0){
                                p[0].click();
                            }
                            else if(typeof(alink) != 'undefined'){
                                $(alink).click();
                            }
                        });
                    }
                    
                    $(divTaskBarTable).find('.uiTaskBarTableClearFloats').remove();
                    $(divTaskBarTable).append($('<div style="clear:both; width: 1px;" class="uiTaskBarTableClearFloats"></div>'));
                }
                else{
                    copy.appendTo(floatingDiv);
                }
                    
                $(floatingDiv).find('input, a').each(function(){
                    $(this).data('onclick', this.onclick);
                    if($(this).is('input')) $(this).attr('onclick', 'return false;');
                    else $(this).attr('onclick', '');
                    $(this).onclick = function(event){ };
                });

                elm.hide();
            });
        }
        
        $('#uiSearchSettings').keyup(function(e){
			if (e.keyCode == 27){
				$(this).val('');
			}
        });
    },
    processView_SetNavHooks: function(){
        //Set target for <a> & <form> 
        $('a:not(.nav-animated-link), form:not(.nav-animated-form)').each(function(){
            if(window.template != 'iframe'){//Normal Page Load
                if(typeof($(this).attr('tab')) != 'undefined' && typeof($(this).attr('target')) == 'undefined'){
                    this.target = '_blank';
                    $(this).attr('target', this.target);
                }
            }
            else{//Am running in IFrame
                if(typeof($(this).attr('self')) != 'undefined' && typeof($(this).attr('target')) == 'undefined'){
                    this.target = '_self';
                    $(this).attr('target', this.target);
                }
                
                var urlIsLink = typeof(this.href) != 'undefined' && this.href != '' && this.href.indexOf('#') == -1 && this.href.indexOf('javascript:') != 0;
                var targetsSelf = typeof(this.target) == 'undefined' || this.target == '' || this.target == '_self';
                if(urlIsLink && targetsSelf){
                    var href = this.href;
                    if(!href.match(/(&|\?)tmpl=/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe';
                    this.href = href;
                }
            }
        });
        
        $('a:not(.nav-animated-link)').each(function(){
            $(this).addClass("nav-animated-link");
            
            var isTab           = typeof($(this).attr('newtab')) != 'undefined';
            var isMainViewFrame = top.UI.mainMenuMode    == 'main_index' && window != top && $(window.frameElement).is('.staticFrame');
            var targetsSelf     = typeof(this.target)    == 'undefined' || this.target == '' || this.target == '_self';
            var urlIsLink       = false;
            if(typeof(this.href) != 'undefined'){
            	var __link = '';
            	try{ __link = this.href; }
				catch(err) { if(err.message.indexOf('A security problem occurred.') == 0) log("[UI.processView_SetNavHooks() EXCEPTION OK] "+err.message); else log(err); }
	            if(__link != '')
	            	if(__link.indexOf('#') == -1)
	            		if(__link.indexOf('javascript:') != 0)
	            			urlIsLink = true;
			}
            var isMainUITabChild = $(this).parents('.main_index_page').length > 0;
            
            //Open in Internal Tab?
            if(top.UI.mainMenuMode == 'main_index'){
	            if(((isMainViewFrame && targetsSelf) || isTab || isMainUITabChild) && urlIsLink){
	                $(this).click(function(event){
	                    //Event not canceled
	                    if(!event.isPropagationStopped() && !event.isImmediatePropagationStopped() && !event.isDefaultPrevented()){
	                        if(typeof(this.lastClick) == 'undefined') this.lastClick == null;
	                        var d = new Date();
	                        var now = d.getTime();
	                        if(this.lastClick != now){//Prevent double event fire (IT BURNS!!)
	                            this.lastClick = now;
	                            var href = this.href;

	                            //Get the new tab's temporiay title
	                            var title = false;
	                            {
		                            //Get from <a>'s t4ext
		                            title = $(this).contents().filter(function(){return this.nodeType === 3;})[0];
		                            if(typeof(title) != 'undefined') title = $(title).text();
		                            else title = false;
		                            //Get from a's title attribute
		                            if(title == null || title == '' || title == false){
	                            		title = $(this).attr('title');
									}
		                            //Get from a > img's title attribute
		                            if(title == null || title == '' || title == false){
	                            		var img = $(this).find('img[title]');
	                            		if(img.length > 0){
	                            			title = img.attr('title');
										}
									}
		                            //Get from a > img's alt attribute
		                            if(title == null || title == '' || title == false){
	                            		var img = $(this).find('img[alt]');
	                            		if(img.length > 0){
	                            			title = img.attr('alt');
										}
									}
									//Default to "loading..."
			                        if(title == null || title == '' || title == false){
	                            		title = window.STR_LOADING+'...';
									}
								}
	                            top.UI.loadInternalTab(href, title);
	                            
	                            event.preventDefault();
	                            event.stopPropagation();
	                            event.stopImmediatePropagation();
	                            return false;
	                        }
	                    }
	                });
	            }
			}
			else if((urlIsLink && top.UI.mainMenuMode == 'main_index') || isTab){
				$(this).attr('target', '_blank');	
			}
        });
        
        $('form:not(.nav-animated-form)').each(function(){
            $(this).addClass("nav-animated-form");
            var isTab  = typeof($(this).attr('newtab')) != 'undefined';
            if(isTab){
	            if(top.UI.mainMenuMode != 'main_index') $(this).attr('target', '_blank');
	            else {
	            	$(this).submit(function(){
						var frame = top.UI.loadInternalTab('about:blank', '...');
						$(this).attr('target', $(frame).attr('name'));
						this.reAllowSubmit();
	            	});
				}
			}
			
            var target = $(this).attr('target');
            var action = $(this).attr('action');
            
            if((typeof(target) == 'undefined' || target == null || target == '' || target == '_self') 
            && (typeof(action) == 'string' && action != '' && action != null && action.indexOf('#') == -1 && action.indexOf('javascript:') != 0)){

                if(window.template != '' && !action.match(/(&|\?)tmpl=/i)){
                    action += (action.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl='+window.template;
                    $(this).attr('action', action);
                    var input = $('<input type="hidden" name="tmpl" value="'+window.template+'">');
                    input.appendTo(this);
                }
                
                $(this).submit(function(event){
                    var parentTabs = $(this).parents((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView');
                    if(parentTabs.length > 0 && !action.match(/(&|\?)tmpl=/i)) action += (action.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&')+'tmpl=iframe';
                    $(this).attr('action', action);
                    return UI.Navigate(this, action, event, parentTabs);
                });
            }
        });
    },
    processView_SetAltKeyShortcuts: function(){
    	if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
        $('#uiLeftItems .itemText').each(function(){ UI.AssignAltKey(this); });
    },
    processView_ajaxSuccess: function(){
        UI.processView_ElementsStyle();
    },
    processView_CollapseMobileTables: function(){
    	if(window.isMobile){
    		$('table.mobile_collapse').each(function(){
    			
			    //Find Title & Headers
			    var Title = '';
			    var HeaderRow = null;
			    {
					var header_rows = new Array();
				    var trs = $(this).children('thead').children('tr');
				    var found_as_headers = 0;
				    trs.each(function(index){
				        //Check if is header row
				        var isHeaderRow = (this.childNodes.length > 0);
				        for(var i = 0; i < this.childNodes.length; i++){
				            var node = this.childNodes[i];
				            if(typeof(node.tagName) != 'undefined'){
				                var tag  = node.tagName.toLowerCase();
				                if(tag != "th" && !$(node).hasClass('sub_header')){
				                    isHeaderRow = false;
				                    break;
				                }
				            }
				        }
				        if(isHeaderRow){
				        	found_as_headers++;
				        	header_rows.push(this);
						}
				    });
				    if(found_as_headers == 0){
			    		return;	
					}
					else if(found_as_headers > 2){
			    		return;	
					}
				    else if(found_as_headers == 1){
			    		HeaderRow = header_rows[0];
					}
					else{
			    		Title = $(header_rows[0]).text();
			    		HeaderRow = header_rows[1];
					}
				}
			    			    
			    //Generate HTML control
			    var table = $('<table style="margin-top: 24px;" id="'+get_uuid()+'" class="report mobile_collapse_control notablesorter nofloat"><tbody></tbody></table>');
			    table.insertAfter(this);
			    table[0].active_row = -1;
			    table[0].parent = this;
			    table[0].header_title = 'test'+ Title;
			    table[0].header_row = HeaderRow;
			    table[0].data_length = $(this).children('tbody').children('tr').length;
			    UI.MobileCollapsedTableOpenRecord(table[0], 0);
    		});
		}
	},
	processView_AlphaSortPropTables: function(){
		$('.properties_table_alphasort').each(function(){
			if(typeof(this.properties_table_alphasort_once) == 'undefined') this.properties_table_alphasort_once = false;
			if(this.properties_table_alphasort_once) return;
			this.properties_table_alphasort_once = true;
			var tbodies = $(this).children('tbody').length > 0 ? $(this).children('tbody') : $(this);
			tbodies.each(function(){
				var trs = $(this).children('tr');
				var trBuffer = new Array();
				
				//Get <tr>s to sort
				trs.each(function(){
					var keyText = null;
					if($(this).attr('sortkey') != null) keyText = $(this).attr('sortkey');
					else if($(this).find('label').length > 0) keyText = $(this).find('label').text();
					else if($(this).find('th').length > 0) keyText = $(this).find('th').text();
					else keyText = $(this).find('td').text();
					trBuffer.push({
						key: keyText,
						tr: this
					});
				});
				
				//Sort the buffer
				trBuffer.sort(function(a, b){
				    if(a.key < b.key) return -1;
				    if(a.key > b.key) return 1;
				    return 0;
				})
				
				//Append Sorted DOM <tr>s
				for(var i in trBuffer){
					var tr_elm = trBuffer[i].tr;
					$(this).append(trBuffer[i].tr);
				}
			});
			
		});
	},
	processView_FormTrackDownload: function(){
		//Only for <form>s in <iframe> views
		if(typeof(window.frameElement) == 'undefined') return;
		//Hook all <form trackdownload> elements
		$('form[trackdownload]:not(.trackdownload_hooked)').each(function(){
			//Don't hook twice
			$(this).addClass('trackdownload_hooked');
			//Wrap the <form>.submit() with our hook
			this._processView_FormTrackDownload_submit = this.submit;
			this.submit = (function(a,b,c,d,e){ top.UI.processView_FormTrackDownload_formOnSumbit.call(this, a, b, c, d, e); }).bind(this);
		});
	},
	processView_FormTrackDownload_formOnSumbit: function(a,b,c,d,e){
		//Append tracking ID
		window.processView_FormTrackDownload_uuid = get_uuid();
		window.processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
		$('<input type="hidden" name="form_track_download_uuid">').val(window.processView_FormTrackDownload_uuid).appendTo(this);

		//Get Frame Object
		var _frame = typeof(this.ownerDocument.defaultView) != 'undefined' ? this.ownerDocument.defaultView.frameElement : this.ownerDocument.parentWindow.frameElement;
		if(typeof(_frame) == 'undefined' || _frame == null){
			if(typeof($(this).attr('target')) != 'undefined' && typeof(window.frames[$(this).attr('target')]) != 'undefined' && typeof(window.frames[$(this).attr('target')].frameElement) != 'undefined')
				_frame = window.frames[$(this).attr('target')].frameElement;
		}
		if(typeof(_frame) == 'undefined' || _frame == null)
			_frame = window.frameElement;

		//Submit
		var result = this._processView_FormTrackDownload_submit(a,b,c,d,e);
		if(typeof(result) == 'undefined' || result !== false){
			//Show as loading
			top.UI.setFrameContentsAsLoading(_frame);
			//Watch for complete signal
			window.processView_FormTrackDownload_IsComplete = false;
			window.processView_FormTrackDownload_functionCheckIsComplete = (function(){
				var url = NP_BASE_URL+IMAGE_UPLOAD_DIR+'/temp/frmDownload.'+window.processView_FormTrackDownload_uuid+'.tmp';
				$.fetch(url, 
					function(r){ 
						//Success, file found
						window.processView_FormTrackDownload_lastSuccess = (new Date()).getTime();

						//Complete
						if(r != '0'){
							var setTitle = null;
							var setSubTitle = null;
							if(r != '1'){
								var lines = r.split("\n");
								setTitle = typeof(lines[0]) == 'undefined' ? null : lines[0];
								setSubTitle = typeof(lines[1]) == 'undefined' ? null : lines[1];
							}
							window.processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(_frame, setTitle, setSubTitle);
						}
					},
					function(){
						//Timeout, never found the tracking file...
						if((new Date()).getTime() - window.processView_FormTrackDownload_lastSuccess > 8000 /*8s*/){
							window.processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(_frame);
						}

						//Try again...
						else if(!window.processView_FormTrackDownload_IsComplete){
							setTimeout(window.processView_FormTrackDownload_functionCheckIsComplete, 1000);
						}
					});
			});
			window.processView_FormTrackDownload_functionCheckIsComplete();
		}
    },
    processView_ConvertMissingTHeadTables: function(){
        //Add <thead> to all .report tables that don't already have one
        //--Look at all report tables
        $('table.report').each(function(){
			//Skip floating headers
			if($(this).is('.floating_header') || $(this).is('.floating_header_h')) return;
            //Exclude tables that already have a <thead>
            if($(this).children('thead').length > 0) return;
            
            //Get the header rows
            var pop_rows = new Array();
            var trs = $.merge($(this).children('tr'), $(this).find('tbody > tr'));
            var found_as_headers = 0;
            trs.each(function(index){
                if(found_as_headers > 5) return false;//Too many <thead> rows...
                //Check if is header row
                var isHeaderRow = (this.childNodes.length > 0);
                for(var i = 0; i < this.childNodes.length; i++){
                    var node = this.childNodes[i];
                    if(typeof(node.tagName) != 'undefined'){
                        var tag  = node.tagName.toLowerCase();
                        if(tag != "th" || $(node).hasClass('nofloat') || $(node).hasClass('sub_header')){
                            isHeaderRow = false;
                            break;
                        }
                    }
                }
                if(isHeaderRow){
                    found_as_headers++;
                    pop_rows[index] = this;
                }
                else
                    return false;
            });
            
            //No Header found?
            if(pop_rows.length == 0) return;

            //Add <thead> to report table
            $(this).addClass('AutoTHead');
            var thead = $('<thead>');
            $(this).prepend(thead);

            //Move the <tr>s to the <thead>
            for(var i in pop_rows){
                $(pop_rows[i]).detach().appendTo(thead);
            }

            //Format the first <tbody> row
            //--Find first <tr>
            var firstTbodyRow = thead.next();
            if(typeof(firstTbodyRow) == 'undefined') return;
            if(firstTbodyRow.is('tbody') || firstTbodyRow.is('tfoot')) firstTbodyRow = $(firstTbodyRow[0].children[0]);
            //--No Round always
            firstTbodyRow.children('td, th').addClass('no-round');
            //--Sub header type <tr>
            if(firstTbodyRow.children('td.sub_header, th.sub_header').length > 0) firstTbodyRow.addClass('sub_header');

            //Set HTML2PDF <tr> header count
            var parentNode = this.parentNode;
            if($(parentNode).is('form')) parentNode = parentNode.parentNode;
            $(parentNode).children('#form_pdf_generate').append($('<input type="hidden" name="AutoTHeadCount" value="'+pop_rows.length+'">'));
        });
    },
    
    /*Menu Methods*/
    createMenu: function(){
        if(UI.mainMenu == null) { return; }
        if($('#uiLeftBar').length == 0) return;
        if($('#uiLeftBar > *').length != 0) return;
        $('#uiLeftBar').addClass('menu-type-'+UI.menuType);
        UI.mainMenu.createMenu(UI.menuType);
        UI.onWindowResize();
    },
    createMenu_sub: function(menu, elm){
        for(var m in menu.items){
            if(parseInt(m) != m) continue;
            var elms = menu.items[m].getElement();
            for(var i in elms){
                if(parseInt(i) != i) continue;
                elm.appendChild(elms[i]);
            }
        }
    },
    animateLeftMenuSizes: function(selected_index){
        if(typeof(selected_index) == 'undefined') selected_index = UI.animateLeftMenuSizes.lastSelectedIndex;
        if(typeof(selected_index) == 'undefined') selected_index = -1;
        UI.animateLeftMenuSizes.lastSelectedIndex = selected_index;
        
        if(UI.menuType == 'left'){
            var ul = $("#uiLeftItems")[0];
            if(typeof(ul) == 'undefined') return;
            var animationTime = 100;
            var longestText = 0;

            $("#uiLeftItems > li .itemText").css('width', 'auto');
            $("#uiLeftItems > li .itemText").each(function(){
                var width = $(this).width();
                if(width > longestText) longestText = width;
            });
            $("#uiLeftItems > li .itemText").css('width', longestText+'px');

            var lbb = $('#uiLeftBarBackground')[0];
            lbb._width = (selected_index >= 0 ? ul.maxSize : ul.avgSize) + 20;
            $(lbb).css("width", lbb._width + 'px');
            
            //Adjust Width of left menu items and background
            $("#uiLeftItems > li").width(longestText); 
            var backWidth = $($("#uiLeftItems > li")[0]).outerWidth() + 8;
            $("#uiLeftBarBackground").width(backWidth);
            $('#uiLeftBarBackground')[0]._width = backWidth+parseInt($('#uiLeftBarBackground').marginWidth());
            
            $("#uiLeftItems > li").each(function(i, val){
            //Update the LI Height
            var h = ((selected_index >= 0) ? ((selected_index == i) ? ul.maxSize : ul.minSize) : ul.avgSize);
            if(UI.menuType == 'left_wide')
                $(this).stop(true, false).animate({
                    height: h+'px'
                }, animationTime).css('overflow', 'visble');
            else
                $(this).stop(true, false).animate({
                    height: h+'px'
                }, animationTime).css('overflow', 'visble');
            
            //Get the scale
            h -= $(this).find('.itemText').height()-8;
            var k = Math.min(1, h/UI.leftMenuIconHolderSizeHeight);
            var w = UI.leftMenuIconHolderSizeWidth * k;
            if(selected_index == i) w = Math.max(w,longestText);
            
            var icon = $(this).children('div').children('.imgIcon32');
            var pl = $(this).css('paddingLeft');
            var pt = $(this).css('paddingTop');
            var paddingLeft = 0;
            var paddingTop = 0;
            if(typeof(pl) != 'undefined') paddingLeft = parseInt(pl.replace(/[^\d]/g, ''));
            if(typeof(pt) != 'undefined') paddingTop  = parseInt(pt.replace(/[^\d]/g, ''));

            $(this).css('position', 'relative');
            if(k <= 0.3){
                icon.fadeOut(100);
            }
            else {
                icon.fadeIn(100);
                icon.css('transform', 'scale('+k+')');
                icon.css('transform-origin', '0 0');
                icon.css('position', 'relative');
                icon.css('margin-left', (((UI.leftMenuIconHolderSizeWidth / 2) +  paddingLeft) - (16 * (k/2)) + UI.menuIconLeftOffsetCorrection) + 'px');
                //icon.css('left', (((w / 2) +  paddingLeft) - (20 * k) + UI.menuIconLeftOffsetCorrection) + 'px');
                //icon.css('top',  (((h / 2) +  paddingTop ) - (16 * k)) + 'px');
            }
        });
        }
        else if(UI.menuType == 'left_wide'){
            var ul = $("#uiLeftItems")[0];
            if(typeof(ul) == 'undefined') return;
            var animationTime = 100;
            var longestText = 0;
            var scroll_padding = 0;
            
            if($('#uiLeftItems').height() > $('#uiLeftBarBackground').height()){
                $('#uiLeftBarBackground').css('overflow-y', 'auto').css('overflow-x', 'hidden');
                scroll_padding = 24;
            }
            else{
                $('#uiLeftBarBackground').css('overflow-y', 'hidden').css('overflow-x', 'hidden'); 
            }
            
            $("#uiLeftItems > li .itemText").css('width', 'auto');
            $("#uiLeftItems > li .itemText").each(function(){
                var width = $(this).outerWidth() + 32 + 4;
                if(width > longestText) longestText = width;
            });
            var elm_back = $("#uiLeftBarBackground");
            elm_back[0]._width = longestText + scroll_padding; elm_back.css('width', elm_back[0]._width+'px');
            //uiLeftBar
            var w = elm_back.outerWidth();
            elms = $("#uiLeftBar");
            elms.css('width', w+'px');
            elms[0]._width = elms.outerWidth(); 
            
            $('#uiLeftBarBackground')[0]._width = w+$('#uiLeftBarBackground').marginWidth();
            
        }
    },
    flyOut: function(){
        //ui-tabs-iframed
        if(UI.flyOutTime == 0) return false;
        var tabs = $((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView > ul.ui-tabs-nav > li');
        $('#content').fadeOut(UI.flyOutTime);
        if(tabs.length != 0 && UI.flyOutTime >= 500){
            //var w    = UI.window_width;
            var w    = $($(tabs)[tabs.length - 1]).offset().left;
            var i    = 0;
            var span = 50;
            var time = UI.flyOutTime - ((tabs.length + 3) * span);
            tabs.each(function(){
                i++;
                var sender = this;
                setTimeout(function(){
                    $(sender).css('position', 'relative');
                    $(sender).animate({'left': -w}, UI.flyOutTime);
                }, i * span)
            });
            return true;
        }
    },
    loadFromMainMenu: function(page, sender){
    	if(typeof(page) == 'undefined') return;
        
        //Get Sender
        if(typeof(sender) == 'undefined' || !sender){
            sender = $('.menu-level-0[menu_link="'+page+'"]')[0];
        }
        
        //Animations
        UI.hightLightTab($('#uiLeftItems > li.activateMenuItem'), true);
        UI.hightLightTab(sender);
        
        //Remember
        UI.loadFromMenuPageStack.push(page);
        
        //Get Index
        var index = $(sender).index();
        var lastIndex = UI.loadFromMainMenu.lastIndex;
        UI.loadFromMainMenu.lastIndex = index;
        
        //Handle Link Action
        if(UI.mainMenuMode == 'main_index'){
            if(index == lastIndex) return;
            switch(page){
                default:
                    $('#uiSearchSettingsContainer').hide();
                    break;
                case 'tools':
                case 'admin':
                case 'reports':
                    $('#uiSearchSettingsContainer').css('display', 'inline-block');
                    break;
            }
            
            var animationTime = 330;
            var id            = 'main_index_page_'+page.toLowerCase();
            var windowHeight  = UI.window_height;
            var startA        = (lastIndex < index ? '-' : '') + windowHeight+'px';
            var startB        = (lastIndex > index ? '-' : '') + windowHeight+'px';
            var end           = '0px';
            
            //Reset Scroll
            $('#section_view')[0].scrollTop=0;
            
            //Clear Search Bar
            if($('#uiSearchSettings').val() != '') $('#uiSearchSettings').val('').keyup();
            if(UI.mouseConfirmed) $('#uiSearchSettings').each(function(){this.focus();});
            
            //Highlight Selected Menu Item
            $('#uiLeftItems > li.activateMenuItem').removeClass('activateMenuItem');
            $(sender).addClass('activateMenuItem');
            
            //Hide
            var overflow = $('#section_view').css('overflow');
            $('#section_view').css('overflow', 'hidden')
            $('.main_index_page_active, .frame-overlay-view').removeClass('main_index_page_active')
                .css('top', end)
				.css('max-height', $('#content').height()+'px')
				.css('overflow', 'hidden')
                .stop(true, true)
                .animate({'top': startA}, animationTime, 'swing', function(){ 
                	$(this).hide().css('top', end)
					.css('max-height', '')
					.css('overflow', ''); 
                	if(UI.autoHide_FullFrameOverlayView) 
                		$('.frame-overlay-view').remove();
                });
        
            //Show
            $('#'+id).addClass('main_index_page_active')
                .css('top', startB).show()
				.css('max-height', $('#content').height()+'px')
				.css('overflow', 'hidden')
                .stop(true, true)
                .animate({'top': end}, animationTime+1, 'swing', 
                    function(){ 
			            $('#section_view').css('overflow', overflow);
                        $(this).show().css('top', end)
							.css('max-height', '')
							.css('overflow', ''); 
                        UI.resize(); 
                        //invalidateTab of new sub-page
                        $('#'+id).find('.tabsView').each(function(){ 
                            var instanceVarName = $(this).attr('tabsViewInstance');
                            if(instanceVarName && typeof(window[instanceVarName]) != 'undefined'){
                                var instance = window[instanceVarName];
                                instance.invalidateTab(); 
                            }
                        });
                    });
           
           //Trigger OnView Event
           UI.setTextHelp('');
           UI.refreshTopTitle();
           var iframe_view = $('#'+id+' > .frame-view');
           if(iframe_view.length > 0) UI.viewShown(iframe_view[0]);
        }
        else
            setTimeout(function(){UI.load(CI_BASE_URL+'main/index?&menu_page='+page);}, UI.flyOut() ? UI.flyOutTime : 0);
    },
    refreshTopTitle: function(){
    	var activeLeftTab = $('#uiLeftItems > li.activateMenuItem > div > .itemText > div');
    	if(activeLeftTab.length > 1){
    		UI.texttitle($(activeLeftTab[0]).text(), $(activeLeftTab[1]).text());
		}
		else{
			UI.texttitle($('#uiLeftItems > li.activateMenuItem > div > .itemText').text());
		}
	},
    loadFromTaskBar: function(sender){
        //Not a tabbed taskbar
        var taskBar = $(sender).is('.uiTaskBarButton_sub') ? sender.parentElement.parentElement.parentElement.parentElement : sender.parentElement;
        if(!$(taskBar).is('.uiTaskBarShowOnlyInTabs')) return UI.load(sender);
        if($(sender).is('.uiTaskBarButton_sub')){
            $(sender.parentElement).css('visibility', 'hidden');
            setTimeout(function(){ $(sender.parentElement).css('visibility', 'visible'); }, 100);
        }
		var text = $(sender).attr('title');
		if(!text) text = "";
		if(text == "")
			$(sender).contents().filter(function() { return this.nodeType === Node.TEXT_NODE; }).each(function(){
				var t = $(this).text().trim();
				if(t != ""){
					if(text != "") text += " ";
					text += t;
				}
			});
        var frame = UI.loadInternalTab(sender.href, text, sender);
    },
    open: function(url, target, options, label){/*replacment for window.open when it should default to an internal tab*/
    	if(top.UI.mainMenu == null){
    		return window.open(url, target, options);
		}
		else{
			return top.UI.loadInternalTab(url, label);
		}
	},
	openPost: function(url, post_data, label, options){
		target = "openPost_"+get_uuid();
		var frameOrWindow = UI.open('about:blank', target, options, label);
		var isFrame = frameOrWindow instanceof Window ? false : true;
		if(isFrame) $(frameOrWindow).attr('name', target);
		var tmpForm = $('<form>').attr('action', url).attr('target', target).attr('method', 'POST')
		for(var i in post_data){
			var data = post_data[i];
			if(Array.isArray(data)){
				for(var x in data){
					$('<input type="hidden">').attr('value', data[x]).attr('name', i+'[]').appendTo(tmpForm);
				}
			}
			else{
				$('<input type="hidden">').attr('value', post_data[i]).attr('name', i).appendTo(tmpForm);
			}
		}
		top.$('body').append(tmpForm);
		if(url.match(/[\?&]trackdownload=1/)){
			tmpForm.attr('trackdownload', '1');
			UI.processView_FormTrackDownload();
			top.UI.processView_FormTrackDownload();
		}
		$(tmpForm)[0].submit();
		tmpForm.remove();
	},
	openHidden: function(url, params, method, onLoadComplete){
		if(typeof(method) == 'undefined') method = 'POST';
		if(typeof(params) == 'undefined') params = null;
		if(typeof(onLoadComplete) == 'undefined') onLoadComplete = function(){};
		
		if($('#uiOpenHiddenFrame').length == 0) $('<iframe name="uiOpenHiddenFrame" id="uiOpenHiddenFrame" style="display: none;">').appendTo('body');
		var iframe = $('#uiOpenHiddenFrame')[0];
		
		if($('#uiOpenHiddenForm').length == 0) $('<form id="uiOpenHiddenForm" target="uiOpenHiddenFrame" style="display: none;">').appendTo('body');
		var form = $('#uiOpenHiddenForm');
		form.attr('method', method);
		form.attr('action', url);
		form.empty();
		if(params && (typeof(params.length) != 'undefined' || params instanceof Object)){
			for(var i in params){
				$('<input type="hidden">').val(params[i]).attr('name', i).appendTo(form);
			}
		}
		
		iframe.onLoadComplete = onLoadComplete;
		iframe.checkIframeLoaded = (function(){
			var iframeDoc = this.contentDocument || this.contentWindow.document;
			if (iframeDoc.readyState == 'complete') return this.onLoadComplete();
			window.setTimeout((this.checkIframeLoaded).bind(this), 100);
		}).bind(iframe);
		
		form[0].submit();
		iframe.checkIframeLoaded();
		return $('#uiOpenHiddenFrame')[0];
	},
    loadInternalTab: function(href, label, sender, dont_auto_open){
        if(top.UI.mainMenuMode != 'main_index') return UI.load($("<a></a>").attr('href', href).attr('target', '_blank'));
        if(window.isMobile) return UI.load($("<a></a>").attr('href', href));
        
        //Prepare
        if(typeof(sender) == 'undefined') sender = false;
        if(typeof(dont_auto_open) == 'undefined') dont_auto_open = false;
        if(typeof(UI.loadInternalTabIndex) == 'undefined') UI.loadInternalTabIndex = 0;
        
        //Set URL as tmpl=iframe 
        if(!href.match(/(&|\?)tmpl=/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe';
        
        //Append View
        UI.loadInternalTabIndex++;
        var internal_frame_id = 'frame__iview_'+UI.loadInternalTabIndex;
        var page = 'internal_'+UI.loadInternalTabIndex;
        var view = $('<div id="main_index_page_'+page+'" class="main_index_page main_index_internal_tab"></div>');
        var frame = $('<iframe id="'+internal_frame_id+'" seemless="" class="frame-view" style="display: inline;"><!DOCTYPE html><html><head></head><body></body></html></iframe>');
        frame.appendTo(view);
        view.appendTo('#section_view > .main_index_page_container');
		
		//Frame Load/Unload Events
		frame[0].parentUI = UI;
        $(frame).load(function(){
			var targetUI = null;
			try{ 
				this.contentWindow.internal_frame_id = this.internal_frame_id;
				targetUI = this.contentWindow.UI;
			}
			catch (e) { }
            if(typeof(this.contentWindow) != 'undefined' && targetUI != null){
				//Show load complete UI
				this.parentUI.setFrameContentsAsNotLoading(this);
				//Set Hook for next unload (to show as loading)
				this.contentWindow.onunload = (function(){ this.parentUI.setFrameContentsAsLoading(this); }).bind(this);
				//Append Close to frame
	            targetUI.addTaskbarItem(window.STR_CLOSE, 'menuicons/'+window.iconset+'/closewindow.png', internal_frame_id, page, function(event){
	                var id = $(this).attr('frame_id');
	                var page = $(this).attr('internal_page');
	                window.top.UI.mainMenu.removeItem(page);
	                window.top.$('#'+id).remove();
	                window.top.UI.resize();
	                window.top.UI.showLastInternalPage();
	            });
			}
        });
        
		//Track Download?
		var trackDownload = false;
		if(href.match(/(fpdf|fileopen)\.php/))
			href += href.indexOf('?') != -1 ? '&trackdownload=1' : '?trackdownload=1';
		else if(href.match(/!\/index\.php\?\/+[^\/]+\/[^\/]*pdf\//i) || href.match(/!\/index\.php\?\/+[^\/]+\/pdf[^\/]*\//i))
			href += href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&trackdownload=1' : '&trackdownload=1';
		if(href.match(/[\?&]trackdownload=1/)){
			//Append tracking ID
			frame[0].processView_FormTrackDownload_uuid = get_uuid();
			frame[0].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
			href += '&form_track_download_uuid='+frame[0].processView_FormTrackDownload_uuid;
			trackDownload = true;
		}

        //Append Menu Item
        if(UI.mainMenu != null){
        	if(label == null || label == '' || label == false) label = window.STR_LOADING+'...';
	        var item = new MenuItem(label, 'internal_tab imgIcon32 imgGeneral __'+internal_frame_id, page);
	        item.internal_frame_id = UI.loadInternalTabIndex;
	        UI.mainMenu.addItem(item);
			if(!dont_auto_open) $('#uiLeftItems li:last').click();
			frame[0].menu_item = item;
		}
        frame[0].internal_frame_id = item.internal_frame_id;
        frame[0].setTitle = function(title, subtitle){
        	for(var i in UI.mainMenu.items){
        		if(UI.mainMenu.items[i].link == 'internal_'+this.internal_frame_id){
        			UI.mainMenu.items[i].text = title;
        			UI.mainMenu.items[i].subTitle = subtitle;
				}
			}
        	var htmlTitle = UI.MenuItemGetTabTitleHtml(title, subtitle);
            $('#uiLeftItems li[menu_link="internal_'+this.internal_frame_id+'"] .itemText').html(htmlTitle);
            top.UI.resize();
        }
        
		UI.setFrameContentsAsLoading(frame);
		
		if(trackDownload){
			frame[0].processView_FormTrackDownload_IsComplete = false;
			frame[0].processView_FormTrackDownload_functionCheckIsComplete = (function(){
				var url = NP_BASE_URL+IMAGE_UPLOAD_DIR+'/temp/frmDownload.'+frame[0].processView_FormTrackDownload_uuid+'.tmp';
				$.fetch(url, 
					function(r){
						//Success, file found
						frame[0].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();

						//Complete
						if(r != '0'){
							var setTitle = null;
							var setSubTitle = null;
							if(r != '1'){
								var lines = r.split("\n");
								setTitle = typeof(lines[0]) == 'undefined' ? null : lines[0];
								setSubTitle = typeof(lines[1]) == 'undefined' ? null : lines[1];
							}
							frame[0].processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(frame[0], setTitle, setSubTitle);
						}
					},
					function(){
						//Timeout, never found the tracking file...
						if((new Date()).getTime() - frame[0].processView_FormTrackDownload_lastSuccess > 8000 /*8s*/){
							frame[0].processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(frame[0]);
						}

						//Try again...
						else if(!frame[0].processView_FormTrackDownload_IsComplete){
							setTimeout(frame[0].processView_FormTrackDownload_functionCheckIsComplete, 1000);
						}
					});
			});
			frame[0].processView_FormTrackDownload_functionCheckIsComplete();
		}

        frame.attr('src', href);
		frame.attr('name', internal_frame_id);
		
        return frame[0];
    },
    loadBrowserTab: function(href){
    	return window.open(href, '_blank');
	},
    closeInternalTab: function(internal_frame_id){
        var page = 'internal_'+internal_frame_id;
        UI.mainMenu.removeItem(page);
        $('#main_index_page_'+page).remove();
        UI.showLastInternalPage();
    },
    showLastInternalPage: function(){
        while(UI.loadFromMenuPageStack.length > 0){
            var page = UI.loadFromMenuPageStack.pop();
            var sender = $('.menu-level-0[menu_link="'+page+'"]');
            if(sender.length == 0 || typeof(sender[0]) == 'undefined') continue;
            UI.loadFromMainMenu.lastIndex = -1;
            return UI.loadFromMainMenu(page, sender[0]);
        }
        
        var defaultFirst = $('#uiLeftItems > li[menu_link]:visible');
        var page = defaultFirst.attr('menu_link');
        return UI.loadFromMainMenu(page, typeof(sender) == 'undefined' || typeof(sender[0]) == 'undefined' ? false : sender[0]);
        
    },
    setFrameContentsAsLoading: function(frame){

		//Show Menu Item As Loading
		var _frame = (typeof(frame[0]) != 'undefined') ? frame[0] : frame;
		if(typeof(_frame) != 'undefined' && typeof(_frame.menu_item) != 'undefined'){
			$('#uiLeftItems [menu_link="'+_frame.menu_item.link+'"]').addClass('menu_item_loading');
		}

        var baseHref = $('base').attr('href');
        
        var menuElm = top.$('#uiTopBar')[0];
        var compstyle = typeof(menuElm) != 'undefined' ? getComputedStyle(menuElm) : null;
        var str = typeof(compstyle) != 'undefined' && compstyle != null ? compstyle.backgroundImage : '';
        var matches = str.match(/rgba?\([^\)]*\)/ig);
        if(typeof(matches) == 'undefined' || matches == null) matches = [];
        var color  = (typeof(matches[1]) != 'undefined') ? matches[1] : '#CCCCCC';
        var colorB = (typeof(matches[0]) != 'undefined') ? matches[0] : '#FFFFFF';
        
        var head = '';
		head += '<style type="text/css">';
		head += '* { box-sizing: border-box; } ';
		head += '.main { opacity: 0.5; }';
		head += '.small2 {   position: absolute;   height: 100px;   width: 100px;   background-color: transparent;   top: 50vh;   left: 50%;   transform: translate(-50%, -50%); } ';
		head += '.small1 {   position: absolute;   height: 100px;   width: 100px;   top: 50vh;   left: 50%;   transform-origin: center;   transform: translate(-50%, -50%) rotate(45deg);   background-color: transparent; }';
		head += '.bigcon {   position: absolute;   height: 95px;   width: 95px;     top: 50vh;   left: 50%;   transform-origin: center;   transform: translate(-50%, -50%) rotate(-45deg);   background-color: transparent;   animation: bigcon 2s infinite linear;   animation-delay: 0.25s; }';
		head += '.ball {   border-radius: 50%;   position: absolute; }';
		head += '.small {   width: 25px;   height: 25px;   animation: small 2s infinite ease;   box-shadow: 0px 2px rgba(0,0,0,0.3); background-color: '+color+'; }';
		head += '.small:nth-child(1) {   top: 0%;   left: 0%; }';
		head += '.small:nth-child(2) {   top: 0%;   right: 0%; }';
		head += '.small:nth-child(3) {   right: 0%;   bottom: 0%; }';
		head += '.small:nth-child(4) {   bottom: 0%;   left: 0%; }';
		head += '.big {   width: 20px;   height: 20px;   border-radius: 15px;   box-shadow:0px 0px 10px '+colorB+', 0px 0px 20px '+colorB+', 0px 0px 30px '+colorB+', 0px 0px 50px '+colorB+', 0px 0px 60px '+colorB+' ;   z-index: 1;   background-color: '+colorB+';   animation: bigball 1s infinite linear; }';
		head += '.smallball1{   animation-delay: -1.75s; }';
		head += '.smallball6{   animation-delay: -1.5s; }';
		head += '.smallball2{   animation-delay: -1.25s; }';
		head += '.smallball7{   animation-delay: -1s; }';
		head += '.smallball3{   animation-delay: -0.75s; }';
		head += '.smallball8{   animation-delay: -0.5s; }';
		head += '.smallball4{   animation-delay: -0.25s; }';
		head += '.smallball5{   animation-delay: -0s; } ';
		head += '@keyframes bigcon {   0% {     transform-origin: center;     transform: translate(-50%, -50%) rotate(45deg);   }   100% {     transform-origin: center;     transform: translate(-50%, -50%) rotate(405deg);   } }';
		head += '@keyframes small {   0% {     transform: scale(1);      background-color: '+color+';   }   10% {     transform: scale(1.3);     background-color: '+colorB+';   }   15% {     transform: scale(1);   }   25%{ transform: scale(1);      background-color: '+color+';   }   100%{     transform: scale(1);      background-color: '+color+';   } }';
		head += '</style>';

        var body = '';
        body += '<div class="main">';
		body += '	<div class="small1">';
		body += '		<div class="small ball smallball1"></div>';
		body += '		<div class="small ball smallball2"></div>';
		body += '		<div class="small ball smallball3"></div>';
		body += '		<div class="small ball smallball4"></div>';
		body += '	</div>';
		body += '	<div class="small2">';
		body += '		<div class="small ball smallball5"></div>';
		body += '		<div class="small ball smallball6"></div>';
		body += '		<div class="small ball smallball7"></div>';
		body += '		<div class="small ball smallball8"></div>';
		body += '	</div>';
		body += '	<div class="bigcon"><div class="big ball"></div></div>';
		body += '</div>';
		
		//Confirm frame has parent window...
		if(typeof(frame[0]) != 'undefined' && ((typeof(frame[0].contentWindow) != 'undefined' && frame[0].contentWindow != null) || (typeof(frame[0].contentDocument) != 'undefined' && frame[0].contentDocument != null))){
	        frame.contents().find('head').html(head);
	        frame.contents().find('body').html(body);
	        frame.contents().find('body').addClass('pace-running');
		}
	},
	setFrameContentsAsNotLoading: function(frame, setTitleText, setTitleSubText){
		//Show Menu Item As NOT Loading
		var _frame = (typeof(frame[0]) != 'undefined') ? frame[0] : frame;
		if(typeof(_frame) != 'undefined' && typeof(_frame.menu_item) != 'undefined'){
			$('#uiLeftItems [menu_link="'+_frame.menu_item.link+'"]').removeClass('menu_item_loading');
		}

		//Remove "Loading..." text
		var text = $('#uiLeftItems li[menu_link="internal_'+_frame.internal_frame_id+'"] .itemText').text();
		if(text == window.STR_LOADING+'...'){
			var setTitle = typeof(setTitleText) == 'undefined' || !setTitleText ? (_frame.contentDocument == null ? 'PDF' : '######') : setTitleText;
			if(typeof(_frame.setTitle) != 'undefined') _frame.setTitle(setTitle, setTitleSubText);
			else $('#uiLeftItems li[menu_link="internal_'+this.internal_frame_id+'"] .itemText').text(setTitle);
		}
	},
    showFrameReturnTaskBarItem: function(frame, TaskBar, return_label, return_btn_class){
        //Dont show on if location is my_src
        if(frame.contentWindow.location.href == 'about:blank') return false;
        if(frame.contentWindow.location.href.indexOf($(frame).attr('my_src')) == frame.contentWindow.location.href.length - $(frame).attr('my_src').length) return false;   
        
        //Defaults
        if(typeof(return_label) == 'undefined' || return_label == null) return_label = $(frame).attr('return_label') ? $(frame).attr('return_label') : window.STR_LIST;
        if(typeof(return_btn_class) == 'undefined' || return_btn_class == null) return_btn_class = '';
        if(typeof(TaskBar) == 'undefined') TaskBar = $($($(frame).parent('.ui-tabs-panel')[0]).children('.uiTaskBarContainer')[0]).find('.uiTaskBar')[0];
        
        if(typeof(frame.taskBarUID) == 'undefined'){
            if(typeof(window.top.tasBarUIDNext) == 'undefined') window.top.tasBarUIDNext = 0;   
            frame.taskBarUID = window.top.tasBarUIDNext++;
        }
        
        var frameUIDClass = 'uiTaskBarButtonReturnIframe_'+frame.taskBarUID;
        frame = $(frame);
        TaskBar = $(TaskBar);
        
        if(TaskBar && TaskBar.find('.'+frameUIDClass).length == 0){
            var return_elm = $('<div class="uiTaskBarButton  uiTaskBarButtonFor_ '+return_btn_class+' '+frameUIDClass+'">  <input type="image" title="'+return_label+'" alt="'+return_label+'" src="menuicons/'+window.iconset+'/back.png"> '+return_label+'</div>');
            return_elm.prependTo(TaskBar);
            return_elm.click(function(){
                 frame.attr('src', frame.attr('my_src'));
                 $(this).remove();
            });
        }
        
        return true;
    },
    addTaskbarItem: function(label, img, frame_id, page, onclick){
        var TaskBar = $('#content > .uiTaskBarContainer > .uiTaskBarBackground > .uiTaskBar');
        if(TaskBar.length == 0){
            TaskBar = $('<div class="uiTaskBarContainer"><div class="uiTaskBarBackground"><div class="uiTaskBar uiTaskBarTable"></div></div></div>');
            TaskBar.appendTo('#content');
            TaskBar = $('#content > .uiTaskBarContainer > .uiTaskBarBackground > .uiTaskBar');
            $(window).resize();
        }

        var return_elm = $('<div class="uiTaskBarButton" frame_id="'+frame_id+'" internal_page="'+page+'">  <input type="image" title="'+label+'" alt="'+label+'" src="'+img+'"> '+label+'</div>');
        return_elm.click(onclick);
        return_elm.prependTo(TaskBar);
    },
    hightLightTab: function(internal_frame_id, useAltAnimation){
        if(typeof(useAltAnimation) == 'undefined') useAltAnimation = false;
        
        var elm = null;
        if(typeof(internal_frame_id) == 'object' && typeof(internal_frame_id.jquery) == 'undefined') internal_frame_id = $(internal_frame_id); 
        if(typeof(internal_frame_id) == 'object') elm = internal_frame_id;
        else elm = $('#uiLeftItems > li').filter(function(index){ return this.internal_frame_id == internal_frame_id; });
        
        if(useAltAnimation){
            elm.animate({
                    'opacity': '0.25'
                },
                300, 'swing',
                function(){
                    $(this).stop(true).animate({
                            'opacity': '1'
                        },
                        500, 'swing',
                        function(){
                            
                        }
                    );
                }
            );
        }
        else{
            //Bounce Right
            elm.animate({
                    'padding-left': '24px',
                    'padding-right': '-24px'
                },
                150, 'swing',
                function(){
                    $(this).stop(true).animate({
                            'padding-left': '0px',
                            'padding-right': '0px'
                        },
                        250, 'swing',
                        function(){
                            
                        }
                    );
                }
            );
        }
    },
    promptfornewpassword:function(){
        $('#promptfornewpassword').dialog({
            modal:true,
            dialogClass:'no-close',
	        closeOnEscape: false,
            width:$(window).width()*0.8,
            height:$(window).height()*0.8
        });
    },

    /*MENU PANES*/
    hideAllMenuPanes: function(){
        $('body').children('.uiTopBar_FloatingPane').each(function(){
            if(this._isOpened){
            	this._isOpened = false;
	            $(this).stop(false, true).animate({
	                top: '-'+($(this).height()+10)+'px'
	            }, UI.animationSpeedFloatingPanes);
			}
        });
    },
    positionPane: function(pane_elm, btn_elm){
        //Get Button Location
        var offset = $(btn_elm).offset();
        //Get Pane Width
        $(pane_elm).css('display', 'inline-block').css('position', 'relative').css('width', 'auto').css('left', '0px');
        var width  = $(pane_elm).width();
        $(pane_elm).css('display', 'block').css('width', width+'px').css('position', 'fixed');
        //Get Window Size
        var ww = UI.window_width - 24;
        //Position Pane
        var x = (offset.left + width > ww) ? ww - width : offset.left;
        if(x < 2) x = 2;
        if(pane_elm && pane_elm.id && pane_elm.id == 'uiTopBar_SettingsPane'){
	        $(pane_elm).css('right', x+'px');
	        $(pane_elm).css('left','');
        } else {
	        $(pane_elm).css('left', x+'px');
        }
    },
    toggleLinksPane: function(){
        var elm = $('#uiTopBar_LinkPane')[0];
        if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;

        if(elm._isOpened){
            UI.hideLinksPane();
            elm._isOpened = false;
        }
        else{
            UI.hideAllMenuPanes();
            $(elm).css('margin-top', $('#uiTopBar').height()+'px');
            $(elm).stop(false, true).animate({top: '0px'}, UI.animationSpeedFloatingPanes); 
            UI.positionPane(elm, $('#uiTopBar .btnLinks')[0]);  
            elm._isOpened = true;
        }
    },
    hideLinksPane: function(){
        var elm = $('#uiTopBar_LinkPane')[0];
        if(typeof(elm) == 'undefined') return;
        elm._isOpened = false;
        $(elm).stop(false, true).animate({
            top: '-'+($(elm).height()+10)+'px'
        }, UI.animationSpeedFloatingPanes);
    },
    toggleUserSettingsPane: function(){
        var elm = $('#uiTopBar_SettingsPane')[0];
        if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;

        if(elm._isOpened){
            UI.hideUserSettingsPane();
            elm._isOpened = false;
        }
        else{
            UI.hideAllMenuPanes();
            $(elm).css('margin-top', $('#uiTopBar').height()+'px');
            $(elm).stop(false, true).animate({top: '0px'}, UI.animationSpeedFloatingPanes); 
            UI.positionPane(elm, $('#uiTopBar .btnSettings')[0]);  
            elm._isOpened = true;
        }
    },
    hideUserSettingsPane: function(){
        var elm = $('#uiTopBar_SettingsPane')[0];
        if(typeof(elm) == 'undefined') return;
        elm._isOpened = false;
        $(elm).stop(false, true).animate({
            top: '-'+($(elm).height()+10)+'px'
        }, UI.animationSpeedFloatingPanes);
    },
    toggleUserDevPane: function(){
        var elm = $('#uiTopBar_DevPane')[0];
        if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;
        
        if(elm._isOpened){
            UI.hideUserDevPane();
            elm._isOpened = false;
        }
        else{
            UI.hideAllMenuPanes();
            $(elm).css('margin-top', $('#uiTopBar').height()+'px');
            $(elm).stop(false, true).animate({top: '0px'}, UI.animationSpeedFloatingPanes);   
            UI.positionPane(elm, $('#uiTopBar .btnDebug')[0]); 
            elm._isOpened = true;
        }
    },
    hideUserDevPane: function(){
        var elm = $('#uiTopBar_DevPane')[0];
        if(typeof(elm) == 'undefined') return;
        elm._isOpened = false;
        $(elm).css('padding-top', $('#uiTopBar').height()+'px');
        $(elm).stop(false, true).animate({top: '-'+($(elm).height()+10)+'px'}, UI.animationSpeedFloatingPanes);
    },
    toggleHelpPane: function(){
        var elm = $('#uiTopBar_HelpPane')[0];
        if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;

        if(elm._isOpened){
            UI.hideHelpPane();
            elm._isOpened = false;
        }
        else{
            UI.hideAllMenuPanes();
            $(elm).css('margin-top', $('#uiTopBar').height()+'px');
            $(elm).stop(false, true).animate({top: '0px'}, UI.animationSpeedFloatingPanes); 
            UI.positionPane(elm, $('#uiTopBar .btnHelp')[0]);   
            elm._isOpened = true;
        }
    },
    hideHelpPane: function(){
        var elm = $('#uiTopBar_HelpPane')[0];
        if(typeof(elm) == 'undefined') return;
        elm._isOpened = false;
        $(elm).stop(false, true).animate({
            top: '-'+($(elm).height()+10)+'px'
        }, UI.animationSpeedFloatingPanes);
    },
    toggleQuickLinksPane: function(){
        var elm = $('#uiTopBar_LinksPane')[0];
        if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;

        if(elm._isOpened){
            UI.hideQuickLinksPane();
            elm._isOpened = false;
        }
        else{
            UI.hideAllMenuPanes();
            $(elm).css('margin-top', $('#uiTopBar').height()+'px');
            $(elm).stop(false, true).animate({top: '0px'}, UI.animationSpeedFloatingPanes);  
            UI.positionPane(elm, $('#uiTopBar .btnLinks')[0]);  
            elm._isOpened = true;
        }
    },
    hideQuickLinksPane: function(){
        var elm = $('#uiTopBar_LinksPane')[0];
        if(typeof(elm) == 'undefined') return;
        elm._isOpened = false;
        $(elm).stop(false, true).animate({
            top: '-'+($(elm).height()+10)+'px'
        }, UI.animationSpeedFloatingPanes);
    },
    startSettingsSearch: function(){
        var labels = $('#section_view label');
        if($('#section_view label').length == 0) return;
        
        $('#uiSearchSettingsContainer').css('display', 'inline-block');
        var parent = $('#uiTopBar_SearchResultsPane')[0];
        $(parent).empty();
        
        var arr = [];
        var keys = [];
        function sortObj(arr){
            // Setup Arrays
            var sortedKeys = new Array();
            var sortedObj = {};

            // Separate keys and sort them
            for (var i in arr) sortedKeys.push(i);
            sortedKeys.sort();

            // Reconstruct sorted obj based on keys
            for (var i in sortedKeys) sortedObj[sortedKeys[i]] = arr[sortedKeys[i]];
            return sortedObj;
        }
        
        var labels = $('#section_view label');
        labels.each(function(){
            var txt = $(this).text().trim().replace(/\s*:\s*$/gi, '');
            var elmid = $(this).attr('for');
            arr[txt] = elmid;
        });

        arr = sortObj(arr);
        for(var txt in arr){
            keys.push({label: txt, value: arr[txt]});
        }

        var txbxSearch = $('#uiSearchSettings');
        txbxSearch.autocomplete({
            source: keys,
            select: function(event, ui){
                var id = ui.item.value;
                UI.searchSettingSelected(id);
                $('#uiSearchSettings').css('color', 'white');
                setTimeout('$(\'#uiSearchSettings\').val("");$(\'#uiSearchSettings\').css(\'color\', \'\');', 10);
            },
            open: function(){
                $('.ui-autocomplete').css('padding-top', '8px');
            }
        });
    },
    searchSettingSelected: function(id){
        $('.searchHighlighed').removeClass('searchHighlighed');
        var elm = $('#'+id);
        var lbl = $('label[for='+id+']');
        lbl.addClass('searchHighlighed');
        elm.addClass('searchHighlighed');
        elm[0].focus();
    },
    toggleCollapsedTopMenuPane: function(){
        UI.hideAllMenuPanes();
        
        //Build Contents
        var menu = $('#collapsedTopMenuPaneContents').empty();
        if(typeof(menu[0]._isOpened) == 'undefined') menu[0]._isOpened = false;
        
        if(menu[0]._isOpened){
            menu[0]._isOpened = false;
            UI.hideCollapsedTopMenuPane();
        }
        else{
            menu[0]._isOpened = true;
            menu.html($('#uiTopBarMenu').html()).css('height', 'auto').css('display', 'block');
            var h = menu.height();
            menu.css('height', 0).animate({height: h+'px'}, UI.animationSpeedFloatingPanes);
            menu.click(function(event){ if(event.isPropagationStopped()) return; event.stopPropagation(); UI.hideCollapsedTopMenuPane(); return false; });
        }
    },
    hideCollapsedTopMenuPane: function(){
        var menu = $('#collapsedTopMenuPaneContents');
        menu.animate({height: 0}, UI.animationSpeedFloatingPanes);
        menu[0]._isOpened = false;
    },
	toggleUIAlertsPane: function(isUserEvent){
        if(typeof(isUserEvent) == 'undefined') isUserEvent = false;
		var elm = $('#uiTopBar_AlertsPane')[0];
        if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;

        if(elm._isOpened){
            UI.hideUIAlertsPane(isUserEvent);
            elm._isOpened = false;
        }
        else{
        	$('#uiTopBarAlertsBtn .imgAlert').removeClass('animation_shake')
            UI.hideAllMenuPanes();
            $(elm).css('margin-top', $('#uiTopBar').height()+'px');
            $(elm).stop(false, true).animate({top: '0px'}, UI.animationSpeedFloatingPanes); 
            UI.positionPane(elm, $('#uiTopBarAlertsBtn')[0]);  
            elm._isOpened = true;
        }
	},
    hideUIAlertsPane: function(isUserEvent){
        if(typeof(isUserEvent) == 'undefined') isUserEvent = false;
        if(isUserEvent) $('#uiTopBarAlertsBtn .imgAlert').removeClass('animation_shake')
        var elm = $('#uiTopBar_AlertsPane')[0];
        if(typeof(elm) == 'undefined') return;
        elm._isOpened = false;
        $(elm).stop(false, true).animate({
            top: '-'+($(elm).height()+10)+'px'
        }, UI.animationSpeedFloatingPanes);
    },
    
    shake: function(elm){
    	if(typeof(elm) == 'undefined' || elm == null) return;
    	elm = $(elm);
    	if(typeof(elm[0]) == 'undefined') return;
		var shake_size  = 20;
		var shake_time  = 50;
		var shake_count = 5;
		var wait_end = 0;
		for(var i = 0; i < shake_count; i++){
			var time = (i == 0 ? shake_time / 2 : shake_time);
			var wait = i - 1 >= 0 ? (shake_time / 2) + ((i - 1) * shake_time) : 0;
			var odd  = i % 2 == 0;
			wait_end = wait + time;
			setTimeout((function(){
				elm.css({
				  "transform": "translate("+(this.o ? '-' : '')+shake_size+"px, 0px)",
				  "transition": "transform "+this.t+'ms'
				});
			}).bind({'t': time, 'w': wait, 'o': odd}), wait);
		}
		var _wait = shake_count - 1 >= 0 ? (shake_time / 2) + (shake_count - 1 * shake_time) : shake_time;
		
		setTimeout((function(){
			elm.css({
			  "transform": "translate(0px, 0px)",
			  "transition": "transform "+this.t+'ms'
			});
		}).bind({'t': shake_time / 2}), wait_end + 10);
		setTimeout(function(){
			elm.css({
			  "transform": "translate(0px, 0px)",
			  "transition": "transform 0ms"
			});
		}, wait_end + shake_time);
		
    },
    
    bounce: function(elm, bounce_count){
    	if(typeof(elm) == 'undefined' || elm == null) return;
    	elm = $(elm);
    	if(typeof(elm[0]) == 'undefined') return;
		var shake_size  = 5;
		var shake_time  = 116;
		var shake_count = typeof(bounce_count) == 'undefined' ? 1 : bounce_count;
		var wait_end = 0;
		for(var i = 0; i < shake_count; i++){
			var time = (i == 0 ? shake_time / 2 : shake_time);
			var wait = i - 1 >= 0 ? (shake_time / 2) + ((i - 1) * shake_time) : 0;
			var odd  = i % 2 == 0;
			wait_end = wait + time;
			setTimeout((function(){
				elm.css({
				  "transform": "translate(0px, "+(this.o ? '-' : '')+shake_size+"px)",
				  "transition": "transform "+this.t+'ms'
				});
			}).bind({'t': time, 'w': wait, 'o': odd}), wait);
		}
		var _wait = shake_count - 1 >= 0 ? (shake_time / 2) + (shake_count - 1 * shake_time) : shake_time;
		
		setTimeout((function(){
			elm.css({
			  "transform": "translate(0px, 0px)",
			  "transition": "transform "+this.t+'ms'
			});
		}).bind({'t': shake_time / 2}), wait_end + 10);
		setTimeout(function(){
			elm.css({
			  "transform": "translate(0px, 0px)",
			  "transition": "transform 0ms"
			});
		}, wait_end + shake_time);
    },
	
	showTooltip: function(elm, message, timespan_ms, position){
		//Default Params
		if(typeof(elm) == 'undefined') return;
		if(typeof(message) == 'undefined') message = 'UNDEFINED';
		if(typeof(timespan_ms) == 'undefined') timespan_ms = 3000;
		if(typeof(position) == 'undefined') position = {};
		elm = $(elm);

		//Show Tooltip
		var elmTooltip = $('<div class="ui-tooltip">').html(message).appendTo(elm[0].parentNode);
		elmTooltip.position(position);
		
		//Hide
		var funcHide = (function(){
			if(typeof(this) != 'undefined') $(this).animate({opacity: 0}, 166, (function(){ $(this).remove(); }).bind(this));
		}).bind(elmTooltip);
		//--Hide On Unfocus
		if(elm.is('input') || elm.is('textarea')) elm.one('blur', funcHide);
		//--Auto Hide Tooltip
		if(timespan_ms > 0) setTimeout(funcHide, timespan_ms);
		//--Hide when clicked
		$(elmTooltip).click(funcHide);

		return elmTooltip;
	},
	
	tooltip: function(elm, message, timespan_ms, position){ return UI.showTooltip(elm, message, timespan_ms, position); },
	
    fadeOutAndIn: function(elm){
    	if(typeof(elm.navigator) != 'undefined') return;
    	if(typeof(elm) == 'undefined' || elm == null) return;
    	elm = $(elm);
    	if(typeof(elm[0]) == 'undefined') return;
		elm.addClass('fadeOutAndInAnimation').animate({'opacity': 0.333}, 116);
		setTimeout(function(){
			elm.animate({'opacity': 1}, 116);
			setTimeout(function(){
				elm.removeClass('fadeOutAndInAnimation')
			}, 116);
		}, 116);
    },
	
    setTextHelp: function(html){
    	$('#text_help_link').html(html);
    	if(html == '') $('#text_help_link').css('display', 'none');
    	else $('#text_help_link').css('display', 'list-item');
    	var x = UI.animationSpeedFloatingPanes;
    	UI.animationSpeedFloatingPanes = 0;
    	if(html != '') UI.hideHelpPane();
    	UI.animationSpeedFloatingPanes = x;
	},
    
    show_mobile_nav: function(options){
        //options = {id, text, link, image}
        var background = document.createElement('div');
        $(background).addClass('mobile_nav_background');
        $(background).click(function(){ $('.mobile_nav_background').remove(); });
        $('body')[0].appendChild(background);
        
        var container  = document.createElement('div');
        $(container).addClass('mobile_nav_container');
        background.appendChild(container);

        var max_width = 0;
        var first = true;
        for(var o in options){
            if(!first){
                var br = document.createElement('hr');
                container.appendChild(br);
            }
            first = false;
            
            var option = options[o];
            var li = document.createElement('span');
            $(li)[0].parentLinkId = option.id;
            $(li).text(option.text).css('cursor', 'pointer');
            $(li).click(function(){ 
                var confirmed = UI.mouseConfirmed;
                UI.mouseConfirmed = true;
                isIE = function(){ return false; };
                $('#'+this.parentLinkId)[0].onclick(); 
                UI.mouseConfirmed = confirmed;
            });
            container.appendChild(li);
            
            var _w = $(li).outerWidth();
            if(_w > max_width) max_width = _w;
        }
        container.max_width = max_width;
        UI.show_mobile_nav_resize();
    },
    show_mobile_nav_resize: function(){
        var background = $('.mobile_nav_background');
        var container  = $('.mobile_nav_container');
        if(background.length == 0) return;
        if(container.length  == 0) return;
        
        $(background).css('width', UI.window_width+'px');
        $(background).css('height', UI.window_height+'px');
        
        var max_width = container[0].max_width + 2;
        $(container).css('width', max_width+'px');
        $(container).css('margin-top',  (UI.window_height / 2) - ($(container).height() / 2)+'px');
        $(container).css('margin-left', (UI.window_width  / 2) - (max_width             / 2)+'px');
    },
    
    Navigate: function(sender, href, event, parentTabs, dont_open_new_ui_tab, is_redirect){
        if(typeof(is_redirect) == 'undefined' || is_redirect == '' || is_redirect == null) is_redirect = false;

        //New Browser Tab on Ctrl+Click
        if(top.ctrlIsDown){
            top.ctrlIsDown = false;
            if(typeof(href) == 'undefined' || href == '' || href == null) href = sender.href;
            href = href.replace(/(\?)?&?tmpl=[^&]*/, '$1');
            window.open(href, '_blank');
            return;
        }
        
        //Prepare what Window is targeted and lookup Tabs Control
        if(typeof(dont_open_new_ui_tab) == 'undefined' || dont_open_new_ui_tab == null){
            dont_open_new_ui_tab = false;
            if(typeof(window.frameElement) != 'undefined'){
                if($(window.frameElement).is('.staticFrame')){
                    dont_open_new_ui_tab = true;
                }   
            }
        }
            
        var _window = window;
        if(typeof(sender) != 'undefined' && sender != null && sender.target != '_self' && $(sender).is('a')){
            if(window != top) _window = top;
            if(typeof(parentTabs) == 'undefined' || parentTabs == null || parentTabs.length == 0) parentTabs = _window.$((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView');
        }

        //Handel Close Event (href = close.html)
        if(href.match(/close\.html\?tmpl=iframe/)){
            if(window != top) _window = top;
            if(typeof(parentTabs) == 'undefined' || parentTabs == null) parentTabs = _window.$((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView');
            if(typeof(parentTabs) != 'undefined' && parentTabs.length > 0) window.frameElement.closeTab();
            return false;
        }
        
        //Don't load Save/Back/Delete as tab...
        var img = $(sender).find('img');
        if(img.length > 0 && img.attr('src').match(/(save|delete|back)\.(png|gif)/i)) dont_open_new_ui_tab = true;

        //Load as tab?
        if(typeof(parentTabs) != 'undefined' && parentTabs.length > 0 && (parentTabs.find(sender).length != 0 || window != top) && !dont_open_new_ui_tab){
            var parentTab = $(sender).parents('.ui-tabs-panel');
            return UI.NavigateNewTab(href, parentTabs, _window);
        }
        else{
            if(!$(sender).is('form')){
				//Track Download?
				var _frameElm = window.frameElement;
				if(href.match(/(fpdf|fileopen)\.php/)) href += href.indexOf('?') != -1 ? '&trackdownload=1' : '?trackdownload=1';
				if(href.match(/[\?&]trackdownload=1/) && typeof(_frameElm) != 'undefined' && _frameElm){
					frameUITrackObjIndex = 'frameTrackDownload_'+_frameElm.internal_frame_id;

					//Append tracking ID
					if(href.match(/(fileopen)\.php/)) top.UI.setFrameContentsAsNotLoading(_frameElm);
					else {
						top.UI.setFrameContentsAsLoading(_frameElm);
						top.UI[frameUITrackObjIndex] = {};
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_uuid = get_uuid();
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete = false;
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_functionCheckIsComplete = (function(frameUITrackObjIndex){
							top.$.fetch(this.url, 
								function(r){
									//Success, file found
									top.UI[frameUITrackObjIndex].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
									//Complete
									if(r != '0'){
										var setTitle = null;
										var setSubTitle = null;
										if(r != '1'){
											var lines = r.split("\n");
											setTitle = typeof(lines[0]) == 'undefined' ? null : lines[0];
											setSubTitle = typeof(lines[1]) == 'undefined' ? null : lines[1];
										}
										top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete = true;
										top.UI.setFrameContentsAsNotLoading(_frameElm, setTitle, setSubTitle);
									}
								},
								function(){
									//Timeout, never found the tracking file...
									if((new Date()).getTime() - top.UI[frameUITrackObjIndex].processView_FormTrackDownload_lastSuccess > 8000 /*8s*/){
										top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete = true;
										top.UI.setFrameContentsAsNotLoading(top.UI[frameUITrackObjIndex]);
									}
			
									//Try again...
									else if(!top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete){
										setTimeout(function(){
											top.UI[frameUITrackObjIndex].processView_FormTrackDownload_functionCheckIsComplete(frameUITrackObjIndex);
										}, 1000);
									}
								});
						}).bind({
							url: NP_BASE_URL+IMAGE_UPLOAD_DIR+'/temp/frmDownload.'+top.UI[frameUITrackObjIndex].processView_FormTrackDownload_uuid+'.tmp'
						});
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_functionCheckIsComplete(frameUITrackObjIndex);
						href += '&form_track_download_uuid='+top.UI[frameUITrackObjIndex].processView_FormTrackDownload_uuid;
					}
				}

                if(is_redirect)
                    location.href = href;
                else
                    location.replace(href);
            }
            else{
                return true;
            }
        }
        
        //_window.$('div.pace.pace-inactive').removeClass('pace-inactive').addClass('pace-active');
        return false;
    },
    NavigateNewTab: function(href, parentTabs, _window){            
        if(typeof(_window) == 'undefined') _window = window;
        if(typeof(window.NavigateTabCount) == 'undefined') window.NavigateTabCount = -1;
        window.NavigateTabCount++;

        var tabTemplate = "<li><a href='#{href}'>#{label}</a></li>";
        var label = "...";
        var id = 'tabs-Navigate-'+window.NavigateTabCount;
        var li = _window.$( tabTemplate.replace( /#\{href\}/g, "#" + id ).replace( /#\{label\}/g, label ) );
        var dl = _window.$("<span class='ui-icon ui-icon-close' role='presentation'>X</span>");
        li.addClass('ui-tabs-iframed').addClass('tabsViewItem');
        dl.click(function(){
            var tabs = _window.$(this.parentNode.parentNode);
            var li = this.parentNode;
            var div = _window.$('div[aria-labelledby="'+_window.$(li).attr('aria-labelledby')+'"]');
            li.remove();
            div.remove();
            var lis = tabs.find('li');
            lis = lis[lis.length - 1];
            _window.$(lis).find('a').click();
        });
        li.append(dl);
        var tabContentHtml = "Tab Content.";

        parentTabs.find( ".ui-tabs-nav" ).append( li );
        parentTabs.tabs( "refresh" );
        var a = li.find('a');
        li.css('cursor', 'pointer').click(function(e){
            if(e.target != this) return;
            _window.$(this).find('a').click();
        });
        a.click();
        
        var div = _window.$('div[aria-labelledby="'+a[0].id+'"]');
        var frame = _window.$('<iframe>');
        href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe';
        frame.attr('src', href);
        frame.attr('seemless', 'seemless');
        frame.addClass('tabed-frame');
        div.append(frame);
        frame[0].tab      = li.find('a')[0];
        frame[0].closeTab = function(){ dl.click(); }
        frame[0].setTitle = function(title, subtitle){
        	var html = UI.MenuItemGetTabTitleHtml(title, subtitle);
            $(frame[0].tab).html(html);
            top.UI.resize();
        }
        frame.load(function(){
            var elm  = frame[0].contentWindow.document.getElementById('pagetitle');
            var elm2 = frame[0].contentWindow.document.getElementById('pagesubtitle');
            if(elm != null || elm2 != null) frame[0].setTitle((elm != null) ? $(elm).html() : '', (elm2 != null) ? $(elm2).html() : '');
        });
        
        if(typeof(event) != 'undefined' && event != null){
            event.preventDefault();
            event.stopPropagation();
        }
        
        return false;
    },

    revalidateFrameSize: function(frame, applyMinHeight){
    	if(typeof(applyMinHeight) == 'undefined') applyMinHeight = true;
    	if(typeof(frame) == 'undefined') frame = window.frameElement;
    	if(typeof(frame.contentWindow) == 'undefined') return;
        if($(frame.parentNode).is('.ui-tabs-panel')){
            if($(frame.parentNode).attr('aria-hidden') == 'true')
                return;//Parent Tab is hidden
            if($(frame.parentNode.parentNode.parentNode).is('.main_index_page') && frame.parentNode.parentNode.parentNode.style.display != 'block')
                return;//Parent of parent tab is hidden
        }
        var view        = UI.uiView;
        var view_pt     = 0;
        var view_pb     = 0;
        if(typeof(view) != 'undefined' && view != null){
	        view_pt = $(view).css('padding-top');    view_pt = typeof(view_pt) != 'undefined' && view_pt != null ? parseInt(view_pt.replace(/[^\d]/g)) : 0;
	        view_pb = $(view).css('padding-bottom'); view_pb = typeof(view_pb) != 'undefined' && view_pb != null ? parseInt(view_pb.replace(/[^\d]/g)) : 0;
		}
        var padding     = view_pt + view_pb;
        var viewOffset  = $(view).offset();
        var tableOffset = $(frame).offset();
        var topOffset   = tableOffset.top - (typeof(viewOffset) != 'undefined' ? viewOffset.top : 0);
        var minH        = applyMinHeight ? ($(view).height() - topOffset) + padding : 0;
		var frameInnerBody = frame.contentWindow.document.documentElement != null ? frame.contentWindow.document.documentElement.getElementsByTagName('body') : null;
		if(typeof(frameInnerBody) == 'undefined' || frameInnerBody == null || typeof(frameInnerBody[0]) == 'undefined') frameInnerBody = null;
		else frameInnerBody = $(frameInnerBody[0]);
		var frameInnerHeightScrollHeight = frameInnerBody ? frameInnerBody[0].scrollHeight : 0;
		var frameInnerHeightHeight = frameInnerBody ? frameInnerBody.height() : 0;
		var innerViewScroll = frame.contentWindow.document.getElementById('section_view');
		var innerViewScrollHeight = innerViewScroll == null || typeof(innerViewScroll) == 'undefined' ? 0 : innerViewScroll.scrollHeight;
		if(minH < frameInnerHeightScrollHeight) minH = frameInnerHeightScrollHeight;
		if(minH < frameInnerHeightHeight) minH = frameInnerHeightHeight;
		if(minH < innerViewScrollHeight) minH = innerViewScrollHeight;
        $(frame).hide().css('height', minH+'px').show();
        $(frame.contentDocument.body).css('overflow', 'auto');  
    },
    reload_css: function(){
        $('head link').each(function(){
            if($(this).attr("type").indexOf("css") > -1)
                $(this).attr('href', $(this).attr('href')+'&jsrefresh='+new Date().getMilliseconds());
        });   
    },
    
    HandleGlobalKeyPress: function(e){
        var chr = String.fromCharCode(e.which);
        var scroll_speed = 32;
        var page_down_speed = UI.window_height / 2;
        
        //Handle Alt Shortcuts
        if(e.altKey && e.ctrlKey && typeof(UI.altKeyEvents[chr]) != 'undefined') return $(UI.altKeyEvents[chr]).click();
        
        //Handle View Scroll Keys
        if(e.keyCode >= 37 && e.keyCode <= 40){
            if(e.keyCode == 40)//Down
                UI.Scroll(0, scroll_speed);
            else if(e.keyCode == 38)//Up
                UI.Scroll(0, -scroll_speed);
            else if(e.keyCode == 37)//Left
                UI.Scroll(-scroll_speed, 0);
            else if(e.keyCode == 39)//Right
                UI.Scroll(scroll_speed, 0);
        }
        if(e.keyCode == 34)//Page Down
            UI.Scroll(0, page_down_speed);
        else if (e.keyCode == 33)//Page Up
            UI.Scroll(0, -page_down_speed);
    },
    AssignAltKey: function(elm){
return false;
        /*var assigned = '';
        for(var i in UI.altKeyEvents) assigned += i;
        
        if(typeof(elm.assignAltKeyRanOnce) != 'undefined') return;
        elm.assignAltKeyRanOnce = true;

        var val = $(elm).text();
        var key = false;
        var orgKey = false;
        for(var i in val){
            var c = val[i].toLowerCase();
            if(assigned.indexOf(c) == -1){
                key = c;
                orgKey = val[i];
                break;
            }
        }
        if(key){
            $(elm).html($(elm).html().replace(new RegExp(key, 'i'), '<u>'+orgKey+'</u>'));
            $(elm).attr('title', 'CTRL + ALT + '+ key.toUpperCase());
            assigned += key;
            UI.altKeyEvents[key] = elm;
        }*/
    },
	DirectAssignAltKey: function(elm, key){
		if(1) return false;//Doesn't work in chrome... so skipping
	    var assigned = '';
	    for(var i in UI.altKeyEvents) assigned += i;
	    
	    if(typeof(elm.assignAltKeyRanOnce) != 'undefined') return;
	    elm.assignAltKeyRanOnce = true;

	    $(elm).html($(elm).html().replace(new RegExp(key.toUpperCase(), ''), '<u>'+key.toUpperCase()+'</u>').replace(new RegExp(key.toLowerCase(), ''), '<u>'+key.toLowerCase()+'</u>'));
	    $(elm).attr('title', 'CTRL + ALT + '+ key.toUpperCase());
	    assigned += key;
	    UI.altKeyEvents[key] = elm;
	},
    Scroll: function(x, y){
        if(!$(document.activeElement).is('iframe')){
            var target = null;
            var activeIframe = $((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView > div[aria-hidden="false"] > iframe');
            if(activeIframe.length > 0)
                if($(activeIframe[0].contentDocument.body).css('overflow') != 'hidden')
                    target = activeIframe[0].contentDocument.body;
                else
                    target = $(activeIframe[0].contentDocument.body).find('#section_view')[0];
            else
                target = $('#section_view')[0];
                
            if(typeof(target) == 'undefined' || target == null) target = document.body;
                
            target.scrollTop  = Math.max(0, Math.min(target.scrollHeight, target.scrollTop  + y));
            target.scrollLeft = Math.max(0, Math.min(target.scrollWidth,  target.scrollLeft + x));
        }
    },
    
    show_loading: function(elm){
    	if(typeof(elm) == 'undefined'){
	        if(top != self) return top.UI.show_loading();
		}
		else{
			elm = $(elm);
			if(typeof(elm[0].ui_loading_elm) == 'undefined') elm[0].ui_loading_elm = false;
			if(!elm.ui_loading_elm){
				var loadingelm = $('<div><img style="width: 16px; height: 16px;" src="images/loading_small.gif"></div>');
				var parent = elm[0].parentElement;
				while($(parent).is('.selectOverlay, .checkboxOverlay, .radioOverlay, .ui-autocomplete-input-container')) parent = parent.parentElement;
				var position = $(parent).position();
				loadingelm.css('position', 'absolute').css('left', (position.left+(elm.outerWidth())-20)+'px').css('top', (position.top+4)+'px');
				loadingelm.appendTo(parent);
				elm[0].ui_loading_elm = loadingelm[0];
			}
		}
    },
    hide_loading: function(elm){
    	if(typeof(elm) == 'undefined'){
	        if(top != self) return top.UI.hide_loading();
	    }
	    else{
			elm = $(elm);
			if(typeof(elm[0].ui_loading_elm) == 'undefined') elm[0].ui_loading_elm = false;
			if(elm[0].ui_loading_elm !== false){
				$(elm[0].ui_loading_elm).remove();
				elm[0].ui_loading_elm = false;
			}
	    }
    },
    
    invalidate_db_table: function(table, window_target){
    	if(typeof(window_target) == 'undefined') window_target = top;
    	if(typeof(window_target.$) == 'undefined') return;
    	window_target.$('iframe[refresh_by_db_table]').each(function(){
    		if($(this).attr('refresh_by_db_table') == table){
    			this.contentWindow.location.reload();
			}
		});
		
		window_target.$('iframe').each(function(){
			UI.invalidate_db_table(table, this.contentWindow);
		});
	},
	
	selectTabFromTabView: function(sender, tab_title){
		var tabsView = $(sender).parents('.tabsView');
		if(tabsView.length == 0 && typeof(window.frameElement) != 'undefined')
			tabsView = window.frameElement.contentWindow.$(window.frameElement).parents('.tabsView');
		if(tabsView.length == 0) return false;//not found..
		var target = $($(tabsView).get(0)).find('ul.ui-tabs-nav > li.tabsViewItem[tab_title="'+tab_title+'"] > a');
		target[0].click();
	},
	
	bindContextMenu: function(target_elm, items, appendTo){
		if(typeof(appendTo) == 'undefined') appendTo = $('body')[0];
		if(typeof(target_elm) == 'undefined') return;
		if(typeof(target_elm.length) != 'undefined') target_elm = target_elm[0];
		
		target_elm.context_items = items;
		$(target_elm).bind("contextmenu", function(event) {
			event.preventDefault();
			var html = '';
			
			var menu = $("<div class=\"context-menu\">");
			var menu_inner = $("<div class=\"context-menu-inner\">");
			menu_inner.appendTo(menu);
			
			for(var item_index in this.context_items){
				var item = this.context_items[item_index];
				var a = $('<a>');
				a.appendTo(menu_inner);

				//img
				if(typeof(item.image) != 'undefined'){
					var a_img = $('<img>');
					a_img.attr('src', item.image);
					a_img.addClass('context-menu-inner-list-icon');	
					a_img.appendTo(a);
				}
				
				//Label
				var a_label = $('<span>');
				a_label.text(item.label);
				a_label.appendTo(a);
				
				//Href
				if(typeof(item.href) != 'undefined') a.attr('href', item.href);
				else a.attr('href', 'javascript:void(0);');
				
				//Click
				if(typeof(item.onclick) != 'undefined'){
					a[0]._onclick = item.onclick;
					a[0]._menu = menu;
					a.click(function(e){
						if(!(this._onclick.bind(target_elm))(e)){
							if(e.which == 1)//Left Mouse
								$(this._menu).remove();
						}
					});
				}
				
			}
			
			menu.appendTo(appendTo)
				.css({top: (event.pageY - 20) + "px", left: (event.pageX - 20) + "px", position: 'fixed'})
				.css('z-index', 9999)
				.mouseover(function(){ this.hasMouse = true; })
				.mouseleave(function(){ if(typeof(this.hasMouse) != 'undefined'){ $(this).remove(); } })
		});
	},
	
	MenuItemGetTabTitleHtml: function(title, subtitle){
		var html = '';
		if(title && subtitle){
			html = '<div style="font-size: 10px; margin-top: 5px; text-decoration: underline; overflow: hidden; line-height: 11px; text-overflow: ellipsis;">'+title+'</div><div style="overflow: hidden; line-height: 20px; text-overflow: ellipsis;">'+subtitle+'</div>';
		}
		else if(title && !subtitle){
			html = title;
		}
		else if(!title && subtitle){
			html = subtitle;
		}
		return html;
	},
	
	texttitle: function(title, subtitle){
		if(typeof(title) == 'undefined') title = '';
		if(typeof(subtitle) == 'undefined') subtitle = '';
		if(title) {
			var elm_pagetitle        = document.getElementById('pagetitle');
			var elm_pagetitle_hidden = document.getElementById('pagetitle_hidden');
			var pageTitle = title;
			if(subtitle != '') pageTitle += '<'+'span class="pagetitle-subtitle"> '+subtitle+'<'+'/'+'span>';
			if (elm_pagetitle)        elm_pagetitle.innerHTML = pageTitle;
			if (elm_pagetitle_hidden) elm_pagetitle_hidden.style.display = 'block';
		}
		if(typeof(window.frameElement) != 'undefined' && window.frameElement != null && typeof(window.frameElement.setTitle) != 'undefined'){
			window.frameElement.setTitle(title, subtitle);
		}
		UI.onWindowResize_CenterPageTitle();
	},
	
	listenForUIAlerts: function(){
		UI.refreshUIAlerts(true, true);
    },
    refreshUIAlerts: function(isFirstCall, auto_call_again){
        if(typeof(isFirstCall) == 'undefined') isFirstCall = false;
        if(typeof(auto_call_again) == 'undefined') auto_call_again = false;
        var url = window.CI_BASE_URL+'main/uiAlertMessages/?&NO_USER_ACTIVITY=1';
        if(isFirstCall) url += '&isFirstCall=1';
		$.get(url).done(function(data){
			var something_removed = false;
			for(var _uuid in data){
				var uuid = 'uialert_uuid_'+_uuid;
				var r = data[_uuid];
				if(typeof(r['delete']) != 'undefined'){
					$('#'+uuid).remove();
					something_removed = true;
				}
				else if(typeof(r['text']) != 'undefined'){
					$('#'+uuid).remove();
					r.uuid = uuid;
					UI.addUIAlert(r);
				}
			}
			if(something_removed) UI.revalidateUIAlertsButtonVisiblity();
            var elm = $('#uiTopBar_AlertsPane')[0];
            if(typeof(elm) != 'undefined'){
                if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;
                if(!elm._isOpened) UI.hideUIAlertsPane();
            }
		}).always(function(){
            if(auto_call_again) setTimeout(function(){ UI.refreshUIAlerts(false, true) }, 60000);
		})
	},
	addUIAlert: function(msg_object){
		if(typeof(msg_object) == 'undeinfed') msg_object = {};
		var uuid    = typeof(msg_object.uuid)    == 'undeinfed' ? 'uialert_uuid_is_undefined' : msg_object.uuid;
		var text    = typeof(msg_object.text)    == 'undeinfed' ? '' : msg_object.text;
		var onclick = typeof(msg_object.onclick) == 'undeinfed' ? '' : msg_object.onclick;
		var auto_remove = typeof(msg_object.auto_remove) == 'undeinfed' ? true : (msg_object.auto_remove ? true : false);
		$('<div class="uiAlertMessage">').attr('id', uuid)
			.html('<span class="imgSmallMail" style="margin-right: 8px;"></span>'+text)
			.attr('onclick', (auto_remove ? '$(this).remove();' : '')+'UI.hideUIAlertsPane(true);UI.revalidateUIAlertsButtonVisiblity();'+onclick)
			.appendTo('#uiTopBar_AlertsPane');
		UI.showUIAlertsButton(true);
	},
	showUIAlertsButton: function(ring_animation){
		$('#uiTopBarAlertsBtn').css('display', '');
		UI.onWindowResize_CenterPageTitle();
		
		if(ring_animation){
			var bell = $('#uiTopBarAlertsBtn .imgAlert');
			if(!bell.is('animation_shake')) bell.addClass('animation_shake');
		}
	},
	hideUIAlertsButton: function(){
		$('#uiTopBarAlertsBtn .imgAlert').removeClass('animation_shake')
		$('#uiTopBarAlertsBtn').css('display', 'none');
		UI.onWindowResize_CenterPageTitle();
	},
	revalidateUIAlertsButtonVisiblity: function(){
		if($('#uiTopBar_AlertsPane > div.uiAlertMessage').length == 0){
			UI.hideUIAlertsButton();
		}
		else{
			UI.showUIAlertsButton();
		}
	},
	
	refreshUIPaxTerminalDetails: function(){
		$('.menuTopPaxTerminalDetails').load(window.CI_BASE_URL+'ccterminal/selectedTerminalDetails/', '', function(){
			//Reposition the settings menu (in case size changed)
			var elm = $('#uiTopBar_SettingsPane')[0];
	        if(typeof(elm) != 'undefined'){
        		if(!elm._isOpened){
        			var x = UI.animationSpeedFloatingPanes;
        			UI.animationSpeedFloatingPanes = 0;
					UI.hideUserSettingsPane();
					UI.animationSpeedFloatingPanes = x;
				}
			}
		});
	},
	showPaxTerminalSelect: function(){
		$.post(CI_BASE_URL+'ccterminal/selectTerminal/', {}, function(r){
			if(r.assigned){	}
			else{
				window.UI_collectPaxTerminalPaymentAjax_active_select_dialog = $('<div>').html(r.html).dialog({modal: true, width: 400, title: window.STR_SELECT_A_CC_TERMINAL});
			}
		});
		UI.refreshUIPaxTerminalDetails();
	},
	detachPaxTerminalSelection: function(){
		$.get(window.CI_BASE_URL+'ccterminal/selectTerminal/?&unset=1', function(){ UI.refreshUIPaxTerminalDetails(); });
	},
	
	MobileCollapsedTableOpenRecord: function(collapsed_table, row_index){
		var body = $('<tbody>');
		var data = $(collapsed_table.parent).children('tbody');
		if(typeof(data) == 'undefined') return;
		var record_count = data.children('tr').length;
		data = data.children('tr')[row_index];
		if(typeof(data) == 'undefined') return;
		data = $(data).children('th, td');

		//Set On Change Hooks
		var c = 0;
		data.each(function(){
			if(typeof(this.MobileCollapsedTableOpenRecord_OnChangeHook) == 'undefined'){
				this.MobileCollapsedTableOpenRecord_OnChangeHook = true;
				$(this).find('input, textarea, select').each(function(){
					this.parent_collapsed_table = collapsed_table;
					this.parent_collapsed_table_row_index = row_index;
					this.parent_collapsed_table_data_index = c;
					$(this).change(function(){
						UI.MobileCollapsedTableOpenRecord_ParentInputOnChange(this);
					});
				});
			}
			c++;
		});
		
		//Clone Elms
		var i = 0;
		$(collapsed_table.header_row).children('*').each(function(){
			if(typeof(data[i]) != 'undefined'){
				
				$(data[i]).find('input').each(function(){
					if($(this).is('[type="checkbox"]'))
						if(this.checked)
							$(this).attr('checked', 'checked');
						else
							$(this).removeAttr('checked');
					$(this).attr('value', $(this).val());
				});

				var value = $(data[i]).html();
				
				
				var title = $(this).text().trim() != '' ? $(this).html().replace(/\:$\s*$/, '')+': ' : '';
				var tr = $('<tr>');
				var th = $('<th style="text-align: left; border-radius: 0;">').html(title).appendTo(tr);
				var td = $('<td>').html(value).appendTo(tr);
				td.find('script').remove();
				td.find('span.checkboxOverlay').remove();
				td.find('input[type="checkbox"].was-styled').removeClass('was-styled');
				td.find('input, select, textarea').each(function(){
					this.parent_collapsed_table = collapsed_table;
					this.parent_collapsed_table_row_index = row_index;
					this.parent_collapsed_table_data_index = i;
					this.parent_collapsed_table_td = data[i];
					$(this).change(function(){
						UI.MobileCollapsedTableOpenRecord_ChildInputOnChange(this);
					});
				});
				tr.appendTo(body);
			}
			i++;
		});
		
		//Build Navigation Controls
		{
			var thead = $('<thead>');
			var tfoot = $('<tfoot>');
			var trNav = $('<tr>');
			var thNav = $('<th colspan=2>').appendTo(trNav);
			var tableNav = $('<table class="report notablesorter" style="width: 100%; border: 0; outline: 0; margin: 0; padding: 0; box-shadow: none; margin-bottom: 4px;">').appendTo(thNav);
			var tableNavTR = $('<tr>').appendTo(tableNav);
			
			//Back Button
			var backEnabled = row_index > 0;
			var tdBack = $('<th class="nofloat" style="font-size: 0.8em; text-align: left; '+(backEnabled ? '' : 'visibility: hidden;')+'"></th>').appendTo(tableNavTR);
			var aBack = $('<a onclick="UI.MobileCollapsedTableOpenRecord($(\'#'+$(collapsed_table).attr('id')+'\')[0], '+(row_index - 1)+')" href="javascript:void(0);" style="line-height: 16px;"><img style="width: 24px; height: 24px; margin-bottom: -8px; margin-right: 8px;" src="'+window.ICON_URL+'back.png">'+window.STR_BACK+'</a>').appendTo(tdBack);
			
			//Title
			var tdTitle = $('<th class="nofloat" style="font-size: 0.8em; text-align: center;"></td>');
			$('<span>').text(window.STR_PAGE+': '+(row_index+1)+'/'+record_count.toString()).appendTo(tdTitle);
			tdTitle.appendTo(tableNavTR);
			
			//Next Button
			var nextEnabled = row_index + 1 < record_count;
			var tdNext = $('<th class="nofloat" style="font-size: 0.8em; text-align: right; '+(nextEnabled ? '' : 'visibility: hidden;')+'"></th>').appendTo(tableNavTR);
			var aNext = $('<a onclick="UI.MobileCollapsedTableOpenRecord($(\'#'+$(collapsed_table).attr('id')+'\')[0], '+(row_index + 1)+')" href="javascript:void(0);" style="line-height: 16px;">'+window.STR_NEXT+'<img style="width: 24px; height: 24px; margin-bottom: -8px; margin-left: 8px;" src="'+window.ICON_URL+'next.png"></a>').appendTo(tdNext);
			
			thead.append(trNav.clone());
			tfoot.append(trNav);
		}
		
		//Update Display's HTML
		collapsed_table.active_row = -1;
		$(collapsed_table).empty().append(thead).append(body).append(tfoot);
		UI.processView_ElementsStyle(collapsed_table);
		collapsed_table.active_row = row_index;
	},
	MobileCollapsedTableOpenRecord_ParentInputOnChange: function(sender){
		var tbody = $(sender.parent_collapsed_table).children('tbody');
		if(sender.parent_collapsed_table.active_row == sender.parent_collapsed_table_row_index){
			var tr = tbody.children('tr')[sender.parent_collapsed_table_data_index];
			var td = $(tr).children('td')[0];
			$(td).find(sender.tagName).each(function(){
				if($(this).attr('name') == $(sender).attr('name') && $(this).attr('id') == $(sender).attr('id')){
					if(sender.tagName == 'INPUT' && $(this).attr('type').toLowerCase() == 'checkbox'){
						this.checked = sender.checked;
						$(this).prop('checked', this.checked);
					}
					else
						$(this).val($(sender).val());
				}
			});
		}
	},
	MobileCollapsedTableOpenRecord_ChildInputOnChange: function(sender){
		$(sender.parent_collapsed_table_td).find(sender.tagName).each(function(){
			if($(this).attr('name') == $(sender).attr('name') && $(this).attr('id') == $(sender).attr('id')){
				if(sender.tagName == 'INPUT' && $(this).attr('type').toLowerCase() == 'checkbox'){
					this.checked = sender.checked;
					$(this).prop('checked', this.checked);
				}
				else
					$(this).val($(sender).val());
			}
		});
	},
	
	MobileToogleLeftMenu: function(){
		if(typeof(UI.MobileToogleLeftMenu_LastValue) == 'undefined') UI.MobileToogleLeftMenu_LastValue = false;
		if(UI.MobileToogleLeftMenu_LastValue){
			UI.MobileHideLeftMenu();
		}
		else{
			UI.MobileShowLeftMenu();
		}
	},
	MobileHideLeftMenu: function(instant){
		if(!window.isMobile) return;
		if(typeof(instant) == 'undefined') instant = false;
		UI.MobileToogleLeftMenu_LastValue = false;
		
		var h = $('#uiLeftBarBackground').fullHeight();
		if(instant){
			$('#uiLeftBar').css('position', 'relative').css('top', (-1*h)+'px');
		}
		else{
			$('#uiLeftBar').css('position', 'relative').animate({top: (-1*h)+'px'}, 333);
		}
	},
	MobileShowLeftMenu: function(instant){
		if(!window.isMobile) return;
		if(typeof(instant) == 'undefined') instant = false;
		UI.MobileToogleLeftMenu_LastValue = true;
		
		var top = $('#uiTopBar').fullHeight();
		if(instant){
			$('#uiLeftBar').css('position', 'relative').css('top', top+'px');
		}
		else{
			$('#uiLeftBar').css('position', 'relative').animate({'top': top+'px'}, 333);
		}
	},

	onTableChange: function(tablename_params){
		for(var i in arguments){
			var tablename = arguments[i];
			if(top.UI != window.UI){
				top.UI.onTableChange(tablename);
			}
			else {
				if(typeof(UI.dataTable_RegisteredTableUse[tablename]) != 'undefined'){
					for(var i in UI.dataTable_RegisteredTableUse[tablename]){
						UI.dataTable_RegisteredTableUse[tablename][i].needs_refreshed = true;
					}
				}
			}
		}
	},
	dataTable_RegisterTableUse: function(datatable, tablename){
		if(top.UI != window.UI) return top.UI.dataTable_RegisterTableUse(datatable, tablename);
		if(typeof(UI.dataTable_RegisteredTableUse[tablename]) == 'undefined') UI.dataTable_RegisteredTableUse[tablename] = [];
		UI.dataTable_RegisteredTableUse[tablename].push(datatable);
	}
}

var Menu = function(text, _class){
    this.text  = text;
    this.items = [];
    this._class = _class;

    this.createMenu = function(){
        $('#uiLeftBar').empty()
        
        if($('#uiLeftBar').length == 0) return;
        var eLoc = $('#uiLeftBar')[0];
        var eBackground = document.createElement('div');
        eBackground.id  = 'uiLeftBarBackground';
        var eList = document.createElement('ul');
        eList.id = 'uiLeftItems';
        eBackground.appendChild(eList);
        eLoc.appendChild(eBackground);
        UI.createMenu_sub(UI.mainMenu, eList);
    };
    
    this.addItem = function(menu_item){
        this.items.push(menu_item);
        this.createMenu(UI.menuType); 
        uiWaitForFinalEvent(UI.onWindowResize, 25, "ID_Resize_WaitA");
    };
    
    this.removeItem = function(page){
        var found = -1;
        for(var i = 0; i < this.items.length; i++){
            if(this.items[i].link == page){
                found = i;
                break;
            }
        }
        if(found == -1) return;
        
        this.items.splice(found, 1);
        
        this.createMenu(UI.menuType); 
        uiWaitForFinalEvent(UI.onWindowResize, 25, "ID_Resize_WaitA");
    };
}
var MenuItem = function(text, _class, link, action, subTitle){
    this.text     = text;
    this.subTitle = typeof(subTitle) == 'undefined' ? '' : subTitle;
    this._class   = _class;
    this.link     = link;
    this.action   = typeof(action) == 'undefined' ? false : action;//On Click Function(sender)
    this.menu     = null;
    this.internal_frame_id = null;

    this.getElement = function(){

        var li = document.createElement('li');
        li.internal_frame_id = this.internal_frame_id;
        li.link = this.link;
        li.doDrag = false;
        li.doDragStartX = 0;
        li.doDragStartY = 0;
        $(li).addClass('menu-level-0 menu-left menu-left-level-0 menu-type-'+UI.menuType);
        if(this.action)
            $(li).click(this.action);
        else
            $(li).click(function(event){if(!event.isDefaultPrevented()){ UI.loadFromMainMenu(this.link, this); event.preventDefault(); }});
        $(li).css('user-select', 'none');
        $(li).css('overflow', 'visible');
        $(li).attr('menu_link', this.link);
        $(li).mouseenter(function(){ UI.animateLeftMenuSizes( $(this).index() );} );
        
        //Drag & Close Gesture
        li.startDrag = function(x, y){
            if(typeof(this.internal_frame_id) == 'undefined' || this.internal_frame_id == null) return;
            this.doDrag = true;
            this.doDragStartX = x;
            this.doDragStartY = y;
        };
        li.endDrag = function(){
            this.doDrag = false;
            $(this).css('margin-left', '0px');
        };
        li.updateDrag = function(x, y){
            if(!this.doDrag) return;
            var xDiff = x - this.doDragStartX;
            $(this).css('margin-left', xDiff+'px');
            
            var min = UI.mouseConfirmed ? 24 : 10;
            
            if(xDiff * -1 > min){
                if(typeof(this.internal_frame_id) != 'undefined')
                    UI.closeInternalTab(this.internal_frame_id);
            }
        };
        $(li).mousedown(function(event){ this.startDrag(event.pageX, event.pageY); });
        $(li).mouseleave(function(){ this.endDrag(); });
        $(li).mouseup(function(){ this.endDrag(); });
        $(li).mousemove(function(event){
            var x = event.pageX;
            var y = event.pageY;
            this.updateDrag(x, y);
        });
        $(li).on('touchstart', function(event){ 
            var x = event.originalEvent.touches[0].pageX;
            var y = event.originalEvent.touches[0].pageY;
            this.startDrag(x, y);
        });
        $(li).on('touchmove', function(event){ 
            var x = event.originalEvent.touches[0].pageX;
            var y = event.originalEvent.touches[0].pageY;
            this.updateDrag(x, y);
        });
        $(li).on('touchend', function(event){ this.endDrag(); });
        $(li).on('touchleave', function(event){ this.endDrag(); });
        
        var header = document.createElement('div');
        var headerImage = document.createElement('span');
        var headerText  = document.createElement('span');
        $(headerImage).addClass(this._class);
        $(headerImage).css('user-select', 'none');
        $(header).css('user-select', 'none');
        $(headerText).html(UI.MenuItemGetTabTitleHtml(this.text, this.subTitle));
        $(headerText).addClass('itemText');
        $(headerText).css('user-select', 'none');
        $(li).bind("contextmenu", function(event) {
            event.preventDefault();
            
            var internal_tab = $(this).find('.internal_tab').length > 0;
            
            var html = '';
            html += "<div class=\"context-menu\">";
            html += "   <div class=\"context-menu-inner\">";
            if(internal_tab){
	            html += "   <a href=\"javascript:void(0);\" onclick=\"$('#main_index_page_"+$(this).attr('menu_link')+"').children('iframe').get(0).contentWindow.location.reload();\">";
	            html += "		<img src=\""+ICON_URL+"/refresh.png\" class=\"context-menu-inner-list-icon\" >";
	            html +=         window.STR_REFRESH;
	            html += "   </a>";
                html += "   <a onclick=\"UI.closeInternalTab('"+this.internal_frame_id+"'); $($(this).parents('.context-menu')[0]).remove();\" href=\"javascript:void(0);\">";
                html += "		<img src=\""+ICON_URL+"/closewindow.png\" class=\"context-menu-inner-list-icon\" >";
                html +=         window.STR_CLOSE;
                html += "   </a>";
            }
            else{
                html += "   <a href=\"javascript:void(0);\" onclick=\"UI.browserTab('"+CI_BASE_URL+"main/index/?&menu_page="+$(this).attr('menu_link')+"'); $($(this).parents('.context-menu')[0]).remove();\">";
                html += "		<img src=\""+ICON_URL+"/add.png\" class=\"context-menu-inner-list-icon\" >";
                html +=         window.STR_OPEN_IN_NEW_TAB;
                html += "   </a>";
            }
            html += "   </div>";
            html += "</div>";
            
            $(html)
                .appendTo("body")
                .css({top: (event.pageY - 20) + "px", left: (event.pageX - 20) + "px", position: 'fixed'})
                .css('z-index', 9999)
                .mouseover(function(){ this.hasMouse = true; })
                .mouseleave(function(){ if(typeof(this.hasMouse) != 'undefined'){ $(this).remove(); } })
        });
        
        header.appendChild(headerImage);
        header.appendChild(headerText);
        li.appendChild(header);
        
        //Close Btn
        
        if(typeof(li.internal_frame_id) != 'undefined' && li.internal_frame_id != null){
	        var btnClose = $('<div>');
	        btnClose.addClass('menu-left-level-0-close');
	        btnClose.text('X');
	        btnClose[0].internal_frame_id = li.internal_frame_id;
	        btnClose.click(function(){
            	UI.closeInternalTab(this.internal_frame_id);
			});
	        li.appendChild(btnClose[0]);
		}
		
        return [li];
    }
}

var MetaMenu = {
    
    debug_hold_destroy: false,
    
    processView_createMetaMenus: function(parent){
    	if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
        if(typeof(parent) == 'undefined') parent = $('body')[0];
        MetaMenu.processView_createMetaMenus_AutoTagMenuLinks(parent);
        if(window.meta_menu_adv_rights.arinvoice)      $(parent).find('.menu-invoice[menu_id], .menu-arinvoice[menu_id]').each( function(){ MetaMenu.metaMenu_Make(this, 'arinvoice'); });
        if(window.meta_menu_adv_rights.arorder)        $(parent).find('.menu-order[menu_id], .menu-arorder[menu_id]').each(   function(){ MetaMenu.metaMenu_Make(this, 'arorder');   });
        if(window.meta_menu_adv_rights.job)            $(parent).find('.menu-job[menu_id]').each(   function(){ MetaMenu.metaMenu_Make(this, 'job');   });
        if(window.meta_menu_adv_rights.customer)       $(parent).find('.menu-customer[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'customer');});
        if(window.meta_menu_adv_rights.chk)            $(parent).find('.menu-check[menu_id]').each(   function(){ MetaMenu.metaMenu_Make(this, 'check');   });
        if(window.meta_menu_adv_rights.gltransvoucher) $(parent).find('.menu-voucher[menu_id], .menu-gltransvoucher[menu_id]').each( function(){ MetaMenu.metaMenu_Make(this, 'gltransvoucher');   });
        if(window.meta_menu_adv_rights.vendor)         $(parent).find('.menu-vendor[menu_id]').each(  function(){ MetaMenu.metaMenu_Make(this, 'vendor');   });
        if(window.meta_menu_adv_rights.item)           $(parent).find('.menu-item[menu_id]').each( function(){ MetaMenu.metaMenu_Make(this, 'item');   });
	    if(window.meta_menu_adv_rights.arordership)    $(parent).find('.menu-shipment[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'arordership');});
    },
    processView_createMetaMenus_AutoTagMenuLinks: function(parent){
    	if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
        if(typeof(parent) == 'undefined') parent = $('body')[0];
        $(parent).find('.report a:not([menu_id]), .dataTable a:not([menu_id]), .report-light a:not([menu_id]), .form a:not([menu_id])').each(function(){
            if(typeof(this.menu_id) == 'undefined'){
                this.menu_id = null;
                if($(this).text() != "" && this.href.indexOf('#') == -1 && this.href.indexOf('javascript:') == -1){
                    //Match Orders
                    if(user_rights.ar.read)
	                    if(this.href.match(/(arordshipview\.php)/i) && this.href.match(/[&?](ordershipid)=([^&]*)/i)){
		                    var id = this.href.match(/[&?](ordershipid)=([^&]*)/i);
		                    id = id != null ? id[2] : null;
		                    this.menu_id = id;
		                    $(this).attr('menu_id', id).addClass('menu-shipment');
                            return;
	                    }
                        else if(this.href.match(/(arordshipview\.php|arordpicktick\.php|arserviceordtick\.php|arserviceordupd\.php|nporder\.php)/i)){
                            var id = this.href.match(/[&?](id|orderid)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            var ordernumber = this.href.match(/[&?]ordernumber=([^&]*)/i);
                            ordernumber = ordernumber != null ? ordernumber[1] : null;
                            id = id != null ? id : ordernumber;
                            this.menu_id = id;
                            $(this).attr('menu_id', id).addClass('menu-order');
                            return;
                        }
                    
                    //Match Invoices
                    if(user_rights.ar.read)
                        if(this.href.match(/(arinvoiceview\.php)/i)){
                            var id = this.href.match(/[&?](id|invoiceid)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            if(id != null){
                                this.menu_id = id;
                                $(this).attr('menu_id', id).addClass('menu-arinvoice');
                            }
                            return;
                        }

                    //Match Jobs
                    if(user_rights.ar.read || user_rights.ap.read)
                        if(this.href.match(/(jobupd\.php)/i)){
                            var id = this.href.match(/[&?](jobid)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            if(id != null){
                                this.menu_id = id;
                                $(this).attr('menu_id', id).addClass('menu-job');
                            }
                            return;
                        }

                    //Match Checks
                    if(user_rights.ap.read)
                        if(this.href.match(/(checks\.php)/i)){
                            var id = this.href.match(/[&?](checknbr)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            if(id != null){
                                this.menu_id = id;
                                $(this).attr('menu_id', id).addClass('menu-check');
                            }
                            return;
                        }
                    
                    //Match Vouchers
                    if(user_rights.gl.read)
                        if(this.href.match(/(voucherdetail\.php)/i)){
                            var id = this.href.match(/[&?](voucherid)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            if(id != null){
                                this.menu_id = id;
                                $(this).attr('menu_id', id).addClass('menu-voucher');
                            }
                            return;
                        }
                    
                    //Match Items
                    if(user_rights.ar.read || user_rights.ap.read || user_rights.inv.read)
                        if(this.href.match(/(invitemupd\.php)/i)){
                            var id = this.href.match(/[&?](itemid)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            if(id != null){
                                this.menu_id = id;
                                $(this).attr('menu_id', id).addClass('menu-item');
                            }
                            return;
                        }

                    //Match Customers
                    if(user_rights.ar.read)
                        if(this.href.match(/(arinvoicerepcust\.php|arcustupd\.php)/i)){
                            var id = this.href.match(/[&?](customerid)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            if(id != null){
                                this.menu_id = id;
                                $(this).attr('menu_id', id).addClass('menu-customer');
                            }
                            return;
                        }
                    
                    //Match Vendors
                    if(user_rights.ap.read)
                        if(this.href.match(/(apvendupd\.php)/i)){
                            var id = this.href.match(/[&?](id)=([^&]*)/i);
                            id = id != null ? id[2] : null;
                            if(id != null){
                                this.menu_id = id;
                                $(this).attr('menu_id', id).addClass('menu-vendor');
                            }
                            return;
                        }
                }
            }
        });
    },

    metaMenu_Make: function(elm, type){
    	if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
        if($(elm).is('.menu-disabled')) return;

		var isMobileClickShow = $(elm).is('.menu-meta-mobile-first');
		var isClickShowAlways = $(elm).is('.menu-meta-always');

        var metaLinkContainer = $('<span>');
        metaLinkContainer.addClass('menu-meta-link-holder');
        if(!MetaMenu.debug_hold_destroy){
            metaLinkContainer.click((function(e){
				var showMetaMenuOnClick = this.isClickShowAlways || (this.isMobileClickShow && !UI.mouseConfirmed);

                if(!$(e.target).is('a') || showMetaMenuOnClick){
                    e.preventDefault();
					e.stopImmediatePropagation();

					if(showMetaMenuOnClick){
						if($(e.target).is('a')){
							$(e.target.parentNode).find('.menu-meta-drop-icon-span').click();
						}
						else if($(e.target).is('.menu-meta-link-holder')){
							$(e.target).find('.menu-meta-drop-icon-span').click();
						}
					}

                    return true; 
				}
            }).bind({isMobileClickShow: isMobileClickShow, isClickShowAlways: isClickShowAlways}));
            metaLinkContainer.mouseleave(function(){ 
            	$(this).find('.menu-meta-drop-menu-moat').remove();
            	$('.menu-meta-temp-style').each(function(){
            		$(this).css('z-index', this.org_z);
            		$(this).css('overflow', this.org_overflow);
				});
            });
        }

        $(metaLinkContainer).insertAfter(elm);
        $(metaLinkContainer).prepend($(elm).detach());
        
        var dropSpan = document.createElement('span');
        dropSpan.metaType = type;
        dropSpan.metaId = $(elm).attr('menu_id');
        $(dropSpan).addClass('menu-meta-drop-icon-span');
        $(dropSpan).attr('menu-menu-extra-uri', $(elm).attr('menu-menu-extra-uri'));
        $(dropSpan).appendTo(metaLinkContainer);
        $(dropSpan).click(function(event){ MetaMenu.metaMenu_DropIcon_OnClick(event, this); });
        
        var dropIcon = document.createElement('span');
        $(dropIcon).addClass('menu-meta-drop-icon');
        $(dropIcon).appendTo(dropSpan);
    },

    metaMenu_DropIcon_OnClick: function(event, sender){
        if(event.isDefaultPrevented()) return;
        event.preventDefault();
        event.stopPropagation();

        //Fixup <td> under-flow error
        var tdParent = null;
        var parentNode = sender.parentNode;
        for(var i = 0; i < 4; i++){
        	parentNode = parentNode.parentNode;
        	if(parentNode.tagName == 'TD' || parentNode.tagName == 'TH'){
        		tdParent = parentNode;
        		break;
			}
		}
		if(tdParent != null && ($(tdParent).css('z-index') == 'auto' || $(tdParent).css('z-index') == '0' || $(tdParent).css('z-index') == '1' || $(tdParent).css('z-index') == '' || $(tdParent).css('z-index') == null)){
			tdParent.org_z = $(tdParent).css('z-index');
			tdParent.org_overflow = $(tdParent).css('overflow');
			$(tdParent).css('z-index', '2').css('overflow', 'visible').addClass('menu-meta-temp-style');	
		}
        
        //Show Loading Menu...
        var menuMoat = document.createElement('div');
        $(menuMoat).addClass('menu-meta-drop-menu-moat');
        $(menuMoat).appendTo(sender);

        var menuContainer = document.createElement('div');
        $(menuContainer).addClass('menu-meta-drop-menu menu-meta-drop-menu-loading menu-meta-drop-menu-'+sender.metaType);
        $(menuContainer).text('...');
        $(menuContainer).appendTo(menuMoat);
        $(menuContainer).click(function(event2){
            event2.preventDefault();
        });
        var metaType  = typeof(sender.metaType) == 'undefined' ? $(sender).attr('menu_type') : sender.metaType;
        var metaId    = typeof(sender.metaId)   == 'undefined' ? $(sender).attr('menu_id')   : sender.metaId;
        var menuData  = typeof(sender.menuData) == 'undefined' ? ($(sender).is('a') ? $(sender).attr('menu_data') : $(sender).parents('.menu-meta-link-holder').find('a').attr('menu_data')) : sender.menuData;
		var extra_uri = typeof($(sender).attr('menu-menu-extra-uri')) == 'undefined' ? '' : $(sender).attr('menu-menu-extra-uri');
		var url       = CI_BASE_URL+escape(metaType)+'/metaMenu/'+parseInt(metaId)+'/?&tmpl=iframe&_salt='+Math.floor((Math.random()*999999)+1)+(!menuData ? '': '&'+menuData)+extra_uri;
		
        //Make AJAX Call...
        $.ajax({
            url: url,
            success: function(data, status, XHR){
                $(menuContainer).html(data);

                $(menuContainer).find('a').each(function(){
                	var href = $(this).attr('href');
                
                	var target = $(this).attr('target');
					if((typeof(target) == 'undefined')) $(this).attr('newtab', 'newtab');
					
                	if(typeof(href) == 'undefined' || !href.match(/^javascript:/)){
                		$(this).click(function(e){
                			if(top.UI.mainMenuMode != 'main_index'){
                				e.stopPropagation();
							}
                			else{
                				var target = $(this).attr('target');
								if((typeof(target) != 'undefined' && (target == '_blank' || target == '_new'))){
                					top.UI.browserTab(href);
		                            event.stopImmediatePropagation();
		                            event.preventDefault();
		                            event.stopPropagation();
		                            $('.menu-meta-drop-menu-moat').remove();
		                            return false;
								}
								else{
                					top.UI.open(href);
		                            event.stopImmediatePropagation();
		                            event.preventDefault();
		                            event.stopPropagation();
		                            $('.menu-meta-drop-menu-moat').remove();
		                            return false;
								}
							}
                		});
					}
                });
                MetaMenu.processView_createMetaMenus($(menuContainer)[0]);
                UI.processView_SetNavHooks();

                //Position Menu
                {
                    //Get Bounds
                    var view = $("#section_view");
                    var wW = UI.window_width;
                    var wH = UI.window_height;
                    
                    //Get Position On Screen
                    var off = $(menuContainer).offset();
                    var x = off.left;
                    var y = off.top;
                    var w = $(menuContainer).width();
                    var h = $(menuContainer).height();          
                    
                    //Flip Left
                    if(x+w>wW){
                        var marginLeft = w-12;
                        if(x - marginLeft < 0){
                            marginLeft = x - $('#uiLeftBarBackground').width();
                        }

                        $(menuContainer).css('margin-left', '-'+marginLeft+'px');
                    }
                    
                    //Flip Up
                    if(y+h>wH){
                    	if(y-h<0){//Maxed out to top...
	                        $(menuContainer).css('margin-top', '-'+(y-8)+'px');
	                        UI.revalidateFrameSize(window.frameElement);
						}
						else{
	                        $(menuContainer).css('margin-top', '-'+(h+2)+'px');
						}
                    }
                }

                $(menuContainer).find('.meta-menu-table-menu-expand').mouseenter(function(){
                    var menu = $(this).children('.meta-menu-table-menu-expand-content-moat');
                    $(menu).css('margin-left', '0').css('margin-top', '0');

                    //Get Bounds
                    var view = $("#subpage > .section > .section_content");
                    var wW = UI.window_width;
                    var wH = UI.window_height;
                    
                    //Get Position On Screen
                    var off = $(menu).offset();
                    var x = off.left;
                    var y = off.top;
                    var w = $(menu).outerWidth();
                    var h = $(menu).outerHeight();
                    
                    //Flip Left
                    if(x+w>wW){
                        $(menu).css('margin-left', '-'+(w+$(this).outerWidth())+'px');
                    }
                    
                    //Flip Up
                    if(y+h>wH){
                        var offY = (wH - (y+h));
                        $(menu).css('margin-top', offY+'px');
                    }
                    
                    
                });
            },
            error: function(){
                $(menuContainer).text('Connection error, failed to load.');
            }
        });
    }
}

var load = UI.load;
var popup = UI.popup;
top.shiftIsDown = false;
top.ctrlIsDown = false;
top.altIsDown = false;

$(window).resize(function(){ uiWaitForFinalEvent(UI.onWindowResize, 25, "ID_Resize_WaitA"); });
$(document).ready(UI.onDocumentReady);
$(document).mousemove(function(e){
	if(typeof(e.originalEvent) != 'undefined') e = e.originalEvent;
	var x = typeof(e.movementX) != 'undefined' ? e.movementX : (typeof(e.mozMovementX) != 'undefined' ? e.mozMovementX : (-1));
	var y = typeof(e.movementY) != 'undefined' ? e.movementY : (typeof(e.mozMovementY) != 'undefined' ? e.mozMovementY : (-1));
	if(x != 0 || y != 0) UI.mouseConfirmed = true;
	
	
    if(!top.had_safe_print && top.had_print && !top.unsafe_print_warning_shown){
		top.unsafe_print_warning_shown = true;
		
		top.setTimeout(function(){
			top.UI.toggleLinksPane();
			$('.print_link').css('color', 'red');
			setTimeout(function(){
				alert(STR_TO_ENSURE_A_CORRECT_PRINT_PLEASE_USE_PRINT_FROM_THE_LINKS_MENU);
			}, 10);
			setTimeout(function(){
				$('.print_link').css('color', '');
			}, 3000);
		}, 1);
	}
});
$(document).keypress(function(e){ top.UI.HandleGlobalKeyPress(e) });
$(document).keydown(function(event){
    if(event.which=="16")
        top.shiftIsDown = true;
    else if(event.which=="17")
        top.ctrlIsDown = true;
    else if(event.which=="18")
        top.altIsDown = true;
});
$(document).keyup(function(event){
    if(event.which=="16")
        top.shiftIsDown = false;
    else if(event.which=="17")
        top.ctrlIsDown = false;
    else if(event.which=="18")
        top.altIsDown = false;
});
$(document).ajaxSuccess(function() { uiWaitForFinalEvent(UI.processView_ajaxSuccess, 50, "ID_AJAX_SUCCCESS_WaitA"); });

window.onbeforeprint = UI.onBeforePrint;
window.onafterprint = UI.onAfterPrint;

UI.createMenu();

var uiWaitForFinalEvent = (function () {
    var timer_list = {};
    return function (callback, ms, Timer_Id){
        if (!Timer_Id) Timer_Id = "???";
        if (timer_list[Timer_Id]) clearTimeout (timer_list[Timer_Id]);
        timer_list[Timer_Id] = setTimeout(callback, ms);
    };
})();


//Disable JS Animations if is a mobile device or an old (XP) machine
var ua = navigator.userAgent.toLowerCase();
var isAndroid = ua.indexOf("android") > -1;
var isWinXP = ua.indexOf('windows nt 5.1') > 0;    
var isIOS = ua.match( /iPad/i ) || ua.match( /iPhone/i ) || ua.match( /iPod/i );
var isWinsTablet = ua.match( /Edge/i ) && (navigator.maxTouchPoints > 1);
window.isMobile = isAndroid || isIOS || isWinsTablet;
if(typeof(window.slow_cpu) == 'undefined') window.slow_cpu = false;
if(isIOS) $(document).ready(function(){ $('#iosHeaderGrip').show(); });

if(isAndroid || isWinXP || isIOS || window.slow_cpu || window.isMobile){
	(function ($) {
	    $.fn.animate = function(props, duration, easing, callback) {
			$(this).css(props);
	    	if(typeof(callback) != 'undefined'){
	    		(callback.bind(this))();
			}
	    };
	})(jQuery);
}

if(window.isMobile) $('<style type="text/css">table.mobile_collapse { display: none; } table.mobile_collapse_control .mobile_collapse_excluded { display: none; }</style>').appendTo($('head'));

//Custom Printing Method
jQuery(document).bind("keyup keydown", function(e){
	if(msieversion() != false) return;
    if((e.ctrlKey || e.metaKey) && e.keyCode == 80){
    	e.preventDefault();
    	e.returnValue = false;
    	if(e.type == 'keydown')
    		top.window.print();
        return false;
    }
});

if(typeof(top.had_safe_print) == 'undefined') top.had_safe_print = false;
if(typeof(top.had_print) == 'undefined') top.had_print = false;
if(typeof(top.unsafe_print_warning_shown) == 'undefined') top.unsafe_print_warning_shown = false;
window.org_print = window.print;
window.print = function(){
	top.had_safe_print = true;
	
	var frame = $('.main_index_page_active > iframe.frame-view:visible');
	if(frame.length > 0){
		frame[0].contentWindow.focus();
		frame[0].contentWindow.print();
	}
	else
		window.org_print();
};
window.msieversion_cache = null;
function msieversion() {
	if(window.msieversion_cache !== null) return window.msieversion_cache;
	
	if(navigator.appName == "Netscape"){ 
		if(navigator.appVersion.indexOf('Safari') != -1) return false;                  
		else if(window.navigator.userAgent.indexOf('Firefox') != -1) return false;                  
		else if(window.navigator.userAgent.indexOf('Chrome') != -1) return false;                  
		else if(navigator.appVersion.indexOf('Trident') === -1) window.msieversion_cache = 12;
		else window.msieversion_cache = 11;
    }       
	else{
		var ua = window.navigator.userAgent;
		var msie = ua.indexOf("MSIE ");
		if (msie > 0) window.msieversion_cache = parseInt(ua.substring(msie + 5, ua.indexOf(".", msie)));
		else window.msieversion_cache = false;
	}
    return window.msieversion_cache;
}

$.fn.animateRotate = function(angle, duration, easing, complete) {
  var args = $.speed(duration, easing, complete);
  var step = args.step;
  var last_offset = typeof(this._animateRotate_last_offset) == 'undefined' ? 0 : this._animateRotate_last_offset;
  return this.each(function(i, e) {
    args.complete = $.proxy(args.complete, e);
    args.step = function(now) {
      this._animateRotate_last_offset = now+last_offset;
      $.style(e, 'transform', 'rotate(' + (this._animateRotate_last_offset) + 'deg)');
      if (step) return step.apply(e, arguments);
    };

    $({deg: 0}).animate({deg: angle}, args);
  });
};

window.prefix_uuid = (new Date()).getTime();
window.next_uuid = 0;
function get_uuid(){
	return 'uuid_'+window.prefix_uuid+"_"+(++window.next_uuid);
}