-- MySQL dump 10.11
--
-- Host: localhost    Database: nolapro_clean
-- ------------------------------------------------------
-- Server version	5.0.95

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accounttype`
--

DROP TABLE IF EXISTS `accounttype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounttype` (
  `id` int(11) NOT NULL default '0',
  `description` char(30) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounttype`
--

LOCK TABLES `accounttype` WRITE;
/*!40000 ALTER TABLE `accounttype` DISABLE KEYS */;
INSERT INTO `accounttype` VALUES (10,'Current Assets'),(11,'Fixed Assets'),(13,'Other Assets'),(21,'Current Liabilities'),(22,'Long Term Liabilities'),(23,'Other Liabilities'),(30,'Equity'),(40,'Retained Earnings'),(50,'Sales'),(60,'Sales Adjustments'),(70,'Cost of Goods Sold'),(80,'Expenses'),(90,'Other Income and Expense');
/*!40000 ALTER TABLE `accounttype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `achcode`
--

DROP TABLE IF EXISTS `achcode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `achcode` (
  `code` char(3) NOT NULL default '',
  `description` char(70) NOT NULL default '',
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `achcode`
--

LOCK TABLES `achcode` WRITE;
/*!40000 ALTER TABLE `achcode` DISABLE KEYS */;
INSERT INTO `achcode` VALUES ('C01','Incorrect DFI Account Number'),('C02','Incorrect Transit/Routing Number'),('C03','Incorrect Transit/Routing Number and Incorrect DFI Account Number'),('C04','Incorrect Individual Name'),('C05','Incorrect Transaction Code'),('C06','Incorrect DFI Account Number and Incorrect Transaction Code'),('C07','Incorrect Transit/Routing, DFI Account Number, and Transaction Code'),('C08','Reserved'),('C09','Incorrect Individual Identification Number'),('C10','Incorrect Company Name'),('C11','Incorrect Company Identification'),('C12','Incorrect Company Name and Identification'),('C13','Addenda Format Error'),('C61','Misrouted Notification of Change'),('C62','Incorrect Trace Number'),('C63','Incorrect Company Identification Number'),('C64','Incorrect Individual Identification Number'),('C65','Incorrectly formatted corrected data'),('C66','Incorrect Discretinary Data'),('C67','Routing Number Not From Original Entry Detail Record'),('C68','DFI Account Number Not from Original Entry Detail Record'),('C69','Incorrect Transaction Code'),('R01','Insufficient Funds'),('R02','Account Closed'),('R03','No Account/Unable to Locate Account'),('R04','Invalid Account Number'),('R05','Reserved'),('R06','Returned per ODFIs Request'),('R07','Authorization Revoked by Customer'),('R08','Payment Stopped or Stop Payment on Item'),('R09','Uncollected Funds'),('R10','Customer Advises Not Authorized'),('R11','Check Truncation Entry Return'),('R12','Branch sold to Another OFI'),('R13','ROFI not qualified to participate'),('R14','Representment payee deceased or unable to continue in that capacity'),('R15','Beneficiary of account holder deceased'),('R16','Account frozen'),('R17','File record edit criteria'),('R18','Improper effective entry date'),('R19','Amount field error'),('R20','Non-Transaction Account'),('R21','Invalid company identification'),('R22','Invalid individual IO number'),('R23','Credit entry refused by receiver'),('R24','Duplicate entry'),('R25','Addenda error'),('R26','Mandatory field error'),('R27','Trace number error'),('R28','Routing Number Check Digit Error'),('R29','Corporate customer advises not authorized'),('R30','RDFI not participant in check truncation program'),('R31','Permissible return entry'),('R32','RDFI non-settlement'),('R33','Return of SCK entry'),('R34','Limited Participation DFI'),('R35','Return of Improper debit entry'),('R36','Return of Improper Credit Entry'),('R40','Return of ENR entry by Federal Government Agency (ENR Only)'),('R41','Invalid transaction code (ENR Only)'),('R42','Routing number/check digit error (ENR only)'),('R43','Invalid DFI account number (ENR Only)'),('R44','Invalid Individual ID number (ENR only)'),('R45','Invalid Individual name/company name (ENR only)'),('R46','Invalid representative payee indicator (ENR only)'),('R47','Duplicate Enrollment'),('R50','State Law affecting RCK Acceptance'),('R51','Item is Inelligible, Notice Not Provided, Signature not genuine'),('R52','Stop Payment on Item'),('R61','Misrouted return'),('R62','Incorrect Trace Number'),('R63','Incorrect Dollar Amount'),('R64','Incorrect Individual Identificaton'),('R65','Incorrect transaction code'),('R66','Incorrect Company Identification'),('R67','Duplicate Return'),('R68','Untimely Return'),('R69','Multiple Errors'),('R70','Permissible return entry not accepted'),('R71','Misrouted dishonored return'),('R72','Untimely dishonored return'),('R73','Timely original return'),('R74','Corrected return'),('R80','Cross-border payment coding error'),('R81','Non-Participant in cross-border program'),('R82','Invalid Foreign Receiving DFI Identification'),('R83','Foreign Receiving DFI Unable to Settle');
/*!40000 ALTER TABLE `achcode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `achfile`
--

DROP TABLE IF EXISTS `achfile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `achfile` (
  `id` int(11) NOT NULL auto_increment,
  `filecontents` blob NOT NULL,
  `description` varchar(10) NOT NULL default '',
  `totalcreditamount` decimal(19,4) NOT NULL default '0.0000',
  `totaldebitamount` decimal(19,4) NOT NULL default '0.0000',
  `totalrecords` int(11) NOT NULL default '0',
  `checkacctid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `sent` int(2) NOT NULL default '0',
  `sentdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `effectivedate` date NOT NULL default '0000-00-00',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `entryuserid` (`entryuserid`),
  KEY `checkacctid` (`checkacctid`),
  KEY `canceluserid` (`canceluserid`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `achfile`
--

LOCK TABLES `achfile` WRITE;
/*!40000 ALTER TABLE `achfile` DISABLE KEYS */;
/*!40000 ALTER TABLE `achfile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `achfiledetail`
--

DROP TABLE IF EXISTS `achfiledetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `achfiledetail` (
  `id` int(11) NOT NULL auto_increment,
  `achfileid` int(11) NOT NULL default '0',
  `premployeeid` int(11) NOT NULL default '0',
  `bankaccountid` int(11) NOT NULL default '0',
  `achcode` char(3) NOT NULL default '',
  `routing` varchar(9) NOT NULL default '',
  `accountnumber` varchar(17) NOT NULL default '',
  `bankname` varchar(100) NOT NULL default '',
  `originalvoucher` varchar(50) NOT NULL default '',
  `recordtype` int(2) NOT NULL default '0',
  `recorddata` varchar(94) NOT NULL default '',
  `transactioncode` char(2) NOT NULL default '',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `name` varchar(100) NOT NULL default '',
  `tracenumber` varchar(15) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `premployeeid` (`premployeeid`),
  KEY `entryuserid` (`entryuserid`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `achfileid` (`achfileid`),
  KEY `bankaccountid` (`bankaccountid`),
  KEY `canceluserid` (`canceluserid`),
  KEY `achcode` (`achcode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `achfiledetail`
--

LOCK TABLES `achfiledetail` WRITE;
/*!40000 ALTER TABLE `achfiledetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `achfiledetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `achfiledownload`
--

DROP TABLE IF EXISTS `achfiledownload`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `achfiledownload` (
  `id` int(11) NOT NULL auto_increment,
  `achfileid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `downloaddate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`),
  KEY `achfileid` (`achfileid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `achfiledownload`
--

LOCK TABLES `achfiledownload` WRITE;
/*!40000 ALTER TABLE `achfiledownload` DISABLE KEYS */;
/*!40000 ALTER TABLE `achfiledownload` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `achseq`
--

DROP TABLE IF EXISTS `achseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `achseq` (
  `id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `achseq`
--

LOCK TABLES `achseq` WRITE;
/*!40000 ALTER TABLE `achseq` DISABLE KEYS */;
INSERT INTO `achseq` VALUES (0);
/*!40000 ALTER TABLE `achseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `achtransaction`
--

DROP TABLE IF EXISTS `achtransaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `achtransaction` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `b2buserid` int(11) NOT NULL default '0',
  `customerbankid` int(11) NOT NULL default '0',
  `checkacctid` int(11) NOT NULL default '0',
  `ccaccountid` int(11) NOT NULL default '0',
  `glaccountid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `tablename` varchar(45) NOT NULL default '',
  `tableid` int(11) NOT NULL default '0',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `routingnumber` varchar(9) NOT NULL default '',
  `accountnumber` varchar(20) NOT NULL default '',
  `accounttype` varchar(20) NOT NULL default '',
  `accountname` varchar(50) NOT NULL default '',
  `bankname` varchar(50) NOT NULL default '',
  `echecktype` varchar(15) NOT NULL default '',
  `checknumber` varchar(20) NOT NULL default '',
  `transactionid` varchar(45) NOT NULL default '',
  `resultcode` char(1) NOT NULL default '',
  `resultreasoncode` int(11) NOT NULL default '0',
  `resultreasontext` varchar(255) NOT NULL default '',
  `returned` int(11) NOT NULL default '0',
  `returncode` char(3) NOT NULL default '',
  `returndate` datetime default NULL,
  `customerip` varchar(25) NOT NULL default '',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `b2buserid` (`b2buserid`),
  KEY `customerbankid` (`customerbankid`),
  KEY `checkacctid` (`checkacctid`),
  KEY `ccaccountid` (`ccaccountid`),
  KEY `glaccountid` (`glaccountid`),
  KEY `companyid` (`companyid`),
  KEY `tablename` (`tablename`),
  KEY `tableid` (`tableid`),
  KEY `transactionid` (`transactionid`),
  KEY `resultcode` (`resultcode`),
  KEY `entrydate` (`entrydate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `achtransaction`
--

LOCK TABLES `achtransaction` WRITE;
/*!40000 ALTER TABLE `achtransaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `achtransaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `action`
--

DROP TABLE IF EXISTS `action`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `action` (
  `id` int(11) NOT NULL default '0',
  `action` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `action`
--

LOCK TABLES `action` WRITE;
/*!40000 ALTER TABLE `action` DISABLE KEYS */;
INSERT INTO `action` VALUES (1,'Completed');
/*!40000 ALTER TABLE `action` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actionseq`
--

DROP TABLE IF EXISTS `actionseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actionseq` (
  `id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actionseq`
--

LOCK TABLES `actionseq` WRITE;
/*!40000 ALTER TABLE `actionseq` DISABLE KEYS */;
INSERT INTO `actionseq` VALUES (1);
/*!40000 ALTER TABLE `actionseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activation`
--

DROP TABLE IF EXISTS `activation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activation` (
  `id` int(11) NOT NULL auto_increment,
  `email` varchar(255) NOT NULL default '',
  `companyname` varchar(255) NOT NULL default '',
  `servername` varchar(255) NOT NULL default '',
  `ip` varchar(100) NOT NULL default '',
  `platform` varchar(100) default NULL,
  `act_att` int(11) default NULL,
  `osys` varchar(100) default NULL,
  `businesstype` varchar(100) NOT NULL default '',
  `phone` int(25) default NULL,
  `street` varchar(60) default NULL,
  `city` varchar(60) default NULL,
  `state` varchar(60) default NULL,
  `country` varchar(60) default NULL,
  `postal` varchar(25) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activation`
--

LOCK TABLES `activation` WRITE;
/*!40000 ALTER TABLE `activation` DISABLE KEYS */;
/*!40000 ALTER TABLE `activation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `addedit_control`
--

DROP TABLE IF EXISTS `addedit_control`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addedit_control` (
  `id` int(11) NOT NULL auto_increment,
  `tablename` varchar(250) NOT NULL,
  `fieldname` varchar(250) NOT NULL,
  `block` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `required` int(11) NOT NULL default '0',
  `defaultvalue` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `tablename` (`tablename`),
  KEY `block` (`block`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addedit_control`
--

LOCK TABLES `addedit_control` WRITE;
/*!40000 ALTER TABLE `addedit_control` DISABLE KEYS */;
/*!40000 ALTER TABLE `addedit_control` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `address_format`
--

DROP TABLE IF EXISTS `address_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `address_format` (
  `address_format_id` int(5) NOT NULL auto_increment,
  `address_format` varchar(128) NOT NULL default '',
  `address_summary` varchar(48) NOT NULL default '',
  PRIMARY KEY  (`address_format_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `address_format`
--

LOCK TABLES `address_format` WRITE;
/*!40000 ALTER TABLE `address_format` DISABLE KEYS */;
INSERT INTO `address_format` VALUES (1,'$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country'),(2,'$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country'),(3,'$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$city / $country'),(4,'$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country','$postcode / $country');
/*!40000 ALTER TABLE `address_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ads` (
  `location` varchar(45) NOT NULL,
  `html` text,
  `rate` float default '1',
  PRIMARY KEY  (`location`),
  UNIQUE KEY `location_UNIQUE` (`location`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `airport`
--

DROP TABLE IF EXISTS `airport`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `airport` (
  `id` int(11) NOT NULL auto_increment,
  `vendorid` int(11) NOT NULL default '0',
  `airportcode` varchar(5) NOT NULL default '',
  `airportname` varchar(200) default NULL,
  `pfname` varchar(255) NOT NULL default '',
  `address1` varchar(100) NOT NULL default '',
  `address2` varchar(100) NOT NULL default '',
  `city` varchar(100) NOT NULL default '',
  `state` char(2) NOT NULL default '',
  `zip` varchar(10) NOT NULL default '',
  `description` text NOT NULL,
  `chargefullfee` int(11) NOT NULL default '0',
  `chargeparkingfee` int(11) NOT NULL default '0',
  `chargeairportfee` int(11) NOT NULL default '0',
  `chargefuelfee` int(11) NOT NULL default '0',
  `chargesalestax` int(11) NOT NULL default '0',
  `ta_commission_flat` decimal(12,4) NOT NULL default '0.0000',
  `ta_commission_percent` decimal(12,4) NOT NULL default '0.0000',
  `commission_flat` decimal(12,4) NOT NULL default '0.0000',
  `commission_percent` decimal(12,4) NOT NULL default '0.0000',
  `airport_fee_flat` decimal(12,4) NOT NULL default '0.0000',
  `airport_fee_percent` decimal(12,4) NOT NULL default '0.0000',
  `fuel_charge_flat` decimal(12,4) NOT NULL default '0.0000',
  `salestaxid` int(11) NOT NULL default '0',
  `sales_categoriesid` int(11) NOT NULL default '0',
  `glsalesid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `email` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `vendorid` (`vendorid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `airport`
--

LOCK TABLES `airport` WRITE;
/*!40000 ALTER TABLE `airport` DISABLE KEYS */;
/*!40000 ALTER TABLE `airport` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `airport_category`
--

DROP TABLE IF EXISTS `airport_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `airport_category` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `airport_category`
--

LOCK TABLES `airport_category` WRITE;
/*!40000 ALTER TABLE `airport_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `airport_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `airport_order`
--

DROP TABLE IF EXISTS `airport_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `airport_order` (
  `id` int(11) NOT NULL auto_increment,
  `airportid` int(11) NOT NULL default '0',
  `agentid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `departure_date` datetime default NULL,
  `return_date` datetime default NULL,
  `card_type` varchar(10) default NULL,
  `transid` int(11) NOT NULL default '0',
  `encrypted_card` varchar(50) NOT NULL default '',
  `card_last4` varchar(4) default NULL,
  `confirmcode` varchar(15) NOT NULL default '',
  `cancelcode` varchar(15) NOT NULL default '',
  `cancel` int(2) NOT NULL default '0',
  `email` varchar(100) default NULL,
  `firstname` varchar(50) default NULL,
  `lastname` varchar(100) default NULL,
  `address` varchar(200) default NULL,
  `city` varchar(50) default NULL,
  `state` varchar(50) default NULL,
  `zip` varchar(15) default NULL,
  `phone` varchar(50) default NULL,
  `compupark` varchar(100) default NULL,
  `card_expiration` varchar(4) default NULL,
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `status` int(5) NOT NULL default '0',
  `parking_days` int(11) NOT NULL default '0',
  `parking_fee` decimal(10,4) NOT NULL default '0.0000',
  `agent_commission` decimal(12,4) NOT NULL default '0.0000',
  `agent_commission_paid` decimal(12,4) NOT NULL default '0.0000',
  `vendor_commission` decimal(12,4) NOT NULL default '0.0000',
  `vendor_commission_paid` decimal(12,4) NOT NULL default '0.0000',
  `total_charge` decimal(12,4) NOT NULL default '0.0000',
  `agentcode` varchar(50) NOT NULL default '',
  `barcode_file` varchar(50) NOT NULL default '',
  `fuel_charge` decimal(12,4) NOT NULL default '0.0000',
  `service_fee` decimal(12,4) NOT NULL default '0.0000',
  `airport_fee` decimal(12,4) NOT NULL default '0.0000',
  `salestax` decimal(12,4) NOT NULL default '0.0000',
  `salestaxid` int(11) NOT NULL default '0',
  `grand_total` decimal(12,4) NOT NULL default '0.0000',
  `reservation_fee` decimal(12,4) NOT NULL default '0.0000',
  `invoiceid` int(11) NOT NULL default '0',
  `parking_type` char(1) NOT NULL default 'V',
  PRIMARY KEY  (`id`),
  KEY `airportid` (`airportid`),
  KEY `agentid` (`agentid`),
  KEY `customerid` (`customerid`),
  KEY `departure_date` (`departure_date`),
  KEY `transid` (`transid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `airport_order`
--

LOCK TABLES `airport_order` WRITE;
/*!40000 ALTER TABLE `airport_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `airport_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `airport_order_details`
--

DROP TABLE IF EXISTS `airport_order_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `airport_order_details` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `serviceid` int(11) NOT NULL default '0',
  `description` varchar(50) NOT NULL default '',
  `price` decimal(12,4) NOT NULL default '0.0000',
  `cancel` int(2) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `serviceid` (`serviceid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `airport_order_details`
--

LOCK TABLES `airport_order_details` WRITE;
/*!40000 ALTER TABLE `airport_order_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `airport_order_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `airport_parking`
--

DROP TABLE IF EXISTS `airport_parking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `airport_parking` (
  `id` int(11) NOT NULL auto_increment,
  `airportid` int(11) NOT NULL default '0',
  `num_days` int(5) NOT NULL default '0',
  `price` decimal(10,4) NOT NULL default '0.0000',
  `price_self_park` decimal(10,4) NOT NULL default '0.0000',
  `airport_fee_flat_charge` decimal(10,4) NOT NULL default '0.0000',
  `airport_fee_percent_charge` decimal(10,4) NOT NULL default '0.0000',
  `flat_commission` decimal(10,4) NOT NULL default '0.0000',
  `percent_commission` decimal(10,4) NOT NULL default '0.0000',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `airportid` (`airportid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `airport_parking`
--

LOCK TABLES `airport_parking` WRITE;
/*!40000 ALTER TABLE `airport_parking` DISABLE KEYS */;
/*!40000 ALTER TABLE `airport_parking` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `airport_service`
--

DROP TABLE IF EXISTS `airport_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `airport_service` (
  `id` int(11) NOT NULL auto_increment,
  `airportid` int(11) NOT NULL default '0',
  `serviceid` int(11) NOT NULL default '0',
  `flat_commission` decimal(10,4) NOT NULL default '0.0000',
  `percent_commission` decimal(10,4) NOT NULL default '0.0000',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `price` decimal(12,4) NOT NULL default '0.0000',
  PRIMARY KEY  (`id`),
  KEY `airportid` (`airportid`),
  KEY `cancel` (`cancel`),
  KEY `serviceid` (`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `airport_service`
--

LOCK TABLES `airport_service` WRITE;
/*!40000 ALTER TABLE `airport_service` DISABLE KEYS */;
/*!40000 ALTER TABLE `airport_service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazonsetup`
--

DROP TABLE IF EXISTS `amazonsetup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazonsetup` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(128) NOT NULL default '',
  `companyid` int(11) NOT NULL default '0',
  `sellerid` varchar(128) NOT NULL default '',
  `marketplaceid` varchar(256) NOT NULL default '',
  `developerid` varchar(128) NOT NULL default '',
  `awsaccesskey` varchar(128) NOT NULL default '',
  `secretkey` varchar(128) NOT NULL default '',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastchangeuserid` int(11) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `checkacctid` int(11) NOT NULL default '0',
  `salesglacctid` int(11) NOT NULL default '0',
  `salestaxglacctid` int(11) NOT NULL default '0',
  `taxexemptid` int(11) NOT NULL default '0',
  `refundglacctid` int(11) NOT NULL default '0',
  `invoicetermsid` int(11) NOT NULL default '0',
  `salescategoryid` int(11) NOT NULL default '0',
  `pricelevelid` int(11) NOT NULL default '0',
  `defaultshipvia` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='marketplaceid is now potentially a comma-separated list';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazonsetup`
--

LOCK TABLES `amazonsetup` WRITE;
/*!40000 ALTER TABLE `amazonsetup` DISABLE KEYS */;
/*!40000 ALTER TABLE `amazonsetup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apbill`
--

DROP TABLE IF EXISTS `apbill`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apbill` (
  `id` int(11) NOT NULL auto_increment,
  `invoicenumber` varchar(20) NOT NULL default '',
  `cancel` int(11) NOT NULL default '0',
  `complete` int(11) NOT NULL default '0',
  `paynone` int(11) NOT NULL default '0',
  `total` decimal(19,4) NOT NULL default '0.0000',
  `description` varchar(50) default NULL,
  `dateofinvoice` date default NULL,
  `duedate` date default NULL,
  `discountamount` decimal(19,4) NOT NULL default '0.0000',
  `discountdate` date default NULL,
  `vendorid` int(11) NOT NULL default '0',
  `comment` text,
  `gencompanyid` int(11) NOT NULL default '0',
  `wherefrom` int(11) NOT NULL default '1',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) default NULL,
  `approved_paydate` date default NULL,
  `preapproved_userid` int(11) NOT NULL default '0',
  `preapproved_status` int(5) NOT NULL default '0',
  `preapproved_checkacctid` int(11) NOT NULL default '0',
  `preapproved_amount` decimal(15,6) NOT NULL default '0.000000',
  `preapproved_interest` decimal(15,6) NOT NULL default '0.000000',
  `old_id` varchar(255) default NULL,
  `ccpurchase` int(5) NOT NULL default '0',
  `apglaccountid` int(11) NOT NULL default '0',
  `chargeback` int(5) NOT NULL default '0',
  `recurring` int(5) NOT NULL default '0',
  `payplan_dayofmonth` int(5) NOT NULL default '0',
  `payplan_days` int(11) NOT NULL default '0',
  `payplan_next` date default NULL,
  `payplan_numtimes` int(11) NOT NULL default '0',
  `isretainer` int(5) NOT NULL default '0',
  `retainer_apbillid` int(11) NOT NULL default '0',
  `drawid` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  `alternate_paytoname` varchar(255) NOT NULL default '',
  `non_negotiable` int(5) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `voucherid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  `jobid` int(11) NOT NULL default '0',
  `frommanual` tinyint(4) NOT NULL default '0',
  `invoicetermsid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoicenumber` (`invoicenumber`),
  KEY `wherefrom` (`wherefrom`),
  KEY `recurring` (`recurring`),
  KEY `drawid` (`drawid`),
  KEY `gltr_costcodeid` (`costcodeid`),
  KEY `voucherid` (`voucherid`),
  KEY `glcategoryid` (`glcategoryid`),
  KEY `jobid` (`jobid`),
  KEY `vendorid` (`vendorid`),
  KEY `gccscp` (`gencompanyid`,`cancel`,`complete`,`preapproved_status`,`preapproved_checkacctid`,`paynone`),
  KEY `dateofinvoice` (`dateofinvoice`),
  KEY `duedate` (`duedate`),
  KEY `discountdate` (`discountdate`),
  KEY `approved_paydate` (`approved_paydate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apbill`
--

LOCK TABLES `apbill` WRITE;
/*!40000 ALTER TABLE `apbill` DISABLE KEYS */;
/*!40000 ALTER TABLE `apbill` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apbill_approvers`
--

DROP TABLE IF EXISTS `apbill_approvers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apbill_approvers` (
  `id` int(11) NOT NULL auto_increment,
  `apbillid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `apbillsplitpaymentid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `apbillid_cancel` (`apbillid`,`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apbill_approvers`
--

LOCK TABLES `apbill_approvers` WRITE;
/*!40000 ALTER TABLE `apbill_approvers` DISABLE KEYS */;
/*!40000 ALTER TABLE `apbill_approvers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apbilldetail`
--

DROP TABLE IF EXISTS `apbilldetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apbilldetail` (
  `id` int(11) NOT NULL auto_increment,
  `apbillid` int(11) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `glaccountid` int(11) NOT NULL default '0',
  `invreceiveid` int(11) NOT NULL default '0',
  `jobid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  `description` varchar(100) NOT NULL default '',
  `isretainer` int(5) NOT NULL default '0',
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  PRIMARY KEY  (`id`),
  KEY `apbillid` (`apbillid`),
  KEY `glaccountid` (`glaccountid`),
  KEY `invreceiveid` (`invreceiveid`),
  KEY `gltr_jobid` (`jobid`),
  KEY `gltr_costcodeid` (`costcodeid`),
  KEY `gltr_categoryid` (`glcategoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apbilldetail`
--

LOCK TABLES `apbilldetail` WRITE;
/*!40000 ALTER TABLE `apbilldetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `apbilldetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apbillpayment`
--

DROP TABLE IF EXISTS `apbillpayment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apbillpayment` (
  `id` int(11) NOT NULL auto_increment,
  `apbillid` int(11) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `interest` decimal(19,4) NOT NULL default '0.0000',
  `checkid` int(11) NOT NULL default '0',
  `checkvoid` int(11) NOT NULL default '0',
  `complete` int(2) NOT NULL default '0',
  `currentvoucherid` int(11) NOT NULL default '0',
  `voidvoucherid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `paymethod` int(11) NOT NULL default '2',
  `old_id` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `apbillid` (`apbillid`),
  KEY `checkid` (`checkid`),
  KEY `checkvoid` (`checkvoid`),
  KEY `complete` (`complete`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apbillpayment`
--

LOCK TABLES `apbillpayment` WRITE;
/*!40000 ALTER TABLE `apbillpayment` DISABLE KEYS */;
/*!40000 ALTER TABLE `apbillpayment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apbillsplitpayment`
--

DROP TABLE IF EXISTS `apbillsplitpayment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apbillsplitpayment` (
  `id` int(11) NOT NULL auto_increment,
  `apbillid` int(11) NOT NULL default '0',
  `apbillpaymentid` int(11) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `discountamount` decimal(19,4) NOT NULL default '0.0000',
  `paymentdate` date NOT NULL default '0000-00-00',
  `preapproved_userid` int(11) NOT NULL default '0',
  `preapproved_status` int(11) NOT NULL default '0',
  `preapproved_checkacctid` int(11) NOT NULL default '0',
  `preapproved_amount` decimal(15,6) NOT NULL default '0.000000',
  `preapproved_interest` decimal(15,6) NOT NULL default '0.000000',
  PRIMARY KEY  (`id`),
  KEY `apbill` (`apbillid`),
  KEY `apbillpayment` (`apbillpaymentid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apbillsplitpayment`
--

LOCK TABLES `apbillsplitpayment` WRITE;
/*!40000 ALTER TABLE `apbillsplitpayment` DISABLE KEYS */;
/*!40000 ALTER TABLE `apbillsplitpayment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apbilltaxdetail`
--

DROP TABLE IF EXISTS `apbilltaxdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apbilltaxdetail` (
  `id` int(11) NOT NULL auto_increment,
  `apbillid` int(11) NOT NULL default '0',
  `taxid` int(11) NOT NULL default '0',
  `taxamount` decimal(19,4) NOT NULL default '0.0000',
  `jobid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `apbillid` (`apbillid`),
  KEY `taxid` (`taxid`),
  KEY `gltr_jobid` (`jobid`),
  KEY `gltr_costcodeid` (`costcodeid`),
  KEY `gltr_categoryid` (`glcategoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apbilltaxdetail`
--

LOCK TABLES `apbilltaxdetail` WRITE;
/*!40000 ALTER TABLE `apbilltaxdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `apbilltaxdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apcompany`
--

DROP TABLE IF EXISTS `apcompany`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apcompany` (
  `id` int(11) NOT NULL default '0',
  `payable` double NOT NULL default '0',
  `interestexpense` double NOT NULL default '0',
  `discount` double NOT NULL default '0',
  `discearn` int(11) NOT NULL default '1',
  `usetransactiondate` int(11) NOT NULL default '0',
  `poformat` int(11) NOT NULL default '0',
  `glcashid` int(11) NOT NULL default '0',
  `glccid` int(11) NOT NULL default '0',
  `glotherid` int(11) NOT NULL default '0',
  `default_po_message` text,
  `glcommissionid` int(11) NOT NULL default '0',
  `default_vendor_termsid` int(11) NOT NULL default '0',
  `must_preapprove` int(5) NOT NULL default '0',
  `which_preapprove_ckdate` int(5) NOT NULL default '0',
  `noshowsell_onpo` int(5) NOT NULL default '0',
  `sellqtyonly_poentry` int(5) NOT NULL default '0',
  `default_checkacctid` int(11) NOT NULL default '0',
  `noboxes_on_po` int(5) NOT NULL default '0',
  `podate` int(5) NOT NULL default '0',
  `suppress_linenum_po` int(5) NOT NULL default '0',
  `sbformat` int(5) NOT NULL default '0',
  `noboxes_on_sb` int(5) NOT NULL default '0',
  `noshowsell_onsb` int(5) NOT NULL default '0',
  `suppress_linenum_sb` int(5) NOT NULL default '0',
  `showgl` int(5) NOT NULL default '0',
  `track_pochanges` int(5) NOT NULL default '0',
  `retainerglacctid` int(11) NOT NULL default '0',
  `retainer_checkacctid` int(11) NOT NULL default '0',
  `chargeback_percent` decimal(5,2) NOT NULL default '0.00',
  `chargeback_revenuegl` int(11) NOT NULL default '0',
  `check_glbudget_NonJobPO` int(5) NOT NULL default '0',
  `requirechecklist` int(11) NOT NULL default '0',
  `ccchargefeeflat` decimal(19,6) NOT NULL default '0.000000',
  `ccchargefeepercent` decimal(6,2) NOT NULL default '0.00',
  `adminexpglaccountid` int(11) NOT NULL default '0',
  `adminsalesglaccountid` int(11) NOT NULL default '0',
  `noshow_prices_on_po` int(5) NOT NULL default '0',
  `feesgl` int(11) NOT NULL default '0',
  `retax_liability` int(11) NOT NULL default '0',
  `retax_escrow` int(11) NOT NULL default '0',
  `retax_expense` int(11) NOT NULL default '0',
  `servicecharges` int(11) NOT NULL default '0',
  `defaultpocouserid` int(11) NOT NULL default '0',
  `adjustx1099` int(11) NOT NULL default '0',
  `adjusty1099` int(11) NOT NULL default '0',
  `updatevendorprice` int(11) NOT NULL default '0',
  `hidesalesordernumber` int(11) NOT NULL default '0',
  `hidePOhtml` int(5) NOT NULL default '0',
  `showinternal_itemcode` int(5) NOT NULL default '0',
  `defaultcostcodeid` int(11) NOT NULL default '0',
  `pochecklistsortorder` char(1) NOT NULL default 'L',
  `po_pdf_fontsize` int(11) NOT NULL default '10',
  `showccbillsinseparatetab` tinyint(1) NOT NULL default '1',
  `po_pdf_columns` text,
  `pochecklist_pdf_columns` text,
  `pochecklist_pdf_pricelevel_id` int(11) NOT NULL default '0',
  `round_preapprove_pay_date` varchar(1) NOT NULL default '0',
  `round_preapprove_dates` varchar(100) NOT NULL default '',
  `round_preapprove_holiday` tinyint(1) NOT NULL default '0',
  `round_preapprove_weekend` tinyint(1) NOT NULL default '0',
  `apbills_approver_count` tinyint(4) NOT NULL default '1',
  `apbills_approver_limit_users` tinyint(1) NOT NULL default '0',
  `apbills_approver_check_initials` tinyint(1) NOT NULL default '0',
  `pochecklist_pdf_cost_method` varchar(1) NOT NULL default 'A',
  `blockjobfields` tinyint(4) NOT NULL default '0',
  `defaultglcategoryid` int(11) NOT NULL default '0',
  `invpoemailtemplateid` int(11) NOT NULL default '0',
  `apbills_approver_notices` tinyint(1) NOT NULL default '0',
  `hidecostcodes` tinyint(1) NOT NULL default '0',
  `defaultqtyreceivedtozero` tinyint(1) NOT NULL default '0',
  `hideendorser` tinyint(4) NOT NULL default '0',
  `pendingcreditsglaccountid` int(11) NOT NULL default '0',
  `dismisspoitemimportpopupwarning` tinyint(1) NOT NULL default '0',
  `forcediscount` tinyint(4) NOT NULL default '0',
  `paymentemailtemplateid` int(11) NOT NULL default '0',
  `emailpaymenttypes` varchar(100) NOT NULL default '',
  `blocknewbillglautofill` tinyint(4) NOT NULL default '0',
  `maxsingleeftamount` decimal(19,4) NOT NULL default '0.0000',
  `showposcashpurchaselink` tinyint(1) NOT NULL default '0',
  `nextvendorcode` int(11) NOT NULL default '1000',
  `dropshipcarrierserviceid` int(11) NOT NULL default '0',
  `allowdiscountoncredits` tinyint(1) NOT NULL default '0',
  `autogenvendorcode` tinyint(1) NOT NULL default '0',
  `maxdailyeftamount` decimal(19,4) NOT NULL default '0.0000',
  `poheaderinventorylocationid` int(11) NOT NULL default '0',
  `poshowmainpagenotesinheader` tinyint(1) NOT NULL default '0',
  `polimititemstoassignedvendorsstock` tinyint(1) NOT NULL default '0',
  `hidepoentryinvgl` tinyint(1) NOT NULL default '0',
  `polimititemstoassignedvendorsnonstock` tinyint(1) NOT NULL default '0',
  `polimititemstoassignedvendorsother` tinyint(1) NOT NULL default '0',
  `addlocationcodetoponumber` tinyint(4) NOT NULL default '0',
  `hidevendoraddinpo` tinyint(1) NOT NULL default '0',
  `pouselastcost` tinyint(4) NOT NULL default '0',
  `blockchangingpovendorterms` tinyint(4) NOT NULL default '0',
  `emailassociatedordersalesmanonreceive` tinyint(1) NOT NULL default '0',
  `fromemailforpo` varchar(255) NOT NULL default '',
  `fromemailforvendorinsurancerequests` varchar(255) NOT NULL default '',
  `glrestockfeeid` int(11) NOT NULL,
  `subtotalsonchecks` tinyint(1) NOT NULL,
  `userscanchangevendorproductcodesduringpoentry` tinyint(1) NOT NULL,
  `adjustpoqtywhenarorderqtychanges` tinyint(1) NOT NULL default '1',
  `adjustpocostwhenarordercostchanges` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apcompany`
--

LOCK TABLES `apcompany` WRITE;
/*!40000 ALTER TABLE `apcompany` DISABLE KEYS */;
/*!40000 ALTER TABLE `apcompany` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `apilog`
--

DROP TABLE IF EXISTS `apilog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apilog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `userid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `action` varchar(255) NOT NULL,
  `entrydate` datetime NOT NULL,
  `data_in` text NOT NULL,
  `data_out` longtext NOT NULL,
  `remoteip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apilog`
--

LOCK TABLES `apilog` WRITE;
/*!40000 ALTER TABLE `apilog` DISABLE KEYS */;
/*!40000 ALTER TABLE `apilog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointment`
--

DROP TABLE IF EXISTS `appointment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appointment` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `scheduleid` int(11) NOT NULL default '0',
  `begindate` datetime NOT NULL default '0000-00-00 00:00:00',
  `enddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `title` varchar(200) NOT NULL default '',
  `notes` text NOT NULL,
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `vendorid` (`userid`),
  KEY `begindate` (`begindate`),
  KEY `enddate` (`enddate`),
  KEY `scheduleid` (`scheduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointment`
--

LOCK TABLES `appointment` WRITE;
/*!40000 ALTER TABLE `appointment` DISABLE KEYS */;
/*!40000 ALTER TABLE `appointment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointmentcompany`
--

DROP TABLE IF EXISTS `appointmentcompany`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appointmentcompany` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `companyid` int(11) NOT NULL default '0',
  `appointmentreminders_lastrun` datetime NOT NULL default '0000-00-00 00:00:00',
  `webhook_key` varchar(32) default NULL,
  `webhook_value` varchar(32) default NULL,
  `donotredirectb2blogintoappointments` tinyint(1) NOT NULL default '0',
  `donotrequirepaymentmethodtobook` tinyint(1) NOT NULL default '0',
  `nopaymentmethodmessage` mediumtext NOT NULL,
  `mincaptureauthamount` decimal(18,6) NOT NULL default '0.000000',
  `requireccauthtobook_amount` decimal(18,6) NOT NULL default '0.000000',
  `requireccauthtobook_amount2` decimal(18,6) NOT NULL default '0.000000',
  `email_intro_subject` tinytext NOT NULL,
  `email_intro_bodyhtml` mediumtext NOT NULL,
  `introserviceid` varchar(200) NOT NULL default '',
  `email_reminder_subject` tinytext NOT NULL,
  `email_reminder_bodyhtml` mediumtext NOT NULL,
  `email_confirmation_adminsubject` tinytext NOT NULL,
  `email_confirmation_subject` tinytext NOT NULL,
  `email_confirmation_bodyhtml` mediumtext NOT NULL,
  `email_cancel_adminsubject` tinytext NOT NULL,
  `email_cancel_subject` tinytext NOT NULL,
  `email_cancel_bodyhtml` mediumtext NOT NULL,
  `email_reschedule_adminsubject` tinytext NOT NULL,
  `email_reschedule_subject` tinytext NOT NULL,
  `email_reschedule_bodyhtml` mediumtext NOT NULL,
  `text_reminder_subject` tinytext NOT NULL,
  `email_newpatient_subject` tinytext NOT NULL,
  `email_newpatient_bodyhtml` mediumtext NOT NULL,
  `generalpatientemail` tinytext NOT NULL,
  `maintenanceplan_alert_appointmentlimit` int(11) NOT NULL default '0',
  `maintenanceplan_alert_daylimit` int(11) NOT NULL default '0',
  `text_reminder_body` mediumtext NOT NULL,
  `adminnotificationemailaddress` tinytext NOT NULL,
  `promptfor3rdpartyform` tinyint(1) NOT NULL default '0',
  `enablemedicalthemeoptions` tinyint(1) NOT NULL default '0',
  `disableemailreminders` tinyint(1) NOT NULL default '0',
  `b2bbookingleaddays` int(11) NOT NULL default '0',
  `newpatientnoticeemailaddress` tinytext NOT NULL,
  `newpatientnoticeserviceids` varchar(200) NOT NULL default '',
  `email_express_subject` tinytext NOT NULL,
  `email_express_bodyhtml` mediumtext NOT NULL,
  `expressserviceid` varchar(200) NOT NULL default '',
  `noshowcron_lastrun` datetime NOT NULL default '0000-00-00 00:00:00',
  `requireccauthtobook_services` varchar(200) NOT NULL default '',
  `requireccauthtobook_services2` varchar(200) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `webhook_key_UNIQUE` (`webhook_key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Company-specific setup options for appointments - WIP';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointmentcompany`
--

LOCK TABLES `appointmentcompany` WRITE;
/*!40000 ALTER TABLE `appointmentcompany` DISABLE KEYS */;
/*!40000 ALTER TABLE `appointmentcompany` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointmentschedule`
--

DROP TABLE IF EXISTS `appointmentschedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appointmentschedule` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `startdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `enddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `hostid` int(11) NOT NULL default '0',
  `locationid` int(11) NOT NULL default '0',
  `serviceid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastchangeuserid` int(11) NOT NULL default '0',
  `reserved` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cc` (`companyid`,`cancel`),
  KEY `startdate` (`startdate`),
  KEY `enddate` (`enddate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointmentschedule`
--

LOCK TABLES `appointmentschedule` WRITE;
/*!40000 ALTER TABLE `appointmentschedule` DISABLE KEYS */;
/*!40000 ALTER TABLE `appointmentschedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `approvalreq`
--

DROP TABLE IF EXISTS `approvalreq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `approvalreq` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `tablename` varchar(100) NOT NULL default '',
  `action` varchar(50) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `recordid` int(11) NOT NULL default '0',
  `mainrecordid` int(11) NOT NULL default '0',
  `prevrecordid` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `approvaluserid` int(11) NOT NULL default '0',
  `approvaldate` datetime NOT NULL,
  `pending` int(11) NOT NULL default '1',
  `changeok` int(11) NOT NULL default '0',
  `notes` text NOT NULL,
  `companyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `tablename_action` (`tablename`,`action`),
  KEY `recordid` (`recordid`),
  KEY `mainrecordid` (`mainrecordid`),
  KEY `prevrecordid` (`prevrecordid`),
  KEY `entryuserid` (`entryuserid`),
  KEY `approvaluserid` (`approvaluserid`),
  KEY `pending` (`pending`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `approvalreq`
--

LOCK TABLES `approvalreq` WRITE;
/*!40000 ALTER TABLE `approvalreq` DISABLE KEYS */;
/*!40000 ALTER TABLE `approvalreq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `approvalrequser`
--

DROP TABLE IF EXISTS `approvalrequser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `approvalrequser` (
  `id` int(11) NOT NULL auto_increment,
  `approvalreqid` int(11) NOT NULL default '0',
  `userfromid` int(11) NOT NULL default '0',
  `usertoid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `notes` text,
  PRIMARY KEY  (`id`),
  KEY `approvalreqid` (`approvalreqid`),
  KEY `userfromid` (`userfromid`),
  KEY `usertoid` (`usertoid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `approvalrequser`
--

LOCK TABLES `approvalrequser` WRITE;
/*!40000 ALTER TABLE `approvalrequser` DISABLE KEYS */;
/*!40000 ALTER TABLE `approvalrequser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `approvalrights`
--

DROP TABLE IF EXISTS `approvalrights`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `approvalrights` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `tablename` varchar(100) NOT NULL default '',
  `action` varchar(50) NOT NULL default '',
  `userid` int(11) NOT NULL default '0',
  `nprightsgroupid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `canapprove` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `tablename_action` (`tablename`,`action`),
  KEY `userid` (`userid`),
  KEY `nprightsgroupid` (`nprightsgroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `approvalrights`
--

LOCK TABLES `approvalrights` WRITE;
/*!40000 ALTER TABLE `approvalrights` DISABLE KEYS */;
/*!40000 ALTER TABLE `approvalrights` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arcompany`
--

DROP TABLE IF EXISTS `arcompany`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arcompany` (
  `id` int(11) NOT NULL default '0',
  `imageurl` varchar(150) default NULL,
  `cash` double NOT NULL default '0',
  `checking` double NOT NULL default '0',
  `interest` double NOT NULL default '0',
  `discount` double NOT NULL default '0',
  `cost` double NOT NULL default '0',
  `inventory` double NOT NULL default '0',
  `shipliability` double NOT NULL default '0',
  `receivables` double NOT NULL default '0',
  `nextinvoicenum` double NOT NULL default '1',
  `servicecharge` decimal(8,2) NOT NULL default '0.00',
  `interestrate` decimal(8,4) NOT NULL default '0.0000',
  `baddebt` double NOT NULL default '0',
  `default_sellunitid` int(11) NOT NULL default '0',
  `default_priceunitid` int(11) NOT NULL default '0',
  `default_sell_per_price` int(11) NOT NULL default '1',
  `default_invoice_message` text,
  `invoiceformat` int(11) NOT NULL default '0',
  `labor_sales_glacctid` int(11) NOT NULL default '0',
  `hrunitid` int(11) NOT NULL default '0',
  `is_employee_labor_taxable` int(2) NOT NULL default '1',
  `depositglacctid` int(11) NOT NULL default '0',
  `refund` int(11) NOT NULL default '0',
  `ccprocessorid` int(11) NOT NULL default '0',
  `b2bccprocessorid` int(11) NOT NULL default '0',
  `docfile` text,
  `default_salescategory_cashreceipts` int(11) NOT NULL default '0',
  `default_salescategory_invoice` int(11) NOT NULL default '0',
  `default_salescategory_fulfillment` int(11) NOT NULL default '0',
  `default_salescategory_service` int(11) NOT NULL default '0',
  `serviceorder_summarize` int(5) NOT NULL default '0',
  `tax_on_shipto` int(5) NOT NULL default '0',
  `tax_on_freight` int(2) NOT NULL default '0',
  `order_base` int(5) NOT NULL default '0',
  `b2b_orders` int(2) NOT NULL default '1',
  `b2b_service` int(2) NOT NULL default '1',
  `tax_how` int(2) NOT NULL default '0',
  `donotapply` int(2) NOT NULL default '0',
  `restockglid` int(11) NOT NULL default '0',
  `restockunitid` int(11) NOT NULL default '0',
  `salesterritories` int(5) NOT NULL default '0',
  `default_statement` int(2) NOT NULL default '0',
  `b2b_commission` int(5) NOT NULL default '0',
  `default_discountmsg` text,
  `b2b_print_orders` int(5) NOT NULL default '0',
  `b2b_pricelist_orders` int(5) NOT NULL default '0',
  `default_invoicetermsid` int(11) NOT NULL default '1',
  `b2b_allow_signup` int(11) NOT NULL default '0',
  `default_customergroupid` int(11) NOT NULL default '0',
  `default_b2b_admin_email` varchar(255) NOT NULL default '',
  `invoicecalc` int(5) NOT NULL default '0',
  `current_or_order` int(5) NOT NULL default '0',
  `default_checkacctid` int(11) NOT NULL default '0',
  `nobarcode_on_invoice` int(5) NOT NULL default '0',
  `picklist_blockheader` int(5) NOT NULL default '0',
  `picklist_blockbarcode` int(5) NOT NULL default '0',
  `picklist_sortorder` int(5) NOT NULL default '0',
  `pickliststyle` int(5) NOT NULL default '0',
  `noboxes_on_invoice` int(5) NOT NULL default '0',
  `comparison_levelid` int(11) NOT NULL default '0',
  `statement_no_prior_balance` int(5) NOT NULL default '0',
  `statement_no_interest_added` int(5) NOT NULL default '0',
  `statement_interest_summary` tinyint(1) NOT NULL default '0',
  `ardate` int(5) NOT NULL default '0',
  `noteatbottom` int(5) NOT NULL default '0',
  `internal_serviceorder` int(5) NOT NULL default '1',
  `internal_fulfillmentorder` int(5) NOT NULL default '1',
  `invoicenumber_override` int(5) NOT NULL default '0',
  `display_profit_pos` int(5) NOT NULL default '0',
  `pos_hide_stats` int(5) NOT NULL default '0',
  `pos_hide_fulfillment` int(5) NOT NULL default '0',
  `pos_hide_discounts` int(5) NOT NULL default '0',
  `pos_default_payment_method` int(5) NOT NULL default '0',
  `pos_default_order_type` int(5) NOT NULL default '0',
  `posreloadpriceswhenlocationchanges` tinyint(1) NOT NULL default '1',
  `display_weights_pos` int(5) NOT NULL default '0',
  `checkforcost` int(5) NOT NULL default '0',
  `bankdepositautoselect` int(11) NOT NULL default '1',
  `salesmanBlock` int(5) NOT NULL default '0',
  `show_salesdata` int(5) NOT NULL default '0',
  `usecurdateforship` int(11) NOT NULL default '0',
  `allowcoinvoice` int(11) NOT NULL default '0',
  `hidegl_pos` int(5) NOT NULL default '0',
  `showaddl_pos` int(5) NOT NULL default '0',
  `revenuerec` text,
  `deferredrevenue` int(11) NOT NULL default '0',
  `mgmtfee_glaccountid` int(11) NOT NULL default '0',
  `latefees` int(11) NOT NULL default '0',
  `petrent` int(11) NOT NULL default '0',
  `lawncare` int(11) NOT NULL default '0',
  `showpriorbalanceoninvoice` int(11) NOT NULL default '0',
  `petdeposit` int(11) NOT NULL default '0',
  `posblockchilditemsearch` int(11) NOT NULL default '0',
  `requireccbillingaddress` int(11) NOT NULL default '0',
  `requirecccardcode` int(11) NOT NULL default '0',
  `ccpaymentinstructions` text,
  `surveyorder` int(11) NOT NULL default '0',
  `surveyinvoice` int(11) NOT NULL default '0',
  `report_on_paid` int(5) NOT NULL default '0',
  `nocostupdate` int(5) NOT NULL default '0',
  `maintenance` int(11) NOT NULL default '0',
  `commissionmethod` varchar(20) default NULL,
  `hideoptions` int(11) NOT NULL default '0',
  `fulfillmentduedays` int(11) NOT NULL default '3',
  `serviceduedays` int(11) NOT NULL default '3',
  `hideinvpagenumber` int(11) NOT NULL default '0',
  `appendendnotes` int(11) NOT NULL default '0',
  `showinvsignature` int(11) NOT NULL default '0',
  `show_discount_on_forms` int(5) NOT NULL default '0',
  `formsize` int(5) NOT NULL default '0',
  `defaulttovendorcost` int(11) NOT NULL default '0',
  `default_order_message` text,
  `purgeordersdays` int(11) NOT NULL default '0',
  `purgeordershow` char(1) NOT NULL default 'U',
  `nocredit` int(11) NOT NULL default '0',
  `nocredit_note` varchar(255) NOT NULL default '',
  `hidequotelineprices` int(11) NOT NULL default '0',
  `defaultquoteprintnote` text,
  `minsalesmargin` decimal(6,2) NOT NULL default '0.00',
  `maxsalesmargin` decimal(6,2) NOT NULL default '0.00',
  `bestprice` int(11) NOT NULL default '0',
  `hideestshipdate` int(11) NOT NULL default '0',
  `default_incomplete_when_ship` int(5) NOT NULL default '0',
  `onlyBOonPrint` int(5) NOT NULL default '0',
  `auto_voucher_number` tinyint(4) NOT NULL default '1',
  `rebategl` int(11) NOT NULL default '0',
  `inventoryusetax` decimal(6,2) NOT NULL default '0.00',
  `full_sized_ship_sold_to_box` tinyint(4) NOT NULL default '0',
  `show_cust_notes_on_srv_edit` int(1) NOT NULL default '0',
  `defaulttostaticcost` int(11) NOT NULL default '0',
  `display_profit_per_line_pos` int(11) NOT NULL default '0',
  `showshiponinvoice` int(11) NOT NULL default '0',
  `usebackgroundinvpdf` int(11) NOT NULL default '0',
  `hideduedate` int(5) NOT NULL default '0',
  `defaultvendorid` int(11) NOT NULL default '0',
  `allowcreditdiscount` tinyint(4) NOT NULL default '0',
  `auto_shipped_email_style` tinyint(4) NOT NULL default '0',
  `showoverrideprice` tinyint(4) NOT NULL default '0',
  `showpackingslipsig` tinyint(4) NOT NULL default '0',
  `pricehistoryautodisplay` tinyint(4) NOT NULL default '1',
  `pricehistorymax` int(11) NOT NULL default '0',
  `showupsshipto` tinyint(4) NOT NULL default '0',
  `hideshipchargeups` tinyint(4) NOT NULL default '0',
  `terms_discount` int(5) NOT NULL default '0',
  `packingslipcount` tinyint(4) NOT NULL default '1',
  `b2b_requireponumber` tinyint(4) NOT NULL default '0',
  `orderduedatefromterms` tinyint(4) default '0',
  `b2b_paymentmethod` int(11) NOT NULL default '5',
  `canadianefttype` char(1) NOT NULL default 'G',
  `invoiceemailtemplateid` int(11) NOT NULL default '0',
  `sold_to_format` mediumtext,
  `ship_to_format` mediumtext,
  `ship_to_pickup_format` mediumtext,
  `requireponumber` tinyint(4) NOT NULL default '0',
  `showinvqtytotal` tinyint(4) NOT NULL default '0',
  `allowdiscountoverride` tinyint(4) NOT NULL default '0',
  `shipchargedefaultoactual` tinyint(1) default '1',
  `barcode_on_confirmation` tinyint(1) NOT NULL default '0',
  `current_or_payplan` tinyint(1) NOT NULL default '0',
  `hidelinetotals` tinyint(1) NOT NULL default '0',
  `hidepriceeach` tinyint(1) NOT NULL default '0',
  `splitdesc` tinyint(4) NOT NULL default '0',
  `picklist_qty_weight` tinyint(1) NOT NULL default '1',
  `picklist_multiprintwarning` tinyint(4) NOT NULL default '0',
  `showbomsubitems` tinyint(4) NOT NULL default '0',
  `reservationfeeglaccountid` int(11) NOT NULL default '0',
  `phonedigittrimnum` int(11) NOT NULL default '1',
  `pos_block_new_customers` tinyint(4) NOT NULL default '0',
  `orderformat` int(11) NOT NULL default '-1',
  `useordernumforponum` tinyint(4) NOT NULL default '0',
  `receiveautopo` tinyint(4) NOT NULL default '0',
  `showorderuser` tinyint(4) NOT NULL default '0',
  `statementmessagewithbankinfo` text,
  `statementmessagewithnobankinfo` text,
  `asmstoreid` varchar(100) NOT NULL default '',
  `asmstorename` varchar(100) NOT NULL default '',
  `showupsshiptopdf` tinyint(4) NOT NULL default '0',
  `showinvoicecustomfields` text,
  `display_linedate_pos` tinyint(4) NOT NULL default '0',
  `createjobwithnewcustomer` tinyint(4) NOT NULL default '0',
  `hideaddjobbuttons` tinyint(4) NOT NULL default '0',
  `useposfornewinvoices` tinyint(4) NOT NULL default '0',
  `invpdfhidelinenumbers` tinyint(4) NOT NULL default '0',
  `invpdfhideunitnames` tinyint(4) NOT NULL default '0',
  `invpdfhideshipto` tinyint(4) NOT NULL default '0',
  `invpdfcustomatshipto` tinyint(4) NOT NULL default '0',
  `invpdfposlabelinvoice` tinyint(4) NOT NULL default '0',
  `invpdfdescbeforeqty` tinyint(4) NOT NULL default '0',
  `hidejobnamecolumn` tinyint(4) NOT NULL default '0',
  `picklistconsolidatedgroup` tinyint(4) NOT NULL default '0',
  `blockinvoiceunpost` tinyint(1) NOT NULL default '0',
  `hideaccruedinterestonpayment` tinyint(1) NOT NULL default '0',
  `hideenterinterestonpayment` tinyint(1) NOT NULL default '0',
  `preventduplicateshipnames` tinyint(1) NOT NULL default '0',
  `b2blockstatus` tinyint(1) NOT NULL default '0',
  `b2bpaymentfee` decimal(19,4) NOT NULL default '0.0000',
  `b2bpaymentfeeispercentage` tinyint(1) NOT NULL default '0',
  `b2bpaymentfeeglid` int(11) NOT NULL default '0',
  `chargebackglid` int(11) NOT NULL default '0',
  `writeoffmax` decimal(19,4) NOT NULL default '-1.0000',
  `writeoffmaxperc` decimal(19,4) NOT NULL default '100.0000',
  `zlienkey` varchar(64) NOT NULL default '',
  `zliensecret` varchar(64) NOT NULL default '',
  `zlienurl` varchar(128) NOT NULL default '',
  `zlienportalurl` varchar(128) NOT NULL default '',
  `defaultinvoicepaymentamounttozero` tinyint(1) NOT NULL default '0',
  `blocksaleswithoutpurchaseby` tinyint(1) NOT NULL default '0',
  `blocknondirectglentryediting` tinyint(1) NOT NULL default '0',
  `blockprofitchangesforstockitems` tinyint(1) NOT NULL default '0',
  `blocknewpoforstocklineitems` tinyint(1) NOT NULL default '0',
  `hidepaymententryafterpos` tinyint(1) NOT NULL default '0',
  `hideposprintuntilafterpayment` tinyint(1) NOT NULL default '0',
  `hideposprintinvoice` tinyint(1) NOT NULL default '0',
  `defaultqtyshippedtozero` tinyint(1) NOT NULL default '0',
  `autoselectsalestax` tinyint(1) NOT NULL default '0',
  `dropshiprequireupload` tinyint(1) NOT NULL default '0',
  `suggestaltlocations` tinyint(1) NOT NULL default '1',
  `ordereditnotices` tinyint(1) NOT NULL default '0',
  `ordereditnoticesadmin` tinyint(1) NOT NULL default '0',
  `jobcreditmarkup` decimal(19,4) NOT NULL default '0.0000',
  `allowzeroqtyonquotes` tinyint(1) NOT NULL default '0',
  `rmanextinvoicenumber` varchar(64) NOT NULL default '',
  `rmareturnpolicy` mediumtext NOT NULL,
  `tax_rounding_detailed` tinyint(1) NOT NULL default '0',
  `jobprelimcreditlimit` decimal(12,6) NOT NULL default '0.000000',
  `billtrust_host` text NOT NULL,
  `billtrust_user` text NOT NULL,
  `billtrust_pass` text NOT NULL,
  `delivery_charge_max_order_total` decimal(19,4) NOT NULL,
  `fuel_charge_max_order_total` decimal(19,4) NOT NULL,
  `delivery_charge_itemid` int(11) NOT NULL,
  `delivery_charge_nontax_itemid` int(11) NOT NULL,
  `fuel_charge_itemid` int(11) NOT NULL,
  `fuel_charge_nontax_itemid` int(11) NOT NULL,
  `our_shipping_method` int(11) NOT NULL,
  `rental_cogs_percentage` decimal(12,6) NOT NULL,
  `forceinventoryitemsforquotetoorder` tinyint(1) NOT NULL default '0',
  `ordernumbering_last_serviceorder` varchar(32) NOT NULL default 'SO-*****0',
  `uspsaddressverify` tinyint(1) NOT NULL default '1',
  `joblinkcontractprelimdates` tinyint(1) NOT NULL default '0',
  `rentalsbillwhen` tinyint(1) NOT NULL default '0' COMMENT '0 = In Advancen1 = In Arrears',
  `invoicealwaysshowsummarybox` tinyint(1) NOT NULL default '0',
  `picklist_bin` tinyint(1) NOT NULL default '1',
  `nextcustomercode` int(11) NOT NULL default '1000',
  `showsiglineonordconf` tinyint(1) NOT NULL default '0',
  `autogencustomercode` tinyint(1) NOT NULL default '0',
  `convertdeferredrevenueandexpensesonjobclose` tinyint(1) NOT NULL default '0',
  `deferredrevenueglid` int(11) NOT NULL default '0',
  `deferredexpenseglid` int(11) NOT NULL default '0',
  `ordernumbering_last_fulfillmentorder` varchar(32) NOT NULL default 'FO-*****0',
  `ordernumbering_last_quote` varchar(32) NOT NULL default 'QT-*****0',
  `paid_on_account_itemid` int(11) NOT NULL,
  `invoicecronimportskipgls` tinyint(1) NOT NULL default '0',
  `arpaymentcronimportskipgls` tinyint(1) NOT NULL default '0',
  `showsalespersononquotes` tinyint(1) NOT NULL default '0',
  `showsiglineonquotes` tinyint(1) NOT NULL default '0',
  `singlecustomeremailperinput` tinyint(1) NOT NULL default '0',
  `foposselectinvtype` tinyint(1) NOT NULL default '0',
  `invoiceheadertext` text NOT NULL,
  `hidetermsoninvoicepdf` tinyint(1) NOT NULL default '0',
  `invoicepaymentinfotext` text NOT NULL,
  `invoiceheadersubtext` text NOT NULL,
  `invoicefooternotes` text NOT NULL,
  `invoiceshiptosubtext` text NOT NULL,
  `backorderdistroonly` tinyint(1) NOT NULL default '0',
  `prelimreplyto` varchar(255) NOT NULL default '',
  `b2buserdetailstemplate` int(11) NOT NULL default '0',
  `prelimtemplate` varchar(200) NOT NULL default '',
  `showautocompletecustomercode` tinyint(1) NOT NULL default '0',
  `minfincharge` decimal(19,4) NOT NULL default '0.0000',
  `invoiceinterest` tinyint(1) NOT NULL default '0',
  `jobsrequirescustomer` tinyint(1) NOT NULL default '0',
  `interestchargemin` decimal(19,4) NOT NULL default '0.0000',
  `invpdfhideitemcodes` tinyint(4) NOT NULL default '0',
  `invpdfhidejobcode` tinyint(4) NOT NULL default '0',
  `invpdfhidejobname` tinyint(4) NOT NULL default '0',
  `invpdfhidecustomernumber` tinyint(4) NOT NULL default '0',
  `blockshipposoverlimit` tinyint(4) NOT NULL default '0',
  `outonrentalglid` int(11) NOT NULL default '0',
  `blockfreeinvsales` tinyint(4) NOT NULL default '0',
  `contrarentalglid` int(11) NOT NULL default '0',
  `contranonstockrentalglid` int(11) NOT NULL default '0',
  `hiderentalnumperiods` tinyint(4) NOT NULL default '0',
  `interestdays` int(11) NOT NULL default '30',
  `paymentonaccountbankaccount` int(11) NOT NULL default '0',
  `blockinvoicenoshipdoc` tinyint(4) NOT NULL default '0',
  `invoicecronimportskipinventory` tinyint(4) NOT NULL default '0',
  `minimumpricelevelid` int(11) NOT NULL default '0',
  `showlocationonpaymentpage` tinyint(1) NOT NULL default '0',
  `defaultbankdepositcheckingaccount` int(11) NOT NULL default '0',
  `defaultbankdepositcostcode` int(11) NOT NULL default '0',
  `picklistshowvendoritemcode` tinyint(1) NOT NULL default '0',
  `dailyclosevarianceid` int(11) NOT NULL default '0',
  `dailyclosevariancemethod` char(1) NOT NULL default 'S',
  `customeraddshowcreditcardlink` tinyint(1) NOT NULL default '0',
  `showcostcodeonpaymentpage` tinyint(1) NOT NULL default '0',
  `hideqtyperprice` tinyint(4) NOT NULL default '0',
  `paymentonaccountalwayscollectconveniencefee` tinyint(1) NOT NULL default '0',
  `hidecarriername` tinyint(4) NOT NULL default '0',
  `stateswithnocountytaxifcitytax` text,
  `rentalcontracttext` text,
  `showpackingslipinvoicenotes` tinyint(1) NOT NULL default '0',
  `paymentplansalesaccountallowanyaccounttype` tinyint(1) NOT NULL default '0',
  `blockrentalcreditforfirstperiod` tinyint(1) NOT NULL default '0',
  `defaultprelimrequestsearchminimumopenamount` decimal(18,6) NOT NULL default '0.000000',
  `blockexpiredquotes` tinyint(1) NOT NULL default '0',
  `defaultcustomercarrierserviceid` int(11) NOT NULL default '0',
  `blockitemsnotforsale` int(11) NOT NULL default '0',
  `nextjobcode` int(11) NOT NULL default '10000',
  `quotemaxexpdays` int(11) NOT NULL default '0',
  `quotedefaultexpdays` int(11) NOT NULL default '30',
  `enterpayments_readonlyinventorylocation` tinyint(1) NOT NULL default '0',
  `lowestcanoverrideprice` tinyint(4) NOT NULL default '0',
  `emailcenterdefaultprivate` tinyint(1) NOT NULL default '0',
  `lockjobcodes` tinyint(1) NOT NULL default '0',
  `ordersmusthaveshiptocityzip` tinyint(1) NOT NULL default '0',
  `defaultorderstostaticcost` tinyint(4) NOT NULL default '0',
  `forcecheckingaccountidforenterpayments` int(11) NOT NULL default '0',
  `forcecheckingaccountidforposfo` int(11) NOT NULL default '0',
  `combinetaxesinvoicepdf` tinyint(4) NOT NULL default '0',
  `showdetailedtotalsonpackingsplip` tinyint(1) NOT NULL default '0',
  `showshipconfirmfo` tinyint(4) NOT NULL default '0',
  `blocknonstockpos` tinyint(1) NOT NULL default '0',
  `forequireshippingzipstateandcity` tinyint(1) NOT NULL default '0',
  `emailorderconfwhenshipping` tinyint(4) NOT NULL default '0',
  `showextravaluesummaryonorderconf` tinyint(1) NOT NULL default '0',
  `defaultorderconfemailtemplateid` int(11) NOT NULL default '0',
  `statementemailheader` varchar(128) NOT NULL default '',
  `showinvoiceterms` tinyint(1) NOT NULL default '0',
  `defaultshowpricesondeliveryconf` tinyint(1) NOT NULL default '0',
  `defaultshowpricesonpackingslip` tinyint(1) NOT NULL default '0',
  `defaultallowordermodifications` tinyint(1) NOT NULL default '0',
  `hidepaymentterms` tinyint(1) default '0',
  `b2bdefaultinventorylocationid` int(11) NOT NULL default '0',
  `allowuserrestockfeeoverride` tinyint(1) NOT NULL default '0',
  `restockfeeistaxed` tinyint(1) NOT NULL default '1',
  `restockfeegroupedontooneline` tinyint(1) NOT NULL default '0',
  `blockordersavewithoutshippingpref` tinyint(1) NOT NULL default '0',
  `defaultjobshippingmethod` int(11) NOT NULL default '0',
  `interestmincustomerbalance` decimal(18,6) NOT NULL default '0.000000',
  `display_unit_of_measure` int(5) NOT NULL default '0',
  `showboqtyonpackingslip` tinyint(1) NOT NULL default '1',
  `requirereasonforardeletions` tinyint(1) NOT NULL default '0',
  `shipqty_on_confirmation` tinyint(1) NOT NULL default '0',
  `hidelinenum_on_confirmation` tinyint(1) NOT NULL default '0',
  `nocredit_invoicetermsid` int(11) NOT NULL default '0',
  `ardeletionnoticesadmin` tinyint(1) NOT NULL default '0',
  `excludeprevshippeditemsonpackingslip` tinyint(1) NOT NULL default '0',
  `showweightwithunnumber` tinyint(1) NOT NULL default '0',
  `substituteinvlocationinfo` tinyint(1) NOT NULL default '0',
  `forceinventoryitemsforallsales` tinyint(1) NOT NULL default '0',
  `blockshiptoeditsonorderentry` tinyint(1) NOT NULL default '0',
  `blockrentalsfornocreditcustomers` tinyint(1) NOT NULL default '0',
  `notifysalespersonnewcustomerswithcredit` tinyint(1) NOT NULL default '0',
  `notifysalespersonfornewjobs` tinyint(1) NOT NULL default '0',
  `notifysalespersonfornewrentalorders` tinyint(4) NOT NULL default '0',
  `emailregionmanagerscustnosales` tinyint(4) NOT NULL default '0',
  `daystoprelim` int(11) NOT NULL default '20',
  `limitedshiptoaddressentry` tinyint(1) NOT NULL default '0',
  `allowshipovercreditwithfulldeposit` tinyint(1) NOT NULL default '0',
  `stateswithshippingtax` text NOT NULL,
  `showsavezeroqtywarning` tinyint(1) NOT NULL default '1',
  `showsavezeropricewarning` tinyint(1) NOT NULL default '1',
  `positemlookuplayout` varchar(16) NOT NULL default '',
  `showitemlookuponorderentryline` varchar(1) NOT NULL default 'A',
  `specialpricingstatic` tinyint(1) NOT NULL default '1',
  `effectivetaxselectblock` tinyint(1) NOT NULL default '1',
  `rentalshipandreturnskipgloutonrentglstock` tinyint(1) NOT NULL default '0',
  `rentalshipandreturnskipgloutonrentglnonstock` tinyint(1) NOT NULL default '0',
  `rentalshipandreturnskipgloutonrentglothercharges` tinyint(1) NOT NULL default '0',
  `rentalstockusescogspercentage` tinyint(1) NOT NULL default '0',
  `rentalnonstockusescogspercentage` tinyint(1) NOT NULL default '0',
  `rentalotherchargesusescogspercentage` tinyint(1) NOT NULL default '0',
  `jobsrequirecitystatezip` tinyint(4) NOT NULL default '0',
  `blockvoideftpayments` tinyint(1) NOT NULL default '0',
  `notebelowordertotal` varchar(100) NOT NULL default '',
  `invoicedeliverybullpinningenabled` tinyint(1) NOT NULL default '0',
  `invoicedeliverybullpinningexcludeafterdays` int(11) NOT NULL default '0',
  `invoicedeliverybullpinningexcludeinvoicesover` decimal(19,4) NOT NULL default '0.0000',
  `invoicedeliverybullpinningexcludecustomersover` decimal(19,4) NOT NULL default '0.0000',
  `invoicedeliverybullpinningexcludelastdayofmonth` tinyint(1) NOT NULL default '0',
  `invoicedeliverybullpinningexcludeallinvoiceswhenanypending` tinyint(1) NOT NULL default '1',
  `shipunreceivedpoaction` tinyint(1) NOT NULL default '0',
  `b2bpaymentfeeglcategoryid` int(11) NOT NULL default '0',
  `rentaldefaultglcategoryid` int(11) NOT NULL default '0',
  `invoicedeliverybullpinningexcludeemail` tinyint(1) NOT NULL default '0',
  `invoicedeliverybullpinningexcludemail` tinyint(1) NOT NULL default '0',
  `invoicedeliverybullpinningexcludefax` tinyint(1) NOT NULL default '0',
  `sendspecialpricelistexpnotice` int(11) NOT NULL default '-1',
  `sendspecialpricelistsummary` tinyint(1) NOT NULL default '0',
  `blocknegqtysales` tinyint(4) default '0',
  `dailydrawerclosecreatebankdepositmode` tinyint(1) NOT NULL default '0',
  `sendnewcustemail` tinyint(4) default '0',
  `refundcreditviacheckslocation` int(11) NOT NULL default '0',
  `bankdepositscanincluderefunds` tinyint(1) NOT NULL default '0',
  `bankdepositsincludeglexpenses` tinyint(1) NOT NULL default '0',
  `blockposforcustomerswithpricingonpacking` tinyint(4) default '0',
  `saveorderentryprogress` int(11) NOT NULL default '120',
  `fromemailforinvoices` varchar(255) NOT NULL default '',
  `fromemailforstatementsaddress` varchar(255) NOT NULL default '',
  `fromemailforprelim` varchar(255) NOT NULL default '',
  `fromemailfororderconfirmation` varchar(255) NOT NULL default '',
  `fromemailforbids` varchar(255) NOT NULL default '',
  `hideagingoncustomerstatements` tinyint(1) NOT NULL default '0',
  `updatecustomerinvoicetermsonsale` tinyint(1) NOT NULL default '1',
  `allowpaymentagainstclosedinvoice` tinyint(1) NOT NULL default '0',
  `showamountandduedateoninvoicefooter` tinyint(1) NOT NULL default '0',
  `groupitemsonorderconfirmation` tinyint(1) NOT NULL default '0',
  `enlargeorderinfotextonorderconfirmation` tinyint(1) default '0',
  `pricehistoryfomode` int(11) NOT NULL default '0',
  `pricehistorydayslimit` int(11) NOT NULL default '0',
  `showinvoicedateonpaymententry` tinyint(1) NOT NULL default '0',
  `hideduedateonpayment` tinyint(1) NOT NULL default '0',
  `showadjustedbalanceonpayment` tinyint(1) NOT NULL default '0',
  `invoiceagingusesduedate` tinyint(1) NOT NULL default '0',
  `invoiceagingexcludecredits` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arcompany`
--

LOCK TABLES `arcompany` WRITE;
/*!40000 ALTER TABLE `arcompany` DISABLE KEYS */;
/*!40000 ALTER TABLE `arcompany` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ardailyclose`
--

DROP TABLE IF EXISTS `ardailyclose`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ardailyclose` (
  `id` int(11) NOT NULL auto_increment,
  `inventorylocationid` int(11) NOT NULL,
  `closedate` date default NULL,
  `actualcash` decimal(19,4) NOT NULL default '0.0000',
  `currencybreakdown` text,
  `currency` varchar(10) default NULL,
  `sys_cash` decimal(19,4) NOT NULL default '0.0000',
  `sys_checks` decimal(19,4) NOT NULL default '0.0000',
  `sys_cc` decimal(19,4) NOT NULL default '0.0000',
  `gl_cash` decimal(19,4) NOT NULL default '0.0000',
  `gl_checks` decimal(19,4) NOT NULL default '0.0000',
  `gl_cc` decimal(19,4) NOT NULL default '0.0000',
  `actualchecks` decimal(19,4) NOT NULL default '0.0000',
  `cashdrawerfloat` decimal(19,4) NOT NULL default '0.0000',
  `depositeamount` decimal(19,4) NOT NULL default '0.0000',
  `actualcc` decimal(19,4) NOT NULL default '0.0000',
  `overshort` decimal(19,4) NOT NULL default '0.0000',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `location` (`inventorylocationid`),
  KEY `closedate` (`closedate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ardailyclose`
--

LOCK TABLES `ardailyclose` WRITE;
/*!40000 ALTER TABLE `ardailyclose` DISABLE KEYS */;
/*!40000 ALTER TABLE `ardailyclose` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `area`
--

DROP TABLE IF EXISTS `area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `area` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `surveyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `applicationfee` decimal(19,6) NOT NULL default '0.000000',
  `blockfromsignups` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `area`
--

LOCK TABLES `area` WRITE;
/*!40000 ALTER TABLE `area` DISABLE KEYS */;
/*!40000 ALTER TABLE `area` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoice`
--

DROP TABLE IF EXISTS `arinvoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoice` (
  `id` int(11) NOT NULL auto_increment,
  `invoicenumber` varchar(30) NOT NULL default '',
  `ponumber` varchar(30) default NULL,
  `wherefrom` int(11) NOT NULL default '2',
  `orderid` int(11) NOT NULL default '0',
  `orderbycompanyid` int(11) NOT NULL default '0',
  `shiptocompanyid` int(11) NOT NULL default '0',
  `status` int(11) NOT NULL default '0',
  `customerbillcode` varchar(20) default NULL,
  `shipcost` decimal(19,4) NOT NULL default '0.0000',
  `invoicetotal` decimal(19,4) NOT NULL default '0.0000',
  `invoicetermsid` int(11) NOT NULL default '0',
  `salesmanid` int(11) NOT NULL default '0',
  `invoicedate` date default NULL,
  `duedate` date default NULL,
  `discountdate` date default NULL,
  `discountamount` decimal(19,4) NOT NULL default '0.0000',
  `accruedinterest` decimal(19,4) NOT NULL default '0.0000',
  `datelastinterestcalc` date default NULL,
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `pricelevelid` int(11) NOT NULL default '0',
  `inventorylocationid` int(11) NOT NULL default '0',
  `payment_method` varchar(12) default NULL,
  `cc_type` varchar(20) default NULL,
  `cc_owner` varchar(64) default NULL,
  `cc_number` varchar(32) default NULL,
  `cc_expires` varchar(4) default NULL,
  `shipping_method` varchar(32) default NULL,
  `currency` varchar(10) NOT NULL default 'USD',
  `cc_PNREF` varchar(12) default NULL,
  `cc_AUTHCODE` varchar(6) default NULL,
  `transaction_id` varchar(32) default NULL,
  `customers_id` int(5) default NULL,
  `currency_value` decimal(14,6) NOT NULL default '0.000000',
  `servicerepid` int(11) NOT NULL default '0',
  `discountapplied` decimal(19,4) NOT NULL default '0.0000',
  `payplan` int(2) NOT NULL default '0',
  `payplan_period` int(5) NOT NULL default '0',
  `payplan_days` int(11) NOT NULL default '0',
  `payplan_next` date default NULL,
  `payplan_numtimes` int(11) NOT NULL default '0',
  `sales_categoriesid` int(11) NOT NULL default '0',
  `coverage` int(3) NOT NULL default '0',
  `formnumber` varchar(50) default NULL,
  `shiptoattn` varchar(100) default NULL,
  `old_id` varchar(255) default NULL,
  `client_po` varchar(30) default NULL,
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  `arglaccountid` int(11) NOT NULL default '0',
  `leaseid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `delivered` int(11) NOT NULL default '0',
  `carrierserviceid_preferred` int(11) NOT NULL default '0',
  `taxclassid` int(11) NOT NULL default '0',
  `b2bhidden` tinyint(1) NOT NULL default '0',
  `interestforinvoiceid` int(11) NOT NULL default '0',
  `zlienid` int(11) NOT NULL default '0',
  `billtrustsent` datetime default NULL,
  `faxsent` datetime default NULL,
  `emailsent` datetime default NULL,
  `contactnameid` int(11) NOT NULL default '0',
  `invoicenotificationmethod` varchar(1) NOT NULL default '',
  `jobid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  `taxexemptid` int(11) NOT NULL default '0',
  `isacustomerreturn` varchar(1) NOT NULL default '0',
  `priceadjustmentforinvoiceid` int(11) NOT NULL default '0',
  `taxadjustmentforinvoiceid` int(11) NOT NULL default '0',
  `voucherid` int(11) NOT NULL default '0',
  `rental` tinyint(4) NOT NULL default '0',
  `paiddate` datetime default NULL,
  `paymeth` tinyint(1) NOT NULL default '0',
  `rentalconverttosale` tinyint(1) NOT NULL default '0',
  `modifiedfromarinvoiceid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoicenumber` (`invoicenumber`),
  KEY `ponumber` (`ponumber`),
  KEY `orderbycompanyid` (`orderbycompanyid`),
  KEY `invoicedate` (`invoicedate`),
  KEY `shiptocompanyid` (`shiptocompanyid`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `sales_categoriesid` (`sales_categoriesid`),
  KEY `cancel` (`cancel`),
  KEY `canceldate` (`canceldate`),
  KEY `lastchangedate` (`lastchangedate`),
  KEY `payplan` (`payplan`),
  KEY `orderid` (`orderid`),
  KEY `leaseid` (`leaseid`),
  KEY `salesmanid` (`salesmanid`),
  KEY `gltr_costcodeid` (`costcodeid`),
  KEY `jobid` (`jobid`),
  KEY `interestforinvoiceid` (`interestforinvoiceid`),
  KEY `glcategoryid` (`glcategoryid`),
  KEY `dataList` (`gencompanyid`,`status`,`payplan`,`cancel`),
  KEY `aging_report` (`cancel`,`status`,`gencompanyid`,`payplan`,`invoicedate`),
  KEY `billtrustsent` (`billtrustsent`),
  KEY `faxsent` (`faxsent`),
  KEY `emailsent` (`emailsent`),
  KEY `voucherid` (`voucherid`),
  KEY `inventorylocationid` (`inventorylocationid`),
  KEY `rental` (`rental`),
  KEY `activeonjob` (`jobid`,`cancel`),
  KEY `modifiedfromarinvoiceid` (`modifiedfromarinvoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoice`
--

LOCK TABLES `arinvoice` WRITE;
/*!40000 ALTER TABLE `arinvoice` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoice_interest`
--

DROP TABLE IF EXISTS `arinvoice_interest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoice_interest` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `calcdate` date default NULL,
  `amount` decimal(19,5) NOT NULL default '0.00000',
  `cancel` tinyint(4) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `balance` decimal(19,4) NOT NULL default '0.0000',
  `ratemonths` int(11) NOT NULL default '0',
  `rate` decimal(8,4) default NULL,
  `servicecharge` decimal(19,4) default NULL,
  `interestinvoiceid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `calcdate` (`calcdate`),
  KEY `cancel` (`cancel`),
  KEY `invoiceid` (`invoiceid`),
  KEY `interestinvoiceid` (`interestinvoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoice_interest`
--

LOCK TABLES `arinvoice_interest` WRITE;
/*!40000 ALTER TABLE `arinvoice_interest` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoice_interest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicecalculationscache`
--

DROP TABLE IF EXISTS `arinvoicecalculationscache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicecalculationscache` (
  `arinvoiceid` int(11) NOT NULL,
  `total` decimal(19,4) default NULL,
  `paid` decimal(19,4) default NULL,
  `discount` decimal(19,4) default NULL,
  `balance` decimal(19,4) default NULL,
  PRIMARY KEY  (`arinvoiceid`),
  KEY `everything` (`arinvoiceid`,`total`,`paid`,`discount`,`balance`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicecalculationscache`
--

LOCK TABLES `arinvoicecalculationscache` WRITE;
/*!40000 ALTER TABLE `arinvoicecalculationscache` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicecalculationscache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicedelivery`
--

DROP TABLE IF EXISTS `arinvoicedelivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicedelivery` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `deliverydate` date default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `entrydate` (`entrydate`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicedelivery`
--

LOCK TABLES `arinvoicedelivery` WRITE;
/*!40000 ALTER TABLE `arinvoicedelivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicedelivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicedeliverydetail`
--

DROP TABLE IF EXISTS `arinvoicedeliverydetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicedeliverydetail` (
  `id` int(11) NOT NULL auto_increment,
  `arinvoicedeliveryid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `description` varchar(100) default NULL,
  `qty` decimal(18,6) NOT NULL default '0.000000',
  `qtyunitnameid` int(11) NOT NULL default '0',
  `note` text,
  PRIMARY KEY  (`id`),
  KEY `arinvoicedeliveryid` (`arinvoicedeliveryid`),
  KEY `linenumber` (`linenumber`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicedeliverydetail`
--

LOCK TABLES `arinvoicedeliverydetail` WRITE;
/*!40000 ALTER TABLE `arinvoicedeliverydetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicedeliverydetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicedetail`
--

DROP TABLE IF EXISTS `arinvoicedetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicedetail` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `description` varchar(255) default NULL,
  `qty` decimal(18,6) NOT NULL default '1.000000',
  `qtyunitnameid` int(11) NOT NULL default '0',
  `glaccountid` int(11) NOT NULL default '0',
  `taxflag` int(11) NOT NULL default '0',
  `priceach` decimal(19,6) NOT NULL default '0.000000',
  `priceunitnameid` int(11) NOT NULL default '0',
  `qtyunitperpriceunit` decimal(19,6) NOT NULL default '1.000000',
  `totalprice` decimal(19,4) NOT NULL default '0.0000',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `costeach` decimal(19,6) NOT NULL default '0.000000',
  `costglaccountid` int(11) NOT NULL default '0',
  `main_arinvoicedetailid` int(11) NOT NULL default '0',
  `itemoptionid` int(11) NOT NULL default '0',
  `itemoptiongroupid` int(11) NOT NULL default '0',
  `taxflag2` int(2) NOT NULL default '0',
  `taxflag3` int(2) NOT NULL default '0',
  `taxflagid` int(11) NOT NULL default '0',
  `taxflag2id` int(11) NOT NULL default '0',
  `taxflag3id` int(11) NOT NULL default '0',
  `orig_priceach` decimal(12,5) NOT NULL default '0.00000',
  `discount_amount` decimal(12,5) NOT NULL default '0.00000',
  `discount_percent` decimal(12,5) NOT NULL default '0.00000',
  `old_id` varchar(255) default NULL,
  `pricelevelid` int(11) NOT NULL default '0',
  `price_override` int(5) NOT NULL default '0',
  `extended_price` decimal(19,5) NOT NULL default '0.00000',
  `worktypeid` int(11) NOT NULL default '0',
  `worksubtypeid` int(11) NOT NULL default '0',
  `returnqty` decimal(18,6) NOT NULL default '0.000000',
  `returndetailid` int(11) NOT NULL default '0',
  `discountid` int(11) NOT NULL default '0',
  `discountpercent` decimal(7,2) NOT NULL default '0.00',
  `inventorylocationid` int(11) NOT NULL default '0',
  `linedate` date default NULL,
  `taxclassid` int(11) NOT NULL default '0',
  `partialtaxexemptionid` int(11) NOT NULL default '0',
  `linetype` tinyint(1) NOT NULL default '0',
  `period` char(1) NOT NULL default '',
  `rentalbegindate` date default NULL,
  `itempricespecialdetailid` int(11) NOT NULL default '0',
  `numperiods` decimal(19,6) NOT NULL default '1.000000',
  `arorderdetailid` int(11) NOT NULL default '0',
  `producttypetaxid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `linenumber` (`linenumber`),
  KEY `qty` (`qty`),
  KEY `glaccountid` (`glaccountid`),
  KEY `inventorylocationid` (`inventorylocationid`),
  KEY `itemid` (`itemid`),
  KEY `taxclassid` (`taxclassid`),
  KEY `arorderdetailid` (`arorderdetailid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicedetail`
--

LOCK TABLES `arinvoicedetail` WRITE;
/*!40000 ALTER TABLE `arinvoicedetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicedetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicedetailcost`
--

DROP TABLE IF EXISTS `arinvoicedetailcost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicedetailcost` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `cost` decimal(19,4) NOT NULL default '0.0000',
  `costglaccountid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `itemid` int(11) NOT NULL default '0',
  `locationid` int(11) NOT NULL default '0',
  `arordershipdetailid` int(11) NOT NULL default '0',
  `inventoryglacctid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoiceid` (`invoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicedetailcost`
--

LOCK TABLES `arinvoicedetailcost` WRITE;
/*!40000 ALTER TABLE `arinvoicedetailcost` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicedetailcost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicedetailnotes`
--

DROP TABLE IF EXISTS `arinvoicedetailnotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicedetailnotes` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `note` text,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `private` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `linenumber` (`linenumber`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicedetailnotes`
--

LOCK TABLES `arinvoicedetailnotes` WRITE;
/*!40000 ALTER TABLE `arinvoicedetailnotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicedetailnotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicedetailpending`
--

DROP TABLE IF EXISTS `arinvoicedetailpending`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicedetailpending` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `unitid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `camallocationid` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `description` varchar(100) NOT NULL default '',
  `qty` decimal(18,6) NOT NULL default '1.000000',
  `qtyunitnameid` int(11) NOT NULL default '0',
  `glaccountid` int(11) NOT NULL default '0',
  `taxflag` int(11) NOT NULL default '0',
  `priceach` decimal(19,6) NOT NULL default '0.000000',
  `priceunitnameid` int(11) NOT NULL default '0',
  `qtyunitperpriceunit` decimal(19,6) NOT NULL default '0.000000',
  `totalprice` decimal(19,4) NOT NULL default '0.0000',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `costeach` decimal(19,6) NOT NULL default '0.000000',
  `costglaccountid` int(11) NOT NULL default '0',
  `taxflag2` int(2) NOT NULL default '0',
  `taxflag3` int(2) NOT NULL default '0',
  `taxflagid` int(11) NOT NULL default '0',
  `taxflag2id` int(11) NOT NULL default '0',
  `taxflag3id` int(11) NOT NULL default '0',
  `pricelevelid` int(11) NOT NULL default '0',
  `price_override` int(5) NOT NULL default '0',
  `extended_price` decimal(19,5) NOT NULL default '0.00000',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `unitid` (`unitid`),
  KEY `camallocationid` (`camallocationid`),
  KEY `customerid` (`customerid`),
  KEY `qty` (`qty`),
  KEY `glaccountid` (`glaccountid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicedetailpending`
--

LOCK TABLES `arinvoicedetailpending` WRITE;
/*!40000 ALTER TABLE `arinvoicedetailpending` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicedetailpending` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicedetailref`
--

DROP TABLE IF EXISTS `arinvoicedetailref`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicedetailref` (
  `id` int(11) NOT NULL auto_increment,
  `arinvoicedetailid` int(11) NOT NULL,
  `reftable` varchar(64) NOT NULL default '',
  `refid` int(11) NOT NULL,
  `reftag` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `arinvoicedetailid` (`arinvoicedetailid`),
  KEY `ref` (`reftable`,`refid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicedetailref`
--

LOCK TABLES `arinvoicedetailref` WRITE;
/*!40000 ALTER TABLE `arinvoicedetailref` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicedetailref` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicenotes`
--

DROP TABLE IF EXISTS `arinvoicenotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicenotes` (
  `invoiceid` int(11) NOT NULL default '0',
  `note` text,
  `hide` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `source_noteid` int(11) NOT NULL default '0',
  `id` int(11) NOT NULL auto_increment,
  UNIQUE KEY `id` (`id`),
  KEY `invoiceid` (`invoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicenotes`
--

LOCK TABLES `arinvoicenotes` WRITE;
/*!40000 ALTER TABLE `arinvoicenotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicenotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicenotice`
--

DROP TABLE IF EXISTS `arinvoicenotice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicenotice` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `action` varchar(45) NOT NULL default '',
  `tablename` varchar(45) NOT NULL default '',
  `tableid` int(11) default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `action` (`action`),
  KEY `tabledata` (`tablename`,`tableid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicenotice`
--

LOCK TABLES `arinvoicenotice` WRITE;
/*!40000 ALTER TABLE `arinvoicenotice` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicenotice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicenotification`
--

DROP TABLE IF EXISTS `arinvoicenotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicenotification` (
  `id` int(11) NOT NULL auto_increment,
  `begindate` date default NULL,
  `enddate` date default NULL,
  `datesent` datetime default NULL,
  `numbersent` int(11) NOT NULL default '0',
  `numberqueued` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `latenotice` varchar(25) NOT NULL default '',
  `dayslate` int(11) default NULL,
  `chargefee` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `datesent` (`datesent`),
  KEY `entryuserid` (`entryuserid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicenotification`
--

LOCK TABLES `arinvoicenotification` WRITE;
/*!40000 ALTER TABLE `arinvoicenotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicenotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicepaymentdetail`
--

DROP TABLE IF EXISTS `arinvoicepaymentdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicepaymentdetail` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `voucherid` int(11) NOT NULL default '0',
  `datereceived` date default NULL,
  `paymeth` int(11) NOT NULL default '1',
  `interest` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `cancel_userid` int(11) NOT NULL default '0',
  `checkid` varchar(100) default NULL,
  `bankdepositid` int(11) NOT NULL default '0',
  `bankstatement_enddate` date default NULL,
  `old_id` varchar(255) default NULL,
  `refund_paymeth` int(11) NOT NULL default '0',
  `cctransactionid` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  `returned` int(11) NOT NULL default '0',
  `feeinvoiceid` int(11) NOT NULL default '0',
  `feeapbillid` int(11) NOT NULL default '0',
  `bankfee_amount` decimal(19,4) NOT NULL default '0.0000',
  `bankfee_glid` int(11) NOT NULL default '0',
  `rnum` varchar(30) NOT NULL default '',
  `tendered` decimal(19,4) NOT NULL default '0.0000',
  `transid` varchar(32) default NULL,
  `orderdepositid` int(11) NOT NULL default '0',
  `jointcheck` tinyint(1) NOT NULL default '0',
  `isb2bpaymentfee` tinyint(1) NOT NULL default '0',
  `isb2bpayment` tinyint(1) NOT NULL default '0',
  `ispaymentonaccount` tinyint(1) NOT NULL default '0',
  `writeoffreasonid` tinyint(1) NOT NULL default '0',
  `inventorylocationid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `ccterminalid` int(11) NOT NULL default '0',
  `extuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `voucherid` (`voucherid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `paymeth` (`paymeth`),
  KEY `checkid` (`checkid`),
  KEY `bankdepositid` (`bankdepositid`),
  KEY `cancel` (`cancel`),
  KEY `rnum` (`rnum`),
  KEY `interest` (`interest`),
  KEY `datereceived` (`datereceived`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicepaymentdetail`
--

LOCK TABLES `arinvoicepaymentdetail` WRITE;
/*!40000 ALTER TABLE `arinvoicepaymentdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicepaymentdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicepaymentnotes`
--

DROP TABLE IF EXISTS `arinvoicepaymentnotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicepaymentnotes` (
  `id` int(11) NOT NULL auto_increment,
  `voucherid` int(11) NOT NULL default '0',
  `note` text,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `voucherid` (`voucherid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicepaymentnotes`
--

LOCK TABLES `arinvoicepaymentnotes` WRITE;
/*!40000 ALTER TABLE `arinvoicepaymentnotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicepaymentnotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicestdnotes`
--

DROP TABLE IF EXISTS `arinvoicestdnotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicestdnotes` (
  `id` int(11) NOT NULL auto_increment,
  `shortnote` varchar(50) default NULL,
  `full_note` text,
  `sortorder` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` date default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `autoselect` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `sortorder` (`sortorder`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicestdnotes`
--

LOCK TABLES `arinvoicestdnotes` WRITE;
/*!40000 ALTER TABLE `arinvoicestdnotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicestdnotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicetaxdetail`
--

DROP TABLE IF EXISTS `arinvoicetaxdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicetaxdetail` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `taxid` int(11) NOT NULL default '0',
  `partialtaxid` int(11) NOT NULL default '0',
  `taxrate` decimal(12,5) NOT NULL default '0.00000',
  `taxamount` decimal(19,4) NOT NULL default '0.0000',
  `taxcap` decimal(19,4) NOT NULL default '0.0000',
  `taxexemptid` int(11) NOT NULL default '0',
  `taxexemptportion` decimal(12,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `taxid` (`taxid`),
  KEY `taxexemptid` (`taxexemptid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicetaxdetail`
--

LOCK TABLES `arinvoicetaxdetail` WRITE;
/*!40000 ALTER TABLE `arinvoicetaxdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicetaxdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arinvoicevoucherbatch`
--

DROP TABLE IF EXISTS `arinvoicevoucherbatch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arinvoicevoucherbatch` (
  `id` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `voucherid` int(11) NOT NULL default '0',
  `batchid` varchar(16) NOT NULL default '',
  `reversed` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `voucherid` (`voucherid`),
  KEY `batchid` (`batchid`),
  KEY `reversed` (`reversed`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arinvoicevoucherbatch`
--

LOCK TABLES `arinvoicevoucherbatch` WRITE;
/*!40000 ALTER TABLE `arinvoicevoucherbatch` DISABLE KEYS */;
/*!40000 ALTER TABLE `arinvoicevoucherbatch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorder`
--

DROP TABLE IF EXISTS `arorder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorder` (
  `id` int(11) NOT NULL auto_increment,
  `ordernumber` double NOT NULL default '0',
  `onum` varchar(30) NOT NULL default '',
  `ponumber` varchar(30) default NULL,
  `orderbycompanyid` int(11) NOT NULL default '0',
  `shiptocompanyid` int(11) NOT NULL default '0',
  `status` int(11) NOT NULL default '0',
  `customerbillcode` varchar(20) default NULL,
  `companyid` int(11) NOT NULL default '0',
  `pricelevelid` int(11) NOT NULL default '0',
  `inventorylocationid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `duedate` date default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `payment_method` varchar(12) default '',
  `cc_type` varchar(20) default NULL,
  `cc_owner` varchar(64) default NULL,
  `cc_number` varchar(32) default NULL,
  `cc_expires` varchar(7) default NULL,
  `shipping_method` varchar(32) default NULL,
  `orders_date_finished` timestamp NOT NULL default '0000-00-00 00:00:00',
  `currency` varchar(10) NOT NULL default 'USD',
  `cc_PNREF` varchar(12) default NULL,
  `cc_AUTHCODE` varchar(6) default NULL,
  `transaction_id` varchar(32) default NULL,
  `customers_id` int(5) default NULL,
  `shipping_cost` decimal(19,4) NOT NULL default '0.0000',
  `order_weight` decimal(12,2) NOT NULL default '0.00',
  `ordertotal` decimal(19,4) NOT NULL default '0.0000',
  `currency_value` decimal(14,6) default NULL,
  `wherefrom` varchar(100) default '',
  `confirmed_by` varchar(100) default '',
  `confirmed_date` varchar(100) default '',
  `confirmed` varchar(100) default '',
  `paymeth` int(11) NOT NULL default '0',
  `ordertype` int(2) NOT NULL default '0',
  `estimate` decimal(19,4) NOT NULL default '0.0000',
  `deposit` decimal(19,4) NOT NULL default '0.0000',
  `salesmanid` int(11) NOT NULL default '0',
  `sales_categoriesid` int(11) NOT NULL default '0',
  `statusid` int(11) NOT NULL default '0',
  `rma_arorder_returnedid` int(11) NOT NULL default '0',
  `rma_orig_arorderid` int(11) NOT NULL default '0',
  `carrierserviceid_preferred` int(11) NOT NULL default '0',
  `finalship` int(5) NOT NULL default '0',
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  `arglaccountid` int(11) NOT NULL default '0',
  `defaultworktypeid` int(11) NOT NULL default '0',
  `jobid` int(11) NOT NULL default '0',
  `defaultworksubtypeid` int(11) NOT NULL default '0',
  `stageid` int(11) NOT NULL default '0',
  `edi` int(11) NOT NULL default '0',
  `ediasn` int(11) NOT NULL default '0',
  `ediinvoice` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  `dropship` tinyint(1) NOT NULL default '0',
  `unread` tinyint(1) NOT NULL default '0',
  `contactnameid` int(11) NOT NULL default '0',
  `usecontactdetails` tinyint(1) NOT NULL default '0',
  `signaturerequired` tinyint(1) NOT NULL default '0',
  `rentalsbillwhen` tinyint(1) NOT NULL default '0',
  `outsidesalesmargin` int(11) NOT NULL default '0',
  `lastshipdate` datetime default NULL,
  `defaultvendorid` int(11) NOT NULL default '0',
  `shippingnotes` text,
  `revision` int(11) NOT NULL default '0',
  `pickticklastprint` datetime default NULL,
  `pickticknumprint` int(11) NOT NULL default '0',
  `taxclassid` int(11) NOT NULL default '0',
  `taxexemptid` int(11) NOT NULL default '0',
  `clonedquotearorderid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `ponumber` (`ponumber`),
  KEY `ordernumber` (`ordernumber`),
  KEY `inventorylocationid` (`inventorylocationid`),
  KEY `companyid` (`companyid`),
  KEY `shiptocompanyid` (`shiptocompanyid`),
  KEY `pricelevelid` (`pricelevelid`),
  KEY `orderbycompanyid` (`orderbycompanyid`),
  KEY `sales_categoriesid` (`sales_categoriesid`),
  KEY `jobid` (`jobid`),
  KEY `stageid` (`stageid`),
  KEY `edi` (`edi`),
  KEY `onum` (`onum`),
  KEY `gltr_costcodeid` (`costcodeid`),
  KEY `glcategoryid` (`glcategoryid`),
  KEY `ccso` (`companyid`,`cancel`,`status`,`ordertype`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorder`
--

LOCK TABLES `arorder` WRITE;
/*!40000 ALTER TABLE `arorder` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorder_deposit`
--

DROP TABLE IF EXISTS `arorder_deposit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorder_deposit` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `payment_method` int(5) NOT NULL default '0',
  `transaction_id` varchar(32) default NULL,
  `entrydate` date default NULL,
  `cc_type` varchar(20) default NULL,
  `last4ofcard` varchar(4) default NULL,
  `voucherid` int(11) NOT NULL default '0',
  `cancel` int(3) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `bankdepositid` int(11) NOT NULL default '0',
  `cctransactionid` int(11) NOT NULL default '0',
  `checkid` varchar(20) default NULL,
  `bankstatement_enddate` date default NULL,
  `checkacctid` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  `returned` int(11) NOT NULL default '0',
  `bankfee_amount` decimal(19,4) NOT NULL default '0.0000',
  `bankfee_glid` int(11) NOT NULL default '0',
  `rnum` varchar(30) NOT NULL default '',
  `tendered` decimal(19,4) NOT NULL default '0.0000',
  `ccterminalid` int(11) NOT NULL default '0',
  `notes` text,
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `voucherid` (`voucherid`),
  KEY `rnum` (`rnum`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorder_deposit`
--

LOCK TABLES `arorder_deposit` WRITE;
/*!40000 ALTER TABLE `arorder_deposit` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorder_deposit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordercalculationscache`
--

DROP TABLE IF EXISTS `arordercalculationscache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordercalculationscache` (
  `arorderid` int(11) NOT NULL,
  `effective_status` tinyint(1) NOT NULL,
  `lastrentalbilldate_data` text NOT NULL,
  `lastbilled` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`arorderid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordercalculationscache`
--

LOCK TABLES `arordercalculationscache` WRITE;
/*!40000 ALTER TABLE `arordercalculationscache` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordercalculationscache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderdepositcredit`
--

DROP TABLE IF EXISTS `arorderdepositcredit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderdepositcredit` (
  `id` int(11) NOT NULL auto_increment,
  `orderdepositid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` tinyint(4) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `orderdepositid` (`orderdepositid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `cancel` (`cancel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderdepositcredit`
--

LOCK TABLES `arorderdepositcredit` WRITE;
/*!40000 ALTER TABLE `arorderdepositcredit` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderdepositcredit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderdetail`
--

DROP TABLE IF EXISTS `arorderdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderdetail` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `qtyorder` decimal(18,6) NOT NULL default '0.000000',
  `qtyship` decimal(18,6) NOT NULL default '0.000000',
  `qtybill` decimal(18,6) NOT NULL default '0.000000',
  `glaccountid` int(11) NOT NULL default '0',
  `taxflag` int(11) NOT NULL default '0',
  `costeach` decimal(19,6) NOT NULL default '0.000000',
  `priceach` decimal(19,6) NOT NULL default '0.000000',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `products_tax` decimal(7,4) NOT NULL default '0.0000',
  `description` varchar(255) default NULL,
  `saleunitperpriceunit` decimal(19,6) NOT NULL default '1.000000',
  `costglaccountid` int(11) NOT NULL default '0',
  `purchaseunitid` int(11) NOT NULL default '0',
  `priceunitid` int(11) NOT NULL default '0',
  `main_arorderdetailid` int(11) NOT NULL default '0',
  `itemoptiongroupid` int(11) NOT NULL default '0',
  `itemoptionid` int(11) NOT NULL default '0',
  `multioption` int(2) NOT NULL default '0',
  `optionindependent` int(2) NOT NULL default '0',
  `inventorylocationid` int(11) NOT NULL default '0',
  `taxflag2` int(2) NOT NULL default '0',
  `taxflag3` int(2) NOT NULL default '0',
  `taxflagid` int(11) NOT NULL default '0',
  `taxflag2id` int(11) NOT NULL default '0',
  `taxflag3id` int(11) NOT NULL default '0',
  `itemweight` decimal(12,6) NOT NULL default '0.000000',
  `qtyorderprice` double NOT NULL default '0',
  `pricelevelid` int(11) NOT NULL default '0',
  `price_override` int(5) NOT NULL default '0',
  `extended_price` decimal(19,5) NOT NULL default '0.00000',
  `worktypeid` int(11) NOT NULL default '0',
  `worksubtypeid` int(11) NOT NULL default '0',
  `vendorid` int(11) NOT NULL default '0',
  `discount_percent` decimal(6,2) NOT NULL default '0.00',
  `orig_priceach` decimal(19,6) NOT NULL default '0.000000',
  `linedate` date default NULL,
  `taxclassid` int(11) NOT NULL default '0',
  `transfrominventorylocationid` int(11) NOT NULL default '0',
  `linetype` tinyint(1) NOT NULL default '0',
  `period` char(1) NOT NULL default '',
  `numperiods` decimal(19,6) NOT NULL default '1.000000',
  `partialtaxexemptionid` int(11) NOT NULL default '0',
  `producttypetaxid` int(11) NOT NULL default '0',
  `createpowhenconvertedfrombid` tinyint(1) NOT NULL default '0',
  `ignoretaxexempt` tinyint(1) NOT NULL default '0',
  `itempricespecialdetailid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `itemid` (`itemid`),
  KEY `linenumber` (`linenumber`),
  KEY `qtyorder` (`qtyorder`),
  KEY `qtyship` (`qtyship`),
  KEY `qtybill` (`qtybill`),
  KEY `glaccountid` (`glaccountid`),
  KEY `main_arorderdetailid` (`main_arorderdetailid`),
  KEY `itemoptionid` (`itemoptionid`),
  KEY `taxclassid` (`taxclassid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderdetail`
--

LOCK TABLES `arorderdetail` WRITE;
/*!40000 ALTER TABLE `arorderdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderdetailforeignnotes`
--

DROP TABLE IF EXISTS `arorderdetailforeignnotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderdetailforeignnotes` (
  `id` int(11) NOT NULL auto_increment,
  `arorderdetailid` int(11) NOT NULL default '0',
  `tablename` varchar(64) NOT NULL default '',
  `recordid` int(11) NOT NULL default '0',
  `notes` text NOT NULL,
  `cancel` tinyint(1) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime default NULL,
  `lastchangeuserid` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `foreignref` (`tablename`,`recordid`),
  KEY `detailid` (`arorderdetailid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderdetailforeignnotes`
--

LOCK TABLES `arorderdetailforeignnotes` WRITE;
/*!40000 ALTER TABLE `arorderdetailforeignnotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderdetailforeignnotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderdetailnotes`
--

DROP TABLE IF EXISTS `arorderdetailnotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderdetailnotes` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `note` text,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `private` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `linenumber` (`linenumber`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderdetailnotes`
--

LOCK TABLES `arorderdetailnotes` WRITE;
/*!40000 ALTER TABLE `arorderdetailnotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderdetailnotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderdetailseq`
--

DROP TABLE IF EXISTS `arorderdetailseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderdetailseq` (
  `id` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderdetailseq`
--

LOCK TABLES `arorderdetailseq` WRITE;
/*!40000 ALTER TABLE `arorderdetailseq` DISABLE KEYS */;
INSERT INTO `arorderdetailseq` VALUES (0);
/*!40000 ALTER TABLE `arorderdetailseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderdetailstdnotes`
--

DROP TABLE IF EXISTS `arorderdetailstdnotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderdetailstdnotes` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) default NULL,
  `note` text,
  `sortorder` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` date default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `sortorder` (`sortorder`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderdetailstdnotes`
--

LOCK TABLES `arorderdetailstdnotes` WRITE;
/*!40000 ALTER TABLE `arorderdetailstdnotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderdetailstdnotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordermarginlog`
--

DROP TABLE IF EXISTS `arordermarginlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordermarginlog` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `totalprice` decimal(19,6) NOT NULL default '0.000000',
  `totalcost` decimal(19,6) NOT NULL default '0.000000',
  `margin` decimal(6,2) NOT NULL default '0.00',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `minmargin` decimal(6,2) NOT NULL default '0.00',
  `maxmargin` decimal(6,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordermarginlog`
--

LOCK TABLES `arordermarginlog` WRITE;
/*!40000 ALTER TABLE `arordermarginlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordermarginlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordernotes`
--

DROP TABLE IF EXISTS `arordernotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordernotes` (
  `orderid` int(11) NOT NULL default '0',
  `note` text,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `source_noteid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `internal` int(5) NOT NULL default '0',
  `id` int(11) NOT NULL auto_increment,
  UNIQUE KEY `id` (`id`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordernotes`
--

LOCK TABLES `arordernotes` WRITE;
/*!40000 ALTER TABLE `arordernotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordernotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderrentalpickup`
--

DROP TABLE IF EXISTS `arorderrentalpickup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderrentalpickup` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `assigneduserid` int(11) NOT NULL default '0',
  `assigneddate` date default NULL,
  `pickedupdate` date default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '0' COMMENT '0=open, 1=assigned, 2=picked up, 3=returned/received in warehouse/complete',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime default NULL,
  `lastchangeuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `order` (`orderid`),
  KEY `status` (`status`,`cancel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderrentalpickup`
--

LOCK TABLES `arorderrentalpickup` WRITE;
/*!40000 ALTER TABLE `arorderrentalpickup` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderrentalpickup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderrentalpickupdetail`
--

DROP TABLE IF EXISTS `arorderrentalpickupdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderrentalpickupdetail` (
  `id` int(11) NOT NULL auto_increment,
  `arorderrentalpickupid` int(11) NOT NULL default '0',
  `ordershipdetailid` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `quantity` decimal(18,6) NOT NULL default '0.000000',
  `status` tinyint(1) NOT NULL default '0' COMMENT '0=open, 1=assigned, 2=picked up, 3=returned/received in warehouse/complete',
  `arinvoiceid` int(11) NOT NULL default '0',
  `offrentdate` date default NULL,
  `inventorylocationid` int(11) NOT NULL default '0',
  `linenotes` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `parent` (`arorderrentalpickupid`),
  KEY `shipment` (`ordershipdetailid`),
  KEY `arinvoiceid` (`arinvoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderrentalpickupdetail`
--

LOCK TABLES `arorderrentalpickupdetail` WRITE;
/*!40000 ALTER TABLE `arorderrentalpickupdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderrentalpickupdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderseq`
--

DROP TABLE IF EXISTS `arorderseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderseq` (
  `id` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderseq`
--

LOCK TABLES `arorderseq` WRITE;
/*!40000 ALTER TABLE `arorderseq` DISABLE KEYS */;
INSERT INTO `arorderseq` VALUES (238);
/*!40000 ALTER TABLE `arorderseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordership`
--

DROP TABLE IF EXISTS `arordership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordership` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `carrierserviceid` int(11) NOT NULL default '0',
  `shipdate` datetime default NULL,
  `locationid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `shiptoid` int(11) NOT NULL default '0',
  `voucherid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `shipdate` (`shipdate`),
  KEY `locationid` (`locationid`),
  KEY `shiptoid` (`shiptoid`),
  KEY `cancel` (`cancel`),
  KEY `carrierserviceid` (`carrierserviceid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `activeorder` (`cancel`,`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordership`
--

LOCK TABLES `arordership` WRITE;
/*!40000 ALTER TABLE `arordership` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordershipdetail`
--

DROP TABLE IF EXISTS `arordershipdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordershipdetail` (
  `id` int(11) NOT NULL auto_increment,
  `ordershipid` int(11) NOT NULL default '0',
  `orderdetailid` int(11) NOT NULL default '0',
  `shipqty` decimal(18,6) NOT NULL default '0.000000',
  `adjustmentqty` decimal(18,6) NOT NULL default '0.000000',
  `adjustmentqtysansonhand` decimal(18,6) NOT NULL default '0.000000',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `inventoryglacctid` int(11) NOT NULL default '0',
  `costeach` decimal(19,6) NOT NULL default '0.000000',
  `lastrentalbilldate` date default NULL,
  `minrentalbilldate` date default NULL,
  `rentalreturnqty` decimal(18,6) NOT NULL default '0.000000',
  `rentalreturncomplete` tinyint(1) NOT NULL default '0',
  `rentalreturndate` date default NULL,
  `rentalvalue` decimal(19,6) NOT NULL default '0.000000',
  `rentalisoffrent` tinyint(1) NOT NULL default '0',
  `rentaloffrentqty` decimal(19,6) NOT NULL default '0.000000',
  `rentalissold` tinyint(1) NOT NULL default '0',
  `rentalsolddate` date default NULL,
  `rentalsoldqty` decimal(19,6) NOT NULL default '0.000000',
  `rentaloffrentdate` date default NULL,
  PRIMARY KEY  (`id`),
  KEY `orderdetailid` (`orderdetailid`),
  KEY `shipqty` (`shipqty`),
  KEY `ordershipid` (`ordershipid`),
  KEY `entrydate` (`entrydate`),
  KEY `rentalreturncomplete` (`rentalreturncomplete`),
  KEY `lastrentalbilldate` (`lastrentalbilldate`),
  KEY `rentalreturndate` (`rentalreturndate`),
  KEY `rentalissold` (`rentalissold`),
  KEY `rentalsolddate` (`rentalsolddate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordershipdetail`
--

LOCK TABLES `arordershipdetail` WRITE;
/*!40000 ALTER TABLE `arordershipdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordershipdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordershippackage`
--

DROP TABLE IF EXISTS `arordershippackage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordershippackage` (
  `id` int(11) NOT NULL auto_increment,
  `ordershipid` int(11) NOT NULL default '0',
  `weight` double NOT NULL default '0',
  `cost` decimal(19,4) NOT NULL default '0.0000',
  `tracknumber` char(50) NOT NULL default '',
  `arinvoiceid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `ordershipid` (`ordershipid`),
  KEY `tracknumber` (`tracknumber`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordershippackage`
--

LOCK TABLES `arordershippackage` WRITE;
/*!40000 ALTER TABLE `arordershippackage` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordershippackage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordertax`
--

DROP TABLE IF EXISTS `arordertax`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordertax` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `taxrateid` int(11) NOT NULL default '0',
  `partialtaxrateid` int(11) NOT NULL default '0',
  `tax` decimal(19,4) NOT NULL default '0.0000',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `taxrate` decimal(12,5) NOT NULL default '0.00000',
  `taxcap` decimal(19,4) NOT NULL default '0.0000',
  `taxexemptid` int(11) NOT NULL default '0',
  `taxexemptportion` decimal(12,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `taxrateid` (`taxrateid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordertax`
--

LOCK TABLES `arordertax` WRITE;
/*!40000 ALTER TABLE `arordertax` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordertax` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arordertrack`
--

DROP TABLE IF EXISTS `arordertrack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arordertrack` (
  `id` int(11) NOT NULL auto_increment,
  `orderid` int(11) NOT NULL default '0',
  `action` int(11) NOT NULL default '0',
  `trackdate` datetime default NULL,
  `trackuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `trackuserid` (`trackuserid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arordertrack`
--

LOCK TABLES `arordertrack` WRITE;
/*!40000 ALTER TABLE `arordertrack` DISABLE KEYS */;
/*!40000 ALTER TABLE `arordertrack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arorderunsaved`
--

DROP TABLE IF EXISTS `arorderunsaved`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arorderunsaved` (
  `id` int(11) NOT NULL auto_increment,
  `genuserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `snapshot` mediumtext NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user` (`genuserid`,`gencompanyid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arorderunsaved`
--

LOCK TABLES `arorderunsaved` WRITE;
/*!40000 ALTER TABLE `arorderunsaved` DISABLE KEYS */;
/*!40000 ALTER TABLE `arorderunsaved` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arserviceorder_prepaid_time`
--

DROP TABLE IF EXISTS `arserviceorder_prepaid_time`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arserviceorder_prepaid_time` (
  `id` int(11) NOT NULL auto_increment,
  `hours` decimal(12,2) NOT NULL default '0.00',
  `hours_used` decimal(12,2) NOT NULL default '0.00',
  `complete` int(5) NOT NULL default '0',
  `worktypeid` int(11) NOT NULL default '0',
  `orderid` int(11) NOT NULL default '0',
  `rate_per_hour` decimal(16,5) NOT NULL default '0.00000',
  `total_price` decimal(16,5) NOT NULL default '0.00000',
  `entrydate` date default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `workclassid` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `worktypeid` (`worktypeid`),
  KEY `cancel` (`cancel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arserviceorder_prepaid_time`
--

LOCK TABLES `arserviceorder_prepaid_time` WRITE;
/*!40000 ALTER TABLE `arserviceorder_prepaid_time` DISABLE KEYS */;
/*!40000 ALTER TABLE `arserviceorder_prepaid_time` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arserviceorder_time`
--

DROP TABLE IF EXISTS `arserviceorder_time`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arserviceorder_time` (
  `id` int(11) NOT NULL auto_increment,
  `employeeid` int(11) NOT NULL default '0',
  `vendorid` int(11) NOT NULL default '0',
  `ordered` int(11) NOT NULL default '0',
  `techname` varchar(50) default NULL,
  `hours` decimal(10,2) NOT NULL default '0.00',
  `startdatetime` datetime default NULL,
  `enddatetime` datetime default NULL,
  `rate` decimal(10,4) NOT NULL default '0.0000',
  `totalprice` decimal(10,4) NOT NULL default '0.0000',
  `totalcost` decimal(10,4) NOT NULL default '0.0000',
  `worktypeid` int(11) NOT NULL default '0',
  `worksubtypeid` int(11) NOT NULL default '0',
  `workclassid` int(11) NOT NULL default '0',
  `notes` text,
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` date default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `internal_comment` text,
  `costrate` decimal(10,4) NOT NULL default '0.0000',
  `status` int(3) NOT NULL default '0',
  `orderid` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  PRIMARY KEY  (`id`),
  KEY `employeeid` (`employeeid`),
  KEY `worktypeid` (`worktypeid`),
  KEY `vendorid` (`vendorid`),
  KEY `ordered` (`ordered`),
  KEY `entrydate` (`entrydate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arserviceorder_time`
--

LOCK TABLES `arserviceorder_time` WRITE;
/*!40000 ALTER TABLE `arserviceorder_time` DISABLE KEYS */;
/*!40000 ALTER TABLE `arserviceorder_time` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arstatusoptions`
--

DROP TABLE IF EXISTS `arstatusoptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `arstatusoptions` (
  `id` int(11) NOT NULL auto_increment,
  `description` varchar(50) default NULL,
  `sortorder` int(5) NOT NULL default '1',
  `complete` tinyint(1) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `sortorder` (`sortorder`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arstatusoptions`
--

LOCK TABLES `arstatusoptions` WRITE;
/*!40000 ALTER TABLE `arstatusoptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `arstatusoptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorizenetaccounts`
--

DROP TABLE IF EXISTS `authorizenetaccounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authorizenetaccounts` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `ccaccountid` int(11) default '0',
  `customerrefid` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorizenetaccounts`
--

LOCK TABLES `authorizenetaccounts` WRITE;
/*!40000 ALTER TABLE `authorizenetaccounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `authorizenetaccounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autobilllog`
--

DROP TABLE IF EXISTS `autobilllog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autobilllog` (
  `id` int(11) NOT NULL auto_increment,
  `autobilldate` datetime default NULL,
  `customerid` int(11) NOT NULL default '0',
  `leaseid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `arinvoicepaymentdetailid` int(11) NOT NULL default '0',
  `cctransactionid` int(11) NOT NULL default '0',
  `paymentplanid` int(11) NOT NULL default '0',
  `achtransactionid` int(11) NOT NULL default '0',
  `customerbankid` int(11) NOT NULL default '0',
  `cardused` varchar(50) default NULL,
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `successful` int(11) NOT NULL default '0',
  `message` varchar(255) default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `leaseid` (`leaseid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `arinvoicepaymentdetailid` (`arinvoicepaymentdetailid`),
  KEY `cctransactionid` (`cctransactionid`),
  KEY `paymentplanid` (`paymentplanid`),
  KEY `successful` (`successful`),
  KEY `autobilldate` (`autobilldate`),
  KEY `achtransactionid` (`achtransactionid`),
  KEY `customerbankid` (`customerbankid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autobilllog`
--

LOCK TABLES `autobilllog` WRITE;
/*!40000 ALTER TABLE `autobilllog` DISABLE KEYS */;
/*!40000 ALTER TABLE `autobilllog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `b2b_access_table`
--

DROP TABLE IF EXISTS `b2b_access_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `b2b_access_table` (
  `id` int(11) NOT NULL auto_increment,
  `description` varchar(255) default NULL,
  `whocan` int(11) NOT NULL default '0',
  `pagelist` text,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `b2b_access_table`
--

LOCK TABLES `b2b_access_table` WRITE;
/*!40000 ALTER TABLE `b2b_access_table` DISABLE KEYS */;
INSERT INTO `b2b_access_table` VALUES (1,'System Adminstrator',1,'*'),(2,'No Access',1,''),(3,'Order Entry - No Item History',1,'indexcust.php,arordadd.php,arordupd.php,arserviceordadd.php,arserviceordupd.php,shipped_detail.php,arordconfirmation.php,arserviceordtickfpdf.php,client_customer.php,arinvoicereppay.php,pay_history'),(4,'Payables',1,'indexcust.php,arinvoicesum.php,arinvoicereppay.php,arinvoiceviewfpdf.php,client_customer.php,pay_history'),(5,'Order Entry - All',1,'indexcust.php,arordadd.php,arordupd.php,arserviceordadd.php,arserviceordupd.php,shipped_detail.php,arordconfirmation.php,arserviceordtickfpdf.php,arordercustitemlst.php,client_customer.php,arinvoicereppay.php,pay_history'),(6,'All Except Users',1,'indexcust.php,arordadd.php,arordupd.php,arserviceordadd.php,arserviceordupd.php,shipped_detail.php,arordconfirmation.php,arserviceordtickfpdf.php,arordercustitemlst.php,arinvoicesum.php,arinvoicereppay.php,arinvoiceviewfpdf.php,arinvoicepay.php,client_customer.php,pay_history'),(7,'Rep',2,'indexvend.php,b2b_commissionreport.php,apvendorbillsrpt.php,rep_orders.php,av_airports_resrpt.php,av_edit_reservation.php,editvendor.php,client_customer.php,pay_history'),(8,'System Administrator',2,'*'),(9,'Payment History',1,'arinvoicereppay.php,client_customer.php,client_customer.php'),(10,'Order Entry - No Item / Payment History',1,'indexcust.php,arordadd.php,arordupd.php,arserviceordadd.php,arserviceordupd.php,shipped_detail.php,arordconfirmation.php,arserviceordtickfpdf.php,client_customer.php,arinvoicereppay.php');
/*!40000 ALTER TABLE `b2b_access_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `b2b_user_access_table`
--

DROP TABLE IF EXISTS `b2b_user_access_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `b2b_user_access_table` (
  `id` int(11) NOT NULL auto_increment,
  `b2b_access_tableid` int(11) NOT NULL default '0',
  `b2buserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `b2b_access_tableid` (`b2b_access_tableid`),
  KEY `b2buserid` (`b2buserid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `b2b_user_access_table`
--

LOCK TABLES `b2b_user_access_table` WRITE;
/*!40000 ALTER TABLE `b2b_user_access_table` DISABLE KEYS */;
/*!40000 ALTER TABLE `b2b_user_access_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `b2bcart`
--

DROP TABLE IF EXISTS `b2bcart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `b2bcart` (
  `id` int(11) NOT NULL auto_increment,
  `b2buserid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `itemid` int(11) NOT NULL default '0',
  `qty` decimal(18,6) NOT NULL default '0.000000',
  PRIMARY KEY  (`id`),
  KEY `b2buserid` (`b2buserid`),
  KEY `customerid` (`customerid`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `itemid` (`itemid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `b2bcart`
--

LOCK TABLES `b2bcart` WRITE;
/*!40000 ALTER TABLE `b2bcart` DISABLE KEYS */;
/*!40000 ALTER TABLE `b2bcart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `b2bcompany`
--

DROP TABLE IF EXISTS `b2bcompany`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `b2bcompany` (
  `companyid` int(11) NOT NULL,
  `customheaderhtml` text,
  `remoteregistration_key` varchar(32) default NULL,
  `remoteregistration_value` varchar(32) default NULL,
  `remoteregistration_usertype` int(11) default '1',
  `remoteregistration_useraccess` int(11) default '6',
  `remoteregistration_customfields` tinytext,
  `remoteregistration_emailsubject` tinytext,
  `remoteregistration_emailbody` text,
  `remoteregistration_failmessage` text,
  PRIMARY KEY  (`companyid`),
  UNIQUE KEY `remoteregistration_key_UNIQUE` (`remoteregistration_key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Company options for new b2b features - PRIMARY KEY companyid';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `b2bcompany`
--

LOCK TABLES `b2bcompany` WRITE;
/*!40000 ALTER TABLE `b2bcompany` DISABLE KEYS */;
/*!40000 ALTER TABLE `b2bcompany` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `b2buser`
--

DROP TABLE IF EXISTS `b2buser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `b2buser` (
  `id` int(11) NOT NULL auto_increment,
  `firstname` varchar(100) default NULL,
  `lastname` varchar(100) default NULL,
  `loginname` varchar(100) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `usertype` int(11) NOT NULL default '0',
  `referenceid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `email` varchar(255) default NULL,
  `resetkey` varchar(255) NOT NULL default '',
  `temppw` int(11) NOT NULL default '0',
  `tempfrontendpw` varchar(64) NOT NULL default '',
  `wpemailconfirmed` varchar(255) NOT NULL default '',
  `wpemailunconfirmed` varchar(255) NOT NULL default '',
  `wpemailhashverifykey` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `usertype` (`usertype`),
  KEY `cancel` (`cancel`),
  KEY `referenceid` (`referenceid`),
  KEY `password` (`password`),
  KEY `loginname` (`loginname`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `b2buser`
--

LOCK TABLES `b2buser` WRITE;
/*!40000 ALTER TABLE `b2buser` DISABLE KEYS */;
/*!40000 ALTER TABLE `b2buser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bankaccount`
--

DROP TABLE IF EXISTS `bankaccount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankaccount` (
  `id` int(11) NOT NULL auto_increment,
  `premployeeid` int(11) NOT NULL default '0',
  `accounttype` int(2) NOT NULL default '0',
  `routing` varchar(9) NOT NULL default '',
  `accountnumber` varchar(17) NOT NULL default '',
  `prenote_ok` int(2) NOT NULL default '0',
  `prenote_achfiledetailid` int(11) NOT NULL default '0',
  `contactname` varchar(100) NOT NULL default '',
  `bankname` varchar(100) NOT NULL default '',
  `address` varchar(100) NOT NULL default '',
  `city` varchar(100) NOT NULL default '',
  `state` varchar(100) NOT NULL default '',
  `zip` varchar(15) NOT NULL default '',
  `phone` varchar(20) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `prtype` int(5) NOT NULL default '0',
  `recordid` int(11) NOT NULL default '0',
  `show_employeename` int(5) NOT NULL default '0',
  `show_ss` int(5) NOT NULL default '0',
  `show_dates` int(5) NOT NULL default '0',
  `show_employer` int(5) NOT NULL default '0',
  `include_contribution` int(5) NOT NULL default '0',
  `summary_deposit` int(5) NOT NULL default '0',
  `show_other` varchar(255) default NULL,
  `dd_or_check` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `canceluserid` (`canceluserid`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `entryuserid` (`entryuserid`),
  KEY `lastchangeuserid` (`lastchangeuserid`),
  KEY `prenote_achfiledetailid` (`prenote_achfiledetailid`),
  KEY `premployeeid` (`premployeeid`),
  KEY `prtype` (`prtype`),
  KEY `recordid` (`recordid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bankaccount`
--

LOCK TABLES `bankaccount` WRITE;
/*!40000 ALTER TABLE `bankaccount` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankaccount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bankdeposit`
--

DROP TABLE IF EXISTS `bankdeposit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankdeposit` (
  `id` int(11) NOT NULL auto_increment,
  `cashtotal` decimal(19,4) NOT NULL default '0.0000',
  `checktotal` decimal(19,4) NOT NULL default '0.0000',
  `othertotal` decimal(19,4) NOT NULL default '0.0000',
  `cashout` decimal(19,4) NOT NULL default '0.0000',
  `depositdate` date default NULL,
  `checkaccountid` int(11) NOT NULL default '0',
  `onbankstatement` int(2) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `bankstatement_enddate` date default NULL,
  `voucherid` int(11) NOT NULL default '0',
  `depositdescription` varchar(255) NOT NULL default '',
  `currency` varchar(10) NOT NULL default 'USD',
  `ccdeposit` tinyint(4) NOT NULL default '0',
  `ardailycloseid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `depositdate` (`depositdate`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `checkaccountid` (`checkaccountid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bankdeposit`
--

LOCK TABLES `bankdeposit` WRITE;
/*!40000 ALTER TABLE `bankdeposit` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankdeposit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bankdepositdetail`
--

DROP TABLE IF EXISTS `bankdepositdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankdepositdetail` (
  `id` int(11) NOT NULL auto_increment,
  `bankdepositid` int(11) NOT NULL default '0',
  `referenceid` int(11) NOT NULL default '0',
  `wherefrom` int(5) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `deposit_type` int(5) NOT NULL default '0',
  `cancel` int(3) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `deposit_type` (`deposit_type`),
  KEY `referenceid` (`referenceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bankdepositdetail`
--

LOCK TABLES `bankdepositdetail` WRITE;
/*!40000 ALTER TABLE `bankdepositdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankdepositdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bankimport`
--

DROP TABLE IF EXISTS `bankimport`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankimport` (
  `id` int(11) NOT NULL auto_increment,
  `checkaccountid` int(11) default '0',
  `currency` varchar(10) NOT NULL default '',
  `bankid` varchar(10) NOT NULL default '',
  `acctid` varchar(25) NOT NULL default '',
  `startdate` date NOT NULL default '0000-00-00',
  `enddate` date NOT NULL default '0000-00-00',
  `balanceamount` decimal(19,6) NOT NULL default '0.000000',
  `balancedate` date NOT NULL default '0000-00-00',
  `statementdate` date NOT NULL default '0000-00-00',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `companyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `checkaccountid` (`checkaccountid`),
  KEY `bankid` (`bankid`),
  KEY `acctid` (`acctid`),
  KEY `balanceamount` (`balanceamount`),
  KEY `balancedate` (`balancedate`),
  KEY `startdate` (`startdate`),
  KEY `enddate` (`enddate`),
  KEY `companyid` (`companyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bankimport`
--

LOCK TABLES `bankimport` WRITE;
/*!40000 ALTER TABLE `bankimport` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankimport` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bankimportdetail`
--

DROP TABLE IF EXISTS `bankimportdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankimportdetail` (
  `id` int(11) NOT NULL auto_increment,
  `bankimportid` int(11) NOT NULL default '0',
  `bankid` varchar(10) NOT NULL default '',
  `acctid` varchar(25) NOT NULL default '',
  `fitid` varchar(50) NOT NULL default '',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `transtype` varchar(20) NOT NULL default '',
  `checknum` varchar(20) NOT NULL default '',
  `description` varchar(100) NOT NULL default '',
  `memo` varchar(255) NOT NULL default '',
  `dateposted` date NOT NULL default '0000-00-00',
  `tablename` varchar(100) NOT NULL default '',
  `tableid` int(11) NOT NULL default '0',
  `notes` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `bankimportid` (`bankimportid`),
  KEY `bankid` (`bankid`),
  KEY `acctid` (`acctid`),
  KEY `fitid` (`fitid`),
  KEY `dateposted` (`dateposted`),
  KEY `transtype` (`transtype`),
  KEY `relatedtable` (`tablename`,`tableid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bankimportdetail`
--

LOCK TABLES `bankimportdetail` WRITE;
/*!40000 ALTER TABLE `bankimportdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankimportdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bankrec`
--

DROP TABLE IF EXISTS `bankrec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankrec` (
  `id` int(11) NOT NULL auto_increment,
  `bankendbal` decimal(19,6) NOT NULL default '0.000000',
  `enddate` date default NULL,
  `gencompanyid` int(11) NOT NULL default '0',
  `bankaccountid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `createuserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `servicecharges` decimal(19,6) NOT NULL default '0.000000',
  `servicechargesvoucherid` int(11) NOT NULL default '0',
  `interestearned` decimal(19,6) NOT NULL default '0.000000',
  `interestearnedvoucherid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `bankaccountid` (`bankaccountid`),
  KEY `enddate` (`enddate`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bankrec`
--

LOCK TABLES `bankrec` WRITE;
/*!40000 ALTER TABLE `bankrec` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankrec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bankstmtgltrans`
--

DROP TABLE IF EXISTS `bankstmtgltrans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bankstmtgltrans` (
  `id` int(11) NOT NULL auto_increment,
  `gltransactionid` int(11) default '0',
  `bankstmtdate` date default '0000-00-00',
  `checkaccountid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `gltransactionid` (`gltransactionid`),
  KEY `bankstmtdate` (`bankstmtdate`),
  KEY `bcg` (`bankstmtdate`,`checkaccountid`,`gltransactionid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bankstmtgltrans`
--

LOCK TABLES `bankstmtgltrans` WRITE;
/*!40000 ALTER TABLE `bankstmtgltrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankstmtgltrans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `barcodelabel`
--

DROP TABLE IF EXISTS `barcodelabel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodelabel` (
  `id` int(11) NOT NULL auto_increment,
  `labelname` varchar(100) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `labelsize_width` int(11) NOT NULL default '0',
  `labelsize_height` int(11) NOT NULL default '0',
  `barcode_left` int(11) NOT NULL default '0',
  `barcode_top` int(11) NOT NULL default '0',
  `itemdescription_yesno` int(5) NOT NULL default '0',
  `itemdescription_left` int(11) NOT NULL default '0',
  `itemdescription_top` int(11) NOT NULL default '0',
  `fixedtext` varchar(100) NOT NULL default '',
  `fixedtext_left` int(11) NOT NULL default '0',
  `fixedtext_top` int(11) NOT NULL default '0',
  `tablename` varchar(50) NOT NULL default 'item',
  `fieldname` varchar(100) NOT NULL default 'itemcode',
  `textsize` int(5) NOT NULL default '8',
  `cancel` int(5) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `itemcode_yesno` int(5) NOT NULL default '0',
  `itemcode_left` int(11) NOT NULL default '0',
  `itemcode_top` int(11) NOT NULL default '0',
  `barcodetype` varchar(10) NOT NULL default ' ',
  `oneperitem` int(5) NOT NULL default '0',
  `shelf_yesno` int(5) NOT NULL default '0',
  `shelf_top` int(11) NOT NULL default '0',
  `shelf_left` int(11) NOT NULL default '0',
  `ordernumber_yesno` tinyint(4) NOT NULL default '0',
  `ordernumber_top` int(11) NOT NULL default '0',
  `ordernumber_left` int(11) NOT NULL default '0',
  `quantity_yesno` tinyint(4) NOT NULL default '0',
  `quantity_top` int(11) NOT NULL default '0',
  `quantity_left` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `cancel` (`cancel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `barcodelabel`
--

LOCK TABLES `barcodelabel` WRITE;
/*!40000 ALTER TABLE `barcodelabel` DISABLE KEYS */;
/*!40000 ALTER TABLE `barcodelabel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `barcodelabel_cf`
--

DROP TABLE IF EXISTS `barcodelabel_cf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodelabel_cf` (
  `id` int(11) NOT NULL auto_increment,
  `barcodelabelid` int(11) NOT NULL default '0',
  `flexfieldid` int(11) NOT NULL default '0',
  `flexfield_yesno` int(5) NOT NULL default '0',
  `flexfield_left` int(11) NOT NULL default '0',
  `flexfield_top` int(11) NOT NULL default '0',
  `flexfielddescription_yesno` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `barcodelabelid` (`barcodelabelid`),
  KEY `flexfieldid` (`flexfieldid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `barcodelabel_cf`
--

LOCK TABLES `barcodelabel_cf` WRITE;
/*!40000 ALTER TABLE `barcodelabel_cf` DISABLE KEYS */;
/*!40000 ALTER TABLE `barcodelabel_cf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `barcodelabel_price`
--

DROP TABLE IF EXISTS `barcodelabel_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodelabel_price` (
  `id` int(11) NOT NULL auto_increment,
  `barcodelabelid` int(11) NOT NULL default '0',
  `pricelevel` int(11) NOT NULL default '0',
  `price_yesno` int(5) NOT NULL default '0',
  `price_left` int(11) NOT NULL default '0',
  `price_top` int(11) NOT NULL default '0',
  `priceleveldescription_yesno` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `barcodelabelid` (`barcodelabelid`),
  KEY `pricelevel` (`pricelevel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `barcodelabel_price`
--

LOCK TABLES `barcodelabel_price` WRITE;
/*!40000 ALTER TABLE `barcodelabel_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `barcodelabel_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `batchimport`
--

DROP TABLE IF EXISTS `batchimport`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `batchimport` (
  `id` int(11) NOT NULL auto_increment,
  `batchtype` varchar(24) NOT NULL default '',
  `filename` varchar(100) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` tinyint(4) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `batchtype` (`batchtype`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `entrydate` (`entrydate`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `batchimport`
--

LOCK TABLES `batchimport` WRITE;
/*!40000 ALTER TABLE `batchimport` DISABLE KEYS */;
/*!40000 ALTER TABLE `batchimport` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `batchimportdetail`
--

DROP TABLE IF EXISTS `batchimportdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `batchimportdetail` (
  `id` int(11) NOT NULL auto_increment,
  `batchimportid` int(11) NOT NULL default '0',
  `tablename` varchar(100) NOT NULL default '',
  `tableid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `line` int(11) NOT NULL default '0',
  `message` varchar(255) NOT NULL default '',
  `error` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `batchimportid` (`batchimportid`),
  KEY `tablename` (`tablename`),
  KEY `tableid` (`tableid`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `error` (`error`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `batchimportdetail`
--

LOCK TABLES `batchimportdetail` WRITE;
/*!40000 ALTER TABLE `batchimportdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `batchimportdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `binshelflog`
--

DROP TABLE IF EXISTS `binshelflog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `binshelflog` (
  `id` int(11) NOT NULL auto_increment,
  `itemid` int(11) NOT NULL default '0',
  `inventorylocationid` int(11) NOT NULL default '0',
  `bin_shelf` varchar(50) NOT NULL default '',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `itemid` (`itemid`),
  KEY `inventorylocationid` (`inventorylocationid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `binshelflog`
--

LOCK TABLES `binshelflog` WRITE;
/*!40000 ALTER TABLE `binshelflog` DISABLE KEYS */;
/*!40000 ALTER TABLE `binshelflog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `building`
--

DROP TABLE IF EXISTS `building`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `building` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(20) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `address1` varchar(100) NOT NULL default '',
  `address2` varchar(100) NOT NULL default '',
  `city` varchar(50) NOT NULL default '',
  `state` varchar(20) NOT NULL default '',
  `zip` varchar(15) NOT NULL default '',
  `description` text NOT NULL,
  `managementfee` decimal(6,2) NOT NULL default '0.00',
  `latefee` decimal(19,6) NOT NULL default '0.000000',
  `transferfee` decimal(19,6) NOT NULL default '0.000000',
  `petrent` decimal(19,6) NOT NULL default '0.000000',
  `utilitiescharge` varchar(5) NOT NULL default '',
  `electricbasis` decimal(19,6) NOT NULL default '0.000000',
  `waterbasis` decimal(19,6) NOT NULL default '0.000000',
  `gasbasis` decimal(19,6) NOT NULL default '0.000000',
  `buildingtypeid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `areaid` int(11) NOT NULL default '0',
  `firstnotice` int(11) NOT NULL default '0',
  `secondnotice` int(11) NOT NULL default '0',
  `finalnotice` int(11) NOT NULL default '0',
  `asleasetemplateid` varchar(45) NOT NULL default '',
  `asleasetemplateid2` varchar(45) NOT NULL default '',
  `asleasetemplateid4` varchar(45) NOT NULL default '',
  `asleasedocname` varchar(100) NOT NULL default '',
  `docexpirationdays` int(11) NOT NULL default '0',
  `noaddressupdate` int(11) NOT NULL default '0',
  `asguarantordocname` varchar(100) NOT NULL default '',
  `asguarantortemplateid` varchar(45) NOT NULL default '',
  `aspetdocname` varchar(100) NOT NULL default '',
  `aspettemplateid` varchar(45) NOT NULL default '',
  `asterminationdocname` varchar(100) NOT NULL default '',
  `asterminationtemplateid` varchar(45) NOT NULL default '',
  `asterminationtemplateid2` varchar(45) NOT NULL default '',
  `firstinvoicemonths` int(11) NOT NULL default '0',
  `asamendmenttemplateid` varchar(45) NOT NULL default '',
  `asamendmentdocname` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `building`
--

LOCK TABLES `building` WRITE;
/*!40000 ALTER TABLE `building` DISABLE KEYS */;
/*!40000 ALTER TABLE `building` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildingagent`
--

DROP TABLE IF EXISTS `buildingagent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildingagent` (
  `id` int(11) NOT NULL auto_increment,
  `buildingid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `newleaseflat` decimal(19,6) NOT NULL default '0.000000',
  `newleasepercent` decimal(7,2) NOT NULL default '0.00',
  `renewleaseflat` decimal(19,6) NOT NULL default '0.000000',
  `renewleasepercent` decimal(7,2) NOT NULL default '0.00',
  `30daypercent` decimal(7,2) NOT NULL default '0.00',
  `60daypercent` decimal(7,2) NOT NULL default '0.00',
  `90daypercent` decimal(7,2) NOT NULL default '0.00',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `buildingid` (`buildingid`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildingagent`
--

LOCK TABLES `buildingagent` WRITE;
/*!40000 ALTER TABLE `buildingagent` DISABLE KEYS */;
/*!40000 ALTER TABLE `buildingagent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildingownership`
--

DROP TABLE IF EXISTS `buildingownership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildingownership` (
  `id` int(11) NOT NULL auto_increment,
  `buildingid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `percentownership` decimal(12,2) NOT NULL default '0.00',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildingownership`
--

LOCK TABLES `buildingownership` WRITE;
/*!40000 ALTER TABLE `buildingownership` DISABLE KEYS */;
/*!40000 ALTER TABLE `buildingownership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildingtype`
--

DROP TABLE IF EXISTS `buildingtype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildingtype` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `companyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildingtype`
--

LOCK TABLES `buildingtype` WRITE;
/*!40000 ALTER TABLE `buildingtype` DISABLE KEYS */;
/*!40000 ALTER TABLE `buildingtype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildordermaster`
--

DROP TABLE IF EXISTS `buildordermaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildordermaster` (
  `buildordermasterid` int(11) NOT NULL default '0',
  `final` int(2) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `orderqtyinitial` decimal(18,6) NOT NULL default '0.000000',
  `orderqtyfinal` decimal(18,6) NOT NULL default '0.000000',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `lastchangedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastchangeuserid` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `inventorylocationid` int(11) NOT NULL default '0',
  `status` int(5) NOT NULL default '0',
  `po_created` int(5) NOT NULL default '0',
  `note` varchar(255) default NULL,
  `autobuild` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`buildordermasterid`),
  KEY `note` (`note`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildordermaster`
--

LOCK TABLES `buildordermaster` WRITE;
/*!40000 ALTER TABLE `buildordermaster` DISABLE KEYS */;
/*!40000 ALTER TABLE `buildordermaster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildordermasterseq`
--

DROP TABLE IF EXISTS `buildordermasterseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildordermasterseq` (
  `id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildordermasterseq`
--

LOCK TABLES `buildordermasterseq` WRITE;
/*!40000 ALTER TABLE `buildordermasterseq` DISABLE KEYS */;
INSERT INTO `buildordermasterseq` VALUES (9);
/*!40000 ALTER TABLE `buildordermasterseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildordersub`
--

DROP TABLE IF EXISTS `buildordersub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildordersub` (
  `buildordersubid` int(11) NOT NULL default '0',
  `buildordermasterid` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `qtycommitted` decimal(18,6) NOT NULL default '0.000000',
  `qtyused` decimal(18,6) NOT NULL default '0.000000',
  `qtymaster` decimal(18,6) NOT NULL default '-1.000000',
  `final` int(2) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `cancel` int(2) NOT NULL default '0',
  `vendoritemid` int(11) NOT NULL default '0',
  `mfg` varchar(50) default NULL,
  `vordernumber` varchar(30) default NULL,
  `reference_notes` text,
  PRIMARY KEY  (`buildordersubid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildordersub`
--

LOCK TABLES `buildordersub` WRITE;
/*!40000 ALTER TABLE `buildordersub` DISABLE KEYS */;
/*!40000 ALTER TABLE `buildordersub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildordersubdetail`
--

DROP TABLE IF EXISTS `buildordersubdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildordersubdetail` (
  `id` int(11) NOT NULL auto_increment,
  `buildordersubid` int(11) NOT NULL default '0',
  `vendoritemid` int(11) NOT NULL default '0',
  `mfg` varchar(50) default NULL,
  `vordernumber` varchar(30) default NULL,
  `poqty` decimal(18,6) NOT NULL default '0.000000',
  `invpodetailid` int(11) NOT NULL default '0',
  `qty_commit` decimal(18,6) NOT NULL default '0.000000',
  `qtyused` decimal(18,6) NOT NULL default '0.000000',
  PRIMARY KEY  (`id`),
  KEY `vendoritemid` (`vendoritemid`),
  KEY `invpodetailid` (`invpodetailid`),
  KEY `buildordersubid` (`buildordersubid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildordersubdetail`
--

LOCK TABLES `buildordersubdetail` WRITE;
/*!40000 ALTER TABLE `buildordersubdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `buildordersubdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buildordersubseq`
--

DROP TABLE IF EXISTS `buildordersubseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `buildordersubseq` (
  `id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `buildordersubseq`
--

LOCK TABLES `buildordersubseq` WRITE;
/*!40000 ALTER TABLE `buildordersubseq` DISABLE KEYS */;
INSERT INTO `buildordersubseq` VALUES (0);
/*!40000 ALTER TABLE `buildordersubseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calcqty`
--

DROP TABLE IF EXISTS `calcqty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calcqty` (
  `id_calcqty` int(11) NOT NULL default '0',
  `description` varchar(100) NOT NULL default '',
  `formula` varchar(255) NOT NULL default '',
  `id_calctype` int(3) NOT NULL default '0',
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_user_create` int(11) NOT NULL default '0',
  `lastrevisedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_user_revise` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `cancel` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_calcqty`),
  UNIQUE KEY `id_calcqty` (`id_calcqty`),
  KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calcqty`
--

LOCK TABLES `calcqty` WRITE;
/*!40000 ALTER TABLE `calcqty` DISABLE KEYS */;
/*!40000 ALTER TABLE `calcqty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calcqtyseq`
--

DROP TABLE IF EXISTS `calcqtyseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calcqtyseq` (
  `id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calcqtyseq`
--

LOCK TABLES `calcqtyseq` WRITE;
/*!40000 ALTER TABLE `calcqtyseq` DISABLE KEYS */;
INSERT INTO `calcqtyseq` VALUES (0);
/*!40000 ALTER TABLE `calcqtyseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `notes` text NOT NULL,
  `eventdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `reminder` int(11) NOT NULL default '0',
  `tablename` varchar(100) NOT NULL default '',
  `tableid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `eventdate` (`eventdate`),
  KEY `tablename` (`tablename`),
  KEY `tableid` (`tableid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendarlistener`
--

DROP TABLE IF EXISTS `calendarlistener`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendarlistener` (
  `id` int(11) NOT NULL auto_increment,
  `calendarid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `nprightsgroupid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `calendarid` (`calendarid`),
  KEY `userid` (`userid`),
  KEY `nprightsgroupid` (`nprightsgroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendarlistener`
--

LOCK TABLES `calendarlistener` WRITE;
/*!40000 ALTER TABLE `calendarlistener` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendarlistener` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `camallocation`
--

DROP TABLE IF EXISTS `camallocation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `camallocation` (
  `id` int(11) NOT NULL auto_increment,
  `buildingid` int(11) NOT NULL default '0',
  `description` varchar(100) NOT NULL default '',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `glaccountid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `buildingid` (`buildingid`),
  KEY `glaccountid` (`glaccountid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `camallocation`
--

LOCK TABLES `camallocation` WRITE;
/*!40000 ALTER TABLE `camallocation` DISABLE KEYS */;
/*!40000 ALTER TABLE `camallocation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `carrier`
--

DROP TABLE IF EXISTS `carrier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `carrier` (
  `id` int(11) NOT NULL auto_increment,
  `customernumber` varchar(20) default NULL,
  `trackingurlbase` varchar(150) default NULL,
  `trackingurlvarname` varchar(30) default NULL,
  `description` varchar(100) NOT NULL default '',
  `vendorid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `carrier_upcharge` decimal(5,2) NOT NULL default '0.00',
  `carrier_upcharge_flat` decimal(19,6) NOT NULL default '0.000000',
  `sitelogin` varchar(40) NOT NULL default '',
  `sitepassword` varchar(50) NOT NULL default '',
  `accesskey` varchar(25) NOT NULL default '',
  `usenegotiatedrates` tinyint(4) NOT NULL default '0',
  `maxboxweight` decimal(6,2) NOT NULL default '0.00',
  `shiplength` decimal(7,2) NOT NULL default '0.00',
  `shipwidth` decimal(7,2) NOT NULL default '0.00',
  `shipheight` decimal(7,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `vendorid` (`vendorid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `carrier`
--

LOCK TABLES `carrier` WRITE;
/*!40000 ALTER TABLE `carrier` DISABLE KEYS */;
INSERT INTO `carrier` VALUES (1,NULL,NULL,NULL,'UPS',1,0,'0.00','0.000000','','','',0,'0.00','0.00','0.00','0.00'),(2,NULL,NULL,NULL,'UPS',2,0,'0.00','0.000000','','','',0,'0.00','0.00','0.00','0.00');
/*!40000 ALTER TABLE `carrier` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `carrierservice`
--

DROP TABLE IF EXISTS `carrierservice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `carrierservice` (
  `id` int(11) NOT NULL auto_increment,
  `carrierid` int(11) NOT NULL default '0',
  `description` varchar(50) NOT NULL default '',
  `abbreviation` varchar(50) default NULL,
  `code` varchar(10) NOT NULL default '',
  `saturdaydelivery` varchar(1) NOT NULL default 'N',
  `methodmarkupflat` decimal(12,4) NOT NULL default '0.0000',
  `allowonpointofsaleorders` tinyint(1) NOT NULL default '1',
  `sortorder` int(11) default NULL,
  `not_on_b2b` int(5) NOT NULL default '0',
  `onquote` int(5) NOT NULL default '0',
  `box1_charge` decimal(19,5) NOT NULL default '0.00000',
  `box_addl` decimal(19,5) NOT NULL default '0.00000',
  `require_shippernum` int(5) NOT NULL default '0',
  `showvalue` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `carrierid` (`carrierid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `carrierservice`
--

LOCK TABLES `carrierservice` WRITE;
/*!40000 ALTER TABLE `carrierservice` DISABLE KEYS */;
INSERT INTO `carrierservice` VALUES (1,1,'GROUND','GND','','N','0.0000',1,NULL,0,0,'0.00000','0.00000',0,0),(2,2,'GROUND','GND','','N','0.0000',1,NULL,0,0,'0.00000','0.00000',0,0);
/*!40000 ALTER TABLE `carrierservice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cashcount`
--

DROP TABLE IF EXISTS `cashcount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cashcount` (
  `id` int(11) NOT NULL auto_increment,
  `voucherid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `denomination` decimal(19,2) NOT NULL default '0.00',
  `qty` int(11) NOT NULL default '0',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `datereceived` date default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `voucherid` (`voucherid`),
  KEY `customerid` (`customerid`),
  KEY `datereceived` (`datereceived`),
  KEY `companyid` (`companyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cashcount`
--

LOCK TABLES `cashcount` WRITE;
/*!40000 ALTER TABLE `cashcount` DISABLE KEYS */;
/*!40000 ALTER TABLE `cashcount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cashpayment`
--

DROP TABLE IF EXISTS `cashpayment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cashpayment` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `entrydate` date default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `note` varchar(255) default NULL,
  `voucherid` int(11) NOT NULL default '0',
  `taxable_amount` decimal(19,4) NOT NULL default '0.0000',
  `exempt_amount` decimal(19,4) NOT NULL default '0.0000',
  `cost_amount` decimal(19,4) NOT NULL default '0.0000',
  `glaccountsalesid` int(11) NOT NULL default '0',
  `glaccountcostid` int(11) NOT NULL default '0',
  `exemptreasonid` int(11) NOT NULL default '0',
  `payment_type` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `bankdepositid` int(11) NOT NULL default '0',
  `sales_categoriesid` int(11) NOT NULL default '0',
  `bankstatement_enddate` date default NULL,
  `checkacctid` int(11) NOT NULL default '0',
  `checknumber` varchar(30) NOT NULL default '',
  `currency` varchar(10) NOT NULL default 'USD',
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  `bankfee_amount` decimal(19,4) NOT NULL default '0.0000',
  `bankfee_glid` int(11) NOT NULL default '0',
  `rnum` varchar(30) NOT NULL default '',
  `inventorylocationid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `jobid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `voucherid` (`voucherid`),
  KEY `cancel` (`cancel`),
  KEY `entrydate` (`entrydate`),
  KEY `payment_type` (`payment_type`),
  KEY `sales_categoriesid` (`sales_categoriesid`),
  KEY `rnum` (`rnum`),
  KEY `inventorylocationid` (`inventorylocationid`),
  KEY `gltr_costcodeid` (`costcodeid`),
  KEY `glcategoryid` (`glcategoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cashpayment`
--

LOCK TABLES `cashpayment` WRITE;
/*!40000 ALTER TABLE `cashpayment` DISABLE KEYS */;
/*!40000 ALTER TABLE `cashpayment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cashpaymenttax`
--

DROP TABLE IF EXISTS `cashpaymenttax`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cashpaymenttax` (
  `id` int(11) NOT NULL auto_increment,
  `cashpaymentid` int(11) NOT NULL default '0',
  `taxid` int(11) NOT NULL default '0',
  `tax` decimal(19,4) NOT NULL default '0.0000',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `taxgroupid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `taxid` (`taxid`),
  KEY `cashpaymentid` (`cashpaymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cashpaymenttax`
--

LOCK TABLES `cashpaymenttax` WRITE;
/*!40000 ALTER TABLE `cashpaymenttax` DISABLE KEYS */;
/*!40000 ALTER TABLE `cashpaymenttax` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cashtracker`
--

DROP TABLE IF EXISTS `cashtracker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cashtracker` (
  `id` int(11) NOT NULL auto_increment,
  `tablename` varchar(200) NOT NULL default '',
  `referenceid` int(11) NOT NULL default '0',
  `wherefrom` int(5) NOT NULL default '0',
  `userid_in` int(11) NOT NULL default '0',
  `userid_out` int(11) NOT NULL default '0',
  `date_in` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_out` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `amount` decimal(19,5) NOT NULL default '0.00000',
  `bankdepositid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `userid_in` (`userid_in`),
  KEY `userid_out` (`userid_out`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cashtracker`
--

LOCK TABLES `cashtracker` WRITE;
/*!40000 ALTER TABLE `cashtracker` DISABLE KEYS */;
/*!40000 ALTER TABLE `cashtracker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccaccount`
--

DROP TABLE IF EXISTS `ccaccount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccaccount` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `ccprocessorid` int(11) NOT NULL default '0',
  `checkacctid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccaccount`
--

LOCK TABLES `ccaccount` WRITE;
/*!40000 ALTER TABLE `ccaccount` DISABLE KEYS */;
INSERT INTO `ccaccount` VALUES (1,'Manual',4,0,1,'2006-01-17 16:45:08',1,'2006-01-17 21:45:08',1,0,'0000-00-00 00:00:00',0);
/*!40000 ALTER TABLE `ccaccount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccaccountoption`
--

DROP TABLE IF EXISTS `ccaccountoption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccaccountoption` (
  `id` int(11) NOT NULL auto_increment,
  `ccprocessorid` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `fieldname` varchar(50) NOT NULL default '',
  `ccvalues` text NOT NULL,
  `ccdefault` varchar(255) NOT NULL default '',
  `cchold` int(2) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccaccountoption`
--

LOCK TABLES `ccaccountoption` WRITE;
/*!40000 ALTER TABLE `ccaccountoption` DISABLE KEYS */;
INSERT INTO `ccaccountoption` VALUES (1,1,'Login ID','The login ID for your Authorize.net account','x_login','','Test',0),(2,1,'Transaction Key','Transaction key for your account (for security)','x_transaction_key','','Test',1),(3,1,'Check MD5 Hash','Should the MD5 hash be checked?','x_check_hash','TRUE=>Yes~FALSE=>No','FALSE',1),(4,1,'Hash Value','Hash value for the MD5 hash check','x_hash_value','','Test',1),(5,1,'Transaction Mode','Mode used when processing requests','x_test_request','TRUE=>Testing~FALSE=>Production','TRUE',0),(6,1,'Order Transaction Type','Transaction type to use for orders','type','S=>Authorization & Immediate Capture','S',0),(7,1,'Email Customer','Should Authorize.net send an email to the customer?','x_email_customer','TRUE=>Yes~FALSE=>No','FALSE',1),(8,1,'Deliminate Data','Deliminated response from gateway','x_delim_data','TRUE=>True','TRUE',0),(9,1,'Delimination Character','Character used to separate fields','x_delim_char',',=>,',',',0),(10,1,'Encapsulation Character','Character used to encapsulate fields','x_encap_char','|=>|','|',0),(11,1,'Transaction Method','Method used to process requests','x_method','CC=>Credit Card','CC',0),(12,1,'Program Version','','x_version','3.1=>3.1','3.1',0),(13,1,'Relay Response','','x_relay_response','FALSE=>False','FALSE',0),(14,3,'Merchant ID','ID assigned to you by PSiGate','MerchantID','','Test',0),(15,3,'Transaction Mode','Mode to use when processing requests','Result','1=>Always Good~2=>Always Duplicate~3=>Always Decline~0=>Production','1',0),(16,3,'Order Transaction Type','Transaction type to use for orders','type','S=>Sale','S',0),(17,5,'Username','PayPal API Username','username','','',0),(18,5,'Password','PayPal API Password','password','','',0),(19,5,'Certificate File Path','Path to PayPal API certificate in PEM format','certificateFile','','',0),(20,5,'Subject','Optional name of third-party who authorizes transactions','subject','','',0),(21,5,'Environment','PayPal environment to run transactions','environment','live=>Live~sandbox=>Sandbox~beta-sandbox=>Beta-Sandbox','sandbox',0),(22,1,'Shopping Cart Account','Do you want to tie this account with the<br>Authorize.net account set up in the shopping cart?','x_account_tie','sc_authorizenet=>Yes~sc_none=>No','sc_none',0),(23,3,'Shopping Cart Account','Do you want to tie this account with the<br>PSiGate account set up in the shopping cart?','account_tie','sc_psigate=>Yes~sc_none=>No','sc_none',0),(24,5,'Shopping Cart Account','Do you want to tie this account with the<br>PayPal Pro account set up in the shopping cart?','account_tie','sc_paypalpro=>Yes~sc_none=>No','sc_none',0),(26,5,'Order Transaction Type','Transaction type to use for orders','type','A=>Authorization with Delayed Capture','A',0),(27,5,'Additional Authorization %','Additional % to authorize for orders (max 25%)','authorize_extra','0=>0 %~2=>2 %~5=>5 %~10=>10 %~15=>15 %~20=>20 %~25=>25%','10',0),(28,4,'Store Card Info','Retain CC last 4 digits, card name and expiration','validate','0=>No~1=>Yes','0',0),(29,1,'Device Type','Device if using card-present transactions','x_device_type','1=>Unknown~2=>Unattended Terminal~3=>Self Service Terminal~4=>Electronic Cash Register~5=>Personal Computer-Based Terminal~6=>AirPay~7=>Wireless POS~8=>Website~9=>Dial Terminal~10=>Virtual Terminal','5',0),(30,1,'Account Type','Is this a card present (uses scanner) or card not present type of account?','x_card_present','0=>Card Not Present~1=>Card Present','0',0),(31,6,'Source Key','USAePay generated source key','x_login','','Test',0),(32,6,'Check MD5 Hash','Should the MD5 hash be checked?','x_check_hash','TRUE=>Yes~FALSE=>No','FALSE',1),(33,6,'Hash Value','Hash value for the MD5 hash check','x_hash_value','','Test',1),(34,6,'Transaction Mode','Mode used when processing requests','x_test_request','TRUE=>Testing~FALSE=>Production','TRUE',0),(35,6,'Order Transaction Type','Transaction type to use for orders','type','S=>Authorization & Immediate Capture','S',0),(36,6,'Email Customer','Should USA ePay send an email to the customer?','x_email_customer','TRUE=>Yes~FALSE=>No','FALSE',1),(37,6,'Deliminate Data','Deliminated response from gateway','x_delim_data','TRUE=>True','TRUE',0),(38,6,'Delimination Character','Character used to separate fields','x_delim_char',',=>,',',',0),(39,6,'Encapsulation Character','Character used to encapsulate fields','x_encap_char','|=>|','|',0),(40,6,'Transaction Method','Method used to process requests','x_method','CC=>Credit Card','CC',0),(41,6,'Program Version','','x_version','3.1=>3.1','3.1',0),(42,6,'Relay Response','','x_relay_response','FALSE=>False','FALSE',0),(43,6,'Device Type','Device if using card-present transactions','x_device_type','1=>Unknown~2=>Unattended Terminal~3=>Self Service Terminal~4=>Electronic Cash Register~5=>Personal Computer-Based Terminal~6=>AirPay~7=>Wireless POS~8=>Website~9=>Dial Terminal~10=>Virtual Terminal','5',0),(44,6,'Account Type','Is this a card present (uses scanner) or card not present type of account?','x_card_present','0=>Card Not Present~1=>Card Present','0',0),(45,6,'PIN','PIN entered in the USA ePay Merchant Terminal','x_pin','','',0),(46,6,'Source Key Type','','x_sandbox','sandbox=>Sandbox Source Key~production=>Production','production',0);
/*!40000 ALTER TABLE `ccaccountoption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccaccountsetting`
--

DROP TABLE IF EXISTS `ccaccountsetting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccaccountsetting` (
  `id` int(11) NOT NULL auto_increment,
  `ccaccountid` int(11) NOT NULL default '0',
  `ccaccountoptionid` int(11) NOT NULL default '0',
  `value` varchar(255) NOT NULL default '',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccaccountsetting`
--

LOCK TABLES `ccaccountsetting` WRITE;
/*!40000 ALTER TABLE `ccaccountsetting` DISABLE KEYS */;
INSERT INTO `ccaccountsetting` VALUES (1,1,28,'0','2006-04-19 16:48:49',1);
/*!40000 ALTER TABLE `ccaccountsetting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccimportlog`
--

DROP TABLE IF EXISTS `ccimportlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccimportlog` (
  `id` int(11) NOT NULL auto_increment,
  `apbillid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `companyid` int(11) NOT NULL default '0',
  `maincompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `postdate` date default NULL,
  `ccvendorid` int(11) NOT NULL default '0',
  `dnp` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `apbillid` (`apbillid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `companyid` (`companyid`),
  KEY `maincompanyid` (`maincompanyid`),
  KEY `entrydate` (`entrydate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccimportlog`
--

LOCK TABLES `ccimportlog` WRITE;
/*!40000 ALTER TABLE `ccimportlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccimportlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccprocessor`
--

DROP TABLE IF EXISTS `ccprocessor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccprocessor` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `modulename` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccprocessor`
--

LOCK TABLES `ccprocessor` WRITE;
/*!40000 ALTER TABLE `ccprocessor` DISABLE KEYS */;
INSERT INTO `ccprocessor` VALUES (1,'Authorize.Net','authorizenet'),(3,'PSiGate','psigate'),(4,'Manual (off line)','manual'),(6,'USA ePay','epay');
/*!40000 ALTER TABLE `ccprocessor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccpurchase`
--

DROP TABLE IF EXISTS `ccpurchase`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccpurchase` (
  `id` int(11) NOT NULL auto_increment,
  `ccvendorid` int(11) NOT NULL default '0',
  `purchasedate` date default NULL,
  `who` varchar(100) default NULL,
  `amount` decimal(19,5) NOT NULL default '0.00000',
  `purpose` varchar(250) default NULL,
  `apbillid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `lastupdatedate` timestamp NULL default NULL,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `purchasefrom` varchar(100) default NULL,
  `invpoid` int(11) NOT NULL default '0',
  `jobid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `ccvendorid` (`ccvendorid`),
  KEY `cancel` (`cancel`),
  KEY `purchasedate` (`purchasedate`),
  KEY `gltr_jobid` (`jobid`),
  KEY `gltr_costcodeid` (`costcodeid`),
  KEY `gltr_categoryid` (`glcategoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccpurchase`
--

LOCK TABLES `ccpurchase` WRITE;
/*!40000 ALTER TABLE `ccpurchase` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccpurchase` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccpurchase_detail`
--

DROP TABLE IF EXISTS `ccpurchase_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccpurchase_detail` (
  `id` int(11) NOT NULL auto_increment,
  `ccpurchaseid` int(11) NOT NULL default '0',
  `glaccountid` int(11) NOT NULL default '0',
  `chargetype` int(5) NOT NULL default '0',
  `voucherid` int(11) NOT NULL default '0',
  `amount` decimal(19,5) NOT NULL default '0.00000',
  `cancel` int(5) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `glcontraid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `ccpurchaseid` (`ccpurchaseid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccpurchase_detail`
--

LOCK TABLES `ccpurchase_detail` WRITE;
/*!40000 ALTER TABLE `ccpurchase_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccpurchase_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccpurchase_gen`
--

DROP TABLE IF EXISTS `ccpurchase_gen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccpurchase_gen` (
  `id` int(11) NOT NULL auto_increment,
  `useforpo` int(5) NOT NULL default '0',
  `freight_chargetype` int(11) NOT NULL default '0',
  `tax_chargetype` int(11) NOT NULL default '0',
  `default_po_chargetype` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccpurchase_gen`
--

LOCK TABLES `ccpurchase_gen` WRITE;
/*!40000 ALTER TABLE `ccpurchase_gen` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccpurchase_gen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccpurchase_type`
--

DROP TABLE IF EXISTS `ccpurchase_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccpurchase_type` (
  `id` int(11) NOT NULL auto_increment,
  `glaccountid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `description` varchar(250) default NULL,
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `lastupdatedate` datetime default NULL,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `salestaxid` int(11) NOT NULL default '0',
  `glcontraid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `glaccountid` (`glaccountid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccpurchase_type`
--

LOCK TABLES `ccpurchase_type` WRITE;
/*!40000 ALTER TABLE `ccpurchase_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccpurchase_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccterminal`
--

DROP TABLE IF EXISTS `ccterminal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccterminal` (
  `id` int(11) NOT NULL auto_increment,
  `inventorylocationid` int(11) NOT NULL default '0',
  `code` varchar(255) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `ip` varchar(45) NOT NULL default '127.0.0.1',
  `port` int(11) NOT NULL default '443',
  `checkedout` tinyint(1) NOT NULL default '0',
  `checkedoutuserid` int(11) NOT NULL default '0',
  `checkacctid` int(11) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `lastchangeuserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime default NULL,
  `middleware_devicekey` varchar(255) NOT NULL default '',
  `ccaccountid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `middleware_devicekey_UNIQUE` (`middleware_devicekey`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccterminal`
--

LOCK TABLES `ccterminal` WRITE;
/*!40000 ALTER TABLE `ccterminal` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccterminal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccterminallog`
--

DROP TABLE IF EXISTS `ccterminallog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccterminallog` (
  `id` int(11) NOT NULL auto_increment,
  `ccterminalid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `userid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `resulttxt` varchar(45) NOT NULL default '',
  `requestraw` text NOT NULL,
  `replyraw` text NOT NULL,
  `replyjson` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccterminallog`
--

LOCK TABLES `ccterminallog` WRITE;
/*!40000 ALTER TABLE `ccterminallog` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccterminallog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccterminaluser`
--

DROP TABLE IF EXISTS `ccterminaluser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccterminaluser` (
  `id` int(11) NOT NULL auto_increment,
  `ccterminalid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `returneddate` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccterminaluser`
--

LOCK TABLES `ccterminaluser` WRITE;
/*!40000 ALTER TABLE `ccterminaluser` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccterminaluser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cctransaction`
--

DROP TABLE IF EXISTS `cctransaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cctransaction` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `b2buserid` int(11) NOT NULL default '0',
  `ccaccountid` int(11) NOT NULL default '0',
  `referid` int(11) NOT NULL default '0',
  `refertable` varchar(50) NOT NULL default '',
  `transtype` char(1) NOT NULL default '',
  `cardnumber` varchar(50) NOT NULL default '',
  `cardexp` varchar(4) NOT NULL default '',
  `cardtype` varchar(20) NOT NULL default '',
  `cardfirstname` varchar(50) NOT NULL default '',
  `cardlastname` varchar(50) NOT NULL default '',
  `amount` decimal(12,4) NOT NULL default '0.0000',
  `nontaxable` decimal(12,4) NOT NULL default '0.0000',
  `shipping` decimal(12,4) NOT NULL default '0.0000',
  `tax` decimal(12,4) NOT NULL default '0.0000',
  `transid` varchar(30) NOT NULL default '',
  `optionalid` varchar(80) NOT NULL default '',
  `resultcode` char(1) NOT NULL default '',
  `resultreasoncode` int(11) NOT NULL default '0',
  `resultreasontext` varchar(255) NOT NULL default '',
  `authcode` varchar(25) NOT NULL default '',
  `avscode` char(2) NOT NULL default '',
  `cardcode` char(2) NOT NULL default '',
  `customerip` varchar(25) NOT NULL default '',
  `md5hash` varchar(50) NOT NULL default '',
  `customerconfirmation` varchar(20) NOT NULL default '',
  `authopen` int(2) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `authtransid` varchar(30) NOT NULL default '',
  `authorize_extra` int(11) NOT NULL default '0',
  `userdata` varchar(255) NOT NULL default '',
  `billingaddress` varchar(100) NOT NULL default '',
  `billingcity` varchar(50) NOT NULL default '',
  `billingstate` varchar(50) NOT NULL default '',
  `billingzip` varchar(20) NOT NULL default '',
  `cardpresent` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  PRIMARY KEY  (`id`),
  KEY `referid` (`referid`),
  KEY `ccaccountid` (`ccaccountid`),
  KEY `refertable` (`refertable`),
  KEY `b2buserid` (`b2buserid`),
  KEY `customerconfirmation` (`customerconfirmation`),
  KEY `transid` (`transid`),
  KEY `customerid` (`customerid`),
  KEY `cardtype` (`cardtype`),
  KEY `transtype` (`transtype`),
  KEY `entrydate` (`entrydate`),
  KEY `resultcode` (`resultcode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cctransaction`
--

LOCK TABLES `cctransaction` WRITE;
/*!40000 ALTER TABLE `cctransaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `cctransaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ccvendor`
--

DROP TABLE IF EXISTS `ccvendor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ccvendor` (
  `id` int(11) NOT NULL auto_increment,
  `vendorid` int(11) NOT NULL default '0',
  `ccname` varchar(250) default NULL,
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `lastupdatedate` timestamp NULL default NULL,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `dash_hidden` tinyint(1) NOT NULL default '0',
  `glaccountid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `vendorid` (`vendorid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ccvendor`
--

LOCK TABLES `ccvendor` WRITE;
/*!40000 ALTER TABLE `ccvendor` DISABLE KEYS */;
/*!40000 ALTER TABLE `ccvendor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cfglaccount`
--

DROP TABLE IF EXISTS `cfglaccount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cfglaccount` (
  `id` int(11) NOT NULL auto_increment,
  `cflineid` int(11) NOT NULL default '0',
  `glaccountid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cflineid` (`cflineid`),
  KEY `glaccountid` (`glaccountid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cfglaccount`
--

LOCK TABLES `cfglaccount` WRITE;
/*!40000 ALTER TABLE `cfglaccount` DISABLE KEYS */;
/*!40000 ALTER TABLE `cfglaccount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cfline`
--

DROP TABLE IF EXISTS `cfline`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cfline` (
  `id` int(11) NOT NULL auto_increment,
  `categoryid` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `display_order` int(11) NOT NULL default '0',
  `multiplier` int(11) NOT NULL default '1',
  `companyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `categoryid` (`categoryid`),
  KEY `cancel` (`cancel`),
  KEY `companyid` (`companyid`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cfline`
--

LOCK TABLES `cfline` WRITE;
/*!40000 ALTER TABLE `cfline` DISABLE KEYS */;
INSERT INTO `cfline` VALUES (1,1,'Rent Paid in Advance',0,1,1,'2009-12-20 17:01:00',1,0,'2009-12-20 23:43:04',1),(2,2,'Depreciation',0,-1,1,'2009-12-20 17:10:18',1,0,'0001-01-01 00:00:00',0),(3,2,'Amortization',0,-1,1,'2009-12-20 18:01:38',1,0,'0001-01-01 00:00:00',0),(4,3,'Cash Out - Nondeductible Asset',0,-1,1,'2009-12-20 18:10:05',1,0,'0001-01-01 00:00:00',0),(5,3,'Net change in accounts receivable',0,-1,1,'2009-12-20 18:15:04',1,0,'0001-01-01 00:00:00',0),(6,3,'Net change in accounts payable and accrued expenses',0,1,1,'2009-12-20 18:19:37',1,0,'0000-00-00 00:00:00',0),(7,4,'Change of Prepaid Expenses',0,-1,1,'2009-12-20 18:22:19',1,0,'0001-01-01 00:00:00',0),(8,4,'Change of Other Current Assets',0,-1,1,'2009-12-20 18:22:46',1,0,'0001-01-01 00:00:00',0),(9,6,'Inventory',0,-1,1,'2009-12-20 18:26:04',1,0,'0001-01-01 00:00:00',0),(10,6,'Property, Plant and Equipment - General',0,-1,1,'2009-12-20 18:37:36',1,0,'0001-01-01 00:00:00',0),(11,6,'Property, Plant and Equipment - Property',0,-1,1,'2009-12-20 18:38:31',1,0,'0001-01-01 00:00:00',0),(12,6,'Land',0,-1,1,'2009-12-20 18:39:11',1,0,'0001-01-01 00:00:00',0),(13,5,'Return of (Made to) Investments Affiliate Companies',0,-1,1,'2009-12-20 18:40:19',1,0,'0001-01-01 00:00:00',0),(14,5,'Repayment of (Loans to) Affiliate Companies',0,-1,1,'2009-12-20 18:41:18',1,0,'0001-01-01 00:00:00',0),(15,5,'Repayment (Issuance) of Notes Receivable - Current, net',0,-1,1,'2009-12-20 18:41:42',1,0,'0001-01-01 00:00:00',0),(16,5,'Repayment (Issuance) of Notes Receivable, net',0,-1,1,'2009-12-20 18:42:13',1,0,'0001-01-01 00:00:00',0),(17,5,'Proceeds from sale of Other Assets - Other Noncurrent, Other Current',0,-1,1,'2009-12-20 18:44:24',1,0,'0001-01-01 00:00:00',0),(18,5,'Deposits and Refundable Deposits',0,-1,1,'2009-12-20 18:45:09',1,0,'0001-01-01 00:00:00',0),(19,7,'Proceeds from (repayment of) principal from long term real estate debt, net',0,1,1,'2009-12-20 18:50:08',1,0,'0000-00-00 00:00:00',0),(20,7,'Proceeds from (repayment of) long term notes',0,1,1,'2009-12-20 18:50:35',1,0,'0000-00-00 00:00:00',0),(21,7,'Proceeds from (repayment of) borrowings from unsecured debt - term and loc',0,1,1,'2009-12-20 18:50:55',1,0,'0000-00-00 00:00:00',0),(22,7,'Cash Out - Nontaxable Income',0,1,1,'2009-12-20 18:51:15',1,0,'0000-00-00 00:00:00',0),(23,7,'Membership Contribution Received',0,1,1,'2009-12-20 18:51:39',1,0,'0000-00-00 00:00:00',0),(24,7,'Membership Disbursements Paid',0,1,1,'2009-12-20 18:52:01',1,0,'0000-00-00 00:00:00',0),(25,7,'Dividends Paid',0,1,1,'2009-12-20 18:52:51',1,0,'0000-00-00 00:00:00',0),(26,8,'STR_BEGINNING_END_OF_PERIOD_ACCOUNTS',0,1,1,'2009-12-20 18:55:50',1,0,'0001-01-01 00:00:00',0),(28,1,'Test Name2',0,1,1,'2009-12-20 23:34:59',1,1,'2009-12-20 23:43:47',1),(29,5,'Proceeds from sale of Property, Plant and Equipment - Property',0,-1,1,'2009-12-22 15:39:40',1,0,'0001-01-01 00:00:00',0),(30,5,'Proceeds from sale of Property, Plant and Equipment - General',0,-1,1,'2009-12-22 15:39:54',1,0,'0001-01-01 00:00:00',0),(31,5,'Proceeds from sale of Land',0,-1,1,'2009-12-22 15:40:05',1,0,'0001-01-01 00:00:00',0);
/*!40000 ALTER TABLE `cfline` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `changedate`
--

DROP TABLE IF EXISTS `changedate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `changedate` (
  `id_changedate` int(11) NOT NULL default '0',
  `id_printorder` int(11) NOT NULL default '0',
  `id_user` int(11) NOT NULL default '0',
  `olddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `newdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `changedate` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id_changedate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `changedate`
--

LOCK TABLES `changedate` WRITE;
/*!40000 ALTER TABLE `changedate` DISABLE KEYS */;
/*!40000 ALTER TABLE `changedate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `changedateseq`
--

DROP TABLE IF EXISTS `changedateseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `changedateseq` (
  `id` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `changedateseq`
--

LOCK TABLES `changedateseq` WRITE;
/*!40000 ALTER TABLE `changedateseq` DISABLE KEYS */;
INSERT INTO `changedateseq` VALUES (0);
/*!40000 ALTER TABLE `changedateseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chargebackcode`
--

DROP TABLE IF EXISTS `chargebackcode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chargebackcode` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(64) NOT NULL default '',
  `description` tinytext,
  `glaccountid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime default NULL,
  `lastchangeuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chargebackcode`
--

LOCK TABLES `chargebackcode` WRITE;
/*!40000 ALTER TABLE `chargebackcode` DISABLE KEYS */;
/*!40000 ALTER TABLE `chargebackcode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checkacct`
--

DROP TABLE IF EXISTS `checkacct`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkacct` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) default NULL,
  `glaccountid` int(11) NOT NULL default '0',
  `lastchecknumberused` decimal(20,0) default NULL,
  `defaultendorser` varchar(50) default NULL,
  `gencompanyid` int(11) NOT NULL default '0',
  `ap` int(11) NOT NULL default '0',
  `ar` tinyint(1) NOT NULL default '1',
  `pay` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `destination_routing` varchar(9) NOT NULL default '',
  `destination_name` varchar(23) NOT NULL default '',
  `origin_routing` varchar(9) NOT NULL default '',
  `origin_name` varchar(23) NOT NULL default '',
  `company_name` varchar(16) NOT NULL default '',
  `company_identification` varchar(10) NOT NULL default '',
  `send_prenotes` int(2) NOT NULL default '0',
  `accountnumber` varchar(17) NOT NULL default '',
  `fractional_routing` varchar(30) NOT NULL default '',
  `addresscsz` varchar(255) NOT NULL default '',
  `printfullchecks` int(2) NOT NULL default '0',
  `logo` varchar(100) NOT NULL default '',
  `signaturefile` varchar(100) NOT NULL default '',
  `signaturefile2` varchar(100) NOT NULL default '',
  `xadjust` int(11) NOT NULL default '0',
  `yadjust` int(11) NOT NULL default '0',
  `pay_type` int(5) NOT NULL default '2',
  `currency` varchar(10) NOT NULL default 'USD',
  `stubdetails` int(5) NOT NULL default '0',
  `depositrouting` varchar(30) NOT NULL default '',
  `depositformat` int(5) NOT NULL default '0',
  `depositlocation` varchar(255) NOT NULL default '',
  `depositbankaddress` varchar(200) NOT NULL default '',
  `stubformat` int(5) NOT NULL default '0',
  `accountcode` varchar(50) NOT NULL default '',
  `siglines` int(5) NOT NULL default '0',
  `echeckccaccountid` int(11) NOT NULL default '0',
  `specialpayroll` int(5) NOT NULL default '0',
  `dash_hidden` tinyint(1) NOT NULL default '0',
  `filecreationnumber` int(11) NOT NULL default '0',
  `inactive` tinyint(4) NOT NULL default '0',
  `stub_overflow` tinyint(1) NOT NULL default '0',
  `void_date_default_now` tinyint(1) NOT NULL default '0',
  `no_sig_on_manual_checks` tinyint(1) NOT NULL default '0',
  `ccvendorid` int(11) NOT NULL default '0',
  `positive_pay_enabled` tinyint(1) NOT NULL default '0',
  `positive_pay_host` varchar(255) NOT NULL default '',
  `positive_pay_user` varchar(255) NOT NULL default '',
  `positive_pay_private_key` mediumtext NOT NULL,
  `positive_pay_public_key` mediumtext NOT NULL,
  `show_invoice_notes` tinyint(1) NOT NULL default '0',
  `show_invoice_tables` tinyint(1) NOT NULL default '3',
  `show_invoice_origamt` tinyint(1) NOT NULL default '0',
  `show_invoice_disc` tinyint(1) NOT NULL default '0',
  `copy_second_stub` tinyint(1) NOT NULL default '1',
  `positive_pay_sftp` tinyint(1) NOT NULL default '1',
  `payee_name_caps` tinyint(1) NOT NULL default '1',
  `payee_name_font_size` tinyint(4) NOT NULL default '12',
  `hide_second_header` tinyint(1) NOT NULL default '0',
  `hide_discount` tinyint(1) NOT NULL default '0',
  `hide_interest` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checkacct`
--

LOCK TABLES `checkacct` WRITE;
/*!40000 ALTER TABLE `checkacct` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkacct` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checklist`
--

DROP TABLE IF EXISTS `checklist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checklist` (
  `id` int(11) NOT NULL auto_increment,
  `cltype` varchar(15) NOT NULL default '',
  `recordid` int(11) NOT NULL default '0',
  `description` varchar(255) NOT NULL default '',
  `completed` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `cancel` int(11) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `confirmuserids` text NOT NULL,
  `finaluserid` int(11) NOT NULL default '0',
  `finaldate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `entryuserid` (`entryuserid`),
  KEY `cltype` (`cltype`),
  KEY `completed` (`completed`),
  KEY `cancel` (`cancel`),
  KEY `recordid` (`recordid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checklist`
--

LOCK TABLES `checklist` WRITE;
/*!40000 ALTER TABLE `checklist` DISABLE KEYS */;
/*!40000 ALTER TABLE `checklist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chk`
--

DROP TABLE IF EXISTS `chk`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chk` (
  `id` int(11) NOT NULL auto_increment,
  `wherefrom` int(11) NOT NULL default '0',
  `paytype` int(11) NOT NULL default '0',
  `checkdate` date default NULL,
  `checkvoid` int(11) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `checkaccountid` int(11) NOT NULL default '0',
  `checknumber` decimal(15,0) NOT NULL default '0',
  `cashdate` date NOT NULL default '0000-00-00',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `gencompanyid` int(11) NOT NULL default '0',
  `name` varchar(100) default NULL,
  `achfiledetailid` int(11) NOT NULL default '0',
  `commission` int(2) NOT NULL default '0',
  `maincheckid` int(11) NOT NULL default '0',
  `stub_display` varchar(255) NOT NULL default '',
  `currency` varchar(10) NOT NULL default 'USD',
  `voiddate` date default NULL,
  `altname` varchar(255) NOT NULL default '',
  `non_negotiable` int(5) NOT NULL default '0',
  `manual` tinyint(1) NOT NULL default '0',
  `ccapbillid` int(11) NOT NULL default '0',
  `positivepaysent` datetime default '0000-00-00 00:00:00',
  `ccapbilldetailid` int(11) NOT NULL default '0',
  `forcediscount` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `achfiledetailid` (`achfiledetailid`),
  KEY `checkaccountid` (`checkaccountid`),
  KEY `checkvoid` (`checkvoid`),
  KEY `checknumber` (`checknumber`),
  KEY `checkdate` (`checkdate`),
  KEY `cashdate` (`cashdate`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `wherefrom` (`wherefrom`),
  KEY `maincheckid` (`maincheckid`),
  KEY `paytype_ccapbillid` (`paytype`,`ccapbillid`),
  KEY `ccapbilldetailid` (`ccapbilldetailid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chk`
--

LOCK TABLES `chk` WRITE;
/*!40000 ALTER TABLE `chk` DISABLE KEYS */;
/*!40000 ALTER TABLE `chk` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chknotes`
--

DROP TABLE IF EXISTS `chknotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chknotes` (
  `id` int(11) NOT NULL auto_increment,
  `checkid` int(11) NOT NULL default '0',
  `note` text,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `checkid` (`checkid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chknotes`
--

LOCK TABLES `chknotes` WRITE;
/*!40000 ALTER TABLE `chknotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `chknotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coinvoice`
--

DROP TABLE IF EXISTS `coinvoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coinvoice` (
  `id` int(11) NOT NULL auto_increment,
  `maininvoiceid` int(11) NOT NULL default '0',
  `maincustomerid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `invoicetotal` decimal(19,6) NOT NULL default '0.000000',
  `groupbysales` int(11) NOT NULL default '0',
  `paid` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `cancel` int(11) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `notes` text NOT NULL,
  `companyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `maininvoiceid` (`maininvoiceid`),
  KEY `maincustomerid` (`maincustomerid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `customerid` (`customerid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coinvoice`
--

LOCK TABLES `coinvoice` WRITE;
/*!40000 ALTER TABLE `coinvoice` DISABLE KEYS */;
/*!40000 ALTER TABLE `coinvoice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coinvoicedetail`
--

DROP TABLE IF EXISTS `coinvoicedetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coinvoicedetail` (
  `id` int(11) NOT NULL auto_increment,
  `coinvoiceid` int(11) NOT NULL default '0',
  `description` varchar(100) NOT NULL default '',
  `origlinenum` int(11) NOT NULL default '0',
  `salesglaccountid` int(11) NOT NULL default '0',
  `origamount` decimal(19,6) NOT NULL default '0.000000',
  `chargedamount` decimal(19,6) NOT NULL default '0.000000',
  `paidamount` decimal(19,6) NOT NULL default '0.000000',
  PRIMARY KEY  (`id`),
  KEY `coinvoiceid` (`coinvoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coinvoicedetail`
--

LOCK TABLES `coinvoicedetail` WRITE;
/*!40000 ALTER TABLE `coinvoicedetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `coinvoicedetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `commission`
--

DROP TABLE IF EXISTS `commission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commission` (
  `id` int(11) NOT NULL auto_increment,
  `userid` int(11) NOT NULL default '0',
  `tablename` varchar(50) NOT NULL default '',
  `tableid` int(11) NOT NULL default '0',
  `description` varchar(150) NOT NULL default '',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  `commissionflat` decimal(19,6) NOT NULL default '0.000000',
  `commissionpercent` decimal(7,2) NOT NULL default '0.00',
  `commissionbase` decimal(19,6) NOT NULL default '0.000000',
  `status` int(11) NOT NULL default '-1',
  `premplweekid` int(11) NOT NULL default '0',
  `salesmanid` int(11) NOT NULL default '0',
  `employeeid` int(11) NOT NULL default '0',
  `vendorid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `orderid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `linenumber` int(11) NOT NULL default '0',
  `commissiondate` date default NULL,
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `method` varchar(20) NOT NULL default '',
  `currency` varchar(10) NOT NULL default 'USD',
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`),
  KEY `tablename` (`tablename`),
  KEY `tableid` (`tableid`),
  KEY `status` (`status`),
  KEY `premplweekid` (`premplweekid`),
  KEY `entrydate` (`entrydate`),
  KEY `cancel` (`cancel`),
  KEY `customerid` (`customerid`),
  KEY `employeeid` (`employeeid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `orderid` (`orderid`),
  KEY `salesmanid` (`salesmanid`),
  KEY `vendorid` (`vendorid`),
  KEY `companyid` (`companyid`),
  KEY `method` (`method`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commission`
--

LOCK TABLES `commission` WRITE;
/*!40000 ALTER TABLE `commission` DISABLE KEYS */;
/*!40000 ALTER TABLE `commission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `commissionadjustlatepmt`
--

DROP TABLE IF EXISTS `commissionadjustlatepmt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commissionadjustlatepmt` (
  `id` int(11) NOT NULL auto_increment,
  `leaseid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `origcommissionid` int(11) NOT NULL default '0',
  `commissionid` int(11) NOT NULL default '0',
  `dayslate` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `leaseid` (`leaseid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `origcommissionid` (`origcommissionid`),
  KEY `commissionid` (`commissionid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commissionadjustlatepmt`
--

LOCK TABLES `commissionadjustlatepmt` WRITE;
/*!40000 ALTER TABLE `commissionadjustlatepmt` DISABLE KEYS */;
/*!40000 ALTER TABLE `commissionadjustlatepmt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `compositeitemextras`
--

DROP TABLE IF EXISTS `compositeitemextras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `compositeitemextras` (
  `id` int(11) NOT NULL auto_increment,
  `compositeitemid` int(11) NOT NULL default '0',
  `amount` decimal(19,5) NOT NULL default '0.00000',
  `glaccountid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `description` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `compositeitemid` (`compositeitemid`),
  KEY `cancel` (`cancel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `compositeitemextras`
--

LOCK TABLES `compositeitemextras` WRITE;
/*!40000 ALTER TABLE `compositeitemextras` DISABLE KEYS */;
/*!40000 ALTER TABLE `compositeitemextras` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `compositeitemid`
--

DROP TABLE IF EXISTS `compositeitemid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `compositeitemid` (
  `id` int(11) NOT NULL auto_increment,
  `itemcodeid` int(11) NOT NULL default '0',
  `subitemcodeid` int(11) default NULL,
  `quantity` decimal(18,6) NOT NULL default '0.000000',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `default_itemvendorid` int(11) NOT NULL default '0',
  `mfg` varchar(50) default NULL,
  `vordernumber` varchar(30) default NULL,
  `reference_notes` text,
  `status` int(5) NOT NULL default '0',
  `displayorder` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `itemcodeid` (`itemcodeid`),
  KEY `subitemcodeid` (`subitemcodeid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `compositeitemid`
--

LOCK TABLES `compositeitemid` WRITE;
/*!40000 ALTER TABLE `compositeitemid` DISABLE KEYS */;
/*!40000 ALTER TABLE `compositeitemid` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuration`
--

DROP TABLE IF EXISTS `configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuration` (
  `configuration_id` int(5) NOT NULL auto_increment,
  `configuration_title` varchar(64) NOT NULL default '',
  `configuration_key` varchar(64) NOT NULL default '',
  `configuration_value` varchar(255) NOT NULL default '',
  `configuration_description` varchar(255) NOT NULL default '',
  `configuration_group_id` int(5) NOT NULL default '0',
  `sort_order` int(5) default NULL,
  `last_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `date_added` timestamp NOT NULL default '0000-00-00 00:00:00',
  `use_function` varchar(32) default NULL,
  `set_function` varchar(255) default NULL,
  PRIMARY KEY  (`configuration_id`)
) ENGINE=MyISAM AUTO_INCREMENT=231 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuration`
--

LOCK TABLES `configuration` WRITE;
/*!40000 ALTER TABLE `configuration` DISABLE KEYS */;
INSERT INTO `configuration` VALUES (1,'Installed Shipping Modules','SHIPPING_MODULES','item.php;flat.php;selfpickup.php;ups.php;usps.php','This is automatically updated. No need to edit.',7,1,'2007-03-29 13:24:39','2003-06-10 00:18:15','',NULL),(200,'Store Name','STORE_NAME','NolaPro','The name of my store',1,1,'2003-10-05 18:21:34','2002-01-25 06:25:53','',NULL),(2,'Store Owner','STORE_OWNER','Noguska','The name of my store owner',1,2,'2003-12-19 16:59:42','2002-01-25 06:25:53','',NULL),(3,'E-Mail Address','STORE_OWNER_EMAIL_ADDRESS','admin1@noguska.com','The e-mail address of my store owner',1,3,'2003-12-17 21:29:08','2002-01-25 06:25:53','',NULL),(4,'E-Mail From','EMAIL_FROM','admin1@noguska.com','The e-mail address used in (sent) e-mails',1,4,'2003-09-18 18:23:20','2002-01-25 06:25:53','',NULL),(5,'Country','STORE_COUNTRY','223','The country my store is located in',1,5,'2002-02-11 17:31:58','2002-01-25 06:25:53','tep_get_country_name',NULL),(6,'Expected Sort Order','EXPECTED_PRODUCTS_SORT','DESC','This is the sort order used in the &quot;expected products&quot; box.  It can be either ASC (ascending) or DESC (descending, the default).',1,20,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(7,'Expected Sort Field','EXPECTED_PRODUCTS_FIELD','date_expected','The column to sort by in the &quot;expected products&quot; box.  Can be &quot;products_name&quot; or &quot;date_expected&quot; (the default)',1,30,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(8,'First Name','ENTRY_FIRST_NAME_MIN_LENGTH','1','Minimum length of first name',2,1,'2003-12-17 21:29:28','2002-01-25 06:25:53','',NULL),(9,'Last Name','ENTRY_LAST_NAME_MIN_LENGTH','1','Minimum length of last name',2,2,'2002-03-05 16:54:48','2002-01-25 06:25:53','',NULL),(10,'Date of Birth','ENTRY_DOB_MIN_LENGTH','10','Minimum length of date of birth',2,3,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(11,'E-Mail Address','ENTRY_EMAIL_ADDRESS_MIN_LENGTH','6','Minimum length of e-mail address',2,4,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(12,'Street Address','ENTRY_STREET_ADDRESS_MIN_LENGTH','5','Minimum length of street address',2,5,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(13,'Post Code','ENTRY_POSTCODE_MIN_LENGTH','4','Minimum length of post code',2,6,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(14,'City','ENTRY_CITY_MIN_LENGTH','4','Minimum length of city',2,7,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(15,'State','ENTRY_STATE_MIN_LENGTH','4','Minimum length of state',2,7,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(16,'Telephone Number','ENTRY_TELEPHONE_MIN_LENGTH','3','Minimum length of telephone number',2,8,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(17,'Password','ENTRY_PASSWORD_MIN_LENGTH','5','Minimum length of password',2,9,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(18,'Credit Card Owner Name','CC_OWNER_MIN_LENGTH','3','Minimum length of credit card owner name',2,10,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(19,'Credit Card Number','CC_NUMBER_MIN_LENGTH','10','Minimum length of credit card number',2,11,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(20,'Review Text','REVIEW_TEXT_MIN_LENGTH','25','Minimum length of review text',2,13,'2002-11-10 23:20:59','2002-01-25 06:25:53','',NULL),(21,'Address Book Entries','MAX_ADDRESS_BOOK_ENTRIES','5','Maximum address book entries a customer is allowed to have',3,1,'2003-12-17 21:30:00','2002-01-25 06:25:53','',NULL),(22,'Search Results','MAX_DISPLAY_SEARCH_RESULTS','10','Amount of products to list',3,2,'2002-02-06 23:55:33','2002-01-25 06:25:53','',NULL),(23,'Page Links','MAX_DISPLAY_PAGE_LINKS','5','Number of \'number\' links use for page-sets',3,3,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(24,'Special Products','MAX_DISPLAY_SPECIAL_PRODUCTS','9','Maximum number of products on special to display',3,4,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(25,'New Products','MAX_DISPLAY_NEW_PRODUCTS','6','Maximum number of new products to display in a category',3,5,'2002-10-13 20:58:03','2002-01-25 06:25:53','',NULL),(26,'Products Expected','MAX_DISPLAY_UPCOMING_PRODUCTS','10','Maximum number of products expected to display',3,6,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(27,'Manufacturers List','MAX_DISPLAY_MANUFACTURERS_IN_A_LIST','0','Used in manufacturers box; when the number of manufacturers exceeds this number, a drop-down list will be displayed instead of the default list',3,7,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(28,'Length of Manufacturers Name','MAX_DISPLAY_MANUFACTURER_NAME_LEN','15','Used in manufacturers box; maximum length of manufacturers name to display',3,8,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(29,'New Reviews','MAX_DISPLAY_NEW_REVIEWS','6','Maximum number of new reviews to display',3,9,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(30,'Selection of Random Reviews','MAX_RANDOM_SELECT_REVIEWS','10','How many records to select from to choose one random product review',3,10,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(31,'Selection of Random New Products','MAX_RANDOM_SELECT_NEW','10','How many records to select from to choose one random new product to display',3,11,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(32,'Selection of Products on Special','MAX_RANDOM_SELECT_SPECIALS','10','How many records to select from to choose one random product special to display',3,12,'2002-10-09 03:35:09','2002-01-25 06:25:53','',NULL),(33,'Categories To List Per Row','MAX_DISPLAY_CATEGORIES_PER_ROW','3','How many categories to list per row',3,13,'2002-10-13 20:58:36','2002-01-25 06:25:53','',NULL),(34,'Small Image Width','SMALL_IMAGE_WIDTH','100','The pixel width of small images',4,1,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(35,'Small Image Height','SMALL_IMAGE_HEIGHT','80','The pixel height of small images',4,2,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(36,'Heading Image Width','HEADING_IMAGE_WIDTH','85','The pixel width of heading images',4,3,'2002-02-19 22:12:49','2002-01-25 06:25:53','',NULL),(37,'Heading Image Height','HEADING_IMAGE_HEIGHT','60','The pixel height of heading images',4,4,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(38,'Subcategory Image Width','SUBCATEGORY_IMAGE_WIDTH','100','The pixel width of subcategory images',4,5,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(39,'Subcategory Image Height','SUBCATEGORY_IMAGE_HEIGHT','57','The pixel height of subcategory images',4,6,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(40,'Calculate Image Size','CONFIG_CALCULATE_IMAGE_SIZE','1','Calculate the size of images?',4,7,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(41,'Image Required','IMAGE_REQUIRED','1','Enable to display broken images. Good for development.',4,8,'2002-03-19 17:46:43','2002-01-25 06:25:53','',NULL),(42,'General','FONT_STYLE_MAIN','<font face=\"Verdana, Arial\" size=\"2\" color=\"#000000\">','General font style',5,1,'2002-02-22 03:59:57','2002-01-25 06:25:53','',NULL),(43,'Small Text','FONT_STYLE_SMALL_TEXT','<font face=\"Verdana, Arial\" size=\"1\" color=\"#000000\">','Small Text font style',5,2,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(44,'Navigation Bar','FONT_STYLE_HEADER_NAVIGATION_BAR','<font face=\"Tahoma, Verdana, Arial\" size=\"2\" color=\"#ffffff\">','Header Navigation Bar font style',5,3,'2002-02-22 16:39:47','2002-01-25 06:25:53','',NULL),(45,'Top Bar','FONT_STYLE_TOP_BAR','<font face=\"Tahoma, Verdana, Arial\" size=\"2\"  color=\"#FFFFFF\">','Top Bar font style',5,4,'2002-02-22 16:42:49','2002-01-25 06:25:53','',NULL),(46,'Heading','FONT_STYLE_HEADING','<font face=\"Verdana, Arial\" size=\"4\" color=\"#000000\">','Heading font style',5,5,'2002-02-22 14:39:29','2002-01-25 06:25:53','',NULL),(47,'Sub Bar','FONT_STYLE_SUB_BAR','<font face=\"Verdana, Arial\" size=\"1\" color=\"#000000\">','Sub Bar font style',5,6,'2002-02-22 14:40:26','2002-01-25 06:25:53','',NULL),(48,'Table Heading','FONT_STYLE_TABLE_HEADING','<font face=\"Verdana, Arial\" size=\"2\" color=\"#000000\">','Table Heading font style',5,7,'2002-02-22 14:43:10','2002-01-25 06:25:53','',NULL),(49,'Footer','FONT_STYLE_FOOTER','<font face=\"Tahoma, Verdana, Arial\" size=\"2\" color=\"#ffffff\">','Footer font style',5,8,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(50,'Info-Box Headings','FONT_STYLE_INFO_BOX_HEADING','<font face=\"Tahoma, Verdana, Arial\" size=\"2\" color=\"#FFFFFF\">','Font style for info-box headings',5,9,'2002-02-22 17:10:20','2002-01-25 06:25:53','',NULL),(51,'Info-Box Contents','FONT_STYLE_INFO_BOX_BODY','<font face=\"Verdana, Arial\" size=\"1\">','Font style for info-box contents',5,10,'2002-02-22 16:40:44','2002-01-25 06:25:53','',NULL),(52,'Listing Headings','FONT_STYLE_LIST_BOX_HEADING','<font face=\"Verdana, Arial\" size=\"2\">','Font style for listing box headings',5,11,'2002-02-22 16:41:14','2002-01-25 06:25:53','',NULL),(53,'Listing Contents','FONT_STYLE_LIST_BOX_BODY','<font face=\"Verdana, Arial\" size=\"1\" color=\"#000000\">','Font style for listing box contents',5,12,'2002-02-22 14:53:37','2002-01-25 06:25:53','',NULL),(54,'Account Categories','FONT_STYLE_ACCOUNT_CATEGORY','<font face=\"Verdana, Arial\" size=\"2\" color=\"#aabbdd\">','Account Category font style',5,13,'2002-02-22 14:58:03','2002-01-25 06:25:53','',NULL),(55,'Field Entry','FONT_STYLE_FIELD_ENTRY','<font face=\"Verdana, Arial\" size=\"2\">','Field Entry font style',5,14,'2002-02-22 16:43:37','2002-01-25 06:25:53','',NULL),(56,'Field Value','FONT_STYLE_FIELD_VALUE','<font face=\"Verdana, Arial\" size=\"2\">','Field Value font style',5,15,'2002-02-22 16:44:16','2002-01-25 06:25:53','',NULL),(57,'New Item In Cart','FONT_STYLE_NEW_CART_ITEM','<font face=\"Verdana, Arial\" size=\"1\" color=\"#ff0000\">','Font style for new items added to the cart',5,16,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(58,'Installed Payment Modules','PAYMENT_MODULES','paypal.php;cc.php;cod.php','List of payment module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: cc.php;cod.php;paypal.php)',6,0,'2003-12-22 15:58:13','2002-01-25 06:25:53','',NULL),(92,'Inactive Account Timer','MAX_NUMBER_OF_DAYS_WITHOUT_ORDERS_ALLOWED','90','If the customer has not been active for this many days the account is disabled.',3,1,'2003-10-17 18:06:18','2002-02-20 20:25:10','',NULL),(94,'Store Address','STORE_ADDRESS','One OS Suite Way','Store Address',1,5,'2002-11-14 01:41:10','2002-02-20 20:36:58','',NULL),(93,'Store Address City','STORE_ADDRESS_CITY','New York','Store Address City',1,5,'2002-11-10 22:39:38','2002-02-20 20:35:55','',NULL),(63,'Credit Card TP email address','PAYMENT_EMAIL_CC','NONE','If this email address is not NONE then the middle digits of any stored cc numbers will be X-ed out and emailed with the order id.',6,5,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(64,'Shipping Methods to offer to customer','SHIPPING_MODULES','item.php;flat.php;selfpickup.php;ups.php;usps.php','List of shipping module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ups.php;flat.php;item.php)',7,1,'2007-03-29 13:24:45','2002-01-25 06:25:53',NULL,NULL),(65,'Package Tare weight.','SHIPPING_BOX_WEIGHT','3','What is the weight of typical packaging of small to medium packages?',7,2,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(66,'Larger packages - percentage increase.','SHIPPING_BOX_PADDING','10','For 10% enter 10',7,3,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(67,'Handling Fee','SHIPPING_HANDLING','0','Enter the handling fee you may charge.',7,4,'2002-10-09 03:36:36','2002-01-25 06:25:53','',NULL),(68,'Display Product Image','PRODUCT_LIST_IMAGE','1','Do you want to display the Product Image?',8,1,'2002-03-19 17:52:04','2002-01-25 06:25:53','',NULL),(69,'Display Product Manufacturer Name','PRODUCT_LIST_MANUFACTURER','0','Do you want to display the Product Manufacturer Name?',8,2,'2003-08-27 19:13:58','2002-01-25 06:25:53','',NULL),(70,'Display Product Model','PRODUCT_LIST_MODEL','1','Do you want to display the Product Model?',8,3,'2003-12-17 21:31:27','2002-01-25 06:25:53','',NULL),(71,'Display Product Name','PRODUCT_LIST_NAME','1','Do you want to display the Product Name?',8,4,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(72,'Display Product Price','PRODUCT_LIST_PRICE','1','Do you want to display the Product Price',8,5,'2002-03-19 17:43:41','2002-01-25 06:25:53','',NULL),(73,'Display Product Quantity','PRODUCT_LIST_QUANTITY','1','Do you want to display the Product Quantity?',8,6,'2002-03-19 17:40:47','2002-01-25 06:25:53','',NULL),(74,'Display Product Weight','PRODUCT_LIST_WEIGHT','1','Do you want to display the Product Weight?',8,7,'2002-03-19 17:41:08','2002-01-25 06:25:53','',NULL),(75,'Display Buy Now column','PRODUCT_LIST_BUY_NOW','1','Do you want to display the Buy Now column?',8,8,'2002-03-19 17:41:32','2002-01-25 06:25:53','',NULL),(76,'Display Category/Manufacturer Filter (0=disable; 1=enable)','PRODUCT_LIST_FILTER','1','Do you want to display the Category/Manufacturer Filter?',8,9,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(77,'Location of Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)','PREV_NEXT_BAR_LOCATION','2','Sets the location of the Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)',8,10,'2002-03-19 17:44:44','2002-01-25 06:25:53','',NULL),(203,'Enable Item Shipping','SHIPPING_ITEM_ENABLED','1','Do you want to offer per item rate shipping?',7,7,'2003-07-18 20:11:28','2003-07-18 20:11:28',NULL,NULL),(80,'UPS Pickup Method','SHIPPING_UPS_PICKUP','CC','How do you give packages to UPS? CC - Customer Counter, RDP - Daily Pickup, OTP - One Time Pickup, LC - Letter Center, OCA - On Call Air',7,5,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(81,'UPS Packaging?','SHIPPING_UPS_PACKAGE','CP','CP - Your Packaging, ULE - UPS Letter, UT - UPS Tube, UBE - UPS Express Box',7,6,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(82,'Residential Delivery?','SHIPPING_UPS_RES','RES','Quote for Residential (RES) or Commercial Delivery (COM)',7,7,'2003-10-17 18:05:19','2002-01-25 06:25:53',NULL,NULL),(83,'Enter the USPS USERID','SHIPPING_USPS_USERID','NONE','Enter the USPS USERID assigned to you. Register at http://www.uspsprioritymail.com/et_regcert.html and also tell them you are an end user not developer.',7,11,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(85,'Enter the USPS URL of the production Server','SHIPPING_USPS_SERVER','NONE','See above',7,13,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(86,'Enter the Maximum Package Weight you will ship','SHIPPING_MAX_WEIGHT','50','Carriers have a max weight limit for a single package. This is a common one for all.',7,14,'2002-01-25 06:25:53','2002-01-25 06:25:53',NULL,NULL),(87,'Postal Code','STORE_ORIGIN_ZIP','10005','Enter the Postal Code (ZIP) of the Store to be used in shipping quotes.',1,6,'2003-12-18 14:20:52','2002-01-25 06:25:53','',NULL),(88,'Country Code','STORE_ORIGIN_COUNTRY','95991','Enter the &quot;ISO 3166&quot; Country Code of the Store to be used in shipping quotes.  To find your country code, visit the <A HREF=\"http://www.din.de/gremien/nas/nabd/iso3166ma/codlstp1/index.html\" TARGET=\"_blank\">ISO 3166 Maintenance Agency</A>.',1,9,'2002-10-27 18:30:40','2002-01-25 06:25:53','',NULL),(95,'Store Telephone Number','STORE_TELEPHONE','212-123-4567','Store Telephone Number',1,10,'2002-11-10 22:41:38','2002-02-20 20:40:21','',NULL),(96,'Store Fax Number','STORE_FAX','212-345-6789','Store Fax Number',1,11,'2002-11-10 22:42:03','2002-02-20 20:53:57','',NULL),(97,'E-Mail Address for Invoices','STORE_EMAIL_INVOICE','noreply@nolapro.com','Copy of the invoices are send to this mail box',1,4,'2003-12-19 16:59:32','2002-02-20 21:10:17','',NULL),(98,'E-Mail Customer Account Support','EMAIL_CUSTOMER_ACCOUNT_SUPPORT','noreply@ossuite.org','E-Mail box for account creating and disabling',1,4,'2002-11-10 23:39:29','2002-02-20 21:12:37','',NULL),(99,'Tax ID/SSN','ENTRY_TAX_ID_MIN_LENGTH','9','configuration',2,5,'2003-10-17 18:11:23','2002-02-25 19:13:26',NULL,NULL),(100,'Company Name','ENTRY_COMPANY_NAME_MIN_LENGTH','2','Minimum length of company name',2,5,'2002-02-25 19:19:47','2002-02-25 19:19:47',NULL,NULL),(134,'Active ERP Software','ACTIVE_ACCOUNTING_SOFTWARE','1','Active ERP Software Installed',1,6,'2002-11-11 21:28:22','2002-09-03 21:25:03',NULL,NULL),(130,'OS Suite ERP Software','NOLA_ENABLE','1','OS Suite ERP System is running',1,6,'2002-11-11 21:29:16','2002-08-04 22:00:27',NULL,NULL),(204,'Per Item shipping cost','SHIPPING_ITEM_COST','2.50','How much will be charged for each item ordered?',7,8,'2003-07-18 20:11:28','2003-07-18 20:11:28',NULL,NULL),(120,'Store Address State','STORE_ADDRESS_STATE','New York','Store address state',1,5,'2003-12-19 16:59:53','2002-03-20 19:18:11','',NULL),(145,'Allow Credit Card','PAYMENT_SUPPORT_CC','1','Do you want to accept credit card payments?',6,2,'2003-10-17 13:48:24','2002-10-16 23:40:16','',NULL),(113,'Store PayPal Email','STORE_PAYPAL_EMAIL','admin1@noguska.com','PayPal Email account for this store',1,4,'2003-09-18 18:25:47','2002-03-19 15:45:35','',NULL),(206,'Enable Self Pickup','SHIPPING_SELFPICKUP_ENABLED','1','Do you want to offer self-pickup option ?',7,5,'2003-10-17 18:13:58','2003-07-18 20:11:34',NULL,NULL),(159,'Enable FedEx Shipping','SHIPPING_FEDEX_ENABLED','1','Do you want to offer Federal Express (FedEx) shipping?',7,10,'2002-11-21 14:28:01','2002-11-21 14:28:01',NULL,NULL),(127,'Active ERP ID','ACTIVE_COMPANY','1','Active ERP Company for Accounting Purpose',1,6,'2002-11-11 21:30:26','2002-07-24 23:11:51',NULL,NULL),(218,'Enable UPS Shipping','SHIPPING_UPS_ENABLED','1','Do you want to offer UPS shipping?',7,9,'2003-10-05 18:58:39','2003-10-05 18:58:39',NULL,NULL),(151,'Default Price Level','DEFAULT_PRICE_LEVEL','1','Default Price Level for Non-Login Customer',1,6,'2003-11-26 13:41:53','2002-11-10 19:22:11','tep_get_price_level',NULL),(152,'Login Required','LOGIN_REQUIRE','0','Required for customer to Login for browsing products',1,9,'2003-10-17 18:13:25','2002-11-10 19:33:53','',NULL),(222,'Allow PayPal','PAYMENT_SUPPORT_PAYPAL','1','Do you want to accept PayPal payments?',6,3,'2003-12-17 21:33:27','2003-12-17 21:33:27',NULL,NULL),(155,'Sale GL Account','SALE_GL_ACCOUNT','12','Sale General Ledger Account',1,8,'2002-11-10 23:44:24','2002-11-10 23:26:33','tep_get_saleglaccount_id',NULL),(156,'Invoice Term','INVOICE_TERM','1','Default Invoice Term',1,8,'2002-11-10 23:28:03','2002-11-10 23:28:03','tep_get_invoiceterm_id',NULL),(157,'Sale Rep','DEFAULT_SALE_REP','1','Default Sale Rep',1,8,'2002-11-10 23:29:18','2002-11-10 23:29:18','tep_get_saleman_id',NULL),(207,'Self Pick Up Cost','SHIPPING_SELFPICKUP_COST','0.00','What is the Shipping cost? The Handling fee will also be added.',7,6,'2003-12-22 16:01:50','2003-07-18 20:11:34','',NULL),(211,'Flat Cost','SHIPPING_FLAT_COST','5.00','What is the Shipping cost? The Handling fee will also be added.',7,6,'2003-07-18 20:11:38','2003-07-18 20:11:38',NULL,NULL),(210,'Enable Flat Shipping','SHIPPING_FLAT_ENABLED','1','Do you want to offer flat rate shipping?',7,5,'2003-07-18 20:11:38','2003-07-18 20:11:38',NULL,NULL),(223,'PayPal ID','PAYPAL_ID','you@yourbuisness.com','Your buisness ID at PayPal.  Usually the email address you signed up with.  You can create a free PayPal account at http://www.paypal.com.',6,4,'2003-12-17 21:33:27','2003-12-17 21:33:27',NULL,NULL),(221,'','FONT_STYLE_NAVIGATION_BOX_HEADING','<font face=\"Verdana, Arial\" size=\"1\" color=\"#000000\">','',0,NULL,'2003-12-09 23:12:20','0000-00-00 00:00:00',NULL,NULL),(225,'Allow Cash On Delivery (COD)','PAYMENT_SUPPORT_COD','1','Do you want to accept COD (Cash On Delevery) payments?',6,1,'2003-12-22 15:58:13','2003-12-22 15:58:13',NULL,NULL),(226,'Store Address Zip','STORE_ADDRESS_ZIP','44830','Store address zip',1,6,'2004-06-25 18:40:45','2004-06-25 18:40:45','',''),(227,'Default Inventory Location','DEFAULT_INVENTORYLOCATION','1','Default inventory location ID from which to ship products',1,6,'2004-06-25 18:56:27','2004-06-25 18:56:27','',''),(228,'Enable SSL','ENABLE_SSL','0','Whether to use SSL for order checkout.',1,6,'2005-02-28 20:44:03','0000-00-00 00:00:00',NULL,NULL),(229,'Display Email Option When Out of Stock (0=disable; 1=enable)','PRODUCT_LIST_EMAIL_OOS','1','Do you want to show the option to email customers when an item is out of stock?',8,10,'2006-04-24 15:19:48','0000-00-00 00:00:00','',NULL),(230,'Enable USPS Shipping','SHIPPING_USPS_ENABLED','0','Do you want to offer USPS shipping?',7,10,'2007-03-29 13:29:55','2005-08-02 19:26:18',NULL,NULL);
/*!40000 ALTER TABLE `configuration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuration_group`
--

DROP TABLE IF EXISTS `configuration_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuration_group` (
  `configuration_group_id` int(5) NOT NULL auto_increment,
  `configuration_group_title` varchar(64) NOT NULL default '',
  `configuration_group_description` varchar(255) NOT NULL default '',
  `sort_order` int(5) default NULL,
  PRIMARY KEY  (`configuration_group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuration_group`
--

LOCK TABLES `configuration_group` WRITE;
/*!40000 ALTER TABLE `configuration_group` DISABLE KEYS */;
INSERT INTO `configuration_group` VALUES (1,'My Store','General information about my store',1),(2,'Minimum Values','The minimum values for functions / data',2),(3,'Maximum Values','The maximum values for functions / data',3),(6,'Payment Options','Payment options available at my store',6),(7,'Shipping Options','Shipping options available at my store',7),(8,'Product Listing','Product Listingconfiguration options',8);
/*!40000 ALTER TABLE `configuration_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `constructionproject_details`
--

DROP TABLE IF EXISTS `constructionproject_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `constructionproject_details` (
  `id` int(11) NOT NULL auto_increment,
  `siteid` int(11) NOT NULL default '0',
  `deal` text,
  `estimated_ground_breaking` date default NULL,
  `land_and_entitlements` text,
  `lande_contacts` text,
  `lande_permits` text,
  `lande_other` text,
  `improvements_description` text,
  `improvements_building_plans` text,
  `improvements_phases` text,
  `improvements_quotes` text,
  `feasibility_mktresearch` text,
  `feasibility_mktplans` text,
  `status` int(5) NOT NULL default '0',
  `address` text,
  `cancel` int(5) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `client` varchar(255) NOT NULL default '',
  `projectcode` varchar(20) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `siteid` (`siteid`),
  KEY `cancel` (`cancel`),
  KEY `status` (`status`),
  KEY `projectcode` (`projectcode`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `constructionproject_details`
--

LOCK TABLES `constructionproject_details` WRITE;
/*!40000 ALTER TABLE `constructionproject_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `constructionproject_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `constructionproject_details_phase`
--

DROP TABLE IF EXISTS `constructionproject_details_phase`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `constructionproject_details_phase` (
  `id` int(11) NOT NULL auto_increment,
  `project_detailid` int(11) NOT NULL default '0',
  `phasenumber` int(5) NOT NULL default '1',
  `fairmarketvalue` decimal(19,5) NOT NULL default '0.00000',
  `financialrequest` decimal(19,5) NOT NULL default '0.00000',
  `cost_engineering` decimal(19,5) NOT NULL default '0.00000',
  `cost_closing` decimal(19,5) NOT NULL default '0.00000',
  `cost_marketing` decimal(19,5) NOT NULL default '0.00000',
  `cost_general` decimal(19,5) NOT NULL default '0.00000',
  `cost_furniture` decimal(19,5) NOT NULL default '0.00000',
  `cost_excavation` decimal(19,5) NOT NULL default '0.00000',
  `cost_construction_main` decimal(19,5) NOT NULL default '0.00000',
  `cost_construction_amenities` decimal(19,5) NOT NULL default '0.00000',
  `date_estimate` date default NULL,
  `status` int(5) NOT NULL default '0',
  `inflow_gfd` decimal(19,5) NOT NULL default '0.00000',
  `cancel` int(5) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `estimate_startdate` date default NULL,
  `estimated_enddate` date default NULL,
  `inflow_client` decimal(19,5) default NULL,
  `inflow_rex` decimal(19,5) NOT NULL default '0.00000',
  `outflow_client` decimal(19,5) default NULL,
  `outflow_gfd` decimal(19,5) NOT NULL default '0.00000',
  `cost_interest` decimal(19,5) NOT NULL default '0.00000',
  `cost_architectural` decimal(19,5) NOT NULL default '0.00000',
  `cost_permits` decimal(19,5) NOT NULL default '0.00000',
  `outflow_rex` decimal(19,5) NOT NULL default '0.00000',
  `cost_siteandgeneral` decimal(19,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`),
  KEY `project_detailid` (`project_detailid`),
  KEY `phasenumber` (`phasenumber`),
  KEY `status` (`status`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `constructionproject_details_phase`
--

LOCK TABLES `constructionproject_details_phase` WRITE;
/*!40000 ALTER TABLE `constructionproject_details_phase` DISABLE KEYS */;
/*!40000 ALTER TABLE `constructionproject_details_phase` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactaddress`
--

DROP TABLE IF EXISTS `contactaddress`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactaddress` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `contactnameid` int(10) unsigned NOT NULL default '0',
  `tablename` varchar(100) NOT NULL default '',
  `tablerecordid` int(10) unsigned NOT NULL default '0',
  `companyid` int(10) unsigned NOT NULL default '0',
  `entryuserid` int(10) unsigned NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `address1` varchar(200) NOT NULL default '',
  `address2` varchar(200) NOT NULL default '',
  `mailstop` varchar(20) NOT NULL default '',
  `city` varchar(100) NOT NULL default '',
  `state` varchar(50) NOT NULL default '',
  `zip` varchar(15) NOT NULL default '',
  `country` varchar(100) NOT NULL default '',
  `description` text NOT NULL,
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `tablerecordid` (`tablerecordid`),
  KEY `tablename` (`tablename`),
  KEY `contactnameid` (`contactnameid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactaddress`
--

LOCK TABLES `contactaddress` WRITE;
/*!40000 ALTER TABLE `contactaddress` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactaddress` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactemail`
--

DROP TABLE IF EXISTS `contactemail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactemail` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `contactnameid` int(10) unsigned NOT NULL default '0',
  `tablename` varchar(100) NOT NULL default '',
  `tablerecordid` int(10) unsigned NOT NULL default '0',
  `companyid` int(10) unsigned NOT NULL default '0',
  `entryuserid` int(10) unsigned NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `email` varchar(100) NOT NULL default '',
  `description` text NOT NULL,
  `cancel` int(11) NOT NULL default '0',
  `sendstatements` tinyint(1) NOT NULL default '0',
  `sendprelim` tinyint(1) NOT NULL default '0',
  `sendinvoices` tinyint(1) NOT NULL default '0',
  `sendconfs` tinyint(1) NOT NULL default '0',
  `sendquotes` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `tablerecordid` (`tablerecordid`),
  KEY `tablename` (`tablename`),
  KEY `contactnameid` (`contactnameid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactemail`
--

LOCK TABLES `contactemail` WRITE;
/*!40000 ALTER TABLE `contactemail` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactemail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactname`
--

DROP TABLE IF EXISTS `contactname`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactname` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `tablename` varchar(100) NOT NULL default '',
  `tablerecordid` int(10) unsigned NOT NULL default '0',
  `companyid` int(10) unsigned NOT NULL default '0',
  `entryuserid` int(10) unsigned NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `firstname` varchar(100) NOT NULL default '',
  `lastname` varchar(100) NOT NULL default '',
  `description` text NOT NULL,
  `cancel` int(11) NOT NULL default '0',
  `taskstatusid` int(11) NOT NULL default '0',
  `authorizedbuyer` tinyint(1) NOT NULL default '0',
  `inactive` tinyint(4) default '0',
  PRIMARY KEY  (`id`),
  KEY `tablerecordid` (`tablerecordid`),
  KEY `tablename` (`tablename`),
  KEY `taskstatusid` (`taskstatusid`),
  KEY `firstname` (`firstname`),
  KEY `lastname` (`lastname`),
  KEY `cancel` (`cancel`),
  KEY `companyid` (`companyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactname`
--

LOCK TABLES `contactname` WRITE;
/*!40000 ALTER TABLE `contactname` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactname` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactphone`
--

DROP TABLE IF EXISTS `contactphone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactphone` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `contactnameid` int(10) unsigned NOT NULL default '0',
  `tablename` varchar(100) NOT NULL default '',
  `tablerecordid` int(10) unsigned NOT NULL default '0',
  `companyid` int(10) unsigned NOT NULL default '0',
  `entryuserid` int(10) unsigned NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `phone` varchar(100) NOT NULL default '',
  `description` text NOT NULL,
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `tablerecordid` (`tablerecordid`),
  KEY `tablename` (`tablename`),
  KEY `contactnameid` (`contactnameid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactphone`
--

LOCK TABLES `contactphone` WRITE;
/*!40000 ALTER TABLE `contactphone` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactphone` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `costcode`
--

DROP TABLE IF EXISTS `costcode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `costcode` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(20) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastupdateuserid` int(11) NOT NULL default '0',
  `blocksales` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `costcode`
--

LOCK TABLES `costcode` WRITE;
/*!40000 ALTER TABLE `costcode` DISABLE KEYS */;
/*!40000 ALTER TABLE `costcode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter`
--

DROP TABLE IF EXISTS `counter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `counter` (
  `startdate` char(8) default NULL,
  `counter` int(12) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `counter`
--

LOCK TABLES `counter` WRITE;
/*!40000 ALTER TABLE `counter` DISABLE KEYS */;
/*!40000 ALTER TABLE `counter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter_history`
--

DROP TABLE IF EXISTS `counter_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `counter_history` (
  `month` char(8) default NULL,
  `counter` int(12) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `counter_history`
--

LOCK TABLES `counter_history` WRITE;
/*!40000 ALTER TABLE `counter_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `counter_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `countries` (
  `countries_id` int(5) NOT NULL auto_increment,
  `countries_name` varchar(64) NOT NULL default '',
  `countries_iso_code_2` char(2) NOT NULL default '',
  `countries_iso_code_3` char(3) NOT NULL default '',
  `calling_code` char(3) NOT NULL default '',
  `address_format_id` int(5) NOT NULL default '0',
  `langs` tinytext,
  `states` text,
  `continent` varchar(2) NOT NULL default '',
  `decimalplaces` tinyint(4) NOT NULL default '2',
  `unitprice_decimalplaces` tinyint(4) NOT NULL default '2',
  `currency_symbol` varchar(6) NOT NULL default '$',
  `character_encoding` varchar(12) NOT NULL default 'ISO-8859-1',
  `thousandssymbol` varchar(6) NOT NULL default ',',
  `decimalsymbol` varchar(6) NOT NULL default '.',
  `symbolafter` varchar(6) NOT NULL default '',
  `temp` varchar(1) NOT NULL default 'F',
  PRIMARY KEY  (`countries_id`),
  KEY `IDX_COUNTRIES_NAME` (`countries_name`)
) ENGINE=MyISAM AUTO_INCREMENT=276 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (240,'Afghanistan','AF','AFG','93',0,'pr,dr','Badakhshan,Badghis Province,Farah,Faryab Province,Herat Province,Kabul,Kunduz Province,Or?zg?n Province,Paktia Province,Vel?yat-e [provisional] Khowst,Vel?yat-e [provisional] N?rest?n,Vel?yat-e Baghl?n,Vel?yat-e Balkh,Vel?yat-e B?m??n,Vel?yat-e Ghazn?,Vel?yat-e Ghowr,Vel?yat-e Helmand,Vel?yat-e Jowzj?n,Vel?yat-e Kandah?r,Vel?yat-e K?p?s?,Vel?yat-e Konar,Vel?yat-e Laghm?n,Vel?yat-e Lowgar,Vel?yat-e Nangarh?r,Vel?yat-e N?mr?z,Vel?yat-e Pakt?k?,Vel?yat-e Parv?n,Vel?yat-e Samang?n,Vel?yat-e Sar-e Pol,Vel?yat-e Takh?r,Vel?yat-e Vardak,Zabul Province','AS',2,2,'','','','','',''),(2,'Albania','AL','ALB','355',1,'el','Qarku i Beratit,Qarku i Dibrës,Qarku i Durrësit,Qarku i Elbasanit,Qarku i Fierit,Qarku i Gjirokastrës,Qarku i Korçës,Qarku i Kukësit,Qarku i Lezhës,Qarku i Shkodrës,Qarku i Tiranës,Qarku i Vlorës','EU',2,2,'','','','','',''),(3,'Algeria','DZ','DZA','213',1,'ar,fr','Wilaya d\' Adrar,Wilaya d\' Alger,Wilaya d\' Annaba,Wilaya d\' El Bayadh,Wilaya d\' El Oued,Wilaya d\' El Tarf,Wilaya d\' Illizi,Wilaya d\' Oran,Wilaya d\' Oum el Bouaghi,Wilaya de Aïn Defla,Wilaya de Aïn Temouchent,Wilaya de Batna,Wilaya de Béchar,Wilaya de Bejaïa,Wilaya de Biskra,Wilaya de Blida,Wilaya de Bordj Bou Arréridj,Wilaya de Bouira,Wilaya de Boumerdes,Wilaya de Chlef,Wilaya de Constantine,Wilaya de Djelfa,Wilaya de Ghardaïa,Wilaya de Guelma,Wilaya de Jijel,Wilaya de Khenchela,Wilaya de Laghouat,Wilaya de Mascara,Wilaya de Médéa,Wilaya de Mila,Wilaya de Mostaganem,Wilaya de M\'Sila,Wilaya de Naama,Wilaya de Ouargla,Wilaya de Relizane,Wilaya de Saïda,Wilaya de Sétif,Wilaya de Sidi Bel Abbès,Wilaya de Skikda,Wilaya de Souk Ahras,Wilaya de Tamanghasset,Wilaya de Tébessa,Wilaya de Tiaret,Wilaya de Tindouf,Wilaya de Tipaza,Wilaya de Tissemsilt,Wilaya de Tizi Ouzou,Wilaya de Tlemcen','AF',2,2,'','','','','',''),(5,'Andorra','AD','AND','376',1,'fr,pt','Parròquia d\'Andorra la Vella,Parròquia de Canillo,Parròquia de la Massana,Parròquia de Sant Julià de Lòria,Parròquia d\'Encamp,Parròquia d\'Escaldes-Engordany,Parròquia d\'Ordino','EU',2,2,'','','','','',''),(6,'Angola','AO','AGO','244',1,'pt','Província da Huíla,Província da Lunda Norte,Província da Lunda Sul,Província de Benguela,Província de Cabinda,Província de Luanda,Província de Malanje,Província de Namibe,Província do Bengo,Província do Bié,Província do Cuando Cubango,Província do Cuanza Norte,Província do Cuanza Sul,Província do Cunene,Província do Huambo,Província do Moxico,Província do Uíge,Província do Zaire','AF',2,2,'','','','','',''),(9,'Antigua and Barbuda','AG','ATG','1',1,'en','Barbuda,Parish of Saint George,Parish of Saint John,Parish of Saint Mary,Parish of Saint Paul,Parish of Saint Peter,Parish of Saint Philip','NA',2,2,'','','','','',''),(10,'Argentina','AR','ARG','54',1,'es,en,it,de,fr','Distrito Federal,Provincia de Buenos Aires,Provincia de Catamarca,Provincia de Córdoba,Provincia de Corrientes,Provincia de Entre Ríos,Provincia de Formosa,Provincia de Jujuy,Provincia de La Pampa,Provincia de La Rioja,Provincia de Mendoza,Provincia de Misiones,Provincia de Río Negro,Provincia de Salta,Provincia de San Juan,Provincia de San Luis,Provincia de Santa Cruz,Provincia de Santa Fe,Provincia de Santiago del Estero,Provincia de Tucumán,Provincia del Chaco,Provincia del Chubut,Provincia del Neuquén','SA',2,2,'','','','','',''),(11,'Armenia','AM','ARM','374',1,'ru','Aragatsotni Marz,Ararati Marz,Armaviri Marz,Geghark\'unik\'i Marz,K\'aghak\' Yerevan,Kotayk\'i Marz,Lorru Marz,Shiraki Marz,Syunik\'i Marz,Tavushi Marz,Vayots\' Dzori Marz','AS',2,2,'','','','','',''),(13,'Australia','AU','AUS','61',1,'en','Australian Capital Territory,New South Wales,Northern Territory,Queensland,South Australia,Tasmania,Victoria,Western Australia','OC',2,2,'','','','','',''),(14,'Austria','AT','AUT','43',1,'en','Burgenland,Carinthia,Lower Austria,Salzburg,Styria,Tyrol,Upper Austria,Vienna,Vorarlberg','EU',2,2,'','','','','',''),(15,'Azerbaijan','AZ','AZE','994',1,'ru','Ab?eron Rayonu,A?cab?di Rayonu,A?dam Rayonu,A?da? Rayonu,A?stafa Rayonu,A?su Rayonu,Astara Rayonu,Bak? ?ähäri,Balak?n Rayonu,B?rd? Rayonu,Beyl?qan Rayonu,Bil?suvar Rayonu,C?bray?l Rayonu,C?lilabad Rayonu,Da?k?s?n Rayonu,D?v?çi Rayonu,?li Bayraml? ??h?ri,Füzuli Rayonu,G?d?b?y Rayonu,G?nc? ??h?ri,Goranboy Rayonu,Göyçay Rayonu,Hac?qabul Rayonu,?mi?li Rayonu,?smay?ll? Rayonu,K?lb?c?r Rayonu,Kürd?mir Rayonu,Laç?n Rayonu,L?nk?ran Rayonu,L?nk?ran ??h?ri,Lerik Rayonu,Masall? Rayonu,Ming?cevir ??h?ri,Naftalan ??h?ri,Nakhichevan,Neftçala Rayonu,O?uz Rayonu,Qax Rayonu,Qazax Rayonu,Q?b?l? Rayonu,Qobustan Rayonu,Quba Rayonu,Qubadl? Rayonu,Qusar Rayonu,Saatl? Rayonu,Sabirabad Rayonu,Salyan Rayonu,?amax? Rayonu,Samux Rayonu,??ki Rayonu,??ki ??h?ri,??mkir Rayonu,Siy?z?n Rayonu,Sumqay?t ??h?ri,?u?a Rayonu,?u?a ??h?ri,T?rt?r Rayonu,Tovuz Rayonu,Ucar Rayonu,Xaçmaz Rayonu,Xank?ndi ??h?ri,Xanlar Rayonu,X?z? Rayonu,Xocal? Rayonu,Xocav?nd Rayonu,Yard?ml? Rayonu,Yevlax Rayonu,Yevlax ??h?ri,Zaqatala Rayonu,Z?ngilan Rayonu,Z?rdab Rayonu','AS',2,2,'','','','','',''),(16,'Bahamas','BS','BHS','1',1,'en','Acklins and Crooked Islands District,Bimini District,Cat Island District,Exuma District,Freeport District,Fresh Creek District,Governor\'s Harbour District,Green Turtle Cay District,Harbour Island District,High Rock District,Inagua District,Kemps Bay District,Long Island District,Marsh Harbour District,Mayaguana District,New Providence District,Nichollstown and Berry Islands District,Ragged Island District,Rock Sound District,San Salvador and Rum Cay District,Sandy Point District','NA',2,2,'','','','','',''),(17,'Bahrain','BH','BHR','973',1,'ar,en,ur','Ar Rifa’ and Southern Region,Central Region,Hamad town,Hawar Islands,Hedd,Isa Town,Jidd Haffs,Manama,Muharraq,Northern Region,Sitra,Western Region','AS',3,3,'','','','','',''),(18,'Bangladesh','BD','BGD','880',1,'en','Borishal,Chittagong,Dhaka Division,Khulna Division,R?jsh?hi Division,Sylhet Division','AS',2,2,'','','','','',''),(19,'Barbados','BB','BRB','1',1,'en','Christ Church,Saint Andrew,Saint George,Saint James,Saint John,Saint Joseph,Saint Lucy,Saint Michael,Saint Peter,Saint Philip,Saint Thomas','NA',2,2,'','','','','',''),(20,'Belarus','BY','BLR','375',1,'ru','Brestskaya Voblasts\',Homyel\'skaya Voblasts\',Horad Minsk,Hrodzyenskaya Voblasts\',Mahilyowskaya Voblasts\',Minskaya Voblasts\',Vitsyebskaya Voblasts\'','EU',2,2,'','','','','',''),(21,'Belgium','BE','BEL','32',1,'nl,fr','Flanders,Région de Bruxelles-Capitale,Wallonia','EU',2,2,'','','','','',''),(22,'Belize','BZ','BLZ','501',1,'en,es','Belize District,Cayo District,Corozal District,Orange Walk District,Stann Creek District,Toledo District','NA',2,2,'','','','','',''),(23,'Benin','BJ','BEN','229',1,'fr','Département de l\' Alibori,Département de l\' Atakora,Département de l\' Atlantique,Département de l\' Ouémé,Département de la Donga,Département du Borgou,Département du Collines,Département du Kouffo,Département du Littoral,Département du Mono,Département du Plateau,Département du Zou','AF',2,2,'','','','','',''),(25,'Bhutan','BT','BTN','975',1,'en,zh,th','Bumthang Dzongkhag,Chhukha Dzongkhag,Chirang Dzongkhag,Daga Dzongkhag,Gasa District,Geylegphug Dzongkhag,Ha Dzongkhag,Lhuntshi Dzongkhag,Mongar Dzongkhag,Paro District,Pemagatsel Dzongkhag,Punakha Dzongkhag,Samchi Dzongkhag,Samdrup Jongkhar District,Shemgang Dzongkhag,Tashigang Dzongkhag,Thimphu Dzongkhag,Tongsa Dzongkhag,Wangdi Phodrang Dzongkhag','AS',2,2,'','','','','',''),(26,'Bolivia','BO','BOL','591',1,'es','Departamento de Chuquisaca,Departamento de Cochabamba,Departamento de La Paz,Departamento de Oruro,Departamento de Pando,Departamento de Potosí,Departamento de Santa Cruz,Departamento de Tarija,Departamento del Beni','SA',2,2,'','','','','',''),(27,'Bosnia and Herzegovina','BA','BIH','387',1,'sr,en','Federation of Bosnia and Herzegovina,Republika Srpska','EU',2,2,'','','','','',''),(28,'Botswana','BW','BWA','267',1,'en','Central District,Chobe District,Ghanzi District,Kgalagadi District,Kgatleng District,Kweneng District,North East District,North West District,South East District,Southern District','AF',2,2,'','','','','',''),(30,'Brazil','BR','BRA','55',1,'pt,es,en,fr','Distrito Federal,Estado da Bahia,Estado da Paraíba,Estado de Alagoas,Estado de Espírito Santo,Estado de Goiás,Estado de Mato Grosso,Estado de Mato Grosso do Sul,Estado de Minas Gerais,Estado de Pernambuco,Estado de Rondônia,Estado de Roraima,Estado de Santa Catarina,Estado de São Paulo,Estado de Sergipe,Estado de Tocantins,Estado do Acre,Estado do Amapá,Estado do Amazonas,Estado do Ceará,Estado do Maranhão,Estado do Pará,Estado do Parana,Estado do Piauí,Estado do Rio de Janeiro,Estado do Rio Grande do Norte,Estado do Rio Grande do Sul','SA',2,2,'','','','','',''),(32,'Brunei Darussalam','BN','BRN','673',1,'ms','Belait District,Brunei and Muara District,Temburong District,Tutong District','AS',2,2,'','','','','',''),(33,'Bulgaria','BG','BGR','359',1,'bg,tr','Oblast Blagoevgrad,Oblast Burgas,Oblast Dobrich,Oblast Gabrovo,Oblast Khaskovo,Oblast K?rdzhali,Oblast Kyustendil,Oblast Lovech,Oblast Montana,Oblast Pazardzhik,Oblast Pernik,Oblast Pleven,Oblast Plovdiv,Oblast Razgrad,Oblast Ruse,Oblast Shumen,Oblast Silistra,Oblast Sliven,Oblast Smolyan,Oblast Sofiya,Oblast Sofiya-Grad,Oblast Stara Zagora,Oblast T?rgovishte,Oblast Varna,Oblast Veliko T?rnovo,Oblast Vidin,Oblast Vratsa,Oblast Yambol','EU',2,2,'','','','','',''),(34,'Burkina Faso','BF','BFA','226',1,'fr','Kadiogo,Province d\' Oubritenga,Province de l\' Oudalan,Province de la Bougouriba,Province de la Comoé,Province de la Gnagna,Province de la Komondjari,Province de la Kompienga,Province de la Kossi,Province de la Léraba,Province de la Sissili,Province de la Tapoa,Province des Balé,Province des Banwa,Province du Bam,Province du Bazèga,Province du Boulgou,Province du Boulkiemdé,Province du Ganzourgou,Province du Gourma,Province du Houet,Province du Ioba,Province du Kénédougou,Province du Koulpélogo,Province du Kouritenga,Province du Kourwéogo,Province du Loroum,Province du Mouhoun,Province du Nahouri,Province du Namentenga,Province du Nayala,Province du Noumbiel,Province du Passore,Province du Poni,Province du Sanguié,Province du Sanmatenga,Province du Séno,Province du Soum,Province du Sourou,Province du Tuy,Province du Yagha,Province du Yatenga,Province du Ziro,Province du Zondoma,Province du Zoundwéogo','AF',2,2,'','','','','',''),(35,'Burundi','BI','BDI','257',1,'fr','iProvense ya Bubanza,iProvense ya Bujumbura,iProvense ya Bururi,iProvense ya Cibitoke,iProvense ya Gitega,iProvense ya Karuzi,iProvense ya Kayanza,iProvense ya Kirundo,iProvense ya Muramvya,iProvense ya Muyinga,iProvense ya Mwaro,iProvense ya Rutana,Province de Cankuzo,Province de Makamba,Province de Ngozi,Province de Ruyigi','AF',2,2,'','','','','',''),(36,'Cambodia','KH','KHM','855',1,'fr,en','Khêt Si?mréab-?târ Méanchey,Khétt Bântéay Méan Che?y,Khétt B?tdâmbâng,Khétt Kâmpóng Cham,Khétt Kâmpóng Chhn?ng,Khétt Kâmpóng Spœ,Khétt Kâmpóng Thum,Khétt Kâmpôt,Khétt Kândal,Khétt Kaôh K?ng,Khétt Krâchéh,Khétt Môndôl Kiri,Khétt Po?th?s?t,Khétt Pre?h V?héar,Khétt Prey Vêng,Khétt Rôtân?h Kiri,Khétt Si?m Réab,Khétt Stœ?ng Trêng,Khétt Svay Ri?ng,Khétt Takêv,Kr?ng Phnum Pénh,Kr?ng Pre?h Seihân?','AS',2,2,'','','','','',''),(37,'Cameroon','CM','CMR','237',1,'fr','Adamaoua Province,Centre Province,East Province,Far North Province,Littoral Province,North Province,North-West Province,South Province,South-West Province,West Province','AF',2,2,'','','','','',''),(38,'Canada','CA','CAN','1',1,'en,fr','AB:Alberta,BC:British Columbia,MB:Manitoba,NB:New Brunswick,NL:Newfoundland and Labrador,NT:Northwest Territories,NS:Nova Scotia,NU:Nunavut,ON:Ontario,PE:Prince Edward Island,QC:Quebec,SK:Saskatchewan,YT:Yukon Territory','NA',2,2,'','','','','',''),(39,'Cape Verde','CV','CPV','238',1,'pt','Concelho da Boa Vista,Concelho da Brava,Concelho da Praia,Concelho da Ribeira Grande,Concelho de Santa Catarina,Concelho de Santa Cruz,Concelho de São Domingos,Concelho de São Filipe,Concelho de São Miguel,Concelho de São Nicolau,Concelho de São Vicente,Concelho do Maio,Concelho do Paul,Concelho do Sal,Concelho do Tarrafal,Concelho dos Mosteiros','AF',2,2,'','','','','',''),(41,'Central African Republic','CF','CAF','236',1,'fr','Commune de Bangui,Préfecture de l\' Ombella-Mpoko,Préfecture de l\' Ouham,Préfecture de l\' Ouham-Pendé,Préfecture de la Bamingui-Bangoran,Préfecture de la Basse-Kotto,Préfecture de la Haute-Kotto,Préfecture de la Kémo,Préfecture de la Lobaye,Préfecture de la Mambéré-Kadéï,Préfecture de la Nana-Grébizi,Préfecture de la Nana-Mambéré,Préfecture de la Ouaka,Préfecture de la Sangha-Mbaéré,Préfecture de la Vakaga,Préfecture du Haut-Mbomou,Préfecture du Mbomou','AF',2,2,'','','','','',''),(42,'Chad','TD','TCD','235',1,'fr','Préfecture du Batha,Préfecture du Biltine,Préfecture du Borkou-Ennedi-Tibesti,Préfecture du Chari-Baguirmi,Préfecture du Guéra,Préfecture du Kanem,Préfecture du Lac,Préfecture du Logone Occidental,Préfecture du Logone Oriental,Préfecture du Mayo-Kébbi,Préfecture du Moyen-Chari,Préfecture du Ouaddaï,Préfecture du Salamat,Préfecture du Tandjilé','AF',2,2,'','','','','',''),(43,'Chile','CL','CHL','56',1,'es','Región Aisén del General Carlos Ibáñez del Campo,Región de Antofagasta,Región de Arica y Parinacota,Región de Atacama,Región de Coquimbo,Región de la Araucanía,Región de Los Lagos,Región de Los Ríos,Región de Magallanes y de la Antártica Chilena,Región de Tarapacá,Región de Valparaíso,Región del Biobío,Región del Libertador General Bernardo O\'Higgins,Región del Maule,Región Metropolitana de Santiago','SA',2,2,'','','','','',''),(44,'China','CN','CHN','86',1,'en,zh','Anhui Sheng,Beijing Shi,Chongqing Shi,Fujian,Gansu Sheng,Guangdong Sheng,Guangxi Zhuangzu Zizhiqu,Guizhou Sheng,Hainan Province,Hebei Sheng,Heilongjiang Sheng,Henan Sheng,Hubei,Hunan Province,Inner Mongolia Autonomous Region,Jiangsu Sheng,Jiangxi Sheng,Jilin Sheng,Liaoning Province,Ningxia Huizu Zizhiqu,Qinghai Sheng,Shaanxi Sheng,Shandong Sheng,Shanghai Shi,Shanxi Sheng,Sichuan Sheng,Tianjin Shi,Tibet Autonomous Region,Xinjiang Uygur Zizhiqu,Yunnan Province,Zhejiang Sheng','AS',2,2,'','','','','',''),(47,'Colombia','CO','COL','57',1,'es','Atlántico,Bogota D.C.,Cundinamarca,Departamento de Antioquia,Departamento de Arauca,Departamento de Bolívar,Departamento de Boyacá,Departamento de Caldas,Departamento de Casanare,Departamento de Córdoba,Departamento de La Guajira,Departamento de Nariño,Departamento de Norte de Santander,Departamento de Risaralda,Departamento de Santander,Departamento de Sucre,Departamento de Tolima,Departamento del Amazonas,Departamento del Caquetá,Departamento del Cauca,Departamento del Cesar,Departamento del Chocó,Departamento del Guainía,Departamento del Guaviare,Departamento del Huila,Departamento del Magdalena,Departamento del Meta,Departamento del Putumayo,Departamento del Quindío,Departamento del Valle del Cauca,Departamento del Vaupés,Departamento del Vichada','SA',2,2,'','','','','',''),(48,'Comoros','KM','COM','269',1,'ar,fr','Anjouan,Grande Comore,Mohéli','AF',2,2,'','','','','',''),(49,'Congo','CD','COD','242',1,'fr',' DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\", DEMOCRATIC REPUBLIC OF THE\"','AF',2,2,'','','','','',''),(51,'Costa Rica','CR','CRI','506',1,'es,en','Provincia de Alajuela,Provincia de Cartago,Provincia de Guanacaste,Provincia de Heredia,Provincia de Limón,Provincia de Puntarenas,Provincia de San José','NA',2,2,'','','','','',''),(52,'Cote D\'Ivoire','CI','CIV','225',1,'fr','Région de l\' Agnéby,Région de la Marahoué,Région de la Vallée du Bandama,Région des Dix-Huit Montagnes,Région des Lacs,Région des Lagunes,Région des Savanes,Région du Bafing,Région du Bas-Sassandra,Région du Denguélé,Région du Fromager,Région du Haut-Sassandra,Région du Moyen-Cavally,Région du Moyen-Comoé,Région du N\'zi-Comoé,Région du Sud-Bandama,Région du Sud-Comoé,Région du Worodougou,Région du Zanzan','AF',2,2,'','','','','',''),(53,'Croatia','HR','HRV','385',1,'en,ru','Bjelovarsko-Bilogorska Županija,Brodsko-Posavska Županija,Dubrova?ko-Neretvanska Županija,Grad Zagreb,Istarska Županija,Karlova?ka Županija,Koprivni?ko-Križeva?ka Županija,Krapinsko-Zagorska Županija,Li?ko-Senjska Županija,Me?imurska Županija,Osje?ko-Baranjska Županija,Požeško-Slavonska Županija,Primorsko-Goranska Županija,Šibensko-Kninska Županija,Sisa?ko-Moslava?ka Županija,Splitsko-Dalmatinska Županija,Varaždinska Županija,Viroviti?ko-Podravska Županija,Vukovarsko-Srijemska Županija,Zadarska Županija,Zagreba?ka Županija','EU',2,2,'','','','','',''),(54,'Cuba','CU','CUB','53',1,'es','Municipio Especial Isla de la Juventud,Provincia de Camagüey,Provincia de Ciego de Ávila,Provincia de Cienfuegos,Provincia de Ciudad de La Habana,Provincia de Guantánamo,Provincia de Holguín,Provincia de La Habana,Provincia de Matanzas,Provincia de Pinar del Río,Provincia de Sancti Spíritus,Provincia de Santiago de Cuba,Provincia de Villa Clara,Provincia Granma,pueto padre','NA',2,2,'','','','','',''),(55,'Cyprus','CY','CYP','357',1,'el','Famagusta District,Kyrenia District,Larnaca District,Limassol District,Nicosia District,Paphos District','AS',2,2,'','','','','',''),(56,'Czech Republic','CZ','CZE','420',1,'ru,de,fr,it,es','Hlavní m?sto Praha,Jiho?eský Kraj,Karlovarský kraj,Kraj Vyso?ina,Královéhradecký kraj,Liberecký kraj,Moravskoslezský kraj,Olomoucký kraj,Pardubický kraj,Plze?ský kraj,South Moravian Region,St?edo?eský kraj,Ústecký kraj,Zlínský kraj','EU',2,2,'','','','','',''),(57,'Denmark','DK','DNK','45',1,'da','Capital Region,Central Jutland,North Jutland,South Denmark,Zealand','EU',2,2,'','','','','',''),(58,'Djibouti','DJ','DJI','253',1,'fr,ar','Région d\' Ali Sabieh,Région d\' Arta,Région d\' Obock,Région de Dikhil,Région de Tadjourah,Ville de Djibouti','AF',2,2,'','','','','',''),(59,'Dominica','DM','DMA','1',1,'en','Saint Andrew,Saint David,Saint George,Saint John,Saint Joseph,Saint Luke,Saint Mark,Saint Patrick,Saint Paul,Saint Peter','NA',2,2,'','','','','',''),(60,'Dominican Republic','DO','DOM','1',1,'es','Distrito Nacional,Provincia de Azua,Provincia de Baoruco,Provincia de Barahona,Provincia de Dajabón,Provincia de El Seíbo,Provincia de Elías Piña,Provincia de Hato Mayor,Provincia de Independencia,Provincia de La Altagracia,Provincia de La Romana,Provincia de La Vega,Provincia de Monseñor Nouel,Provincia de Monte Cristi,Provincia de Monte Plata,Provincia de Pedernales,Provincia de Peravia,Provincia de Puerto Plata,Provincia de Salcedo,Provincia de Samaná,Provincia de San Cristóbal,Provincia de San José de Ocoa,Provincia de San Juan,Provincia de San Pedro de Macorís,Provincia de Santiago,Provincia de Santiago Rodríguez,Provincia de Santo Domingo,Provincia de Valverde,Provincia Duarte,Provincia Espaillat,Provincia María Trinidad Sánchez,Provincia Sánchez Ramírez','NA',2,2,'','','','','',''),(61,'East Timor','TP','TMP','670',1,'pt','East Timor','AS',2,2,'','','','','',''),(62,'Ecuador','EC','ECU','593',1,'es','Provincia de Bolívar,Provincia de Cotopaxi,Provincia de El Oro,Provincia de Esmeraldas,Provincia de Francisco de Orellana,Provincia de Galápagos,Provincia de Imbabura,Provincia de Loja,Provincia de Los Ríos,Provincia de Manabí,Provincia de Morona Santiago,Provincia de Napo,Provincia de Pichincha,Provincia de Sucumbíos,Provincia de Zamora Chinchipe,Provincia del Azuay,Provincia del Cañar,Provincia del Carchi,Provincia del Chimborazo,Provincia del Guayas,Provincia del Pastaza,Provincia del Tungurahua','SA',2,2,'','','','','',''),(63,'Egypt','EG','EGY','20',1,'ar,en','Alexandria,Eastern Province,Mu??faz?at ad Daqahl?yah,Mu??faz?at al Ba?r al A?mar,Mu??faz?at al Bu?ayrah,Mu??faz?at al Fayy?m,Mu??faz?at al Gharb?yah,Mu??faz?at al Ism?`?l?yah,Mu??faz?at al J?zah,Mu??faz?at al Min?f?yah,Mu??faz?at al Miny?,Mu??faz?at al Q?hirah,Mu??faz?at al Qaly?b?yah,Mu??faz?at al W?d? al Jad?d,Mu??faz?at as Suways,Mu??faz?at Asw?n,Mu??faz?at Asy??,Mu??faz?at Ban? Suwayf,Mu??faz?at B?r Sa`?d,Mu??faz?at Dumy??,Mu??faz?at Jan?b S?n?\',Mu??faz?at Kafr ash Shaykh,Mu??faz?at Ma?r??,Mu??faz?at Qin?,Mu??faz?at Sham?l S?n?\',Mu??faz?at S?h?j','AF',2,2,'','','','','',''),(64,'El Salvador','SV','SLV','503',1,'es','Departamento de Ahuachapán,Departamento de Cabañas,Departamento de Chalatenango,Departamento de Cuscatlán,Departamento de La Libertad,Departamento de La Paz,Departamento de La Unión,Departamento de Morazán,Departamento de San Miguel,Departamento de San Salvador,Departamento de San Vicente,Departamento de Santa Ana,Departamento de Sonsonate,Departamento de Usulután','NA',2,2,'','','','','',''),(65,'Equatorial Guinea','GQ','GNQ','240',1,'es','Provincia de Annobón,Provincia de Bioko Norte,Provincia de Bioko Sur,Provincia de Centro Sur,Provincia de Kié-Ntem,Provincia de Litoral,Provincia de Wele-Nzas','AF',2,2,'','','','','',''),(66,'Eritrea','ER','ERI','291',1,'ar','Zoba ?nseba,Zoba Debub,Zoba Debubaw? K\'eyih Bahr?,Zoba Gash Barka,Zoba Ma\'?kel,Zoba Sem?naw? K\'eyih Bahr?','AF',2,2,'','','','','',''),(67,'Estonia','EE','EST','372',1,'et,ru','Harjumaa,Hiiumaa,Ida-Virumaa,Järvamaa,Jõgevamaa,Läänemaa,Lääne-Virumaa,Pärnumaa,Põlvamaa,Raplamaa,Saaremaa,Tartumaa,Valgamaa,Viljandimaa,Võrumaa','EU',2,2,'','','','','',''),(68,'Ethiopia','ET','ETH','251',1,'ar,en','?d?s ?beba ?stedader,?far Kilil,?mara Kilil,B?nshangul Gumuz Kilil,Dir? Dawa ?stedader,Gamb?la Hizboch Kilil,H?rer? Hizb Kilil,Orom?ya Kilil,Sumal? Kilil,Tigray Kilil,Welega Kifle H?ger,YeDebub Bih?roch Bih?reseboch na Hizboch Kilil','AF',2,2,'','','','','',''),(71,'Fiji','FJ','FJI','679',1,'en','Central,Eastern,Northern,Rotuma,Western','OC',2,2,'','','','','',''),(72,'Finland','FI','FIN','358',1,'fi','Åland,Åland ,Eastern Finland,Lapponia,Oulu,Southern Finland,Western Finland','EU',2,2,'','','','','',''),(73,'France','FR','FRA','33',1,'fr','Alsace,Aquitaine,Basse-Normandie,Bourgogne,Brittany,Champagne-Ardenne,Corsica,Franche-Comté,Haute-Normandie,Languedoc-Roussillon,Midi-Pyrénées,Picardie,Poitou-Charentes,Provence-Alpes-Côte d\'Azur,Région Auvergne,Région Centre,Région Île-de-France,Région Limousin,Région Lorraine,Région Nord-Pas-de-Calais,Région Pays de la Loire,Rhône-Alpes','EU',2,2,'','','','','',''),(78,'Gabon','GA','GAB','241',1,'fr','Province de l\' Estuaire,Province de l\' Ogooué-Ivindo,Province de l\' Ogooué-Lolo,Province de l\' Ogooué-Maritime,Province de la Ngounié,Province de la Nyanga,Province du Haut-Ogooué,Province du Moyen-Ogooué,Province du Woleu-Ntem','AF',2,2,'','','','','',''),(79,'Gambia','GM','GMB','220',1,'en','Central River Division,City of Banjul,Lower River Division,North Bank Division,Upper River,Western Division','AF',2,2,'','','','','',''),(80,'Georgia','GE','GEO','995',1,'ru','Abkhazia,Ajaria [provisional],Ch\'khorotsqus Raioni,K\'alak\'i T\'bilisi,Martvilis Raioni,Samegrelo and Zemo Svaneti,Zugdidis Raioni','AS',2,2,'','','','','',''),(81,'Germany','DE','DEU','49',1,'de','Baden-Württemberg,Bavaria,Brandenburg,Hamburg,Hesse,Land Berlin,Land Bremen,Lower Saxony,Mecklenburg-Vorpommern,North Rhine-Westphalia,Rhineland-Palatinate,Saarland,Saxony,Saxony-Anhalt,Schleswig-Holstein,Thuringia','EU',2,2,'','','','','',''),(82,'Ghana','GH','GHA','233',1,'en','Ashanti Region,Brong-Ahafo Region,Central Region,Eastern Region,Greater Accra Region,Northern Region,Upper East Region,Upper West Region,Volta Region,Western Region','AF',2,2,'','','','','',''),(84,'Greece','GR','GRC','30',1,'el,en,fr','Attica,Central Greece,Central Macedonia,Crete,East Macedonia and Thrace,Epirus,Ionian Islands,North Aegean,Peloponnese,South Aegean,Thessaly,West Greece,West Macedonia','EU',2,2,'','','','','',''),(86,'Grenada','GD','GRD','1',1,'en','Saint Andrew,Saint David,Saint George,Saint John,Saint Mark,Saint Patrick','NA',2,2,'','','','','',''),(89,'Guatemala','GT','GTM','502',1,'es','Departamento de Alta Verapaz,Departamento de Baja Verapaz,Departamento de Chimaltenango,Departamento de Chiquimula,Departamento de El Progreso,Departamento de Escuintla,Departamento de Guatemala,Departamento de Huehuetenango,Departamento de Izabal,Departamento de Jalapa,Departamento de Jutiapa,Departamento de Quetzaltenango,Departamento de Retalhuleu,Departamento de Sacatepéquez,Departamento de San Marcos,Departamento de Santa Rosa,Departamento de Sololá,Departamento de Suchitepéquez,Departamento de Totonicapán,Departamento de Zacapa,Departamento del Petén,Departamento del Quiché','NA',2,2,'','','','','',''),(90,'Guinea','GN','GIN','224',1,'fr','Capitale d\'État-Zone Spéciale de Conakry,Préfecture de Beyla,Préfecture de Boffa,Préfecture de Boké,Préfecture de Coyah,Préfecture de Dabola,Préfecture de Dalaba,Préfecture de Dinguiraye,Préfecture de Dubréka,Préfecture de Faranah,Préfecture de Forécariah,Préfecture de Fria,Préfecture de Gaoual,Préfecture de Guékédou,Préfecture de Kankan,Préfecture de Kérouané,Préfecture de Kindia,Préfecture de Kissidougou,Préfecture de Koubia,Préfecture de Koundara,Préfecture de Kouroussa,Préfecture de Labé,Préfecture de Lélouma,Préfecture de Lola,Préfecture de Macenta,Préfecture de Mali,Préfecture de Mamou,Préfecture de Mandiana,Préfecture de Nzérékoré,Préfecture de Pita,Préfecture de Siguiri,Préfecture de Télimélé,Préfecture de Tougué,Préfecture de Yomou','AF',2,2,'','','','','',''),(91,'Guinea-bissau','GW','GNB','245',1,'pt','Bafatá,Biombo,Bissau,Bolama,Cacheu,Gabú,Oio,Quinara,Tombali','AF',2,2,'','','','','',''),(92,'Guyana','GY','GUY','592',1,'en,hi,ur','Barima-Waini Region,Cuyuni-Mazaruni Region,Demerara-Mahaica Region,East Berbice-Corentyne Region,Essequibo Islands-West Demerara Region,Mahaica-Berbice Region,Pomeroon-Supenaam Region,Potaro-Siparuni Region,Upper Demerara-Berbice Region,Upper Takutu-Upper Essequibo Region','SA',2,2,'','','','','',''),(93,'Haiti','HT','HTI','509',1,'fr','Département de l\' Artibonite,Département de l\' Ouest,Département de la Grand\'Anse,Département du Centre,Département du Nord,Département du Nord-Est,Département du Nord-Ouest,Département du Sud,Département du Sud-Est','NA',2,2,'','','','','',''),(95,'Honduras','HN','HND','504',1,'es','Departamento de Atlántida,Departamento de Choluteca,Departamento de Colón,Departamento de Comayagua,Departamento de Copán,Departamento de Cortés,Departamento de El Paraíso,Departamento de Gracias a Dios,Departamento de Intibucá,Departamento de Islas de la Bahía,Departamento de Lempira,Departamento de Ocotepeque,Departamento de Olancho,Departamento de Santa Bárbara,Departamento de Valle,Departamento de Yoro,Departmento de Francisco Morazán,Departmento de La Paz','NA',2,2,'','','','','',''),(97,'Hungary','HU','HUN','36',1,'en,de,ro,ru,it,fr','Bács-Kiskun,Baranya megye,Békés megye,Borsod-Abaúj-Zemplén,Budapest f?város,Csongrád megye,Fejér,Gy?r-Moson-Sopron,Hajdú-Bihar,Heves megye,Jász-Nagykun-Szolnok,Komárom-Esztergom,Nógrád megye,Pest megye,Somogy megye,Szabolcs-Szatmár-Bereg,Tolna megye,Vas,Veszprém megye,Zala','EU',2,2,'','','','','',''),(98,'Iceland','IS','ISL','354',1,'en','Capital Region,East,Northeast,Northwest,South,Southern Peninsula,West,Westfjords','EU',2,2,'','','','','',''),(99,'India','IN','IND','91',1,'hi,en,ur',' Union Territory of Andaman and Nicobar Islands,Bengal,Bih?r State of,Daman and Diu,Goa,Him?chal Pradesh,Laccadives,State of Andhra Pradesh,State of Arun?chal Pradesh,State of Assam,State of Chhatt?sgarh,State of Gujar?t,State of Hary?na,State of Jammu and Kashm?r,State of Jharkhand,State of Karn?taka,State of Kerala,State of Madhya Pradesh,State of Mah?r?shtra,State of Manipur,State of Megh?laya,State of Mizoram,State of N?g?land,State of Orissa,State of Punjab,State of R?jasth?n,State of Sikkim,State of Tamil N?du,State of Tripura,State of Uttar Pradesh,Union Territory of Chand?garh,Union Territory of D?dra and Nagar Haveli,Union Territory of Delhi,Union Territory of Puducherry,Uttarakhand','AS',2,2,'','','','','',''),(100,'Indonesia','ID','IDN','62',1,'en,nl','Bangka-Belitung,Central Java,Central Sulawesi,Daerah Istimewa Aceh,Daerah Istimewa Yogyakarta,Daerah Khusus Ibukota Jakarta Raya,East Java,East Kalimantan,East Nusa Tenggara,Kotamadya Tegal,North Sulawesi,North Sumatra,Propinsi Bali,Propinsi Banten,Propinsi Bengkulu,Propinsi Jambi,Propinsi Kalimantan Tengah,Propinsi Lampung,Propinsi Maluku,Propinsi Maluku Utara,Propinsi Nusa Tenggara Barat,Propinsi Sulawesi Tenggara,Provinsi Gorontalo,Provinsi Irian Jaya Barat,Provinsi Papua,Provinsi Riau,Provinsi Sulawesi Barat,Riau Islands,South Kalimantan,South Sulawesi,South Sumatra,West Java,West Kalimantan,West Sumatra','AS',2,2,'','','','','',''),(101,'Iran','IR','IRN','98',1,'pr,pr,ar,tr',' ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\", ISLAMIC REPUBLIC OF\"','AS',2,2,'','','','','',''),(102,'Iraq','IQ','IRQ','964',1,'ar','Diyala,Mu??faz?at al Anb?r,Mu??faz?at al Ba?rah,Mu??faz?at al Muthanná,Mu??faz?at al Q?dis?yah,Mu??faz?at an Najaf,Mu??faz?at Arb?l,Mu??faz?at as Sulaym?n?yah,Mu??faz?at at Ta\'m?m,Mu??faz?at B?bil,Mu??faz?at Baghd?d,Mu??faz?at Dah?k,Mu??faz?at Dh? Q?r,Mu??faz?at Karbal?\',Mu??faz?at Mays?n,Mu??faz?at N?nawá,Mu??faz?at ?al?? ad D?n,Mu??faz?at W?si?,Ost?n-e D??leh,Ost?n-e Soleym?n?yeh','AS',2,2,'','','','','',''),(103,'Ireland','IE','IRL','353',1,'en','County Carlow,County Cavan,County Clare,County Cork,County Donegal,County Dublin,County Galway,County Kerry,County Kildare,County Kilkenny,County Laois,County Leitrim,County Limerick,County Longford,County Louth,County Mayo,County Meath,County Monaghan,County Offaly,County Roscommon,County Sligo,County Tipperary,County Waterford,County Westmeath,County Wexford,County Wicklow','EU',2,2,'','','','','',''),(104,'Israel','IL','ISR','972',1,'he,ar,en','Central District,Haifa District,Jerusalem District,Northern District,Southern District,Tel Aviv District','AS',2,2,'','','','','',''),(105,'Italy','IT','ITA','39',1,'fr','Abruzzo,Aosta Valley,Apulia,Basilicate,Calabria,Campania,Friuli,Latium,Liguria,Lombardy,Piedmont,Regione Emilia-Romagna,Regione Molise,Sardinia,Sicily,The Marches,Trentino-Alto Adige,Tuscany,Umbria,Veneto','EU',2,2,'','','','','',''),(106,'Jamaica','JM','JAM','1',1,'en','Hanover Parish,Kingston,Parish of Clarendon,Parish of Manchester,Parish of Portland,Parish of Saint Andrew,Parish of Saint Ann,Parish of Saint Catherine,Parish of Saint Elizabeth,Parish of Saint James,Parish of Saint Mary,Parish of Saint Thomas,Parish of Trelawny,Parish of Westmoreland','NA',2,2,'','','','','',''),(107,'Japan','JP','JPN','81',1,'jp','Aichi-ken,Akita-ken,Aomori-ken,Chiba-ken,Ehime,Fukui-ken,Fukuoka-ken,Fukushima-ken,Gifu-ken,Gumma-ken,Hiroshima-ken,Hokkaid?,Hy?go-ken,Ibaraki-ken,Ishikawa-ken,Iwate-ken,Kagawa-ken,Kagoshima-ken,Kanagawa-ken,K?chi-ken,Kumamoto-ken,Ky?to-fu,Mie-ken,Miyagi-ken,Miyazaki-ken,Nagano-ken,Nagasaki-ken,Nara,Niigata-ken,?ita-ken,Okayama-ken,Okinawa-ken,?saka-fu,Saga-ken,Saitama-ken,Shiga-ken,Shimane-ken,Shizuoka-ken,Tochigi-ken,Tokushima-ken,T?ky?-to,Tottori-ken,Toyama-ken,Wakayama-ken,Yamagata-ken,Yamaguchi-ken,Yamanashi-ken','AS',2,2,'','','','','',''),(108,'Jordan','JO','JOR','962',1,'ar,en','Ajlun,Amman,Aqaba,Balqa,Irbid,Jerash,Karak,Ma\'an,Madaba,Mafraq,Tafielah,Zarqa','AS',2,2,'','','','','',''),(109,'Kazakhstan','KZ','KAZ','7',1,'ru','Akmolinskaya Oblast\',Almatinskaya Oblast\',Aqtöbe Oblysy,Atyra? Oblysy,Batys Qazaqstan Oblysy,East Kazakhstan,Gorod Almaty,Gorod Astana,Köksheta? Oblysy,Kostanayskaya Oblast\',Mangghysta? Oblysy,Pavlodar Oblysy,Qaraghandy Oblysy,Qyzylorda Oblysy,Semey Oblysy,Severo-Kazakhstanskaya Oblast\',Taldyqorghan Oblysy,Torghay Oblysy,Yuzhno-Kazakhstanskaya Oblast\',Zhambyl Oblysy,Zhezqazghan Oblysy','AS',2,2,'','','','','',''),(110,'Kenya','KE','KEN','254',1,'en','Central Province,Coast Province,Eastern,Nairobi Area,North Eastern Province,Nyanza Province,Rift Valley Province,Western Province','AF',2,2,'','','','','',''),(111,'Kiribati','KI','KIR','686',1,'en','Gilbert Islands,Line Islands','OC',2,2,'','','','','',''),(112,'Korea (South)','KP','PRK','82',1,'ko',' DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\", DEMOCRATIC PEOPLE\'S REPUBLIC OF\"','AS',2,2,'','','','','',''),(113,'Korea (North)','KR','KOR','850',1,'ko',' REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\", REPUBLIC OF\"','AS',2,2,'','','','','',''),(114,'Kuwait','KW','KWT','965',1,'ar,en','Al Farwaniyah,Mu??faz?at al `??imah,Mu??faz?at al A?mad?,Mu??faz?at ?awall?,Mu??faz?at Jahr?\',Mu??faz?atalWafrah','AS',2,2,'','','','','',''),(115,'Kyrgyzstan','KG','KGZ','996',1,'ru','Batkenskaya Oblast\',Bishkek Shaary,Chuyskaya Oblast\',Jalal-Abad Oblasty,Narynskaya Oblast\',Oshskaya Oblast\',Talasskaya Oblast\',Ysyk-Köl Oblasty','AS',2,2,'','','','','',''),(116,'Laos','LA','LAO','856',1,'fr,en','Kamphèng Nakhon Viangchan,Khétphisét Xaisômboun,Khouèng Attapu,Khouèng Bokéo,Khouèng Bolikhamxai,Khouèng Champasak,Khouèng Houaphan,Khouèng Khammouan,Khouèng Louangnamtha,Khouèng Louangphrabang,Khouèng Oudômxai,Khouèng Phôngsali,Khouèng Salavan,Khouèng Savannakhét,Khouèng Viangchan,Khouèng Xaignabouli,Khouèng Xékong,Khouèng Xiangkhoang','AS',2,2,'','','','','',''),(117,'Latvia','LV','LVA','371',1,'ru','Aizkraukles Rajons,Al?ksnes Rajons,Balvu Rajons,Bauskas Rajons,C?su Rajons,Daugavpils,Daugavpils Rajons,Dobeles Rajons,Gulbenes Rajons,J?kabpils Rajons,Jelgava,Jelgavas Rajons,J?rmala,Kr?slavas Rajons,Kuld?gas Rajons,Liep?ja,Liep?jas Rajons,Limbažu Rajons,Ludzas Rajons,Madonas Rajons,Ogres Rajons,Prei?u Rajons,R?zekne,R?zeknes Rajons,R?ga,R?gas Rajons,Saldus Rajons,Talsu Rajons,Tukuma Rajons,Valkas Rajons,Valmieras Rajons,Ventspils,Ventspils Rajons','EU',2,2,'','','','','',''),(118,'Lebanon','LB','LBN','961',1,'ar,fr,en','Mohafazat Aakâr,Mohafazat Baalbek-Hermel,Mohafazat Béqaa,Mohafazat Beyrouth,Mohafazat Liban-Nord,Mohafazat Liban-Sud,Mohafazat Mont-Liban,Mohafazat Nabatîyé','AS',2,2,'','','','','',''),(119,'Lesotho','LS','LSO','266',1,'en','Berea District,Butha-Buthe District,Leribe District,Mafeteng District,Maseru District,Mohale\'s Hoek District,Mokhotlong District,Qacha\'s Nek District,Quthing District,Thaba-Tseka District','AF',2,2,'','','','','',''),(120,'Liberia','LR','LBR','231',1,'en','Bomi County,Bong County,Gbarpolu County,Grand Bassa County,Grand Cape Mount County,Grand Gedeh County,Grand Kru County,Lofa County,Margibi County,Maryland County,Montserrado County,Nimba County,River Cess County,River Gee County,Sinoe County','AF',2,2,'','','','','',''),(121,'Libya','LY','LBY','218',1,'ar,it','Balad?yat Ajd?biy?,Balad?yat al `Az?z?yah,Balad?yat al `Ujayl?t,Balad?yat al Aby?r,Balad?yat al Bay??\',Balad?yat al F?ti?,Balad?yat al Jabal al Akh?ar,Balad?yat al Jufrah,Balad?yat al Jumayl,Balad?yat al Khums,Balad?yat al Kufrah,Balad?yat al Marj,Balad?yat al Qar?b?ll,Balad?yat al Qubbah,Balad?yat an Nuq?? al Khams,Balad?yat ash Sh??i\',Balad?yat Awb?r?,Balad?yat az Zahr?\',Balad?yat az Z?wiyah,Balad?yat Bangh?z?,Balad?yat Ban? Wal?d,Balad?yat Bin Jaww?d,Balad?yat Darnah,Balad?yat Ghad?mis,Balad?yat Ghary?n,Balad?yat Gh?t,Balad?yat J?d?,Balad?yat J?l?,Balad?yat Janz?r,Balad?yat Mi?r?tah,Balad?yat Mizdah,Balad?yat Murzuq,Balad?yat N?l?t,Balad?yat Qam?nis,Balad?yat Qa?r Bin Ghash?r,Balad?yat Sabh?,Balad?yat ?abr?tah,Balad?yat Sawfajj?n,Balad?yat Sha???t,Balad?yat ?urm?n,Balad?yat Surt,Balad?yat ?ar?bulus,Balad?yat Tarh?nah,Balad?yat ?ubruq,Balad?yat T?krah,Balad?yat Yafran,Balad?yat Zl??an,Balad?yat Zuw?rah','AF',2,2,'','','','','',''),(122,'Liechtenstein','LI','LIE','423',1,'de','Gemeinde Balzers,Gemeinde Eschen,Gemeinde Gamprin,Gemeinde Mauren,Gemeinde Planken,Gemeinde Ruggell,Gemeinde Schaan,Gemeinde Schellenberg,Gemeinde Triesen,Gemeinde Triesenberg,Gemeinde Vaduz','EU',2,2,'','','','','',''),(123,'Lithuania','LT','LTU','370',1,'ru,pl','Alytaus Apskritis,Kauno Apskritis,Klaip?dos Apskritis,Marijampol?s Apskritis,Panev?žio Apskritis,Šiauli? Apskritis,Taurag?s Apskritis,Telši? Apskritis,Utenos Apskritis,Vilniaus Apskritis','EU',2,2,'','','','','',''),(124,'Luxembourg','LU','LUX','352',1,'de','District de Diekirch,District de Grevenmacher,District de Luxembourg','EU',2,2,'','','','','',''),(126,'Macedonia','MK','MKD','389',1,'sr',' THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\", THE FORMER YUGOSLAV REPUBLIC OF\"','EU',2,2,'','','','','',''),(127,'Madagascar','MG','MDG','261',1,'fr','Faritanin\' Antananarivo,Faritanin\' i Fianarantsoa,Faritanin\' i Mahajanga,Faritanin\' i Toamasina,Faritanin\' i Toliara,Faritany d\' Antsiranana','AF',2,2,'','','','','',''),(128,'Malawi','MW','MWI','265',1,'','Balaka District,Blantyre District,Chikwawa District,Chiradzulu District,Chitipa District,Dedza District,Dowa District,Karonga District,Kasungu District,Likoma District,Lilongwe District,Machinga District,Mangochi District,Mchinji District,Mulanje District,Mwanza District,Mzimba District,Nkhata Bay District,Nkhotakota District,Nsanje District,Ntcheu District,Ntchisi District,Phalombe District,Rumphi District,Salima District,Thyolo District,Zomba District','AF',2,2,'','','','','',''),(129,'Malaysia','MY','MYS','60',1,'zh,en','JHR:Johor,KDH:Kedah,KTN:Kelantan,KUL:Federal Territory of Kuala Lumpur,LBN:Federal Territory of Labuan,MLK:Malacca,NSN:Negeri Sembilan,PHG:Pahang,PJY:Federal Territory of Putrajaya,PLS:Perlis,PNG:Putrajaya,PRK:Perak,SBH:Sabah,SGR:Selangor,SRW:Sarawak,TRG:Terengganu','AS',2,2,'','',',','.','','C'),(130,'Maldives','MV','MDV','960',1,'','Alifu Atholhu,Baa Atholhu,Dhaalu Atholhu,Faafu Atholhu,Gaafu Alifu Atholhu,Gaafu Dhaalu Atholhu,Gnyaviyani Atoll,Haa Alifu Atholhu,Haa Dhaalu Atholhu,Laamu Atholhu,Lhaviyani Atholhu,Maale,Meemu Atholhu,Noonu Atholhu,Raa Atholhu,Seenu Atholhu,Shaviyani Atholhu,Thaa Atholhu,Vaavu Atholhu','AS',2,2,'','','','','',''),(131,'Mali','ML','MLI','223',1,'fr','District de Bamako,Région de Gao,Région de Kayes,Région de Kidal,Région de Koulikoro,Région de Mopti,Région de Ségou,Région de Sikasso,Région de Tombouctou','AF',2,2,'','','','','',''),(132,'Malta','MT','MLT','356',1,'en','','EU',2,2,'','','','','',''),(133,'Marshall Islands','MH','MHL','692',1,'','','OC',2,2,'','','','','',''),(135,'Mauritania','MR','MRT','222',1,'fr','Nouakchott District de,Région de Dakhlet Nouadhibou,Région de l\' Adrar,Région de l\' Assaba,Région de l\' Inchiri,Région du Brakna,Région du Gorgol,Région du Guidimaka,Région du Hodh Ech Chargui,Région du Hodh El Gharbi,Région du Tagant,Région du Tiris Zemmour,Région du Trarza','AF',2,2,'','','','','',''),(136,'Mauritius','MU','MUS','230',1,'fr','Agalega Islands,Black River District,Cargados Carajos,Flacq District,Grand Port District,Moka District,Pamplemousses District,Plaines Wilhems District,Port Louis District,Rivière du Rempart District,Rodrigues,Savanne District','AF',2,2,'','','','','',''),(138,'Mexico','MX','MEX','52',1,'es','Aguascalientes,Baja California Sur,Campeche,Chiapas,Chihuahua,Coahuila,Colima,Durango,Estado de Baja California,Estado de México,Estado de Veracruz-Llave,Guanajuato,Guerrero,Hidalgo,Jalisco,Michoacán,Morelos,Nayarit,Nuevo León,Oaxaca,Puebla,Querétaro,Quintana Roo,San Luis Potosí,Sinaloa,Sonora,Tabasco,Tamaulipas,The Federal District,Tlaxcala,Yucatán,Zacatecas','NA',2,2,'','','','','',''),(139,'Micronesia','FM','FSM','691',1,'en',' FEDERATED STATES OF\", FEDERATED STATES OF\", FEDERATED STATES OF\", FEDERATED STATES OF\"','OC',2,2,'','','','','',''),(140,'Moldova','MD','MDA','373',1,'ru','Balti Judetul,Cahul Judetul,Cainari Raionul,Camenca Raionul,Ceadîr-Lunga Raionul,Comrat Raionul,Edinet Judetul,Grigoriopol Raionul,Lapusna Judetul,Municipiul Bender,Municipiul Chi?in?u,Municipul B?l?i,Orhei Judetul,Raionul Anenii Noi,Raionul Basarabeasca,Raionul Briceni,Raionul Cahul,Raionul C?l?ra?i,Raionul Cantemir,Raionul C?u?eni,Raionul Cimi?lia,Raionul Criuleni,Raionul Dondu?eni,Raionul Drochia,Raionul Dub?sari,Raionul Edine?,Raionul F?le?ti,Raionul Flore?ti,Raionul Glodeni,Raionul Hînce?ti,Raionul Ialoveni,Raionul Leova,Raionul Nisporeni,Raionul Ocni?a,Raionul Orhei,Raionul Rezina,Raionul Rî?cani,Raionul Sîngerei,Raionul ?old?ne?ti,Raionul Soroca,Raionul ?tefan-Vod?,Raionul Str??eni,Raionul Taraclia,Raionul Telene?ti,Raionul Ungheni,Rîbnita Raionul,Slobozia Raionul,Soroca Judetul,Tighina Judetul,Tiraspol Municipiul,Ungheni Judetul,Unitate Teritorial? Autonom? G?g?uzia,Unitatea Teritorial? din Stînga Nistrului,Vulcanes Raionul','EU',2,2,'','','','','',''),(141,'Monaco','MC','MCO','377',1,'fr,en,it','Commune de Monaco','EU',2,2,'','','','','',''),(142,'Mongolia','MN','MNG','976',1,'ru','Arhangay Aymag,Bayanhongor Aymag,Bayan-Ölgiy Aymag,Bulgan Aymag,Central Aymag,Darhan Hot (historical),Dzavhan Aymag,East Gobi Aymag,Eastern,Erdenet Hot (historical),Gov?-Altay Aymag,Gov?-Sumber,Hentiy Aymag,Hovd Aymag,Hövsgöl Aymag,Middle Gov?,Selenge Aymag,South Gobi Aimak,South Hangay,Sühbaatar Aymag,Ulaanbaatar Hot,Uvs Aymag,??????-??? ?????,????? ?????','AS',2,2,'','','','','',''),(144,'Morocco','MA','MAR','212',1,'ar','Laâyoune-Boujdour-Sakia El Hamra,Région de Chaouia-Ouardigha,Région de Doukkala-Abda,Région de Fès-Boulemane,Région de Gharb-Chrarda-Beni Hssen,Région de Guelmim-Es Smara,Région de l\' Oriental,Région de Marrakech-Tensift-Al Haouz,Région de Meknès-Tafilalet,Région de Rabat-Salé-Zemmour-Zaër,Région de Souss-Massa-Drâa,Région de Tadla-Azilal,Région de Tanger-Tétouan,Région de Taza-Al Hoceima-Taounate,Région du Grand Casablanca','AF',2,2,'','','','','',''),(145,'Mozambique','MZ','MOZ','258',1,'pt','Cidade de Maputo,Maputo Province,Província de Cabo Delgado,Província de Gaza,Província de Inhambane,Província de Manica,Província de Nampula,Província de Niassa,Província de Sofala,Província de Tete,Província de Zambézia','AF',2,2,'','','','','',''),(146,'Myanmar','MM','MMR','95',1,'','Ayeyarwady Division,Bago Division,Chin State,Kachin State,Kayah State,Kayin State,Magway Division,Mandalay Division,Mon State,Rakhine State,Sagaing Division,Shan State,Tanintharyi Division,Yangon Division','AS',2,2,'','','','','',''),(147,'Namibia','NA','NAM','264',1,'en','Bethanien,Caprivi,Caprivi Oos,Erongo,Hardap,Kaokoland,Karas,Kavango,Khomas,Kunene,Ohangwena,Okavango,Omaheke,Omusati,Oshana,Oshikoto,Otjiwarongo,Otjozondjupa,Outjo,Owambo','AF',2,2,'','','','','',''),(148,'Nauru','NR','NRU','674',1,'en','','OC',2,2,'','','','','',''),(149,'Nepal','NP','NPL','977',1,'','B?gmat? Zone,Bher? Zone,Dhawal?giri Zone,Gandak? Zone,Janakpur Zone,Karn?l? Zone,Kos? Zone,Lumbin? Zone,Mah?k?l? Zone,Mech? Zone,N?r?yan? Zone,R?pt? Zone,Sagarm?th? Zone,Set? Zone','AS',2,2,'','','','','',''),(150,'Netherlands','NL','NLD','31',1,'nl','North Brabant,North Holland,Provincie Drenthe,Provincie Flevoland,Provincie Friesland,Provincie Gelderland,Provincie Groningen,Provincie Limburg,Provincie Overijssel,Provincie Utrecht,Provincie Zeeland,South Holland','EU',2,2,'','','','','',''),(153,'New Zealand','NZ','NZL','64',1,'en','Auckland,Bay of Plenty,Canterbury,Chatham Islands,Gisborne,Hawkes Bay,Marlborough,Nelson,Otago,Southland,Taranaki,Waikato,Wanganui,Wellington,West Coast,Whangarei','OC',2,2,'','','','','',''),(154,'Nicaragua','NI','NIC','505',1,'','Departamento de Boaco,Departamento de Carazo,Departamento de Chinandega,Departamento de Chontales,Departamento de Estelí,Departamento de Granada,Departamento de Jinotega,Departamento de León,Departamento de Madriz,Departamento de Managua,Departamento de Masaya,Departamento de Matagalpa,Departamento de Nueva Segovia,Departamento de Río San Juan,Departamento de Rivas,Región Autónoma Atlántico Norte,Región Autónoma Atlántico Sur','NA',2,2,'','','','','',''),(155,'Niger','NE','NER','227',1,'fr','Département d\' Agadez,Département de Diffa,Département de Dosso,Département de Maradi,Département de Tahoua,Département de Tillabéri,Département de Zinder,Niamey,Niamey Département de','AF',2,2,'','','','','',''),(156,'Nigeria','NG','NGA','234',1,'en','Abia State,Abuja Federal Capital Territory,Adamawa State,Akwa Ibom State,Anambra State,Bauchi State,Bayelsa State,Bendel State,Benue State,Benue-Plateau State,Borno State,Cross River State,Delta State,East-Central State,Ebonyi State,Ekiti State,Ekpoma,Enugu State,Gombe State,Gongola State,Imo State,Jigawa State,Kaduna State,Kano State,Katsina State,Kebbi State,Kogi State,Kwara State,Lagos State,Nassarawa State,Niger State,North-Eastern State,North-Western State,Ogun State,Ondo State,Osun State,Oyo State,Plateau State,Rivers State,Sokoto State,Taraba State,Western State,Yobe State,Zamfara State','AF',2,2,'','','','','',''),(160,'Norway','NO','NOR','47',1,'','Akershus Fylke,Aust-Agder Fylke,Bouvetøya ,Buskerud Fylke,Finnmark Fylke,Hedmark Fylke,Hordaland Fylke,Jan Mayen,Møre og Romsdal Fylke,Nordland Fylke,Nord-Trøndelag Fylke,Oppland Fylke,Oslo Fylke,Østfold,Rogaland Fylke,Sogn og Fjordane Fylke,Sør-Trøndelag Fylke,Telemark Fylke,Troms Fylke,Vest-Agder Fylke,Vestfold Fylke','EU',2,2,'','','','','',''),(161,'Oman','OM','OMN','968',1,'ar,en,ur','Al Min?aqah ad D?khil?yah,Al Min?aqah al Wus?á,Al Min?aqah ash Sharq?yah,Min?aqat al B??inah,Min?aqat az? Z??hirah,Min?aqat Masqa?,Mu??faz?at Z?uf?r','AS',2,2,'','','','','',''),(162,'Pakistan','PK','PAK','92',1,'ur','Azad Kashmir,Balochist?n,Federally Administered Tribal Areas,Isl?m?b?d Capital Territory,North-West Frontier Province,Punjab,Sind','AS',2,2,'','','','','',''),(163,'Palau','PW','PLW','680',1,'en,tl,zh,jp','Hatohobei State,State of Airai,State of Angaur,State of Koror,State of Melekeok,State of Ngaraard,State of Ngarchelong,State of Ngchesar,State of Ngeremlengui,State of Ngiwal,State of Peleliu','OC',2,2,'','','','','',''),(164,'Panama','PA','PAN','507',1,'es,en','Comarca de San Blas,Provincia de Bocas del Toro,Provincia de Chiriquí,Provincia de Coclé,Provincia de Colón,Provincia de Herrera,Provincia de Los Santos,Provincia de Panamá,Provincia de Veraguas,Provincia del Darién','NA',2,2,'','','','','',''),(165,'Papua New Guinea','PG','PNG','675',1,'','Sandaun Province','OC',2,2,'','','','','',''),(166,'Paraguay','PY','PRY','595',1,'es','Asunción,Departamento Central,Departamento de Alto Paraguay,Departamento de Boquerón,Departamento de Caaguazú,Departamento de Caazapá,Departamento de Canindeyú,Departamento de Concepción,Departamento de Itapúa,Departamento de la Cordillera,Departamento de Misiones,Departamento de Ñeembucú,Departamento de Paraguarí,Departamento de Presidente Hayes,Departamento de San Pedro,Departamento del Alto Paraná,Departamento del Amambay,Departamento del Guairá','SA',2,2,'','','','','',''),(167,'Peru','PE','PER','51',1,'es','Departamento de Amazonas,Departamento de Ancash,Departamento de Apurímac,Departamento de Arequipa,Departamento de Ayacucho,Departamento de Cajamarca,Departamento de Cusco,Departamento de Huancavelica,Departamento de Huánuco,Departamento de Ica,Departamento de Junín,Departamento de La Libertad,Departamento de Lambayeque,Departamento de Lima,Departamento de Loreto,Departamento de Madre de Dios,Departamento de Moquegua,Departamento de Pasco,Departamento de Piura,Departamento de Puno,Departamento de San Martín,Departamento de Tacna,Departamento de Tumbes,Departamento de Ucayali,Provincia Constitucional del Callao','SA',2,2,'','','','','',''),(168,'Philippines','PH','PHL','63',1,'tl','Angeles City,Bacolod City,Bago City,Baguio City,Bais City,Batangas City,Butuan City,Cabanatuan City,Cadiz City,Cagayan de Oro City,Calbayog City,Caloocan City,Canlaon City,Cavite City,Cebu City,Chartered City of Cagayan de Oro,Chartered City of Iligan,Chartered City of Marawi,City of Manila,Cotabato City,Dagupan City,Danao City,Dapitan City,Davao City,Dipolog City,Dumaguete City,Eastern Samar,General Santos City,Gingoog City,Iligan City,Iloilo City,Iriga City,La Carlota City,Laoag City,Lapu-Lapu City,Legaspi City,Lipa City,Lucena City,Mandaue City,Marawi City,Mountain Province,Naga City,Northern Samar,Olongapo City,Ormoc City,Oroquieta City,Ozamis City,Pagadian City,Palayan City,Pasay City,Province of  Zamboanga del Sur,Province of Abra,Province of Agusan del Norte,Province of Agusan del Sur,Province of Aklan,Province of Albay,Province of Antique,Province of Aurora,Province of Basilan,Province of Bataan,Province of Batanes,Province of Batangas,Province of Benguet,Province of Bohol,Province of Bukidnon,Province of Bulacan,Province of Cagayan,Province of Camarines Norte,Province of Camarines Sur,Province of Camiguin,Province of Capiz,Province of Catanduanes,Province of Cavite,Province of Cebu,Province of Davao del Norte,Province of Davao del Sur,Province of Davao Oriental,Province of Ifugao,Province of Ilocos Norte,Province of Ilocos Sur,Province of Iloilo,Province of Isabela,Province of Kalinga-Apayao,Province of La Union,Province of Laguna,Province of Lanao del Norte,Province of Lanao del Sur,Province of Leyte,Province of Maguindanao,Province of Marinduque,Province of Masbate,Province of Mindoro Occidental,Province of Mindoro Oriental,Province of Misamis Occidental,Province of Misamis Oriental,Province of Negros Occidental,Province of Negros Oriental,Province of North Cotabato,Province of Nueva Ecija,Province of Nueva Vizcaya,Province of Palawan,Province of Pampanga,Province of Pangasinan,Province of Quezon,Province of Quirino,Province of Rizal,Province of Romblon,Province of Samar,Province of Siquijor,Province of Sorsogon,Province of South Cotabato,Province of Sultan Kudarat,Province of Sulu,Province of Surigao del Norte,Province of Surigao del Sur,Province of Tarlac,Province of Tawi-Tawi,Province of Zambales,Province of Zamboanga del Norte,Puerto Princesa City,Quezon City,Roxas City,San Carlos City,San Jose City,San Pablo City,Silay City,Southern Leyte,Surigao City,Tacloban City,Tagaytay City,Tagbilaran City,Tangub City,Toledo City,Trece Martires City,Zamboanga City','AS',2,2,'','','','','',''),(170,'Poland','PL','POL','48',1,'pl','Greater Poland Voivodeship,Kuyavian-Pomeranian Voivodeship,Lesser Poland Voivodeship,?ód? Voivodeship,Lower Silesian Voivodeship,Lublin Voivodeship,Lubusz Voivodeship,Masovian Voivodeship,Opole Voivodeship,Podlachian Voivodeship,Pomeranian Voivodeship,Silesian Voivodeship,Subcarpathian Voivodeship,?wi?tokrzyskie Voivodeship,Warmian-Masurian Voivodeship,West Pomeranian Voivodeship','EU',2,2,'','','','','',''),(171,'Portugal','PT','PRT','351',1,'pt','Bragança,Distrito da Guarda,Distrito de Aveiro,Distrito de Beja,Distrito de Braga,Distrito de Castelo Branco,Distrito de Coimbra,Distrito de Évora,Distrito de Faro,Distrito de Leiria,Distrito de Portalegre,Distrito de Santarém,Distrito de Setúbal,Distrito de Viana do Castelo,Distrito de Vila Real,Distrito de Viseu,Distrito do Porto,Lisbon,Região Autónoma da Madeira,Região Autónoma dos Açores','EU',2,2,'','','','','',''),(173,'Qatar','QA','QAT','974',1,'','Balad?yat ad Daw?ah,Balad?yat al Ghuwayr?yah,Balad?yat al Jumayl?yah,Balad?yat al Khawr,Balad?yat al Wakrah,Balad?yat ar Rayy?n,Balad?yat Jaray?n al B??inah,Balad?yat Mad?nat ash Sham?l,Balad?yat Umm Sa`?d,Balad?yat Umm ?al?l','AS',2,2,'','','','','',''),(175,'Romania','RO','ROU','40',1,'ro,de','Jude?ul Alba,Jude?ul Arad,Jude?ul Arge?,Jude?ul Bac?u,Jude?ul Bihor,Jude?ul Bistri?a-N?s?ud,Jude?ul Boto?ani,Jude?ul Br?ila,Jude?ul Bra?ov,Jude?ul Buz?u,Jude?ul C?l?ra?i,Jude?ul Cara?-Severin,Jude?ul Cluj,Jude?ul Constan?a,Jude?ul Covasna,Jude?ul Dâmbovi?a,Jude?ul Dolj,Jude?ul Gala?i,Jude?ul Giurgiu,Jude?ul Gorj,Jude?ul Harghita,Jude?ul Hunedoara,Jude?ul Ialomi?a,Jude?ul Ia?i,Jude?ul Ilfov,Jude?ul Mehedin?i,Jude?ul Mure?,Jude?ul Neam?,Jude?ul Olt,Jude?ul Prahova,Jude?ul S?laj,Jude?ul Satu Mare,Jude?ul Sibiu,Jude?ul Suceava,Jude?ul Teleorman,Jude?ul Timi?,Jude?ul Tulcea,Jude?ul Vâlcea,Jude?ul Vaslui,Jude?ul Vrancea,Maramure?,Municipiul Bucure?ti','EU',2,2,'','','','','',''),(176,'Russia','RU','RUS','7',1,'ru','Aginskiy Buryatskiy Avtonomnyy Okrug,Altayskiy Kray,Amurskaya Oblast\',Arkhangelskaya oblast,Astrakhanskaya Oblast\',Belgorodskaya Oblast\',Belgorodskiy Rayon,Borisovskiy Rayon,Bryanskaya Oblast\',Chechnya,Chelyabinskaya Oblast\',Chitinskaya Oblast\',Chukotskiy Avtonomnyy Okrug,Chuvashia,Dagestan,Evenkiyskiy Avtonomnyy Okrug,Irkutskaya Oblast\',Ivanovskaya Oblast’,Jewish Autonomous Oblast,Kabardino-Balkarskaya Respublika,Kaliningradskaya Oblast\',Kaluzhskaya Oblast’,Kamchatskaya Oblast\',Karachayevo-Cherkesskaya Respublika,Kemerovskaya Oblast\',Khabarovsk Krai,Khanty-Mansiyskiy Avtonomnyy Okrug,Kirovskaya Oblast\',Koryakskiy Avtonomnyy Okrug,Kostromskaya Oblast\',Krasnodarskiy Kray,Krasnoyarskiy Kray,Kurganskaya Oblast\',Kurskaya Oblast\',Leningradskaya Oblast\',Lipetskaya Oblast\',Magadanskaya Oblast\',Moscow,Moskovskaya Oblast\',Murmansk Oblast,Nenetskiy Avtonomnyy Okrug,Nizhegorodskaya Oblast’,Novgorodskaya Oblast\',Novosibirskaya Oblast\',Omskaya Oblast\',Orenburgskaya Oblast\',Orlovskaya Oblast\',Penzenskaya Oblast\',Permskaya Oblast’,Permskiy Kray,Primorskiy Kray,Pskovskaya Oblast\',Respublika Adygeya,Respublika Altay,Respublika Bashkortostan,Respublika Buryatiya,Respublika Ingushetiya,Respublika Kalmykiya,Respublika Kareliya,Respublika Khakasiya,Respublika Komi,Respublika Mariy-El,Respublika Mordoviya,Respublika Sakha (Yakutiya),Respublika Severnaya Osetiya-Alaniya,Respublika Tatarstan,Respublika Tyva,Rostovskaya Oblast\',Ryazanskaya Oblast\',Sakhalinskaya Oblast\',Samarskaya Oblast\',Sankt-Peterburg,Saratovskaya Oblast\',Shebekinskiy Rayon,Smolenskaya Oblast\',Stavropol\'skiy Kray,Sverdlovskaya Oblast\',Tambovskaya Oblast\',Taymyrskiy (Dolgano-Nenetskiy) Avtonomnyy Okrug,Tomskaya Oblast\',Tul\'skaya Oblast\',Tverskaya Oblast’,Tyumenskaya Oblast\',Udmurtskaya Respublika,Ul’yanovskaya Oblast’,Ust\'-Ordynskiy Buryatskiy Avtonomnyy Okrug,Vladimirskaya Oblast\',Volgogradskaya Oblast\',Vologodskaya Oblast\',Voronezhskaya Oblast\',Yamalo-Nenetskiy Avtonomnyy Okrug,Yaroslavskaya Oblast\'','AS',2,2,'','','','','',''),(177,'Rwanda','RW','RWA','250',1,'fr','Eastern Province,Kigali City,Northern Province,Préfecture de Kibuye,Préfecture de Kigali,Préfecture de Ruhengeri,Prefegitura ya Butare,Prefegitura ya Byumba,Prefegitura ya Cyangugu,Prefegitura ya Gikongoro,Prefegitura ya Gisenyi,Prefegitura ya Gitarama,Prefegitura ya Kibungo,Southern Province,Western Province','AF',2,2,'','','','','',''),(178,'Saint Kitts and Nevis','KN','KNA','1',1,'','Christ Church Nichola Town,Saint Anne Sandy Point,Saint George Basseterre,Saint George Gingerland,Saint James Windward,Saint John Capesterre,Saint John Figtree,Saint Mary Cayon,Saint Paul Capesterre,Saint Paul Charlestown,Saint Peter Basseterre,Saint Thomas Lowland,Saint Thomas Middle Island,Trinity Palmetto Point','NA',2,2,'','','','','',''),(179,'Saint Lucia','LC','LCA','1',1,'','Quarter of Anse-la-Raye,Quarter of Castries,Quarter of Choiseul,Quarter of Dauphin,Quarter of Dennery,Quarter of Gros-Islet,Quarter of Laborie,Quarter of Micoud,Quarter of Praslin,Quarter of Soufrière,Quarter of Vieux-Fort','NA',2,2,'','','','','',''),(180,'Saint Vincent and the Grenadines','VC','VCT','1',1,'','Grenadines,Parish of Charlotte,Parish of Saint Andrew,Parish of Saint David,Parish of Saint George,Parish of Saint Patrick','NA',2,2,'','','','','',''),(181,'Samoa','WS','WSM','685',1,'en','','OC',2,2,'','','','','',''),(182,'San Marino','SM','SMR','378',1,'it','Castello di Acquaviva,Castello di Borgo Maggiore,Castello di Domagnano,Castello di Faetano,Castello di Fiorentino,Castello di Montegiardino,Castello di San Marino Città,Castello di Serravalle,Chiesanuova','EU',2,2,'','','','','',''),(183,'Sao Tome and Principe','ST','STP','239',1,'','Príncipe,São Tomé','AF',2,2,'','','','','',''),(184,'Saudi Arabia','SA','SAU','966',1,'ar','Al Min?aqah ash Sharq?yah,Min?aqat `As?r,Min?aqat al B??ah,Min?aqat al Jawf,Min?aqat al Mad?nah,Min?aqat al Qa??m,Min?aqat ar Riy??,Min?aqat ??\'il,Min?aqat J?z?n,Min?aqat Makkah,Min?aqat Najr?n,Min?aqat Tab?k,Northern Borders Region','AS',2,2,'','','','','',''),(185,'Senegal','SN','SEN','221',1,'','Kolda Region,Région de Dakar,Région de Diourbel,Région de Fatick,Région de Kaolack,Région de Louga,Région de Matam,Région de Saint-Louis,Région de Tambacounda,Région de Thiès,Région de Ziguinchor','AF',2,2,'','','','','',''),(186,'Seychelles','SC','SYC','248',1,'en,fr','Anse aux Pins,Anse Boileau,Anse Etoile,Anse Louis,Anse Royale,Au Cap,Baie Lazare,Baie Sainte Anne,Beau Vallon,Bel Air,Bel Ombre,Cascade,English River,Glacis,Grand Anse Mahe,Grand Anse Praslin,Inner Islands,Les Mamelles,Mont Buxton,Mont Fleuri,Plaisance,Pointe Larue,Port Glaud,Roche Caiman,Saint Louis,Takamaka','AF',2,2,'','','','','',''),(187,'Sierra Leone','SL','SLE','232',1,'en','Eastern Province,Northern Province,Southern Province,Western Area','AF',2,2,'','','','','',''),(188,'Singapore','SG','SGP','65',4,'en,ms,zh','','AS',2,2,'','','','','',''),(189,'Slovakia','SK','SVK','421',1,'','Banskobystrický Kraj,Bratislavský Kraj,Košický Kraj,Nitriansky Kraj,Prešovský Kraj,Tren?iansky Kraj,Trnavský Kraj,Žilinský Kraj','EU',2,2,'','','','','',''),(190,'Slovenia','SI','SVN','386',1,'si','Bohinj,Ljubljana,Mestna Ob?ina Celje,Mestna Ob?ina Koper-Capodistria,Mestna Ob?ina Kranj,Mestna Ob?ina Maribor,Mestna Ob?ina Murska Sobota,Mestna Ob?ina Nova Gorica,Mestna Ob?ina Novo Mesto,Mestna Ob?ina Ptuj,Mestna Ob?ina Slovenj Gradec,Mestna Ob?ina Velenje,Ob?ina [historical] Cankova-Tišina,Ob?ina [historical] Destrnik-Trnovska Vas,Ob?ina [historical] Hodoš Šalovci,Ob?ina [historical] Lendava,Ob?ina [historical] Podvelka-Ribnica,Ob?ina Ajdovš?ina,Ob?ina Beltinci,Ob?ina Benedikt,Ob?ina Bistrica ob Sotli,Ob?ina Bled,Ob?ina Bloke,Ob?ina Borovnica,Ob?ina Bovec,Ob?ina Braslov?e,Ob?ina Brda,Ob?ina Brežice,Ob?ina Brezovica,Ob?ina Cankova,Ob?ina Cerklje na Gorenjskem,Ob?ina Cerknica,Ob?ina Cerkno,Ob?ina Cerkvenjak,Ob?ina ?renšovci,Ob?ina ?rna na Koroškem,Ob?ina ?rnomelj,Ob?ina Destrnik,Ob?ina Diva?a,Ob?ina Dobje,Ob?ina Dobrepolje,Ob?ina Dobrna,Ob?ina Dobrova-Horjul-Polhov Gradec,Ob?ina Dobrovnik-Dobronak,Ob?ina Dol pri Ljubljani,Ob?ina Dolenjske Toplice,Ob?ina Domžale,Ob?ina Dornava,Ob?ina Dravograd,Ob?ina Duplek,Ob?ina Gorenja Vas-Poljane,Ob?ina Gorišnica,Ob?ina Gornja Radgona,Ob?ina Gornji Grad,Ob?ina Gornji Petrovci,Ob?ina Grad,Ob?ina Grosuplje,Ob?ina Hajdina,Ob?ina Ho?e-Slivnica,Ob?ina Hodoš-Hodos,Ob?ina Horjul,Ob?ina Hrastnik,Ob?ina Hrpelje-Kozina,Ob?ina Idrija,Ob?ina Ig,Ob?ina Ilirska Bistrica,Ob?ina Ivan?na Gorica,Ob?ina Izola-Isola,Ob?ina Jesenice,Ob?ina Jezersko,Ob?ina Juršinci,Ob?ina Kamnik,Ob?ina Kanal,Ob?ina Kidri?evo,Ob?ina Kobarid,Ob?ina Kobilje,Ob?ina Ko?evje,Ob?ina Komen,Ob?ina Komenda,Ob?ina Kostel,Ob?ina Kozje,Ob?ina Kranjska Gora,Ob?ina Križevci,Ob?ina Krško,Ob?ina Kungota,Ob?ina Kuzma,Ob?ina Laško,Ob?ina Lenart,Ob?ina Lendava-Lendva,Ob?ina Litija,Ob?ina Ljubno,Ob?ina Ljutomer,Ob?ina Logatec,Ob?ina Loška Dolina,Ob?ina Loški Potok,Ob?ina Lovrenc na Pohorju,Ob?ina Lu?e,Ob?ina Lukovica,Ob?ina Majšperk,Ob?ina Markovci,Ob?ina Medvode,Ob?ina Mengeš,Ob?ina Metlika,Ob?ina Mežica,Ob?ina Miklavž na Dravskem Polju,Ob?ina Miren-Kostanjevica,Ob?ina Mirna Pe?,Ob?ina Mislinja,Ob?ina Morav?e,Ob?ina MoravskeToplice,Ob?ina Mozirje,Ob?ina Muta,Ob?ina Naklo,Ob?ina Nazarje,Ob?ina Odranci,Ob?ina Oplotnica,Ob?ina Ormož,Ob?ina Osilnica,Ob?ina Pesnica,Ob?ina Piran-Pirano,Ob?ina Pivka,Ob?ina Pod?etrtek,Ob?ina Podlehnik,Ob?ina Podvelka,Ob?ina Polzela,Ob?ina Postojna,Ob?ina Prebold,Ob?ina Preddvor,Ob?ina Prevalje,Ob?ina Puconci,Ob?ina Ra?e-Fram,Ob?ina Rade?e,Ob?ina Radenci,Ob?ina Radlje ob Dravi,Ob?ina Radovljica,Ob?ina Ravne na Koroškem,Ob?ina Razkrižje,Ob?ina Ribnica,Ob?ina Ribnica na Pohorju,Ob?ina Rogaška Slatina,Ob?ina Rogašovci,Ob?ina Rogatec,Ob?ina Ruše,Ob?ina Šalovci,Ob?ina Selnica ob Dravi,Ob?ina Semi?,Ob?ina Šempeter-Vrtojba,Ob?ina Šen?ur,Ob?ina Šentilj,Ob?ina Šentjernej,Ob?ina Šentjur pri Celju,Ob?ina Sevnica,Ob?ina Sežana,Ob?ina Škocjan,Ob?ina Škofja Loka,Ob?ina Škofljica,Ob?ina Slovenska Bistrica,Ob?ina Slovenske Konjice,Ob?ina Šmarje pri Jelšah,Ob?ina Šmartno ob Paki,Ob?ina Šmartno pri Litiji,Ob?ina Sodražica,Ob?ina Sol?ava,Ob?ina Šoštanj,Ob?ina Starše,Ob?ina Štore,Ob?ina Sveta Ana,Ob?ina Sveti Andraž v Slovenskih Goricah,Ob?ina Sveti Jurij,Ob?ina Tabor,Ob?ina Tišina,Ob?ina Tolmin,Ob?ina Trbovlje,Ob?ina Trebnje,Ob?ina Trnovska Vas,Ob?ina Trži?,Ob?ina Trzin,Ob?ina Turniš?e,Ob?ina Velika Polana,Ob?ina Velike Laš?e,Ob?ina Veržej,Ob?ina Videm,Ob?ina Vipava,Ob?ina Vitanje,Ob?ina Vodice,Ob?ina Vojnik,Ob?ina Vransko,Ob?ina Vrhnika,Ob?ina Vuzenica,Ob?ina Zagorje ob Savi,Ob?ina Žalec,Ob?ina Zavr?,Ob?ina Železniki,Ob?ina Žetale,Ob?ina Žiri,Ob?ina Žirovnica,Ob?ina Zre?e,Ob?ina Žužemberk','EU',2,2,'','','','','',''),(191,'Solomon Islands','SB','SLB','677',1,'en','Central Province,Guadalcanal Province,Isabel Province,Makira Province,Malaita Province,Temotu Province,Western Province','OC',2,2,'','','','','',''),(192,'Somalia','SO','SOM','252',1,'ar,en,it','Gobolka Awdal,Gobolka Bakool,Gobolka Banaadir,Gobolka Bari,Gobolka Bay,Gobolka Galguduud,Gobolka Gedo,Gobolka Hiiraan,Gobolka Mudug,Gobolka Nugaal,Gobolka Sanaag,Gobolka Shabeellaha Hoose,Gobolka Sool,Gobolka Togdheer,Gobolka Woqooyi Galbeed,Lower Juba,Middle Juba,Middle Shabele','AF',2,2,'','','','','',''),(193,'South Africa','ZA','ZAF','27',1,'af,en','Free State,Gauteng,Limpopo Province,Mpumalanga,Province of Eastern Cape,Province of KwaZulu-Natal,Province of Northern Cape,Province of North-West,Province of the Western Cape','AF',2,2,'','','','','',''),(195,'Spain','ES','ESP','34',3,'','Andalusia,Aragon,Autonomous Region of Madrid,Autonomous Region of Navarre,Balearic Islands,Basque Country,Canary Islands,Cantabria,Castille and León,Castille-La Mancha,Catalonia,Ceuta,Estremadura,Galicia,La Rioja,Melilla,Principality of Asturias,Region of Murcia,Valencian Community','EU',2,2,'','','','','',''),(196,'Sri Lanka','LK','LKA','94',1,'','Central Province,North Central Province,North Eastern Province,North Western Province,Province of Sabaragamuwa,Province of Uva,Southern Province,Western Province','AS',2,2,'','','','','',''),(199,'Sudan','SD','SDN','249',1,'ar,en','Al Jazirah,Al Qadarif,Al Wil?yah al Istiw?\'?yah,Al Wil?yah al Wus?á,Al Wil?yah ash Sharq?yah,Ba?r al Ghazal Wilayat,Blue Nile,Central Equatoria,Darfur Wilayat,Eastern Equatoria,Khartoum,Kurdufan Wilayat,Lakes,Northern,Red Sea,Unity,Upper Nile,Western Bahr al Ghazal,White Nile,Wil?yat Gharb al Istiw?\'?yah,Wil?yat Gharb D?rf?r,Wil?yat Gharb Kurduf?n,Wil?yat Jan?b D?rf?r,Wil?yat Jan?b Kurduf?n,Wil?yat Junqal?,Wil?yat Kassal?,Wil?yat Nahr an N?l,Wil?yat Sham?l Ba?r al Ghaz?l,Wil?yat Sham?l D?rf?r,Wil?yat Sham?l Kurduf?n,Wil?yat Sinn?r,Wil?yat Warab','AF',2,2,'','','','','',''),(200,'Suriname','SR','SUR','597',1,'nl','Distrikt Brokopondo,Distrikt Commewijne,Distrikt Coronie,Distrikt Marowijne,Distrikt Nickerie,Distrikt Para,Distrikt Paramaribo,Distrikt Saramacca,Distrikt Sipaliwini,Distrikt Wanica','SA',2,2,'','','','','',''),(202,'Swaziland','SZ','SWZ','268',1,'en','Hhohho District,Lubombo District,Manzini District,Shiselweni District','AF',2,2,'','','','','',''),(203,'Sweden','SE','SWE','46',1,'sv','Blekinge Län,Dalarnas Län,Gävleborgs Län,Gotlands Län,Hallands Län,Jämtlands Län,Jönköpings Län,Kalmar Län,Kronobergs Län,Norrbottens Län,Örebro Län,Östergötlands Län,Skåne Län,Södermanlands Län,Stockholms Län,Uppsala Län,Värmlands Län,Västerbottens Län,Västernorrlands Län,Västmanlands Län,Västra Götalands Län','EU',2,2,'','','','','',''),(204,'Switzerland','CH','CHE','41',1,'de,fr','Canton de Fribourg,Canton de Genève,Canton de Neuchâtel,Canton de Vaud,Canton du Jura,Canton du Valais,Cantone Ticino,Kanton Aargau,Kanton Appenzell Ausserrhoden,Kanton Appenzell Innerrhoden,Kanton Basel-Landschaft,Kanton Basel-Stadt,Kanton Bern,Kanton Glarus,Kanton Graubünden,Kanton Luzern,Kanton Nidwalden,Kanton Obwalden,Kanton Schaffhausen,Kanton Schwyz,Kanton Solothurn,Kanton St. Gallen,Kanton Thurgau,Kanton Uri,Kanton Zürich,Kanton Zug','EU',2,2,'','','','','',''),(205,'Syria','SY','SYR','963',1,'','Aleppo,Al-Hasakah,Ar-Raqqah,As-Suwayda,Damascus City,Daraa,Deir ez-Zor,Hama Governorate,Homs,Idlib,Latakia,Quneitra,Rif-dimashq,Tartus','AS',2,2,'','','','','',''),(207,'Tajikistan','TJ','TJK','992',1,'','Gorno-Badakhshan,Kulyabskaya Oblast\',Kurgan-Tyubinskaya Oblast\',Region of Republican Subordination,Viloyati Khatlon,Viloyati Sughd','AS',2,2,'','','','','',''),(208,'Tanzania','TZ','TZA','255',1,'',' UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\", UNITED REPUBLIC OF\"','AF',2,2,'','','','','',''),(209,'Thailand','TH','THA','66',1,'th,en','Bangkok,Changawat Chanthaburi,Changwat Amnat Charoen,Changwat Ang Thong,Changwat Buriram,Changwat Chachoengsao,Changwat Chai Nat,Changwat Chaiyaphum,Changwat Chiang Mai,Changwat Chiang Rai,Changwat Chon Buri,Changwat Chumphon,Changwat Kalasin,Changwat Kamphaeng Phet,Changwat Kanchanaburi,Changwat Khon Kaen,Changwat Krabi,Changwat Lampang,Changwat Lamphun,Changwat Loei,Changwat Lop Buri,Changwat Mae Hong Son,Changwat Maha Sarakham,Changwat Mukdahan,Changwat Nakhon Nayok,Changwat Nakhon Pathom,Changwat Nakhon Phanom,Changwat Nakhon Ratchasima,Changwat Nakhon Sawan,Changwat Nakhon Si Thammarat,Changwat Nan,Changwat Narathiwat,Changwat Nong Bua Lamphu,Changwat Nong Khai,Changwat Nonthaburi,Changwat Pathum Thani,Changwat Pattani,Changwat Phangnga,Changwat Phatthalung,Changwat Phayao,Changwat Phetchabun,Changwat Phetchaburi,Changwat Phichit,Changwat Phitsanulok,Changwat Phra Nakhon,Changwat Phra Nakhon Si Ayutthaya,Changwat Phrae,Changwat Phuket,Changwat Prachin Buri,Changwat Prachuap Khiri Khan,Changwat Ranong,Changwat Ratchaburi,Changwat Rayong,Changwat Roi Et,Changwat Sa Kaeo,Changwat Sakon Nakhon,Changwat Samut Prakan,Changwat Samut Sakhon,Changwat Samut Songkhram,Changwat Sara Buri,Changwat Satun,Changwat Sing Buri,Changwat Sisaket,Changwat Songkhla,Changwat Sukhothai,Changwat Suphan Buri,Changwat Surat Thani,Changwat Surin,Changwat Tak,Changwat Trang,Changwat Trat,Changwat Ubon Ratchathani,Changwat Udon Thani,Changwat Uthai Thani,Changwat Uttaradit,Changwat Yala,Changwat Yasothon','AS',2,2,'','','','','',''),(210,'Togo','TG','TGO','228',1,'','Région Centrale,Région de la Kara,Région des Plateaux,Région des Savanes,Région Maritime','AF',2,2,'','','','','',''),(212,'Tonga','TO','TON','676',1,'en','','OC',2,2,'','','','','',''),(213,'Trinidad and Tobago','TT','TTO','1',1,'en,hi,fr,es,zh','Arima,County of Caroni,County of Mayaro,County of Nariva,County of Saint Andrew,County of Saint David,County of Saint George,County of Saint Patrick,County of Victoria,Port-of-Spain,San Fernando,Ward of Tobago','NA',2,2,'','','','','',''),(214,'Tunisia','TN','TUN','216',1,'ar,fr','Gouvernorat de Ariana,Gouvernorat de Béja,Gouvernorat de Ben Arous,Gouvernorat de Bizerte,Gouvernorat de Gabès,Gouvernorat de Gafsa,Gouvernorat de Jendouba,Gouvernorat de Kairouan,Gouvernorat de Kasserine,Gouvernorat de Kebili,Gouvernorat de Kef,Gouvernorat de la Manouba,Gouvernorat de Mahdia,Gouvernorat de Médenine,Gouvernorat de Monastir,Gouvernorat de Nabeul,Gouvernorat de Sfax,Gouvernorat de Sidi Bou Zid,Gouvernorat de Siliana,Gouvernorat de Sousse,Gouvernorat de Tataouine,Gouvernorat de Tozeur,Gouvernorat de Tunis,Gouvernorat de Zaghouan,Tunis al Janubiyah Wilayat','AF',2,2,'','','','','',''),(215,'Turkey','TR','TUR','90',1,'tr','Adana Province,Ad?yaman,Afyonkarahisar,A?r? Province,Aksaray Province,Amasya Province,Ankara Province,Antalya Province,Ardahan Province,Artvin Province,Ayd?n Province,Bal?kesir Province,Bart?n Province,Batman Province,Bayburt,Bilecik Province,Bingöl Province,Bitlis Province,Bolu Province,Burdur Province,Bursa,Çanakkale Province,Çank?r? Province,Çorum Province,Denizli Province,Diyarbak?r,Düzce,Edirne Province,Elaz??,Erzincan Province,Erzurum Province,Gaziantep Province,Giresun Province,Gümü?hane,Hakkâri Province,Hatay Province,I?d?r Province,Isparta Province,Istanbul,?zmir,Kahramanmara? Province,Karabük,Karaman Province,Kars,Kastamonu Province,Kayseri Province,Kilis Province,K?r?kkale Province,K?rklareli Province,K?r?ehir Province,Kocaeli Province,Konya Province,Kütahya Province,Malatya Province,Manisa Province,Mardin Province,Mersin Province,Mu?la Province,Mu? Province,Nev?ehir,Ni?de,Ordu,Osmaniye Province,Rize,Sakarya Province,Samsun Province,?anl?urfa Province,Siirt Province,Sinop Province,??rnak Province,Sivas Province,Tekirda? Province,Tokat,Trabzon Province,Tunceli Province,U?ak Province,Van Province,Yalova Province,Yozgat Province,Zonguldak','AS',2,2,'','','','','',''),(216,'Turkmenistan','TM','TKM','993',1,'','Ahal Welaýaty,Balkan Welaýaty,Da?oguz Welaýaty,Lebap Welaýaty,Mary Welaýaty','AS',2,2,'','','','','',''),(218,'Tuvalu','TV','TUV','688',1,'en','','OC',2,2,'','','','','',''),(219,'Uganda','UG','UGA','256',1,'en,ar','Apac District,Arua District,Bugiri District,Bundibugyo District,Bushenyi District,Busia District,Busoga Province,Eastern Province,Gulu District,Hoima District,Iganga District,Jinja District,Kabale District,Kabarole District,Kaberamaido District,Kalangala District,Kampala District,Kamuli District,Kamwenge District,Kanungu District,Kapchorwa District,Kasese District,Katakwi District,Kayunga District,Kibale District,Kiboga District,Kisoro District,Kitgum District,Kotido District,Kumi District,Kyenjojo District,Lira District,Luwero District,Masaka District,Masindi District,Mayuge District,Mbale District,Mbarara District,Moroto,Moroto District,Moyo District,Mpigi District,Mubende District,Mukono District,Nakapiripirit District,Nakasongola District,Nebbi District,Nile Province,North Buganda Province,Northern Province,Ntungamo District,Pader District,Pallisa District,Rakai District,Rukungiri District,Sembabule District,Sironko District,Soroti District,Southern Province,Tororo District,Wakiso District,Western Province,Yumbe District','AF',2,2,'','','','','',''),(220,'Ukraine','UA','UKR','380',1,'ru,ro,pl','Avtonomna Respublika Krym,Cherkas\'ka Oblast\',Chernihivs\'ka Oblast\',Chernivets\'ka Oblast\',Dnipropetrovs\'ka Oblast\',Donets\'ka Oblast\',Ivano-Frankivs\'ka Oblast\',Kharkivs\'ka Oblast\',Kherson Oblast,Khmel\'nyts\'ka Oblast\',Kiev Oblast,Kirovohrads\'ka Oblast\',Luhans\'ka Oblast\',L\'vivs\'ka Oblast\',Misto Kyyiv,Misto Sevastopol\',Mykolayivs\'ka Oblast\',Odessa Oblast,Poltava Oblast,Rivnens\'ka Oblast\',Sumy Oblast,Ternopil\'s\'ka Oblast\',Vinnyts\'ka Oblast\',Volyns\'ka Oblast\',Zakarpats\'ka Oblast\',Zaporiz\'ka Oblast\',Zhytomyrs\'ka Oblast\'','EU',2,2,'','','','','',''),(221,'United Arab Emirates','AE','ARE','971',1,'ar,pr,en,hi,ur','`Ajm?n,Ab? Z?aby,Al Fujayrah,Ash Sh?riqah,Dubayy,Ra\'s al Khaymah,Umm al Qaywayn','AS',2,2,'','','','','',''),(222,'United Kingdom','GB','GBR','44',1,'en','England,Northern Ireland,Scotland,Wales','EU',2,2,'','','','','',''),(223,'United States','US','USA','1',2,'en,es','CA:California,AZ:Arizona,AR:Arkansas,AL:Alabama,AK:Alaska,CO:Colorado,CT:Connecticut,DC:Washington DC,DE:Delaware,FL:Florida,GA:Georgia,HI:Hawaii,IA:Iowa,ID:Idaho,IL:Illinois,IN:Indiana,KS:Kansas,KY:Kentucky,LA:Louisiana,MA:Massachusetts,ME:Maine,MI:Michigan,MN:Minnesota,MO:Missouri,MS:Mississippi,MT:Montana,NC:North Carolina,ND:North Dakota,NE:Nebraska,NH:New Hampshire,NJ:New Jersey,NM:New Mexico,NV:Nevada,NY:New York,OH:Ohio,OK:Oklahoma,OR:Oregon,PA:Pennsylvania,PR:Puerto Rico,RI:Rhode Island,SC:South Carolina,SD:South Dakota,TN:Tennessee,TX:Texas,UT:Utah,VA:Virginia,VT:Vermont,WA:Washington,WI:Wisconsin,WV:West Virginia,WY:Wyoming,MD:Maryland','NA',2,2,'','','','','',''),(225,'Uruguay','UY','URY','598',1,'es','Artigas Department,Canelones Department,Cerro Largo Department,Colonia Department,Departamento de Durazno,Departamento de Flores,Departamento de Montevideo,Departamento de Paysandú,Departamento de Río Negro,Departamento de Rivera,Departamento de Rocha,Departamento de Salto,Departamento de San José,Departamento de Tacuarembó,Departamento de Treinta y Tres,Florida Department,Lavalleja Department,Maldonado Department,Soriano Department','SA',2,2,'','','','','',''),(226,'Uzbekistan','UZ','UZB','998',1,'ru','Andijon Viloyati,Buxoro Viloyati,Farg`ona Viloyati,Jizzax Viloyati,Karakalpakstan,Namangan Viloyati,Navoiy Viloyati,Qashqadaryo Viloyati,Samarqand Viloyati,Sirdaryo Viloyati,Surxondaryo Viloyati,Toshkent Shahri,Toshkent Viloyati,Xorazm Viloyati','AS',2,2,'','','','','',''),(227,'Vanuatu','VU','VUT','678',1,'en','Ambrym,Aoba/Maéwo,Éfaté,Épi,Malakula,Malampa Province,Paama,Penama Province,Pentecôte,Sanma Province,Shefa Province,Shepherd,Tafea Province,Torba Province','OC',2,2,'','','','','',''),(228,'Vatican City','VA','VAT','39',1,'','','EU',2,2,'','','','','',''),(229,'Venezuela','VE','VEN','58',1,'es','Dependencias Federales,Distrito Federal,Estado Amazonas,Estado Anzoátegui,Estado Apure,Estado Aragua,Estado Barinas,Estado Bolívar,Estado Carabobo,Estado Cojedes,Estado Falcón,Estado Guárico,Estado Lara,Estado Mérida,Estado Miranda,Estado Monagas,Estado Portuguesa,Estado Sucre,Estado Táchira,Estado Trujillo,Estado Vargas,Estado Yaracuy,Estado Zulia,Isla Margarita,Territorio Federal Delta Amacuro','SA',2,2,'','','','','',''),(230,'Viet Nam','VN','VNM','84',1,'','B?c Thái T?nh,H?i Hung T?nh,Hà B?c T?nh,Minh H?i T?nh,Nam Hà T?nh,Qu?ng Nam-Ðà N?ng T?nh,Sông Bé T?nh,Thành Ph? H?i Phòng,Thành ph? H? Chí Minh,Th? Ðô Hà N?i,T?nh An Giang,T?nh Bà R?a-V?ng Tàu,T?nh B?c Giang,T?nh B?c K?n,T?nh B?c Liêu,T?nh B?c Ninh,T?nh B?n Tre,T?nh Bình Ð?nh,T?nh Bình D??ng,T?nh Bình Ph??c,T?nh Bình Thu?n,T?nh Cà Mau,T?nh C?n Th?,T?nh Cao B?ng,T?nh Ðà N?ng,T?nh Ð?c L?k,T?nh Ð?ng Nai,T?nh Ð?ng Tháp,T?nh Gia Lai,T?nh Hà Giang,T?nh Hà Nam,T?nh Hà Tây,T?nh Hà T?nh,T?nh H?i D??ng,T?nh Hòa Bình,T?nh H?ng Yên,T?nh Khánh Hòa,T?nh Ki?n Giang,T?nh Kon Tum,T?nh Lai Châu,T?nh Lâm Ð?ng,T?nh L?ng S?n,T?nh Lào Cai,T?nh Long An,T?nh Nam Ð?nh,T?nh Ngh? An,T?nh Ninh Bình,T?nh Ninh Thu?n,T?nh Phú Th?,T?nh Phú Yên,T?nh Qu?ng Bình,T?nh Qu?ng Nam,T?nh Qu?ng Ngãi,T?nh Qu?ng Ninh,T?nh Qu?ng Tr?,T?nh Sóc Tr?ng,T?nh S?n La,T?nh Tây Ninh,T?nh Thái Bình,T?nh Thái Nguyên,T?nh Thanh Hóa,T?nh Th?a Thiên-Hu?,T?nh Ti?n Giang,T?nh Trà Vinh,T?nh Tuyên Quang,T?nh V?nh Long,T?nh V?nh Phúc,T?nh Yên Bái,Vinh Phú T?nh','AS',2,2,'','','','','',''),(235,'Yemen','YE','YEM','967',1,'ar','Aden Municipality,Mu??faz?at `Adan,Mu??faz?at Abyan,Mu??faz?at a? ??li`,Mu??faz?at al Bay??\',Mu??faz?at al ?udaydah,Mu??faz?at al Jawf,Mu??faz?at al Mahrah,Mu??faz?at al Ma?w?t,Mu??faz?at ?a?ramawt,Mu??faz?at ?ajjah,Mu??faz?at Ibb,Mu??faz?at La?ij,Mu??faz?at Shabwah,Mu??faz?at Ta`izz,Omran,Qa??\' al ?udaydah','AS',2,2,'','','','','',''),(242,'South Sudan','CX','SCX','211',1,'','','',2,2,'','','','','',''),(241,'Montenegro','CS','SCG','382',1,'','','EU',2,2,'','','','','',''),(238,'Zambia','ZM','ZMB','260',1,'','Central Province,Copperbelt Province,Eastern Province,Luapula Province,Lusaka Province,Northern Province,North-Western Province,Southern Province,Western Province','AF',2,2,'','','','','',''),(239,'Zimbabwe','ZW','ZWE','263',1,'en','Bulawayo Province,Harare Province,Manicaland Province,Mashonaland Central Province,Mashonaland East Province,Mashonaland West Province,Masvingo Province,Matabeleland North Province,Matabeleland South Province,Midlands Province','AF',2,2,'','','','','',''),(243,'Hong Kong','HK','HKG','852',1,'en, zh',NULL,'AS',2,2,'','','','','',''),(245,'Aruba','AW','ABW','297',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(246,'Ascension Island','SH','SHN','247',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(247,'British Indian Ocean Territory','IO','IOT','246',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(248,'Congo- Democratic Republic of the','CD','COD','243',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(249,'Cook Islands','CK','COK','682',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(250,'Falkland Islands','FK','FLK','500',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(251,'Faroe Islands','FO','FRO','298',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(252,'French Guiana','GF','GUF','594',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(253,'French Polynesia','PF','PYF','689',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(254,'French Southern and Antarctic Lands','TF','ATF','262',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(255,'Gibraltar','GI','GIB','350',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(256,'Greenland','GL','GRL','299',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(257,'Guadeloupe','GP','GLP','590',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(258,'Macao','MO','MAC','853',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(259,'Martinique','MQ','MTQ','596',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(260,'Netherlands Antilles','NL','NLD','599',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(261,'New Caledonia','NC','NCL','687',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(262,'Niue','NU','NIU','683',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(263,'Norfolk Island','NF','NFK','672',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(264,'Palestine','PS','PSE','970',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(265,'Pitcairn','PN','PCN','872',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(266,'Reunion','RE','REU','262',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(267,'Saint Helena','SH','SHN','290',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(268,'Saint Pierre and Miquelon','PM','SPM','508',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(269,'Serbia','RS','SRB','381',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(270,'Taiwan','TW','TWN','886',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(271,'Tokelau','TK','TKL','690',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(272,'Tristan da Cunha','SH','SHN','290',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(273,'United States Minor Outlying Islands','UM','UMI','699',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(274,'Wallis and Futuna Islands','WF','WLF','681',0,NULL,NULL,'',2,2,'$','ISO-8859-1',',','.','','F'),(275,'Bermuda ','BM','BMU','1 4',1,'en,pt,es','Devonshire,Hamilton,Paget,Pembroke,Sandys,Smith\'s,Southampton,St George\'s,Warwick,Hamilton,St George\'s','NA',2,2,'','','','','','');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coupons`
--

DROP TABLE IF EXISTS `coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coupons` (
  `id` int(11) NOT NULL auto_increment,
  `coupon_code` varchar(50) NOT NULL default '',
  `percent_discount` decimal(6,2) NOT NULL default '0.00',
  `dollars_discount` decimal(19,5) NOT NULL default '0.00000',
  `description` varchar(255) NOT NULL default '',
  `expirationdate` date default NULL,
  `maxdollars` decimal(19,6) NOT NULL default '0.000000',
  `useroverride` int(5) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` date default NULL,
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coupons`
--

LOCK TABLES `coupons` WRITE;
/*!40000 ALTER TABLE `coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `courtfiling`
--

DROP TABLE IF EXISTS `courtfiling`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `courtfiling` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `invoicenumber` varchar(30) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `description` text,
  `datefiled` date default NULL,
  `amountfiled` decimal(19,6) NOT NULL default '0.000000',
  `status` int(11) NOT NULL default '-1',
  `judgmentamount` decimal(19,6) NOT NULL default '0.000000',
  `judgmentdate` date default NULL,
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `invoiceid` (`invoiceid`),
  KEY `datefiled` (`datefiled`),
  KEY `status` (`status`),
  KEY `judgmentdate` (`judgmentdate`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `courtfiling`
--

LOCK TABLES `courtfiling` WRITE;
/*!40000 ALTER TABLE `courtfiling` DISABLE KEYS */;
/*!40000 ALTER TABLE `courtfiling` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cron`
--

DROP TABLE IF EXISTS `cron`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cron` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(45) default NULL,
  `min` tinytext,
  `hr` tinytext,
  `day` tinytext,
  `month` tinytext,
  `event` mediumtext,
  `lastrun` datetime default NULL,
  `companyid` varchar(45) NOT NULL default '0',
  `cancel` tinyint(4) NOT NULL default '0',
  `lastelapsedtime` float NOT NULL default '0',
  `lastoutput` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cron`
--

LOCK TABLES `cron` WRITE;
/*!40000 ALTER TABLE `cron` DISABLE KEYS */;
/*!40000 ALTER TABLE `cron` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `currencies_id` int(5) NOT NULL auto_increment,
  `title` varchar(32) NOT NULL default '',
  `code` char(3) NOT NULL default '',
  `symbol_left` varchar(12) default NULL,
  `symbol_right` varchar(12) default NULL,
  `decimal_point` char(1) default NULL,
  `thousands_point` char(1) default NULL,
  `decimal_places` char(1) default NULL,
  PRIMARY KEY  (`currencies_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencies`
--

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'US Dollar','USD','$','USD','.',',','2'),(2,'EURO','EUR','.','.',',','.','2'),(3,'Peso','PS','.','.','.','.','2');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currency` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `symbolbefore` varchar(10) NOT NULL default '',
  `symbolafter` varchar(10) NOT NULL default '',
  `standard` int(11) NOT NULL default '0',
  `decimalplaces` int(11) NOT NULL default '2',
  `unitdecimalplaces` int(11) NOT NULL default '5',
  `active` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `decimalsymbol` varchar(2) NOT NULL default '.',
  `thousandssymbol` varchar(2) NOT NULL default ',',
  `glaccountid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currency`
--

LOCK TABLES `currency` WRITE;
/*!40000 ALTER TABLE `currency` DISABLE KEYS */;
INSERT INTO `currency` VALUES (1,'AED','United Arab Emirates, Dirhams','','AED',1,2,5,0,0,'.',',',0),(2,'AFN','Afghanistan, Afghanis','','AFN',1,2,5,0,0,'.',',',0),(3,'ALL','Albania, Leke','','ALL',1,2,5,0,0,'.',',',0),(4,'AMD','Armenia, Drams','','AMD',1,2,5,0,0,'.',',',0),(5,'ANG','Netherlands Antilles, Guilders (Florins)','','ANG',1,2,5,0,0,'.',',',0),(6,'AOA','Angola, Kwanza','','AOA',1,2,5,0,0,'.',',',0),(7,'ARS','Argentina, Pesos','','ARS',1,2,5,0,0,'.',',',0),(8,'AUD','Australia, Dollars','','AUD',1,2,5,0,0,'.',',',0),(9,'AWG','Aruba, Guilders (Florins)','','AWG',1,2,5,0,0,'.',',',0),(10,'AZN','Azerbaijan, New Manats','','AZN',1,2,5,0,0,'.',',',0),(11,'BAM','Bosnia and Herzegovina, Convertible Marka','','BAM',1,2,5,0,0,'.',',',0),(12,'BBD','Barbados, Dollars','','BBD',1,2,5,0,0,'.',',',0),(13,'BDT','Bangladesh, Taka','','BDT',1,2,5,0,0,'.',',',0),(14,'BGN','Bulgaria, Leva','','BGN',1,2,5,0,0,'.',',',0),(15,'BHD','Bahrain, Dinars','','BHD',1,2,5,0,0,'.',',',0),(16,'BIF','Burundi, Francs','','BIF',1,2,5,0,0,'.',',',0),(17,'BMD','Bermuda, Dollars','','BMD',1,2,5,0,0,'.',',',0),(18,'BND','Brunei Darussalam, Dollars','','BND',1,2,5,0,0,'.',',',0),(19,'BOB','Bolivia, Bolivianos','','BOB',1,2,5,0,0,'.',',',0),(20,'BRL','Brazil, Brazil Real','','BRL',1,2,5,0,0,'.',',',0),(21,'BSD','Bahamas, Dollars','','BSD',1,2,5,0,0,'.',',',0),(22,'BTN','Bhutan, Ngultrum','','BTN',1,2,5,0,0,'.',',',0),(23,'BWP','Botswana, Pulas','','BWP',1,2,5,0,0,'.',',',0),(24,'BYR','Belarus, Rubles','','BYR',1,2,5,0,0,'.',',',0),(25,'BZD','Belize, Dollars','','BZD',1,2,5,0,0,'.',',',0),(26,'CAD','Canada, Dollars','','CAD',1,2,5,0,0,'.',',',0),(27,'CDF','Congo/Kinshasa, Congolese Francs','','CDF',1,2,5,0,0,'.',',',0),(28,'CHF','Switzerland, Francs','','CHF',1,2,5,0,0,'.',',',0),(29,'CLP','Chile, Pesos','','CLP',1,2,5,0,0,'.',',',0),(30,'CNY','China, Yuan Renminbi','','CNY',1,2,5,0,0,'.',',',0),(31,'COP','Colombia, Pesos','','COP',1,2,5,0,0,'.',',',0),(32,'CRC','Costa Rica, Colones','','CRC',1,2,5,0,0,'.',',',0),(33,'CUP','Cuba, Pesos','','CUP',1,2,5,0,0,'.',',',0),(34,'CVE','Cape Verde, Escudos','','CVE',1,2,5,0,0,'.',',',0),(36,'CZK','Czech Republic, Koruny','','CZK',1,2,5,0,0,'.',',',0),(37,'DJF','Djibouti, Francs','','DJF',1,2,5,0,0,'.',',',0),(38,'DKK','Denmark, Kroner','','DKK',1,2,5,0,0,'.',',',0),(39,'DOP','Dominican Republic, Pesos','','DOP',1,2,5,0,0,'.',',',0),(40,'DZD','Algeria, Algeria Dinars','','DZD',1,2,5,0,0,'.',',',0),(41,'EEK','Estonia, Krooni','','EEK',1,2,5,0,0,'.',',',0),(42,'EGP','Egypt, Pounds','','EGP',1,2,5,0,0,'.',',',0),(43,'ERN','Eritrea, Nakfa','','ERN',1,2,5,0,0,'.',',',0),(44,'ETB','Ethiopia, Birr','','ETB',1,2,5,0,0,'.',',',0),(45,'EUR','Euro Member Countries, Euro','','EUR',1,2,5,1,0,'.',',',0),(46,'FJD','Fiji, Dollars','','FJD',1,2,5,0,0,'.',',',0),(47,'FKP','Falkland Islands (Malvinas), Pounds','','FKP',1,2,5,0,0,'.',',',0),(48,'GBP','United Kingdom, Pounds','','GBP',1,2,5,1,0,'.',',',0),(49,'GEL','Georgia, Lari','','GEL',1,2,5,0,0,'.',',',0),(50,'GGP','Guernsey, Pounds','','GGP',1,2,5,0,0,'.',',',0),(51,'GHS','Ghana, Cedis','','GHS',1,2,5,0,0,'.',',',0),(52,'GIP','Gibraltar, Pounds','','GIP',1,2,5,0,0,'.',',',0),(53,'GMD','Gambia, Dalasi','','GMD',1,2,5,0,0,'.',',',0),(54,'GNF','Guinea, Francs','','GNF',1,2,5,0,0,'.',',',0),(55,'GTQ','Guatemala, Quetzales','','GTQ',1,2,5,0,0,'.',',',0),(56,'GYD','Guyana, Dollars','','GYD',1,2,5,0,0,'.',',',0),(57,'HKD','Hong Kong, Dollars','','HKD',1,2,5,0,0,'.',',',0),(58,'HNL','Honduras, Lempiras','','HNL',1,2,5,0,0,'.',',',0),(59,'HRK','Croatia, Kuna','','HRK',1,2,5,0,0,'.',',',0),(60,'HTG','Haiti, Gourdes','','HTG',1,2,5,0,0,'.',',',0),(61,'HUF','Hungary, Forint','','HUF',1,2,5,0,0,'.',',',0),(62,'IDR','Indonesia, Rupiahs','','IDR',1,2,5,0,0,'.',',',0),(63,'ILS','Israel, New Shekels','','ILS',1,2,5,0,0,'.',',',0),(64,'IMP','Isle of Man, Pounds','','IMP',1,2,5,0,0,'.',',',0),(65,'INR','India, Rupees','','INR',1,2,5,0,0,'.',',',0),(66,'IQD','Iraq, Dinars','','IQD',1,2,5,0,0,'.',',',0),(67,'IRR','Iran, Rials','','IRR',1,2,5,0,0,'.',',',0),(68,'ISK','Iceland, Kronur','','ISK',1,2,5,0,0,'.',',',0),(69,'JEP','Jersey, Pounds','','JEP',1,2,5,0,0,'.',',',0),(70,'JMD','Jamaica, Dollars','','JMD',1,2,5,0,0,'.',',',0),(71,'JOD','Jordan, Dinars','','JOD',1,2,5,0,0,'.',',',0),(72,'JPY','Japan, Yen','','JPY',1,2,5,0,0,'.',',',0),(73,'KES','Kenya, Shillings','','KES',1,2,5,0,0,'.',',',0),(74,'KGS','Kyrgyzstan, Soms','','KGS',1,2,5,0,0,'.',',',0),(75,'KHR','Cambodia, Riels','','KHR',1,2,5,0,0,'.',',',0),(76,'KMF','Comoros, Francs','','KMF',1,2,5,0,0,'.',',',0),(77,'KPW','Korea (North), Won','','KPW',1,2,5,0,0,'.',',',0),(78,'KRW','Korea (South), Won','','KRW',1,2,5,0,0,'.',',',0),(79,'KWD','Kuwait, Dinars','','KWD',1,2,5,0,0,'.',',',0),(80,'KYD','Cayman Islands, Dollars','','KYD',1,2,5,0,0,'.',',',0),(81,'KZT','Kazakhstan, Tenge','','KZT',1,2,5,0,0,'.',',',0),(82,'LAK','Laos, Kips','','LAK',1,2,5,0,0,'.',',',0),(83,'LBP','Lebanon, Pounds','','LBP',1,2,5,0,0,'.',',',0),(84,'LKR','Sri Lanka, Rupees','','LKR',1,2,5,0,0,'.',',',0),(85,'LRD','Liberia, Dollars','','LRD',1,2,5,0,0,'.',',',0),(86,'LSL','Lesotho, Maloti','','LSL',1,2,5,0,0,'.',',',0),(87,'LTL','Lithuania, Litai','','LTL',1,2,5,0,0,'.',',',0),(88,'LVL','Latvia, Lati','','LVL',1,2,5,0,0,'.',',',0),(89,'LYD','Libya, Dinars','','LYD',1,2,5,0,0,'.',',',0),(90,'MAD','Morocco, Dirhams','','MAD',1,2,5,0,0,'.',',',0),(91,'MDL','Moldova, Lei','','MDL',1,2,5,0,0,'.',',',0),(92,'MGA','Madagascar, Ariary','','MGA',1,2,5,0,0,'.',',',0),(93,'MKD','Macedonia, Denars','','MKD',1,2,5,0,0,'.',',',0),(94,'MMK','Myanmar (Burma), Kyats','','MMK',1,2,5,0,0,'.',',',0),(95,'MNT','Mongolia, Tugriks','','MNT',1,2,5,0,0,'.',',',0),(96,'MOP','Macau, Patacas','','MOP',1,2,5,0,0,'.',',',0),(97,'MRO','Mauritania, Ouguiyas','','MRO',1,2,5,0,0,'.',',',0),(99,'MUR','Mauritius, Rupees','','MUR',1,2,5,0,0,'.',',',0),(100,'MVR','Maldives (Maldive Islands), Rufiyaa','','MVR',1,2,5,0,0,'.',',',0),(101,'MWK','Malawi, Kwachas','','MWK',1,2,5,0,0,'.',',',0),(102,'MXN','Mexico, Pesos','','MXN',1,2,5,0,0,'.',',',0),(103,'MYR','Malaysia, Ringgits','','MYR',1,2,5,0,0,'.',',',0),(104,'MZN','Mozambique, Meticais','','MZN',1,2,5,0,0,'.',',',0),(105,'NAD','Namibia, Dollars','','NAD',1,2,5,0,0,'.',',',0),(106,'NGN','Nigeria, Nairas','','NGN',1,2,5,0,0,'.',',',0),(107,'NIO','Nicaragua, Cordobas','','NIO',1,2,5,0,0,'.',',',0),(108,'NOK','Norway, Krone','','NOK',1,2,5,0,0,'.',',',0),(109,'NPR','Nepal, Nepal Rupees','','NPR',1,2,5,0,0,'.',',',0),(110,'NZD','New Zealand, Dollars','','NZD',1,2,5,0,0,'.',',',0),(111,'OMR','Oman, Rials','','OMR',1,2,5,0,0,'.',',',0),(112,'PAB','Panama, Balboa','','PAB',1,2,5,0,0,'.',',',0),(113,'PEN','Peru, Nuevos Soles','','PEN',1,2,5,0,0,'.',',',0),(114,'PGK','Papua New Guinea, Kina','','PGK',1,2,5,0,0,'.',',',0),(115,'PHP','Philippines, Pesos','','PHP',1,2,5,0,0,'.',',',0),(116,'PKR','Pakistan, Rupees','','PKR',1,2,5,0,0,'.',',',0),(117,'PLN','Poland, Zlotych','','PLN',1,2,5,0,0,'.',',',0),(118,'PYG','Paraguay, Guarani','','PYG',1,2,5,0,0,'.',',',0),(119,'QAR','Qatar, Rials','','QAR',1,2,5,0,0,'.',',',0),(120,'RON','Romania, New Lei','','RON',1,2,5,0,0,'.',',',0),(121,'RSD','Serbia, Dinars','','RSD',1,2,5,0,0,'.',',',0),(122,'RUB','Russia, Rubles','','RUB',1,2,5,0,0,'.',',',0),(123,'RWF','Rwanda, Rwanda Francs','','RWF',1,2,5,0,0,'.',',',0),(124,'SAR','Saudi Arabia, Riyals','','SAR',1,2,5,0,0,'.',',',0),(125,'SBD','Solomon Islands, Dollars','','SBD',1,2,5,0,0,'.',',',0),(126,'SCR','Seychelles, Rupees','','SCR',1,2,5,0,0,'.',',',0),(127,'SDG','Sudan, Pounds','','SDG',1,2,5,0,0,'.',',',0),(128,'SEK','Sweden, Kronor','','SEK',1,2,5,0,0,'.',',',0),(129,'SGD','Singapore, Dollars','','SGD',1,2,5,0,0,'.',',',0),(130,'SHP','Saint Helena, Pounds','','SHP',1,2,5,0,0,'.',',',0),(131,'SLL','Sierra Leone, Leones','','SLL',1,2,5,0,0,'.',',',0),(132,'SOS','Somalia, Shillings','','SOS',1,2,5,0,0,'.',',',0),(133,'SPL','Seborga, Luigini','','SPL',1,2,5,0,0,'.',',',0),(134,'SRD','Suriname, Dollars','','SRD',1,2,5,0,0,'.',',',0),(135,'STD','SÃ£o Tome and Principe, Dobras','','STD',1,2,5,0,0,'.',',',0),(136,'SVC','El Salvador, Colones','','SVC',1,2,5,0,0,'.',',',0),(137,'SYP','Syria, Pounds','','SYP',1,2,5,0,0,'.',',',0),(138,'SZL','Swaziland, Emalangeni','','SZL',1,2,5,0,0,'.',',',0),(139,'THB','Thailand, Baht','','THB',1,2,5,0,0,'.',',',0),(140,'TJS','Tajikistan, Somoni','','TJS',1,2,5,0,0,'.',',',0),(141,'TMM','Turkmenistan, Manats','','TMM',1,2,5,0,0,'.',',',0),(142,'TND','Tunisia, Dinars','','TND',1,2,5,0,0,'.',',',0),(143,'TOP','Tonga, Pa\'anga','','TOP',1,2,5,0,0,'.',',',0),(144,'TRY','Turkey, New Lira','','TRY',1,2,5,0,0,'.',',',0),(145,'TTD','Trinidad and Tobago, Dollars','','TTD',1,2,5,0,0,'.',',',0),(146,'TVD','Tuvalu, Tuvalu Dollars','','TVD',1,2,5,0,0,'.',',',0),(147,'TWD','Taiwan, New Dollars','','TWD',1,2,5,0,0,'.',',',0),(148,'TZS','Tanzania, Shillings','','TZS',1,2,5,0,0,'.',',',0),(149,'UAH','Ukraine, Hryvnia','','UAH',1,2,5,0,0,'.',',',0),(150,'UGX','Uganda, Shillings','','UGX',1,2,5,0,0,'.',',',0),(151,'USD','United States of America, Dollars','$','',1,2,3,1,0,'.',',',0),(152,'UYU','Uruguay, Pesos','','UYU',1,2,5,0,0,'.',',',0),(153,'UZS','Uzbekistan, Sums','','UZS',1,2,5,0,0,'.',',',0),(155,'VEF','Venezuela, Bolivares Fuertes','','VEF',1,2,5,0,0,'.',',',0),(156,'VND','Viet Nam, Dong','','VND',1,2,5,0,0,'.',',',0),(157,'VUV','Vanuatu, Vatu','','VUV',1,2,5,0,0,'.',',',0),(158,'WST','Samoa, Tala','','WST',1,2,5,0,0,'.',',',0),(159,'XAF','CommunautÃ© FinanciÃ¨re Africaine BEAC, Francs','','XAF',1,2,5,0,0,'.',',',0),(160,'XAG','Silver, Ounces','','XAG',1,2,5,0,0,'.',',',0),(161,'XAU','Gold, Ounces','','XAU',1,2,5,0,0,'.',',',0),(162,'XCD','East Caribbean Dollars','','XCD',1,2,5,0,0,'.',',',0),(163,'XDR','International Monetary Fund (IMF) Special Drawing Rights','','XDR',1,2,5,0,0,'.',',',0),(164,'XOF','CommunautÃ© FinanciÃ¨re Africaine BCEAO, Francs','','XOF',1,2,5,0,0,'.',',',0),(165,'XPD','Palladium Ounces','','XPD',1,2,5,0,0,'.',',',0),(166,'XPF','Comptoirs FranÃ§ais du Pacifique Francs','','XPF',1,2,5,0,0,'.',',',0),(167,'XPT','Platinum, Ounces','','XPT',1,2,5,0,0,'.',',',0),(168,'YER','Yemen, Rials','','YER',1,2,5,0,0,'.',',',0),(169,'ZAR','South Africa, Rand','','ZAR',1,2,5,0,0,'.',',',0),(170,'ZMK','Zambia, Kwacha','','ZMK',1,2,5,0,0,'.',',',0),(171,'ZWD','Zimbabwe, Zimbabwe Dollars','','ZWD',1,2,5,0,0,'.',',',0);
/*!40000 ALTER TABLE `currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencydenomination`
--

DROP TABLE IF EXISTS `currencydenomination`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencydenomination` (
  `id` int(11) NOT NULL auto_increment,
  `currency` varchar(10) NOT NULL default 'USD',
  `label` varchar(255) NOT NULL default '',
  `value` decimal(19,4) NOT NULL default '0.0000',
  PRIMARY KEY  (`id`),
  KEY `curr` (`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencydenomination`
--

LOCK TABLES `currencydenomination` WRITE;
/*!40000 ALTER TABLE `currencydenomination` DISABLE KEYS */;
INSERT INTO `currencydenomination` VALUES (1,'USD','Pennies','0.0100'),(2,'USD','Nickels','0.0500'),(3,'USD','Dimes','0.1000'),(4,'USD','Quarters','0.2500'),(5,'USD','$1','1.0000'),(6,'USD','$5','5.0000'),(7,'USD','$10','10.0000'),(8,'USD','$20','20.0000'),(9,'USD','$50','50.0000'),(10,'USD','$100','100.0000');
/*!40000 ALTER TABLE `currencydenomination` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencylog`
--

DROP TABLE IF EXISTS `currencylog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencylog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `curfrom` varchar(10) NOT NULL default '',
  `curto` varchar(10) NOT NULL default '',
  `currate` decimal(22,10) NOT NULL default '1.0000000000',
  `curdate` date NOT NULL default '0000-00-00',
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `date_from_to` (`curdate`,`curfrom`,`curto`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencylog`
--

LOCK TABLES `currencylog` WRITE;
/*!40000 ALTER TABLE `currencylog` DISABLE KEYS */;
/*!40000 ALTER TABLE `currencylog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer`
--

DROP TABLE IF EXISTS `customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer` (
  `id` int(11) NOT NULL auto_increment,
  `taxexemptid` int(11) NOT NULL default '0',
  `creditlimit` double NOT NULL default '0',
  `salesglacctid` int(11) NOT NULL default '0',
  `salesmanid` int(11) NOT NULL default '0',
  `servicerepid` int(11) NOT NULL default '0',
  `invoicetermsid` int(11) NOT NULL default '0',
  `quotecommentid` int(11) NOT NULL default '0',
  `interest` int(11) NOT NULL default '1',
  `billtoattnname` varchar(30) default NULL,
  `quoteattnname` varchar(30) default NULL,
  `chargecode` varchar(30) default NULL,
  `salestaxnum` varchar(30) default NULL,
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `companyname` varchar(100) NOT NULL default '',
  `address1` varchar(100) NOT NULL default '',
  `address2` varchar(100) NOT NULL default '',
  `mailstop` varchar(20) NOT NULL default '',
  `city` varchar(50) NOT NULL default '',
  `state` varchar(20) NOT NULL default '',
  `zip` varchar(15) NOT NULL default '',
  `country` varchar(20) NOT NULL default '',
  `phone1` varchar(20) NOT NULL default '',
  `phone1comment` varchar(20) NOT NULL default '',
  `phone1type` varchar(8) default NULL,
  `phone2` varchar(20) NOT NULL default '',
  `phone2comment` varchar(20) NOT NULL default '',
  `phone2type` varchar(8) default NULL,
  `phone3` varchar(20) NOT NULL default '',
  `phone3comment` varchar(20) NOT NULL default '',
  `phone3type` varchar(8) default NULL,
  `phone4` varchar(20) NOT NULL default '',
  `phone4comment` varchar(20) NOT NULL default '',
  `phone4type` varchar(8) default NULL,
  `textphone` varchar(20) NOT NULL default '',
  `mobilecarrierid` int(2) NOT NULL default '0',
  `email1` varchar(255) NOT NULL default '',
  `email1comment` varchar(20) NOT NULL default '',
  `email1sendinvoices` tinyint(1) NOT NULL default '1',
  `email1sendconfs` tinyint(1) NOT NULL default '1',
  `email1sendquotes` tinyint(1) NOT NULL default '1',
  `email1prelim` tinyint(1) NOT NULL default '1',
  `email2` varchar(255) NOT NULL default '',
  `email2comment` varchar(20) NOT NULL default '',
  `email2sendinvoices` tinyint(1) NOT NULL default '0',
  `email2sendconfs` tinyint(1) NOT NULL default '0',
  `email2sendquotes` tinyint(1) NOT NULL default '0',
  `email2prelim` tinyint(1) NOT NULL default '0',
  `email1statements` tinyint(1) NOT NULL default '1',
  `email2statements` tinyint(1) NOT NULL default '0',
  `rentalsbillwhen` tinyint(1) NOT NULL default '2',
  `paymeth` int(11) NOT NULL default '0',
  `defaulttopaymentonaccount` tinyint(1) NOT NULL default '0',
  `prelimable` tinyint(1) NOT NULL default '0',
  `on_hold` tinyint(1) NOT NULL default '0',
  `on_hold_date` datetime default NULL,
  `on_hold_userid` int(11) NOT NULL default '0',
  `b2ballowccpay` tinyint(1) NOT NULL default '1',
  `invoicenotificationmethod` varchar(1) NOT NULL default '',
  `statementnotificationmethod` varchar(1) NOT NULL default '',
  `requireponumberonorders` tinyint(1) NOT NULL default '0',
  `allowspecialpricing` tinyint(1) NOT NULL default '0',
  `specialpricingstatic` tinyint(1) NOT NULL default '2',
  `coachname` varchar(100) NOT NULL default '',
  `maintenanceplanactive` tinyint(1) NOT NULL default '0',
  `maintenanceplanstart` varchar(8) default '',
  `maintenanceplanend` varchar(8) default '',
  `maintenanceplancomments` mediumtext NOT NULL,
  `acceptbackorders` tinyint(1) NOT NULL default '0',
  `authorizedbuyersonly` tinyint(1) NOT NULL default '0',
  `exemptdeliverycharge` tinyint(1) NOT NULL default '0',
  `exemptfuelcharge` tinyint(1) NOT NULL default '0',
  `showpricesondeliveryconf` tinyint(1) NOT NULL default '0',
  `deliverysalesonly` tinyint(1) NOT NULL default '0',
  `allowordermodifications` tinyint(1) NOT NULL default '0',
  `jobnumberrequired` tinyint(1) NOT NULL default '0',
  `prelimjobsales` tinyint(1) NOT NULL default '0',
  `toolsonjob` tinyint(1) NOT NULL default '0',
  `shipifincompletejobinfo` tinyint(1) NOT NULL default '0',
  `addressverified` varchar(32) default '',
  `creditapplicationreceived` tinyint(1) NOT NULL default '0',
  `creditapplicationreceiveddate` date default NULL,
  `taxexemptiondate` date default NULL,
  `authorizedbuyer` tinyint(1) NOT NULL default '0',
  `closed` tinyint(1) NOT NULL default '0',
  `closed_date` datetime default NULL,
  `closed_userid` int(11) NOT NULL default '0',
  `interestchargeoptionid` int(11) NOT NULL default '0',
  `b2bnopaymentfee` tinyint(1) NOT NULL default '0',
  `website` varchar(100) NOT NULL default '',
  `federalid` varchar(20) NOT NULL default '',
  `entry_gender` char(1) NOT NULL default '',
  `entry_firstname` varchar(32) NOT NULL default '',
  `entry_lastname` varchar(32) NOT NULL default '',
  `entry_country_id` int(5) NOT NULL default '0',
  `entry_zone_id` int(5) NOT NULL default '0',
  `image` varchar(64) NOT NULL default '',
  `customers_dob` varchar(8) default '',
  `customers_password` varchar(40) default '',
  `customers_promotion_ok` tinyint(1) default '0',
  `customer_price_level` int(11) default NULL,
  `points_earned` decimal(8,2) default '0.00',
  `current_sales_process` int(11) NOT NULL default '0',
  `notes` longtext,
  `default_po` varchar(30) default NULL,
  `customercode` varchar(30) NOT NULL default '',
  `preprint_from_box_labels` int(2) NOT NULL default '0',
  `notify_order` int(2) NOT NULL default '0',
  `notify_ship` int(2) NOT NULL default '0',
  `notify_invoice` int(2) NOT NULL default '0',
  `email_order_acknowledgement` int(2) NOT NULL default '0',
  `email_order_ship` int(2) NOT NULL default '0',
  `email_invoice` int(2) NOT NULL default '0',
  `groupid` int(11) NOT NULL default '0',
  `onlygroupitems_onb2b` int(5) NOT NULL default '0',
  `taxgroupid` int(11) NOT NULL default '0',
  `salescategoryid` int(11) NOT NULL default '0',
  `weather_cf` char(1) default NULL,
  `weather_zip` varchar(20) default NULL,
  `time_zone` varchar(6) default '+00:00',
  `salutation` varchar(20) default NULL,
  `middle_name` varchar(50) default NULL,
  `name_suffix` varchar(20) default NULL,
  `currency` varchar(10) NOT NULL default 'USD',
  `customertypeid` int(11) NOT NULL default '0',
  `appstatus` char(1) NOT NULL default '',
  `areaid` int(11) NOT NULL default '0',
  `coinvoicecustomer` int(11) NOT NULL default '0',
  `nocredit` int(5) NOT NULL default '0',
  `nocredit_note` varchar(255) NOT NULL default '',
  `autobill` int(11) NOT NULL default '0',
  `pricelist_prepaybycc` int(5) NOT NULL default '0',
  `companyname2` varchar(50) NOT NULL default '',
  `auto_shipped_email` tinyint(4) default '0',
  `auto_invoiced_email` tinyint(4) NOT NULL default '0',
  `autosendordercreatedemail` tinyint(1) NOT NULL default '0',
  `bankrouting` varchar(50) default NULL,
  `bankaccountnum` varchar(100) default NULL,
  `service_worktypeid` int(11) NOT NULL default '0',
  `requirestatement` tinyint(4) NOT NULL default '1',
  `invoiceemailtemplateid` int(11) NOT NULL default '0',
  `numinvoicecopies` int(11) NOT NULL default '1',
  `lead` tinyint(1) NOT NULL default '0',
  `timezoneid` int(11) NOT NULL default '0',
  `taskstatusid` int(11) NOT NULL default '0',
  `defaultshiptotaxexemptid` int(11) NOT NULL default '0',
  `defaultshiptotaxexemptappliestopos` tinyint(1) NOT NULL default '0',
  `showpricesonpackingslip` tinyint(1) NOT NULL default '0',
  `sendinterestinvoices` tinyint(1) NOT NULL default '0',
  `appointmentreminderpreference` tinyint(1) NOT NULL default '0',
  `invoicetermsidrevertonhold` int(11) NOT NULL default '0',
  `notallowedtounchecktaxboxesonlineitems` tinyint(1) NOT NULL default '0',
  `nocheckpayment` tinyint(1) NOT NULL default '0',
  `nocreditcardpayment` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `taxexemptid` (`taxexemptid`),
  KEY `salesglacctid` (`salesglacctid`),
  KEY `salesmanid` (`salesmanid`),
  KEY `servicerepid` (`servicerepid`),
  KEY `invoicetermsid` (`invoicetermsid`),
  KEY `quotecommentid` (`quotecommentid`),
  KEY `groupid` (`groupid`),
  KEY `taxgroupid` (`taxgroupid`),
  KEY `taskstatusid` (`taskstatusid`),
  KEY `lead` (`lead`),
  KEY `defaultshiptotaxexemptid` (`defaultshiptotaxexemptid`),
  KEY `zip` (`zip`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer`
--

LOCK TABLES `customer` WRITE;
/*!40000 ALTER TABLE `customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_product`
--

DROP TABLE IF EXISTS `customer_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_product` (
  `customers_id` int(11) NOT NULL default '0',
  `products_id` int(11) NOT NULL default '0',
  `approved_price` decimal(19,4) NOT NULL default '0.0000',
  `comments` varchar(60) default NULL,
  `last_modified` datetime default NULL,
  PRIMARY KEY  (`customers_id`,`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_product`
--

LOCK TABLES `customer_product` WRITE;
/*!40000 ALTER TABLE `customer_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customerbank`
--

DROP TABLE IF EXISTS `customerbank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customerbank` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `routingnumber` varchar(9) NOT NULL default '',
  `accountnumber` varchar(20) NOT NULL default '',
  `accounttype` varchar(20) NOT NULL default '',
  `accountname` varchar(50) NOT NULL default '',
  `bankname` varchar(50) NOT NULL default '',
  `defaultaccount` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customerbank`
--

LOCK TABLES `customerbank` WRITE;
/*!40000 ALTER TABLE `customerbank` DISABLE KEYS */;
/*!40000 ALTER TABLE `customerbank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customergroup`
--

DROP TABLE IF EXISTS `customergroup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customergroup` (
  `id` int(11) NOT NULL auto_increment,
  `groupid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `groupid` (`groupid`),
  KEY `customerid` (`customerid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customergroup`
--

LOCK TABLES `customergroup` WRITE;
/*!40000 ALTER TABLE `customergroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `customergroup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customeritemdiscount`
--

DROP TABLE IF EXISTS `customeritemdiscount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customeritemdiscount` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `discountpercent` decimal(6,2) NOT NULL default '0.00',
  `discountflat` decimal(19,6) NOT NULL default '0.000000',
  `companyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `notes` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `itemid` (`itemid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customeritemdiscount`
--

LOCK TABLES `customeritemdiscount` WRITE;
/*!40000 ALTER TABLE `customeritemdiscount` DISABLE KEYS */;
/*!40000 ALTER TABLE `customeritemdiscount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_basket`
--

DROP TABLE IF EXISTS `customers_basket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_basket` (
  `customers_basket_id` int(5) NOT NULL auto_increment,
  `customers_id` int(5) NOT NULL default '0',
  `products_id` int(5) NOT NULL default '0',
  `inventorylocationid` int(11) default NULL,
  `customers_basket_quantity` int(2) NOT NULL default '0',
  `final_price` decimal(6,2) NOT NULL default '0.00',
  `customers_basket_date_added` varchar(8) default NULL,
  `discount_comment` varchar(60) default NULL,
  `lineitem` int(11) NOT NULL default '0',
  PRIMARY KEY  (`customers_basket_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_basket`
--

LOCK TABLES `customers_basket` WRITE;
/*!40000 ALTER TABLE `customers_basket` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_basket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_basket_attributes`
--

DROP TABLE IF EXISTS `customers_basket_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_basket_attributes` (
  `customers_basket_attributes_id` int(5) NOT NULL auto_increment,
  `customers_id` int(5) NOT NULL default '0',
  `products_id` int(5) NOT NULL default '0',
  `products_options_id` int(5) NOT NULL default '0',
  `products_options_value_id` int(5) NOT NULL default '0',
  `lineitem` int(11) NOT NULL default '0',
  `value` varchar(255) NOT NULL default '',
  `iogid` int(11) NOT NULL default '0',
  `ioid` int(11) NOT NULL default '0',
  `selection` int(11) NOT NULL default '0',
  `notes` text NOT NULL,
  PRIMARY KEY  (`customers_basket_attributes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_basket_attributes`
--

LOCK TABLES `customers_basket_attributes` WRITE;
/*!40000 ALTER TABLE `customers_basket_attributes` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_basket_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_info`
--

DROP TABLE IF EXISTS `customers_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers_info` (
  `customers_info_id` int(5) NOT NULL default '0',
  `customers_info_date_of_last_logon` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `customers_info_number_of_logons` int(5) default NULL,
  `customers_info_date_account_created` timestamp NOT NULL default '0000-00-00 00:00:00',
  `customers_info_date_account_last_modified` timestamp NOT NULL default '0000-00-00 00:00:00',
  `customers_info_last_verify_date` timestamp NOT NULL default '0000-00-00 00:00:00',
  `customers_info_status` char(10) default NULL,
  PRIMARY KEY  (`customers_info_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_info`
--

LOCK TABLES `customers_info` WRITE;
/*!40000 ALTER TABLE `customers_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customersalestax`
--

DROP TABLE IF EXISTS `customersalestax`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customersalestax` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `salestaxid` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `salestaxid` (`salestaxid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customersalestax`
--

LOCK TABLES `customersalestax` WRITE;
/*!40000 ALTER TABLE `customersalestax` DISABLE KEYS */;
/*!40000 ALTER TABLE `customersalestax` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customhelp`
--

DROP TABLE IF EXISTS `customhelp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customhelp` (
  `id` int(11) NOT NULL auto_increment,
  `page` varchar(100) NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `page` (`page`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customhelp`
--

LOCK TABLES `customhelp` WRITE;
/*!40000 ALTER TABLE `customhelp` DISABLE KEYS */;
/*!40000 ALTER TABLE `customhelp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db_explanation`
--

DROP TABLE IF EXISTS `db_explanation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `db_explanation` (
  `id_db_explanation` int(11) NOT NULL auto_increment,
  `table_name` varchar(255) NOT NULL default '',
  `field_name` varchar(255) NOT NULL default '',
  `field_length` int(11) NOT NULL default '0',
  `field_type` varchar(255) NOT NULL default 'Integer',
  `field_value` varchar(255) NOT NULL default '',
  `field_explanation` text,
  `field_key_type` varchar(255) NOT NULL default 'none',
  `field_key_table_name` varchar(255) default NULL,
  PRIMARY KEY  (`id_db_explanation`),
  KEY `table_name` (`table_name`),
  KEY `field_name` (`field_name`)
) ENGINE=InnoDB AUTO_INCREMENT=5217 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db_explanation`
--

LOCK TABLES `db_explanation` WRITE;
/*!40000 ALTER TABLE `db_explanation` DISABLE KEYS */;
INSERT INTO `db_explanation` VALUES (1,'accounttype','id',11,'Integer','10=Assets Current\r\n11=Assets Fixed\r\n13=Other Assets\r\n21=Liabilities Current\r\n22=Liabilities Long-Term\r\n23=Liabilities Other\r\n30=Equity\r\n40=Retained Earnings\r\n50=Sales\r\n60=Sales Adjustments\r\n70=Cost of Goods Sold\r\n80=Expenses\r\n90=Other Income and Expenses','For GL to determine whether the associated accounts are ASSETS, LIABILITIES, etc. These IDs cannot be added to by users.','primary unique','self'),(2,'accounttype','description',30,'Text','any','Explanation of purpose','',''),(3,'achcode','code',3,'Text','','Error Codes returned by ACH transactions','primary',''),(4,'achcode','description',70,'Text','','Complete text of what error code means','',''),(5,'achfile','id',11,'Integer','','','primary','self'),(6,'achfile','filecontents',65535,'X','','copy of file sent','',''),(7,'achfile','description',10,'Text','','','',''),(8,'achfile','totalcreditamount',21,'Numeric','','Credit amount total for file','',''),(9,'achfile','totaldebitamount',21,'Numeric','','Debit amount total for file','',''),(10,'achfile','totalrecords',11,'Integer','','Total number of detail records contained in file','',''),(11,'achfile','checkacctid',11,'Integer','','id of checking account','multiple','checkacct'),(12,'achfile','gencompanyid',11,'Integer','','NolaPro Company','multiple','gencompany'),(13,'achfile','sent',2,'Integer','0,1','1=sent file','',''),(14,'achfile','sentdate',19,'DateTime','','Date file sent','',''),(15,'achfile','effectivedate',10,'Date','','Date ACH transaction to take place','',''),(16,'achfile','entrydate',19,'DateTime','','Date Entered in system','',''),(17,'achfile','entryuserid',11,'Integer','','Who entered','multiple','genuser'),(18,'achfile','cancel',2,'Integer','0,1','1=cancelled','',''),(19,'achfile','canceldate',19,'DateTime','','date cancelled','',''),(20,'achfile','canceluserid',11,'Integer','','who cancelled','multiple','genuser'),(21,'achfiledetail','id',11,'Integer','','','primary','self'),(22,'achfiledetail','achfileid',11,'Integer','','Which achfile record was this detail grouped with','multiple','achfile'),(23,'achfiledetail','premployeeid',11,'Integer','','Payroll employee being paid','multiple','premployee.id'),(24,'achfiledetail','bankaccountid',11,'Integer','','','multiple',''),(25,'achfiledetail','achcode',3,'Text','','return error code from ACH process','multiple',''),(26,'achfiledetail','routing',9,'Text','','','',''),(27,'achfiledetail','accountnumber',17,'Text','','','',''),(28,'achfiledetail','bankname',100,'Text','','','',''),(29,'achfiledetail','originalvoucher',50,'Text','','','',''),(30,'achfiledetail','recordtype',2,'Integer','','','',''),(31,'achfiledetail','recorddata',94,'Text','','','',''),(32,'achfiledetail','transactioncode',2,'Text','','','',''),(33,'achfiledetail','amount',21,'Numeric','','','',''),(34,'achfiledetail','name',100,'Text','','','',''),(35,'achfiledetail','tracenumber',15,'Text','','','',''),(36,'achfiledetail','gencompanyid',11,'Integer','','NolaPro Company','multiple','gencompany.id'),(37,'achfiledetail','entrydate',19,'DateTime','','','',''),(38,'achfiledetail','entryuserid',11,'Integer','','Who entered','multiple','genuser.id'),(39,'achfiledetail','cancel',2,'Integer','','','',''),(40,'achfiledetail','canceldate',19,'DateTime','','','',''),(41,'achfiledetail','canceluserid',11,'Integer','','Who cancelled','multiple','genuser.id'),(42,'achfiledownload','id',11,'Integer','','','primary',''),(43,'achfiledownload','achfileid',11,'Integer','','','multiple',''),(44,'achfiledownload','userid',11,'Integer','','','multiple',''),(45,'achfiledownload','downloaddate',19,'DateTime','','','',''),(46,'action','id',11,'Integer','','','primary',''),(47,'action','action',100,'Text','','','',''),(48,'address_format','address_format_id',5,'Integer','','','primary',''),(49,'address_format','address_format',128,'Text','','','',''),(50,'address_format','address_summary',48,'Text','','','',''),(51,'airport','id',11,'Integer','','','primary',''),(52,'airport','airportcode',5,'Text','','','',''),(53,'airport','airportname',200,'Text','','','',''),(54,'airport','sales_categoriesid',11,'Integer','','','',''),(55,'airport','cancel',2,'Integer','','','multiple',''),(56,'airport','canceldate',19,'DateTime','','','',''),(57,'airport','canceluserid',11,'Integer','','','',''),(58,'airport_category','id',11,'Integer','','','primary',''),(59,'airport_category','name',50,'Text','','','',''),(60,'airport_category','cancel',2,'Integer','','','multiple',''),(61,'airport_category','canceldate',19,'DateTime','','','',''),(62,'airport_category','canceluserid',11,'Integer','','','',''),(63,'airport_order','id',11,'Integer','','','primary',''),(64,'airport_order','airportid',11,'Integer','','','multiple',''),(65,'airport_order','agentid',11,'Integer','','','multiple',''),(66,'airport_order','customerid',11,'Integer','','','multiple',''),(67,'airport_order','entrydate',19,'DateTime','','','',''),(68,'airport_order','departure_date',19,'DateTime','','','multiple',''),(69,'airport_order','return_date',19,'DateTime','','','',''),(70,'airport_order','card_type',10,'Text','','','',''),(71,'airport_order','transid',11,'Integer','','','multiple',''),(72,'airport_order','encrypted_card',50,'Text','','','',''),(73,'airport_order','card_last4',4,'Text','','','',''),(74,'airport_order','confirmcode',15,'Text','','','',''),(75,'airport_order','cancelcode',15,'Text','','','',''),(76,'airport_order','cancel',2,'Integer','','','multiple',''),(77,'airport_order','email',100,'Text','','','',''),(78,'airport_order','firstname',50,'Text','','','',''),(79,'airport_order','lastname',100,'Text','','','',''),(80,'airport_order','address',200,'Text','','','',''),(81,'airport_order','city',50,'Text','','','',''),(82,'airport_order','state',50,'Text','','','',''),(83,'airport_order','zip',15,'Text','','','',''),(84,'airport_order','phone',50,'Text','','','',''),(85,'airport_order','compupark',100,'Text','','','',''),(86,'airport_order','card_expiration',4,'Text','','','',''),(87,'airport_order','canceldate',19,'DateTime','','','',''),(88,'airport_order','canceluserid',11,'Integer','','','',''),(89,'airport_order','status',5,'Integer','','','',''),(90,'airport_order','parking_days',11,'Integer','','','',''),(91,'airport_order','parking_fee',12,'Numeric','','','',''),(92,'airport_order','agent_commission',14,'Numeric','','','',''),(93,'airport_order','vendor_commission',14,'Numeric','','','',''),(94,'airport_order','total_charge',14,'Numeric','','','',''),(95,'airport_order_details','id',11,'Integer','','','primary',''),(96,'airport_order_details','orderid',11,'Integer','','','multiple',''),(97,'airport_order_details','serviceid',11,'Integer','','','multiple',''),(98,'airport_order_details','description',50,'Text','','','',''),(99,'airport_order_details','price',14,'Numeric','','','',''),(100,'airport_order_details','cancel',2,'Integer','','','multiple',''),(101,'airport_parking','id',11,'Integer','','','primary',''),(102,'airport_parking','airportid',11,'Integer','','','multiple',''),(103,'airport_parking','num_days',5,'Integer','','','',''),(104,'airport_parking','price',12,'Numeric','','','',''),(105,'airport_parking','airport_fee_flat_charge',12,'Numeric','','','',''),(106,'airport_parking','airport_fee_percent_charge',12,'Numeric','','','',''),(107,'airport_parking','flat_commission',12,'Numeric','','','',''),(108,'airport_parking','percent_commission',12,'Numeric','','','',''),(109,'airport_parking','cancel',2,'Integer','','','multiple',''),(110,'airport_parking','canceldate',19,'DateTime','','','',''),(111,'airport_parking','canceluserid',11,'Integer','','','',''),(112,'airport_service','id',11,'Integer','','','primary',''),(113,'airport_service','airportid',11,'Integer','','','multiple',''),(114,'airport_service','serviceid',11,'Integer','','','multiple',''),(115,'airport_service','flat_commission',12,'Numeric','','','',''),(116,'airport_service','percent_commission',12,'Numeric','','','',''),(117,'airport_service','cancel',2,'Integer','','','multiple',''),(118,'airport_service','canceldate',19,'DateTime','','','',''),(119,'airport_service','canceluserid',11,'Integer','','','',''),(120,'airport_service','price',14,'Numeric','','','',''),(121,'apbill','id',22,'Numeric','','','primary unique',''),(122,'apbill','invoicenumber',20,'Text','','','multiple',''),(123,'apbill','cancel',11,'Integer','1=cancel\r\n0=open','Flag if cancelled','',''),(124,'apbill','complete',11,'Integer','1=complete\r\n0=not complete','If bill fully paid off','',''),(125,'apbill','paynone',11,'Integer','1=do not pay\r\n0=ok to pay','','',''),(126,'apbill','total',21,'Numeric','','','',''),(127,'apbill','description',50,'Text','','','',''),(128,'apbill','dateofinvoice',10,'Date','','','',''),(129,'apbill','duedate',10,'Date','','','',''),(130,'apbill','discountamount',21,'Numeric','','calculated discount before paid, actual discount after paid','',''),(131,'apbill','discountdate',10,'Date','','Date through which discount is allowed','',''),(132,'apbill','vendorid',22,'Numeric','','','',''),(133,'apbill','comment',65535,'X','','','',''),(134,'apbill','gencompanyid',22,'Numeric','','Internal Company','',''),(135,'apbill','wherefrom',11,'Integer','','integer = what module originated this entry.','multiple',''),(136,'apbill','entrydate',19,'DateTime','','','',''),(137,'apbill','entryuserid',22,'Numeric','','Who entered','',''),(138,'apbill','lastchangedate',19,'DateTime','','','',''),(139,'apbill','lastchangeuserid',22,'Numeric','','','',''),(140,'apbill','canceldate',19,'DateTime','','date cancelled','',''),(141,'apbill','canceluserid',22,'Numeric','','who cancelled','',''),(142,'apbilldetail','id',22,'Numeric','','','primary unique',''),(143,'apbilldetail','apbillid',22,'Numeric','','','multiple',''),(144,'apbilldetail','amount',21,'Numeric','','','',''),(145,'apbilldetail','glaccountid',22,'Numeric','','','multiple',''),(146,'apbilldetail','invreceiveid',22,'Numeric','','','multiple',''),(147,'apbillpayment','id',22,'Numeric','','','primary unique',''),(148,'apbillpayment','apbillid',22,'Numeric','','','multiple',''),(149,'apbillpayment','amount',21,'Numeric','','','',''),(150,'apbillpayment','interest',21,'Numeric','','','',''),(151,'apbillpayment','checkid',22,'Numeric','','','multiple',''),(152,'apbillpayment','checkvoid',11,'Integer','','','multiple',''),(153,'apbillpayment','complete',2,'Integer','','','multiple',''),(154,'apbillpayment','currentvoucherid',11,'Integer','','','',''),(155,'apbillpayment','voidvoucherid',11,'Integer','','','',''),(156,'apbillpayment','entrydate',19,'DateTime','','','',''),(157,'apbillpayment','entryuserid',22,'Numeric','','','',''),(158,'apbillpayment','lastchangedate',19,'DateTime','','','',''),(159,'apbillpayment','lastchangeuserid',22,'Numeric','','','',''),(160,'apbillpayment','paymethod',11,'Integer','','','',''),(161,'apcompany','id',22,'Numeric','','','multiple',''),(162,'apcompany','payable',22,'Numeric','','','',''),(163,'apcompany','interestexpense',22,'Numeric','','','',''),(164,'apcompany','discount',22,'Numeric','','','',''),(165,'apcompany','discearn',11,'Integer','','','',''),(166,'apcompany','usetransactiondate',11,'Integer','','','',''),(167,'apcompany','poformat',11,'Integer','','','',''),(168,'apcompany','glcashid',11,'Integer','','','',''),(169,'apcompany','glccid',11,'Integer','','','',''),(170,'apcompany','glotherid',11,'Integer','','','',''),(171,'apcompany','default_po_message',255,'Text','','','',''),(172,'arcompany','id',22,'Numeric','','','primary unique',''),(173,'arcompany','imageurl',150,'Text','','','',''),(174,'arcompany','cash',22,'Numeric','','','',''),(175,'arcompany','checking',22,'Numeric','','','',''),(176,'arcompany','interest',22,'Numeric','','','',''),(177,'arcompany','discount',22,'Numeric','','','',''),(178,'arcompany','cost',22,'Numeric','','','',''),(179,'arcompany','inventory',22,'Numeric','','','',''),(180,'arcompany','shipliability',22,'Numeric','','','',''),(181,'arcompany','receivables',22,'Numeric','','','',''),(182,'arcompany','nextinvoicenum',22,'Numeric','','','',''),(183,'arcompany','servicecharge',10,'Numeric','','','',''),(184,'arcompany','interestrate',10,'Numeric','','','',''),(185,'arcompany','baddebt',22,'Numeric','','','',''),(186,'arcompany','default_sellunitid',11,'Integer','','','',''),(187,'arcompany','default_priceunitid',11,'Integer','','','',''),(188,'arcompany','default_sell_per_price',11,'Integer','','','',''),(189,'arcompany','default_invoice_message',255,'Text','','','',''),(190,'arcompany','invoiceformat',11,'Integer','','','',''),(191,'arcompany','labor_sales_glacctid',11,'Integer','','','',''),(192,'arcompany','hrunitid',11,'Integer','','','',''),(193,'arcompany','is_employee_labor_taxable',2,'Integer','','','',''),(194,'arcompany','depositglacctid',11,'Integer','','','',''),(195,'arcompany','refund',11,'Integer','','','',''),(196,'arcompany','ccprocessorid',11,'Integer','','','',''),(197,'arcompany','docfile',65535,'X','','','',''),(198,'arcompany','default_salescategory_cashreceipts',11,'Integer','','','',''),(199,'arcompany','default_salescategory_invoice',11,'Integer','','','',''),(200,'arcompany','default_salescategory_fulfillment',11,'Integer','','','',''),(201,'arcompany','default_salescategory_service',11,'Integer','','','',''),(202,'arcompany','serviceorder_summarize',5,'Integer','','','',''),(203,'arcompany','tax_on_shipto',5,'Integer','','','',''),(204,'arinvoice','id',22,'Numeric','','','primary unique',''),(205,'arinvoice','invoicenumber',30,'Text','','','multiple',''),(206,'arinvoice','ponumber',30,'Text','','','multiple',''),(207,'arinvoice','wherefrom',11,'Integer','','','',''),(208,'arinvoice','orderid',22,'Numeric','','','',''),(209,'arinvoice','orderbycompanyid',22,'Numeric','','','multiple',''),(210,'arinvoice','shiptocompanyid',22,'Numeric','','','multiple',''),(211,'arinvoice','status',11,'Integer','','','',''),(212,'arinvoice','customerbillcode',20,'Text','','','',''),(213,'arinvoice','shipcost',21,'Numeric','','','',''),(214,'arinvoice','invoicetotal',21,'Numeric','','','',''),(215,'arinvoice','invoicetermsid',22,'Numeric','','','',''),(216,'arinvoice','salesmanid',22,'Numeric','','','',''),(217,'arinvoice','invoicedate',10,'Date','','','multiple',''),(218,'arinvoice','duedate',10,'Date','','','',''),(219,'arinvoice','discountdate',10,'Date','','','',''),(220,'arinvoice','discountamount',21,'Numeric','','','',''),(221,'arinvoice','accruedinterest',21,'Numeric','','','',''),(222,'arinvoice','datelastinterestcalc',10,'Date','','','',''),(223,'arinvoice','gencompanyid',22,'Numeric','','','multiple',''),(224,'arinvoice','cancel',11,'Integer','','','multiple',''),(225,'arinvoice','canceldate',19,'DateTime','','','multiple',''),(226,'arinvoice','canceluserid',22,'Numeric','','','',''),(227,'arinvoice','entrydate',19,'DateTime','','','',''),(228,'arinvoice','entryuserid',22,'Numeric','','','',''),(229,'arinvoice','lastchangedate',19,'DateTime','','','multiple',''),(230,'arinvoice','lastchangeuserid',22,'Numeric','','','',''),(231,'arinvoice','pricelevelid',22,'Numeric','','','',''),(232,'arinvoice','inventorylocationid',22,'Numeric','','','',''),(233,'arinvoice','payment_method',12,'Text','','','',''),(234,'arinvoice','cc_type',20,'Text','','','',''),(235,'arinvoice','cc_owner',64,'Text','','','',''),(236,'arinvoice','cc_number',32,'Text','','','',''),(237,'arinvoice','cc_expires',4,'Text','','','',''),(238,'arinvoice','shipping_method',32,'Text','','','',''),(239,'arinvoice','currency',3,'Text','','','',''),(240,'arinvoice','cc_PNREF',12,'Text','','','',''),(241,'arinvoice','cc_AUTHCODE',6,'Text','','','',''),(242,'arinvoice','transaction_id',32,'Text','','','',''),(243,'arinvoice','customers_id',5,'Integer','','','',''),(244,'arinvoice','currency_value',16,'Numeric','','','',''),(245,'arinvoice','servicerepid',11,'Integer','','','',''),(246,'arinvoice','discountapplied',21,'Numeric','','','',''),(247,'arinvoice','payplan',2,'Integer','0,1','0=regular invoice\r\n1=payment plan record only (not an actual invoice)','multiple',''),(248,'arinvoice','payplan_period',5,'Integer','','','',''),(249,'arinvoice','payplan_days',11,'Integer','','','',''),(250,'arinvoice','payplan_next',10,'Date','','','',''),(251,'arinvoice','payplan_numtimes',11,'Integer','','','',''),(252,'arinvoice','sales_categoriesid',11,'Integer','','','multiple',''),(253,'arinvoice','coverage',3,'Integer','','','',''),(254,'arinvoicedetail','id',22,'Numeric','','','primary unique',''),(255,'arinvoicedetail','invoiceid',22,'Numeric','','','multiple',''),(256,'arinvoicedetail','linenumber',11,'Integer','','','multiple',''),(257,'arinvoicedetail','itemid',22,'Numeric','','','',''),(258,'arinvoicedetail','description',100,'Text','','','',''),(259,'arinvoicedetail','qty',22,'Numeric','','','multiple',''),(260,'arinvoicedetail','qtyunitnameid',11,'Integer','','','',''),(261,'arinvoicedetail','glaccountid',22,'Numeric','','','multiple',''),(262,'arinvoicedetail','taxflag',11,'Integer','','','',''),(263,'arinvoicedetail','priceach',21,'Numeric','','','',''),(264,'arinvoicedetail','priceunitnameid',11,'Integer','','','',''),(265,'arinvoicedetail','qtyunitperpriceunit',12,'Numeric','','','',''),(266,'arinvoicedetail','totalprice',21,'Numeric','','','',''),(267,'arinvoicedetail','entrydate',19,'DateTime','','','',''),(268,'arinvoicedetail','entryuserid',22,'Numeric','','','',''),(269,'arinvoicedetail','lastchangedate',19,'DateTime','','','',''),(270,'arinvoicedetail','lastchangeuserid',22,'Numeric','','','',''),(271,'arinvoicedetail','costeach',21,'Numeric','','','',''),(272,'arinvoicedetail','costglaccountid',22,'Numeric','','','',''),(273,'arinvoicedetailcost','id',22,'Numeric','','','primary unique',''),(274,'arinvoicedetailcost','invoiceid',22,'Numeric','','','multiple',''),(275,'arinvoicedetailcost','cost',21,'Numeric','','','',''),(276,'arinvoicedetailcost','costglaccountid',22,'Numeric','','','',''),(277,'arinvoicedetailcost','entrydate',19,'DateTime','','','',''),(278,'arinvoicedetailcost','entryuserid',22,'Numeric','','','',''),(279,'arinvoicedetailcost','lastchangedate',19,'DateTime','','','',''),(280,'arinvoicedetailcost','lastchangeuserid',22,'Numeric','','','',''),(281,'arinvoicedetailnotes','id',11,'Integer','','','primary unique',''),(282,'arinvoicedetailnotes','invoiceid',11,'Integer','','','multiple',''),(283,'arinvoicedetailnotes','linenumber',11,'Integer','','','multiple',''),(284,'arinvoicedetailnotes','note',65535,'X','','','',''),(285,'arinvoicedetailnotes','lastchangedate',19,'DateTime','','','',''),(286,'arinvoicedetailnotes','lastchangeuserid',11,'Integer','','','',''),(287,'arinvoicenotes','invoiceid',22,'Numeric','','','multiple',''),(288,'arinvoicenotes','note',65535,'X','','','',''),(289,'arinvoicenotes','hide',11,'Integer','','','',''),(290,'arinvoicenotes','lastchangedate',19,'DateTime','','','',''),(291,'arinvoicenotes','lastchangeuserid',22,'Numeric','','','',''),(292,'arinvoicenotes','linenumber',11,'Integer','','','',''),(293,'arinvoicenotes','source_noteid',11,'Integer','','','',''),(294,'arinvoicenotes','id',11,'Integer','','','primary',''),(295,'arinvoicepaymentdetail','id',22,'Numeric','','','primary unique',''),(296,'arinvoicepaymentdetail','invoiceid',22,'Numeric','','','multiple',''),(297,'arinvoicepaymentdetail','amount',21,'Numeric','','discount stored as negative number','',''),(298,'arinvoicepaymentdetail','voucherid',22,'Numeric','','','multiple',''),(299,'arinvoicepaymentdetail','datereceived',10,'Date','','','',''),(300,'arinvoicepaymentdetail','paymeth',11,'Integer','','','multiple',''),(301,'arinvoicepaymentdetail','interest',11,'Integer','0,1,2,9','0=balance paid\r\n1,9=payment is interest\r\n2=discount amount','',''),(302,'arinvoicepaymentdetail','cancel',2,'Integer','','','multiple',''),(303,'arinvoicepaymentdetail','canceldate',19,'DateTime','','','',''),(304,'arinvoicepaymentdetail','cancel_userid',11,'Integer','','','',''),(305,'arinvoicepaymentdetail','checkid',20,'Text','','','multiple',''),(306,'arinvoicepaymentdetail','bankdepositid',11,'Integer','','','multiple','bankdeposit.id'),(307,'arinvoicepaymentdetail','bankstatement_enddate',10,'Date','','Bank Statement end date for period in which this was marked as cleared through bank.','',''),(308,'arinvoicestdnotes','id',11,'Integer','','','primary',''),(309,'arinvoicestdnotes','shortnote',50,'Text','','','',''),(310,'arinvoicestdnotes','full_note',65535,'X','','','',''),(311,'arinvoicestdnotes','sortorder',5,'Integer','','','multiple',''),(312,'arinvoicestdnotes','gencompanyid',11,'Integer','','','multiple',''),(313,'arinvoicestdnotes','entrydate',10,'Date','','','',''),(314,'arinvoicestdnotes','entryuserid',11,'Integer','','','',''),(315,'arinvoicestdnotes','cancel',2,'Integer','','','multiple',''),(316,'arinvoicestdnotes','canceldate',10,'Date','','','',''),(317,'arinvoicestdnotes','canceluserid',11,'Integer','','','',''),(318,'arinvoicestdnotes','lastupdatedate',19,'DateTime','','','',''),(319,'arinvoicestdnotes','lastupdateuserid',11,'Integer','','','',''),(320,'arinvoicetaxdetail','id',22,'Numeric','','','primary unique',''),(321,'arinvoicetaxdetail','invoiceid',22,'Numeric','','','multiple',''),(322,'arinvoicetaxdetail','taxid',22,'Numeric','','','multiple',''),(323,'arinvoicetaxdetail','taxamount',21,'Numeric','','','',''),(324,'arorder','id',11,'Integer','','','primary',''),(325,'arorder','ordernumber',22,'Numeric','','','multiple',''),(326,'arorder','ponumber',30,'Text','','','multiple',''),(327,'arorder','orderbycompanyid',22,'Numeric','','','multiple',''),(328,'arorder','shiptocompanyid',22,'Numeric','','','multiple',''),(329,'arorder','status',11,'Integer','-2,-1,0,1,2','-1=quote\r\n0=pending\r\n1=shipped\r\n2=billed\r\n-2=unconfirmed (entered by B2B user but not in order queue for filling yet','',''),(330,'arorder','customerbillcode',20,'Text','','','',''),(331,'arorder','companyid',22,'Numeric','','','multiple',''),(332,'arorder','pricelevelid',22,'Numeric','','','multiple',''),(333,'arorder','inventorylocationid',22,'Numeric','','','multiple',''),(334,'arorder','cancel',11,'Integer','1,0','1=cancelled - do not use','',''),(335,'arorder','canceldate',19,'DateTime','','','',''),(336,'arorder','canceluserid',22,'Numeric','','','',''),(337,'arorder','entrydate',19,'DateTime','','','',''),(338,'arorder','entryuserid',22,'Numeric','','','',''),(339,'arorder','duedate',10,'Date','','','',''),(340,'arorder','lastchangedate',19,'DateTime','','','',''),(341,'arorder','lastchangeuserid',22,'Numeric','','','',''),(342,'arorder','payment_method',12,'Text','','','',''),(343,'arorder','cc_type',20,'Text','','','',''),(344,'arorder','cc_owner',64,'Text','','','',''),(345,'arorder','cc_number',32,'Text','','','',''),(346,'arorder','cc_expires',7,'Text','','','',''),(347,'arorder','shipping_method',32,'Text','','','',''),(348,'arorder','orders_date_finished',19,'DateTime','','','',''),(349,'arorder','currency',3,'Text','','','',''),(350,'arorder','cc_PNREF',12,'Text','','','',''),(351,'arorder','cc_AUTHCODE',6,'Text','','','',''),(352,'arorder','transaction_id',32,'Text','','','',''),(353,'arorder','customers_id',5,'Integer','','','',''),(354,'arorder','shipping_cost',21,'Numeric','','','',''),(355,'arorder','order_weight',14,'Numeric','','','',''),(356,'arorder','currency_value',16,'Numeric','','','',''),(357,'arorder','wherefrom',100,'Text','','','',''),(358,'arorder','confirmed_by',100,'Text','','','',''),(359,'arorder','confirmed_date',100,'Text','','','',''),(360,'arorder','confirmed',100,'Text','','','',''),(361,'arorder','paymeth',11,'Integer','','','',''),(362,'arorder','ordertype',2,'Integer','','','',''),(363,'arorder','estimate',21,'Numeric','','','',''),(364,'arorder','deposit',21,'Numeric','','','',''),(365,'arorder','salesmanid',11,'Integer','','','',''),(366,'arorder','sales_categoriesid',11,'Integer','','','multiple',''),(367,'arorder','statusid',11,'Integer','','Process status (per user-entered list of possible statuses).','',''),(368,'arorder_deposit','id',11,'Integer','','','primary unique',''),(369,'arorder_deposit','orderid',11,'Integer','','','multiple',''),(370,'arorder_deposit','amount',21,'Numeric','','','',''),(371,'arorder_deposit','payment_method',5,'Integer','','','',''),(372,'arorder_deposit','transaction_id',32,'Text','','','',''),(373,'arorder_deposit','entrydate',10,'Date','','','',''),(374,'arorder_deposit','cc_type',20,'Text','','','',''),(375,'arorder_deposit','last4ofcard',4,'Text','','','',''),(376,'arorder_deposit','voucherid',11,'Integer','','','multiple',''),(377,'arorder_deposit','cancel',3,'Integer','','','',''),(378,'arorder_deposit','canceldate',10,'Date','','','',''),(379,'arorder_deposit','canceluserid',11,'Integer','','','',''),(380,'arorder_deposit','lastchangedate',19,'DateTime','','','',''),(381,'arorder_deposit','bankdepositid',11,'Integer','','','',''),(382,'arorderdetail','id',22,'Numeric','','','primary unique',''),(383,'arorderdetail','orderid',22,'Numeric','','','multiple',''),(384,'arorderdetail','itemid',22,'Numeric','','','multiple',''),(385,'arorderdetail','linenumber',11,'Integer','','','multiple',''),(386,'arorderdetail','qtyorder',22,'Numeric','','','multiple',''),(387,'arorderdetail','qtyship',22,'Numeric','','','multiple',''),(388,'arorderdetail','qtybill',22,'Numeric','','','multiple',''),(389,'arorderdetail','glaccountid',22,'Numeric','','','multiple',''),(390,'arorderdetail','taxflag',11,'Integer','','','',''),(391,'arorderdetail','costeach',21,'Numeric','','','',''),(392,'arorderdetail','priceach',21,'Numeric','','','',''),(393,'arorderdetail','entrydate',19,'DateTime','','','',''),(394,'arorderdetail','entryuserid',22,'Numeric','','','',''),(395,'arorderdetail','lastchangedate',19,'DateTime','','','',''),(396,'arorderdetail','lastchangeuserid',22,'Numeric','','','',''),(397,'arorderdetail','products_tax',9,'Numeric','','','',''),(398,'arorderdetail','description',255,'Text','','','',''),(399,'arorderdetail','saleunitperpriceunit',12,'Numeric','','','',''),(400,'arorderdetail','costglaccountid',22,'Numeric','','','',''),(401,'arorderdetail','purchaseunitid',11,'Integer','','','',''),(402,'arorderdetail','priceunitid',11,'Integer','','','',''),(403,'arorderdetail','main_arorderdetailid',11,'Integer','','','multiple',''),(404,'arorderdetail','itemoptiongroupid',11,'Integer','','','',''),(405,'arorderdetail','itemoptionid',11,'Integer','','','multiple',''),(406,'arorderdetail','multioption',2,'Integer','','','',''),(407,'arorderdetail','optionindependent',2,'Integer','','','',''),(408,'arorderdetail','inventorylocationid',22,'Numeric','','','',''),(409,'arorderdetailnotes','id',11,'Integer','','','primary unique',''),(410,'arorderdetailnotes','orderid',11,'Integer','','','multiple',''),(411,'arorderdetailnotes','linenumber',11,'Integer','','','multiple',''),(412,'arorderdetailnotes','note',65535,'X','','','',''),(413,'arorderdetailnotes','lastchangedate',19,'DateTime','','','',''),(414,'arorderdetailnotes','lastchangeuserid',11,'Integer','','','',''),(415,'arordernotes','orderid',22,'Numeric','','','multiple',''),(416,'arordernotes','note',65535,'X','','','',''),(417,'arordernotes','lastchangedate',19,'DateTime','','','',''),(418,'arordernotes','lastchangeuserid',22,'Numeric','','','',''),(419,'arordernotes','linenumber',11,'Integer','','','',''),(420,'arordernotes','id',11,'Integer','','','primary',''),(421,'arordernotes','internal',5,'Integer','','','',''),(422,'arordernotes','source_noteid',11,'Integer','','','',''),(423,'arordership','id',22,'Numeric','','','primary unique',''),(424,'arordership','orderid',22,'Numeric','','','multiple',''),(425,'arordership','carrierserviceid',22,'Numeric','','','',''),(426,'arordership','shipdate',19,'DateTime','','','multiple',''),(427,'arordership','locationid',22,'Numeric','','','multiple',''),(428,'arordership','entrydate',19,'DateTime','','','',''),(429,'arordership','entryuserid',22,'Numeric','','','',''),(430,'arordership','lastchangedate',19,'DateTime','','','',''),(431,'arordership','lastchangeuserid',22,'Numeric','','','',''),(432,'arordershipdetail','id',22,'Numeric','','','primary unique',''),(433,'arordershipdetail','ordershipid',22,'Numeric','','','multiple',''),(434,'arordershipdetail','orderdetailid',22,'Numeric','','','multiple',''),(435,'arordershipdetail','shipqty',22,'Numeric','','','multiple',''),(436,'arordershipdetail','entrydate',19,'DateTime','','','',''),(437,'arordershipdetail','entryuserid',22,'Numeric','','','',''),(438,'arordershipdetail','lastchangedate',19,'DateTime','','','',''),(439,'arordershipdetail','lastchangeuserid',22,'Numeric','','','',''),(440,'arordershippackage','id',22,'Numeric','','','primary unique',''),(441,'arordershippackage','ordershipid',22,'Numeric','','','multiple',''),(442,'arordershippackage','weight',22,'Numeric','','','',''),(443,'arordershippackage','cost',21,'Numeric','','','',''),(444,'arordershippackage','tracknumber',50,'Text','','','multiple',''),(445,'arordershippackage','arinvoiceid',22,'Numeric','','','',''),(446,'arordertax','id',22,'Numeric','','','primary unique',''),(447,'arordertax','orderid',22,'Numeric','','','multiple',''),(448,'arordertax','taxrateid',22,'Numeric','','','multiple',''),(449,'arordertax','tax',21,'Numeric','','','',''),(450,'arordertax','entrydate',19,'DateTime','','','',''),(451,'arordertax','entryuserid',22,'Numeric','','','',''),(452,'arordertax','lastchangedate',19,'DateTime','','','',''),(453,'arordertax','lastchangeuserid',22,'Numeric','','','',''),(454,'arordertrack','id',22,'Numeric','','','primary unique',''),(455,'arordertrack','orderid',22,'Numeric','','','multiple',''),(456,'arordertrack','action',11,'Integer','','','',''),(457,'arordertrack','trackdate',19,'DateTime','','','',''),(458,'arordertrack','trackuserid',22,'Numeric','','','multiple',''),(459,'arordertrack','lastchangedate',19,'DateTime','','','',''),(460,'arordertrack','lastchangeuserid',22,'Numeric','','','',''),(461,'arserviceorder_time','id',11,'Integer','','','primary',''),(462,'arserviceorder_time','employeeid',11,'Integer','','','multiple',''),(463,'arserviceorder_time','vendorid',11,'Integer','','','multiple',''),(464,'arserviceorder_time','techname',50,'Text','','','',''),(465,'arserviceorder_time','hours',12,'Numeric','','','',''),(466,'arserviceorder_time','startdatetime',19,'DateTime','','','',''),(467,'arserviceorder_time','enddatetime',19,'DateTime','','','',''),(468,'arserviceorder_time','rate',12,'Numeric','','','',''),(469,'arserviceorder_time','totalprice',12,'Numeric','','','',''),(470,'arserviceorder_time','totalcost',12,'Numeric','','','',''),(471,'arserviceorder_time','worktypeid',11,'Integer','','','multiple',''),(472,'arserviceorder_time','workclassid',11,'Integer','','','',''),(473,'arserviceorder_time','notes',65535,'X','','','',''),(474,'arserviceorder_time','gencompanyid',11,'Integer','','','',''),(475,'arserviceorder_time','entrydate',10,'Date','','','multiple',''),(476,'arserviceorder_time','entryuserid',11,'Integer','','','',''),(477,'arserviceorder_time','cancel',2,'Integer','','','',''),(478,'arserviceorder_time','canceldate',19,'DateTime','','','',''),(479,'arserviceorder_time','canceluserid',11,'Integer','','','',''),(480,'arserviceorder_time','lastchangedate',19,'DateTime','','','',''),(481,'arserviceorder_time','lastchangeuserid',11,'Integer','','','',''),(482,'arserviceorder_time','orderid',11,'Integer','','','',''),(483,'arserviceorder_time','internal_comment',255,'Text','','','',''),(484,'arserviceorder_time','costrate',12,'Numeric','','','',''),(485,'arserviceorder_time','status',3,'Integer','','','',''),(486,'arstatusoptions','id',11,'Integer','','','primary',''),(487,'arstatusoptions','description',50,'Text','','','',''),(488,'arstatusoptions','sortorder',5,'Integer','','','multiple',''),(489,'arstatusoptions','entrydate',19,'DateTime','','','',''),(490,'arstatusoptions','entryuserid',11,'Integer','','','',''),(491,'arstatusoptions','lastchangedate',19,'DateTime','','','',''),(492,'arstatusoptions','lastchangeuserid',11,'Integer','','','',''),(493,'arstatusoptions','cancel',2,'Integer','','','multiple',''),(494,'arstatusoptions','canceldate',19,'DateTime','','','',''),(495,'arstatusoptions','canceluserid',11,'Integer','','','',''),(496,'arstatusoptions','gencompanyid',11,'Integer','','','',''),(497,'bankaccount','id',11,'Integer','','','primary',''),(498,'bankaccount','premployeeid',11,'Integer','','','multiple',''),(499,'bankaccount','accounttype',2,'Integer','','','',''),(500,'bankaccount','routing',9,'Text','','','',''),(501,'bankaccount','accountnumber',17,'Text','','','',''),(502,'bankaccount','prenote_ok',2,'Integer','','','',''),(503,'bankaccount','prenote_achfiledetailid',11,'Integer','','','multiple',''),(504,'bankaccount','contactname',100,'Text','','','',''),(505,'bankaccount','bankname',100,'Text','','','',''),(506,'bankaccount','address',100,'Text','','','',''),(507,'bankaccount','city',100,'Text','','','',''),(508,'bankaccount','state',100,'Text','','','',''),(509,'bankaccount','zip',15,'Text','','','',''),(510,'bankaccount','phone',20,'Text','','','',''),(511,'bankaccount','gencompanyid',11,'Integer','','','multiple',''),(512,'bankaccount','entrydate',19,'DateTime','','','',''),(513,'bankaccount','entryuserid',11,'Integer','','','multiple',''),(514,'bankaccount','lastchangedate',19,'DateTime','','','',''),(515,'bankaccount','lastchangeuserid',11,'Integer','','','multiple',''),(516,'bankaccount','cancel',2,'Integer','','','',''),(517,'bankaccount','canceldate',19,'DateTime','','','',''),(518,'bankaccount','canceluserid',11,'Integer','','','multiple',''),(519,'bankdeposit','id',11,'Integer','','','primary unique',''),(520,'bankdeposit','cashtotal',21,'Numeric','','','',''),(521,'bankdeposit','checktotal',21,'Numeric','','','',''),(522,'bankdeposit','othertotal',21,'Numeric','','','',''),(523,'bankdeposit','cashout',21,'Numeric','','','',''),(524,'bankdeposit','depositdate',10,'Date','','','multiple',''),(525,'bankdeposit','checkaccountid',11,'Integer','','','multiple',''),(526,'bankdeposit','onbankstatement',2,'Integer','','','',''),(527,'bankdeposit','gencompanyid',11,'Integer','','','multiple',''),(528,'bankdeposit','cancel',2,'Integer','','','multiple',''),(529,'bankdeposit','canceldate',19,'DateTime','','','',''),(530,'bankdeposit','canceluserid',11,'Integer','','','',''),(531,'bankdeposit','entrydate',19,'DateTime','','','',''),(532,'bankdeposit','entryuserid',11,'Integer','','','',''),(533,'bankdeposit','lastupdatedate',19,'DateTime','','','',''),(534,'bankdeposit','lastupdateuserid',11,'Integer','','','',''),(535,'bankdeposit','bankstatement_enddate',10,'Date','','','',''),(536,'bankdepositdetail','id',11,'Integer','','','primary unique',''),(537,'bankdepositdetail','bankdepositid',11,'Integer','','','',''),(538,'bankdepositdetail','referenceid',11,'Integer','','','multiple',''),(539,'bankdepositdetail','wherefrom',5,'Integer','','','',''),(540,'bankdepositdetail','amount',21,'Numeric','','','',''),(541,'bankdepositdetail','deposit_type',5,'Integer','','','multiple',''),(542,'bankdepositdetail','cancel',3,'Integer','','','',''),(543,'bankdepositdetail','canceldate',19,'DateTime','','','',''),(544,'bankdepositdetail','canceluserid',11,'Integer','','','',''),(545,'buildordermaster','buildordermasterid',11,'Integer','','','primary',''),(546,'buildordermaster','final',2,'Integer','','','',''),(547,'buildordermaster','itemid',11,'Integer','','','',''),(548,'buildordermaster','orderqtyinitial',22,'Numeric','','','',''),(549,'buildordermaster','orderqtyfinal',22,'Numeric','','','',''),(550,'buildordermaster','entrydate',19,'DateTime','','','',''),(551,'buildordermaster','canceldate',19,'DateTime','','','',''),(552,'buildordermaster','canceluserid',22,'Numeric','','','',''),(553,'buildordermaster','cancel',2,'Integer','','','',''),(554,'buildordermaster','lastchangedate',19,'DateTime','','','',''),(555,'buildordermaster','lastchangeuserid',22,'Numeric','','','',''),(556,'buildordermaster','entryuserid',22,'Numeric','','','',''),(557,'buildordermaster','inventorylocationid',22,'Numeric','','','',''),(558,'buildordersub','buildordersubid',11,'Integer','','','primary',''),(559,'buildordersub','buildordermasterid',11,'Integer','','','',''),(560,'buildordersub','itemid',11,'Integer','','','',''),(561,'buildordersub','qtycommitted',22,'Numeric','','','',''),(562,'buildordersub','qtyused',22,'Numeric','','','',''),(563,'buildordersub','final',2,'Integer','','','',''),(564,'buildordersub','entrydate',19,'DateTime','','','',''),(565,'buildordersub','cancel',2,'Integer','','','',''),(566,'calcqty','id_calcqty',11,'Integer','','','primary unique',''),(567,'calcqty','description',100,'Text','','','multiple',''),(568,'calcqty','formula',255,'Text','','','',''),(569,'calcqty','id_calctype',3,'Integer','','','',''),(570,'calcqty','createdate',19,'DateTime','','','',''),(571,'calcqty','id_user_create',11,'Integer','','','',''),(572,'calcqty','lastrevisedate',19,'DateTime','','','',''),(573,'calcqty','id_user_revise',11,'Integer','','','',''),(574,'calcqty','canceldate',19,'DateTime','','','',''),(575,'calcqty','cancel',11,'Integer','','','',''),(576,'calcqty','gencompanyid',11,'Integer','','','',''),(577,'carrier','id',22,'Numeric','','','primary unique',''),(578,'carrier','customernumber',20,'Text','','','',''),(579,'carrier','trackingurlbase',150,'Text','','','',''),(580,'carrier','trackingurlvarname',30,'Text','','','',''),(581,'carrier','description',100,'Text','','','',''),(582,'carrier','vendorid',22,'Numeric','','','',''),(583,'carrier','cancel',2,'Integer','','','',''),(584,'carrierservice','id',22,'Numeric','','','primary unique',''),(585,'carrierservice','carrierid',22,'Numeric','','','multiple',''),(586,'carrierservice','description',30,'Text','','','',''),(587,'carrierservice','abbreviation',10,'Text','','','',''),(588,'carrierservice','sortorder',11,'Integer','','','',''),(589,'cashpayment','id',11,'Integer','','','primary unique',''),(590,'cashpayment','customerid',11,'Integer','','','multiple',''),(591,'cashpayment','entrydate',10,'Date','','','multiple',''),(592,'cashpayment','entryuserid',11,'Integer','','','',''),(593,'cashpayment','note',255,'Text','','','',''),(594,'cashpayment','voucherid',11,'Integer','','','multiple',''),(595,'cashpayment','taxable_amount',21,'Numeric','','','',''),(596,'cashpayment','exempt_amount',21,'Numeric','','','',''),(597,'cashpayment','cost_amount',21,'Numeric','','','',''),(598,'cashpayment','glaccountsalesid',11,'Integer','','','',''),(599,'cashpayment','glaccountcostid',11,'Integer','','','',''),(600,'cashpayment','exemptreasonid',11,'Integer','','','',''),(601,'cashpayment','payment_type',11,'Integer','','','multiple',''),(602,'cashpayment','gencompanyid',11,'Integer','','','',''),(603,'cashpayment','cancel',2,'Integer','','','multiple',''),(604,'cashpayment','canceldate',19,'DateTime','','','',''),(605,'cashpayment','canceluserid',11,'Integer','','','',''),(606,'cashpayment','lastupdatedate',19,'DateTime','','','',''),(607,'cashpayment','lastupdateuserid',11,'Integer','','','',''),(608,'cashpayment','bankdepositid',11,'Integer','','','',''),(609,'cashpayment','sales_categoriesid',11,'Integer','','','multiple',''),(610,'cashpayment','bankstatement_enddate',10,'Date','','','',''),(611,'cashpaymenttax','id',11,'Integer','','','primary unique',''),(612,'cashpaymenttax','cashpaymentid',11,'Integer','','','multiple',''),(613,'cashpaymenttax','taxid',11,'Integer','','','multiple',''),(614,'cashpaymenttax','tax',21,'Numeric','','','',''),(615,'cashpaymenttax','cancel',2,'Integer','','','',''),(616,'cashpaymenttax','canceldate',19,'DateTime','','','',''),(617,'cashpaymenttax','canceluserid',11,'Integer','','','',''),(618,'ccprocessor','id',11,'Integer','','','primary',''),(619,'ccprocessor','name',100,'Text','','','',''),(620,'ccprocessor','modulename',100,'Text','','','',''),(621,'changedate','id_changedate',11,'Integer','','','primary',''),(622,'changedate','id_printorder',11,'Integer','','','',''),(623,'changedate','id_user',11,'Integer','','','',''),(624,'changedate','olddate',19,'DateTime','','','',''),(625,'changedate','newdate',19,'DateTime','','','',''),(626,'changedate','createdate',19,'DateTime','','','',''),(627,'changedate','changedate',20,'Text','','','',''),(628,'checkacct','id',22,'Numeric','','','primary unique',''),(629,'checkacct','name',30,'Text','','','multiple',''),(630,'checkacct','glaccountid',22,'Numeric','','','',''),(631,'checkacct','lastchecknumberused',21,'Numeric','','','',''),(632,'checkacct','defaultendorser',50,'Text','','','',''),(633,'checkacct','gencompanyid',22,'Numeric','','','',''),(634,'checkacct','ap',11,'Integer','','','',''),(635,'checkacct','pay',11,'Integer','','','',''),(636,'checkacct','cancel',2,'Integer','','','',''),(637,'checkacct','canceldate',10,'Date','','','',''),(638,'checkacct','canceluserid',11,'Integer','','','',''),(639,'checkacct','lastupdatedate',19,'DateTime','','','',''),(640,'checkacct','lastupdateuserid',11,'Integer','','','',''),(641,'checkacct','destination_routing',9,'Text','','','',''),(642,'checkacct','destination_name',23,'Text','','','',''),(643,'checkacct','origin_routing',9,'Text','','','',''),(644,'checkacct','origin_name',23,'Text','','','',''),(645,'checkacct','company_name',16,'Text','','','',''),(646,'checkacct','company_identification',10,'Text','','','',''),(647,'checkacct','send_prenotes',2,'Integer','','','',''),(648,'checkacct','accountnumber',17,'Text','','','',''),(649,'checkacct','fractional_routing',30,'Text','','','',''),(650,'checkacct','addresscsz',255,'Text','','','',''),(651,'checkacct','printfullchecks',2,'Integer','','','',''),(652,'checkacct','logo',100,'Text','','','',''),(653,'checkacct','xadjust',11,'Integer','','','',''),(654,'checkacct','yadjust',11,'Integer','','','',''),(655,'chk','id',22,'Numeric','','','primary unique',''),(656,'chk','wherefrom',11,'Integer','','','multiple',''),(657,'chk','paytype',11,'Integer','','','',''),(658,'chk','checkdate',10,'Date','','','multiple',''),(659,'chk','checkvoid',11,'Integer','','','multiple',''),(660,'chk','amount',21,'Numeric','','','',''),(661,'chk','checkaccountid',22,'Numeric','','','multiple',''),(662,'chk','checknumber',16,'Numeric','','','multiple',''),(663,'chk','cashdate',10,'Date','','','multiple',''),(664,'chk','entrydate',19,'DateTime','','','',''),(665,'chk','entryuserid',22,'Numeric','','','',''),(666,'chk','lastchangedate',19,'DateTime','','','',''),(667,'chk','lastchangeuserid',22,'Numeric','','','',''),(668,'chk','gencompanyid',11,'Integer','','','multiple',''),(669,'chk','name',100,'Text','','','',''),(670,'chk','achfiledetailid',11,'Integer','','','multiple',''),(671,'columnfilter','table_name',100,'Text','','','multiple',''),(672,'columnfilter','column_name',100,'Text','','','multiple',''),(673,'columnfilter','ereg',6,'Integer','','','multiple',''),(674,'columnfilter','pcre',6,'Integer','','','multiple',''),(675,'columnfilter','addtext',6,'Integer','','','multiple',''),(676,'columnfilter','deltext',6,'Integer','','','multiple',''),(677,'columnfilter','casesensitive',6,'Integer','','','multiple',''),(678,'columnfilter','pattern',100,'Text','','','',''),(679,'columnfilter','replacement',100,'Text','','','',''),(680,'columnfilter','applyorder',6,'Integer','','','multiple',''),(681,'columnfilter','applyintodb',6,'Integer','','','multiple',''),(682,'columnfilter','applyoutofdb',6,'Integer','','','multiple',''),(683,'compositeitemid','id',22,'Numeric','','','primary unique',''),(684,'compositeitemid','itemcodeid',22,'Numeric','','','multiple',''),(685,'compositeitemid','subitemcodeid',22,'Numeric','','','multiple',''),(686,'compositeitemid','quantity',22,'Numeric','','','',''),(687,'compositeitemid','cancel',11,'Integer','','','',''),(688,'compositeitemid','canceldate',19,'DateTime','','','',''),(689,'compositeitemid','canceluserid',22,'Numeric','','','',''),(690,'compositeitemid','entrydate',19,'DateTime','','','',''),(691,'compositeitemid','entryuserid',22,'Numeric','','','',''),(692,'compositeitemid','lastchangedate',19,'DateTime','','','',''),(693,'compositeitemid','lastchangeuserid',22,'Numeric','','','',''),(694,'configuration','configuration_id',5,'Integer','','','primary',''),(695,'configuration','configuration_title',64,'Text','','','',''),(696,'configuration','configuration_key',64,'Text','','','',''),(697,'configuration','configuration_value',255,'Text','','','',''),(698,'configuration','configuration_description',255,'Text','','','',''),(699,'configuration','configuration_group_id',5,'Integer','','','',''),(700,'configuration','sort_order',5,'Integer','','','',''),(701,'configuration','last_modified',19,'DateTime','','','',''),(702,'configuration','date_added',19,'DateTime','','','',''),(703,'configuration','use_function',32,'Text','','','',''),(704,'configuration','set_function',255,'Text','','','',''),(705,'configuration_group','configuration_group_id',5,'Integer','','','primary',''),(706,'configuration_group','configuration_group_title',64,'Text','','','',''),(707,'configuration_group','configuration_group_description',255,'Text','','','',''),(708,'configuration_group','sort_order',5,'Integer','','','',''),(709,'contactaddress','id',10,'Integer','','','primary',''),(710,'contactaddress','contactnameid',10,'Integer','','','multiple',''),(711,'contactaddress','tablename',100,'Text','','','multiple',''),(712,'contactaddress','tablerecordid',10,'Integer','','','multiple',''),(713,'contactaddress','companyid',10,'Integer','','','',''),(714,'contactaddress','entryuserid',10,'Integer','','','',''),(715,'contactaddress','entrydate',19,'DateTime','','','',''),(716,'contactaddress','address1',200,'Text','','','',''),(717,'contactaddress','address2',200,'Text','','','',''),(718,'contactaddress','mailstop',20,'Text','','','',''),(719,'contactaddress','city',100,'Text','','','',''),(720,'contactaddress','state',50,'Text','','','',''),(721,'contactaddress','zip',15,'Text','','','',''),(722,'contactaddress','country',100,'Text','','','',''),(723,'contactaddress','description',65535,'X','','','',''),(724,'contactaddress','cancel',11,'Integer','','','',''),(725,'contactemail','id',10,'Integer','','','primary',''),(726,'contactemail','contactnameid',10,'Integer','','','multiple',''),(727,'contactemail','tablename',100,'Text','','','multiple',''),(728,'contactemail','tablerecordid',10,'Integer','','','multiple',''),(729,'contactemail','companyid',10,'Integer','','','',''),(730,'contactemail','entryuserid',10,'Integer','','','',''),(731,'contactemail','entrydate',19,'DateTime','','','',''),(732,'contactemail','email',100,'Text','','','',''),(733,'contactemail','description',65535,'X','','','',''),(734,'contactemail','cancel',11,'Integer','','','',''),(735,'contactname','id',10,'Integer','','','primary',''),(736,'contactname','tablename',100,'Text','','','multiple',''),(737,'contactname','tablerecordid',10,'Integer','','','multiple',''),(738,'contactname','companyid',10,'Integer','','','',''),(739,'contactname','entryuserid',10,'Integer','','','',''),(740,'contactname','entrydate',19,'DateTime','','','',''),(741,'contactname','firstname',100,'Text','','','',''),(742,'contactname','lastname',100,'Text','','','',''),(743,'contactname','description',65535,'X','','','',''),(744,'contactname','cancel',11,'Integer','','','',''),(745,'contactphone','id',10,'Integer','','','primary',''),(746,'contactphone','contactnameid',10,'Integer','','','multiple',''),(747,'contactphone','tablename',100,'Text','','','multiple',''),(748,'contactphone','tablerecordid',10,'Integer','','','multiple',''),(749,'contactphone','companyid',10,'Integer','','','',''),(750,'contactphone','entryuserid',10,'Integer','','','',''),(751,'contactphone','entrydate',19,'DateTime','','','',''),(752,'contactphone','phone',100,'Text','','','',''),(753,'contactphone','description',65535,'X','','','',''),(754,'contactphone','cancel',11,'Integer','','','',''),(755,'counter','startdate',8,'Text','','','',''),(756,'counter','counter',12,'Integer','','','',''),(757,'counter_history','month',8,'Text','','','',''),(758,'counter_history','counter',12,'Integer','','','',''),(759,'countries','countries_id',5,'Integer','','','primary',''),(760,'countries','countries_name',64,'Text','','','multiple',''),(761,'countries','countries_iso_code_2',2,'Text','','','',''),(762,'countries','countries_iso_code_3',3,'Text','','','',''),(763,'countries','address_format_id',5,'Integer','','','',''),(764,'currencies','currencies_id',5,'Integer','','','primary',''),(765,'currencies','title',32,'Text','','','',''),(766,'currencies','code',3,'Text','','','',''),(767,'currencies','symbol_left',12,'Text','','','',''),(768,'currencies','symbol_right',12,'Text','','','',''),(769,'currencies','decimal_point',1,'Text','','','',''),(770,'currencies','thousands_point',1,'Text','','','',''),(771,'currencies','decimal_places',1,'Text','','','',''),(772,'customer','id',22,'Numeric','','','primary unique',''),(773,'customer','taxexemptid',22,'Numeric','','','multiple',''),(774,'customer','creditlimit',22,'Numeric','','','',''),(775,'customer','salesglacctid',22,'Numeric','','','multiple',''),(776,'customer','salesmanid',22,'Numeric','','','multiple',''),(777,'customer','servicerepid',22,'Numeric','','','multiple',''),(778,'customer','invoicetermsid',22,'Numeric','','','multiple',''),(779,'customer','quotecommentid',22,'Numeric','','','multiple',''),(780,'customer','interest',11,'Integer','','','',''),(781,'customer','billtoattnname',30,'Text','','','',''),(782,'customer','quoteattnname',30,'Text','','','',''),(783,'customer','chargecode',30,'Text','','','',''),(784,'customer','salestaxnum',30,'Text','','','',''),(785,'customer','gencompanyid',22,'Numeric','','','',''),(786,'customer','cancel',11,'Integer','','','',''),(787,'customer','canceldate',19,'DateTime','','','',''),(788,'customer','canceluserid',22,'Numeric','','','',''),(789,'customer','entrydate',19,'DateTime','','','',''),(790,'customer','entryuserid',22,'Numeric','','','',''),(791,'customer','lastchangedate',19,'DateTime','','','',''),(792,'customer','lastchangeuserid',22,'Numeric','','','',''),(793,'customer','companyname',35,'Text','','','',''),(794,'customer','address1',100,'Text','','','',''),(795,'customer','address2',100,'Text','','','',''),(796,'customer','mailstop',20,'Text','','','',''),(797,'customer','city',50,'Text','','','',''),(798,'customer','state',20,'Text','','','',''),(799,'customer','zip',15,'Text','','','',''),(800,'customer','country',20,'Text','','','',''),(801,'customer','phone1',20,'Text','','','',''),(802,'customer','phone1comment',20,'Text','','','',''),(803,'customer','phone2',20,'Text','','','',''),(804,'customer','phone2comment',20,'Text','','','',''),(805,'customer','phone3',20,'Text','','','',''),(806,'customer','phone3comment',20,'Text','','','',''),(807,'customer','phone4',20,'Text','','','',''),(808,'customer','phone4comment',20,'Text','','','',''),(809,'customer','email1',50,'Text','','','',''),(810,'customer','email1comment',20,'Text','','','',''),(811,'customer','email2',50,'Text','','','',''),(812,'customer','email2comment',20,'Text','','','',''),(813,'customer','website',100,'Text','','','',''),(814,'customer','federalid',20,'Text','','','',''),(815,'customer','entry_gender',1,'Text','','','',''),(816,'customer','entry_firstname',32,'Text','','','',''),(817,'customer','entry_lastname',32,'Text','','','',''),(818,'customer','entry_country_id',5,'Integer','','','',''),(819,'customer','entry_zone_id',5,'Integer','','','',''),(820,'customer','image',64,'Text','','','',''),(821,'customer','customers_dob',8,'Text','','','',''),(822,'customer','customers_password',40,'Text','','','',''),(823,'customer','customers_promotion_ok',1,'Integer','','','',''),(824,'customer','customer_price_level',11,'Integer','','','',''),(825,'customer','points_earned',10,'Numeric','','','',''),(826,'customer','current_sales_process',11,'Integer','','','',''),(827,'customer','notes',255,'Text','','','',''),(828,'customer','default_po',30,'Text','','','',''),(829,'customer','customercode',30,'Text','','','',''),(830,'customer_product','customers_id',11,'Integer','','','primary',''),(831,'customer_product','products_id',11,'Integer','','','primary',''),(832,'customer_product','approved_price',21,'Numeric','','','',''),(833,'customer_product','comments',60,'Text','','','',''),(834,'customer_product','last_modified',19,'DateTime','','','',''),(835,'customers_basket','customers_basket_id',5,'Integer','','','primary',''),(836,'customers_basket','customers_id',5,'Integer','','','',''),(837,'customers_basket','products_id',5,'Integer','','','',''),(838,'customers_basket','lineitem',11,'Integer','','','',''),(839,'customers_basket','inventorylocationid',22,'Numeric','','','',''),(840,'customers_basket','customers_basket_quantity',2,'Integer','','','',''),(841,'customers_basket','final_price',8,'Numeric','','','',''),(842,'customers_basket','customers_basket_date_added',8,'Text','','','',''),(843,'customers_basket','discount_comment',60,'Text','','','',''),(844,'customers_basket_attributes','customers_basket_attributes_id',5,'Integer','','','primary',''),(845,'customers_basket_attributes','customers_id',5,'Integer','','','',''),(846,'customers_basket_attributes','products_id',5,'Integer','','','',''),(847,'customers_basket_attributes','lineitem',11,'Integer','','','',''),(848,'customers_basket_attributes','value',255,'Text','','','',''),(849,'customers_basket_attributes','iogid',11,'Integer','','','',''),(850,'customers_basket_attributes','ioid',11,'Integer','','','',''),(851,'customers_basket_attributes','selection',11,'Integer','','','',''),(852,'customers_basket_attributes','notes',65535,'X','','','',''),(853,'customers_basket_attributes','products_options_id',5,'Integer','','','',''),(854,'customers_basket_attributes','products_options_value_id',5,'Integer','','','',''),(855,'customers_info','customers_info_id',5,'Integer','','','primary',''),(856,'customers_info','customers_info_date_of_last_logon',19,'DateTime','','','',''),(857,'customers_info','customers_info_number_of_logons',5,'Integer','','','',''),(858,'customers_info','customers_info_date_account_created',19,'DateTime','','','',''),(859,'customers_info','customers_info_date_account_last_modified',19,'DateTime','','','',''),(860,'customers_info','customers_info_last_verify_date',19,'DateTime','','','',''),(861,'customers_info','customers_info_status',10,'Text','','','',''),(862,'customersalestax','id',22,'Numeric','','','primary unique',''),(863,'customersalestax','customerid',22,'Numeric','','','multiple',''),(864,'customersalestax','salestaxid',22,'Numeric','','','multiple',''),(865,'db_explanation','id_db_explanation',11,'Integer','','','primary',''),(866,'db_explanation','table_name',255,'Text','','','multiple',''),(867,'db_explanation','field_name',255,'Text','','','multiple',''),(868,'db_explanation','field_length',11,'Integer','','','',''),(869,'db_explanation','field_type',255,'Text','','','',''),(870,'db_explanation','field_value',255,'Text','','','',''),(871,'db_explanation','field_explanation',65535,'X','','','',''),(872,'db_explanation','field_key_type',255,'Text','','','',''),(873,'db_explanation','field_key_table_name',255,'Text','','','',''),(874,'default_response','id_default_response',11,'Integer','','','primary unique',''),(875,'default_response','id_worksubtype',11,'Integer','','','',''),(876,'default_response','id_question',11,'Integer','','','',''),(877,'default_response','response_id_question_detail',11,'Integer','','','',''),(878,'default_response','response',20,'Text','','','',''),(879,'default_response','createdate',19,'DateTime','','','',''),(880,'default_response','id_user_create',11,'Integer','','','',''),(881,'default_response','lastrevisedate',19,'DateTime','','','',''),(882,'default_response','id_user_revise',11,'Integer','','','',''),(883,'default_response','canceldate',19,'DateTime','','','',''),(884,'default_response','cancel',11,'Integer','','','',''),(885,'docmgmtcategory','id',22,'Numeric','','','primary',''),(886,'docmgmtcategory','name',255,'Text','','','',''),(887,'docmgmtcategory','cancel',11,'Integer','','','',''),(888,'docmgmtdata','id',22,'Numeric','','','primary',''),(889,'docmgmtdata','category',22,'Numeric','','','',''),(890,'docmgmtdata','owner',22,'Numeric','','','multiple',''),(891,'docmgmtdata','realname',255,'Text','','','',''),(892,'docmgmtdata','created',19,'DateTime','','','',''),(893,'docmgmtdata','description',255,'Text','','','',''),(894,'docmgmtdata','itemid',22,'Numeric','','','multiple',''),(895,'docmgmtdata','comment',65535,'X','','','',''),(896,'docmgmtdata','status',22,'Numeric','','','',''),(897,'docmgmtdata','version',10,'Text','','','',''),(898,'docmgmtdata','final',11,'Integer','','','',''),(899,'docmgmtlog','id',22,'Numeric','','','multiple',''),(900,'docmgmtlog','modified_on',19,'DateTime','','','',''),(901,'docmgmtlog','modified_by',22,'Numeric','','','multiple',''),(902,'docmgmtlog','oldversion',10,'Text','','','',''),(903,'docmgmtlog','newversion',10,'Text','','','',''),(904,'docmgmtlog','note',65535,'X','','','',''),(905,'docmgmtperms','fid',22,'Numeric','','','multiple',''),(906,'docmgmtperms','uid',22,'Numeric','','','multiple',''),(907,'docmgmtperms','rights',22,'Numeric','','','multiple',''),(908,'estcostcenter','id',22,'Numeric','','','primary unique',''),(909,'estcostcenter','name',50,'Text','','','',''),(910,'estcostcenter','cctype',11,'Integer','','','',''),(911,'estcostcenter','orderflag',11,'Integer','','','',''),(912,'estcostcenter','cancel',11,'Integer','','','',''),(913,'estcostcentersubtype','id',22,'Numeric','','','primary unique',''),(914,'estcostcentersubtype','name',50,'Text','','','',''),(915,'estcostcentersubtype','costcenterid',22,'Numeric','','','multiple',''),(916,'estcostcentersubtype','orderflag',11,'Integer','','','',''),(917,'estcostcentersubtype','cancel',11,'Integer','','','',''),(918,'estmachine','id',22,'Numeric','','','primary unique',''),(919,'estmachine','name',50,'Text','','','',''),(920,'estmachine','costcentersubtypeid',22,'Numeric','','','multiple',''),(921,'estmachine','costmachperhr',14,'Numeric','','','',''),(922,'estmachine','costoperperhr',14,'Numeric','','','',''),(923,'estmachine','costasstperhr',14,'Numeric','','','',''),(924,'estmachine','factoverhead',5,'Numeric','','','',''),(925,'estmachine','genoverhead',5,'Numeric','','','',''),(926,'estmachine','markup',6,'Numeric','','','',''),(927,'estmachine','orderflag',11,'Integer','','','',''),(928,'estmachine','gencompanyid',22,'Numeric','','','',''),(929,'estmachine','cancel',11,'Integer','','','',''),(930,'estprgeneral','gencompanyid',22,'Numeric','','','primary unique',''),(931,'estprgeneral','onetrimopcostsid',22,'Numeric','','','',''),(932,'estprgeneral','twotrimopcostsid',22,'Numeric','','','',''),(933,'estprgeneral','cutopcostsid',22,'Numeric','','','',''),(934,'estprgeneral','cancel',11,'Integer','','','',''),(935,'estprgeneral','canceldate',19,'DateTime','','','',''),(936,'estprgeneral','canceluserid',22,'Numeric','','','',''),(937,'estprgeneral','entrydate',19,'DateTime','','','',''),(938,'estprgeneral','entryuserid',22,'Numeric','','','',''),(939,'estprgeneral','lastchangedate',19,'DateTime','','','',''),(940,'estprgeneral','lastchangeuserid',22,'Numeric','','','',''),(941,'estprprice','id',22,'Numeric','','','primary unique',''),(942,'estprprice','gencompanyid',22,'Numeric','','','',''),(943,'estprprice','name',50,'Text','','','',''),(944,'estprprice','worktypeid',22,'Numeric','','','',''),(945,'estprprice','estquotestdsizeid',22,'Numeric','','','',''),(946,'estprprice','maxpages',11,'Integer','','','',''),(947,'estprprice','minpages',11,'Integer','','','',''),(948,'estprprice','opoffsetsheet',11,'Integer','','','',''),(949,'estprprice','opoffsetweb',11,'Integer','','','',''),(950,'estprprice','opdigital',11,'Integer','','','',''),(951,'estprprice','opscreen',11,'Integer','','','',''),(952,'estprprice','opflexo',11,'Integer','','','',''),(953,'estprprice','opvended',11,'Integer','','','',''),(954,'estprprice','qtyperbox',6,'Numeric','','','',''),(955,'estprprice','notes',65535,'X','','','',''),(956,'estprprice','prpriceid',22,'Numeric','','','',''),(957,'estprprice','maxstocks',11,'Integer','','','',''),(958,'estprprice','tools',11,'Integer','','','',''),(959,'estprprice','cancel',11,'Integer','','','',''),(960,'estprprice','canceldate',19,'DateTime','','','',''),(961,'estprprice','canceluserid',22,'Numeric','','','',''),(962,'estprprice','entrydate',19,'DateTime','','','',''),(963,'estprprice','entryuserid',22,'Numeric','','','',''),(964,'estprprice','lastchangedate',19,'DateTime','','','',''),(965,'estprprice','lastchangeuserid',22,'Numeric','','','',''),(966,'estprpriceoptioncosts','id',22,'Numeric','','','primary unique',''),(967,'estprpriceoptioncosts','proption',11,'Integer','','','',''),(968,'estprpriceoptioncosts','stocklistid',22,'Numeric','','','',''),(969,'estprpriceoptioncosts','hrsgeneralsetup',8,'Numeric','','','',''),(970,'estprpriceoptioncosts','hrscolorsetup',8,'Numeric','','','',''),(971,'estprpriceoptioncosts','runrate',12,'Numeric','','','',''),(972,'estprpriceoptioncosts','runrate2',12,'Numeric','','','',''),(973,'estprpriceoptioncosts','runrate3',12,'Numeric','','','',''),(974,'estprpriceoptioncosts','runqty',9,'Numeric','','','',''),(975,'estprpriceoptioncosts','runqty2',9,'Numeric','','','',''),(976,'estprpriceoptioncosts','runrateqtytype',11,'Integer','','','',''),(977,'estprpriceoptioncosts','numoperators',11,'Integer','','','',''),(978,'estprpriceoptioncosts','numassistants',11,'Integer','','','',''),(979,'estprpriceoptioncosts','mantomachine',11,'Integer','','','',''),(980,'estprpriceoptioncosts','setupscrap',7,'Numeric','','','',''),(981,'estprpriceoptioncosts','runscrap',7,'Numeric','','','',''),(982,'estprpriceoptioncosts','runscrap2',7,'Numeric','','','',''),(983,'estprpriceoptioncosts','scrapqty',9,'Numeric','','','',''),(984,'estprpriceoptioncosts','registrationslowdown',3,'Numeric','','','',''),(985,'estprpriceoptioncosts','maxinksperpass',11,'Integer','','','',''),(986,'estprpriceoptioncosts','estmachineid',22,'Numeric','','','',''),(987,'estprpriceoptioncostsmaterials','id',22,'Numeric','','','primary unique',''),(988,'estprpriceoptioncostsmaterials','proption',11,'Integer','','','',''),(989,'estprpriceoptioncostsmaterials','stocklistid',22,'Numeric','','','',''),(990,'estprpriceoptioncostsmaterials','itemid',22,'Numeric','','','',''),(991,'estprpriceoptioncostsmaterials','name',30,'Text','','','',''),(992,'estprpriceoptioncostsmaterials','qty',12,'Numeric','','','',''),(993,'estprpriceoptioncostsmaterials','per',11,'Integer','','','',''),(994,'estprpriceoptioncostsmaterials','cost',14,'Numeric','','','',''),(995,'estprpriceoptionprice','id',22,'Numeric','','','primary unique',''),(996,'estprpriceoptionprice','proption',11,'Integer','','','',''),(997,'estprpriceoptionprice','stockusageid',22,'Numeric','','','',''),(998,'estprpriceoptionprice','qty',22,'Numeric','','','',''),(999,'estprpriceoptionprice','amount',12,'Numeric','','','',''),(1000,'estprpriceoptionprice','qtycalchow',11,'Integer','','','',''),(1001,'estprpricestockusage','id',22,'Numeric','','','primary unique',''),(1002,'estprpricestockusage','prpriceid',22,'Numeric','','','',''),(1003,'estprpricestockusage','name',20,'Text','','','',''),(1004,'estprpricestockusage','proptionone',22,'Numeric','','','',''),(1005,'estprpricestockusage','proptiontwo',22,'Numeric','','','',''),(1006,'estprpricestockusage','proptionqty',11,'Numeric','','','',''),(1007,'estprpricestockusage','maxinksfront',11,'Integer','','','',''),(1008,'estprpricestockusage','mininksfront',11,'Integer','','','',''),(1009,'estprpricestockusage','maxinksback',11,'Integer','','','',''),(1010,'estprpricestockusage','mininksback',11,'Integer','','','',''),(1011,'estprpricestockusage','maxpages',11,'Integer','','','',''),(1012,'estprpricestockusage','inkcoveragedefault',11,'Integer','','','',''),(1013,'estprpricestockusage','stockusageid',22,'Numeric','','','',''),(1014,'estprpricestockusagecolors','id',22,'Numeric','','','primary unique',''),(1015,'estprpricestockusagecolors','stocklistid',22,'Numeric','','','',''),(1016,'estprpricestockusagecolors','substockcolorsid',22,'Numeric','','','',''),(1017,'estprpricestockusagestock','id',22,'Numeric','','','primary unique',''),(1018,'estprpricestockusagestock','stockusageid',22,'Numeric','','','',''),(1019,'estprpricestockusagestock','proption',11,'Integer','','','',''),(1020,'estprpricestockusagestock','substockid',22,'Numeric','','','',''),(1021,'estprpricestockusagestock','numberout',11,'Integer','','','',''),(1022,'estprpricestockusagestock','cuts',11,'Integer','','','',''),(1023,'estprpricestockusagestock','width',12,'Numeric','','','',''),(1024,'estprpricestockusagestock','length',12,'Numeric','','','',''),(1025,'estprpricestockusagestock','numberup',11,'Integer','','','',''),(1026,'estprpricestockusagestock','addlchargeperm',12,'Numeric','','','',''),(1027,'estprpricestockusagestock','addlminimum',12,'Numeric','','','',''),(1028,'estprpricetools','id',22,'Numeric','','','primary unique',''),(1029,'estprpricetools','name',30,'Text','','','',''),(1030,'estprpricetools','description',100,'Text','','','',''),(1031,'estprpricetools','locationid',22,'Numeric','','','',''),(1032,'estprpricetools','familyid',22,'Numeric','','','',''),(1033,'estprpricetools','gencompanyid',22,'Numeric','','','',''),(1034,'estprpricetools','firsttimeamount',12,'Numeric','','','',''),(1035,'estprpricetools','timesusedcounter',11,'Integer','','','',''),(1036,'estprpricetools','costperuse',12,'Numeric','','','',''),(1037,'estprpricetools','priceperuse',12,'Numeric','','','',''),(1038,'estprpricetools','costperpresshour',12,'Numeric','','','',''),(1039,'estprpricetools','priceperpresshour',12,'Numeric','','','',''),(1040,'estprpricetools','priceperpressqty',12,'Numeric','','','',''),(1041,'estprpricetools','tooltype',11,'Integer','','','',''),(1042,'estprpricetools','repeatlength',7,'Numeric','','','',''),(1043,'estprpricetools','across',11,'Integer','','','',''),(1044,'estprpricetools','around',11,'Integer','','','',''),(1045,'estprpricetools','cavityshape',30,'Text','','','',''),(1046,'estprpricetools','cavitywidth',30,'Text','','','',''),(1047,'estprpricetools','cavitydepth',30,'Text','','','',''),(1048,'estprpricetools','gap',30,'Text','','','',''),(1049,'estprpricetools','bearerwidth',30,'Text','','','',''),(1050,'estprpricetools','gearpitchratio',11,'Integer','','','',''),(1051,'estprpricetools','teeth',11,'Integer','','','',''),(1052,'estprpricetools','addlsetuphrspress',7,'Numeric','','','',''),(1053,'estprpricetools','value',12,'Numeric','','','',''),(1054,'estprpricetools','cancel',11,'Integer','','','',''),(1055,'estprpricetools','canceldate',19,'DateTime','','','',''),(1056,'estprpricetools','canceluserid',22,'Numeric','','','',''),(1057,'estprpricetools','entrydate',19,'DateTime','','','',''),(1058,'estprpricetools','entryuserid',22,'Numeric','','','',''),(1059,'estprpricetools','lastchangedate',19,'DateTime','','','',''),(1060,'estprpricetools','lastchangeuserid',22,'Numeric','','','',''),(1061,'estquote','id',22,'Numeric','','','primary unique',''),(1062,'estquote','quotenum',22,'Numeric','','','',''),(1063,'estquote','subquotenum',11,'Integer','','','',''),(1064,'estquote','customerid',22,'Numeric','','','multiple',''),(1065,'estquote','ponumber',30,'Text','','','',''),(1066,'estquote','priority',11,'Integer','','','',''),(1067,'estquote','duedate',19,'DateTime','','','',''),(1068,'estquote','worktypeid',22,'Numeric','','','',''),(1069,'estquote','jobname',30,'Text','','','',''),(1070,'estquote','jobdesc',65535,'X','','','',''),(1071,'estquote','attn',30,'Text','','','',''),(1072,'estquote','custtrackingnum',20,'Text','','','',''),(1073,'estquote','custchargecode',30,'Text','','','',''),(1074,'estquote','formnumber',20,'Text','','','',''),(1075,'estquote','itemid',22,'Numeric','','','',''),(1076,'estquote','itemcomposite',11,'Integer','','','',''),(1077,'estquote','prpriceid',22,'Numeric','','','',''),(1078,'estquote','finishwidth',7,'Numeric','','','',''),(1079,'estquote','finishheight',7,'Numeric','','','',''),(1080,'estquote','flatwidth',7,'Numeric','','','',''),(1081,'estquote','flatheight',7,'Numeric','','','',''),(1082,'estquote','numpages',22,'Numeric','','','',''),(1083,'estquote','extuser',22,'Numeric','','','',''),(1084,'estquote','genuser',22,'Numeric','','','',''),(1085,'estquote','gencompanyid',22,'Numeric','','','',''),(1086,'estquote','cancel',11,'Integer','','','',''),(1087,'estquote','canceldate',19,'DateTime','','','',''),(1088,'estquote','canceluserid',22,'Numeric','','','',''),(1089,'estquote','entrydate',19,'DateTime','','','',''),(1090,'estquote','entryuserid',22,'Numeric','','','',''),(1091,'estquote','lastchangedate',19,'DateTime','','','',''),(1092,'estquote','lastchangeuserid',22,'Numeric','','','',''),(1093,'estquotebindery','id',22,'Numeric','','','primary unique',''),(1094,'estquotebindery','name',50,'Text','','','',''),(1095,'estquotebindery','gencompanyid',22,'Numeric','','','',''),(1096,'estquotebindery','cancel',11,'Integer','','','',''),(1097,'estquotebindery','canceldate',19,'DateTime','','','',''),(1098,'estquotebindery','canceluserid',22,'Numeric','','','',''),(1099,'estquotebindery','entrydate',19,'DateTime','','','',''),(1100,'estquotebindery','entryuserid',22,'Numeric','','','',''),(1101,'estquotebindery','lastchangedate',19,'DateTime','','','',''),(1102,'estquotebindery','lastchangeuserid',22,'Numeric','','','',''),(1103,'estquotebindery','composition',2,'Integer','','','',''),(1104,'estquotebindery','packaging',2,'Integer','','','',''),(1105,'estquotebinderyaddl','id',22,'Numeric','','','primary unique',''),(1106,'estquotebinderyaddl','estquotebinderyid',22,'Numeric','','','',''),(1107,'estquotebinderyaddl','name',50,'Text','','','',''),(1108,'estquotebinderyaddl','question',65535,'X','','','',''),(1109,'estquotebinderyaddl','validreply',11,'Integer','','','',''),(1110,'estquotebinderyaddl','cancel',11,'Integer','','','',''),(1111,'estquotebinderyaddl','canceldate',19,'DateTime','','','',''),(1112,'estquotebinderyaddl','canceluserid',22,'Numeric','','','',''),(1113,'estquotebinderyaddl','entrydate',19,'DateTime','','','',''),(1114,'estquotebinderyaddl','entryuserid',22,'Numeric','','','',''),(1115,'estquotebinderyaddl','lastchangedate',19,'DateTime','','','',''),(1116,'estquotebinderyaddl','lastchangeuserid',22,'Numeric','','','',''),(1117,'estquotebinderyaddl','qtyperpkg',6,'Numeric','','','',''),(1118,'estquotebinderyaddl','weightpermpkg',7,'Numeric','','','',''),(1119,'estquotebinderyaddl','turnaround',11,'Integer','','','',''),(1120,'estquotebinderyaddl','tooltip',255,'Text','','','',''),(1121,'estquotebinderyaddl','orderflag',11,'Integer','','','',''),(1122,'estquotebinderyaddl','internalonly',2,'Integer','','','',''),(1123,'estquotebinderyaddl','piecework_base',2,'Integer','','','',''),(1124,'estquotebinderyaddl','piecework_name',20,'Text','','','',''),(1125,'estquotebinderyaddloptions','id',22,'Numeric','','','primary unique',''),(1126,'estquotebinderyaddloptions','binderyaddlid',22,'Numeric','','','multiple',''),(1127,'estquotebinderyaddloptions','prompt',20,'Text','','','',''),(1128,'estquotebinderyaddloptions','numprompt',12,'Numeric','','','',''),(1129,'estquotebinderyaddloptions','orderflag',11,'Integer','','','',''),(1130,'estquotebinderyaddloptionsize','id',22,'Numeric','','','primary unique',''),(1131,'estquotebinderyaddloptionsize','binderyaddlid',22,'Numeric','','','multiple',''),(1132,'estquotebinderyaddloptionsize','binderyaddloptionsid',22,'Numeric','','','',''),(1133,'estquotebinderyaddloptionsize','estquotebinderyaddlsizeid',22,'Numeric','','','',''),(1134,'estquotebinderyaddloptionsize','amountaddl',7,'Numeric','','','',''),(1135,'estquotebinderyaddloptionsize','setupaddl',7,'Numeric','','','',''),(1136,'estquotebinderyaddloptionsize','minimumaddl',7,'Numeric','','','',''),(1137,'estquotebinderyaddlsize','id',22,'Numeric','','','primary unique',''),(1138,'estquotebinderyaddlsize','estquotebinderyaddlid',22,'Numeric','','','',''),(1139,'estquotebinderyaddlsize','estquotestdsizeid',22,'Numeric','','','',''),(1140,'estquotebinderyaddlsize','amount',7,'Numeric','','','',''),(1141,'estquotebinderyaddlsize','setupcharge',7,'Numeric','','','',''),(1142,'estquotebinderyaddlsize','minreply',12,'Numeric','','','',''),(1143,'estquotebinderyaddlsize','maxreply',12,'Numeric','','','',''),(1144,'estquotebinderyaddlsize','minimumcharge',7,'Numeric','','','',''),(1145,'estquotebinderyaddlsize','calculatehow',11,'Integer','','','',''),(1146,'estquotebinderyaddlsize','entrydate',19,'DateTime','','','',''),(1147,'estquotebinderyaddlsize','entryuserid',22,'Numeric','','','',''),(1148,'estquotebinderyaddlsize','lastchangedate',19,'DateTime','','','',''),(1149,'estquotebinderyaddlsize','lastchangeuserid',22,'Numeric','','','',''),(1150,'estquotebinderyaddlsize','maxpass',11,'Integer','','','',''),(1151,'estquotebinderyworktype','estquotebinderyid',22,'Numeric','','','multiple',''),(1152,'estquotebinderyworktype','estquoteworktypeid',22,'Numeric','','','',''),(1153,'estquotefile','id',22,'Numeric','','','primary unique',''),(1154,'estquotefile','quoteid',22,'Numeric','','','',''),(1155,'estquotefile','filename',255,'Text','','','multiple',''),(1156,'estquotegenink','id',22,'Numeric','','','primary unique',''),(1157,'estquotegenink','maxcolors',11,'Integer','','','',''),(1158,'estquotegenink','regcharge',6,'Numeric','','','',''),(1159,'estquotegenink','gencompanyid',22,'Numeric','','','multiple',''),(1160,'estquotegenink','namecov1',20,'Text','','','',''),(1161,'estquotegenink','namecov2',20,'Text','','','',''),(1162,'estquotegenink','namecov3',20,'Text','','','',''),(1163,'estquotegenink','namecov4',20,'Text','','','',''),(1164,'estquotegenink','namecov5',20,'Text','','','',''),(1165,'estquotegenink','namecov6',20,'Text','','','',''),(1166,'estquotegenink','namecov7',20,'Text','','','',''),(1167,'estquotegenink','namecov8',20,'Text','','','',''),(1168,'estquotegenink','namecov9',20,'Text','','','',''),(1169,'estquotegenink','covpct1',4,'Numeric','','','',''),(1170,'estquotegenink','covpct2',4,'Numeric','','','',''),(1171,'estquotegenink','covpct3',4,'Numeric','','','',''),(1172,'estquotegenink','covpct4',4,'Numeric','','','',''),(1173,'estquotegenink','covpct5',4,'Numeric','','','',''),(1174,'estquotegenink','covpct6',4,'Numeric','','','',''),(1175,'estquotegenink','covpct7',4,'Numeric','','','',''),(1176,'estquotegenink','covpct8',4,'Numeric','','','',''),(1177,'estquotegenink','covpct9',4,'Numeric','','','',''),(1178,'estquotegenstock','id',22,'Numeric','','','primary unique',''),(1179,'estquotegenstock','name',30,'Text','','','multiple',''),(1180,'estquotegenstock','gencompanyid',22,'Numeric','','','multiple',''),(1181,'estquotegenstock','cancel',11,'Integer','','','',''),(1182,'estquotegenstock','canceldate',19,'DateTime','','','',''),(1183,'estquotegenstock','canceluserid',22,'Numeric','','','',''),(1184,'estquotegenstock','entrydate',19,'DateTime','','','',''),(1185,'estquotegenstock','entryuserid',22,'Numeric','','','',''),(1186,'estquotegenstock','lastchangedate',19,'DateTime','','','',''),(1187,'estquotegenstock','lastchangeuserid',22,'Numeric','','','',''),(1188,'estquotegenstock','orderflag',11,'Integer','','','',''),(1189,'estquoteink','id',22,'Numeric','','','primary unique',''),(1190,'estquoteink','name',50,'Text','','','multiple',''),(1191,'estquoteink','jobprice',8,'Numeric','','','',''),(1192,'estquoteink','mprice',8,'Numeric','','','',''),(1193,'estquoteink','type',11,'Integer','','','',''),(1194,'estquoteink','gencompanyid',22,'Numeric','','','multiple',''),(1195,'estquoteink','costbased',11,'Integer','','','',''),(1196,'estquoteink','costper',8,'Numeric','','','',''),(1197,'estquoteink','coverage',11,'Integer','','','',''),(1198,'estquotepricelist','id',22,'Numeric','','','primary unique',''),(1199,'estquotepricelist','stdsizeid',22,'Numeric','','','',''),(1200,'estquotepricelist','worktypeid',22,'Numeric','','','',''),(1201,'estquotepricelist','name',50,'Text','','','',''),(1202,'estquotepricelist','cancel',11,'Integer','','','',''),(1203,'estquotepricelist','canceldate',19,'DateTime','','','',''),(1204,'estquotepricelist','canceluserid',22,'Numeric','','','',''),(1205,'estquotepricelist','entrydate',19,'DateTime','','','',''),(1206,'estquotepricelist','entryuserid',22,'Numeric','','','',''),(1207,'estquotepricelist','lastchangeuserid',22,'Numeric','','','',''),(1208,'estquotepricelist','lastchangedate',19,'DateTime','','','',''),(1209,'estquotepricelist','gencompanyid',22,'Numeric','','','',''),(1210,'estquotepricelist','maxinkside1',11,'Integer','','','',''),(1211,'estquotepricelist','maxinkside2',11,'Integer','','','',''),(1212,'estquotepricelist','trimchargepermpercut',10,'Numeric','','','',''),(1213,'estquotepricelist','trimmincharge',10,'Numeric','','','',''),(1214,'estquotepricelist','qtyperbox',6,'Numeric','','','',''),(1215,'estquotepricelist','notes',65535,'X','','','',''),(1216,'estquotepricelist','point2id',22,'Numeric','','','',''),(1217,'estquotepricelistprice','id',22,'Numeric','','','primary unique',''),(1218,'estquotepricelistprice','pricelistid',22,'Numeric','','','',''),(1219,'estquotepricelistprice','quantity',11,'Numeric','','','',''),(1220,'estquotepricelistprice','priceperm',8,'Numeric','','','',''),(1221,'estquotepriceliststock','id',22,'Numeric','','','primary unique',''),(1222,'estquotepriceliststock','pricelistid',22,'Numeric','','','',''),(1223,'estquotepriceliststock','genstockid',22,'Numeric','','','',''),(1224,'estquotepriceliststock','substockid',22,'Numeric','','','',''),(1225,'estquotepriceliststock','addlchargeperm',8,'Numeric','','','',''),(1226,'estquotepriceliststock','addlmincharge',8,'Numeric','','','',''),(1227,'estquotepriceliststock','default_partno',50,'Text','','','',''),(1228,'estquotepriceliststock','default_number_up',11,'Integer','','','',''),(1229,'estquotepriceliststock','default_parts',11,'Integer','','','',''),(1230,'estquotepriceliststockcolors','id',22,'Numeric','','','primary unique',''),(1231,'estquotepriceliststockcolors','priceliststockid',22,'Numeric','','','',''),(1232,'estquotepriceliststockcolors','substockcolorsid',22,'Numeric','','','',''),(1233,'estquotepriceliststockcolors','default_partno',30,'Text','','','',''),(1234,'estquoteqty','id',22,'Numeric','','','primary unique',''),(1235,'estquoteqty','quoteid',22,'Numeric','','','multiple',''),(1236,'estquoteqty','qty',22,'Numeric','','','',''),(1237,'estquotequest','id',22,'Numeric','','','primary unique',''),(1238,'estquotequest','quoteid',22,'Numeric','','','multiple',''),(1239,'estquotequest','questionid',22,'Numeric','','','',''),(1240,'estquotequest','yesno',11,'Integer','','','',''),(1241,'estquotequest','selection',22,'Numeric','','','',''),(1242,'estquotequest','text',50,'Text','','','',''),(1243,'estquotequote','id',22,'Numeric','','','primary unique',''),(1244,'estquotequote','customerid',22,'Numeric','','','multiple',''),(1245,'estquotequote','contactname',50,'Text','','','',''),(1246,'estquotequote','stdsizeid',22,'Numeric','','','',''),(1247,'estquotequote','cwidth',12,'Numeric','','','',''),(1248,'estquotequote','clength',12,'Numeric','','','',''),(1249,'estquotequote','substockid',22,'Numeric','','','',''),(1250,'estquotequote','tightreg1',11,'Integer','','','',''),(1251,'estquotequote','tightreg2',11,'Integer','','','',''),(1252,'estquotequote','gencompanyid',22,'Numeric','','','',''),(1253,'estquotequote','cancel',11,'Integer','','','',''),(1254,'estquotequote','canceldate',19,'DateTime','','','',''),(1255,'estquotequote','canceluserid',22,'Numeric','','','',''),(1256,'estquotequote','entrydate',19,'DateTime','','','',''),(1257,'estquotequote','entryuserid',22,'Numeric','','','',''),(1258,'estquotequote','lastchangedate',19,'DateTime','','','',''),(1259,'estquotequote','lastchangeuserid',22,'Numeric','','','',''),(1260,'estquotequote','description',255,'Text','','','',''),(1261,'estquotequote','substockcolorid',22,'Numeric','','','',''),(1262,'estquotequote','shippingservice',3,'Text','','','',''),(1263,'estquotequote','shippingzipcode',12,'Text','','','',''),(1264,'estquotequote','special',255,'Text','','','',''),(1265,'estquotequote','quotenum',20,'Text','','','',''),(1266,'estquotequote','extuser',22,'Numeric','','','',''),(1267,'estquotequote','genuser',22,'Numeric','','','',''),(1268,'estquotequote','pricelistid',22,'Numeric','','','',''),(1269,'estquotequote','duedate',10,'Date','','','multiple',''),(1270,'estquotequote','finalshipdate',10,'Date','','','multiple',''),(1271,'estquotequote','status',5,'Integer','','','',''),(1272,'estquotequote','billdate',10,'Date','','','',''),(1273,'estquotequote','order_quantity',11,'Integer','','','',''),(1274,'estquotequote','shiptotal',14,'Numeric','','','',''),(1275,'estquotequote','billtotal',14,'Numeric','','','',''),(1276,'estquotequote','orderdate',10,'Date','','','multiple',''),(1277,'estquotequote','instructions',255,'Text','','','',''),(1278,'estquotequote','id_printorder',11,'Integer','','','multiple',''),(1279,'estquotequote','extras',11,'Integer','','','',''),(1280,'estquotequote','numup',11,'Integer','','','',''),(1281,'estquotequote','itemid',11,'Integer','','','multiple',''),(1282,'estquotequote','papername',50,'Text','','','',''),(1283,'estquotequote','paperwidth',14,'Numeric','','','',''),(1284,'estquotequote','paperlength',14,'Numeric','','','',''),(1285,'estquotequote','priority',2,'Integer','','','',''),(1286,'estquotequote','formnumber',50,'Text','','','multiple',''),(1287,'estquotequote','numparts',11,'Integer','','','',''),(1288,'estquotequote','presswidth',14,'Numeric','','','',''),(1289,'estquotequote','presslength',14,'Numeric','','','',''),(1290,'estquotequote','customer_po',30,'Text','','','',''),(1291,'estquotequote','print_how',2,'Integer','','','',''),(1292,'estquotequote','salesglacctid',11,'Integer','','','',''),(1293,'estquotequote','rush_charge',14,'Numeric','','','',''),(1294,'estquotequote','composition_charge',14,'Numeric','','','',''),(1295,'estquotequote','glrush',11,'Integer','','','',''),(1296,'estquotequote','glcomposition',11,'Integer','','','',''),(1297,'estquotequote_instructions','id',11,'Integer','','','primary',''),(1298,'estquotequote_instructions','quoteid',11,'Integer','','','multiple',''),(1299,'estquotequote_instructions','workareaid',11,'Integer','','','multiple',''),(1300,'estquotequote_instructions','instructions',255,'Text','','','',''),(1301,'estquotequote_shipment','id_shipment',11,'Integer','','','primary',''),(1302,'estquotequote_shipment','id_order_shipto',11,'Integer','','','multiple',''),(1303,'estquotequote_shipment','quantity',15,'Integer','','','',''),(1304,'estquotequote_shipment','shipdate',19,'DateTime','','','',''),(1305,'estquotequote_shipment','id_shipmentlog',11,'Integer','','','',''),(1306,'estquotequote_shipment','packslip',2,'Integer','','','',''),(1307,'estquotequote_shipment','boxlabel',2,'Integer','','','',''),(1308,'estquotequote_shipment','logdate',19,'DateTime','','','',''),(1309,'estquotequote_shipment','createdate',10,'Date','','','',''),(1310,'estquotequote_shipment','id_user_create',11,'Integer','','','',''),(1311,'estquotequote_shipment','lastrevisedate',19,'DateTime','','','',''),(1312,'estquotequote_shipment','id_user_revise',11,'Integer','','','',''),(1313,'estquotequote_shipment','canceldate',10,'Date','','','',''),(1314,'estquotequote_shipment','cancel',11,'Integer','','','',''),(1315,'estquotequote_shipment','signfor',255,'Text','','','',''),(1316,'estquotequote_shipment','failed',11,'Integer','','','',''),(1317,'estquotequote_shipment','id_printorder',11,'Integer','','','multiple',''),(1318,'estquotequote_shipment','notes',255,'Text','','','',''),(1319,'estquotequote_shipment','id_order_shipment_group',11,'Integer','','','multiple',''),(1320,'estquotequote_shipment','trackingnum',30,'Text','','','',''),(1321,'estquotequote_shipment','invoiceid',11,'Integer','','','',''),(1322,'estquotequote_shipment','carrierserviceid',11,'Integer','','','',''),(1323,'estquotequote_shipment','freight',14,'Numeric','','','',''),(1324,'estquotequote_shipment','numperbox',11,'Integer','','','',''),(1325,'estquotequote_shipment','numboxes',11,'Integer','','','',''),(1326,'estquotequote_shipment','id_estquoteship',11,'Integer','','','',''),(1327,'estquotequotebindquest','id',22,'Numeric','','','primary unique',''),(1328,'estquotequotebindquest','quoteid',22,'Numeric','','','multiple',''),(1329,'estquotequotebindquest','questionid',22,'Numeric','','','',''),(1330,'estquotequotebindquest','yesno',11,'Integer','','','',''),(1331,'estquotequotebindquest','numbetween',22,'Numeric','','','',''),(1332,'estquotequotebindquest','text',50,'Text','','','',''),(1333,'estquotequoteink','id',22,'Numeric','','','primary unique',''),(1334,'estquotequoteink','quoteid',22,'Numeric','','','multiple',''),(1335,'estquotequoteink','side',11,'Integer','','','',''),(1336,'estquotequoteink','inkid',22,'Numeric','','','',''),(1337,'estquotequoteink','pms',4,'Text','','','',''),(1338,'estquotequotenotes','id',22,'Numeric','','','primary unique',''),(1339,'estquotequotenotes','quotebold',50,'Text','','','',''),(1340,'estquotequotenotes','quotetext',65535,'X','','','',''),(1341,'estquotequotenotes','showwhen',11,'Integer','','','',''),(1342,'estquotequotenotes','orderflag',11,'Integer','','','',''),(1343,'estquotequotenotes','gencompanyid',22,'Numeric','','','',''),(1344,'estquotequotenotes','entrydate',19,'DateTime','','','',''),(1345,'estquotequotenotes','entryuserid',22,'Numeric','','','',''),(1346,'estquotequotenotes','lastchangeuserid',22,'Numeric','','','',''),(1347,'estquotequotenotes','lastchangedate',19,'DateTime','','','',''),(1348,'estquotequoteqty','id',22,'Numeric','','','primary unique',''),(1349,'estquotequoteqty','quoteid',22,'Numeric','','','multiple',''),(1350,'estquotequoteqty','qty',22,'Numeric','','','',''),(1351,'estquotequoteqty','weight',12,'Numeric','','','',''),(1352,'estquotequoteqty','total',12,'Numeric','','','',''),(1353,'estquotequoteqty','shipcost',12,'Numeric','','','',''),(1354,'estquotequoteqty','turnaround',11,'Integer','','','',''),(1355,'estquotequoteqty','mcost',12,'Numeric','','','',''),(1356,'estquotequoteqty','boxes',11,'Integer','','','',''),(1357,'estquotequoteqty','comptotal',22,'Numeric','','','',''),(1358,'estquotequotequest','id',22,'Numeric','','','primary unique',''),(1359,'estquotequotequest','quoteid',22,'Numeric','','','multiple',''),(1360,'estquotequotequest','questionid',22,'Numeric','','','',''),(1361,'estquotequotequest','yesno',11,'Integer','','','',''),(1362,'estquotequotequest','numbetween',22,'Numeric','','','',''),(1363,'estquotequotequest','text',50,'Text','','','',''),(1364,'estquoteship','id',22,'Numeric','','','primary',''),(1365,'estquoteship','id_printorder',22,'Numeric','','','multiple',''),(1366,'estquoteship','shiptoid',22,'Numeric','','','multiple',''),(1367,'estquoteship','carrierserviceid',22,'Numeric','','','multiple',''),(1368,'estquoteship','shipqty',22,'Numeric','','','',''),(1369,'estquoteship','attn',30,'Text','','','',''),(1370,'estquoteship','client_po',30,'Text','','','',''),(1371,'estquoteship','weight',22,'Numeric','','','',''),(1372,'estquoteship','cost',22,'Numeric','','','',''),(1373,'estquoteship','boxes',11,'Integer','','','',''),(1374,'estquoteship','zipcode',12,'Text','','','',''),(1375,'estquoteship','qtyperfullbox',11,'Integer','','','',''),(1376,'estquoteship','packages',11,'Integer','','','',''),(1377,'estquoteship','invoiceid',11,'Integer','','','',''),(1378,'estquoteship','client_name',100,'Text','','','',''),(1379,'estquotestdsize','id',22,'Numeric','','','primary unique',''),(1380,'estquotestdsize','length',12,'Numeric','','','',''),(1381,'estquotestdsize','width',12,'Numeric','','','',''),(1382,'estquotestdsize','gencompanyid',22,'Numeric','','','',''),(1383,'estquotestdsize','orderflag',11,'Integer','','','',''),(1384,'estquotestock','id',22,'Numeric','','','primary unique',''),(1385,'estquotestock','quoteid',22,'Numeric','','','multiple',''),(1386,'estquotestock','stockusageid',22,'Numeric','','','multiple',''),(1387,'estquotestock','stocklistid',22,'Numeric','','','multiple',''),(1388,'estquotestock','flatwidth',7,'Numeric','','','',''),(1389,'estquotestock','flatheight',7,'Numeric','','','',''),(1390,'estquotestock','numpages',22,'Numeric','','','',''),(1391,'estquotestock','notes',65535,'X','','','',''),(1392,'estquotestockink','id',22,'Numeric','','','primary unique',''),(1393,'estquotestockink','quotestockid',22,'Numeric','','','multiple',''),(1394,'estquotestockink','inkid',22,'Numeric','','','multiple',''),(1395,'estquotestockink','side',11,'Integer','','','',''),(1396,'estquotestockink','inknum',11,'Integer','','','',''),(1397,'estquotestockink','coverage',7,'Numeric','','','',''),(1398,'estquotestocktool','id',22,'Numeric','','','primary unique',''),(1399,'estquotestocktool','quotestockid',22,'Numeric','','','multiple',''),(1400,'estquotestocktool','toolid',22,'Numeric','','','multiple',''),(1401,'estquotesubstock','id',22,'Numeric','','','primary unique',''),(1402,'estquotesubstock','estquotegenstockid',22,'Numeric','','','multiple',''),(1403,'estquotesubstock','name',50,'Text','','','multiple',''),(1404,'estquotesubstock','weight',8,'Numeric','','','',''),(1405,'estquotesubstock','turnaround',11,'Integer','','','',''),(1406,'estquotesubstock','orderflag',11,'Integer','','','',''),(1407,'estquotesubstock','parts',11,'Integer','','','',''),(1408,'estquotesubstock','inchesperm',6,'Numeric','','','',''),(1409,'estquotesubstockcolors','id',22,'Numeric','','','primary unique',''),(1410,'estquotesubstockcolors','substockid',22,'Numeric','','','multiple',''),(1411,'estquotesubstockcolors','color',50,'Text','','','multiple',''),(1412,'estquotesubstockcolorsize','id',11,'Integer','','','primary unique',''),(1413,'estquotesubstockcolorsize','substockid',11,'Integer','','','multiple',''),(1414,'estquotesubstockcolorsize','substockcolorid',11,'Integer','','','multiple',''),(1415,'estquotesubstockcolorsize','sizename',20,'Text','','','',''),(1416,'estquotesubstockcolorsize','partno',50,'Text','','','multiple',''),(1417,'estquotesubstockcost','id',22,'Numeric','','','primary unique',''),(1418,'estquotesubstockcost','substockid',22,'Numeric','','','multiple',''),(1419,'estquotesubstockcost','stocktype',11,'Integer','','','',''),(1420,'estquotesubstockcost','length',12,'Numeric','','','multiple',''),(1421,'estquotesubstockcost','width',12,'Numeric','','','multiple',''),(1422,'estquotesubstockcost','cost',12,'Numeric','','','multiple',''),(1423,'estquotesubstockcost','costhow',11,'Integer','','','',''),(1424,'estquotesubstockcost','itemid',22,'Numeric','','','multiple',''),(1425,'estquotesubstocksize','id',11,'Integer','','','primary unique',''),(1426,'estquotesubstocksize','substockid',11,'Integer','','','multiple',''),(1427,'estquotesubstocksize','sizename',20,'Text','','','',''),(1428,'estquotesubstocksize','partno',50,'Text','','','multiple',''),(1429,'estquoteworktype','id',22,'Numeric','','','primary unique',''),(1430,'estquoteworktype','name',50,'Text','','','',''),(1431,'estquoteworktype','turnaroundqty',11,'Numeric','','','',''),(1432,'estquoteworktype','turnarounddaysuptoqty',11,'Integer','','','',''),(1433,'estquoteworktype','turnarounddaysoverqty',11,'Integer','','','',''),(1434,'estquoteworktype','gencompanyid',22,'Numeric','','','',''),(1435,'estquoteworktype','cancel',11,'Integer','','','',''),(1436,'estquoteworktype','canceldate',19,'DateTime','','','',''),(1437,'estquoteworktype','canceluserid',22,'Numeric','','','',''),(1438,'estquoteworktype','entrydate',19,'DateTime','','','',''),(1439,'estquoteworktype','entryuserid',22,'Numeric','','','',''),(1440,'estquoteworktype','lastchangeuserid',22,'Numeric','','','',''),(1441,'estquoteworktype','lastchangedate',19,'DateTime','','','',''),(1442,'estquoteworktype','notes',65535,'X','','','',''),(1443,'estquoteworktype','genworktypeid',22,'Numeric','','','',''),(1444,'estquoteworktype','orderflag',11,'Integer','','','',''),(1445,'estquoteworktypeaddl','id',22,'Numeric','','','primary unique',''),(1446,'estquoteworktypeaddl','worktypeid',22,'Numeric','','','',''),(1447,'estquoteworktypeaddl','question',50,'Text','','','',''),(1448,'estquoteworktypeaddl','validreply',11,'Integer','','','',''),(1449,'estquoteworktypeaddl','minreply',12,'Numeric','','','',''),(1450,'estquoteworktypeaddl','maxreply',12,'Numeric','','','',''),(1451,'estquoteworktypeaddl','askonlyifmtblackink',11,'Integer','','','',''),(1452,'estquoteworktypeaddl','askonlyifmtoneink',11,'Integer','','','',''),(1453,'estquoteworktypeaddl','askonlyminsizelength',12,'Numeric','','','',''),(1454,'estquoteworktypeaddl','askonlyminsizewidth',12,'Numeric','','','',''),(1455,'estquoteworktypeaddl','askonlymaxsizelength',12,'Numeric','','','',''),(1456,'estquoteworktypeaddl','askonlymaxsizewidth',12,'Numeric','','','',''),(1457,'estquoteworktypeaddl','calculatehow',11,'Integer','','','',''),(1458,'estquoteworktypeaddl','cancel',11,'Integer','','','',''),(1459,'estquoteworktypeaddl','canceldate',19,'DateTime','','','',''),(1460,'estquoteworktypeaddl','canceluserid',22,'Numeric','','','',''),(1461,'estquoteworktypeaddl','entrydate',19,'DateTime','','','',''),(1462,'estquoteworktypeaddl','entryuserid',22,'Numeric','','','',''),(1463,'estquoteworktypeaddl','lastchangedate',19,'DateTime','','','',''),(1464,'estquoteworktypeaddl','lastchangeuserid',22,'Numeric','','','',''),(1465,'estquoteworktypeaddl','askonlyifmtoneside',11,'Integer','','','',''),(1466,'estquoteworktypeaddl','amount',7,'Numeric','','','',''),(1467,'estquoteworktypeaddl','askonlyifoneink',11,'Integer','','','',''),(1468,'estquoteworktypeaddl','aboveqty',12,'Numeric','','','',''),(1469,'estquoteworktypegen','id',22,'Numeric','','','primary unique',''),(1470,'estquoteworktypegen','name',50,'Text','','','',''),(1471,'estquoteworktypegen','gencompanyid',22,'Numeric','','','',''),(1472,'estquoteworktypegen','orderflag',11,'Integer','','','',''),(1473,'estquoteworktypegen','cancel',11,'Integer','','','',''),(1474,'estquoteworktypegen','canceldate',19,'DateTime','','','',''),(1475,'estquoteworktypegen','canceluserid',22,'Numeric','','','',''),(1476,'estquoteworktypegen','entrydate',19,'DateTime','','','',''),(1477,'estquoteworktypegen','entryuserid',22,'Numeric','','','',''),(1478,'estquoteworktypegen','lastchangedate',19,'DateTime','','','',''),(1479,'estquoteworktypegen','lastchangeuserid',22,'Numeric','','','',''),(1480,'estquoteworktypestdqty','id',22,'Numeric','','','primary unique',''),(1481,'estquoteworktypestdqty','quantity',11,'Numeric','','','',''),(1482,'estquoteworktypestdqty','worktypeid',22,'Numeric','','','',''),(1483,'extuser','id',22,'Numeric','','','primary unique',''),(1484,'extuser','name',30,'Text','','','',''),(1485,'extuser','password',50,'Text','','','',''),(1486,'extuser','customer',11,'Integer','','','',''),(1487,'extuser','vendor',11,'Integer','','','',''),(1488,'extuser','cancel',11,'Integer','','','',''),(1489,'extuser','stylesheetid',11,'Integer','','','',''),(1490,'extuser','canceldate',19,'DateTime','','','',''),(1491,'extuser','canceluserid',22,'Numeric','','','',''),(1492,'extuser','entrydate',19,'DateTime','','','',''),(1493,'extuser','entryuserid',22,'Numeric','','','',''),(1494,'extuser','lastchangedate',19,'DateTime','','','',''),(1495,'extuser','lastchangeuserid',22,'Numeric','','','',''),(1496,'extuser','deflanguageid',11,'Integer','','','',''),(1497,'extuser','fullname',100,'Text','','','',''),(1498,'family','id_family',11,'Integer','','','primary unique',''),(1499,'family','name',50,'Text','','','',''),(1500,'family','id_workarea',11,'Integer','','','',''),(1501,'family','imptype',3,'Integer','','','',''),(1502,'family','iph',14,'Integer','','','',''),(1503,'family','iphtwo',14,'Integer','','','',''),(1504,'family','clickprice',7,'Numeric','','','',''),(1505,'family','clickpricetwo',7,'Numeric','','','',''),(1506,'family','maximpressionsperday',16,'Numeric','','','',''),(1507,'family','createdate',19,'DateTime','','','',''),(1508,'family','id_user_create',11,'Integer','','','',''),(1509,'family','lastrevisedate',19,'DateTime','','','',''),(1510,'family','id_user_revise',11,'Integer','','','',''),(1511,'family','canceldate',19,'DateTime','','','',''),(1512,'family','cancel',11,'Integer','','','',''),(1513,'family','gencompanyid',11,'Integer','','','',''),(1514,'family','maxwidth',12,'Numeric','','','',''),(1515,'family','maxlength',12,'Numeric','','','',''),(1516,'family','minwidth',12,'Numeric','','','',''),(1517,'family','minlength',12,'Numeric','','','',''),(1518,'family','mincolors',11,'Integer','','','',''),(1519,'family','maxcolors',11,'Integer','','','',''),(1520,'family','maxcolors_two',11,'Integer','','','',''),(1521,'family','maxcolors_one_if_two',11,'Integer','','','',''),(1522,'family','iphunits',3,'Integer','','','',''),(1523,'family_iph','id_family_iph',11,'Integer','','','primary',''),(1524,'family_iph','id_family',11,'Integer','','','multiple',''),(1525,'family_iph','multiplier',7,'Numeric','','','',''),(1526,'family_iph','len',12,'Numeric','','','',''),(1527,'family_iph','wt',12,'Numeric','','','',''),(1528,'family_iph','greater_or_less',1,'Integer','','','',''),(1529,'family_iph','sizeormwt',1,'Integer','','','',''),(1530,'family_iph','price',7,'Numeric','','','',''),(1531,'family_iph','createdate',19,'DateTime','','','',''),(1532,'family_iph','id_user_create',11,'Integer','','','',''),(1533,'family_iph','lastrevisedate',19,'DateTime','','','',''),(1534,'family_iph','id_user_revise',11,'Integer','','','',''),(1535,'family_iph','canceldate',19,'DateTime','','','',''),(1536,'family_iph','cancel',11,'Integer','','','',''),(1537,'family_price','id_family_price',11,'Integer','','','primary unique',''),(1538,'family_price','id_family',11,'Integer','','','multiple',''),(1539,'family_price','qty_over',15,'Integer','','','',''),(1540,'family_price','price_1_sided',17,'Numeric','','','',''),(1541,'family_price','price_2_sided',17,'Numeric','','','',''),(1542,'family_price','createdate',19,'DateTime','','','',''),(1543,'family_price','id_user_create',11,'Integer','','','',''),(1544,'family_price','lastrevisedate',19,'DateTime','','','',''),(1545,'family_price','id_user_revise',11,'Integer','','','',''),(1546,'family_price','canceldate',19,'DateTime','','','',''),(1547,'family_price','cancel',11,'Integer','','','',''),(1548,'filedata','id',11,'Integer','','','primary',''),(1549,'filedata','fileitemid',11,'Integer','','','multiple',''),(1550,'filedata','filedata',65535,'X','','','',''),(1551,'filedefinition','id',11,'Integer','','','primary',''),(1552,'filedefinition','table_name',100,'Text','','','multiple',''),(1553,'filedefinition','file_function',11,'Integer','','','',''),(1554,'filedefinition','notes',65535,'X','','','',''),(1555,'filedefinition','prompt',255,'Text','','','',''),(1556,'filedefinition','upload_limit',11,'Integer','','','',''),(1557,'filedefinition','modaccess',150,'Text','','','',''),(1558,'filedefinition','modbit',20,'Text','','','',''),(1559,'fileitem','id',11,'Integer','','','primary',''),(1560,'fileitem','filedefinitionid',11,'Integer','','','multiple',''),(1561,'fileitem','tablerecordid',11,'Integer','','','multiple',''),(1562,'fileitem','filename',255,'Text','','','',''),(1563,'fileitem','display_type',11,'Integer','','','',''),(1564,'fileitem','datatype',60,'Text','','','',''),(1565,'fileitem','size',20,'Integer','','','',''),(1566,'fileitem','filedate',19,'DateTime','','','',''),(1567,'fileitem','companyid',11,'Integer','','','',''),(1568,'fileitem','entryuserid',11,'Integer','','','multiple',''),(1569,'fileitem','notes',65535,'X','','','',''),(1570,'gencompany','id',11,'Integer','','','primary unique',''),(1571,'gencompany','address1',100,'Text','','','',''),(1572,'gencompany','address2',100,'Text','','','',''),(1573,'gencompany','city',50,'Text','','','',''),(1574,'gencompany','state',20,'Text','','','',''),(1575,'gencompany','zip',15,'Text','','','',''),(1576,'gencompany','country',20,'Text','','','',''),(1577,'gencompany','phone1',20,'Text','','','',''),(1578,'gencompany','phone2',20,'Text','','','',''),(1579,'gencompany','phone3',20,'Text','','','',''),(1580,'gencompany','phone4',20,'Text','','','',''),(1581,'gencompany','email',50,'Text','','','',''),(1582,'gencompany','web',100,'Text','','','',''),(1583,'gencompany','name',50,'Text','','','',''),(1584,'gencompany','active',11,'Integer','','','',''),(1585,'gencompany','graphicurl',200,'Text','','','',''),(1586,'gencompany','graphicurl_big',200,'Text','','','',''),(1587,'gencompany','menucolor',11,'Integer','','','',''),(1588,'gencompany','lastupdateuserid',11,'Integer','','','',''),(1589,'gencompany','lastupdatedate',19,'DateTime','','','',''),(1590,'genmessage','id',22,'Numeric','','','primary unique',''),(1591,'genmessage','userid',22,'Numeric','','','multiple',''),(1592,'genmessage','sourceuserid',22,'Numeric','','','',''),(1593,'genmessage','entrydate',19,'DateTime','','','',''),(1594,'genmessage','readdate',19,'DateTime','','','',''),(1595,'genmessage','message',65535,'X','','','',''),(1596,'genprint','id',11,'Integer','','','',''),(1597,'genprint','special_order_markup',8,'Numeric','','','',''),(1598,'genprint','outside_vended_markup',8,'Numeric','','','',''),(1599,'genprint','qty_unitid',11,'Integer','','','',''),(1600,'genprint','price_unitid',11,'Integer','','','',''),(1601,'genprint','conversion',11,'Integer','','','',''),(1602,'genprint','overdays',5,'Integer','','','',''),(1603,'genprint','first_timeframe',11,'Integer','','','',''),(1604,'genprint','second_timeframe',11,'Integer','','','',''),(1605,'genprint','glrush',11,'Integer','','','',''),(1606,'genprint','glcomposition',11,'Integer','','','',''),(1607,'genstate','id',22,'Numeric','','','primary unique',''),(1608,'genstate','stateinit',3,'Text','','','multiple unique',''),(1609,'genstate','statename',30,'Text','','','',''),(1610,'genstylesheet','id',11,'Integer','','','primary unique',''),(1611,'genstylesheet','name',50,'Text','','',' unique',''),(1612,'genstylesheet','filename',50,'Text','','',' unique',''),(1613,'genuser','id',22,'Numeric','','','primary unique',''),(1614,'genuser','name',50,'Text','','','multiple unique',''),(1615,'genuser','password',64,'Text','','','',''),(1616,'genuser','raccessap',11,'Integer','','','',''),(1617,'genuser','raccessar',11,'Integer','','','',''),(1618,'genuser','raccessgl',11,'Integer','','','',''),(1619,'genuser','raccesspay',11,'Integer','','','',''),(1620,'genuser','raccessinv',11,'Integer','','','',''),(1621,'genuser','raccessest',11,'Integer','','','',''),(1622,'genuser','raccessfix',11,'Integer','','','',''),(1623,'genuser','raccessimp',11,'Integer','','','',''),(1624,'genuser','waccessap',11,'Integer','','','',''),(1625,'genuser','waccessar',11,'Integer','','','',''),(1626,'genuser','waccessgl',11,'Integer','','','',''),(1627,'genuser','waccesspay',11,'Integer','','','',''),(1628,'genuser','waccessinv',11,'Integer','','','',''),(1629,'genuser','waccessest',11,'Integer','','','',''),(1630,'genuser','waccessfix',11,'Integer','','','',''),(1631,'genuser','waccessimp',11,'Integer','','','',''),(1632,'genuser','saccessap',11,'Integer','','','',''),(1633,'genuser','saccessar',11,'Integer','','','',''),(1634,'genuser','saccessgl',11,'Integer','','','',''),(1635,'genuser','saccesspay',11,'Integer','','','',''),(1636,'genuser','saccessinv',11,'Integer','','','',''),(1637,'genuser','saccessest',11,'Integer','','','',''),(1638,'genuser','saccessfix',11,'Integer','','','',''),(1639,'genuser','saccessimp',11,'Integer','','','',''),(1640,'genuser','supervisor',11,'Integer','','','',''),(1641,'genuser','active',11,'Integer','','','',''),(1642,'genuser','stylesheetid',11,'Integer','','','',''),(1643,'genuser','deflanguage',11,'Integer','','','',''),(1644,'genuser','email',100,'Text','','','',''),(1645,'genuser','logon_attempts',4,'Integer','','','',''),(1646,'genuser','firstname',35,'Text','','','',''),(1647,'genuser','lastname',35,'Text','','','',''),(1648,'genuser','cancel',11,'Integer','','','',''),(1649,'genuser','admin',2,'Integer','','','',''),(1650,'genuser','raccesssc',11,'Integer','','','',''),(1651,'genuser','waccesssc',11,'Integer','','','',''),(1652,'genuser','saccesssc',11,'Integer','','','',''),(1653,'genuser','employeeid',11,'Integer','','','',''),(1654,'genusercompany','genuser_id',22,'Numeric','','','',''),(1655,'genusercompany','gencompanyid',11,'Integer','','','',''),(1656,'genusercompany','lasthome',20,'Text','','','',''),(1657,'genusercompany','raccessap',2,'Integer','','','',''),(1658,'genusercompany','raccessar',2,'Integer','','','',''),(1659,'genusercompany','raccessgl',2,'Integer','','','',''),(1660,'genusercompany','raccesspay',2,'Integer','','','',''),(1661,'genusercompany','raccessinv',2,'Integer','','','',''),(1662,'genusercompany','raccessest',2,'Integer','','','',''),(1663,'genusercompany','raccessfix',2,'Integer','','','',''),(1664,'genusercompany','raccessimp',2,'Integer','','','',''),(1665,'genusercompany','raccesssc',2,'Integer','','','',''),(1666,'genusercompany','waccessap',2,'Integer','','','',''),(1667,'genusercompany','waccessar',2,'Integer','','','',''),(1668,'genusercompany','waccessgl',2,'Integer','','','',''),(1669,'genusercompany','waccesspay',2,'Integer','','','',''),(1670,'genusercompany','waccessinv',2,'Integer','','','',''),(1671,'genusercompany','waccessest',2,'Integer','','','',''),(1672,'genusercompany','waccessfix',2,'Integer','','','',''),(1673,'genusercompany','waccessimp',2,'Integer','','','',''),(1674,'genusercompany','waccesssc',2,'Integer','','','',''),(1675,'genusercompany','saccessap',2,'Integer','','','',''),(1676,'genusercompany','saccessar',2,'Integer','','','',''),(1677,'genusercompany','saccessgl',2,'Integer','','','',''),(1678,'genusercompany','saccesspay',2,'Integer','','','',''),(1679,'genusercompany','saccessinv',2,'Integer','','','',''),(1680,'genusercompany','saccessest',2,'Integer','','','',''),(1681,'genusercompany','saccessfix',2,'Integer','','','',''),(1682,'genusercompany','saccessimp',2,'Integer','','','',''),(1683,'genusercompany','saccesssc',2,'Integer','','','',''),(1684,'genusercompany','supervisor',2,'Integer','','','',''),(1685,'genusercompany_temp','genuser_id',22,'Numeric','','','',''),(1686,'genusercompany_temp','gencompanyid',11,'Integer','','','',''),(1687,'genusercompany_temp','raccessap',2,'Integer','','','',''),(1688,'genusercompany_temp','raccessar',2,'Integer','','','',''),(1689,'genusercompany_temp','raccessgl',2,'Integer','','','',''),(1690,'genusercompany_temp','raccesspay',2,'Integer','','','',''),(1691,'genusercompany_temp','raccessinv',2,'Integer','','','',''),(1692,'genusercompany_temp','raccessest',2,'Integer','','','',''),(1693,'genusercompany_temp','raccessfix',2,'Integer','','','',''),(1694,'genusercompany_temp','raccessimp',2,'Integer','','','',''),(1695,'genusercompany_temp','raccesssc',2,'Integer','','','',''),(1696,'genusercompany_temp','waccessap',2,'Integer','','','',''),(1697,'genusercompany_temp','waccessar',2,'Integer','','','',''),(1698,'genusercompany_temp','waccessgl',2,'Integer','','','',''),(1699,'genusercompany_temp','waccesspay',2,'Integer','','','',''),(1700,'genusercompany_temp','waccessinv',2,'Integer','','','',''),(1701,'genusercompany_temp','waccessest',2,'Integer','','','',''),(1702,'genusercompany_temp','waccessfix',2,'Integer','','','',''),(1703,'genusercompany_temp','waccessimp',2,'Integer','','','',''),(1704,'genusercompany_temp','waccesssc',2,'Integer','','','',''),(1705,'genusercompany_temp','saccessap',2,'Integer','','','',''),(1706,'genusercompany_temp','saccessar',2,'Integer','','','',''),(1707,'genusercompany_temp','saccessgl',2,'Integer','','','',''),(1708,'genusercompany_temp','saccesspay',2,'Integer','','','',''),(1709,'genusercompany_temp','saccessinv',2,'Integer','','','',''),(1710,'genusercompany_temp','saccessest',2,'Integer','','','',''),(1711,'genusercompany_temp','saccessfix',2,'Integer','','','',''),(1712,'genusercompany_temp','saccessimp',2,'Integer','','','',''),(1713,'genusercompany_temp','saccesssc',2,'Integer','','','',''),(1714,'genusercompany_temp','supervisor',2,'Integer','','','',''),(1715,'genuserhome','genuser',11,'Integer','','','',''),(1716,'genuserhome','gencompany',11,'Integer','','','',''),(1717,'genuserhome','home',20,'Text','','','',''),(1718,'genuserhome','twothirds',100,'Text','','','',''),(1719,'genuserhome','half1',100,'Text','','','',''),(1720,'genuserhome','half2',100,'Text','','','',''),(1721,'genuserhome','lastlogin',19,'DateTime','','','',''),(1722,'genuserhome','whole',100,'Text','','','',''),(1723,'glaccount','id',22,'Numeric','','','primary unique',''),(1724,'glaccount','name',20,'Text','','','multiple',''),(1725,'glaccount','description',255,'Text','','','',''),(1726,'glaccount','accounttypeid',11,'Integer','','','multiple',''),(1727,'glaccount','companyid',22,'Numeric','','','multiple',''),(1728,'glaccount','summaryaccountid',22,'Numeric','','','multiple',''),(1729,'glaccount','lastchangedate',19,'DateTime','','','',''),(1730,'glaccount','lastchangeuserid',22,'Numeric','','','',''),(1731,'glaccount','cancel',2,'Integer','','','',''),(1732,'glaccount','canceldate',19,'DateTime','','','',''),(1733,'glaccount','canceluserid',11,'Integer','','','',''),(1734,'glbudgets','id',22,'Numeric','','','primary unique',''),(1735,'glbudgets','glaccountid',22,'Numeric','','','multiple',''),(1736,'glbudgets','companyid',22,'Numeric','','','multiple',''),(1737,'glbudgets','budgetyear',11,'Integer','','','multiple',''),(1738,'glbudgets','jan',21,'Numeric','','','',''),(1739,'glbudgets','feb',21,'Numeric','','','',''),(1740,'glbudgets','mar',21,'Numeric','','','',''),(1741,'glbudgets','apr',21,'Numeric','','','',''),(1742,'glbudgets','may',21,'Numeric','','','',''),(1743,'glbudgets','jun',21,'Numeric','','','',''),(1744,'glbudgets','jul',21,'Numeric','','','',''),(1745,'glbudgets','aug',21,'Numeric','','','',''),(1746,'glbudgets','sep',21,'Numeric','','','',''),(1747,'glbudgets','oct',21,'Numeric','','','',''),(1748,'glbudgets','nov',21,'Numeric','','','',''),(1749,'glbudgets','decm',21,'Numeric','','','',''),(1750,'glbudgets','lastchangedate',19,'DateTime','','','',''),(1751,'glbudgets','lastchangeuserid',22,'Numeric','','','',''),(1752,'glbudgets','entrydate',19,'DateTime','','','',''),(1753,'glbudgets','rank',11,'Integer','','','',''),(1754,'glbudgets','cancel',2,'Integer','','','',''),(1755,'glbudgets','budgetname',100,'Text','','','',''),(1756,'glcompany','id',22,'Numeric','','','primary unique',''),(1757,'glcompany','fiscalbeginmonth',11,'Integer','','','',''),(1758,'glpie','id',22,'Numeric','','','primary unique',''),(1759,'glpie','name',30,'Text','','','',''),(1760,'glpie','description',100,'Text','','','',''),(1761,'glpie','begindate',10,'Date','','','',''),(1762,'glpie','findate',10,'Date','','','',''),(1763,'glpie','cancel',11,'Integer','','','',''),(1764,'glpie','canceldate',19,'DateTime','','','',''),(1765,'glpie','canceluserid',22,'Numeric','','','',''),(1766,'glpie','entrydate',19,'DateTime','','','',''),(1767,'glpie','entryuserid',22,'Numeric','','','',''),(1768,'glpie','lastchangedate',19,'DateTime','','','',''),(1769,'glpie','lastchangeuserid',22,'Numeric','','','',''),(1770,'glpieslice','id',22,'Numeric','','','primary unique',''),(1771,'glpieslice','glpieid',22,'Numeric','','','multiple',''),(1772,'glpieslice','name',30,'Text','','','',''),(1773,'glpieslice','begindate',10,'Date','','','',''),(1774,'glpieslice','findate',10,'Date','','','',''),(1775,'glpieslice','lastchangedate',19,'DateTime','','','',''),(1776,'glpieslice','lastchangeuserid',22,'Numeric','','','',''),(1777,'glpieslicedetail','id',22,'Numeric','','','primary unique',''),(1778,'glpieslicedetail','glpiesliceid',22,'Numeric','','','multiple',''),(1779,'glpieslicedetail','glaccountid',22,'Numeric','','','',''),(1780,'glpieslicedetail','companyid',22,'Numeric','','','',''),(1781,'glpieslicedetail','lastchangedate',19,'DateTime','','','',''),(1782,'glpieslicedetail','lastchangeuserid',22,'Numeric','','','',''),(1783,'gltransaction','id',22,'Numeric','','','primary unique',''),(1784,'gltransaction','glaccountid',22,'Numeric','','','multiple',''),(1785,'gltransaction','voucherid',22,'Numeric','','','multiple',''),(1786,'gltransaction','amount',21,'Numeric','','','',''),(1787,'gltransvoucher','id',22,'Numeric','','','primary unique',''),(1788,'gltransvoucher','voucher',50,'Text','','','multiple',''),(1789,'gltransvoucher','description',50,'Text','','','',''),(1790,'gltransvoucher','comments',50,'Text','','','',''),(1791,'gltransvoucher','wherefrom',11,'Integer','','source module','multiple',''),(1792,'gltransvoucher','status',11,'Integer','','0=unposted, 1=posted, 2=auto posted by close year','',''),(1793,'gltransvoucher','cancel',11,'Integer','','1=cancelled, do not include in any gl totals','',''),(1794,'gltransvoucher','companyid',22,'Numeric','','','multiple',''),(1795,'gltransvoucher','standardset',22,'Numeric','','1=recurring ledger set - do not include in any ledger totals','',''),(1796,'gltransvoucher','entrydate',19,'DateTime','','','',''),(1797,'gltransvoucher','posteddate',19,'DateTime','','date on which posting DONE','',''),(1798,'gltransvoucher','post2date',10,'Date','','date posted TO','multiple',''),(1799,'gltransvoucher','canceldate',19,'DateTime','','','',''),(1800,'gltransvoucher','lastchangedate',19,'DateTime','','','',''),(1801,'gltransvoucher','lastchangeuserid',22,'Numeric','','','',''),(1802,'gltransvoucher','entryuserid',22,'Numeric','','','',''),(1803,'gltransvoucher','canceluserid',22,'Numeric','','','',''),(1804,'gltransvoucher','postuserid',22,'Numeric','','who posted','',''),(1805,'gltransvoucher','bankdepositid',11,'Integer','','','',''),(1806,'invbegcount','id',11,'Integer','','','primary',''),(1807,'invbegcount','itemid',11,'Integer','','','',''),(1808,'invbegcount','count',22,'Numeric','','','',''),(1809,'invbegcount','priceach',14,'Numeric','','','',''),(1810,'invbegcount','inventorylocationid',11,'Integer','','','',''),(1811,'invbegcount','status',2,'Integer','','','',''),(1812,'invbegcount','entrydate',19,'DateTime','','','',''),(1813,'invbegcount','entryuserid',11,'Integer','','','',''),(1814,'invbegcount','countunitid',11,'Integer','','','',''),(1815,'invcompany','id',22,'Numeric','','','primary unique',''),(1816,'invcompany','cash',22,'Numeric','','','',''),(1817,'invcompany','sales',22,'Numeric','','','',''),(1818,'invcompany','loss',22,'Numeric','','','',''),(1819,'invcompany','cost',22,'Numeric','','','',''),(1820,'invcompany','freight',22,'Numeric','','','',''),(1821,'invcompany','tax',22,'Numeric','','','',''),(1822,'invcompany','custoritemglacct',11,'Integer','','','',''),(1823,'invcompany','locationid',11,'Integer','','','',''),(1824,'invcompany','default_pricelevelid',11,'Integer','','','',''),(1825,'invcompany','weight_units',10,'Text','','','',''),(1826,'invcompany','category_hierarchy',2,'Integer','','','',''),(1827,'invcount','id',11,'Integer','','','primary',''),(1828,'invcount','itemid',11,'Integer','','','',''),(1829,'invcount','count',11,'Integer','','','',''),(1830,'invcount','countunitid',100,'Text','','','',''),(1831,'invcount','entrydate',19,'DateTime','','','',''),(1832,'invcount','status',2,'Integer','','','',''),(1833,'invcount','inventorylocationid',11,'Integer','','','',''),(1834,'invcount','entryuserid',11,'Integer','','','',''),(1835,'invcount','posteddate',19,'DateTime','','','',''),(1836,'invcount','posteduserid',11,'Integer','','','',''),(1837,'inventorylocation','id',22,'Numeric','','','primary',''),(1838,'inventorylocation','companyname',35,'Text','','','',''),(1839,'inventorylocation','address1',100,'Text','','','',''),(1840,'inventorylocation','address2',100,'Text','','','',''),(1841,'inventorylocation','mailstop',20,'Text','','','',''),(1842,'inventorylocation','city',50,'Text','','','',''),(1843,'inventorylocation','state',20,'Text','','','',''),(1844,'inventorylocation','zip',15,'Text','','','',''),(1845,'inventorylocation','country',20,'Text','','','',''),(1846,'inventorylocation','phone1',20,'Text','','','',''),(1847,'inventorylocation','phone1comment',20,'Text','','','',''),(1848,'inventorylocation','phone2',20,'Text','','','',''),(1849,'inventorylocation','phone2comment',20,'Text','','','',''),(1850,'inventorylocation','phone3',20,'Text','','','',''),(1851,'inventorylocation','phone3comment',20,'Text','','','',''),(1852,'inventorylocation','phone4',20,'Text','','','',''),(1853,'inventorylocation','phone4comment',20,'Text','','','',''),(1854,'inventorylocation','email1',50,'Text','','','',''),(1855,'inventorylocation','email1comment',20,'Text','','','',''),(1856,'inventorylocation','email2',50,'Text','','','',''),(1857,'inventorylocation','email2comment',20,'Text','','','',''),(1858,'inventorylocation','website',100,'Text','','','',''),(1859,'inventorylocation','federalid',20,'Text','','','',''),(1860,'inventorylocation','cancel',11,'Integer','','','',''),(1861,'inventorylocation','canceldate',19,'DateTime','','','',''),(1862,'inventorylocation','canceluserid',22,'Numeric','','','',''),(1863,'inventorylocation','entrydate',19,'DateTime','','','',''),(1864,'inventorylocation','entryuserid',22,'Numeric','','','',''),(1865,'inventorylocation','lastchangedate',19,'DateTime','','','',''),(1866,'inventorylocation','lastchangeuserid',22,'Numeric','','','',''),(1867,'inventorylocation','gencompanyid',11,'Integer','','','',''),(1868,'inventorylocation','printlocation',2,'Integer','','','',''),(1869,'invitemcatseason','id',22,'Numeric','','','primary unique',''),(1870,'invitemcatseason','itemcategoryid',22,'Numeric','','','multiple',''),(1871,'invitemcatseason','seasonname',50,'Text','','','',''),(1872,'invitemcatseason','seasonbegin',11,'Integer','','','',''),(1873,'invitemcatseason','seasonend',11,'Integer','','','',''),(1874,'invitemcatseason','cancel',11,'Integer','','','',''),(1875,'invitemcatseason','canceldate',19,'DateTime','','','',''),(1876,'invitemcatseason','canceluserid',22,'Numeric','','','',''),(1877,'invitemcatseason','entrydate',19,'DateTime','','','',''),(1878,'invitemcatseason','entryuserid',22,'Numeric','','','',''),(1879,'invitemcatseason','lastchangedate',19,'DateTime','','','',''),(1880,'invitemcatseason','lastchangeuserid',22,'Numeric','','','',''),(1881,'invoiceterms','id',22,'Numeric','','','primary unique',''),(1882,'invoiceterms','verbal',30,'Text','','','',''),(1883,'invoiceterms','discountpercent',8,'Numeric','','','',''),(1884,'invoiceterms','discountdays',11,'Integer','','','',''),(1885,'invoiceterms','discountdayofmonth',11,'Integer','','','',''),(1886,'invoiceterms','netduedays',11,'Integer','','','',''),(1887,'invoiceterms','ar',11,'Integer','','','multiple',''),(1888,'invoiceterms','ap',11,'Integer','','','multiple',''),(1889,'invoiceterms','cancel',11,'Integer','','','',''),(1890,'invoiceterms','canceldate',19,'DateTime','','','',''),(1891,'invoiceterms','canceluserid',22,'Numeric','','','',''),(1892,'invoiceterms','entrydate',19,'DateTime','','','',''),(1893,'invoiceterms','entryuserid',22,'Numeric','','','',''),(1894,'invoiceterms','lastchangedate',19,'DateTime','','','',''),(1895,'invoiceterms','lastchangeuserid',22,'Numeric','','','',''),(1896,'invpo','id',22,'Numeric','','','primary unique',''),(1897,'invpo','vendorid',22,'Numeric','','','multiple',''),(1898,'invpo','ponumber',20,'Text','','','multiple',''),(1899,'invpo','duedate',10,'Date','','','',''),(1900,'invpo','locationid',22,'Numeric','','','',''),(1901,'invpo','carrierserviceid',22,'Numeric','','','',''),(1902,'invpo','tracknumber',50,'Text','','','',''),(1903,'invpo','contact',20,'Text','','','',''),(1904,'invpo','requisition',20,'Text','','','',''),(1905,'invpo','ordernumber',20,'Text','','','',''),(1906,'invpo','gencompanyid',22,'Numeric','','','',''),(1907,'invpo','complete',11,'Integer','','','',''),(1908,'invpo','cancel',11,'Integer','','','',''),(1909,'invpo','canceldate',19,'DateTime','','','',''),(1910,'invpo','canceluserid',22,'Numeric','','','',''),(1911,'invpo','entrydate',19,'DateTime','','','',''),(1912,'invpo','entryuserid',22,'Numeric','','','',''),(1913,'invpo','lastchangedate',19,'DateTime','','','',''),(1914,'invpo','status',11,'Integer','','','',''),(1915,'invpo','lastchangeuserid',22,'Numeric','','','',''),(1916,'invpo','notes',255,'Text','','','',''),(1917,'invpo','initials',255,'Text','','','',''),(1918,'invpo','description',255,'Text','','','',''),(1919,'invpo','referenceid',11,'Integer','','','multiple',''),(1920,'invpo','wherefrom',11,'Integer','','','multiple',''),(1921,'invpodetail','id',22,'Numeric','','','primary unique',''),(1922,'invpodetail','invpoid',22,'Numeric','','','multiple',''),(1923,'invpodetail','itemid',22,'Numeric','','','multiple',''),(1924,'invpodetail','itemqty',21,'Numeric','','','',''),(1925,'invpodetail','itemprice',21,'Numeric','','','',''),(1926,'invpodetail','detail_description',255,'Text','','','',''),(1927,'invpodetail','inv_glacct',22,'Numeric','','','',''),(1928,'invpodetail','conversion',14,'Numeric','','','',''),(1929,'invponotes','id',11,'Integer','','','primary',''),(1930,'invponotes','invpoid',11,'Integer','','','multiple',''),(1931,'invponotes','linenumber',11,'Integer','','','multiple',''),(1932,'invponotes','note',65535,'X','','','',''),(1933,'invponotes','entrydate',10,'Date','','','',''),(1934,'invponotes','entryuserid',11,'Integer','','','',''),(1935,'invponotes','lastupdatedate',19,'DateTime','','','',''),(1936,'invponotes','lastupdateuserid',11,'Integer','','','',''),(1937,'invponotes','source_noteid',11,'Integer','','','multiple',''),(1938,'invpoquote','id',22,'Numeric','','','primary unique',''),(1939,'invpoquote','invpoid',22,'Numeric','','','multiple',''),(1940,'invpoquote','vendorid',22,'Numeric','','','multiple',''),(1941,'invpoquote','invpodetailid',22,'Numeric','','','multiple',''),(1942,'invpoquote','itemqty',12,'Numeric','','','',''),(1943,'invpoquote','itemprice',14,'Numeric','','','',''),(1944,'invpostdnotes','id',11,'Integer','','','primary',''),(1945,'invpostdnotes','shortnote',50,'Text','','','',''),(1946,'invpostdnotes','full_note',65535,'X','','','',''),(1947,'invpostdnotes','sortorder',5,'Integer','','','multiple',''),(1948,'invpostdnotes','gencompanyid',11,'Integer','','','multiple',''),(1949,'invpostdnotes','entrydate',10,'Date','','','',''),(1950,'invpostdnotes','entryuserid',11,'Integer','','','',''),(1951,'invpostdnotes','cancel',2,'Integer','','','multiple',''),(1952,'invpostdnotes','canceldate',10,'Date','','','',''),(1953,'invpostdnotes','canceluserid',11,'Integer','','','',''),(1954,'invpostdnotes','lastupdatedate',19,'DateTime','','','',''),(1955,'invpostdnotes','lastupdateuserid',11,'Integer','','','',''),(1956,'invreceive','id',22,'Numeric','','','primary unique',''),(1957,'invreceive','recsource',11,'Integer','','','',''),(1958,'invreceive','invpoid',22,'Numeric','','','multiple',''),(1959,'invreceive','receivedate',19,'DateTime','','','',''),(1960,'invreceive','itemid',22,'Numeric','','','multiple',''),(1961,'invreceive','vendorid',22,'Numeric','','','',''),(1962,'invreceive','locationid',22,'Numeric','','','',''),(1963,'invreceive','itemqty',12,'Numeric','','','',''),(1964,'invreceive','itemprice',21,'Numeric','','','',''),(1965,'invreceive','itemqtyused',12,'Numeric','','','',''),(1966,'invreceive','itemqtydamaged',12,'Numeric','','','',''),(1967,'invreceive','conversion',14,'Numeric','','','',''),(1968,'invreceive','track',30,'Text','','','',''),(1969,'invreceive','receiveunitnameid',22,'Numeric','','','',''),(1970,'invreceive','passtoap',11,'Integer','','','',''),(1971,'invreceive','apbillid',22,'Numeric','','','',''),(1972,'invreceive','gencompanyid',22,'Numeric','','','',''),(1973,'invreceive','cancel',11,'Integer','','','',''),(1974,'invreceive','canceldate',19,'DateTime','','','',''),(1975,'invreceive','canceluserid',22,'Numeric','','','',''),(1976,'invreceive','entrydate',19,'DateTime','','','',''),(1977,'invreceive','entryuserid',22,'Numeric','','','',''),(1978,'invreceive','lastchangedate',19,'DateTime','','','',''),(1979,'invreceive','invpodetailid',11,'Integer','','','',''),(1980,'invreceive','status',2,'Integer','','','',''),(1981,'invreceive','initials',255,'Text','','','',''),(1982,'invreceive','lastchangeuserid',22,'Numeric','','','',''),(1983,'invreceive','recnotes',65535,'X','','','',''),(1984,'item','id',22,'Numeric','','','primary unique',''),(1985,'item','itemcode',30,'Text','','UPC Code or item code - must be unique','multiple',''),(1986,'item','compositeitemyesno',11,'Integer','','','',''),(1987,'item','description',100,'Text','','','',''),(1988,'item','categoryid',22,'Numeric','','','multiple',''),(1989,'item','stockunitnameid',22,'Numeric','','','','unitname.id'),(1990,'item','priceunitnameid',22,'Numeric','','','','unitname.id'),(1991,'item','lbsperpriceunit',22,'Numeric','','','',''),(1992,'item','priceunitsperstockunit',18,'Numeric','','Conversion factor between stocking units and pricing units. On screen might show as 1000 stock units per price unit, but in database it will be stored as 1/1000 or .001','',''),(1993,'item','inventoryglacctid',22,'Numeric','','glaccount.id - for inventory account','multiple','glaccount.id'),(1994,'item','salesglacctid',22,'Numeric','','','',''),(1995,'item','width',22,'Numeric','','','',''),(1996,'item','length',22,'Numeric','','','',''),(1997,'item','mwt',22,'Numeric','','','',''),(1998,'item','cogs',22,'Numeric','','','',''),(1999,'item','cogseffectivedate',19,'DateTime','','','',''),(2000,'item','middlemanprice',22,'Numeric','','','',''),(2001,'item','price',22,'Numeric','','not used','',''),(2002,'item','priceeffectivedate',19,'DateTime','','not used','',''),(2003,'item','status',11,'Integer','','','',''),(2004,'item','id_item_useinstead',100,'Text','','if out or discontinued, use this item.id instead','','item.id'),(2005,'item','invtype',11,'Integer','1,2,3','1=physical\r\n2=POD\r\n3=Finished Goods','',''),(2006,'item','catalogdescription',65535,'X','','','',''),(2007,'item','products_website',255,'Text','','','',''),(2008,'item','catalogsheeturl',200,'Text','','','',''),(2009,'item','graphicurl',200,'Text','','','',''),(2010,'item','companyid',22,'Numeric','','gencompany.id - which company this item is associated with','multiple','gencompany.id'),(2011,'item','cancel',11,'Integer','0,1','1=cancelled','',''),(2012,'item','canceldate',19,'DateTime','','','',''),(2013,'item','canceluserid',22,'Numeric','','','',''),(2014,'item','entrydate',19,'DateTime','','','',''),(2015,'item','entryuserid',22,'Numeric','','','',''),(2016,'item','lastchangedate',19,'DateTime','','','',''),(2017,'item','lastchangeuserid',22,'Numeric','','','',''),(2018,'item','products_quantity',4,'Integer','','','',''),(2019,'item','products_viewed',5,'Integer','','','',''),(2020,'item','products_status',1,'Integer','','','',''),(2021,'item','products_tax_class_id',5,'Integer','','','',''),(2022,'item','products_costprice',10,'Numeric','','','',''),(2023,'item','products_pushup',6,'Numeric','','','',''),(2024,'item','scart',2,'Integer','','','',''),(2025,'item','parentitemid',22,'Numeric','','','multiple',''),(2026,'item','scart_minqtydisplay',11,'Integer','','','',''),(2027,'itemcategory','id',22,'Numeric','','','primary unique',''),(2028,'itemcategory','companyid',22,'Numeric','','','',''),(2029,'itemcategory','name',50,'Text','','','',''),(2030,'itemcategory','invtype',11,'Integer','','','',''),(2031,'itemcategory','cancel',11,'Integer','','','',''),(2032,'itemcategory','canceldate',19,'DateTime','','','',''),(2033,'itemcategory','canceluserid',22,'Numeric','','','',''),(2034,'itemcategory','entrydate',19,'DateTime','','','',''),(2035,'itemcategory','entryuserid',22,'Numeric','','','',''),(2036,'itemcategory','lastchangedate',19,'DateTime','','','',''),(2037,'itemcategory','lastchangeuserid',22,'Numeric','','','',''),(2038,'itemcategory','seasonname1',50,'Text','','','',''),(2039,'itemcategory','seasonname2',50,'Text','','','',''),(2040,'itemcategory','seasonname3',50,'Text','','','',''),(2041,'itemcategory','seasonname4',50,'Text','','','',''),(2042,'itemcategory','seasonbegin1',25,'Text','','','',''),(2043,'itemcategory','seasonbegin2',25,'Text','','','',''),(2044,'itemcategory','seasonbegin3',25,'Text','','','',''),(2045,'itemcategory','seasonbegin4',25,'Text','','','',''),(2046,'itemcategory','seasonend1',25,'Text','','','',''),(2047,'itemcategory','seasonend2',25,'Text','','','',''),(2048,'itemcategory','seasonend3',25,'Text','','','',''),(2049,'itemcategory','seasonend4',25,'Text','','','',''),(2050,'itemcategory','categories_image',64,'Text','','','',''),(2051,'itemcategory','parent_id',5,'Integer','','','',''),(2052,'itemcategory','sort_order',3,'Integer','','','',''),(2053,'itemcategory','is_print_order',11,'Integer','','','',''),(2054,'itemlocation','id',22,'Numeric','','','primary unique',''),(2055,'itemlocation','itemid',22,'Numeric','','','multiple',''),(2056,'itemlocation','inventorylocationid',22,'Numeric','','','multiple',''),(2057,'itemlocation','onhandqty',22,'Numeric','','','',''),(2058,'itemlocation','maxstocklevelseason1',22,'Numeric','','','',''),(2059,'itemlocation','minstocklevelseason1',22,'Numeric','','','',''),(2060,'itemlocation','orderqtyseason1',22,'Numeric','','','',''),(2061,'itemlocation','maxstocklevelseason2',22,'Numeric','','','',''),(2062,'itemlocation','minstocklevelseason2',22,'Numeric','','','',''),(2063,'itemlocation','orderqtyseason2',22,'Numeric','','','',''),(2064,'itemlocation','maxstocklevelseason3',22,'Numeric','','','',''),(2065,'itemlocation','minstocklevelseason3',22,'Numeric','','','',''),(2066,'itemlocation','orderqtyseason3',22,'Numeric','','','',''),(2067,'itemlocation','maxstocklevelseason4',22,'Numeric','','','',''),(2068,'itemlocation','minstocklevelseason4',22,'Numeric','','','',''),(2069,'itemlocation','orderqtyseason4',22,'Numeric','','','',''),(2070,'itemlocation','markupsetid',22,'Numeric','','','multiple',''),(2071,'itemlocation','firstcost',21,'Numeric','','','',''),(2072,'itemlocation','midcost',21,'Numeric','','','',''),(2073,'itemlocation','lastcost',21,'Numeric','','','',''),(2074,'itemlocation','firstqty',22,'Numeric','','','',''),(2075,'itemlocation','midqty',22,'Numeric','','','',''),(2076,'itemlocation','lastqty',22,'Numeric','','','',''),(2077,'itemlocation','cancel',11,'Integer','','','',''),(2078,'itemlocation','canceldate',19,'DateTime','','','',''),(2079,'itemlocation','canceluserid',22,'Numeric','','','',''),(2080,'itemlocation','entrydate',19,'DateTime','','','',''),(2081,'itemlocation','entryuserid',22,'Numeric','','','',''),(2082,'itemlocation','lastchangedate',19,'DateTime','','','',''),(2083,'itemlocation','lastchangeuserid',22,'Numeric','','','',''),(2084,'itemoption','id',11,'Integer','','','primary',''),(2085,'itemoption','itemoptiongroupid',11,'Integer','','','multiple',''),(2086,'itemoption','itemid',11,'Integer','','','multiple',''),(2087,'itemoption','price',14,'Numeric','','','',''),(2088,'itemoption','cost',14,'Numeric','','','',''),(2089,'itemoption','minqty',14,'Numeric','','','',''),(2090,'itemoption','maxqty',14,'Numeric','','','',''),(2091,'itemoption','mainind',2,'Integer','','','',''),(2092,'itemoption','rounding',2,'Integer','','','',''),(2093,'itemoption','name',255,'Text','','','',''),(2094,'itemoption','description',65535,'X','','','',''),(2095,'itemoption','priceunitnameid',11,'Integer','','','multiple',''),(2096,'itemoption','salesunitnameid',11,'Integer','','','multiple',''),(2097,'itemoption','saleunitperpriceunit',9,'Numeric','','','',''),(2098,'itemoption','lbsperpriceunit',22,'Numeric','','','',''),(2099,'itemoption','defaultvalue',14,'Numeric','','','',''),(2100,'itemoption','defaultoption',2,'Integer','','','',''),(2101,'itemoption','displayorder',11,'Integer','','','',''),(2102,'itemoption','taxable',2,'Integer','','','',''),(2103,'itemoption','salesglaccountid',11,'Integer','','','multiple',''),(2104,'itemoption','entrydate',19,'DateTime','','','',''),(2105,'itemoption','entryuserid',11,'Integer','','','',''),(2106,'itemoption','lastchangedate',19,'DateTime','','','',''),(2107,'itemoption','lastchangeuserid',11,'Integer','','','',''),(2108,'itemoption','companyid',11,'Integer','','','',''),(2109,'itemoption','cancel',2,'Integer','','','',''),(2110,'itemoptiongroup','id',11,'Integer','','','primary',''),(2111,'itemoptiongroup','name',255,'Text','','','',''),(2112,'itemoptiongroup','description',65535,'X','','','',''),(2113,'itemoptiongroup','optiontype',8,'Text','','','',''),(2114,'itemoptiongroup','allowblank',2,'Integer','','','',''),(2115,'itemoptiongroup','entrydate',19,'DateTime','','','',''),(2116,'itemoptiongroup','entryuserid',11,'Integer','','','',''),(2117,'itemoptiongroup','lastchangedate',19,'DateTime','','','',''),(2118,'itemoptiongroup','lastchangeuserid',11,'Integer','','','',''),(2119,'itemoptiongroup','companyid',11,'Integer','','','',''),(2120,'itemoptiongroup','cancel',2,'Integer','','','',''),(2121,'itemoptiongroupitem','id',11,'Integer','','','primary',''),(2122,'itemoptiongroupitem','itemoptiongroupid',11,'Integer','','','multiple',''),(2123,'itemoptiongroupitem','itemid',11,'Integer','','','multiple',''),(2124,'itemoptiongroupitem','sortorder',11,'Integer','','','',''),(2125,'itemtransaction','id',11,'Integer','','','primary',''),(2126,'itemtransaction','itemid',11,'Integer','','item in inventory','multiple','item.id'),(2127,'itemtransaction','wherefrom',2,'Integer','1-7','1=arorder\r\n2=shopping cart\r\n3=inventory adjustment (adjust or physical inv. Auto-adjust)\r\n4=inventory move\r\n5=inventory buildorder\r\n6=PO\r\n7=without PO','multiple',''),(2128,'itemtransaction','referenceid',11,'Integer','','id of related table (from wherefrom info). This may not have a value.','',''),(2129,'itemtransaction','locationid',11,'Integer','','location where inventory resides','multiple','inventorylocation.id'),(2130,'itemtransaction','description',100,'Text','','','',''),(2131,'itemtransaction','quantity',21,'Numeric','','quantity of usage units','',''),(2132,'itemtransaction','costpereach',21,'Numeric','','cost per usage unit','',''),(2133,'itemtransaction','trtype',2,'Integer','1-6','1=committed (does not affect on-hand)\r\n2=received/purchased\r\n3=used/sold\r\n4=adjusted\r\n5=balance forward\r\n6=damaged','multiple',''),(2134,'itemtransaction','createdate',19,'DateTime','','date created','multiple',''),(2135,'itemtransaction','createuserid',11,'Integer','','who created','','genuser.id'),(2136,'itemtransaction','cancel',2,'Integer','1,0','1=cancel','multiple',''),(2137,'itemtransaction','canceluserid',11,'Integer','','who cancelled','','genuser.id'),(2138,'itemtransaction','canceldate',19,'DateTime','','date cancelled','',''),(2139,'itemtransaction','id_order_shipment',11,'Integer','','','',''),(2140,'itemtransaction','pricepereach',21,'Numeric','','sell price per usage unit','',''),(2141,'itemvendor','id',22,'Numeric','','','primary unique',''),(2142,'itemvendor','vendorid',22,'Numeric','','','multiple',''),(2143,'itemvendor','itemid',22,'Numeric','','','multiple',''),(2144,'itemvendor','vordernumber',30,'Text','','','',''),(2145,'itemvendor','vitemunitnameid',22,'Numeric','','','',''),(2146,'itemvendor','vitemconversion',14,'Numeric','','','',''),(2147,'itemvendor','vitemcost1',21,'Numeric','','','',''),(2148,'itemvendor','vitemqty1',21,'Numeric','','','',''),(2149,'itemvendor','vitemcost2',21,'Numeric','','','',''),(2150,'itemvendor','vitemqty2',21,'Numeric','','','',''),(2151,'itemvendor','vitemcost3',21,'Numeric','','','',''),(2152,'itemvendor','vitemqty3',21,'Numeric','','','',''),(2153,'itemvendor','vitemcost4',21,'Numeric','','','',''),(2154,'itemvendor','cancel',11,'Integer','','','',''),(2155,'itemvendor','canceldate',19,'DateTime','','','',''),(2156,'itemvendor','canceluserid',22,'Numeric','','','',''),(2157,'itemvendor','entrydate',19,'DateTime','','','',''),(2158,'itemvendor','entryuserid',22,'Numeric','','','',''),(2159,'itemvendor','lastchangedate',19,'DateTime','','','',''),(2160,'itemvendor','lastchangeuserid',22,'Numeric','','','',''),(2161,'lang','id',11,'Integer','','','primary',''),(2162,'lang','name',255,'Text','','','multiple',''),(2163,'lang','en',255,'Text','','','',''),(2164,'lang','de',255,'Text','','','',''),(2165,'lang','es',255,'Text','','','',''),(2166,'lang','ru',255,'Text','','','',''),(2167,'langmatch','id',11,'Integer','','','primary',''),(2168,'langmatch','langid',11,'Integer','','','multiple',''),(2169,'langmatch','page',100,'Text','','','multiple',''),(2170,'languages','languages_id',5,'Integer','','','primary',''),(2171,'languages','name',32,'Text','','','multiple',''),(2172,'languages','code',2,'Text','','','',''),(2173,'languages','image',64,'Text','','','',''),(2174,'languages','directory',32,'Text','','','',''),(2175,'languages','sort_order',3,'Integer','','','',''),(2176,'languages','cancel',11,'Integer','','','',''),(2177,'latereason','id_latereason',11,'Integer','','','primary',''),(2178,'latereason','reason',100,'Text','','','',''),(2179,'latereason','createdate',10,'Date','','','',''),(2180,'latereason','id_user_create',11,'Integer','','','',''),(2181,'latereason','lastrevisedate',19,'DateTime','','','',''),(2182,'latereason','id_user_revise',11,'Integer','','','',''),(2183,'latereason','canceldate',10,'Date','','','',''),(2184,'latereason','cancel',11,'Integer','','','',''),(2185,'latereason','gencompanyid',11,'Integer','','','',''),(2186,'machine','id_machine',11,'Integer','','','primary unique',''),(2187,'machine','id_family',11,'Integer','','','',''),(2188,'machine','name',50,'Text','','','',''),(2189,'machine','serialnumber',50,'Text','','','',''),(2190,'machine','machinecostperhour',12,'Numeric','','','',''),(2191,'machine','laborcostperhour',12,'Numeric','','','',''),(2192,'machine','id_company',11,'Integer','','','',''),(2193,'machine','id_location',11,'Integer','','','',''),(2194,'machine','operatortime',7,'Numeric','','','',''),(2195,'machine','overhead',7,'Numeric','','','',''),(2196,'machine','markup',7,'Numeric','','','',''),(2197,'machine','is_default',1,'Integer','','','',''),(2198,'machine','rolloverpoint',15,'Integer','','','',''),(2199,'machine','createdate',19,'DateTime','','','',''),(2200,'machine','id_user_create',11,'Integer','','','',''),(2201,'machine','lastrevisedate',19,'DateTime','','','',''),(2202,'machine','id_user_revise',11,'Integer','','','',''),(2203,'machine','canceldate',19,'DateTime','','','',''),(2204,'machine','cancel',11,'Integer','','','',''),(2205,'machine','gencompanyid',11,'Integer','','','',''),(2206,'markupset','id',22,'Numeric','','','primary unique',''),(2207,'markupset','description',35,'Text','','','',''),(2208,'markupset','costbased',11,'Integer','','','multiple',''),(2209,'markupset','companyid',22,'Numeric','','','multiple',''),(2210,'markupset','cancel',11,'Integer','','','',''),(2211,'markupset','canceldate',19,'DateTime','','','',''),(2212,'markupset','canceluserid',22,'Numeric','','','',''),(2213,'markupset','entrydate',19,'DateTime','','','',''),(2214,'markupset','entryuserid',22,'Numeric','','','',''),(2215,'markupset','lastchangedate',19,'DateTime','','','',''),(2216,'markupset','lastchangeuserid',22,'Numeric','','','',''),(2217,'markupsetlevel','id',22,'Numeric','','','primary unique',''),(2218,'markupsetlevel','pricelevelid',22,'Numeric','','','multiple',''),(2219,'markupsetlevel','markupsetid',22,'Numeric','','','multiple',''),(2220,'markupsetlevel','markuppercent',8,'Numeric','','','',''),(2221,'markupsetlevel','cancel',11,'Integer','','','',''),(2222,'markupsetlevel','canceldate',19,'DateTime','','','',''),(2223,'markupsetlevel','canceluserid',22,'Numeric','','','',''),(2224,'markupsetlevel','entrydate',19,'DateTime','','','',''),(2225,'markupsetlevel','entryuserid',22,'Numeric','','','',''),(2226,'markupsetlevel','lastchangedate',19,'DateTime','','','',''),(2227,'markupsetlevel','lastchangeuserid',22,'Numeric','','','',''),(2228,'menucategory','id',11,'Integer','','','primary unique',''),(2229,'menucategory','name',50,'Text','','','',''),(2230,'menucategory','orderflag',11,'Integer','','','multiple',''),(2231,'menucategory','menu',11,'Integer','','','',''),(2232,'menucategory','description',65535,'X','','','',''),(2233,'menucategory','accessap',11,'Integer','','','multiple',''),(2234,'menucategory','accessar',11,'Integer','','','multiple',''),(2235,'menucategory','accessgl',11,'Integer','','','multiple',''),(2236,'menucategory','accesspay',11,'Integer','','','multiple',''),(2237,'menucategory','accessinv',11,'Integer','','','multiple',''),(2238,'menucategory','accessest',11,'Integer','','','multiple',''),(2239,'menucategory','accessfix',11,'Integer','','','multiple',''),(2240,'menucategory','accessimp',11,'Integer','','','multiple',''),(2241,'menucategory','setupap',11,'Integer','','','',''),(2242,'menucategory','setupar',11,'Integer','','','',''),(2243,'menucategory','setupgl',11,'Integer','','','',''),(2244,'menucategory','setuppay',11,'Integer','','','',''),(2245,'menucategory','setupinv',11,'Integer','','','',''),(2246,'menucategory','setupest',11,'Integer','','','',''),(2247,'menucategory','setupfix',11,'Integer','','','',''),(2248,'menucategory','setupimp',11,'Integer','','','',''),(2249,'menucategory','supervisor',11,'Integer','','','multiple',''),(2250,'menucategory','nonsupervisor',11,'Integer','','','multiple',''),(2251,'menucategory','extvend',11,'Integer','','','multiple',''),(2252,'menucategory','extcust',11,'Integer','','','multiple',''),(2253,'menucategory','nonext',11,'Integer','','','multiple',''),(2254,'menudata','id',11,'Integer','','','primary',''),(2255,'menudata','menu_name',100,'Text','','','',''),(2256,'menudata','id_menudata',11,'Integer','','','',''),(2257,'menudata','orderflag',5,'Integer','','','',''),(2258,'menudata','menu_action',2,'Integer','','','',''),(2259,'menudata','description',250,'Text','','','',''),(2260,'menudata','accessap',2,'Integer','','','',''),(2261,'menudata','accessar',2,'Integer','','','',''),(2262,'menudata','accessgl',2,'Integer','','','',''),(2263,'menudata','accesspay',2,'Integer','','','',''),(2264,'menudata','accessinv',2,'Integer','','','',''),(2265,'menudata','accessest',2,'Integer','','','',''),(2266,'menudata','accessfix',2,'Integer','','','',''),(2267,'menudata','accessimp',2,'Integer','','','',''),(2268,'menudata','accesssc',2,'Integer','','','',''),(2269,'menudata','setupap',2,'Integer','','','',''),(2270,'menudata','setupar',2,'Integer','','','',''),(2271,'menudata','setupgl',2,'Integer','','','',''),(2272,'menudata','setuppay',2,'Integer','','','',''),(2273,'menudata','setupinv',2,'Integer','','','',''),(2274,'menudata','setupest',2,'Integer','','','',''),(2275,'menudata','setupfix',2,'Integer','','','',''),(2276,'menudata','setupimp',2,'Integer','','','',''),(2277,'menudata','setupsc',2,'Integer','','','',''),(2278,'menudata','supervisor',2,'Integer','','','',''),(2279,'menudata','extvend',2,'Integer','','','',''),(2280,'menudata','extcust',2,'Integer','','','',''),(2281,'menudata','nonext',2,'Integer','','','',''),(2282,'menudata','menu_link',255,'Text','','','',''),(2283,'menudata','languageid',2,'Integer','','','',''),(2284,'menudataorder','id',11,'Integer','','','primary',''),(2285,'menudataorder','menu_name',30,'Text','','','',''),(2286,'menudataorder','id_menudata',11,'Integer','','','',''),(2287,'menudataorder','orderflag',5,'Integer','','','',''),(2288,'menudataorder','menu_action',2,'Integer','','','',''),(2289,'menudataorder','description',250,'Text','','','',''),(2290,'menudataorder','accessap',2,'Integer','','','',''),(2291,'menudataorder','accessar',2,'Integer','','','',''),(2292,'menudataorder','accessgl',2,'Integer','','','',''),(2293,'menudataorder','accesspay',2,'Integer','','','',''),(2294,'menudataorder','accessinv',2,'Integer','','','',''),(2295,'menudataorder','accessest',2,'Integer','','','',''),(2296,'menudataorder','accessfix',2,'Integer','','','',''),(2297,'menudataorder','accessimp',2,'Integer','','','',''),(2298,'menudataorder','setupap',2,'Integer','','','',''),(2299,'menudataorder','setupar',2,'Integer','','','',''),(2300,'menudataorder','setupgl',2,'Integer','','','',''),(2301,'menudataorder','setuppay',2,'Integer','','','',''),(2302,'menudataorder','setupinv',2,'Integer','','','',''),(2303,'menudataorder','setupest',2,'Integer','','','',''),(2304,'menudataorder','setupfix',2,'Integer','','','',''),(2305,'menudataorder','setupimp',2,'Integer','','','',''),(2306,'menudataorder','supervisor',2,'Integer','','','',''),(2307,'menudataorder','extvend',2,'Integer','','','',''),(2308,'menudataorder','extcust',2,'Integer','','','',''),(2309,'menudataorder','nonext',2,'Integer','','','',''),(2310,'menudataorder','menu_link',255,'Text','','','',''),(2311,'menudatavendor','id',11,'Integer','','','primary',''),(2312,'menudatavendor','menu_name',30,'Text','','','',''),(2313,'menudatavendor','id_menudata',11,'Integer','','','',''),(2314,'menudatavendor','orderflag',5,'Integer','','','',''),(2315,'menudatavendor','menu_action',2,'Integer','','','',''),(2316,'menudatavendor','description',250,'Text','','','',''),(2317,'menudatavendor','accessap',2,'Integer','','','',''),(2318,'menudatavendor','accessar',2,'Integer','','','',''),(2319,'menudatavendor','accessgl',2,'Integer','','','',''),(2320,'menudatavendor','accesspay',2,'Integer','','','',''),(2321,'menudatavendor','accessinv',2,'Integer','','','',''),(2322,'menudatavendor','accessest',2,'Integer','','','',''),(2323,'menudatavendor','accessfix',2,'Integer','','','',''),(2324,'menudatavendor','accessimp',2,'Integer','','','',''),(2325,'menudatavendor','setupap',2,'Integer','','','',''),(2326,'menudatavendor','setupar',2,'Integer','','','',''),(2327,'menudatavendor','setupgl',2,'Integer','','','',''),(2328,'menudatavendor','setuppay',2,'Integer','','','',''),(2329,'menudatavendor','setupinv',2,'Integer','','','',''),(2330,'menudatavendor','setupest',2,'Integer','','','',''),(2331,'menudatavendor','setupfix',2,'Integer','','','',''),(2332,'menudatavendor','setupimp',2,'Integer','','','',''),(2333,'menudatavendor','supervisor',2,'Integer','','','',''),(2334,'menudatavendor','extvend',2,'Integer','','','',''),(2335,'menudatavendor','extcust',2,'Integer','','','',''),(2336,'menudatavendor','nonext',2,'Integer','','','',''),(2337,'menudatavendor','menu_link',255,'Text','','','',''),(2338,'menufunction','id',11,'Integer','','','primary unique',''),(2339,'menufunction','menucategoryid',11,'Integer','','','multiple',''),(2340,'menufunction','name',50,'Text','','','',''),(2341,'menufunction','leftimageurl',50,'Text','','','',''),(2342,'menufunction','rightimageurl',50,'Text','','','',''),(2343,'menufunction','link',50,'Text','','','',''),(2344,'menufunction','orderflag',11,'Integer','','','multiple',''),(2345,'menufunction','accessap',11,'Integer','','','multiple',''),(2346,'menufunction','accessar',11,'Integer','','','multiple',''),(2347,'menufunction','accessgl',11,'Integer','','','multiple',''),(2348,'menufunction','accesspay',11,'Integer','','','multiple',''),(2349,'menufunction','accessinv',11,'Integer','','','multiple',''),(2350,'menufunction','accessest',11,'Integer','','','multiple',''),(2351,'menufunction','accessfix',11,'Integer','','','multiple',''),(2352,'menufunction','accessimp',11,'Integer','','','multiple',''),(2353,'menufunction','setupap',11,'Integer','','','',''),(2354,'menufunction','setupar',11,'Integer','','','',''),(2355,'menufunction','setupgl',11,'Integer','','','',''),(2356,'menufunction','setuppay',11,'Integer','','','',''),(2357,'menufunction','setupinv',11,'Integer','','','',''),(2358,'menufunction','setupest',11,'Integer','','','',''),(2359,'menufunction','setupfix',11,'Integer','','','',''),(2360,'menufunction','setupimp',11,'Integer','','','',''),(2361,'menufunction','supervisor',11,'Integer','','','multiple',''),(2362,'menufunction','nonsupervisor',11,'Integer','','','multiple',''),(2363,'menufunction','extvend',11,'Integer','','','multiple',''),(2364,'menufunction','extcust',11,'Integer','','','multiple',''),(2365,'menufunction','nonext',11,'Integer','','','multiple',''),(2366,'menupage','id',11,'Integer','','','primary unique',''),(2367,'menupage','menufunctionid',11,'Integer','','','multiple',''),(2368,'menupage','name',50,'Text','','','',''),(2369,'menupage','orderflag',11,'Integer','','','multiple',''),(2370,'menupage','accessap',11,'Integer','','','multiple',''),(2371,'menupage','accessar',11,'Integer','','','multiple',''),(2372,'menupage','accessgl',11,'Integer','','','multiple',''),(2373,'menupage','accesspay',11,'Integer','','','multiple',''),(2374,'menupage','accessinv',11,'Integer','','','multiple',''),(2375,'menupage','accessest',11,'Integer','','','multiple',''),(2376,'menupage','accessfix',11,'Integer','','','multiple',''),(2377,'menupage','accessimp',11,'Integer','','','multiple',''),(2378,'menupage','setupap',11,'Integer','','','',''),(2379,'menupage','setupar',11,'Integer','','','',''),(2380,'menupage','setupgl',11,'Integer','','','',''),(2381,'menupage','setuppay',11,'Integer','','','',''),(2382,'menupage','setupinv',11,'Integer','','','',''),(2383,'menupage','setupest',11,'Integer','','','',''),(2384,'menupage','setupfix',11,'Integer','','','',''),(2385,'menupage','setupimp',11,'Integer','','','',''),(2386,'menupage','supervisor',11,'Integer','','','multiple',''),(2387,'menupage','nonsupervisor',11,'Integer','','','multiple',''),(2388,'menupage','extvend',11,'Integer','','','multiple',''),(2389,'menupage','extcust',11,'Integer','','','multiple',''),(2390,'menupage','nonext',11,'Integer','','','multiple',''),(2391,'mod_help_categories','id',11,'Integer','','','primary',''),(2392,'mod_help_categories','parent_id',11,'Integer','','','',''),(2393,'mod_help_categories','name',255,'Text','','','',''),(2394,'mod_help_categories','ordering',11,'Integer','','','',''),(2395,'mod_help_related_topics','id',11,'Integer','','','primary',''),(2396,'mod_help_related_topics','topic_id',11,'Integer','','','',''),(2397,'mod_help_related_topics','related_topic_id',11,'Integer','','','',''),(2398,'mod_help_topics','id',11,'Integer','','','primary',''),(2399,'mod_help_topics','parent_id',11,'Integer','','','',''),(2400,'mod_help_topics','topic',255,'Text','','','',''),(2401,'mod_help_topics','helptext',65535,'X','','','',''),(2402,'mod_help_topics','ordering',11,'Integer','','','',''),(2403,'modules','id',11,'Integer','','','primary',''),(2404,'modules','name',255,'Text','','','',''),(2405,'order_actual','id_order_actual',11,'Integer','','','primary unique',''),(2406,'order_actual','id_printorder',11,'Integer','','','multiple',''),(2407,'order_actual','id_family',11,'Integer','','','multiple',''),(2408,'order_actual','print_type',2,'Integer','','','',''),(2409,'order_actual','id_question',11,'Integer','','','',''),(2410,'order_actual','id_question_detail',11,'Integer','','','',''),(2411,'order_actual','id_machine',11,'Integer','','','multiple',''),(2412,'order_actual','id_item',11,'Integer','','','',''),(2413,'order_actual','redo',2,'Integer','','','multiple',''),(2414,'order_actual','actual_time',8,'Numeric','','','',''),(2415,'order_actual','hourlyrate',17,'Numeric','','','',''),(2416,'order_actual','production_quantity',17,'Numeric','','','',''),(2417,'order_actual','production_costperunit',17,'Numeric','','','',''),(2418,'order_actual','actual_matl',17,'Numeric','','','',''),(2419,'order_actual','material_unitcost',17,'Numeric','','','',''),(2420,'order_actual','comments',250,'Text','','','',''),(2421,'order_actual','initials',10,'Text','','','',''),(2422,'order_actual','createdate',19,'DateTime','','','',''),(2423,'order_actual','id_user_create',11,'Integer','','','',''),(2424,'order_actual','lastrevisedate',19,'DateTime','','','',''),(2425,'order_actual','id_user_revise',11,'Integer','','','',''),(2426,'order_actual','canceldate',10,'Date','','','',''),(2427,'order_actual','cancel',1,'Integer','','','',''),(2428,'order_actual','time_eq_actual',12,'Numeric','','','',''),(2429,'order_actual','time_op_actual',12,'Numeric','','','',''),(2430,'order_actual','cost_op_hour',12,'Numeric','','','',''),(2431,'order_actual','cost_eq_hour',12,'Numeric','','','',''),(2432,'order_actual','matl_qty_actual',12,'Numeric','','','',''),(2433,'order_actual','matl_unitcost_actual',12,'Numeric','','','',''),(2434,'order_actual','markup',12,'Numeric','','','',''),(2435,'order_actual','extendedprice',12,'Numeric','','','',''),(2436,'order_actual','overhead',12,'Numeric','','','',''),(2437,'order_actual','Impressions_actual',12,'Numeric','','','',''),(2438,'order_actual','production_priceperunit',14,'Numeric','','','',''),(2439,'order_actual','price_per_hour',14,'Numeric','','','',''),(2440,'order_actual','matl_unitprice_actual',14,'Numeric','','','',''),(2441,'order_actual','iphunit_name',20,'Text','','','',''),(2442,'order_additional','id',11,'Integer','','','primary',''),(2443,'order_additional','id_printorder',11,'Integer','','','',''),(2444,'order_additional','id_gencompany',11,'Integer','','','',''),(2445,'order_additional','description',250,'Text','','','',''),(2446,'order_additional','quantity',15,'Text','','','',''),(2447,'order_additional','price',17,'Numeric','','','',''),(2448,'order_chargenum','id_order_chargenum',11,'Integer','','','primary unique',''),(2449,'order_chargenum','id_printorder',11,'Integer','','','multiple',''),(2450,'order_chargenum','charge_number',15,'Text','','','multiple',''),(2451,'order_chargenum','activity_number',15,'Text','','','',''),(2452,'order_chargenum','subactivity_number',15,'Text','','','',''),(2453,'order_chargenum','percent_of_order',12,'Numeric','','','',''),(2454,'order_chargenum','cancel',1,'Integer','','','',''),(2455,'order_chargenum','canceldate',10,'Date','','','',''),(2456,'order_chargenum','wherefrom',2,'Integer','','','',''),(2457,'order_document','id_order_document',11,'Integer','','','primary',''),(2458,'order_document','id_printorder',11,'Integer','','','multiple',''),(2459,'order_document','docname',255,'Text','','','',''),(2460,'order_document','origdocname',255,'Text','','','',''),(2461,'order_document','cancel',2,'Integer','','','',''),(2462,'order_document','lastrevisedate',19,'DateTime','','','',''),(2463,'order_document','id_temp',11,'Integer','','','',''),(2464,'order_functions','id_order_functions',11,'Integer','','','primary unique',''),(2465,'order_functions','id_printorder',11,'Integer','','','multiple',''),(2466,'order_functions','id_question',11,'Integer','','','multiple',''),(2467,'order_functions','sel_response',100,'Text','','','',''),(2468,'order_functions','text_response',100,'Text','','','',''),(2469,'order_functions','time_est',12,'Numeric','','','',''),(2470,'order_functions','time_est_price',14,'Numeric','','','',''),(2471,'order_functions','time_est_cost',14,'Numeric','','','',''),(2472,'order_functions','materials_est_cost',14,'Numeric','','','',''),(2473,'order_functions','materials_est_price',14,'Numeric','','','',''),(2474,'order_functions','createdate',19,'DateTime','','','',''),(2475,'order_functions','id_user_create',11,'Integer','','','',''),(2476,'order_functions','lastrevisedate',19,'DateTime','','','',''),(2477,'order_functions','id_user_revise',11,'Integer','','','',''),(2478,'order_functions','canceldate',19,'DateTime','','','',''),(2479,'order_functions','cancel',11,'Integer','','','',''),(2480,'order_functions','actual_quantity',17,'Numeric','','','',''),(2481,'order_functions','calc_quantity',17,'Numeric','','','',''),(2482,'order_functions','actual_quantity_materials',17,'Numeric','','','',''),(2483,'order_functions','calc_quantity_materials',17,'Numeric','','','',''),(2484,'order_functions','print_type',1,'Integer','','','',''),(2485,'order_functions','id_order_partnr',11,'Integer','','','',''),(2486,'order_functions','id_item',11,'Integer','','','',''),(2487,'order_functions','id_family',11,'Integer','','','',''),(2488,'order_functions','time_eq_est',12,'Numeric','','','',''),(2489,'order_functions','time_op_est',12,'Numeric','','','',''),(2490,'order_functions','cost_op_hour',12,'Numeric','','','',''),(2491,'order_functions','cost_eq_hour',12,'Numeric','','','',''),(2492,'order_functions','matl_qty_est',12,'Numeric','','','',''),(2493,'order_functions','matl_unitcost_est',12,'Numeric','','','',''),(2494,'order_functions','overhead',6,'Numeric','','','',''),(2495,'order_functions','markup',6,'Numeric','','','',''),(2496,'order_functions','extendedprice',12,'Numeric','','','',''),(2497,'order_functions','Impressions_est',11,'Integer','','','',''),(2498,'order_functions','quote_quantity',11,'Integer','','','',''),(2499,'order_functions','time_actual',14,'Numeric','','','',''),(2500,'order_functions','time_actual_cost',14,'Numeric','','','',''),(2501,'order_functions','time_actual_price',14,'Numeric','','','',''),(2502,'order_functions','materials_actual_price',14,'Numeric','','','',''),(2503,'order_functions','materials_actual_cost',14,'Numeric','','','',''),(2504,'order_functions','production_quantity',14,'Integer','','','',''),(2505,'order_functions','production_priceperunit',14,'Numeric','','','',''),(2506,'order_functions','matl_unitprice_est',14,'Numeric','','','',''),(2507,'order_functions','price_per_hour',14,'Numeric','','','',''),(2508,'order_functions','iphunit_name',20,'Text','','','',''),(2509,'order_partnr','id_order_partnr',11,'Integer','','','primary unique',''),(2510,'order_partnr','id_printorder',11,'Integer','','','multiple',''),(2511,'order_partnr','id_item',11,'Integer','','','multiple',''),(2512,'order_partnr','print_method',3,'Integer','','','',''),(2513,'order_partnr','quantity_est',15,'Numeric','','','',''),(2514,'order_partnr','quantity_scrap_cust',15,'Numeric','','','',''),(2515,'order_partnr','quantity_scrap_xrx',15,'Numeric','','','',''),(2516,'order_partnr','quantity_good_actual',15,'Numeric','','','',''),(2517,'order_partnr','cost_per_salesunit',12,'Numeric','','','',''),(2518,'order_partnr','price_per_salesunit',12,'Numeric','','','',''),(2519,'order_partnr','status',3,'Integer','','','',''),(2520,'order_partnr','description',20,'Text','','','',''),(2521,'order_partnr','number_up',3,'Integer','','','',''),(2522,'order_partnr','pages',5,'Integer','','','',''),(2523,'order_partnr','num_originals',5,'Integer','','','',''),(2524,'order_partnr','sides',1,'Integer','','','',''),(2525,'order_partnr','special_order',50,'Text','','','',''),(2526,'order_partnr','width',12,'Numeric','','','',''),(2527,'order_partnr','length',12,'Numeric','','','',''),(2528,'order_partnr','impressions',15,'Numeric','','','',''),(2529,'order_partnr','num_colors',3,'Integer','','','',''),(2530,'order_partnr','colorlist',100,'Text','','','',''),(2531,'order_partnr','createdate',19,'DateTime','','','',''),(2532,'order_partnr','id_user_create',11,'Integer','','','',''),(2533,'order_partnr','lastrevisedate',19,'DateTime','','','',''),(2534,'order_partnr','id_user_revise',11,'Integer','','','',''),(2535,'order_partnr','canceldate',19,'DateTime','','','',''),(2536,'order_partnr','cancel',11,'Integer','','','',''),(2537,'order_partnr','mwt',8,'Numeric','','','',''),(2538,'order_partnr','press_width',12,'Numeric','','','',''),(2539,'order_partnr','press_length',12,'Numeric','','','',''),(2540,'order_partnr','number_out',3,'Integer','','','',''),(2541,'order_partnr','colorlist_two',100,'Text','','','',''),(2542,'order_partnr','num_colors_two',3,'Integer','','','',''),(2543,'order_partnr','pages_per_sig',5,'Integer','','','',''),(2544,'order_partnr','signatures',5,'Integer','','','',''),(2545,'order_partnr','iphqty',11,'Integer','','','',''),(2546,'order_partnr','iphunit_name',20,'Text','','','',''),(2547,'order_partnr','difficulty',3,'Integer','','','',''),(2548,'order_po','id_order_po',11,'Integer','','','primary unique',''),(2549,'order_po','id_printorder',11,'Integer','','','multiple',''),(2550,'order_po','id_purchase_order',11,'Integer','','','multiple',''),(2551,'order_po','id_workarea',11,'Integer','','','',''),(2552,'order_proof','id_order_proof',11,'Integer','','','primary',''),(2553,'order_proof','sentdate',19,'DateTime','','','',''),(2554,'order_proof','pages',3,'Integer','','','',''),(2555,'order_proof','proof_status',1,'Integer','','','',''),(2556,'order_proof','id_printorder',11,'Integer','','','',''),(2557,'order_proof','responsedate',19,'DateTime','','','',''),(2558,'order_proof','duedate',19,'DateTime','','','',''),(2559,'order_proof','notes',250,'Text','','','',''),(2560,'order_proof','id_user_create',11,'Integer','','','',''),(2561,'order_proof','createdate',19,'DateTime','','','',''),(2562,'order_proof','lastrevisedate',19,'DateTime','','','',''),(2563,'order_proof','id_user_revise',11,'Integer','','','',''),(2564,'order_proof','cancel',11,'Integer','','','',''),(2565,'order_proof','canceldate',19,'DateTime','','','',''),(2566,'order_proof','days_after',11,'Integer','','','',''),(2567,'order_shipment','id_order_shipment',11,'Integer','','','primary unique',''),(2568,'order_shipment','id_order_shipto',11,'Integer','','','multiple',''),(2569,'order_shipment','quantity',15,'Integer','','','',''),(2570,'order_shipment','shipdate',19,'DateTime','','','',''),(2571,'order_shipment','id_order_shipmentlog',11,'Integer','','','',''),(2572,'order_shipment','packslip',2,'Integer','','','',''),(2573,'order_shipment','boxlabel',2,'Integer','','','',''),(2574,'order_shipment','logdate',19,'DateTime','','','',''),(2575,'order_shipment','createdate',10,'Date','','','',''),(2576,'order_shipment','id_user_create',11,'Integer','','','',''),(2577,'order_shipment','lastrevisedate',19,'DateTime','','','',''),(2578,'order_shipment','id_user_revise',11,'Integer','','','',''),(2579,'order_shipment','canceldate',10,'Date','','','',''),(2580,'order_shipment','cancel',11,'Integer','','','',''),(2581,'order_shipment','signfor',255,'Text','','','',''),(2582,'order_shipment','failed',11,'Integer','','','',''),(2583,'order_shipment','id_printorder',11,'Integer','','','',''),(2584,'order_shipment','notes',250,'Text','','','',''),(2585,'order_shipment','id_order_shipment_group',11,'Integer','','','multiple',''),(2586,'order_work','id',11,'Integer','','','primary',''),(2587,'order_work','id_employee',11,'Integer','','','',''),(2588,'order_work','id_printorder',11,'Integer','','','',''),(2589,'order_work','id_family',11,'Integer','','','',''),(2590,'order_work','id_question',11,'Integer','','','',''),(2591,'order_work','id_question_detail',11,'Integer','','','',''),(2592,'order_work','id_machine',11,'Integer','','','',''),(2593,'order_work','id_order_actual',11,'Integer','','','',''),(2594,'order_work','startdatetime',19,'DateTime','','','',''),(2595,'order_work','enddatetime',19,'DateTime','','','',''),(2596,'order_work','elapsedtime',17,'Numeric','','','',''),(2597,'order_work','status',11,'Integer','','','',''),(2598,'orders_products_attributes','orders_products_attributes_id',5,'Integer','','','primary',''),(2599,'orders_products_attributes','orders_id',5,'Integer','','','',''),(2600,'orders_products_attributes','orders_products_id',5,'Integer','','','',''),(2601,'orders_products_attributes','products_options',32,'Text','','','',''),(2602,'orders_products_attributes','products_options_values',32,'Text','','','',''),(2603,'orders_products_attributes','options_values_price',10,'Numeric','','','',''),(2604,'orders_products_attributes','price_prefix',1,'Text','','','',''),(2605,'originals','id_originals',11,'Integer','','','multiple',''),(2606,'originals','name',50,'Text','','','',''),(2607,'payplan_bills','id',11,'Integer','','','primary',''),(2608,'payplan_bills','payplan_invoiceid',11,'Integer','','','multiple',''),(2609,'payplan_bills','invoicedate',10,'Date','','','',''),(2610,'payplan_bills','invoiceid',11,'Integer','','','multiple',''),(2611,'pickupsalestax','id',11,'Integer','','','primary',''),(2612,'pickupsalestax','gencompanyid',11,'Integer','','','multiple',''),(2613,'pickupsalestax','salestaxid',11,'Integer','','','multiple',''),(2614,'practive','id',22,'Numeric','','','primary unique',''),(2615,'practive','employeeid',22,'Numeric','','','',''),(2616,'practive','status',11,'Integer','','','',''),(2617,'practive','statuschangedate',10,'Date','','','',''),(2618,'practive','lastchangedate',19,'DateTime','','','',''),(2619,'practive','lastchangeuserid',22,'Numeric','','','',''),(2620,'prbended','id',22,'Numeric','','','primary unique',''),(2621,'prbended','gencompanyid',22,'Numeric','','','',''),(2622,'prbended','paytype',11,'Integer','','','',''),(2623,'prbended','bendedtype',11,'Integer','','','',''),(2624,'prbended','name',30,'Text','','','multiple',''),(2625,'prbended','howfig',11,'Integer','','','',''),(2626,'prbended','prdedgroupid',22,'Numeric','','','',''),(2627,'prbended','rate',10,'Numeric','','','',''),(2628,'prbended','ceilingperyear',21,'Numeric','','','',''),(2629,'prbended','expenseglacctid',22,'Numeric','','','',''),(2630,'prbended','payableglacctid',22,'Numeric','','','',''),(2631,'prbended','vendorid',22,'Numeric','','','',''),(2632,'prbended','cancel',11,'Integer','','','',''),(2633,'prbended','canceldate',19,'DateTime','','','',''),(2634,'prbended','canceluserid',22,'Numeric','','','',''),(2635,'prbended','entrydate',19,'DateTime','','','',''),(2636,'prbended','entryuserid',22,'Numeric','','','',''),(2637,'prbended','lastchangedate',19,'DateTime','','','',''),(2638,'prbended','lastchangeuserid',22,'Numeric','','','',''),(2639,'prcity','id',22,'Numeric','','','primary unique',''),(2640,'prcity','gencompanyid',22,'Numeric','','','',''),(2641,'prcity','abrev',3,'Text','','','',''),(2642,'prcity','name',30,'Text','','','',''),(2643,'prcity','taxnum',20,'Text','','','',''),(2644,'prcity','deductfed',11,'Integer','','','',''),(2645,'prcity','feddeductmax',21,'Numeric','','','',''),(2646,'prcity','exemptyr1',21,'Numeric','','','',''),(2647,'prcity','exemptyr2',21,'Numeric','','','',''),(2648,'prcity','exemptyr3',21,'Numeric','','','',''),(2649,'prcity','exemptyr4',21,'Numeric','','','',''),(2650,'prcity','glacctid',22,'Numeric','','','',''),(2651,'prcity','vendorid',22,'Numeric','','','',''),(2652,'prcity','maxexemptpercent',7,'Numeric','','','',''),(2653,'prcity','maxexemptyear',21,'Numeric','','','',''),(2654,'prcity','taxcreditexempt1',21,'Numeric','','','',''),(2655,'prcity','taxcreditexempt2',21,'Numeric','','','',''),(2656,'prcity','taxcreditexempt3',21,'Numeric','','','',''),(2657,'prcity','taxcreditexempt4',21,'Numeric','','','',''),(2658,'prcity','cancel',11,'Integer','','','',''),(2659,'prcity','canceldate',19,'DateTime','','','',''),(2660,'prcity','canceluserid',22,'Numeric','','','',''),(2661,'prcity','entrydate',19,'DateTime','','','',''),(2662,'prcity','entryuserid',22,'Numeric','','','',''),(2663,'prcity','lastchangedate',19,'DateTime','','','',''),(2664,'prcity','lastchangeuserid',22,'Numeric','','','',''),(2665,'prcitydetail','id',22,'Numeric','','','primary unique',''),(2666,'prcitydetail','prcityid',22,'Numeric','','','',''),(2667,'prcitydetail','maritalstatus',11,'Integer','','','',''),(2668,'prcitydetail','deductiontable',11,'Integer','','','',''),(2669,'prcitydetail','tax',21,'Numeric','','','',''),(2670,'prcitydetail','percent',10,'Numeric','','','',''),(2671,'prcitydetail','over',21,'Numeric','','','',''),(2672,'prcompany','id',22,'Numeric','','','primary unique',''),(2673,'prcompany','fedtaxnum',15,'Text','','','',''),(2674,'prcompany','w2companyname',35,'Text','','','',''),(2675,'prcompany','w2companyaddress1',100,'Text','','','',''),(2676,'prcompany','w2companyaddress2',100,'Text','','','',''),(2677,'prcompany','w2citystatezip',100,'Text','','','',''),(2678,'prcompany','stateunemplnum',15,'Text','','','',''),(2679,'prcompany','glcheckaccountid',22,'Numeric','','','',''),(2680,'prcompany','glfitpayableid',22,'Numeric','','','',''),(2681,'prcompany','glficapayableid',22,'Numeric','','','',''),(2682,'prcompany','glficaexpenseid',22,'Numeric','','','',''),(2683,'prcompany','glfuipayableid',22,'Numeric','','','',''),(2684,'prcompany','glfuiexpenseid',22,'Numeric','','','',''),(2685,'prcompany','glmedicarepayableid',22,'Numeric','','','',''),(2686,'prcompany','glmedicareexpenseid',22,'Numeric','','','',''),(2687,'prcompany','glsuipayableid',22,'Numeric','','','',''),(2688,'prcompany','glsuiexpenseid',22,'Numeric','','','',''),(2689,'prcompany','glmiscdedpayableid',22,'Numeric','','','',''),(2690,'prcompany','gltaxexemptexpenseid',22,'Numeric','','','',''),(2691,'prcompany','glworkmanscomppayableid',22,'Numeric','','','',''),(2692,'prcompany','glworkmanscompexpenseid',22,'Numeric','','','',''),(2693,'prcompany','post2payables',11,'Integer','','','',''),(2694,'prcompany','checkacctid',22,'Numeric','','','',''),(2695,'prcompany','shift2multiplier',7,'Numeric','','','',''),(2696,'prcompany','shift3multiplier',7,'Numeric','','','',''),(2697,'prcompany','sickleavehrsperyear',7,'Numeric','','','',''),(2698,'prcompany','maxsickleave',9,'Numeric','','','',''),(2699,'prcompany','minwagehr',12,'Numeric','','','',''),(2700,'prcompany','autoprintdeposit',11,'Integer','','','',''),(2701,'prcompany','depositvendorid',22,'Numeric','','','',''),(2702,'prcompany','cancel',11,'Integer','','','',''),(2703,'prcompany','canceldate',19,'DateTime','','','',''),(2704,'prcompany','canceluserid',22,'Numeric','','','',''),(2705,'prcompany','entrydate',19,'DateTime','','','',''),(2706,'prcompany','entryuserid',22,'Numeric','','','',''),(2707,'prcompany','lastchangedate',19,'DateTime','','','',''),(2708,'prcompany','lastchangeuserid',22,'Numeric','','','',''),(2709,'prcompany','fringes',12,'Numeric','','','',''),(2710,'prcompany','default_dd_desc',10,'Text','','','',''),(2711,'prcompany','glpayroll_payableid',11,'Integer','','','',''),(2712,'prcompany','post2endperiod',5,'Integer','','','',''),(2713,'prcompanyperiod','id',22,'Numeric','','','primary unique',''),(2714,'prcompanyperiod','prcompanyid',22,'Numeric','','','multiple',''),(2715,'prcompanyperiod','prperiodid',22,'Numeric','','','multiple',''),(2716,'prcompanyperiod','maxpayhr',21,'Numeric','','','',''),(2717,'prcompanyperiod','maxgross',21,'Numeric','','','',''),(2718,'prcompanyperiod','cancel',11,'Integer','','','',''),(2719,'prdedgroup','id',22,'Numeric','','','primary unique',''),(2720,'prdedgroup','name',30,'Text','','','',''),(2721,'prdedgroup','gencompanyid',22,'Numeric','','','',''),(2722,'prdepositchecks','checkid',22,'Numeric','','','primary',''),(2723,'prdepositchecks','prperiodid',22,'Numeric','','','multiple',''),(2724,'prdepositchecks','periodbegindate',10,'Date','','','',''),(2725,'prdepositchecks','periodenddate',10,'Date','','','',''),(2726,'prdepositchecks','fit',21,'Numeric','','','',''),(2727,'prdepositchecks','fica',21,'Numeric','','','',''),(2728,'prdepositchecks','medicare',21,'Numeric','','','',''),(2729,'prdepositchecks','gencompanyid',22,'Numeric','','','',''),(2730,'prempldeduction','id',22,'Numeric','','','primary unique',''),(2731,'prempldeduction','employeeid',22,'Numeric','','','multiple',''),(2732,'prempldeduction','description',50,'Text','','','',''),(2733,'prempldeduction','amountperperiod',12,'Numeric','','','',''),(2734,'prempldeduction','glaccountid',22,'Numeric','','','',''),(2735,'prempldeduction','periodsremain',11,'Integer','','','',''),(2736,'prempldeduction','cancel',11,'Integer','','','',''),(2737,'prempldeduction','canceldate',19,'DateTime','','','',''),(2738,'prempldeduction','canceluserid',22,'Numeric','','','',''),(2739,'prempldeduction','entrydate',19,'DateTime','','','',''),(2740,'prempldeduction','entryuserid',22,'Numeric','','','',''),(2741,'prempldeduction','lastchangedate',19,'DateTime','','','',''),(2742,'prempldeduction','lastchangeuserid',22,'Numeric','','','',''),(2743,'premployee','id',22,'Numeric','','','primary unique',''),(2744,'premployee','companyid',22,'Numeric','','','',''),(2745,'premployee','firstname',30,'Text','','','',''),(2746,'premployee','lastname',30,'Text','','','',''),(2747,'premployee','ssnumber',20,'Text','','','',''),(2748,'premployee','dateofbirth',10,'Date','','','',''),(2749,'premployee','hiredate',10,'Date','','','',''),(2750,'premployee','terminatedate',10,'Date','','','',''),(2751,'premployee','lastreviewid',22,'Numeric','','','',''),(2752,'premployee','paytype',11,'Integer','','','',''),(2753,'premployee','payperiod',11,'Integer','','','',''),(2754,'premployee','payperperiod',21,'Numeric','','','',''),(2755,'premployee','lastpaychangedate',19,'DateTime','','','',''),(2756,'premployee','glaccountid',22,'Numeric','','','',''),(2757,'premployee','maritalstatus',11,'Integer','','','',''),(2758,'premployee','federalexemptions',11,'Integer','','','',''),(2759,'premployee','extrafitperpayperiod',21,'Numeric','','','',''),(2760,'premployee','extrafitbasedon',11,'Integer','','','',''),(2761,'premployee','eic',11,'Integer','','','',''),(2762,'premployee','prstateid',22,'Numeric','','','',''),(2763,'premployee','stateexemptions',11,'Integer','','','',''),(2764,'premployee','extrasitperpayperiod',21,'Numeric','','','',''),(2765,'premployee','extrasitbasedon',11,'Integer','','','',''),(2766,'premployee','prlocalid',22,'Numeric','','','',''),(2767,'premployee','localexemptions',11,'Integer','','','',''),(2768,'premployee','extralitperpayperiod',21,'Numeric','','','',''),(2769,'premployee','extralitbasedon',11,'Integer','','','',''),(2770,'premployee','prcityid',22,'Numeric','','','',''),(2771,'premployee','cityexemptions',11,'Integer','','','',''),(2772,'premployee','extracitperpayperiod',21,'Numeric','','','',''),(2773,'premployee','extracitbasedon',11,'Integer','','','',''),(2774,'premployee','workmanscomprate',12,'Numeric','','','',''),(2775,'premployee','pensplanid1',22,'Numeric','','','',''),(2776,'premployee','pensplandedamount1',12,'Numeric','','','',''),(2777,'premployee','pensplanbase1',11,'Integer','','','',''),(2778,'premployee','pensplanid2',22,'Numeric','','','',''),(2779,'premployee','pensplandedamount2',12,'Numeric','','','',''),(2780,'premployee','pensplanbase2',11,'Integer','','','',''),(2781,'premployee','vacationhoursaccrued',12,'Numeric','','','',''),(2782,'premployee','sickleavehoursaccrued',12,'Numeric','','','',''),(2783,'premployee','prdedgroupid',65535,'X','','','',''),(2784,'premployee','status',11,'Integer','','','',''),(2785,'premployee','gencompanyid',22,'Numeric','','','',''),(2786,'premployee','cancel',11,'Integer','','','',''),(2787,'premployee','canceldate',19,'DateTime','','','',''),(2788,'premployee','canceluserid',22,'Numeric','','','',''),(2789,'premployee','entrydate',19,'DateTime','','','',''),(2790,'premployee','entryuserid',22,'Numeric','','','',''),(2791,'premployee','lastchangedate',19,'DateTime','','','',''),(2792,'premployee','lastchangeuserid',22,'Numeric','','','',''),(2793,'premployee','image',64,'Text','','','',''),(2794,'premployee','workclassid',11,'Integer','','','',''),(2795,'premployee','direct_deposit',2,'Integer','','','',''),(2796,'premployee','bankaccountid',11,'Integer','','','multiple',''),(2797,'premplreview','id',22,'Numeric','','','primary unique',''),(2798,'premplreview','employeeid',22,'Numeric','','','',''),(2799,'premplreview','evaluatorname',50,'Text','','','',''),(2800,'premplreview','evaldate',10,'Date','','','',''),(2801,'premplreview','premplreviewratingid',22,'Numeric','','','',''),(2802,'premplreview','comments',65535,'X','','','',''),(2803,'premplreview','cancel',11,'Integer','','','',''),(2804,'premplreview','canceldate',19,'DateTime','','','',''),(2805,'premplreview','canceluserid',22,'Numeric','','','',''),(2806,'premplreview','entrydate',19,'DateTime','','','',''),(2807,'premplreview','entryuserid',22,'Numeric','','','',''),(2808,'premplreview','lastchangedate',19,'DateTime','','','',''),(2809,'premplreview','lastchangeuserid',22,'Numeric','','','',''),(2810,'premplreviewrating','id',22,'Numeric','','','primary unique',''),(2811,'premplreviewrating','description',50,'Text','','','',''),(2812,'premplweek','id',22,'Numeric','','','primary unique',''),(2813,'premplweek','employeeid',22,'Numeric','','','',''),(2814,'premplweek','periodbegindate',10,'Date','','','',''),(2815,'premplweek','periodenddate',10,'Date','','','',''),(2816,'premplweek','prperiodid',22,'Numeric','','','',''),(2817,'premplweek','tipspay',21,'Numeric','','','',''),(2818,'premplweek','tipsaswages',21,'Numeric','','','',''),(2819,'premplweek','misctaxablepay',21,'Numeric','','','',''),(2820,'premplweek','misctaxablecomment',30,'Text','','','',''),(2821,'premplweek','miscnontaxablepay',21,'Numeric','','','',''),(2822,'premplweek','miscnontaxablecomment',30,'Text','','','',''),(2823,'premplweek','vacaccrue',7,'Numeric','','','',''),(2824,'premplweek','sickaccrue',7,'Numeric','','','',''),(2825,'premplweek','federaltax',21,'Numeric','','','',''),(2826,'premplweek','ficatax',21,'Numeric','','','',''),(2827,'premplweek','statetax',21,'Numeric','','','',''),(2828,'premplweek','localtax',21,'Numeric','','','',''),(2829,'premplweek','citytax',21,'Numeric','','','',''),(2830,'premplweek','prstateid',22,'Numeric','','','',''),(2831,'premplweek','prcityid',22,'Numeric','','','',''),(2832,'premplweek','prlocalid',22,'Numeric','','','',''),(2833,'premplweek','eiccredit',21,'Numeric','','','',''),(2834,'premplweek','miscdeduction',21,'Numeric','','','',''),(2835,'premplweek','miscdeductioncomment',30,'Text','','','',''),(2836,'premplweek','medicarededuction',21,'Numeric','','','',''),(2837,'premplweek','calculatestatus',11,'Integer','','','',''),(2838,'premplweek','fuitax',21,'Numeric','','','',''),(2839,'premplweek','cficatax',21,'Numeric','','','',''),(2840,'premplweek','cmedicarededuction',21,'Numeric','','','',''),(2841,'premplweek','suitax',21,'Numeric','','','',''),(2842,'premplweek','netpay',21,'Numeric','','','',''),(2843,'premplweek','checkid',22,'Numeric','','','multiple',''),(2844,'premplweek','cancel',11,'Integer','','','multiple',''),(2845,'premplweek','canceldate',19,'DateTime','','','',''),(2846,'premplweek','canceluserid',22,'Numeric','','','',''),(2847,'premplweek','entrydate',19,'DateTime','','','',''),(2848,'premplweek','entryuserid',22,'Numeric','','','',''),(2849,'premplweek','lastchangedate',19,'DateTime','','','',''),(2850,'premplweek','lastchangeuserid',22,'Numeric','','','',''),(2851,'premplweek','depositcheckid',22,'Numeric','','','',''),(2852,'premplweekdeddetail','id',22,'Numeric','','','primary unique',''),(2853,'premplweekdeddetail','premplweekid',22,'Numeric','','','',''),(2854,'premplweekdeddetail','prempldeductionid',22,'Numeric','','','',''),(2855,'premplweekdeddetail','prbendedid',22,'Numeric','','','',''),(2856,'premplweekdeddetail','prpensionid',22,'Numeric','','','',''),(2857,'premplweekdeddetail','amount',21,'Numeric','','','',''),(2858,'premplweekdeddetail','dedtype',11,'Integer','','','',''),(2859,'premplweekpaydetail','id',22,'Numeric','','','primary unique',''),(2860,'premplweekpaydetail','premplweekid',22,'Numeric','','','',''),(2861,'premplweekpaydetail','prpaytypeid',11,'Integer','','','',''),(2862,'premplweekpaydetail','prbendedid',22,'Numeric','','','',''),(2863,'premplweekpaydetail','qty',10,'Numeric','','','',''),(2864,'premplweekpaydetail','rate',10,'Numeric','','','',''),(2865,'premplweekpaydetail','amount',21,'Numeric','','','',''),(2866,'premplweekpaydetail','glaccountid',22,'Numeric','','','',''),(2867,'prfederal','id',22,'Numeric','','','primary unique',''),(2868,'prfederal','maxwagesfica',21,'Numeric','','','',''),(2869,'prfederal','employeeficapercent',10,'Numeric','','','',''),(2870,'prfederal','companyficapercent',10,'Numeric','','','',''),(2871,'prfederal','maxwagesmedicare',21,'Numeric','','','',''),(2872,'prfederal','employeemedicarepercent',10,'Numeric','','','',''),(2873,'prfederal','companymedicarepercent',10,'Numeric','','','',''),(2874,'prfederal','maxwagesfui',21,'Numeric','','','',''),(2875,'prfederal','companyfuipercent',10,'Numeric','','','',''),(2876,'prfederal','eicsinglepercent1',10,'Numeric','','','',''),(2877,'prfederal','eicsingleover1',21,'Numeric','','','',''),(2878,'prfederal','eicsingletax2',21,'Numeric','','','',''),(2879,'prfederal','eicsingleover2',21,'Numeric','','','',''),(2880,'prfederal','eicsingletax3',21,'Numeric','','','',''),(2881,'prfederal','eicsinglepercent3',10,'Numeric','','','',''),(2882,'prfederal','eicsingleover3',21,'Numeric','','','',''),(2883,'prfederal','eicmarriedpercent1',10,'Numeric','','','',''),(2884,'prfederal','eicmarriedover1',21,'Numeric','','','',''),(2885,'prfederal','eicmarriedtax2',21,'Numeric','','','',''),(2886,'prfederal','eicmarriedover2',21,'Numeric','','','',''),(2887,'prfederal','eicmarriedtax3',21,'Numeric','','','',''),(2888,'prfederal','eicmarriedpercent3',10,'Numeric','','','',''),(2889,'prfederal','eicmarriedover3',21,'Numeric','','','',''),(2890,'prfederal','exemptionallow',21,'Numeric','','','',''),(2891,'prfederal','gencompanyid',22,'Numeric','','','multiple',''),(2892,'prfederal','cancel',11,'Integer','','','',''),(2893,'prfederal','canceldate',19,'DateTime','','','',''),(2894,'prfederal','canceluserid',22,'Numeric','','','',''),(2895,'prfederal','entrydate',19,'DateTime','','','',''),(2896,'prfederal','entryuserid',22,'Numeric','','','',''),(2897,'prfederal','lastchangedate',19,'DateTime','','','',''),(2898,'prfederal','lastchangeuserid',22,'Numeric','','','',''),(2899,'prfederaldetail','id',22,'Numeric','','','primary unique',''),(2900,'prfederaldetail','prfederalid',22,'Numeric','','','',''),(2901,'prfederaldetail','maritalstatus',11,'Integer','','','',''),(2902,'prfederaldetail','deductiontable',11,'Integer','','','',''),(2903,'prfederaldetail','tax',21,'Numeric','','','',''),(2904,'prfederaldetail','percent',10,'Numeric','','','',''),(2905,'prfederaldetail','over',21,'Numeric','','','',''),(2906,'pricediscount','id',22,'Numeric','','','primary unique',''),(2907,'pricediscount','itemid',22,'Numeric','','','multiple',''),(2908,'pricediscount','itemlocationid',22,'Numeric','','','multiple',''),(2909,'pricediscount','quantity',14,'Numeric','','','',''),(2910,'pricediscount','discount',8,'Numeric','','','',''),(2911,'pricediscount','cancel',11,'Integer','','','',''),(2912,'pricediscount','canceldate',19,'DateTime','','','',''),(2913,'pricediscount','canceluserid',22,'Numeric','','','',''),(2914,'pricediscount','entrydate',19,'DateTime','','','',''),(2915,'pricediscount','entryuserid',22,'Numeric','','','',''),(2916,'pricediscount','lastchangedate',19,'DateTime','','','',''),(2917,'pricediscount','lastchangeuserid',22,'Numeric','','','',''),(2918,'pricelevel','id',22,'Numeric','','','primary unique',''),(2919,'pricelevel','description',30,'Text','','','',''),(2920,'pricelevel','companyid',22,'Numeric','','','multiple',''),(2921,'pricelevel','cancel',11,'Integer','','','',''),(2922,'pricelevel','canceldate',19,'DateTime','','','',''),(2923,'pricelevel','canceluserid',22,'Numeric','','','',''),(2924,'pricelevel','entrydate',19,'DateTime','','','',''),(2925,'pricelevel','entryuserid',22,'Numeric','','','',''),(2926,'pricelevel','lastchangedate',19,'DateTime','','','',''),(2927,'pricelevel','lastchangeuserid',22,'Numeric','','','',''),(2928,'priceperpriceunit','id',22,'Numeric','','','primary unique',''),(2929,'priceperpriceunit','itemid',22,'Numeric','','','multiple',''),(2930,'priceperpriceunit','itemlocationid',22,'Numeric','','','multiple',''),(2931,'priceperpriceunit','pricelevelid',22,'Numeric','','','multiple',''),(2932,'priceperpriceunit','price',21,'Numeric','','','',''),(2933,'priceperpriceunit','cancel',11,'Integer','','','',''),(2934,'priceperpriceunit','canceldate',19,'DateTime','','','',''),(2935,'priceperpriceunit','canceluserid',22,'Numeric','','','',''),(2936,'priceperpriceunit','entrydate',19,'DateTime','','','',''),(2937,'priceperpriceunit','entryuserid',22,'Numeric','','','',''),(2938,'priceperpriceunit','lastchangedate',19,'DateTime','','','',''),(2939,'priceperpriceunit','lastchangeuserid',22,'Numeric','','','',''),(2940,'print_categories','id',11,'Integer','','','primary',''),(2941,'print_categories','description',50,'Text','','','',''),(2942,'print_categories','glacctid',11,'Integer','','','',''),(2943,'print_categories','entrydate',19,'DateTime','','','',''),(2944,'print_categories','entryuserid',11,'Integer','','','',''),(2945,'print_categories','cancel',2,'Integer','','','',''),(2946,'print_categories','canceldate',19,'DateTime','','','',''),(2947,'print_categories','canceluserid',11,'Integer','','','',''),(2948,'print_categories','lastupdatedate',19,'DateTime','','','',''),(2949,'print_categories','gencompanyid',11,'Integer','','','',''),(2950,'printorder','id_printorder',11,'Integer','','','primary unique',''),(2951,'printorder','id_customer',11,'Integer','','','multiple',''),(2952,'printorder','id_printorder_main',11,'Integer','','','',''),(2953,'printorder','linenum',3,'Integer','','','',''),(2954,'printorder','id_worksubtype',11,'Integer','','','',''),(2955,'printorder','description',250,'Text','','','',''),(2956,'printorder','destination_partnr',30,'Text','','','multiple',''),(2957,'printorder','order_quantity',14,'Integer','','','',''),(2958,'printorder','order_type',2,'Integer','','','',''),(2959,'printorder','vendall',1,'Integer','','','',''),(2960,'printorder','order_class',2,'Integer','','','',''),(2961,'printorder','status',2,'Integer','','','',''),(2962,'printorder','approvedate',19,'DateTime','','','',''),(2963,'printorder','duedate',19,'DateTime','','','',''),(2964,'printorder','finalshipdate',19,'DateTime','','','',''),(2965,'printorder','pricedate',10,'Date','','','',''),(2966,'printorder','createdate',19,'DateTime','','','',''),(2967,'printorder','id_user_create',11,'Integer','','','',''),(2968,'printorder','lastrevisedate',19,'DateTime','','','',''),(2969,'printorder','id_user_revise',11,'Integer','','','',''),(2970,'printorder','canceldate',19,'DateTime','','','',''),(2971,'printorder','cancel',11,'Integer','','','',''),(2972,'printorder','numperunit',5,'Integer','','','',''),(2973,'printorder','totalpages',5,'Integer','','','',''),(2974,'printorder','unitname',10,'Text','','','',''),(2975,'printorder','instructions',65535,'X','','','',''),(2976,'printorder','priority',2,'Integer','','','',''),(2977,'printorder','estimated_price',17,'Numeric','','','',''),(2978,'printorder','estimated_cost',17,'Numeric','','','',''),(2979,'printorder','actual_price',17,'Numeric','','','',''),(2980,'printorder','final_width',12,'Numeric','','','',''),(2981,'printorder','final_length',12,'Numeric','','','',''),(2982,'printorder','who_ok_price',10,'Text','','','',''),(2983,'printorder','id_latereason',11,'Integer','','','',''),(2984,'printorder','enter_initials',3,'Text','','','',''),(2985,'printorder','del_initials',3,'Text','','','',''),(2986,'printorder','bill_sent',2,'Integer','','','',''),(2987,'printorder','bill_month',2,'Text','','','',''),(2988,'printorder','bill_year',4,'Text','','','',''),(2989,'printorder','shiptotal',16,'Numeric','','','',''),(2990,'printorder','vend_est_total',16,'Numeric','','','',''),(2991,'printorder','qc_initials',5,'Text','','','',''),(2992,'printorder','fulldetails',250,'Text','','','',''),(2993,'printorder','pickup',2,'Integer','','','',''),(2994,'printorder','internalorder',2,'Integer','','','',''),(2995,'printorder','mailroom',5,'Text','','','',''),(2996,'printorder','cliententry',11,'Integer','','','',''),(2997,'printorder','id_originals',11,'Integer','','','',''),(2998,'printorder','proof',2,'Integer','','','',''),(2999,'printorder','quote',2,'Integer','','','',''),(3000,'printorder','id_gencompany',11,'Integer','','','',''),(3001,'printorder','customer_po',50,'Text','','','',''),(3002,'printorder','multiquotestatus',11,'Integer','','','',''),(3003,'printorder','notes',255,'Text','','','',''),(3004,'printorder','orientation',20,'Text','','','',''),(3005,'printorder','quotedesc',65535,'X','','','',''),(3006,'printorder_misc','id_printorder',11,'Integer','','','',''),(3007,'printorder_misc','shipqty1',11,'Integer','','','',''),(3008,'printorder_misc','shipdate1',19,'DateTime','','','',''),(3009,'printorder_misc','shipqty2',11,'Integer','','','',''),(3010,'printorder_misc','shipdate2',19,'DateTime','','','',''),(3011,'printorder_misc','shipqty3',11,'Integer','','','',''),(3012,'printorder_misc','shipdate3',19,'DateTime','','','',''),(3013,'printorder_misc','shipqty4',11,'Integer','','','',''),(3014,'printorder_misc','shipdate4',19,'DateTime','','','',''),(3015,'printorder_misc','shipqty5',11,'Integer','','','',''),(3016,'printorder_misc','shipdate5',19,'DateTime','','','',''),(3017,'printorder_misc','orientation',50,'Text','','','',''),(3018,'printorder_misc','quote_desc',65535,'X','','','',''),(3019,'printorder_shipsched','id',11,'Integer','','','primary unique',''),(3020,'printorder_shipsched','id_printorder',11,'Integer','','','multiple',''),(3021,'printorder_shipsched','id_printorder_shipto',11,'Integer','','','multiple',''),(3022,'printorder_shipsched','qty',11,'Integer','','','',''),(3023,'printorder_shipsched','shipdate',10,'Date','','','multiple',''),(3024,'printorder_shipsched','cancel',2,'Integer','','','multiple',''),(3025,'printorder_shipsched','canceldate',19,'DateTime','','','',''),(3026,'printorder_shipsched','canceluserid',11,'Integer','','','',''),(3027,'printorder_shipto','id_printorder_shipto',11,'Integer','','','primary',''),(3028,'printorder_shipto','id_printorder',11,'Integer','','','multiple',''),(3029,'printorder_shipto','attn',50,'Text','','','',''),(3030,'printorder_shipto','quantity',11,'Integer','','','',''),(3031,'printorder_shipto','id_delivery',11,'Integer','','','',''),(3032,'printorder_shipto','id_shipto',11,'Integer','','','',''),(3033,'printorder_shipto','cancel',2,'Integer','','','',''),(3034,'printorder_workarea','id',11,'Integer','','','primary',''),(3035,'printorder_workarea','id_printorder',11,'Integer','','','multiple',''),(3036,'printorder_workarea','id_workarea',11,'Integer','','','multiple',''),(3037,'printorder_workarea','completedate',19,'DateTime','','','',''),(3038,'printorder_workarea','initials',5,'Text','','','',''),(3039,'prlocal','id',22,'Numeric','','','primary unique',''),(3040,'prlocal','gencompanyid',22,'Numeric','','','',''),(3041,'prlocal','abrev',3,'Text','','','',''),(3042,'prlocal','name',30,'Text','','','',''),(3043,'prlocal','taxnum',20,'Text','','','',''),(3044,'prlocal','deductfed',11,'Integer','','','',''),(3045,'prlocal','feddeductmax',21,'Numeric','','','',''),(3046,'prlocal','exemptyr1',21,'Numeric','','','',''),(3047,'prlocal','exemptyr2',21,'Numeric','','','',''),(3048,'prlocal','exemptyr3',21,'Numeric','','','',''),(3049,'prlocal','exemptyr4',21,'Numeric','','','',''),(3050,'prlocal','glacctid',22,'Numeric','','','',''),(3051,'prlocal','vendorid',22,'Numeric','','','',''),(3052,'prlocal','maxexemptpercent',7,'Numeric','','','',''),(3053,'prlocal','maxexemptyear',21,'Numeric','','','',''),(3054,'prlocal','taxcreditexempt1',21,'Numeric','','','',''),(3055,'prlocal','taxcreditexempt2',21,'Numeric','','','',''),(3056,'prlocal','taxcreditexempt3',21,'Numeric','','','',''),(3057,'prlocal','taxcreditexempt4',21,'Numeric','','','',''),(3058,'prlocal','cancel',11,'Integer','','','',''),(3059,'prlocal','canceldate',19,'DateTime','','','',''),(3060,'prlocal','canceluserid',22,'Numeric','','','',''),(3061,'prlocal','entrydate',19,'DateTime','','','',''),(3062,'prlocal','entryuserid',22,'Numeric','','','',''),(3063,'prlocal','lastchangedate',19,'DateTime','','','',''),(3064,'prlocal','lastchangeuserid',22,'Numeric','','','',''),(3065,'prlocaldetail','id',22,'Numeric','','','primary unique',''),(3066,'prlocaldetail','prlocalid',22,'Numeric','','','',''),(3067,'prlocaldetail','maritalstatus',11,'Integer','','','',''),(3068,'prlocaldetail','deductiontable',11,'Integer','','','',''),(3069,'prlocaldetail','tax',21,'Numeric','','','',''),(3070,'prlocaldetail','percent',10,'Numeric','','','',''),(3071,'prlocaldetail','over',21,'Numeric','','','',''),(3072,'products_attributes','products_attributes_id',5,'Integer','','','primary',''),(3073,'products_attributes','products_id',5,'Integer','','','',''),(3074,'products_attributes','options_id',5,'Integer','','','',''),(3075,'products_attributes','options_values_id',5,'Integer','','','',''),(3076,'products_attributes','options_values_price',10,'Numeric','','','',''),(3077,'products_attributes','price_prefix',1,'Text','','','',''),(3078,'products_expected','products_expected_id',5,'Integer','','','primary',''),(3079,'products_expected','products_name',255,'Text','','','',''),(3080,'products_expected','date_expected',8,'Text','','','',''),(3081,'products_options','products_options_id',5,'Integer','','','primary',''),(3082,'products_options','products_options_name',32,'Text','','','',''),(3083,'products_options_values','products_options_values_id',5,'Integer','','','primary',''),(3084,'products_options_values','products_options_values_name',64,'Text','','','',''),(3085,'products_options_values_to_products_options','products_options_values_to_products_options_id',5,'Integer','','','primary',''),(3086,'products_options_values_to_products_options','products_options_id',5,'Integer','','','',''),(3087,'products_options_values_to_products_options','products_options_values_id',5,'Integer','','','',''),(3088,'prpaychange','id',22,'Numeric','','','primary unique',''),(3089,'prpaychange','employeeid',22,'Numeric','','','',''),(3090,'prpaychange','oldpay',21,'Numeric','','','',''),(3091,'prpaychange','newpay',21,'Numeric','','','',''),(3092,'prpaychange','paystartdate',10,'Date','','','',''),(3093,'prpaychange','lastchangedate',19,'DateTime','','','',''),(3094,'prpaychange','lastchangeuserid',22,'Numeric','','','',''),(3095,'prpaytype','id',22,'Numeric','','','primary unique',''),(3096,'prpaytype','name',4,'Text','','','',''),(3097,'prpaytype','description',40,'Text','','','',''),(3098,'prpaytype','multiplier',7,'Numeric','','','',''),(3099,'prpaytype','vacation',11,'Integer','','','',''),(3100,'prpaytype','sick',11,'Integer','','','',''),(3101,'prpaytype','gencompanyid',22,'Numeric','','','',''),(3102,'prpension','id',22,'Numeric','','','primary unique',''),(3103,'prpension','gencompanyid',22,'Numeric','','','',''),(3104,'prpension','name',30,'Text','','','multiple',''),(3105,'prpension','w2plantype',11,'Integer','','','',''),(3106,'prpension','w2plansubtype',1,'Text','','','',''),(3107,'prpension','employercontribhow',11,'Integer','','','',''),(3108,'prpension','employercontribute',10,'Numeric','','','',''),(3109,'prpension','employermaxmatchpercent',10,'Numeric','','','',''),(3110,'prpension','mustbeinplan',11,'Integer','','','',''),(3111,'prpension','calcbasis',11,'Integer','','','',''),(3112,'prpension','prdedgroupid',22,'Numeric','','','',''),(3113,'prpension','paytype',11,'Integer','','','',''),(3114,'prpension','payableglacctid',22,'Numeric','','','',''),(3115,'prpension','expenseglacctid',22,'Numeric','','','',''),(3116,'prpension','federalincometax',11,'Integer','','','',''),(3117,'prpension','stateincometax',11,'Integer','','','',''),(3118,'prpension','localincometax',11,'Integer','','','',''),(3119,'prpension','cityincometax',11,'Integer','','','',''),(3120,'prpension','employeefica',11,'Integer','','','',''),(3121,'prpension','companyfica',11,'Integer','','','',''),(3122,'prpension','fui',11,'Integer','','','',''),(3123,'prpension','sui',11,'Integer','','','',''),(3124,'prpension','workmanscomp',11,'Integer','','','',''),(3125,'prpension','vendorid',22,'Numeric','','','',''),(3126,'prpension','cancel',11,'Integer','','','',''),(3127,'prpension','canceldate',19,'DateTime','','','',''),(3128,'prpension','canceluserid',22,'Numeric','','','',''),(3129,'prpension','entrydate',19,'DateTime','','','',''),(3130,'prpension','entryuserid',22,'Numeric','','','',''),(3131,'prpension','lastchangedate',19,'DateTime','','','',''),(3132,'prpension','lastchangeuserid',22,'Numeric','','','',''),(3133,'prpension','employeronly_percent',14,'Numeric','','','',''),(3134,'prpension','employermaxmatchpercent_uptopercent',14,'Numeric','','','',''),(3135,'prpension','employermaxmatchpercent2',14,'Numeric','','','',''),(3136,'prpension','employermaxmatchpercent2_uptopercent',14,'Numeric','','','',''),(3137,'prperiod','id',22,'Numeric','','','primary unique',''),(3138,'prperiod','numperyear',11,'Integer','','','',''),(3139,'prperiod','name',15,'Text','','','',''),(3140,'prstate','id',22,'Numeric','','','primary unique',''),(3141,'prstate','gencompanyid',22,'Numeric','','','',''),(3142,'prstate','genstateid',22,'Numeric','','','multiple',''),(3143,'prstate','taxnum',20,'Text','','','',''),(3144,'prstate','suipercent',10,'Numeric','','','',''),(3145,'prstate','suimax',12,'Numeric','','','',''),(3146,'prstate','deductfed',11,'Integer','','','',''),(3147,'prstate','feddeductmax',12,'Numeric','','','',''),(3148,'prstate','exemptyr1',21,'Numeric','','','',''),(3149,'prstate','exemptyr2',21,'Numeric','','','',''),(3150,'prstate','exemptyr3',21,'Numeric','','','',''),(3151,'prstate','exemptyr4',21,'Numeric','','','',''),(3152,'prstate','glacctid',22,'Numeric','','','',''),(3153,'prstate','vendorid',22,'Numeric','','','',''),(3154,'prstate','maxexemptpercent',10,'Numeric','','','',''),(3155,'prstate','maxexemptyear',12,'Numeric','','','',''),(3156,'prstate','taxcreditexempt1',12,'Numeric','','','',''),(3157,'prstate','taxcreditexempt2',12,'Numeric','','','',''),(3158,'prstate','taxcreditexempt3',12,'Numeric','','','',''),(3159,'prstate','taxcreditexempt4',12,'Numeric','','','',''),(3160,'prstate','cancel',11,'Integer','','','',''),(3161,'prstate','canceldate',19,'DateTime','','','',''),(3162,'prstate','canceluserid',22,'Numeric','','','',''),(3163,'prstate','entrydate',19,'DateTime','','','',''),(3164,'prstate','entryuserid',22,'Numeric','','','',''),(3165,'prstate','lastchangedate',19,'DateTime','','','',''),(3166,'prstate','lastchangeuserid',22,'Numeric','','','',''),(3167,'prstate','mexemptyr1',21,'Numeric','','','',''),(3168,'prstate','mexemptyr2',21,'Numeric','','','',''),(3169,'prstate','mexemptyr3',21,'Numeric','','','',''),(3170,'prstate','mexemptyr4',21,'Numeric','','','',''),(3171,'prstate','jexemptyr1',21,'Numeric','','','',''),(3172,'prstate','jexemptyr2',21,'Numeric','','','',''),(3173,'prstate','jexemptyr3',21,'Numeric','','','',''),(3174,'prstate','jexemptyr4',21,'Numeric','','','',''),(3175,'prstate','hexemptyr1',21,'Numeric','','','',''),(3176,'prstate','hexemptyr2',21,'Numeric','','','',''),(3177,'prstate','hexemptyr3',21,'Numeric','','','',''),(3178,'prstate','hexemptyr4',21,'Numeric','','','',''),(3179,'prstatedetail','id',22,'Numeric','','','primary unique',''),(3180,'prstatedetail','prstateid',22,'Numeric','','','',''),(3181,'prstatedetail','maritalstatus',11,'Integer','','','',''),(3182,'prstatedetail','deductiontable',11,'Integer','','','',''),(3183,'prstatedetail','tax',12,'Numeric','','','',''),(3184,'prstatedetail','percent',10,'Numeric','','','',''),(3185,'prstatedetail','over',12,'Numeric','','','',''),(3186,'prt_orientation','id',11,'Integer','','','primary unique',''),(3187,'prt_orientation','description',20,'Text','','','',''),(3188,'prtlocation','id',22,'Numeric','','','primary unique',''),(3189,'prtlocation','companyname',35,'Text','','','',''),(3190,'prtlocation','address1',100,'Text','','','',''),(3191,'prtlocation','address2',100,'Text','','','',''),(3192,'prtlocation','mailstop',20,'Text','','','',''),(3193,'prtlocation','city',50,'Text','','','',''),(3194,'prtlocation','state',20,'Text','','','',''),(3195,'prtlocation','zip',15,'Text','','','',''),(3196,'prtlocation','country',20,'Text','','','',''),(3197,'prtlocation','phone1',20,'Text','','','',''),(3198,'prtlocation','phone1comment',20,'Text','','','',''),(3199,'prtlocation','phone2',20,'Text','','','',''),(3200,'prtlocation','phone2comment',20,'Text','','','',''),(3201,'prtlocation','phone3',20,'Text','','','',''),(3202,'prtlocation','phone3comment',20,'Text','','','',''),(3203,'prtlocation','phone4',20,'Text','','','',''),(3204,'prtlocation','phone4comment',20,'Text','','','',''),(3205,'prtlocation','email1',50,'Text','','','',''),(3206,'prtlocation','email1comment',20,'Text','','','',''),(3207,'prtlocation','email2',50,'Text','','','',''),(3208,'prtlocation','email2comment',50,'Text','','','',''),(3209,'prtlocation','website',100,'Text','','','',''),(3210,'prtlocation','federalid',20,'Text','','','',''),(3211,'prtlocation','cancel',2,'Integer','','','',''),(3212,'prtlocation','canceldate',19,'DateTime','','','',''),(3213,'prtlocation','canceluserid',11,'Integer','','','',''),(3214,'prtlocation','entrydate',19,'DateTime','','','',''),(3215,'prtlocation','entryuserid',11,'Integer','','','',''),(3216,'prtlocation','lastchangedate',19,'DateTime','','','',''),(3217,'prtlocation','lastchangeuserid',11,'Integer','','','',''),(3218,'prtlocation','gencompanyid',11,'Integer','','','multiple',''),(3219,'prvacation','id',22,'Numeric','','','primary unique',''),(3220,'prvacation','yrsbeforeaccrue',7,'Numeric','','','',''),(3221,'prvacation','vacdaysperyear',7,'Numeric','','','',''),(3222,'prvacation','maxaccrue',7,'Numeric','','','',''),(3223,'prvacation','gencompanyid',22,'Numeric','','','',''),(3224,'prvacation','cancel',11,'Integer','','','',''),(3225,'prvacation','canceldate',19,'DateTime','','','',''),(3226,'prvacation','canceluserid',22,'Numeric','','','',''),(3227,'prvacation','entrydate',19,'DateTime','','','',''),(3228,'prvacation','entryuserid',22,'Numeric','','','',''),(3229,'prvacation','lastchangedate',19,'DateTime','','','',''),(3230,'prvacation','lastchangeuserid',22,'Numeric','','','',''),(3231,'purchasetype','id_purchasetype',11,'Integer','','','primary unique',''),(3232,'purchasetype','id_company',11,'Integer','','','',''),(3233,'purchasetype','name',20,'Text','','','',''),(3234,'purchasetype','createdate',10,'Date','','','',''),(3235,'purchasetype','id_user_create',11,'Integer','','','',''),(3236,'purchasetype','lastrevisedate',19,'DateTime','','','',''),(3237,'purchasetype','id_user_revise',11,'Integer','','','',''),(3238,'purchasetype','canceldate',10,'Date','','','',''),(3239,'purchasetype','cancel',11,'Integer','','','',''),(3240,'purchasetype','include_in_internal_billing',2,'Integer','','','',''),(3241,'question','id_question',11,'Integer','','','primary unique',''),(3242,'question','id_family',11,'Integer','','','',''),(3243,'question','id_responsetype',11,'Integer','','','',''),(3244,'question','question',100,'Text','','','',''),(3245,'question','unit_of_measure',10,'Text','','','',''),(3246,'question','displayorder',3,'Integer','','','',''),(3247,'question','internalonly',1,'Integer','','','',''),(3248,'question','createdate',19,'DateTime','','','',''),(3249,'question','id_user_create',11,'Integer','','','',''),(3250,'question','lastrevisedate',19,'DateTime','','','',''),(3251,'question','id_user_revise',11,'Integer','','','',''),(3252,'question','canceldate',19,'DateTime','','','',''),(3253,'question','cancel',11,'Integer','','','',''),(3254,'question_calc','id_question_calc',11,'Integer','','','primary unique',''),(3255,'question_calc','id_question',11,'Integer','','','',''),(3256,'question_calc','id_question_detail',11,'Integer','','','',''),(3257,'question_calc','id_calcqty',11,'Integer','','','',''),(3258,'question_calc','oneperjob',2,'Integer','','','',''),(3259,'question_calc','id_item',11,'Integer','','','',''),(3260,'question_calc','materialcost',12,'Numeric','','','',''),(3261,'question_calc','createdate',19,'DateTime','','','',''),(3262,'question_calc','id_user_create',11,'Integer','','','',''),(3263,'question_calc','lastrevisedate',19,'DateTime','','','',''),(3264,'question_calc','id_user_revise',11,'Integer','','','',''),(3265,'question_calc','canceldate',19,'DateTime','','','',''),(3266,'question_calc','materialmarkup',12,'Numeric','','','',''),(3267,'question_calc','cancel',11,'Integer','','','',''),(3268,'question_detail','id_question_detail',11,'Integer','','','primary unique',''),(3269,'question_detail','id_question',11,'Integer','','','',''),(3270,'question_detail','id_family',11,'Integer','','','',''),(3271,'question_detail','selection',100,'Text','','','',''),(3272,'question_detail','displayorder',3,'Integer','','','',''),(3273,'question_detail','createdate',19,'DateTime','','','',''),(3274,'question_detail','id_user_create',11,'Integer','','','',''),(3275,'question_detail','lastrevisedate',19,'DateTime','','','',''),(3276,'question_detail','id_user_revise',11,'Integer','','','',''),(3277,'question_detail','canceldate',19,'DateTime','','','',''),(3278,'question_detail','cancel',11,'Integer','','','',''),(3279,'quotecomment','id',22,'Numeric','','','primary',''),(3280,'quotecomment','comments',100,'Text','','','',''),(3281,'quotecomment','cancel',11,'Integer','','','',''),(3282,'quotecomment','canceldate',19,'DateTime','','','',''),(3283,'quotecomment','canceluserid',22,'Numeric','','','',''),(3284,'quotecomment','entrydate',19,'DateTime','','','',''),(3285,'quotecomment','entryuserid',22,'Numeric','','','',''),(3286,'quotecomment','lastchangedate',19,'DateTime','','','',''),(3287,'quotecomment','lastchangeuserid',22,'Numeric','','','',''),(3288,'quoteemail','id',11,'Integer','','','primary',''),(3289,'quoteemail','lead_time',11,'Integer','','','',''),(3290,'quoteemail','offer',65535,'X','','','',''),(3291,'quoteemail','point1',65535,'X','','','',''),(3292,'quoteemail','point2',65535,'X','','','',''),(3293,'quoteemail','point3',65535,'X','','','',''),(3294,'quoteemail','point4',65535,'X','','','',''),(3295,'quoteemail','point5',65535,'X','','','',''),(3296,'quoteemail','point6',65535,'X','','','',''),(3297,'quoteemail','from_person',65535,'X','','','',''),(3298,'quoteemail','subject',65535,'X','','','',''),(3299,'quoteemail','message',100,'Text','','','',''),(3300,'responsetype','id_responsetype',11,'Integer','','','primary',''),(3301,'responsetype','name',50,'Text','','','',''),(3302,'responsetype','createdate',19,'DateTime','','','',''),(3303,'responsetype','id_user_create',11,'Integer','','','',''),(3304,'responsetype','lastrevisedate',19,'DateTime','','','',''),(3305,'responsetype','id_user_revise',11,'Integer','','','',''),(3306,'responsetype','canceldate',19,'DateTime','','','',''),(3307,'responsetype','cancel',11,'Integer','','','',''),(3308,'reviews','reviews_id',5,'Integer','','','primary',''),(3309,'reviews','reviews_text',65535,'X','','','',''),(3310,'reviews','reviews_rating',1,'Integer','','','',''),(3311,'reviews_extra','reviews_id',5,'Integer','','','',''),(3312,'reviews_extra','products_id',5,'Integer','','','',''),(3313,'reviews_extra','customers_id',5,'Integer','','','',''),(3314,'reviews_extra','date_added',8,'Text','','','',''),(3315,'reviews_extra','reviews_read',5,'Integer','','','',''),(3316,'reviews_extra','reviews_active',2,'Integer','','','',''),(3317,'rma_purchasing','id',11,'Integer','','','primary',''),(3318,'rma_purchasing','rma',30,'Text','','','',''),(3319,'rma_purchasing','ponumber',20,'Text','','','',''),(3320,'rma_purchasing','ordernumber',20,'Text','','','',''),(3321,'rma_purchasing','invoicenumber',20,'Text','','','',''),(3322,'rma_purchasing','invoicedate',19,'DateTime','','','',''),(3323,'rma_purchasing','vendorid',11,'Integer','','','',''),(3324,'rma_purchasing','itemcode',20,'Text','','','',''),(3325,'rma_purchasing','vendorpartnumber',30,'Text','','','',''),(3326,'rma_purchasing','serialnumber',100,'Text','','','',''),(3327,'rma_purchasing','quantity',12,'Numeric','','','',''),(3328,'rma_purchasing','problem',255,'Text','','','',''),(3329,'rma_purchasing','contactname',100,'Text','','','',''),(3330,'rma_purchasing','sentdate',19,'DateTime','','','',''),(3331,'rma_purchasing','expectedreturndate',19,'DateTime','','','',''),(3332,'rma_purchasing','trackingnumber',50,'Text','','','',''),(3333,'rma_purchasing','actionid',11,'Integer','','','',''),(3334,'rma_purchasing','restockingfee',12,'Numeric','','','',''),(3335,'rma_purchasing','completed',2,'Integer','','','',''),(3336,'rma_purchasing','completeddate',100,'Text','','','',''),(3337,'rma_purchasing','address1',100,'Text','','','',''),(3338,'rma_purchasing','address2',100,'Text','','','',''),(3339,'rma_purchasing','city',50,'Text','','','',''),(3340,'rma_purchasing','state',20,'Text','','','',''),(3341,'rma_purchasing','zip',15,'Text','','','',''),(3342,'rma_purchasing','country',20,'Text','','','',''),(3343,'rma_purchasing','shiptoaddress',255,'Text','','','',''),(3344,'rma_purchasing','entrydate',19,'DateTime','','','',''),(3345,'rma_purchasing','companyid',11,'Integer','','','',''),(3346,'rma_purchasing','notes',65535,'X','','','',''),(3347,'rma_purchasing_action','id',11,'Integer','','','primary',''),(3348,'rma_purchasing_action','action',100,'Text','','','',''),(3349,'sales_categories','id',11,'Integer','','','primary',''),(3350,'sales_categories','description',50,'Text','','','',''),(3351,'sales_categories','entrydate',19,'DateTime','','','',''),(3352,'sales_categories','entryuserid',11,'Integer','','','',''),(3353,'sales_categories','cancel',2,'Integer','','','',''),(3354,'sales_categories','canceldate',19,'DateTime','','','',''),(3355,'sales_categories','canceluserid',11,'Integer','','','',''),(3356,'sales_categories','lastupdatedate',19,'DateTime','','','',''),(3357,'sales_categories','gencompanyid',11,'Integer','','','',''),(3358,'salescategory','id',11,'Integer','','','primary',''),(3359,'salescategory','type',100,'Text','','','',''),(3360,'salescategory','description',100,'Text','','','',''),(3361,'salescategory','gencompanyid',22,'Numeric','','','',''),(3362,'salesman','id',22,'Numeric','','','primary unique',''),(3363,'salesman','payrollid',22,'Numeric','','','multiple',''),(3364,'salesman','commissionrate',8,'Numeric','','','',''),(3365,'salesman','commissionbase',11,'Integer','','','',''),(3366,'salesman','servicerep',11,'Integer','','','multiple',''),(3367,'salesman','salesman',11,'Integer','','','multiple',''),(3368,'salesman','gencompanyid',22,'Numeric','','','multiple',''),(3369,'salesman','cancel',11,'Integer','','','',''),(3370,'salesman','canceldate',19,'DateTime','','','',''),(3371,'salesman','canceluserid',22,'Numeric','','','',''),(3372,'salesman','entrydate',19,'DateTime','','','',''),(3373,'salesman','entryuserid',22,'Numeric','','','',''),(3374,'salesman','lastchangedate',19,'DateTime','','','',''),(3375,'salesman','lastchangeuserid',22,'Numeric','','','',''),(3376,'salesman','name',50,'Text','','','',''),(3377,'salesman','address1',100,'Text','','','',''),(3378,'salesman','address2',100,'Text','','','',''),(3379,'salesman','mailstop',20,'Text','','','',''),(3380,'salesman','city',50,'Text','','','',''),(3381,'salesman','state',20,'Text','','','',''),(3382,'salesman','zip',15,'Text','','','',''),(3383,'salesman','country',20,'Text','','','',''),(3384,'salesman','phone1',20,'Text','','','',''),(3385,'salesman','phone1comment',20,'Text','','','',''),(3386,'salesman','phone2',20,'Text','','','',''),(3387,'salesman','phone2comment',20,'Text','','','',''),(3388,'salesman','phone3',20,'Text','','','',''),(3389,'salesman','phone3comment',20,'Text','','','',''),(3390,'salesman','phone4',20,'Text','','','',''),(3391,'salesman','phone4comment',20,'Text','','','',''),(3392,'salesman','email1',50,'Text','','','',''),(3393,'salesman','email2',50,'Text','','','',''),(3394,'salesman','email1comment',20,'Text','','','',''),(3395,'salesman','email2comment',20,'Text','','','',''),(3396,'salesman','federalid',20,'Text','','','',''),(3397,'salesprocess','id',11,'Integer','','','primary',''),(3398,'salesprocess','salesman_id',11,'Integer','','','',''),(3399,'salesprocess','status',11,'Integer','','','',''),(3400,'salesprocess','customer_id',11,'Integer','','','',''),(3401,'salesprocess','contact',100,'Text','','','',''),(3402,'salesprocess','position',100,'Text','','','',''),(3403,'salesprocess','phone',10,'Integer','','','',''),(3404,'salesprocess','email',100,'Text','','','',''),(3405,'salesprocess','salescategory_id',11,'Integer','','','',''),(3406,'salesprocess','quality',11,'Integer','','','',''),(3407,'salesprocess','description',200,'Text','','','',''),(3408,'salesprocess','notes',200,'Text','','','',''),(3409,'salesprocess','estimated_sale',11,'Numeric','','','',''),(3410,'salesprocess','actual_sale',11,'Numeric','','','',''),(3411,'salestax','id',22,'Numeric','','','primary',''),(3412,'salestax','taxname',30,'Text','','','',''),(3413,'salestax','taxrate',9,'Numeric','','','',''),(3414,'salestax','taxbase',11,'Integer','','','',''),(3415,'salestax','glacctid',22,'Numeric','','','',''),(3416,'salestax','cancel',11,'Integer','','','',''),(3417,'salestax','canceldate',19,'DateTime','','','',''),(3418,'salestax','canceluserid',22,'Numeric','','','',''),(3419,'salestax','entrydate',19,'DateTime','','','',''),(3420,'salestax','entryuserid',22,'Numeric','','','',''),(3421,'salestax','lastchangedate',19,'DateTime','','','',''),(3422,'salestax','lastchangeuserid',22,'Numeric','','','',''),(3423,'salestax','taxstate',5,'Text','','','',''),(3424,'salestracker','id',11,'Integer','','','primary',''),(3425,'salestracker','sales_process_id',11,'Integer','','','',''),(3426,'salestracker','action_salesman_id',11,'Integer','','','',''),(3427,'salestracker','action_id',11,'Integer','','','',''),(3428,'salestracker','action_date',19,'DateTime','','','',''),(3429,'salestracker','notes',200,'Text','','','',''),(3430,'salestracker','next_action_salesman_id',11,'Integer','','','',''),(3431,'salestracker','next_action_id',11,'Integer','','','',''),(3432,'salestracker','next_action_date',19,'DateTime','','','',''),(3433,'search_cat','id',11,'Integer','','','primary',''),(3434,'search_cat','name',100,'Text','','','',''),(3435,'search_cat','level',11,'Integer','','','',''),(3436,'search_cat','cancel',11,'Integer','','','',''),(3437,'search_cat','categories_image',64,'Text','','','',''),(3438,'search_cat','companyid',11,'Integer','','','',''),(3439,'search_cat','parentid',11,'Integer','','','multiple',''),(3440,'search_tree','id',11,'Integer','','','primary',''),(3441,'search_tree','itemid',11,'Integer','','','',''),(3442,'search_tree','companyid',11,'Integer','','','',''),(3443,'search_tree','searchcatid',11,'Integer','','','',''),(3444,'serversetup','changedate',100,'Text','','','',''),(3445,'serversetup','definename',100,'Text','','','',''),(3446,'serversetup','id',11,'Integer','','','primary',''),(3447,'serversetup','definevalue',255,'Text','','','',''),(3448,'serversetup','description',100,'Text','','','',''),(3449,'service','id',11,'Integer','','','primary',''),(3450,'service','name',50,'Text','','','',''),(3451,'service','categoryid',11,'Integer','','','multiple',''),(3452,'service','cancel',2,'Integer','','','multiple',''),(3453,'service','canceldate',19,'DateTime','','','',''),(3454,'service','canceluserid',11,'Integer','','','',''),(3455,'service_workclass','id',11,'Integer','','','primary',''),(3456,'service_workclass','name',50,'Text','','','',''),(3457,'service_workclass','gencompanyid',11,'Integer','','','multiple',''),(3458,'service_workclass','entrydate',10,'Date','','','',''),(3459,'service_workclass','entryuserid',11,'Integer','','','',''),(3460,'service_workclass','cancel',2,'Integer','','','multiple',''),(3461,'service_workclass','canceldate',19,'DateTime','','','',''),(3462,'service_workclass','canceluserid',11,'Integer','','','',''),(3463,'service_workclass','lastchangedate',19,'DateTime','','','',''),(3464,'service_workclass','lastchangeuserid',11,'Integer','','','',''),(3465,'service_workclass_rates','id',11,'Integer','','','primary',''),(3466,'service_workclass_rates','service_worktypeid',11,'Integer','','','multiple',''),(3467,'service_workclass_rates','service_workclassid',11,'Integer','','','multiple',''),(3468,'service_workclass_rates','rate',12,'Numeric','','','',''),(3469,'service_workclass_rates','gencompanyid',11,'Integer','','','multiple',''),(3470,'service_workclass_rates','entrydate',10,'Date','','','',''),(3471,'service_workclass_rates','entryuserid',11,'Integer','','','',''),(3472,'service_workclass_rates','cancel',2,'Integer','','','multiple',''),(3473,'service_workclass_rates','canceldate',19,'DateTime','','','',''),(3474,'service_workclass_rates','canceluserid',11,'Integer','','','',''),(3475,'service_workclass_rates','lastchangedate',19,'DateTime','','','',''),(3476,'service_workclass_rates','lastchangeuserid',11,'Integer','','','',''),(3477,'service_worktype','id',11,'Integer','','','primary',''),(3478,'service_worktype','name',50,'Text','','','',''),(3479,'service_worktype','gencompanyid',11,'Integer','','','multiple',''),(3480,'service_worktype','entrydate',10,'Date','','','',''),(3481,'service_worktype','entryuserid',11,'Integer','','','',''),(3482,'service_worktype','cancel',2,'Integer','','','multiple',''),(3483,'service_worktype','canceldate',19,'DateTime','','','',''),(3484,'service_worktype','canceluserid',11,'Integer','','','',''),(3485,'service_worktype','lastchangedate',19,'DateTime','','','',''),(3486,'service_worktype','lastchangeuserid',11,'Integer','','','',''),(3487,'setup','billing',11,'Integer','','','',''),(3488,'setup','inventory',11,'Integer','','','',''),(3489,'setup','payroll',11,'Integer','','','',''),(3490,'setup','payable',11,'Integer','','','',''),(3491,'setup','gencompanyid',11,'Integer','','','',''),(3492,'setup','gl',11,'Integer','','','',''),(3493,'setup','admin',11,'Integer','','','',''),(3494,'setup','id',11,'Integer','','','primary',''),(3495,'shipto','id',22,'Numeric','','','primary unique',''),(3496,'shipto','defaultshipvia',22,'Numeric','','','',''),(3497,'shipto','cancel',11,'Integer','','','',''),(3498,'shipto','canceldate',19,'DateTime','','','',''),(3499,'shipto','canceluserid',22,'Numeric','','','',''),(3500,'shipto','entrydate',19,'DateTime','','','',''),(3501,'shipto','entryuserid',22,'Numeric','','','',''),(3502,'shipto','lastchangedate',19,'DateTime','','','',''),(3503,'shipto','lastchangeuserid',22,'Numeric','','','',''),(3504,'shipto','address1',100,'Text','','','',''),(3505,'shipto','address2',100,'Text','','','',''),(3506,'shipto','mailstop',20,'Text','','','',''),(3507,'shipto','city',50,'Text','','','',''),(3508,'shipto','state',20,'Text','','','',''),(3509,'shipto','zip',15,'Text','','','',''),(3510,'shipto','country',20,'Text','','','',''),(3511,'shipto','phone1',20,'Text','','','',''),(3512,'shipto','phone1comment',20,'Text','','','',''),(3513,'shipto','phone2',20,'Text','','','',''),(3514,'shipto','phone2comment',20,'Text','','','',''),(3515,'shipto','phone3',20,'Text','','','',''),(3516,'shipto','phone3comment',20,'Text','','','',''),(3517,'shipto','phone4',20,'Text','','','',''),(3518,'shipto','phone4comment',20,'Text','','','',''),(3519,'shipto','email1',50,'Text','','','',''),(3520,'shipto','email2',50,'Text','','','',''),(3521,'shipto','email1comment',20,'Text','','','',''),(3522,'shipto','email2comment',20,'Text','','','',''),(3523,'shipto','customerid',11,'Integer','','','multiple',''),(3524,'shipto','shipname',50,'Text','','','',''),(3525,'shipto','entry_firstname',32,'Text','','','',''),(3526,'shipto','entry_lastname',32,'Text','','','',''),(3527,'shipto','entry_country_id',5,'Integer','','','',''),(3528,'shipto','entry_zone_id',5,'Integer','','','',''),(3529,'shipto','dummy_record',1,'Integer','','','',''),(3530,'shipto','taxexemptid',11,'Integer','','','',''),(3531,'shipto','salestaxnum',30,'Text','','','',''),(3532,'shiptosalestax','id',11,'Integer','','','primary',''),(3533,'shiptosalestax','shiptoid',11,'Integer','','','multiple',''),(3534,'shiptosalestax','salestaxid',11,'Integer','','','multiple',''),(3535,'specials','specials_id',5,'Integer','','','primary',''),(3536,'specials','products_id',5,'Integer','','','',''),(3537,'specials','specials_new_products_price',10,'Numeric','','','',''),(3538,'specials','specials_date_added',8,'Text','','','',''),(3539,'specials','pricelevel_id',5,'Integer','','','',''),(3540,'statelist','initials',5,'Text','','','primary unique',''),(3541,'statelist','name',30,'Text','','','multiple unique',''),(3542,'statelist','id',11,'Integer','','','',''),(3543,'std_accounts','id',11,'Integer','','','primary',''),(3544,'std_accounts','industry_code',20,'Text','','','multiple',''),(3545,'std_accounts','industry_name',255,'Text','','','',''),(3546,'std_accounts','account_name',20,'Text','','','',''),(3547,'std_accounts','account_description',255,'Text','','','',''),(3548,'std_accounts','account_type',5,'Integer','','','',''),(3549,'std_accounts','cancel',2,'Integer','','','',''),(3550,'stock_purpose','id_stockpurpose',11,'Integer','','','primary',''),(3551,'stock_purpose','purpose',30,'Text','','','',''),(3552,'stock_purpose','cancel',11,'Integer','','','',''),(3553,'stock_purpose','cancel_date',19,'DateTime','','','',''),(3554,'stock_purpose','cancel_userid',11,'Integer','','','',''),(3555,'stock_purpose','createdate',19,'DateTime','','','',''),(3556,'stock_purpose','create_userid',11,'Integer','','','',''),(3557,'stock_purpose','id_user_create',11,'Integer','','','',''),(3558,'stock_purpose','lastrevisedate',19,'DateTime','','','',''),(3559,'stock_purpose','id_user_revise',11,'Integer','','','',''),(3560,'stock_purpose','gencompanyid',11,'Integer','','','',''),(3561,'stock_purpose','sortorder',11,'Integer','','','',''),(3562,'tax_class','tax_class_id',5,'Integer','','','primary',''),(3563,'tax_class','tax_class_title',32,'Text','','','',''),(3564,'tax_class','tax_class_description',255,'Text','','','',''),(3565,'tax_class','last_modified',19,'DateTime','','','',''),(3566,'tax_class','date_added',19,'DateTime','','','',''),(3567,'tax_rates','tax_rates_id',5,'Integer','','','primary',''),(3568,'tax_rates','tax_zone_id',5,'Integer','','','',''),(3569,'tax_rates','tax_class_id',5,'Integer','','','',''),(3570,'tax_rates','tax_rate',9,'Numeric','','','',''),(3571,'tax_rates','tax_description',255,'Text','','','',''),(3572,'tax_rates','last_modified',19,'DateTime','','','',''),(3573,'tax_rates','date_added',19,'DateTime','','','',''),(3574,'taxexempt','id',22,'Numeric','','','primary',''),(3575,'taxexempt','exemptname',30,'Text','','','',''),(3576,'taxexempt','cancel',11,'Integer','','','',''),(3577,'taxexempt','canceldate',19,'DateTime','','','',''),(3578,'taxexempt','canceluserid',22,'Numeric','','','',''),(3579,'taxexempt','entrydate',19,'DateTime','','','',''),(3580,'taxexempt','entryuserid',22,'Numeric','','','',''),(3581,'taxexempt','lastchangedate',19,'DateTime','','','',''),(3582,'taxexempt','lastchangeuserid',22,'Numeric','','','',''),(3583,'unitname','id',22,'Numeric','','','primary',''),(3584,'unitname','unitname',50,'Text','','','',''),(3585,'unitname','cancel',11,'Integer','','','',''),(3586,'unitname','canceldate',19,'DateTime','','','',''),(3587,'unitname','canceluserid',22,'Numeric','','','',''),(3588,'unitname','entrydate',19,'DateTime','','','',''),(3589,'unitname','entryuserid',22,'Numeric','','','',''),(3590,'unitname','lastchangedate',19,'DateTime','','','',''),(3591,'unitname','lastchangeuserid',22,'Numeric','','','',''),(3592,'vendor','name',30,'Text','','','',''),(3593,'vendor','id',22,'Numeric','','','primary unique',''),(3594,'vendor','orderfromname',30,'Text','','','',''),(3595,'vendor','paytermsid',22,'Numeric','','','',''),(3596,'vendor','paynone',11,'Integer','','','',''),(3597,'vendor','defaultglacctid',22,'Numeric','','','',''),(3598,'vendor','defaultbilldescription',50,'Text','','','',''),(3599,'vendor','customeraccount',20,'Text','','','',''),(3600,'vendor','gencompanyid',22,'Numeric','','','',''),(3601,'vendor','cancel',11,'Integer','','','',''),(3602,'vendor','canceldate',19,'DateTime','','','',''),(3603,'vendor','canceluserid',22,'Numeric','','','',''),(3604,'vendor','entrydate',19,'DateTime','','','',''),(3605,'vendor','entryuserid',22,'Numeric','','','',''),(3606,'vendor','lastchangedate',19,'DateTime','','','',''),(3607,'vendor','lastchangeuserid',22,'Numeric','','','',''),(3608,'vendor','companyname',100,'Text','','','',''),(3609,'vendor','address1',100,'Text','','','',''),(3610,'vendor','address2',100,'Text','','','',''),(3611,'vendor','mailstop',20,'Text','','','',''),(3612,'vendor','city',50,'Text','','','',''),(3613,'vendor','state',20,'Text','','','',''),(3614,'vendor','zip',15,'Text','','','',''),(3615,'vendor','country',20,'Text','','','',''),(3616,'vendor','phone1',20,'Text','','','',''),(3617,'vendor','phone1comment',20,'Text','','','',''),(3618,'vendor','phone2',20,'Text','','','',''),(3619,'vendor','phone2comment',20,'Text','','','',''),(3620,'vendor','phone3',20,'Text','','','',''),(3621,'vendor','phone3comment',20,'Text','','','',''),(3622,'vendor','phone4',20,'Text','','','',''),(3623,'vendor','phone4comment',20,'Text','','','',''),(3624,'vendor','email1',50,'Text','','','',''),(3625,'vendor','email1comment',20,'Text','','','',''),(3626,'vendor','email2',50,'Text','','','',''),(3627,'vendor','email2comment',20,'Text','','','',''),(3628,'vendor','website',100,'Text','','','',''),(3629,'vendor','federalid',20,'Text','','','',''),(3630,'vendor','orderfrom_companyname',100,'Text','','','',''),(3631,'vendor','orderfrom_address1',100,'Text','','','',''),(3632,'vendor','orderfrom_address2',100,'Text','','','',''),(3633,'vendor','orderfrom_mailstop',20,'Text','','','',''),(3634,'vendor','orderfrom_city',50,'Text','','','',''),(3635,'vendor','orderfrom_state',20,'Text','','','',''),(3636,'vendor','orderfrom_zip',15,'Text','','','',''),(3637,'vendor','orderfrom_country',20,'Text','','','',''),(3638,'vendor','image',64,'Text','','','',''),(3639,'vendor','scart',11,'Integer','','','',''),(3640,'vendor','workclassid',11,'Integer','','','multiple',''),(3641,'vendor','default_cost_per_hour',14,'Numeric','','','',''),(3642,'vendor','vendor_code',50,'Text','','','',''),(3643,'vendor','vendor_lead_time',11,'Integer','','','',''),(3644,'vendor','carrierserviceid',11,'Integer','','','',''),(3645,'vendor','noreturns',2,'Integer','','','',''),(3646,'vendor','percent_commission',10,'Numeric','','','',''),(3647,'vendor','flat_commission',14,'Numeric','','','',''),(3648,'vendor','parent_vendorid',11,'Integer','','','multiple',''),(3649,'workarea','id_workarea',11,'Integer','','','primary',''),(3650,'workarea','name',50,'Text','','','',''),(3651,'workarea','createdate',19,'DateTime','','','',''),(3652,'workarea','id_user_create',11,'Integer','','','',''),(3653,'workarea','lastrevisedate',19,'DateTime','','','',''),(3654,'workarea','id_user_revise',11,'Integer','','','',''),(3655,'workarea','canceldate',19,'DateTime','','','',''),(3656,'workarea','cancel',11,'Integer','','','',''),(3657,'workarea','sortorder',11,'Integer','','','',''),(3658,'workarea','print',11,'Integer','','','',''),(3659,'workarea','gencompanyid',11,'Integer','','','',''),(3660,'workarea','ask_instructions',2,'Integer','','','',''),(3661,'worksubtype','id_worksubtype',11,'Integer','','','primary unique',''),(3662,'worksubtype','id_worktype',11,'Integer','','','',''),(3663,'worksubtype','name',100,'Text','','','',''),(3664,'worksubtype','purpose',255,'Text','','','',''),(3665,'worksubtype','num_parts',3,'Integer','','','',''),(3666,'worksubtype','vended',3,'Integer','','','',''),(3667,'worksubtype','createdate',19,'DateTime','','','',''),(3668,'worksubtype','id_user_create',11,'Integer','','','',''),(3669,'worksubtype','lastrevisedate',19,'DateTime','','','',''),(3670,'worksubtype','id_user_revise',11,'Integer','','','',''),(3671,'worksubtype','canceldate',19,'DateTime','','','',''),(3672,'worksubtype','cancel',11,'Integer','','','',''),(3673,'worksubtype_detail','id_worksubtype',11,'Integer','','','primary',''),(3674,'worksubtype_detail','id_category',11,'Integer','','','primary',''),(3675,'worksubtype_detail','id_family',11,'Integer','','','primary',''),(3676,'worksubtype_detail','id_item',11,'Integer','','','primary',''),(3677,'worksubtype_quantity','id_worksubtype_quantity',11,'Integer','','','primary unique',''),(3678,'worksubtype_quantity','id_worksubtype',11,'Integer','','','multiple',''),(3679,'worksubtype_quantity','quantity',14,'Integer','','','',''),(3680,'worksubtype_quantity','days',5,'Integer','','','',''),(3681,'worksubtype_quantity','createdate',19,'DateTime','','','',''),(3682,'worksubtype_quantity','id_user_create',11,'Integer','','','',''),(3683,'worksubtype_quantity','lastrevisedate',19,'DateTime','','','',''),(3684,'worksubtype_quantity','id_user_revise',11,'Integer','','','',''),(3685,'worksubtype_quantity','canceldate',19,'DateTime','','','',''),(3686,'worksubtype_quantity','cancel',11,'Integer','','','',''),(3687,'worktype','id_worktype',11,'Integer','','','primary unique',''),(3688,'worktype','name',50,'Text','','','',''),(3689,'worktype','purpose',255,'Text','','','',''),(3690,'worktype','createdate',19,'DateTime','','','',''),(3691,'worktype','id_user_create',11,'Integer','','','',''),(3692,'worktype','orderflag',3,'Integer','','','',''),(3693,'worktype','lastrevisedate',19,'DateTime','','','',''),(3694,'worktype','id_user_revise',11,'Integer','','','',''),(3695,'worktype','canceldate',19,'DateTime','','','',''),(3696,'worktype','cancel',11,'Integer','','','',''),(3697,'zipcode','zip',10,'Text','','','multiple',''),(3698,'zipcode','state',10,'Text','','','',''),(3699,'zipcode','city',50,'Text','','','',''),(3700,'zipcode','longitude',22,'Numeric','','','',''),(3701,'zipcode','latitude',22,'Numeric','','','',''),(3702,'zones','zone_id',5,'Integer','','','primary',''),(3703,'zones','zone_country_id',5,'Integer','','','',''),(3704,'zones','zone_code',5,'Text','','','',''),(3705,'zones','zone_name',32,'Text','','','',''),(3706,'airport_order','agentcode',50,'Text','','','',''),(3707,'arcompany','tax_on_freight',2,'Integer','','','',''),(3708,'arinvoice','formnumber',50,'Text','','','',''),(3709,'arinvoicedetail','main_arinvoicedetailid',11,'Integer','','','',''),(3710,'arinvoicedetail','itemoptionid',11,'Integer','','','',''),(3711,'arinvoicedetail','itemoptiongroupid',11,'Integer','','','',''),(3712,'arordership','shiptoid',11,'Integer','','','multiple',''),(3713,'b2b_access_table','id',11,'Integer','','','primary',''),(3714,'b2b_access_table','description',255,'Text','','','',''),(3715,'b2b_access_table','whocan',11,'Integer','1,2','1 if customer\r\n2 if vendor','',''),(3716,'b2b_access_table','pagelist',65535,'X','pagelist=* means all access (supervisor)\r\npagelist= means NO access','list of php pages on b2b site that can be accessed. Must be separated by commas.','',''),(3717,'b2b_user_access_table','id',11,'Integer','','','primary',''),(3718,'b2b_user_access_table','b2b_access_tableid',11,'Integer','','','multiple',''),(3719,'b2b_user_access_table','b2buserid',11,'Integer','','','multiple',''),(3720,'b2buser','id',11,'Integer','','','primary',''),(3721,'b2buser','firstname',100,'Text','','','',''),(3722,'b2buser','lastname',100,'Text','','','',''),(3723,'b2buser','loginname',100,'Text','','','multiple',''),(3724,'b2buser','password',255,'Text','','','multiple',''),(3725,'b2buser','usertype',11,'Integer','1 if customer\r\n2 if vendor','Determines what type of menu items will appear and which modules can be accessed by this user.','multiple',''),(3726,'b2buser','referenceid',11,'Integer','','','multiple',''),(3727,'b2buser','cancel',11,'Integer','','','multiple',''),(3728,'b2buser','canceldate',19,'DateTime','','','',''),(3729,'b2buser','canceluserid',11,'Integer','','','',''),(3730,'b2buser','entrydate',19,'DateTime','','','',''),(3731,'b2buser','entryuserid',11,'Integer','','','',''),(3732,'b2buser','lastchangedate',19,'DateTime','','','',''),(3733,'b2buser','lastchangeuserid',11,'Integer','','','',''),(3734,'homepages','id',11,'Integer','','','multiple',''),(3735,'homepages','tabname',200,'Text','','','multiple',''),(3736,'homepages','reportname',200,'Text','','','multiple',''),(3737,'homepages','reportdescription',255,'Text','','','',''),(3738,'homepages','create_interval',12,'Numeric','','','',''),(3739,'homepages','lastupdate',19,'DateTime','','','',''),(3740,'homepages','status',11,'Integer','','','',''),(3741,'homepages','generate_start',19,'DateTime','','','',''),(3742,'homepages','page_html',65535,'X','','','',''),(3743,'homepages','gencompanyid',11,'Integer','','','',''),(3744,'invcompany','default_inventoryglacct',11,'Integer','','','',''),(3745,'itemoption','optioncode',50,'Text','','','',''),(3746,'airport','glsalesid',11,'Integer','','','',''),(3747,'airport_order','agent_commission_paid',14,'Numeric','','','',''),(3748,'airport_order','vendor_commission_paid',14,'Numeric','','','',''),(3749,'airport_order','barcode_file',50,'Text','','','',''),(3750,'apbill','approved_paydate',10,'Date','','','',''),(3751,'apbill','preapproved_userid',11,'Integer','','','',''),(3752,'apbill','preapproved_status',5,'Integer','','','',''),(3753,'apbill','preapproved_checkacctid',11,'Integer','','','',''),(3754,'apbill','preapproved_amount',17,'Numeric','','','',''),(3755,'apbill','preapproved_interest',17,'Numeric','','','',''),(3756,'apbill','old_id',255,'Text','','','',''),(3757,'apbillpayment','old_id',255,'Text','','','',''),(3758,'apbilltaxdetail','id',11,'Integer','','','primary',''),(3759,'apbilltaxdetail','apbillid',11,'Integer','','','multiple',''),(3760,'apbilltaxdetail','taxid',11,'Integer','','','multiple',''),(3761,'apbilltaxdetail','taxamount',21,'Numeric','','','',''),(3762,'apcompany','glcommissionid',11,'Integer','','','',''),(3763,'apcompany','default_vendor_termsid',11,'Integer','','','',''),(3764,'apcompany','must_preapprove',5,'Integer','','','',''),(3765,'apcompany','which_preapprove_ckdate',5,'Integer','','','',''),(3766,'arcompany','order_base',5,'Integer','','','',''),(3767,'arcompany','b2b_orders',2,'Integer','','','',''),(3768,'arcompany','b2b_service',2,'Integer','','','',''),(3769,'arcompany','tax_how',2,'Integer','','','',''),(3770,'arcompany','donotapply',2,'Integer','','','',''),(3771,'arcompany','restockglid',11,'Integer','','','',''),(3772,'arcompany','restockunitid',11,'Integer','','','',''),(3773,'arcompany','salesterritories',5,'Integer','','','',''),(3774,'arcompany','default_statement',2,'Integer','','','',''),(3775,'arcompany','b2b_commission',5,'Integer','','','',''),(3776,'arcompany','default_discountmsg',65535,'X','','','',''),(3777,'arcompany','b2b_print_orders',5,'Integer','','','',''),(3778,'arcompany','b2b_pricelist_orders',5,'Integer','','','',''),(3779,'arinvoice','shiptoattn',100,'Text','','','',''),(3780,'arinvoice','old_id',255,'Text','','','',''),(3781,'arinvoice_interest','id',11,'Integer','','','primary',''),(3782,'arinvoice_interest','invoiceid',11,'Integer','','','',''),(3783,'arinvoice_interest','calcdate',10,'Date','','','multiple',''),(3784,'arinvoice_interest','amount',21,'Numeric','','','',''),(3785,'arinvoicedetail','taxflag2',2,'Integer','','','',''),(3786,'arinvoicedetail','taxflag3',2,'Integer','','','',''),(3787,'arinvoicedetail','taxflagid',11,'Integer','','','',''),(3788,'arinvoicedetail','taxflag2id',11,'Integer','','','',''),(3789,'arinvoicedetail','taxflag3id',11,'Integer','','','',''),(3790,'arinvoicedetail','orig_priceach',14,'Numeric','','','',''),(3791,'arinvoicedetail','discount_amount',14,'Numeric','','','',''),(3792,'arinvoicedetail','discount_percent',14,'Numeric','','','',''),(3793,'arinvoicedetail','old_id',255,'Text','','','',''),(3794,'arinvoicedetailcost','itemid',11,'Integer','','','',''),(3795,'arinvoicedetailcost','locationid',11,'Integer','','','',''),(3796,'arinvoicedetailcost','arordershipdetailid',11,'Integer','','','',''),(3797,'arinvoicedetailcost','inventoryglacctid',11,'Integer','','','',''),(3798,'arinvoicepaymentdetail','old_id',255,'Text','','','',''),(3799,'arorder','rma_arorder_returnedid',11,'Integer','','','',''),(3800,'arorder','rma_orig_arorderid',11,'Integer','','','',''),(3801,'arorder_deposit','cctransactionid',11,'Integer','','','',''),(3802,'arorderdetail','taxflag2',2,'Integer','','','',''),(3803,'arorderdetail','taxflag3',2,'Integer','','','',''),(3804,'arorderdetail','taxflagid',11,'Integer','','','',''),(3805,'arorderdetail','taxflag2id',11,'Integer','','','',''),(3806,'arorderdetail','taxflag3id',11,'Integer','','','',''),(3807,'arorderdetail','itemweight',14,'Numeric','','','',''),(3808,'arorderdetail','qtyorderprice',22,'Numeric','','','',''),(3809,'arordership','voucherid',11,'Integer','','','',''),(3810,'arordershipdetail','inventoryglacctid',11,'Integer','','','',''),(3811,'arordershipdetail','costeach',21,'Numeric','','','',''),(3812,'arordertax','taxrate',14,'Numeric','','','',''),(3813,'arserviceorder_time','ordered',11,'Integer','','','multiple',''),(3814,'b2buser','email',255,'Text','','','',''),(3815,'buildordermaster','status',5,'Integer','','','',''),(3816,'buildordermaster','po_created',5,'Integer','','','',''),(3817,'buildordersub','vendoritemid',11,'Integer','','','',''),(3818,'buildordersub','mfg',50,'Text','','','',''),(3819,'buildordersub','vordernumber',30,'Text','','','',''),(3820,'buildordersub','reference_notes',65535,'X','','','',''),(3821,'buildordersubdetail','id',11,'Integer','','','primary',''),(3822,'buildordersubdetail','buildordersubid',11,'Integer','','','multiple',''),(3823,'buildordersubdetail','vendoritemid',11,'Integer','','','multiple',''),(3824,'buildordersubdetail','mfg',50,'Text','','','',''),(3825,'buildordersubdetail','vordernumber',30,'Text','','','',''),(3826,'buildordersubdetail','poqty',14,'Numeric','','','',''),(3827,'buildordersubdetail','invpodetailid',11,'Integer','','','multiple',''),(3828,'buildordersubdetail','qty_commit',14,'Numeric','','','',''),(3829,'buildordersubdetail','qtyused',14,'Numeric','','','',''),(3830,'cashpaymenttax','taxgroupid',11,'Integer','','','',''),(3831,'ccaccount','id',11,'Integer','','','primary',''),(3832,'ccaccount','name',100,'Text','','','',''),(3833,'ccaccount','ccprocessorid',11,'Integer','','','',''),(3834,'ccaccount','companyid',11,'Integer','','','',''),(3835,'ccaccount','entrydate',19,'DateTime','','','',''),(3836,'ccaccount','entryuserid',11,'Integer','','','',''),(3837,'ccaccount','lastchangedate',19,'DateTime','','','',''),(3838,'ccaccount','lastchangeuserid',11,'Integer','','','',''),(3839,'ccaccount','cancel',2,'Integer','','','',''),(3840,'ccaccount','canceldate',19,'DateTime','','','',''),(3841,'ccaccount','canceluserid',11,'Integer','','','',''),(3842,'ccaccountoption','id',11,'Integer','','','primary',''),(3843,'ccaccountoption','ccprocessorid',11,'Integer','','','',''),(3844,'ccaccountoption','name',255,'Text','','','',''),(3845,'ccaccountoption','description',255,'Text','','','',''),(3846,'ccaccountoption','fieldname',50,'Text','','','',''),(3847,'ccaccountoption','ccvalues',65535,'X','','','',''),(3848,'ccaccountoption','ccdefault',255,'Text','','','',''),(3849,'ccaccountoption','cchold',2,'Integer','','','',''),(3850,'ccaccountsetting','id',11,'Integer','','','primary',''),(3851,'ccaccountsetting','ccaccountid',11,'Integer','','','',''),(3852,'ccaccountsetting','ccaccountoptionid',11,'Integer','','','',''),(3853,'ccaccountsetting','value',255,'Text','','','',''),(3854,'ccaccountsetting','lastchangedate',19,'DateTime','','','',''),(3855,'ccaccountsetting','lastchangeuserid',11,'Integer','','','',''),(3856,'cctransaction','id',11,'Integer','','','primary',''),(3857,'cctransaction','customerid',11,'Integer','','','multiple',''),(3858,'cctransaction','b2buserid',11,'Integer','','','multiple',''),(3859,'cctransaction','ccaccountid',11,'Integer','','','multiple',''),(3860,'cctransaction','referid',11,'Integer','','','multiple',''),(3861,'cctransaction','refertable',50,'Text','','','multiple',''),(3862,'cctransaction','transtype',1,'Text','','','multiple',''),(3863,'cctransaction','cardnumber',50,'Text','','','',''),(3864,'cctransaction','cardexp',4,'Text','','','',''),(3865,'cctransaction','cardtype',20,'Text','','','multiple',''),(3866,'cctransaction','cardfirstname',50,'Text','','','',''),(3867,'cctransaction','cardlastname',50,'Text','','','',''),(3868,'cctransaction','amount',14,'Numeric','','','',''),(3869,'cctransaction','nontaxable',14,'Numeric','','','',''),(3870,'cctransaction','shipping',14,'Numeric','','','',''),(3871,'cctransaction','tax',14,'Numeric','','','',''),(3872,'cctransaction','transid',30,'Text','','','multiple',''),(3873,'cctransaction','optionalid',80,'Text','','','',''),(3874,'cctransaction','resultcode',1,'Text','','','',''),(3875,'cctransaction','resultreasoncode',11,'Integer','','','',''),(3876,'cctransaction','resultreasontext',255,'Text','','','',''),(3877,'cctransaction','authcode',25,'Text','','','',''),(3878,'cctransaction','avscode',2,'Text','','','',''),(3879,'cctransaction','cardcode',2,'Text','','','',''),(3880,'cctransaction','customerip',25,'Text','','','',''),(3881,'cctransaction','md5hash',50,'Text','','','',''),(3882,'cctransaction','customerconfirmation',20,'Text','','','multiple',''),(3883,'cctransaction','authopen',2,'Integer','','','',''),(3884,'cctransaction','entrydate',19,'DateTime','','','multiple',''),(3885,'cctransaction','entryuserid',11,'Integer','','','',''),(3886,'cctransaction','authtransid',30,'Text','','','',''),(3887,'cctransaction','authorize_extra',11,'Integer','','','',''),(3888,'cctransaction','userdata',255,'Text','','','',''),(3889,'checkacct','pay_type',5,'Integer','','','',''),(3890,'chk','commission',2,'Integer','','','',''),(3891,'compositeitemid','default_itemvendorid',11,'Integer','','','',''),(3892,'compositeitemid','mfg',50,'Text','','','',''),(3893,'compositeitemid','vordernumber',30,'Text','','','',''),(3894,'compositeitemid','reference_notes',65535,'X','','','',''),(3895,'compositeitemid','status',5,'Integer','','','',''),(3896,'compositeitemid','displayorder',5,'Integer','','','',''),(3897,'customer','preprint_from_box_labels',2,'Integer','','','',''),(3898,'customer','notify_order',2,'Integer','','','',''),(3899,'customer','notify_ship',2,'Integer','','','',''),(3900,'customer','notify_invoice',2,'Integer','','','',''),(3901,'customer','email_order_acknowledgement',2,'Integer','','','',''),(3902,'customer','email_order_ship',2,'Integer','','','',''),(3903,'customer','email_invoice',2,'Integer','','','',''),(3904,'customer','groupid',11,'Integer','','','multiple',''),(3905,'customer','onlygroupitems_onb2b',5,'Integer','','','',''),(3906,'customer','taxgroupid',11,'Integer','','','multiple',''),(3907,'employeelog','id_employeelog',11,'Integer','','','primary unique',''),(3908,'employeelog','id_employee',11,'Integer','','','',''),(3909,'employeelog','status',3,'Integer','','','',''),(3910,'employeelog','createdate',19,'DateTime','','','',''),(3911,'employeelog','starttime',19,'DateTime','','','',''),(3912,'employeelog','endtime',19,'DateTime','','','',''),(3913,'employeelog','total_time',12,'Numeric','','','',''),(3914,'employeelog','id_employeelogcategory',11,'Integer','','','',''),(3915,'employeelog','notes',100,'Text','','','',''),(3916,'employeelog','cancel',3,'Integer','','','',''),(3917,'employeelogcategory','id',11,'Integer','','','primary unique',''),(3918,'employeelogcategory','name',100,'Text','','','',''),(3919,'employeelogcategory','cancel',3,'Integer','','','',''),(3920,'estquote_deposit','id',11,'Integer','','','primary unique',''),(3921,'estquote_deposit','id_printorder',11,'Integer','','','multiple',''),(3922,'estquote_deposit','amount',14,'Numeric','','','',''),(3923,'estquote_deposit','payment_method',5,'Integer','','','',''),(3924,'estquote_deposit','transaction_id',32,'Text','','','',''),(3925,'estquote_deposit','entrydate',10,'Date','','','',''),(3926,'estquote_deposit','cc_type',20,'Text','','','',''),(3927,'estquote_deposit','last4ofcard',4,'Text','','','',''),(3928,'estquote_deposit','voucherid',11,'Integer','','','multiple',''),(3929,'estquote_deposit','cancel',3,'Integer','','','',''),(3930,'estquote_deposit','canceldate',10,'Date','','','',''),(3931,'estquote_deposit','canceluserid',11,'Integer','','','',''),(3932,'estquote_deposit','lastchangedate',19,'DateTime','','','',''),(3933,'estquote_deposit','bankdepositid',11,'Integer','','','',''),(3934,'estquotebinderyaddl','pieceworkgroupid',11,'Integer','','','',''),(3935,'estquotebinderyaddl','internal_quote',5,'Integer','','','multiple',''),(3936,'estquotebinderyaddl','external_quote',5,'Integer','','','multiple',''),(3937,'estquotebinderyaddl','internal_order',5,'Integer','','','multiple',''),(3938,'estquotebinderyaddl','external_order',5,'Integer','','','multiple',''),(3939,'estquotepieceworkgroup','id',11,'Integer','','','primary',''),(3940,'estquotepieceworkgroup','name',100,'Text','','','',''),(3941,'estquotepieceworkgroup','gencompanyid',11,'Integer','','','',''),(3942,'estquotequote','reprint',11,'Integer','','','',''),(3943,'estquoteship','shiptoname',255,'Text','','','',''),(3944,'estquoteship','shiptoaddress',255,'Text','','','',''),(3945,'estquoteship','shiptoaddress2',255,'Text','','','',''),(3946,'estquoteship','shiptocity',50,'Text','','','',''),(3947,'estquoteship','shiptostate',20,'Text','','','',''),(3948,'estquoteship','shiptozip',15,'Text','','','',''),(3949,'estquoteship','shiptophone',20,'Text','','','',''),(3950,'estquoteship','shipfromname',255,'Text','','','',''),(3951,'estquoteship','shipfromaddress',255,'Text','','','',''),(3952,'estquoteship','shipfromaddress2',255,'Text','','','',''),(3953,'estquoteship','shipfromcity',50,'Text','','','',''),(3954,'estquoteship','shipfromstate',20,'Text','','','',''),(3955,'estquoteship','shipfromzip',15,'Text','','','',''),(3956,'estquoteworktype','tightregrule',5,'Integer','','','',''),(3957,'gencompany','vat_tax',5,'Integer','','','',''),(3958,'genuser','weather_zip',20,'Text','','','',''),(3959,'genuser','cpa',11,'Integer','','','',''),(3960,'genuserhome','whole2',100,'Text','','','',''),(3961,'gl_costcenter','id',11,'Integer','','','primary',''),(3962,'gl_costcenter','description',255,'Text','','','',''),(3963,'gl_costcenter','companyid',11,'Integer','','','',''),(3964,'gl_costcenter','cancel',5,'Integer','','','multiple',''),(3965,'gl_costcenter','canceluserid',11,'Integer','','','',''),(3966,'gl_costcenter','canceldate',19,'DateTime','','','',''),(3967,'gl_costcenter','entrydate',10,'Date','','','',''),(3968,'gl_costcenter','entryuserid',11,'Integer','','','',''),(3969,'gl_summarylevel','id',11,'Integer','','','primary',''),(3970,'gl_summarylevel','description',255,'Text','','','',''),(3971,'gl_summarylevel','companyid',11,'Integer','','','',''),(3972,'gl_summarylevel','cancel',5,'Integer','','','multiple',''),(3973,'gl_summarylevel','canceluserid',11,'Integer','','','',''),(3974,'gl_summarylevel','canceldate',19,'DateTime','','','',''),(3975,'gl_summarylevel','entrydate',10,'Date','','','',''),(3976,'gl_summarylevel','entryuserid',11,'Integer','','','',''),(3977,'gl_summarylevel_account','glaccountid',11,'Integer','','','multiple',''),(3978,'gl_summarylevel_account','gl_summarylevelid',11,'Integer','','','multiple',''),(3979,'gl_summarylevel_account','destination_glaccountid',11,'Integer','','','multiple',''),(3980,'glaccount','costcenterid',11,'Integer','','','multiple',''),(3981,'igroup','id',11,'Integer','','','primary',''),(3982,'igroup','groupname',255,'Text','','','',''),(3983,'igroup','groupcode',20,'Text','','','multiple',''),(3984,'igroup','createdate',19,'DateTime','','','',''),(3985,'igroup','gencompanyid',11,'Integer','','','',''),(3986,'igroup','createuserid',11,'Integer','','','',''),(3987,'igroup','cancel',5,'Integer','','','',''),(3988,'igroup','canceldate',19,'DateTime','','','',''),(3989,'igroup','canceluserid',11,'Integer','','','',''),(3990,'igroup','lastchangedate',19,'DateTime','','','',''),(3991,'igroup','lastchangeuserid',11,'Integer','','','',''),(3992,'invcompany','multi_quantity',5,'Integer','','','',''),(3993,'invnotification','id',11,'Integer','','','primary',''),(3994,'invnotification','itemid',11,'Integer','','','multiple',''),(3995,'invnotification','customerid',11,'Integer','','','multiple',''),(3996,'invnotification','companyid',11,'Integer','','','',''),(3997,'invnotification','email',255,'Text','','','',''),(3998,'invnotification','entrydate',19,'DateTime','','','',''),(3999,'invnotification','sent',2,'Integer','','','',''),(4000,'invnotification','sentdate',19,'DateTime','','','',''),(4001,'invpo','salesordernumber',20,'Text','','','',''),(4002,'invpo','dropship',5,'Integer','','','multiple',''),(4003,'invpo','shiptoid',11,'Integer','','','multiple',''),(4004,'invpo','salesorderid',11,'Integer','','','multiple',''),(4005,'invpodetail','itemvendorid',11,'Integer','','','',''),(4006,'invpodetail','purchaseunitid',11,'Integer','','','',''),(4007,'invpodetail','itempriceqty',21,'Numeric','','','',''),(4008,'invreceive','itempriceqty',14,'Numeric','','','',''),(4009,'item','id_printorder',11,'Integer','','','',''),(4010,'item','taxexempt',2,'Integer','','','',''),(4011,'item_group','itemid',11,'Integer','','','primary',''),(4012,'item_group','groupid',11,'Integer','','','primary',''),(4013,'item_group','price',17,'Numeric','','','',''),(4014,'itemtransaction','itemvendorid',11,'Integer','','','multiple',''),(4015,'itemtransaction','status',5,'Integer','','','multiple',''),(4016,'itemtransaction','withdrawn',14,'Numeric','','','',''),(4017,'itemtransactiondetail','id',11,'Integer','','','primary',''),(4018,'itemtransactiondetail','itemtransactionid',11,'Integer','','','multiple',''),(4019,'itemtransactiondetail','itemtransactionfieldid',11,'Integer','','','multiple',''),(4020,'itemtransactiondetail','itemvalue',255,'Text','','','',''),(4021,'itemtransactionfield','id',11,'Integer','','','primary',''),(4022,'itemtransactionfield','categoryid',11,'Integer','','','multiple',''),(4023,'itemtransactionfield','description',255,'Text','','','',''),(4024,'itemtransactionfield','default_value',255,'Text','','','',''),(4025,'itemtransactionfield','entrytype',5,'Integer','','','',''),(4026,'itemtransactionfield','text_limit',11,'Integer','','','',''),(4027,'itemtransactionfield','gencompanyid',11,'Integer','','','multiple',''),(4028,'itemtransactionfield','entrydate',19,'DateTime','','','',''),(4029,'itemtransactionfield','entryuserid',11,'Integer','','','',''),(4030,'itemtransactionfield','cancel',5,'Integer','','','multiple',''),(4031,'itemtransactionfield','canceluserid',11,'Integer','','','',''),(4032,'itemtransactionfield','canceldate',19,'DateTime','','','',''),(4033,'itemtransactionfield','lastupdatedate',19,'DateTime','','','',''),(4034,'itemtransactionfield','lastupdateuserid',11,'Integer','','','',''),(4035,'itemtransactionfield_selection','id',11,'Integer','','','primary',''),(4036,'itemtransactionfield_selection','itemtransactionfieldid',11,'Integer','','','',''),(4037,'itemtransactionfield_selection','name',255,'Text','','','',''),(4038,'itemtransactionfield_selection','sortorder',5,'Integer','','','multiple',''),(4039,'itemtransactionfield_selection','cancel',5,'Integer','','','multiple',''),(4040,'itemtransactionfield_selection','canceldate',19,'DateTime','','','',''),(4041,'itemtransactionfield_selection','canceluserid',11,'Integer','','','',''),(4042,'itemvendor','mfg',50,'Text','','','',''),(4043,'itemvendor','is_default',5,'Integer','','','',''),(4044,'lang','pt',255,'Text','','','',''),(4045,'lang','jp',255,'Text','','','',''),(4046,'lang','fr',255,'Text','','','',''),(4047,'langcompany','id',11,'Integer','','','primary',''),(4048,'langcompany','gencompanyid',11,'Integer','','','multiple',''),(4049,'langcompany','languages_id',11,'Integer','','','',''),(4050,'langcompany','active',2,'Integer','','','',''),(4051,'langfield','id',11,'Integer','','','primary',''),(4052,'langfield','tablename',255,'Text','','','multiple',''),(4053,'langfield','fieldname',255,'Text','','','multiple',''),(4054,'langfield','recordid',11,'Integer','','','multiple',''),(4055,'langfield','en',65535,'X','','','',''),(4056,'langfield','de',65535,'X','','','',''),(4057,'langfield','es',65535,'X','','','',''),(4058,'langfield','ru',65535,'X','','','',''),(4059,'langfield','jp',65535,'X','','','',''),(4060,'langmatch_b2b','id',11,'Integer','','','primary',''),(4061,'langmatch_b2b','langid',11,'Integer','','','multiple',''),(4062,'langmatch_b2b','page',100,'Text','','','multiple',''),(4063,'link','id',11,'Integer','','','primary',''),(4064,'link','name',25,'Text','','','',''),(4065,'link','url',100,'Text','','','',''),(4066,'link','description',100,'Text','','','',''),(4067,'link','gencompanyid',11,'Text','','','',''),(4068,'link','active',11,'Text','','','',''),(4069,'link','linktype',11,'Text','','','',''),(4070,'menudata','plaintext',11,'Text','','','',''),(4071,'menudata','linktype',11,'Text','','','',''),(4072,'order_partnr','print_type',2,'Integer','','','',''),(4073,'prcity','round_tax',2,'Integer','','','',''),(4074,'prcity','mexemptyr1',21,'Numeric','','','',''),(4075,'prcity','mexemptyr2',21,'Numeric','','','',''),(4076,'prcity','mexemptyr3',21,'Numeric','','','',''),(4077,'prcity','mexemptyr4',21,'Numeric','','','',''),(4078,'prcity','jexemptyr1',21,'Numeric','','','',''),(4079,'prcity','jexemptyr2',21,'Numeric','','','',''),(4080,'prcity','jexemptyr3',21,'Numeric','','','',''),(4081,'prcity','jexemptyr4',21,'Numeric','','','',''),(4082,'prcity','hexemptyr1',21,'Numeric','','','',''),(4083,'prcity','hexemptyr2',21,'Numeric','','','',''),(4084,'prcity','hexemptyr3',21,'Numeric','','','',''),(4085,'prcity','hexemptyr4',21,'Numeric','','','',''),(4086,'prcity','hexemptyr0',21,'Numeric','','','',''),(4087,'prcity','mexemptyr0',21,'Numeric','','','',''),(4088,'prcity','jexemptyr0',21,'Numeric','','','',''),(4089,'prcity','exemptyr0',21,'Numeric','','','',''),(4090,'prcompany','w2extra_top',5,'Integer','','','',''),(4091,'prcompany','w2extra_side',5,'Integer','','','',''),(4092,'premployee','old_id',255,'Text','','','',''),(4093,'printorder','Bindery_completedate',19,'DateTime','','','',''),(4094,'printorder','Bindery_initials',255,'Text','','','',''),(4095,'printorder','Digital_Print_completedate',19,'DateTime','','','',''),(4096,'printorder','Digital_Print_initials',255,'Text','','','',''),(4097,'printorder','Graphics_completedate',19,'DateTime','','','',''),(4098,'printorder','Graphics_initials',10,'Text','','','',''),(4099,'printorder','Outside_Vended_completedate',19,'DateTime','','','',''),(4100,'printorder','Outside_Vended_initials',255,'Text','','','',''),(4101,'printorder','Paper_completedate',19,'DateTime','','','',''),(4102,'printorder','Paper_initials',10,'Text','','','',''),(4103,'printorder','Prepress_completedate',19,'DateTime','','','',''),(4104,'printorder','Prepress_initials',255,'Text','','','',''),(4105,'printorder','Press_completedate',19,'DateTime','','','',''),(4106,'printorder','Press_initials',255,'Text','','','',''),(4107,'printorder','Shipping_completedate',19,'DateTime','','','',''),(4108,'printorder','Shipping_initials',10,'Text','','','',''),(4109,'printorder_shipto','shiptoname',255,'Text','','','',''),(4110,'printorder_shipto','shiptoaddress',255,'Text','','','',''),(4111,'printorder_shipto','shiptoaddress2',255,'Text','','','',''),(4112,'printorder_shipto','shiptocity',50,'Text','','','',''),(4113,'printorder_shipto','shiptostate',20,'Text','','','',''),(4114,'printorder_shipto','shiptozip',15,'Text','','','',''),(4115,'printorder_shipto','shiptophone',20,'Text','','','',''),(4116,'prlocal','round_tax',2,'Integer','','','',''),(4117,'prlocal','mexemptyr1',21,'Numeric','','','',''),(4118,'prlocal','mexemptyr2',21,'Numeric','','','',''),(4119,'prlocal','mexemptyr3',21,'Numeric','','','',''),(4120,'prlocal','mexemptyr4',21,'Numeric','','','',''),(4121,'prlocal','jexemptyr1',21,'Numeric','','','',''),(4122,'prlocal','jexemptyr2',21,'Numeric','','','',''),(4123,'prlocal','jexemptyr3',21,'Numeric','','','',''),(4124,'prlocal','jexemptyr4',21,'Numeric','','','',''),(4125,'prlocal','hexemptyr1',21,'Numeric','','','',''),(4126,'prlocal','hexemptyr2',21,'Numeric','','','',''),(4127,'prlocal','hexemptyr3',21,'Numeric','','','',''),(4128,'prlocal','hexemptyr4',21,'Numeric','','','',''),(4129,'prlocal','hexemptyr0',21,'Numeric','','','',''),(4130,'prlocal','mexemptyr0',21,'Numeric','','','',''),(4131,'prlocal','jexemptyr0',21,'Numeric','','','',''),(4132,'prlocal','exemptyr0',21,'Numeric','','','',''),(4133,'prpension','w2retirementbox',2,'Integer','','','',''),(4134,'prstate','round_tax',2,'Integer','','','',''),(4135,'prstate','hexemptyr0',21,'Numeric','','','',''),(4136,'prstate','mexemptyr0',21,'Numeric','','','',''),(4137,'prstate','jexemptyr0',21,'Numeric','','','',''),(4138,'prstate','exemptyr0',21,'Numeric','','','',''),(4139,'rma_action','id',11,'Integer','','','primary',''),(4140,'rma_action','action',50,'Text','','','',''),(4141,'rma_action','new_order_required',5,'Integer','','','',''),(4142,'rma_action','gencompanyid',11,'Integer','','','',''),(4143,'rma_action','cancel',5,'Integer','','','multiple',''),(4144,'rma_action','canceluserid',11,'Integer','','','',''),(4145,'rma_action','canceldate',19,'DateTime','','','',''),(4146,'rma_action','entrydate',19,'DateTime','','','',''),(4147,'rma_action','entryuserid',11,'Integer','','','',''),(4148,'rma_arorder','id',11,'Integer','','','primary',''),(4149,'rma_arorder','rmanumber',50,'Text','','','multiple',''),(4150,'rma_arorder','orderid',11,'Integer','','','multiple',''),(4151,'rma_arorder','arordershipid',11,'Integer','','','multiple',''),(4152,'rma_arorder','date_issued',10,'Date','','','',''),(4153,'rma_arorder','date_rma_completed',10,'Date','','','',''),(4154,'rma_arorder','status',5,'Integer','','','multiple',''),(4155,'rma_arorder','return_shipping_paid_by',5,'Integer','','','',''),(4156,'rma_arorder','send_willcall',5,'Integer','','','',''),(4157,'rma_arorder','notes',255,'Text','','','',''),(4158,'rma_arorder','createdate',19,'DateTime','','','',''),(4159,'rma_arorder','createuserid',11,'Integer','','','',''),(4160,'rma_arorder','lastupdatedate',19,'DateTime','','','',''),(4161,'rma_arorder','lastupdateuserid',11,'Integer','','','',''),(4162,'rma_arorder','cancel',5,'Integer','','','multiple',''),(4163,'rma_arorder','canceldate',19,'DateTime','','','',''),(4164,'rma_arorder','canceluserid',11,'Integer','','','',''),(4165,'rma_arorder_returned','id',11,'Integer','','','primary',''),(4166,'rma_arorder_returned','rma_arorderid',11,'Integer','','','multiple',''),(4167,'rma_arorder_returned','return_date',10,'Date','','','multiple',''),(4168,'rma_arorder_returned','taxid',11,'Integer','','','',''),(4169,'rma_arorder_returned','taxcredit',21,'Numeric','','','',''),(4170,'rma_arorder_returned','taxid2',11,'Integer','','','',''),(4171,'rma_arorder_returned','taxcredit2',21,'Numeric','','','',''),(4172,'rma_arorder_returned','taxid3',11,'Integer','','','',''),(4173,'rma_arorder_returned','taxcredit3',21,'Numeric','','','',''),(4174,'rma_arorder_returned','shipping_credit',21,'Numeric','','','',''),(4175,'rma_arorder_returned','restock_fee',21,'Numeric','','','',''),(4176,'rma_arorder_returned','total_credit',21,'Numeric','','','',''),(4177,'rma_arorder_returned','invoiceid',11,'Integer','','','',''),(4178,'rma_arorder_returned','voucherid',11,'Integer','','','',''),(4179,'rma_arorder_returned','new_orderid',11,'Integer','','','',''),(4180,'rma_arorder_returned','cancel',5,'Integer','','','multiple',''),(4181,'rma_arorder_returned','canceluserid',11,'Integer','','','',''),(4182,'rma_arorder_returned','canceldate',19,'DateTime','','','',''),(4183,'rma_arorder_returned','entrydate',19,'DateTime','','','',''),(4184,'rma_arorder_returned','entryuserid',11,'Integer','','','',''),(4185,'rma_arorder_returned_extras','id',11,'Integer','','','primary',''),(4186,'rma_arorder_returned_extras','rma_arorder_returnedid',11,'Integer','','','multiple',''),(4187,'rma_arorder_returned_extras','creditamount',21,'Numeric','','','',''),(4188,'rma_arorder_returned_extras','creditdescription',255,'Text','','','',''),(4189,'rma_arorder_returned_extras','creditclass',11,'Integer','','','multiple',''),(4190,'rma_arorderdetail','id',11,'Integer','','','primary',''),(4191,'rma_arorderdetail','rma_arorderid',11,'Integer','','','multiple',''),(4192,'rma_arorderdetail','orderid',11,'Integer','','','multiple',''),(4193,'rma_arorderdetail','arordershipdetailid',11,'Integer','','','multiple',''),(4194,'rma_arorderdetail','qty_to_return',14,'Numeric','','','',''),(4195,'rma_arorderdetail','qty_returned_actual',14,'Numeric','','','',''),(4196,'rma_arorderdetail','order_itemid',11,'Integer','','','',''),(4197,'rma_arorderdetail','order_costeach',21,'Numeric','','','',''),(4198,'rma_arorderdetail','order_priceach',21,'Numeric','','','',''),(4199,'rma_arorderdetail','order_saleunitperpriceunit',14,'Numeric','','','',''),(4200,'rma_arorderdetail','order_cogsglid',11,'Integer','','','',''),(4201,'rma_arorderdetail','order_salesglid',11,'Integer','','','',''),(4202,'rma_arorderdetail','replacement_itemid',11,'Integer','','','',''),(4203,'rma_arorderdetail','replacement_costeach',21,'Numeric','','','',''),(4204,'rma_arorderdetail','replacement_priceach',21,'Numeric','','','',''),(4205,'rma_arorderdetail','replace_saleunitperpriceunit',14,'Numeric','','','',''),(4206,'rma_arorderdetail','replace_cogsglid',11,'Integer','','','',''),(4207,'rma_arorderdetail','replace_salesglid',11,'Integer','','','',''),(4208,'rma_arorderdetail','qty_to_replace',14,'Numeric','','','',''),(4209,'rma_arorderdetail','rma_reasonid',11,'Integer','','','',''),(4210,'rma_arorderdetail','rma_actionid',11,'Integer','','','',''),(4211,'rma_arorderdetail','entrydate',10,'Date','','','',''),(4212,'rma_arorderdetail','entryuserid',11,'Integer','','','',''),(4213,'rma_arorderdetail','canceldate',10,'Date','','','',''),(4214,'rma_arorderdetail','cancel',5,'Integer','','','multiple',''),(4215,'rma_arorderdetail','canceluserid',11,'Integer','','','',''),(4216,'rma_arorderdetail_returned','id',11,'Integer','','','primary',''),(4217,'rma_arorderdetail_returned','rma_arorderdetailid',11,'Integer','','','multiple',''),(4218,'rma_arorderdetail_returned','qty_received',14,'Numeric','','','',''),(4219,'rma_arorderdetail_returned','receive_itemid',11,'Integer','','','',''),(4220,'rma_arorderdetail_returned','costeach',21,'Numeric','','','',''),(4221,'rma_arorderdetail_returned','priceach',21,'Numeric','','','',''),(4222,'rma_arorderdetail_returned','salesglaccountid',11,'Integer','','','',''),(4223,'rma_arorderdetail_returned','costglaccountid',11,'Integer','','','',''),(4224,'rma_arorderdetail_returned','inventoryglaccountid',11,'Integer','','','',''),(4225,'rma_arorderdetail_returned','rma_conditionid',11,'Integer','','','',''),(4226,'rma_arorderdetail_returned','rma_actionid',11,'Integer','','','',''),(4227,'rma_arorderdetail_returned','restock_fee',21,'Numeric','','','',''),(4228,'rma_arorderdetail_returned','total_credit_amount',21,'Numeric','','','',''),(4229,'rma_arorderdetail_returned','replace_qty',14,'Numeric','','','',''),(4230,'rma_arorderdetail_returned','replace_itemid',11,'Integer','','','',''),(4231,'rma_arorderdetail_returned','invoiceid',11,'Integer','','','',''),(4232,'rma_arorderdetail_returned','voucherid',11,'Integer','','','',''),(4233,'rma_arorderdetail_returned','entryuserid',11,'Integer','','','',''),(4234,'rma_arorderdetail_returned','cancel',5,'Integer','','','multiple',''),(4235,'rma_arorderdetail_returned','canceluserid',11,'Integer','','','',''),(4236,'rma_arorderdetail_returned','canceldate',19,'DateTime','','','',''),(4237,'rma_condition','id',11,'Integer','','','primary',''),(4238,'rma_condition','rma_condition',50,'Text','','','',''),(4239,'rma_condition','percent_restock_fee',7,'Numeric','','','',''),(4240,'rma_condition','flat_restock_fee',14,'Numeric','','','',''),(4241,'rma_condition','gencompanyid',11,'Integer','','','',''),(4242,'rma_condition','cancel',5,'Integer','','','multiple',''),(4243,'rma_condition','canceluserid',11,'Integer','','','',''),(4244,'rma_condition','canceldate',19,'DateTime','','','',''),(4245,'rma_condition','entrydate',19,'DateTime','','','',''),(4246,'rma_condition','entryuserid',11,'Integer','','','',''),(4247,'rma_condition','damaged',5,'Integer','','','',''),(4248,'rma_creditclass','id',11,'Integer','','','primary',''),(4249,'rma_creditclass','description',50,'Text','','','',''),(4250,'rma_creditclass','glaccountid',11,'Integer','','','',''),(4251,'rma_creditclass','is_taxable',5,'Integer','','','',''),(4252,'rma_creditclass','gencompanyid',11,'Integer','','','',''),(4253,'rma_creditclass','cancel',5,'Integer','','','multiple',''),(4254,'rma_creditclass','canceluserid',11,'Integer','','','',''),(4255,'rma_creditclass','canceldate',19,'DateTime','','','',''),(4256,'rma_creditclass','entrydate',19,'DateTime','','','',''),(4257,'rma_creditclass','entryuserid',11,'Integer','','','',''),(4258,'rma_reason','id',11,'Integer','','','primary',''),(4259,'rma_reason','reason',50,'Text','','','',''),(4260,'rma_reason','gencompanyid',11,'Integer','','','',''),(4261,'rma_reason','cancel',5,'Integer','','','multiple',''),(4262,'rma_reason','canceluserid',11,'Integer','','','',''),(4263,'rma_reason','canceldate',19,'DateTime','','','',''),(4264,'rma_reason','entrydate',19,'DateTime','','','',''),(4265,'rma_reason','entryuserid',11,'Integer','','','',''),(4266,'salesman','commissionrate2',8,'Numeric','','','',''),(4267,'salesman','vendorid',11,'Integer','','','',''),(4268,'salestax','glacctid_taxpaid',11,'Integer','','','',''),(4269,'std_accounts','glquery',65535,'X','','','',''),(4270,'taxgroup','id',11,'Integer','','','primary',''),(4271,'taxgroup','groupcode',20,'Text','','','multiple',''),(4272,'taxgroup','createdate',19,'DateTime','','','',''),(4273,'taxgroup','gencompanyid',11,'Integer','','','',''),(4274,'taxgroup','createuserid',11,'Integer','','','',''),(4275,'taxgroup','cancel',5,'Integer','','','',''),(4276,'taxgroup','canceldate',19,'DateTime','','','',''),(4277,'taxgroup','canceluserid',11,'Integer','','','',''),(4278,'taxgroup','lastchangedate',19,'DateTime','','','',''),(4279,'taxgroup','lastchangeuserid',11,'Integer','','','',''),(4280,'territory','id',11,'Integer','','','primary',''),(4281,'territory','salesmanid',11,'Integer','','','multiple',''),(4282,'territory','state',5,'Text','','','multiple',''),(4283,'territory','zipcode_begin',12,'Text','','','multiple',''),(4284,'territory','zipcode_end',12,'Text','','','multiple',''),(4285,'territory','gencompanyid',11,'Integer','','','multiple',''),(4286,'territory_distribution','id',11,'Integer','','','primary',''),(4287,'territory_distribution','customerid',11,'Integer','','','multiple',''),(4288,'territory_distribution','commission_type',1,'Text','','','',''),(4289,'territory_distribution','salesmanid',11,'Integer','','','multiple',''),(4290,'territory_distribution','itemid',11,'Integer','','','',''),(4291,'territory_distribution','itemqty',14,'Numeric','','','',''),(4292,'territory_distribution','note',255,'Text','','','',''),(4293,'territory_distribution','sales_order',50,'Text','','','',''),(4294,'territory_distribution','amount',17,'Numeric','','','',''),(4295,'territory_distribution','zipcode',12,'Text','','','',''),(4296,'territory_distribution','commission_amount',17,'Numeric','','','',''),(4297,'territory_distribution','checkid',11,'Integer','','','multiple',''),(4298,'territory_distribution','import_date',10,'Date','','','',''),(4299,'territory_distribution','check_date',10,'Date','','','',''),(4300,'territory_distribution','import_userid',11,'Integer','','','',''),(4301,'territory_distribution','import_filename',255,'Text','','','',''),(4302,'territory_distribution','cancel',5,'Integer','','','multiple',''),(4303,'territory_distribution','canceldate',19,'DateTime','','','',''),(4304,'territory_distribution','canceluserid',11,'Integer','','','',''),(4305,'ups','id',11,'Integer','','','primary',''),(4306,'ups','shiptoid',50,'Text','','','multiple',''),(4307,'ups','orderid',50,'Text','','','multiple',''),(4308,'ups','rate',14,'Numeric','','','',''),(4309,'ups','shipdate',12,'Text','','','',''),(4310,'ups','tracknum',255,'Text','','','multiple',''),(4311,'ups','void',5,'Text','','','',''),(4312,'ups','posted',5,'Integer','','','',''),(4313,'ups','hundredweight',2,'Text','','','',''),(4314,'ups','billableweight',14,'Numeric','','','',''),(4315,'vendor','bankrouting',255,'Text','','','',''),(4316,'vendor','bankaccountnum',255,'Text','','','',''),(4317,'vendor','taxgroupid',11,'Integer','','','multiple',''),(4318,'vendor','vendorgroupid',11,'Integer','','','',''),(4319,'vendor_checkacct','id',11,'Integer','','','primary',''),(4320,'vendor_checkacct','vendorid',11,'Integer','','','multiple',''),(4321,'vendor_checkacct','checkacctid',11,'Integer','','','multiple',''),(4322,'vendor_checkacct','paystatus',5,'Integer','','','',''),(4323,'vendorsalestax','id',11,'Integer','','','primary',''),(4324,'vendorsalestax','vendorid',11,'Integer','','','multiple',''),(4325,'vendorsalestax','salestaxid',11,'Integer','','','multiple',''),(4326,'activation','id',11,'Integer','',NULL,'primary',NULL),(4327,'activation','email',255,'Text','',NULL,'',NULL),(4328,'activation','companyname',255,'Text','',NULL,'',NULL),(4329,'activation','servername',255,'Text','',NULL,'',NULL),(4330,'activation','ip',100,'Text','',NULL,'',NULL),(4331,'activation','platform',100,'Text','',NULL,'',NULL),(4332,'activation','act_att',11,'Integer','',NULL,'',NULL),(4333,'activation','osys',100,'Text','',NULL,'',NULL),(4334,'activation','businesstype',100,'Text','',NULL,'',NULL),(4335,'activation','phone',25,'Integer','',NULL,'',NULL),(4336,'activation','street',60,'Text','',NULL,'',NULL),(4337,'activation','city',60,'Text','',NULL,'',NULL),(4338,'activation','state',60,'Text','',NULL,'',NULL),(4339,'activation','country',60,'Text','',NULL,'',NULL),(4340,'activation','postal',25,'Text','',NULL,'',NULL),(4341,'addedit_control','id',11,'Integer','',NULL,'primary',NULL),(4342,'addedit_control','tablename',250,'Text','',NULL,'multiple',NULL),(4343,'addedit_control','fieldname',250,'Text','',NULL,'',NULL),(4344,'addedit_control','block',5,'Integer','',NULL,'multiple',NULL),(4345,'addedit_control','gencompanyid',11,'Integer','',NULL,'',NULL),(4346,'airport','vendorid',11,'Integer','',NULL,'multiple',NULL),(4347,'airport','pfname',255,'Text','',NULL,'',NULL),(4348,'airport','address1',100,'Text','',NULL,'',NULL),(4349,'airport','address2',100,'Text','',NULL,'',NULL),(4350,'airport','city',100,'Text','',NULL,'',NULL),(4351,'airport','state',2,'Text','',NULL,'',NULL),(4352,'airport','zip',10,'Text','',NULL,'',NULL),(4353,'airport','description',65535,'X','',NULL,'',NULL),(4354,'airport','chargefullfee',11,'Integer','',NULL,'',NULL),(4355,'airport','chargeparkingfee',11,'Integer','',NULL,'',NULL),(4356,'airport','chargeairportfee',11,'Integer','',NULL,'',NULL),(4357,'airport','chargefuelfee',11,'Integer','',NULL,'',NULL),(4358,'airport','chargesalestax',11,'Integer','',NULL,'',NULL),(4359,'airport','ta_commission_flat',14,'Numeric','',NULL,'',NULL),(4360,'airport','ta_commission_percent',14,'Numeric','',NULL,'',NULL),(4361,'airport','commission_flat',14,'Numeric','',NULL,'',NULL),(4362,'airport','commission_percent',14,'Numeric','',NULL,'',NULL),(4363,'airport','airport_fee_flat',14,'Numeric','',NULL,'',NULL),(4364,'airport','airport_fee_percent',14,'Numeric','',NULL,'',NULL),(4365,'airport','fuel_charge_flat',14,'Numeric','',NULL,'',NULL),(4366,'airport','salestaxid',11,'Integer','',NULL,'',NULL),(4367,'airport','email',255,'Text','',NULL,'',NULL),(4368,'airport_order','fuel_charge',14,'Numeric','',NULL,'',NULL),(4369,'airport_order','service_fee',14,'Numeric','',NULL,'',NULL),(4370,'airport_order','airport_fee',14,'Numeric','',NULL,'',NULL),(4371,'airport_order','salestax',14,'Numeric','',NULL,'',NULL),(4372,'airport_order','salestaxid',11,'Integer','',NULL,'',NULL),(4373,'airport_order','grand_total',14,'Numeric','',NULL,'',NULL),(4374,'airport_order','reservation_fee',14,'Numeric','',NULL,'',NULL),(4375,'airport_order','invoiceid',11,'Integer','',NULL,'',NULL),(4376,'airport_order','parking_type',1,'Text','',NULL,'',NULL),(4377,'airport_parking','price_self_park',12,'Numeric','',NULL,'',NULL),(4378,'apbill','ccpurchase',5,'Integer','',NULL,'',NULL),(4379,'apcompany','noshowsell_onpo',5,'Integer','',NULL,'',NULL),(4380,'apcompany','sellqtyonly_poentry',5,'Integer','',NULL,'',NULL),(4381,'apcompany','default_checkacctid',11,'Integer','',NULL,'',NULL),(4382,'apcompany','noboxes_on_po',5,'Integer','',NULL,'',NULL),(4383,'apcompany','podate',5,'Integer','',NULL,'',NULL),(4384,'apcompany','suppress_linenum_po',5,'Integer','',NULL,'',NULL),(4385,'apilog','id',10,'Integer','',NULL,'primary',NULL),(4386,'apilog','userid',11,'Integer','',NULL,'',NULL),(4387,'apilog','companyid',11,'Integer','',NULL,'',NULL),(4388,'apilog','action',255,'Text','',NULL,'',NULL),(4389,'apilog','entrydate',19,'DateTime','',NULL,'',NULL),(4390,'apilog','data_in',65535,'X','',NULL,'',NULL),(4391,'apilog','data_out',-1,'X','',NULL,'',NULL),(4392,'apilog','remoteip',15,'Text','',NULL,'',NULL),(4393,'arcompany','default_invoicetermsid',11,'Integer','',NULL,'',NULL),(4394,'arcompany','b2b_allow_signup',11,'Integer','',NULL,'',NULL),(4395,'arcompany','default_customergroupid',11,'Integer','',NULL,'',NULL),(4396,'arcompany','default_b2b_admin_email',255,'Text','',NULL,'',NULL),(4397,'arcompany','invoicecalc',5,'Integer','',NULL,'',NULL),(4398,'arcompany','current_or_order',5,'Integer','',NULL,'',NULL),(4399,'arcompany','default_checkacctid',11,'Integer','',NULL,'',NULL),(4400,'arcompany','nobarcode_on_invoice',5,'Integer','',NULL,'',NULL),(4401,'arcompany','picklist_blockheader',5,'Integer','',NULL,'',NULL),(4402,'arcompany','picklist_blockbarcode',5,'Integer','',NULL,'',NULL),(4403,'arcompany','picklist_sortorder',5,'Integer','',NULL,'',NULL),(4404,'arcompany','pickliststyle',5,'Integer','',NULL,'',NULL),(4405,'arcompany','noboxes_on_invoice',5,'Integer','',NULL,'',NULL),(4406,'arcompany','comparison_levelid',11,'Integer','',NULL,'',NULL),(4407,'arcompany','statement_no_prior_balance',5,'Integer','',NULL,'',NULL),(4408,'arcompany','statement_no_interest_added',5,'Integer','',NULL,'',NULL),(4409,'arcompany','ardate',5,'Integer','',NULL,'',NULL),(4410,'arcompany','noteatbottom',5,'Integer','',NULL,'',NULL),(4411,'arcompany','internal_serviceorder',5,'Integer','',NULL,'',NULL),(4412,'arcompany','internal_fulfillmentorder',5,'Integer','',NULL,'',NULL),(4413,'arcompany','invoicenumber_override',5,'Integer','',NULL,'',NULL),(4414,'arinvoice','client_po',30,'Text','',NULL,'',NULL),(4415,'arinvoicedetail','pricelevelid',11,'Integer','',NULL,'',NULL),(4416,'arinvoicepaymentdetail','refund_paymeth',11,'Integer','',NULL,'',NULL),(4417,'arinvoicepaymentdetail','cctransactionid',11,'Integer','',NULL,'',NULL),(4418,'arinvoicetaxdetail','taxcap',21,'Numeric','',NULL,'',NULL),(4419,'arorder','carrierserviceid_preferred',11,'Integer','',NULL,'',NULL),(4420,'arorder','finalship',5,'Integer','',NULL,'',NULL),(4421,'arorder_deposit','checkid',20,'Text','',NULL,'',NULL),(4422,'arorder_deposit','bankstatement_enddate',10,'Date','',NULL,'',NULL),(4423,'arorder_deposit','checkacctid',11,'Integer','',NULL,'',NULL),(4424,'arorderdetail','pricelevelid',11,'Integer','',NULL,'',NULL),(4425,'arordership','cancel',5,'Integer','',NULL,'multiple',NULL),(4426,'arordership','canceldate',10,'Date','',NULL,'',NULL),(4427,'arordership','canceluserid',11,'Integer','',NULL,'',NULL),(4428,'arordershippackage','cancel',5,'Integer','',NULL,'multiple',NULL),(4429,'arordershippackage','canceldate',10,'Date','',NULL,'',NULL),(4430,'arordershippackage','canceluserid',11,'Integer','',NULL,'',NULL),(4431,'arordertax','taxcap',21,'Numeric','',NULL,'',NULL),(4432,'arserviceorder_prepaid_time','id',11,'Integer','',NULL,'primary',NULL),(4433,'arserviceorder_prepaid_time','hours',14,'Numeric','',NULL,'',NULL),(4434,'arserviceorder_prepaid_time','hours_used',14,'Numeric','',NULL,'',NULL),(4435,'arserviceorder_prepaid_time','complete',5,'Integer','',NULL,'',NULL),(4436,'arserviceorder_prepaid_time','worktypeid',11,'Integer','',NULL,'multiple',NULL),(4437,'arserviceorder_prepaid_time','orderid',11,'Integer','',NULL,'multiple',NULL),(4438,'arserviceorder_prepaid_time','rate_per_hour',18,'Numeric','',NULL,'',NULL),(4439,'arserviceorder_prepaid_time','total_price',18,'Numeric','',NULL,'',NULL),(4440,'arserviceorder_prepaid_time','entrydate',10,'Date','',NULL,'',NULL),(4441,'arserviceorder_prepaid_time','entryuserid',11,'Integer','',NULL,'',NULL),(4442,'arserviceorder_prepaid_time','lastchangedate',19,'DateTime','',NULL,'',NULL),(4443,'arserviceorder_prepaid_time','lastchangeuserid',11,'Integer','',NULL,'',NULL),(4444,'arserviceorder_prepaid_time','cancel',5,'Integer','',NULL,'multiple',NULL),(4445,'arserviceorder_prepaid_time','canceluserid',11,'Integer','',NULL,'',NULL),(4446,'arserviceorder_prepaid_time','workclassid',11,'Integer','',NULL,'',NULL),(4447,'bankaccount','prtype',5,'Integer','',NULL,'multiple',NULL),(4448,'bankaccount','recordid',11,'Integer','',NULL,'multiple',NULL),(4449,'bankaccount','show_employeename',5,'Integer','',NULL,'',NULL),(4450,'bankaccount','show_ss',5,'Integer','',NULL,'',NULL),(4451,'bankaccount','show_dates',5,'Integer','',NULL,'',NULL),(4452,'bankaccount','show_employer',5,'Integer','',NULL,'',NULL),(4453,'bankaccount','include_contribution',5,'Integer','',NULL,'',NULL),(4454,'bankaccount','summary_deposit',5,'Integer','',NULL,'',NULL),(4455,'bankaccount','show_other',255,'Text','',NULL,'',NULL),(4456,'bankaccount','dd_or_check',5,'Integer','',NULL,'',NULL),(4457,'bankdeposit','voucherid',11,'Integer','',NULL,'',NULL),(4458,'carrierservice','not_on_b2b',5,'Integer','',NULL,'',NULL),(4459,'carrierservice','onquote',5,'Integer','',NULL,'',NULL),(4460,'cashpayment','checkacctid',11,'Integer','',NULL,'',NULL),(4461,'ccaccount','checkacctid',11,'Integer','',NULL,'',NULL),(4462,'ccpurchase','id',11,'Integer','',NULL,'primary',NULL),(4463,'ccpurchase','ccvendorid',11,'Integer','',NULL,'multiple',NULL),(4464,'ccpurchase','purchasedate',10,'Date','',NULL,'multiple',NULL),(4465,'ccpurchase','who',100,'Text','',NULL,'',NULL),(4466,'ccpurchase','amount',21,'Numeric','',NULL,'',NULL),(4467,'ccpurchase','purpose',250,'Text','',NULL,'',NULL),(4468,'ccpurchase','apbillid',11,'Integer','',NULL,'',NULL),(4469,'ccpurchase','cancel',5,'Integer','',NULL,'multiple',NULL),(4470,'ccpurchase','canceluserid',11,'Integer','',NULL,'',NULL),(4471,'ccpurchase','canceldate',19,'DateTime','',NULL,'',NULL),(4472,'ccpurchase','lastupdatedate',19,'DateTime','',NULL,'',NULL),(4473,'ccpurchase','lastupdateuserid',11,'Integer','',NULL,'',NULL),(4474,'ccpurchase','purchasefrom',100,'Text','',NULL,'',NULL),(4475,'ccpurchase','invpoid',11,'Integer','',NULL,'',NULL),(4476,'ccpurchase_detail','id',11,'Integer','',NULL,'primary',NULL),(4477,'ccpurchase_detail','ccpurchaseid',11,'Integer','',NULL,'multiple',NULL),(4478,'ccpurchase_detail','glaccountid',11,'Integer','',NULL,'',NULL),(4479,'ccpurchase_detail','chargetype',5,'Integer','',NULL,'',NULL),(4480,'ccpurchase_detail','voucherid',11,'Integer','',NULL,'',NULL),(4481,'ccpurchase_detail','amount',21,'Numeric','',NULL,'',NULL),(4482,'ccpurchase_detail','cancel',5,'Integer','',NULL,'multiple',NULL),(4483,'ccpurchase_detail','canceldate',10,'Date','',NULL,'',NULL),(4484,'ccpurchase_detail','canceluserid',11,'Integer','',NULL,'',NULL),(4485,'ccpurchase_detail','glcontraid',11,'Integer','',NULL,'',NULL),(4486,'ccpurchase_gen','id',11,'Integer','',NULL,'primary',NULL),(4487,'ccpurchase_gen','useforpo',5,'Integer','',NULL,'',NULL),(4488,'ccpurchase_gen','freight_chargetype',11,'Integer','',NULL,'',NULL),(4489,'ccpurchase_gen','tax_chargetype',11,'Integer','',NULL,'',NULL),(4490,'ccpurchase_gen','default_po_chargetype',11,'Integer','',NULL,'',NULL),(4491,'ccpurchase_type','id',11,'Integer','',NULL,'primary',NULL),(4492,'ccpurchase_type','glaccountid',11,'Integer','',NULL,'multiple',NULL),(4493,'ccpurchase_type','gencompanyid',11,'Integer','',NULL,'',NULL),(4494,'ccpurchase_type','description',250,'Text','',NULL,'',NULL),(4495,'ccpurchase_type','cancel',5,'Integer','',NULL,'multiple',NULL),(4496,'ccpurchase_type','canceluserid',11,'Integer','',NULL,'',NULL),(4497,'ccpurchase_type','canceldate',19,'DateTime','',NULL,'',NULL),(4498,'ccpurchase_type','lastupdatedate',19,'DateTime','',NULL,'',NULL),(4499,'ccpurchase_type','lastupdateuserid',11,'Integer','',NULL,'',NULL),(4500,'ccpurchase_type','salestaxid',11,'Integer','',NULL,'',NULL),(4501,'ccpurchase_type','glcontraid',11,'Integer','',NULL,'',NULL),(4502,'ccvendor','id',11,'Integer','',NULL,'primary',NULL),(4503,'ccvendor','vendorid',11,'Integer','',NULL,'multiple',NULL),(4504,'ccvendor','ccname',250,'Text','',NULL,'',NULL),(4505,'ccvendor','cancel',5,'Integer','',NULL,'multiple',NULL),(4506,'ccvendor','canceluserid',11,'Integer','',NULL,'',NULL),(4507,'ccvendor','canceldate',19,'DateTime','',NULL,'',NULL),(4508,'ccvendor','lastupdatedate',19,'DateTime','',NULL,'',NULL),(4509,'ccvendor','lastupdateuserid',11,'Integer','',NULL,'',NULL),(4510,'chk','maincheckid',11,'Integer','',NULL,'multiple',NULL),(4511,'customer','salescategoryid',11,'Integer','',NULL,'',NULL),(4512,'customer','weather_cf',1,'Text','',NULL,'',NULL),(4513,'customer','weather_zip',20,'Text','',NULL,'',NULL),(4514,'customer','time_zone',6,'Text','',NULL,'',NULL),(4515,'customer','salutation',20,'Text','',NULL,'',NULL),(4516,'customer','middle_name',50,'Text','',NULL,'',NULL),(4517,'customer','name_suffix',20,'Text','',NULL,'',NULL),(4518,'estquotebinderyaddl','printdays',11,'Integer','',NULL,'',NULL),(4519,'estquotepriceliststock','qtyperbox',11,'Integer','',NULL,'',NULL),(4520,'estquotequote','printdate',10,'Date','',NULL,'',NULL),(4521,'estquotequote','calculated_qty',14,'Numeric','',NULL,'',NULL),(4522,'estquotequote','sell_total',14,'Numeric','',NULL,'',NULL),(4523,'estquotequote','calculated_total',16,'Numeric','',NULL,'',NULL),(4524,'estquotequote','previous_id_printorder',11,'Integer','',NULL,'',NULL),(4525,'estquotequote','client_notes',65535,'X','',NULL,'',NULL),(4526,'estquotequoteqty','printdays',11,'Integer','',NULL,'',NULL),(4527,'estquoteship','shipper_number',30,'Text','',NULL,'',NULL),(4528,'estquoteship','billto',20,'Text','',NULL,'',NULL),(4529,'event','id',10,'Integer','',NULL,'primary',NULL),(4530,'event','module',10,'Text','',NULL,'multiple',NULL),(4531,'event','section',50,'Text','',NULL,'multiple',NULL),(4532,'event','action',50,'Text','',NULL,'multiple',NULL),(4533,'event','link',255,'Text','',NULL,'',NULL),(4534,'eventlog','id',10,'Integer','',NULL,'primary',NULL),(4535,'eventlog','companyid',11,'Integer','',NULL,'multiple',NULL),(4536,'eventlog','userid',11,'Integer','',NULL,'multiple',NULL),(4537,'eventlog','extuserid',11,'Integer','',NULL,'multiple',NULL),(4538,'eventlog','module',10,'Text','',NULL,'multiple',NULL),(4539,'eventlog','section',50,'Text','',NULL,'multiple',NULL),(4540,'eventlog','action',50,'Text','',NULL,'multiple',NULL),(4541,'eventlog','eventtable',100,'Text','',NULL,'multiple',NULL),(4542,'eventlog','eventid',10,'Integer','',NULL,'multiple',NULL),(4543,'eventlog','data',65535,'X','',NULL,'',NULL),(4544,'eventlog','entrydate',19,'DateTime','',NULL,'multiple',NULL),(4545,'eventlog','ip',20,'Text','',NULL,'',NULL),(4546,'family','workarea_order',11,'Integer','',NULL,'',NULL),(4547,'family','scrapperplate',11,'Integer','',NULL,'',NULL),(4548,'family','scrappercent',22,'Numeric','',NULL,'',NULL),(4549,'family','minimum_charge',14,'Numeric','',NULL,'',NULL),(4550,'feature','id',10,'Integer','',NULL,'primary',NULL),(4551,'feature','name',45,'Text','',NULL,'',NULL),(4552,'feature','description_short',100,'Text','',NULL,'',NULL),(4553,'feature','description',255,'Text','',NULL,'',NULL),(4554,'feature','display',11,'Integer','',NULL,'',NULL),(4555,'feature','ecomid',11,'Integer','',NULL,'',NULL),(4556,'feature','version',25,'Text','',NULL,'',NULL),(4557,'feature_activation','id',10,'Integer','',NULL,'primary',NULL),(4558,'feature_activation','featureid',10,'Integer','',NULL,'multiple',NULL),(4559,'feature_activation','serial_number',50,'Text','',NULL,'',NULL),(4560,'feature_activation','entrydate',19,'DateTime','',NULL,'',NULL),(4561,'feature_activation','code',50,'Text','',NULL,'',NULL),(4562,'fileitem','b2buserid',11,'Integer','',NULL,'multiple',NULL),(4563,'flexfield','id',10,'Integer','',NULL,'primary',NULL),(4564,'flexfield','tablename',100,'Text','',NULL,'multiple',NULL),(4565,'flexfield','displayname',100,'Text','',NULL,'',NULL),(4566,'flexfield','fieldtype',1,'Text','',NULL,'',NULL),(4567,'flexfield','sortorder',10,'Integer','',NULL,'',NULL),(4568,'flexfield','internalname',100,'Text','',NULL,'multiple',NULL),(4569,'flexfield','defaultvalue',255,'Text','',NULL,'',NULL),(4570,'flexfield','companyid',11,'Integer','',NULL,'',NULL),(4571,'flexfield','readonly',5,'Integer','',NULL,'',NULL),(4572,'flexfield','donotimport',5,'Integer','',NULL,'',NULL),(4573,'flexoption','id',10,'Integer','',NULL,'primary',NULL),(4574,'flexoption','flexfieldid',10,'Integer','',NULL,'multiple',NULL),(4575,'flexoption','name',100,'Text','',NULL,'',NULL),(4576,'flexoption','value',255,'Text','',NULL,'',NULL),(4577,'flexoption','sortorder',10,'Integer','',NULL,'',NULL),(4578,'flextable','id',10,'Integer','',NULL,'primary',NULL),(4579,'flextable','name',100,'Text','',NULL,'',NULL),(4580,'flextable','tablename',100,'Text','',NULL,'',NULL),(4581,'flexvalue','id',10,'Integer','',NULL,'primary',NULL),(4582,'flexvalue','flexfieldid',10,'Integer','',NULL,'multiple',NULL),(4583,'flexvalue','recordid',10,'Integer','',NULL,'multiple',NULL),(4584,'flexvalue','value',255,'Text','',NULL,'',NULL),(4585,'four51trans','id',10,'Integer','',NULL,'primary',NULL),(4586,'four51trans','xmlrequest',65535,'X','',NULL,'',NULL),(4587,'four51trans','xmlresponse',65535,'X','',NULL,'',NULL),(4588,'four51trans','entrydate',19,'DateTime','',NULL,'',NULL),(4589,'four51trans','status',11,'Integer','',NULL,'',NULL),(4590,'four51trans','orderid',11,'Integer','',NULL,'multiple',NULL),(4591,'four51trans','customerid',11,'Integer','',NULL,'multiple',NULL),(4592,'four51trans','transtype',1,'Text','',NULL,'',NULL),(4593,'four51trans','responsetext',255,'Text','',NULL,'',NULL),(4594,'gencompany','ar_email',50,'Text','',NULL,'',NULL),(4595,'gencompany','order_email',50,'Text','',NULL,'',NULL),(4596,'gencompany','ap_email',50,'Text','',NULL,'',NULL),(4597,'gencompany','businesstype',100,'Text','',NULL,'',NULL),(4598,'gencompany','print_only_orders',5,'Integer','',NULL,'',NULL),(4599,'gencompany','arship_shortform',5,'Integer','',NULL,'',NULL),(4600,'genprint','extrafield1_desc',255,'Text','',NULL,'',NULL),(4601,'genprint','extrafield2_desc',255,'Text','',NULL,'',NULL),(4602,'genprint','extrafield3_desc',255,'Text','',NULL,'',NULL),(4603,'genprint','extrafield4_desc',255,'Text','',NULL,'',NULL),(4604,'genprint','jobticket_notes',65535,'X','',NULL,'',NULL),(4605,'genprint','askink',5,'Integer','',NULL,'',NULL),(4606,'genprint','whichinvoicedate',5,'Integer','',NULL,'',NULL),(4607,'genuser','weather_cf',1,'Text','',NULL,'',NULL),(4608,'genuser','menu_style',5,'Integer','',NULL,'',NULL),(4609,'genuser','iconset',10,'Text','',NULL,'',NULL),(4610,'genuser','apikey',50,'Text','',NULL,'',NULL),(4611,'genuser','timeclock_only',5,'Integer','',NULL,'',NULL),(4612,'genuser','ipfilter',255,'Text','',NULL,'',NULL),(4613,'genuser','splashdate',19,'DateTime','',NULL,'',NULL),(4614,'genuser','defaulthomepage',30,'Text','',NULL,'',NULL),(4615,'genusercompany','edit_messages',5,'Integer','',NULL,'',NULL),(4616,'genusercompany','pos_only',11,'Integer','',NULL,'',NULL),(4617,'glaccount','old_id',20,'Text','',NULL,'',NULL),(4618,'hints','id',11,'Integer','',NULL,'primary',NULL),(4619,'hints','notes',65535,'X','',NULL,'',NULL),(4620,'hints','question',255,'Text','',NULL,'',NULL),(4621,'invcompany','costmethod',1,'Text','',NULL,'',NULL),(4622,'invcompany','inventoryvariance',11,'Integer','',NULL,'',NULL),(4623,'invcompany','addglatpo',11,'Integer','',NULL,'',NULL),(4624,'invcompany','distributetaxfreight',11,'Integer','',NULL,'',NULL),(4625,'invcompany','breakdown_scrap',5,'Integer','',NULL,'',NULL),(4626,'invcompany','costadjustglacctid',11,'Integer','',NULL,'',NULL),(4627,'invintercompany','id',11,'Integer','',NULL,'primary',NULL),(4628,'invintercompany','sourcecompanyid',11,'Integer','',NULL,'multiple',NULL),(4629,'invintercompany','othercompanyid',11,'Integer','',NULL,'multiple',NULL),(4630,'invintercompany','customerid',11,'Integer','',NULL,'',NULL),(4631,'invintercompany','vendorid',11,'Integer','',NULL,'',NULL),(4632,'invintercompany','pricelevelid',11,'Integer','',NULL,'',NULL),(4633,'invpo','paytermsid',11,'Integer','',NULL,'',NULL),(4634,'invpo','ccpurchaseid',11,'Integer','',NULL,'multiple',NULL),(4635,'invpodetail','notes',500,'Text','',NULL,'',NULL),(4636,'item','scart_front_page',11,'Integer','',NULL,'',NULL),(4637,'item','caliper',12,'Numeric','',NULL,'',NULL),(4638,'item','upc',255,'Text','',NULL,'',NULL),(4639,'item','author',100,'Text','',NULL,'',NULL),(4640,'item','notes',65535,'X','',NULL,'',NULL),(4641,'itemlocation','wacost',21,'Numeric','',NULL,'',NULL),(4642,'itemlocation','waqty',22,'Numeric','',NULL,'',NULL),(4643,'itemlocation','bin_shelf',50,'Text','',NULL,'',NULL),(4644,'lang','custom',2,'Integer','',NULL,'',NULL),(4645,'lang','ar',255,'Text','',NULL,'',NULL),(4646,'lang','ms',255,'Text','',NULL,'',NULL),(4647,'lang','hi',255,'Text','',NULL,'',NULL),(4648,'lang','th',255,'Text','',NULL,'',NULL),(4649,'lang','tl',255,'Text','',NULL,'',NULL),(4650,'lang','it',255,'Text','',NULL,'',NULL),(4651,'lang','sv',255,'Text','',NULL,'',NULL),(4652,'lang','zh',255,'Text','',NULL,'',NULL),(4653,'lang','el',255,'Text','',NULL,'',NULL),(4654,'lang','he',255,'Text','',NULL,'',NULL),(4655,'lang','ko',255,'Text','',NULL,'',NULL),(4656,'lang','da',255,'Text','',NULL,'',NULL),(4657,'lang','no',255,'Text','',NULL,'',NULL),(4658,'lang','fi',255,'Text','',NULL,'',NULL),(4659,'lang','nl',255,'Text','',NULL,'',NULL),(4660,'lang','ba',255,'Text','',NULL,'',NULL),(4661,'lang','si',255,'Text','',NULL,'',NULL),(4662,'langfield','pt',65535,'X','',NULL,'',NULL),(4663,'langfield','fr',65535,'X','',NULL,'',NULL),(4664,'langfield','zh',65535,'X','',NULL,'',NULL),(4665,'langfield','ar',65535,'X','',NULL,'',NULL),(4666,'langfield','ms',65535,'X','',NULL,'',NULL),(4667,'langfield','hi',65535,'X','',NULL,'',NULL),(4668,'langfield','th',65535,'X','',NULL,'',NULL),(4669,'langfield','tl',65535,'X','',NULL,'',NULL),(4670,'langfield','it',65535,'X','',NULL,'',NULL),(4671,'langfield','sv',65535,'X','',NULL,'',NULL),(4672,'langfield','el',65535,'X','',NULL,'',NULL),(4673,'langfield','he',65535,'X','',NULL,'',NULL),(4674,'langfield','ko',65535,'X','',NULL,'',NULL),(4675,'langfield','da',65535,'X','',NULL,'',NULL),(4676,'langfield','no',65535,'X','',NULL,'',NULL),(4677,'langfield','fi',65535,'X','',NULL,'',NULL),(4678,'langfield','nl',65535,'X','',NULL,'',NULL),(4679,'langfield','ba',65535,'X','',NULL,'',NULL),(4680,'langfield','si',65535,'X','',NULL,'',NULL),(4681,'menudata','gencompanyid',11,'Integer','',NULL,'',NULL),(4682,'menudata','groupname',15,'Text','',NULL,'',NULL),(4683,'menudataxp','id',11,'Integer','',NULL,'primary',NULL),(4684,'menudataxp','menu_name',100,'Text','',NULL,'',NULL),(4685,'menudataxp','id_menudata',11,'Integer','',NULL,'',NULL),(4686,'menudataxp','orderflag',5,'Integer','',NULL,'',NULL),(4687,'menudataxp','menu_action',2,'Integer','',NULL,'',NULL),(4688,'menudataxp','description',250,'Text','',NULL,'',NULL),(4689,'menudataxp','accessap',2,'Integer','',NULL,'',NULL),(4690,'menudataxp','accessar',2,'Integer','',NULL,'',NULL),(4691,'menudataxp','accessgl',2,'Integer','',NULL,'',NULL),(4692,'menudataxp','accesspay',2,'Integer','',NULL,'',NULL),(4693,'menudataxp','accessinv',2,'Integer','',NULL,'',NULL),(4694,'menudataxp','accessest',2,'Integer','',NULL,'',NULL),(4695,'menudataxp','accessfix',2,'Integer','',NULL,'',NULL),(4696,'menudataxp','accessimp',2,'Integer','',NULL,'',NULL),(4697,'menudataxp','accesssc',2,'Integer','',NULL,'',NULL),(4698,'menudataxp','setupap',2,'Integer','',NULL,'',NULL),(4699,'menudataxp','setupar',2,'Integer','',NULL,'',NULL),(4700,'menudataxp','setupgl',2,'Integer','',NULL,'',NULL),(4701,'menudataxp','setuppay',2,'Integer','',NULL,'',NULL),(4702,'menudataxp','setupinv',2,'Integer','',NULL,'',NULL),(4703,'menudataxp','setupest',2,'Integer','',NULL,'',NULL),(4704,'menudataxp','setupfix',2,'Integer','',NULL,'',NULL),(4705,'menudataxp','setupimp',2,'Integer','',NULL,'',NULL),(4706,'menudataxp','setupsc',2,'Integer','',NULL,'',NULL),(4707,'menudataxp','supervisor',2,'Integer','',NULL,'',NULL),(4708,'menudataxp','extvend',2,'Integer','',NULL,'',NULL),(4709,'menudataxp','extcust',2,'Integer','',NULL,'',NULL),(4710,'menudataxp','nonext',2,'Integer','',NULL,'',NULL),(4711,'menudataxp','menu_link',255,'Text','',NULL,'',NULL),(4712,'menudataxp','linktype',11,'Text','',NULL,'',NULL),(4713,'menudataxp','plaintext',11,'Text','',NULL,'',NULL),(4714,'menudataxp','languageid',2,'Integer','',NULL,'',NULL),(4715,'menudataxp','icon',255,'Text','',NULL,'',NULL),(4716,'menudataxp','gencompanyid',11,'Integer','',NULL,'',NULL),(4717,'menudataxp','groupname',15,'Text','',NULL,'',NULL),(4718,'message','messageid',11,'Integer','',NULL,'primary',NULL),(4719,'message','createuserid',11,'Integer','',NULL,'',NULL),(4720,'message','userid',11,'Integer','',NULL,'',NULL),(4721,'message','createdate',19,'DateTime','',NULL,'',NULL),(4722,'message','title',100,'Text','',NULL,'',NULL),(4723,'message','message',65535,'X','',NULL,'',NULL),(4724,'message','homepage',5,'Integer','',NULL,'',NULL),(4725,'message','fontcolor',25,'Text','',NULL,'',NULL),(4726,'message','graphicid',11,'Integer','',NULL,'',NULL),(4727,'message','startdate',19,'DateTime','',NULL,'',NULL),(4728,'message','enddate',19,'DateTime','',NULL,'',NULL),(4729,'message','cancel',5,'Integer','',NULL,'multiple',NULL),(4730,'message','canceluserid',11,'Integer','',NULL,'',NULL),(4731,'message','banner_interval',25,'Text','',NULL,'',NULL),(4732,'message','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(4733,'message_graphic','id',11,'Integer','',NULL,'primary',NULL),(4734,'message_graphic','name',100,'Text','',NULL,'',NULL),(4735,'message_graphic','graphiccategoryid',11,'Integer','',NULL,'',NULL),(4736,'message_graphic','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(4737,'message_graphic','description',100,'Text','',NULL,'',NULL),(4738,'message_graphic','cancel',5,'Integer','',NULL,'',NULL),(4739,'message_graphic','createdate',19,'DateTime','',NULL,'',NULL),(4740,'message_graphic','userid',11,'Integer','',NULL,'',NULL),(4741,'message_graphiccategory','id',11,'Integer','',NULL,'primary',NULL),(4742,'message_graphiccategory','name',100,'Text','',NULL,'',NULL),(4743,'message_graphiccategory','description',100,'Text','',NULL,'',NULL),(4744,'message_graphiccategory','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(4745,'message_graphiccategory','cancel',5,'Integer','',NULL,'multiple',NULL),(4746,'note','id',11,'Integer','',NULL,'primary',NULL),(4747,'note','notetypeid',11,'Integer','',NULL,'multiple',NULL),(4748,'note','recordid',11,'Integer','',NULL,'multiple',NULL),(4749,'note','note',65535,'X','',NULL,'',NULL),(4750,'note','companyid',11,'Integer','',NULL,'multiple',NULL),(4751,'note','entrydate',19,'DateTime','',NULL,'',NULL),(4752,'note','entryuserid',11,'Integer','',NULL,'multiple',NULL),(4753,'note','cancel',11,'Integer','',NULL,'',NULL),(4754,'note','canceldate',19,'DateTime','',NULL,'',NULL),(4755,'note','canceluserid',11,'Integer','',NULL,'',NULL),(4756,'notetype','id',11,'Integer','',NULL,'primary',NULL),(4757,'notetype','code',100,'Text','',NULL,' unique',NULL),(4758,'notetype','title',255,'Text','',NULL,'',NULL),(4759,'notetype','description',65535,'X','',NULL,'',NULL),(4760,'notetype','modaccess',150,'Text','',NULL,'',NULL),(4761,'notetype','modbit',20,'Text','',NULL,'',NULL),(4762,'npdb','id',10,'Integer','',NULL,'primary',NULL),(4763,'npdb','name',150,'Text','',NULL,'',NULL),(4764,'npdb','dbname',50,'Text','',NULL,'',NULL),(4765,'npdb','domainname',255,'Text','',NULL,'',NULL),(4766,'npdb','entrydate',19,'DateTime','',NULL,'',NULL),(4767,'npdb','serialnumber',45,'Text','',NULL,'',NULL),(4768,'npdb','codenumber',45,'Text','',NULL,'',NULL),(4769,'npdb','cancel',11,'Integer','',NULL,'',NULL),(4770,'npdb','canceldate',19,'DateTime','',NULL,'',NULL),(4771,'npdb','masterlicense',16,'Text','',NULL,'',NULL),(4772,'order_actual','invoiceid',11,'Integer','',NULL,'',NULL),(4773,'order_partnr','caliper',12,'Numeric','',NULL,'',NULL),(4774,'order_partnr','order_date',10,'Date','',NULL,'',NULL),(4775,'order_partnr','order_by',11,'Integer','',NULL,'',NULL),(4776,'order_partnr','receive_date',10,'Date','',NULL,'',NULL),(4777,'order_partnr','received_by',11,'Integer','',NULL,'',NULL),(4778,'order_shipment','invoiceid',11,'Integer','',NULL,'',NULL),(4779,'personal_message','id',11,'Integer','',NULL,'primary',NULL),(4780,'personal_message','messageid',11,'Integer','',NULL,'',NULL),(4781,'personal_message','userid',11,'Integer','',NULL,'multiple',NULL),(4782,'personal_message','receiveddate',19,'DateTime','',NULL,'',NULL),(4783,'personal_message','received',5,'Integer','',NULL,'',NULL),(4784,'personal_message','gencompanyid',11,'Integer','',NULL,'',NULL),(4785,'personal_message','cancel',5,'Integer','',NULL,'multiple',NULL),(4786,'piecework_addlrates','id',11,'Integer','',NULL,'primary unique',NULL),(4787,'piecework_addlrates','piecework_functionid',11,'Integer','',NULL,'multiple',NULL),(4788,'piecework_addlrates','piecework_function_detailid',11,'Integer','',NULL,'multiple',NULL),(4789,'piecework_addlrates','rate',17,'Numeric','',NULL,'',NULL),(4790,'piecework_addlrates','sortorder',11,'Integer','',NULL,'',NULL),(4791,'piecework_areas','id',11,'Integer','',NULL,'primary',NULL),(4792,'piecework_areas','name',50,'Text','',NULL,'',NULL),(4793,'piecework_areas','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(4794,'piecework_areas','cancel',5,'Integer','',NULL,'multiple',NULL),(4795,'piecework_areas','canceldate',19,'DateTime','',NULL,'',NULL),(4796,'piecework_areas','canceluserid',11,'Integer','',NULL,'',NULL),(4797,'piecework_areas','entrydate',19,'DateTime','',NULL,'',NULL),(4798,'piecework_areas','entryuserid',11,'Integer','',NULL,'',NULL),(4799,'piecework_areas','lastchangedate',19,'DateTime','',NULL,'',NULL),(4800,'piecework_areas','lastchangeuserid',11,'Integer','',NULL,'',NULL),(4801,'piecework_areas','sortorder',5,'Integer','',NULL,'',NULL),(4802,'piecework_function_detail','id',11,'Integer','',NULL,'primary',NULL),(4803,'piecework_function_detail','id_piecework_functions',11,'Integer','',NULL,'multiple',NULL),(4804,'piecework_function_detail','entrytype',2,'Integer','',NULL,'',NULL),(4805,'piecework_function_detail','rate',17,'Numeric','',NULL,'',NULL),(4806,'piecework_function_detail','minimum',17,'Numeric','',NULL,'',NULL),(4807,'piecework_function_detail','cancel',5,'Integer','',NULL,'multiple',NULL),(4808,'piecework_function_detail','canceldate',19,'DateTime','',NULL,'',NULL),(4809,'piecework_function_detail','canceluserid',11,'Integer','',NULL,'',NULL),(4810,'piecework_function_detail','entrydate',19,'DateTime','',NULL,'',NULL),(4811,'piecework_function_detail','entryuserid',11,'Integer','',NULL,'',NULL),(4812,'piecework_function_detail','lastchangedate',19,'DateTime','',NULL,'',NULL),(4813,'piecework_function_detail','lastchangeuserid',11,'Integer','',NULL,'',NULL),(4814,'piecework_function_detail','sortorder',5,'Integer','',NULL,'',NULL),(4815,'piecework_function_detail','prompt',50,'Text','',NULL,'',NULL),(4816,'piecework_function_detail','dividing_quantity_for_rate',11,'Integer','',NULL,'',NULL),(4817,'piecework_function_detail','user_rate_requires_explanation',5,'Integer','',NULL,'',NULL),(4818,'piecework_function_detail','allow_user_rate',5,'Integer','',NULL,'',NULL),(4819,'piecework_function_detail','calc_how',5,'Integer','',NULL,'',NULL),(4820,'piecework_function_detail_selection','id',11,'Integer','',NULL,'primary',NULL),(4821,'piecework_function_detail_selection','id_piecework_function_detail',11,'Integer','',NULL,'multiple',NULL),(4822,'piecework_function_detail_selection','description',50,'Text','',NULL,'',NULL),(4823,'piecework_function_detail_selection','rate',17,'Numeric','',NULL,'',NULL),(4824,'piecework_function_detail_selection','minimum',17,'Numeric','',NULL,'',NULL),(4825,'piecework_function_detail_selection','cancel',5,'Integer','',NULL,'multiple',NULL),(4826,'piecework_function_detail_selection','canceldate',19,'DateTime','',NULL,'',NULL),(4827,'piecework_function_detail_selection','canceluserid',11,'Integer','',NULL,'',NULL),(4828,'piecework_function_detail_selection','entrydate',19,'DateTime','',NULL,'',NULL),(4829,'piecework_function_detail_selection','entryuserid',11,'Integer','',NULL,'',NULL),(4830,'piecework_function_detail_selection','lastchangedate',19,'DateTime','',NULL,'',NULL),(4831,'piecework_function_detail_selection','lastchangeuserid',11,'Integer','',NULL,'',NULL),(4832,'piecework_function_detail_selection','sortorder',5,'Integer','',NULL,'',NULL),(4833,'piecework_functions','id',11,'Integer','',NULL,'primary',NULL),(4834,'piecework_functions','id_piecework_area',11,'Integer','',NULL,'multiple',NULL),(4835,'piecework_functions','description',50,'Text','',NULL,'',NULL),(4836,'piecework_functions','cancel',5,'Integer','',NULL,'multiple',NULL),(4837,'piecework_functions','canceldate',19,'DateTime','',NULL,'',NULL),(4838,'piecework_functions','canceluserid',11,'Integer','',NULL,'',NULL),(4839,'piecework_functions','entrydate',19,'DateTime','',NULL,'',NULL),(4840,'piecework_functions','entryuserid',11,'Integer','',NULL,'',NULL),(4841,'piecework_functions','lastchangedate',19,'DateTime','',NULL,'',NULL),(4842,'piecework_functions','lastchangeuserid',11,'Integer','',NULL,'',NULL),(4843,'piecework_functions','sortorder',5,'Integer','',NULL,'',NULL),(4844,'piecework_functions','ask_job',5,'Integer','',NULL,'',NULL),(4845,'piecework_functions','allow_nojob',5,'Integer','',NULL,'',NULL),(4846,'piecework_functions','ask_quantity',5,'Integer','',NULL,'',NULL),(4847,'piecework_functions','allow_user_rate',5,'Integer','',NULL,'',NULL),(4848,'piecework_functions','minimum',17,'Numeric','',NULL,'',NULL),(4849,'piecework_functions','user_rate_require_explanation',5,'Integer','',NULL,'',NULL),(4850,'piecework_functions','rate',17,'Numeric','',NULL,'',NULL),(4851,'piecework_functions','dividing_quantity_for_rate',11,'Integer','',NULL,'',NULL),(4852,'pradditionaltax','id',22,'Numeric','',NULL,'primary unique',NULL),(4853,'pradditionaltax','gencompanyid',22,'Numeric','',NULL,'',NULL),(4854,'pradditionaltax','abrev',3,'Text','',NULL,'',NULL),(4855,'pradditionaltax','name',30,'Text','',NULL,'',NULL),(4856,'pradditionaltax','taxnum',20,'Text','',NULL,'',NULL),(4857,'pradditionaltax','deductfed',11,'Integer','',NULL,'',NULL),(4858,'pradditionaltax','feddeductmax',21,'Numeric','',NULL,'',NULL),(4859,'pradditionaltax','exemptyr1',21,'Numeric','',NULL,'',NULL),(4860,'pradditionaltax','exemptyr2',21,'Numeric','',NULL,'',NULL),(4861,'pradditionaltax','exemptyr3',21,'Numeric','',NULL,'',NULL),(4862,'pradditionaltax','exemptyr4',21,'Numeric','',NULL,'',NULL),(4863,'pradditionaltax','glacctid',22,'Numeric','',NULL,'',NULL),(4864,'pradditionaltax','vendorid',22,'Numeric','',NULL,'',NULL),(4865,'pradditionaltax','maxexemptpercent',7,'Numeric','',NULL,'',NULL),(4866,'pradditionaltax','maxexemptyear',21,'Numeric','',NULL,'',NULL),(4867,'pradditionaltax','taxcreditexempt1',21,'Numeric','',NULL,'',NULL),(4868,'pradditionaltax','taxcreditexempt2',21,'Numeric','',NULL,'',NULL),(4869,'pradditionaltax','taxcreditexempt3',21,'Numeric','',NULL,'',NULL),(4870,'pradditionaltax','taxcreditexempt4',21,'Numeric','',NULL,'',NULL),(4871,'pradditionaltax','cancel',11,'Integer','',NULL,'',NULL),(4872,'pradditionaltax','canceldate',19,'DateTime','',NULL,'',NULL),(4873,'pradditionaltax','canceluserid',22,'Numeric','',NULL,'',NULL),(4874,'pradditionaltax','entrydate',19,'DateTime','',NULL,'',NULL),(4875,'pradditionaltax','entryuserid',22,'Numeric','',NULL,'',NULL),(4876,'pradditionaltax','lastchangedate',19,'DateTime','',NULL,'',NULL),(4877,'pradditionaltax','lastchangeuserid',22,'Numeric','',NULL,'',NULL),(4878,'pradditionaltax','round_tax',2,'Integer','',NULL,'',NULL),(4879,'pradditionaltax','mexemptyr1',21,'Numeric','',NULL,'',NULL),(4880,'pradditionaltax','mexemptyr2',21,'Numeric','',NULL,'',NULL),(4881,'pradditionaltax','mexemptyr3',21,'Numeric','',NULL,'',NULL),(4882,'pradditionaltax','mexemptyr4',21,'Numeric','',NULL,'',NULL),(4883,'pradditionaltax','jexemptyr1',21,'Numeric','',NULL,'',NULL),(4884,'pradditionaltax','jexemptyr2',21,'Numeric','',NULL,'',NULL),(4885,'pradditionaltax','jexemptyr3',21,'Numeric','',NULL,'',NULL),(4886,'pradditionaltax','jexemptyr4',21,'Numeric','',NULL,'',NULL),(4887,'pradditionaltax','hexemptyr1',21,'Numeric','',NULL,'',NULL),(4888,'pradditionaltax','hexemptyr2',21,'Numeric','',NULL,'',NULL),(4889,'pradditionaltax','hexemptyr3',21,'Numeric','',NULL,'',NULL),(4890,'pradditionaltax','hexemptyr4',21,'Numeric','',NULL,'',NULL),(4891,'pradditionaltax','hexemptyr0',21,'Numeric','',NULL,'',NULL),(4892,'pradditionaltax','mexemptyr0',21,'Numeric','',NULL,'',NULL),(4893,'pradditionaltax','jexemptyr0',21,'Numeric','',NULL,'',NULL),(4894,'pradditionaltax','exemptyr0',21,'Numeric','',NULL,'',NULL),(4895,'pradditionaltax','taxyear',4,'Integer','',NULL,'',NULL),(4896,'pradditionaltax','mainrec',11,'Integer','',NULL,'',NULL),(4897,'pradditionaltaxdetail','id',22,'Numeric','',NULL,'primary unique',NULL),(4898,'pradditionaltaxdetail','pradditionaltaxid',22,'Numeric','',NULL,'',NULL),(4899,'pradditionaltaxdetail','maritalstatus',11,'Integer','',NULL,'',NULL),(4900,'pradditionaltaxdetail','deductiontable',11,'Integer','',NULL,'',NULL),(4901,'pradditionaltaxdetail','tax',21,'Numeric','',NULL,'',NULL),(4902,'pradditionaltaxdetail','percent',10,'Numeric','',NULL,'',NULL),(4903,'pradditionaltaxdetail','over',21,'Numeric','',NULL,'',NULL),(4904,'prcity','taxyear',4,'Integer','',NULL,'',NULL),(4905,'prcity','mainrec',11,'Integer','',NULL,'',NULL),(4906,'prcompany','extrafield1_desc',255,'Text','',NULL,'',NULL),(4907,'prcompany','extrafield2_desc',255,'Text','',NULL,'',NULL),(4908,'prcompany','wc_vendorid',11,'Integer','',NULL,'',NULL),(4909,'prcompany','totalach',5,'Integer','',NULL,'',NULL),(4910,'prcompany','maxssn_digits',5,'Integer','',NULL,'',NULL),(4911,'prcompany','check_memoline',100,'Text','',NULL,'',NULL),(4912,'prempldeduction','vendorid',11,'Integer','',NULL,'',NULL),(4913,'premployee','extrafield1',255,'Text','',NULL,'',NULL),(4914,'premployee','extrafield2',255,'Text','',NULL,'',NULL),(4915,'premployee','timeclock_piecework',5,'Integer','',NULL,'',NULL),(4916,'premployee','timeclock_shift',5,'Integer','',NULL,'',NULL),(4917,'premployee','pensplanid3',22,'Numeric','',NULL,'',NULL),(4918,'premployee','pensplandedamount3',12,'Numeric','',NULL,'',NULL),(4919,'premployee','pensplanbase3',11,'Integer','',NULL,'',NULL),(4920,'premployee','pensplanid4',22,'Numeric','',NULL,'',NULL),(4921,'premployee','pensplandedamount4',12,'Numeric','',NULL,'',NULL),(4922,'premployee','pensplanbase4',11,'Integer','',NULL,'',NULL),(4923,'premployee','pensplanid5',22,'Numeric','',NULL,'',NULL),(4924,'premployee','pensplandedamount5',12,'Numeric','',NULL,'',NULL),(4925,'premployee','pensplanbase5',11,'Integer','',NULL,'',NULL),(4926,'premployee_addltaxes','id',11,'Integer','',NULL,'primary unique',NULL),(4927,'premployee_addltaxes','employeeid',11,'Integer','',NULL,'multiple',NULL),(4928,'premployee_addltaxes','pradditionaltaxid',11,'Integer','',NULL,'multiple',NULL),(4929,'premployee_addltaxes','exemptions',11,'Integer','',NULL,'',NULL),(4930,'premployee_addltaxes','cancel',5,'Integer','',NULL,'multiple',NULL),(4931,'premployee_addltaxes','canceldate',10,'Date','',NULL,'',NULL),(4932,'premployee_addltaxes','canceluserid',11,'Integer','',NULL,'',NULL),(4933,'premplweekdeddetail','vendorid',11,'Integer','',NULL,'',NULL),(4934,'premplweekdeddetail','bankaccountid',11,'Integer','',NULL,'',NULL),(4935,'premplweekdeddetail','dd_or_check',5,'Integer','',NULL,'',NULL),(4936,'premplweekdeddetail','checkid',11,'Integer','',NULL,'multiple',NULL),(4937,'premplweekpaydetail','categoryid',11,'Integer','',NULL,'',NULL),(4938,'premplweekpaydetail','comment',255,'Text','',NULL,'',NULL),(4939,'prfederal','eicmarriednopercent1',10,'Numeric','',NULL,'',NULL),(4940,'prfederal','eicmarriednoover1',21,'Numeric','',NULL,'',NULL),(4941,'prfederal','eicmarriednotax2',21,'Numeric','',NULL,'',NULL),(4942,'prfederal','eicmarriednoover2',21,'Numeric','',NULL,'',NULL),(4943,'prfederal','eicmarriednotax3',21,'Numeric','',NULL,'',NULL),(4944,'prfederal','eicmarriednopercent3',21,'Numeric','',NULL,'',NULL),(4945,'prfederal','eicmarriednoover3',21,'Numeric','',NULL,'',NULL),(4946,'prfederal','fui_vendorid',11,'Integer','',NULL,'',NULL),(4947,'prfederal','taxyear',4,'Integer','',NULL,'',NULL),(4948,'prfederal','mainrec',11,'Integer','',NULL,'',NULL),(4949,'printorder','reprint',5,'Integer','',NULL,'',NULL),(4950,'printorder','extrafield1',255,'Text','',NULL,'',NULL),(4951,'printorder','extrafield2',255,'Text','',NULL,'',NULL),(4952,'printorder','extrafield3',255,'Text','',NULL,'',NULL),(4953,'printorder','extrafield4',255,'Text','',NULL,'',NULL),(4954,'printorder','contactname',255,'Text','',NULL,'',NULL),(4955,'printorder','contactphone',255,'Text','',NULL,'',NULL),(4956,'printorder_shipto','shipfromname',255,'Text','',NULL,'',NULL),(4957,'printorder_shipto','shipfromaddress',255,'Text','',NULL,'',NULL),(4958,'printorder_shipto','shipfromaddress2',255,'Text','',NULL,'',NULL),(4959,'printorder_shipto','shipfromcity',50,'Text','',NULL,'',NULL),(4960,'printorder_shipto','shipfromstate',20,'Text','',NULL,'',NULL),(4961,'printorder_shipto','shipfromzip',15,'Text','',NULL,'',NULL),(4962,'prlocal','taxyear',4,'Integer','',NULL,'',NULL),(4963,'prlocal','mainrec',11,'Integer','',NULL,'',NULL),(4964,'prntax_category','id',11,'Integer','',NULL,'primary',NULL),(4965,'prntax_category','name',255,'Text','',NULL,'',NULL),(4966,'prntax_category','glaccountid',11,'Integer','',NULL,'multiple',NULL),(4967,'prntax_category','cancel',5,'Integer','',NULL,'multiple',NULL),(4968,'prntax_category','canceldate',10,'Date','',NULL,'',NULL),(4969,'prntax_category','canceluserid',11,'Integer','',NULL,'',NULL),(4970,'prntax_category','entrydate',19,'DateTime','',NULL,'',NULL),(4971,'prntax_category','entryuserid',11,'Integer','',NULL,'',NULL),(4972,'prntax_category','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(4973,'prntax_category','lastupdatedate',19,'DateTime','',NULL,'',NULL),(4974,'prntax_category','lastupdateuserid',11,'Integer','',NULL,'',NULL),(4975,'prntax_category','taxable',5,'Integer','',NULL,'',NULL),(4976,'project','id',11,'Integer','',NULL,'primary',NULL),(4977,'project','vendorid',11,'Integer','',NULL,'multiple',NULL),(4978,'project','projectname',255,'Text','',NULL,'',NULL),(4979,'project','customerid',11,'Integer','',NULL,'multiple',NULL),(4980,'project','project_templateid',11,'Integer','',NULL,'',NULL),(4981,'project','project_total',21,'Numeric','',NULL,'',NULL),(4982,'project','commission1_percent',6,'Numeric','',NULL,'',NULL),(4983,'project','commission1_vendorid',11,'Integer','',NULL,'',NULL),(4984,'project','commission2_percent',6,'Numeric','',NULL,'',NULL),(4985,'project','commission2_vendorid',11,'Integer','',NULL,'',NULL),(4986,'project','salestax1_id',11,'Integer','',NULL,'',NULL),(4987,'project','salestax1_percent',6,'Numeric','',NULL,'',NULL),(4988,'project','salestax1_glacctid',11,'Integer','',NULL,'',NULL),(4989,'project','salestax2_id',11,'Integer','',NULL,'',NULL),(4990,'project','salestax2_percent',6,'Numeric','',NULL,'',NULL),(4991,'project','salestax2_glacctid',11,'Integer','',NULL,'',NULL),(4992,'project','salestax3_id',11,'Integer','',NULL,'',NULL),(4993,'project','salestax3_percent',6,'Numeric','',NULL,'',NULL),(4994,'project','salestax3_glacctid',11,'Integer','',NULL,'',NULL),(4995,'project','othertax_name',20,'Text','',NULL,'',NULL),(4996,'project','othertax_percent',6,'Numeric','',NULL,'',NULL),(4997,'project','othertax_glacctid',11,'Integer','',NULL,'',NULL),(4998,'project','numweeks',5,'Integer','',NULL,'',NULL),(4999,'project','status',5,'Integer','',NULL,'multiple',NULL),(5000,'project','glacctid_income',11,'Integer','',NULL,'',NULL),(5001,'project','glacctid_cogs',11,'Integer','',NULL,'',NULL),(5002,'project','glacctid_commission1',11,'Integer','',NULL,'',NULL),(5003,'project','glacctid_commission2',11,'Integer','',NULL,'',NULL),(5004,'project','cancel',5,'Integer','',NULL,'multiple',NULL),(5005,'project','canceldate',19,'DateTime','',NULL,'',NULL),(5006,'project','canceluserid',11,'Integer','',NULL,'',NULL),(5007,'project','entrydate',19,'DateTime','',NULL,'',NULL),(5008,'project','entryuserid',11,'Integer','',NULL,'',NULL),(5009,'project','lastchangedate',19,'DateTime','',NULL,'',NULL),(5010,'project','lastchangeuserid',11,'Integer','',NULL,'',NULL),(5011,'project','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(5012,'project','voucherid',11,'Integer','',NULL,'',NULL),(5013,'project','othertax_client_percent',12,'Numeric','',NULL,'',NULL),(5014,'project','startdate',10,'Date','',NULL,'',NULL),(5015,'projectdetail','id',11,'Integer','',NULL,'primary',NULL),(5016,'projectdetail','projectid',11,'Integer','',NULL,'multiple',NULL),(5017,'projectdetail','description',255,'Text','',NULL,'',NULL),(5018,'projectdetail','description2',255,'Text','',NULL,'',NULL),(5019,'projectdetail','description3',255,'Text','',NULL,'',NULL),(5020,'projectdetail','amount',21,'Numeric','',NULL,'',NULL),(5021,'projectdetail','percent_of_total',6,'Numeric','',NULL,'',NULL),(5022,'projectdetail','salestax1_amount',21,'Numeric','',NULL,'',NULL),(5023,'projectdetail','salestax2_amount',21,'Numeric','',NULL,'',NULL),(5024,'projectdetail','salestax3_amount',21,'Numeric','',NULL,'',NULL),(5025,'projectdetail','othertax_amount',21,'Numeric','',NULL,'',NULL),(5026,'projectdetail','commission1_checkid',11,'Integer','',NULL,'multiple',NULL),(5027,'projectdetail','commission2_checkid',11,'Integer','',NULL,'multiple',NULL),(5028,'projectdetail','client_checkid',11,'Integer','',NULL,'multiple',NULL),(5029,'projectdetail','invoiceid',11,'Integer','',NULL,'multiple',NULL),(5030,'projectdetail','commission1_apbillid',11,'Integer','',NULL,'',NULL),(5031,'projectdetail','commission2_apbillid',11,'Integer','',NULL,'',NULL),(5032,'projectexpenses','id',11,'Integer','',NULL,'primary',NULL),(5033,'projectexpenses','projectid',11,'Integer','',NULL,'multiple',NULL),(5034,'projectexpenses','amount',21,'Numeric','',NULL,'',NULL),(5035,'projectexpenses','checkid',11,'Integer','',NULL,'multiple',NULL),(5036,'projectgen','id',11,'Integer','',NULL,'primary',NULL),(5037,'projectgen','default_checkacctid',11,'Integer','',NULL,'',NULL),(5038,'projectinvoice','id',11,'Integer','',NULL,'primary',NULL),(5039,'projectinvoice','projectid',11,'Integer','',NULL,'multiple',NULL),(5040,'projectinvoice','projectdetailid',11,'Integer','',NULL,'multiple',NULL),(5041,'projectinvoice','invoiceid',11,'Integer','',NULL,'multiple',NULL),(5042,'projectpayment','id',11,'Integer','',NULL,'primary',NULL),(5043,'projectpayment','checkid',11,'Integer','',NULL,'multiple',NULL),(5044,'projectpayment','projectid',11,'Integer','',NULL,'multiple',NULL),(5045,'projectpayment','projectdetailid',11,'Integer','',NULL,'multiple',NULL),(5046,'projecttemplate','id',11,'Integer','',NULL,'primary',NULL),(5047,'projecttemplate','templatename',255,'Text','',NULL,'',NULL),(5048,'projecttemplate','commission1_percent',6,'Numeric','',NULL,'',NULL),(5049,'projecttemplate','commission1_vendorid',11,'Integer','',NULL,'',NULL),(5050,'projecttemplate','commission2_percent',6,'Numeric','',NULL,'',NULL),(5051,'projecttemplate','commission2_vendorid',11,'Integer','',NULL,'',NULL),(5052,'projecttemplate','salestax1_id',11,'Integer','',NULL,'',NULL),(5053,'projecttemplate','salestax1_percent',6,'Numeric','',NULL,'',NULL),(5054,'projecttemplate','salestax1_glacctid',11,'Integer','',NULL,'',NULL),(5055,'projecttemplate','salestax2_id',11,'Integer','',NULL,'',NULL),(5056,'projecttemplate','salestax2_percent',6,'Numeric','',NULL,'',NULL),(5057,'projecttemplate','salestax2_glacctid',11,'Integer','',NULL,'',NULL),(5058,'projecttemplate','salestax3_id',11,'Integer','',NULL,'',NULL),(5059,'projecttemplate','salestax3_percent',6,'Numeric','',NULL,'',NULL),(5060,'projecttemplate','salestax3_glacctid',11,'Integer','',NULL,'',NULL),(5061,'projecttemplate','othertax_name',20,'Text','',NULL,'',NULL),(5062,'projecttemplate','othertax_percent',6,'Numeric','',NULL,'',NULL),(5063,'projecttemplate','othertax_glacctid',11,'Integer','',NULL,'',NULL),(5064,'projecttemplate','weekly',5,'Integer','',NULL,'',NULL),(5065,'projecttemplate','glacctid_income',11,'Integer','',NULL,'',NULL),(5066,'projecttemplate','glacctid_cogs',11,'Integer','',NULL,'',NULL),(5067,'projecttemplate','glacctid_commission1',11,'Integer','',NULL,'',NULL),(5068,'projecttemplate','glacctid_commission2',11,'Integer','',NULL,'',NULL),(5069,'projecttemplate','cancel',5,'Integer','',NULL,'multiple',NULL),(5070,'projecttemplate','canceldate',19,'DateTime','',NULL,'',NULL),(5071,'projecttemplate','canceluserid',11,'Integer','',NULL,'',NULL),(5072,'projecttemplate','entrydate',19,'DateTime','',NULL,'',NULL),(5073,'projecttemplate','entryuserid',11,'Integer','',NULL,'',NULL),(5074,'projecttemplate','lastchangedate',19,'DateTime','',NULL,'',NULL),(5075,'projecttemplate','lastchangeuserid',11,'Integer','',NULL,'',NULL),(5076,'projecttemplate','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(5077,'projecttemplate','customdays',5,'Integer','',NULL,'',NULL),(5078,'projecttemplate','othertax_client_percent',12,'Numeric','',NULL,'',NULL),(5079,'projecttemplatedetail','id',11,'Integer','',NULL,'primary',NULL),(5080,'projecttemplatedetail','projecttemplateid',11,'Integer','',NULL,'multiple',NULL),(5081,'projecttemplatedetail','description',255,'Text','',NULL,'',NULL),(5082,'projecttemplatedetail','description2',255,'Text','',NULL,'',NULL),(5083,'projecttemplatedetail','description3',255,'Text','',NULL,'',NULL),(5084,'projecttemplatedetail','percent_of_total',6,'Numeric','',NULL,'',NULL),(5085,'prperiod','strname',30,'Text','',NULL,'',NULL),(5086,'prstate','sui_vendorid',11,'Integer','',NULL,'',NULL),(5087,'prstate','taxyear',4,'Integer','',NULL,'',NULL),(5088,'prstate','mainrec',11,'Integer','',NULL,'',NULL),(5089,'qbimport','id',10,'Integer','',NULL,'primary',NULL),(5090,'qbimport','module',45,'Text','',NULL,'',NULL),(5091,'qbimport','status',11,'Integer','',NULL,'',NULL),(5092,'qbimport','numrecords',10,'Integer','',NULL,'',NULL),(5093,'qbimport','entrydate',19,'DateTime','',NULL,'',NULL),(5094,'qbimport','entryuserid',11,'Integer','',NULL,'',NULL),(5095,'qbimport','companyid',11,'Integer','',NULL,'',NULL),(5096,'question','donotshow_on_ticket',5,'Integer','',NULL,'',NULL),(5097,'sales_categories','allow_b2b_display',11,'Integer','',NULL,'',NULL),(5098,'salestax','capamount',16,'Numeric','',NULL,'',NULL),(5099,'salestax','gencompanyid',11,'Integer','',NULL,'',NULL),(5100,'service_worktype','salesglacctid',11,'Integer','',NULL,'',NULL),(5101,'shipto','weather_cf',1,'Text','',NULL,'',NULL),(5102,'shipto','weather_zip',20,'Text','',NULL,'',NULL),(5103,'shipto','time_zone',6,'Text','',NULL,'',NULL),(5104,'survey','id',10,'Integer','',NULL,'primary',NULL),(5105,'survey','name',255,'Text','',NULL,'',NULL),(5106,'survey','entryuserid',10,'Integer','',NULL,'',NULL),(5107,'survey','entrydate',19,'DateTime','',NULL,'',NULL),(5108,'survey','cancel',11,'Integer','',NULL,'',NULL),(5109,'survey','canceluserid',11,'Integer','',NULL,'',NULL),(5110,'survey','canceldate',19,'DateTime','',NULL,'',NULL),(5111,'survey','companyid',10,'Integer','',NULL,'',NULL),(5112,'survey','surveytype',20,'Text','',NULL,'',NULL),(5113,'survey','emailtext',65535,'X','',NULL,'',NULL),(5114,'surveycomplete','id',10,'Integer','',NULL,'primary',NULL),(5115,'surveycomplete','surveyid',10,'Integer','',NULL,'',NULL),(5116,'surveycomplete','customerid',10,'Integer','',NULL,'multiple',NULL),(5117,'surveycomplete','vendorid',10,'Integer','',NULL,'multiple',NULL),(5118,'surveycomplete','entrydate',19,'DateTime','',NULL,'multiple',NULL),(5119,'surveycomplete','ip',20,'Text','',NULL,'',NULL),(5120,'surveycomplete','referenceid',10,'Integer','',NULL,'multiple',NULL),(5121,'surveycomplete','referencetable',50,'Text','',NULL,'',NULL),(5122,'surveycomplete','uniqueid',45,'Text','',NULL,'',NULL),(5123,'tccompany','id',11,'Integer','',NULL,'primary unique',NULL),(5124,'tccompany','general_ip_only',255,'Text','',NULL,'',NULL),(5125,'tccompany','genuser_ip_yesno',5,'Integer','',NULL,'',NULL),(5126,'tccompany','hours_day_overtime',6,'Numeric','',NULL,'',NULL),(5127,'tccompany','hours_week_overtime',7,'Numeric','',NULL,'',NULL),(5128,'tccompany','payweek_beginday',5,'Integer','',NULL,'',NULL),(5129,'tccompany','lunchpaid',5,'Integer','',NULL,'',NULL),(5130,'tccompany','breakpaid',5,'Integer','',NULL,'',NULL),(5131,'tccompany','maxtime_perbreak',6,'Numeric','',NULL,'',NULL),(5132,'tccompany','max_breaks_perday',5,'Integer','',NULL,'',NULL),(5133,'tccompany','allow_comptime',5,'Integer','',NULL,'',NULL),(5134,'tccompany','stpay_prpaytypeid',11,'Integer','',NULL,'',NULL),(5135,'tccompany','ot_prpaytypeid',11,'Integer','',NULL,'',NULL),(5136,'tccompany','maxpaidlunch',17,'Numeric','',NULL,'',NULL),(5137,'tccompany','maxhours',11,'Integer','',NULL,'',NULL),(5138,'tccompany','salaried_all_stpay',5,'Integer','',NULL,'',NULL),(5139,'tccompany','salaried_limit_time',5,'Integer','',NULL,'',NULL),(5140,'tccompany','no_autologout',5,'Integer','',NULL,'',NULL),(5141,'tccompany','no_paydisplay',5,'Integer','',NULL,'',NULL),(5142,'tccompany','norelog_viewtimes',5,'Integer','',NULL,'',NULL),(5143,'tccompany','input_font_size',11,'Integer','',NULL,'',NULL),(5144,'timeclock','id',11,'Integer','',NULL,'primary',NULL),(5145,'timeclock','employeeid',11,'Integer','',NULL,'multiple',NULL),(5146,'timeclock','name',50,'Text','',NULL,'',NULL),(5147,'timeclock','hours',17,'Numeric','',NULL,'',NULL),(5148,'timeclock','quantity',17,'Numeric','',NULL,'',NULL),(5149,'timeclock','rateperhour',17,'Numeric','',NULL,'',NULL),(5150,'timeclock','rateperpiece',17,'Numeric','',NULL,'',NULL),(5151,'timeclock','totalpay',17,'Numeric','',NULL,'',NULL),(5152,'timeclock','jobid',11,'Integer','',NULL,'',NULL),(5153,'timeclock','notes',255,'Text','',NULL,'',NULL),(5154,'timeclock','gencompanyid',11,'Integer','',NULL,'',NULL),(5155,'timeclock','entrydate',19,'DateTime','',NULL,'multiple',NULL),(5156,'timeclock','cancel',5,'Integer','',NULL,'',NULL),(5157,'timeclock','canceldate',19,'DateTime','',NULL,'',NULL),(5158,'timeclock','canceluserid',11,'Integer','',NULL,'',NULL),(5159,'timeclock','lastchangedate',19,'DateTime','',NULL,'',NULL),(5160,'timeclock','lastchangeuserid',11,'Integer','',NULL,'',NULL),(5161,'timeclock','status',5,'Integer','',NULL,'',NULL),(5162,'timeclock','ordertype',5,'Integer','',NULL,'',NULL),(5163,'timeclock','timetype',5,'Integer','',NULL,'',NULL),(5164,'timeclock','piecerate_pricesid',11,'Integer','',NULL,'',NULL),(5165,'timeclock','employee_edited',5,'Integer','',NULL,'',NULL),(5166,'timeclock','employee_edit_datetime',19,'DateTime','',NULL,'',NULL),(5167,'timeclock','management_edited',5,'Integer','',NULL,'',NULL),(5168,'timeclock','management_edited_datetime',19,'DateTime','',NULL,'',NULL),(5169,'timeclock','management_edited_userid',11,'Integer','',NULL,'',NULL),(5170,'timeclock','premplweekid',11,'Integer','',NULL,'',NULL),(5171,'timeclock','description',255,'Text','',NULL,'',NULL),(5172,'timeclock','startdatetime',19,'DateTime','',NULL,'multiple',NULL),(5173,'timeclock','enddatetime',19,'DateTime','',NULL,'',NULL),(5174,'timeclock','ip',50,'Text','',NULL,'',NULL),(5175,'timeclock','ippath',100,'Text','',NULL,'',NULL),(5176,'timeclock','otherid',11,'Integer','',NULL,'',NULL),(5177,'timeclock','comptime',5,'Integer','',NULL,'',NULL),(5178,'timeclock','shift',5,'Integer','',NULL,'',NULL),(5179,'timeclock','unpaid_hours',17,'Numeric','',NULL,'',NULL),(5180,'timeclock','calc_othours',17,'Numeric','',NULL,'',NULL),(5181,'timeclock','calc_sthours',17,'Numeric','',NULL,'',NULL),(5182,'timeclock','calc_otpay',18,'Numeric','',NULL,'',NULL),(5183,'timeclock','calc_stpay',18,'Numeric','',NULL,'',NULL),(5184,'timeclock','piecework_div',11,'Integer','',NULL,'',NULL),(5185,'timeclock','calc_pwpay',21,'Numeric','',NULL,'',NULL),(5186,'timeclock','calc_pwqty',17,'Numeric','',NULL,'',NULL),(5187,'timeclock','pw_minimum',21,'Numeric','',NULL,'',NULL),(5188,'timeclock','calc_pwrate',21,'Numeric','',NULL,'',NULL),(5189,'timeclock','post2date',10,'Date','',NULL,'',NULL),(5190,'timeclock_othertime','id',11,'Integer','',NULL,'primary',NULL),(5191,'timeclock_othertime','note',50,'Text','',NULL,'',NULL),(5192,'timeclock_othertime','sortorder',5,'Integer','',NULL,'multiple',NULL),(5193,'timeclock_othertime','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(5194,'timeclock_othertime','cancel',5,'Integer','',NULL,'multiple',NULL),(5195,'timeclock_othertime','canceluserid',11,'Integer','',NULL,'',NULL),(5196,'timeclock_othertime','canceldate',19,'DateTime','',NULL,'',NULL),(5197,'timeclock_othertime','lastupdatedate',19,'DateTime','',NULL,'',NULL),(5198,'timeclock_othertime','lastupdateuserid',11,'Integer','',NULL,'',NULL),(5199,'timeclock_othertime','paidtime',5,'Integer','',NULL,'',NULL),(5200,'vendor','vendorcode',30,'Text','',NULL,'',NULL),(5201,'vendor','salutation',20,'Text','',NULL,'',NULL),(5202,'vendor','first_name',50,'Text','',NULL,'',NULL),(5203,'vendor','middle_name',50,'Text','',NULL,'',NULL),(5204,'vendor','name_suffix',20,'Text','',NULL,'',NULL),(5205,'vendor','vendortypeid',11,'Integer','',NULL,'multiple',NULL),(5206,'vendortype','id',11,'Integer','',NULL,'primary',NULL),(5207,'vendortype','description',255,'Text','',NULL,'',NULL),(5208,'vendortype','cancel',5,'Integer','',NULL,'multiple',NULL),(5209,'vendortype','canceldate',19,'DateTime','',NULL,'',NULL),(5210,'vendortype','canceluserid',11,'Integer','',NULL,'',NULL),(5211,'vendortype','gencompanyid',11,'Integer','',NULL,'multiple',NULL),(5212,'vendortype','lastupdatedate',19,'DateTime','',NULL,'',NULL),(5213,'wherefrom','id',11,'Integer','',NULL,'primary',NULL),(5214,'wherefrom','module',10,'Text','',NULL,'',NULL),(5215,'wherefrom','name',100,'Text','',NULL,'',NULL),(5216,'worktype','gencompanyid',11,'Integer','',NULL,'',NULL);
/*!40000 ALTER TABLE `db_explanation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_response`
--

DROP TABLE IF EXISTS `default_response`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_response` (
  `id_default_response` int(11) NOT NULL default '0',
  `id_worksubtype` int(11) NOT NULL default '0',
  `id_question` int(11) NOT NULL default '0',
  `response_id_question_detail` int(11) NOT NULL default '0',
  `response` varchar(20) NOT NULL default '',
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_user_create` int(11) NOT NULL default '0',
  `lastrevisedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_user_revise` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_default_response`),
  UNIQUE KEY `id_default_response` (`id_default_response`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_response`
--

LOCK TABLES `default_response` WRITE;
/*!40000 ALTER TABLE `default_response` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_response` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_responseseq`
--

DROP TABLE IF EXISTS `default_responseseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `default_responseseq` (
  `id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_responseseq`
--

LOCK TABLES `default_responseseq` WRITE;
/*!40000 ALTER TABLE `default_responseseq` DISABLE KEYS */;
INSERT INTO `default_responseseq` VALUES (0);
/*!40000 ALTER TABLE `default_responseseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `department`
--

DROP TABLE IF EXISTS `department`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `department` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(45) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `glwageexpenseid` int(11) NOT NULL default '0',
  `glficaexpenseid` int(11) NOT NULL default '0',
  `glfuiexpenseid` int(11) NOT NULL default '0',
  `glmedicareexpenseid` int(11) NOT NULL default '0',
  `glsuiexpenseid` int(11) NOT NULL default '0',
  `glworkmanscompexpenseid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `cancel` (`cancel`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `department`
--

LOCK TABLES `department` WRITE;
/*!40000 ALTER TABLE `department` DISABLE KEYS */;
/*!40000 ALTER TABLE `department` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `discount`
--

DROP TABLE IF EXISTS `discount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `discountpercent` decimal(6,2) NOT NULL default '0.00',
  `glaccountid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `cancel` int(11) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `companyid` (`companyid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `discount`
--

LOCK TABLES `discount` WRITE;
/*!40000 ALTER TABLE `discount` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dnsmxcache`
--

DROP TABLE IF EXISTS `dnsmxcache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dnsmxcache` (
  `id` int(11) NOT NULL auto_increment,
  `hostnamechecksum` int(11) NOT NULL,
  `found` tinyint(1) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `hostname` varchar(255) character set utf8 collate utf8_unicode_ci NOT NULL,
  `mxhostscsv` text character set utf8 collate utf8_unicode_ci,
  `weightcsv` text character set utf8 collate utf8_unicode_ci,
  PRIMARY KEY  (`id`),
  KEY `checksumkey` (`hostnamechecksum`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dnsmxcache`
--

LOCK TABLES `dnsmxcache` WRITE;
/*!40000 ALTER TABLE `dnsmxcache` DISABLE KEYS */;
/*!40000 ALTER TABLE `dnsmxcache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `docmgmtcategory`
--

DROP TABLE IF EXISTS `docmgmtcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `docmgmtcategory` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `docmgmtcategory`
--

LOCK TABLES `docmgmtcategory` WRITE;
/*!40000 ALTER TABLE `docmgmtcategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `docmgmtcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `docmgmtdata`
--

DROP TABLE IF EXISTS `docmgmtdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `docmgmtdata` (
  `id` int(11) NOT NULL auto_increment,
  `category` double NOT NULL default '0',
  `owner` double NOT NULL default '0',
  `realname` varchar(255) NOT NULL default '',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `description` varchar(255) default NULL,
  `itemid` int(11) NOT NULL default '0',
  `comment` text,
  `status` double NOT NULL default '0',
  `version` varchar(10) default NULL,
  `final` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `itemid` (`itemid`),
  KEY `owner` (`owner`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `docmgmtdata`
--

LOCK TABLES `docmgmtdata` WRITE;
/*!40000 ALTER TABLE `docmgmtdata` DISABLE KEYS */;
/*!40000 ALTER TABLE `docmgmtdata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `docmgmtlog`
--

DROP TABLE IF EXISTS `docmgmtlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `docmgmtlog` (
  `id` int(11) NOT NULL default '0',
  `modified_on` datetime NOT NULL default '0000-00-00 00:00:00',
  `modified_by` double NOT NULL default '0',
  `oldversion` varchar(10) default NULL,
  `newversion` varchar(10) default NULL,
  `note` text,
  KEY `id` (`id`),
  KEY `modified_by` (`modified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `docmgmtlog`
--

LOCK TABLES `docmgmtlog` WRITE;
/*!40000 ALTER TABLE `docmgmtlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `docmgmtlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `docmgmtperms`
--

DROP TABLE IF EXISTS `docmgmtperms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `docmgmtperms` (
  `fid` int(11) NOT NULL default '0',
  `uid` int(11) NOT NULL default '0',
  `rights` double NOT NULL default '0',
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `rights` (`rights`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `docmgmtperms`
--

LOCK TABLES `docmgmtperms` WRITE;
/*!40000 ALTER TABLE `docmgmtperms` DISABLE KEYS */;
/*!40000 ALTER TABLE `docmgmtperms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `docsigning`
--

DROP TABLE IF EXISTS `docsigning`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `docsigning` (
  `id` int(11) NOT NULL auto_increment,
  `doctype` varchar(25) NOT NULL default '',
  `templateid` varchar(45) NOT NULL default '',
  `docname` varchar(100) NOT NULL default '',
  `tablename` varchar(45) NOT NULL default '',
  `tableid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `docid` varchar(45) NOT NULL default '',
  `auth` varchar(45) NOT NULL default '',
  `signatory1id` varchar(45) NOT NULL default '',
  `signatory1auth` varchar(45) NOT NULL default '',
  `signatory2id` varchar(45) NOT NULL default '',
  `signatory2auth` varchar(45) NOT NULL default '',
  `signatory3id` varchar(45) NOT NULL default '',
  `signatory3auth` varchar(45) NOT NULL default '',
  `signatory4id` varchar(45) NOT NULL default '',
  `signatory4auth` varchar(45) NOT NULL default '',
  `status` varchar(45) NOT NULL default '',
  `statusdate` datetime default NULL,
  `statusdetail` varchar(50) NOT NULL default '',
  `expirationdate` date default NULL,
  `ordernumber` int(11) NOT NULL default '0',
  `signurl1` varchar(255) NOT NULL default '',
  `signurl2` varchar(255) NOT NULL default '',
  `signurl3` varchar(255) NOT NULL default '',
  `signurl4` varchar(255) NOT NULL default '',
  `viewurl` varchar(255) NOT NULL default '',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `completedate` datetime default NULL,
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastlogdate` datetime default NULL,
  `lastlogdetails` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`),
  KEY `doctype` (`doctype`),
  KEY `tableinfo` (`tablename`,`tableid`),
  KEY `docinfo` (`docid`,`auth`),
  KEY `status` (`status`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `docsigning`
--

LOCK TABLES `docsigning` WRITE;
/*!40000 ALTER TABLE `docsigning` DISABLE KEYS */;
/*!40000 ALTER TABLE `docsigning` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `draw`
--

DROP TABLE IF EXISTS `draw`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `draw` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `status` int(11) NOT NULL default '0',
  `drawtotal` decimal(19,6) NOT NULL default '0.000000',
  `drawdate` date NOT NULL default '0000-00-00',
  `retainage` decimal(6,2) NOT NULL default '0.00',
  `retainagetotal` decimal(19,6) NOT NULL default '0.000000',
  `customerid` int(11) NOT NULL default '0',
  `invoiceid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `cancel` int(11) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `jobsondraw` text NOT NULL,
  `changeorderadd` decimal(19,6) NOT NULL default '0.000000',
  `changeorderded` decimal(19,6) NOT NULL default '0.000000',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `status` (`status`),
  KEY `drawdate` (`drawdate`),
  KEY `customerid` (`customerid`),
  KEY `invoiceid` (`invoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `draw`
--

LOCK TABLES `draw` WRITE;
/*!40000 ALTER TABLE `draw` DISABLE KEYS */;
/*!40000 ALTER TABLE `draw` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drawdetail`
--

DROP TABLE IF EXISTS `drawdetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `drawdetail` (
  `id` int(11) NOT NULL auto_increment,
  `drawid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `amount` decimal(19,6) NOT NULL default '0.000000',
  PRIMARY KEY  (`id`),
  KEY `costcodeid` (`costcodeid`),
  KEY `drawid` (`drawid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drawdetail`
--

LOCK TABLES `drawdetail` WRITE;
/*!40000 ALTER TABLE `drawdetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `drawdetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ebaysetup`
--

DROP TABLE IF EXISTS `ebaysetup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ebaysetup` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(128) NOT NULL default '',
  `ebaystorename` varchar(128) NOT NULL default '',
  `ebayaccountid` varchar(32) NOT NULL default '',
  `companyid` int(11) NOT NULL default '0',
  `token` varchar(1024) NOT NULL default '',
  `tokenexpire` datetime NOT NULL default '0000-00-00 00:00:00',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastchangeuserid` int(11) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `salesglacctid` int(11) NOT NULL default '0',
  `salestaxglacctid` int(11) NOT NULL default '0',
  `taxexemptid` int(11) NOT NULL default '0',
  `salescategoryid` int(11) NOT NULL default '0',
  `inventorylocationid` int(11) NOT NULL default '0',
  `invoicetermsid` int(11) NOT NULL default '0',
  `pricelevelid` int(11) NOT NULL default '0',
  `defaultshipvia` int(11) NOT NULL default '0',
  `currency` varchar(8) NOT NULL default '',
  `stockunitnameid` int(11) NOT NULL default '0',
  `priceunitnameid` int(11) NOT NULL default '0',
  `allowautomaticorderimports` tinyint(1) NOT NULL default '0',
  `automaticorderimport_lastrun` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ebaysetup`
--

LOCK TABLES `ebaysetup` WRITE;
/*!40000 ALTER TABLE `ebaysetup` DISABLE KEYS */;
/*!40000 ALTER TABLE `ebaysetup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eftfile`
--

DROP TABLE IF EXISTS `eftfile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `eftfile` (
  `id` int(11) NOT NULL auto_increment,
  `filecontents` mediumtext,
  `efttype` char(1) NOT NULL default 'C',
  `totalamount` decimal(19,4) NOT NULL default '0.0000',
  `totalrecords` int(11) NOT NULL default '0',
  `filecreationnumber` int(11) NOT NULL default '0',
  `checkacctid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `paymentdate` date default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastemaildate` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `efttype` (`efttype`),
  KEY `entryuserid` (`entryuserid`),
  KEY `checkacctid` (`checkacctid`),
  KEY `canceluserid` (`canceluserid`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `paymentdate` (`paymentdate`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eftfile`
--

LOCK TABLES `eftfile` WRITE;
/*!40000 ALTER TABLE `eftfile` DISABLE KEYS */;
/*!40000 ALTER TABLE `eftfile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eftfiledetail`
--

DROP TABLE IF EXISTS `eftfiledetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `eftfiledetail` (
  `id` int(11) NOT NULL auto_increment,
  `eftfileid` int(11) NOT NULL default '0',
  `vendorid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `amount` decimal(19,4) NOT NULL default '0.0000',
  `checkid` int(11) NOT NULL default '0',
  `voucherid` int(11) NOT NULL default '0',
  `recordnumber` int(11) NOT NULL default '0',
  `paymentdate` date default NULL,
  PRIMARY KEY  (`id`),
  KEY `eftfileid` (`eftfileid`),
  KEY `vendorid` (`vendorid`),
  KEY `customerid` (`customerid`),
  KEY `checkid` (`checkid`),
  KEY `voucherid` (`voucherid`),
  KEY `paymentdate` (`paymentdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eftfiledetail`
--

LOCK TABLES `eftfiledetail` WRITE;
/*!40000 ALTER TABLE `eftfiledetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `eftfiledetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailtemplate`
--

DROP TABLE IF EXISTS `emailtemplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailtemplate` (
  `id` int(11) NOT NULL auto_increment,
  `action` varchar(20) NOT NULL default '',
  `name` varchar(200) NOT NULL default '',
  `fromname` varchar(255) NOT NULL default '',
  `fromemail` varchar(255) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `body` text,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `defaultcc` text,
  `defaultbcc` text,
  `surveyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailtemplate`
--

LOCK TABLES `emailtemplate` WRITE;
/*!40000 ALTER TABLE `emailtemplate` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailtemplate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employeelog`
--

DROP TABLE IF EXISTS `employeelog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employeelog` (
  `id_employeelog` int(11) NOT NULL default '0',
  `id_employee` int(11) NOT NULL default '0',
  `status` int(3) NOT NULL default '0',
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `starttime` datetime default NULL,
  `endtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `total_time` decimal(10,2) NOT NULL default '0.00',
  `id_employeelogcategory` int(11) NOT NULL default '0',
  `notes` varchar(100) NOT NULL default '',
  `cancel` int(3) NOT NULL default '0',
  PRIMARY KEY  (`id_employeelog`),
  UNIQUE KEY `id_employeelog` (`id_employeelog`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employeelog`
--

LOCK TABLES `employeelog` WRITE;
/*!40000 ALTER TABLE `employeelog` DISABLE KEYS */;
/*!40000 ALTER TABLE `employeelog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employeelogcategory`
--

DROP TABLE IF EXISTS `employeelogcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employeelogcategory` (
  `id` int(11) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `cancel` int(3) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employeelogcategory`
--

LOCK TABLES `employeelogcategory` WRITE;
/*!40000 ALTER TABLE `employeelogcategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `employeelogcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employeelogseq`
--

DROP TABLE IF EXISTS `employeelogseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employeelogseq` (
  `id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employeelogseq`
--

LOCK TABLES `employeelogseq` WRITE;
/*!40000 ALTER TABLE `employeelogseq` DISABLE KEYS */;
/*!40000 ALTER TABLE `employeelogseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `equipment`
--

DROP TABLE IF EXISTS `equipment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `equipment` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(150) NOT NULL default '',
  `description` text NOT NULL,
  `buildingid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `cost` decimal(19,6) NOT NULL default '0.000000',
  `serialnumber` varchar(100) NOT NULL default '',
  `purchasedate` date default NULL,
  `vendorid` int(11) NOT NULL default '0',
  `invpoid` int(11) NOT NULL default '0',
  `signedout` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` varchar(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `buildingid` (`buildingid`),
  KEY `companyid` (`companyid`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `equipment`
--

LOCK TABLES `equipment` WRITE;
/*!40000 ALTER TABLE `equipment` DISABLE KEYS */;
/*!40000 ALTER TABLE `equipment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `equipmentsignout`
--

DROP TABLE IF EXISTS `equipmentsignout`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `equipmentsignout` (
  `id` int(11) NOT NULL auto_increment,
  `equipmentid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `workorderid` int(11) NOT NULL default '0',
  `dateout` date NOT NULL default '0000-00-00',
  `datein` date NOT NULL default '0000-00-00',
  `notes` text NOT NULL,
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`),
  KEY `equipmentid` (`equipmentid`),
  KEY `workorderid` (`workorderid`),
  KEY `dateout` (`dateout`),
  KEY `datein` (`datein`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `equipmentsignout`
--

LOCK TABLES `equipmentsignout` WRITE;
/*!40000 ALTER TABLE `equipmentsignout` DISABLE KEYS */;
/*!40000 ALTER TABLE `equipmentsignout` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estcostcenter`
--

DROP TABLE IF EXISTS `estcostcenter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estcostcenter` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(50) NOT NULL default '',
  `cctype` int(11) NOT NULL default '0',
  `orderflag` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estcostcenter`
--

LOCK TABLES `estcostcenter` WRITE;
/*!40000 ALTER TABLE `estcostcenter` DISABLE KEYS */;
/*!40000 ALTER TABLE `estcostcenter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estcostcentersubtype`
--

DROP TABLE IF EXISTS `estcostcentersubtype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estcostcentersubtype` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(50) NOT NULL default '',
  `costcenterid` int(11) NOT NULL default '0',
  `orderflag` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `costcenterid` (`costcenterid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estcostcentersubtype`
--

LOCK TABLES `estcostcentersubtype` WRITE;
/*!40000 ALTER TABLE `estcostcentersubtype` DISABLE KEYS */;
/*!40000 ALTER TABLE `estcostcentersubtype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estmachine`
--

DROP TABLE IF EXISTS `estmachine`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estmachine` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(50) NOT NULL default '',
  `costcentersubtypeid` int(11) NOT NULL default '0',
  `costmachperhr` decimal(12,2) NOT NULL default '0.00',
  `costoperperhr` decimal(12,2) NOT NULL default '0.00',
  `costasstperhr` decimal(12,2) NOT NULL default '0.00',
  `factoverhead` decimal(3,2) NOT NULL default '0.00',
  `genoverhead` decimal(3,2) NOT NULL default '0.00',
  `markup` decimal(4,2) NOT NULL default '0.00',
  `orderflag` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `costcentersubtypeid` (`costcentersubtypeid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estmachine`
--

LOCK TABLES `estmachine` WRITE;
/*!40000 ALTER TABLE `estmachine` DISABLE KEYS */;
/*!40000 ALTER TABLE `estmachine` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprgeneral`
--

DROP TABLE IF EXISTS `estprgeneral`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprgeneral` (
  `gencompanyid` int(11) NOT NULL default '0',
  `onetrimopcostsid` int(11) NOT NULL default '0',
  `twotrimopcostsid` int(11) NOT NULL default '0',
  `cutopcostsid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  PRIMARY KEY  (`gencompanyid`),
  UNIQUE KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprgeneral`
--

LOCK TABLES `estprgeneral` WRITE;
/*!40000 ALTER TABLE `estprgeneral` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprgeneral` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprprice`
--

DROP TABLE IF EXISTS `estprprice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprprice` (
  `id` int(11) NOT NULL auto_increment,
  `gencompanyid` int(11) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `worktypeid` int(11) NOT NULL default '0',
  `estquotestdsizeid` int(11) NOT NULL default '0',
  `maxpages` int(11) NOT NULL default '0',
  `minpages` int(11) NOT NULL default '0',
  `opoffsetsheet` int(11) NOT NULL default '0',
  `opoffsetweb` int(11) NOT NULL default '0',
  `opdigital` int(11) NOT NULL default '0',
  `opscreen` int(11) NOT NULL default '0',
  `opflexo` int(11) NOT NULL default '0',
  `opvended` int(11) NOT NULL default '0',
  `qtyperbox` decimal(5,0) NOT NULL default '0',
  `notes` blob,
  `prpriceid` int(11) NOT NULL default '0',
  `maxstocks` int(11) NOT NULL default '1',
  `tools` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprprice`
--

LOCK TABLES `estprprice` WRITE;
/*!40000 ALTER TABLE `estprprice` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprprice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprpriceoptioncosts`
--

DROP TABLE IF EXISTS `estprpriceoptioncosts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprpriceoptioncosts` (
  `id` int(11) NOT NULL auto_increment,
  `proption` int(11) NOT NULL default '0',
  `stocklistid` int(11) NOT NULL default '0',
  `hrsgeneralsetup` decimal(6,3) NOT NULL default '0.000',
  `hrscolorsetup` decimal(6,3) NOT NULL default '0.000',
  `runrate` decimal(10,2) NOT NULL default '0.00',
  `runrate2` decimal(10,2) NOT NULL default '0.00',
  `runrate3` decimal(10,2) NOT NULL default '0.00',
  `runqty` decimal(8,0) NOT NULL default '0',
  `runqty2` decimal(8,0) NOT NULL default '0',
  `runrateqtytype` int(11) NOT NULL default '0',
  `numoperators` int(11) NOT NULL default '0',
  `numassistants` int(11) NOT NULL default '0',
  `mantomachine` int(11) NOT NULL default '0',
  `setupscrap` decimal(5,2) NOT NULL default '0.00',
  `runscrap` decimal(5,2) NOT NULL default '0.00',
  `runscrap2` decimal(5,2) NOT NULL default '0.00',
  `scrapqty` decimal(8,0) NOT NULL default '0',
  `registrationslowdown` decimal(2,0) NOT NULL default '0',
  `maxinksperpass` int(11) NOT NULL default '1',
  `estmachineid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprpriceoptioncosts`
--

LOCK TABLES `estprpriceoptioncosts` WRITE;
/*!40000 ALTER TABLE `estprpriceoptioncosts` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprpriceoptioncosts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprpriceoptioncostsmaterials`
--

DROP TABLE IF EXISTS `estprpriceoptioncostsmaterials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprpriceoptioncostsmaterials` (
  `id` int(11) NOT NULL auto_increment,
  `proption` int(11) NOT NULL default '0',
  `stocklistid` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `qty` decimal(10,3) NOT NULL default '0.000',
  `per` int(11) NOT NULL default '0',
  `cost` decimal(12,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprpriceoptioncostsmaterials`
--

LOCK TABLES `estprpriceoptioncostsmaterials` WRITE;
/*!40000 ALTER TABLE `estprpriceoptioncostsmaterials` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprpriceoptioncostsmaterials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprpriceoptionprice`
--

DROP TABLE IF EXISTS `estprpriceoptionprice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprpriceoptionprice` (
  `id` int(11) NOT NULL auto_increment,
  `proption` int(11) NOT NULL default '0',
  `stockusageid` int(11) NOT NULL default '0',
  `qty` double NOT NULL default '0',
  `amount` decimal(10,2) NOT NULL default '0.00',
  `qtycalchow` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprpriceoptionprice`
--

LOCK TABLES `estprpriceoptionprice` WRITE;
/*!40000 ALTER TABLE `estprpriceoptionprice` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprpriceoptionprice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprpricestockusage`
--

DROP TABLE IF EXISTS `estprpricestockusage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprpricestockusage` (
  `id` int(11) NOT NULL auto_increment,
  `prpriceid` int(11) NOT NULL default '0',
  `name` char(20) NOT NULL default '',
  `proptionone` double NOT NULL default '0',
  `proptiontwo` double NOT NULL default '0',
  `proptionqty` decimal(10,0) NOT NULL default '0',
  `maxinksfront` int(11) NOT NULL default '0',
  `mininksfront` int(11) NOT NULL default '0',
  `maxinksback` int(11) NOT NULL default '0',
  `mininksback` int(11) NOT NULL default '0',
  `maxpages` int(11) NOT NULL default '0',
  `inkcoveragedefault` int(11) NOT NULL default '1',
  `stockusageid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprpricestockusage`
--

LOCK TABLES `estprpricestockusage` WRITE;
/*!40000 ALTER TABLE `estprpricestockusage` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprpricestockusage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprpricestockusagecolors`
--

DROP TABLE IF EXISTS `estprpricestockusagecolors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprpricestockusagecolors` (
  `id` int(11) NOT NULL auto_increment,
  `stocklistid` int(11) NOT NULL default '0',
  `substockcolorsid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprpricestockusagecolors`
--

LOCK TABLES `estprpricestockusagecolors` WRITE;
/*!40000 ALTER TABLE `estprpricestockusagecolors` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprpricestockusagecolors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprpricestockusagestock`
--

DROP TABLE IF EXISTS `estprpricestockusagestock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprpricestockusagestock` (
  `id` int(11) NOT NULL auto_increment,
  `stockusageid` int(11) NOT NULL default '0',
  `proption` int(11) NOT NULL default '0',
  `substockid` int(11) NOT NULL default '0',
  `numberout` int(11) NOT NULL default '1',
  `cuts` int(11) NOT NULL default '0',
  `width` decimal(10,3) NOT NULL default '0.000',
  `length` decimal(10,3) NOT NULL default '0.000',
  `numberup` int(11) NOT NULL default '1',
  `addlchargeperm` decimal(10,2) NOT NULL default '0.00',
  `addlminimum` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprpricestockusagestock`
--

LOCK TABLES `estprpricestockusagestock` WRITE;
/*!40000 ALTER TABLE `estprpricestockusagestock` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprpricestockusagestock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estprpricetools`
--

DROP TABLE IF EXISTS `estprpricetools`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estprpricetools` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(30) NOT NULL default '',
  `description` char(100) NOT NULL default '',
  `locationid` int(11) NOT NULL default '0',
  `familyid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `firsttimeamount` decimal(10,2) NOT NULL default '0.00',
  `timesusedcounter` int(11) NOT NULL default '0',
  `costperuse` decimal(10,2) NOT NULL default '0.00',
  `priceperuse` decimal(10,2) NOT NULL default '0.00',
  `costperpresshour` decimal(10,2) NOT NULL default '0.00',
  `priceperpresshour` decimal(10,2) NOT NULL default '0.00',
  `priceperpressqty` decimal(10,2) NOT NULL default '0.00',
  `tooltype` int(11) NOT NULL default '0',
  `repeatlength` decimal(5,3) NOT NULL default '0.000',
  `across` int(11) NOT NULL default '0',
  `around` int(11) NOT NULL default '0',
  `cavityshape` char(30) NOT NULL default '',
  `cavitywidth` char(30) NOT NULL default '',
  `cavitydepth` char(30) NOT NULL default '',
  `gap` char(30) NOT NULL default '',
  `bearerwidth` char(30) NOT NULL default '',
  `gearpitchratio` int(11) NOT NULL default '0',
  `teeth` int(11) NOT NULL default '0',
  `addlsetuphrspress` decimal(5,2) NOT NULL default '0.00',
  `value` decimal(10,2) NOT NULL default '0.00',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estprpricetools`
--

LOCK TABLES `estprpricetools` WRITE;
/*!40000 ALTER TABLE `estprpricetools` DISABLE KEYS */;
/*!40000 ALTER TABLE `estprpricetools` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquote`
--

DROP TABLE IF EXISTS `estquote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquote` (
  `id` int(11) NOT NULL auto_increment,
  `quotenum` double NOT NULL default '0',
  `subquotenum` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `ponumber` varchar(30) default NULL,
  `priority` int(11) NOT NULL default '0',
  `duedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `worktypeid` int(11) NOT NULL default '0',
  `jobname` varchar(30) default NULL,
  `jobdesc` blob,
  `attn` varchar(30) default NULL,
  `custtrackingnum` varchar(20) default NULL,
  `custchargecode` varchar(30) default NULL,
  `formnumber` varchar(20) default NULL,
  `itemid` int(11) NOT NULL default '0',
  `itemcomposite` int(11) NOT NULL default '0',
  `prpriceid` int(11) NOT NULL default '0',
  `finishwidth` decimal(5,4) NOT NULL default '0.0000',
  `finishheight` decimal(5,4) NOT NULL default '0.0000',
  `flatwidth` decimal(5,4) NOT NULL default '0.0000',
  `flatheight` decimal(5,4) NOT NULL default '0.0000',
  `numpages` double NOT NULL default '0',
  `extuser` double NOT NULL default '0',
  `genuser` double NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `customerid` (`customerid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquote`
--

LOCK TABLES `estquote` WRITE;
/*!40000 ALTER TABLE `estquote` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquote_covercolors`
--

DROP TABLE IF EXISTS `estquote_covercolors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquote_covercolors` (
  `id` int(11) NOT NULL auto_increment,
  `colorname` varchar(50) NOT NULL default '',
  `cancel` int(5) NOT NULL default '0',
  `sortorder` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `addl_order_charge` decimal(19,5) NOT NULL default '0.00000',
  `addl_each_charge` decimal(19,5) NOT NULL default '0.00000',
  `outin` int(5) NOT NULL default '0',
  `pricelistid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `outin` (`outin`),
  KEY `pricelistid` (`pricelistid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquote_covercolors`
--

LOCK TABLES `estquote_covercolors` WRITE;
/*!40000 ALTER TABLE `estquote_covercolors` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquote_covercolors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquote_deposit`
--

DROP TABLE IF EXISTS `estquote_deposit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquote_deposit` (
  `id` int(11) NOT NULL auto_increment,
  `id_printorder` int(11) NOT NULL default '0',
  `amount` decimal(12,4) NOT NULL default '0.0000',
  `payment_method` int(5) NOT NULL default '0',
  `transaction_id` varchar(32) default NULL,
  `entrydate` date default NULL,
  `cc_type` varchar(20) default NULL,
  `last4ofcard` varchar(4) default NULL,
  `voucherid` int(11) NOT NULL default '0',
  `cancel` int(3) NOT NULL default '0',
  `canceldate` date default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `bankdepositid` int(11) NOT NULL default '0',
  `checkid` varchar(20) NOT NULL default '',
  `currency` varchar(10) NOT NULL default 'USD',
  `bankfee_amount` decimal(19,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`),
  KEY `id_printorder` (`id_printorder`),
  KEY `voucherid` (`voucherid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquote_deposit`
--

LOCK TABLES `estquote_deposit` WRITE;
/*!40000 ALTER TABLE `estquote_deposit` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquote_deposit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteaddlstock`
--

DROP TABLE IF EXISTS `estquoteaddlstock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteaddlstock` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `itemcode` varchar(30) NOT NULL default '',
  `substockqty` int(11) NOT NULL default '0',
  `stockname` varchar(50) default NULL,
  `cancel` int(11) NOT NULL default '0',
  `substocksizeid` int(11) NOT NULL default '0',
  `genstockid` int(11) NOT NULL default '0',
  `substockcolorid` int(11) NOT NULL default '0',
  `substockid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `quoteid` (`quoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteaddlstock`
--

LOCK TABLES `estquoteaddlstock` WRITE;
/*!40000 ALTER TABLE `estquoteaddlstock` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteaddlstock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotebindery`
--

DROP TABLE IF EXISTS `estquotebindery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotebindery` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `composition` int(2) NOT NULL default '0',
  `packaging` int(2) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotebindery`
--

LOCK TABLES `estquotebindery` WRITE;
/*!40000 ALTER TABLE `estquotebindery` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotebindery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotebinderyaddl`
--

DROP TABLE IF EXISTS `estquotebinderyaddl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotebinderyaddl` (
  `id` int(11) NOT NULL auto_increment,
  `estquotebinderyid` int(11) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `question` blob NOT NULL,
  `validreply` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `qtyperpkg` decimal(5,0) NOT NULL default '1',
  `weightpermpkg` decimal(5,2) NOT NULL default '0.00',
  `turnaround` int(11) NOT NULL default '0',
  `tooltip` varchar(255) NOT NULL default '',
  `orderflag` int(11) NOT NULL default '0',
  `internalonly` int(2) NOT NULL default '0',
  `piecework_base` int(2) NOT NULL default '0',
  `piecework_name` varchar(20) default NULL,
  `pieceworkgroupid` int(11) NOT NULL default '0',
  `internal_quote` int(5) NOT NULL default '0',
  `external_quote` int(5) NOT NULL default '0',
  `internal_order` int(5) NOT NULL default '0',
  `external_order` int(5) NOT NULL default '0',
  `printdays` int(11) NOT NULL default '0',
  `replyGreaterThan` int(9) NOT NULL default '0',
  `replyMultiplyBy` decimal(10,6) NOT NULL default '1.000000',
  `maxTextLength` int(11) NOT NULL default '50',
  `monospace` int(5) NOT NULL default '0',
  `blockdisplay` int(5) NOT NULL default '0',
  `mustselect` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `external_quote` (`external_quote`),
  KEY `internal_order` (`internal_order`),
  KEY `internal_quote` (`internal_quote`),
  KEY `external_order` (`external_order`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotebinderyaddl`
--

LOCK TABLES `estquotebinderyaddl` WRITE;
/*!40000 ALTER TABLE `estquotebinderyaddl` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotebinderyaddl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotebinderyaddloptions`
--

DROP TABLE IF EXISTS `estquotebinderyaddloptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotebinderyaddloptions` (
  `id` int(11) NOT NULL auto_increment,
  `binderyaddlid` int(11) NOT NULL default '0',
  `prompt` varchar(50) NOT NULL default '',
  `numprompt` decimal(10,2) NOT NULL default '0.00',
  `orderflag` int(11) NOT NULL default '0',
  `glaccountid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `binderyaddlid` (`binderyaddlid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotebinderyaddloptions`
--

LOCK TABLES `estquotebinderyaddloptions` WRITE;
/*!40000 ALTER TABLE `estquotebinderyaddloptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotebinderyaddloptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotebinderyaddloptionsize`
--

DROP TABLE IF EXISTS `estquotebinderyaddloptionsize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotebinderyaddloptionsize` (
  `id` int(11) NOT NULL auto_increment,
  `binderyaddlid` int(11) NOT NULL default '0',
  `binderyaddloptionsid` int(11) NOT NULL default '0',
  `estquotebinderyaddlsizeid` int(11) NOT NULL default '0',
  `amountaddl` decimal(19,5) NOT NULL default '0.00000',
  `setupaddl` decimal(5,2) NOT NULL default '0.00',
  `minimumaddl` decimal(5,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `binderyaddlid` (`binderyaddlid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotebinderyaddloptionsize`
--

LOCK TABLES `estquotebinderyaddloptionsize` WRITE;
/*!40000 ALTER TABLE `estquotebinderyaddloptionsize` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotebinderyaddloptionsize` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotebinderyaddlsize`
--

DROP TABLE IF EXISTS `estquotebinderyaddlsize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotebinderyaddlsize` (
  `id` int(11) NOT NULL auto_increment,
  `estquotebinderyaddlid` int(11) NOT NULL default '0',
  `estquotestdsizeid` int(11) NOT NULL default '0',
  `amount` decimal(5,2) NOT NULL default '0.00',
  `setupcharge` decimal(5,2) NOT NULL default '0.00',
  `minreply` decimal(10,2) NOT NULL default '0.00',
  `maxreply` decimal(10,2) NOT NULL default '0.00',
  `minimumcharge` decimal(5,2) NOT NULL default '0.00',
  `calculatehow` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `maxpass` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotebinderyaddlsize`
--

LOCK TABLES `estquotebinderyaddlsize` WRITE;
/*!40000 ALTER TABLE `estquotebinderyaddlsize` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotebinderyaddlsize` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotebinderyworktype`
--

DROP TABLE IF EXISTS `estquotebinderyworktype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotebinderyworktype` (
  `estquotebinderyid` int(11) NOT NULL default '0',
  `estquoteworktypeid` int(11) NOT NULL default '0',
  KEY `estquotebinderyid` (`estquotebinderyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotebinderyworktype`
--

LOCK TABLES `estquotebinderyworktype` WRITE;
/*!40000 ALTER TABLE `estquotebinderyworktype` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotebinderyworktype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotefile`
--

DROP TABLE IF EXISTS `estquotefile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotefile` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `filename` char(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `filename` (`filename`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotefile`
--

LOCK TABLES `estquotefile` WRITE;
/*!40000 ALTER TABLE `estquotefile` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotefile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotegenink`
--

DROP TABLE IF EXISTS `estquotegenink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotegenink` (
  `id` int(11) NOT NULL auto_increment,
  `maxcolors` int(11) NOT NULL default '1',
  `regcharge` decimal(4,2) NOT NULL default '0.00',
  `gencompanyid` int(11) NOT NULL default '0',
  `namecov1` char(20) NOT NULL default '',
  `namecov2` char(20) NOT NULL default '',
  `namecov3` char(20) NOT NULL default '',
  `namecov4` char(20) NOT NULL default '',
  `namecov5` char(20) NOT NULL default '',
  `namecov6` char(20) NOT NULL default '',
  `namecov7` char(20) NOT NULL default '',
  `namecov8` char(20) NOT NULL default '',
  `namecov9` char(20) NOT NULL default '',
  `covpct1` decimal(3,0) NOT NULL default '0',
  `covpct2` decimal(3,0) NOT NULL default '0',
  `covpct3` decimal(3,0) NOT NULL default '0',
  `covpct4` decimal(3,0) NOT NULL default '0',
  `covpct5` decimal(3,0) NOT NULL default '0',
  `covpct6` decimal(3,0) NOT NULL default '0',
  `covpct7` decimal(3,0) NOT NULL default '0',
  `covpct8` decimal(3,0) NOT NULL default '0',
  `covpct9` decimal(3,0) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotegenink`
--

LOCK TABLES `estquotegenink` WRITE;
/*!40000 ALTER TABLE `estquotegenink` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotegenink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotegenstock`
--

DROP TABLE IF EXISTS `estquotegenstock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotegenstock` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(30) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `orderflag` int(11) NOT NULL default '0',
  `stdsizeid` int(5) NOT NULL default '0',
  `notforb2b` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotegenstock`
--

LOCK TABLES `estquotegenstock` WRITE;
/*!40000 ALTER TABLE `estquotegenstock` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotegenstock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotegenstock_inks`
--

DROP TABLE IF EXISTS `estquotegenstock_inks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotegenstock_inks` (
  `id` int(11) NOT NULL auto_increment,
  `inkid` int(11) NOT NULL default '0',
  `estquotegenstockid` int(11) NOT NULL default '0',
  `sides` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `estquotegenstockid` (`estquotegenstockid`),
  KEY `inkid` (`inkid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotegenstock_inks`
--

LOCK TABLES `estquotegenstock_inks` WRITE;
/*!40000 ALTER TABLE `estquotegenstock_inks` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotegenstock_inks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteink`
--

DROP TABLE IF EXISTS `estquoteink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteink` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(50) NOT NULL default '',
  `jobprice` decimal(6,2) NOT NULL default '0.00',
  `mprice` decimal(6,4) NOT NULL default '0.0000',
  `type` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `costbased` int(11) NOT NULL default '0',
  `costper` decimal(6,2) NOT NULL default '0.00',
  `coverage` int(11) NOT NULL default '0',
  `setup` decimal(19,5) NOT NULL default '0.00000',
  `always_setup` int(5) NOT NULL default '0',
  `always_perM` int(5) NOT NULL default '0',
  `inkcountifvirtual` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteink`
--

LOCK TABLES `estquoteink` WRITE;
/*!40000 ALTER TABLE `estquoteink` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteorderreceived_how`
--

DROP TABLE IF EXISTS `estquoteorderreceived_how`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteorderreceived_how` (
  `id` int(11) NOT NULL auto_increment,
  `description` text NOT NULL,
  `cancel` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteorderreceived_how`
--

LOCK TABLES `estquoteorderreceived_how` WRITE;
/*!40000 ALTER TABLE `estquoteorderreceived_how` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteorderreceived_how` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotepieceworkgroup`
--

DROP TABLE IF EXISTS `estquotepieceworkgroup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotepieceworkgroup` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) default NULL,
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotepieceworkgroup`
--

LOCK TABLES `estquotepieceworkgroup` WRITE;
/*!40000 ALTER TABLE `estquotepieceworkgroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotepieceworkgroup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotepricelist`
--

DROP TABLE IF EXISTS `estquotepricelist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotepricelist` (
  `id` int(11) NOT NULL auto_increment,
  `stdsizeid` int(11) NOT NULL default '0',
  `worktypeid` int(11) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangeuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `gencompanyid` int(11) NOT NULL default '0',
  `maxinkside1` int(11) NOT NULL default '0',
  `maxinkside2` int(11) NOT NULL default '0',
  `trimchargepermpercut` decimal(8,2) NOT NULL default '0.00',
  `trimmincharge` decimal(8,2) NOT NULL default '0.00',
  `qtyperbox` decimal(5,0) NOT NULL default '0',
  `notes` blob NOT NULL,
  `point2id` int(11) NOT NULL default '0',
  `covereach_blackinandout` decimal(19,5) NOT NULL default '0.00000',
  `covereach_coloroutblackin` decimal(19,5) NOT NULL default '0.00000',
  `covereach_colorinandout` decimal(19,5) NOT NULL default '0.00000',
  `costper_nocover` decimal(19,5) NOT NULL default '0.00000',
  `covereach_colorinblackout` decimal(19,5) NOT NULL default '0.00000',
  `noinkcharge` int(5) NOT NULL default '0',
  `scrap_percent` decimal(5,2) NOT NULL default '0.00',
  `scrap_sheets_max` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotepricelist`
--

LOCK TABLES `estquotepricelist` WRITE;
/*!40000 ALTER TABLE `estquotepricelist` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotepricelist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotepricelist_specials`
--

DROP TABLE IF EXISTS `estquotepricelist_specials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotepricelist_specials` (
  `id` int(11) NOT NULL auto_increment,
  `typeofspecialid` int(11) NOT NULL default '0',
  `pricelistid` int(11) NOT NULL default '0',
  `addlcostper` decimal(19,5) NOT NULL default '0.00000',
  `cancel` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`),
  KEY `pricelistid` (`pricelistid`),
  KEY `typeofspecialid` (`typeofspecialid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotepricelist_specials`
--

LOCK TABLES `estquotepricelist_specials` WRITE;
/*!40000 ALTER TABLE `estquotepricelist_specials` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotepricelist_specials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotepricelistprice`
--

DROP TABLE IF EXISTS `estquotepricelistprice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotepricelistprice` (
  `id` int(11) NOT NULL auto_increment,
  `pricelistid` int(11) NOT NULL default '0',
  `quantity` decimal(10,0) NOT NULL default '0',
  `priceperm` decimal(6,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotepricelistprice`
--

LOCK TABLES `estquotepricelistprice` WRITE;
/*!40000 ALTER TABLE `estquotepricelistprice` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotepricelistprice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotepriceliststock`
--

DROP TABLE IF EXISTS `estquotepriceliststock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotepriceliststock` (
  `id` int(11) NOT NULL auto_increment,
  `pricelistid` int(11) NOT NULL default '0',
  `genstockid` int(11) NOT NULL default '0',
  `substockid` int(11) NOT NULL default '0',
  `addlchargeperm` decimal(6,2) NOT NULL default '0.00',
  `addlmincharge` decimal(6,2) NOT NULL default '0.00',
  `default_number_up` int(11) NOT NULL default '1',
  `default_parts` int(11) NOT NULL default '1',
  `default_partno` varchar(50) default NULL,
  `qtyperbox` int(11) NOT NULL default '0',
  `addlchargemult` decimal(10,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotepriceliststock`
--

LOCK TABLES `estquotepriceliststock` WRITE;
/*!40000 ALTER TABLE `estquotepriceliststock` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotepriceliststock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotepriceliststockcolors`
--

DROP TABLE IF EXISTS `estquotepriceliststockcolors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotepriceliststockcolors` (
  `id` int(11) NOT NULL auto_increment,
  `priceliststockid` int(11) NOT NULL default '0',
  `substockcolorsid` int(11) NOT NULL default '0',
  `default_partno` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotepriceliststockcolors`
--

LOCK TABLES `estquotepriceliststockcolors` WRITE;
/*!40000 ALTER TABLE `estquotepriceliststockcolors` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotepriceliststockcolors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotepricelistupdatelog`
--

DROP TABLE IF EXISTS `estquotepricelistupdatelog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotepricelistupdatelog` (
  `id` int(11) NOT NULL auto_increment,
  `worktypeid` int(11) NOT NULL default '0',
  `pricelistid` int(11) NOT NULL default '0',
  `multiplier` varchar(50) NOT NULL default '',
  `maxinkside1` varchar(50) default NULL,
  `maxinkside2` varchar(50) default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotepricelistupdatelog`
--

LOCK TABLES `estquotepricelistupdatelog` WRITE;
/*!40000 ALTER TABLE `estquotepricelistupdatelog` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotepricelistupdatelog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteqty`
--

DROP TABLE IF EXISTS `estquoteqty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteqty` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `qty` double NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteqty`
--

LOCK TABLES `estquoteqty` WRITE;
/*!40000 ALTER TABLE `estquoteqty` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteqty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequest`
--

DROP TABLE IF EXISTS `estquotequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequest` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `questionid` int(11) NOT NULL default '0',
  `yesno` int(11) NOT NULL default '0',
  `selection` double NOT NULL default '0',
  `text` char(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequest`
--

LOCK TABLES `estquotequest` WRITE;
/*!40000 ALTER TABLE `estquotequest` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote`
--

DROP TABLE IF EXISTS `estquotequote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote` (
  `id` int(11) NOT NULL auto_increment,
  `customerid` int(11) NOT NULL default '0',
  `contactname` varchar(50) default NULL,
  `stdsizeid` int(11) NOT NULL default '0',
  `cwidth` decimal(10,3) NOT NULL default '0.000',
  `clength` decimal(10,3) NOT NULL default '0.000',
  `substockid` int(11) NOT NULL default '0',
  `tightreg1` int(11) NOT NULL default '0',
  `tightreg2` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `description` varchar(255) default NULL,
  `substockcolorid` int(11) NOT NULL default '0',
  `shippingservice` char(3) default NULL,
  `shippingzipcode` varchar(12) default NULL,
  `special` varchar(255) default NULL,
  `quotenum` varchar(20) default NULL,
  `extuser` double NOT NULL default '0',
  `genuser` double NOT NULL default '0',
  `pricelistid` int(11) NOT NULL default '0',
  `duedate` date default NULL,
  `finalshipdate` date default NULL,
  `status` int(5) NOT NULL default '0',
  `billdate` date default NULL,
  `order_quantity` int(11) NOT NULL default '0',
  `shiptotal` decimal(12,2) NOT NULL default '0.00',
  `billtotal` decimal(12,2) NOT NULL default '0.00',
  `orderdate` date default NULL,
  `instructions` varchar(255) default NULL,
  `id_printorder` int(11) NOT NULL default '0',
  `extras` int(11) NOT NULL default '0',
  `numup` int(11) NOT NULL default '1',
  `itemid` int(11) NOT NULL default '0',
  `papername` varchar(50) default NULL,
  `paperwidth` decimal(12,3) NOT NULL default '0.000',
  `paperlength` decimal(12,3) NOT NULL default '0.000',
  `priority` int(2) NOT NULL default '0',
  `formnumber` varchar(50) default NULL,
  `numparts` int(11) NOT NULL default '1',
  `salesglacctid` int(11) NOT NULL default '0',
  `presslength` decimal(12,2) NOT NULL default '0.00',
  `presswidth` decimal(12,2) NOT NULL default '0.00',
  `customer_po` varchar(30) default NULL,
  `print_how` int(2) NOT NULL default '0',
  `rush_charge` decimal(12,4) NOT NULL default '0.0000',
  `composition_charge` decimal(12,4) NOT NULL default '0.0000',
  `glrush` int(11) NOT NULL default '0',
  `glcomposition` int(11) NOT NULL default '0',
  `reprint` int(11) NOT NULL default '0',
  `printdate` date default NULL,
  `calculated_qty` decimal(12,5) NOT NULL default '0.00000',
  `sell_total` decimal(12,5) NOT NULL default '0.00000',
  `calculated_total` decimal(14,5) NOT NULL default '0.00000',
  `previous_id_printorder` int(11) NOT NULL default '0',
  `client_notes` text,
  `confirm_date` date default NULL,
  `sigmult` int(11) NOT NULL default '1',
  `parts_separate` int(5) NOT NULL default '0',
  `addparts` int(5) NOT NULL default '0',
  `thispart` int(11) NOT NULL default '0',
  `invoiceto_companyid` int(11) NOT NULL default '0',
  `order_discount_percent` decimal(4,2) NOT NULL default '0.00',
  `preferred_shipdate` date default NULL,
  `receivedate` date default NULL,
  `shipbefore` date default NULL,
  `shipafter` int(5) NOT NULL default '5',
  `orderyear` varchar(4) NOT NULL default '',
  `art_number` varchar(30) NOT NULL default '',
  `reorder` int(5) NOT NULL default '0',
  `ordertaker` varchar(10) NOT NULL default '',
  `problem` int(5) NOT NULL default '0',
  `rush` int(5) NOT NULL default '0',
  `order_sourceid` int(11) NOT NULL default '0',
  `sales_responseid` int(11) NOT NULL default '0',
  `shipnote` varchar(100) NOT NULL default '',
  `ok` int(5) NOT NULL default '0',
  `okdate` date default NULL,
  `topress` int(5) NOT NULL default '0',
  `topressdate` date default NULL,
  `print_what_on_covers` int(5) NOT NULL default '0',
  `rescom` int(5) NOT NULL default '0',
  `couponid` int(11) NOT NULL default '0',
  `coupon_amount` decimal(16,5) NOT NULL default '0.00000',
  `pricepercover` decimal(19,5) NOT NULL default '0.00000',
  `priceperspecialdesign` decimal(19,5) NOT NULL default '0.00000',
  `pricepercolorborder` decimal(19,5) NOT NULL default '0.00000',
  `priceperpremium` decimal(19,5) NOT NULL default '0.00000',
  `priceperstandard` decimal(19,5) NOT NULL default '0.00000',
  `totalpriceperbook` decimal(19,5) NOT NULL default '0.00000',
  `basepriceperbook` decimal(19,5) NOT NULL default '0.00000',
  `totaldiscountamount` decimal(19,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`),
  KEY `duedate` (`duedate`),
  KEY `duedate_2` (`duedate`),
  KEY `customerid` (`customerid`),
  KEY `itemid` (`itemid`),
  KEY `id_printorder` (`id_printorder`),
  KEY `formnumber` (`formnumber`),
  KEY `orderdate` (`orderdate`),
  KEY `finalshipdate` (`finalshipdate`),
  KEY `confirm_date` (`confirm_date`),
  KEY `invoiceto_companyid` (`invoiceto_companyid`),
  KEY `ok` (`ok`),
  KEY `topress` (`topress`),
  KEY `cancel` (`cancel`),
  KEY `gencompanyid` (`gencompanyid`),
  KEY `order_quantity` (`order_quantity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote`
--

LOCK TABLES `estquotequote` WRITE;
/*!40000 ALTER TABLE `estquotequote` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote_covers`
--

DROP TABLE IF EXISTS `estquotequote_covers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote_covers` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `outside_cover_design_nr` varchar(30) NOT NULL default '',
  `outside_cover_color5id` int(11) NOT NULL default '0',
  `outside_cover_permit_nr` varchar(50) NOT NULL default '',
  `inside_cover_color5id` int(11) NOT NULL default '0',
  `inside_cover_special_print` varchar(100) NOT NULL default '',
  `inside_cover_color1id` int(11) NOT NULL default '0',
  `nocovers` int(5) NOT NULL default '0',
  `nowindow` int(5) NOT NULL default '0',
  `large_diecut` int(5) NOT NULL default '0',
  `outside_cover_color1id` int(11) NOT NULL default '0',
  `outside_cover_color2id` int(11) NOT NULL default '0',
  `outside_cover_color3id` int(11) NOT NULL default '0',
  `outside_cover_color4id` int(11) NOT NULL default '0',
  `outside_custom_color1` varchar(30) NOT NULL default '',
  `outside_custom_color2` varchar(30) NOT NULL default '',
  `inside_cover_color2id` int(11) NOT NULL default '0',
  `inside_cover_color3id` int(11) NOT NULL default '0',
  `inside_cover_color4id` int(11) NOT NULL default '0',
  `inside_custom_color1` varchar(30) NOT NULL default '',
  `inside_custom_color2` varchar(30) NOT NULL default '',
  `covernumber` int(5) NOT NULL default '0',
  `inside_cover_design_nr` varchar(30) NOT NULL default '',
  `covertotal` decimal(19,5) NOT NULL default '0.00000',
  `inhouse_or_custom` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`),
  KEY `covernumber` (`covernumber`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote_covers`
--

LOCK TABLES `estquotequote_covers` WRITE;
/*!40000 ALTER TABLE `estquotequote_covers` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequote_covers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote_envelopes`
--

DROP TABLE IF EXISTS `estquotequote_envelopes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote_envelopes` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `specialdate` date default NULL,
  `line1` varchar(100) NOT NULL default '',
  `line2` varchar(100) NOT NULL default '',
  `line3` varchar(100) NOT NULL default '',
  `dating_type` int(5) default NULL,
  `premium_color` varchar(30) default NULL,
  `border_color` varchar(30) default NULL,
  `custom_color` varchar(30) default NULL,
  `custom_design_nr` varchar(30) default NULL,
  `ink_description` int(5) NOT NULL default '0',
  `ink_name` int(5) NOT NULL default '0',
  `ink_date` int(5) NOT NULL default '0',
  `sortorder` int(11) NOT NULL default '0',
  `costper` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `specialdate` (`specialdate`),
  KEY `quoteid` (`quoteid`),
  KEY `sortorder` (`sortorder`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote_envelopes`
--

LOCK TABLES `estquotequote_envelopes` WRITE;
/*!40000 ALTER TABLE `estquotequote_envelopes` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequote_envelopes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote_instructions`
--

DROP TABLE IF EXISTS `estquotequote_instructions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote_instructions` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `workareaid` int(11) NOT NULL default '0',
  `instructions` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `workareaid` (`workareaid`),
  KEY `quoteid` (`quoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote_instructions`
--

LOCK TABLES `estquotequote_instructions` WRITE;
/*!40000 ALTER TABLE `estquotequote_instructions` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequote_instructions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote_items`
--

DROP TABLE IF EXISTS `estquotequote_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote_items` (
  `id` int(11) NOT NULL auto_increment,
  `itemid` int(11) NOT NULL default '0',
  `qty` int(11) NOT NULL default '0',
  `id_printorder` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `entrydate` date default NULL,
  `itemtransid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `id_printorder` (`id_printorder`),
  KEY `itemid` (`itemid`),
  KEY `cancel` (`cancel`),
  KEY `itemtransid` (`itemtransid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote_items`
--

LOCK TABLES `estquotequote_items` WRITE;
/*!40000 ALTER TABLE `estquotequote_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequote_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote_shipment`
--

DROP TABLE IF EXISTS `estquotequote_shipment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote_shipment` (
  `id_shipment` int(11) NOT NULL default '0',
  `id_order_shipto` int(11) NOT NULL default '0',
  `quantity` int(15) NOT NULL default '0',
  `shipdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_shipmentlog` int(11) NOT NULL default '0',
  `packslip` int(2) NOT NULL default '0',
  `boxlabel` int(2) NOT NULL default '0',
  `logdate` datetime default NULL,
  `createdate` date default NULL,
  `id_user_create` int(11) NOT NULL default '0',
  `lastrevisedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_user_revise` int(11) NOT NULL default '0',
  `canceldate` date default NULL,
  `cancel` int(11) NOT NULL default '0',
  `signfor` varchar(255) default NULL,
  `failed` int(11) NOT NULL default '0',
  `id_printorder` int(11) NOT NULL default '0',
  `notes` varchar(255) default NULL,
  `id_order_shipment_group` int(11) NOT NULL default '0',
  `trackingnum` varchar(30) default NULL,
  `invoiceid` int(11) NOT NULL default '0',
  `freight` decimal(12,2) NOT NULL default '0.00',
  `carrierserviceid` int(11) NOT NULL default '0',
  `numperbox` int(11) NOT NULL default '0',
  `numboxes` int(11) NOT NULL default '0',
  `id_estquoteship` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_shipment`),
  KEY `id_order_shipto` (`id_order_shipto`),
  KEY `id_order_shipment_group` (`id_order_shipment_group`),
  KEY `id_printorder` (`id_printorder`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote_shipment`
--

LOCK TABLES `estquotequote_shipment` WRITE;
/*!40000 ALTER TABLE `estquotequote_shipment` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequote_shipment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote_shipmentseq`
--

DROP TABLE IF EXISTS `estquotequote_shipmentseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote_shipmentseq` (
  `id` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote_shipmentseq`
--

LOCK TABLES `estquotequote_shipmentseq` WRITE;
/*!40000 ALTER TABLE `estquotequote_shipmentseq` DISABLE KEYS */;
INSERT INTO `estquotequote_shipmentseq` VALUES (0);
/*!40000 ALTER TABLE `estquotequote_shipmentseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequote_specials`
--

DROP TABLE IF EXISTS `estquotequote_specials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequote_specials` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `specialdatesid` int(11) NOT NULL default '0',
  `specialdate` date default NULL,
  `line1` varchar(100) NOT NULL default '',
  `line2` varchar(100) NOT NULL default '',
  `line3` varchar(100) NOT NULL default '',
  `dating_type` int(5) default NULL,
  `premium_color` varchar(30) default NULL,
  `border_color` varchar(30) default NULL,
  `custom_color` varchar(30) default NULL,
  `custom_design_nr` varchar(30) default NULL,
  `ink_description` int(5) NOT NULL default '0',
  `ink_name` int(5) NOT NULL default '0',
  `insert_where_if_samedate` int(5) NOT NULL default '0',
  `sequence` int(5) NOT NULL default '0',
  `std` int(5) NOT NULL default '0',
  `thisorlast` int(5) NOT NULL default '0',
  `ink_date` int(5) NOT NULL default '0',
  `repeating` int(5) NOT NULL default '0',
  `eachday` int(5) NOT NULL default '0',
  `costper` decimal(19,5) NOT NULL default '0.00000',
  `costtotal` decimal(19,5) NOT NULL default '0.00000',
  `binderyaddloptionsid` int(11) NOT NULL default '0',
  `binderyid` int(11) NOT NULL default '3',
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`),
  KEY `specialdatesid` (`specialdatesid`),
  KEY `std` (`std`),
  KEY `sequence` (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequote_specials`
--

LOCK TABLES `estquotequote_specials` WRITE;
/*!40000 ALTER TABLE `estquotequote_specials` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequote_specials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequotebindquest`
--

DROP TABLE IF EXISTS `estquotequotebindquest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequotebindquest` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `questionid` int(11) NOT NULL default '0',
  `yesno` int(11) NOT NULL default '0',
  `numbetween` double NOT NULL default '0',
  `text` varchar(100) NOT NULL default '',
  `snumbetween` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`),
  KEY `numbetween` (`numbetween`),
  KEY `snumbetween` (`snumbetween`),
  KEY `questionid` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequotebindquest`
--

LOCK TABLES `estquotequotebindquest` WRITE;
/*!40000 ALTER TABLE `estquotequotebindquest` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequotebindquest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequoteink`
--

DROP TABLE IF EXISTS `estquotequoteink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequoteink` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `side` int(11) NOT NULL default '1',
  `inkid` int(11) NOT NULL default '0',
  `pms` char(4) default NULL,
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequoteink`
--

LOCK TABLES `estquotequoteink` WRITE;
/*!40000 ALTER TABLE `estquotequoteink` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequoteink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequotenotes`
--

DROP TABLE IF EXISTS `estquotequotenotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequotenotes` (
  `id` int(11) NOT NULL auto_increment,
  `quotebold` varchar(50) NOT NULL default '',
  `quotetext` blob NOT NULL,
  `showwhen` int(11) NOT NULL default '0',
  `orderflag` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangeuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequotenotes`
--

LOCK TABLES `estquotequotenotes` WRITE;
/*!40000 ALTER TABLE `estquotequotenotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequotenotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequoteqty`
--

DROP TABLE IF EXISTS `estquotequoteqty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequoteqty` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `qty` double NOT NULL default '0',
  `weight` decimal(10,2) NOT NULL default '0.00',
  `total` decimal(10,2) NOT NULL default '0.00',
  `shipcost` decimal(10,2) NOT NULL default '0.00',
  `turnaround` int(11) NOT NULL default '1',
  `mcost` decimal(10,2) NOT NULL default '0.00',
  `comptotal` double NOT NULL default '0',
  `boxes` int(11) NOT NULL default '0',
  `printdays` int(11) NOT NULL default '0',
  `covers` decimal(19,5) NOT NULL default '0.00000',
  `specials` decimal(19,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`),
  KEY `qty` (`qty`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequoteqty`
--

LOCK TABLES `estquotequoteqty` WRITE;
/*!40000 ALTER TABLE `estquotequoteqty` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequoteqty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotequotequest`
--

DROP TABLE IF EXISTS `estquotequotequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotequotequest` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `questionid` int(11) NOT NULL default '0',
  `yesno` int(11) NOT NULL default '0',
  `numbetween` double NOT NULL default '0',
  `text` char(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `quoteid` (`quoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotequotequest`
--

LOCK TABLES `estquotequotequest` WRITE;
/*!40000 ALTER TABLE `estquotequotequest` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotequotequest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotesalescampaign`
--

DROP TABLE IF EXISTS `estquotesalescampaign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotesalescampaign` (
  `id` int(11) NOT NULL auto_increment,
  `description` text NOT NULL,
  `hide` int(5) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `hide` (`hide`),
  KEY `cancel` (`cancel`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotesalescampaign`
--

LOCK TABLES `estquotesalescampaign` WRITE;
/*!40000 ALTER TABLE `estquotesalescampaign` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotesalescampaign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteship`
--

DROP TABLE IF EXISTS `estquoteship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteship` (
  `id` int(11) NOT NULL auto_increment,
  `id_printorder` double NOT NULL default '0',
  `shiptoid` int(11) NOT NULL default '0',
  `carrierserviceid` int(11) NOT NULL default '0',
  `shipqty` double NOT NULL default '0',
  `attn` varchar(50) NOT NULL default '',
  `weight` double NOT NULL default '0',
  `cost` double NOT NULL default '0',
  `boxes` int(11) NOT NULL default '0',
  `zipcode` varchar(12) NOT NULL default '0',
  `qtyperfullbox` int(11) NOT NULL default '0',
  `packages` int(11) NOT NULL default '0',
  `client_po` varchar(30) default NULL,
  `invoiceid` int(11) NOT NULL default '0',
  `client_name` varchar(100) default NULL,
  `shiptoname` varchar(255) default NULL,
  `shiptoaddress` varchar(255) default NULL,
  `shiptoaddress2` varchar(255) default NULL,
  `shiptocity` varchar(50) default NULL,
  `shiptostate` varchar(20) default NULL,
  `shiptozip` varchar(15) default NULL,
  `shiptophone` varchar(20) default NULL,
  `shipfromname` varchar(255) default NULL,
  `shipfromaddress` varchar(255) default NULL,
  `shipfromaddress2` varchar(255) default NULL,
  `shipfromcity` varchar(50) default NULL,
  `shipfromstate` varchar(20) default NULL,
  `shipfromzip` varchar(15) default NULL,
  `shipper_number` varchar(30) default NULL,
  `billto` varchar(20) default NULL,
  `shipname2` varchar(50) NOT NULL default '',
  `rescom` int(5) NOT NULL default '0',
  `customer_email` varchar(50) NOT NULL default '',
  `csr_email` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `carrierserviceid` (`carrierserviceid`),
  KEY `shiptoid` (`shiptoid`),
  KEY `id_printorder` (`id_printorder`),
  KEY `invoiceid` (`invoiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteship`
--

LOCK TABLES `estquoteship` WRITE;
/*!40000 ALTER TABLE `estquoteship` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotestdsize`
--

DROP TABLE IF EXISTS `estquotestdsize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotestdsize` (
  `id` int(11) NOT NULL auto_increment,
  `length` decimal(10,3) NOT NULL default '0.000',
  `width` decimal(10,3) NOT NULL default '0.000',
  `gencompanyid` int(11) NOT NULL default '0',
  `orderflag` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotestdsize`
--

LOCK TABLES `estquotestdsize` WRITE;
/*!40000 ALTER TABLE `estquotestdsize` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotestdsize` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotestock`
--

DROP TABLE IF EXISTS `estquotestock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotestock` (
  `id` int(11) NOT NULL auto_increment,
  `quoteid` int(11) NOT NULL default '0',
  `stockusageid` int(11) NOT NULL default '0',
  `stocklistid` int(11) NOT NULL default '0',
  `flatwidth` decimal(5,4) NOT NULL default '0.0000',
  `flatheight` decimal(5,4) NOT NULL default '0.0000',
  `numpages` double NOT NULL default '0',
  `notes` blob,
  PRIMARY KEY  (`id`),
  KEY `stockusageid` (`stockusageid`),
  KEY `stocklistid` (`stocklistid`),
  KEY `quoteid` (`quoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotestock`
--

LOCK TABLES `estquotestock` WRITE;
/*!40000 ALTER TABLE `estquotestock` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotestock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotestockink`
--

DROP TABLE IF EXISTS `estquotestockink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotestockink` (
  `id` int(11) NOT NULL auto_increment,
  `quotestockid` int(11) NOT NULL default '0',
  `inkid` int(11) NOT NULL default '0',
  `side` int(11) NOT NULL default '1',
  `inknum` int(11) NOT NULL default '0',
  `coverage` decimal(5,4) NOT NULL default '0.0000',
  PRIMARY KEY  (`id`),
  KEY `quotestockid` (`quotestockid`),
  KEY `inkid` (`inkid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotestockink`
--

LOCK TABLES `estquotestockink` WRITE;
/*!40000 ALTER TABLE `estquotestockink` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotestockink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotestocktool`
--

DROP TABLE IF EXISTS `estquotestocktool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotestocktool` (
  `id` int(11) NOT NULL auto_increment,
  `quotestockid` int(11) NOT NULL default '0',
  `toolid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `quotestockid` (`quotestockid`),
  KEY `toolid` (`toolid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotestocktool`
--

LOCK TABLES `estquotestocktool` WRITE;
/*!40000 ALTER TABLE `estquotestocktool` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotestocktool` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotesubstock`
--

DROP TABLE IF EXISTS `estquotesubstock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotesubstock` (
  `id` int(11) NOT NULL auto_increment,
  `estquotegenstockid` int(11) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `weight` decimal(6,4) NOT NULL default '0.0000',
  `turnaround` int(11) NOT NULL default '0',
  `orderflag` int(11) NOT NULL default '0',
  `parts` int(11) NOT NULL default '1',
  `inchesperm` decimal(4,2) NOT NULL default '0.00',
  `parts_separate` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `estquotegenstockid` (`estquotegenstockid`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotesubstock`
--

LOCK TABLES `estquotesubstock` WRITE;
/*!40000 ALTER TABLE `estquotesubstock` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotesubstock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotesubstockcolors`
--

DROP TABLE IF EXISTS `estquotesubstockcolors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotesubstockcolors` (
  `id` int(11) NOT NULL auto_increment,
  `substockid` int(11) NOT NULL default '0',
  `color` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `substockid` (`substockid`),
  KEY `color` (`color`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotesubstockcolors`
--

LOCK TABLES `estquotesubstockcolors` WRITE;
/*!40000 ALTER TABLE `estquotesubstockcolors` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotesubstockcolors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotesubstockcolorsize`
--

DROP TABLE IF EXISTS `estquotesubstockcolorsize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotesubstockcolorsize` (
  `id` int(11) NOT NULL auto_increment,
  `substockid` int(11) NOT NULL default '0',
  `substockcolorid` int(11) NOT NULL default '0',
  `sizename` varchar(20) default NULL,
  `partno` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `substockid` (`substockid`),
  KEY `substockcolorid` (`substockcolorid`),
  KEY `partno` (`partno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotesubstockcolorsize`
--

LOCK TABLES `estquotesubstockcolorsize` WRITE;
/*!40000 ALTER TABLE `estquotesubstockcolorsize` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotesubstockcolorsize` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotesubstockcost`
--

DROP TABLE IF EXISTS `estquotesubstockcost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotesubstockcost` (
  `id` int(11) NOT NULL auto_increment,
  `substockid` int(11) NOT NULL default '0',
  `stocktype` int(11) NOT NULL default '0',
  `length` decimal(10,4) NOT NULL default '0.0000',
  `width` decimal(10,4) NOT NULL default '0.0000',
  `cost` decimal(10,4) NOT NULL default '0.0000',
  `costhow` int(11) NOT NULL default '0',
  `itemid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cost` (`cost`),
  KEY `width` (`width`),
  KEY `itemid` (`itemid`),
  KEY `length` (`length`),
  KEY `substockid` (`substockid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotesubstockcost`
--

LOCK TABLES `estquotesubstockcost` WRITE;
/*!40000 ALTER TABLE `estquotesubstockcost` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotesubstockcost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotesubstocksize`
--

DROP TABLE IF EXISTS `estquotesubstocksize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotesubstocksize` (
  `id` int(11) NOT NULL auto_increment,
  `substockid` int(11) NOT NULL default '0',
  `sizename` varchar(20) default NULL,
  `partno` varchar(50) default NULL,
  `partno2` varchar(50) default NULL,
  `partno3` varchar(50) default NULL,
  `partno4` varchar(50) default NULL,
  `partno5` varchar(50) default NULL,
  `partno6` varchar(50) default NULL,
  `partno7` varchar(50) default NULL,
  `partno8` varchar(50) default NULL,
  `partno9` varchar(50) default NULL,
  `partno10` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `substockid` (`substockid`),
  KEY `partno` (`partno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotesubstocksize`
--

LOCK TABLES `estquotesubstocksize` WRITE;
/*!40000 ALTER TABLE `estquotesubstocksize` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotesubstocksize` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquotetypeofspecial`
--

DROP TABLE IF EXISTS `estquotetypeofspecial`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquotetypeofspecial` (
  `id` int(11) NOT NULL auto_increment,
  `sname` varchar(100) NOT NULL default '',
  `svalue` int(5) NOT NULL default '0',
  `addlcostper` decimal(19,5) NOT NULL default '0.00000',
  `isdefault` int(5) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `isdefault` (`isdefault`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquotetypeofspecial`
--

LOCK TABLES `estquotetypeofspecial` WRITE;
/*!40000 ALTER TABLE `estquotetypeofspecial` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquotetypeofspecial` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteworktype`
--

DROP TABLE IF EXISTS `estquoteworktype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteworktype` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `turnaroundqty` decimal(10,0) NOT NULL default '0',
  `turnarounddaysuptoqty` int(11) NOT NULL default '0',
  `turnarounddaysoverqty` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangeuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `notes` blob NOT NULL,
  `genworktypeid` int(11) NOT NULL default '0',
  `orderflag` int(11) NOT NULL default '0',
  `tightregrule` int(5) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteworktype`
--

LOCK TABLES `estquoteworktype` WRITE;
/*!40000 ALTER TABLE `estquoteworktype` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteworktype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteworktypeaddl`
--

DROP TABLE IF EXISTS `estquoteworktypeaddl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteworktypeaddl` (
  `id` int(11) NOT NULL auto_increment,
  `worktypeid` int(11) NOT NULL default '0',
  `question` char(50) NOT NULL default '',
  `validreply` int(11) NOT NULL default '0',
  `minreply` decimal(10,2) NOT NULL default '0.00',
  `maxreply` decimal(10,2) NOT NULL default '0.00',
  `askonlyifmtblackink` int(11) NOT NULL default '0',
  `askonlyifmtoneink` int(11) NOT NULL default '0',
  `askonlyminsizelength` decimal(10,2) NOT NULL default '0.00',
  `askonlyminsizewidth` decimal(10,2) NOT NULL default '0.00',
  `askonlymaxsizelength` decimal(10,2) NOT NULL default '0.00',
  `askonlymaxsizewidth` decimal(10,2) NOT NULL default '0.00',
  `calculatehow` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `askonlyifmtoneside` int(11) NOT NULL default '0',
  `amount` decimal(5,2) NOT NULL default '0.00',
  `askonlyifoneink` int(11) NOT NULL default '0',
  `aboveqty` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteworktypeaddl`
--

LOCK TABLES `estquoteworktypeaddl` WRITE;
/*!40000 ALTER TABLE `estquoteworktypeaddl` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteworktypeaddl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteworktypegen`
--

DROP TABLE IF EXISTS `estquoteworktypegen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteworktypegen` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(50) NOT NULL default '',
  `gencompanyid` int(11) NOT NULL default '0',
  `orderflag` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteworktypegen`
--

LOCK TABLES `estquoteworktypegen` WRITE;
/*!40000 ALTER TABLE `estquoteworktypegen` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteworktypegen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estquoteworktypestdqty`
--

DROP TABLE IF EXISTS `estquoteworktypestdqty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estquoteworktypestdqty` (
  `id` int(11) NOT NULL auto_increment,
  `quantity` decimal(10,0) NOT NULL default '0',
  `worktypeid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estquoteworktypestdqty`
--

LOCK TABLES `estquoteworktypestdqty` WRITE;
/*!40000 ALTER TABLE `estquoteworktypestdqty` DISABLE KEYS */;
/*!40000 ALTER TABLE `estquoteworktypestdqty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `module` varchar(10) NOT NULL,
  `section` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `link` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `module` (`module`),
  KEY `section` (`section`),
  KEY `action` (`action`),
  KEY `event` (`module`,`section`,`action`)
) ENGINE=MyISAM AUTO_INCREMENT=160 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` VALUES (1,'ar','order','add','arordpicktick.php?caller=1&ordernumber='),(2,'ar','order','update','arordpicktick.php?caller=1&ordernumber='),(3,'ar','order','quote','arordpicktick.php?caller=1&ordernumber='),(4,'ar','order','delete',''),(5,'ar','order','invoice','arinvoiceview.php?caller=1&invoiceid='),(6,'ar','order','shipment',''),(7,'ar','customer','add','arcustupd.php?customerid='),(8,'ar','customer','update','arcustupd.php?customerid='),(9,'ar','customer','delete',''),(10,'ar','shipto','add',''),(11,'ar','shipto','update',''),(12,'ar','shipto','delete',''),(13,'ar','salescategory','add','adminarsales_category.php?id='),(14,'ar','salescategory','update','adminarsales_category.php?id='),(15,'ar','salescategory','delete',''),(16,'ar','rma','add',''),(17,'ar','rma','update',''),(18,'ar','rma','delete',''),(19,'ar','payment','add',''),(20,'ar','salesterritory','edit',''),(21,'ar','salesperson','add','adminarsalesmanupd.php?id='),(22,'ar','salesperson','update','adminarsalesmanupd.php?id='),(23,'ar','salesperson','delete',''),(24,'ar','carrier','add','adminarcarrierupd.php?carrierid='),(25,'ar','carrier','update','adminarcarrierupd.php?carrierid='),(26,'ar','carrier','delete',''),(27,'ar','carriermethod','add',''),(28,'ar','carriermethod','update',''),(29,'ar','carriermethod','delete',''),(30,'ar','bankdeposit','add','arbankdepositupd.php?bankdepositid='),(31,'ar','bankdeposit','delete',''),(32,'ar','creditcheck','write','checks.php?apbill=1&archeck=1&checknbr='),(33,'ar','invoice','add','arinvoiceview.php?caller=1&invoiceid='),(34,'ar','invoice','update','arinvoiceview.php?caller=1&invoiceid='),(35,'ar','invoice','delete',''),(36,'b2b','payment','add',''),(37,'b2b','order','add','arordpicktick.php?caller=1&ordernumber='),(38,'b2b','customer','update','arcustupd.php?customerid='),(39,'inv','item','add','invitemupd.php?itemid='),(40,'inv','item','update','invitemupd.php?itemid='),(41,'inv','item','delete',''),(42,'inv','item','adjustment',''),(43,'inv','item','transfer',''),(44,'inv','itemvendor','add',''),(45,'inv','itemvendor','update',''),(46,'inv','itemvendor','delete',''),(47,'inv','itemlocation','add',''),(48,'inv','itemlocation','update',''),(49,'inv','itemlocation','delete',''),(50,'gl','voucher','add','gljourupd.php?selectv=1&vid='),(51,'gl','voucher','update','gljourupd.php?selectv=1&vid='),(52,'gl','voucher','delete',''),(53,'gl','voucher','post',''),(54,'gl','voucher','postreverse',''),(55,'gl','year','close',''),(56,'gl','account','add','glacctupd.php?id='),(57,'gl','account','update','glacctupd.php?id='),(58,'gl','account','delete',''),(59,'gl','account','reactivate','glacctupd.php?id='),(60,'gl','bank','reconcile',''),(61,'pr','employee','add','premployeeupd.php?employeeid='),(62,'pr','employee','update','premployeeupd.php?employeeid='),(63,'pr','period','calculate',''),(64,'pr','check','edit',''),(65,'pr','check','write',''),(66,'pr','hours','add',''),(67,'pr','employeededuction','add',''),(68,'pr','employeededuction','update',''),(69,'pr','employeededuction','delete',''),(70,'pr','generaldeduction','add',''),(71,'pr','generaldeduction','update',''),(72,'pr','generaldeduction','delete',''),(73,'pr','generalbenefit','add',''),(74,'pr','generalbenefit','update',''),(75,'pr','generalbenefit','delete',''),(76,'pr','generalfactors','update',''),(77,'pr','companycontribution','add',''),(78,'pr','companycontribution','update',''),(79,'pr','companycontribution','delete',''),(80,'pr','pension','add',''),(81,'pr','pension','update',''),(82,'pr','pension','delete',''),(83,'ap','bill','add','apbillupd.php?apbillid='),(84,'ap','bill','update','apbillupd.php?apbillid='),(85,'ap','bill','delete',''),(86,'ap','manualcheck','write','checks.php?apbill=1&checknbr='),(87,'ap','commissioncheck','write','checks.php?apbill=1&checknbr='),(88,'ap','preapprovedcheck','write','checks.php?apbill=1&checknbr='),(89,'ap','check','write','checks.php?apbill=1&checknbr='),(90,'ap','check','cashed',''),(91,'ap','check','uncashed',''),(92,'ap','check','void','checks.php?apbill=1&checknbr='),(93,'ap','vendor','add','apvendupd.php?id='),(94,'ap','vendor','update','apvendupd.php?id='),(95,'ap','vendor','delete',''),(96,'ap','po','add','invpoupd.php?invpoid='),(97,'ap','po','update','invpoupd.php?invpoid='),(98,'ap','po','delete',''),(99,'ap','po','receive','invporecv.php?submit=1&invpoid='),(100,'ap','po','passtoap',''),(101,'ap','withoutpo','receive',''),(102,'admin','user','add','genuserupd.php?id='),(103,'admin','user','update','genuserupd.php?id='),(104,'admin','user','delete',''),(105,'admin','company','add','gencompanyupd.php?id='),(106,'admin','company','update','gencompanyupd.php?id='),(107,'admin','company','delete',''),(108,'admin','emailcenter','send',''),(109,'admin','user','login','genuserupd.php?id='),(110,'ar','paymentplan','add','arpayplanupd.php?invoiceid='),(111,'ar','paymentplan','update','arpayplanupd.php?invoiceid='),(112,'ar','paymentplan','delete',''),(113,'ar','paymentplan','post','arinvoiceview.php?caller=1&invoiceid='),(114,'ar','order','serviceticketpdf',''),(115,'inv','inventorylocation','add','admininvlocationupd.php?id='),(116,'inv','inventorylocation','update','admininvlocationupd.php?id='),(117,'inv','inventorylocation','delete',''),(118,'ar','invoice','printpdf',''),(119,'admin','user','logout','genuserupd.php?id='),(120,'admin','nolog','loginpage',''),(121,'admin','import','customers',''),(122,'admin','import','employees',''),(123,'admin','import','gltotals',''),(124,'admin','import','itemcategories',''),(125,'admin','import','items',''),(126,'admin','import','vendors',''),(127,'ar','nolog','invoicebutton',''),(128,'ar','nolog','invoicereprintbutton',''),(129,'ar','nolog','serviceorderbutton',''),(130,'ar','nolog','pospmt',''),(131,'inv','nolog','price',''),(132,'ar','order','printpdf',''),(133,'ap','po','printpdf',''),(134,'ap','bill','printpdf',''),(135,'ar','receipt','printpdf',''),(136,'inv','nolog','onhand',''),(137,'inv','prices','edit',''),(138,'ap','eft','download',''),(139,'ar','eft','download',''),(140,'ar','order','magentoimport',''),(141,'admin','department','add','department.php?cmd=edit&departmentid='),(142,'admin','department','update','department.php?cmd=edit&departmentid='),(143,'admin','department','delete',''),(144,'pr','prworkerscomp','add','prworkerscomp.php?cmd=edit&prworkerscompid='),(145,'pr','prworkerscomp','update','prworkerscomp.php?cmd=edit&prworkerscompid='),(146,'pr','prworkerscomp','delete',''),(147,'admin','taxclass','add','taxclass.php?cmd=edit&taxclassid='),(148,'admin','taxclass','update','taxclass.php?cmd=edit&taxclassid='),(149,'admin','taxclass','delete',''),(150,'ar','appointment','book','!/index.php?/appointments/reportCustomerHistory/?&customerid='),(151,'ar','appointment','unbook','!/index.php?/appointments/reportCustomerHistory/?&customerid='),(152,'ar','appointment','servicechange','!/index.php?/appointments/reportCustomerHistory/?&customerid='),(153,'ar','appointment','schedulecreate',''),(154,'ar','appointment','schedulecancel',''),(155,'ar','appointment','hostchange',''),(156,'ar','appointment','reserve',''),(157,'ar','appointment','unreserve',''),(158,'ar','appointment','checkin',''),(159,'b2b','user','login','');
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eventlog`
--

DROP TABLE IF EXISTS `eventlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `eventlog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `companyid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `extuserid` int(11) NOT NULL default '0',
  `module` varchar(10) NOT NULL,
  `section` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `eventtable` varchar(100) default NULL,
  `eventid` int(10) unsigned default NULL,
  `data` text NOT NULL,
  `entrydate` datetime NOT NULL,
  `ip` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `companyid` (`companyid`),
  KEY `userid` (`userid`),
  KEY `extuserid` (`extuserid`),
  KEY `entrydate` (`entrydate`),
  KEY `module` (`module`),
  KEY `section` (`section`),
  KEY `action` (`action`),
  KEY `eventtable` (`eventtable`),
  KEY `eventid` (`eventid`),
  KEY `event` (`module`,`section`,`action`)
) ENGINE=MyISAM AUTO_INCREMENT=91 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eventlog`
--

LOCK TABLES `eventlog` WRITE;
/*!40000 ALTER TABLE `eventlog` DISABLE KEYS */;
INSERT INTO `eventlog` VALUES (35,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-03-20 13:38:35','127.0.0.1'),(36,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-03-30 14:15:36','192.168.1.231'),(37,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-04-11 15:22:58','192.168.1.234'),(38,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-04-20 13:15:31','192.168.1.233'),(39,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-05-01 15:25:09','192.168.1.231'),(40,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-05-13 14:11:12','192.168.1.59'),(41,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-05-17 20:25:53','192.168.1.232'),(42,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-05-21 14:42:05','192.168.1.232'),(43,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-05-26 16:40:24','192.168.1.232'),(44,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-05-28 13:43:24','192.168.1.232'),(45,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-06-09 15:27:45','192.168.1.231'),(46,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-06-15 09:28:48','192.168.1.231'),(47,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-06-23 14:34:12','192.168.1.231'),(48,0,1,0,'admin','user','logout','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-07-06 12:25:08','192.168.1.231'),(49,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-07-09 09:14:35','192.168.1.232'),(50,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-07-21 15:48:44','192.168.1.232'),(51,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-08-03 10:18:38','192.168.1.231'),(52,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-08-04 14:25:32','192.168.1.231'),(53,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-08-10 14:57:09','192.168.1.231'),(54,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-08-12 14:32:57','192.168.1.231'),(55,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-08-31 10:44:57','192.168.1.232'),(56,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-09-10 14:33:37','192.168.1.231'),(57,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-09-22 11:51:29','127.0.0.1'),(58,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-09-23 12:11:06','127.0.0.1'),(59,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-09-29 11:05:15','192.168.1.231'),(60,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-10-12 15:42:06','192.168.1.234'),(61,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-10-22 10:38:29','127.0.0.1'),(62,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-10-22 13:11:59','192.168.1.232'),(63,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-11-09 14:02:47','127.0.0.1'),(64,0,1,0,'admin','user','logout','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-11-09 14:13:22','127.0.0.1'),(65,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2009-12-23 20:29:18','192.168.1.231'),(66,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-01-07 09:41:55','192.168.1.231'),(67,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-02-02 13:52:46','192.168.1.232'),(68,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-02-15 11:43:17','192.168.1.232'),(69,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-02-22 14:58:57','192.168.1.232'),(70,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-03-24 10:50:24','192.168.1.232'),(71,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-04-05 09:38:34','192.168.1.231'),(72,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-04-21 14:38:54','192.168.1.231'),(73,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-05-19 11:26:39','192.168.1.231'),(74,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-05-24 11:22:30','192.168.1.231'),(75,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-06-22 14:41:02','192.168.1.231'),(76,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-07-07 15:55:53','192.168.1.231'),(77,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-07-09 09:54:04','192.168.1.231'),(78,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-07-20 15:03:20','192.168.1.232'),(79,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-07-22 14:09:10','192.168.1.231'),(80,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-08-23 12:05:09','192.168.1.231'),(81,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-09-01 12:18:18','192.168.1.232'),(82,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-10-15 14:48:17','192.168.1.233'),(83,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-10-25 15:25:39','192.168.1.233'),(84,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-11-10 14:26:12','192.168.1.232'),(85,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-11-30 14:53:19','192.168.1.231'),(86,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-12-15 12:59:52','192.168.1.231'),(87,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2010-12-27 11:08:58','192.168.1.231'),(88,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2011-01-10 15:11:43','192.168.1.232'),(89,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2011-01-21 14:54:20','192.168.1.232'),(90,0,1,0,'admin','user','login','genuser',1,'a:1:{s:8:\"username\";s:5:\"admin\";}','2011-06-28 17:08:11','127.0.0.1');
/*!40000 ALTER TABLE `eventlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eventlogdetails`
--

DROP TABLE IF EXISTS `eventlogdetails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `eventlogdetails` (
  `id` int(11) NOT NULL auto_increment,
  `eventlogid` int(11) NOT NULL default '0',
  `reftable` varchar(100) NOT NULL default '',
  `reffield` varchar(100) NOT NULL default '',
  `oldvalue` varchar(255) default '',
  `newvalue` varchar(255) default '',
  PRIMARY KEY  (`id`),
  KEY `eventlogid` (`eventlogid`),
  KEY `ref` (`reftable`,`reffield`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eventlogdetails`
--

LOCK TABLES `eventlogdetails` WRITE;
/*!40000 ALTER TABLE `eventlogdetails` DISABLE KEYS */;
/*!40000 ALTER TABLE `eventlogdetails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `extuser`
--

DROP TABLE IF EXISTS `extuser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `extuser` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `customer` int(11) NOT NULL default '0',
  `vendor` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  `stylesheetid` int(11) NOT NULL default '1',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) default NULL,
  `entrydate` datetime default NULL,
  `entryuserid` int(11) default NULL,
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `deflanguageid` int(11) NOT NULL default '1',
  `fullname` varchar(100) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `extuser`
--

LOCK TABLES `extuser` WRITE;
/*!40000 ALTER TABLE `extuser` DISABLE KEYS */;
/*!40000 ALTER TABLE `extuser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `family`
--

DROP TABLE IF EXISTS `family`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `family` (
  `id_family` int(11) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `id_workarea` int(11) NOT NULL default '5',
  `imptype` int(3) NOT NULL default '0',
  `iph` int(14) NOT NULL default '0',
  `iphtwo` int(14) NOT NULL default '0',
  `clickprice` decimal(5,3) NOT NULL default '0.000',
  `clickpricetwo` decimal(5,3) NOT NULL default '0.000',
  `maximpressionsperday` decimal(14,2) NOT NULL default '0.00',
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_user_create` int(11) NOT NULL default '0',
  `lastrevisedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_user_revise` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `cancel` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `maxwidth` decimal(10,3) NOT NULL default '0.000',
  `maxlength` decimal(10,3) NOT NULL default '0.000',
  `minwidth` decimal(10,3) NOT NULL default '0.000',
  `minlength` decimal(10,3) NOT NULL default '0.000',
  `mincolors` int(11) NOT NULL default '0',
  `maxcolors` int(11) NOT NULL default '0',
  `maxcolors_two` int(11) NOT NULL default '0',
  `maxcolors_one_if_two` int(11) NOT NULL default '0',
  `iphunits` int(3) NOT NULL default '0',
  `workarea_order` int(11) NOT NULL default '0',
  `scrapperplate` int(11) NOT NULL default '0',
  `scrappercent` double NOT NULL default '0',
  `minimum_charge` decimal(12,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`id_family`),
  UNIQUE KEY `id_family` (`id_family`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `family`
--

LOCK TABLES `family` WRITE;
/*!40000 ALTER TABLE `family` DISABLE KEYS */;
/*!40000 ALTER TABLE `family` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `family_detailseq`
--

DROP TABLE IF EXISTS `family_detailseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `family_detailseq` (
  `id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `family_detailseq`
--

LOCK TABLES `family_detailseq` WRITE;
/*!40000 ALTER TABLE `family_detailseq` DISABLE KEYS */;
INSERT INTO `family_detailseq` VALUES (0);
/*!40000 ALTER TABLE `family_detailseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `family_iph`
--

DROP TABLE IF EXISTS `family_iph`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `family_iph` (
  `id_family_iph` int(11) NOT NULL default '0',
  `id_family` int(11) NOT NULL default '0',
  `multiplier` decimal(5,2) NOT NULL default '1.00',
  `len` decimal(10,2) NOT NULL default '0.00',
  `wt` decimal(10,2) NOT NULL default '0.00',
  `greater_or_less` int(1) NOT NULL default '2',
  `sizeormwt` int(1) NOT NULL default '1',
  `price` decimal(5,3) NOT NULL default '0.000',
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_user_create` int(11) NOT NULL default '0',
  `lastrevisedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_user_revise` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_family_iph`),
  KEY `id_family` (`id_family`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `family_iph`
--

LOCK TABLES `family_iph` WRITE;
/*!40000 ALTER TABLE `family_iph` DISABLE KEYS */;
/*!40000 ALTER TABLE `family_iph` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `family_iphseq`
--

DROP TABLE IF EXISTS `family_iphseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `family_iphseq` (
  `id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `family_iphseq`
--

LOCK TABLES `family_iphseq` WRITE;
/*!40000 ALTER TABLE `family_iphseq` DISABLE KEYS */;
INSERT INTO `family_iphseq` VALUES (0);
/*!40000 ALTER TABLE `family_iphseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `family_price`
--

DROP TABLE IF EXISTS `family_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `family_price` (
  `id_family_price` int(11) NOT NULL default '0',
  `id_family` int(11) NOT NULL default '0',
  `qty_over` decimal(18,6) NOT NULL default '0.000000',
  `price_1_sided` decimal(15,2) NOT NULL default '0.00',
  `price_2_sided` decimal(15,2) NOT NULL default '0.00',
  `createdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_user_create` int(11) NOT NULL default '0',
  `lastrevisedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `id_user_revise` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_family_price`),
  UNIQUE KEY `id_family_price` (`id_family_price`),
  KEY `id_family` (`id_family`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `family_price`
--

LOCK TABLES `family_price` WRITE;
/*!40000 ALTER TABLE `family_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `family_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `family_priceseq`
--

DROP TABLE IF EXISTS `family_priceseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `family_priceseq` (
  `id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `family_priceseq`
--

LOCK TABLES `family_priceseq` WRITE;
/*!40000 ALTER TABLE `family_priceseq` DISABLE KEYS */;
INSERT INTO `family_priceseq` VALUES (0);
/*!40000 ALTER TABLE `family_priceseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `familyseq`
--

DROP TABLE IF EXISTS `familyseq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `familyseq` (
  `id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `familyseq`
--

LOCK TABLES `familyseq` WRITE;
/*!40000 ALTER TABLE `familyseq` DISABLE KEYS */;
INSERT INTO `familyseq` VALUES (0);
/*!40000 ALTER TABLE `familyseq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faxlog`
--

DROP TABLE IF EXISTS `faxlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faxlog` (
  `id` int(11) NOT NULL auto_increment,
  `status` varchar(16) NOT NULL default '',
  `faxnumber` varchar(32) NOT NULL default '',
  `api_id` varchar(16) NOT NULL default '',
  `api_provider` varchar(16) NOT NULL default '',
  `reftable` varchar(32) NOT NULL default '',
  `refid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `lastupdated` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `Active` (`cancel`,`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faxlog`
--

LOCK TABLES `faxlog` WRITE;
/*!40000 ALTER TABLE `faxlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `faxlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feature`
--

DROP TABLE IF EXISTS `feature`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `feature` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(45) NOT NULL default '',
  `description_short` varchar(100) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `display` int(11) NOT NULL default '0',
  `ecomid` int(11) NOT NULL default '0',
  `featurecategoryid` int(11) NOT NULL default '0',
  `featurecategoryid2` int(11) NOT NULL default '0',
  `version` varchar(25) NOT NULL default '',
  `es` varchar(45) default NULL,
  `af` varchar(45) default NULL,
  `zh` varchar(45) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=392 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `feature`
--

LOCK TABLES `feature` WRITE;
/*!40000 ALTER TABLE `feature` DISABLE KEYS */;
INSERT INTO `feature` VALUES (1,'ordernotes','Order Notes','Adds an unlimited number of dated internal notes to orders.',1,46,1,0,'4.0.2986','Notas Ordenes','Bestelling Notas','????'),(2,'12monthP&L','12-month Profit & Loss','Profit and loss statement for the previous 12-month period.',1,43,7,0,'4.0.2986','Estado de Resultados 12 Meses','12-maande Wins & Verlies Staat','?????'),(3,'POnote','Purchase Order Notes','Adds an unlimited number of dated internal notes about purchase orders',1,48,1,0,'4.0.2986','Notas Órdenes de Compra','Aankoop Bestelling Notas','??????'),(4,'invoicenote','Invoice Notes','Adds an unlimited number of dated internal notes for invoices.',1,47,3,0,'4.0.2986','Notas Factura','Faktuur Notas','????'),(5,'vendornote','Vendor Notes','Adds an unlimited number of dated internal notes about vendors.',1,49,5,0,'4.0.2986','Notas Suplidor','Verskaffer Notas','?????'),(6,'billnote','Payables Notes','Adds an unlimited number of dated internal notes for AP bills.',1,50,1,0,'4.0.2986','Notas Cuentas por Pagar','Uitgawes Notas','?????'),(7,'employeenote','Employee Notes','Adds an unlimited number of dated internal notes about employees.',1,51,6,0,'4.0.2986','Notas Empleados','Werknemer Notas','????'),(8,'timezone','Customer Weather/Time  *Free*','Allows you to view of client time and weather conditions when entering/updating orders or invoices, viewing customer account information, or for particular client \"ship-to\" locations.',1,42,12,0,'4.0.2986',NULL,NULL,NULL),(9,'baddebt','Bad Debt Write-Off Support','This features adds a bad debt write-off function that shows up as \"written off\" during viewing of invoices, on payment reports, and other applicable system areas.',1,41,3,0,'4.0.2986','Ayuda Cuentas Incobrables','Swak Skulde Afskryf Ondersteuningsfunksie','??????'),(10,'fedtax_update','US Federal Tax Tables','US federal tax table updates for 2008 to the present.',1,40,6,0,'4.0.2986','Tables de Impuestos Federales Estadounidenses','VSA Federale Belastingtabelle','??????'),(11,'branding','Site Branding','Places your own logo on the login page and on the footer of all pages in NolaPro for a more personalized experience.',1,44,8,0,'4.0.2986','Creación de Valor de Marco','Webwerf Handelsmerk','????'),(12,'customernote','Customer Notes','Adds an unlimited number of dated internal notes about customers.',1,52,3,0,'4.0.2986','Notas Clientes','Kliënte Notas','????'),(13,'b2bitemgraphics','B2B Item Graphics','Displays product images on the B2B site.',1,45,8,0,'4.0.2986','N2N Gráficas de Items','B2B Item Grafieke','?????????'),(14,'StatementOption','Abbreviated Statement Format  *Free*','Adds the options to select whether to block display of Prior Balance and Interest Added columns on customer statements.',1,53,12,0,'4.0.2996',NULL,NULL,NULL),(15,'customcode','Custom Code Hooks','Provides a way for you to add your own custom PHP code that can be activated to run during NolaPro certain events (i.e., when customers, orders or invoices are added).',1,58,8,0,'4.0.3065','Ganchos de Códigos Personaliados','Aangepade Kode Kramme','???????'),(16,'activitymonitor','User Activity Monitor','Administrative module for tracking and viewing of user activities.  For example, view a history of when customers, vendors, orders, invoices, GL entries and payroll data were added or modified, who made such changes, and when it was done.',1,56,8,0,'4.0.3065','Monitor de Actividad de Usuario','Monitor Gebruiker Aktiwiteite','??????'),(17,'ArSumByShipto','Invoice Summary Options','Two additional formats to summarize invoices by customers to show with/without details and includes the option to display subtotals by shipto locations.',1,57,3,0,'4.0.3065','Resumen Opciones Facturación','Faktuur Opsommingsopsies','??????'),(18,'Printshop_std','NolaPrint - Standard Version','Commercial print industry estimating system featuring quoting, estimating, tracking and billing of printing orders.',1,55,13,0,'4.0.3131',NULL,NULL,NULL),(19,'Printshop_pricelist','NolaPrint - Price List Version','Commercial print industry estimating system featuring quoting, estimating, tracking and billing of printing orders - based on price list.',1,55,13,0,'4.0.3131',NULL,NULL,NULL),(20,'flexfields','Custom Fields','Provides the ability to add your own customizable fields for customers, vendors, employees, items, orders, invoices and AP bills.',1,59,8,0,'4.0.3131','Campos Personalizados','Aangepasde Velde','?????'),(21,'dailyreport','Daily Accounting Summary','Administrative Financial Report showing checking balances, receivables aging totals, payments received, orders completed, and payables aging all on a single page.',1,60,7,0,'4.0.3131','Sumario de Contabilidad Cotidiana','Daaglikse Rekening Opsomming','??????'),(22,'api','NolaPro API','Provides access to the NolaPro API which allows you to build your own applications that integrate with NolaPro.',1,101,8,0,'','NolaPro API','NolaPro API','NolaPro??????'),(23,'PO_EXTRAS','Extra PO Formatting Options','Allows selection of removing boxes from around ship-to and vendor, changing of date format for display on PO, etc.',0,0,0,0,'',NULL,NULL,NULL),(24,'AR_EXTRAS','Date Format Options for Invoice and Statement','Allows changing of date format for display on Invoice and Statement.',0,0,0,0,'',NULL,NULL,NULL),(25,'timeclock','Employee Time Tracking','Timeclock system for employees to punch in/out for work, lunch, breaks, etc. and posts this time directly into payroll, along with reporting of the tracked time.',1,80,6,0,'40.3396','Rastreo de Tiempo de Empleados','Werknemer Tydsporing','??????'),(26,'piecework','Employee Piecework Tracking','Requires the Time Tracking add-on. Provides employee piecework tracking in a production environment and has reports to display money accrued and ways to relate that to clock-in hours from the time tracking module to give an equivalent hourly rate paid.',0,0,0,0,'0',NULL,NULL,NULL),(27,'oscom','osCommerce Integration (all versions)','Sends orders from your osCommerce online store directly into NolaPro.',1,187,10,0,'4.0.4596',NULL,NULL,NULL),(28,'ipaccess','IP Access Control','Allows you to restrict access to NolaPro based on a user\'s IP address. Filtering process can assign acceptable IP addresses that apply to all users or just to specific users.',1,71,8,0,'4.0.3261','IP Control de Acceso','IV (\"IP\") Toegangsbeheer','???????'),(29,'hostingmanager','Hosting Manager','Allows you to host and administer multiple NolaPro customer sites from one installation and multiple but separate databases.  With this plug-in, you will be able to resell NolaPro hosting to your clients at your own prices.',1,82,8,12,'4.0.3396','Administrador de Hospedaje (Versión d NolaPro','Gasheer Bestuurder (NolaPro Herverkoopte Weer','?????NolaPro ?????'),(30,'hosteddb','Hosting Manager - Client Authorization','Generates 1 client license for a new database in the NolaPro hosting manager.',1,83,8,12,'','Administrador de Hospedaje - Autorización de ','Gasheer Bestuurder - Klient Magtiging','????-?????'),(31,'message','Internal Messaging','Provides a way to display messages to other selected NolaPro users.  Supports graphics and also contains reports confirm if/when the messages were viewed.',1,81,8,0,'4.0.3396','Mensajería Internal','Interne Boodskappe','????'),(32,'CCPurchases','Credit Card Tracking','Track and reconcile credit card purchases in Payables.',1,87,5,0,'4.0.3562','Seguimiento Tarjeta de Crédito','Kredietkaart Sporing','?????'),(33,'MergeCust','Customer Account Merging Tool','Lets you merge customer records including all associated orders, payments, invoices, etc. when duplicate accounts have been inadvertently created.',1,86,1,0,'4.0.3475','Herramienta Consolidar Clientes','Kliënterekening Samesmelingsfunksie','????????'),(34,'OrderEntry','Order Entry Access Rights','Allows user rights to be set so they only have access to Order Entry functions.',1,88,8,0,'4.0.3600','Derecho de Acceso Para Llenar Ordenes','Bestellingsinskrywings Toegangsregte','????????'),(35,'CustControl','Customer Page Customizer','Allows user to set which fields will display for input on customer add and edit screens.',1,89,1,0,'4.0.3666','Personalizar Pagina Clientes','Kliënteblad  Aanpasser','??????'),(36,'ExtraPension','Expanded Pension Plans','Add up to three additional pension plans per employee (standard version has two plans).',1,90,6,0,'4.0.3666','Planes Expandidos de Pensión','Uitgebreide Pensioenplanne','???????'),(37,'ItemControl','Inventory Page Customizer','Allows user to set which fields will display for input on item add and edit screens.',1,91,4,0,'4.0.3686','Personalizar Página Inventario','Inventaris Blad Aanpasser','??????'),(38,'VendControl','Vendor Page Customizer','Allow user to set which fields will display for input on vendor add and edit screens.',1,95,5,0,'4.0.3804','Personalizar Pagina Suplidor','Verskaffer Bladsy Aanpasser','??????'),(39,'systemsettings','Premium System Settings','Adds system settings to allow a default home page other than Help, to turn off the login splash page and to remove marketing options from the Help home page (Add-ons, Hosting, Manuals, Support).',1,96,8,0,'4.0.3919','Configuración de Sistema Premium','Premium Sisteem Verstellings','??????'),(40,'lang_es','User Language - Spanish (Full Translation)','Allows users to select Spanish as the display language in NolaPro.',0,185,11,0,'4.0.4470',NULL,NULL,NULL),(41,'qbimport','QuickBooks(TM) Converter (US)','Allows you to export data from QuickBooks and import it into NolaPro via Admin -> Imports -> QuickBooks',1,97,8,0,'4.0.3946','Convertidor de Quickbooks (TM)(US)','QuickBooks(TM) Omskepper (US)','QuickBooks???????????'),(42,'invbkdn','Inventory Item Breakdown','Subdivide a parent item into other inventory items using the item family relationship (ex. for breaking down steel or lumber); the process transfers costs from the main item to sub-items.',1,98,4,0,'4.0.4055','Desglose artículo Inventario','Inventaris Item Ontleding','??????'),(43,'invoicenumber','Invoice Number Override','Override invoice number from orders; useful if you are entering invoices from a paper-based system where the invoice numbers are pre-printed.',1,99,3,0,'4.0.4055','Invalidación Numero factura','Faktuur Nommer Ignoreer','??????'),(44,'combinepayroll','Combine Payrolls for Taxes','Allow another check to sum with prior period for taxes, then just apply the difference.',1,230,6,0,'4.0.5893','Combinar Nominas para Impuestos','Kombineer Loonrol vir Belasting','???????'),(45,'survey','Survey Manager','Create surveys; email survey links from order, invoice, customer and vendor screens; view results with a detailed reporting tool',1,100,8,0,'4.0.4127','Administrador de Encuestas','Opname Bestuurder','????'),(46,'ItemSalesHistory','Inventory Sales History Report','A detailed report that offers several subtotalling and summarizing options to view inventory item sales history.',1,102,4,0,'4.0.4200','Reporte Historia Venta Articulo Inventario','Inventaris Verkoopsgeskiedenis Verslag','????????'),(47,'companytimezone','Company Time Zones','Allows you to set a different time zone for each of your NolaPro companies.',1,104,8,0,'4.0.4215','Zonas Horario de la Empresa','Besigheid Tydsones','????'),(48,'ItemVendorCopy','Item Vendor Copy','Copy item vendor information from one vendor to another.',0,0,0,0,'',NULL,NULL,NULL),(49,'multicurrency','Multi-Currency Module','Lets you use more than one currency in NolaPro for orders, invoices, POs, AP bills, etc.',1,103,8,0,'5.0.7649','Modulo de Multi-Divisa','Multi-Geldeenheid','??????????'),(50,'scartfreeship','Expanded Free Shipping Options for Shopping Cart','Allows you to set minimum order amount, price level and shipping method criteria when offering free shipping in the shopping cart module.',0,106,8,0,'4.0.4410','Opciones de Envio Gratis','Gratis Versendingsopsie vir Winkeltrollie','?????????'),(51,'lang_ar','User Language - Arabic (Incomplete Translation)','Allows users to select Arabic as the display language in NolaPro',0,188,11,0,'4.0.4470',NULL,NULL,NULL),(52,'lang_zh','User Language - Chinese (Incomplete Translation)','Allows users to select Chinese as the display language in NolaPro',0,162,11,0,'4.0.4470',NULL,NULL,NULL),(53,'lang_da','User Language - Danish (Incomplete Translation)','Allows users to select Danish as the display language in NolaPro',0,163,11,0,'4.0.4470',NULL,NULL,NULL),(54,'lang_nl','User Language - Dutch (Incomplete Translation)','Allows users to select Dutch as the display language in NolaPro',0,164,11,0,'4.0.4470',NULL,NULL,NULL),(55,'lang_et','User Language - Estonian (Incomplete Translation)','Allows users to select Estonian as the display language in NolaPro',0,165,11,0,'4.0.4470',NULL,NULL,NULL),(56,'lang_tl','User Language - Filipino (Incomplete Translation)','Allows users to select Filipino as the display language in NolaPro',0,166,11,0,'4.0.4470',NULL,NULL,NULL),(57,'lang_fi','User Language - Finnish (Incomplete Translation)','Allows users to select Finnish as the display language in NolaPro',0,167,11,0,'4.0.4470',NULL,NULL,NULL),(58,'lang_fr','User Language - French (Incomplete Translation)','Allows users to select French as the display language in NolaPro',0,168,11,0,'4.0.4470',NULL,NULL,NULL),(59,'lang_de','User Language - German (Incomplete Translation)','Allows users to select German as the display language in NolaPro',0,169,11,0,'4.0.4470',NULL,NULL,NULL),(60,'lang_el','User Language - Greek (Incomplete Translation)','Allows users to select Greek as the display language in NolaPro',0,170,11,0,'4.0.4470',NULL,NULL,NULL),(61,'lang_he','User Language - Hebrew (Incomplete Translation)','Allows users to select Hebrew as the display language in NolaPro',0,171,11,0,'4.0.4470',NULL,NULL,NULL),(62,'lang_hi','User Language - Hindi (Incomplete Translation)','Allows users to select Hindi as the display language in NolaPro',0,172,11,0,'4.0.4470',NULL,NULL,NULL),(63,'lang_ba','User Language - Indonesian (Incomplete Translation)','Allows users to select Indonesian as the display language in NolaPro',0,173,11,0,'4.0.4470',NULL,NULL,NULL),(64,'lang_it','User Language - Italian (Incomplete Translation)','Allows users to select Italian as the display language in NolaPro',0,174,11,0,'4.0.4470',NULL,NULL,NULL),(65,'lang_jp','User Language - Japanese (Incomplete Translation)','Allows users to select Japanese as the display language in NolaPro',0,175,11,0,'4.0.4470',NULL,NULL,NULL),(66,'lang_ko','User Language - Korean (Incomplete Translation)','Allows users to select Korean as the display language in NolaPro',0,176,11,0,'4.0.4470',NULL,NULL,NULL),(67,'lang_ms','User Language - Malay (Incomplete Translation)','Allows users to select Malay as the display language in NolaPro',0,177,11,0,'4.0.4470',NULL,NULL,NULL),(68,'lang_no','User Language - Norwegian (Incomplete Translation)','Allows users to select Norwegian as the display language in NolaPro',0,178,11,0,'4.0.4470',NULL,NULL,NULL),(69,'lang_pt','User Language - Portuguese (Incomplete Translation)','Allows users to select Portuguese as the display language in NolaPro',0,179,11,0,'4.0.4470',NULL,NULL,NULL),(70,'lang_ro','User Language - Romanian (Incomplete Translation)','Allows users to select Romanian as the display language in NolaPro',0,180,11,0,'4.0.4470',NULL,NULL,NULL),(71,'lang_ru','User Language - Russian (Incomplete Translation)','Allows users to select Russian as the display language in NolaPro',0,181,11,0,'4.0.4470',NULL,NULL,NULL),(72,'lang_si','User Language - Slovenian (Incomplete Translation)','Allows users to select Slovenian as the display language in NolaPro',0,182,11,0,'4.0.4470',NULL,NULL,NULL),(73,'lang_sv','User Language - Swedish (Incomplete Translation)','Allows users to select Swedish as the display language in NolaPro',0,183,11,0,'4.0.4470',NULL,NULL,NULL),(74,'lang_th','User Language - Thai (Incomplete Translation)','Allows users to select Thai as the display language in NolaPro',0,184,11,0,'4.0.4470',NULL,NULL,NULL),(75,'ItemActualCost','Inventory Actual Item Costs','Withdraw from Inventory at actual cost regardless of how many purchases exist in inventory.',1,193,4,0,'4.0.4663','Costo Actual de Items de Inventario','Inventaris Werklike Item Kostes','????????'),(76,'lang_af','User Language - Afrikaans (Incomplete Translation)','Allows users to select Afrikaans as the display language in NolaPro',0,189,11,0,'4.0.4610',NULL,NULL,NULL),(77,'lang_vi','User Language - Vietnamese (Full Translation)','Allows users to select Vietnamese as the display language in NolaPro',0,192,11,0,'4.0.4663',NULL,NULL,NULL),(78,'lang_sr','User Language - Serbian (Incomplete Translation)','Allows users to select Serbian as the display language in NolaPro',1,191,11,0,'4.0.4663',NULL,NULL,NULL),(79,'multiarap','Multiple AR/AP GL Accounts','Allows you to define more than one Accounts Receivable and Accounts Payable account for use when creating orders, invoices and AP Bills.',1,194,7,0,'4.0.4663','Cuentas Multiples CC/CP','Veelvuldige RO/RB Rekeninge','??????/??????'),(80,'blockarreports','Block AR Reports','Allows you to block AR reports (Billing & Orders) for users that have AR read access.',1,239,3,0,'4.0.7245',NULL,NULL,NULL),(81,'construction','Construction','Construction Company',0,0,0,0,'',NULL,NULL,NULL),(82,'salesmanBlock','Limit Salesman Access','Block sales personnel from seeing any orders/invoices/customers other than their own.',1,201,1,0,'4.0.4775','Limitar Acceso Vendedor','Beperk Verkoopspersoon Toegang','????????'),(83,'userrights','Advanced User Rights','Advanced control of pages users are able to access.',1,206,8,0,'4.0.4878','Derechos de Usuarios Avanzados','Gevorderde Gebruikersregte','??????'),(84,'processstages','Process Stages','Add user-definable stages for processing purchase orders and fulfillment orders.',0,0,0,0,'',NULL,NULL,NULL),(85,'lang_ur','User Language - Urdu (Incomplete Translation)','Allows users to select Urdu as the display language in NolaPro',0,208,11,0,'4.0.4986',NULL,NULL,NULL),(86,'lang_pl','User Language - Polish (Incomplete Translation)','Allows users to select Polish as the display language in NolaPro',1,207,11,0,'4.0.4986',NULL,NULL,NULL),(87,'custitemdiscounts','Customer Item Discounts','Create flat or percent item discounts for specific customers.',1,209,4,0,'4.0.4986','Descuento Articulo por Cliente','Kliënt Item Kortings','??????'),(88,'soextrafields','Service Order Extra Fields','Allows you to define additional fields for service orders and develop a custom work details page for each service order.',1,210,1,0,'4.0.4986','Campos Adicionales Ordenes Servicio','Diensbestelling Ekstra Velde','???????'),(89,'googlebase','Google Base Inventory Synchronization','Sync your NolaPro items with your Google Base account.',0,0,0,0,'',NULL,NULL,NULL),(90,'edititemprices','Item Prices - Mass Edit','Provides a page where you can set prices for multiple items and price levels all in one place.',1,212,4,0,'4.0.5042','Edición Masiva Precio Artículos Inventario','Item Pryse - Massa Redigering','????-????'),(91,'servicePF','Pro Forma Invoice for Service Order','Run a pro forma invoice prior to actually being ready to make an invoice for a service order -- shows all hours, etc.',1,240,1,0,'4.0.7245',NULL,NULL,NULL),(92,'ExportItems','Export Inventory Items','Export Items in same format as CSV Import file.',1,218,4,0,'4.0.5226','Exportar Articulo Inventario','Uitvoer van Inventaris Items','??????'),(93,'adminloginany','Admin Tool (Login as any User)','Allows the admin user to automatically log in as any user.',0,0,0,0,'',NULL,NULL,NULL),(94,'depositslip','Bank Deposit Slip PDF','Allow PDF Deposit Slip printing.',1,216,3,0,'4.0.5207','Hoja de Deposito PDF','Bank Depositostrokkie PDF','??????PDF???'),(95,'cashflowreport','Cash Flow Report Rex','A configurable Statement of Cash Flows Report.',0,217,0,0,'0',NULL,NULL,NULL),(96,'cashtracker','Track Movement of Cash Receipts','Track Movement of Cash Receipts from Person to Person.',0,0,0,0,'',NULL,NULL,NULL),(97,'bankimport','Bank Statement Import (OFX)','Import transactions from your bank account in OFX format.',1,220,7,0,'4.0.5333','Importar Transacciones Bancarias (Formato OFX','Bank Transaksies Invoer (OFX Formaat)','???????OFX???'),(98,'postemplate','POS Tax Groups','Create POS Tax Groups that can be assigned to users as tax/location to use when creating a POS sale.',1,223,3,0,'4.0.5451','Grupos Impuestos Punto de Venta','PVV (Punt van Verkope) Belasting Groepe','?????'),(99,'lang_bg','User Language - Bulgarian (Incomplete Translation)','Allows users to select Bulgarian as the display language in NolaPro',0,221,11,0,'4.0.5355',NULL,NULL,NULL),(100,'itemreturns','Invoice Item Returns','Allow return of inventory items when on invoices generated by POS, etc.',1,224,3,0,'4.0.5451','Factura Artículos devueltos','Faktuur Item Retoere','??????'),(101,'discounts','Invoice Discounts','Set up discounts that can be applied to entire invoices.',0,0,0,0,'',NULL,NULL,NULL),(102,'coinvoice','Co-Invoicing','Allow other customers to share responsibility for an invoice.',0,0,0,0,'',NULL,NULL,NULL),(103,'invcopyprice','Copy Inventory Pricing','Copy Inventory Item Pricing from one location to another (or all other) location.',1,222,4,0,'4.0.5431','Duplica Precio Inventario','Kopieër Inventaris Prysberekening','??????'),(104,'ccscanner','Credit Card Scanner Integration','Allows you to use an attached credit card scanning device when submitting credit card payments',1,225,3,0,'4.0.5720','Integración de Escáner de Tarjetas de Crédito','Kredietkaart Skandeerder Integrasie','????????'),(105,'smallinvoice','Small POS Invoices','Invoice option for an 8.5 x 5.5 inch size limited to 7 items.',1,227,3,0,'4.0.5720','Facturas de Pequeños PDV','Kleiner PVV (Punt van Verkope) Fakture','???????'),(106,'lang_tr','User Language - Turkish (Incomplete Translation)','Allows users to select Turkish as the display language in NolaPro',0,226,11,0,'4.0.5720',NULL,NULL,NULL),(107,'mc2xreceipt','Official Receipt for MyCare2x Integration','This is a private add-on -- not available on the store',0,0,0,0,'',NULL,NULL,NULL),(108,'stubcheckstub','Checks: Stub-Check-Stub','Checks allow a new format of \"stub-check-stub\".',1,229,5,0,'4.0.5760','Talonario Cheque Talonario','Tjekteenblad','????'),(109,'receipt','Payment Receipts','Standard \"receipt-size\" PDF for printing to a dedicated receipt printer. Perfect for POS payments.',1,238,3,0,'4.0.7245',NULL,NULL,NULL),(110,'userlocations','Tie User to Specific Locations','Tie User to Specific Locations.',1,233,3,0,'4.0.5967',NULL,NULL,NULL),(111,'empglid','Employee-Specific Tax Expense for GL','Employee-specific Tax Expense for GL.',1,231,6,0,'4.0.5893','Gastos de Impuestos para LM especificamente P','Werknemer-spesifieke Belasting Uitgawe vir AG','???????????'),(112,'mc2xcashcount','Record Currency Counts with Payments','This is a private add-on -- not available on the store',0,0,0,0,'',NULL,NULL,NULL),(113,'shipbarcode','Print Shipto ID on Order Ticket','Print Shipto Record ID on Order Ticket - for use with shipping programs like Worldship.',1,232,1,0,'4.0.5956',NULL,NULL,NULL),(114,'barcodelabel','Custom Design Barcode Labels','Create custom barcode lables using custom fields such as size, color and design. The Custom Fields Add-On is required.',1,235,4,0,'4.0.6199','Diseño Personalizado de Etiquetas de Códigos ','Ontwerp Aangepasde Strepieskode Etikette','?????????'),(115,'lang_pr','User Language - Persian (Incomplete Translation)','Allows users to select Persian as the display language in NolaPro.',1,236,11,0,'4.0.6312',NULL,NULL,NULL),(116,'payrollcheck','Special Payroll Check Format','Turns on a special Payroll Check format.',1,237,6,0,'4.0.6434','Formato Especial Para Cheques de Nomina','Spesiale Loonrol Tjekformaat','????????'),(117,'archiveinvoices','Archive Invoices','Archive old invoices and related records; GL entries are summarized by month or year.',0,0,0,0,'4.0.6587',NULL,NULL,NULL),(118,'tcadocrequest','TCA Doc Request Report','A list of TCA doc requests',0,0,0,0,'',NULL,NULL,NULL),(119,'tabularLogHours','Log Payroll Time in Tabular Format','Allow logging of Payroll Time in tabular format.',1,241,6,0,'4.0.7245',NULL,NULL,NULL),(120,'vtiger','vtiger CRM Integration','Adds custom fields to NolaPro so that vtiger CRM info can be imported using the vtiger Add-On.',1,252,10,0,'5.0.7857',NULL,NULL,NULL),(121,'payroll','Payroll System','Installs the full Payroll System.',1,242,6,0,'4.0.7245','Sistema de Nomina',NULL,NULL),(122,'inventory','Inventory and Ordering System','Installs the Inventory and Ordering System with Point of Sale, Service Orders and Fulfillment Orders.',1,243,1,4,'4.0.7245','Sistema de Inventario y Ordenes',NULL,NULL),(123,'b2b','B2B System','Installs the Business-to-Business (B2B) System for allowing clients access to place order, make payments, etc.',1,244,1,0,'4.0.7245','Sistema B2B',NULL,NULL),(124,'cashbasetaxrpt','Cash Basis Sales Tax Report','View only invoices PAID in a given month on the sales tax report',1,246,3,0,'5.0.7413',NULL,NULL,NULL),(125,'disablecostcorrect','Disable Cost Auto-Correction when Ship/Close Orders','Custom Only Display=0',0,245,1,0,'5.0.8475',NULL,NULL,NULL),(126,'onepagecheck','Special Check Size with GL on stub','Special Check Size with GL on stub',1,279,5,0,'5.0.8475',NULL,NULL,NULL),(127,'expandeddata','Expanded Data Allowance','Allows you to have more customers, vendors, items and employees along with the ability to add more than one company',1,247,8,0,'5.0.7750',NULL,NULL,NULL),(128,'cashflow','Cash Flow Report','Cash Flow Report',1,217,7,0,'5.0.7809',NULL,NULL,NULL),(129,'catitemdel','Delete Inventory By Category','Delete Inventory by Category',1,250,4,0,'5.0.7809',NULL,NULL,NULL),(130,'item12mo','12 Month History of Customer Sales or Units Sold','12 Month History of Customer Sales or Inventory Units Sold',1,249,4,0,'5.0.7809',NULL,NULL,NULL),(132,'orderptcalc','Calculate Item Reorder Point, Min and Max ','Calculate Item Reorder Point, Min and Max',1,251,4,0,'5.0.7809',NULL,NULL,NULL),(133,'unlimiteddata','Unlimited Data Allowance','Allows unlimited customers, vendors, items, companies and employees',0,0,0,0,'5.0.7842',NULL,NULL,NULL),(134,'smallinvoice2','Strip Printer Style Invoice ','Display=0, not an add-on',0,278,3,0,'5.0.8475',NULL,NULL,NULL),(135,'BOMImport','Import BOM Definitions and Build Orders ','Import BOM Definitions and Build Orders',1,282,12,0,'5.0.8500',NULL,NULL,NULL),(136,'smallinvoice3','A4 Half-size Invoice ','Display=0, not an add-on',0,254,3,0,'5.0.8475',NULL,NULL,NULL),(137,'irs1099','IRS 1099-MISC','Allows printing 1099-MISC forms for vendors',1,253,5,0,'5.0.8044',NULL,NULL,NULL),(138,'3dcart','3dcart Order Import','Import orders from a 3dcart store',1,255,10,0,'5.0.8108',NULL,NULL,NULL),(139,'negInvVal','Negative Quantities on Inventory Valuation ','Allow Negative Quantities to display on Inventory Valuation',1,256,4,0,'5.0.8108',NULL,NULL,NULL),(140,'picktickpdf','Direct Pick Ticket PDF from Order Entry','Direct Print of Pick Ticket PDF from final Order Entry Screen',1,277,1,0,'5.0.8475',NULL,NULL,NULL),(141,'commissions','Commissions','Calculate commissions on invoices',1,257,3,0,'5.0.8193',NULL,NULL,NULL),(142,'EmailOnConfirm','Order Confirmation - Include emails','For Fulfillment Order Confirmation, show email for both order by and ship to',1,258,12,0,'5.0.8272',NULL,NULL,NULL),(143,'hideitemoptionsshipinv','Hide Item Options In Shipping & Invoicing','Turning on this option in AR Setup will block item options from being displayed on fulfillment order shipping and invoicing screens',1,276,1,0,'5.0.8475',NULL,NULL,NULL),(144,'overrideorderdate','Override Item Order Date','Override the default current date used when creating or editing item orders',1,281,1,0,'5.0.8500',NULL,NULL,NULL),(145,'EmailCenter','Email Center','Email Center',1,260,8,0,'5.0.8355',NULL,NULL,NULL),(146,'NonInvoicedSales','Non-Invoiced Sales','Non-Invoiced Sales',1,261,3,0,'5.0.8355',NULL,NULL,NULL),(147,'CalculateInterest','Calculate Interest on Invoices','Calculate Interest on Invoices',1,262,12,0,'5.0.8355',NULL,NULL,NULL),(148,'GLBudgets','General Ledger Budgets','Create GL Budgets and run Variance Reports',1,263,7,0,'5.0.8355',NULL,NULL,NULL),(149,'GLSummarize','General Ledger Summarization','Summarize GL Accounts to Create Custom Reports',1,264,7,0,'5.0.8355',NULL,NULL,NULL),(150,'GLRecurring','Recurring Ledger Entries','Recurring Ledger Entries',1,265,7,0,'5.0.8355',NULL,NULL,NULL),(151,'Exports','Misc. Exports','Misc. Exports',1,271,12,0,'5.0.8355',NULL,NULL,NULL),(152,'LangEditor','Language Editor','Edit Text from Anywhere in the program',1,266,12,0,'5.0.8355',NULL,NULL,NULL),(153,'HomePageRefresh','Home Page Refresh Times','Edit times between recalculate Home Page reports',1,267,12,0,'5.0.8355',NULL,NULL,NULL),(154,'CustomerGroups','Create Customer Groups','Create Customer Groups',1,268,1,0,'5.0.8355',NULL,NULL,NULL),(155,'InvoiceEndNotes','Invoice End Notes','Notes to add to end of Invoice',1,269,12,0,'5.0.8355',NULL,NULL,NULL),(156,'VendorType','Vendor Types','Ability to assign a type to each vendor',1,270,12,0,'5.0.8355',NULL,NULL,NULL),(157,'GLCostCenter','GL Cost Center','Assign Cost Centers to GL Accounts to enhance reporting',1,280,7,0,'5.0.8500',NULL,NULL,NULL),(158,'CashRequire','Payables Cash Requirements Report','Payables Cash Requirements Report',1,259,5,0,'5.0.8355',NULL,NULL,NULL),(159,'sidebarhide','Hide Sidebar','Allows you to toggle the left-hand sidebar area (Shortcuts, Help, etc) so it can be hidden to give more room for the application when needed',1,273,12,0,'5.0.8355',NULL,NULL,NULL),(160,'defaultduedate','Default Due Date','Allows you to set the number of days beyond the current date you\'d like the due date for service and fulfillment orders to default to',1,272,12,0,'5.0.8355',NULL,NULL,NULL),(161,'pay_finchg','Finance Charge For Payments','Provides a way to include a finance charge when entering in payments received',1,283,12,0,'5.0.8500',NULL,NULL,NULL),(162,'ediprocessing','EDI Processing - Custom','EDI Processing - Custom Only DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(163,'a4_statement','A4 Open Item Statement','A4 Open Item Statement',0,0,0,0,'',NULL,NULL,NULL),(164,'discOnForms','Show Discount Column on AR Forms','Show Discount Column on AR Forms',1,275,12,0,'5.0.8475',NULL,NULL,NULL),(165,'invoiceaddressbottom','Show Invoice Address at Bottom','Show the invoice address at the bottom with other adjustments - Custom Only DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(166,'oneWrite','OneWrite Customization','OneWrite Customization',0,0,0,0,'',NULL,NULL,NULL),(167,'defaulttovendorcost','Default Inventory Costs To Vendor Pricing','With this customization on all inventory costs for orders will pull the cost from the vendor pricing set up for the item  DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(168,'blockifnostock','Block Orders If No Stock','Block certain users from placing orders if not enough stock is available',1,300,1,0,'5.0.9241',NULL,NULL,NULL),(169,'blocksalesmanchange','Block Salesperson Changes','Block sales personnel from changing the sales person on orders',1,299,1,0,'5.0.9241',NULL,NULL,NULL),(170,'userseries','Per-User Numbering','Alternate configurable numbering system for orders, invoices and receipts that increments on a per-user per-company basis  DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(171,'usershippingrights','User Shipping Rights','Block users or user groups from shipping certain items or categories of items  DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(172,'purgeorders','Purge Open Orders','Purge open fulfillment orders if no shipments have been made after a certain number of days. Purge by putting in unconfirmed status or by deleting. DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(173,'userpaymentcollection','User Payment Collection','Enter payments amounts that user\'s have collected (cash, checks, etc) and match against the payment amounts recorded by the system DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(174,'glTransImport','Import GL Transactions','Import GL Transactions',1,285,7,0,'5.0.8656',NULL,NULL,NULL),(175,'cloneorders','Clone Quotes & Orders','Make duplicates of existing fulfillment quotes and orders',1,284,1,0,'5.0.8657',NULL,NULL,NULL),(176,'pricelevelmarkdowns','Price Level Markdowns','Create price levels that are markdowns of other existing price levels (10% Off Retail price level for example)',1,286,4,0,'5.0.8693',NULL,NULL,NULL),(177,'salesmandefaults','Default Values For Sales Personnel','Set up a default sales account and default bank account for sales people DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(178,'customenterpayments','Custom Enter Payments Page','Custom page for entering payments DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(179,'itemcostadjustapbill','Item Cost Adjustments Using AP Bills','Adjust the cost of items received on PO by the amount of a separate AP Bill on the Inventory Cost Adjustments page ',1,287,4,0,'5.0.8714',NULL,NULL,NULL),(180,'convertordertoquote','Convert Order To Quote','Convert a fulfillment order back into a quote. Performing this action will release committed inventory.',1,288,1,0,'5.0.8714',NULL,NULL,NULL),(181,'showothercostock','Show Stock Level From Other Companies','Show stock levels from other companies on the Item Reorder List report',1,289,4,0,'5.0.8714',NULL,NULL,NULL),(182,'poreturns','Purchase Order Returns','Provides a way to manage returning items received on PO back to vendor',1,290,5,0,'5.0.8909',NULL,NULL,NULL),(183,'colortemplates','Change Colors','Allows you to change the system color layout to something other than the default blue on a system wide, per company or per user basis',1,291,8,0,'5.0.8909',NULL,NULL,NULL),(184,'genusercheckacct','User Bank Account Assignment','Assign users to certain bank accounts so that they can only see their assigned bank accounts throughout the system',1,292,8,0,'5.0.8909',NULL,NULL,NULL),(185,'custommanualchecks','Custom Manual Checks Page','Custom page for writing manual checks DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(186,'blockbackdating','Block AR/AP Backdating','Prevent certain users from being able to backdate AP and AR transactions or post to prior periods ',1,294,3,5,'5.0.9112',NULL,NULL,NULL),(187,'glcostcodes','Cost Codes for AR/AP','Allows you to assign cost codes to invoices and bills and then filter the Profit & Loss statement by cost code',1,295,3,5,'5.0.9112',NULL,NULL,NULL),(188,'updatevendorprice','Update Vendor Prices from POs','This add-on will allow you to update vendor prices for items based on the price entered when converting POs to AP bills. Toggle this feature on or off at Admin -> Setup - Payables -> General Setup -> Update Vendor Prices From Received PO Prices',1,296,5,0,'5.0.9112',NULL,NULL,NULL),(189,'autocompletedelay','Auto-Complete Delay Override','Set on a per-user basis the amount of time in milliseconds until auto-complete boxes look for information. Setting a higher number than the default of 400 can be helpful for slower typers.',1,297,12,0,'5.0.9112',NULL,NULL,NULL),(190,'removeads','Remove Advertising','Remove ads that may be displayed with some free distributions.  If you do not see ads in the program (header, sidebar, or footer), you do not need to purchase this add-on.',1,293,8,0,'5.0.9112',NULL,NULL,NULL),(191,'ExpenseReport','Expense Report','Expense Report DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(192,'invcotransfer','Intercompany Item Transfers','Transfer inventory items between different companies inside the program',1,303,4,0,'5.0.9241',NULL,NULL,NULL),(193,'gltransactioninfo','GL Transaction Descriptions','Allows you to enter descriptions for each line in a GL journal set in addition to the main description',1,302,7,0,'5.0.9241',NULL,NULL,NULL),(194,'salesmarginblock','Sales Margin Invoice Blocking','Prevent fulfillment orders from being invoiced if the total order amount falls outside a sales margin range that you define.  Override these orders through a margin execption report.',1,301,1,0,'5.0.9241',NULL,NULL,NULL),(195,'posmultiplier','Multiply All Quantities in POS/FO','Provides a box where you can enter a number and have all quantities on the entire POS order or Fulfillment Order multiplied by that amount DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(196,'BOMExtras','Extra Charges for Build Orders','Extra Charges for Build Orders',1,304,4,0,'5.0.9389',NULL,NULL,NULL),(197,'itempricecategory','Item Prices - Category Edit','Adjust prices for all items in a specific category by a percentage or flat amount',1,305,4,0,'5.0.9495',NULL,NULL,NULL),(198,'poreqshipdate','PO Requested Ship Dates','For each line in a PO add a requested ship by date that will display in printouts',1,306,5,0,'5.0.9495',NULL,NULL,NULL),(199,'doccenter','Document Center','Upload unassigned Order and AP Bill documents and create orders or AP bills from the documents  DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(200,'prosperaddonpack','Prosper Add-On Pack','The Prosper Add-On Pack includes the Inventory, Payroll & B2b add-ons',1,307,8,0,'5.0.9506',NULL,NULL,NULL),(201,'discountaddonpack','Discount Add-On Pack','With this purchase you will receive all items listed below and save about 50% off of the regular price versus buying them separately. <br><br>Future Add-Ons are not included and will need to be purchased separately.<br><br>Add-ons include:<br><br><b>Order',1,219,8,0,'5.0.9509',NULL,NULL,NULL),(202,'blockPriorPost','Block Posting To Closed Period','Block Posting to Closed General Ledger Period',0,316,7,0,'5.0.9725',NULL,NULL,NULL),(204,'doublewindow','Invoice Format for use with Double Window Envelope','Invoice Format for use with Double Window Envelope',1,321,3,0,'5.0.9725',NULL,NULL,NULL),(205,'glbalCompare','GL Balance - Add Period Comparison','GL Balance - add Period Comparison',1,317,7,0,'5.0.9725',NULL,NULL,NULL),(206,'941taxliability','941 Schedule B Weekly Report','941 Schedule B Weekly Report',1,318,6,0,'5.0.9725',NULL,NULL,NULL),(207,'deliverynotes','Invoice Delivery Tracking','Manage deliveries after invoice creation. DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(208,'serviceship','Service Orders - Allow Shipping','Service Orders - allow shipping',1,319,1,0,'5.0.9725',NULL,NULL,NULL),(209,'supportlivestart','\"Getting Started\" Live Training Session','',1,309,14,0,'',NULL,NULL,NULL),(210,'supportcustconsulting','Customization Consulting','',1,308,14,0,'',NULL,NULL,NULL),(211,'supportonephone','Live Phone Help - 1 Incident','',1,310,14,0,'',NULL,NULL,NULL),(212,'supportdigitalmanaging','Managing Your Business with NolaPro (Digital)','',1,314,14,0,'',NULL,NULL,NULL),(213,'supportdigitalmanual','NolaPro Manuals (Digital)','',1,315,14,0,'',NULL,NULL,NULL),(214,'supportemailone','Unlimited Email Support (1 Contact)','',1,312,14,0,'',NULL,NULL,NULL),(215,'supportemailcomp','Unlimited Email Support (Company)','',1,313,14,0,'',NULL,NULL,NULL),(216,'rebatepayx','Rebate/Discounts Applied To Invoice At Payment','Allows you to apply rebates/discounts to an invoice at time of payment',1,320,3,0,'5.0.9725',NULL,NULL,NULL),(217,'posupdateprices','Update Pricing For POS & Fulfillment Orders','Allows you to click a button to update the pricing for fulfillment quotes, fulfillment orders and POS orders',1,322,1,0,'5.0.9828',NULL,NULL,NULL),(218,'itemvendorstatus','Custom Item Vendor Status Report','Custom Item Vendor Status Report DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(219,'bomautoship','BOM Auto-Create During Shipping','Automatically create BOM (composite) items when shipping if component pieces are available',1,323,4,0,'5.0.9828',NULL,NULL,NULL),(220,'usshipquote','United Stationers Shipping Quote','Shipping Quotes for United Stationers DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(221,'hidedonate','Hides the donation button','',0,0,0,0,'5.0.9824',NULL,NULL,NULL),(222,'inventoryusetax','Inventory Use Tax','Record an inventory use tax percent for your locality and display the use tax in the Sales Profitability report',1,348,3,0,'5.0.10241',NULL,NULL,NULL),(223,'bravoproforma','Custom FO Pro Forma Invoice ','Custom pro forma invoice for fulfillment orders DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(224,'pack_orders','Discount Pack - Orders','',1,343,1,0,'',NULL,NULL,NULL),(225,'pack_billing','Discount Pack - Billing','',1,342,3,0,'',NULL,NULL,NULL),(226,'pack_inventory','Discount Pack - Inventory','',1,341,4,0,'',NULL,NULL,NULL),(227,'pack_payables','Discount Pack - Payables','',1,340,5,0,'',NULL,NULL,NULL),(228,'pack_payroll','Discount Pack - Payroll','',1,339,6,0,'',NULL,NULL,NULL),(229,'pack_ledger','Discount Pack - Ledger','',1,338,7,0,'',NULL,NULL,NULL),(230,'pack_admin','Discount Pack - Admin','',1,337,8,0,'',NULL,NULL,NULL),(231,'changecustomer','Change Customer for Invoices and Service Orders','Allows you to change the customer on invoices and service orders after they have been created.',1,336,1,0,'5.0.9923',NULL,NULL,NULL),(232,'pricehistory','Customer/Vendor Price History','View previous prices paid for items on Quote, Fulfillment Order, POS order and Purchase Order pages',1,335,4,0,'5.0.9923',NULL,NULL,NULL),(233,'defaulttostaticcost','Default Item Costs to Static Cost','Activating this feature will set all item costs to the Static Cost set up for each item rather than using the costs based on purchases and adjustments DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(234,'emailtemplates','Email Templates','Create email templates that can be used when emailing out quotes, order confirmations and invoices',1,345,8,0,'5.0.10014',NULL,NULL,NULL),(235,'blockminpm','Block Price Changes Below Profit Margin','Allows you to set a minimum profit margin per item and then turn on a user setting to prevent users from changing prices below the set level on the POS and Fulfillment order pages.',1,344,4,0,'5.0.10014',NULL,NULL,NULL),(236,'maxPurch','Item Reorder List use Maximum Stock Level not Minimum','Item Reorder List use Maximum Stock Level not Minimum',1,347,4,0,'5.0.10173',NULL,NULL,NULL),(237,'authorizenetcim','Authorize.net Customer Information Manager (CIM)','Store credit cards through Authorize.net\'s CIM system and apply towards order deposits or invoice payments',1,346,3,0,'5.0.10173',NULL,NULL,NULL),(238,'arordervendor','Fulfillment Order Vendor Selection','Set vendors for fulfillment order line items DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(239,'poaccept','PO Line Item Accept','Add an Accepted yes/no box for each line in a purchase order  DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(240,'serialnuminnotes','Require Serial Number','Set up inventory items to require that a serial number be added when shipping or making a POS sale. The serial numbers are appended to the line item order notes. DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(241,'superior','Superior Carbonless Papers','Superior Carbonless Papers',0,0,0,0,'',NULL,NULL,NULL),(242,'fuisui','FUI/SUI (or FUTA/SUTA) Report','FUI/SUI Report',0,0,0,0,'',NULL,NULL,NULL),(243,'usaepaycd','USA ePay Credit Card Storage','Store customer credit cards securely with USA ePay\'s Customer Database tool and run charges against those cards for invoices and order deposits',1,0,0,0,'',NULL,NULL,NULL),(244,'EOMPlusX','Invoice Term: EOM Plus X days','Invoice Term: EOM Plus X days',0,0,0,0,'',NULL,NULL,NULL),(245,'payTypeExclude','Allow Pay Type to be excluded from Hours Worked Calculation','Allow Pay Type to be excluded from Hours Worked Calculation',0,0,0,0,'',NULL,NULL,NULL),(246,'aiproducts','Custom A&I Products Integration','Customer Integration with A&I Products to send over order info DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(247,'groupship','Allow Group Fully Ship Fulfillment Orders','Allow Group Fully Ship Fulfillment Orders',0,0,0,0,'',NULL,NULL,NULL),(248,'eftcanada','Canadian EFT Payments','Generate EFT files formatted to Canadian banking standards to pay vendors or receive money from customers',0,0,0,0,'',NULL,NULL,NULL),(249,'itemstatusvalue','Item Values on Item Status Report','See inventory values in the Item Status report for on-hand and available quantities based on the current item cost',0,0,0,0,'',NULL,NULL,NULL),(250,'oscommanualimport','osCommerce Manual Import','Manually import osCommerce orders DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(251,'usaepayeft','ACH/EFT Processing Via USA ePay','Includes ACH/EFT processing to pay vendors and receive money from customers using USA ePay',1,0,0,0,'',NULL,NULL,NULL),(252,'pm','Property Management','Property Management System DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(253,'positemcategorytax','Item Category POS Sales Taxes','Set sales taxes for POS orders based on the item category DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(254,'detailedarstatement','Custom Detailed AR Statement','Customized Detailed AR Statement DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(255,'authnettransimport','Authorize.net Transaction Import','Import transactions from Authorize.net to aid bank reconciliation DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(256,'user_limit_10','Expanded User Limit (10)','Increase the user limit to 10 users',0,349,8,0,'5.0.10718',NULL,NULL,NULL),(257,'user_limit_25','Expanded User Limit (25)','Increase the user limit to 25 users',0,350,8,0,'5.0.10718',NULL,NULL,NULL),(258,'user_limit_50','Expanded User Limit (50)','Increase the user limit to 50 users',0,351,8,0,'5.0.10718',NULL,NULL,NULL),(259,'user_limit_100','Expanded User Limit (100)','Increase the user limit to 100 users',0,352,8,0,'5.0.10718',NULL,NULL,NULL),(260,'custrequirestatement','Customer Requires Statement','Adds an option to the customer account to require a statement.  If unchecked the customer will not be included when batch printing or emailing statements.  DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(261,'intercompanygl','Intercompany GL Entries','Create GL entries for more than one company at a time',1,353,7,0,'5.0.10786',NULL,NULL,NULL),(262,'userpaymentmethods','Limit User Payment Methods','Limit the types of payment methods users are allowed to accept',1,354,8,0,'5.0.10808',NULL,NULL,NULL),(263,'sumarglpmt','Group AR Payment GL Entries','Groups GL entries together by GL account when more than one invoice is paid rather than having individual entries for the amount of each paid invoice. DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(264,'hotelusage','Hotel Statistics & GL Reporting','Provides a way to record daily totals for rooms available, rooms rented and total room revenue for reporting on the Profit & Loss Statement',1,0,0,0,'',NULL,NULL,NULL),(265,'customsimplestatement','Custom Simple Statement','Customized simple AR statement format with PO # on same line as Invoice # DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(266,'deletionreport','Deletion Report','View deleted data for customers, quotes, orders, invoices, vendors, purchase orders, vendor bills, journal entries and bank deposits and see who deleted the entries and when',1,0,0,0,'',NULL,NULL,NULL),(267,'itemcust','Assign Customer to Item','Assign Customer to Item',0,0,0,0,'',NULL,NULL,NULL),(268,'zencart','Zen Cart Integration','Sends orders from your Zen Cart online store directly into NolaPro.',1,355,10,0,'5.0.11043',NULL,NULL,NULL),(269,'numinvoicecopies','Customer Invoice Copies','Set a default number of invoice copies to automatically generate on a per-customer basis.  Does not apply when emailing invoices.',1,357,3,0,'',NULL,NULL,NULL),(203,'canadianpayroll','Canadian Payroll','Provides support for processing payroll in Canada',1,0,0,0,'',NULL,NULL,NULL),(270,'rpr','RPR Custom Imports','Customized imports and processing for RPR DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(271,'mobile_pos','Mobile POS','Allows a user to be created with a UI designed for a mobile environment.',1,358,1,0,'5.0.11132',NULL,NULL,NULL),(272,'mobile_pos_ssic','Mobile POS (SSIC)','Specific Mobile POS settings for just SSIC',0,0,3,0,'5.0.11132',NULL,NULL,NULL),(273,'itempaymentplans','Item Selection On Payment Plans','Allows items to be selected on a payment plan but does not affect stock levels',1,359,5,0,'5.0.1147',NULL,NULL,NULL),(274,'warehouselocationhistory','Location Within Warehouse History','Tracks when the Location Within Warehouse is changed for items and will display a history of changes on the Add/Edit Pricing & Location page',1,360,4,0,'',NULL,NULL,NULL),(275,'vendormultigl','Multiple Default Vendor GL Accounts','Allows you to have multiple default GL accounts for vendors, so when an AP Bill is created you don\'t need to select all the usual accounts for the vendor as they will be pre-selected',1,361,5,0,'',NULL,NULL,NULL),(276,'persiandateselect','Persian Date Select','Allows dates to be selected with a Persian calendar.',1,362,8,0,'5.0.11223',NULL,NULL,NULL),(277,'separatestmtbyshipto','Break Out AR Statements By Ship To Address','Allows you to view AR statements broken down by ship-to location',1,363,3,0,'',NULL,NULL,NULL),(278,'importposlineitems','Import FO/POS Line Items','Provides a way to upload a CSV file with item codes, quantities and prices when creating fulfillment or POS orders',1,364,1,0,'',NULL,NULL,NULL),(279,'multicustomerpayments','Split Single Payment Between Multiple Customers','Allows you to apply a single payment to more than one customer.  Useful if you bill entities separately, but receive a single check from a corporation to pay invoices for all entities.',1,365,3,0,'',NULL,NULL,NULL),(280,'blockoverseasorders','Block Items From Shipping Outside USA','Set up items which are not allowed to be added to fulfillment orders if the ship-to country is outside the US  DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(281,'checkdigitalsignature','Digital Signature For Checks','Upload a signature file for printing on AP and payroll checks',1,366,5,6,'',NULL,NULL,NULL),(282,'mage','Magento Integration','Magento Integration',0,0,10,0,'5.0.11326',NULL,NULL,NULL),(283,'rtmed','RealTime Med','RealTime Med Custom',0,0,0,0,'5.0.11372',NULL,NULL,NULL),(284,'itemclone','Clone Items','Make duplicates of existing items.',1,367,4,0,'5.0.11380',NULL,NULL,NULL),(285,'purchase_proposal','Purchase Proposal','Allows a PO to be saved as a Purchase Proposal',1,368,5,0,'5.0.11402',NULL,NULL,NULL),(286,'task','CRM/VRM/Tasks Tools','CRM/VRM/Tasks Tools',1,370,10,0,'5.0.11442',NULL,NULL,NULL),(287,'belarus_picklist','Custom Picklist PDF Style For Belarus','Custom Picklist PDF Style For Belarus.  Provides extra header room for first page to show shipto & order number under barcode.  Aligned to print to specific sticker paper. \r\nInvoice Auto-Email label will show under Sold-To box if user has this setting ena',0,0,0,0,'5.0.11481',NULL,NULL,NULL),(288,'leads','Track Customer & Vendor Leads','Allows for tracking of customers and vendors as a lead.',0,0,0,0,'5.0.11542','Permite el seguimiento de clientes y proveedo','',''),(289,'calc_discount_btn','Enter Payment Calc Discount Button','Added a button to the Enter Payments screen that sets the discount field to total minus paid.',0,0,0,0,'5.0.11545',NULL,NULL,NULL),(290,'order_revisions','Order/Quote Revision History','Saves a PDF copy of the quote/order after each save with a revision number.',0,0,0,0,'5.0.11610','',NULL,NULL),(291,'limit_add_companies','Increase Company Limit','Increases the allowed number of companies for this subscription.',0,0,0,0,'5.0.11785',NULL,NULL,NULL),(292,'limit_add_users','Increase User Limit','Increases the allowed number of users for this subscription.',0,0,0,0,'5.0.11785',NULL,NULL,NULL),(293,'limit_add_customers','Increase Customer Limit','Increases the allowed number of customers for this subscription.',0,0,0,0,'5.0.11785',NULL,NULL,NULL),(294,'limit_add_vendors','Increase Vendor Limit','Increases the allowed number of vendors for this subscription.',0,0,0,0,'5.0.11785',NULL,NULL,NULL),(295,'limit_add_transactions','Increase Transaction Limit','Increases the allowed number of transactions for this subscription.',0,0,0,0,'5.0.11785',NULL,NULL,NULL),(296,'limit_add_employess','Increase Employee Limit','Increases the allowed number of employees for this subscription.',0,0,0,0,'5.0.11785',NULL,NULL,NULL),(297,'limit_add_items','Increase Item Limit','Increases the allowed number of items for this subscription.',0,0,0,0,'5.0.11785',NULL,NULL,NULL),(298,'report_builder','Custom Report Builder','Custom Report Builder',0,0,0,0,'5.0.11800',NULL,NULL,NULL),(299,'invoicepdfref','Invoice PDF Ref.','Replaces the word Invoice with Ref. at the top of the invoice PDF DISPLAY=0',0,0,0,0,'',NULL,NULL,NULL),(300,'autofopo','Auto-Generate POs From FOs','Automatically create and receive POs from the fulfillment order page. Also includes the ability to auto-ship the order after PO creation and receipt.',1,0,0,0,'',NULL,NULL,NULL),(301,'hide_inactive_quick_item','Hide Inactive Items from Quick Item Search','Hide Inactive Items from Quick Item Search',0,0,0,0,'5.0.12029',NULL,NULL,NULL),(302,'hide_inactive_item','Hide Inactive Items from Item Search','Hide Inactive Items from Standard Item Searches',0,0,0,0,'5.0.12068',NULL,NULL,NULL),(303,'statementbankmessage','AR Statement Bank Info Message','Add a message to AR statments for when customers have bank info entered and when they don\'t.',1,0,0,0,'',NULL,NULL,NULL),(304,'advancedshippingmanager','AdvancedShippingManager.com Quotes','Get shipping quotes from AdvancedShippingManager.com for fulfillment and POS orders.',0,0,0,0,'',NULL,NULL,NULL),(305,'pacplumbing_pickticket','Special Pickticket Format for Pacplumbing','Special Pickticket Format for Pacplumbing',0,0,0,0,'5.0.12211',NULL,NULL,NULL),(306,'taxclasses','Tax Classes','Create tax classes assignable to items and order/invoice line items. Display sales tax report broken down by tax class.',0,0,0,0,'',NULL,NULL,NULL),(307,'itemvendorcompare','Compare Vendor Prices Button','Adds a compare vendor prices button to the bottom of the item edit page and quick-inventory window.',1,369,5,0,'5.0.12316','Comparar precios de proveedores Botón','Vergelyk Vendor Pryse Button','&#20379;&#24212;&#21830;&#27604;&#36739;&#202'),(308,'3dcart_belarus','3dCart for Belarus','Specific customization for Belarus\' 3dCart usage. (Checkout Questions)',0,0,0,0,'5.0.12323',NULL,NULL,NULL),(309,'invcsvcostedit','Update Inventory Costs & Quantities With Export/Import Tool','Use the Item Export/Import Edit Tool to update costs and quantities. GL entries will be made automatically to account for the change in value.',0,0,0,0,'',NULL,NULL,NULL),(310,'loghourstaxoverride','Log Hours Tax Override','Override which taxes apply for a pay period during log hours ',0,0,0,0,'5.0.12461',NULL,NULL,NULL),(311,'disc_invcat_to_cxgroup','Inventory Categories Discounts','Adds the ability to set discounts by Customer-Group/Inventory-Category combination.   After activation, you can modify these discount groupings under the Item Category edit page.',0,0,0,0,'5.0.12462',NULL,NULL,NULL),(312,'contractorsupply','Contractor Supply','Provides contractor supply industry utilities',0,0,0,0,'5.0.12500',NULL,NULL,NULL),(313,'vendor_certificates','Vendor Certificates','Manage Vendor Certificates.  Adds ability to require valid certificates from vendors before purchase orders can be created.',0,0,0,0,'5.0.12538',NULL,NULL,NULL),(314,'monthly_archive','Monthly Document Archive','Archive copies of reports as PDFs at the end of each month. Reports include: AR Aging - Detail, AR Aging - Summary, Accounts Overdue, Summary of Invoices, Payment Report, AP Aging - Detail & AP Aging - Summary',0,0,0,0,'',NULL,NULL,NULL),(315,'invoice_total_in_words','Display Invoice Total In Words','Display Invoice Total In Words',0,0,0,0,'5.0.12609',NULL,NULL,NULL),(316,'customerholds','Customer Holds','Allow a customer to be set to on hold',0,0,0,0,'5.0.12615',NULL,NULL,NULL),(317,'directexpensepayments','Direct Expense Payments','Create direct expense payment GL entries',0,0,0,0,'5.0.12617',NULL,NULL,NULL),(318,'addressverify','Verify Addresses','Shows if a customers address is valid. (US Only)',0,0,0,0,'5.0.12651',NULL,NULL,NULL),(319,'writeoffs','Customer Invoice Write Offs','Customer Invoice Write Offs',0,0,0,0,'5.0.12663',NULL,NULL,NULL),(320,'archargeback','Customer Invoice Charge Backs','When entering a payment, you can now select an amount to charge back.  This will reduce the invoice total by the charge-back amount and open a new invoice with the charge-back amount.',0,0,0,0,'5.0.12668',NULL,NULL,NULL),(321,'arjointchecks','Joint Checks Flag for Payment Entry','Adds a Joint Check checkbox to Billing -> Enter Payments',0,0,0,0,'5.0.12669',NULL,NULL,NULL),(322,'customerletters','Send/Print Customer Letters','Send/Print Customer Letters (Mail Template Add-on Required)',0,0,0,0,'5.0.12670',NULL,NULL,NULL),(323,'directarpayments','Direct AR Payments','Create direct AR payment GL entries',0,0,0,0,'5.0.12716',NULL,NULL,NULL),(324,'importemployeeexpenses','Import Employee Expenses','Import Employee Expenses and create AP Bills to pay employees as vendors',0,0,0,0,'5.0.12742',NULL,NULL,NULL),(326,'glcategories','GL Categories for AR/AP','Allows you to assign GL categories to invoices and bills and then filter the Profit & Loss statement by category',0,0,0,0,'',NULL,NULL,NULL),(325,'fax','Fax Invoices & Statements','Fax customer statements and invoices',0,0,0,0,'5.0.12764',NULL,NULL,NULL),(327,'autoimport','Auto Import','Allows the system to be set up to import CSV files from /uploads/imports/arinvoice/{for-company-id}/ and /uploads/imports/gltransaction/{for-company-id}/',0,0,0,0,'5.0.12778',NULL,NULL,NULL),(328,'importlog','Import Log Report','Enables the import log report.',0,0,0,0,'5.0.12781',NULL,NULL,NULL),(329,'dynamicwebtwain','Dynamic Web TWAIN','Scanning Integration with Dynamic Web TWAIN',0,0,0,0,'5.0.12838',NULL,NULL,NULL),(330,'positive_pay','Positive Pay','Sends written checks to Positive Pay',0,0,0,0,'5.0.12865',NULL,NULL,NULL),(331,'order_val','Printing Order Value','Report of the value of pending orders for NolaPrint',0,0,0,0,'',NULL,NULL,NULL),(332,'zlien','ZLien','Sync with zlien`s cloud-based platform for lien rights & lien waivers',0,0,0,0,'5.0.12943',NULL,NULL,NULL),(333,'omr','Optical Mark Recognition','Enables OMR printing marks during certain print actions',0,0,0,0,'5.0.12983',NULL,NULL,NULL),(334,'importinvoicechanges','Import Invoice Changes','Import customer & job changes on an invoice (CSV)',0,0,0,0,'5.0.13092',NULL,NULL,NULL),(335,'glfunds','Fund Accounting','Fund Accounting',0,0,0,0,'',NULL,NULL,NULL),(336,'noinvoiceglhistory','No Invoice GL History','Do not keep a GL history of invoice edits',0,0,0,0,'',NULL,NULL,NULL),(337,'autopostgl','Automatically Post GL Entries','Automatically set the status of all new GL entries as posted (won\'t post into closed years or months)',0,0,0,0,'',NULL,NULL,NULL),(338,'oldinvoicepage','Old Invoice Page','Classic Invoice Edit Page',0,0,0,0,'5.0.13352',NULL,NULL,NULL),(339,'poseditinvoicepage','Edit Invoices on POS','Edit Invoice with the POS Page',0,0,0,0,'5.0.13354',NULL,NULL,NULL),(340,'alwaysshowautoadd','Always Show Auto Add','Always show the add option next to the auto-complete boxes',0,0,0,0,'5.0.13373',NULL,NULL,NULL),(341,'checkedit','Edit Checks','Edit AP Checks',0,0,0,0,'5.0.13387',NULL,NULL,NULL),(342,'itemdescriptiononly','Item Description Only','Only show item description for pdf generation if line item is not from inventory (allowing notes, blank space, etc in between line items)',0,0,0,0,'5.0.13387',NULL,NULL,NULL),(343,'editbankdeposit','Edit Bank Deposits','Edit Bank Deposits',0,0,0,0,'5.0.13395',NULL,NULL,NULL),(344,'blindship','Add Blind Ship to Orders page','Add Blind Ship option to Ship To form on the Order page',0,0,0,0,'5.0.13396',NULL,NULL,NULL),(345,'manualcheckfirstpageinfo','Custom First Page Manual Check Info','Custom first page manual check entry boxes',0,0,0,0,'',NULL,NULL,NULL),(346,'inquiriestab','Inquiries Tab','(NP6-UI Only) An additional main menu tab that provides immediate access to various data. All displayed information is read only.',0,0,0,0,'5.0.13440',NULL,NULL,NULL),(347,'invzone','Warehouse Zones','Warehouse Zones',0,0,0,0,'5.0.13444',NULL,NULL,NULL),(348,'itempricesspecial','Special Sales Pricing','Set specific item prices by customer or job (Jobs requires add-on)',0,0,0,0,'5.0.13453',NULL,NULL,NULL),(349,'invadjustmentrequests','Inventory Adjustment Requests','Create requests to users to verify inventory counts.',0,0,0,0,'5.0.13465',NULL,NULL,NULL),(350,'dcreorder','Distribution Center Reordering','Stock Replenishment via Distribution Centers',0,0,0,0,'5.0.13482',NULL,NULL,NULL),(351,'patient_import','Custom Patient Customer Import','Custom Patient / Customer import - special handling of private information from import file.',0,0,0,0,'5.0.13542',NULL,NULL,NULL),(352,'b2b_appointments','B2B Appointments','B2B Appointment Scheduler',0,0,0,0,'5.0.13547',NULL,NULL,NULL),(353,'cx_copy_pick_tickets','Customers Pick Tickets','Double prints pick-tickets. One without order notes and one with.',0,0,0,0,'5.0.13644',NULL,NULL,NULL),(354,'rentals','Rental Orders & Invoicing','Adds the capability to create and invoice Rental Orders via the existing POS/FO page',0,0,0,0,'5.0.13654',NULL,NULL,NULL),(355,'shopify','Shopify Integration','Private App Integration with a Shopify store',0,0,0,0,'5.0.13815',NULL,NULL,NULL),(356,'priceoverriderequests','Price Override Requests','Prices for stocked items cannot be changed except by changing the price level unless an override request is initiated.  Users must be assigned rights to approve these price override requests.',0,0,0,0,'5.0.13830',NULL,NULL,NULL),(357,'paxterminal','CC Payment Terminals','CC Payment Terminals',0,0,0,0,'5.0.13876',NULL,NULL,NULL),(358,'maillog','Mail Log','Mail Log',0,0,0,0,'',NULL,NULL,NULL),(359,'cloneserviceorders','Clone Service Orders','Clone Service Orders, option for copying time records.',0,0,0,0,'5.0.13940',NULL,NULL,NULL),(360,'apvariancereport','AP Variance Report','Report to track differences between the AP module and related GL entries',0,0,0,0,'5.0.13954',NULL,NULL,NULL),(361,'hubconstruction','Special Behaviors for Hub Construction','Special Behaviors for Hub Construction',0,0,0,0,'5.0.13962',NULL,NULL,NULL),(362,'ebay','Ebay Integration','Ebay Integration',0,0,0,0,'5.0.13969',NULL,NULL,NULL),(363,'b2b_remoteregistration','B2B Remote Registration','Allow B2B user registration from a remote website',0,0,0,0,'5.0.13992',NULL,NULL,NULL),(364,'membershiptracker','Membership Status Tracker','Track changes to customer membership changes including detailed report',0,0,0,0,'5.0.14075',NULL,NULL,NULL),(365,'motorstate','Motorstate Features','Import Item Information provided by Motorstate',0,0,0,0,'5.0.14133',NULL,NULL,NULL),(366,'billtrust','Billtrust','Exports for Billtrust',0,0,0,0,'5.0.14151',NULL,NULL,NULL),(367,'customcustomerlist','Customizable Customer List','Customize selection, sorting, display, and output fields (including custom fields)',0,0,0,0,'5.0.14246',NULL,NULL,NULL),(368,'ordernumbering','Custom Order Numbering Schemes','Individualize numbering schemes for Service Orders, Fulfillment Orders, and Quotes per company.',0,0,0,0,'5.0.14322',NULL,NULL,NULL),(369,'amazon','Amazon Integration','Integrate with Amazon Seller Central',0,0,0,0,'5.0.14412',NULL,NULL,NULL),(370,'invoiceslockedbydate','Invoice Locks By Date','Locks Invoices so that cannot be editted after the Invoice Date',0,0,0,0,'5.0.14675',NULL,NULL,NULL),(371,'recurringbilling','Recurring Billing, Customer Subscriptions','Recurring Billing is an enhanced replacement for Payment Plans. Easy automation of invoicing and potential to collect payments from USAePay Customer Database feature.',0,0,0,0,'5.0.14821',NULL,NULL,NULL),(372,'paymentonaccount','Customer Payment On Account','Enable customer payments to On Account, with option set per-customer.',0,0,0,0,'5.0.14851',NULL,NULL,NULL),(373,'invoicepicklist','Invoice Pick List','Invoice pick list print option shown after POS.',0,0,0,0,'5.0.14940',NULL,NULL,NULL),(374,'cxstatementremitformat','Customer Statement Remittance Format','Customer Statements will print with a Remittance Amount line and a tear away header.',0,0,0,0,'5.0.15206',NULL,NULL,NULL),(375,'emaildailysalesreport','E-Mail Daily Sales Report','Users can be set to receive a daily e-mail containing a list of invoices.  A maximum sales margin for invoices to send can be set.',0,0,0,0,'5.0.15434',NULL,NULL,NULL),(376,'cxstatementconstructionformat','Customer Statement Format: Show PO and Client Project Number instead of Invoice Amt and Payments','',0,0,0,0,'5.0.15451',NULL,NULL,NULL),(377,'filesystemdbondisk','Store Uploaded Files On Disk','Store uploaded file attachments on disk instead of inside the database.',0,0,0,0,'5.0.15650',NULL,NULL,NULL),(378,'lastpocost','Last Cost From Purcahses Only','The Last Cost will be based on Purchase Order pricing only.',0,0,0,0,'5.0.16019',NULL,NULL,NULL),(379,'companywidewacost','Weighted Average Cost Company Wide','Item weighted averages costs will use company wide averages.',0,0,0,0,'5.0.16065',NULL,NULL,NULL),(380,'serialnuminnotesreceiving','Require Serial Number When Receiving Items','Set up inventory items to require that a serial number be added when receiving a Purchase Order. The serial numbers are appended to the receiving notes.',0,0,0,0,'5.0.16163',NULL,NULL,NULL),(381,'hideitemcategorycolumn','Hide the Item Category Column on Inventory Item Table','Hide the Item Category Column on the Inventory Item Table',0,0,4,0,'5.0.16287',NULL,NULL,NULL),(382,'customertaxsetupreport','Customer Tax Setup Report','Report to show Customer tax settings for the default company tax exempt status, company ship-to tax exempt status, and primary sales tax district',0,0,3,0,'5.0.16358',NULL,NULL,NULL),(383,'paperproofmylarrequest','Custom Paper Proof / Mylar Request Form for Limitless Enterprises','Custom Paper Proof / Mylar Request Form for Limitless Enterprises. Accessible from Orders Page.',0,0,1,0,'5.0.16565',NULL,NULL,NULL),(384,'arordercontactdetails','Use Contact Details for Orders','Will Use the selected Contact for Bill-to information for Orders and Quotes.',0,0,1,0,'5.0.16850',NULL,NULL,NULL),(385,'setglpostdateonpotoap','Set GL Post Date on PO to AP','Allows the user to define the GLs post date for the transactions created by completing the PO to AP process',0,0,0,0,'',NULL,NULL,NULL),(386,'multiauthnetccaccounts','Multiple Authorize.net CC Accounts for one company.','Allows the use of multiple Authorize.net CC Accounts for one company.',0,0,3,0,'5.0.16888',NULL,NULL,NULL),(387,'saveorderentryprogress','Save order entry progress for new orders','Allows the user to restore an order that was not yet saved',0,0,0,0,'5.0.16924',NULL,NULL,NULL),(388,'salescategoriescheckacct','Set Default Checking Account(s) for Sales Categories','Set default Checking Account(s) for Sales Categories when entering payments for invoices.',0,0,3,0,'5.0.16934',NULL,NULL,NULL),(389,'salestaxreuters','Use Sales Taxes From Reuters Import File','Use Sales Taxes From Reuters Import File.  This is use for places that have county/city rate that vary depending on city-county combinations.',0,0,0,0,'5.0.16958',NULL,NULL,NULL),(390,'salescategoriesglaccts','Set Default GL Accounts For Sales Categories','Set default GL Accounts for use with Sales Categories. These GL Accounts will be used instead of general company defaults when this feature is activated.',0,0,3,0,'5.0.16966',NULL,NULL,NULL),(391,'jbncustomcommissions','JBN Custom Commissions','Custom Commissions for JBN Consulting.',0,0,5,0,'5.0.17020',NULL,NULL,NULL);
/*!40000 ALTER TABLE `feature` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feature_activation`
--

DROP TABLE IF EXISTS `feature_activation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `feature_activation` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `featureid` int(10) unsigned NOT NULL default '0',
  `serial_number` varchar(50) NOT NULL,
  `entrydate` datetime NOT NULL,
  `code` varchar(50) NOT NULL,
  `disabled` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `featureid` (`featureid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `feature_activation`
--

LOCK TABLES `feature_activation` WRITE;
/*!40000 ALTER TABLE `feature_activation` DISABLE KEYS */;
/*!40000 ALTER TABLE `feature_activation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `featurecategory`
--

DROP TABLE IF EXISTS `featurecategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `featurecategory` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `featurecategory`
--

LOCK TABLES `featurecategory` WRITE;
/*!40000 ALTER TABLE `featurecategory` DISABLE KEYS */;
INSERT INTO `featurecategory` VALUES (1,'Orders'),(2,'Notes'),(3,'Billing'),(4,'Inventory'),(5,'Payables'),(6,'Payroll'),(7,'Ledger'),(8,'Admin'),(9,'Plug-Ins'),(10,'eCommerce Apps'),(11,'Language Packs'),(12,'Freebies'),(13,'NolaPrint');
/*!40000 ALTER TABLE `featurecategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filecategory`
--

DROP TABLE IF EXISTS `filecategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filecategory` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `gencompanyid` int(11) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastchangedate` datetime default NULL,
  `lastchangeuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `active` (`gencompanyid`,`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filecategory`
--

LOCK TABLES `filecategory` WRITE;
/*!40000 ALTER TABLE `filecategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `filecategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filedata`
--

DROP TABLE IF EXISTS `filedata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filedata` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `fileitemid` int(11) unsigned NOT NULL default '0',
  `filedata` blob NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `fileitemid` (`fileitemid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filedata`
--

LOCK TABLES `filedata` WRITE;
/*!40000 ALTER TABLE `filedata` DISABLE KEYS */;
INSERT INTO `filedata` VALUES (1,1,'\0JFIF\0\0H\0H\0\0\0C\0\0C\0\0n\"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0CgYwq&>xK(}{h<uE\"lل+0{ZC&RTPk#Uܝ\"pеRUhqF6%@ICu.ۑe`@()nA>p\ndYHF\"ֶPXhnzcѡ͗h@lЦhآVQ 6{Ƣ;C\nl]}>:rDm Kt9Bh:ʕJ4LO$8AʨG-E啫J\\m*KRVr5hqHmMR@q铗!IKPb$K׎ג0	Me2$56{\\صvnqXC\\ߎRczl(rF>r\rEdj2/g_>&~$ӧ޴E7rg.˲[5ٵc8mOAN9!\"{΀p%Ǟ!Mu݂T}6RAz֘Nun;u2/V6m\"t1Wan\\ߒljN*(,w:~0V2S]zn}3dT<yPGR,BC֒2#FܵXk{ymln7=iUj@UFn5xъժ3u?lR^ڙɿm+?wqݪ{M8\'o\0ZyyZ\ZК3xmRA2ʝ6bKؐ5*Ul}!Uo=͵ɢ.76b֊J)~:Wtwp~\0Cv5T[wǽv#j=JUO{v\"Ve{sfxiũHL[q3ZTIa6ƽ0l^3yhOi\"ZrTgYmRيm.\'{=\ZF{j͂D0xiQv/Uͧ9ˍe}c_dsZk65H/`N%H}\\ax<%HCkU0\"uVmL+\rH;8P=5#o1Ӣ˷J\0@5וS\\\'691?џPݶJIǑz\n9е2itYAc\0QP{dS΀8S)]Y{vy#)WN-fU)5f?zߑ|jLrD)㲖3_Zn\Z٫B	uS1B{U8ZJ7pRMV$Z:>EARw\"@ʩ9IRsT ft-5jE}QB6#:Vօ#!(Q[:r\0ɲ:9xtЪxa2[Z5\rw`8_捀A[4Ƨ­<S]\'EݵF\0:j,=V՚a5Ntq2ݐ1Q;g]-EZäǕ:$u֚\"$([,\\iA,˪9yh>l{+AfE-N>R	4;:-hqHT;W1JJYkL*XezdQǖQ{#2EArTx0I*0ج`i;*7ă\Z~ۏ.l5?%fIa%w\0/\0\0\0\0\0!1\"#$ 23A%04@\0\0S狎H_Ց7x~˦~Rnyu)ᄗ\0E8@lP̤g\'xO.rFr&2Kd7=903JĆ뙢Bcf~C`]E\'W߉`Ln!6ITf]Yo|dIӫ(d#D\\g`񓷪N]D/fk\0cweHh,@W\'&p\0dr_DvO@#p?$(˷N>S/7Ku#p̦K\'boWU\0ҪNȟ3(d#!A#Hy#PQ\0rc؟.&v7I#sq3;;0rVb(b-dM((eMn\\_!4sDiR-tg/?t#LBo/QE$S8AF&̞b>H@Xz},Y,\Z>^9ăzBB4\"N?iU3gN9JgAJv@Sض$V,bH	&(F)E\rjHU≅ۑ(Q{vٿǳ/ra_T]vipdΞ3c#x12/va0H-A0LQdD?R	E	\"6\0B;\ng`@	L(ʉZǩbOvChvI>>fI[\'}Ey\rY:䡘㚳/{;}3\")D9XA;fL\09\\N#f>]cn¢~yh۔ \0zƟܚݷ-9>G4c;JŘcEW+KQ[iS\0/d=rMϐ-])Q1\\\\FWr|wkp;D&L y_hƴx\'V0\0x~y]:ǟC,7FASgP8F{\"Ѯ,P\rrA(Q&gQv<o0ҘOM۳vBVi]8(xR2V\0;1rHzڦ[<._	[\\97\\,rbj9\ZcRXzqkU&\0+_/Yn?xj4C)^R~?q>8SIXleG|6~̴m.\0	Coٓi5\rZXhn8c.3ӓi38-^,x\"D\Z$>myF_4Jݟ\nR*6mǜ-~bW|n=lJ(/36z^C;9TMVmĨg^&2\"51v)jH-/fN\0s@o?g]A7׼\\arv[JhFmxtzfX|&Nq;t0c䥴jP9bp*ޫV+O~F\'>>NoT9l?\rO3ggdŨ`SiU=y\',6;\\ӵ\Z|^05q73~>ĉ#FAOwg/{zBh}0h7E+$|`)`u⥏^%&6d`4Hr+ILO}kl\"ʮz9@\n}<SXMJ!`IF\"!?g7Xwi*x<lb,\ZQ\\طS+\Z161\03{7>䷯?Mλ<G0IX(-6dbm{j-0֫-ۺEf \0#ZڭGl9aؕ%,r/ã⫊ٜ$~VNL?6Y5S5ƥϟbrK9c$XJKT9,h0M|-lMqTX.V%2~Ql㿆q M׳;ug&ۃC\0rv۠ɹtIs5fZzkz$59c5;Xמ}jKm[	ïSlF-[٭jLKsQ\0^Ox4ܦBZY}:VRqG	/guXkSV4#L.X[\0?xFp}W1&}[;nAjS|+vYC?</ٽ&%73r\"O%oayZJ煩+ԩt*,4OA-]~w\ZcRUsHs᳖0p&n\\É*yxKXZeq7HFJ,|`#N6MJ6G(DHq\\hbF&u>6%2>qL12$EDJTqidfѲ\rxC\Z|l.MR[um̞_\r\Z\\I\Z/|OqNˍn#frljzh|8Ϗk~2Ik4I!L,Шd$$0BرF5\'H5.<IK2vf/$ɑ}O_?PK{xϸ@m#&O;(\'^ɼI+F&G0գK58 q1$c/Sp~bo-]3\"Gj>ZA㫲V*նN\n&ֵd1W4Gu+n?V!&u~e~bRDq@9)?W,Ⱦ,\naMU7I\"a_ߏf;;E#6ᢙ	FDݙq&dȋ(8mRp2r3\"=S&_$8M\'FdzCdn֊.~ڷRkMNꑜ_XkbijuQi\03dݲe:\n-5zu)əN?D݇;?gSӌ qau/!&8a\\An?~3QGPN<rG/)t\0q>yKi$y|29F5?cy)7\\! F_C\ZQ_`%%HP+q̚*j.\"!M\\xf^\0jsܥOF⣐G&uQ0yYޤo\\Awx@7+]p3&o\0{yoe)tH/atdp(\'9~BiML3NX\05\0	\0\0\0\0\0\0! 13\"#2ABQSCRacqb\0?^ABMB`X-Bn9Hk ,7Dv]YLj#eɂ<\"`B֡`[pX7mR)T5*g9ӸE]cu\rRSW?Txdg9FÄ!rVʓU`m6}Ӷuc9hBd-\\nFCt>+?zVtq:\'	ԬbYޫ=WJٹJBeҎ\"Cwls\0io!V?#lR)TBq,^_}fj4XFԀx5Z4Qdi𶬍FyQ#c}\ni~j?WzkT!c>\'ǲ\'g\\t E$/f4,0	*c5O&4Ġܶ.\Zo5M|TטC_$CI,\\⹐4{K$15GA^M~޿\nYs&\"\"Y]-3fD]&D7%eC#7Cr?`rK)CT歙ՆoeQvN3]WJGpnX7*Skdgrdv9Sj~і5E=%WuH`c%%]Yd冡.Ц	-j1	{SCS\0N@qQ#C*lu#/,>)b.2]\rъn9H p\nwo*ps/._ܶp[U\'x\\D;Z,b	!hX-E7CtZ\"9Z²MEL؜_T`fAw?715`Z-7rJ֬Mdn)83LH8b,BRh/\0:\0\0\0\0\0\0\0!A1 \"#2Q03CRSaq$Bc\0?$w}rqodIE/@\\E{;4XYD,X<SNw%oBCw]k;ٟ-qn-ΟD[{\"\\E0G]eQު6$U4z\'C歆|5\'6*y/V\0J;ڟmo~G$Q~ϪhџRC#Z,i10zMnXlfBֆK\0>2o}y\0V7)KEc\Z^c5^WMȦM%\rZ(0sU[rΔ\"FkT?콠מAoJb\0Zַ\\\0`1%fg[lUu./EK^I`.\Z`u `mz{\Zk*jڈߵGW	\0(w>;tNvq<E)0I.Lb̓$K1|R$A0EB\nWwئZ8ho9K2WJ&Bywe;DMfh2ICB(IboS)\0ǈp.O}Rم~s4a۟\n-Z(8--IvZrB4MlM(9X?y̶̟;.Dʀ06U+jS<lFw~\"2Ě\"f_\"DŻB|E<ALD兓8X=pWܚMS=8hax!ওQ!>xDZgV:~!|t,q\\=V,,ԲbHv.@hEٳA\0K\0;B\nakWg\nioy>E	T[zKߋWgeL[UǅFaDYe>ۚ\"[>!	j>IrE-8WmXBeqD\\_~TSm\rʫjSICcڀ5-nd2}s޺qn$ȓyod^\0D\\-|^;rMe܏/ܜd\"~#2/\0X\0\0\0\0!1\"AQa2q#BR3br CScs$4D%06@Pdt\0\0?3\'	D`#:f*̚Gyqڎco dWdWW$8\\-e\"N&*CZd$*KZ1R)(Z\'=ԥd\"O^1/IJ;K֠@뎢_lmnM\0<u)\\񋂆U	>%QJF/suqvtJA_hPq֖Z[Hw\'(n%Y[~ۯqext>5PvZo8UL&{WovK^WM\Z\na\nw~^5*4JḦxZ~mT4ʫw[3*cur+xa-X#\\bEkZC([\'FԮ9H{κVb9k6!kMOg톬\'|W]aOzƃZNgI%*Ov]#ߨS\'2MyӄS5K \nVI3Ѩ?ϣ\nuԨn	4IU|`Q7#1\n\nRsu9\"8;hnl76P{%;x:K\\*`Oe\r\'jk;/}K||P^u5IJ|x^\ZS+EɱX\"Pr\'uh&\\ =X飄?z/}#t;)QZ\0\"|u9\nr1UywA\0@7Te-@@(I8V{Q-h5थG3H)Ru%<\\zcBp9{ =`i!>N16j85κeF,%4ʾ\"=u)<BKNPEniEq	]T<pR2\n\nׇX]My=iSۄ]ij;זPIzԢqvRB3WS\nz:Q/!U8S^\r[tE,ePp82l}/Ҽ۩^DͣK5R0Q*ZQ_5UFv;K\\B)0(e	R|`4{G_|gF4Њ/>ui\\rb%k<[AOxA6%_Xa*r.p\n	i1Pzj(r\ZM#%[RaJ8d5vf\"@gjj0\rUQ\08]TG\nuԓ8=aiTj\'bA5bi}c\\biz>ϲ.˿UUtn#umP=P|GĆR@>1<ddt%Lh\'p4vÎ+fz],.P!\"1	qtP	$H%=inm^ʠyÉ(vin+\Z*RE!^QnVW]Ӗ-s/)Mt-U6UXϻRu9iTa%E`ͪJ$\nBhשKX$c\n(72փ擟(#T6yG)U))1B\nS>s<#*w11\ZO:O~S0fcX\n\nIBTfe6}auV0\"1P* \0q5K|<Q\nCo(Bn=\rTo1}GdgNcRaOK\ZuT):-o#qH./+U튤&R9w*ԏn<n[i=aO,}ۭ6.ʭ/V[wc1Be^fu^QR9)9Rq`Wݩ\\08h0JK;ǖAj4MtB7\\;࢖9~6m[>xDn)n7\ZW\"Ả xm\nME)T٣޸bvYɕLK˼o6SUZ\'8mR.~}]6p]b in\"7&G~0eʴmPzDLsIQaHIRV텄r	Mq1R2ާK\nd|8(£(Ts씀=<1JAGRI8Sh\"B\rW?BCE*L7i٨㕻Bh(O^-MxstӎNi\00gKwO}>i}\Z\ni\\5/&Ϙ[):7X7OSa_ooy*xBq͛mj\0Q<*7ZՉ{\Z!j˂4Kip!^[i(fe%<\nX=6kD<an*.LBR3= 5/8B7rl{rfmj^l)Í%?T8P}$C<s)ir6I<Vm6orRSTva=10=ͤi j{\"YRR**4H2EV8^[4ܫqBRBR7	\0fTNBg\ZTVGv0N86mAks{il*BR	7e8᪈w^[-«PQ\r{-VlZ\0-I(O|4y\rEGR[Τv\neĠE$!,pZ\nD־uxp%59)EJS*8rx}b\"b]f9FwF$\0&eWhQi$tlD-k!)|h\'!׃ΡC0[Za8Ol{i|m@y=\nX9_\0H&Fjjm[*jm7+Ǥh6t~{NaGm(i3>ގmlAhS%qdƚR[2-K2?V4Nb㒢aZeKw\nǉ,n3sex+W85N[b\0x>W+6@=D?\"0\0wת1Ueq!Ĭ)5#\rzDҐځq+	١v>!V8UqU\0Aqمj/P!\noSRmWѷdLC\ZǌrB+G-kowC\r?82<\"dn,\n6pulÈ(uTVo\'EdKlU^w~*Ux]4{TɞV%h0NbkOBPI-[\"Sf[Ghw\ZGޚܦвĺ^Iwg[)DԠ.u&R(mk~rQܘqF!/bܟDĤmnԌ*:G,%g3O:(ũt%XڬhcbYז\r(٩)w51VXei@#	S:sHxcDm5qČrI-j$@o}RV)^4p(\n.>	?ffyê[ȥJiG+uIĒS/\\qm\nf>\'pS&t(z8LX8\'!\Zܛ\npӳ9_ҏ`#t-M!O\n)^PFm8L)+hpNa5$*Z8I[IG1CT@ҷJEzaM26|[ѡBquZF~y䴂A.M0L3O.SRQ\"Yuw\"LȰܻyձ%Қg%Cgi_X_w@\Zh:UhJT9k)OYԵKR}_BKYk[!ɹAvNZISZ-5Qt5&݋(qD~Rvd[amh1*JHZ5Oi7\Z\rIms\0(HV(|M[O>mi*W>Oz;GJMF&^A-Sap<ļ\'|#GInZUr⻼1T*4%J˙|ڰRi5v}{,*\'ryǤI1Uw0Z\r46j=.P%j+i({a*\r&P6ghoBvi\ZT2V:qRH	PȀiMc%aૐ\\VFtA)k\'l{9)O:R4vA%NWu5yl}ΕRTTZ`HL6x6i@Tg	Ю>78e.#R4HB%BRC\0?FHnYODgRj\Z@	0Cr_)M(jV@ﲄD~ڑjT@H͹Q	\rz~DHP6߷8i\nK-A7Jfq)&Vbb~B[Q\'-Oaޖ\0Bi\Z?G<rkBe4[l%UiaJύ\'([:LYR)\Z_O>\\mW6Z}2J.!KuARR̘|\"@Y몇͹=Ŧk\0PVE=\r7jnyf8h7ڛZߺOdS*Ϝ,N pW(I8n8Qjp\\=j!Q\nʒL=bu\nK/HWJDM>T\0\Zq	-)nL>\r̔Zq-!k몏\Z*zgCg4Khsq%![|J0?9Թ\nO!%etRԚ?[dt\r|3Ju[1uqe+-r=+N\":GՉ{Hܜx[CJcƍ	\'idϛrbH*R)\rP<9KcP||![(6\nRpr2=qcyM}hV\r^]pq^Ȫ$gZe,474~\0˾6:2u) !iQp:7BlJnxI)\'s\nL(7w\"=Ak\rn6ẜ\01ԯ~}޺<a)dҮMy]\nҖmMr=+;td)7V]m6풡$:¾y[EGh5&ZyCqsc촔]hJ3cJr.\r_qnRم(XةjmƗiի%iG).%^-\r)\r7RH::eɊ\"WcJ\\}ܥ\0 ϔ99SMdZvWoqF)\"Ɩ2ٓkd\n)<RXDABV(H^vO葛\\m%	}QKmlRXSLUM62^[	Pb\0~gJL%Mwl9v3tttʤ\'.5PI\r|MjS1ߚAp:Z=҄[Jml `Jg\\o8Y()W\0ie+6[aP:\Zݯ]<[:o%oՃܥ~Nͮcʝ][\rEWԸ[Gf$0[nI%<6UhzblB*m$GEikq\0<uZT:BaUh\'΃φ1qu\'{i=%6?H\"}Hi?$;SZwɐ &1<uƓw\nS|^,J#Hg	@e~@IJrJJpEο(>)ZC:FPa)AvPi`})_܏IF]JT^6AZm[(TI39ܥ=wWc`3IVvSìlO F\0eŬ8Ru	r?BFF\ncu>0He	;.ÈuĢy⭛nWoe&Z=neji7~pA3Jr+]ũBDRsld-)\0S0\raNzr8!(OlgUδE}\r1:*_O08E`&A]k^@ڡƐ\n\\k$j_Qow9{ և-%JTE*::vn]rl<ڭvnʄNIJյ\nIUaQQ]x=i;+:Fk%^Ҽ(O=Д:1kdRbR$E8)Ft٩=Xg<!$[i~\r\0(V:_GNΖʛqe{vOy	6+y+i2ZdGN#TZܓnFZJ_h!auuNGp\\ޖRJ yni4?+ȉaW_/ˋOcn4d%%\Zgn\Zs1Z\07G)#R\n4>PSJEV=azdZkb4(}qs剠fQWʁM.SEyOiP)6+6!LkmO)	cSOc\ZEu;WTmjCMRHq7uJ;WX}TqPjiOɒauvY;2.NȂq0K؆h#5-^e9\"Mw/*P\nF 6y@4uԢ3gCuP8q;4釲-;%X\0cٮQ_\"қL-tJRTr;R}T<`$%C쮲(ju9LTVԀF њ^yF\0)ښOG_U8@v%-)=KnNI549\0+V֒RTRo)Mx/JBʐLɭDb_-7_C3=[%噜8&\Z+#6t֔j˜CZ^Eˡy.2o$Ь S.0CO*ӭl/,}sF6ܞ6l[X^[ IZ˖.cwjJ,Z`6R6մ?7`kX==8B21.UT(;m	G[4Q$gx| gHׯa{#UH\r6U%(n@c@N\nwCUB[J\n>\nm9[)K\\IBƊ2-*YڟqZqM)e(MFwH7QIG{j5\n\nӘ!IaHk]`{!F$u[´{L(۱k*< {K?@.Pݗ]xKzs,6Z=c:j㗪`U\Zjǰj^8}!>!48}qCEB{cZzVEL##QƔ$}qRwSJOvg𼿫)Hm.c f!`x	q2[J8B-XB\n] l0\'ȧC\'q̢<\"b]լ6VuZnA)Jvre`enj_weԲHvm0{uPCU\"h$RUvy}?B쟄)\Z{6N){WM8хN\0ZkN4˔d|!GvL8.]X1֘B]ny*]c 	@\n54ϡz(lb8UyT\r\"¤e-SuAUQܠJS\rM5隞cZrۭJ)+mIr9nꅰGw\rI U¯Mp\ZkNSi[H\0\0\rJ	8nO\nARk{\0B>u?dUChmpR5gbDcx~R	!X*8.	\0>q=LW\0%\n%hyP8Q]Pꡲ6i^j;WW~n\rAr]EK?=l7W@p񇷫[~1)Ȱ(oW8J{C|c*}DV7ڠu!OihlEn5δ疧TAJr	9م6kE 2\n\rV:\0rb?~wN?ϫՇc6?UªnUO}\rcc#\0`O=/\0=;}*WՏ\0\'\0\0\0\0\0\0!1AQaq \0\0?!1S\0p,Ք\\3fHjv1Jzi(p@r\"4G2N;\0\0FA\0̵Ѷ\0;z	hs\Z_} k-!sd^Yo_CP\n\r9НX|/o%K6\Zj}\'X,a u=Fgʍo&;\np-7_giǣ1Dg59:Z\Zc#h3$B<.C_km/`|ss\rhӲY0.	g-yLG5oh5\'?OԶo0ا{L.ª`wu7M\ZY{,k{-]wô[zY+cqL4:Kz\0o!<Z4JSw`֯\'4Ne`/S1mܚ@{ԩF:)t&ǔvq\nVSq9\rN>?0n\"KCP)Z:q@ܒjhgBh\n#=_Q	AIݔcs0Z5\Z{\0CR?&`U|!rM}iІX+`51 4Ƹ惀+䎏/S\0g^Z7:}Dx:5ѻ/p\\I}EBipT6v.[t\r^aaHQLbeOFVR+4¯\\n1-ltpI2E}WxM{NZ\0:DArgķ^r=>~aBq(~\'\'	x\n:0|/pa60J7Նtl{CHMhwPfwşh|W2L>TUt5C0٥SVߐ~n0\ZN,,\0\raײ2ƚ\0h}TXN۵籇Rcu+KYm>h|#CB3P-ig.\'7pe9{xŃl%+d͖f>\r呮3JaNUuZɗY:K]\Zj::̆^#\r96fy\"Sk$\\Ut&8|#sW[ТNfr?4ㄍaG}F²מ#-cͯ9So01rbln +xDX%k\rсS-!\0s>BFc+.:LoU>5\Z<@->2&\"N\\	oVMY̅ӫVif{	*\0א_RJ\0VA],Ks^\"YpO\\>2EF\nߢurG*7Jl)MggD:8ʌDL{Ǥ?j޽\\6<ҷBsðFGw0\'FXMU2~GZ1DA)Vv\0J]a\"~MDjK;yuMU8\\w%5R\"/-5<P:2ĪYB}ߩnR<{\"95zhec0Vfu:~5Z*@:u,:n`зzEKwIN5鹅xeod1Rd&fNa*ı	^?#Jš_s\\$y/IR\03+,3e! \0Z@:/+SPl0?;jZ/Q\\Z&t8ʳS|@[-x\06/v)bl\0fpoqFq`\0At@ai>#wy<_)I,83:L\n\\TD\rɠ[++P#d1|\'kWseh4Lvs$G~bU\Zvz\rWxl|oie,Dx݆G:%;7BN	9\0.o+boM(MfE[Ǳr-KJr[[`~CFFG\0Ck_IőOy|\\(,,.ZsS~ ɴԠŅ`?e+`~S̹9ľA\'UIz4wnm|˛ǎ&URU<:=HeB,\\tFuѕ[a$Vg|gw;	D\\]FJVwV[Gk,XjleLTS_]UE*Xѷ\0iA<&%ih(\0fW@Q/HvUNU.A`\0Y:q:ҙbu;ZV3D{@Np:%z\ZUЛjY}f	@:qHbmt\0u.x-O/q\0UeCg8\nh~gA.,Nl#{x%Xr\0mOeR_&krA\'KfQZLYg\ZYe&-\"bqGKoq+,5Yu9o61P94\0#\0ŗ\Z@R)*P;>\\p\rA4o[G.5wr\0*9\r.IouVĺ	g$c&!_ԯL\nP`\n\r~\0Xxdl*M\'6[>5p̨zkwKPQFd/DJSz	bt77i\"F\rޙ,=ҨE7#if,	3v֗%+bqAN]\"k2eez=kK([ƫW{&+\ZV+j\nTSi	Fn$ԩ<P܈\rQҸNVd_+\0TPg\r)]wk\0QQ˜C\'q_*(G\0e\r0F9{r\"7sW9Lf<K䠹zhp-R.㋁	|)2ՓBKbK3 K?_K5OlBE?D!Yr\"VڔoH<f2+OWpM|6;;\\Î<٧, hpDE5jгY\r2x\\\"w/`mEc~<@BzA.9C2E{}j\\7K\nש5fOW9Ke<.	x;<^!$糊N:ʟxu%țnˁ*nZ }mXBui;oc[\r\"9番v-\\A˼RѐP4aRx*! IG[xyۈW@u\\wt3V~ݩɢ(.D\0erjv\0kMDi*:\0ȉrSqN ]JѣRv\nU+y~{uF,~MzQoCSa~b*-Ak,T;\0-sY,d.54HQZg\0ʰO\r\\aiVi*n@c\0b-R-Wnb]Z&௑^aU#\Zæefaebb&R[-ӣ~k]{`6փC1Jmke5=#/w%a==}ut48PY&j?Gl9\rAMj0_^_S\'G`FecBs0?.DxG2泆MO^{+ݺ;-4xc:B(ԶogKDPtl\ry밈30|u\\0QW?]sG\n^ڙ\n.*8׈2%9},s?Y,rc$4)#]0VΨoG0q-=0_!iKO\rq)(MF\nÿۈ:{jRx\rq	_$ѩаtgK,vIr?Oӎ;pv~/Cl%1g(H	YCܨ(Nz0fsJUaIj\n4Tg]w`;q3]Z{8pՂOW4\0!-T}S \'G NF\"8X-	bfWwo5Ul\\̴A>/F]8IRr\0Z)`:]*tWZ\rs\0.peGU)ihtr\n!f\n.a\r3@q	V5|<QʭT1խP62Syow@w;C	xNvl8f\0֥{J& \ZHgS=A(R77\\v㿈9	TgEfxk٪z$)(Q6f-I:,`gV	G\'79۰t/(#!O1utY}<0ZM+(Wn9`]\"S笤ĕ3gkfzJ&g,aD:ץ(Ϋ<E+oYHB@/\Z\n],8y#zFE&gRCv`^D觮{ɱvELh-[)O6\r=8o/f-☗!n\rt=AwܻF>\r撬߷Ce\\_U7`&FG0c=g%QЛDs,4Pkuۼjg`CP\rCN@U-zu9/Ĭ\Z놧J \0p22oOEȳFW?hW\nƠN}wqp\rΝ\0?(teP4ih(k\07䅟4rbMz^7×\\jmx+0,a*-FHתu8O\rȿlX\"aZvQI%2?*#2Pw#@5[5ֻbI5Z\r*\rG̺,N()Hf#QߑGY0xk.\Z4<M+[Ew7Ģ׆謝T e%&ꮉ򗡸p@1OʀvO5W&TKj\ZP(YlzoP*V%%9]q a884\r({Xznxm{K1l\':\n)ZtSD5?ᝫAү\r!G<-Oǖyfx͢z0N`!\0ξ~/]b&x\'?Pxd8I~)bOƃ!ָ+VSIhlz~Nc+:S΄҂bԩ$NYjX]5̀9^(ij-.Bo=(nȪ+CD0}|jmǪ>\0MyN2>dM9_6NP<Ŷ`r_1bS7ܮt5u%Woڎƍ<oiF$/Jec8 7읤?*cq/i4tXy\'!5[u)FO~ZB%칸V:\n|2yh;{c(9>9Anea5\\ԳJ%C_(\0rfƞ´ۏUCmW/-p˖d2oeE}&	BG^\0PCP={IP=Rwk˵AnK~\nJ\0@t\0wЛ\0C)\r\'c݈ӟ*HY]-%e|3mwQ=KR\0#+Rk![/]꯳)X̃oZo\0S.n,v3s7+1t\n~0g5lf^R+WQz5S։kT*TDZ?#`Xո.ZKTE ʧ-f2U9@\r^\Z+ksaV\r3+\ni\nǷml\r\Zb`W#C/\ZJj\Za?,51Un^*|]HScZ7{cC\0#Z,ql?|1#FGwVqxĺCB8Ņ.nq{KL)Gm䈌+Qfune=XTj\0\0\0\0\0\0X\rD4T$/nqp<05P$Lן@]\0bݘE\0w ^#p((Aik\Z]sx|=c}Md\0_ŠRF\Zo\0>Kl1<eLjӊHnc>1QYo<_.ZPkPdɎ%FJ6R6%&VӜ曐IBGr\0,bAQKHa=#$\0zRsTPDem~8%-b=RqXc4\0\'\0\0\0\0\0\0\0\0\01!qAQa \0?GBBe!|d/BH_r2,ypZrmlh\rM*:43RF@{!#	!u!|rH_	!|b,պ!BH_BUQ\rqU\0_g؃\n) *\0( N@کyD4\\lm#\Zy0\Z-bj	龛&aRHp*v	\0B=+񐺐2!\0\\nfVE٠HBXy愪ͮiڏĖ~4Z/M. ׷8]N]Q8\0ߢ8Fy2-HH(FA\"\0TG,~h,|=?`\n6Tm݂6wW4u`\0?Ḫz!y\0ֵ GY(A ;ڨTx@ќPB̵\"XE=\'$]n1!Uډ8AYVi!Q	dvat$ibg2SBud*p8}\n\0@A>/ёy!\0¨aHut((1tIz7-~N>\n~hJZp!Ȥ$\0{Whz1/ٖD&f3 NV`_.&YgUġ2De2BCX \"KUFڠ\01n@t(we\Z (X#C:H\0a*z[QJz\Z!!J xBFfP\0Ŷڠ0ް\". {QjD\0SO(z\"D̈>.$j*ne␺2BH_!|d/ 1R_?4TtJ玪 o&Crnd>GH_,RBD	!|$/RH_!E*A\\?QPj͕+z\\n69mJ@6\0Hv\0(\0\0\0\0\0\0\0!1AQaq 0\0?Gu\0d<p#h\09kG4~vx~rI̛~.OfDwHE\Zu0xdǶk:fnPD9=OtVOS\r4QҴ^tqȫ\"mEC8xM\0v<VRżPA\0}T1r\\	P	c/_$A\\֭(Be61P,遳oRI&3~Taӯl@^wG&`ΊP?iIBCr(>Bfd-ޣ\"KOM8	]\0۟\\smﶉ?W#/!f7FcN$;LPWGǸ5ٗ@ŷ?~(c\0u`>Cǿ<4vx<Vv <T2ۙzU\'nIxz	#\\%*RV	~2njPґipmdopIKO!#ϵi#z|pFJUؐ\0	\rIRXBb<Q&H9gΔAO@u5s~k?ƛnYfK!sSOS|QYݯCBb!CX-2;x<W`xӑw٤څQf\"R+\'^P)̎\Z\\$̎qFI]Ϙ\\ӛJćJ2t}rO|RD|iDmDߑY=O:ק\r?vOIVeZ`D?!QjA	[ΤEg>U_nv\'6PasQrlz,ö4xK:w&7#9\"YHϣ.g+FbB\0K	R!m[4sVn8|ny!7*TrjБ6_o\0`\0\"0Xer~OZ\Z8h%h\0&Jmft)Ye+ŻԈ:Dqm~SC\ZkLM3&-07b$\n!4Kq%	`JrݚW־du\0_U+ǯ\Z8hV:8u2;xzQ F_[7c_W	&	:4G\nv\"2sטLjfcJdxW\0\'\0\0\0\0!\01AQaq \0\0?z޿x\"ҧOz킁\\g!>\'$\r:@\'DP(\'X=2\0c\rWΓ	R#gH!K/	K8ɭL=]#[?y8*Hɳ\riW#`\n*ar@r}`C7-nd36uiF	& ϱ1Al\'Ϸ	#!vo|wSy2K<D^2S	6JPˇhx7ӒfǓ\rL4\'Ӎ7e\n\\Ln,`nwzDtKA6c`zp:z<~K!H\nܷ݉J}WeK͡cffc\"P`\"xUxuVN!\0$֚{ӠNTyeL}`B7g֞qCB18w=~KUt̩Z4-͎bca\0C\0bAJ%\r\n\\pL,7e`\\$Sm`c%\0J78C@5 u7ڀk1!Ayi0Bȱ֋F-gP\\XLi$]/\"u7bD\ntr\0ГGVY+2~r`{.AX\'~D:㄄)45:WB\nk-,aɐ@|:Ρ=\'$T\'B-Qx?YaO\r|L	j>0iqs^؄\'k|\04k?*D\0PKN|R\r`H9W#<<}J21rGՀ\'׉ߙ_*\0\0m:Q:\\QG\"}8ف ,\'$J}fǓCF:U\"H*&hx>~:6NO7Ǟ0)K IRT*t\0I+NT5׽x  m2IdA&\Za[HJe0GsMx\"~\\@~shx>- ݆![t4wX+P͸\n`,X}aH≽{\Z}ۯ}ixlԔlӛ_7\0kxE\03H>)(A\nTCIj\"l՛LI֎@+͹50%+#jВC%-\"EhqnJmW_DE$(2:0M2Yn.f\05s\Z:\nN t^b~vp&`,x\\uтn\0R4ҸS=Skd\0WQĴdS7Zԋ;ӽ	t/-!ӎ`Z+MetD\0d.w	?!;]嗏$w\0)\0\ZfeBa&/وfj(LfiF&8H H l#y*i 	ϛH;_j,Ml{F>RD4v=3c+spY3a<qΖ;nF$Iu.O~4I9!aUOb-C$==%(I0GMca#ϗ|@=Ƈ@	N+J|#ST㆛4bՆe6WF\0`?ZD!4pk+x|L}b)ߡOlj\']{	d\ro=;5H{/r懃Ru7%22O1YΏ<b\"Q\03BX5eq&1x}sgewuw6|}h˾!לMAz3I` q\Z&uZ3Rc5%\'D%,&\r\Z6=\r#1(H4	,fK\0F]nU	lşgLU!6He\n61(v3H{{}#dhw`\\\'RĢRε޺s\n([\r%hq\nh!2DcYfcLsN=\n&H!g.bf]ArbCԎj`X5=\"^{bA})ԧ1}BLtY<\"[=As߇_/5Y>\'p`O\n]$%BlYɉ_*\0Jt״bl{2x;8B3N66},TGe0%\'\'8<#@ˠ:DHDKH|dV \\ۆ\nscw`vAIyDwF8Ag/_={=$r`8δtW\rdĤ\0DyV3J4lvu(%!dT#RBJ	JGwNI\0n\\4Fբ0۬RX9.ˀE#sM6Ad\0!HH@d\\$&5aFBq@V\0Tzd?!g/(&xsOV)S@Z!\\sVFHAk\0s\0ȱX89B:8ʐ%i]57\0G9RŤZ;S\0E5J$^u`=&)r1!u(՜^E)`>H:iq޾ndF\ZGҠkZy׼vs-La+6|b\rF:lqc2SǗA\"]kHN$I17C O<p|26o9+_|n]̽u\r0)jz17f}`HXx\\8U|]5_M1\Z,d7%w3(n{@Q}%{\0\'`Gqj|߉f\r d}g $\')X-uZ5\'U?dB6\n\nEKP!ԒN0J%PwM5)%w?ݑs:g\0yKbN3V(J%+-4r;Ȣ^[`@n\'@t8X8l|d)WE\'wnI?%) \nDE\\bqg/>I:H%DƻX&Nf1А$4hp`؈\n[e8M{7\Z=`1+$oJ\rOVN\\Shr/]+PРcBv`GӷSfPZg\Z~ȉ^OP\np\'7Vmvo.<_?J\"jSOl4\0ݨї\00/Hf^o\'aؤu?FB4EH*n.r$N\0?CJi4-./᩼.DEBX` 7F3Y1yj=d!PΤ~rl0b=tȴQ4#K!H-=-5\0gc\0A,I[9wX#<?ܠͷW\"iK\\K\n\'1|N#`3?Sǎ98C\'L5tO\n\"9]up\"B Mz\nVad%)$7Г=,!E\0kvDTfxCcEH)Po8\n\n<I$P>#IG݁:_$My?n쌧Ax(P-/̾\\EiJN9/6Κ+ۀ%\\KU]1.Wt\r<1N33  \n@\"i9mcc#d`&$Y^SgL6ˈ2?z\0SIUf>e2w:Z9re*rlVJ/#\0\0Eʤåq\0#5!dpQBo^Y78\':bܐ6ӫ\rS85D\"r2pDI	)xNHBoˍm`9cqqa\'\Z%%j#, `1L|`]hAbMҎQ1n(\\IqVsb{cuVH7Ϭ넬X9yrwKd;Ŀs\0͉@\0+{ecKȘ8A%ޓϕ,~*-x>D~c\'Zea\Z-h,fxdoo#J(ZN4eE~x9l{bnLi\'5DQf*fX5FU\ne\'4f,oMIz1H9D$B=vk!ցir@\\Y$C\ZY	<h6! R#g-Ģ)W=2h#1^@o>/IZnQX!i2fuw$oڿ?R,)Ԧzi1&&3\Zd떆{?!I>s(A&Nʈ(w$DؑkZ(uβPaLC最Mk<%n8sA6pxwTJƺA8dX(H#αFUF^Ǳ\nWndzw@]]8g(ey\ZP\n	8U\0AY~IbuPɬSGldxy#ՒPea0)Vtu°i=`(pzA,>ӉC#&UCAkEc]do>Vq-2+~-,,]8/!Cy*nQ%BbpowX\"H#N,A̳0z`I\rr` J`./C\nЗ5s$Nn?|a!*a\\D`<>@\0\0J W(uAxs|Ǘ;(H	ep#cdBnNH&ԁ=c)ڌ!a$$h5e\0N]sXp9S\n,H;3]Q36 5{)|/>c\Z8xnF@o>1kJf9m/~YY\ZJE΀{ǪRq:R+|Y`	YA\0j0ӓg`^fdB)&&nkj0  ba]5#c۸#C=^owcL22\0r9|bh׉H72@{ĖZ80Y`X\0J,S0J\r8_HBXJ^×\n\'- 9\ZFKL?#\\T!.irz\"s+0_;h\n,n2\rThǘF#\02qQOGop-<dpr\"<&`+˔E;b&&ڬqq?qI⁖P!\rIDE%mO1;<u$MD\nlF,J$\'/HBƎ_[&B s=Ao`*\\s\\6O\01Σ=S\0Nw0Og\0Z\\@)>{ɹ1M04&Hb%IR}cuz)jЂC\0y-$g?ra:阈fX=&gDAFy˜뜫GʕQ	d 93=E#$_?	JĎPc\"c.pp$9kj1pTM\n-VxGyK!!A|9.(g\'m\'F`q|q[竺5K^\0`qK.$I<T`BT񆲈Iw`\"/(EN.5xO|20]aM`:\njR93D:Rm=-oYR_9P!XĬF\".Փx+Ѷ\"8 1W^)e7і\\82BȝK`ud~32D]\nc*w]m`:眎ޑ},weS$PKF&k~0RxZ$\\5l(a-H\'ipBI;{W9Ty;MVpO/\":0@8қ<&arYWC9@m̷&Y3A ~Iv{0j%}t#\00dcL^pߙ\n\0{LYu<%>\r8c:nU:dh}-mrĜv0c3\08cd`q3ick*reOy:=!E(Yr؏3ҋ\0x}j?y\0sZw}G$n9Qc4.u)&Dw1:ι#G|4}MځSY$_96=_Pã@Skfp_&F.	\0.	U^=M\n9ORfɊ;eDy+dE\rטS}b4.\0p[wx\ZA~8\08D-n)e  \nw!̑PvP|D6HxcZ	9l-ZnrB\0\"0j%U ϼ/#4xA:x :KkB,9fpYओ\0xgKFH	a:L#>ΞMVD$<b`\'^2ہ79\\̌\'W>%Fly>\0~VU]cQ\"Z|`X\"DN6e҈\'dD$\"\'8M*Xn;Pbo0{(Eٱ>Cmtf2w\Zkc>(EtX]x㢢Zje(CF\ZtcO\nE4M55=\'ȉG$sDlw;\n=gӟHD k@ k1$qt;8H$P;`pP)t麅;U-#Ӆ7{1Q@T!ƈ\"xp9ǲ&DpG7HeS76Wۛ9qV`q}\Z[$pԅ|\\0X ;㟱@@ik3cꏼ[H˩~X1xȫ,EY06tkPh~*юY&\nuj<s͈y6_Kr74/	zK:ƣ]F1[~0Zc bΥRKaG\nM$YxT\0VM198\"a1Lgܶ `9q\"^Ӊ 6*&>p\nPƋcbSP\rPSW\0i2Se9\"2<&r|XɱU#$ڢ)8HFM>KX^;f,aw\0&G-Ϭyؚ[+i1zY`(|`Ao6@.s\rqdLCs˜d)Wrfn	an3Ǵb6|=$_ly>D\n`,9I.MTaۄXA >:=^-4/[͏\'@\0Һs\0I)@9zxESEA(Th4x``U}L_8q$x\0\'<N\Z	6NR^\"pd\0BEf5Hm$eKw\0u4<XV`#DŊ&{d/~!\n!Q\r\0e S6۠9B\"x]dS>>(DJuezeX(TiB+T5;ǦY	8f\0rXh(C4k\0oVDX$2@J\"d{@.\0GH\ZEaZQBR9 MP%U5E\0䍙haŕ˃Vx\0|OI:.N	nD!@ʓe/P-rI,\Zhq6x#A2MM^(ԟywRHa`H<Wj\"\0-%b[GA-sZvgv<8cY9\0^v)	)(wItn.i*$=1YQ{#\0D;n?S˻;dtCAC\r	vsRyݿiˋ	21/}ۜiN<٤x{$d6J;(uCɕw9.P\\?V=fn]a[\0Azv2d͏\':feS\rw7$e^sӾuT=\0JcW0E\'P0~\0r\rx9zaiA.\'^&:A̡p<߻U>9W/c9\rȑ,-됆\nPHrX4CQiU>\\}aM%.si !3x@Ǎ<>K9oX\"C~,֗JNi`71h\'7!y\0ӬeM\nH]+^V\npƞNbNu: Z@K\r_%褞I*6 ((1YKCƻoBH\rFɩ0h.M\nFמgQC\rʞ.26$^!(׷e(\"%Dyk\0r)\'\0NnYvkHJ=%\n\"=\0\'d!b@$I\'C`Ć#N,5זOLsI\0	jOH뀏CÂ!yQX2d)M\rcP4ON>^WĿwF&.cA$(&F\\TsF)\0=jS;JD4L`ڏy\\ƌV,MxH%ly>@C-ѕZȞ$=b`fj䥍n0}o?͏\'AI$ra\' BABq2C?8g/_	B&X$\0L	L\'m#;%t\nx<\0)o_BY`.`\'./ 0W	\r:x[εu\nJ\nQ2:hY=͘ EѿTs\"#|A\0Z	#*8<d5Tf=ٳ[1υH\'@!	_<&($\rMnmK9 888T,J\0 Xc`@\Zpd֜JSrzbRaTG=P)θ7B\"Ix4dtPK	p#\01a(X,\0خŬ>0u$A#\\.x}`JN\rZ|uIH<LV&d(%bÿlP]N\"Do{CavPف1Ư5\"ę\"A5%\\L8\nr֒RDj@S\\8\rBD[9+Y!6`wB+\0-;\0P[rdq5,}9b@!=\0&~j|ϯ٭׾ĕC+:}ĘMv!bIly>c(u0a²Gh^lI͏\'H!7$ g/_֧֠\rӷWI2Df\n6?*2l|r!A))RYf5|\0\"	K59ktC3C0=*8D(kb):osR*$=ot@BB :\\V5BaR42 4:Ą#Et&Ұ)PVXo\"f\nؔM%&ς952bCmT`R!sxkST)&\"RlOr!3dY!$:`c%r!Me4c'),(3,3,'%PDF-1.3\n3 0 obj\n<</Type /Page\n/Parent 1 0 R\n/Resources 2 0 R\n/Contents 4 0 R>>\nendobj\n4 0 obj\n<</Filter /FlateDecode /Length 19>>\nstream\nx3R235W(\0\nendstream\nendobj\n1 0 obj\n<</Type /Pages\n/Kids [3 0 R ]\n/Count 1\n/MediaBox [0 0 612.00 792.00]\n>>\nendobj\n2 0 obj\n<<\n/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]\n/Font <<\n>>\n/XObject <<\n>>\n>>\nendobj\n5 0 obj\n<<\n/Producer (FPDF 1.6)\n/CreationDate (D:20120711083435)\n>>\nendobj\n6 0 obj\n<<\n/Type /Catalog\n/Pages 1 0 R\n/OpenAction [3 0 R /FitH null]\n/PageLayout /OneColumn\n>>\nendobj\nxref\n0 7\n0000000000 65535 f \n0000000175 00000 n \n0000000262 00000 n \n0000000009 00000 n \n0000000087 00000 n \n0000000356 00000 n \n0000000431 00000 n \ntrailer\n<<\n/Size 7\n/Root 6 0 R\n/Info 5 0 R\n>>\nstartxref\n534\n%%EOF\n');
/*!40000 ALTER TABLE `filedata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filedefinition`
--

DROP TABLE IF EXISTS `filedefinition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filedefinition` (
  `id` int(11) NOT NULL auto_increment,
  `table_name` varchar(100) default NULL,
  `file_function` int(11) NOT NULL default '0',
  `notes` text,
  `prompt` varchar(255) default NULL,
  `upload_limit` int(11) NOT NULL default '0',
  `modaccess` varchar(150) NOT NULL default '',
  `modbit` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `table_name` (`table_name`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filedefinition`
--

LOCK TABLES `filedefinition` WRITE;
/*!40000 ALTER TABLE `filedefinition` DISABLE KEYS */;
INSERT INTO `filedefinition` VALUES (1,'sales_categories',0,'Graphic to print on invoice when this sales category is assigned to the job','STR_GRAPHIC_FOR_INVOICE',1,'ar,public','011'),(2,'itemoptiongroup',0,'Graphic for a group of item options.','STR_GRAPHIC_FOR_OPTION_GROUP',1,'inv,public','011'),(3,'itemoption',0,'Graphic for a specific item option.','STR_GRAPHIC_FOR_OPTION',1,'inv,public','011'),(4,'genuser',0,'Checks this user has printed.','STR_CHECK',0,'ap,ar,gl,inv,sc,pr,est,pricelist,pm','011'),(5,'customer',0,'Files associated with a particular customer.','STR_FILES_FOR_CUSTOMER',0,'ar,pm','011'),(6,'vendor',0,'files for Vendors','STR_VENDOR_FILES',0,'ap,inv','011'),(7,'arorder',0,'files relating to orders','STR_ORDER_FILES',0,'ar,inv','011'),(8,'arinvoice',0,'files for Invoices','STR_INVOICE_FILES',0,'ar,pm','011'),(9,'apbills',0,'files for Vendor Bills','STR_VENDOR_BILL_FILES',0,'ap','011'),(10,'invpo',0,'Files for Purchase Orders','STR_PURCHASE_ORDER_FILES',0,'ap,inv','011'),(11,'item',0,'Files for Inventory Items','STR_INVENTORY_ITEM_FILES',0,'inv','011'),(12,'itemvendor',0,'Files for Inventory Item Suppliers','STR_INVENTORY_ITEM_SUPPLIER_FILES',0,'inv','011'),(13,'premployee',0,'Files for Employees','STR_EMPLOYEE_FILES',0,'pr','011'),(14,'salesman',0,'Files for Sales Persons','STR_SALES_PERSON_FILES',0,'ar','011'),(15,'gencompany',0,'B2B Login Graphic','STR_B2B_LOGIN_GRAPHIC',1,'public,admin','011'),(16,'gencompany',0,'B2B Company Header Graphic','STR_B2B_COMPANY_HEADER_GRAPHIC',1,'public,admin','11'),(17,'gencompany',0,'B2B Print Logo','STR_B2B_COMPANY_PRINT_LOGO',1,'public,admin','11'),(18,'b2buser',0,'B2B printouts','STR_B2B_PRINTOUTS',0,'public','111'),(19,'igroup',0,'Graphic attached to the customer group.','STR_GRAPHIC_FOR_CUSTOMER_GROUP',1,'ar,public','011'),(20,'gencompany',0,'Background PDF file to use for invoices.','STR_BACKGROUND_PDF_FILE_FOR_EMAILED_INVOICES',1,'ar,public','011'),(21,'estquotequote',0,'Artwork for Print Orders for Pricelist Nolaprint','STR_CURRENT_ARTWORK_ON_FILE_AND_UPLOADED_POS',0,'public,admin','111'),(22,'estquotequote',0,'Internal Job Documents (Filled-in Job Tickets, Customer PO)','STR_INTERNAL_JOB_DOCUMENTS',0,'public,admin','011'),(23,'gencompany',0,'Custom logo for login page','STR_CUSTOM_LOGO_FOR_LOGIN_PAGE',1,'public,admin','011'),(24,'gencompany',0,'Custom logo for footer','STR_CUSTOM_LOGO_FOR_FOOTER',1,'public, admin','011'),(25,'message_graphic',0,'Message Graphic','STR_MESSAGE_GRAPHIC',1,'public','111'),(26,'gencompany',0,'Background PDF file to use for invoices after page one.','STR_BACKGROUND_PDF_FILE_FOR_EMAILED_INVOICES_AFTER_PAGE_ONE',1,'ar,public','011'),(27,'survey',0,'Header for Survey page','STR_SURVEY_HEADER_GRAPHIC',1,'public, admin','011'),(28,'building',0,'Lease Docs for Buildings','STR_LEASE_PDF_FILES',0,'public,admin','111'),(29,'project',0,'Project Details','STR_PROJECT_DOCUMENTS',0,'ap,pm','111'),(30,'building',0,'Property Documents','STR_PROPERTY_DOCUMENTS',0,'ar,pm','111'),(31,'unit',0,'Unit Documents','STR_UNIT_DOCUMENTS',0,'ar,pm','111'),(32,'lease',0,'Uploaded Lease Documents','STR_LEASE_DOCUMENTS',0,'ar,pm','011'),(33,'job',0,'Job Douments','STR_JOB_DOCUMENTS',0,'ap,pm','111'),(34,'loans',0,'Loan Douments','STR_LOAN_DOCUMENTS',0,'ap,pm','111'),(35,'courtfiling',0,'Court Filing Documents','STR_COURT_FILING_DOCUMENTS',0,'ar,pm','111'),(36,'building',0,'General Tenant Info Documents','STR_GENERAL_TENANT_INFO_DOCUMENTS',0,'public, admin','111'),(37,'bankrec',0,'Bank Reconciliation Documents','STR_BANK_RECONCILIATION_DOCUMENTS',0,'gl','011'),(38,'prreimburse',0,'Reimbursement Attachments','STR_REIMBURSEMENT_RECEIPTS',0,'public,admin','111'),(39,'estquotequotebindquest',0,'File to Upload for Number Selection','STR_NUMBER_LISTS',1,'ar,pricelist,est','011'),(40,'ccpurchase',0,'Files for CC purchases','STR_CREDIT_CARD_PURCHASE_DOCUMENTS',0,'ap','011'),(41,'gltransvoucher',0,'Journal Entry Documents','STR_JOURNAL_ENTRY_DOCUMENTS',0,'gl','111'),(42,'arinvoicepaymentdetail',0,'Customer Payment Attachments','STR_CUSTOMER_PAYMENT_ATTACHMENTS',0,'ar','011'),(43,'survey',0,'Survey Email Attachment','STR_SURVEY_EMAIL_ATTACHMENT',1,'public,admin','011'),(44,'checkacct',0,'Checking Account Files','STR_CHECKING_ACCOUNT_FILES',0,'ap','011'),(45,'vendor',0,'Uploaded Statements For Vendors','STR_VENDOR_STATEMENTS',0,'ap','011'),(46,'emailtemplate',0,'Email Template Attachments','STR_EMAIL_TEMPLATE_ATTACHMENTS',0,'ap,ar,pm','011'),(47,'gencompany',0,'Quote Attachments For PDF','STR_QUOTE_ATTACHMENTS',0,'ar','011'),(48,'gencompany',0,'Order Attachments For PDF','STR_ORDER_ATTACHMENTS',0,'ar','011'),(49,'gencompany',0,'Invoice Attachments For PDF','STR_INVOICE_ATTACHMENTS',0,'ar','011'),(50,'bankdeposit',0,'Bank Deposit Documents','STR_BANK_DEPOSIT_DOCUMENTS',0,'ap,gl','011'),(51,'customer',0,'Customer Profile Picture (Before)','STR_CUSTOMER_BEFORE_PICTURE',1,'ar','011'),(52,'customer',0,'Customer Profile Picture (After)','STR_CUSTOMER_AFTER_PICTURE',1,'ar','011'),(53,'arordership',0,'Order Shipment Documents','STR_SHIPMENT_DOCUMENTS',0,'ar','011'),(54,'waiver',0,'Files for Waivers','STR_WAIVER_FILES',0,'ar','011'),(55,'workorder',0,'Tenant Work Order Attachments','STR_TENANT_WORK_ORDER_ATTACHMENTS',5,'ar','011'),(56,'workorder',0,'Internal Work Order Attachments','STR_INTERNAL_WORK_ORDER_ATTACHMENTS',0,'ar','011'),(57,'invreceivemain',0,'PO Receipt Documents','STR_PO_RECEIPT_DOCUMENTS',0,'ap','011');
/*!40000 ALTER TABLE `filedefinition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fileitem`
--

DROP TABLE IF EXISTS `fileitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fileitem` (
  `id` int(11) NOT NULL auto_increment,
  `filedefinitionid` int(11) NOT NULL default '0',
  `tablerecordid` int(11) NOT NULL default '0',
  `filename` varchar(255) default NULL,
  `display_type` int(11) NOT NULL default '0',
  `datatype` varchar(60) NOT NULL default 'application/octet-stream',
  `size` bigint(20) unsigned NOT NULL default '1024',
  `filedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `companyid` int(11) NOT NULL default '0',
  `entryuserid` int(11) NOT NULL default '0',
  `b2buserid` int(11) NOT NULL default '0',
  `notes` text NOT NULL,
  `filecategoryid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `filedefinitionid` (`filedefinitionid`),
  KEY `tablerecordid` (`tablerecordid`),
  KEY `b2buserid` (`b2buserid`),
  KEY `entryuserid` (`entryuserid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fileitem`
--

LOCK TABLES `fileitem` WRITE;
/*!40000 ALTER TABLE `fileitem` DISABLE KEYS */;
INSERT INTO `fileitem` VALUES (1,15,1,'partnerlogin.jpg',0,'image/pjpeg',35315,'2006-01-24 14:04:36',1,1,0,'Business to Business portal main login banner',0),(3,4,1,'statement_usr1.pdf',0,'application/pdf',749,'2012-07-11 08:34:38',1,1,0,'Attached is your Statement ',0);
/*!40000 ALTER TABLE `fileitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fileitemattachment`
--

DROP TABLE IF EXISTS `fileitemattachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fileitemattachment` (
  `id` int(11) NOT NULL auto_increment,
  `filedefinitionid` int(11) NOT NULL default '0',
  `tablerecordid` int(11) NOT NULL default '0',
  `fileitemid` int(11) NOT NULL default '0',
  `sortorder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `filedefinitionid` (`filedefinitionid`),
  KEY `tablerecordid` (`tablerecordid`),
  KEY `fileitemid` (`fileitemid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fileitemattachment`
--

LOCK TABLES `fileitemattachment` WRITE;
/*!40000 ALTER TABLE `fileitemattachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `fileitemattachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fileitemattachmentdefault`
--

DROP TABLE IF EXISTS `fileitemattachmentdefault`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fileitemattachmentdefault` (
  `id` int(11) NOT NULL auto_increment,
  `filedefinitionid` int(11) NOT NULL default '0',
  `tablerecordid` int(11) NOT NULL default '0',
  `fileitemid` int(11) NOT NULL default '0',
  `sortorder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `filedefinitionid` (`filedefinitionid`),
  KEY `fileitemid` (`fileitemid`),
  KEY `tablerecordid` (`tablerecordid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fileitemattachmentdefault`
--

LOCK TABLES `fileitemattachmentdefault` WRITE;
/*!40000 ALTER TABLE `fileitemattachmentdefault` DISABLE KEYS */;
/*!40000 ALTER TABLE `fileitemattachmentdefault` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flexfield`
--

DROP TABLE IF EXISTS `flexfield`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flexfield` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `tablename` varchar(100) NOT NULL,
  `displayname` text NOT NULL,
  `fieldtype` enum('T','S','C','D','H','R','A','I') NOT NULL default 'T',
  `sortorder` int(10) unsigned NOT NULL default '0',
  `internalname` varchar(100) NOT NULL,
  `defaultvalue` varchar(255) NOT NULL,
  `companyid` int(11) NOT NULL default '0',
  `readonly` int(5) NOT NULL default '0',
  `donotimport` int(5) NOT NULL default '0',
  `rowabove` int(11) NOT NULL default '0',
  `cellwidth` int(11) NOT NULL default '0',
  `titlelocation` varchar(10) NOT NULL default '',
  `tbsize` int(11) NOT NULL default '0',
  `linkfield` varchar(50) NOT NULL default '',
  `required` int(11) NOT NULL default '0',
  `pagelink` varchar(200) NOT NULL default '',
  `pagelinktitle` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `tablename` (`tablename`),
  KEY `internalname` (`internalname`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flexfield`
--

LOCK TABLES `flexfield` WRITE;
/*!40000 ALTER TABLE `flexfield` DISABLE KEYS */;
/*!40000 ALTER TABLE `flexfield` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flexoption`
--

DROP TABLE IF EXISTS `flexoption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flexoption` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `flexfieldid` int(10) unsigned NOT NULL default '0',
  `name` text,
  `value` varchar(255) NOT NULL,
  `sortorder` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `flexfieldid` (`flexfieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flexoption`
--

LOCK TABLES `flexoption` WRITE;
/*!40000 ALTER TABLE `flexoption` DISABLE KEYS */;
/*!40000 ALTER TABLE `flexoption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flextable`
--

DROP TABLE IF EXISTS `flextable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flextable` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL,
  `tablename` varchar(100) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flextable`
--

LOCK TABLES `flextable` WRITE;
/*!40000 ALTER TABLE `flextable` DISABLE KEYS */;
INSERT INTO `flextable` VALUES (1,'Customer','customer'),(2,'Item','item'),(3,'Order','arorder'),(4,'Invoice','arinvoice'),(5,'Vendor','vendor'),(6,'AP Bill','apbill'),(7,'Employee','premployee'),(8,'Shipment','arordership'),(9,'Ship-To','shipto'),(10,'Print-Pricelist-Order','estquotequote'),(11,'Inventory Locations','inventorylocation'),(12,'GL Account','glaccount'),(13,'Company','gencompany'),(14,'User','genuser'),(15,'Service Order Work Details','soworkdetails'),(16,'Service Order Extra Fields','soextra'),(17,'PO Checklist','checklistpo'),(18,'SB Checklist','checklistsb'),(19,'Year-End Checklist','checklistye'),(20,'Quarter-End Checklist','checklistqe'),(21,'Month-End Checklist','checklistme'),(22,'Building','building'),(23,'Unit','unit'),(24,'Move In Checklist','checklistmi'),(25,'Move Out Checklist','checklistmo'),(26,'Communications','communications'),(27,'Item Category','itemcategory'),(28,'Sales Tax','salestax'),(29,'Accounts Receivable Payment Detail','arinvoicepaymentdetail'),(30,'Job','job');
/*!40000 ALTER TABLE `flextable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flexvalue`
--

DROP TABLE IF EXISTS `flexvalue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flexvalue` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `flexfieldid` int(10) unsigned NOT NULL default '0',
  `recordid` int(10) unsigned NOT NULL default '0',
  `value` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `flexfieldid` (`flexfieldid`),
  KEY `recordid` (`recordid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flexvalue`
--

LOCK TABLES `flexvalue` WRITE;
/*!40000 ALTER TABLE `flexvalue` DISABLE KEYS */;
/*!40000 ALTER TABLE `flexvalue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `four51trans`
--

DROP TABLE IF EXISTS `four51trans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `four51trans` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `xmlrequest` text NOT NULL,
  `xmlresponse` text NOT NULL,
  `entrydate` datetime NOT NULL,
  `status` int(11) NOT NULL default '500',
  `orderid` int(11) NOT NULL default '0',
  `customerid` int(11) NOT NULL default '0',
  `transtype` enum('O','S') NOT NULL default 'O',
  `responsetext` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `orderid` (`orderid`),
  KEY `customerid` (`customerid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `four51trans`
--

LOCK TABLES `four51trans` WRITE;
/*!40000 ALTER TABLE `four51trans` DISABLE KEYS */;
/*!40000 ALTER TABLE `four51trans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `freightburden`
--

DROP TABLE IF EXISTS `freightburden`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freightburden` (
  `id` int(11) NOT NULL auto_increment,
  `inventorylocationid1` int(11) NOT NULL default '0',
  `inventorylocationid2` int(11) NOT NULL default '0',
  `percent` decimal(19,4) NOT NULL default '0.0000',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime NOT NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL,
  `entryuserid` int(11) NOT NULL default '0',
  `lastupdatedate` datetime NOT NULL,
  `lastupdateuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `inventorylocationid1` (`inventorylocationid1`,`cancel`),
  KEY `inventorylocationid2` (`inventorylocationid2`,`cancel`),
  KEY `active` (`cancel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `freightburden`
--

LOCK TABLES `freightburden` WRITE;
/*!40000 ALTER TABLE `freightburden` DISABLE KEYS */;
/*!40000 ALTER TABLE `freightburden` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gencompany`
--

DROP TABLE IF EXISTS `gencompany`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gencompany` (
  `id` int(11) NOT NULL auto_increment,
  `address1` varchar(100) default NULL,
  `address2` varchar(100) default NULL,
  `city` varchar(50) default NULL,
  `state` varchar(20) default NULL,
  `zip` varchar(15) default NULL,
  `country` varchar(20) default NULL,
  `phone1` varchar(20) default NULL,
  `phone2` varchar(20) default NULL,
  `phone3` varchar(20) default NULL,
  `phone4` varchar(20) default NULL,
  `email` varchar(50) default NULL,
  `ar_email` varchar(50) NOT NULL default '',
  `order_email` varchar(50) NOT NULL default '',
  `ap_email` varchar(50) NOT NULL default '',
  `web` varchar(100) default NULL,
  `name` varchar(50) default NULL,
  `dba` varchar(50) NOT NULL default '',
  `active` int(11) default '1',
  `menucolor` int(11) NOT NULL default '0',
  `graphicurl` varchar(200) default '',
  `graphicurl_big` varchar(200) default '',
  `lastupdateuserid` int(11) NOT NULL default '0',
  `lastupdatedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `vat_tax` int(5) default '0',
  `businesstype` varchar(100) NOT NULL default '',
  `print_only_orders` int(5) NOT NULL default '0',
  `arship_shortform` int(5) NOT NULL default '0',
  `timezoneid` int(11) NOT NULL default '0',
  `currency` varchar(10) NOT NULL default 'USD',
  `isconstruction` int(5) NOT NULL default '0',
  `companycode` varchar(50) NOT NULL default '',
  `clientllc` int(5) NOT NULL default '0',
  `defaultbarcodelabelid` int(11) NOT NULL default '0',
  `defaultorderbarcodelabelid` int(11) NOT NULL default '0',
  `ui_style` mediumtext,
  `pdf_font` varchar(45) NOT NULL default '',
  `faxsettings` mediumtext,
  `importnotices` mediumtext,
  `autopostglimports` tinyint(1) NOT NULL default '0',
  `glgroupdebitcreditcolumn` tinyint(1) NOT NULL default '1',
  `gledithidecostcodes` tinyint(1) NOT NULL default '0',
  `showautocompleteidboxes` int(11) NOT NULL default '0',
  `showsetupmenu` int(11) NOT NULL default '1',
  `setupfirstrun` int(11) NOT NULL default '1',
  `weather_zip` varchar(20) NOT NULL default '',
  `weather_cf` char(1) NOT NULL default 'F',
  `hideweather` int(5) NOT NULL default '0',
  `css_style_index` tinyint(4) NOT NULL default '-1',
  `glrequirecostcode` tinyint(4) NOT NULL default '0',
  `glrequireglcategory` tinyint(4) NOT NULL default '0',
  `alloweditingnotedates` tinyint(4) NOT NULL default '0',
  `usegljourupdhv` tinyint(4) NOT NULL default '0',
  `qrfontsize` decimal(8,3) NOT NULL default '9.000',
  `qrprintoneperline` tinyint(1) NOT NULL default '0',
  `qrprintpaperwidth` decimal(8,3) NOT NULL default '612.000',
  `qrprintpaperheight` decimal(8,3) NOT NULL default '792.000',
  `qrprintmargintop` decimal(8,3) NOT NULL default '72.000',
  `qrprintmarginbottom` decimal(8,3) NOT NULL default '72.000',
  `qrprintmarginleft` decimal(8,3) NOT NULL default '72.000',
  `qrprintmarginright` decimal(8,3) NOT NULL default '72.000',
  `qrprintpaddingtop` decimal(8,3) NOT NULL default '0.000',
  `qrprintpaddingbottom` decimal(8,3) NOT NULL default '0.000',
  `qrprintpaddingleft` decimal(8,3) NOT NULL default '0.000',
  `qrprintpaddingright` decimal(8,3) NOT NULL default '0.000',
  `blockeditingcodes` tinyint(4) NOT NULL default '0',
  `timereportcostaccess` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gencompany`
--

LOCK TABLES `gencompany` WRITE;
/*!40000 ALTER TABLE `gencompany` DISABLE KEYS */;
/*!40000 ALTER TABLE `gencompany` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gencounty`
--

DROP TABLE IF EXISTS `gencounty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gencounty` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(45) NOT NULL default '',
  `state` varchar(5) NOT NULL default '',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryuserid` varchar(45) NOT NULL default '0',
  `lastchangedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastchangeuserid` varchar(45) NOT NULL default '0',
  `cancel` tinyint(1) NOT NULL default '0',
  `canceldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `canceluserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='User-defined county list by state.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gencounty`
--

LOCK TABLES `gencounty` WRITE;
/*!40000 ALTER TABLE `gencounty` DISABLE KEYS */;
/*!40000 ALTER TABLE `gencounty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genmessage`
--

DROP TABLE IF EXISTS `genmessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genmessage` (
  `id` int(11) NOT NULL auto_increment,
  `userid` int(11) NOT NULL default '0',
  `sourceuserid` int(11) NOT NULL default '0',
  `entrydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `readdate` datetime NOT NULL default '0001-01-01 00:00:00',
  `message` blob NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genmessage`
--

LOCK TABLES `genmessage` WRITE;
/*!40000 ALTER TABLE `genmessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `genmessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genprint`
--

DROP TABLE IF EXISTS `genprint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genprint` (
  `id` int(11) NOT NULL default '0',
  `special_order_markup` decimal(6,3) NOT NULL default '0.000',
  `outside_vended_markup` decimal(6,3) NOT NULL default '0.000',
  `qty_unitid` int(11) NOT NULL default '0',
  `price_unitid` int(11) NOT NULL default '0',
  `conversion` int(11) NOT NULL default '1',
  `overdays` int(5) NOT NULL default '30',
  `first_timeframe` int(11) NOT NULL default '24',
  `second_timeframe` int(11) NOT NULL default '80',
  `glrush` int(11) NOT NULL default '0',
  `glcomposition` int(11) NOT NULL default '0',
  `extrafield1_desc` varchar(255) default NULL,
  `extrafield2_desc` varchar(255) default NULL,
  `extrafield3_desc` varchar(255) default NULL,
  `extrafield4_desc` varchar(255) default NULL,
  `jobticket_notes` text,
  `askink` int(5) NOT NULL default '1',
  `whichinvoicedate` int(5) NOT NULL default '0',
  `inventory_markup` decimal(9,3) NOT NULL default '0.000',
  `showdollars_onpendinglist` int(5) NOT NULL default '0',
  `fromWho` int(5) NOT NULL default '0',
  `boxlabel` int(5) NOT NULL default '0',
  `displayweightmax` int(11) NOT NULL default '0',
  `displayweightmsg` text,
  `jobtick1` varchar(100) NOT NULL default '',
  `jobtick2` varchar(100) NOT NULL default '',
  `jobtick3` varchar(100) NOT NULL default '',
  `jobtick4` varchar(100) NOT NULL default '',
  `envitemid` int(11) NOT NULL default '0',
  `envfactor` decimal(19,4) NOT NULL default '0.0000',
  `covitemid` int(11) NOT NULL default '0',
  `covfactor` decimal(19,4) NOT NULL default '0.0000',
  `extra1_confirm` varchar(100) default NULL,
  `extra2_confirm` varchar(100) default NULL,
  `extra3_confirm` varchar(100) default NULL,
  `extra4_confirm` varchar(100) default NULL,
  `extra5_confirm` varchar(100) default NULL,
  `quoteDateChg` int(5) NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genprint`
--

LOCK TABLES `genprint` WRITE;
/*!40000 ALTER TABLE `genprint` DISABLE KEYS */;
/*!40000 ALTER TABLE `genprint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genstate`
--

DROP TABLE IF EXISTS `genstate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genstate` (
  `id` int(11) NOT NULL auto_increment,
  `stateinit` char(3) NOT NULL default '',
  `statename` char(30) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `stateinit` (`stateinit`),
  KEY `stateinit_2` (`stateinit`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genstate`
--

LOCK TABLES `genstate` WRITE;
/*!40000 ALTER TABLE `genstate` DISABLE KEYS */;
INSERT INTO `genstate` VALUES (1,'AL','Alabama'),(2,'AK','Alaska'),(3,'AZ','Arizona'),(4,'AR','Arkansas'),(5,'CA','California'),(6,'CO','Colorado'),(7,'CT','Connecticut'),(8,'DE','Delaware'),(9,'FL','Florida'),(10,'GA','Georgia'),(11,'HI','Hawaii'),(12,'ID','Idaho'),(13,'IL','Illinois'),(14,'IN','Indiana'),(15,'IA','Iowa'),(16,'KS','Kansas'),(17,'ME','Maine'),(18,'MD','Maryland'),(19,'MA','Massachusetts'),(20,'MI','Michigan'),(21,'MN','Minnesota'),(22,'MS','Mississippi'),(23,'MO','Missouri'),(24,'MT','Montana'),(25,'NE','Nebraska'),(26,'NV','Nevada'),(27,'NH','New Hampshire'),(28,'NJ','New Jersey'),(29,'NM','New Mexico'),(30,'NY','New York'),(31,'NC','North Carolina'),(32,'ND','North Dakota'),(33,'OH','Ohio'),(34,'OK','Oklahoma'),(35,'OR','Oregon'),(36,'PA','Pennsylvania'),(37,'RI','Rhode Island'),(38,'SC','South Carolina'),(39,'SD','South Dakota'),(40,'TN','Tennessee'),(41,'TX','Texas'),(42,'UT','Utah'),(43,'VT','Vermont'),(44,'VA','Virginia'),(45,'WA','Washington'),(46,'DC','Washington, DC'),(47,'WV','West Virginia'),(48,'WI','Wisconsin'),(49,'WY','Wyoming'),(50,'KY','Kentucky'),(51,'LA','Louisiana'),(52,'PR','Puerto Rico'),(53,'NF','Newfoundland'),(54,'NS','Nova Scotia'),(55,'ON','Ontario'),(56,'PE','Prince Edward Island'),(57,'PQ','Quebec'),(58,'SK','Saskatchewan'),(59,'NT','Northwest Territories'),(60,'YT','Yukon Terrirory'),(61,'BC','British Columbia'),(62,'NB','New Brunswick'),(63,'MB','Manitoba'),(64,'AB','Alberta'),(65,'NU','Nunavut');
/*!40000 ALTER TABLE `genstate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genstylesheet`
--

DROP TABLE IF EXISTS `genstylesheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genstylesheet` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(50) NOT NULL default '',
  `filename` char(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `filename` (`filename`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genstylesheet`
--

LOCK TABLES `genstylesheet` WRITE;
/*!40000 ALTER TABLE `genstylesheet` DISABLE KEYS */;
INSERT INTO `genstylesheet` VALUES (1,'Blue Heaven','blueheaven'),(2,'Blue and White','bluish'),(3,'Earth Tones','earthtones'),(4,'Black and White','bw'),(5,'Cool Gray','coolgray'),(6,'Unix Terminal','unixterm'),(7,'Hot Tomato','tomato');
/*!40000 ALTER TABLE `genstylesheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genuser`
--

DROP TABLE IF EXISTS `genuser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genuser` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `password` varchar(128) default NULL,
  `raccessap` int(11) NOT NULL default '0',
  `raccessar` int(11) NOT NULL default '0',
  `raccessgl` int(11) NOT NULL default '0',
  `raccesspay` int(11) NOT NULL default '0',
  `raccessinv` int(11) NOT NULL default '0',
  `raccessest` int(11) NOT NULL default '0',
  `raccessfix` int(11) NOT NULL default '0',
  `raccessimp` int(11) NOT NULL default '0',
  `waccessap` int(11) NOT NULL default '0',
  `waccessar` int(11) NOT NULL default '0',
  `waccessgl` int(11) NOT NULL default '0',
  `waccesspay` int(11) NOT NULL default '0',
  `waccessinv` int(11) NOT NULL default '0',
  `waccessest` int(11) NOT NULL default '0',
  `waccessfix` int(11) NOT NULL default '0',
  `waccessimp` int(11) NOT NULL default '0',
  `saccessap` int(11) NOT NULL default '0',
  `saccessar` int(11) NOT NULL default '0',
  `saccessgl` int(11) NOT NULL default '0',
  `saccesspay` int(11) NOT NULL default '0',
  `saccessinv` int(11) NOT NULL default '0',
  `saccessest` int(11) NOT NULL default '0',
  `saccessfix` int(11) NOT NULL default '0',
  `saccessimp` int(11) NOT NULL default '0',
  `supervisor` int(11) NOT NULL default '0',
  `active` int(11) NOT NULL default '0',
  `stylesheetid` int(11) NOT NULL default '1',
  `deflanguage` int(11) NOT NULL default '1',
  `email` varchar(100) NOT NULL default '',
  `logon_attempts` tinyint(4) NOT NULL default '0',
  `firstname` varchar(35) default NULL,
  `lastname` varchar(35) default NULL,
  `cancel` int(11) default '0',
  `admin` int(2) NOT NULL default '0',
  `raccesssc` int(11) NOT NULL default '0',
  `waccesssc` int(11) NOT NULL default '0',
  `saccesssc` int(11) NOT NULL default '0',
  `pmaccess` int(11) NOT NULL default '0',
  `pmadmin` int(11) NOT NULL default '0',
  `employeeid` int(11) NOT NULL default '0',
  `weather_zip` varchar(20) default NULL,
  `cpa` int(11) NOT NULL default '0',
  `weather_cf` char(1) default 'F',
  `menu_style` int(5) NOT NULL default '0',
  `iconset` varchar(10) NOT NULL default 'deflt',
  `apikey` varchar(50) default NULL,
  `timeclock_only` int(5) NOT NULL default '0',
  `ipfilter` varchar(255) NOT NULL default '',
  `splashdate` datetime default NULL,
  `defaulthomepage` varchar(30) NOT NULL default '',
  `timeclock_blockviewlogins` int(5) NOT NULL default '0',
  `phone` varchar(25) NOT NULL default '',
  `emailsignature` text,
  `sysadmin` int(11) NOT NULL default '0',
  `css_style_index` tinyint(4) NOT NULL default '-1',
  `autocompletedelay` int(11) NOT NULL default '400',
  `blockinvcotransfer` int(11) NOT NULL default '0',
  `blockapbilledit` tinyint(4) NOT NULL default '0',
  `ui_style` mediumtext,
  `np5_legacy_mode` tinyint(1) NOT NULL default '0',
  `slow_cpu` tinyint(1) NOT NULL default '0',
  `mobile_pos` tinyint(4) default '0',
  `mobile_pos_companyid` int(11) default '1',
  `mobile_pos_locationid` int(11) default '-1',
  `blockinvcsvcostedit` tinyint(4) NOT NULL default '0',
  `user_settings` mediumtext,
  `default_gencompanyid` int(11) NOT NULL default '0',
  `canchangejobitemuser` tinyint(4) NOT NULL default '0',
  `blockjoblaborrates` tinyint(4) NOT NULL default '0',
  `allowemaillogin` tinyint(4) NOT NULL default '0',
  `datatablesnoautoload` tinyint(1) NOT NULL default '0',
  `sendoverpaymentnotices` tinyint(1) NOT NULL default '0',
  `bankdeposituserentriesonly` tinyint(1) NOT NULL default '0',
  `passwordsetdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `datatablesuserfilter` tinyint(1) NOT NULL default '0',
  `isbuyer` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `name_2` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genuser`
--

LOCK TABLES `genuser` WRITE;
/*!40000 ALTER TABLE `genuser` DISABLE KEYS */;
INSERT INTO `genuser` VALUES (1,'admin','pass',1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,'',1,'Admin','',0,1,0,1,1,0,0,0,NULL,1,'F',1,'3d',NULL,0,'','2017-07-26 13:59:05','',0,'','',0,-1,400,0,0,NULL,0,0,0,1,-1,0,NULL,0,0,0,1,0,0,0,'0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `genuser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genusercheckacct`
--

DROP TABLE IF EXISTS `genusercheckacct`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genusercheckacct` (
  `id` int(11) NOT NULL auto_increment,
  `userid` int(11) NOT NULL default '0',
  `checkacctid` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`),
  KEY `checkacctid` (`checkacctid`),
  KEY `gencompanyid` (`gencompanyid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genusercheckacct`
--

LOCK TABLES `genusercheckacct` WRITE;
/*!40000 ALTER TABLE `genusercheckacct` DISABLE KEYS */;
/*!40000 ALTER TABLE `genusercheckacct` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genusercompany`
--

DROP TABLE IF EXISTS `genusercompany`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genusercompany` (
  `genuser_id` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `lasthome` varchar(20) NOT NULL default '',
  `raccessap` int(2) NOT NULL default '0',
  `raccessar` int(2) NOT NULL default '0',
  `raccessgl` int(2) NOT NULL default '0',
  `raccesspay` int(2) NOT NULL default '0',
  `raccessinv` int(2) NOT NULL default '0',
  `raccessest` int(2) NOT NULL default '0',
  `raccessfix` int(2) NOT NULL default '0',
  `raccessimp` int(2) NOT NULL default '0',
  `raccesssc` int(2) NOT NULL default '0',
  `waccessap` int(2) NOT NULL default '0',
  `waccessar` int(2) NOT NULL default '0',
  `waccessgl` int(2) NOT NULL default '0',
  `waccesspay` int(2) NOT NULL default '0',
  `waccessinv` int(2) NOT NULL default '0',
  `waccessest` int(2) NOT NULL default '0',
  `waccessfix` int(2) NOT NULL default '0',
  `waccessimp` int(2) NOT NULL default '0',
  `waccesssc` int(2) NOT NULL default '0',
  `saccessap` int(2) NOT NULL default '0',
  `saccessar` int(2) NOT NULL default '0',
  `saccessgl` int(2) NOT NULL default '0',
  `saccesspay` int(2) NOT NULL default '0',
  `saccessinv` int(2) NOT NULL default '0',
  `saccessest` int(2) NOT NULL default '0',
  `saccessfix` int(2) NOT NULL default '0',
  `saccessimp` int(2) NOT NULL default '0',
  `saccesssc` int(2) NOT NULL default '0',
  `supervisor` int(2) NOT NULL default '0',
  `edit_messages` int(5) NOT NULL default '0',
  `pos_only` int(11) NOT NULL default '0',
  `salesmanid` int(11) NOT NULL default '0',
  `blockarreports` int(11) NOT NULL default '0',
  `nprightsgroupid` int(11) NOT NULL default '0',
  `postaxgroupid` int(11) NOT NULL default '0',
  `invlocations` varchar(255) NOT NULL default '',
  `blockordersave` int(5) NOT NULL default '0',
  `blockpospricing` int(11) NOT NULL default '0',
  `onlycustomeredittab` int(11) NOT NULL default '0',
  `blockifnostock` int(11) NOT NULL default '0',
  `blockbackdating` int(11) NOT NULL default '0',
  `blockcustomercreditedit` int(11) NOT NULL default '0',
  `blockminpm` int(11) NOT NULL default '0',
  `blockposdescription` tinyint(4) NOT NULL default '0',
  `blockposcost` tinyint(4) NOT NULL default '0',
  `blockcostonreports` tinyint(4) NOT NULL default '0',
  `blockcost` tinyint(4) NOT NULL default '0',
  `blockaddllineitemoptions` tinyint(1) NOT NULL default '0',
  `blockcustomeredit` tinyint(1) NOT NULL default '0',
  `usecompanywriteoffvalues` tinyint(1) NOT NULL default '1',
  `writeoffmax` decimal(19,4) NOT NULL default '0.0000',
  `writeoffmaxperc` decimal(19,4) NOT NULL default '0.0000',
  `hideorderprofitexpectnonstock` tinyint(1) NOT NULL default '0',
  `paymeths` varchar(20) NOT NULL default '',
  `onlyproposals` tinyint(1) NOT NULL default '0',
  `apbill_approver` tinyint(1) NOT NULL default '0',
  `blockinvoiceheaderedit` tinyint(1) NOT NULL default '0',
  `canoverrideprice` tinyint(1) NOT NULL default '0',
  `canviewvendorbankinfo` tinyint(4) NOT NULL default '0',
  `fohidecustomeroverdue` tinyint(1) NOT NULL default '0',
  `fohideglinfo` tinyint(1) NOT NULL default '0',
  `paymentsdailyclosemanagement` tinyint(1) NOT NULL default '0',
  `canviewcustomerbankinfo` tinyint(4) NOT NULL default '0',
  `blockstockitempo` tinyint(4) NOT NULL default '0',
  `blockitembinedit` tinyint(1) NOT NULL default '0',
  `emaildailysalesreport` tinyint(1) NOT NULL default '0',
  `emaildailysalesreportmaxmargin` decimal(19,4) NOT NULL default '100.0000',
  `emailownposonrec` tinyint(1) NOT NULL default '0',
  `blockstockitemcreate` tinyint(4) NOT NULL default '0',
  `blockotherchargespo` tinyint(4) NOT NULL default '0',
  `blockstockedit` tinyint(1) NOT NULL default '0',
  `blocknonstockedit` tinyint(1) NOT NULL default '0',
  `blockotherchargesedit` tinyint(1) NOT NULL default '0',
  `canalwaysunpostinvoices` tinyint(4) NOT NULL default '0',
  `canviewjobprelimablesettings` tinyint(4) NOT NULL default '0',
  `canalwayschangepovendorterms` tinyint(4) NOT NULL default '0',
  `blockissuecredit` tinyint(4) NOT NULL default '0',
  `invstatusdetailpricelevels` tinyint(1) NOT NULL default '0',
  `maxpoamount` decimal(19,4) NOT NULL default '0.0000',
  `allowbuyernotesedit` tinyint(1) NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genusercompany`
--

LOCK TABLES `genusercompany` WRITE;
/*!40000 ALTER TABLE `genusercompany` DISABLE KEYS */;
INSERT INTO `genusercompany` VALUES (1,1,'',1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,'',0,0,0,0,0,0,0,0,0,0,0,0,0,1,'0.0000','0.0000',0,'',0,0,0,0,0,0,0,0,0,0,0,0,'100.0000',0,0,0,0,0,0,0,0,0,0,0,'0.0000',0);
/*!40000 ALTER TABLE `genusercompany` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genusercompany_temp`
--

DROP TABLE IF EXISTS `genusercompany_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genusercompany_temp` (
  `genuser_id` int(11) NOT NULL default '0',
  `gencompanyid` int(11) NOT NULL default '0',
  `raccessap` int(2) NOT NULL default '0',
  `raccessar` int(2) NOT NULL default '0',
  `raccessgl` int(2) NOT NULL default '0',
  `raccesspay` int(2) NOT NULL default '0',
  `raccessinv` int(2) NOT NULL default '0',
  `raccessest` int(2) NOT NULL default '0',
  `raccessfix` int(2) NOT NULL default '0',
  `raccessimp` int(2) NOT NULL default '0',
  `raccesssc` int(2) NOT NULL default '0',
  `waccessap` int(2) NOT NULL default '0',
  `waccessar` int(2) NOT NULL default '0',
  `waccessgl` int(2) NOT NULL default '0',
  `waccesspay` int(2) NOT NULL default '0',
  `waccessinv` int(2) NOT NULL default '0',
  `waccessest` int(2) NOT NULL default '0',
  `waccessfix` int(2) NOT NULL default '0',
  `waccessimp` int(2) NOT NULL default '0',
  `waccesssc` int(2) NOT NULL default '0',
  `saccessap` int(2) NOT NULL default '0',
  `saccessar` int(2) NOT NULL default '0',
  `saccessgl` int(2) NOT NULL default '0',
  `saccesspay` int(2) NOT NULL default '0',
  `saccessinv` int(2) NOT NULL default '0',
  `saccessest` int(2) NOT NULL default '0',
  `saccessfix` int(2) NOT NULL default '0',
  `saccessimp` int(2) NOT NULL default '0',
  `saccesssc` int(2) NOT NULL default '0',
  `supervisor` int(2) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genusercompany_temp`
--

LOCK TABLES `genusercompany_temp` WRITE;
/*!40000 ALTER TABLE `genusercompany_temp` DISABLE KEYS */;
INSERT INTO `genusercompany_temp` VALUES (1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,1,1),(2,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,1,1);
/*!40000 ALTER TABLE `genusercompany_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `genuserhome`
--

DROP TABLE IF EXISTS `genuserhome`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `genuserhome` (
  `genuser` int(11) NOT NULL default '0',
  `gencompany` int(11) NOT NULL default '0',
  `home` varchar(20) NOT NULL default '',
  `reports` text,
  `twothirds` varchar(100) NOT NULL default '',
  `half1` varchar(100) NOT NULL default '',
  `half2` varchar(100) NOT NULL default '',
  `whole` varchar(100) NOT NULL default '',
  `lastlogin` datetime NOT NULL default '0000-00-00 00:00:00',
  `whole2` varchar(100) default NULL,
  KEY `key` (`genuser`,`gencompany`,`home`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `genuserhome`
--

LOCK TABLES `genuserhome` WRITE;
/*!40000 ALTER TABLE `genuserhome` DISABLE KEYS */;
INSERT INTO `genuserhome` VALUES (1,0,'orders',NULL,'open_orders_due_dates','recently_shipped_items','recently_shipped_orders','performance_statistics_30','2019-08-14 19:09:37',NULL),(1,0,'orders',NULL,'open_orders_due_dates','recently_shipped_items','recently_shipped_orders','performance_statistics_30','2019-08-14 19:09:37',NULL);
/*!40000 ALTER TABLE `genuserhome` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gl_costcenter`
--

DROP TABLE IF EXISTS `gl_costcenter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gl_costcenter` (
  `id` int(11) NOT NULL auto_increment,
  `description` varchar(255) default NULL,
  `companyid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `entrydate` date default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gl_costcenter`
--

LOCK TABLES `gl_costcenter` WRITE;
/*!40000 ALTER TABLE `gl_costcenter` DISABLE KEYS */;
/*!40000 ALTER TABLE `gl_costcenter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gl_summarylevel`
--

DROP TABLE IF EXISTS `gl_summarylevel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gl_summarylevel` (
  `id` int(11) NOT NULL auto_increment,
  `description` varchar(255) default NULL,
  `companyid` int(11) NOT NULL default '0',
  `cancel` int(5) NOT NULL default '0',
  `canceluserid` int(11) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `entrydate` date default NULL,
  `entryuserid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gl_summarylevel`
--

LOCK TABLES `gl_summarylevel` WRITE;
/*!40000 ALTER TABLE `gl_summarylevel` DISABLE KEYS */;
/*!40000 ALTER TABLE `gl_summarylevel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gl_summarylevel_account`
--

DROP TABLE IF EXISTS `gl_summarylevel_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gl_summarylevel_account` (
  `glaccountid` int(11) NOT NULL default '0',
  `gl_summarylevelid` int(11) NOT NULL default '0',
  `destination_glaccountid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`glaccountid`,`gl_summarylevelid`),
  KEY `glaccountid` (`glaccountid`),
  KEY `gl_summarylevelid` (`gl_summarylevelid`),
  KEY `destination_glaccountid` (`destination_glaccountid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gl_summarylevel_account`
--

LOCK TABLES `gl_summarylevel_account` WRITE;
/*!40000 ALTER TABLE `gl_summarylevel_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `gl_summarylevel_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glaccount`
--

DROP TABLE IF EXISTS `glaccount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `glaccount` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL default '',
  `description` varchar(255) default NULL,
  `accounttypeid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `summaryaccountid` int(11) NOT NULL default '0',
  `lastchangedate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `lastchangeuserid` int(11) default NULL,
  `cancel` int(2) NOT NULL default '0',
  `canceldate` datetime default NULL,
  `canceluserid` int(11) NOT NULL default '0',
  `costcenterid` int(11) NOT NULL default '0',
  `old_id` varchar(20) default NULL,
  `accountsubtypeid` varchar(10) NOT NULL default '',
  `block_journal` int(5) NOT NULL default '0',
  `defaultcostcodeid` int(11) NOT NULL default '0',
  `defaultglcategoryid` int(11) NOT NULL default '0',
  `hascostcodes` tinyint(1) NOT NULL default '1',
  `hasglcategories` tinyint(1) NOT NULL default '1',
  `allowedcostcodes` text,
  `allowedglcategories` text,
  PRIMARY KEY  (`id`),
  KEY `name` (`name`),
  KEY `accounttypeid` (`accounttypeid`),
  KEY `companyid` (`companyid`),
  KEY `summaryaccountid` (`summaryaccountid`),
  KEY `costcenterid` (`costcenterid`),
  KEY `block_journal` (`block_journal`),
  KEY `hascostcodes` (`hascostcodes`),
  KEY `hasglcategories` (`hasglcategories`),
  KEY `cancel` (`cancel`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `glaccount`
--

LOCK TABLES `glaccount` WRITE;
/*!40000 ALTER TABLE `glaccount` DISABLE KEYS */;
/*!40000 ALTER TABLE `glaccount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `glbudgets`
--

DROP TABLE IF EXISTS `glbudgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `glbudgets` (
  `id` int(11) NOT NULL auto_increment,
  `glaccountid` int(11) NOT NULL default '0',
  `costcodeid` int(11) NOT NULL default '0',
  `glcategoryid` int(11) NOT NULL default '0',
  `companyid` int(11) NOT NULL default '0',
  `budgetyear` int(11) NOT NULL default '0',
  `jan` decimal(19,4) NOT NULL default '0.0000',
  `feb` decimal(19,4) NOT NULL default '0.0000',
  `mar` decimal(19,4) NOT NULL default '0.0000',
  `apr` decimal(19,4) NOT NULL default '0.0000',
  `may` decimal(19,4) NOT NULL default '0.0000',
  `jun` decimal(19,4) NOT NULL default '0.0000',
  `jul` decimal(19,4) NOT NUL