<?php
include_once(dirname(__FILE__)."/npapi.php");
//ini_set('display_errors', 'on'); error_reporting(E_ALL&~E_NOTICE);
ini_set('display_errors', 'off'); error_reporting(0);


function nolapro_get_company_defaults($name="arcompany") {
	$api = new npapi();
	// Set some useful defaults
	// Can be arcompany, apcompany, invcompany; tables where NolaPro default values are stored
	$api->action = "$name/search/id/$api->companyid";
	$api->call_api();
	if ($api->ok) {
		$defaultset = $api->rsp->$name;
		return $defaultset;
	} else {
		return 0;	
	}
}

// Save the OSCom order in NolaPro
function nolapro_save_order($order, $cart, $orderid, $customerid, $order_totals, $payment) {
	$api = new npapi();
	// Check the customer info
	// Set the state code
	if (isset($order->customer['country']['id']) && isset($order->customer['zone_id']) && tep_not_null($order->customer['zone_id'])) {
		$order->customer['state'] = tep_get_zone_code($order->customer['country']['id'], $order->customer['zone_id'], $order->customer['state']);
	}
	$np_customerid = nolapro_check_customer($customerid);
	$np_customerid = nolapro_save_customer($order->customer, $customerid, $np_customerid);
	$order->delivery['telephone'] = $order->customer['telephone'];
	$order->delivery['email_address'] = $order->customer['email_address'];
	if (isset($order->delivery['country']['id']) && isset($order->delivery['zone_id']) && tep_not_null($order->delivery['zone_id'])) {
		$order->delivery['state'] = tep_get_zone_code($order->delivery['country']['id'], $order->delivery['zone_id'], $order->delivery['state']);
	}
	$shiptoid = nolapro_save_shipto($order->delivery, $np_customerid, $order->customer);
	// Save the order
	if ($np_customerid && $shiptoid) {
		$osccompany = nolapro_get_company_defaults('osccompany');
		$pricelevelid = (string) $osccompany->default_pricelevelid;
		$inventorylocationid = (string) $osccompany->locationid;
		$default_costid = (string) $osccompany->cost;
		$default_salesglacctid = (string) $osccompany->sales;
		
		$default_sellunitid = (string) $osccompany->default_sellunitid;
		$default_priceunitid = (string) $osccompany->default_priceunitid;
		$default_checking = (string) $osccompany->checking;
		$default_deposit = (string) $osccompany->depositglacctid;
		$default_checkacctid = (string) $osccompany->default_checkacctid;
		$default_salescategory = (string) $osccompany->default_salescategory_fulfillment;
		
		$invcompany = nolapro_get_company_defaults('invcompany');
		if (!$pricelevelid) {
			$pricelevelid = (string) $invcompany->default_pricelevelid;
		}
		if (!$inventorylocationid) {
			$inventorylocationid = (string) $invcompany->locationid;
		}
		if (!$default_costid) {
			$default_costid = (string) $invcompany->cost;
		}
		$useitemsalesacct = (string) $invcompany->custoritemglacct;
		
		$gencompany = nolapro_get_company_defaults('gencompany');
		$currency = (string) $gencompany->currency;
		
		$arcompany = nolapro_get_company_defaults('arcompany');
		if (!$default_sellunitid) {
			$default_sellunitid = (string) $arcompany->default_sellunitid;
		}
		if (!$default_priceunitid) {
			$default_priceunitid = (string) $arcompany->default_priceunitid;
		}
		if (!$default_checking) {
			$default_checking = (string) $arcompany->checking;
		}
		if (!$default_deposit) {
			$default_deposit = (string) $arcompany->depositglacctid;
		}
		if (!$default_checkacctid) {
			$default_checkacctid = (string) $arcompany->default_checkacctid;
		}
		$default_saleunitperpriceunit = 1;
		if (!$default_salescategory) {
			$default_salescategory = (string) $arcompany->default_salescategory_fulfillment;
		}
		
		if (!$default_salesglacctid) {
			$api->action = "customer/search/id/$np_customerid";
			$api->call_api();
			$default_salesglacctid = (string) $api->rsp->customer->salesglacctid;
		}

		if (!$default_salesglacctid) {
			$default_salesglacctid = (string) $invcompany->sales;	
		}
		$api->set_table('arorder');
		$weight = 0;
		if (isset($cart->weight)) {
			$weight = $cart->weight;
		}
		// Get the total charged
		$total = 0;
		$handlingfee = 0;
		$handlingfee_name = "";
		foreach ($order_totals as $ordtot) {
			if ($ordtot['code'] == 'ot_total') {
				$total = $ordtot['value'];	
			}
			// Get handling fee
			if ($ordtot['code'] == 'ot_handlingfee') {
				$handlingfee = $ordtot['value'];
				$handlingfee_name = $ordtot['title'];	
			}
		}
		if (!isset($order->info['comments'])) {
			$order->info['comments'] = '';	
		}
		$total = number_format($total, 2, ".", "");  //Format to 2 places
		$order->info['comments'] .= "\n".$order->info['shipping_method'].": ".$order->info['shipping_cost'];
		$order->info['comments'] .= "\n".$order->info['payment_method'].": ".$total;
		if (isset($order->info['cc_type']) && $order->info['cc_type']) {
				$order->info['comments'] .= "\n".$order->info['cc_type']."  ".$order->info['cc_number'];
				$order->info['comments'] .= "\n".$order->info['cc_owner'];
				$order->info['comments'] .= "\nExp:".$order->info['cc_expires'];
		}
		$data = array(	"orderbycompanyid" => $np_customerid,
						"shiptocompanyid" => $shiptoid,
						"wherefrom"=>"2",
						"pricelevelid"=>$pricelevelid,
						"inventorylocationid"=>$inventorylocationid,
						"duedate"=>date("Y-m-d"),
						"shipping_method"=>$order->info['shipping_method'],
						"shipping_cost"=>$order->info['shipping_cost'],
						"order_weight"=>$weight,
						"deposit" => $total,
						"sales_categoriesid" => $default_salescategory,
						"currency" => $currency);
		$api->set_data($data);

		$data = array();
		$tax_flexfieldid = nolapro_get_flexfield('oscomtaxid');
		$item_flexfieldid = nolapro_get_flexfield('oscomitemid');
		$tax_class_array = array();
		$product_id_array = array();
		$linenumber = 0;
		for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
			if ($order->products[$i]['model']) {
				$pname = $order->products[$i]['model']." ".$order->products[$i]['name'];
			} else {
				$pname = $order->products[$i]['name'];
			}
			$use_salesglacctid = $default_salesglacctid;
			$use_purchaseunitid = $default_sellunitid;
			$use_priceunitid = $default_priceunitid;
			$use_saleunitperpriceunit = $default_saleunitperpriceunit;
			$use_itemid = 0; 
			$cost = 0;
			$tax = 0;
			$nptax = array();
			$itemweight = 0;
			$product_id = (int)$order->products[$i]['id'];
			$product_id_array[] = $product_id;
			$product_query = tep_db_query("select products_id, products_price, products_tax_class_id, products_weight from " . TABLE_PRODUCTS . " where products_id = '" . $product_id . "'");
	        if ($product = tep_db_fetch_array($product_query)) {
	        	$itemweight = $product['products_weight'];
	        	if (isset($order->products[$i]['tax']) && $order->products[$i]['tax'] > 0) {
					$tax = $order->products[$i]['tax'];
		        	if (!isset($tax_class_array[$product['products_tax_class_id']])) {
			        	// Get tax ids for this item
						$tax_query = tep_db_query("select tax_rates_id, tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$order->delivery['country']['id'] . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$order->delivery['zone_id'] . "') and tr.tax_class_id = '" . (int)$product['products_tax_class_id'] . "' order by tr.tax_priority");
				    	if (tep_db_num_rows($tax_query)) {
							while ($tax = tep_db_fetch_array($tax_query)) {
							    $tax_class_array[$product['products_tax_class_id']][$tax['tax_rates_id']]['np_tax_id'] = "-1";
							    $tax_class_array[$product['products_tax_class_id']][$tax['tax_rates_id']]['tax_rate'] = $tax['tax_rate'];
							}
				    	}
		        	}
			        if (isset($tax_class_array[$product['products_tax_class_id']])) {
			        	$count = 0;
			        	foreach ($tax_class_array[$product['products_tax_class_id']] as $oscom_tax_id => $t) {
			        		if ($t['np_tax_id'] == "-1") {
			        			// Look up np tax id
			        			$cond = array("conditions" => "flexfieldid='$tax_flexfieldid' and value='$oscom_tax_id'");
								$taxapi = new npapi();
								$taxapi->set_data($cond);
								$taxapi->action = "flexvalue/search";
								$taxapi->call_api();
								if ($taxapi->ok) {
									$tax_class_array[$product['products_tax_class_id']][$oscom_tax_id]['np_tax_id'] = (string) $taxapi->rsp->flexvalue->recordid;
								} else {
									$tax_class_array[$product['products_tax_class_id']][$oscom_tax_id]['np_tax_id'] = "";	
								}
			        		}
			        		$count++;
			        		if ($count == 1) {
			        			$num = "";	
			        		} else {
			        			$num = $count;
			        		}
			        		$nptax['taxflag'.$num] = 1;
			        		$nptax['taxflag'.$num.'id'] = $tax_class_array[$product['products_tax_class_id']][$oscom_tax_id]['np_tax_id'];
			        	}
			        }
		        }
		        // Grab NolaPro item defaults if an item exists
		        $params = array("conditions" => "flexfieldid='$item_flexfieldid' and value='$product_id'");
		        $iapi = new npapi();
				$iapi->set_data($params);
				$iapi->action = "flexvalue/search";
				$iapi->call_api();
				$np_itemid = 0;
				if ($iapi->ok) {
					$np_itemid = (string) $iapi->rsp->flexvalue->recordid;
				}
				if ($np_itemid) {
					$use_itemid = $np_itemid;
					// Get item cost and other default values
					$iapi->action = "item/get_item_cost/$np_itemid/$inventorylocationid";
					$iapi->call_api();
					$cost = 0;
					if ($iapi->ok) {
						$cost = (string) $iapi->rsp->item->cost;	
					}
					// Get item info
					$iapi->action = "item/search/id/$np_itemid";
					$iapi->call_api();
					if ($iapi->ok) {
						if ($useitemsalesacct) {
							// Use the item sales account
							$use_salesglacctid = (string) $iapi->rsp->item->salesglacctid;
						}
						if ((string) $iapi->rsp->item->stockunitnameid) {
							$use_purchaseunitid = (string) $iapi->rsp->item->stockunitnameid;
						}
						if ((string) $iapi->rsp->item->priceunitnameid) {
							$use_priceunitid = (string) $iapi->rsp->item->priceunitnameid;
						}
						$priceunitsperstockunit = (string) $iapi->rsp->item->priceunitsperstockunit;
						$use_saleunitperpriceunit = $priceunitsperstockunit > 0 ? 1/$priceunitsperstockunit : 1;
						
					}
				}
			}
			$linenumber++;
			$data[] = array_merge(array('linenumber' => $linenumber, 
							'qtyorder' => $order->products[$i]['qty'], 
							'glaccountid' => $use_salesglacctid, 
							'costglaccountid' => $default_costid, 
							'itemid' => $use_itemid, 
							'description' => $pname, 
							'priceach' => $order->products[$i]['price'], 
							'costeach' => $cost,
							'purchaseunitid' => $use_purchaseunitid, 
							'priceunitid' => $use_priceunitid,
							'products_tax' => $order->products[$i]['tax'],
							'itemweight' => $itemweight,
							'saleunitperpriceunit' => $use_saleunitperpriceunit
							), $nptax);
			// Add any product options if some exist
			if (isset($order->products[$i]['attributes'])) {
			      $attributes_exist = '1';
			      global $languages_id;
			      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
			        if (DOWNLOAD_ENABLED == 'true') {
			          $attributes_query = "select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix, pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename 
			                               from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa 
			                               left join " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
			                                on pa.products_attributes_id=pad.products_attributes_id
			                               where pa.products_id = '" . $order->products[$i]['id'] . "' 
			                                and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' 
			                                and pa.options_id = popt.products_options_id 
			                                and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' 
			                                and pa.options_values_id = poval.products_options_values_id 
			                                and popt.language_id = '" . $languages_id . "' 
			                                and poval.language_id = '" . $languages_id . "'";
			          $attributes = tep_db_query($attributes_query);
			        } else {
			          $attributes = tep_db_query("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa where pa.products_id = '" . $order->products[$i]['id'] . "' and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . $languages_id . "' and poval.language_id = '" . $languages_id . "'");
			        }
			        $attributes_values = tep_db_fetch_array($attributes);
			
			        $linenumber++;
					$data[] = array_merge(array('linenumber' => $linenumber, 
									'qtyorder' => $order->products[$i]['qty'], 
									'glaccountid' => $use_salesglacctid, 
									'costglaccountid' => $default_costid, 
									'itemid' => 0, 
									'description' => $attributes_values['products_options_name']." ".$attributes_values['products_options_values_name'], 
									'priceach' => ($attributes_values['price_prefix'] != '+' ? -1 * $attributes_values['options_values_price'] : $attributes_values['options_values_price']), 
									'costeach' => 0,
									'purchaseunitid' => $use_purchaseunitid, 
									'priceunitid' => $use_priceunitid,
									'products_tax' => $order->products[$i]['tax'],
									'saleunitperpriceunit' => $use_saleunitperpriceunit
									), $nptax);
			      }
		    }
		}
		// Add handling fee as a line item if there is one
		if ($handlingfee > 0) {
			$use_salesglacctid = $default_salesglacctid;
			$use_purchaseunitid = $default_sellunitid;
			$use_priceunitid = $default_priceunitid;
			$use_saleunitperpriceunit = $default_saleunitperpriceunit;
			$linenumber++;
			$nptax = array();
			$totalrate = 0;
			if (MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS) {
				if (!isset($tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS])) {
		        	// Get tax ids for this item
					$tax_query = tep_db_query("select tax_rates_id, tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$order->delivery['country']['id'] . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$order->delivery['zone_id'] . "') and tr.tax_class_id = '" . MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS . "' order by tr.tax_priority");
			    	if (tep_db_num_rows($tax_query)) {
						while ($tax = tep_db_fetch_array($tax_query)) {
						    $tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS][$tax['tax_rates_id']]['np_tax_id'] = "-1";
						    $tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS][$tax['tax_rates_id']]['tax_rate'] = $tax['tax_rate'];
						    $totalrate += $tax['tax_rate'];
						}
			    	}
	        	}
	        	if (isset($tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS])) {
		        	$count = 0;
		        	foreach ($tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS] as $oscom_tax_id => $t) {
		        		if ($t['np_tax_id'] == "-1") {
		        			// Look up np tax id
		        			$cond = array("conditions" => "flexfieldid='$tax_flexfieldid' and value='$oscom_tax_id'");
							$taxapi = new npapi();
							$taxapi->set_data($cond);
							$taxapi->action = "flexvalue/search";
							$taxapi->call_api();
							if ($taxapi->ok) {
								$tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS][$oscom_tax_id]['np_tax_id'] = (string) $taxapi->rsp->flexvalue->recordid;
							} else {
								$tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS][$oscom_tax_id]['np_tax_id'] = "";	
							}
		        		}
		        		$count++;
		        		if ($count == 1) {
		        			$num = "";	
		        		} else {
		        			$num = $count;
		        		}
		        		$nptax['taxflag'.$num] = 1;
		        		$nptax['taxflag'.$num.'id'] = $tax_class_array[MODULE_ORDER_TOTAL_HANDLINGFEE_TAX_CLASS][$oscom_tax_id]['np_tax_id'];
		        	}
		        }
			}
			$data[] = array_merge(array('linenumber' => $linenumber, 
							'qtyorder' => 1, 
							'glaccountid' => $use_salesglacctid, 
							'costglaccountid' => $default_costid, 
							'itemid' => 0, 
							'description' => $handlingfee_name, 
							'priceach' => $handlingfee, 
							'costeach' => 0,
							'purchaseunitid' => $use_purchaseunitid, 
							'priceunitid' => $use_priceunitid,
							'products_tax' => $totalrate,
							'saleunitperpriceunit' => $use_saleunitperpriceunit
							), $nptax);
		}
		$api->set_table('arorderdetail');
		$api->set_data($data);
		if (count($tax_class_array) > 0) {	
			$api->set_table('arordertax');
			$data = array();
			foreach ($tax_class_array as $prod_tax_class) {
				foreach ($prod_tax_class as $oscom_tax_id => $t) {
					if ($t['np_tax_id'] > 0) {
						$data[] = array('taxrateid' => $t['np_tax_id'],
										'taxrate' => $t['tax_rate']
										);
					}
				}
			}
			if (count($data) > 0) {
				$api->set_data($data);
			}
		}
		$api->action = "arorder/save";
		$api->call_api();
		
		if ($api->ok) {
			$np_orderid = (string) $api->rsp->arorder['id'];	
			
			// Save a link to the oscom order
			$flexfieldid = nolapro_get_flexfield('oscomorderid');
			$api->set_table('flexvalue');
			$data = array(	"flexfieldid" => $flexfieldid,
							"recordid" => $np_orderid,
							"value" => $orderid);
			$api->set_data($data);
			$api->action = "flexvalue/save";
			$api->call_api();
			
			// Save any order notes
			if ($order->info['comments']) {
				$api->set_table('arordernotes');
				$data = array(	"orderid" => $np_orderid,
								"note" => $order->info['comments']);
				$api->set_data($data);
				$api->action = "arordernotes/save";
				$api->call_api();
			}
			
			if ($total > 0) {
				// Create a deposit record & voucher
				// Create voucher and gltransaction records
				$api->set_table('gltransvoucher');
				$data = array(	"voucher" => "OS$orderid"."NP$np_orderid",
								"description" => "OSCom Order $orderid NP Order $np_orderid",
								"wherefrom" => "2");
				$api->set_data($data);
				$api->set_table('gltransaction');
				$data = array(
							array('glaccountid' => $default_checking, 'amount' => $total, "currency" => $currency), 
							array('glaccountid' => $default_deposit, 'amount' => -1*$total, "currency" => $currency)
						);
				$api->set_data($data);
				$api->action = "gltransvoucher/save";
				$api->call_api();
				$voucherid = 0;
				if ($api->ok) {
					$voucherid = (string) $api->rsp->gltransvoucher['id'];
				}
				// Set NP payment method
				$payment_method = 5; // Default to credit card
				switch ($payment) {
					case 'moneyorder' :
						$payment_method = 2;  // Also for checks
					break;
					case 'paypal' :
						$payment_method = 6;
					break;
					case 'cod' :
						$payment_method = 4;  
					break;
				}
				$api->set_table('arorder_deposit');
				$data = array(	"orderid" => $np_orderid,
								"amount" => $total,
								"voucherid" => $voucherid,
								"checkacctid" => $default_checkacctid,
								"payment_method" => $payment_method,
								"currency" => $currency);
				$api->set_data($data);
				$api->action = "arorder_deposit/save";
				$api->call_api();
			}
		}
		
		if ($np_orderid ) {
			$msg = "";
			if (file_exists(dirname(__FILE__)."/extra.php")) {
				define('NP_EXTRA', 1);
				include_once(dirname(__FILE__)."/extra.php");	
			}
			if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
				$subject = "New NolaPro Order $np_orderid From OSCom Store";
				$msg .= "OSCom Order ID: $orderid\n";
				$msg .= "NolaPro Order ID: $np_orderid\n";
				$msg .= "Customer: ".$order->customer['firstname']." ".$order->customer['lastname']." ".($order->customer['company']?"- ".$order->customer['company']:"")."\n";
				$msg .= "OSCom Customer ID: $customerid\n";
				$msg .= "NolaPro Customer ID: $np_customerid\n\n";
				if ($serialmsg) {
					$msg .= $serialmsg;	
				}
				tep_mail('', SEND_EXTRA_ORDER_EMAILS_TO, $subject, $msg, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
			}
		}
	} else {
		return 0;	
	}
}

function nolapro_check_customer($customerid) {
	$api = new npapi();
	
	$np_customerid = 0;
	// Get the oscom customerid field in nolapro
	$flexfieldid = nolapro_get_flexfield('oscomcustomerid');
	if (!$flexfieldid) {
		return 0;	
	}
	// Find NolaPro id for this oscomcustomerid
	$data = array("conditions" => "flexfieldid='$flexfieldid' and value='$customerid'");
	$api->set_data($data);
	$api->action = "flexvalue/search";
	$api->call_api();
	if ($api->ok) {
		$np_customerid = (string) $api->rsp->flexvalue->recordid;
	} else {
		if ($api->errorcode == 90001) {
			// Record not found 
			
		} else {
			// Some other problem
		}
	}
	return $np_customerid;
}

// Gets the flexfield that stores the oscom-nolapro tie
function nolapro_get_flexfield($internalname="9999999") {
	$api = new npapi();
	$api->action = "flexfield/search/internalname/$internalname";
	$api->call_api();
	if ($api->ok) {
		return (string) $api->rsp->flexfield['id'];
	} else {
		return 0;
	}
}

function nolapro_save_customer($customer, $customerid, $np_customerid=0) {
	$api = new npapi();
	$data = array();
	if (!$np_customerid) {
		// Prepare to add a new customer
		// Get some default values
		$osccompany = nolapro_get_company_defaults("osccompany");
		if ($osccompany) {
			$salesglacctid = (string) $osccompany->sales;
			$customer_price_level = (string) $osccompany->default_pricelevelid;
			$invoicetermsid = (string) $osccompany->default_invoicetermsid;
		}
		$invcompany = nolapro_get_company_defaults("invcompany");
		if ($invcompany) {
			if (!$salesglacctid) {
				$salesglacctid = (string) $invcompany->sales;
			}
			if (!$customer_price_level) {
				$customer_price_level = (string) $invcompany->default_pricelevelid;
			}
			
			$arcompany = nolapro_get_company_defaults("arcompany");
			if ($arcompany) {
				if (!$invoicetermsid) {
					$invoicetermsid = (string) $arcompany->default_invoicetermsid;
				}
				$data = array(	"salesglacctid" => $salesglacctid,
								"customer_price_level" => $customer_price_level,
								"invoicetermsid" => $invoicetermsid,
								"weather_cf" => "F");
			}
		}
		$api->set_table('customer');
		$api->set_data($data);
	} else {
		$api->set_table('customer');
		$api->set_data('id', $np_customerid);	
	}
	if (!$customer['company']) {
		$customer['company'] = $customer['firstname']. ' '. $customer['lastname'];	
	}
	$gencompany = nolapro_get_company_defaults('gencompany');
	if ((string) $gencompany->currency) {
		$currency = (string) $gencompany->currency;
	} else {
		$currency = 'USD';
	}
	$data = array(	"companyname" => $customer['company'],
					"entry_firstname" => $customer['firstname'],
					"entry_lastname" => $customer['lastname'],
					"address1" => $customer['street_address'],
					"city" => $customer['city'],
					"state" => $customer['state'],
					"zip" => $customer['postcode'],
					"country" => $customer['country']['title'],
					"phone1" => $customer['telephone'],
					"email1" => $customer['email_address'],
					"weather_zip" => $customer['postcode'],
					"currency" => $currency);
	// Save the customer
	$api->set_data($data);
	$api->action = "customer/save";
	$api->call_api();
	$addflexfield = 0;
	if ($api->errorcode == 90012) {  // Entry exists for this company
		$cond = array("conditions" => "companyname='".addslashes($customer['company'])."' and cancel='0'");
		$api->set_data($cond);
		$api->action = "customer/search";
		$api->call_api();
		if (!$api->ok) {
			$data['companyname'] = $customer['company']." ".date("Y-m-d");
		} else {
			$np_customerid = (string) $api->rsp->customer->id;
			$data['id'] = $np_customerid;
			$addflexfield = 1;  // Add a flexfield since one doesn't exist
		}
		$api->set_table('customer');
		$api->set_data($data);
		$api->action = "customer/save";
		$api->call_api();
	}
	if ($api->ok) {
		if (!$np_customerid || $addflexfield) {
			$np_customerid = (string) $api->rsp->customer['id'];
			// Add a record to tie oscom id to nolapro id
			$flexfieldid = nolapro_get_flexfield('oscomcustomerid');
			$api->set_table('flexvalue');
			$data = array(	"flexfieldid" => $flexfieldid,
							"recordid" => $np_customerid,
							"value" => $customerid);
			$api->set_data($data);
			$api->action = "flexvalue/save";
			$api->call_api();
		}	
	} else {
		return 0;	
	}
	return $np_customerid;
}

function nolapro_save_deposit() {
	$api = new npapi();
}


function nolapro_save_shipto($delivery, $np_customerid, $customer) {
	$api = new npapi();
	// Create a shipto record
	$shiptoid = 0;
	$api->set_table('shipto');
	// If not set then use customer billing info
	if (!$delivery['street_address']) {
		$delivery['company'] = $customer['company'];
		$delivery['firstname'] = $customer['firstname'];
		$delivery['lastname'] = $customer['lastname'];
		$delivery['street_address'] = $customer['street_address'];
		$delivery['city'] = $customer['city'];
		$delivery['state'] = $customer['state'];
		$delivery['postcode'] = $customer['postcode'];
		$delivery['country']['title'] = $customer['country']['title'];
	}
	if (!$delivery['company']) {
		$delivery['company'] = $delivery['firstname']. ' '. $delivery['lastname'];	
	}
	$data = array(	"shipname" => $delivery['company'],
					"entry_firstname" => $delivery['firstname'],
					"entry_lastname" => $delivery['lastname'],
					"address1" => $delivery['street_address'],
					"city" => $delivery['city'],
					"state" => $delivery['state'],
					"zip" => $delivery['postcode'],
					"country" => $delivery['country']['title'],
					"phone1" => $delivery['telephone'],
					"email1" => $delivery['email_address'],
					"customerid" => $np_customerid,
					"weather_cf" => "F",
					"weather_zip" => $delivery['postcode']);
	$api->set_data($data);
	$api->action = "shipto/save";
	$api->call_api();
	if ($api->errorcode == 90012) {  // Entry exists for this company
		$cond = array("conditions" => "shipname='".$delivery['company']."' and cancel='0'");
		$api->set_data($cond);
		$api->action = "shipto/search";
		$api->call_api();
		if (!$api->ok) {
			$data['shipname'] = $delivery['company']." ".date("Y-m-d");
		} else {
			$shiptoid = (string) $api->rsp->shipto->id;
			$data['id'] = $shiptoid;
			unset($data['weather_cf']); //Don't override this if this record already exists
		}
		$api->set_table('shipto');
		$api->set_data($data);
		$api->action = "shipto/save";
		$api->call_api();
	}
	if ($api->ok) {
		return (string) $api->rsp->shipto['id'];	
	} else {
		return 0;	
	}
}