<?php
namespace Avalara;
use GuzzleHttp\Client;

/*****************************************************************************
 *                                                                           *
 *      This file is automatically generated by the AvaTax SDK process.      *
 *                  Edits to this file will be overwritten.                  *
 *                                                                           *
 *****************************************************************************/
 
/*****************************************************************************
 *                              API Methods                                  *
 *****************************************************************************/

 /**
 * Descendant AvaTaxClient that implements all API methods.
 */
class AvaTaxClient extends AvaTaxClientBase
{


    /**
     * Reset this account's license key
     *
     * Resets the existing license key for this account to a new key.
     *  
     * To reset your account, you must specify the ID of the account you wish to reset and confirm the action.
     *  
     * This API is only available to account administrators for the account in question, and may only be called after
     * an account has been activated by reading and accepting Avalara's terms and conditions. To activate your account
     * please log onto the AvaTax website or call the `ActivateAccount` API.
     *  
     * You can only reset license with 'Default' license key name. 
     * Resetting a license key cannot be undone. Any previous license keys will immediately cease to work when a new key is created.
     *  
     * When you call this API, all account administrators for this account will receive an email with the newly updated license key.
     * The email will specify which user reset the license key and it will contain the new key to use to update your connectors.
     * Note: The reset license key functionality will only be available for existing active license key i.e. when you reset license key for the account, the Default license key will be reset.The reset license key functionality is not available for newly created license keys i.e. license keys other than Default
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account you wish to update.
     * @param ResetLicenseKeyModel $model A request confirming that you wish to reset the license key of this account.
     * @return LicenseKeyModel
     */
    public function accountResetLicenseKey($id, $model)    {
        $path = "/api/v2/accounts/{$id}/resetlicensekey";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Activate an account by accepting terms and conditions
     *
     * Activate the account specified by the unique accountId number.
     *  
     * This activation request can only be called by account administrators. You must indicate
     * that you have read and accepted Avalara's terms and conditions to call this API.
     *  
     * Once you have activated your account, use the `AccountResetLicenseKey` API to generate
     * a license key for your account.
     *  
     * If you have not read or accepted the terms and conditions, this API call will return the
     * unchanged account model.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account to activate
     * @param ActivateAccountModel $model The activation request
     * @return AccountModel
     */
    public function activateAccount($id, $model)    {
        $path = "/api/v2/accounts/{$id}/activate";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve audit history for an account.
     *
     * Retrieve audit trace history for an account.
     *  
     * Your audit trace history contains a record of all API calls made against the AvaTax REST API that returned an error. You can use this API to investigate
     * problems and see exactly what information was sent back and forth between your code and AvaTax.
     *  
     * When specifying a start and end datetime, please include a valid timezone indicator, such as the "Z" present in the examples for the start and end query parameters.
     * You can learn more about valid time zone designators at https://en.wikipedia.org/wiki/ISO_8601#Time_zone_designators.
     *  
     * This API enforces limits to the amount of data retrieved. These limits are subject to change.
     *  
     * * You may request data from a maximum of a one-hour time period.
     * * The amount of data and number of API calls returned by this API are limited and may be adjusted at any time.
     * * Old records may be migrated out of immediately available storage. To request older data, please contact your account manager.
     * * New records must migrate to available storage before they can be retrieved. You may need to wait a period of time before newly created records can be fetched.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account you wish to audit.
     * @param string $start The start datetime of audit history you with to retrieve, e.g. "2018-06-08T17:00:00Z". Defaults to the past 15 minutes.
     * @param string $end The end datetime of audit history you with to retrieve, e.g. "2018-06-08T17:15:00Z. Defaults to the current time. Maximum of an hour after the start time.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @return FetchResult
     */
    public function auditAccount($id, $start, $end, $top=null, $skip=null)    {
        $path = "/api/v2/accounts/{$id}/audit";
        $guzzleParams = [
            'query' => ['start' => $start, 'end' => $end, '$top' => $top, '$skip' => $skip],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create license key for this account
     *
     * Creates a new license key for this account.
     *  
     * To create a license key for your account, you must specify the ID of the account and license key name.
     *  
     * This API is only available to account administrators for the account in question, and may only be called after
     * an account has been activated by reading and accepting Avalara's terms and conditions. To activate your account
     * please log onto the AvaTax website or call the `ActivateAccount` API.
     *  
     * You will reference this key using license key name. The existing license key will be using 'Default' as license key name.
     * Hence make sure that the license key name is unique per account considering the existing license key name 'Default'
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account you wish to update.
     * @param AccountLicenseKeyModel $model 
     * @return LicenseKeyModel
     */
    public function createLicenseKey($id, $model)    {
        $path = "/api/v2/accounts/{$id}/licensekey";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete license key for this account by license key name
     *
     * Deletes the license key for this account using license key name.
     *  
     * To delete a license key for your account, you must specify the accountID of the account and license key name.
     *  
     * This API is only available to account administrators for the account in question.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account you wish to update.
     * @param string $licensekeyname The license key name you wish to update.
     * @return ErrorDetail[]
     */
    public function deleteLicenseKey($id, $licensekeyname)    {
        $path = "/api/v2/accounts/{$id}/licensekey/{$licensekeyname}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single account
     *
     * Get the account object identified by this URL.
     * You may use the '$include' parameter to fetch additional nested data:
     *  
     * * Subscriptions
     * * Users
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account to retrieve
     * @param string $include A comma separated list of special fetch options
     * @return AccountModel
     */
    public function getAccount($id, $include=null)    {
        $path = "/api/v2/accounts/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Get configuration settings for this account
     *
     * Retrieve a list of all configuration settings tied to this account.
     *  
     * Configuration settings provide you with the ability to control features of your account and of your
     * tax software. The category names `TaxServiceConfig` and `AddressServiceConfig` are reserved for
     * Avalara internal software configuration values; to store your own account-level settings, please
     * create a new category name that begins with `X-`, for example, `X-MyCustomCategory`.
     *  
     * Account settings are permanent settings that cannot be deleted. You can set the value of an
     * account setting to null if desired.
     *  
     * Avalara-based account settings for `TaxServiceConfig` and `AddressServiceConfig` affect your account's
     * tax calculation and address resolution, and should only be changed with care.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return AccountConfigurationModel[]
     */
    public function getAccountConfiguration($id)    {
        $path = "/api/v2/accounts/{$id}/configuration";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve license key by license key name
     *
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account to retrieve
     * @param string $licensekeyname The ID of the account to retrieve
     * @return AccountLicenseKeyModel
     */
    public function getLicenseKey($id, $licensekeyname)    {
        $path = "/api/v2/accounts/{$id}/licensekey/{$licensekeyname}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all license keys for this account
     *
     * Gets list of all the license keys used by the account.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account to retrieve
     * @return AccountLicenseKeyModel[]
     */
    public function getLicenseKeys($id)    {
        $path = "/api/v2/accounts/{$id}/licensekeys";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all accounts
     *
     * List all account objects that can be seen by the current user.
     *  
     * This API lists all accounts you are allowed to see. In general, most users will only be able to see their own account.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Subscriptions
     * * Users
     *  
     * For more information about filtering in REST, please see the documentation at http://developer.avalara.com/avatax/filtering-in-rest/ .
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include A comma separated list of objects to fetch underneath this account. Any object with a URL path underneath this account can be fetched by specifying its name.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* subscriptions, users
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryAccounts($include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/accounts";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Change configuration settings for this account
     *
     * Update configuration settings tied to this account.
     *  
     * Configuration settings provide you with the ability to control features of your account and of your
     * tax software. The category names `TaxServiceConfig` and `AddressServiceConfig` are reserved for
     * Avalara internal software configuration values; to store your own account-level settings, please
     * create a new category name that begins with `X-`, for example, `X-MyCustomCategory`.
     *  
     * Account settings are permanent settings that cannot be deleted. You can set the value of an
     * account setting to null if desired.
     *  
     * Avalara-based account settings for `TaxServiceConfig` and `AddressServiceConfig` affect your account's
     * tax calculation and address resolution, and should only be changed with care.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @param AccountConfigurationModel[] $model 
     * @return AccountConfigurationModel[]
     */
    public function setAccountConfiguration($id, $model)    {
        $path = "/api/v2/accounts/{$id}/configuration";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve geolocation information for a specified address
     *
     * Resolve an address against Avalara's address-validation system. If the address can be resolved, this API
     * provides the latitude and longitude of the resolved location. The value 'resolutionQuality' can be used
     * to identify how closely this address can be located. If the address cannot be clearly located, use the
     * 'messages' structure to learn more about problems with this address.
     * This is the same API as the POST /api/v2/addresses/resolve endpoint.
     * Both verbs are supported to provide for flexible implementation.
     *  
     * In order to get any evaluation for an address, please provide at least one of the following fields/pairs:
     * 1. postal code
     * 2. line1 + city + region
     * 3. line1 + postal code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AutoAddress.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $line1 Line 1
     * @param string $line2 Line 2
     * @param string $line3 Line 3
     * @param string $city City
     * @param string $region State / Province / Region
     * @param string $postalCode Postal Code / Zip Code
     * @param string $country Two character ISO 3166 Country Code (see /api/v2/definitions/countries for a full list)
     * @param string $textCase selectable text case for address validation (See TextCase::* for a list of allowable values)
     * @return AddressResolutionModel
     */
    public function resolveAddress($line1, $line2, $line3, $city, $region, $postalCode, $country, $textCase)    {
        $path = "/api/v2/addresses/resolve";
        $guzzleParams = [
            'query' => ['line1' => $line1, 'line2' => $line2, 'line3' => $line3, 'city' => $city, 'region' => $region, 'postalCode' => $postalCode, 'country' => $country, 'textCase' => $textCase],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve geolocation information for a specified address
     *
     * Resolve an address against Avalara's address-validation system. If the address can be resolved, this API
     * provides the latitude and longitude of the resolved location. The value 'resolutionQuality' can be used
     * to identify how closely this address can be located. If the address cannot be clearly located, use the
     * 'messages' structure to learn more about problems with this address.
     * This is the same API as the GET /api/v2/addresses/resolve endpoint.
     * Both verbs are supported to provide for flexible implementation.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AutoAddress.
     * Swagger Name: AvaTaxClient
     * 
     * @param AddressValidationInfo $model The address to resolve
     * @return AddressResolutionModel
     */
    public function resolveAddressPost($model)    {
        $path = "/api/v2/addresses/resolve";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a lookup file for a company
     *
     * 
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account for the company
     * @param int $companyId The ID of the company for which the lookup file is to be created
     * @param AdvancedRuleLookupFileModel $model The lookup file you wish to create
     * @return AdvancedRuleLookupFileModel
     */
    public function createCompanyLookupFile($accountId, $companyId, $model)    {
        $path = "/api/v2/advancedrules/accounts/{$accountId}/companies/{$companyId}/lookupFiles";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a lookup file
     *
     * 
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account for the company the lookup file is for
     * @param string $id The unique ID/GUID for the company lookup file to be deleted
     * @return ErrorDetail[]
     */
    public function deleteLookupFile($accountId, $id)    {
        $path = "/api/v2/advancedrules/accounts/{$accountId}/lookupFiles/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Get the lookup files for a company
     *
     * 
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The account ID for the company
     * @param int $companyId The ID of the company for which to retrieve lookup files
     * @return FetchResult
     */
    public function getCompanyLookupFiles($accountId, $companyId)    {
        $path = "/api/v2/advancedrules/accounts/{$accountId}/companies/{$companyId}/lookupFiles";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Get a lookup file for an accountId and companyLookupFileId
     *
     * 
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account for the lookup file
     * @param string $id The unique ID/GUID of the company lookup file to return
     * @return AdvancedRuleLookupFileModel
     */
    public function getLookupFile($accountId, $id)    {
        $path = "/api/v2/advancedrules/accounts/{$accountId}/lookupFiles/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a lookup file
     *
     * 
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account for the company the lookup file is for
     * @param string $id The unique ID/GUID of the company lookup file to be updated
     * @param AdvancedRuleLookupFileModel $model The new values to update the lookup file
     * @return AdvancedRuleLookupFileModel
     */
    public function updateLookupFile($accountId, $id, $model)    {
        $path = "/api/v2/advancedrules/accounts/{$accountId}/lookupFiles/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new AvaFileForm
     *
     * Create one or more AvaFileForms
     * A 'AvaFileForm' represents a form supported by our returns team
     * 
     * ### Security Policies
     * 
     * * This API requires the user role Compliance Root User.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param AvaFileFormModel[] $model The AvaFileForm you wish to create.
     * @return AvaFileFormModel[]
     */
    public function createAvaFileForms($model)    {
        $path = "/api/v2/avafileforms";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single AvaFileForm
     *
     * Marks the existing AvaFileForm object at this URL as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: Compliance Root User, ComplianceUser, FirmAdmin.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the AvaFileForm you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteAvaFileForm($id)    {
        $path = "/api/v2/avafileforms/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single AvaFileForm
     *
     * Get the AvaFileForm object identified by this URL.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CompanyUser, Compliance Root User, Compliance Temp User, ComplianceAdmin, ComplianceUser, FirmAdmin, FirmUser, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The primary key of this AvaFileForm
     * @return AvaFileFormModel
     */
    public function getAvaFileForm($id)    {
        $path = "/api/v2/avafileforms/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all AvaFileForms
     *
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CompanyUser, Compliance Root User, Compliance Temp User, ComplianceAdmin, ComplianceUser, FirmAdmin, FirmUser, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* outletTypeId
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryAvaFileForms($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/avafileforms";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a AvaFileForm
     *
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires the user role Compliance Root User.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the AvaFileForm you wish to update
     * @param AvaFileFormModel $model The AvaFileForm model you wish to update.
     * @return AvaFileFormModel
     */
    public function updateAvaFileForm($id, $model)    {
        $path = "/api/v2/avafileforms/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Cancel an in progress batch
     *
     * Marks the in progress batch identified by this URL as cancelled.
     *  
     * Only JSON batches can be cancelled. If you attempt to cancel a file batch, you will receive an error message.
     *  
     * Only in progress batches can be cancelled. If you attempt to cancel a batch that its status is not Waiting or Processing, you will receive an error message.
     * Cancelling an in progress batch does not delete any transactions that were created before the cancellation.
     *  
     * Because the batch system processes with a degree of concurrency, and
     * because of batch sizes in the queue vary, AvaTax API is unable to accurately
     * predict when a batch will complete. If high performance processing is
     * required, please use the
     * [CreateTransaction API](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/CreateTransaction/).
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this batch.
     * @param int $id The ID of the batch to cancel.
     * @return BatchModel
     */
    public function cancelBatch($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/batches/{$id}/cancel";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new batch
     *
     * Create one or more new batch objects attached to this company.
     *  
     * Each batch object may have one or more file objects (currently only one file is supported).
     *  
     * When a batch is created, it is added to the AvaTax Batch Queue and will be
     * processed as quickly as possible in the order it was received. To check the
     * status of a batch, fetch the batch and retrieve the results of the batch
     * operation.
     *  
     * Because the batch system processes with a degree of concurrency, and
     * because of batch sizes in the queue vary, AvaTax API is unable to accurately
     * predict when a batch will complete. If high performance processing is
     * required, please use the
     * [CreateTransaction API](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/CreateTransaction/).
     *  
     * The maximum content length of the request body is limited to 28.6 MB. If this limit
     * is exceeded, a 404 Not Found status will be returned (possibly with a CORS error if
     * the API is called from a browser). In this situation, please split the request into
     * smaller batches.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this batch.
     * @param BatchModel[] $model The batch you wish to create.
     * @return BatchModel[]
     */
    public function createBatches($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/batches";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new transaction batch
     *
     * Create a new transaction batch objects attached to this company.
     *  
     * When a transaction batch is created, it is added to the AvaTax Batch v2 Queue and will be
     * processed as quickly as possible in the order it was received. To check the
     * status of a batch, fetch the batch and retrieve the results of the batch
     * operation.
     *  
     * Because the batch system processes with a degree of concurrency, and
     * because of batch sizes in the queue vary, AvaTax API is unable to accurately
     * predict when a batch will complete. If high performance processing is
     * required, please use the
     * [CreateTransaction API](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/CreateTransaction/).
     *  
     * The maximum content length of the request body is limited to 28.6 MB. If this limit
     * is exceeded, a 404 Not Found status will be returned (possibly with a CORS error if
     * the API is called from a browser). In this situation, please split the request into
     * smaller batches.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this batch.
     * @param CreateTransactionBatchRequestModel $model The transaction batch you wish to create.
     * @return CreateTransactionBatchResponseModel
     */
    public function createTransactionBatch($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/batches/transactions";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single batch
     *
     * Marks the batch identified by this URL as deleted.
     *  
     * If you attempt to delete a batch that is being processed, you will receive an error message.
     * Deleting a batch does not delete any transactions that were created by importing the batch.
     *  
     * Because the batch system processes with a degree of concurrency, and
     * because of batch sizes in the queue vary, AvaTax API is unable to accurately
     * predict when a batch will complete. If high performance processing is
     * required, please use the
     * [CreateTransaction API](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/CreateTransaction/).
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: CSPAdmin, CSPTester, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this batch.
     * @param int $id The ID of the batch to delete.
     * @return ErrorDetail[]
     */
    public function deleteBatch($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/batches/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Download a single batch file
     *
     * Download a single batch file identified by this URL.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this batch
     * @param int $batchId The ID of the batch object
     * @param int $id The primary key of this batch file object
     * @return object
     */
    public function downloadBatch($companyId, $batchId, $id)    {
        $path = "/api/v2/companies/{$companyId}/batches/{$batchId}/files/{$id}/attachment";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single batch
     *
     * Get the batch object identified by this URL. A batch object is a large
     * collection of API calls stored in a compact file.
     *  
     * Use this endpoint to retrieve the results or check the status of a batch.
     *  
     * When a batch is created, it is added to the AvaTax Batch Queue and will be
     * processed as quickly as possible in the order it was received. To check the
     * status of a batch, fetch the batch and retrieve the results of the batch
     * operation.
     *  
     * Because the batch system processes with a degree of concurrency, and
     * because of batch sizes in the queue vary, AvaTax API is unable to accurately
     * predict when a batch will complete. If high performance processing is
     * required, please use the
     * [CreateTransaction API](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/CreateTransaction/).
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this batch
     * @param int $id The primary key of this batch
     * @return BatchModel
     */
    public function getBatch($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/batches/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all batches for this company
     *
     * List all batch objects attached to the specified company.
     *  
     * A batch object is a large collection of API calls stored in a compact file.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter;
     * full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * Use [GetBatch](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Batches/GetBatch/)
     * to retrieve the results, or check the status, of an individual batch.
     *  
     * When a batch is created, it is added to the AvaTax Batch Queue and will be
     * processed as quickly as possible in the order it was received. To check the
     * status of a batch, fetch the batch and retrieve the results of the batch
     * operation.
     *  
     * Because the batch system processes with a degree of concurrency, and
     * because of batch sizes in the queue vary, AvaTax API is unable to accurately
     * predict when a batch will complete. If high performance processing is
     * required, please use the
     * [CreateTransaction API](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/CreateTransaction/).
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these batches
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* files
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listBatchesByCompany($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/batches";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all batches
     *
     * Get multiple batch objects across all companies.
     *  
     * A batch object is a large collection of API calls stored in a compact file.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter;
     * full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * When a batch is created, it is added to the AvaTax Batch Queue and will be
     * processed as quickly as possible in the order it was received. To check the
     * status of a batch, fetch the batch and retrieve the results of the batch
     * operation.
     *  
     * Because the batch system processes with a degree of concurrency, and
     * because of batch sizes in the queue vary, AvaTax API is unable to accurately
     * predict when a batch will complete. If high performance processing is
     * required, please use the
     * [CreateTransaction API](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/CreateTransaction/).
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* files
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryBatches($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/batches";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a CertExpress invitation
     *
     * Creates an invitation for a customer to self-report certificates using the CertExpress website.
     *  
     * This invitation is delivered by your choice of method, or you can present a hyperlink to the user
     * directly in your connector. Your customer will be redirected to https://app.certexpress.com/ where
     * they can follow a step-by-step guide to enter information about their exemption certificates. The
     * certificates entered will be recorded and automatically linked to their customer record.
     *  
     * The [CertExpress website](https://app.certexpress.com/home) is available for customers to use at any time.
     * Using CertExpress with this API will ensure that your certificates are automatically linked correctly into
     * your company so that they can be used for tax exemptions.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that will record certificates
     * @param string $customerCode The number of the customer where the request is sent to
     * @param CreateCertExpressInvitationModel[] $model the requests to send out to customers
     * @return CertExpressInvitationStatusModel[]
     */
    public function createCertExpressInvitation($companyId, $customerCode, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/certexpressinvites";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single CertExpress invitation
     *
     * Retrieve an existing CertExpress invitation sent to a customer.
     *  
     * A CertExpression invitation allows a customer to follow a helpful step-by-step guide to provide information
     * about their certificates. This step by step guide allows the customer to complete and upload the full
     * certificate in a convenient, friendly web browser experience. When the customer completes their certificates,
     * they will automatically be recorded to your company and linked to the customer record.
     *  
     * The [CertExpress website](https://app.certexpress.com/home) is available for customers to use at any time.
     * Using CertExpress with this API will ensure that your certificates are automatically linked correctly into
     * your company so that they can be used for tax exemptions.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that issued this invitation
     * @param string $customerCode The number of the customer where the request is sent to
     * @param int $id The unique ID number of this CertExpress invitation
     * @param string $include OPTIONAL: A comma separated list of special fetch options. No options are defined at this time.
     * @return CertExpressInvitationModel
     */
    public function getCertExpressInvitation($companyId, $customerCode, $id, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/certexpressinvites/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List CertExpress invitations
     *
     * Retrieve CertExpress invitations sent by this company.
     *  
     * A CertExpression invitation allows a customer to follow a helpful step-by-step guide to provide information
     * about their certificates. This step by step guide allows the customer to complete and upload the full
     * certificate in a convenient, friendly web browser experience. When the customer completes their certificates,
     * they will automatically be recorded to your company and linked to the customer record.
     *  
     * The [CertExpress website](https://app.certexpress.com/home) is available for customers to use at any time.
     * Using CertExpress with this API will ensure that your certificates are automatically linked correctly into
     * your company so that they can be used for tax exemptions.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that issued this invitation
     * @param string $include OPTIONAL: A comma separated list of special fetch options.      No options are defined at this time.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* companyId, customer, coverLetter, exposureZones, exemptReasons, requestLink
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCertExpressInvitations($companyId, $include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/certexpressinvites";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create certificates for this company
     *
     * Record one or more certificates document for this company.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * When you create a certificate, it will be processed by Avalara and will become available for use in
     * calculating tax exemptions when processing is complete. For a certificate to be used in calculating exemptions,
     * it must have the following:
     *  
     * * An exposure zone indicating where the certificate is valid
     * * A link to the customer that is allowed to use this certificate
     * * Your tax transaction must contain the correct customer code
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     *  
     * If the users specified in the certificates do not exist, the API will create the user and link them to the certificate
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID number of the company recording this certificate
     * @param boolean $preValidatedExemptionReason If set to true, the certificate will bypass the human verification process.
     * @param CertificateModel[] $model Certificates to be created
     * @return CertificateModel[]
     */
    public function createCertificates($companyId, $preValidatedExemptionReason, $model)    {
        $path = "/api/v2/companies/{$companyId}/certificates";
        $guzzleParams = [
            'query' => ['$preValidatedExemptionReason' => $preValidatedExemptionReason],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Revoke and delete a certificate
     *
     * Revoke the certificate identified by this URL, then delete it.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Revoked certificates can no longer be used.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @return ErrorDetail[]
     */
    public function deleteCertificate($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Download an image for this certificate
     *
     * Download an image or PDF file for this certificate.
     *  
     * This API can be used to download either a single-page preview of the certificate or a full PDF document.
     * To retrieve a preview image, set the `$type` parameter to `Jpeg` and the `$page` parameter to `1`.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param int $page If you choose `$type`=`Jpeg`, you must specify which page number to retrieve.
     * @param string $type The data format in which to retrieve the certificate image (See CertificatePreviewType::* for a list of allowable values)
     * @return object
     */
    public function downloadCertificateImage($companyId, $id, $page, $type)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/attachment";
        $guzzleParams = [
            'query' => ['$page' => $page, '$type' => $type],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single certificate
     *
     * Get the current certificate identified by this URL.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * You can use the `$include` parameter to fetch the following additional objects for expansion:
     *  
     * * customers - Retrieves the list of customers linked to the certificate.
     * * po_numbers - Retrieves all PO numbers tied to the certificate.
     * * attributes - Retrieves all attributes applied to the certificate.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param string $include OPTIONAL: A comma separated list of special fetch options. You can specify one or more of the following:      * customers - Retrieves the list of customers linked to the certificate.   * po_numbers - Retrieves all PO numbers tied to the certificate.   * attributes - Retrieves all attributes applied to the certificate.
     * @return CertificateModel
     */
    public function getCertificate($companyId, $id, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Check a company's exemption certificate status.
     *
     * Checks whether this company is configured to use exemption certificates in AvaTax.
     *  
     * Exemption certificates are tracked through a different auditable data store than the one that
     * holds AvaTax transactions. To use the AvaTax exemption certificate document store, please call
     * `GetCertificateSetup` to see if your company is configured to use the exemption certificate
     * document store. To request setup, please call `RequestCertificateSetup` and your company will
     * be configured with data storage in the auditable certificate system.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company ID to check
     * @return ProvisionStatusModel
     */
    public function getCertificateSetup($companyId)    {
        $path = "/api/v2/companies/{$companyId}/certificates/setup";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Link attributes to a certificate
     *
     * Link one or many attributes to a certificate.
     *  
     * A certificate may have multiple attributes that control its behavior. You may link or unlink attributes to a
     * certificate at any time. The full list of defined attributes may be found using `ListCertificateAttributes`.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param CertificateAttributeModel[] $model The list of attributes to link to this certificate.
     * @return FetchResult
     */
    public function linkAttributesToCertificate($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/attributes/link";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Link customers to a certificate
     *
     * Link one or more customers to an existing certificate.
     *  
     * Customers and certificates must be linked before a customer can make use of a certificate to obtain
     * a tax exemption in AvaTax. Since some certificates may cover more than one business entity, a certificate
     * can be connected to multiple customer records using the `LinkCustomersToCertificate` API.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param LinkCustomersModel $model The list of customers needed be added to the Certificate for exemption
     * @return FetchResult
     */
    public function linkCustomersToCertificate($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/customers/link";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * List all attributes applied to this certificate
     *
     * Retrieve the list of attributes that are linked to this certificate.
     *  
     * A certificate may have multiple attributes that control its behavior. You may link or unlink attributes to a
     * certificate at any time. The full list of defined attributes may be found using [ListCertificateAttributes](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Definitions/ListCertificateAttributes/) API.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @return FetchResult
     */
    public function listAttributesForCertificate($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/attributes";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List customers linked to this certificate
     *
     * List all customers linked to this certificate.
     *  
     * Customers must be linked to a certificate in order to make use of its tax exemption features. You
     * can link or unlink customers to a certificate at any time.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param string $include OPTIONAL: A comma separated list of special fetch options.   No options are currently available when fetching customers.
     * @return FetchResult
     */
    public function listCustomersForCertificate($companyId, $id, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/customers";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all certificates for a company
     *
     * List all certificates recorded by a company
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * You can use the `$include` parameter to fetch the following additional objects for expansion:
     *  
     * * customers - Retrieves the list of customers linked to the certificate.
     * * po_numbers - Retrieves all PO numbers tied to the certificate.
     * * attributes - Retrieves all attributes applied to the certificate.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID number of the company to search
     * @param string $include OPTIONAL: A comma separated list of special fetch options. You can specify one or more of the following:      * customers - Retrieves the list of customers linked to the certificate.   * po_numbers - Retrieves all PO numbers tied to the certificate.   * attributes - Retrieves all attributes applied to the certificate.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* exemptionNumber, status, ecmsId, ecmsStatus, pdf, pages
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryCertificates($companyId, $include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/certificates";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Request setup of exemption certificates for this company.
     *
     * Requests the setup of exemption certificates for this company.
     *  
     * Exemption certificates are tracked through a different auditable data store than the one that
     * holds AvaTax transactions. To use the AvaTax exemption certificate document store, please call
     * `GetCertificateSetup` to see if your company is configured to use the exemption certificate
     * document store. To request setup, please call `RequestCertificateSetup` and your company will
     * be configured with data storage in the auditable certificate system.
     *  
     * This API will return the current status of exemption certificate setup for this company.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId 
     * @return ProvisionStatusModel
     */
    public function requestCertificateSetup($companyId)    {
        $path = "/api/v2/companies/{$companyId}/certificates/setup";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Unlink attributes from a certificate
     *
     * Unlink one or many attributes from a certificate.
     *  
     * A certificate may have multiple attributes that control its behavior. You may link or unlink attributes to a
     * certificate at any time. The full list of defined attributes may be found using `ListCertificateAttributes`.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param CertificateAttributeModel[] $model The list of attributes to unlink from this certificate.
     * @return FetchResult
     */
    public function unlinkAttributesFromCertificate($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/attributes/unlink";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Unlink customers from a certificate
     *
     * Unlinks one or more customers from a certificate.
     *  
     * Unlinking a certificate from a customer will prevent the certificate from being used to generate
     * tax exemptions for the customer in the future. If any previous transactions for this customer had
     * used this linked certificate, those transactions will be unchanged and will still have a link to the
     * exemption certificate in question.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param LinkCustomersModel $model The list of customers to unlink from this certificate
     * @return FetchResult
     */
    public function unlinkCustomersFromCertificate($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/customers/unlink";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single certificate
     *
     * Replace the certificate identified by this URL with a new one.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param CertificateModel $model The new certificate object that will replace the existing one
     * @return CertificateModel
     */
    public function updateCertificate($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Upload an image or PDF attachment for this certificate
     *
     * Upload an image or PDF attachment for this certificate.
     *  
     * Image attachments can be of the format `PDF`, `JPEG`, `TIFF`, or `PNG`. To upload a multi-page image, please
     * use the `PDF` data type.
     *  
     * A certificate is a document stored in either AvaTax Exemptions or CertCapture. The certificate document
     * can contain information about a customer's eligibility for exemption from sales or use taxes based on
     * criteria you specify when you store the certificate. To view or manage your certificates directly, please
     * log onto the administrative website for the product you purchased.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this certificate
     * @param int $id The unique ID number of this certificate
     * @param object $file The exemption certificate file you wanted to upload. Accepted formats are: PDF, JPEG, TIFF, PNG.
     * @return string
     */
    public function uploadCertificateImage($companyId, $id, $file)    {
        $path = "/api/v2/companies/{$companyId}/certificates/{$id}/attachment";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Checks whether the integration being used to set up this company and run transactions onto this company is compliant to all requirements.
     *
     * Examines the most recent 100 transactions or data from the last month when verifying transaction-related integrations.
     * For partners who write integrations against AvaTax for many clients, this API is a way to do a quick self testing to verify whether the
     * written integrations for a company are sufficient enough to be delivered to the respective customers to start using it.
     *  
     * This API provides messages specific enough (through predefined checks) to guide the partner on what integrations are still missing from the company to get fully certified.
     * The API makes the following checks to conclude if the company is NOT fully certified:
     * 1. Any past month items contains generic tax code of P0000000.
     * 2. All the companies on the requesting account are test companies.
     * 3. No Voided/Cancelled documents in the past 30 days.
     * 4. There are less than 2 committed documents.
     * 5. Any documentCode is a generic GUID string.
     * 6. Any customerCode on document is a generic GUID string.
     * 7. No document has more than 1 documentLine.
     * 8. All of the documents have missing exemptionNo, customerUsageType, taxDateOverride or negative amount.
     * 9. Any document quantity is a negative number.
     * 10. Any document have repeated lines.
     * 11. No document has shipping charge.
     * 12. All documents have same ItemCodes, descriptions and taxCodes.
     * 13. Less than 2 addresses used across all documents.
     * 14. Whether locationCode was used in documents.
     * 15. Account with AvaGlobal subscription and no documents have VATBuyerId.
     * 16. Any document has currencyCode not being USD for accounts with AvaGlobal subscription.
     * 17. All documents have countryCode used for accounts with AvaGlobal subscription.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the company to check if its integration is certified.
     * @return string
     */
    public function certifyIntegration($id)    {
        $path = "/api/v2/companies/{$id}/certify";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Change the filing status of this company
     *
     * Changes the current filing status of this company.
     *  
     * For customers using Avalara's Managed Returns Service, each company within their account can request
     * for Avalara to file tax returns on their behalf. Avalara compliance team members will review all
     * requested filing calendars prior to beginning filing tax returns on behalf of this company.
     *  
     * The following changes may be requested through this API:
     *  
     * * If a company is in `NotYetFiling` status, the customer may request this be changed to `FilingRequested`.
     * * Avalara compliance team members may change a company from `FilingRequested` to `FirstFiling`.
     * * Avalara compliance team members may change a company from `FirstFiling` to `Active`.
     *  
     * All other status changes must be requested through the Avalara customer support team.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @param FilingStatusChangeModel $model 
     * @return string
     */
    public function changeFilingStatus($id, $model)    {
        $path = "/api/v2/companies/{$id}/filingstatus";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Quick setup for a company with a single physical address
     *
     * Shortcut to quickly setup a single-physical-location company with critical information and activate it.
     * This API provides quick and simple company setup functionality and does the following things:
     *  
     * * Create a company object with its own tax profile
     * * Add a key contact person for the company
     * * Set up one physical location for the main office
     * * Declare nexus in all taxing jurisdictions for that main office address
     * * Activate the company
     *  
     * This API only provides a limited subset of functionality compared to the 'Create Company' API call.
     * If you need additional features or options not present in this 'Quick Setup' API call, please use the full 'Create Company' call instead.
     * Please allow 1 minute before making transactions using the company.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param CompanyInitializationModel $model Information about the company you wish to create.
     * @return CompanyModel
     */
    public function companyInitialize($model)    {
        $path = "/api/v2/companies/initialize";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create new companies
     *
     * Create one or more new company objects.
     * A 'company' represents a single corporation or individual that is registered to handle transactional taxes.
     * You may attach nested data objects such as contacts, locations, and nexus with this CREATE call, and those objects will be created with the company.
     *  
     * NOTE: Please do not use these blacklisted characters in company name and code: ';', '\', '|'.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param CompanyModel[] $model Either a single company object or an array of companies to create
     * @return CompanyModel[]
     */
    public function createCompanies($model)    {
        $path = "/api/v2/companies";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Add parameters to a company.
     *
     * Add parameters to a company.
     *  
     * Some companies can be taxed and reported differently depending on the properties of the company, such as IsPrimaryAddress. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a company will be used by default in tax calculation but will not show on the transaction line referencing the company.
     *  
     * A company location parameter specified on a transaction line will override a company parameter if they share the same parameter name.
     *  
     * To see available parameters for this company, call `/api/v2/definitions/parameters?$filter=attributeType eq Company`
     *  
     * Some parameters are only available for use if you have subscribed to specific AvaTax services. To see which parameters you are able to use, add the query parameter "$showSubscribed=true" to the parameter definition call above.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this company parameter.
     * @param CompanyParameterDetailModel[] $model The company parameters you wish to create.
     * @return CompanyParameterDetailModel[]
     */
    public function createCompanyParameters($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/parameters";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Request managed returns funding setup for a company
     *
     * This API is available by invitation only.
     * Companies that use the Avalara Managed Returns or the SST Certified Service Provider services are
     * required to setup their funding configuration before Avalara can begin filing tax returns on their
     * behalf.
     * Funding configuration for each company is set up by submitting a funding setup request, which can
     * be sent either via email or via an embedded HTML widget.
     * When the funding configuration is submitted to Avalara, it will be reviewed by treasury team members
     * before approval.
     * This API records that an ambedded HTML funding setup widget was activated.
     * This API requires a subscription to Avalara Managed Returns or SST Certified Service Provider.
     * 
     * ### Security Policies
     * 
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique identifier of the company
     * @param FundingInitiateModel $model The funding initialization request
     * @return FundingStatusModel
     */
    public function createFundingRequest($id, $model)    {
        $path = "/api/v2/companies/{$id}/funding/setup";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single company
     *
     * Deleting a company will delete all child companies, and all users attached to this company.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the company you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteCompany($id)    {
        $path = "/api/v2/companies/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single company parameter
     *
     * Delete a parameter of a company.
     * Some companies can be taxed and reported differently depending on the properties of the company, such as IsPrimaryAddress. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a company will be used by default in tax calculation but will not show on the transaction line referencing the company.
     *  
     * A company location parameter specified on a transaction line will override a company parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $id The parameter id
     * @return ErrorDetail[]
     */
    public function deleteCompanyParameter($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Check the funding configuration of a company
     *
     * This API is available by invitation only.
     * Requires a subscription to Avalara Managed Returns or SST Certified Service Provider.
     * Returns the funding configuration of the requested company.
     * .
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique identifier of the company
     * @return FundingConfigurationModel
     */
    public function fundingConfigurationByCompany($companyId)    {
        $path = "/api/v2/companies/{$companyId}/funding/configuration";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Check the funding configuration of a company
     *
     * This API is available by invitation only.
     * Requires a subscription to Avalara Managed Returns or SST Certified Service Provider.
     * Returns the funding configuration of the requested company.
     * .
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique identifier of the company
     * @param string $currency The currency of the funding. USD and CAD are the only valid currencies
     * @return FundingConfigurationModel[]
     */
    public function fundingConfigurationsByCompanyAndCurrency($companyId, $currency)    {
        $path = "/api/v2/companies/{$companyId}/funding/configurations";
        $guzzleParams = [
            'query' => ['currency' => $currency],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single company
     *
     * Get the company object identified by this URL.
     * A 'company' represents a single corporation or individual that is registered to handle transactional taxes.
     * You may specify one or more of the following values in the '$include' parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Contacts
     *  * Items
     *  * Locations
     *  * Nexus
     *  * Settings
     *  * TaxCodes
     *  * TaxRules
     *  * UPC
     *  * Parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the company to retrieve.
     * @param string $include OPTIONAL: A comma separated list of special fetch options.      * Child objects - Specify one or more of the following to retrieve objects related to each company: "Contacts", "FilingCalendars", "Items", "Locations", "Nexus", "TaxCodes", "NonReportingChildren" or "TaxRules".   * Deleted objects - Specify "FetchDeleted" to retrieve information about previously deleted objects.
     * @return CompanyModel
     */
    public function getCompany($id, $include=null)    {
        $path = "/api/v2/companies/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Get configuration settings for this company
     *
     * Retrieve a list of all configuration settings tied to this company.
     *  
     * Configuration settings provide you with the ability to control features of your account and of your
     * tax software. The category name `AvaCertServiceConfig` is reserved for
     * Avalara internal software configuration values; to store your own company-level settings, please
     * create a new category name that begins with `X-`, for example, `X-MyCustomCategory`.
     *  
     * Company settings are permanent settings that cannot be deleted. You can set the value of a
     * company setting to null if desired and if the particular setting supports it.
     *  
     * Avalara-based company settings for `AvaCertServiceConfig` affect your company's exemption certificate
     * processing, and should be changed with care.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return CompanyConfigurationModel[]
     */
    public function getCompanyConfiguration($id)    {
        $path = "/api/v2/companies/{$id}/configuration";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single company parameter
     *
     * Retrieves a single parameter of a company.
     *  
     * Some companies can be taxed and reported differently depending on the properties of the company, such as IsPrimaryAddress. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a company will be used by default in tax calculation but will not show on the transaction line referencing the company.
     *  
     * A company location parameter specified on a transaction line will override a company parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId 
     * @param int $id 
     * @return CompanyParameterDetailModel
     */
    public function getCompanyParameterDetail($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Get this company's filing status
     *
     * Retrieve the current filing status of this company.
     *  
     * For customers using Avalara's Managed Returns Service, each company within their account can request
     * for Avalara to file tax returns on their behalf. Avalara compliance team members will review all
     * requested filing calendars prior to beginning filing tax returns on behalf of this company.
     *  
     * A company's filing status can be one of the following values:
     *  
     * * `NoReporting` - This company is not configured to report tax returns; instead, it reports through a parent company.
     * * `NotYetFiling` - This company has not yet begun filing tax returns through Avalara's Managed Returns Service.
     * * `FilingRequested` - The company has requested to begin filing tax returns, but Avalara's compliance team has not yet begun filing.
     * * `FirstFiling` - The company has recently filing tax returns and is in a new status.
     * * `Active` - The company is currently active and is filing tax returns via Avalara Managed Returns.
     * * `Inactive` - The company is currently inactive.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return string
     */
    public function getFilingStatus($id)    {
        $path = "/api/v2/companies/{$id}/filingstatus";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve parameters for a company
     *
     * Retrieve all parameters of a company.
     *  
     * Some companies can be taxed and reported differently depending on the properties of the company, such as IsPrimaryAddress. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a company will be used by default in tax calculation but will not show on the transaction line referencing the company.
     *  
     * A company location parameter specified on a transaction line will override a company parameter if they share the same parameter name.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* name, unit
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCompanyParameterDetails($companyId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/parameters";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Check managed returns funding status for a company
     *
     * This API is available by invitation only.
     * Requires a subscription to Avalara Managed Returns or SST Certified Service Provider.
     * Returns a list of funding setup requests and their current status.
     * Each object in the result is a request that was made to setup or adjust funding status for this company.
     * 
     * ### Security Policies
     * 
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique identifier of the company
     * @return FundingStatusModel[]
     */
    public function listFundingRequestsByCompany($id)    {
        $path = "/api/v2/companies/{$id}/funding";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a list of MRS Companies with account
     *
     * This API is available by invitation only.
     *  
     * Get a list of companies with an active MRS service.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @return FetchResult
     */
    public function listMrsCompanies()    {
        $path = "/api/v2/companies/mrs";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all companies
     *
     * Get multiple company objects.
     *  
     * A `company` represents a single corporation or individual that is registered to handle transactional taxes.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Contacts
     * * Items
     * * Locations
     * * Nexus
     * * Settings
     * * TaxCodes
     * * TaxRules
     * * UPC
     * * Parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include A comma separated list of objects to fetch underneath this company. Any object with a URL path underneath this company can be fetched by specifying its name.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* IsFein, contacts, items, locations, nexus, settings, taxCodes, taxRules, upcs, nonReportingChildCompanies, exemptCerts, parameters, supplierandcustomers
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryCompanies($include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Change configuration settings for this company
     *
     * Update configuration settings tied to this company.
     *  
     * Configuration settings provide you with the ability to control features of your account and of your
     * tax software. The category names `AvaCertServiceConfig` is reserved for
     * Avalara internal software configuration values; to store your own company-level settings, please
     * create a new category name that begins with `X-`, for example, `X-MyCustomCategory`.
     *  
     * Company settings are permanent settings that cannot be deleted. You can set the value of a
     * company setting to null if desired and if the particular setting supports it.
     *  
     * Avalara-based company settings for `AvaCertServiceConfig` affect your company's exemption certificate
     * processing, and should be changed with care.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @param CompanyConfigurationModel[] $model 
     * @return CompanyConfigurationModel[]
     */
    public function setCompanyConfiguration($id, $model)    {
        $path = "/api/v2/companies/{$id}/configuration";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single company
     *
     * Replace the existing company object at this URL with an updated object.
     *  
     * A `CompanyModel` represents a single corporation or individual that is registered to handle transactional taxes.
     * All data from the existing object will be replaced with data in the object you PUT.
     *  
     * When calling `UpdateCompany`, you are permitted to update the company itself. Updates to the nested objects
     * such as contacts, locations, or settings are not permitted. To update the nested objects
     *  
     * To set a field's value to `null`, you may either set its value to `null` or omit that field from the object you PUT.
     *  
     * NOTE: Please do not use these blacklisted characters in company name and code: ';', '\', '|'.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the company you wish to update.
     * @param CompanyModel $model The company object you wish to update.
     * @return CompanyModel
     */
    public function updateCompany($id, $model)    {
        $path = "/api/v2/companies/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a company parameter
     *
     * Update a parameter of a company.
     *  
     * Some companies can be taxed and reported differently depending on the properties of the company, such as IsPrimaryAddress. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a company will be used by default in tax calculation but will not show on the transaction line referencing the company.
     *  
     * A company location parameter specified on a transaction line will override a company parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $id The company parameter id
     * @param CompanyParameterDetailModel $model The company parameter object you wish to update.
     * @return CompanyParameterDetailModel
     */
    public function updateCompanyParameterDetail($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve jurisdiction rate information for tax authority
     *
     * This API is available by invitation only.
     * 
     * ### Security Policies
     * 
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $taxAuthorityId Used to limit the jurisdictions returned.
     * @param string $effectiveDate Used to limit the jurisdictions returned.
     * @param string $endDate Used to limit the jurisdictions returned.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param string $include A comma separated list of objects to fetch underneath this jurisdiction.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return ComplianceJurisdictionRateModel
     */
    public function queryTaxAuthorityJurisdictionRates($taxAuthorityId, $effectiveDate, $endDate, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/compliance/taxauthorityjurisdictionrates";
        $guzzleParams = [
            'query' => ['taxAuthorityId' => $taxAuthorityId, 'effectiveDate' => $effectiveDate, 'endDate' => $endDate, '$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new contact
     *
     * Create one or more new contact objects.
     * A 'contact' is a person associated with a company who is designated to handle certain responsibilities of
     * a tax collecting and filing entity.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this contact.
     * @param ContactModel[] $model The contacts you wish to create.
     * @return ContactModel[]
     */
    public function createContacts($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/contacts";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single contact
     *
     * Mark the existing contact object at this URL as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this contact.
     * @param int $id The ID of the contact you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteContact($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/contacts/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single contact
     *
     * Get the contact object identified by this URL.
     * A 'contact' is a person associated with a company who is designated to handle certain responsibilities of
     * a tax collecting and filing entity.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company for this contact
     * @param int $id The primary key of this contact
     * @return ContactModel
     */
    public function getContact($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/contacts/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve contacts for this company
     *
     * List all contact objects assigned to this company.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these contacts
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listContactsByCompany($companyId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/contacts";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all contacts
     *
     * Get multiple contact objects across all companies.
     * A 'contact' is a person associated with a company who is designated to handle certain responsibilities of
     * a tax collecting and filing entity.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryContacts($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/contacts";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single contact
     *
     * Replace the existing contact object at this URL with an updated object.
     * A 'contact' is a person associated with a company who is designated to handle certain responsibilities of
     * a tax collecting and filing entity.
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this contact belongs to.
     * @param int $id The ID of the contact you wish to update
     * @param ContactModel $model The contact you wish to update.
     * @return ContactModel
     */
    public function updateContact($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/contacts/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Create customers for this company
     *
     * Create one or more customers for this company.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this `customer` object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * A nested object such as CustomFields could be specified and created along with the customer object. To fetch the
     * nested object, please call 'GetCustomer' API with appropriate $include parameters.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param CustomerModel[] $model The list of customer objects to be created
     * @return CustomerModel[]
     */
    public function createCustomers($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a customer record
     *
     * Deletes the customer object referenced by this URL.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this `customer` object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $customerCode The unique code representing this customer
     * @return CustomerModel
     */
    public function deleteCustomer($companyId, $customerCode)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single customer
     *
     * Retrieve the customer identified by this URL.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this customer object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * You can use the `$include` parameter to fetch the following additional objects for expansion:
     *  
     * * Certificates - Fetch a list of certificates linked to this customer.
     * * CustomFields - Fetch a list of custom fields associated to this customer.
     * * attributes - Retrieves all attributes applied to the customer.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $customerCode The unique code representing this customer
     * @param string $include Specify optional additional objects to include in this fetch request
     * @return CustomerModel
     */
    public function getCustomer($companyId, $customerCode, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Link attributes to a customer
     *
     * Link one or many attributes to a customer.
     *  
     * A customer may have multiple attributes that control its behavior. You may link or unlink attributes to a
     * customer at any time. The full list of defined attributes may be found using `QueryCompanyCustomerAttributes` API.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this customer object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded the provided customer
     * @param string $customerCode The unique code representing the current customer
     * @param CustomerAttributeModel[] $model The list of attributes to link to the customer.
     * @return FetchResult
     */
    public function linkAttributesToCustomer($companyId, $customerCode, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/attributes/link";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Link certificates to a customer
     *
     * Link one or more certificates to a customer.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this `customer` object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $customerCode The unique code representing this customer
     * @param LinkCertificatesModel $model The list of certificates to link to this customer
     * @return FetchResult
     */
    public function linkCertificatesToCustomer($companyId, $customerCode, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/certificates/link";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Link two customer records together
     *
     * Links a Ship-To customer record with a Bill-To customer record.
     *  
     * Customer records represent businesses or individuals who can provide exemption certificates. Some customers
     * may have certificates that are linked to their shipping address or their billing address. To group these
     * customer records together, you may link multiple bill-to and ship-to addresses together to represent a single
     * entity that has multiple different addresses of different kinds.
     *  
     * In general, a customer will have only one primary billing address and multiple ship-to addresses, representing
     * all of the different locations where they receive goods. To facilitate this type of customer, you can send in
     * one bill-to customer code and multiple ship-to customer codes in a single API call.
     *  
     * Note that you can only link a ship-to customer record to a bill-to customer record. You may not link two customers
     * of the same kind together.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company defining customers.
     * @param string $code The code of the bill-to customer to link.
     * @param LinkCustomersModel $model A list of information about ship-to customers to link to this bill-to customer.
     * @return CustomerModel
     */
    public function linkShipToCustomersToBillCustomer($companyId, $code, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers/billto/{$code}/shipto/link";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a customer's attributes
     *
     * Retrieve the attributes linked to the customer identified by this URL.
     *  
     * A customer may have multiple attributes that control its behavior. You may link or unlink attributes to a
     * customer at any time. The full list of defined attributes may be found using `QueryCompanyCustomerAttributes` API.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this customer object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded the provided customer
     * @param string $customerCode The unique code representing the current customer
     * @return FetchResult
     */
    public function listAttributesForCustomer($companyId, $customerCode)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/attributes";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List certificates linked to a customer
     *
     * List all certificates linked to a customer.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this `customer` object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $customerCode The unique code representing this customer
     * @param string $include OPTIONAL: A comma separated list of special fetch options. You can specify one or more of the following:      * customers - Retrieves the list of customers linked to the certificate.   * po_numbers - Retrieves all PO numbers tied to the certificate.   * attributes - Retrieves all attributes applied to the certificate.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* exemptionNumber, status, ecmsId, ecmsStatus, pdf, pages
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCertificatesForCustomer($companyId, $customerCode, $include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/certificates";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List valid certificates for a location
     *
     * List valid certificates linked to a customer in a particular country and region.
     *  
     * This API is intended to help identify whether a customer has already provided a certificate that
     * applies to a particular country and region. This API is intended to help you remind a customer
     * when they have or have not provided copies of their exemption certificates to you during the sales
     * order process.
     *  
     * If a customer does not have a certificate on file and they wish to provide one, you should send the customer
     * a CertExpress invitation link so that the customer can upload proof of their exemption certificate. Please
     * see the `CreateCertExpressInvitation` API to create an invitation link for this customer.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $customerCode The unique code representing this customer
     * @param string $country Search for certificates matching this country. Uses the ISO 3166 two character country code.
     * @param string $region Search for certificates matching this region. Uses the ISO 3166 two or three character state, region, or province code.
     * @return ExemptionStatusModel
     */
    public function listValidCertificatesForCustomer($companyId, $customerCode, $country, $region)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/certificates/{$country}/{$region}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all customers for this company
     *
     * List all customers recorded by this company matching the specified criteria.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this `customer` object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * You can use the `$include` parameter to fetch the following additional objects for expansion:
     *  
     * * Certificates - Fetch a list of certificates linked to this customer.
     * * attributes - Retrieves all attributes applied to the customer.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $include OPTIONAL - You can specify the value `certificates` to fetch information about certificates linked to the customer.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* shipTos
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryCustomers($companyId, $include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/customers";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Unlink attributes from a customer
     *
     * Unlink one or many attributes from a customer.
     *  
     * A customer may have multiple attributes that control its behavior. You may link or unlink attributes to a
     * customer at any time. The full list of defined attributes may be found using `QueryCompanyCustomerAttributes` API.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this customer object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded the customer
     * @param string $customerCode The unique code representing the current customer
     * @param CustomerAttributeModel[] $model The list of attributes to unlink from the customer.
     * @return FetchResult
     */
    public function unlinkAttributesFromCustomer($companyId, $customerCode, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/attributes/unlink";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Unlink certificates from a customer
     *
     * Remove one or more certificates to a customer.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this `customer` object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $customerCode The unique code representing this customer
     * @param LinkCertificatesModel $model The list of certificates to link to this customer
     * @return FetchResult
     */
    public function unlinkCertificatesFromCustomer($companyId, $customerCode, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}/certificates/unlink";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single customer
     *
     * Replace the customer object at this URL with a new record.
     *  
     * A customer object defines information about a person or business that purchases products from your
     * company. When you create a tax transaction in AvaTax, you can use the `customerCode` from this
     * record in your `CreateTransaction` API call. AvaTax will search for this `customerCode` value and
     * identify any certificates linked to this `customer` object. If any certificate applies to the transaction,
     * AvaTax will record the appropriate elements of the transaction as exempt and link it to the `certificate`.
     *  
     * Before you can use any exemption certificates endpoints, you must set up your company for exemption certificate data storage.
     * Companies that do not have this storage system set up will see `CertCaptureNotConfiguredError` when they call exemption 
     * certificate related APIs. To check if this is set up for a company, call `GetCertificateSetup`. To request setup of exemption 
     * certificate storage for this company, call `RequestCertificateSetup`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that recorded this customer
     * @param string $customerCode The unique code representing this customer
     * @param CustomerModel $model The new customer model that will replace the existing record at this URL
     * @return CustomerModel
     */
    public function updateCustomer($companyId, $customerCode, $model)    {
        $path = "/api/v2/companies/{$companyId}/customers/{$customerCode}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Create and store new datasources for the respective companies.
     *
     * Create one or more datasource objects.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The id of the company you which to create the datasources
     * @param DataSourceModel[] $model 
     * @return DataSourceModel[]
     */
    public function createDataSources($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/datasources";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a datasource by datasource id for a company.
     *
     * Marks the existing datasource for a company as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The id of the company the datasource belongs to.
     * @param int $id The id of the datasource you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteDataSource($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/datasources/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Get data source by data source id
     *
     * Retrieve the data source by its unique ID number.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId 
     * @param int $id data source id
     * @return DataSourceModel
     */
    public function getDataSourceById($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/datasources/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all datasources for this company
     *
     * Gets multiple datasource objects for a given company.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The id of the company you wish to retrieve the datasources.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* isEnabled, isSynced, isAuthorized, name, externalState
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listDataSources($companyId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/datasources";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all datasources
     *
     * Get multiple datasource objects across all companies.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* isEnabled, isSynced, isAuthorized, name, externalState
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryDataSources($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/datasources";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a datasource identified by id for a company
     *
     * Updates a datasource for a company.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The id of the company the datasource belongs to.
     * @param int $id The id of the datasource you wish to delete.
     * @param DataSourceModel $model 
     * @return DataSourceModel
     */
    public function updateDataSource($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/datasources/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Lists all parents of an HS Code.
     *
     * Retrieves the specified HS code and all of its parents, reflecting all sections, chapters, headings, and subheadings
     *  
     * a list of HS Codes that are the parents and information branches of the HS Code for the given
     * destination country, if lower detail is available.
     *  
     * This API will include information branches if applicable. These do not have HS Codes and cannot be referenced,
     * but can contain information relevant to deciding the correct HS Code.
     *  
     * This API is intended to be useful to review the descriptive hierarchy of an HS Code, which can be particularly helpful
     * when HS Codes can have multiple levels of generic descriptions.
     * 
     * ### Security Policies
     * 
     * * This API depends on the following active services:*Required* (all): AvaTaxGlobal.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The name or code of the destination country.
     * @param string $hsCode The partial or full HS Code for which you would like to view all of the parents.
     * @return FetchResult
     */
    public function getCrossBorderCode($country, $hsCode)    {
        $path = "/api/v2/definitions/crossborder/{$country}/{$hsCode}/hierarchy";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Test whether a form supports online login verification
     *
     * This API is intended to be useful to identify whether the user should be allowed
     * to automatically verify their login and password. This API will provide a result only if the form supports automatic online login verification.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $form The name of the form you would like to verify. This is the tax form code
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxFormCodes, scraperType, expectedResponseTime, requiredFilingCalendarDataFields
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function getLoginVerifierByForm($form, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/filingcalendars/loginverifiers/{$form}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all market place locations.
     *
     * List all market place locations.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listAllMarketplaceLocations($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/listallmarketplacelocations";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of the AvaFile Forms available
     *
     * This API is deprecated.
     *  
     * Please use the ListTaxForms API.
     *  
     * Returns the full list of Avalara-supported AvaFile Forms
     * This API is intended to be useful to identify all the different AvaFile Forms
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* outletTypeId
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listAvaFileForms($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/avafileforms";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List certificate attributes used by a company
     *
     * List the certificate attributes defined by a company either specified by the user or the user's default company.
     *  
     * A certificate may have multiple attributes that control its behavior. You may apply or remove attributes to a
     * certificate at any time.
     *  
     * If you see the 'CertCaptureNotConfiguredError', please use CheckProvision and RequestProvision endpoints to
     * check and provision account.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyid Id of the company the user wish to fetch the certificates' attributes from. If not specified the API will use user's default company.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCertificateAttributes($companyid, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/certificateattributes";
        $guzzleParams = [
            'query' => ['companyid' => $companyid, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List the certificate exempt reasons defined by a company
     *
     * List the certificate exempt reasons defined by a company.
     *  
     * An exemption reason defines why a certificate allows a customer to be exempt
     * for purposes of tax calculation.
     *  
     * If you see the 'CertCaptureNotConfiguredError', please use CheckProvision and RequestProvision endpoints to
     * check and provision account.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCertificateExemptReasons($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/certificateexemptreasons";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List certificate exposure zones used by a company
     *
     * List the certificate exposure zones defined by a company.
     *  
     * An exposure zone is a location where a certificate can be valid. Exposure zones may indicate a taxing
     * authority or other legal entity to which a certificate may apply.
     *  
     * If you see the 'CertCaptureNotConfiguredError', please use CheckProvision and RequestProvision endpoints to
     * check and provision account.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* id, companyId, name, tag, description, created, modified, region, country
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCertificateExposureZones($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/certificateexposurezones";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported usage of extra parameters for classification of a item.
     *
     * Returns the full list of Avalara-supported usage of extra parameters for item classification.
     * The list of parameters is available for use with Item Classification.
     * Some parameters are only available for use if you have subscribed to certain features of AvaTax.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* values
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listClassificationParametersUsage($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/classification/parametersusage";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of communications service types
     *
     * Returns full list of service types for a given transaction type ID.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The transaction type ID to examine
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* requiredParameters
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCommunicationsServiceTypes($id, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/communications/transactiontypes/{$id}/servicetypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of communications transactiontypes
     *
     * Returns full list of communications transaction types which
     * are accepted in communication tax calculation requests.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCommunicationsTransactionTypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/communications/transactiontypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of communications transaction/service type pairs
     *
     * Returns full list of communications transaction/service type pairs which
     * are accepted in communication tax calculation requests.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* requiredParameters
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCommunicationsTSPairs($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/communications/tspairs";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all ISO 3166 countries
     *
     * Returns a list of all ISO 3166 country codes, and their US English friendly names.
     * This API is intended to be useful when presenting a dropdown box in your website to allow customers to select a country for
     * a shipping address.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* alpha3Code, isEuropeanUnion, localizedNames, addressesRequireRegion
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCountries($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/countries";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List certificate exposure zones used by a company
     *
     * List available cover letters that can be used when sending invitation to use CertExpress to upload certificates.
     *  
     * The CoverLetter model represents a message sent along with an invitation to use CertExpress to
     * upload certificates. An invitation allows customers to use CertExpress to upload their exemption
     * certificates directly; this cover letter explains why the invitation was sent.
     *  
     * If you see the 'CertCaptureNotConfiguredError', please use CheckProvision and RequestProvision endpoints to
     * check and provision account.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* id, companyId, subject, description, createdDate, modifiedDate, pageCount, templateFilename, version
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCoverLetters($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/coverletters";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Lists the next level of HS Codes given a destination country and HS Code prefix.
     *
     * Retrieves a list of HS Codes that are the children of the prefix for the given destination country, if
     * additional children are available.
     *  
     * HS Code is interchangeable with "tariff code" and definitions are generally unique to a destination country.
     * An HS Code describes an item and its eligibility/rate for tariffs. HS Codes are organized by
     * Section/Chapter/Heading/Subheading/Classification.
     *  
     * This API is intended to be useful to identify the correct HS Code to use for your item.
     * 
     * ### Security Policies
     * 
     * * This API depends on the following active services:*Required* (all): AvaTaxGlobal.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The name or code of the destination country.
     * @param string $hsCode The Section or partial HS Code for which you would like to view the next level of HS Code detail, if more detail is available.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* hsCodeSource, system, destinationCountry, isDecisionNode, zeroPaddingCount, isSystemDefined, isTaxable, effDate, endDate, hsCodeSourceLength
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCrossBorderCodes($country, $hsCode, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/crossborder/{$country}/{$hsCode}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List top level HS Code Sections.
     *
     * Returns the full list of top level HS Code Sections. Sections are the broadest level of detail for
     * classifying tariff codes and the items to which they apply. HS Codes are organized
     * by Section/Chapter/Heading/Subheading/Classification.
     *  
     * This API is intended to be useful to identify the top level Sections for
     * further LandedCost HS Code lookups.
     * 
     * ### Security Policies
     * 
     * * This API depends on the following active services:*Required* (all): AvaTaxGlobal.
     * Swagger Name: AvaTaxClient
     * 
     * @return FetchResult
     */
    public function listCrossBorderSections()    {
        $path = "/api/v2/definitions/crossborder/sections";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all ISO 4217 currencies supported by AvaTax.
     *
     * Lists all ISO 4217 currencies supported by AvaTax.
     *  
     * This API produces a list of currency codes that can be used when calling AvaTax. The values from this API can be used to fill out the
     * `currencyCode` field in a `CreateTransactionModel`.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listCurrencies($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/currencies";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported entity use codes
     *
     * Returns the full list of Avalara-supported entity use codes.
     * Entity/Use Codes are definitions of the entity who is purchasing something, or the purpose for which the transaction
     * is occurring. This information is generally used to determine taxability of the product.
     * In order to facilitate correct reporting of your taxes, you are encouraged to select the proper entity use codes for
     * all transactions that are exempt.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* validCountries
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listEntityUseCodes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/entityusecodes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported filing frequencies.
     *
     * Returns the full list of Avalara-supported filing frequencies.
     * This API is intended to be useful to identify all the different filing frequencies that can be used in notices.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listFilingFrequencies($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/filingfrequencies";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List jurisdictions based on the filter provided
     *
     * Returns a list of all Avalara-supported taxing jurisdictions.
     *  
     * This API allows you to examine all Avalara-supported jurisdictions. You can filter your search by supplying
     * SQL-like query for fetching only the ones you concerned about. For example: effectiveDate > '2016-01-01'
     *  
     * The rate, salesRate, and useRate fields are not available on the JurisdictionModels returned by this API.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* rate, salesRate, signatureCode, useRate
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listJurisdictions($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/jurisdictions";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List jurisdictions near a specific address
     *
     * Returns a list of all Avalara-supported taxing jurisdictions that apply to this address.
     *  
     * This API allows you to identify which jurisdictions are nearby a specific address according to the best available geocoding information.
     * It is intended to allow you to create a "Jurisdiction Override", which allows an address to be configured as belonging to a nearby
     * jurisdiction in AvaTax.
     *  
     * The results of this API call can be passed to the `CreateJurisdictionOverride` API call.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $line1 The first address line portion of this address.
     * @param string $line2 The second address line portion of this address.
     * @param string $line3 The third address line portion of this address.
     * @param string $city The city portion of this address.
     * @param string $region The region, state, or province code portion of this address.
     * @param string $postalCode The postal code or zip code portion of this address.
     * @param string $country The two-character ISO-3166 code of the country portion of this address.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* country, Jurisdictions
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listJurisdictionsByAddress($line1, $line2, $line3, $city, $region, $postalCode, $country, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/jurisdictionsnearaddress";
        $guzzleParams = [
            'query' => ['line1' => $line1, 'line2' => $line2, 'line3' => $line3, 'city' => $city, 'region' => $region, 'postalCode' => $postalCode, 'country' => $country, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List jurisdictions based on the TaxType, TaxSubType and RateType provided
     *
     * Returns a list of all Avalara-supported taxing jurisdictions filtered by TaxType, TaxSubType and RateType.
     *  
     * This API allows you to examine all Avalara-supported jurisdictions. You can filter your search by supplying
     * SQL-like query for fetching only the ones you concerned about. For example: effectiveDate > '2016-01-01'
     *  
     * The jurisdictionType, effectiveDate, and endDate are filterable fields available on the JurisdictionRateTypeTaxTypeMappingModels returned by this API.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country for which you want to retrieve the jurisdiction information
     * @param string $region The region for which you want to retrieve the jurisdiction information
     * @param string $taxTypeId The taxtype for which you want to retrieve the jurisdiction information
     * @param string $taxSubTypeId The taxsubtype for which you want to retrieve the jurisdiction information
     * @param string $rateTypeId The ratetype for which you want to retrieve the jurisdiction information
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* id, country, state, jurisdictionCode, longName, taxTypeId, taxSubTypeId, taxTypeGroupId, rateTypeId
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listJurisdictionsByRateTypeTaxTypeMapping($country, $region, $taxTypeId, $taxSubTypeId, $rateTypeId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/jurisdictions/countries/{$country}/regions/{$region}/taxtypes/{$taxTypeId}/taxsubtypes/{$taxSubTypeId}";
        $guzzleParams = [
            'query' => ['rateTypeId' => $rateTypeId, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the list of questions that are required for a tax location
     *
     * Returns the list of additional questions you must answer when declaring a location in certain taxing jurisdictions.
     * Some tax jurisdictions require that you register or provide additional information to configure each physical place where
     * your company does business.
     * This information is not usually required in order to calculate tax correctly, but is almost always required to file your tax correctly.
     * You can call this API call for any address and obtain information about what questions must be answered in order to properly
     * file tax in that location.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $line1 The first line of this location's address.
     * @param string $line2 The second line of this location's address.
     * @param string $line3 The third line of this location's address.
     * @param string $city The city part of this location's address.
     * @param string $region The region, state, or province part of this location's address.
     * @param string $postalCode The postal code of this location's address.
     * @param string $country The country part of this location's address.
     * @param float $latitude Optionally identify the location via latitude/longitude instead of via address.
     * @param float $longitude Optionally identify the location via latitude/longitude instead of via address.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listLocationQuestionsByAddress($line1, $line2, $line3, $city, $region, $postalCode, $country, $latitude, $longitude, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/locationquestions";
        $guzzleParams = [
            'query' => ['line1' => $line1, 'line2' => $line2, 'line3' => $line3, 'city' => $city, 'region' => $region, 'postalCode' => $postalCode, 'country' => $country, 'latitude' => $latitude, 'longitude' => $longitude, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all forms where logins can be verified automatically
     *
     * List all forms where logins can be verified automatically.
     * This API is intended to be useful to identify whether the user should be allowed
     * to automatically verify their login and password.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxFormCodes, scraperType, expectedResponseTime, requiredFilingCalendarDataFields
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listLoginVerifiers($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/filingcalendars/loginverifiers";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the list of locations for a marketplace.
     *
     * Retrieves the list of suggested locations for a marketplace.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $marketplaceId MarketplaceId of a marketplace
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listMarketplaceLocations($marketplaceId, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/marketplacelocations";
        $guzzleParams = [
            'query' => ['marketplaceId' => $marketplaceId, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported nexus for all countries and regions.
     *
     * Returns the full list of all Avalara-supported nexus for all countries and regions.
     *  
     * This API is intended to be useful if your user interface needs to display a selectable list of nexus.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexus($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/nexus";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all nexus that apply to a specific address.
     *
     * Returns a list of all Avalara-supported taxing jurisdictions that apply to this address.
     * This API allows you to identify which tax authorities apply to a physical location, salesperson address, or point of sale.
     * In general, it is usually expected that a company will declare nexus in all the jurisdictions that apply to each physical address
     * where the company does business.
     * The results of this API call can be passed to the 'Create Nexus' API call to declare nexus for this address.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $line1 The first address line portion of this address.
     * @param string $line2 The first address line portion of this address.
     * @param string $line3 The first address line portion of this address.
     * @param string $city The city portion of this address.
     * @param string $region Name or ISO 3166 code identifying the region portion of the address.      This field supports many different region identifiers:   * Two and three character ISO 3166 region codes   * Fully spelled out names of the region in ISO supported languages   * Common alternative spellings for many regions      For a full list of all supported codes and names, please see the Definitions API `ListRegions`.
     * @param string $postalCode The postal code or zip code portion of this address.
     * @param string $country Name or ISO 3166 code identifying the country portion of this address.      This field supports many different country identifiers:   * Two character ISO 3166 codes   * Three character ISO 3166 codes   * Fully spelled out names of the country in ISO supported languages   * Common alternative spellings for many countries      For a full list of all supported codes and names, please see the Definitions API `ListCountries`.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusByAddress($line1, $line2, $line3, $city, $region, $postalCode, $country, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/nexus/byaddress";
        $guzzleParams = [
            'query' => ['line1' => $line1, 'line2' => $line2, 'line3' => $line3, 'city' => $city, 'region' => $region, 'postalCode' => $postalCode, 'country' => $country, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported nexus for a country.
     *
     * Returns all Avalara-supported nexus for the specified country.
     *  
     * This API is intended to be useful if your user interface needs to display a selectable list of nexus filtered by country.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country in which you want to fetch the system nexus
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusByCountry($country, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/nexus/{$country}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported nexus for a country and region.
     *
     * Returns all Avalara-supported nexus for the specified country and region.
     *  
     * This API is intended to be useful if your user interface needs to display a selectable list of nexus filtered by country and region.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The two-character ISO-3166 code for the country.
     * @param string $region The two or three character region code for the region.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusByCountryAndRegion($country, $region, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/nexus/{$country}/{$region}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List nexus related to a tax form
     *
     * Retrieves a list of nexus related to a tax form.
     *  
     * The concept of `Nexus` indicates a place where your company has sufficient physical presence and is obligated
     * to collect and remit transaction-based taxes.
     *  
     * When defining companies in AvaTax, you must declare nexus for your company in order to correctly calculate tax
     * in all jurisdictions affected by your transactions.
     *  
     * This API is intended to provide useful information when examining a tax form. If you are about to begin filing
     * a tax form, you may want to know whether you have declared nexus in all the jurisdictions related to that tax
     * form in order to better understand how the form will be filled out.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $formCode The form code that we are looking up the nexus for
     * @return NexusByTaxFormModel
     */
    public function listNexusByFormCode($formCode)    {
        $path = "/api/v2/definitions/nexus/byform/{$formCode}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported nexus for a tax type group.
     *
     * Returns all Avalara-supported nexus for the specified specified tax type group.
     *  
     * This API is intended to be useful if your user interface needs to display a selectable list of nexus filtered by tax type group.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $taxTypeGroup The tax type group to fetch the supporting system nexus for.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusByTaxTypeGroup($taxTypeGroup, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/nexus/bytaxtypegroup/{$taxTypeGroup}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of nexus tax type groups
     *
     * Returns the full list of Avalara-supported nexus tax type groups
     * This API is intended to be useful to identify all the different tax sub-types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* subscriptionTypeId, subscriptionDescription, tabName, showColumn
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusTaxTypeGroups($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/nexustaxtypegroups";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice customer funding options.
     *
     * Returns the full list of Avalara-supported tax notice customer funding options.
     * This API is intended to be useful to identify all the different notice customer funding options that can be used in notices.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* activeFlag, sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeCustomerFundingOptions($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticecustomerfundingoptions";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice customer types.
     *
     * Returns the full list of Avalara-supported tax notice customer types.
     * This API is intended to be useful to identify all the different notice customer types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* activeFlag, sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeCustomerTypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticecustomertypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice filing types.
     *
     * Returns the full list of Avalara-supported tax notice filing types.
     * This API is intended to be useful to identify all the different notice filing types that can be used in notices.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* description, activeFlag, sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeFilingtypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticefilingtypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice priorities.
     *
     * Returns the full list of Avalara-supported tax notice priorities.
     * This API is intended to be useful to identify all the different notice priorities that can be used in notices.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* activeFlag, sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticePriorities($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticepriorities";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice reasons.
     *
     * Returns the full list of Avalara-supported tax notice reasons.
     * This API is intended to be useful to identify all the different tax notice reasons.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* description, activeFlag, sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeReasons($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticereasons";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice responsibility ids
     *
     * Returns the full list of Avalara-supported tax notice responsibility ids
     * This API is intended to be useful to identify all the different tax notice responsibilities.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeResponsibilities($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticeresponsibilities";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice root causes
     *
     * Returns the full list of Avalara-supported tax notice root causes
     * This API is intended to be useful to identify all the different tax notice root causes.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeRootCauses($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticerootcauses";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice statuses.
     *
     * Returns the full list of Avalara-supported tax notice statuses.
     * This API is intended to be useful to identify all the different tax notice statuses.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* isOpen, sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeStatuses($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticestatuses";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax notice types.
     *
     * Returns the full list of Avalara-supported tax notice types.
     * This API is intended to be useful to identify all the different notice types that can be used in notices.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* activeFlag, sortOrder
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNoticeTypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/noticetypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported extra parameters for creating transactions.
     *
     * Returns the full list of Avalara-supported extra parameters for the 'Create Transaction' API call.
     * This list of parameters is available for use when configuring your transaction.
     * Some parameters are only available for use if you have subscribed to certain features of AvaTax.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* serviceTypes, regularExpression, values
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listParameters($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/parameters";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the parameters by companyCode and itemCode.
     *
     * Returns the list of parameters based on the company's service types and the item code.
     * Ignores nexus if a service type is configured in the 'IgnoreNexusForServiceTypes' configuration section.
     * Ignores nexus for the AvaAlcohol service type.
     *  
     * NOTE: If your company code or item code contains any of these characters /, +, ? or a space, please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: 'Company/Code' becomes 'Company_-ava2f-_Code'
     * * Replace '+' with '\_-ava2b-\_' For example: 'Company+Code' becomes 'Company_-ava2b-_Code'
     * * Replace '?' with '\_-ava3f-\_' For example: 'Company?Code' becomes 'Company_-ava3f-_Code'
     * * Replace '%' with '\_-ava25-\_' For example: 'Company%Code' becomes 'Company_-ava25-_Code'
     * * Replace '#' with '\_-ava23-\_' For example: 'Company#Code' becomes 'Company_-ava23-_Code'
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode Company code.
     * @param string $itemCode Item code.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* serviceTypes, regularExpression, values
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listParametersByItem($companyCode, $itemCode, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/parameters/byitem/{$companyCode}/{$itemCode}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported usage of extra parameters for creating transactions.
     *
     * Returns the full list of Avalara-supported usage of extra parameters for the 'Create Transaction' API call.
     * This list of parameters is available for use when configuring your transaction.
     * Some parameters are only available for use if you have subscribed to certain features of AvaTax.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* values
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listParametersUsage($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/parametersusage";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported permissions
     *
     * Returns the full list of Avalara-supported permission types.
     * This API is intended to be useful to identify the capabilities of a particular user logon.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @return FetchResult
     */
    public function listPermissions($top=null, $skip=null)    {
        $path = "/api/v2/definitions/permissions";
        $guzzleParams = [
            'query' => ['$top' => $top, '$skip' => $skip],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported postal codes.
     *
     * Retrieves the list of Avalara-supported postal codes.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listPostalCodes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/postalcodes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all customs duty programs recognized by AvaTax
     *
     * List all preferred customs duty programs recognized by AvaTax.
     *  
     * A customs duty program is an optional program you can use to obtain favorable treatment from customs and duty agents.
     * An example of a preferred program is NAFTA, which provides preferential rates for products being shipped from neighboring
     * countries.
     *  
     * To select a preferred program for calculating customs and duty rates, call this API to find the appropriate code for your
     * preferred program. Next, set the parameter `AvaTax.LC.PreferredProgram` in your `CreateTransaction` call to the code of
     * the program.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* effectiveDate, endDate
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listPreferredPrograms($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/preferredprograms";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all available product classification systems.
     *
     * List all available product classification systems.
     *  
     * Tax authorities use product classification systems as a way to identify products and associate them with a tax rate.
     * More than one tax authority might use the same product classification system, but they might charge different tax rates for products.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* countries
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @param string $countryCode If not null, return all records with this code.
     * @return FetchResult
     */
    public function listProductClassificationSystems($filter=null, $top=null, $skip=null, $orderBy=null, $countryCode)    {
        $path = "/api/v2/definitions/productclassificationsystems";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy, '$countryCode' => $countryCode],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all product classification systems available to a company based on its nexus.
     *
     * Lists all product classification systems available to a company based on its nexus.
     *  
     * Tax authorities use product classification systems as a way to identify products and associate them with a tax rate.
     * More than one tax authority might use the same product classification system, but they might charge different tax rates for products.
     *  
     *  
     * NOTE: If your company code contains any of these characters /, +, ? or a space, please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: 'Company/Code' becomes 'Company_-ava2f-_Code'
     * * Replace '+' with '\_-ava2b-\_' For example: 'Company+Code' becomes 'Company_-ava2b-_Code'
     * * Replace '?' with '\_-ava3f-\_' For example: 'Company?Code' becomes 'Company_-ava3f-_Code'
     * * Replace '%' with '\_-ava25-\_' For example: 'Company%Code' becomes 'Company_-ava25-_Code'
     * * Replace '#' with '\_-ava23-\_' For example: 'Company#Code' becomes 'Company_-ava23-_Code'
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* countries
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @param string $countryCode If not null, return all records with this code.
     * @return FetchResult
     */
    public function listProductClassificationSystemsByCompany($companyCode, $filter=null, $top=null, $skip=null, $orderBy=null, $countryCode)    {
        $path = "/api/v2/definitions/productclassificationsystems/bycompany/{$companyCode}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy, '$countryCode' => $countryCode],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of rate types for each country
     *
     * Returns the full list of Avalara-supported rate type file types
     * This API is intended to be useful to identify all the different rate types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country to examine for rate types
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listRateTypesByCountry($country, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/countries/{$country}/ratetypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the list of rate types by country, TaxType and by TaxSubType
     *
     * Returns the list of Avalara-supported rate type file types
     * This API is intended to be useful to identify all the different rate types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country to examine for rate types
     * @param string $taxTypeId The taxType for the country to examine for rate types
     * @param string $taxSubTypeId The taxSubType for the country and taxType to examine for rate types
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* id, rateType, description
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listRateTypesByCountryTaxTypeTaxSubType($country, $taxTypeId, $taxSubTypeId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/countries/{$country}/taxtypes/{$taxTypeId}/taxsubtypes/{$taxSubTypeId}/ratetypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all ISO 3166 regions
     *
     * Returns a list of all ISO 3166 region codes and their US English friendly names.
     * This API is intended to be useful when presenting a dropdown box in your website to allow customers to select a region
     * within the country for a shipping addresses.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* localizedNames
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listRegions($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/regions";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all ISO 3166 regions for a country
     *
     * Returns a list of all ISO 3166 region codes for a specific country code, and their US English friendly names.
     * This API is intended to be useful when presenting a dropdown box in your website to allow customers to select a region
     * within the country for a shipping addresses.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country of which you want to fetch ISO 3166 regions
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* localizedNames
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listRegionsByCountry($country, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/countries/{$country}/regions";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported resource file types
     *
     * Returns the full list of Avalara-supported resource file types
     * This API is intended to be useful to identify all the different resource file types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listResourceFileTypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/resourcefiletypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported usage of parameters used for returns.
     *
     * Returns the full list of Avalara-supported usage of extra parameters for the returns.
     * This list of parameters is available for use with Returns.
     * Some parameters are only available for use if you have subscribed to certain features of AvaTax.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* values
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listReturnsParametersUsage($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/returns/parametersusage";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported permissions
     *
     * Returns the full list of Avalara-supported permission types.
     * This API is intended to be useful when designing a user interface for selecting the security role of a user account.
     * Some security roles are restricted for Avalara internal use.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listSecurityRoles($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/securityroles";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported subscription types
     *
     * Returns the full list of Avalara-supported subscription types.
     * This API is intended to be useful for identifying which features you have added to your account.
     * You may always contact Avalara's sales department for information on available products or services.
     * You cannot change your subscriptions directly through the API.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listSubscriptionTypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/subscriptiontypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the list all tags supported by avalara
     *
     * Retrieves the list of suggested locations for a marketplace.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTags($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/tags";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax authorities.
     *
     * Returns the full list of Avalara-supported tax authorities.
     * This API is intended to be useful to identify all the different authorities that receive tax.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxAuthorities($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxauthorities";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported forms for each tax authority.
     *
     * Returns the full list of Avalara-supported forms for each tax authority.
     * This list represents tax forms that Avalara recognizes.
     * Customers who subscribe to Avalara Managed Returns Service can request these forms to be filed automatically
     * based on the customer's AvaTax data.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxAuthorityForms($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxauthorityforms";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax authority types.
     *
     * Returns the full list of Avalara-supported tax authority types.
     * This API is intended to be useful to identify all the different authority types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxAuthorityTypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxauthoritytypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax codes.
     *
     * Retrieves the list of Avalara-supported system tax codes.
     * A 'TaxCode' represents a uniquely identified type of product, good, or service.
     * Avalara supports correct tax rates and taxability rules for all TaxCodes in all supported jurisdictions.
     * If you identify your products by tax code in your 'Create Transacion' API calls, Avalara will correctly calculate tax rates and
     * taxability rules for this product in all supported jurisdictions.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxCodes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxcodes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of Avalara-supported tax code types.
     *
     * Returns the full list of recognized tax code types.
     * A 'Tax Code Type' represents a broad category of tax codes, and is less detailed than a single TaxCode.
     * This API is intended to be useful for broadly searching for tax codes by tax code type.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @return TaxCodeTypesModel
     */
    public function listTaxCodeTypes($top=null, $skip=null)    {
        $path = "/api/v2/definitions/taxcodetypes";
        $guzzleParams = [
            'query' => ['$top' => $top, '$skip' => $skip],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of the Tax Forms available
     *
     * Returns the full list of Avalara-supported Tax Forms
     * This API is intended to be useful to identify all the different Tax Forms
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxForms($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxforms";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of tax sub types
     *
     * Returns the full list of Avalara-supported tax sub-types
     * This API is intended to be useful to identify all the different tax sub-types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxSubTypes($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxsubtypes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of tax sub types by Country and TaxType
     *
     * Returns the full list of Avalara-supported tax sub-types
     * This API is intended to be useful to identify all the different tax sub-types for given country and TaxType.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country to examine for taxsubtype
     * @param string $taxTypeId The taxType for the country to examine for taxsubtype
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxSubTypesByCountryAndTaxType($country, $taxTypeId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxsubtypes/countries/{$country}/taxtypes/{$taxTypeId}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of tax sub types by jurisdiction code and region
     *
     * Returns the full list of Avalara-supported tax sub-types by jurisdiction and region
     * This API is intended to be useful to identify all the different tax sub-types.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $jurisdictionCode The jurisdiction code of the tax sub type.
     * @param string $region The region of the tax sub type.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxSubTypesByJurisdictionAndRegion($jurisdictionCode, $region, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxsubtypes/{$jurisdictionCode}/{$region}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the full list of tax type groups
     *
     * Returns the full list of Avalara-supported tax type groups
     * This API is intended to be useful to identify all the different tax type groups.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* subscriptionTypeId, subscriptionDescription, tabName, showColumn, displaySequence
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxTypeGroups($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxtypegroups";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the list of applicable TaxTypes
     *
     * Retrieves the list of applicable TaxTypes based on Nexus of the company.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country for which you want to retrieve the unitofbasis information
     * @param int $companyId Your companyId to retrieve the applicable taxtypes
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxTypesByNexusAndCountry($country, $companyId, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/taxtypes/countries/{$country}";
        $guzzleParams = [
            'query' => ['companyId' => $companyId, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve the list of applicable UnitOfBasis
     *
     * Retrieves the list of applicable UnitOfBasis
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country The country for which you want to retrieve the unitofbasis information
     * @param string $taxTypeId The taxtype for which you want to retrieve the unitofbasis information
     * @param string $taxSubTypeId The taxsubtype for which you want to retrieve the unitofbasis information
     * @param string $rateTypeId The ratetype for which you want to retrieve the unitofbasis information
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listUnitOfBasisByCountryAndTaxTypeAndTaxSubTypeAndRateType($country, $taxTypeId, $taxSubTypeId, $rateTypeId, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/unitofbasis/countries/{$country}/taxtypes/{$taxTypeId}/taxsubtypes/{$taxSubTypeId}";
        $guzzleParams = [
            'query' => ['rateTypeId' => $rateTypeId, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all defined units of measurement
     *
     * List all units of measurement systems defined by Avalara.
     *  
     * A unit of measurement system is a method of measuring a quantity, such as distance, mass, or others.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* id
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listUnitOfMeasurement($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/definitions/unitofmeasurements";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create one or more DistanceThreshold objects
     *
     * Create one or more DistanceThreshold objects for this company.
     *  
     * A company-distance-threshold model indicates the distance between a company
     * and the taxing borders of various countries. Distance thresholds are necessary
     * to correctly calculate some value-added taxes.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that owns this DistanceThreshold
     * @param CompanyDistanceThresholdModel[] $model The DistanceThreshold object or objects you wish to create.
     * @return CompanyDistanceThresholdModel[]
     */
    public function createDistanceThreshold($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/distancethresholds";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single DistanceThreshold object
     *
     * Marks the DistanceThreshold object identified by this URL as deleted.
     *  
     * A company-distance-threshold model indicates the distance between a company
     * and the taxing borders of various countries. Distance thresholds are necessary
     * to correctly calculate some value-added taxes.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that owns this DistanceThreshold
     * @param int $id The unique ID number of the DistanceThreshold object you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteDistanceThreshold($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/distancethresholds/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single DistanceThreshold
     *
     * Retrieves a single DistanceThreshold object defined by this URL.
     *  
     * A company-distance-threshold model indicates the distance between a company
     * and the taxing borders of various countries. Distance thresholds are necessary
     * to correctly calculate some value-added taxes.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this DistanceThreshold object
     * @param int $id The unique ID number referring to this DistanceThreshold object
     * @return CompanyDistanceThresholdModel
     */
    public function getDistanceThreshold($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/distancethresholds/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all DistanceThresholds for this company.
     *
     * Lists all DistanceThreshold objects that belong to this company.
     *  
     * A company-distance-threshold model indicates the distance between a company
     * and the taxing borders of various countries. Distance thresholds are necessary
     * to correctly calculate some value-added taxes.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company whose DistanceThreshold objects you wish to list.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listDistanceThresholds($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/distancethresholds";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all DistanceThreshold objects
     *
     * Lists all DistanceThreshold objects that belong to this account.
     *  
     * A company-distance-threshold model indicates the distance between a company
     * and the taxing borders of various countries. Distance thresholds are necessary
     * to correctly calculate some value-added taxes.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryDistanceThresholds($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/distancethresholds";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a DistanceThreshold object
     *
     * Replace the existing DistanceThreshold object at this URL with an updated object.
     *  
     * A company-distance-threshold model indicates the distance between a company
     * and the taxing borders of various countries. Distance thresholds are necessary
     * to correctly calculate some value-added taxes.
     *  
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company that owns this DistanceThreshold object.
     * @param int $id The unique ID number of the DistanceThreshold object to replace.
     * @param CompanyDistanceThresholdModel $model The new DistanceThreshold object to store.
     * @return CompanyDistanceThresholdModel
     */
    public function updateDistanceThreshold($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/distancethresholds/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new eCommerce token.
     *
     * Creates a new eCommerce token.
     *  
     * This API is used to create a new eCommerce token. An eCommerce token is required in order to launch the CertCapture eCommerce plugin. Create a token for each of your CertCapture customers.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company ID that will be issued this certificate.
     * @param CreateECommerceTokenInputModel $model 
     * @return ECommerceTokenOutputModel
     */
    public function createECommerceToken($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/ecommercetokens";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Refresh an eCommerce token.
     *
     * Refresh an eCommerce token.
     *  
     * CertCapture eCommerce tokens expire after one hour. This API is used to refresh an eCommerce token that is about to expire. This API can only be used with active tokens. If your token has expired, you must generate a new one.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company ID that the refreshed certificate belongs to.
     * @param RefreshECommerceTokenInputModel $model 
     * @return FetchResult
     */
    public function refreshECommerceToken($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/ecommercetokens";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Add or Edit options
     *
     * Returns a list of options for adding tax forms for the company and tax form code specified.
     * Returns edit options when modifying a filing calendar.
     * This API is available by invitation only.
     * 
     * ### Security Policies
     * 
     * * This API requires openId bearer token for authentication
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID of the company that owns the filing calendar object
     * @param CycleSafeEditRequestModel $model Cycle Safe Options Request
     * @return CycleSafeOptionResultModel
     */
    public function cycleSafeOptions($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/filingcalendars/edit/cycleSafeOptions";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a company return setting
     *
     * This API is available by invitation only and only available for users with Compliance access
     * 
     * ### Security Policies
     * 
     * * This API requires openId bearer token for authentication
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID of the company
     * @param int $filingCalendarId The unique ID of the filing calendar that will remove setting
     * @param int $companyReturnSettingId The unique ID of the company return setting that will be deleted from the filing calendar
     * @return CompanyReturnSettingModel[]
     */
    public function deleteCompanyReturnSettings($companyId, $filingCalendarId, $companyReturnSettingId)    {
        $path = "/api/v2/companies/{$companyId}/filingcalendars/{$filingCalendarId}/setting/{$companyReturnSettingId}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all legacy filing calendars for this company
     *
     * This API is available by invitation only.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these batches
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxTypes, taxAuthorityId, taxAuthorityName, taxAuthorityType, settings
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @param string $returnCountry A comma separated list of countries
     * @param string $returnRegion A comma separated list of regions
     * @return FetchResult
     */
    public function legacyFilingCalendars($companyId, $filter=null, $top=null, $skip=null, $orderBy=null, $returnCountry, $returnRegion)    {
        $path = "/api/v2/companies/{$companyId}/filingcalendars/Legacy";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy, 'returnCountry' => $returnCountry, 'returnRegion' => $returnRegion],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a filing containing the return and all its accrual returns.
     *
     * ### Security Policies
     * 
     * * This API requires openId bearer token for authentication
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these returns
     * @param int $filingReturnId The ID of the filing return
     * @return FetchResult
     */
    public function getAccrualFilings($companyId, $filingReturnId)    {
        $path = "/api/v2/companies/{$companyId}/filings/accrual/{$filingReturnId}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a list of filed returns for the specified company in the year and month of a given filing period.
     *
     * ### Security Policies
     * 
     * * This API requires openId bearer token for authentication
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API is available by invitation only.*Exempt security roles*: ComplianceRootUser, ComplianceAdmin, ComplianceUser, TechnicalSupportAdmin, TechnicalSupportUser, CompanyUser, AccountUser, CompanyAdmin, AccountAdmin.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these batches
     * @param int $endPeriodMonth The month of the period you are trying to retrieve
     * @param int $endPeriodYear The year of the period you are trying to retrieve
     * @param string $frequency The frequency of the return you are trying to retrieve (See FilingFrequencyId::* for a list of allowable values)
     * @param string $status The status of the return(s) you are trying to retrieve (See FilingStatusId::* for a list of allowable values)
     * @param string $country The country of the return(s) you are trying to retrieve
     * @param string $region The region of the return(s) you are trying to retrieve
     * @param int $filingCalendarId The filing calendar id of the return you are trying to retrieve
     * @param string $taxformCode The unique tax form code of the form.
     * @return FetchResult
     */
    public function getFiledReturns($companyId, $endPeriodMonth, $endPeriodYear, $frequency, $status, $country, $region, $filingCalendarId, $taxformCode)    {
        $path = "/api/v2/companies/{$companyId}/filings/returns/filed";
        $guzzleParams = [
            'query' => ['endPeriodMonth' => $endPeriodMonth, 'endPeriodYear' => $endPeriodYear, 'frequency' => $frequency, 'status' => $status, 'country' => $country, 'region' => $region, 'filingCalendarId' => $filingCalendarId, 'taxformCode' => $taxformCode],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Approves linkage to a firm for a client account
     *
     * This API enables the account admin of a client account to approve linkage request by a firm.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return FirmClientLinkageOutputModel
     */
    public function approveFirmClientLinkage($id)    {
        $path = "/api/v2/firmclientlinkages/{$id}/approve";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Request a new FirmClient account and create an approved linkage to it
     *
     * This API is for use by Firms only.
     *  
     * Avalara allows firms to manage returns for clients without the clients needing to use AvaTax service.
     * Firms can create accounts of FirmClient for customers they are managing using this API.
     *  
     * Calling this API creates an account with the specified product subscriptions, but without a new user for account.
     * Account is then linked to the Firm so they can managed their returns.
     * You should call this API when a customer does not have an AvaTax account and is to be managed only by the firm.
     *  
     * The created account will be created in `Active` status but there will be no user or license key associated with account.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SystemAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param NewFirmClientAccountRequestModel $model Information about the account you wish to create.
     * @return FirmClientLinkageOutputModel
     */
    public function createAndLinkNewFirmClientAccount($model)    {
        $path = "/api/v2/firmclientlinkages/createandlinkclient";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Links a firm account with the client account
     *
     * This API enables the firm admins/firm users to request the linkage of a firm account and a client account.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param FirmClientLinkageInputModel $model FirmClientLinkageInputModel
     * @return FirmClientLinkageOutputModel
     */
    public function createFirmClientLinkage($model)    {
        $path = "/api/v2/firmclientlinkages";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a linkage
     *
     * This API marks a linkage between a firm and client as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return ErrorDetail[]
     */
    public function deleteFirmClientLinkage($id)    {
        $path = "/api/v2/firmclientlinkages/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Get linkage between a firm and client by id
     *
     * This API enables the firm admins/firm users to request the linkage of a firm account and a client account.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return FirmClientLinkageOutputModel
     */
    public function getFirmClientLinkage($id)    {
        $path = "/api/v2/firmclientlinkages/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List client linkages for a firm or client
     *
     * This API enables the firm or account users to request the associated linkages to the account.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* firmAccountName, clientAccountName
     * @return FetchResult
     */
    public function listFirmClientLinkage($filter=null)    {
        $path = "/api/v2/firmclientlinkages";
        $guzzleParams = [
            'query' => ['$filter' => $filter],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Rejects linkage to a firm for a client account
     *
     * This API enables the account admin of a client account to reject linkage request by a firm.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return FirmClientLinkageOutputModel
     */
    public function rejectFirmClientLinkage($id)    {
        $path = "/api/v2/firmclientlinkages/{$id}/reject";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Reset linkage status between a client and firm back to requested
     *
     * This API enables the firm admin of a client account to reset a previously created linkage request by a firm.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return FirmClientLinkageOutputModel
     */
    public function resetFirmClientLinkage($id)    {
        $path = "/api/v2/firmclientlinkages/{$id}/reset";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Revokes previously approved linkage to a firm for a client account
     *
     * This API enables the account admin of a client account to revoke a previously approved linkage request by a firm.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id 
     * @return FirmClientLinkageOutputModel
     */
    public function revokeFirmClientLinkage($id)    {
        $path = "/api/v2/firmclientlinkages/{$id}/revoke";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * FREE API - Request a free trial of AvaTax
     *
     * Call this API to obtain a free AvaTax account.
     *  
     * This API is free to use. No authentication credentials are required to call this API. You must read and
     * accept [Avalara's terms and conditions](https://www1.avalara.com/us/en/legal/terms.html) for the account to be
     * created.
     *  
     * If all conditions are met, this API will grant a free trial version of AvaTax. For a list of functionality
     * available in the free trial and its limitations, please see the [AvaTax Developer Website Free Trial page](https://developer.avalara.com/avatax/signup/).
     *  
     * After your free trial concludes, you will still be able to use the [Free AvaTax API Suite](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Free/).
     * 
     * ### Security Policies
     * 
     * * This API may be called without providing authentication credentials.
     * Swagger Name: AvaTaxClient
     * 
     * @param FreeTrialRequestModel $model Required information to provision a free trial account.
     * @return NewAccountModel
     */
    public function requestFreeTrial($model)    {
        $path = "/api/v2/accounts/freetrials/request";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Request the javascript for a funding setup widget
     *
     * This API is available by invitation only.
     * Companies that use the Avalara Managed Returns or the SST Certified Service Provider services are
     * required to setup their funding configuration before Avalara can begin filing tax returns on their
     * behalf.
     * Funding configuration for each company is set up by submitting a funding setup request, which can
     * be sent either via email or via an embedded HTML widget.
     * When the funding configuration is submitted to Avalara, it will be reviewed by treasury team members
     * before approval.
     * This API returns back the actual javascript code to insert into your application to render the
     * JavaScript funding setup widget inline.
     * Use the 'methodReturn.javaScript' return value to insert this widget into your HTML page.
     * This API requires a subscription to Avalara Managed Returns or SST Certified Service Provider.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique ID number of this funding request
     * @return FundingStatusModel
     */
    public function activateFundingRequest($id)    {
        $path = "/api/v2/fundingrequests/{$id}/widget";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve status about a funding setup request
     *
     * This API is available by invitation only.
     * Companies that use the Avalara Managed Returns or the SST Certified Service Provider services are
     * required to setup their funding configuration before Avalara can begin filing tax returns on their
     * behalf.
     * Funding configuration for each company is set up by submitting a funding setup request, which can
     * be sent either via email or via an embedded HTML widget.
     * When the funding configuration is submitted to Avalara, it will be reviewed by treasury team members
     * before approval.
     * This API checks the status on an existing funding request.
     * This API requires a subscription to Avalara Managed Returns or SST Certified Service Provider.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique ID number of this funding request
     * @return FundingStatusModel
     */
    public function fundingRequestStatus($id)    {
        $path = "/api/v2/fundingrequests/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete all classifications for an item
     *
     * Delete all the classifications for a given item.
     *  
     * A classification is the code for a product in a particular tax system. Classifications enable an item to be used in multiple tax systems which may have different tax rates for a product.
     *  
     * When an item is used in a transaction, the applicable classification will be used to determine the appropriate tax rate.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this item.
     * @param int $itemId The ID of the item you wish to delete the classifications.
     * @return ErrorDetail[]
     */
    public function batchDeleteItemClassifications($companyId, $itemId)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/classifications";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete all parameters for an item
     *
     * Delete all the parameters for a given item.
     *  
     * Some items can be taxed differently depending on the properties of that item, such as the item grade or by a particular measurement of that item. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an item will be used by default in tax calculation but will not show on the transaction line referencing the item .
     *  
     * A parameter specified on a transaction line will override an item parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this item.
     * @param int $itemId The ID of the item you wish to delete the parameters.
     * @return ErrorDetail[]
     */
    public function batchDeleteItemParameters($companyId, $itemId)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/parameters";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Bulk upload items from a product catalog
     *
     * Create/Update one or more item objects attached to this company.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     *  
     * The tax code takes precedence over the tax code id if both are provided.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this items.
     * @param ItemBulkUploadInputModel $model The items you wish to upload.
     * @return ItemBulkUploadOutputModel
     */
    public function bulkUploadItems($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/upload";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Add classifications to an item.
     *
     * Add classifications to an item.
     *  
     * A classification is the code for a product in a particular tax system. Classifications enable an item to be used in multiple tax systems which may have different tax rates for a product.
     *  
     * When an item is used in a transaction, the applicable classification will be used to determine the appropriate tax rate.
     *  
     * An item may only have one classification per tax system.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $itemId The item id.
     * @param ItemClassificationInputModel[] $model The item classifications you wish to create.
     * @return ItemClassificationOutputModel[]
     */
    public function createItemClassifications($companyId, $itemId, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/classifications";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Add parameters to an item.
     *
     * Add parameters to an item.
     *  
     * Some items can be taxed differently depending on the properties of that item, such as the item grade or by a particular measurement of that item. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an item will be used by default in tax calculation but will not show on the transaction line referencing the item .
     *  
     * A parameter specified on a transaction line will override an item parameter if they share the same parameter name.
     *  
     * To see available parameters for this item, call `/api/v2/definitions/parameters?$filter=attributeType eq Product`
     *  
     * Some parameters are only available for use if you have subscribed to specific AvaTax services. To see which parameters you are able to use, add the query parameter "$showSubscribed=true" to the parameter definition call above.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this item parameter.
     * @param int $itemId The item id.
     * @param ItemParameterModel[] $model The item parameters you wish to create.
     * @return ItemParameterModel[]
     */
    public function createItemParameters($companyId, $itemId, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/parameters";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new item
     *
     * Creates one or more new item objects attached to this company.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     *  
     * The tax code takes precedence over the tax code id if both are provided.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this item.
     * @param ItemModel[] $model The item you wish to create.
     * @return ItemModel[]
     */
    public function createItems($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/items";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create tags for a item
     *
     * Creates one or more new `Tag` objects attached to this Item.
     *  
     * Item tags puts multiple labels for an item. So that item can be easily grouped by these tags.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that defined these items
     * @param int $itemId The ID of the item as defined by the company that owns this tag.
     * @param ItemTagDetailModel[] $model Tags you wish to associate with the Item
     * @return ItemTagDetailModel[]
     */
    public function createItemTags($companyId, $itemId, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/tags";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single item
     *
     * Deletes the item object at this URL.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     *  
     * Deleting an item will also delete the parameters and classifications associated with that item.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this item.
     * @param int $id The ID of the item you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteItem($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/items/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single item classification.
     *
     * Delete a single item classification.
     *  
     * A classification is the code for a product in a particular tax system. Classifications enable an item to be used in multiple tax systems which may have different tax rates for a product.
     *  
     * When an item is used in a transaction, the applicable classification will be used to determine the appropriate tax rate.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $itemId The item id.
     * @param int $id The item classification id.
     * @return ErrorDetail[]
     */
    public function deleteItemClassification($companyId, $itemId, $id)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/classifications/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single item parameter
     *
     * Delete a single item parameter.
     *  
     * Some items can be taxed differently depending on the properties of that item, such as the item grade or by a particular measurement of that item. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an item will be used by default in tax calculation but will not show on the transaction line referencing the item .
     *  
     * A parameter specified on a transaction line will override an item parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $itemId The item id
     * @param int $id The parameter id
     * @return ErrorDetail[]
     */
    public function deleteItemParameter($companyId, $itemId, $id)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete item tag by id
     *
     * Deletes the `Tag` object of an Item at this URL.
     *  
     * Item tags puts multiple labels for an item. So that item can be easily grouped by these tags.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that defined these items
     * @param int $itemId The ID of the item as defined by the company that owns this tag.
     * @param int $itemTagDetailId The ID of the item tag detail you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteItemTag($companyId, $itemId, $itemTagDetailId)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/tags/{$itemTagDetailId}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete all item tags
     *
     * Deletes all `Tags` objects of an Item at this URL.
     *  
     * Item tags puts multiple labels for an item. So that item can be easily grouped by these tags.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that defined these items.
     * @param int $itemId The ID of the item as defined by the company that owns this tag.
     * @return ErrorDetail[]
     */
    public function deleteItemTags($companyId, $itemId)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/tags";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single item
     *
     * Get the `Item` object identified by this URL.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this item object
     * @param int $id The primary key of this item
     * @param string $include A comma separated list of additional data to retrieve.
     * @return ItemModel
     */
    public function getItem($companyId, $id, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/items/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single item classification.
     *
     * Retrieve a single item classification.
     *  
     * A classification is the code for a product in a particular tax system. Classifications enable an item to be used in multiple tax systems which may have different tax rates for a product.
     *  
     * When an item is used in a transaction, the applicable classification will be used to determine the appropriate tax rate.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $itemId The item id.
     * @param int $id The item classification id.
     * @return ItemClassificationOutputModel
     */
    public function getItemClassification($companyId, $itemId, $id)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/classifications/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single item parameter
     *
     * Retrieve a single item parameter.
     *  
     * Some items can be taxed differently depending on the properties of that item, such as the item grade or by a particular measurement of that item. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an item will be used by default in tax calculation but will not show on the transaction line referencing the item .
     *  
     * A parameter specified on a transaction line will override an item parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $itemId The item id
     * @param int $id The parameter id
     * @return ItemParameterModel
     */
    public function getItemParameter($companyId, $itemId, $id)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve tags for an item
     *
     * Get the `Tag` objects of an Item identified by this URL.
     *  
     * Item tags puts multiple labels for an item. So that item can be easily grouped by these tags.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that defined these items
     * @param int $itemId The ID of the item as defined by the company that owns this tag.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* tagName
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @return FetchResult
     */
    public function getItemTags($companyId, $itemId, $filter=null, $top=null, $skip=null)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/tags";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve classifications for an item.
     *
     * List classifications for an item.
     *  
     * A classification is the code for a product in a particular tax system. Classifications enable an item to be used in multiple tax systems which may have different tax rates for a product.
     *  
     * When an item is used in a transaction, the applicable classification will be used to determine the appropriate tax rate.
     *  
     * Search for specific objects using the criteria in the `$filter` classification; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` classifications.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $itemId The item id.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* productCode, systemCode
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listItemClassifications($companyId, $itemId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/classifications";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve parameters for an item
     *
     * List parameters for an item.
     *  
     * Some items can be taxed differently depending on the properties of that item, such as the item grade or by a particular measurement of that item. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an item will be used by default in tax calculation but will not show on the transaction line referencing the item .
     *  
     * A parameter specified on a transaction line will override an item parameter if they share the same parameter name.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $itemId The item id
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* name, unit, isNeededForCalculation, isNeededForReturns, isNeededForClassification
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listItemParameters($companyId, $itemId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/parameters";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve items for this company
     *
     * List all items defined for the current company.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     *  
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * You may specify Tag Name in the `tagName` query parameter if you want to filter items on the basis of tagName
     * 
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Parameters
     * * Classifications
     * * Tags
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that defined these items
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxCode, classifications, parameters, tags
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @param string $tagName Tag Name on the basis of which you want to filter Items
     * @return FetchResult
     */
    public function listItemsByCompany($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null, $tagName)    {
        $path = "/api/v2/companies/{$companyId}/items";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy, 'tagName' => $tagName],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all items
     *
     * Get multiple item objects across all companies.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     *  
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxCode, classifications, parameters, tags
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryItems($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/items";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all items associated with given tag
     *
     * Get multiple item objects associated with given tag.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     *  
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that defined these items.
     * @param string $tag The master tag to be associated with item.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxCode, classifications, parameters, tags
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryItemsByTag($companyId, $tag, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/items/bytags/{$tag}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Sync items from a product catalog
     *
     * Syncs a list of items with AvaTax without waiting for them to be created. It is ideal for syncing large product catalogs
     * with AvaTax.
     *  
     * Any invalid or duplicate items will be ignored. To diagnose why an item is not created, use the normal create transaction API to receive validation information.
     *  
     * This API is currently limited to 1000 items per call (the limit is subject to change).
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this item.
     * @param SyncItemsRequestModel $model The request object.
     * @return SyncItemsResponseModel
     */
    public function syncItems($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/sync";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single item
     *
     * Replace the existing `Item` object at this URL with an updated object.
     *  
     * Items are a way of separating your tax calculation process from your tax configuration details. If you choose, you
     * can provide `itemCode` values for each `CreateTransaction()` API call rather than specifying tax codes, parameters, descriptions,
     * and other data fields. AvaTax will automatically look up each `itemCode` and apply the correct tax codes and parameters
     * from the item table instead. This allows your CreateTransaction call to be as simple as possible, and your tax compliance
     * team can manage your item catalog and adjust the tax behavior of items without having to modify your software.
     *  
     * All data from the existing object will be replaced with data in the object you PUT. To set a field's value to null,
     * you may either set its value to null or omit that field from the object you post.
     *  
     * The tax code takes precedence over the tax code id if both are provided.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this item belongs to.
     * @param int $id The ID of the item you wish to update
     * @param ItemModel $model The item object you wish to update.
     * @return ItemModel
     */
    public function updateItem($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Update an item classification.
     *
     * Update an item classification.
     *  
     * A classification is the code for a product in a particular tax system. Classifications enable an item to be used in multiple tax systems which may have different tax rates for a product.
     *  
     * When an item is used in a transaction, the applicable classification will be used to determine the appropriate tax rate.
     *  
     * An item may only have one classification per tax system.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $itemId The item id.
     * @param int $id The item classification id.
     * @param ItemClassificationInputModel $model The item object you wish to update.
     * @return ItemClassificationOutputModel
     */
    public function updateItemClassification($companyId, $itemId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/classifications/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Update an item parameter
     *
     * Update an item parameter.
     *  
     * Some items can be taxed differently depending on the properties of that item, such as the item grade or by a particular measurement of that item. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an item will be used by default in tax calculation but will not show on the transaction line referencing the item .
     *  
     * A parameter specified on a transaction line will override an item parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $itemId The item id
     * @param int $id The item parameter id
     * @param ItemParameterModel $model The item object you wish to update.
     * @return ItemParameterModel
     */
    public function updateItemParameter($companyId, $itemId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/items/{$itemId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Create one or more overrides
     *
     * Creates one or more jurisdiction override objects for this account.
     *  
     * A Jurisdiction Override is a configuration setting that allows you to select the taxing
     * jurisdiction for a specific address. If you encounter an address that is on the boundary
     * between two different jurisdictions, you can choose to set up a jurisdiction override
     * to switch this address to use different taxing jurisdictions.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns this override
     * @param JurisdictionOverrideModel[] $model The jurisdiction override objects to create
     * @return JurisdictionOverrideModel[]
     */
    public function createJurisdictionOverrides($accountId, $model)    {
        $path = "/api/v2/accounts/{$accountId}/jurisdictionoverrides";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single override
     *
     * Marks the item object at this URL as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns this override
     * @param int $id The ID of the override you wish to delete
     * @return ErrorDetail[]
     */
    public function deleteJurisdictionOverride($accountId, $id)    {
        $path = "/api/v2/accounts/{$accountId}/jurisdictionoverrides/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single override
     *
     * Get the item object identified by this URL.
     *  
     * A Jurisdiction Override is a configuration setting that allows you to select the taxing
     * jurisdiction for a specific address. If you encounter an address that is on the boundary
     * between two different jurisdictions, you can choose to set up a jurisdiction override
     * to switch this address to use different taxing jurisdictions.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns this override
     * @param int $id The primary key of this override
     * @return JurisdictionOverrideModel
     */
    public function getJurisdictionOverride($accountId, $id)    {
        $path = "/api/v2/accounts/{$accountId}/jurisdictionoverrides/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve overrides for this account
     *
     * List all jurisdiction override objects defined for this account.
     *  
     * A Jurisdiction Override is a configuration setting that allows you to select the taxing
     * jurisdiction for a specific address. If you encounter an address that is on the boundary
     * between two different jurisdictions, you can choose to set up a jurisdiction override
     * to switch this address to use different taxing jurisdictions.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns this override
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* country, Jurisdictions
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listJurisdictionOverridesByAccount($accountId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/accounts/{$accountId}/jurisdictionoverrides";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all overrides
     *
     * Get multiple jurisdiction override objects across all companies.
     *  
     * A Jurisdiction Override is a configuration setting that allows you to select the taxing
     * jurisdiction for a specific address. If you encounter an address that is on the boundary
     * between two different jurisdictions, you can choose to set up a jurisdiction override
     * to switch this address to use different taxing jurisdictions.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* country, Jurisdictions
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryJurisdictionOverrides($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/jurisdictionoverrides";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single jurisdictionoverride
     *
     * Replace the existing jurisdictionoverride object at this URL with an updated object.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that this jurisdictionoverride belongs to.
     * @param int $id The ID of the jurisdictionoverride you wish to update
     * @param JurisdictionOverrideModel $model The jurisdictionoverride object you wish to update.
     * @return JurisdictionOverrideModel
     */
    public function updateJurisdictionOverride($accountId, $id, $model)    {
        $path = "/api/v2/accounts/{$accountId}/jurisdictionoverrides/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Add parameters to a location.
     *
     * Add parameters to a location.
     *  
     * Some locations can be taxed differently depending on the properties of that location. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a location will be used by default in tax calculation but will not show on the transaction line referencing the location.
     *  
     * A parameter specified on a transaction line will override a location parameter if they share the same parameter name.
     *  
     * To see available parameters for this location, call `/api/v2/definitions/parameters?$filter=attributeType eq Company`
     *  
     * Some parameters are only available for use if you have subscribed to specific AvaTax services. To see which parameters you are able to use, add the query parameter "$showSubscribed=true" to the parameter definition call above.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this location parameter.
     * @param int $locationId The location id.
     * @param LocationParameterModel[] $model The location parameters you wish to create.
     * @return LocationParameterModel[]
     */
    public function createLocationParameters($companyId, $locationId, $model)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$locationId}/parameters";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new location
     *
     * Create one or more new location objects attached to this company.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this location.
     * @param LocationModel[] $model The location you wish to create.
     * @return LocationModel[]
     */
    public function createLocations($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/locations";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single location
     *
     * Mark the location object at this URL as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this location.
     * @param int $id The ID of the location you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteLocation($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single location parameter
     *
     * Delete a single location parameter.
     *  
     * Some locations can be taxed differently depending on the properties of that location. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a location will be used by default in tax calculation but will not show on the transaction line referencing the location.
     *  
     * A parameter specified on a transaction line will override a location parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $locationId The location id
     * @param int $id The parameter id
     * @return ErrorDetail[]
     */
    public function deleteLocationParameter($companyId, $locationId, $id)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$locationId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single location
     *
     * Get the location object identified by this URL.
     * An 'Location' represents a physical address where a company does business.
     * Many taxing authorities require that you define a list of all locations where your company does business.
     * These locations may require additional custom configuration or tax registration with these authorities.
     * For more information on metadata requirements, see the '/api/v2/definitions/locationquestions' API.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * LocationSettings
     * * parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this location
     * @param int $id The primary key of this location
     * @param string $include A comma separated list of additional data to retrieve.
     * @return LocationModel
     */
    public function getLocation($companyId, $id, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single company location parameter
     *
     * Retrieve a single location parameter.
     *  
     * Some locations can be taxed differently depending on the properties of that location. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a location will be used by default in tax calculation but will not show on the transaction line referencing the location.
     *  
     * A parameter specified on a transaction line will override a location parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $locationId The location id
     * @param int $id The parameter id
     * @return LocationParameterModel
     */
    public function getLocationParameter($companyId, $locationId, $id)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$locationId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve parameters for a location
     *
     * List parameters for a location.
     *  
     * Some locations can be taxed differently depending on the properties of that location. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a location will be used by default in tax calculation but will not show on the transaction line referencing the location.
     *  
     * A parameter specified on a transaction line will override a location parameter if they share the same parameter name.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $locationId The ID of the location
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* name, unit
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listLocationParameters($companyId, $locationId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$locationId}/parameters";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve locations for this company
     *
     * List all location objects defined for this company.
     * An 'Location' represents a physical address where a company does business.
     * Many taxing authorities require that you define a list of all locations where your company does business.
     * These locations may require additional custom configuration or tax registration with these authorities.
     * For more information on metadata requirements, see the '/api/v2/definitions/locationquestions' API.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * LocationSettings
     * * parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these locations
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* isMarketplaceOutsideUsa, settings, parameters
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listLocationsByCompany($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/locations";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all locations
     *
     * Get multiple location objects across all companies.
     * An 'Location' represents a physical address where a company does business.
     * Many taxing authorities require that you define a list of all locations where your company does business.
     * These locations may require additional custom configuration or tax registration with these authorities.
     * For more information on metadata requirements, see the '/api/v2/definitions/locationquestions' API.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * LocationSettings
     * * parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* isMarketplaceOutsideUsa, settings, parameters
     * @param string $include A comma separated list of additional data to retrieve. You may specify `LocationSettings` to retrieve location settings.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryLocations($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/locations";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single location
     *
     * Replace the existing location object at this URL with an updated object.
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this location belongs to.
     * @param int $id The ID of the location you wish to update
     * @param LocationModel $model The location you wish to update.
     * @return LocationModel
     */
    public function updateLocation($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a location parameter
     *
     * Update a location parameter.
     *  
     * Some locations can be taxed differently depending on the properties of that location. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a location will be used by default in tax calculation but will not show on the transaction line referencing the location.
     *  
     * A parameter specified on a transaction line will override a location parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPAdmin, CSPTester, FirmAdmin, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $locationId The location id
     * @param int $id The location parameter id
     * @param LocationParameterModel $model The location parameter object you wish to update.
     * @return LocationParameterModel
     */
    public function updateLocationParameter($companyId, $locationId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$locationId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Validate the location against local requirements
     *
     * Returns validation information for this location.
     * This API call is intended to compare this location against the currently known taxing authority rules and regulations,
     * and provide information about what additional work is required to completely setup this location.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this location
     * @param int $id The primary key of this location
     * @return LocationValidationModel
     */
    public function validateLocation($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$id}/validate";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Adjust a MultiDocument transaction
     *
     * Adjusts the current MultiDocument transaction uniquely identified by this URL.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * When you adjust a transaction, that transaction's status is recorded as `Adjusted`.
     *  
     * Both the revisions will be available for retrieval based on their code and ID numbers. Only transactions in Committed status can be reported on a tax filing by Avalara's Managed Returns Service.
     *  
     * Transactions that have been previously reported to a tax authority by Avalara Managed Returns are considered locked and are no longer available for adjustments.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $code The transaction code for this MultiDocument transaction
     * @param string $type The transaction type for this MultiDocument transaction (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param AdjustMultiDocumentModel $model The adjust request you wish to execute
     * @return MultiDocumentModel
     */
    public function adjustMultiDocumentTransaction($code, $type, $include=null, $model)    {
        $path = "/api/v2/transactions/multidocument/{$code}/type/{$type}/adjust";
        $guzzleParams = [
            'query' => ['include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Get audit information about a MultiDocument transaction
     *
     * Retrieve audit information about a MultiDocument transaction stored in AvaTax.
     *  
     * The audit API retrieves audit information related to a specific MultiDocument transaction. This audit
     * information includes the following:
     *  
     * * The `code` of the MultiDocument transaction
     * * The `type` of the MultiDocument transaction
     * * The server timestamp representing the exact server time when the transaction was created
     * * The server duration - how long it took to process this transaction
     * * Whether exact API call details were logged
     * * A reconstructed API call showing what the original create call looked like
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $code The transaction code for this MultiDocument transaction
     * @param string $type The transaction type for this MultiDocument transaction (See DocumentType::* for a list of allowable values)
     * @return AuditMultiDocumentModel
     */
    public function auditMultiDocumentTransaction($code, $type)    {
        $path = "/api/v2/transactions/multidocument/{$code}/type/{$type}/audit";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Commit a MultiDocument transaction
     *
     * Marks a list of transactions by changing its status to `Committed`.
     *  
     * Transactions that are committed are available to be reported to a tax authority by Avalara Managed Returns.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * Any changes made to a committed transaction will generate a transaction history.
     * 
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, ProStoresOperator, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param CommitMultiDocumentModel $model The commit request you wish to execute
     * @return MultiDocumentModel
     */
    public function commitMultiDocumentTransaction($model)    {
        $path = "/api/v2/transactions/multidocument/commit";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new MultiDocument transaction
     *
     * Records a new MultiDocument transaction in AvaTax.
     *  
     * A traditional transaction requires exactly two parties: a seller and a buyer. MultiDocument transactions can
     * involve a marketplace of vendors, each of which contributes some portion of the final transaction. Within
     * a MultiDocument transaction, each individual buyer and seller pair are matched up and converted to a separate
     * document. This separation of documents allows each seller to file their taxes separately.
     *  
     * This API will report an error if you attempt to create a transaction when one already exists with the specified `code`.
     * If you would like the API to automatically update the transaction when it already exists, please set the `allowAdjust`
     * value to `true`.
     *  
     * To generate a refund for a transaction, use the `RefundTransaction` API.
     *  
     * The field `type` identifies the kind of transaction - for example, a sale, purchase, or refund. If you do not specify
     * a `type` value, you will receive an estimate of type `SalesOrder`, which will not be recorded.
     *  
     * The origin and destination locations for a transaction must be identified by either address or geocode. For address-based transactions, please
     * provide addresses in the fields `line`, `city`, `region`, `country` and `postalCode`. For geocode-based transactions, please provide the geocode
     * information in the fields `latitude` and `longitude`. If either `latitude` or `longitude` or both are null, the transaction will be calculated
     * using the best available address location information.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * ForceTimeout - Simulates a timeout. This adds a 30 second delay and error to your API call. This can be used to test your code to ensure it can respond correctly in the case of a dropped connection.
     *  
     * If you omit the `$include` parameter, the API will assume you want `Summary,Addresses`.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param CreateMultiDocumentModel $model the multi document transaction model
     * @return MultiDocumentModel
     */
    public function createMultiDocumentTransaction($include=null, $model)    {
        $path = "/api/v2/transactions/multidocument";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a MultiDocument transaction
     *
     * Get the current MultiDocument transaction identified by this URL.
     *  
     * If this transaction was adjusted, the return value of this API will be the current transaction with this code.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $code The multidocument code to retrieve
     * @param string $type The transaction type to retrieve (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in the response after transaction is created
     * @return MultiDocumentModel
     */
    public function getMultiDocumentTransactionByCodeAndType($code, $type, $include=null)    {
        $path = "/api/v2/transactions/multidocument/{$code}/type/{$type}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a MultiDocument transaction by ID
     *
     * Get the unique MultiDocument transaction identified by this URL.
     *  
     * A traditional transaction requires exactly two parties: a seller and a buyer. MultiDocument transactions can
     * involve a marketplace of vendors, each of which contributes some portion of the final transaction. Within
     * a MultiDocument transaction, each individual buyer and seller pair are matched up and converted to a separate
     * document. This separation of documents allows each seller to file their taxes separately.
     *  
     * This endpoint retrieves the exact transaction identified by this ID number even if that transaction was later adjusted
     * by using the `AdjustTransaction` endpoint.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique ID number of the MultiDocument transaction to retrieve
     * @param string $include Specifies objects to include in the response after transaction is created
     * @return MultiDocumentModel
     */
    public function getMultiDocumentTransactionById($id, $include=null)    {
        $path = "/api/v2/transactions/multidocument/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all MultiDocument transactions
     *
     * List all MultiDocument transactions within this account.
     *  
     * This endpoint is limited to returning 1,000 MultiDocument transactions at a time. To retrieve more than 1,000 MultiDocument
     * transactions, please use the pagination features of the API.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* documents
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listMultiDocumentTransactions($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/transactions/multidocument";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a refund for a MultiDocument transaction
     *
     * Create a refund for a MultiDocument transaction.
     *  
     * A traditional transaction requires exactly two parties: a seller and a buyer. MultiDocument transactions can
     * involve a marketplace of vendors, each of which contributes some portion of the final transaction. Within
     * a MultiDocument transaction, each individual buyer and seller pair are matched up and converted to a separate
     * document. This separation of documents allows each seller to file their taxes separately.
     *  
     * The `RefundTransaction` API allows you to quickly and easily create a `ReturnInvoice` representing a refund
     * for a previously created `SalesInvoice` transaction. You can choose to create a full or partial refund, and
     * specify individual line items from the original sale for refund.
     *  
     * The `RefundTransaction` API ensures that the tax amount you refund to the customer exactly matches the tax that
     * was calculated during the original transaction, regardless of any changes to your company's configuration, rules,
     * nexus, or any other setting.
     *  
     * This API is intended to be a shortcut to allow you to quickly and accurately generate a refund for the following
     * common refund scenarios:
     *  
     * * A full refund of a previous sale
     * * Refunding the tax that was charged on a previous sale, when the customer provides an exemption certificate after the purchase
     * * Refunding one or more items (lines) from a previous sale
     * * Granting a customer a percentage refund of a previous sale
     *  
     * For more complex scenarios than the ones above, please use `CreateTransaction` with document type `ReturnInvoice` to
     * create a custom refund transaction.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     * If you omit the `$include` parameter, the API will assume you want `Summary,Addresses`.
     * 
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $code The code of this MultiDocument transaction
     * @param string $type The type of this MultiDocument transaction (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param RefundTransactionModel $model Information about the refund to create
     * @return MultiDocumentModel
     */
    public function refundMultiDocumentTransaction($code, $type, $include=null, $model)    {
        $path = "/api/v2/transactions/multidocument/{$code}/type/{$type}/refund";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Verify a MultiDocument transaction
     *
     * Verifies that the MultiDocument transaction uniquely identified by this URL matches certain expected values.
     *  
     * If the transaction does not match these expected values, this API will return an error code indicating which value did not match.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param VerifyMultiDocumentModel $model Information from your accounting system to verify against this MultiDocument transaction as it is stored in AvaTax
     * @return MultiDocumentModel
     */
    public function verifyMultiDocumentTransaction($model)    {
        $path = "/api/v2/transactions/multidocument/verify";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Void a MultiDocument transaction
     *
     * Voids the current transaction uniquely identified by this URL.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * When you void a transaction, that transaction's status is recorded as `DocVoided`.
     *  
     * Transactions that have been previously reported to a tax authority by Avalara Managed Returns Service are considered `locked`,
     * and they are no longer available to be voided.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, ProStoresOperator, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $code The transaction code for this MultiDocument transaction
     * @param string $type The transaction type for this MultiDocument transaction (See DocumentType::* for a list of allowable values)
     * @param VoidTransactionModel $model The void request you wish to execute
     * @return MultiDocumentModel
     */
    public function voidMultiDocumentTransaction($code, $type, $model)    {
        $path = "/api/v2/transactions/multidocument/{$code}/type/{$type}/void";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new nexus
     *
     * Creates one or more new nexus declarations attached to this company.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * To create a nexus declaration for your company, you must first call the Definitions API `ListNexus` to obtain a
     * list of Avalara-defined nexus. Once you have determined which nexus you wish to declare, you should customize
     * only the user-selectable fields in this object.
     *  
     * The user selectable fields for the nexus object are `companyId`, `effectiveDate`, `endDate`, `localNexusTypeId`,
     * `taxId`, `nexusTypeId`, `hasPermanentEstablishment`, and `isSellerImporterOfRecord`.
     *  
     * When calling `CreateNexus` or `UpdateNexus`, all values in your nexus object except for the user-selectable fields
     * must match an Avalara-defined system nexus object. You can retrieve a list of Avalara-defined system nexus objects
     * by calling `ListNexus`. If any data does not match, AvaTax may not recognize your nexus declaration.
     *  
     * Please note that nexus changes may not take effect immediately and you should plan to update your nexus settings in advance
     * of calculating tax for a location.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this nexus.
     * @param NexusModel[] $model The nexus you wish to create.
     * @return NexusModel[]
     */
    public function createNexus($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/nexus";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Add parameters to a nexus.
     *
     * Add parameters to the nexus.
     * Some tax calculation and reporting are different depending on the properties of the nexus, such as isRemoteSeller. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an nexus will be used by default in tax calculation but will not show on the transaction line referencing the nexus.
     *  
     * A parameter specified on a transaction line will override an nexus parameter if they share the same parameter name.
     *  
     * To see available parameters for this item, call `/api/v2/definitions/parameters?$filter=attributeType eq Nexus`
     *  
     * Some parameters are only available for use if you have subscribed to specific AvaTax services. To see which parameters you are able to use, add the query parameter "$showSubscribed=true" to the parameter definition call above.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this nexus parameter.
     * @param int $nexusId The nexus id.
     * @param NexusParameterDetailModel[] $model The nexus parameters you wish to create.
     * @return NexusParameterDetailModel[]
     */
    public function createNexusParameters($companyId, $nexusId, $model)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$nexusId}/parameters";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Creates nexus for a list of addresses.
     *
     * This call is intended to simplify adding all applicable nexus to a company, for an address or addresses. Calling this
     * API declares nexus for this company, for the list of addresses provided,
     * for the date range provided. You may also use this API to extend effective date on an already-declared nexus.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * Note that not all fields within a nexus can be updated; Avalara publishes a list of all defined nexus at the
     * '/api/v2/definitions/nexus' endpoint.
     *  
     * You may only define nexus matching the official list of declared nexus.
     *  
     * Please note that nexus changes may not take effect immediately and you should plan to update your nexus settings in advance
     * of calculating tax for a location.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that will own this nexus.
     * @param DeclareNexusByAddressModel[] $model The nexus you wish to create.
     * @return NexusByAddressModel[]
     */
    public function declareNexusByAddress($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/nexus/byaddress";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single nexus
     *
     * Marks the existing nexus object at this URL as deleted.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * Please note that nexus changes may not take effect immediately and you should plan to update your nexus settings in advance
     * of calculating tax for a location.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this nexus.
     * @param int $id The ID of the nexus you wish to delete.
     * @param boolean $cascadeDelete If true, deletes all the child nexus if they exist along with parent nexus
     * @return ErrorDetail[]
     */
    public function deleteNexus($companyId, $id, $cascadeDelete)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$id}";
        $guzzleParams = [
            'query' => ['cascadeDelete' => $cascadeDelete],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single nexus parameter
     *
     * Delete a single nexus parameter.
     * Some tax calculation and reporting are different depending on the properties of the nexus, such as isRemoteSeller. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an nexus will be used by default in tax calculation but will not show on the transaction line referencing the nexus.
     *  
     * A parameter specified on a transaction line will override an nexus parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $nexusId The nexus id
     * @param int $id The parameter id
     * @return ErrorDetail[]
     */
    public function deleteNexusParameter($companyId, $nexusId, $id)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$nexusId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete all parameters for an nexus
     *
     * Delete all the parameters for a given nexus.
     * Some tax calculation and reporting are different depending on the properties of the nexus, such as isRemoteSeller. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an nexus will be used by default in tax calculation but will not show on the transaction line referencing the nexus.
     *  
     * A parameter specified on a transaction line will override an nexus parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this nexus.
     * @param int $nexusId The ID of the nexus you wish to delete the parameters.
     * @return ErrorDetail[]
     */
    public function deleteNexusParameters($companyId, $nexusId)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$nexusId}/parameters";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single nexus
     *
     * Get the nexus object identified by this URL.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     * You may specify one or more of the following values in the '$include' parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this nexus object
     * @param int $id The primary key of this nexus
     * @param string $include 
     * @return NexusModel
     */
    public function getNexus($companyId, $id, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List company nexus related to a tax form
     *
     * Retrieves a list of nexus related to a tax form.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * This API is intended to provide useful information when examining a tax form. If you are about to begin filing
     * a tax form, you may want to know whether you have declared nexus in all the jurisdictions related to that tax
     * form in order to better understand how the form will be filled out.
     * You may specify one or more of the following values in the '$include' parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this nexus object
     * @param string $formCode The form code that we are looking up the nexus for
     * @param string $include 
     * @return NexusByTaxFormModel
     */
    public function getNexusByFormCode($companyId, $formCode, $include=null)    {
        $path = "/api/v2/companies/{$companyId}/nexus/byform/{$formCode}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single nexus parameter
     *
     * Retrieve a single nexus parameter.
     * Some tax calculation and reporting are different depending on the properties of the nexus, such as isRemoteSeller.In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an nexus will be used by default in tax calculation but will not show on the transaction line referencing the nexus.
     *  
     * A parameter specified on a transaction line will override an nexus parameter if they share the same parameter name.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $nexusId The nexus id
     * @param int $id The parameter id
     * @return NexusParameterDetailModel
     */
    public function getNexusParameter($companyId, $nexusId, $id)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$nexusId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve nexus for this company
     *
     * List all nexus objects defined for this company.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * You may specify one or more of the following values in the '$include' parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these nexus objects
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusByCompany($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/nexus";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve nexus for this company By TaxTypeGroup
     *
     * List all nexus objects defined for this company filtered by TaxTypeGroup.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * You may specify one or more of the following values in the '$include' parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these nexus objects
     * @param string $taxTypeGroup Name of TaxTypeGroup to filter by
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusByCompanyAndTaxTypeGroup($companyId, $taxTypeGroup, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/nexus/byTaxTypeGroup/{$taxTypeGroup}";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve parameters for a nexus
     *
     * List parameters for a nexus.
     * Some tax calculation and reporting are different depending on the properties of the nexus, such as isRemoteSeller. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to an nexus will be used by default in tax calculation but will not show on the transaction line referencing the nexus.
     *  
     * A parameter specified on a transaction line will override an nexus parameter if they share the same parameter name. 
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id
     * @param int $nexusId The nexus id
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* name, unit
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNexusParameters($companyId, $nexusId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$nexusId}/parameters";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all nexus
     *
     * Get multiple nexus objects across all companies.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * You may specify one or more of the following values in the '$include' parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Parameters
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* streamlinedSalesTax, isSSTActive, taxTypeGroup, taxAuthorityId, taxName, parameters, taxableNexus
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryNexus($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/nexus";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single nexus
     *
     * Replace the existing nexus declaration object at this URL with an updated object.
     *  
     * The concept of Nexus indicates a place where your company is legally obligated to collect and remit transactional
     * taxes. The legal requirements for nexus may vary per country and per jurisdiction; please seek advice from your
     * accountant or lawyer prior to declaring nexus.
     *  
     * To create a nexus declaration for your company, you must first call the Definitions API `ListNexus` to obtain a
     * list of Avalara-defined nexus. Once you have determined which nexus you wish to declare, you should customize
     * only the user-selectable fields in this object.
     *  
     * The user selectable fields for the nexus object are `companyId`, `effectiveDate`, `endDate`, `localNexusTypeId`,
     * `taxId`, `nexusTypeId`, `hasPermanentEstablishment`, and `isSellerImporterOfRecord`.
     *  
     * When calling `CreateNexus` or `UpdateNexus`, all values in your nexus object except for the user-selectable fields
     * must match an Avalara-defined system nexus object. You can retrieve a list of Avalara-defined system nexus objects
     * by calling `ListNexus`. If any data does not match, AvaTax may not recognize your nexus declaration.
     *  
     * Please note that nexus changes may not take effect immediately and you should plan to update your nexus settings in advance
     * of calculating tax for a location.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this nexus belongs to.
     * @param int $id The ID of the nexus you wish to update
     * @param NexusModel $model The nexus object you wish to update.
     * @return NexusModel
     */
    public function updateNexus($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Update an nexus parameter
     *
     * Update an nexus parameter.
     *  
     * Some tax calculation and reporting are different depending on the properties of the nexus, such as isRemoteSeller. In AvaTax, these tax-affecting properties are called "parameters".
     *  
     * A parameter added to a nexus will be used in tax calculation based on the locationcode and parameter value the transaction state line might have lines added.
     *  
     * A parameter specified on a transaction line will override an item parameter if they share the same parameter name.????? I dont know about this?
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The company id.
     * @param int $nexusId The nexus id
     * @param int $id The nexus parameter id
     * @param NexusParameterDetailModel $model The nexus object you wish to update.
     * @return NexusParameterDetailModel
     */
    public function updateNexusParameter($companyId, $nexusId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/nexus/{$nexusId}/parameters/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Creates a new tax notice responsibility type.
     *
     * This API is available by invitation only and only available for users with Compliance admin access.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param CreateNoticeResponsibilityTypeModel $model The responsibility type to create
     * @return NoticeResponsibilityModel
     */
    public function createNoticeResponsibilityType($model)    {
        $path = "/api/v2/notices/responsibilities";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Creates a new tax notice root cause type.
     *
     * This API is available by invitation only and only available for users with Compliance admin access.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param CreateNoticeRootCauseTypeModel $model The root cause type to create
     * @return NoticeRootCauseModel
     */
    public function createNoticeRootCauseType($model)    {
        $path = "/api/v2/notices/rootcauses";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a tax notice responsibility type.
     *
     * This API is available by invitation only and only available for users with Compliance admin access.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $responsibilityId The unique ID of the responsibility type
     * @return ErrorDetail[]
     */
    public function deleteNoticeResponsibilityType($responsibilityId)    {
        $path = "/api/v2/notices/responsibilities/{$responsibilityId}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a tax notice root cause type.
     *
     * This API is available by invitation only and only available for users with Compliance admin access.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $rootCauseId The unique ID of the root cause type
     * @return ErrorDetail[]
     */
    public function deleteNoticeRootCauseType($rootCauseId)    {
        $path = "/api/v2/notices/rootcauses/{$rootCauseId}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Mark a single notification as dismissed.
     *
     * Marks the notification identified by this URL as dismissed.
     *  
     * A notification is a message from Avalara that may have relevance to your business. You may want
     * to regularly review notifications and then dismiss them when you are certain that you have addressed
     * any relevant concerns raised by this notification.
     *  
     * An example of a notification would be a message about new software, or a change to AvaTax that may
     * affect you, or a potential issue with your company's tax profile.
     *  
     * When you dismiss a notification, the notification will track the user and time when it was
     * dismissed. You can then later review which employees of your company dismissed notifications to
     * determine if they were resolved appropriately.
     *  
     * A Global notification with null accountId and companyId cannot be dismissed and will expire within a given time span.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The id of the notification you wish to mark as dismissed.
     * @return NotificationModel
     */
    public function dismissNotification($id)    {
        $path = "/api/v2/notifications/{$id}/dismiss";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single notification.
     *
     * Retrieve a single notification by its unique ID number.
     *  
     * A notification is a message from Avalara that may have relevance to your business. You may want
     * to regularly review notifications and then dismiss them when you are certain that you have addressed
     * any relevant concerns raised by this notification.
     *  
     * An example of a notification would be a message about new software, or a change to AvaTax that may
     * affect you, or a potential issue with your company's tax profile.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The id of the notification to retrieve.
     * @return NotificationModel
     */
    public function getNotification($id)    {
        $path = "/api/v2/notifications/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all notifications.
     *
     * List all notifications.
     *  
     * A notification is a message from Avalara that may have relevance to your business. You may want
     * to regularly review notifications and then dismiss them when you are certain that you have addressed
     * any relevant concerns raised by this notification.
     *  
     * An example of a notification would be a message about new software, or a change to AvaTax that may
     * affect you, or a potential issue with your company's tax profile.
     *  
     * You may search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listNotifications($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/notifications";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Request a new Avalara account
     *
     * This API is for use by partner provisioning services customers only.
     *  
     * Avalara invites select partners to refer new customers to the AvaTax service using the onboarding features
     * of AvaTax. These partners can create accounts for new customers using this API.
     *  
     * Calling this API creates an account with the specified product subscriptions, but does not configure billing.
     * The customer will receive information from Avalara about how to configure billing for their account.
     * You should call this API when a customer has requested to begin using Avalara services.
     *  
     * If the newly created account owner wishes, they can confirm that they have read and agree to the Avalara
     * terms and conditions. If they do so, they can receive a license key as part of this API and their
     * API will be created in `Active` status. If the customer has not yet read and accepted these terms and
     * conditions, the account will be created in `New` status and they can receive a license key by logging
     * onto the AvaTax website and reviewing terms and conditions online.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API is available by invitation only.
     * * This API is available by invitation only. To request access to this feature, please speak to a business development manager and request access to [Provisioning:RequestNewAccount].
     * Swagger Name: AvaTaxClient
     * 
     * @param NewAccountRequestModel $model Information about the account you wish to create and the selected product offerings.
     * @return NewAccountModel
     */
    public function requestNewAccount($model)    {
        $path = "/api/v2/accounts/request";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Request a new entitilement to an existing customer
     *
     * This API is for use by partner provisioning services customers only. This will allow the partners to allow
     * the add new entitlement to an existing customer
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API is available by invitation only.
     * * This API is available by invitation only. To request access to this feature, please speak to a business development manager and request access to [Provisioning:RequestNewAccount].
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The avatax account id of the customer
     * @param string $offer The offer to be added to an already existing customer
     * @return OfferModel
     */
    public function requestNewEntitlement($id, $offer)    {
        $path = "/api/v2/accounts/{$id}/entitlements/{$offer}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new account
     *
     * # For Registrar Use Only
     * This API is for use by Avalara Registrar administrative users only.
     *  
     * Create a single new account object.
     * When creating an account object you may attach subscriptions and users as part of the 'Create' call.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param AccountModel $model The account you wish to create.
     * @return AccountModel[]
     */
    public function createAccount($model)    {
        $path = "/api/v2/accounts";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create new notifications.
     *
     * This API is available by invitation only.
     *  
     * Create a single notification.
     *  
     * A notification is a message from Avalara that may have relevance to your business. You may want
     * to regularly review notifications and then dismiss them when you are certain that you have addressed
     * any relevant concerns raised by this notification.
     *  
     * A Global notification is a message which is directed to all the accounts and is set to expire within
     * a certain time and cannot be dismissed by the user. Make accountId and companyId null to create a global notification.
     *  
     * An example of a notification would be a message about new software, or a change to AvaTax that may
     * affect you, or a potential issue with your company's tax profile.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API is available by invitation only. To request access to this feature, please speak to a business development manager and request access to [NotificationsAPI:Create].
     * Swagger Name: AvaTaxClient
     * 
     * @param NotificationModel[] $model The notifications you wish to create.
     * @return NotificationModel[]
     */
    public function createNotifications($model)    {
        $path = "/api/v2/notifications";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new subscription
     *
     * This API is for use by Avalara Registrar administrative users only.
     *  
     * Create one or more new subscription objects attached to this account.
     * A 'subscription' indicates a licensed subscription to a named Avalara service.
     * To request or remove subscriptions, please contact Avalara sales or your customer account manager.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns this subscription.
     * @param SubscriptionModel[] $model The subscription you wish to create.
     * @return SubscriptionModel[]
     */
    public function createSubscriptions($accountId, $model)    {
        $path = "/api/v2/accounts/{$accountId}/subscriptions";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single account
     *
     * # For Registrar Use Only
     * This API is for use by Avalara Registrar administrative users only.
     *  
     * Delete an account.
     * Deleting an account will delete all companies, all account level users and license keys attached to this account.
     * 
     * ### Security Policies
     * 
     * * This API requires the user role SystemAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteAccount($id)    {
        $path = "/api/v2/accounts/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single notification.
     *
     * This API is available by invitation only.
     *  
     * Delete the existing notification identified by this URL.
     *  
     * A notification is a message from Avalara that may have relevance to your business. You may want
     * to regularly review notifications and then dismiss them when you are certain that you have addressed
     * any relevant concerns raised by this notification.
     *  
     * An example of a notification would be a message about new software, or a change to AvaTax that may
     * affect you, or a potential issue with your company's tax profile.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API is available by invitation only. To request access to this feature, please speak to a business development manager and request access to [NotificationsAPI:Create].
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The id of the notification you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteNotification($id)    {
        $path = "/api/v2/notifications/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single subscription
     *
     * # For Registrar Use Only
     * This API is for use by Avalara Registrar administrative users only.
     *  
     * Mark the existing account identified by this URL as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns this subscription.
     * @param int $id The ID of the subscription you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteSubscription($accountId, $id)    {
        $path = "/api/v2/accounts/{$accountId}/subscriptions/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve List of Accounts by Account Migration Status
     *
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $writeMode  (See TssAccountMigrationId::* for a list of allowable values)
     * @return AccountMigrationStatusModel
     */
    public function listAccountsByTssWriteMode($writeMode)    {
        $path = "/api/v2/accounts/ListAccountsByTssWriteMode/{$writeMode}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Reset a user's password programmatically
     *
     * # For Registrar Use Only
     * This API is for use by Avalara Registrar administrative users only.
     *  
     * Allows a system admin to reset the password for a specific user via the API.
     * This API is only available for Avalara Registrar Admins, and can be used to reset the password of any
     * user based on internal Avalara business processes.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API is available to Avalara system-level (registrar-level) users only.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $userId The unique ID of the user whose password will be changed
     * @param boolean $unmigrateFromAi If user's password was migrated to AI, undo this.
     * @param SetPasswordModel $model The new password for this user
     * @return string
     */
    public function resetPassword($userId, $unmigrateFromAi, $model)    {
        $path = "/api/v2/passwords/{$userId}/reset";
        $guzzleParams = [
            'query' => ['unmigrateFromAi' => $unmigrateFromAi],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single account
     *
     * # For Registrar Use Only
     * This API is for use by Avalara Registrar administrative users only.
     *  
     * Replace an existing account object with an updated account object.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the account you wish to update.
     * @param AccountModel $model The account object you wish to update.
     * @return AccountModel
     */
    public function updateAccount($id, $model)    {
        $path = "/api/v2/accounts/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single notification.
     *
     * This API is available by invitation only.
     *  
     * Replaces the notification identified by this URL with a new notification.
     *  
     * A notification is a message from Avalara that may have relevance to your business. You may want
     * to regularly review notifications and then dismiss them when you are certain that you have addressed
     * any relevant concerns raised by this notification.
     *  
     * An example of a notification would be a message about new software, or a change to AvaTax that may
     * affect you, or a potential issue with your company's tax profile.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API is available by invitation only. To request access to this feature, please speak to a business development manager and request access to [NotificationsAPI:Create].
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The id of the notification you wish to update.
     * @param NotificationModel $model The notification object you wish to update.
     * @return NotificationModel
     */
    public function updateNotification($id, $model)    {
        $path = "/api/v2/notifications/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single subscription
     *
     * # For Registrar Use Only
     * This API is for use by Avalara Registrar administrative users only.
     *  
     * Replace the existing subscription object at this URL with an updated object.
     * A 'subscription' indicates a licensed subscription to a named Avalara service.
     * To request or remove subscriptions, please contact Avalara sales or your customer account manager.
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that this subscription belongs to.
     * @param int $id The ID of the subscription you wish to update
     * @param SubscriptionModel $model The subscription you wish to update.
     * @return SubscriptionModel
     */
    public function updateSubscription($accountId, $id, $model)    {
        $path = "/api/v2/accounts/{$accountId}/subscriptions/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Download a report
     *
     * This API downloads the file associated with a report.
     *  
     * If the report is not yet complete, you will receive a `ReportNotFinished` error. To check if a report is complete,
     * use the `GetReport` API.
     *  
     * Reports are run as asynchronous report tasks on the server. When complete, the report file will be available for download
     * for up to 30 days after completion. To run an asynchronous report, you should follow these steps:
     *  
     * * Begin a report by calling the report's Initiate API. There is a separate initiate API call for each report type.
     * * In the result of the Initiate API, you receive back a report's `id` value.
     * * Check the status of a report by calling `GetReport` and passing in the report's `id` value.
     * * When a report's status is `Completed`, call `DownloadReport` to retrieve the file.
     *  
     * * We throttle this API. You can only call this API up to 5 times in a minute.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique ID number of this report
     * @return object
     */
    public function downloadReport($id)    {
        $path = "/api/v2/reports/{$id}/attachment";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single report
     *
     * Retrieve a single report by its unique ID number.
     *  
     * Reports are run as asynchronous report tasks on the server. When complete, the report file will be available for download
     * for up to 30 days after completion. To run an asynchronous report, you should follow these steps:
     *  
     * * Begin a report by calling the report's Initiate API. There is a separate initiate API call for each report type.
     * * In the result of the Initiate API, you receive back a report's `id` value.
     * * Check the status of a report by calling `GetReport` and passing in the report's `id` value.
     * * When a report's status is `Completed`, call `DownloadReport` to retrieve the file.
     *  
     * This API call returns information about any report type.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique ID number of the report to retrieve
     * @return ReportModel
     */
    public function getReport($id)    {
        $path = "/api/v2/reports/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Initiate an ExportDocumentLine report task
     *
     * Begins running an `ExportDocumentLine` report task and returns the identity of the report.
     *  
     * Reports are run as asynchronous report tasks on the server. When complete, the report file will be available for download
     * for up to 30 days after completion. To run an asynchronous report, you should follow these steps:
     *  
     * * Begin a report by calling the report's Initiate API. There is a separate initiate API call for each report type.
     * * In the result of the Initiate API, you receive back a report's `id` value.
     * * Check the status of a report by calling `GetReport` and passing in the report's `id` value.
     * * When a report's status is `Completed`, call `DownloadReport` to retrieve the file.
     *  
     * The `ExportDocumentLine` report produces information about invoice lines recorded within your account.
     *  
     * To split large reports into multiple smaller partitions, use the numberOfPartitions and partition properties on ExportDocumentLineModel.
     *  
     * Example - split a report into three partitions
     *  
     * * Follow the steps above with numberOfPartitions = 3 and partition = 0
     * * Follow the steps above with numberOfPartitions = 3 and partition = 1
     * * Follow the steps above with numberOfPartitions = 3 and partition = 2
     * * Once all three reports are downloaded merge the files on the client side.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The unique ID number of the company to report on.
     * @param ExportDocumentLineModel $model Options that may be configured to customize the report.
     * @return ReportModel[]
     */
    public function initiateExportDocumentLineReport($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/reports/exportdocumentline/initiate";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * List all report tasks for account
     *
     * List all report tasks for your account.
     *  
     * Reports are run as asynchronous report tasks on the server. When complete, the report file will be available for download
     * for up to 30 days after completion. To run an asynchronous report, you should follow these steps:
     *  
     * * Begin a report by calling the report's Initiate API. There is a separate initiate API call for each report type.
     * * In the result of the Initiate API, you receive back a report's `id` value.
     * * Check the status of a report by calling `GetReport` and passing in the report's `id` value.
     * * When a report's status is `Completed`, call `DownloadReport` to retrieve the file.
     *  
     * This API call returns information about all report types across your entire account.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The id of the company for which to get reports.
     * @param string $pageKey Provide a page key to retrieve the next page of results.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @return FetchResult
     */
    public function listReports($companyId, $pageKey, $skip=null, $top=null)    {
        $path = "/api/v2/reports";
        $guzzleParams = [
            'query' => ['companyId' => $companyId, 'pageKey' => $pageKey, '$skip' => $skip, '$top' => $top],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new setting
     *
     * Create one or more new setting objects attached to this company.
     *  
     * The company settings system is a metadata system that you can use to store extra information
     * about a company. Your integration or connector could use this data storage to keep track of
     * preference information, reminders, or any other storage that would need to persist even if
     * the customer uninstalls your application.
     *  
     * A setting can refer to any type of data you need to remember about this company object.
     * When creating this object, you may define your own `set`, `name`, and `value` parameters.
     * To define your own values, please choose a `set` name that begins with `X-` to indicate an extension.
     *  
     * Use Set = Transactions, Name = TaxCodePrioritization/HSCodePrioritization and Value = Transaction/ItemMaster for prioritizing which TaxCodes/HsCodes should be used for calculating taxes.
     *  
     * Example: To prioritize TaxCodes passed in a Transaction over values stored with Items when calculating tax, use
     * Set = Transactions, Name = TaxCodePrioritization, Value = Transaction
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this setting.
     * @param SettingModel[] $model The setting you wish to create.
     * @return SettingModel[]
     */
    public function createSettings($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/settings";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single setting
     *
     * Mark the setting object at this URL as deleted.
     *  
     * The company settings system is a metadata system that you can use to store extra information
     * about a company. Your integration or connector could use this data storage to keep track of
     * preference information, reminders, or any other storage that would need to persist even if
     * the customer uninstalls your application.
     *  
     * A setting can refer to any type of data you need to remember about this company object.
     * When creating this object, you may define your own `set`, `name`, and `value` parameters.
     * To define your own values, please choose a `set` name that begins with `X-` to indicate an extension.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this setting.
     * @param int $id The ID of the setting you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteSetting($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/settings/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single setting
     *
     * Get a single setting object by its unique ID.
     *  
     * The company settings system is a metadata system that you can use to store extra information
     * about a company. Your integration or connector could use this data storage to keep track of
     * preference information, reminders, or any other storage that would need to persist even if
     * the customer uninstalls your application.
     *  
     * A setting can refer to any type of data you need to remember about this company object.
     * When creating this object, you may define your own `set`, `name`, and `value` parameters.
     * To define your own values, please choose a `set` name that begins with `X-` to indicate an extension.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this setting
     * @param int $id The primary key of this setting
     * @return SettingModel
     */
    public function getSetting($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/settings/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all settings for this company
     *
     * List all setting objects attached to this company.
     *  
     * The company settings system is a metadata system that you can use to store extra information
     * about a company. Your integration or connector could use this data storage to keep track of
     * preference information, reminders, or any other storage that would need to persist even if
     * the customer uninstalls your application.
     *  
     * A setting can refer to any type of data you need to remember about this company object.
     * When creating this object, you may define your own `set`, `name`, and `value` parameters.
     * To define your own values, please choose a `set` name that begins with `X-` to indicate an extension.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these settings
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* modifiedDate, ModifiedUserId
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listSettingsByCompany($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/settings";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all settings
     *
     * Get multiple setting objects across all companies.
     *  
     * The company settings system is a metadata system that you can use to store extra information
     * about a company. Your integration or connector could use this data storage to keep track of
     * preference information, reminders, or any other storage that would need to persist even if
     * the customer uninstalls your application.
     *  
     * A setting can refer to any type of data you need to remember about this company object.
     * When creating this object, you may define your own `set`, `name`, and `value` parameters.
     * To define your own values, please choose a `set` name that begins with `X-` to indicate an extension.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* modifiedDate, ModifiedUserId
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function querySettings($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/settings";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single setting
     *
     * Replace the existing setting object at this URL with an updated object.
     *  
     * The company settings system is a metadata system that you can use to store extra information
     * about a company. Your integration or connector could use this data storage to keep track of
     * preference information, reminders, or any other storage that would need to persist even if
     * the customer uninstalls your application.
     *  
     * A setting can refer to any type of data you need to remember about this company object.
     * When creating this object, you may define your own `set`, `name`, and `value` parameters.
     * To define your own values, please choose a `set` name that begins with `X-` to indicate an extension.
     *  
     * All data from the existing object will be replaced with data in the object you `PUT`.
     *  
     * To set a field's value to `null`, you may either set its value to `null` or omit that field from the object when calling update.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this setting belongs to.
     * @param int $id The ID of the setting you wish to update
     * @param SettingModel $model The setting you wish to update.
     * @return SettingModel
     */
    public function updateSetting($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/settings/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single subscription
     *
     * Get the subscription object identified by this URL.
     * A 'subscription' indicates a licensed subscription to a named Avalara service.
     * To request or remove subscriptions, please contact Avalara sales or your customer account manager.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns this subscription
     * @param int $id The primary key of this subscription
     * @return SubscriptionModel
     */
    public function getSubscription($accountId, $id)    {
        $path = "/api/v2/accounts/{$accountId}/subscriptions/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve subscriptions for this account
     *
     * List all subscription objects attached to this account.
     * A 'subscription' indicates a licensed subscription to a named Avalara service.
     * To request or remove subscriptions, please contact Avalara sales or your customer account manager.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The ID of the account that owns these subscriptions
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* subscriptionDescription
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listSubscriptionsByAccount($accountId, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/accounts/{$accountId}/subscriptions";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all subscriptions
     *
     * Get multiple subscription objects across all accounts.
     * A 'subscription' indicates a licensed subscription to a named Avalara service.
     * To request or remove subscriptions, please contact Avalara sales or your customer account manager.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* subscriptionDescription
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function querySubscriptions($filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/subscriptions";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new tax code
     *
     * Create one or more new taxcode objects attached to this company.
     * A 'TaxCode' represents a uniquely identified type of product, good, or service.
     * Avalara supports correct tax rates and taxability rules for all TaxCodes in all supported jurisdictions.
     * If you identify your products by tax code in your 'Create Transacion' API calls, Avalara will correctly calculate tax rates and
     * taxability rules for this product in all supported jurisdictions.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this tax code.
     * @param TaxCodeModel[] $model The tax code you wish to create.
     * @return TaxCodeModel[]
     */
    public function createTaxCodes($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/taxcodes";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single tax code
     *
     * Marks the existing TaxCode object at this URL as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this tax code.
     * @param int $id The ID of the tax code you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteTaxCode($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/taxcodes/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single tax code
     *
     * Get the taxcode object identified by this URL.
     * A 'TaxCode' represents a uniquely identified type of product, good, or service.
     * Avalara supports correct tax rates and taxability rules for all TaxCodes in all supported jurisdictions.
     * If you identify your products by tax code in your 'Create Transacion' API calls, Avalara will correctly calculate tax rates and
     * taxability rules for this product in all supported jurisdictions.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this tax code
     * @param int $id The primary key of this tax code
     * @return TaxCodeModel
     */
    public function getTaxCode($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/taxcodes/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve tax codes for this company
     *
     * List all taxcode objects attached to this company.
     * A 'TaxCode' represents a uniquely identified type of product, good, or service.
     * Avalara supports correct tax rates and taxability rules for all TaxCodes in all supported jurisdictions.
     * If you identify your products by tax code in your 'Create Transacion' API calls, Avalara will correctly calculate tax rates and
     * taxability rules for this product in all supported jurisdictions.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these tax codes
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxCodesByCompany($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/taxcodes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all tax codes
     *
     * Get multiple taxcode objects across all companies.
     * A 'TaxCode' represents a uniquely identified type of product, good, or service.
     * Avalara supports correct tax rates and taxability rules for all TaxCodes in all supported jurisdictions.
     * If you identify your products by tax code in your 'Create Transacion' API calls, Avalara will correctly calculate tax rates and
     * taxability rules for this product in all supported jurisdictions.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryTaxCodes($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/taxcodes";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single tax code
     *
     * Replace the existing taxcode object at this URL with an updated object.
     * A 'TaxCode' represents a uniquely identified type of product, good, or service.
     * Avalara supports correct tax rates and taxability rules for all TaxCodes in all supported jurisdictions.
     * If you identify your products by tax code in your 'Create Transacion' API calls, Avalara will correctly calculate tax rates and
     * taxability rules for this product in all supported jurisdictions.
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this tax code belongs to.
     * @param int $id The ID of the tax code you wish to update
     * @param TaxCodeModel $model The tax code you wish to update.
     * @return TaxCodeModel
     */
    public function updateTaxCode($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/taxcodes/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Build a multi-location tax content file
     *
     * Builds a tax content file containing information useful for a retail point-of-sale solution.
     *  
     * Since tax rates may change based on decisions made by a variety of tax authorities, we recommend
     * that users of this tax content API download new data every day. Many tax authorities may finalize
     * decisions on tax changes at unexpected times and may make changes in response to legal issues or
     * governmental priorities. Any tax content downloaded for future time periods is subject to change
     * if tax rates or tax laws change.
     *  
     * A TaxContent file contains a matrix of the taxes that would be charged when you sell any of your
     * Items at any of your Locations. To create items, use `CreateItems()`. To create locations, use
     * `CreateLocations()`. The file is built by looking up the tax profile for your location and your
     * item and calculating taxes for each in turn. To include a custom `TaxCode` in this tax content
     * file, first create the custom tax code using `CreateTaxCodes()` to create the custom tax code,
     * then use `CreateItems()` to create an item that uses the custom tax code.
     *  
     * This data file can be customized for specific partner devices and usage conditions.
     *  
     * The result of this API is the file you requested in the format you requested using the `responseType` field.
     *  
     * This API builds the file on demand, and is limited to files with no more than 7500 scenarios. To build a tax content
     * file for a single location at a time, please use `BuildTaxContentFileForLocation`.
     *  
     * NOTE: This API does not work for Tennessee tax holiday scenarios.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param PointOfSaleDataRequestModel $model Parameters about the desired file format and report format, specifying which company, locations and TaxCodes to include.
     * @return object
     */
    public function buildTaxContentFile($model)    {
        $path = "/api/v2/pointofsaledata/build";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Build a tax content file for a single location
     *
     * Builds a tax content file containing information useful for a retail point-of-sale solution.
     *  
     * Since tax rates may change based on decisions made by a variety of tax authorities, we recommend
     * that users of this tax content API download new data every day. Many tax authorities may finalize
     * decisions on tax changes at unexpected times and may make changes in response to legal issues or
     * governmental priorities. Any tax content downloaded for future time periods is subject to change
     * if tax rates or tax laws change.
     *  
     * A TaxContent file contains a matrix of the taxes that would be charged when you sell any of your
     * Items at any of your Locations. To create items, use `CreateItems()`. To create locations, use
     * `CreateLocations()`. The file is built by looking up the tax profile for your location and your
     * item and calculating taxes for each in turn. To include a custom `TaxCode` in this tax content
     * file, first create the custom tax code using `CreateTaxCodes()` to create the custom tax code,
     * then use `CreateItems()` to create an item that uses the custom tax code.
     *  
     * This data file can be customized for specific partner devices and usage conditions.
     *  
     * The result of this API is the file you requested in the format you requested using the `responseType` field.
     *  
     * This API builds the file on demand, and is limited to files with no more than 7500 scenarios. To build a tax content
     * file for a multiple locations in a single file, please use `BuildTaxContentFile`.
     *  
     * NOTE: This API does not work for Tennessee tax holiday scenarios.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID number of the company that owns this location.
     * @param int $id The ID number of the location to retrieve point-of-sale data.
     * @param string $date The date for which point-of-sale data would be calculated (today by default)
     * @param string $format The format of the file (JSON by default) (See PointOfSaleFileType::* for a list of allowable values)
     * @param string $partnerId If specified, requests a custom partner-formatted version of the file. (See PointOfSalePartnerId::* for a list of allowable values)
     * @param boolean $includeJurisCodes When true, the file will include jurisdiction codes in the result.
     * @return object
     */
    public function buildTaxContentFileForLocation($companyId, $id, $date, $format, $partnerId, $includeJurisCodes)    {
        $path = "/api/v2/companies/{$companyId}/locations/{$id}/pointofsaledata";
        $guzzleParams = [
            'query' => ['date' => $date, 'format' => $format, 'partnerId' => $partnerId, 'includeJurisCodes' => $includeJurisCodes],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Download a file listing tax rates by postal code
     *
     * Download a CSV file containing all five digit postal codes in the United States and their sales
     * and use tax rates for tangible personal property.
     *  
     * Since tax rates may change based on decisions made by a variety of tax authorities, we recommend
     * that users of this tax content API download new data every day. Many tax authorities may finalize
     * decisions on tax changes at unexpected times and may make changes in response to legal issues or
     * governmental priorities. Any tax content downloaded for future time periods is subject to change
     * if tax rates or tax laws change.
     *  
     * This rates file is intended to be used as a default for tax calculation when your software cannot
     * call the `CreateTransaction` API call. When using this file, your software will be unable to
     * handle complex tax rules such as:
     *  
     * * Zip+4 - This tax file contains five digit zip codes only.
     * * Different product types - This tax file contains tangible personal property tax rates only.
     * * Mixed sourcing - This tax file cannot be used to resolve origin-based taxes.
     * * Threshold-based taxes - This tax file does not contain information about thresholds.
     *  
     * If you use this file to provide default tax rates, please ensure that your software calls `CreateTransaction`
     * to reconcile the actual transaction and determine the difference between the estimated general tax
     * rate and the final transaction tax.
     *  
     * The file provided by this API is in CSV format with the following columns:
     *  
     * * ZIP_CODE - The five digit zip code for this record.
     * * STATE_ABBREV - A valid two character US state abbreviation for this record. Zip codes may span multiple states.
     * * COUNTY_NAME - A valid county name for this record. Zip codes may span multiple counties.
     * * CITY_NAME - A valid city name for this record. Zip codes may span multiple cities.
     * * STATE_SALES_TAX - The state component of the sales tax rate.
     * * STATE_USE_TAX - The state component of the use tax rate.
     * * COUNTY_SALES_TAX - The county component of the sales tax rate.
     * * COUNTY_USE_TAX - The county component of the use tax rate.
     * * CITY_SALES_TAX - The city component of the sales tax rate.
     * * CITY_USE_TAX - The city component of the use tax rate.
     * * TOTAL_SALES_TAX - The total tax rate for sales tax for this postal code. This value may not equal the sum of the state/county/city due to special tax jurisdiction rules.
     * * TOTAL_USE_TAX - The total tax rate for use tax for this postal code. This value may not equal the sum of the state/county/city due to special tax jurisdiction rules.
     * * TAX_SHIPPING_ALONE - This column contains 'Y' if shipping is taxable.
     * * TAX_SHIPPING_AND_HANDLING_TOGETHER - This column contains 'Y' if shipping and handling are taxable when sent together.
     *  
     * For more detailed tax content, please use the `BuildTaxContentFile` API which allows usage of exact items and exact locations.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $date The date for which point-of-sale data would be calculated (today by default). Example input: 2016-12-31
     * @param string $region A two character region code which limits results to a specific region.
     * @return object
     */
    public function downloadTaxRatesByZipCode($date, $region)    {
        $path = "/api/v2/taxratesbyzipcode/download/{$date}";
        $guzzleParams = [
            'query' => ['region' => $region],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Sales tax rates for a specified address
     *
     * Usage of this API is subject to rate limits. Users who exceed the rate limit will receive HTTP
     * response code 429 - `Too Many Requests`.
     *  
     * This API assumes that you are selling general tangible personal property at a retail point-of-sale
     * location in the United States only.
     *  
     * For more powerful tax calculation, please consider upgrading to the `CreateTransaction` API,
     * which supports features including, but not limited to:
     *  
     * * Nexus declarations
     * * Taxability based on product/service type
     * * Sourcing rules affecting origin/destination states
     * * Customers who are exempt from certain taxes
     * * States that have dollar value thresholds for tax amounts
     * * Refunds for products purchased on a different date
     * * Detailed jurisdiction names and state assigned codes
     * * And more!
     *  
     * Please see [Estimating Tax with REST v2](http://developer.avalara.com/blog/2016/11/04/estimating-tax-with-rest-v2/)
     * for information on how to upgrade to the full AvaTax CreateTransaction API.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $line1 The street address of the location.
     * @param string $line2 The street address of the location.
     * @param string $line3 The street address of the location.
     * @param string $city The city name of the location.
     * @param string $region Name or ISO 3166 code identifying the region within the country.     This field supports many different region identifiers:   * Two and three character ISO 3166 region codes   * Fully spelled out names of the region in ISO supported languages   * Common alternative spellings for many regions     For a full list of all supported codes and names, please see the Definitions API `ListRegions`.
     * @param string $postalCode The postal code of the location.
     * @param string $country Name or ISO 3166 code identifying the country.     This field supports many different country identifiers:   * Two character ISO 3166 codes   * Three character ISO 3166 codes   * Fully spelled out names of the country in ISO supported languages   * Common alternative spellings for many countries     For a full list of all supported codes and names, please see the Definitions API `ListCountries`.
     * @return TaxRateModel
     */
    public function taxRatesByAddress($line1, $line2, $line3, $city, $region, $postalCode, $country)    {
        $path = "/api/v2/taxrates/byaddress";
        $guzzleParams = [
            'query' => ['line1' => $line1, 'line2' => $line2, 'line3' => $line3, 'city' => $city, 'region' => $region, 'postalCode' => $postalCode, 'country' => $country],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Sales tax rates for a specified country and postal code. This API is only available for US postal codes.
     *
     * This API is only available for a US postal codes.
     *  
     * Usage of this API is subject to rate limits. Users who exceed the rate limit will receive HTTP
     * response code 429 - `Too Many Requests`.
     *  
     * This API assumes that you are selling general tangible personal property at a retail point-of-sale
     * location in the United States only.
     *  
     * For more powerful tax calculation, please consider upgrading to the `CreateTransaction` API,
     * which supports features including, but not limited to:
     *  
     * * Nexus declarations
     * * Taxability based on product/service type
     * * Sourcing rules affecting origin/destination states
     * * Customers who are exempt from certain taxes
     * * States that have dollar value thresholds for tax amounts
     * * Refunds for products purchased on a different date
     * * Detailed jurisdiction names and state assigned codes
     * * And more!
     *  
     * Please see [Estimating Tax with REST v2](http://developer.avalara.com/blog/2016/11/04/estimating-tax-with-rest-v2/)
     * for information on how to upgrade to the full AvaTax CreateTransaction API.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $country Name or ISO 3166 code identifying the country.     This field supports many different country identifiers:   * Two character ISO 3166 codes   * Three character ISO 3166 codes   * Fully spelled out names of the country in ISO supported languages   * Common alternative spellings for many countries     For a full list of all supported codes and names, please see the Definitions API `ListCountries`.
     * @param string $postalCode The postal code of the location.
     * @return TaxRateModel
     */
    public function taxRatesByPostalCode($country, $postalCode)    {
        $path = "/api/v2/taxrates/bypostalcode";
        $guzzleParams = [
            'query' => ['country' => $country, 'postalCode' => $postalCode],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new tax rule
     *
     * Create one or more custom tax rules attached to this company.
     *  
     * A tax rule represents a rule that changes the default AvaTax behavior for a product or jurisdiction. Custom tax rules
     * can be used to change the taxability of an item, to change the tax base of an item, or to change the tax rate
     * charged when selling an item. Tax rules can also change tax behavior depending on the `entityUseCode` value submitted
     * with the transaction.
     *  
     * You can create custom tax rules to customize the behavior of AvaTax to match specific rules that are custom to your
     * business. If you have obtained a ruling from a tax auditor that requires custom tax calculations, you can use
     * custom tax rules to redefine the behavior for your company or item.
     *  
     * Please use custom tax rules carefully and ensure that these tax rules match the behavior agreed upon with your
     * auditor, legal representative, and accounting team.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this tax rule.
     * @param TaxRuleModel[] $model The tax rule you wish to create.
     * @return TaxRuleModel[]
     */
    public function createTaxRules($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/taxrules";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single tax rule
     *
     * Mark the custom tax rule identified by this URL as deleted.
     *  
     * A tax rule represents a rule that changes the default AvaTax behavior for a product or jurisdiction. Custom tax rules
     * can be used to change the taxability of an item, to change the tax base of an item, or to change the tax rate
     * charged when selling an item. Tax rules can also change tax behavior depending on the `entityUseCode` value submitted
     * with the transaction.
     *  
     * You can create custom tax rules to customize the behavior of AvaTax to match specific rules that are custom to your
     * business. If you have obtained a ruling from a tax auditor that requires custom tax calculations, you can use
     * custom tax rules to redefine the behavior for your company or item.
     *  
     * Please use custom tax rules carefully and ensure that these tax rules match the behavior agreed upon with your
     * auditor, legal representative, and accounting team.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this tax rule.
     * @param int $id The ID of the tax rule you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteTaxRule($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/taxrules/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single tax rule
     *
     * Get the taxrule object identified by this URL.
     *  
     * A tax rule represents a rule that changes the default AvaTax behavior for a product or jurisdiction. Custom tax rules
     * can be used to change the taxability of an item, to change the tax base of an item, or to change the tax rate
     * charged when selling an item. Tax rules can also change tax behavior depending on the `entityUseCode` value submitted
     * with the transaction.
     *  
     * You can create custom tax rules to customize the behavior of AvaTax to match specific rules that are custom to your
     * business. If you have obtained a ruling from a tax auditor that requires custom tax calculations, you can use
     * custom tax rules to redefine the behavior for your company or item.
     *  
     * Please use custom tax rules carefully and ensure that these tax rules match the behavior agreed upon with your
     * auditor, legal representative, and accounting team.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this tax rule
     * @param int $id The primary key of this tax rule
     * @return TaxRuleModel
     */
    public function getTaxRule($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/taxrules/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve tax rules for this company
     *
     * List all taxrule objects attached to this company.
     *  
     * A tax rule represents a rule that changes the default AvaTax behavior for a product or jurisdiction. Custom tax rules
     * can be used to change the taxability of an item, to change the tax base of an item, or to change the tax rate
     * charged when selling an item. Tax rules can also change tax behavior depending on the `entityUseCode` value submitted
     * with the transaction.
     *  
     * You can create custom tax rules to customize the behavior of AvaTax to match specific rules that are custom to your
     * business. If you have obtained a ruling from a tax auditor that requires custom tax calculations, you can use
     * custom tax rules to redefine the behavior for your company or item.
     *  
     * Please use custom tax rules carefully and ensure that these tax rules match the behavior agreed upon with your
     * auditor, legal representative, and accounting team.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these tax rules
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxCode, taxTypeCode, taxRuleProductDetail, rateTypeCode, taxTypeGroup, taxSubType, unitOfBasis
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTaxRules($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/taxrules";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all tax rules
     *
     * Get multiple taxrule objects across all companies.
     *  
     * A tax rule represents a rule that changes the default AvaTax behavior for a product or jurisdiction. Custom tax rules
     * can be used to change the taxability of an item, to change the tax base of an item, or to change the tax rate
     * charged when selling an item. Tax rules can also change tax behavior depending on the `entityUseCode` value submitted
     * with the transaction.
     *  
     * You can create custom tax rules to customize the behavior of AvaTax to match specific rules that are custom to your
     * business. If you have obtained a ruling from a tax auditor that requires custom tax calculations, you can use
     * custom tax rules to redefine the behavior for your company or item.
     *  
     * Please use custom tax rules carefully and ensure that these tax rules match the behavior agreed upon with your
     * auditor, legal representative, and accounting team.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* taxCode, taxTypeCode, taxRuleProductDetail, rateTypeCode, taxTypeGroup, taxSubType, unitOfBasis
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryTaxRules($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/taxrules";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single tax rule
     *
     * Replace the existing custom tax rule object at this URL with an updated object.
     *  
     * A tax rule represents a rule that changes the default AvaTax behavior for a product or jurisdiction. Custom tax rules
     * can be used to change the taxability of an item, to change the tax base of an item, or to change the tax rate
     * charged when selling an item. Tax rules can also change tax behavior depending on the `entityUseCode` value submitted
     * with the transaction.
     *  
     * You can create custom tax rules to customize the behavior of AvaTax to match specific rules that are custom to your
     * business. If you have obtained a ruling from a tax auditor that requires custom tax calculations, you can use
     * custom tax rules to redefine the behavior for your company or item.
     *  
     * Please use custom tax rules carefully and ensure that these tax rules match the behavior agreed upon with your
     * auditor, legal representative, and accounting team.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this tax rule belongs to.
     * @param int $id The ID of the tax rule you wish to update
     * @param TaxRuleModel $model The tax rule you wish to update.
     * @return TaxRuleModel
     */
    public function updateTaxRule($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/taxrules/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Add lines to an existing unlocked transaction
     *
     * Add lines to an existing unlocked transaction.
     *  
     *  The `AddLines` API allows you to add additional transaction lines to existing transaction, so that customer will
     *  be able to append multiple calls together and form an extremely large transaction. If customer does not specify line number
     *  in the lines to be added, a new random Guid string will be generated for line number. If customer are not satisfied with
     *  the line number for the transaction lines, they can turn on the renumber switch to have REST v2 automatically renumber all
     *  transaction lines for them, in this case, the line number becomes: "1", "2", "3", ...
     *  
     *  A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     *  sales, purchases, inventory transfer, and returns (also called refunds).
     *  You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Lines
     *  * Details (implies lines)
     *  * Summary (implies details)
     *  * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     *  If you omit the `$include` parameter, the API will assume you want `Summary,Addresses`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param AddTransactionLineModel $model information about the transaction and lines to be added
     * @return TransactionModel
     */
    public function addLines($include=null, $model)    {
        $path = "/api/v2/companies/transactions/lines/add";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Correct a previously created transaction
     *
     * Replaces the current transaction uniquely identified by this URL with a new transaction.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * When you adjust a committed transaction, the original transaction will be updated with the status code `Adjusted`, and
     * both revisions will be available for retrieval based on their code and ID numbers.
     * Only transactions in `Committed` status are reported by Avalara Managed Returns.
     *  
     * Transactions that have been previously reported to a tax authority by Avalara Managed Returns are considered `locked` and are
     * no longer available for adjustments.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to adjust
     * @param string $documentType (Optional): The document type of the transaction to adjust. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param AdjustTransactionModel $model The adjustment you wish to make
     * @return TransactionModel
     */
    public function adjustTransaction($companyCode, $transactionCode, $documentType, $include=null, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/adjust";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Get audit information about a transaction
     *
     * Retrieve audit information about a transaction stored in AvaTax.
     *  
     * The `AuditTransaction` API retrieves audit information related to a specific transaction. This audit
     * information includes the following:
     *  
     * * The `CompanyId` of the company that created the transaction
     * * The server timestamp representing the exact server time when the transaction was created
     * * The server duration - how long it took to process this transaction
     * * Whether exact API call details were logged
     * * A reconstructed API call showing what the original CreateTransaction call looked like
     *  
     * This API can be used to examine information about a previously created transaction.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The code identifying the company that owns this transaction
     * @param string $transactionCode The code identifying the transaction
     * @return AuditTransactionModel
     */
    public function auditTransaction($companyCode, $transactionCode)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/audit";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Get audit information about a transaction
     *
     * Retrieve audit information about a transaction stored in AvaTax.
     *  
     * The `AuditTransaction` API retrieves audit information related to a specific transaction. This audit
     * information includes the following:
     *  
     * * The `CompanyId` of the company that created the transaction
     * * The server timestamp representing the exact server time when the transaction was created
     * * The server duration - how long it took to process this transaction
     * * Whether exact API call details were logged
     * * A reconstructed API call showing what the original CreateTransaction call looked like
     *  
     * This API can be used to examine information about a previously created transaction.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The code identifying the company that owns this transaction
     * @param string $transactionCode The code identifying the transaction
     * @param string $documentType The document type of the original transaction (See DocumentType::* for a list of allowable values)
     * @return AuditTransactionModel
     */
    public function auditTransactionWithType($companyCode, $transactionCode, $documentType)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/types/{$documentType}/audit";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Lock a set of documents
     *
     * This API is available by invitation only.
     *  
     * Lock a set of transactions uniquely identified by DocumentIds provided. This API allows locking multiple documents at once.
     * After this API call succeeds, documents will be locked and can't be voided.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     * 
     * ### Security Policies
     * 
     * * This API requires the user role Compliance Root User.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param BulkLockTransactionModel $model bulk lock request
     * @return BulkLockTransactionResult
     */
    public function bulkLockTransaction($model)    {
        $path = "/api/v2/transactions/lock";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Change a transaction's code
     *
     * Renames a transaction uniquely identified by this URL by changing its `code` value.
     *  
     * This API is available as long as the transaction is in `saved` or `posted` status. When a transaction
     * is `committed`, it can be modified by using the [AdjustTransaction](https://developer.avalara.com/api-reference/avatax/rest/v2/methods/Transactions/AdjustTransaction/) method.
     *  
     * After this API call succeeds, the transaction will have a new URL matching its new `code`.
     *  
     * If you have more than one document with the same `code`, specify the `documentType` parameter to choose between them.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, ProStoresOperator, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to change
     * @param string $documentType (Optional): The document type of the transaction to change document code. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param ChangeTransactionCodeModel $model The code change request you wish to execute
     * @return TransactionModel
     */
    public function changeTransactionCode($companyCode, $transactionCode, $documentType, $include=null, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/changecode";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Commit a transaction for reporting
     *
     * Marks a transaction by changing its status to `Committed`.
     *  
     * Transactions that are committed are available to be reported to a tax authority by Avalara Managed Returns.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * If you have more than one document with the same `code`, specify the `documentType` parameter to choose between them.
     *  
     * Any changes made to a committed transaction will generate a transaction history.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, ProStoresOperator, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to commit
     * @param string $documentType (Optional): The document type of the transaction to commit. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param CommitTransactionModel $model The commit request you wish to execute
     * @return TransactionModel
     */
    public function commitTransaction($companyCode, $transactionCode, $documentType, $include=null, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/commit";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create or adjust a transaction
     *
     * Records a new transaction or adjust an existing transaction in AvaTax.
     *  
     * The `CreateOrAdjustTransaction` endpoint is used to create a new transaction or update an existing one. This API
     * can help you create an idempotent service that creates transactions
     * If there exists a transaction identified by code, the original transaction will be adjusted by using the meta data
     * in the input transaction.
     *  
     * The `CreateOrAdjustTransaction` API cannot modify any transaction that has been reported to a tax authority using
     * the Avalara Managed Returns Service or any other tax filing service. If you call this API to attempt to modify
     * a transaction that has been reported on a tax filing, you will receive the error `CannotModifyLockedTransaction`.
     *  
     * To generate a refund for a transaction, use the `RefundTransaction` API.
     *  
     * If you don't specify the field `type` in your request, you will get an estimate of type `SalesOrder`, which will not be recorded in the database.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * ForceTimeout - Simulates a timeout. This adds a 30 second delay and error to your API call. This can be used to test your code to ensure it can respond correctly in the case of a dropped connection.
     *  
     * If you omit the `$include` parameter, the API will assume you want `Summary,Addresses`.
     *  
     * NOTE: Avoid using the following strings in your transaction codes as they are encoding strings and will be interpreted differently:
     * * \_-ava2f-\_
     * * \_-ava2b-\_
     * * \_-ava3f-\_
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param CreateOrAdjustTransactionModel $model The transaction you wish to create or adjust
     * @return TransactionModel
     */
    public function createOrAdjustTransaction($include=null, $model)    {
        $path = "/api/v2/transactions/createoradjust";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new transaction
     *
     * Records a new transaction in AvaTax.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * The `CreateTransaction` endpoint uses the tax profile of your company to identify the correct tax rules
     * and rates to apply to all line items in this transaction. The end result will be the total tax calculated by AvaTax based on your
     * company's configuration and the data provided in this API call.
     *  
     * The `CreateTransaction` API will report an error if a committed transaction already exists with the same `code`. To
     * avoid this error, use the `CreateOrAdjustTransaction` API - it will create the transaction if it does not exist, or
     * update it if it does exist.
     *  
     * To generate a refund for a transaction, use the `RefundTransaction` API.
     *  
     * The field `type` identifies the kind of transaction - for example, a sale, purchase, or refund. If you do not specify
     * a `type` value, you will receive an estimate of type `SalesOrder`, which will not be recorded.
     *  
     * The origin and destination locations for a transaction must be identified by either address or geocode. For address-based transactions, please
     * provide addresses in the fields `line`, `city`, `region`, `country` and `postalCode`. For geocode-based transactions, please provide the geocode
     * information in the fields `latitude` and `longitude`. If either `latitude` or `longitude` or both are null, the transaction will be calculated
     * using the best available address location information.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * ForceTimeout - Simulates a timeout. This adds a 30 second delay and error to your API call. This can be used to test your code to ensure it can respond correctly in the case of a dropped connection.
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * If you omit the `$include` parameter, the API will assume you want `Summary,Addresses`.
     *  
     * NOTE: Avoid using the following strings in your transaction codes as they are encoding strings and will be interpreted differently:
     * * \_-ava2f-\_
     * * \_-ava2b-\_
     * * \_-ava3f-\_
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param CreateTransactionModel $model The transaction you wish to create
     * @return TransactionModel
     */
    public function createTransaction($include=null, $model)    {
        $path = "/api/v2/transactions/create";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Remove lines from an existing unlocked transaction
     *
     * Remove lines to an existing unlocked transaction.
     *  
     *  The `DeleteLines` API allows you to remove transaction lines from existing unlocked transaction, so that customer will
     *  be able to delete transaction lines and adjust original transaction the way they like
     *  
     *  A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     *  sales, purchases, inventory transfer, and returns (also called refunds).
     *  You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     *  * Lines
     *  * Details (implies lines)
     *  * Summary (implies details)
     *  * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     *  If you omit the `$include` parameter, the API will assume you want `Summary,Addresses`.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param RemoveTransactionLineModel $model information about the transaction and lines to be removed
     * @return TransactionModel
     */
    public function deleteLines($include=null, $model)    {
        $path = "/api/v2/companies/transactions/lines/delete";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single transaction by code
     *
     * Get the current transaction identified by this company code, transaction code, and document type.
     *  
     * A transaction is uniquely identified by `companyCode`, `code` (often called Transaction Code), and `documentType`.
     *  
     * For compatibility purposes, when this API finds multiple transactions with the same transaction code, and if you have not specified
     * the `type` parameter to this API, it will default to selecting the `SalesInvoices` transaction. To change this behavior, use the
     * optional `documentType` parameter to specify the specific document type you wish to find.
     *  
     * If this transaction was adjusted, the return value of this API will be the current transaction with this code.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to retrieve
     * @param string $documentType (Optional): The document type of the transaction to retrieve (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @return TransactionModel
     */
    public function getTransactionByCode($companyCode, $transactionCode, $documentType, $include=null)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single transaction by code
     *
     * DEPRECATED: Please use the `GetTransactionByCode` API instead.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to retrieve
     * @param string $documentType The transaction type to retrieve (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @return TransactionModel
     */
    public function getTransactionByCodeAndType($companyCode, $transactionCode, $documentType, $include=null)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/types/{$documentType}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single transaction by ID
     *
     * Get the unique transaction identified by this URL.
     *  
     * This endpoint retrieves the exact transaction identified by this ID number even if that transaction was later adjusted
     * by using the `AdjustTransaction` endpoint.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The unique ID number of the transaction to retrieve
     * @param string $include Specifies objects to include in this fetch call
     * @return TransactionModel
     */
    public function getTransactionById($id, $include=null)    {
        $path = "/api/v2/transactions/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all transactions
     *
     * List all transactions attached to this company.
     *  
     * This endpoint is limited to returning 1,000 transactions at a time maximum.
     *  
     * When listing transactions, you must specify a `date` range filter. If you do not specify a `$filter` that includes a `date` field
     * criteria, the query will default to looking at only those transactions with `date` in the past 30 days.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, ProStoresOperator, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param int $dataSourceId Optionally filter transactions to those from a specific data source.
     * @param string $include Specifies objects to include in this fetch call
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* exchangeRateCurrencyCode, totalDiscount, lines, addresses, locationTypes, summary, taxDetailsByTaxType, parameters, userDefinedFields, messages, invoiceMessages, isFakeTransaction, deliveryTerms
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listTransactionsByCompany($companyCode, $dataSourceId, $include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyCode}/transactions";
        $guzzleParams = [
            'query' => ['dataSourceId' => $dataSourceId, '$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Lock a single transaction
     *
     * Lock a transaction uniquely identified by this URL.
     *  
     * This API is mainly used for connector developers to simulate what happens when the Returns product locks a document.
     * After this API call succeeds, the document will be locked and can't be voided or adjusted.
     *  
     * This API is only available to customers in Sandbox with AvaTaxPro subscription. On production servers, this API is available by invitation only.
     *  
     * If you have more than one document with the same `code`, specify the `documentType` parameter to choose between them.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Returns* (at least one of): Mrs, MRSComplianceManager, AvaTaxCsp.*Firm Managed* (for accounts managed by a firm): ARA, ARAManaged.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to lock
     * @param string $documentType (Optional): The document type of the transaction to lock. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param LockTransactionModel $model The lock request you wish to execute
     * @return TransactionModel
     */
    public function lockTransaction($companyCode, $transactionCode, $documentType, $include=null, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/lock";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a refund for a transaction
     *
     * Create a refund for a transaction.
     *  
     * The `RefundTransaction` API allows you to quickly and easily create a `ReturnInvoice` representing a refund
     * for a previously created `SalesInvoice` transaction. You can choose to create a full or partial refund, and
     * specify individual line items from the original sale for refund.
     *  
     * The `RefundTransaction` API ensures that the tax amount you refund to the customer exactly matches the tax that
     * was calculated during the original transaction, regardless of any changes to your company's configuration, rules,
     * nexus, or any other setting.
     *  
     * This API is intended to be a shortcut to allow you to quickly and accurately generate a refund for the following
     * common refund scenarios:
     *  
     * * A full refund of a previous sale
     * * Refunding the tax that was charged on a previous sale, when the customer provides an exemption certificate after the purchase
     * * Refunding one or more items (lines) from a previous sale
     * * Granting a customer a percentage refund of a previous sale
     *  
     * For more complex scenarios than the ones above, please use `CreateTransaction` with document type `ReturnInvoice` to
     * create a custom refund transaction.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     * If you omit the `$include` parameter, the API will assume you want `Summary,Addresses`.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The code of the company that made the original sale
     * @param string $transactionCode The transaction code of the original sale
     * @param string $include Specifies objects to include in the response after transaction is created
     * @param string $documentType (Optional): The document type of the transaction to refund. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param boolean $useTaxDateOverride (Optional): If set to true, processes refund using taxDateOverride rather than taxAmountOverride (Note: taxAmountOverride is not allowed for SST states).
     * @param RefundTransactionModel $model Information about the refund to create
     * @return TransactionModel
     */
    public function refundTransaction($companyCode, $transactionCode, $include=null, $documentType, $useTaxDateOverride, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/refund";
        $guzzleParams = [
            'query' => ['$include' => $include, 'documentType' => $documentType, 'useTaxDateOverride' => $useTaxDateOverride],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Perform multiple actions on a transaction
     *
     * Performs one or more actions against the current transaction uniquely identified by this URL.
     *  
     * The `SettleTransaction` API call can perform the work of `ChangeCode`, `VerifyTransaction`, and `CommitTransaction`.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * If you have more than one document with the same `code`, specify the `documentType` parameter to choose between them.
     *  
     * This API is available for users who want to execute more than one action at a time.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, ProStoresOperator, SSTAdmin, TechnicalSupportAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to settle
     * @param string $documentType (Optional): The document type of the transaction to settle. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param SettleTransactionModel $model The data from an external system to reconcile against AvaTax
     * @return TransactionModel
     */
    public function settleTransaction($companyCode, $transactionCode, $documentType, $include=null, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/settle";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Uncommit a transaction for reporting
     *
     * Adjusts a transaction by changing it to an uncommitted status.
     *  
     * Transactions that have been previously reported to a tax authority by Avalara Managed Returns are considered `locked` and are
     * no longer available to be uncommitted.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to Uncommit
     * @param string $documentType (Optional): The document type of the transaction to Uncommit. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @return TransactionModel
     */
    public function uncommitTransaction($companyCode, $transactionCode, $documentType, $include=null)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/uncommit";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Unvoids a transaction
     *
     * Unvoids a voided transaction
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to commit
     * @param string $documentType (Optional): The document type of the transaction to commit. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @return TransactionModel
     */
    public function unvoidTransaction($companyCode, $transactionCode, $documentType, $include=null)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/unvoid";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Verify a transaction
     *
     * Verifies that the transaction uniquely identified by this URL matches certain expected values.
     *  
     * If the transaction does not match these expected values, this API will return an error code indicating which value did not match.
     *  
     * If you have more than one document with the same `code`, specify the `documentType` parameter to choose between them.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, CSPTester, ProStoresOperator, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to settle
     * @param string $documentType (Optional): The document type of the transaction to verify. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param VerifyTransactionModel $model The data from an external system to reconcile against AvaTax
     * @return TransactionModel
     */
    public function verifyTransaction($companyCode, $transactionCode, $documentType, $include=null, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/verify";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Void a transaction
     *
     * Voids the current transaction uniquely identified by this URL.
     *  
     * A transaction represents a unique potentially taxable action that your company has recorded, and transactions include actions like
     * sales, purchases, inventory transfer, and returns (also called refunds).
     *  
     * When you void a transaction, that transaction's status is recorded as `DocVoided`.
     *  
     * If you have more than one document with the same `code`, specify the `documentType` parameter to choose between them.
     *  
     * Transactions that have been previously reported to a tax authority by Avalara Managed Returns are no longer available to be voided.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * Lines
     * * Details (implies lines)
     * * Summary (implies details)
     * * Addresses
     * * SummaryOnly (omit lines and details - reduces API response size)
     * * LinesOnly (omit details - reduces API response size)
     * * TaxDetailsByTaxType - Includes the aggregated tax, exempt tax, taxable and non-taxable for each tax type returned in the transaction summary.
     *  
     * NOTE: If your companyCode or transactionCode contains any of these characters /, +, ? or a space please use the following encoding before making a request:
     * * Replace '/' with '\_-ava2f-\_' For example: document/Code becomes document_-ava2f-_Code
     * * Replace '+' with '\_-ava2b-\_' For example: document+Code becomes document_-ava2b-_Code
     * * Replace '?' with '\_-ava3f-\_' For example: document?Code becomes document_-ava3f-_Code
     * * Replace '%' with '\_-ava25-\_' For example: document%Code becomes document_-ava25-_Code
     * * Replace '#' with '\_-ava23-\_' For example: document#Code becomes document_-ava23-_Code
     * * Replace ' ' with '%20' For example: document Code becomes document%20Code
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, CompanyAdmin, CSPTester, ProStoresOperator, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $companyCode The company code of the company that recorded this transaction
     * @param string $transactionCode The transaction code to void
     * @param string $documentType (Optional): The document type of the transaction to void. If not provided, the default is SalesInvoice. (See DocumentType::* for a list of allowable values)
     * @param string $include Specifies objects to include in this fetch call
     * @param VoidTransactionModel $model The void request you wish to execute. To void a transaction the code must be set to 'DocVoided'
     * @return TransactionModel
     */
    public function voidTransaction($companyCode, $transactionCode, $documentType, $include=null, $model)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/void";
        $guzzleParams = [
            'query' => ['documentType' => $documentType, '$include' => $include],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Create a new UPC
     *
     * Create one or more new UPC objects attached to this company.
     * A UPC represents a single UPC code in your catalog and matches this product to the tax code identified by this UPC.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaUpc.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this UPC.
     * @param UPCModel[] $model The UPC you wish to create.
     * @return UPCModel[]
     */
    public function createUPCs($companyId, $model)    {
        $path = "/api/v2/companies/{$companyId}/upcs";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single UPC
     *
     * Marks the UPC object identified by this URL as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaUpc.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this UPC.
     * @param int $id The ID of the UPC you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteUPC($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/upcs/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single UPC
     *
     * Get the UPC object identified by this URL.
     * A UPC represents a single UPC code in your catalog and matches this product to the tax code identified by this UPC.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaUpc.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns this UPC
     * @param int $id The primary key of this UPC
     * @return UPCModel
     */
    public function getUPC($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/upcs/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve UPCs for this company
     *
     * List all UPC objects attached to this company.
     * A UPC represents a single UPC code in your catalog and matches this product to the tax code identified by this UPC.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaUpc.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that owns these UPCs
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listUPCsByCompany($companyId, $filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/companies/{$companyId}/upcs";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all UPCs
     *
     * Get multiple UPC objects across all companies.
     * A UPC represents a single UPC code in your catalog and matches this product to the tax code identified by this UPC.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, CSPAdmin, CSPTester, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser.
     * * This API depends on the following active services:*Required* (all): AvaUpc.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).
     * @param string $include A comma separated list of additional data to retrieve.
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryUPCs($filter=null, $include=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/upcs";
        $guzzleParams = [
            'query' => ['$filter' => $filter, '$include' => $include, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single UPC
     *
     * Replace the existing UPC object at this URL with an updated object.
     * A UPC represents a single UPC code in your catalog and matches this product to the tax code identified by this UPC.
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, SSTAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaUpc.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The ID of the company that this UPC belongs to.
     * @param int $id The ID of the UPC you wish to update
     * @param UPCModel $model The UPC you wish to update.
     * @return UPCModel
     */
    public function updateUPC($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/upcs/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a User Defined Field by User Defined Field id for a company.
     *
     * Marks the existing user defined field for a company as deleted.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The id of the company the User Defined Field belongs to.
     * @param int $id The id of the User Defined Field you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteUserDefinedField($companyId, $id)    {
        $path = "/api/v2/companies/{$companyId}/userdefinedfields/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * 
     *
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId 
     * @param string $udfType Document or Line level UDF (See UserDefinedFieldType::* for a list of allowable values)
     * @param boolean $allowDefaults If true this will add defaulted UDFs to the list that are not named yet
     * @return FetchResult
     */
    public function listUserDefinedFieldsByCompanyId($companyId, $udfType, $allowDefaults)    {
        $path = "/api/v2/companies/{$companyId}/userdefinedfields";
        $guzzleParams = [
            'query' => ['udfType' => $udfType, 'allowDefaults' => $allowDefaults],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a User Defined Field identified by id for a company
     *
     * Updates a User Defined Field for a company.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, CSPTester, FirmAdmin, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin.
     * * This API depends on the following active services:*Required* (all): AvaTaxPro, BasicReturns.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $companyId The id of the company the user defined field belongs to.
     * @param int $id 
     * @param CompanyUserDefinedFieldModel $model 
     * @return CompanyUserDefinedFieldModel
     */
    public function updateUserDefinedField($companyId, $id, $model)    {
        $path = "/api/v2/companies/{$companyId}/userdefinedfields";
        $guzzleParams = [
            'query' => ['id' => $id],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Change Password
     *
     * Allows a user to change their password via an API call.
     *  
     * This API allows an authenticated user to change their password via an API call. This feature is only available
     * for accounts that do not use SAML integrated password validation.
     *  
     * This API only allows the currently authenticated user to change their password; it cannot be used to apply to a
     * different user than the one authenticating the current API call.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param PasswordChangeModel $model An object containing your current password and the new password.
     * @return string
     */
    public function changePassword($model)    {
        $path = "/api/v2/passwords";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Create new users
     *
     * Create one or more new user objects attached to this account.
     *  
     * A user represents one person with access privileges to make API calls and work with a specific account.
     *  
     * Users who are account administrators or company users are permitted to create user records to invite
     * additional team members to work with AvaTax.
     *  
     * A newly created user will receive an email inviting them to create their password. This means that you
     * must provide a valid email address for all user accounts created.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The unique ID number of the account where these users will be created.
     * @param UserModel[] $model The user or array of users you wish to create.
     * @return UserModel[]
     */
    public function createUsers($accountId, $model)    {
        $path = "/api/v2/accounts/{$accountId}/users";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'21.12.0' );
    }

    /**
     * Delete a single user
     *
     * Mark the user object identified by this URL as deleted.
     *  
     * This API is available for use by account and company administrators only.
     *  
     * Account and company administrators may only delete users within the appropriate organizations
     * they control.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, CompanyAdmin, Compliance Root User, CSPTester, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TreasuryAdmin.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the user you wish to delete.
     * @param int $accountId The accountID of the user you wish to delete.
     * @return ErrorDetail[]
     */
    public function deleteUser($id, $accountId)    {
        $path = "/api/v2/accounts/{$accountId}/users/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve a single user
     *
     * Get the user object identified by this URL.
     * A user represents one person with access privileges to make API calls and work with a specific account.
     *  
     *  You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * FetchDeleted
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the user to retrieve.
     * @param int $accountId The accountID of the user you wish to get.
     * @param string $include Optional fetch commands.
     * @return UserModel
     */
    public function getUser($id, $accountId, $include=null)    {
        $path = "/api/v2/accounts/{$accountId}/users/{$id}";
        $guzzleParams = [
            'query' => ['$include' => $include],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all entitlements for a single user
     *
     * Return a list of all entitlements to which this user has rights to access.
     * Entitlements are a list of specified API calls the user is permitted to make, a list of identifier numbers for companies the user is
     * allowed to use, and an access level identifier that indicates what types of access roles the user is allowed to use.
     * This API call is intended to provide a validation endpoint to determine, before making an API call, whether this call is likely to succeed.
     * For example, if user 567 within account 999 is attempting to create a new child company underneath company 12345, you could preview the user's
     * entitlements and predict whether this call would succeed:
     *  
     * * Retrieve entitlements by calling '/api/v2/accounts/999/users/567/entitlements' . If the call fails, you do not have accurate
     *  credentials for this user.
     * * If the 'accessLevel' field within entitlements is 'None', the call will fail.
     * * If the 'accessLevel' field within entitlements is 'SingleCompany' or 'SingleAccount', the call will fail if the companies
     *  table does not contain the ID number 12345.
     * * If the 'permissions' array within entitlements does not contain 'AccountSvc.CompanySave', the call will fail.
     *  
     * For a full list of defined permissions, please use '/api/v2/definitions/permissions' .
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the user to retrieve.
     * @param int $accountId The accountID of the user you wish to get.
     * @return UserEntitlementModel
     */
    public function getUserEntitlements($id, $accountId)    {
        $path = "/api/v2/accounts/{$accountId}/users/{$id}/entitlements";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve users for this account
     *
     * List all user objects attached to this account.
     * A user represents one person with access privileges to make API calls and work with a specific account.
     *  
     * When an API is called using a legacy AvaTax License Key, the API log entry is recorded as being performed by a special user attached to that license key.
     * By default, this API will not return a listing of license key users. Users with registrar-level security may call this API to list license key users.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * FetchDeleted
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $accountId The accountID of the user you wish to list.
     * @param string $include Optional fetch commands.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* SuppressNewUserEmail
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function listUsersByAccount($accountId, $include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/accounts/{$accountId}/users";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Retrieve all users
     *
     * Get multiple user objects across all accounts.
     *  
     * A user represents one person or set of credentials with access privileges to make API calls and work with a specific account. A user can be authenticated
     * via either username / password authentication, an OpenID / OAuth Bearer Token, or a legacy AvaTax License Key.
     *  
     * When an API is called using a legacy AvaTax License Key, the API log entry is recorded as being performed by a special user attached to that license key.
     * By default, this API will not return a listing of license key users. Users with registrar-level security may call this API to list license key users.
     *  
     * Search for specific objects using the criteria in the `$filter` parameter; full documentation is available on [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/) .
     * Paginate your results using the `$top`, `$skip`, and `$orderby` parameters.
     *  
     * You may specify one or more of the following values in the `$include` parameter to fetch additional nested data, using commas to separate multiple values:
     *  
     * * FetchDeleted
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountOperator, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPAdmin, CSPTester, FirmAdmin, FirmUser, ProStoresOperator, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, SystemOperator, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $include Optional fetch commands.
     * @param string $filter A filter statement to identify specific records to retrieve. For more information on filtering, see [Filtering in REST](http://developer.avalara.com/avatax/filtering-in-rest/).<br />*Not filterable:* SuppressNewUserEmail
     * @param int $top If nonzero, return no more than this number of results. Used with `$skip` to provide pagination for large datasets. Unless otherwise specified, the maximum number of records that can be returned from an API call is 1,000 records.
     * @param int $skip If nonzero, skip this number of results before returning data. Used with `$top` to provide pagination for large datasets.
     * @param string $orderBy A comma separated list of sort statements in the format `(fieldname) [ASC|DESC]`, for example `id ASC`.
     * @return FetchResult
     */
    public function queryUsers($include=null, $filter=null, $top=null, $skip=null, $orderBy=null)    {
        $path = "/api/v2/users";
        $guzzleParams = [
            'query' => ['$include' => $include, '$filter' => $filter, '$top' => $top, '$skip' => $skip, '$orderBy' => $orderBy],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Update a single user
     *
     * Replace the existing user object at this URL with an updated object.
     * A user represents one person with access privileges to make API calls and work with a specific account.
     * All data from the existing object will be replaced with data in the object you PUT.
     * To set a field's value to null, you may either set its value to null or omit that field from the object you post.
     * 
     * ### Security Policies
     * 
     * * This API requires one of the following user roles: AccountAdmin, AccountUser, CompanyAdmin, CompanyUser, Compliance Root User, ComplianceAdmin, ComplianceUser, CSPTester, FirmAdmin, FirmUser, Registrar, SiteAdmin, SSTAdmin, SystemAdmin, TechnicalSupportAdmin, TechnicalSupportUser, TreasuryAdmin, TreasuryUser.
     * Swagger Name: AvaTaxClient
     * 
     * @param int $id The ID of the user you wish to update.
     * @param int $accountId The accountID of the user you wish to update.
     * @param UserModel $model The user object you wish to update.
     * @return UserModel
     */
    public function updateUser($id, $accountId, $model)    {
        $path = "/api/v2/accounts/{$accountId}/users/{$id}";
        $guzzleParams = [
            'query' => [],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'21.12.0' );
    }

    /**
     * Checks if the current user is subscribed to a specific service
     *
     * Returns a subscription object for the current account, or 404 Not Found if this subscription is not enabled for this account.
     *  
     * This API will return an error if it is called with invalid authentication credentials.
     *  
     * This API is intended to help you determine whether you have the necessary subscription to use certain API calls
     * within AvaTax. You can examine the subscriptions returned from this API call to look for a particular product
     * or subscription to provide useful information to the current user as to whether they are entitled to use
     * specific features of AvaTax.
     * Swagger Name: AvaTaxClient
     * 
     * @param string $serviceTypeId The service to check
     * @return SubscriptionModel
     */
    public function getMySubscription($serviceTypeId)    {
        $path = "/api/v2/utilities/subscriptions/{$serviceTypeId}";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * List all services to which the current user is subscribed
     *
     * Returns the list of all subscriptions enabled for the currently logged in user.
     *  
     * This API will return an error if it is called with invalid authentication credentials.
     *  
     * This API is intended to help you determine whether you have the necessary subscription to use certain API calls
     * within AvaTax. You can examine the subscriptions returned from this API call to look for a particular product
     * or subscription to provide useful information to the current user as to whether they are entitled to use
     * specific features of AvaTax.
     * Swagger Name: AvaTaxClient
     * 
     * @return FetchResult
     */
    public function listMySubscriptions()    {
        $path = "/api/v2/utilities/subscriptions";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Tests connectivity and version of the service
     *
     * Check connectivity to AvaTax and return information about the AvaTax API server.
     *  
     * This API is intended to help you verify that your connection is working. This API will always succeed and will
     * never return a error. It provides basic information about the server you connect to:
     *  
     * * `version` - The version number of the AvaTax API server that responded to your request. The AvaTax API version number is updated once per month during Avalara's update process.
     * * `authenticated` - A boolean flag indicating whether or not you sent valid credentials with your API request.
     * * `authenticationType` - If you provided valid credentials to the API, this field will tell you whether you used Bearer, Username, or LicenseKey authentication.
     * * `authenticatedUserName` - If you provided valid credentials to the API, this field will tell you the username of the currently logged in user.
     * * `authenticatedUserId` - If you provided valid credentials to the API, this field will tell you the user ID of the currently logged in user.
     * * `authenticatedAccountId` - If you provided valid credentials to the API, this field will contain the account ID of the currently logged in user.
     *  
     * This API helps diagnose connectivity problems between your application and AvaTax; you may call this API even
     * if you do not have verified connection credentials. If this API fails, either your computer is not connected to
     * the internet, or there is a routing problem between your office and Avalara, or the Avalara server is not available.
     * For more information on the uptime of AvaTax, please see [Avalara's AvaTax Status Page](https://status.avalara.com/).
     * 
     * ### Security Policies
     * 
     * * This API may be called without providing authentication credentials.
     * Swagger Name: AvaTaxClient
     * 
     * @return PingResultModel
     */
    public function ping()    {
        $path = "/api/v2/utilities/ping";
        $guzzleParams = [
            'query' => [],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'21.12.0' );
    }

    /**
     * Determines whether an individual meets or exceeds the minimum legal drinking age.
     *
     * The request must meet the following criteria in order to be evaluated:
     * * *firstName*, *lastName*, and *address* are required fields.
     * * One of the following sets of attributes are required for the *address*:
     *  * *line1, city, region*
     *  * *line1, postalCode*
     * 
     * Optionally, the transaction and its lines may use the following parameters:
     * * A *DOB* (Date of Birth) field. The value should be ISO-8601 compliant (e.g. 2020-07-21).
     * * Beyond the required *address* fields above, a *country* field is permitted
     *  * The valid values for this attribute are [*US, USA*]
     * 
     * **Security Policies**
     * This API depends on the active subscription *AgeVerification*
     * Swagger Name: AvaTaxBeverageClient
     * 
     * @param string $simulatedFailureCode (Optional) The failure code included in the simulated response of the endpoint. Note that this endpoint is only available in Sandbox for testing purposes.
     * @param AgeVerifyRequest $model Information about the individual whose age is being verified.
     * @return AgeVerifyResult
     */
    public function verifyAge($simulatedFailureCode, $model)    {
        $path = "/api/v2/ageverification/verify";
        $guzzleParams = [
            'query' => ['simulatedFailureCode' => $simulatedFailureCode],
            'body' => json_encode($model, JSON_INVALID_UTF8_SUBSTITUTE)
        ];
        return $this->restCall($path, 'POST', $guzzleParams,'' );
    }

    /**
     * Removes the transaction from consideration when evaluating regulations that span multiple transactions.
     *
     * 
     * Swagger Name: AvaTaxBeverageClient
     * 
     * @param string $companyCode The company code of the company that recorded the transaction
     * @param string $transactionCode The transaction code to retrieve
     * @param string $documentType (Optional): The document type of the transaction to operate on. If omitted, defaults to "SalesInvoice"
     * @return 
     */
    public function deregisterShipment($companyCode, $transactionCode, $documentType)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/shipment/registration";
        $guzzleParams = [
            'query' => ['documentType' => $documentType],
            'body' => null
        ];
        return $this->restCall($path, 'DELETE', $guzzleParams,'' );
    }

    /**
     * Registers the transaction so that it may be included when evaluating regulations that span multiple transactions.
     *
     * 
     * Swagger Name: AvaTaxBeverageClient
     * 
     * @param string $companyCode The company code of the company that recorded the transaction
     * @param string $transactionCode The transaction code to retrieve
     * @param string $documentType (Optional): The document type of the transaction to operate on. If omitted, defaults to "SalesInvoice"
     * @return 
     */
    public function registerShipment($companyCode, $transactionCode, $documentType)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/shipment/registration";
        $guzzleParams = [
            'query' => ['documentType' => $documentType],
            'body' => null
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'' );
    }

    /**
     * Evaluates a transaction against a set of direct-to-consumer shipping regulations and, if compliant, registers the transaction so that it may be included when evaluating regulations that span multiple transactions.
     *
     * 
     * Swagger Name: AvaTaxBeverageClient
     * 
     * @param string $companyCode The company code of the company that recorded the transaction
     * @param string $transactionCode The transaction code to retrieve
     * @param string $documentType (Optional): The document type of the transaction to operate on. If omitted, defaults to "SalesInvoice"
     * @return ShippingVerifyResult
     */
    public function registerShipmentIfCompliant($companyCode, $transactionCode, $documentType)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/shipment/registerIfCompliant";
        $guzzleParams = [
            'query' => ['documentType' => $documentType],
            'body' => null
        ];
        return $this->restCall($path, 'PUT', $guzzleParams,'' );
    }

    /**
     * Evaluates a transaction against a set of direct-to-consumer shipping regulations.
     *
     * The transaction and its lines must meet the following criteria in order to be evaluated:
     * * The transaction must be recorded. Using a type of *SalesInvoice* is recommended.
     * * A parameter with the name *AlcoholRouteType* must be specified and the value must be one of the following: '*DTC*', '*Retailer DTC*'
     * * A parameter with the name *RecipientName* must be specified and the value must be the name of the recipient.
     * * Each alcohol line must include a *ContainerSize* parameter that describes the volume of a single container. Use the *unit* field to specify one of the following units: '*Litre*', '*Millilitre*', '*gallon (US fluid)*', '*quart (US fluid)*', '*ounce (fluid US customary)*'
     * * Each alcohol line must include a *PackSize* parameter that describes the number of containers in a pack. Specify *Count* in the *unit* field.
     * 
     * Optionally, the transaction and its lines may use the following parameters:
     * * The *ShipDate* parameter may be used if the date of shipment is different than the date of the transaction. The value should be ISO-8601 compliant (e.g. 2020-07-21).
     * * The *RecipientDOB* parameter may be used to evaluate age restrictions. The value should be ISO-8601 compliant (e.g. 2020-07-21).
     * * The *PurchaserDOB* parameter may be used to evaluate age restrictions. The value should be ISO-8601 compliant (e.g. 2020-07-21).
     * * The *SalesLocation* parameter may be used to describe whether the sale was made *OnSite* or *OffSite*. *OffSite* is the default value.
     * * The *AlcoholContent* parameter may be used to describe the alcohol percentage by volume of the item. Specify *Percentage* in the *unit* field.
     * 
     * **Security Policies**
     * This API depends on all of the following active subscriptions: *AvaAlcohol, AutoAddress, AvaTaxPro*
     * Swagger Name: AvaTaxBeverageClient
     * 
     * @param string $companyCode The company code of the company that recorded the transaction
     * @param string $transactionCode The transaction code to retrieve
     * @param string $documentType (Optional): The document type of the transaction to operate on. If omitted, defaults to "SalesInvoice"
     * @return ShippingVerifyResult
     */
    public function verifyShipment($companyCode, $transactionCode, $documentType)    {
        $path = "/api/v2/companies/{$companyCode}/transactions/{$transactionCode}/shipment/verify";
        $guzzleParams = [
            'query' => ['documentType' => $documentType],
            'body' => null
        ];
        return $this->restCall($path, 'GET', $guzzleParams,'' );
    }

}
?>