<?php
declare(strict_types=1);

/**
 * GroupsApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\GroupsApi;


/**
 * ListGroupUsersOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListGroupUsersOptions
{
    /**
      * $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
      * var null|string
      */
    protected $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * Sets count
     * param null|string $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $start_position Starting value for the list.
      * var null|string
      */
    protected $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * param null|string $start_position Starting value for the list.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * ListGroupsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListGroupsOptions
{
    /**
      * $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
      * var null|string
      */
    protected $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * Sets count
     * param null|string $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $group_type 
      * var null|string
      */
    protected $group_type = null;

    /**
     * Gets group_type
     *
     * @return ?string
     */
    public function getGroupType()
    {
        return $this->group_type;
    }

    /**
     * Sets group_type
     * param null|string $group_type 
     *
     * @return self
     */
    public function setGroupType(?string $group_type): self
    {
        $this->group_type = $group_type;
        return $this;
    }
    /**
      * $include_usercount 
      * var null|string
      */
    protected $include_usercount = null;

    /**
     * Gets include_usercount
     *
     * @return ?string
     */
    public function getIncludeUsercount()
    {
        return $this->include_usercount;
    }

    /**
     * Sets include_usercount
     * param null|string $include_usercount 
     *
     * @return self
     */
    public function setIncludeUsercount(?string $include_usercount): self
    {
        $this->include_usercount = $include_usercount;
        return $this;
    }
    /**
      * $search_text 
      * var null|string
      */
    protected $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText()
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * param null|string $search_text 
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position Starting value for the list.
      * var null|string
      */
    protected $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * param null|string $start_position Starting value for the list.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * GroupsApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GroupsApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = isset($apiClient) && $apiClient ? $apiClient : new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation createGroups
     *
     * Creates one or more groups for the account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function createGroups($account_id, $group_information = null)
    {
        list($response) = $this->createGroupsWithHttpInfo($account_id, $group_information);
        return $response;
    }

    /**
     * Operation createGroupsWithHttpInfo
     *
     * Creates one or more groups for the account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createGroupsWithHttpInfo($account_id, $group_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createGroups');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2.1/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrands
     *
     * Deletes brand information from the requested group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupBrands
     */
    public function deleteBrands($account_id, $group_id, $brands_request = null)
    {
        list($response) = $this->deleteBrandsWithHttpInfo($account_id, $group_id, $brands_request);
        return $response;
    }

    /**
     * Operation deleteBrandsWithHttpInfo
     *
     * Deletes brand information from the requested group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupBrands, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandsWithHttpInfo($account_id, $group_id, $brands_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrands');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling deleteBrands');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups/{groupId}/brands";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "groupId", $group_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($brands_request)) {
            $_tempBody = $brands_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupBrands',
                '/v2.1/accounts/{accountId}/groups/{groupId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupBrands', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupBrands', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteGroupUsers
     *
     * Deletes one or more users from a gro
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UsersResponse
     */
    public function deleteGroupUsers($account_id, $group_id, $user_info_list = null)
    {
        list($response) = $this->deleteGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list);
        return $response;
    }

    /**
     * Operation deleteGroupUsersWithHttpInfo
     *
     * Deletes one or more users from a gro
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UsersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteGroupUsers');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling deleteGroupUsers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups/{groupId}/users";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "groupId", $group_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_info_list)) {
            $_tempBody = $user_info_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UsersResponse',
                '/v2.1/accounts/{accountId}/groups/{groupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UsersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UsersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteGroups
     *
     * Deletes an existing user group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function deleteGroups($account_id, $group_information = null)
    {
        list($response) = $this->deleteGroupsWithHttpInfo($account_id, $group_information);
        return $response;
    }

    /**
     * Operation deleteGroupsWithHttpInfo
     *
     * Deletes an existing user group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupsWithHttpInfo($account_id, $group_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteGroups');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2.1/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrands
     *
     * Gets group brand ID Information.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupBrands
     */
    public function getBrands($account_id, $group_id)
    {
        list($response) = $this->getBrandsWithHttpInfo($account_id, $group_id);
        return $response;
    }

    /**
     * Operation getBrandsWithHttpInfo
     *
     * Gets group brand ID Information.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupBrands, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandsWithHttpInfo($account_id, $group_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrands');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling getBrands');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups/{groupId}/brands";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "groupId", $group_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupBrands',
                '/v2.1/accounts/{accountId}/groups/{groupId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupBrands', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupBrands', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listGroupUsers
     *
     * Gets a list of users in a group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param  \DocuSign\eSign\Api\GroupsApi\ListGroupUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UsersResponse
     */
    public function listGroupUsers($account_id, $group_id, \DocuSign\eSign\Api\GroupsApi\ListGroupUsersOptions $options = null)
    {
        list($response) = $this->listGroupUsersWithHttpInfo($account_id, $group_id, $options);
        return $response;
    }

    /**
     * Operation listGroupUsersWithHttpInfo
     *
     * Gets a list of users in a group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param  \DocuSign\eSign\Api\GroupsApi\ListGroupUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UsersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listGroupUsersWithHttpInfo($account_id, $group_id, \DocuSign\eSign\Api\GroupsApi\ListGroupUsersOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listGroupUsers');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling listGroupUsers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups/{groupId}/users";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "groupId", $group_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UsersResponse',
                '/v2.1/accounts/{accountId}/groups/{groupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UsersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UsersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listGroups
     *
     * Gets information about groups associated with the account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\GroupsApi\ListGroupsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function listGroups($account_id, \DocuSign\eSign\Api\GroupsApi\ListGroupsOptions $options = null)
    {
        list($response) = $this->listGroupsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listGroupsWithHttpInfo
     *
     * Gets information about groups associated with the account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\GroupsApi\ListGroupsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listGroupsWithHttpInfo($account_id, \DocuSign\eSign\Api\GroupsApi\ListGroupsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listGroups');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getGroupType() != 'null') {
                $queryParams['group_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getGroupType());
            }
            if ($options->getIncludeUsercount() != 'null') {
                $queryParams['include_usercount'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeUsercount());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2.1/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrands
     *
     * Adds group brand ID information to a group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupBrands
     */
    public function updateBrands($account_id, $group_id, $brands_request = null)
    {
        list($response) = $this->updateBrandsWithHttpInfo($account_id, $group_id, $brands_request);
        return $response;
    }

    /**
     * Operation updateBrandsWithHttpInfo
     *
     * Adds group brand ID information to a group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupBrands, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandsWithHttpInfo($account_id, $group_id, $brands_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrands');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling updateBrands');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups/{groupId}/brands";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "groupId", $group_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($brands_request)) {
            $_tempBody = $brands_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupBrands',
                '/v2.1/accounts/{accountId}/groups/{groupId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupBrands', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupBrands', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateGroupUsers
     *
     * Adds one or more users to an existing group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UsersResponse
     */
    public function updateGroupUsers($account_id, $group_id, $user_info_list = null)
    {
        list($response) = $this->updateGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list);
        return $response;
    }

    /**
     * Operation updateGroupUsersWithHttpInfo
     *
     * Adds one or more users to an existing group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UsersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateGroupUsers');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling updateGroupUsers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups/{groupId}/users";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "groupId", $group_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_info_list)) {
            $_tempBody = $user_info_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UsersResponse',
                '/v2.1/accounts/{accountId}/groups/{groupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UsersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UsersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateGroups
     *
     * Updates the group information for a group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function updateGroups($account_id, $group_information = null)
    {
        list($response) = $this->updateGroupsWithHttpInfo($account_id, $group_information);
        return $response;
    }

    /**
     * Operation updateGroupsWithHttpInfo
     *
     * Updates the group information for a group.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupsWithHttpInfo($account_id, $group_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateGroups');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/groups";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] =$this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2.1/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
