<?php
/**
 * LinkedExternalPrimaryAccount
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * LinkedExternalPrimaryAccount Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class LinkedExternalPrimaryAccount implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'linkedExternalPrimaryAccount';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'account_name' => '?string',
        'configuration_id' => '?string',
        'email' => '?string',
        'link_id' => '?string',
        'pdf_field_handling_option' => '?string',
        'recipient_auth_requirements' => '\DocuSign\eSign\Model\ExternalPrimaryAccountRecipientAuthRequirements',
        'status' => '?string',
        'user_id' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'account_name' => null,
        'configuration_id' => null,
        'email' => null,
        'link_id' => null,
        'pdf_field_handling_option' => null,
        'recipient_auth_requirements' => null,
        'status' => null,
        'user_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account_name' => 'accountName',
        'configuration_id' => 'configurationId',
        'email' => 'email',
        'link_id' => 'linkId',
        'pdf_field_handling_option' => 'pdfFieldHandlingOption',
        'recipient_auth_requirements' => 'recipientAuthRequirements',
        'status' => 'status',
        'user_id' => 'userId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account_name' => 'setAccountName',
        'configuration_id' => 'setConfigurationId',
        'email' => 'setEmail',
        'link_id' => 'setLinkId',
        'pdf_field_handling_option' => 'setPdfFieldHandlingOption',
        'recipient_auth_requirements' => 'setRecipientAuthRequirements',
        'status' => 'setStatus',
        'user_id' => 'setUserId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account_name' => 'getAccountName',
        'configuration_id' => 'getConfigurationId',
        'email' => 'getEmail',
        'link_id' => 'getLinkId',
        'pdf_field_handling_option' => 'getPdfFieldHandlingOption',
        'recipient_auth_requirements' => 'getRecipientAuthRequirements',
        'status' => 'getStatus',
        'user_id' => 'getUserId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account_name'] = isset($data['account_name']) ? $data['account_name'] : null;
        $this->container['configuration_id'] = isset($data['configuration_id']) ? $data['configuration_id'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['link_id'] = isset($data['link_id']) ? $data['link_id'] : null;
        $this->container['pdf_field_handling_option'] = isset($data['pdf_field_handling_option']) ? $data['pdf_field_handling_option'] : null;
        $this->container['recipient_auth_requirements'] = isset($data['recipient_auth_requirements']) ? $data['recipient_auth_requirements'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets account_name
     *
     * @return ?string
     */
    public function getAccountName()
    {
        return $this->container['account_name'];
    }

    /**
     * Sets account_name
     *
     * param null|string $account_name 
     *
     * @return $this
     */
    public function setAccountName($account_name)
    {
        $this->container['account_name'] = $account_name;

        return $this;
    }

    /**
     * Gets configuration_id
     *
     * @return ?string
     */
    public function getConfigurationId()
    {
        return $this->container['configuration_id'];
    }

    /**
     * Sets configuration_id
     *
     * param null|string $configuration_id 
     *
     * @return $this
     */
    public function setConfigurationId($configuration_id)
    {
        $this->container['configuration_id'] = $configuration_id;

        return $this;
    }

    /**
     * Gets email
     *
     * @return ?string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * param null|string $email 
     *
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets link_id
     *
     * @return ?string
     */
    public function getLinkId()
    {
        return $this->container['link_id'];
    }

    /**
     * Sets link_id
     *
     * param null|string $link_id 
     *
     * @return $this
     */
    public function setLinkId($link_id)
    {
        $this->container['link_id'] = $link_id;

        return $this;
    }

    /**
     * Gets pdf_field_handling_option
     *
     * @return ?string
     */
    public function getPdfFieldHandlingOption()
    {
        return $this->container['pdf_field_handling_option'];
    }

    /**
     * Sets pdf_field_handling_option
     *
     * param null|string $pdf_field_handling_option 
     *
     * @return $this
     */
    public function setPdfFieldHandlingOption($pdf_field_handling_option)
    {
        $this->container['pdf_field_handling_option'] = $pdf_field_handling_option;

        return $this;
    }

    /**
     * Gets recipient_auth_requirements
     *
     * @return \DocuSign\eSign\Model\ExternalPrimaryAccountRecipientAuthRequirements
     */
    public function getRecipientAuthRequirements()
    {
        return $this->container['recipient_auth_requirements'];
    }

    /**
     * Sets recipient_auth_requirements
     *
     * @param \DocuSign\eSign\Model\ExternalPrimaryAccountRecipientAuthRequirements $recipient_auth_requirements 
     *
     * @return $this
     */
    public function setRecipientAuthRequirements($recipient_auth_requirements)
    {
        $this->container['recipient_auth_requirements'] = $recipient_auth_requirements;

        return $this;
    }

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * param null|string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return ?string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * param null|string $user_id 
     *
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

