<?php
/**
 * OfflineAttributes
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * OfflineAttributes Class Doc Comment
 *
 * @category    Class
 * @description DocuSign internal use, but it is needed for swagger tools (go lang, Elixir/OTP) to generate client library.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OfflineAttributes implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'offlineAttributes';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'account_esign_id' => '?string',
        'device_model' => '?string',
        'device_name' => '?string',
        'gps_latitude' => '?string',
        'gps_longitude' => '?string',
        'offline_signing_hash' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'account_esign_id' => null,
        'device_model' => null,
        'device_name' => null,
        'gps_latitude' => null,
        'gps_longitude' => null,
        'offline_signing_hash' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account_esign_id' => 'accountEsignId',
        'device_model' => 'deviceModel',
        'device_name' => 'deviceName',
        'gps_latitude' => 'gpsLatitude',
        'gps_longitude' => 'gpsLongitude',
        'offline_signing_hash' => 'offlineSigningHash'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account_esign_id' => 'setAccountEsignId',
        'device_model' => 'setDeviceModel',
        'device_name' => 'setDeviceName',
        'gps_latitude' => 'setGpsLatitude',
        'gps_longitude' => 'setGpsLongitude',
        'offline_signing_hash' => 'setOfflineSigningHash'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account_esign_id' => 'getAccountEsignId',
        'device_model' => 'getDeviceModel',
        'device_name' => 'getDeviceName',
        'gps_latitude' => 'getGpsLatitude',
        'gps_longitude' => 'getGpsLongitude',
        'offline_signing_hash' => 'getOfflineSigningHash'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account_esign_id'] = isset($data['account_esign_id']) ? $data['account_esign_id'] : null;
        $this->container['device_model'] = isset($data['device_model']) ? $data['device_model'] : null;
        $this->container['device_name'] = isset($data['device_name']) ? $data['device_name'] : null;
        $this->container['gps_latitude'] = isset($data['gps_latitude']) ? $data['gps_latitude'] : null;
        $this->container['gps_longitude'] = isset($data['gps_longitude']) ? $data['gps_longitude'] : null;
        $this->container['offline_signing_hash'] = isset($data['offline_signing_hash']) ? $data['offline_signing_hash'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets account_esign_id
     *
     * @return ?string
     */
    public function getAccountEsignId()
    {
        return $this->container['account_esign_id'];
    }

    /**
     * Sets account_esign_id
     *
     * param null|string $account_esign_id A GUID identifying the account associated with the consumer disclosure
     *
     * @return $this
     */
    public function setAccountEsignId($account_esign_id)
    {
        $this->container['account_esign_id'] = $account_esign_id;

        return $this;
    }

    /**
     * Gets device_model
     *
     * @return ?string
     */
    public function getDeviceModel()
    {
        return $this->container['device_model'];
    }

    /**
     * Sets device_model
     *
     * param null|string $device_model A string containing information about the model of the device used for offline signing.
     *
     * @return $this
     */
    public function setDeviceModel($device_model)
    {
        $this->container['device_model'] = $device_model;

        return $this;
    }

    /**
     * Gets device_name
     *
     * @return ?string
     */
    public function getDeviceName()
    {
        return $this->container['device_name'];
    }

    /**
     * Sets device_name
     *
     * param null|string $device_name A string containing information about the type of device used for offline signing.
     *
     * @return $this
     */
    public function setDeviceName($device_name)
    {
        $this->container['device_name'] = $device_name;

        return $this;
    }

    /**
     * Gets gps_latitude
     *
     * @return ?string
     */
    public function getGpsLatitude()
    {
        return $this->container['gps_latitude'];
    }

    /**
     * Sets gps_latitude
     *
     * param null|string $gps_latitude A string containing the latitude of the device location at the time of signing.
     *
     * @return $this
     */
    public function setGpsLatitude($gps_latitude)
    {
        $this->container['gps_latitude'] = $gps_latitude;

        return $this;
    }

    /**
     * Gets gps_longitude
     *
     * @return ?string
     */
    public function getGpsLongitude()
    {
        return $this->container['gps_longitude'];
    }

    /**
     * Sets gps_longitude
     *
     * param null|string $gps_longitude A string containing the longitude of the device location at the time of signing.
     *
     * @return $this
     */
    public function setGpsLongitude($gps_longitude)
    {
        $this->container['gps_longitude'] = $gps_longitude;

        return $this;
    }

    /**
     * Gets offline_signing_hash
     *
     * @return ?string
     */
    public function getOfflineSigningHash()
    {
        return $this->container['offline_signing_hash'];
    }

    /**
     * Sets offline_signing_hash
     *
     * param null|string $offline_signing_hash 
     *
     * @return $this
     */
    public function setOfflineSigningHash($offline_signing_hash)
    {
        $this->container['offline_signing_hash'] = $offline_signing_hash;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

