<?php

namespace ZipStream\Option;

use DateTime;

final class File
{
    /**
     * @var string
     */
    private $comment = '';
    /**
     * @var Method
     */
    private $method;
    /**
     * @var int
     */
    private $deflateLevel;
    /**
     * @var DateTime
     */
    private $time;
    /**
     * @var int
     */
    private $size = 0;

    public function defaultTo($archiveOptions)
    {
        $this->deflateLevel = $this->deflateLevel ? $this->deflateLevel : $archiveOptions->getDeflateLevel();
        $this->time = $this->time ? $this->time : new DateTime();
    }

    /**
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param string $comment
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
    }

    /**
     * @return Method
     */
    public function getMethod()
    {
        return $this->method ? $this->method : Method::DEFLATE();
    }

    /**
     * @param Method $method
     */
    public function setMethod($method)
    {
        $this->method = $method;
    }

    /**
     * @return int
     */
    public function getDeflateLevel()
    {
        return $this->deflateLevel ?: Archive::DEFAULT_DEFLATE_LEVEL;
    }

    /**
     * @param int $deflateLevel
     */
    public function setDeflateLevel($deflateLevel)
    {
        $this->deflateLevel = $deflateLevel;
    }

    /**
     * @return DateTime
     */
    public function getTime()
    {
        return $this->time;
    }

    /**
     * @param DateTime $time
     */
    public function setTime($time)
    {
        $this->time = $time;
    }

    /**
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @param int $size
     */
    public function setSize($size)
    {
        $this->size = $size;
    }
}
