window.qbImportRunnerActive = false;
window.isQbImportPaused = false;
window.alertOnNextError = true;
window.suspendQBQueueUpdates = false;
window.qbImport_Step_Active = 0;
window.qbImport_Action_Active = 0;
window.qbImportStartLocked = 0;
window.suspendUIUpdates = 0;
window.qbimportUnfulfilledRequirementDialog = null;
window.qbimportUnfulfilledRequirementLastShownGUID = null;
window.qbimportUnfulfilledRequirementLastShownPushGUID = null;
window.qbImport_AfterStepStack = [];
window.qbImport_AfterStepOnce = [];
window.qbImport_QueuedUserMessages = [];
window.enqueueActionActive = false;
window.enqueueActions = {};
if(typeof(window.qbimport_auto_start) == 'undefined') window.qbimport_auto_start = false;
if(typeof(window.STR_ERROR_IMPORTING) == 'undefined') window.STR_ERROR_IMPORTING = 'Error Importing';
if(typeof(window.STR_CLOSE) == 'undefined') window.STR_CLOSE = 'Close';
if(typeof(window.STR_RETRY) == 'undefined') window.STR_RETRY = 'Retry';
if(typeof(window.STR_IGNORE) == 'undefined') window.STR_IGNORE = 'Ignore';
if(typeof(window.STR_CONTINUE) == 'undefined') window.STR_CONTINUE = 'Continue';
if(typeof(window.STR_SAVED) == 'undefined') window.STR_SAVED = 'Saved';
if(typeof(window.STR_SAVE) == 'undefined') window.STR_SAVE = 'Save';
if(typeof(window.STR_SAVING) == 'undefined') window.STR_SAVING = 'Saving';
if(typeof(window.STR_IMPORT_PAUSED) == 'undefined') window.STR_IMPORT_PAUSED = 'Import Pasued';
if(typeof(window.STR_RESUMING_IMPORT) == 'undefined') window.STR_RESUMING_IMPORT = 'Resuming Import';
if(typeof(window.STR_IMPORT_STARTED) == 'undefined') window.STR_IMPORT_STARTED = 'Import Started';
if(typeof(window.STR_NO_RECORDS_FOUND) == 'undefined') window.STR_NO_RECORDS_FOUND = 'No Records Found';
if(typeof(window.STR_QUEUED) == 'undefined') window.STR_QUEUED = 'Queued';
if(typeof(window.STR_SHOW_DETAILS) == 'undefined') window.STR_SHOW_DETAILS = 'Show Details';
if(typeof(window.STR_NOTICE) == 'undefined') window.STR_NOTICE = 'Notice';
if(typeof(window.STR_A_REQUIRED_SETTING_IS_UNDEFINED) == 'undefined') window.STR_A_REQUIRED_SETTING_IS_UNDEFINED = 'A required setting is undefined.';
if(typeof(window.STR_CONNECTION_ERROR) == 'undefined') window.STR_CONNECTION_ERROR = 'Connection Error';

function suspendQbImportUI(){
	window.suspendUIUpdates++;
}
function resumeQbImportUI(){
	if(window.suspendUIUpdates > 0) window.suspendUIUpdates--;
}

$(function(){
	updateQBQueue_Update();
	if(window.qbimport_auto_start){
		btnImportAll_Click(null, null);
	}
});

function btnImportAll_Click(sender, event){
	$('#tblQBImportTasks input[type="checkbox"]').each(function(){ this.checked = true; });
	btnImportSelected_Click(sender, event);
}

function btnImportSelected_Click(sender, event){
	//Make UI readonly
	$('#tblQBImportTasks input[type="checkbox"]:checked').each(function(){
		$(this).closest('td').find('.checkboxOverlay').css('opacity', 0.75);
		$(this).closest('td').css('cursor', 'default').next().css('cursor', 'default');
	}).prop('readonly', true).prop('disabled', true);
	//Remove Unwanted actions
	$('#tblQBImportTasks input[type="checkbox"]:not(:checked)').each(function(){
		$(this).closest('tr').remove();
	});
	//Build POST data
	var importkeys = [];
	$("#tblQBImportTasks tr[import-key]").each(function(){
		importkeys.push($(this).closest('tr[import-key]').attr('import-key'));
	});
	//Save Selection
	$.ajaxRetry({
		url: CI_BASE_URL+'qbimport/qbimport/saveImportSelection/',
		method: 'post',
		dataType: 'json',
		data: {importkeys: importkeys},
	});
	//Begin The Runner
	window.alertOnNextError = true;
	if(!window.qbImportRunnerActive) pauseImport(window.STR_IMPORT_STARTED, '<i class="fas fa-play"></i>', 1000);
	qbImportRunnerStart();
}

function qbImportRunnerStart(){
	window.qbimportUnfulfilledRequirementLastShownGUID = window.qbimportUnfulfilledRequirementLastShownPushGUID = null;
	if(!window.qbImportRunnerActive){
		window.alertOnNextError = true;
		window.qbImportRunnerActive = true;
		setInterval(qbImport_Step, 1000);
	}
	$('#tbQbImportAll').hide();
	$('#tbQbImportSelected').hide();
	setPausedState(false);
}

function qbimport_hasExportIterationTypeQueued(){
	var cssSelector = 'tr[import-is-iteration-type="1"]:not([qb-queue-status="e"]):not([qb-queue-status="z"]):not([qb-queue-status="n"]):not([qb-queue-status=""])';
	var found = $(cssSelector);
	return found.length > 0;
}

function qbImport_Step(){
	if(window.isQbImportPaused) return;
	if(window.qbImport_Step_Active > 0) return;
	window.qbImport_Step_Active++;

	//Queue Next Export...
	if(!qbimport_hasExportIterationTypeQueued() && !window.enqueueActionActive){
		var css  = 'tr[import-action]:not(.qbExportQueueRequested):not(.qbExportQueued):not([qb-queue-status="i"]):not([qb-queue-status="z"]):not([qb-queue-status="q"]):not([qb-queue-status="n"]):not([no-export-queue="1"])';
		var nextTr = $(css);
		var action = nextTr.attr('qb-export-src');
		if(typeof(action) == 'undefined' || action === null || action === '') action = nextTr.attr('import-key');
		if(typeof(action) != 'undefined' && action !== null && action !== ''){
			var tr = $('tr[import-key="'+nextTr.attr('import-key')+'"]'+(typeof(nextTr.attr('qb-export-src')) != 'undefined' && nextTr.attr('qb-export-src') != '' ? ', tr[qb-export-src="'+nextTr.attr('qb-export-src')+"]" : ''));
			if(tr.length > 0){
				tr.addClass('qbExportQueueRequested');
				enqueueAction(action)
					.fail(function(){
						tr.removeClass('qbExportQueued');
						tr.removeClass('qbExportQueueRequested');
						tr.addClass('qbExportQueueRequestFailed');
					})
					.done(function(r){
						if(typeof(r.success) !== 'undefined' && r.success){
							tr.removeClass('qbExportQueueRequestFailed');
							tr.addClass('qbExportQueued');
						}
						else {
							tr.addClass('qbExportQueueRequestFailed');
							tr.removeClass('qbExportQueueRequested');
							tr.removeClass('qbExportQueued');
						}
					});
			}

		}
	}

	//Execute Next Ready Import...
	if($('tr.npImportActive, tr.npImportRequested:not(.npImportDone)').length == 0){
		//Is there a pending error that needs to resolved first?
		var tr2 = $('tr[import-key]:not([np-import-result]):not([qb-queue-status="n"]), tr[import-key].npImportRetryFromError:not([qb-queue-status="n"]), tr[import-key][np-import-result="0"]:not([qb-queue-status="n"]):not(.npImportIgnoreErrors):not(.npImportRetryFromError)');
		var trErr = $('tr[np-import-result="0"]:not(.npImportIgnoreErrors):not(.npImportRetryFromError)');
		if(tr2.length != 0 && trErr.length == 0){
			//Find Next to run
			var nextTr = $(tr2[0]);
			var nextTrOrder = parseInt($(tr).attr('import-order'));
			tr2.each(function(){
				var maybeNextTrOrder = parseInt($(this).attr('import-order'));
				if(maybeNextTrOrder < nextTrOrder){
					nextTrOrder = maybeNextTrOrder;
					nextTr = $(this);
				}
			});
			tr2 = nextTr;
			//Next import step is not waiting for export still
			if(tr2.attr('qb-queue-status') == 'z' || tr2.is('[no-export-queue="1"][qb-queue-status=""]')) {
				if(window.qbImport_Action_Active == 0){
					//Verify no existing loading statuses in the import-column
					if($('.np-import-status > loading-32, .np-import-status > loading-64, .np-import-status > loading-24').length == 0) {

						//Flag as loading, and unflag errors
						tr2.addClass('npImportActive');
						tr2.removeClass('npImportIgnoreErrors');
						tr2.removeClass('npImportRetryFromError');
						tr2.addClass('npImportRequested');
						tr2.find('td.np-import-status').html('<loading-32></loading-32><span class="np-import-progress"></span>');
						tr2.attr('import-started', Date.now());

						//Start the import AJAX
						window.qbImport_Action_Active++;
						importAction(tr2.attr("import-key"))
							.fail(function(){
								tr2.attr('import-failed', Date.now());
								tr2.attr('np-import-result', '0');
								tr2.removeClass('npImportActive');
								tr2.removeClass('npImportRequested');
								tr2.removeClass('npImportRetryFromError');
								tr2.addClass('npImportFailed');
							})
							.done(function(r){
								tr2.attr('import-done', Date.now());
								tr2.removeClass('npImportActive');
								tr2.removeClass('npImportFailed');
								tr2.removeClass('npImportRetryFromError');
								tr2.addClass('npImportDone');
							})
							.then(function(){
								setTimeout(function(){
									if(tr2.find('td.np-import-status').html() == '<loading-32></loading-32><span class="np-import-progress"></span>') tr2.find('td.np-import-status').html('');
								}, 1000);
								setTimeout(function(){
									window.qbImport_Action_Active--;
								}, 1000);
							});
					}
				}
			}
		}
		else if(window.alertOnNextError && trErr.length > 0) {
			pauseForImportError(window.alertOnNextError);
			window.alertOnNextError = false;
		}
	}

	window.qbImport_Step_Active--;
}

function qbImport_AfterStep(callable, once){
	if(typeof(callable) == 'undefined') {
		for(var i in window.qbImport_AfterStepStack) window.qbImport_AfterStepStack[i]();
		for(var i in window.qbImport_AfterStepOnce) window.qbImport_AfterStepOnce[i]();
		window.qbImport_AfterStepOnce = [];
	}
	else if(typeof(callable) == 'function') {
		if(typeof(once) == 'undefined' || !once) window.qbImport_AfterStepStack.push(callable);
		else window.qbImport_AfterStepOnce.push(callable);
	}
}

function pauseForImportError(quick){
	var trErr = $('tr[qb-queue-status="z"][np-import-result="0"]:not(.npImportIgnoreErrors):not(.npImportRetryFromError)');
	var msg = '<b style="font-size: 1.1em;">'+window.STR_ERROR_IMPORTING+':<br>'+trErr.attr('title')+'</b><br><br>'+window.STR_IMPORT_PAUSED;
	var buttons = {};
	buttons[window.STR_SHOW_DETAILS] = function(){
		$(trErr.find('td.np-import-status img').get(0)).trigger('click');
		UI.pushMessageClose();
	};
	pauseImport(msg, 'error', 0, buttons);

	$('#tbQbImportContinue').css('opacity', 0.5);
	window.qbImportStartLocked++;
	setTimeout(function(){ window.qbImportStartLocked--; if(window.qbImportStartLocked == 0) $('#tbQbImportContinue').css('opacity', 1); }, 500);

	if(trErr.length > 0){
		var section_view = $('#section_view');
		var offset = trErr.offset().top;
		if(section_view.length > 0){
			section_view.css('scroll-behavior', 'smooth');
			offset += section_view[0].scrollTop;
		}
		if(offset > 0) {
			offset -= section_view.length > 0 ? (section_view.height() / 2) : 0;
			if(section_view.length > 0){
				setTimeout(function(){
					$('#section_view').css('scroll-behavior', 'smooth')[0].scrollTop = offset;
				}, 1);
			}
		}
		UI.shake(trErr.find('td.np-import-status img'));
		trErr.find('td').addClass('emergency');
		setTimeout(function(){ trErr.find('td').removeClass('emergency'); }, 8000);
	}
}

function updateQBQueue_Update(){
	if(window.suspendUIUpdates <= 0){
		updateQBQueue().then(function(){
			setTimeout(updateQBQueue_Update, 1000);
		});
	}
	else {
		setTimeout(updateQBQueue_Update, 1000);
	}
}

function updateQBQueue(){
	var promise = new PromiseObj();
	window.updateQBQueueAjax = $.ajaxRetry({
		url: CI_BASE_URL+'/qbimport/qbimport/getQBQueue',
		method: 'POST',
		dataType: 'json',
		success: function(data, textStatus, jqXHR){
			window.qbImportUpdateData = data;
			if(window.suspendUIUpdates <= 0) {

				//Clear the 'checking...' text
				$('tr[import-action] > td.qb-export-status.statusPendingLoad, tr[import-action] > td.np-import-status.statusPendingLoad').html('<span class="np-import-progress"></span>').removeClass('statusPendingLoad');

				//Export Side
				for(var id in data.queue){
					var q = data.queue[id];
					var parts = data.queue[id].parts;
					var is_iterator_type = data.queue[id].is_iterator_type;
					var iteratorIndex = data.queue[id].iteratorIndex;
					var parts_progress = (is_iterator_type || parts > 0) && data.queue[id].parts_progress > 0 ? ((data.queue[id].parts_progress * 0.95).toFixed(0) + '%') : '';
					if(is_iterator_type && iteratorIndex == 0) parts_progress = '';
					if(parts_progress !== '') parts_progress = '<span class="qb-export-parts-progress-label">'+parts_progress+'</span>';
					var tr = $('tr[import-action="'+q.qb_action+'"]');
					switch(q.qb_status){
						case 's': status_html = '<loading-32></loading-32><div style="text-align: center; height: 0px; position: relative; text-align: center;"><i style="color: var(--ui-style-table-header-background-end); position: relative; left: 14px; top: -14px;" class="fa fa-compress"></i></div>'; break;
						case 'z': status_html = '<img src="images/accept.png" style="width: 24px; height: 24px;">'; break;
						case 'n': status_html = '<img src="images/accept.png" style="width: 24px; height: 24px; opacity: 0.5px;" title="">'; break;
						case 'i': status_html = '<loading-32></loading-32>'+parts_progress; break;
						case 'q': status_html = window.STR_QUEUED+'<loading-ellip></loading-ellip>'; break;
						case 'e': status_html = '<img onclick="imgQbStatusError_Click(this, event)" src="images/error.png" style="width: 24px; height: 24px; cursor: pointer;">'; break;
						default: status_html = '<img onclick="imgQbStatusError_Click(this, event)" src="images/error.png" style="width: 24px; height: 24px; cursor: pointer;" title="Unknown status of \''+q.qb_status+'\'!">'; break;
					}

					var isNoExportType = tr.is('[no-export-queue="1"][qb-export-src=""]');
					var td = tr.find('.qb-export-status')[0];
					if(typeof(td) != 'undefined'){
						if(isNoExportType){
							var faSlashHTML = '<i class="fas fa-slash" style="opacity: 0.5;"></i>';
							if(td.innerHTML != faSlashHTML) td.innerHTML = faSlashHTML;
						}
						else {
							status_html += '<span class="np-import-progress"></span>';
							if(td.innerHTML != status_html) td.innerHTML = status_html;

							td = tr.find('.qb-export-queued')[0];
							if(td.innerHTML != q.enqueue_datetime) td.innerHTML = q.enqueue_datetime;

							td = tr.find('.qb-export-timespan')[0];
							if(td.innerHTML != q.processing_time) td.innerHTML = q.processing_time;
						}
					}

					if(tr.attr("qb-queue-msg") != q.msg) tr.attr("qb-queue-msg", q.msg);
					if(tr.attr("qb-queue-status") != q.qb_status) tr.attr("qb-queue-status", q.qb_status);

					if(q.qb_status == 'z'){
						var img = $('<img src="images/view.png" class="imgQBStatusZView" style="width: 24px; height: 24px; cursor: pointer;">');
						var elm = tr.find('.qb-export-view');
						if(elm.find('.imgQBStatusZView').length == 0){
							img.on('click', function(){
								var tr = $(this).closest('tr');
								var type = tr.attr("import-filename");
								if(typeof(type) == 'undefined' || type == '') type = tr.attr("qb-export-src");
								if(typeof(type) == 'undefined' || type == '') type = tr.attr("import-key");
								UI.open(CI_BASE_URL+'qbimport/qbimport/viewExport/?&type='+type);
							});
							elm.html('').append(img);
						}
					}
				}

				//Import Side
				for(var key in data.import){
					var value = data.import[key];
					if(key.indexOf('.') !== -1){
						var parts = key.split('.');
						var import_key = parts[0];
						var import_param = parts[1];
						var tr = $('tr[import-key="'+import_key+'"]');
						if(tr.length > 0){
							if(import_param == 'result'){
								var setHtml = '';
								if(value == 1) setHtml = '<img src="images/accept.png" style="width: 24px; height: 24px;">';
								else if(value === null) {
									//setHtml = '<loading-32></loading-32><span class="np-import-progress-null"></span>';
								}
								else setHtml = '<img onclick="imgImportStatusError_Click(this, event)" src="images/error.png" style="width: 24px; height: 24px; cursor: pointer;">';
								var elm = tr.find('td.np-import-status')[0];
								if(elm.innerHTML != setHtml) {
									if(value === null) {
										if(elm.innerHTML.indexOf('<loading-32>') < 0) elm.innerHTML = setHtml;
									}
									else {
										elm.innerHTML = setHtml;
									}
								}
								var setAttr = value === null ? '' : value.toString();
								if(tr.attr('np-import-result') != setAttr) tr.attr('np-import-result', setAttr);
							}
							else if(import_param == 'unfulfilledRequirement'){
								if(value != null) showUnfulfilledRequirementDialog();
							}
							else if(import_param == 'startedlbl'){
								var elm = tr.find('td.np-import-started')[0];
								if(elm.innerHTML != value) elm.innerHTML = value;
							}
							else if(import_param == 'log'){
								var setAttr = value === null ? '' : value.toString();
								if(tr.attr('np-import-log') != setAttr) tr.attr('np-import-log', setAttr);
							}
							else if(import_param == 'timespan'){
								var elm = tr.find('td.np-import-timespan')[0];
								if(elm.innerHTML != value) elm.innerHTML = value;
							}
							else if(import_param == 'count'){
								var setAttr = value === null ? '' : value.toString();
								if(tr.attr('np-import-count') != setAttr) tr.attr('np-import-count', setAttr);
							}
							else if(import_param == 'ignoreerrors'){
								var setAttr = value === null ? '' : value.toString();
								if(setAttr == '1'){
									if(!tr.is('.npImportIgnoreErrors')) tr.addClass('npImportIgnoreErrors');
								}
								else if(tr.is('.npImportIgnoreErrors')) tr.removeClass('npImportIgnoreErrors');
							}
							else if(import_param == 'progress'){
								setQBImportProgress(tr, value === null ? '' : value.toString())
							}
							else if(import_param == 'success'){
								var setAttr = value === null ? '' : value.toString();
								if(setAttr == '1'){
									if(!tr.is('.npImportSuccess')) tr.addClass('npImportSuccess');
								}
								else {
									if(tr.is('.npImportSuccess')) tr.removeClass('npImportSuccess');
								}
							}
						}
					}
				}

				$('tr[qb-queue-status="n"]:not([import-key="recordcount"]):not([import-key="cleanup"])').attr('title', STR_NO_RECORDS_FOUND);

				//Set no-records-found TD content
				{
					var faSlashHTML = '<i class="fas fa-slash" style="opacity: 0.5;"></i>';
					$('tr[qb-queue-status="n"]:not([import-key="cleanup"]) > td.np-import-status').each(function(){
						if(this.innerHTML !== faSlashHTML) this.innerHTML = faSlashHTML;
					});
					var skipExportViewHtml = '<img src="images/view.png" style="width: 24px; height: 24px; opacity: 0.75; cursor: no-drop;"><div style="height: 0px; font-size: 0.7em; opacity: 0.75; position: relative; top: -2px;">'+window.STR_NO_RECORDS_FOUND+'</div>';
					$('tr[qb-queue-status="n"]:not([import-key="recordcount"]):not([import-key="cleanup"]) > td.qb-export-view').each(function(){
						if(this.innerHTML !== skipExportViewHtml) this.innerHTML = skipExportViewHtml;
					});
					$('tr[qb-queue-status="n"]:not([import-key="cleanup"]) > td.np-import-started').each(function(){
						if(this.innerHTML !== faSlashHTML) this.innerHTML = faSlashHTML;
					});
					$('tr[qb-queue-status="n"]:not([import-key="cleanup"]) > td.np-import-timespan').each(function(){
						if(this.innerHTML !== faSlashHTML) this.innerHTML = faSlashHTML;
					});
				}
			}

			promise.done({data: data, textStatus: textStatus, jqXHR: jqXHR});
		},
		error: function(data, textStatus, errorThrown){
			promise.fail({data: data, textStatus: textStatus, errorThrown: errorThrown});
		},
		complete: function(data, textStatus, jqXHR){
			promise.always({data: data, textStatus: textStatus});
			promise.then({data: data, textStatus: textStatus, jqXHR: jqXHR});
		},
	});
	return promise;
}

function cbImport_Change(sender, event){

}

function btnDeleteExportCache_Click(sender, event){
	setPausedState(true);
	$('.qbimport-diag:visible').dialog('close');
	if(typeof(STR_ARE_YOU_SURE_DELETE) == 'undefined') window.STR_ARE_YOU_SURE_DELETE = 'Are you sure you want to delete this?';
	if(!confirm(STR_ARE_YOU_SURE_DELETE)) return;
	suspendQbImportUI();
	window.enqueueActions = {};
	$('td.qb-export-queued, td.qb-export-status, td.qb-export-timespan, td.qb-export-view').html('<span class="np-import-progress"></span>');
	$('#qbimportpagespinner')[0].showSpinner();
	setTimeout(function(){
		$('td.qb-export-queued, td.qb-export-timespan, td.qb-export-view').html('');
		$('td.qb-export-status').html('<span class="np-import-progress"></span>');
		$.ajaxRetry({
			url: CI_BASE_URL+'/qbimport/qbimport/clearQBExportData/',
			method: 'POST',
			dataType: 'json',
			complete: function(){
				setTimeout(function(){
					$.ajaxRetry({
						url: CI_BASE_URL+'/qbimport/qbimport/clearQBExportData/',
						method: 'POST',
						dataType: 'json',
						complete: function(){
							setTimeout(function(){
								$('td.qb-export-queued, td.qb-export-timespan, td.qb-export-view').html('');
								$('td.qb-export-status').html('<span class="np-import-progress"></span>');
								location.href=location.href;
							}, 2000);
						},
					});
				}, 3000);
			},
		});
	}, 1000);
}

function btnDeleteImportProgress_Click(sender, event){
	setPausedState(true);
	$('.qbimport-diag:visible').dialog('close');
	if(typeof(STR_ARE_YOU_SURE_DELETE) == 'undefined') window.STR_ARE_YOU_SURE_DELETE = 'Are you sure you want to delete this?';
	if(!confirm(STR_ARE_YOU_SURE_DELETE)) return;
	suspendQbImportUI();
	$('#qbimportpagespinner')[0].showSpinner();
	setTimeout(function(){
		$.ajaxRetry({
			url: CI_BASE_URL+'/qbimport/qbimport/clearQBImportProgress/',
			method: 'POST',
			dataType: 'json',
			complete: function(){
				setTimeout(function(){
					$.ajaxRetry({
						url: CI_BASE_URL+'/qbimport/qbimport/clearQBImportProgress/',
						method: 'POST',
						dataType: 'json',
						complete: function(){
							setTimeout(function(){
								location.href=location.href;
							}, 2000);
						},
					});
				}, 3000);
			},
		});
	}, 1000);
}

function setPausedState(paused){
	window.isQbImportPaused = paused === 'other' || paused;
	if(paused === 'other'){
		$('#tbQbImportContinue').hide();
		$('#tbQbImportPause').hide();
	}
	else if(window.isQbImportPaused) {
		$('#tbQbImportContinue').removeClass('tbQbImportHidden').show();
		$('#tbQbImportPause').hide();
	}
	else {
		$('#tbQbImportContinue').hide();
		$('#tbQbImportPause').removeClass('tbQbImportHidden').show();
	}
}

function enqueueAction(action){
	var promise = new PromiseObj();
	var data = {"action": action};

	if(typeof(window.enqueueActions[action]) !== 'undefined'){
		setTimeout(function(){
			promise.fail({data: data, textStatus: 'enqueueAction had already ran this action [E21321431127]', errorThrown: 'E21321431127'});
			promise.always({data: data, textStatus: 'enqueueAction had already ran this action [E21321431127]'});
			promise.then({data: data, textStatus: 'enqueueAction had already ran this action [E21321431127]', jqXHR: null});
		}, 1000);
		return promise;
	}

	if(window.enqueueActionActive){
		setTimeout(function(){
			promise.fail({data: data, textStatus: 'enqueueAction is already active [E170240232]', errorThrown: 'E170240232'});
			promise.always({data: data, textStatus: 'enqueueAction is already active [E170240232]'});
			promise.then({data: data, textStatus: 'enqueueAction is already active [E170240232]', jqXHR: null});
		}, 1000);
		return promise;
	}

	window.enqueueActionActive = true;
	$.ajaxRetry({
		url: CI_BASE_URL+'/qbimport/qbimport/enqueue',
		method: 'POST',
		data: data,
		dataType: 'json',
		success: function(data, textStatus, jqXHR){
			promise.done({data: data, textStatus: textStatus, jqXHR: jqXHR});
			window.enqueueActions[action] = action;
			setTimeout(function(){ window.enqueueActionActive = false; }, 100);
		},
		error: function(data, textStatus, errorThrown){
			promise.fail({data: data, textStatus: textStatus, errorThrown: errorThrown});
			setTimeout(function(){ window.enqueueActionActive = false; }, 300);
		},
		complete: function(data, textStatus, jqXHR){
			promise.always({data: data, textStatus: textStatus});
			promise.then({data: data, textStatus: textStatus, jqXHR: jqXHR});
		},
	});
	return promise;
}

window.qbImport_CurrentUserMessageDialog = null;
function nextQBImportUserMessage(){
	if(window.qbImport_QueuedUserMessages.length > 0){
		if(window.qbImport_CurrentUserMessageDialog === null || window.qbImport_CurrentUserMessageDialog.is(':visible') === false){
			var msg = window.qbImport_QueuedUserMessages.shift();
			var diagParams = {
				modal: true,
				close: function(){
					window.qbImport_CurrentUserMessageDialog.remove();
					window.qbImport_CurrentUserMessageDialog = null;
					setTimeout(function(){
						nextQBImportUserMessage();
					}, 33);
				}
			};
			window.qbImport_CurrentUserMessageDialog = $(msg).dialog(diagParams);
			UI.processView_ElementsStyle(window.qbImport_CurrentUserMessageDialog);
			UI.processView_SetNavHooks();
		}
	}
}

function enqueueUserQBImportMessage(msg){
	window.qbImport_QueuedUserMessages.push(msg);
	nextQBImportUserMessage();
}

function importAction(import_key){
	var promise = new PromiseObj();

	//Show as loading
	$('#tblQBImportTasks > tbody > tr[import-key="'+import_key+'"] > td.np-import-status').html('<loading-32></loading-32><span class="np-import-progress"></span>');

	//Send Import Request
	$.ajaxRetry({
		url: CI_BASE_URL+'/qbimport/qbimport/import',
		method: 'POST',
		data: {"type": import_key},
		dataType: 'json',
		success: function(data, textStatus, jqXHR){
			if(typeof(data.msg) === 'string' && data.msg !== '') enqueueUserQBImportMessage(data.msg);
			promise.done({data: data, textStatus: textStatus, jqXHR: jqXHR});
		},
		error: function(data, textStatus, errorThrown){
			promise.fail({data: data, textStatus: textStatus, errorThrown});
		},
		complete: function(data, textStatus, jqXHR){
			promise.always({data: data, textStatus: textStatus});
			promise.then({data: data, textStatus: textStatus, jqXHR: jqXHR});
		},
	});
	return promise;
}

function imgQbStatusError_Click(sender, event){
	$('.qbimport-diag:visible').dialog('close');
	var tr = $(sender).closest('tr');
	if(typeof(STR_ERROR_IMPORTING) == 'undefined') window.STR_ERROR_IMPORTING = 'Error Importing';
	if(typeof(STR_CLOSE) == 'undefined') window.STR_CLOSE = 'Close';
	if(typeof(STR_RETRY) == 'undefined') window.STR_RETRY = 'Retry';
	var buttons = {};
	buttons[STR_CLOSE] = function(){ try{ $(this).dialog('close').remove(); } catch (err) {} };
	buttons[STR_RETRY] = function(){
		$(this).html('<loading-64></loading-64>').remove();
		var action = tr.attr('qb-export-src');
		if(typeof(action) == 'undefined' || action === null || action === '') action = tr.attr('import-key');
		window.suspendQBQueueUpdates = true;
		if(window.updateQBQueueAjax != null) try{ window.updateQBQueueAjax.abort(); } catch(err){ }
		enqueueAction(action)
			.then((function(){
				setTimeout((function(){
					if(window.updateQBQueueAjax != null) try{ window.updateQBQueueAjax.abort(); } catch(err){ }
					setTimeout((function(){
						window.suspendQBQueueUpdates = false;
						updateQBQueue().then((function(){
							try{ $(this).dialog('close').remove(); } catch (err) {}
						}).bind(this));
					}).bind(this), 500);
				}).bind(this), 500);
			}).bind(this));
	};
	var msg = tr.attr('qb-queue-msg');
	if(msg === null || msg === '') msg = STR_AN_UNEXPECTED_ERROR_HAS_OCCURRED;
	$('<div class="qbimport-diag">').html($('<pre>').text(msg).html()).dialog({
		title: STR_ERROR_IMPORTING+': '+tr.attr('title'),
		modal: true,
		buttons: buttons,
	});
}

function imgImportStatusError_Click(sender, event){
	$('.qbimport-diag:visible').dialog('close');
	var tr = $(sender).closest('tr');

	//Show Unfulfilled Requirment Dialog
	if(window.qbImportUpdateData != null
	  && typeof(window.qbImportUpdateData.import) != 'undefined'
	  && typeof(window.qbImportUpdateData.import[tr.attr('import-key')+'.unfulfilledRequirement']) != 'undefined'
	  && window.qbImportUpdateData.import[tr.attr('import-key')+'.unfulfilledRequirement'] != null){
		window.qbimportUnfulfilledRequirementLastShownGUID = window.qbimportUnfulfilledRequirementLastShownPushGUID = null;
		showUnfulfilledRequirementDialog();
	}

	//Show Standard Error Message Dialog (Ignore/Retry/Close)
	else {
		var log = tr.attr('np-import-log');
		if(typeof(log) == 'undefined' || log == '') log = window.STR_ERROR_IMPORTING+' [E43266043764]';

		var buttons = {};
		if(tr.is('.npImportIgnoreErrors') == false){
			buttons[STR_IGNORE+' / '+STR_CONTINUE] = function(){
				tr.addClass('npImportIgnoreErrors');
				window.alertOnNextError = true;
				$(this).css('text-align', 'center').css('overflow', 'hidden').html('<loading-64></loading-64>');
				$(this).closest('div.ui-dialog').find(".ui-dialog-titlebar > button.ui-dialog-titlebar-close").remove();
				$(this).closest('div.ui-dialog').find(".ui-dialog-buttonpane").remove();
				$.ajaxRetry({
					url: CI_BASE_URL+'qbimport/qbimport/ignoreImportError/?&set=1&type='+tr.attr('import-key'),
					method: 'post',
					dataType: 'json'
				});
				btnContinueImport_Click(null, null);
				setTimeout((function(){
					try{ $(this).dialog('close'); } catch (err) {}
				}).bind(this), 2000);
			};
		}
		buttons[STR_RETRY] = function(){
			tr.find('td.np-import-status').html('<loading-32></loading-32><span class="np-import-progress"></span>');
			tr.addClass('npImportRetryFromError');
			tr.removeClass('npImportRequested');
			tr.removeClass('npImportIgnoreErrors');
			window.alertOnNextError = true;
			$.ajaxRetry({
				url: CI_BASE_URL+'qbimport/qbimport/ignoreImportError/?&set=0&type='+tr.attr('import-key'),
				method: 'post',
				dataType: 'json',
				complete: (function(){
					tr.find('td.np-import-status').html('<loading-32></loading-32><span class="np-import-progress"></span>');
					tr.removeClass('npImportRequested');
					tr.removeClass('npImportIgnoreErrors');
					updateQBQueue().then((function(){
						btnContinueImport_Click(null, null);
						setTimeout((function(){
							try{ $(this).dialog('close'); } catch(err) {}
						}).bind(this), 300);
					}).bind(this));
				}).bind(this)
			});
			$(this).css('text-align', 'center').css('overflow', 'hidden').html('<loading-64></loading-64>');
			$(this).closest('div.ui-dialog').find(".ui-dialog-titlebar > button.ui-dialog-titlebar-close").remove();
			$(this).closest('div.ui-dialog').find(".ui-dialog-buttonpane").remove();
		};
		buttons[STR_CLOSE] = function(){ $(this).dialog('close'); };

		if(typeof(STR_ERROR_IMPORTING) == 'undefined') window.STR_ERROR_IMPORTING = 'Error Importing';
		UI.pushMessageClose();
		$('<div class="qbimport-diag qbimport-diag-import-error-status-dialog">').attr('title', STR_ERROR_IMPORTING+': '+$(tr).attr('title')).text(log).dialog({
			modal: true,
			buttons: buttons,
			width: 450,
		});
	}
}

function btnContinueImport_Click(sender, event){
	window.alertOnNextError = true;
	UI.pushMessage('', window.STR_IMPORT_STARTED, null, '<i class="fas fa-play"></i>', 1000, true);
	qbImportRunnerStart();
}

function btnPauseImport_Click(sender, event){
	if(window.qbImportStartLocked > 0) {
		UI.shake(sender);
		return;
	}
	setPausedState(true);
	pauseImport(window.STR_IMPORT_PAUSED, '<i class="fas fa-pause"></i>', 1000);
	var tmp = updateQBQueue;
	updateQBQueue = function(){};
	if(window.updateQBQueueAjax !== null){
		try{ window.updateQBQueueAjax.abort(); } catch (err) {}
	}
	$.ajaxRetry({url: CI_BASE_URL+'qbimport/qbimport/pauseImportExport/', method: 'post'}).then(function(){
		try{ window.updateQBQueueAjax.abort(); } catch (err) {}
		$('tr.qbExportQueued').removeClass('qbExportQueued');
		$('tr.qbExportQueueRequested').removeClass('qbExportQueueRequested');
		$('tr[qb-queue-status="q"]')
			.attr('qb-queue-status', '')
			.find('td.qb-export-queued').html('');
		$('tr[qb-queue-status="q"]')
			.find('td.qb-export-status').html('<span class="np-import-progress"></span>');
		updateQBQueue = tmp;
		updateQBQueue();
	});
}

function pauseImport(msg_body_html, msg_type_or_html, msg_timeout, buttons){
	if(typeof(buttons) == 'undefined') buttons = null;
	setPausedState(true);
	UI.pushMessage('', msg_body_html, buttons, msg_type_or_html, msg_timeout, true);
}

function showUnfulfilledRequirementDialog(){
	
	//Skip if already shown
	if(window.qbimportUnfulfilledRequirementDialog !== null && window.qbimportUnfulfilledRequirementDialog.is(':visible')) return;

	//Find Pending Requirement(s)
	var guids = [];
	var actions = [];
	var unfulfilledRequirement = [];
	for(var k in window.qbImportUpdateData.import){
		var v = window.qbImportUpdateData.import[k];
		if(v === null || typeof(v) !== 'string' || v === '' || v.substring(0, 1) !== '{') continue;
		var p = k.split('.', 2);
		var action = p[0];
		var field = p[1];
		if(field === 'unfulfilledRequirement'){
			var d = JSON.parse(v);
			if(guids.indexOf(d.guid) === -1) guids.push(d.guid);
			if(actions.indexOf(action) === -1) actions.push(action);
			unfulfilledRequirement.push(v);
			break;
		}
	}
	if(unfulfilledRequirement.length == 0) return;

	//Skip if this is the exact same dialog already shown last to the user
	guids.sort();
	guids = guids.join(',');
	if(window.qbimportUnfulfilledRequirementLastShownGUID === guids) {
		if(window.qbimportUnfulfilledRequirementLastShownPushGUID !== guids) pauseImport(window.STR_IMPORT_PAUSED, '<i class="fas fa-pause"></i>', 1000);
		window.qbimportUnfulfilledRequirementLastShownPushGUID = guids;
		return;
	}
	window.qbimportUnfulfilledRequirementLastShownGUID = guids;

	//Create New
	if(qbimportUnfulfilledRequirementDialog !== null) $(qbimportUnfulfilledRequirementDialog).remove();
	qbimportUnfulfilledRequirementDialog = $('<div style="padding:0;">').attr('title', STR_NOTICE);
	
	//Set Loading Contents
	qbimportUnfulfilledRequirementDialog.html('')
		.append($('<div style="font-size: 1.2em; padding: 8px; text-align: center; text-decoration: underline;">').text(STR_A_REQUIRED_SETTING_IS_UNDEFINED))
		.append($('<div class="qbimportUnfulfilledRequirementAjaxTarget">')
			.append($('<div style="padding: 24px; text-align: center;">').append($('<loading-64>')))
		);

	//Define Buttons
	var buttons = [];
	buttons.push({
		html: '<style>.uiTaskBarBackground, .ui-dialog-titlebar, div.uiPushMessage { z-index: 88 !important; } </style><i class="fa fa-save" style="margin-right: 8px; color: var(--ui-style-highlight)"></i>'+STR_SAVE,
		click: function(){

			//Build Post Data
			var post = [];
			$('#tblFormUnfulfilledRequirement [name]').each(function(){
				var name = $(this).attr('name');
				if(name.match(/^save_model_.*_label$/i) === null) post.push($(this).attr('name')+'='+$(this).val());
			});
			post = post.join('&');

			//Show As Loading
			$(window.qbimportUnfulfilledRequirementDialog).prev().find('.ui-dialog-titlebar-close').remove();
			$(window.qbimportUnfulfilledRequirementDialog).next().find('button').css('opacity', 0.5).css('cursor', 'wait').css('user-select', 'none').prop('disabled', 1);
			$(this).html('').append(
				$('<div style="text-align: center; padding: 32px;"></div>')
					.append($('<loading-64>'))
					.append($('<div style="padding-top: 8px;">').text(STR_SAVING).append($('<loading-ellip>'))));

			//Send
			$.ajaxRetry({
				url: CI_BASE_URL + 'qbimport/qbimport/saveUnfulfilledRequirementForm/?&tmpl=text',
				method: 'post',
				data: post,
				complete: function(){

					//Show As Saved
					setPausedState('other');
					$(window.qbimportUnfulfilledRequirementDialog)
						.html('')
						.append(
							$('<div style="text-align: center; padding: 32px;"></div>')
								.append($('<i class="fa fa-check" style="color: var(--ui-style-highlight); font-weight: bold; font-size: 32pt; text-shadow: 0 0 3px var(--ui-style-highlight-text);">'))
								.append($('<div style="padding-top: 8px; font-weight: bold; font-size: 1.2em;">').text(STR_SAVED+'!'))
						  );

					//Rerun failed import step(s), update the queue ui, then close the dialog
					setTimeout(function(){

						UI.pushMessage('', STR_RESUMING_IMPORT, null, 'notice', 1000, true);
						
						//Append "Resuming Import..." text
						var funcShowAsResuming = null;
						funcShowAsResuming = function(){
							funcShowAsResuming = function(){};
							setTimeout(function(){
								$(window.qbimportUnfulfilledRequirementDialog).find('div > i').replaceWith($('<loading-64>'));
								$(window.qbimportUnfulfilledRequirementDialog).find('div > div').replaceWith($('<div style="text-align: center; padding: 8px;">').text(STR_RESUMING_IMPORT).append($('<loading-ellip>')));
								setTimeout(function(){
									try{ $(window.qbimportUnfulfilledRequirementDialog).dialog('close'); } catch (err) { }
								}, 1000);
							}, 1000);
						};

						//After import actions...
						var funcAfterActionsComplete = (function(){
							setTimeout(function(){
								funcShowAsResuming();
								//Wait until next queue is complete
								updateQBQueue().then((function(){
									//Reset and close the unfulfilled dialog
									window.qbimportUnfulfilledRequirementLastShownPushGUID = window.qbimportUnfulfilledRequirementLastShownGUID = null;
									try{ $(window.qbimportUnfulfilledRequirementDialog).dialog('close'); } catch (err) { }
									//Resume
									setPausedState(false);
									qbImportRunnerStart();
								}).bind(this));
							}, 500);
						}).bind(this);

						//Fire Each Action
						if(actions.length > 0){
							var importActionsPending = actions.length;
							for(var a in actions){
								importAction(actions[a]).then(function(){
									importActionsPending--;
									if(importActionsPending == 0) funcAfterActionsComplete();
								});
							}
						}

						//No Actions To Run..
						else funcAfterActionsComplete();

						setTimeout(funcShowAsResuming, 1000);
					}, 500);
				}
			});
		}
	});

	//Show Dialog
	$(window.qbimportUnfulfilledRequirementDialog).dialog({
		modal: true,
		width: 640,
		buttons: buttons,
		appendTo: '#content',
	});
	$(window.qbimportUnfulfilledRequirementDialog[0].parentNode).css('z-index', 95).prev().css('z-index', 94);

	//Build Post
	var post = '';
	for(var i in unfulfilledRequirement){
		post += (post == '' ? '' : '&')+'unfulfilledRequirement['+i+']='+encodeURIComponent(unfulfilledRequirement[i]);
	}	

	//Load in the setting
	$.ajaxRetry({
		url: CI_BASE_URL + 'qbimport/qbimport/getUnfulfilledRequirementForm/',
		data: post,
		method: 'post',
		success: function(html){
			qbimportUnfulfilledRequirementDialog.find('.qbimportUnfulfilledRequirementAjaxTarget').html(html);
		},
		error: function(data){
			qbimportUnfulfilledRequirementDialog.find('.qbimportUnfulfilledRequirementAjaxTarget')
				.html('<img src="images/error.png" style="width: 32px; height: 32px; margin: 32px; margin-bottom: 8px;">')
				.append($('<div style="text-align: center;" class="emergency">').text(STR_CONNECTION_ERROR))
				.append($('<div class="qbimporterrortimeout">').append($('<b>').text('10')).append($('<span>').text('s')));

			var funcRetryTimeOutUpdate = null;
			funcRetryTimeOutUpdate = function(){
				var to = qbimportUnfulfilledRequirementDialog.find('.qbimporterrortimeout > b');
				var ito = parseInt(to.text()) - 1;
				if(ito > 0){
					to.text(ito.toString());
					setTimeout(funcRetryTimeOutUpdate, 1000);
				}
				else {
					qbimportUnfulfilledRequirementDialog.dialog('close');
					showUnfulfilledRequirementDialog();
				}
			};
			funcRetryTimeOutUpdate();

		},
	});
}

function setQBImportProgress(jqTr, value){
	//Find the cell to update
	var td = $(jqTr).find('td.np-import-status');
	if(td.length === 0) return;
	//Parse value to float
	value = value === null || value === '' || value === false ? 0 : parseFloat(value);
	//Set the progress text
	td.find('.np-import-progress').text(value < 100 && value > 0 ? value.toFixed(0)+'%' : '');
	//Hide Progress Info
	if(value <= 0 || value >= 100) td.removeClass('np-import-show-progress');
	//Show Progress Info
	else td.addClass('np-import-show-progress');
}