<?php

/**
 * Schema object for: PaymentMethodAddRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_PaymentMethodAddRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = '';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'PaymentMethodAdd Name' => 'STRTYPE',
  'PaymentMethodAdd IsActive' => 'BOOLTYPE',
  'PaymentMethodAdd PaymentMethodType' => 'ENUMTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'PaymentMethodAdd Name' => 31,
  'PaymentMethodAdd IsActive' => 0,
  'PaymentMethodAdd PaymentMethodType' => 0,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'PaymentMethodAdd Name' => false,
  'PaymentMethodAdd IsActive' => true,
  'PaymentMethodAdd PaymentMethodType' => true,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'PaymentMethodAdd Name' => 999.99,
  'PaymentMethodAdd IsActive' => 999.99,
  'PaymentMethodAdd PaymentMethodType' => 7,
  'IncludeRetElement' => 4,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'PaymentMethodAdd Name' => false,
  'PaymentMethodAdd IsActive' => false,
  'PaymentMethodAdd PaymentMethodType' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'PaymentMethodAdd Name',
  1 => 'PaymentMethodAdd IsActive',
  2 => 'PaymentMethodAdd PaymentMethodType',
  3 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>