<?php

/**
 * Schema object for: CreditMemoAddRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_CreditMemoAddRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = '';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'CreditMemoAdd CustomerRef ListID' => 'IDTYPE',
  'CreditMemoAdd CustomerRef FullName' => 'STRTYPE',
  'CreditMemoAdd ClassRef ListID' => 'IDTYPE',
  'CreditMemoAdd ClassRef FullName' => 'STRTYPE',
  'CreditMemoAdd ARAccountRef ListID' => 'IDTYPE',
  'CreditMemoAdd ARAccountRef FullName' => 'STRTYPE',
  'CreditMemoAdd TemplateRef ListID' => 'IDTYPE',
  'CreditMemoAdd TemplateRef FullName' => 'STRTYPE',
  'CreditMemoAdd TxnDate' => 'DATETYPE',
  'CreditMemoAdd RefNumber' => 'STRTYPE',
  'CreditMemoAdd BillAddress Addr1' => 'STRTYPE',
  'CreditMemoAdd BillAddress Addr2' => 'STRTYPE',
  'CreditMemoAdd BillAddress Addr3' => 'STRTYPE',
  'CreditMemoAdd BillAddress Addr4' => 'STRTYPE',
  'CreditMemoAdd BillAddress Addr5' => 'STRTYPE',
  'CreditMemoAdd BillAddress City' => 'STRTYPE',
  'CreditMemoAdd BillAddress State' => 'STRTYPE',
  'CreditMemoAdd BillAddress PostalCode' => 'STRTYPE',
  'CreditMemoAdd BillAddress Country' => 'STRTYPE',
  'CreditMemoAdd BillAddress Note' => 'STRTYPE',
  'CreditMemoAdd ShipAddress Addr1' => 'STRTYPE',
  'CreditMemoAdd ShipAddress Addr2' => 'STRTYPE',
  'CreditMemoAdd ShipAddress Addr3' => 'STRTYPE',
  'CreditMemoAdd ShipAddress Addr4' => 'STRTYPE',
  'CreditMemoAdd ShipAddress Addr5' => 'STRTYPE',
  'CreditMemoAdd ShipAddress City' => 'STRTYPE',
  'CreditMemoAdd ShipAddress State' => 'STRTYPE',
  'CreditMemoAdd ShipAddress PostalCode' => 'STRTYPE',
  'CreditMemoAdd ShipAddress Country' => 'STRTYPE',
  'CreditMemoAdd ShipAddress Note' => 'STRTYPE',
  'CreditMemoAdd IsPending' => 'BOOLTYPE',
  'CreditMemoAdd PONumber' => 'STRTYPE',
  'CreditMemoAdd TermsRef ListID' => 'IDTYPE',
  'CreditMemoAdd TermsRef FullName' => 'STRTYPE',
  'CreditMemoAdd DueDate' => 'DATETYPE',
  'CreditMemoAdd SalesRepRef ListID' => 'IDTYPE',
  'CreditMemoAdd SalesRepRef FullName' => 'STRTYPE',
  'CreditMemoAdd FOB' => 'STRTYPE',
  'CreditMemoAdd ShipDate' => 'DATETYPE',
  'CreditMemoAdd ShipMethodRef ListID' => 'IDTYPE',
  'CreditMemoAdd ShipMethodRef FullName' => 'STRTYPE',
  'CreditMemoAdd ItemSalesTaxRef ListID' => 'IDTYPE',
  'CreditMemoAdd ItemSalesTaxRef FullName' => 'STRTYPE',
  'CreditMemoAdd Memo' => 'STRTYPE',
  'CreditMemoAdd CustomerMsgRef ListID' => 'IDTYPE',
  'CreditMemoAdd CustomerMsgRef FullName' => 'STRTYPE',
  'CreditMemoAdd IsToBePrinted' => 'BOOLTYPE',
  'CreditMemoAdd IsToBeEmailed' => 'BOOLTYPE',
  'CreditMemoAdd IsTaxIncluded' => 'BOOLTYPE',
  'CreditMemoAdd CustomerSalesTaxCodeRef ListID' => 'IDTYPE',
  'CreditMemoAdd CustomerSalesTaxCodeRef FullName' => 'STRTYPE',
  'CreditMemoAdd Other' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd ItemRef ListID' => 'IDTYPE',
  'CreditMemoAdd CreditMemoLineAdd ItemRef FullName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd Desc' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd Quantity' => 'QUANTYPE',
  'CreditMemoAdd CreditMemoLineAdd UnitOfMeasure' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd Rate' => 'PRICETYPE',
  'CreditMemoAdd CreditMemoLineAdd RatePercent' => 'PERCENTTYPE',
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef ListID' => 'IDTYPE',
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef FullName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd ClassRef ListID' => 'IDTYPE',
  'CreditMemoAdd CreditMemoLineAdd ClassRef FullName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd Amount' => 'AMTTYPE',
  'CreditMemoAdd CreditMemoLineAdd ServiceDate' => 'DATETYPE',
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef ListID' => 'IDTYPE',
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef FullName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd IsTaxable' => 'BOOLTYPE',
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef ListID' => 'IDTYPE',
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef FullName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd Other1' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd Other2' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 'INTTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 'INTTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 'ENUMTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 'ENUMTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 'INTTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 'ENUMTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 'ENUMTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 'ENUMTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 'INTTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 'ENUMTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 'DATETIMETYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 'INTTYPE',
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd DataExt OwnerID' => 'GUIDTYPE',
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtValue' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef ListID' => 'IDTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef FullName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd Desc' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd Quantity' => 'QUANTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd UnitOfMeasure' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd ServiceDate' => 'DATETYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt OwnerID' => 'GUIDTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtName' => 'STRTYPE',
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtValue' => 'STRTYPE',
  'CreditMemoAdd DiscountLineAdd Amount' => 'AMTTYPE',
  'CreditMemoAdd DiscountLineAdd RatePercent' => 'PERCENTTYPE',
  'CreditMemoAdd DiscountLineAdd IsTaxable' => 'BOOLTYPE',
  'CreditMemoAdd DiscountLineAdd AccountRef ListID' => 'IDTYPE',
  'CreditMemoAdd DiscountLineAdd AccountRef FullName' => 'STRTYPE',
  'CreditMemoAdd SalesTaxLineAdd Amount' => 'AMTTYPE',
  'CreditMemoAdd SalesTaxLineAdd RatePercent' => 'PERCENTTYPE',
  'CreditMemoAdd SalesTaxLineAdd AccountRef ListID' => 'IDTYPE',
  'CreditMemoAdd SalesTaxLineAdd AccountRef FullName' => 'STRTYPE',
  'CreditMemoAdd ShippingLineAdd Amount' => 'AMTTYPE',
  'CreditMemoAdd ShippingLineAdd AccountRef ListID' => 'IDTYPE',
  'CreditMemoAdd ShippingLineAdd AccountRef FullName' => 'STRTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'CreditMemoAdd CustomerRef ListID' => 0,
  'CreditMemoAdd CustomerRef FullName' => 209,
  'CreditMemoAdd ClassRef ListID' => 0,
  'CreditMemoAdd ClassRef FullName' => 209,
  'CreditMemoAdd ARAccountRef ListID' => 0,
  'CreditMemoAdd ARAccountRef FullName' => 209,
  'CreditMemoAdd TemplateRef ListID' => 0,
  'CreditMemoAdd TemplateRef FullName' => 209,
  'CreditMemoAdd TxnDate' => 0,
  'CreditMemoAdd RefNumber' => 11,
  'CreditMemoAdd BillAddress Addr1' => 41,
  'CreditMemoAdd BillAddress Addr2' => 41,
  'CreditMemoAdd BillAddress Addr3' => 41,
  'CreditMemoAdd BillAddress Addr4' => 41,
  'CreditMemoAdd BillAddress Addr5' => 41,
  'CreditMemoAdd BillAddress City' => 31,
  'CreditMemoAdd BillAddress State' => 21,
  'CreditMemoAdd BillAddress PostalCode' => 13,
  'CreditMemoAdd BillAddress Country' => 31,
  'CreditMemoAdd BillAddress Note' => 41,
  'CreditMemoAdd ShipAddress Addr1' => 41,
  'CreditMemoAdd ShipAddress Addr2' => 41,
  'CreditMemoAdd ShipAddress Addr3' => 41,
  'CreditMemoAdd ShipAddress Addr4' => 41,
  'CreditMemoAdd ShipAddress Addr5' => 41,
  'CreditMemoAdd ShipAddress City' => 31,
  'CreditMemoAdd ShipAddress State' => 21,
  'CreditMemoAdd ShipAddress PostalCode' => 13,
  'CreditMemoAdd ShipAddress Country' => 31,
  'CreditMemoAdd ShipAddress Note' => 41,
  'CreditMemoAdd IsPending' => 0,
  'CreditMemoAdd PONumber' => 25,
  'CreditMemoAdd TermsRef ListID' => 0,
  'CreditMemoAdd TermsRef FullName' => 209,
  'CreditMemoAdd DueDate' => 0,
  'CreditMemoAdd SalesRepRef ListID' => 0,
  'CreditMemoAdd SalesRepRef FullName' => 209,
  'CreditMemoAdd FOB' => 13,
  'CreditMemoAdd ShipDate' => 0,
  'CreditMemoAdd ShipMethodRef ListID' => 0,
  'CreditMemoAdd ShipMethodRef FullName' => 209,
  'CreditMemoAdd ItemSalesTaxRef ListID' => 0,
  'CreditMemoAdd ItemSalesTaxRef FullName' => 209,
  'CreditMemoAdd Memo' => 4095,
  'CreditMemoAdd CustomerMsgRef ListID' => 0,
  'CreditMemoAdd CustomerMsgRef FullName' => 209,
  'CreditMemoAdd IsToBePrinted' => 0,
  'CreditMemoAdd IsToBeEmailed' => 0,
  'CreditMemoAdd IsTaxIncluded' => 0,
  'CreditMemoAdd CustomerSalesTaxCodeRef ListID' => 0,
  'CreditMemoAdd CustomerSalesTaxCodeRef FullName' => 209,
  'CreditMemoAdd Other' => 29,
  'CreditMemoAdd CreditMemoLineAdd ItemRef ListID' => 0,
  'CreditMemoAdd CreditMemoLineAdd ItemRef FullName' => 209,
  'CreditMemoAdd CreditMemoLineAdd Desc' => 4095,
  'CreditMemoAdd CreditMemoLineAdd Quantity' => 0,
  'CreditMemoAdd CreditMemoLineAdd UnitOfMeasure' => 31,
  'CreditMemoAdd CreditMemoLineAdd Rate' => 0,
  'CreditMemoAdd CreditMemoLineAdd RatePercent' => 0,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef ListID' => 0,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef FullName' => 209,
  'CreditMemoAdd CreditMemoLineAdd ClassRef ListID' => 0,
  'CreditMemoAdd CreditMemoLineAdd ClassRef FullName' => 209,
  'CreditMemoAdd CreditMemoLineAdd Amount' => 0,
  'CreditMemoAdd CreditMemoLineAdd ServiceDate' => 0,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef ListID' => 0,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef FullName' => 209,
  'CreditMemoAdd CreditMemoLineAdd IsTaxable' => 0,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef ListID' => 0,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef FullName' => 209,
  'CreditMemoAdd CreditMemoLineAdd Other1' => 29,
  'CreditMemoAdd CreditMemoLineAdd Other2' => 29,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 25,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 41,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 41,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 18,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 24,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 60,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 24,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 32,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 12,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 84,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 16,
  'CreditMemoAdd CreditMemoLineAdd DataExt OwnerID' => 0,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtName' => 31,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtValue' => 0,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef ListID' => 0,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef FullName' => 209,
  'CreditMemoAdd CreditMemoLineGroupAdd Desc' => 4095,
  'CreditMemoAdd CreditMemoLineGroupAdd Quantity' => 0,
  'CreditMemoAdd CreditMemoLineGroupAdd UnitOfMeasure' => 31,
  'CreditMemoAdd CreditMemoLineGroupAdd ServiceDate' => 0,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt OwnerID' => 0,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtName' => 31,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtValue' => 0,
  'CreditMemoAdd DiscountLineAdd Amount' => 0,
  'CreditMemoAdd DiscountLineAdd RatePercent' => 0,
  'CreditMemoAdd DiscountLineAdd IsTaxable' => 0,
  'CreditMemoAdd DiscountLineAdd AccountRef ListID' => 0,
  'CreditMemoAdd DiscountLineAdd AccountRef FullName' => 209,
  'CreditMemoAdd SalesTaxLineAdd Amount' => 0,
  'CreditMemoAdd SalesTaxLineAdd RatePercent' => 0,
  'CreditMemoAdd SalesTaxLineAdd AccountRef ListID' => 0,
  'CreditMemoAdd SalesTaxLineAdd AccountRef FullName' => 209,
  'CreditMemoAdd ShippingLineAdd Amount' => 0,
  'CreditMemoAdd ShippingLineAdd AccountRef ListID' => 0,
  'CreditMemoAdd ShippingLineAdd AccountRef FullName' => 209,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'CreditMemoAdd CustomerRef ListID' => true,
  'CreditMemoAdd CustomerRef FullName' => true,
  'CreditMemoAdd ClassRef ListID' => true,
  'CreditMemoAdd ClassRef FullName' => true,
  'CreditMemoAdd ARAccountRef ListID' => true,
  'CreditMemoAdd ARAccountRef FullName' => true,
  'CreditMemoAdd TemplateRef ListID' => true,
  'CreditMemoAdd TemplateRef FullName' => true,
  'CreditMemoAdd TxnDate' => true,
  'CreditMemoAdd RefNumber' => true,
  'CreditMemoAdd BillAddress Addr1' => true,
  'CreditMemoAdd BillAddress Addr2' => true,
  'CreditMemoAdd BillAddress Addr3' => true,
  'CreditMemoAdd BillAddress Addr4' => true,
  'CreditMemoAdd BillAddress Addr5' => true,
  'CreditMemoAdd BillAddress City' => true,
  'CreditMemoAdd BillAddress State' => true,
  'CreditMemoAdd BillAddress PostalCode' => true,
  'CreditMemoAdd BillAddress Country' => true,
  'CreditMemoAdd BillAddress Note' => true,
  'CreditMemoAdd ShipAddress Addr1' => true,
  'CreditMemoAdd ShipAddress Addr2' => true,
  'CreditMemoAdd ShipAddress Addr3' => true,
  'CreditMemoAdd ShipAddress Addr4' => true,
  'CreditMemoAdd ShipAddress Addr5' => true,
  'CreditMemoAdd ShipAddress City' => true,
  'CreditMemoAdd ShipAddress State' => true,
  'CreditMemoAdd ShipAddress PostalCode' => true,
  'CreditMemoAdd ShipAddress Country' => true,
  'CreditMemoAdd ShipAddress Note' => true,
  'CreditMemoAdd IsPending' => true,
  'CreditMemoAdd PONumber' => true,
  'CreditMemoAdd TermsRef ListID' => true,
  'CreditMemoAdd TermsRef FullName' => true,
  'CreditMemoAdd DueDate' => true,
  'CreditMemoAdd SalesRepRef ListID' => true,
  'CreditMemoAdd SalesRepRef FullName' => true,
  'CreditMemoAdd FOB' => true,
  'CreditMemoAdd ShipDate' => true,
  'CreditMemoAdd ShipMethodRef ListID' => true,
  'CreditMemoAdd ShipMethodRef FullName' => true,
  'CreditMemoAdd ItemSalesTaxRef ListID' => true,
  'CreditMemoAdd ItemSalesTaxRef FullName' => true,
  'CreditMemoAdd Memo' => true,
  'CreditMemoAdd CustomerMsgRef ListID' => true,
  'CreditMemoAdd CustomerMsgRef FullName' => true,
  'CreditMemoAdd IsToBePrinted' => true,
  'CreditMemoAdd IsToBeEmailed' => true,
  'CreditMemoAdd IsTaxIncluded' => true,
  'CreditMemoAdd CustomerSalesTaxCodeRef ListID' => true,
  'CreditMemoAdd CustomerSalesTaxCodeRef FullName' => true,
  'CreditMemoAdd Other' => true,
  'CreditMemoAdd CreditMemoLineAdd ItemRef ListID' => true,
  'CreditMemoAdd CreditMemoLineAdd ItemRef FullName' => true,
  'CreditMemoAdd CreditMemoLineAdd Desc' => true,
  'CreditMemoAdd CreditMemoLineAdd Quantity' => true,
  'CreditMemoAdd CreditMemoLineAdd UnitOfMeasure' => true,
  'CreditMemoAdd CreditMemoLineAdd Rate' => false,
  'CreditMemoAdd CreditMemoLineAdd RatePercent' => false,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef ListID' => true,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef FullName' => true,
  'CreditMemoAdd CreditMemoLineAdd ClassRef ListID' => true,
  'CreditMemoAdd CreditMemoLineAdd ClassRef FullName' => true,
  'CreditMemoAdd CreditMemoLineAdd Amount' => true,
  'CreditMemoAdd CreditMemoLineAdd ServiceDate' => true,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef ListID' => true,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef FullName' => true,
  'CreditMemoAdd CreditMemoLineAdd IsTaxable' => true,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef ListID' => true,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef FullName' => true,
  'CreditMemoAdd CreditMemoLineAdd Other1' => true,
  'CreditMemoAdd CreditMemoLineAdd Other2' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => true,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => true,
  'CreditMemoAdd CreditMemoLineAdd DataExt OwnerID' => false,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtName' => false,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtValue' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef ListID' => true,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef FullName' => true,
  'CreditMemoAdd CreditMemoLineGroupAdd Desc' => true,
  'CreditMemoAdd CreditMemoLineGroupAdd Quantity' => true,
  'CreditMemoAdd CreditMemoLineGroupAdd UnitOfMeasure' => true,
  'CreditMemoAdd CreditMemoLineGroupAdd ServiceDate' => true,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt OwnerID' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtName' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtValue' => false,
  'CreditMemoAdd DiscountLineAdd Amount' => true,
  'CreditMemoAdd DiscountLineAdd RatePercent' => false,
  'CreditMemoAdd DiscountLineAdd IsTaxable' => true,
  'CreditMemoAdd DiscountLineAdd AccountRef ListID' => true,
  'CreditMemoAdd DiscountLineAdd AccountRef FullName' => true,
  'CreditMemoAdd SalesTaxLineAdd Amount' => true,
  'CreditMemoAdd SalesTaxLineAdd RatePercent' => false,
  'CreditMemoAdd SalesTaxLineAdd AccountRef ListID' => true,
  'CreditMemoAdd SalesTaxLineAdd AccountRef FullName' => true,
  'CreditMemoAdd ShippingLineAdd Amount' => true,
  'CreditMemoAdd ShippingLineAdd AccountRef ListID' => true,
  'CreditMemoAdd ShippingLineAdd AccountRef FullName' => true,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'CreditMemoAdd CustomerRef ListID' => 999.99,
  'CreditMemoAdd CustomerRef FullName' => 999.99,
  'CreditMemoAdd ClassRef ListID' => 999.99,
  'CreditMemoAdd ClassRef FullName' => 999.99,
  'CreditMemoAdd ARAccountRef ListID' => 999.99,
  'CreditMemoAdd ARAccountRef FullName' => 999.99,
  'CreditMemoAdd TemplateRef ListID' => 999.99,
  'CreditMemoAdd TemplateRef FullName' => 999.99,
  'CreditMemoAdd TxnDate' => 999.99,
  'CreditMemoAdd RefNumber' => 999.99,
  'CreditMemoAdd BillAddress Addr1' => 999.99,
  'CreditMemoAdd BillAddress Addr2' => 999.99,
  'CreditMemoAdd BillAddress Addr3' => 999.99,
  'CreditMemoAdd BillAddress Addr4' => 2,
  'CreditMemoAdd BillAddress Addr5' => 6,
  'CreditMemoAdd BillAddress City' => 999.99,
  'CreditMemoAdd BillAddress State' => 999.99,
  'CreditMemoAdd BillAddress PostalCode' => 999.99,
  'CreditMemoAdd BillAddress Country' => 999.99,
  'CreditMemoAdd BillAddress Note' => 6,
  'CreditMemoAdd ShipAddress Addr1' => 999.99,
  'CreditMemoAdd ShipAddress Addr2' => 999.99,
  'CreditMemoAdd ShipAddress Addr3' => 999.99,
  'CreditMemoAdd ShipAddress Addr4' => 2,
  'CreditMemoAdd ShipAddress Addr5' => 6,
  'CreditMemoAdd ShipAddress City' => 999.99,
  'CreditMemoAdd ShipAddress State' => 999.99,
  'CreditMemoAdd ShipAddress PostalCode' => 999.99,
  'CreditMemoAdd ShipAddress Country' => 999.99,
  'CreditMemoAdd ShipAddress Note' => 6,
  'CreditMemoAdd IsPending' => 999.99,
  'CreditMemoAdd PONumber' => 999.99,
  'CreditMemoAdd TermsRef ListID' => 999.99,
  'CreditMemoAdd TermsRef FullName' => 999.99,
  'CreditMemoAdd DueDate' => 999.99,
  'CreditMemoAdd SalesRepRef ListID' => 999.99,
  'CreditMemoAdd SalesRepRef FullName' => 999.99,
  'CreditMemoAdd FOB' => 999.99,
  'CreditMemoAdd ShipDate' => 999.99,
  'CreditMemoAdd ShipMethodRef ListID' => 999.99,
  'CreditMemoAdd ShipMethodRef FullName' => 999.99,
  'CreditMemoAdd ItemSalesTaxRef ListID' => 999.99,
  'CreditMemoAdd ItemSalesTaxRef FullName' => 999.99,
  'CreditMemoAdd Memo' => 999.99,
  'CreditMemoAdd CustomerMsgRef ListID' => 999.99,
  'CreditMemoAdd CustomerMsgRef FullName' => 999.99,
  'CreditMemoAdd IsToBePrinted' => 999.99,
  'CreditMemoAdd IsToBeEmailed' => 6,
  'CreditMemoAdd IsTaxIncluded' => 6,
  'CreditMemoAdd CustomerSalesTaxCodeRef ListID' => 999.99,
  'CreditMemoAdd CustomerSalesTaxCodeRef FullName' => 999.99,
  'CreditMemoAdd Other' => 6,
  'CreditMemoAdd CreditMemoLineAdd ItemRef ListID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd ItemRef FullName' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd Desc' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd Quantity' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd UnitOfMeasure' => 7,
  'CreditMemoAdd CreditMemoLineAdd Rate' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd RatePercent' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef ListID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef FullName' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd ClassRef ListID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd ClassRef FullName' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd Amount' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd ServiceDate' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef ListID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef FullName' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd IsTaxable' => 4,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef ListID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef FullName' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd Other1' => 6,
  'CreditMemoAdd CreditMemoLineAdd Other2' => 6,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 0,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 6,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 7,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 6,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 6,
  'CreditMemoAdd CreditMemoLineAdd DataExt OwnerID' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtName' => 999.99,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtValue' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef ListID' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef FullName' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd Desc' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd Quantity' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd UnitOfMeasure' => 7,
  'CreditMemoAdd CreditMemoLineGroupAdd ServiceDate' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt OwnerID' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtName' => 999.99,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtValue' => 999.99,
  'CreditMemoAdd DiscountLineAdd Amount' => 999.99,
  'CreditMemoAdd DiscountLineAdd RatePercent' => 999.99,
  'CreditMemoAdd DiscountLineAdd IsTaxable' => 4,
  'CreditMemoAdd DiscountLineAdd AccountRef ListID' => 999.99,
  'CreditMemoAdd DiscountLineAdd AccountRef FullName' => 999.99,
  'CreditMemoAdd SalesTaxLineAdd Amount' => 999.99,
  'CreditMemoAdd SalesTaxLineAdd RatePercent' => 999.99,
  'CreditMemoAdd SalesTaxLineAdd AccountRef ListID' => 999.99,
  'CreditMemoAdd SalesTaxLineAdd AccountRef FullName' => 999.99,
  'CreditMemoAdd ShippingLineAdd Amount' => 999.99,
  'CreditMemoAdd ShippingLineAdd AccountRef ListID' => 999.99,
  'CreditMemoAdd ShippingLineAdd AccountRef FullName' => 999.99,
  'IncludeRetElement' => 4,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'CreditMemoAdd CustomerRef ListID' => false,
  'CreditMemoAdd CustomerRef FullName' => false,
  'CreditMemoAdd ClassRef ListID' => false,
  'CreditMemoAdd ClassRef FullName' => false,
  'CreditMemoAdd ARAccountRef ListID' => false,
  'CreditMemoAdd ARAccountRef FullName' => false,
  'CreditMemoAdd TemplateRef ListID' => false,
  'CreditMemoAdd TemplateRef FullName' => false,
  'CreditMemoAdd TxnDate' => false,
  'CreditMemoAdd RefNumber' => false,
  'CreditMemoAdd BillAddress Addr1' => false,
  'CreditMemoAdd BillAddress Addr2' => false,
  'CreditMemoAdd BillAddress Addr3' => false,
  'CreditMemoAdd BillAddress Addr4' => false,
  'CreditMemoAdd BillAddress Addr5' => false,
  'CreditMemoAdd BillAddress City' => false,
  'CreditMemoAdd BillAddress State' => false,
  'CreditMemoAdd BillAddress PostalCode' => false,
  'CreditMemoAdd BillAddress Country' => false,
  'CreditMemoAdd BillAddress Note' => false,
  'CreditMemoAdd ShipAddress Addr1' => false,
  'CreditMemoAdd ShipAddress Addr2' => false,
  'CreditMemoAdd ShipAddress Addr3' => false,
  'CreditMemoAdd ShipAddress Addr4' => false,
  'CreditMemoAdd ShipAddress Addr5' => false,
  'CreditMemoAdd ShipAddress City' => false,
  'CreditMemoAdd ShipAddress State' => false,
  'CreditMemoAdd ShipAddress PostalCode' => false,
  'CreditMemoAdd ShipAddress Country' => false,
  'CreditMemoAdd ShipAddress Note' => false,
  'CreditMemoAdd IsPending' => false,
  'CreditMemoAdd PONumber' => false,
  'CreditMemoAdd TermsRef ListID' => false,
  'CreditMemoAdd TermsRef FullName' => false,
  'CreditMemoAdd DueDate' => false,
  'CreditMemoAdd SalesRepRef ListID' => false,
  'CreditMemoAdd SalesRepRef FullName' => false,
  'CreditMemoAdd FOB' => false,
  'CreditMemoAdd ShipDate' => false,
  'CreditMemoAdd ShipMethodRef ListID' => false,
  'CreditMemoAdd ShipMethodRef FullName' => false,
  'CreditMemoAdd ItemSalesTaxRef ListID' => false,
  'CreditMemoAdd ItemSalesTaxRef FullName' => false,
  'CreditMemoAdd Memo' => false,
  'CreditMemoAdd CustomerMsgRef ListID' => false,
  'CreditMemoAdd CustomerMsgRef FullName' => false,
  'CreditMemoAdd IsToBePrinted' => false,
  'CreditMemoAdd IsToBeEmailed' => false,
  'CreditMemoAdd IsTaxIncluded' => false,
  'CreditMemoAdd CustomerSalesTaxCodeRef ListID' => false,
  'CreditMemoAdd CustomerSalesTaxCodeRef FullName' => false,
  'CreditMemoAdd Other' => false,
  'CreditMemoAdd CreditMemoLineAdd ItemRef ListID' => false,
  'CreditMemoAdd CreditMemoLineAdd ItemRef FullName' => false,
  'CreditMemoAdd CreditMemoLineAdd Desc' => false,
  'CreditMemoAdd CreditMemoLineAdd Quantity' => false,
  'CreditMemoAdd CreditMemoLineAdd UnitOfMeasure' => false,
  'CreditMemoAdd CreditMemoLineAdd Rate' => false,
  'CreditMemoAdd CreditMemoLineAdd RatePercent' => false,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef ListID' => false,
  'CreditMemoAdd CreditMemoLineAdd PriceLevelRef FullName' => false,
  'CreditMemoAdd CreditMemoLineAdd ClassRef ListID' => false,
  'CreditMemoAdd CreditMemoLineAdd ClassRef FullName' => false,
  'CreditMemoAdd CreditMemoLineAdd Amount' => false,
  'CreditMemoAdd CreditMemoLineAdd ServiceDate' => false,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef ListID' => false,
  'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef FullName' => false,
  'CreditMemoAdd CreditMemoLineAdd IsTaxable' => false,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef ListID' => false,
  'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef FullName' => false,
  'CreditMemoAdd CreditMemoLineAdd Other1' => false,
  'CreditMemoAdd CreditMemoLineAdd Other2' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => false,
  'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => false,
  'CreditMemoAdd CreditMemoLineAdd DataExt OwnerID' => false,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtName' => false,
  'CreditMemoAdd CreditMemoLineAdd DataExt DataExtValue' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef ListID' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef FullName' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd Desc' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd Quantity' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd UnitOfMeasure' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd ServiceDate' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt OwnerID' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtName' => false,
  'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtValue' => false,
  'CreditMemoAdd DiscountLineAdd Amount' => false,
  'CreditMemoAdd DiscountLineAdd RatePercent' => false,
  'CreditMemoAdd DiscountLineAdd IsTaxable' => false,
  'CreditMemoAdd DiscountLineAdd AccountRef ListID' => false,
  'CreditMemoAdd DiscountLineAdd AccountRef FullName' => false,
  'CreditMemoAdd SalesTaxLineAdd Amount' => false,
  'CreditMemoAdd SalesTaxLineAdd RatePercent' => false,
  'CreditMemoAdd SalesTaxLineAdd AccountRef ListID' => false,
  'CreditMemoAdd SalesTaxLineAdd AccountRef FullName' => false,
  'CreditMemoAdd ShippingLineAdd Amount' => false,
  'CreditMemoAdd ShippingLineAdd AccountRef ListID' => false,
  'CreditMemoAdd ShippingLineAdd AccountRef FullName' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'CreditMemoAdd',
  1 => 'CreditMemoAdd CustomerRef',
  2 => 'CreditMemoAdd CustomerRef ListID',
  3 => 'CreditMemoAdd CustomerRef FullName',
  4 => 'CreditMemoAdd ClassRef ListID',
  5 => 'CreditMemoAdd ClassRef FullName',
  6 => 'CreditMemoAdd ARAccountRef ListID',
  7 => 'CreditMemoAdd ARAccountRef FullName',
  8 => 'CreditMemoAdd TemplateRef ListID',
  9 => 'CreditMemoAdd TemplateRef FullName',
  10 => 'CreditMemoAdd TxnDate',
  11 => 'CreditMemoAdd RefNumber',
  12 => 'CreditMemoAdd BillAddress Addr1',
  13 => 'CreditMemoAdd BillAddress Addr2',
  14 => 'CreditMemoAdd BillAddress Addr3',
  15 => 'CreditMemoAdd BillAddress Addr4',
  16 => 'CreditMemoAdd BillAddress Addr5',
  17 => 'CreditMemoAdd BillAddress City',
  18 => 'CreditMemoAdd BillAddress State',
  19 => 'CreditMemoAdd BillAddress PostalCode',
  20 => 'CreditMemoAdd BillAddress Country',
  21 => 'CreditMemoAdd BillAddress Note',
  22 => 'CreditMemoAdd ShipAddress Addr1',
  23 => 'CreditMemoAdd ShipAddress Addr2',
  24 => 'CreditMemoAdd ShipAddress Addr3',
  25 => 'CreditMemoAdd ShipAddress Addr4',
  26 => 'CreditMemoAdd ShipAddress Addr5',
  27 => 'CreditMemoAdd ShipAddress City',
  28 => 'CreditMemoAdd ShipAddress State',
  29 => 'CreditMemoAdd ShipAddress PostalCode',
  30 => 'CreditMemoAdd ShipAddress Country',
  31 => 'CreditMemoAdd ShipAddress Note',
  32 => 'CreditMemoAdd IsPending',
  33 => 'CreditMemoAdd PONumber',
  34 => 'CreditMemoAdd TermsRef ListID',
  35 => 'CreditMemoAdd TermsRef FullName',
  36 => 'CreditMemoAdd DueDate',
  37 => 'CreditMemoAdd SalesRepRef ListID',
  38 => 'CreditMemoAdd SalesRepRef FullName',
  39 => 'CreditMemoAdd FOB',
  40 => 'CreditMemoAdd ShipDate',
  41 => 'CreditMemoAdd ShipMethodRef ListID',
  42 => 'CreditMemoAdd ShipMethodRef FullName',
  43 => 'CreditMemoAdd ItemSalesTaxRef ListID',
  44 => 'CreditMemoAdd ItemSalesTaxRef FullName',
  45 => 'CreditMemoAdd Memo',
  46 => 'CreditMemoAdd CustomerMsgRef ListID',
  47 => 'CreditMemoAdd CustomerMsgRef FullName',
  48 => 'CreditMemoAdd IsToBePrinted',
  49 => 'CreditMemoAdd IsToBeEmailed',
  50 => 'CreditMemoAdd IsTaxIncluded',
  51 => 'CreditMemoAdd CustomerSalesTaxCodeRef ListID',
  52 => 'CreditMemoAdd CustomerSalesTaxCodeRef FullName',
  53 => 'CreditMemoAdd Other',
  54 => 'CreditMemoAdd',
  55 => 'CreditMemoAdd CreditMemoLineAdd',
  56 => 'CreditMemoAdd CreditMemoLineAdd ItemRef',
  57 => 'CreditMemoAdd CreditMemoLineAdd ItemRef ListID',
  58 => 'CreditMemoAdd CreditMemoLineAdd ItemRef FullName',
  59 => 'CreditMemoAdd CreditMemoLineAdd Desc',
  60 => 'CreditMemoAdd CreditMemoLineAdd Quantity',
  61 => 'CreditMemoAdd CreditMemoLineAdd UnitOfMeasure',
  62 => 'CreditMemoAdd CreditMemoLineAdd Rate',
  63 => 'CreditMemoAdd CreditMemoLineAdd RatePercent',
  64 => 'CreditMemoAdd CreditMemoLineAdd PriceLevelRef ListID',
  65 => 'CreditMemoAdd CreditMemoLineAdd PriceLevelRef FullName',
  66 => 'CreditMemoAdd CreditMemoLineAdd ClassRef ListID',
  67 => 'CreditMemoAdd CreditMemoLineAdd ClassRef FullName',
  68 => 'CreditMemoAdd CreditMemoLineAdd Amount',
  69 => 'CreditMemoAdd CreditMemoLineAdd ServiceDate',
  70 => 'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef ListID',
  71 => 'CreditMemoAdd CreditMemoLineAdd SalesTaxCodeRef FullName',
  72 => 'CreditMemoAdd CreditMemoLineAdd IsTaxable',
  73 => 'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef ListID',
  74 => 'CreditMemoAdd CreditMemoLineAdd OverrideItemAccountRef FullName',
  75 => 'CreditMemoAdd CreditMemoLineAdd Other1',
  76 => 'CreditMemoAdd CreditMemoLineAdd Other2',
  77 => 'CreditMemoAdd',
  78 => 'CreditMemoAdd CreditMemoLineAdd',
  79 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo',
  80 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo',
  81 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber',
  82 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth',
  83 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear',
  84 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard',
  85 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress',
  86 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode',
  87 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode',
  88 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode',
  89 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType',
  90 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode',
  91 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage',
  92 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID',
  93 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber',
  94 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode',
  95 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet',
  96 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip',
  97 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch',
  98 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID',
  99 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode',
  100 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus',
  101 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime',
  102 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp',
  103 => 'CreditMemoAdd CreditMemoLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID',
  104 => 'CreditMemoAdd CreditMemoLineAdd DataExt OwnerID',
  105 => 'CreditMemoAdd CreditMemoLineAdd DataExt DataExtName',
  106 => 'CreditMemoAdd CreditMemoLineAdd DataExt DataExtValue',
  107 => 'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef ListID',
  108 => 'CreditMemoAdd CreditMemoLineGroupAdd ItemGroupRef FullName',
  109 => 'CreditMemoAdd CreditMemoLineGroupAdd Desc',
  110 => 'CreditMemoAdd CreditMemoLineGroupAdd Quantity',
  111 => 'CreditMemoAdd CreditMemoLineGroupAdd UnitOfMeasure',
  112 => 'CreditMemoAdd CreditMemoLineGroupAdd ServiceDate',
  113 => 'CreditMemoAdd CreditMemoLineGroupAdd DataExt OwnerID',
  114 => 'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtName',
  115 => 'CreditMemoAdd CreditMemoLineGroupAdd DataExt DataExtValue',
  116 => 'CreditMemoAdd DiscountLineAdd Amount',
  117 => 'CreditMemoAdd DiscountLineAdd RatePercent',
  118 => 'CreditMemoAdd DiscountLineAdd IsTaxable',
  119 => 'CreditMemoAdd DiscountLineAdd AccountRef ListID',
  120 => 'CreditMemoAdd DiscountLineAdd AccountRef FullName',
  121 => 'CreditMemoAdd SalesTaxLineAdd Amount',
  122 => 'CreditMemoAdd SalesTaxLineAdd RatePercent',
  123 => 'CreditMemoAdd SalesTaxLineAdd AccountRef ListID',
  124 => 'CreditMemoAdd SalesTaxLineAdd AccountRef FullName',
  125 => 'CreditMemoAdd ShippingLineAdd Amount',
  126 => 'CreditMemoAdd ShippingLineAdd AccountRef ListID',
  127 => 'CreditMemoAdd ShippingLineAdd AccountRef FullName',
  128 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>