<?php

/**
 * Schema object for: ItemReceiptModRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_ItemReceiptModRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = '';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'ItemReceiptMod TxnID' => 'IDTYPE',
  'ItemReceiptMod EditSequence' => 'STRTYPE',
  'ItemReceiptMod VendorRef ListID' => 'IDTYPE',
  'ItemReceiptMod VendorRef FullName' => 'STRTYPE',
  'ItemReceiptMod APAccountRef ListID' => 'IDTYPE',
  'ItemReceiptMod APAccountRef FullName' => 'STRTYPE',
  'ItemReceiptMod TxnDate' => 'DATETYPE',
  'ItemReceiptMod RefNumber' => 'STRTYPE',
  'ItemReceiptMod Memo' => 'STRTYPE',
  'ItemReceiptMod ClearExpenseLines' => 'BOOLTYPE',
  'ItemReceiptMod ExpenseLineMod TxnLineID' => 'IDTYPE',
  'ItemReceiptMod ExpenseLineMod AccountRef ListID' => 'IDTYPE',
  'ItemReceiptMod ExpenseLineMod AccountRef FullName' => 'STRTYPE',
  'ItemReceiptMod ExpenseLineMod Amount' => 'AMTTYPE',
  'ItemReceiptMod ExpenseLineMod TaxAmount' => 'AMTTYPE',
  'ItemReceiptMod ExpenseLineMod Memo' => 'STRTYPE',
  'ItemReceiptMod ExpenseLineMod CustomerRef ListID' => 'IDTYPE',
  'ItemReceiptMod ExpenseLineMod CustomerRef FullName' => 'STRTYPE',
  'ItemReceiptMod ExpenseLineMod ClassRef ListID' => 'IDTYPE',
  'ItemReceiptMod ExpenseLineMod ClassRef FullName' => 'STRTYPE',
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'ItemReceiptMod ExpenseLineMod BillableStatus' => 'ENUMTYPE',
  'ItemReceiptMod ClearItemLines' => 'BOOLTYPE',
  'ItemReceiptMod ItemLineMod TxnLineID' => 'IDTYPE',
  'ItemReceiptMod ItemLineMod ItemRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemLineMod ItemRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemLineMod Desc' => 'STRTYPE',
  'ItemReceiptMod ItemLineMod Quantity' => 'QUANTYPE',
  'ItemReceiptMod ItemLineMod UnitOfMeasure' => 'STRTYPE',
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemLineMod Cost' => 'PRICETYPE',
  'ItemReceiptMod ItemLineMod Amount' => 'AMTTYPE',
  'ItemReceiptMod ItemLineMod TaxAmount' => 'AMTTYPE',
  'ItemReceiptMod ItemLineMod CustomerRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemLineMod CustomerRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemLineMod ClassRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemLineMod ClassRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemLineMod BillableStatus' => 'ENUMTYPE',
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod TxnLineID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod Quantity' => 'QUANTYPE',
  'ItemReceiptMod ItemGroupLineMod UnitOfMeasure' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TxnLineID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Desc' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Quantity' => 'QUANTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod UnitOfMeasure' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Cost' => 'PRICETYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Amount' => 'AMTTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TaxAmount' => 'AMTTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod BillableStatus' => 'ENUMTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'ItemReceiptMod TxnID' => 0,
  'ItemReceiptMod EditSequence' => 16,
  'ItemReceiptMod VendorRef ListID' => 0,
  'ItemReceiptMod VendorRef FullName' => 41,
  'ItemReceiptMod APAccountRef ListID' => 0,
  'ItemReceiptMod APAccountRef FullName' => 41,
  'ItemReceiptMod TxnDate' => 0,
  'ItemReceiptMod RefNumber' => 20,
  'ItemReceiptMod Memo' => 4095,
  'ItemReceiptMod ClearExpenseLines' => 0,
  'ItemReceiptMod ExpenseLineMod TxnLineID' => 0,
  'ItemReceiptMod ExpenseLineMod AccountRef ListID' => 0,
  'ItemReceiptMod ExpenseLineMod AccountRef FullName' => 41,
  'ItemReceiptMod ExpenseLineMod Amount' => 0,
  'ItemReceiptMod ExpenseLineMod TaxAmount' => 0,
  'ItemReceiptMod ExpenseLineMod Memo' => 4095,
  'ItemReceiptMod ExpenseLineMod CustomerRef ListID' => 0,
  'ItemReceiptMod ExpenseLineMod CustomerRef FullName' => 41,
  'ItemReceiptMod ExpenseLineMod ClassRef ListID' => 0,
  'ItemReceiptMod ExpenseLineMod ClassRef FullName' => 41,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef ListID' => 0,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef FullName' => 41,
  'ItemReceiptMod ExpenseLineMod BillableStatus' => 0,
  'ItemReceiptMod ClearItemLines' => 0,
  'ItemReceiptMod ItemLineMod TxnLineID' => 0,
  'ItemReceiptMod ItemLineMod ItemRef ListID' => 0,
  'ItemReceiptMod ItemLineMod ItemRef FullName' => 41,
  'ItemReceiptMod ItemLineMod Desc' => 4095,
  'ItemReceiptMod ItemLineMod Quantity' => 0,
  'ItemReceiptMod ItemLineMod UnitOfMeasure' => 31,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef ListID' => 0,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef FullName' => 41,
  'ItemReceiptMod ItemLineMod Cost' => 0,
  'ItemReceiptMod ItemLineMod Amount' => 0,
  'ItemReceiptMod ItemLineMod TaxAmount' => 0,
  'ItemReceiptMod ItemLineMod CustomerRef ListID' => 0,
  'ItemReceiptMod ItemLineMod CustomerRef FullName' => 41,
  'ItemReceiptMod ItemLineMod ClassRef ListID' => 0,
  'ItemReceiptMod ItemLineMod ClassRef FullName' => 41,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef ListID' => 0,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef FullName' => 41,
  'ItemReceiptMod ItemLineMod BillableStatus' => 0,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef ListID' => 0,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod TxnLineID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod Quantity' => 0,
  'ItemReceiptMod ItemGroupLineMod UnitOfMeasure' => 31,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TxnLineID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Desc' => 4095,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Quantity' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod UnitOfMeasure' => 31,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Cost' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Amount' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TaxAmount' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef FullName' => 41,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod BillableStatus' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef ListID' => 0,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef FullName' => 41,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'ItemReceiptMod TxnID' => false,
  'ItemReceiptMod EditSequence' => false,
  'ItemReceiptMod VendorRef ListID' => true,
  'ItemReceiptMod VendorRef FullName' => true,
  'ItemReceiptMod APAccountRef ListID' => true,
  'ItemReceiptMod APAccountRef FullName' => true,
  'ItemReceiptMod TxnDate' => true,
  'ItemReceiptMod RefNumber' => true,
  'ItemReceiptMod Memo' => true,
  'ItemReceiptMod ClearExpenseLines' => true,
  'ItemReceiptMod ExpenseLineMod TxnLineID' => false,
  'ItemReceiptMod ExpenseLineMod AccountRef ListID' => true,
  'ItemReceiptMod ExpenseLineMod AccountRef FullName' => true,
  'ItemReceiptMod ExpenseLineMod Amount' => true,
  'ItemReceiptMod ExpenseLineMod TaxAmount' => true,
  'ItemReceiptMod ExpenseLineMod Memo' => true,
  'ItemReceiptMod ExpenseLineMod CustomerRef ListID' => true,
  'ItemReceiptMod ExpenseLineMod CustomerRef FullName' => true,
  'ItemReceiptMod ExpenseLineMod ClassRef ListID' => true,
  'ItemReceiptMod ExpenseLineMod ClassRef FullName' => true,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef ListID' => true,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef FullName' => true,
  'ItemReceiptMod ExpenseLineMod BillableStatus' => true,
  'ItemReceiptMod ClearItemLines' => true,
  'ItemReceiptMod ItemLineMod TxnLineID' => false,
  'ItemReceiptMod ItemLineMod ItemRef ListID' => true,
  'ItemReceiptMod ItemLineMod ItemRef FullName' => true,
  'ItemReceiptMod ItemLineMod Desc' => true,
  'ItemReceiptMod ItemLineMod Quantity' => true,
  'ItemReceiptMod ItemLineMod UnitOfMeasure' => true,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef ListID' => true,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef FullName' => true,
  'ItemReceiptMod ItemLineMod Cost' => true,
  'ItemReceiptMod ItemLineMod Amount' => true,
  'ItemReceiptMod ItemLineMod TaxAmount' => true,
  'ItemReceiptMod ItemLineMod CustomerRef ListID' => true,
  'ItemReceiptMod ItemLineMod CustomerRef FullName' => true,
  'ItemReceiptMod ItemLineMod ClassRef ListID' => true,
  'ItemReceiptMod ItemLineMod ClassRef FullName' => true,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef ListID' => true,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef FullName' => true,
  'ItemReceiptMod ItemLineMod BillableStatus' => true,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef ListID' => true,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod TxnLineID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod Quantity' => true,
  'ItemReceiptMod ItemGroupLineMod UnitOfMeasure' => true,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TxnLineID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Desc' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Quantity' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod UnitOfMeasure' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Cost' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Amount' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TaxAmount' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef FullName' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod BillableStatus' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef ListID' => true,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef FullName' => true,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'ItemReceiptMod TxnID' => 999.99,
  'ItemReceiptMod EditSequence' => 999.99,
  'ItemReceiptMod VendorRef ListID' => 999.99,
  'ItemReceiptMod VendorRef FullName' => 999.99,
  'ItemReceiptMod APAccountRef ListID' => 999.99,
  'ItemReceiptMod APAccountRef FullName' => 999.99,
  'ItemReceiptMod TxnDate' => 999.99,
  'ItemReceiptMod RefNumber' => 999.99,
  'ItemReceiptMod Memo' => 999.99,
  'ItemReceiptMod ClearExpenseLines' => 999.99,
  'ItemReceiptMod ExpenseLineMod TxnLineID' => 999.99,
  'ItemReceiptMod ExpenseLineMod AccountRef ListID' => 999.99,
  'ItemReceiptMod ExpenseLineMod AccountRef FullName' => 999.99,
  'ItemReceiptMod ExpenseLineMod Amount' => 999.99,
  'ItemReceiptMod ExpenseLineMod TaxAmount' => 6.1,
  'ItemReceiptMod ExpenseLineMod Memo' => 999.99,
  'ItemReceiptMod ExpenseLineMod CustomerRef ListID' => 999.99,
  'ItemReceiptMod ExpenseLineMod CustomerRef FullName' => 999.99,
  'ItemReceiptMod ExpenseLineMod ClassRef ListID' => 999.99,
  'ItemReceiptMod ExpenseLineMod ClassRef FullName' => 999.99,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef ListID' => 999.99,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef FullName' => 999.99,
  'ItemReceiptMod ExpenseLineMod BillableStatus' => 999.99,
  'ItemReceiptMod ClearItemLines' => 999.99,
  'ItemReceiptMod ItemLineMod TxnLineID' => 999.99,
  'ItemReceiptMod ItemLineMod ItemRef ListID' => 999.99,
  'ItemReceiptMod ItemLineMod ItemRef FullName' => 999.99,
  'ItemReceiptMod ItemLineMod Desc' => 999.99,
  'ItemReceiptMod ItemLineMod Quantity' => 999.99,
  'ItemReceiptMod ItemLineMod UnitOfMeasure' => 7,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef ListID' => 999.99,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef FullName' => 999.99,
  'ItemReceiptMod ItemLineMod Cost' => 999.99,
  'ItemReceiptMod ItemLineMod Amount' => 999.99,
  'ItemReceiptMod ItemLineMod TaxAmount' => 6.1,
  'ItemReceiptMod ItemLineMod CustomerRef ListID' => 999.99,
  'ItemReceiptMod ItemLineMod CustomerRef FullName' => 999.99,
  'ItemReceiptMod ItemLineMod ClassRef ListID' => 999.99,
  'ItemReceiptMod ItemLineMod ClassRef FullName' => 999.99,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef ListID' => 999.99,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef FullName' => 999.99,
  'ItemReceiptMod ItemLineMod BillableStatus' => 999.99,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef ListID' => 999.99,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod TxnLineID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod Quantity' => 999.99,
  'ItemReceiptMod ItemGroupLineMod UnitOfMeasure' => 7,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TxnLineID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Desc' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Quantity' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod UnitOfMeasure' => 7,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Cost' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Amount' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TaxAmount' => 6.1,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef FullName' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod BillableStatus' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef ListID' => 999.99,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef FullName' => 999.99,
  'IncludeRetElement' => 999.99,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'ItemReceiptMod TxnID' => false,
  'ItemReceiptMod EditSequence' => false,
  'ItemReceiptMod VendorRef ListID' => false,
  'ItemReceiptMod VendorRef FullName' => false,
  'ItemReceiptMod APAccountRef ListID' => false,
  'ItemReceiptMod APAccountRef FullName' => false,
  'ItemReceiptMod TxnDate' => false,
  'ItemReceiptMod RefNumber' => false,
  'ItemReceiptMod Memo' => false,
  'ItemReceiptMod ClearExpenseLines' => false,
  'ItemReceiptMod ExpenseLineMod TxnLineID' => false,
  'ItemReceiptMod ExpenseLineMod AccountRef ListID' => false,
  'ItemReceiptMod ExpenseLineMod AccountRef FullName' => false,
  'ItemReceiptMod ExpenseLineMod Amount' => false,
  'ItemReceiptMod ExpenseLineMod TaxAmount' => false,
  'ItemReceiptMod ExpenseLineMod Memo' => false,
  'ItemReceiptMod ExpenseLineMod CustomerRef ListID' => false,
  'ItemReceiptMod ExpenseLineMod CustomerRef FullName' => false,
  'ItemReceiptMod ExpenseLineMod ClassRef ListID' => false,
  'ItemReceiptMod ExpenseLineMod ClassRef FullName' => false,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef ListID' => false,
  'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef FullName' => false,
  'ItemReceiptMod ExpenseLineMod BillableStatus' => false,
  'ItemReceiptMod ClearItemLines' => false,
  'ItemReceiptMod ItemLineMod TxnLineID' => false,
  'ItemReceiptMod ItemLineMod ItemRef ListID' => false,
  'ItemReceiptMod ItemLineMod ItemRef FullName' => false,
  'ItemReceiptMod ItemLineMod Desc' => false,
  'ItemReceiptMod ItemLineMod Quantity' => false,
  'ItemReceiptMod ItemLineMod UnitOfMeasure' => false,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef ListID' => false,
  'ItemReceiptMod ItemLineMod OverrideUOMSetRef FullName' => false,
  'ItemReceiptMod ItemLineMod Cost' => false,
  'ItemReceiptMod ItemLineMod Amount' => false,
  'ItemReceiptMod ItemLineMod TaxAmount' => false,
  'ItemReceiptMod ItemLineMod CustomerRef ListID' => false,
  'ItemReceiptMod ItemLineMod CustomerRef FullName' => false,
  'ItemReceiptMod ItemLineMod ClassRef ListID' => false,
  'ItemReceiptMod ItemLineMod ClassRef FullName' => false,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef ListID' => false,
  'ItemReceiptMod ItemLineMod SalesTaxCodeRef FullName' => false,
  'ItemReceiptMod ItemLineMod BillableStatus' => false,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef ListID' => false,
  'ItemReceiptMod ItemLineMod OverrideItemAccountRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod TxnLineID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemGroupRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod Quantity' => false,
  'ItemReceiptMod ItemGroupLineMod UnitOfMeasure' => false,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TxnLineID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Desc' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Quantity' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod UnitOfMeasure' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Cost' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod Amount' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod TaxAmount' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef FullName' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod BillableStatus' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef ListID' => false,
  'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef FullName' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'ItemReceiptMod TxnID',
  1 => 'ItemReceiptMod EditSequence',
  2 => 'ItemReceiptMod VendorRef ListID',
  3 => 'ItemReceiptMod VendorRef FullName',
  4 => 'ItemReceiptMod APAccountRef ListID',
  5 => 'ItemReceiptMod APAccountRef FullName',
  6 => 'ItemReceiptMod TxnDate',
  7 => 'ItemReceiptMod RefNumber',
  8 => 'ItemReceiptMod Memo',
  9 => 'ItemReceiptMod ClearExpenseLines',
  10 => 'ItemReceiptMod ExpenseLineMod TxnLineID',
  11 => 'ItemReceiptMod ExpenseLineMod AccountRef ListID',
  12 => 'ItemReceiptMod ExpenseLineMod AccountRef FullName',
  13 => 'ItemReceiptMod ExpenseLineMod Amount',
  14 => 'ItemReceiptMod ExpenseLineMod TaxAmount',
  15 => 'ItemReceiptMod ExpenseLineMod Memo',
  16 => 'ItemReceiptMod ExpenseLineMod CustomerRef ListID',
  17 => 'ItemReceiptMod ExpenseLineMod CustomerRef FullName',
  18 => 'ItemReceiptMod ExpenseLineMod ClassRef ListID',
  19 => 'ItemReceiptMod ExpenseLineMod ClassRef FullName',
  20 => 'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef ListID',
  21 => 'ItemReceiptMod ExpenseLineMod SalesTaxCodeRef FullName',
  22 => 'ItemReceiptMod ExpenseLineMod BillableStatus',
  23 => 'ItemReceiptMod ClearItemLines',
  24 => 'ItemReceiptMod ItemLineMod TxnLineID',
  25 => 'ItemReceiptMod ItemLineMod ItemRef ListID',
  26 => 'ItemReceiptMod ItemLineMod ItemRef FullName',
  27 => 'ItemReceiptMod ItemLineMod Desc',
  28 => 'ItemReceiptMod ItemLineMod Quantity',
  29 => 'ItemReceiptMod ItemLineMod UnitOfMeasure',
  30 => 'ItemReceiptMod ItemLineMod OverrideUOMSetRef ListID',
  31 => 'ItemReceiptMod ItemLineMod OverrideUOMSetRef FullName',
  32 => 'ItemReceiptMod ItemLineMod Cost',
  33 => 'ItemReceiptMod ItemLineMod Amount',
  34 => 'ItemReceiptMod ItemLineMod TaxAmount',
  35 => 'ItemReceiptMod ItemLineMod CustomerRef ListID',
  36 => 'ItemReceiptMod ItemLineMod CustomerRef FullName',
  37 => 'ItemReceiptMod ItemLineMod ClassRef ListID',
  38 => 'ItemReceiptMod ItemLineMod ClassRef FullName',
  39 => 'ItemReceiptMod ItemLineMod SalesTaxCodeRef ListID',
  40 => 'ItemReceiptMod ItemLineMod SalesTaxCodeRef FullName',
  41 => 'ItemReceiptMod ItemLineMod BillableStatus',
  42 => 'ItemReceiptMod ItemLineMod OverrideItemAccountRef ListID',
  43 => 'ItemReceiptMod ItemLineMod OverrideItemAccountRef FullName',
  44 => 'ItemReceiptMod ItemGroupLineMod TxnLineID',
  45 => 'ItemReceiptMod ItemGroupLineMod ItemGroupRef ListID',
  46 => 'ItemReceiptMod ItemGroupLineMod ItemGroupRef FullName',
  47 => 'ItemReceiptMod ItemGroupLineMod Quantity',
  48 => 'ItemReceiptMod ItemGroupLineMod UnitOfMeasure',
  49 => 'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef ListID',
  50 => 'ItemReceiptMod ItemGroupLineMod OverrideUOMSetRef FullName',
  51 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod TxnLineID',
  52 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef ListID',
  53 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod ItemRef FullName',
  54 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod Desc',
  55 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod Quantity',
  56 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod UnitOfMeasure',
  57 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef ListID',
  58 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideUOMSetRef FullName',
  59 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod Cost',
  60 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod Amount',
  61 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod TaxAmount',
  62 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef ListID',
  63 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod CustomerRef FullName',
  64 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef ListID',
  65 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod ClassRef FullName',
  66 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef ListID',
  67 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod SalesTaxCodeRef FullName',
  68 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod BillableStatus',
  69 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef ListID',
  70 => 'ItemReceiptMod ItemGroupLineMod ItemLineMod OverrideItemAccountRef FullName',
  71 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>