<?php

    //Version Checks
    {
		global $_index_constants_static_loaded;
		$_index_constants_static_loaded = false;
		register_shutdown_function(function(){
			global $_index_constants_static_loaded;
			if(!$_index_constants_static_loaded){
				if(PHP_VERSION_ID >= 80000 && PHP_VERSION_ID < 80200){
					echo "<h1>ERROR: PHP v8.0 and v8.1 are not supported.</h1>";
				}
				else {
					echo "<h1>ERROR: Check Ioncube installation. [E56143232]</h1>";
				}
			}
		});
		require_once(dirname(__FILE__).'/!/application/config/constants.static.php');
		$_index_constants_static_loaded = true;

        function __is_windows_desktop_install(){
            return stristr(php_uname('s'), 'Windows') && file_exists(dirname(__FILE__).'/../install/my.default.ini');
        }
        function __index_show_update_msg($msg = ''){
            // The Windows user needs to download our backend update
            ?>
            <!DOCTYPE html>
            <html>
                <head>
                    <title>Backend Update Required</title>
                    <link rel="stylesheet" type="text/css" href="<?= defined('CSS_URL') ? CSS_URL : 'css/' ?>ui.css">
                </head>
                <body style="padding: 12px;">
                    <?= $msg ? "<h2>$msg</h2>" : '' ?>
                    <?php 
                        if(__is_windows_desktop_install()){
                    ?>
                        <h2>Before proceeding you will need to run a special update for the backend of NolaPro (Apache & PHP).</h2>
                        <h2><a href="http://noguska.com/NolaPro-Backend-Update.exe">Click here to download the update.</a></h2>
                        <h2>Refresh this page after completing the update.</h2>
                    <?php 
                        }
                    ?>
                </body>
            </html>
            <?php
            die();
        }
        function __min_server_software_version_check(){
            //Skip checks if Cloud-Hosted or is Dev
			require_once(dirname(__FILE__).'/!/application/helpers/hosted.php');
            $hosted = in_array($_SERVER['SERVER_ADDR'], getHostedIPs());
            $dev    = substr($_SERVER['SERVER_NAME'], -11) == 'noguska.com';
            if($hosted || $dev) return;
            
            //Define Version Information
            if (!defined('PHP_VERSION_ID')) {
                $version = explode('.', PHP_VERSION);
                define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
            }
            $min_version = explode('.', REQUIRED_PHP_VERSION_MIN);
            $min_version = ($min_version[0] * 10000 + $min_version[1] * 100 + $min_version[2]);
            $min_win_version = explode('.', REQUIRED_PHP_VERSION_MIN);
            $min_win_version = ($min_win_version[0] * 10000 + $min_win_version[1] * 100 + $min_win_version[2]);
            $ioncube_loader_iversion = function_exists('ioncube_loader_iversion') ? ioncube_loader_iversion() : 0;
            
            //Check: ionCube Loader exists
			$ignoreIoncubeWarnings = false;
            if(!extension_loaded('ionCube Loader') && file_exists('../.ignoreioncubeloadermissing')) $ignoreIoncubeWarnings = true;
            if(!extension_loaded('ionCube Loader') && !$ignoreIoncubeWarnings)
                __index_show_update_msg("Missing IonCube Loader!");
            
            //Check: Windows-PHP Min Version
            if (__is_windows_desktop_install() && PHP_VERSION_ID < $min_win_version)
                __index_show_update_msg();
            
            //Check: PHP Min Version
            if (PHP_VERSION_ID < $min_version)
                __index_show_update_msg('This software requires PHP '.REQUIRED_PHP_VERSION_MIN.' or better. (Running PHP v'.PHP_VERSION.')');
            
            //Check: ionCube Min Version
            if(intval($ioncube_loader_iversion) < MIN_IONCUBE_IVERSION && !$ignoreIoncubeWarnings)
                __index_show_update_msg('You must <a target="_blank" href="http://www.ioncube.com/loaders.php">update your installation of ionCube</a> before this software can run.');
        }
        __min_server_software_version_check();
    }
    
    if (file_exists('install.php')) {
        include('install.php');
        die();
    }

    require_once(dirname(__FILE__)."/includes/classes/nptable.php");
    require_once(dirname(__FILE__)."/includes/classes/company_defaults.php");
    require_once(dirname(__FILE__)."/includes/classes/company.php");
    require_once(dirname(__FILE__)."/includes/classes/apcompany.php");
    require_once(dirname(__FILE__)."/includes/classes/arcompany.php");
    require_once(dirname(__FILE__)."/includes/classes/invcompany.php");
    require_once(dirname(__FILE__)."/includes/classes/prcompany.php");
    require_once(dirname(__FILE__)."/includes/functions.php");
	require_once(dirname(__FILE__)."/!/application/config/constants.php");
	require(dirname(__FILE__).'/includes/session.php');
	
	if(@$_REQUEST['logout'] == 1){
		ini_set('display_errors',0);
		redirect('indexmain.php?logout=1'.(@$_REQUEST['qsdone']?'&qsdone=1':''), 0);
	}
	if(@$_REQUEST['qs_reset'] == 1)
		redirect('indexmain.php?createmenu=2&quick_setup=0&qs_reset=0'.(@$_REQUEST['qsdone']?'&qsdone=1':''), 0);

	require_once('includes/defines.php');
	require_once('includes/adodb/adodb.inc.php');
	$recordSet = $conn->execute("select max(id) from gencompany where active=1");
	if (!$recordSet||$recordSet->fields[0]<1||@$quick_setup==1) {
		$glog = isset($_REQUEST['glog']) ? '&glog=1' : '';
		redirect('indexmain.php?quick_setup=1&qs_reset=0&ref=index'.$glog, 0);
	}
	if(!isset($_REQUEST['autoUpdateAction'])){
		//NP6
		require(NP_BASE_DIR.'includes/auth.php');//Try to login
		$appendRedirectURL = [];
		if(isset($_REQUEST['uselangcode'])) $appendRedirectURL['uselangcode'] = $_REQUEST['uselangcode'];
		if(isset($_REQUEST['start_walkthrough'])) $appendRedirectURL['start_walkthrough'] = $_REQUEST['start_walkthrough'];
		$appendRedirectURL = http_build_query($appendRedirectURL);
		$url = CI_BASE_URL.($appendRedirectURL === '' ? '' : '?&'.$appendRedirectURL);
		if(!headers_sent()) header('Location: '.$url);
		redirect($url);
	}
	else{
		//NP5
		chdir(dirname(__FILE__));
		include('indexmain.php');
		require_once("includes/footer.php");
	}