if(typeof(top.ClientService) != 'undefined'){
	window.ClientService = top.ClientService;
}
else {
	window.ClientService = {
		isEnabled: null,
		isAjaxActive: false,
		version: null,
		queueBuffer: [],
		events: {'OnEnable': [], 'OnDisable': []},
		suspended: false,
		//Core Functions
		Init: function(callback){
			ClientService.Call('version', null, 
				//Success
				function(r){
					ClientService.version = r;
					ClientService.isEnabled = true;
					ClientService.OnEnable();
					if(typeof(callback) == 'function') callback();
				},
				//Error
				function(){
					ClientService.isEnabled = false;
					ClientService.OnDisable();
					if(typeof(callback) == 'function') callback();
				});
		},
		QuickInit: function(callback, timeout_ms){
			if(typeof(timeout_ms) == 'undefined') timeout_ms = 1000;
			if(typeof(callback) != 'function') callback = function(){};
			var timedout = false;
			var initRan = false;
			setTimeout(function(){
				timedout = true;
				if(!initRan) callback();
			}, timeout_ms);
			ClientService.Init(function(){
				initRan = true;
				if(!timedout) callback();
			});
		},
		Call: function(action, data, onsuccess, onerror){
			if(typeof(onerror) != 'function') onerror = function(){};
			if(typeof(onsuccess) != 'function') onsuccess = function(){};
			if(typeof(data) != 'object' || data === null) data = {};
			if(ClientService.isEnabled === false){
				onerror(null, '0', 'Client Service Is Not Enabled');
				return;
			}
			data.__action = action;
			ClientService.queueBuffer.push({data: data, onsuccess: onsuccess, onerror: onerror});
			if(!ClientService.suspended) ClientService.ClearQueue();
		},
		ClearQueue: function(){
			//Run only one at a time, and only when there is data to send
			if(ClientService.isAjaxActive || ClientService.queueBuffer.length == 0) return;
			ClientService.isAjaxActive = true;
			//Clear/Copy the buffer to be sent out
			//--Start request with 'auth' action always
			var sendBuffer = [{ }];
			var sendData = [{
				__action: 'auth',
				BUILD_VERSION: ""+window.BUILD_VERSION,
				NP_BASE_URL: window.NP_BASE_URL,
				PHPSESSID: typeof(window.npsessionid) != 'undefined' ? window.npsessionid : (typeof(document.cookie) == 'string' ? document.cookie.match(/\bPHPSESSID=([^\s]*)/).pop() : null),
				PHPSESSNAME: typeof(window.npsessionname) != 'undefined' ? window.npsessionname : null
			}];
			while(ClientService.queueBuffer.length > 0){
				var d = ClientService.queueBuffer.shift();
				sendData.push(d.data);
				sendBuffer.push(d);
			}
			//Call Ajax
			jQuery.ajaxRetry({
				type: "POST",
				url: 'http://127.0.0.1:50081/',
				data: JSON.stringify(sendData),
				success: function(data, xhr, textStatus){
					ClientService.isAjaxActive = false;
					var dataSets = typeof(data) == 'string' ? JSON.parse(data) : data;
					for(var i in sendBuffer){
						if(typeof(sendBuffer[i].onsuccess) == 'function'){
							sendBuffer[i].onsuccess(dataSets[i], xhr, textStatus);
						}
					}
					ClientService.ClearQueue();
				},
				error: function(xhr, textStatus, errorThrown){
					ClientService.isAjaxActive = false;
					for(var i in sendBuffer){
						if(typeof(sendBuffer[i].onerror) == 'function'){
							sendBuffer[i].onerror(xhr, textStatus, errorThrown);
						}
					}
					ClientService.ClearQueue();
				}
			});
		},
		HasVersion: function(version){
			if(ClientService.version === null || typeof(ClientService.version) != 'object') return null;
			if(typeof(version) != 'string') return null;
			var cmp_parts = version.split('.');
			var cur_parts = ClientService.version.client.split('.');
			for(var i in cur_parts){
				if(cmp_parts[i] == cur_parts[i]) continue;
				if(cur_parts[i] > cmp_parts[i]) return true;
				if(cmp_parts[i] > cur_parts[i]) return false;
			}
			return true;
		},
		//Event Register
		On: function(name, callable){
			//Start buffer
			if(typeof(ClientService.events[name]) == 'undefined') ClientService.events[name] = [];
			//Trigger Event
			if(typeof(callable) == 'undefined'){
				for(var i in ClientService.events[name]){
					ClientService.events[name][i]();
				}
			}
			//Register Event
			else if(typeof(callable) == 'function'){
				ClientService.events[name].push(callable);
			}
		},
		OnEnable: function(callable){
			if(typeof(callable) == 'undefined') return ClientService.On('OnEnable');
			else return ClientService.On('OnEnable', callable);
		},
		OnDisable: function(callable){
			if(typeof(callable) == 'undefined') return ClientService.On('OnDisable');
			else return ClientService.On('OnDisable', callable);
		},
		//Requests
		SetClientValue: function(key, value, onsuccess, onerror){
			if(typeof(onerror) != 'function') onerror = function(){};
			if(typeof(onsuccess) != 'function') onsuccess = function(){};
			return ClientService.Call('setvalue', {key: key, value: value}, onsuccess, onerror);
		},
		GetClientValue: function(key, onsuccess, onerror){
			if(typeof(onerror) != 'function') onerror = function(){};
			if(typeof(onsuccess) != 'function') onsuccess = function(){};
			return ClientService.Call('getvalue', {key: key}, onsuccess, onerror);
		},
		GetPrinterList: function(onsuccess, onerror){
			if(typeof(onerror) != 'function') onerror = function(){};
			if(typeof(onsuccess) != 'function') onsuccess = function(){};
			return ClientService.Call('getprinterlist', {}, onsuccess, onerror);
		},
		PrintPDF: function(PDFData, printerDeviceID, printType, documentName, onsuccess, onerror){
			var params = {PDFData: PDFData, PrinterDeviceID: printerDeviceID, PrintType: printType, DocumentName: documentName};
			return ClientService.Call('printpdf', params, onsuccess, onerror);
		},
		PrintPDFFromURL: function(PDF_URL, printerDeviceID, printType, documentName, ondownloadfinish, onsuccess, onerror, redirectIndex){
			//Default Values
			if(typeof(redirectIndex) == 'undefined') redirectIndex = 0;
			if(typeof(onerror) != 'function') onerror = function(){};
			if(typeof(onsuccess) != 'function') onsuccess = function(){};
			if(typeof(ondownloadfinish) != 'function') ondownloadfinish = function(){};
			//Download PDF
			var aborted = false;
			fetch(PDF_URL)
				.then(function(resp){ return resp.blob(); })
				.then( blob => new Promise( callback =>{
					var reader = new FileReader();
					reader.onload = function(){ callback(this.result) };
					reader.readAsDataURL(blob);
				}))
				.then(function(resp){
					if(aborted) return;
					//HTML Response
					if(resp.match(/^data:text\/html;/)){
						var html = atob(resp.replace(/^data:text\/html(; [^\s]*=[^\s]*)?;base64,/, ''));
						//Login Page?
						if(html.indexOf('id="txbxUsername"') >= 0 && html.indexOf('name="entered_password"') && html.indexOf('id="forgot_pwd_img"')){
							error('Login Required [E2460646075]');
							return;
						}
						//Redirect
						else if(redirectIndex < 4 && html.indexOf('<!--{"redirect-url":') >= 0){
							var match = html.match(/<!--\s*(\{"redirect-url":.*?\})\s*-->/);
							if(match){
								var json_html_encoded = match[1];
								var json = $('<textarea />').html(json_html_encoded).text();
								var data = JSON.parse(json);
								if(typeof(data) != 'undefined' && data){
									redirectIndex++;
									return ClientService.PrintPDFFromURL(data['redirect-url'], printerDeviceID, printType, documentName, ondownloadfinish, onsuccess, onerror, redirectIndex);
								}
							}
						}
					}
					//PDF Downloaded
					if(ondownloadfinish() === false) return;//aborted
					//Error: Bad File Type
					if(!resp.match(/^data:application\/pdf;base64,/)) onerror('Incorrect Document Mime Type [E0623468464326]');
					//Send PDF data to the client to print
					else ClientService.PrintPDF(resp.replace(/^data:application\/pdf;base64,/, ''), printerDeviceID, printType, documentName, onsuccess, onerror);
				})
				.catch(onerror);

			return {abort: function(){
				aborted = true;
			}};
		},
		UpdateInstallation: function(autoTriggerDownload, onsuccess, onerror){
			if(typeof(autoTriggerDownload) == 'undefined') autoTriggerDownload = true;
			if(typeof(onerror) != 'function') onerror = function(){};
			if(typeof(onsuccess) != 'function') onsuccess = function(){};

			var onsuccess_org = onsuccess;
			onsuccess = function(e){
				if(e !== null && typeof(e) == 'object'){
					if(autoTriggerDownload && (typeof(e.update_triggered) == 'undefined' || !e.update_triggered) && typeof(e.download_url) == 'string') window.open('_new', e.download_url);
					if(typeof(e.process_error) == 'string') console.log(process_error + ' [E26408668627]');
				}
				onsuccess_org(e);
			};

			var onerror_org = onerror;
			onerror = function(e){
				if(e !== null && typeof(e) == 'object'){
					if(autoTriggerDownload && (typeof(e.update_triggered) == 'undefined' || !e.update_triggered) && typeof(e.download_url) == 'string') window.open('_new', e.download_url);
					if(typeof(e.process_error) == 'string') console.log(process_error + ' [E3246608478]');
				}
				onerror_org(e);
			};

			return ClientService.Call('updateinstallation', {}, onsuccess, onerror);
		},
		UpdateClient: function(autoTriggerDownload, onsuccess, onerror){
			if(typeof(autoTriggerDownload) == 'undefined') autoTriggerDownload = true;
			if(typeof(onerror) != 'function') onerror = function(){};
			if(typeof(onsuccess) != 'function') onsuccess = function(){};

			var onsuccess_org = onsuccess;
			onsuccess = function(e){
				if(e !== null && typeof(e) == 'object'){
					if(autoTriggerDownload && (typeof(e.update_triggered) == 'undefined' || !e.update_triggered) && typeof(e.download_url) == 'string') window.open('_new', e.download_url);
					if(typeof(e.process_error) == 'string') console.log(process_error + ' [E608324474368459]');
				}
				onsuccess_org(e);
			};

			var onerror_org = onerror;
			onerror = function(e){
				if(e !== null && typeof(e) == 'object'){
					if(autoTriggerDownload && (typeof(e.update_triggered) == 'undefined' || !e.update_triggered) && typeof(e.download_url) == 'string') window.open('_new', e.download_url);
					if(typeof(e.process_error) == 'string') console.log(process_error + ' [E608324474368459]');
				}
				onerror_org(e);
			};

			return ClientService.Call('updateclient', {}, onsuccess, onerror);
		}
	};
	ClientService.Init();
}