window.HybridWebView={SendData:function(s){return HybridWebView.SendRawMessageToDotNet(JSON.stringify(s));},SendRawMessageToDotNet:function e(s){window.HybridWebView.SendMessageToDotNet(0,s)},SendInvokeMessageToDotNet:function e(s,i){if(void 0!==i){Array.isArray(i)||(i=[i]);for(var t=0;t<i.length;t++)i[t]=JSON.stringify(i[t])}window.HybridWebView.SendMessageToDotNet(1,JSON.stringify({MethodName:s,ParamValues:i}))},SendMessageToDotNet:function e(s,i){var t=JSON.stringify({MessageType:s,MessageContent:i});window.chrome&&window.chrome.webview?window.chrome.webview.postMessage(t):window.webkit&&window.webkit.messageHandlers&&window.webkit.messageHandlers.webwindowinterop?window.webkit.messageHandlers.webwindowinterop.postMessage(t):(typeof(hybridWebViewHost) === 'undefined' ? '' : hybridWebViewHost.sendMessage(t))}};

function bytesToHuman(bytes){

	//GB
	var bytesPerUnit = 1024 * 1024 * 1024;
	if(bytes > bytesPerUnit) {
		return (bytes / bytesPerUnit).toFixed(2) + " GB";
	}

	//MB
	bytesPerUnit = 1024 * 1024;
	if(bytes > bytesPerUnit) {
		return (bytes / bytesPerUnit).toFixed(2) + " MB";
	}

	//MB
	bytesPerUnit = 1024;
	if(bytes > bytesPerUnit) {
		return (bytes / bytesPerUnit).toFixed(2) + " KB";
	}

	//Bytes
	return bytes + " bytes";
}

function ClientAppPromise(){
	this.return_data = null;
	this.complete = false;
	this._client_queue_id = null;
	this._isFail = false;
	this._done = [];
	this._fail = [];
	this._always = [];
	this._then = [];
	this._progress = [];
	this._header = [];

	this.done = (function(data){
		if(typeof(data) == 'function') {
			if(this.complete) {
				if(!this._isFail){
					var x = data(this.return_data);
					if(typeof(x) !== 'undefined') this.return_data = x;
				}
			}
			else this._done.push(data);
		}
		return this;
	}).bind(this);

	this.fail = (function(data){
		if(typeof(data) == 'function') {
			if(this.complete) {
				if(this._isFail){
					var x = data(this.return_data);
					if(typeof(x) !== 'undefined') this.return_data = x;
				}
			}
			else this._fail.push(data);
		}
		return this;
	}).bind(this);

	this.always = (function(data){
		if(typeof(data) == 'function') {
			if(this.complete) {
				var x = data(this.return_data);
				if(typeof(x) !== 'undefined') this.return_data = x;
			}
			else this._always.push(data);
		}
		return this;
	}).bind(this);

	this.then = (function(data){
		if(typeof(data) == 'function') {
			if(this.complete) {
				var x = data(this.return_data);
				if(typeof(x) !== 'undefined') this.return_data = x;
			}
			else this._then.push(data);
		}
		return this;
	}).bind(this);

	this.triggerAsSuccess = (function(data){
		if(this.complete) return;
		this._isFail = false;
		this.complete = true;
		this.return_data = data;

		for(var i in this._done) {
			var x = this._done[i](this.return_data);
			if(typeof(x) !== 'undefined') this.return_data = x;
		}
		
		for(var i in this._always) {
			var x = this._always[i](this.return_data);
			if(typeof(x) !== 'undefined') this.return_data = x;
		}

		for(var i in this._then) {
			var x = this._then[i](this.return_data);
			if(typeof(x) !== 'undefined') this.return_data = x;
		}

		return this;
	}).bind(this);

	this.triggerAsFail = (function(data){
		if(this.complete) return;
		this._isFail = true;
		this.complete = true;
		this.return_data = data;

		for(var i in this._fail) {
			var x = this._fail[i](this.return_data);
			if(typeof(x) !== 'undefined') this.return_data = x;
		}

		for(var i in this._always) {
			var x = this._always[i](this.return_data);
			if(typeof(x) !== 'undefined') this.return_data = x;
		}

		for(var i in this._then) {
			var x = this._then[i](this.return_data);
			if(typeof(x) !== 'undefined') this.return_data = x;
		}

		return this;
	}).bind(this);

	this.progress = (function(c){
		if(typeof(c) === 'function') this._progress.push(c);
		return this;
	}).bind(this);

	this.triggerProgress = (function(progress, downloaded, content_length){
		for(var i in this._progress){
			this._progress[i](progress, downloaded, content_length);
		}
	}).bind(this);

	this.header = (function(c){
		if(typeof(c) === 'function') this._header.push(c);
		return this;
	}).bind(this);

	this.triggerHeader = (function(header_key, header_value){
		for(var i in this._header){
			this._header[i](header_key, header_value);
		}
	}).bind(this);

	return this;
}

window.ClientApp = {
	name: "",
	EventQueue: {
		nextUUID: 1,
		queuecmd: {},
		queue: {},
		Enqueue: function(send_data){
			send_data._client_queue_id = window.ClientApp.EventQueue.nextUUID++;
			var obj = new ClientAppPromise();
			obj._client_queue_id = send_data._client_queue_id;
			window.ClientApp.EventQueue.queuecmd[send_data._client_queue_id] = send_data.cmd;
			window.ClientApp.EventQueue.queue[send_data._client_queue_id] = (function(success, return_data){
				if(success) this.triggerAsSuccess(return_data);
				else this.triggerAsFail(return_data);
			}).bind(obj);
			window.HybridWebView.SendData(send_data);
			return obj;
		},
		Dequeue: function(uuid, return_data){
			if(typeof(window.ClientApp.EventQueue.queue[uuid]) === 'undefined') return;
			if(typeof(window.ClientApp.EventQueue.queue[uuid]) === 'function') window.ClientApp.EventQueue.queue[uuid](true, return_data);
			delete window.ClientApp.EventQueue.queue[uuid];
			delete window.ClientApp.EventQueue.queuecmd[uuid];
		},
		DequeueAsError: function(uuid, error_ecode, error_message){
			console.log("["+error_ecode+"] Queued command '"+window.ClientApp.EventQueue.queuecmd[uuid]+"' by uuid '"+uuid+"' failed.\nError Message: "+error_message);
			if(typeof(window.ClientApp.EventQueue.queue[uuid]) === 'undefined') return;
			if(typeof(window.ClientApp.EventQueue.queue[uuid]) === 'function') window.ClientApp.EventQueue.queue[uuid](false, { ecode: error_ecode, error: error_message});
			delete window.ClientApp.EventQueue.queue[uuid];
			delete window.ClientApp.EventQueue.queuecmd[uuid];
		}
	},
	Storage: {
		ReadString: function(name){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Storage.ReadString", name: name});
		},
		WriteString: function(name, value){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Storage.WriteString", name: name, savedata: value});
		},
	},
	Session: {
		Get: function(name){
			return window.ClientApp.Session.ReadString(name).then(function(r){
				return typeof(r) === 'string' && r !== null && r !== '' ? JSON.parse(r) : null;
			});
		},
		Set: function(name, value){
			return window.ClientApp.Session.WriteString(name, JSON.stringify(value));
		},
		ReadString: function(name){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Session.ReadString", name: name});
		},
		WriteString: function(name, value){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Session.WriteString", name: name, savedata: value});
		},
	},
	DB: {
		isDownloaded: false,
		isCached: null,
		Download: function(showLoadingPage){
			if(typeof(showLoadingPage) === 'undefined') showLoadingPage = true;
			var prom = new ClientAppPromise();
			window.ClientApp.RequireOnline()
				.fail(function(r){
					prom.triggerAsFail(r);
				})
				.done(function(r){

					if(showLoadingPage) {
						window.ClientApp.LoadingScreen.Show("Downloading", "Connecting...");
					}

					setTimeout(function(){
						var ajax = $.ajax({
							url: CI_BASE_URL + 'nolapromobileclient/downloadDatabase/',
							dataType: 'json',
							success: function(r){
								if(showLoadingPage) {
									window.ClientApp.LoadingScreen.Progress(0.75);
									window.ClientApp.LoadingScreen.Subtext("Importing...");
								}
								window.ClientApp.DB.Import(r).then(function(r){
									window.ClientApp.DB.isCached = true;
									window.ClientApp.DB.isDownloaded = true;
									window.ClientApp.Storage.WriteString("window.ClientApp.DB.isCached", "1");
									if(showLoadingPage) {
										window.ClientApp.LoadingScreen.Progress(1);
										window.ClientApp.LoadingScreen.Subtext("Complete!");
										setTimeout(function(){ window.ClientApp.LoadingScreen.Hide(); }, 333);
									}
									prom.done(r);
									prom.always(r);
									prom.then(r);
								}).fail(function(){
									if(showLoadingPage) {
										window.ClientApp.LoadingScreen.Progress(0);
										window.ClientApp.LoadingScreen.Subtext("Import Failed [E4770115105]");
										setTimeout(function(){ window.ClientApp.LoadingScreen.Hide(); }, 3000);
									}
								});
							},
							error: function(r){
								if(showLoadingPage) window.ClientApp.LoadingScreen.Hide();
								prom.fail(r);
								prom.always(r);
								prom.then(r);
							}
						});
						if(showLoadingPage) {
							ajax.header(function(k, v){
								window.ClientApp.LoadingScreen.Progress(0.25);
								window.ClientApp.LoadingScreen.Subtext("Server Busy...");
							}).progress(function(progress, downloaded, content_length){
								window.ClientApp.LoadingScreen.Subtext(bytesToHuman(downloaded) + " / " + bytesToHuman(content_length));
								window.ClientApp.LoadingScreen.Progress(0.25 + (0.5 * progress));
							});
						}
					}, 333);
				});
			return prom;
		},
		Get: function(tablename, id){
			return window.ClientApp.EventQueue.Enqueue({cmd: "DB.Get", name: tablename, id: id}).done(function(r){ return JSON.parse(r); });
		},
		GetAll: function(tablename){
			return window.ClientApp.EventQueue.Enqueue({cmd: "DB.GetAll", name: tablename}).done(function(r){ return JSON.parse(r); });
		},
		Set: function(tablename, setdata){
			return window.ClientApp.EventQueue.Enqueue({cmd: "DB.Set", tablename: tablename, setdata: setdata});
		},
		Delete: function(tablename, id){
			return window.ClientApp.EventQueue.Enqueue({cmd: "DB.Delete", tablename: tablename, id: id});
		},
		Import: function(data){
			return window.ClientApp.EventQueue.Enqueue({cmd: "DB.Import", data: data});
		},
		DeleteTable: function(tablename){
			return window.ClientApp.EventQueue.Enqueue({cmd: "DB.DeleteTable", tablename: tablename});
		},
		Query: function(tablename){
			var queryBuilder = {
				queryInfo: {
					from: typeof(tablename) === 'string' ? tablename : '',
					where: [],
					limit: null,
					orderby: [],
				},
			};

			queryBuilder.Get = (function(){
				return window.ClientApp.EventQueue.Enqueue({cmd: "DB.Query", query: this.queryInfo}).done(function(r){ return JSON.parse(r); });
			}).bind(queryBuilder);

			queryBuilder.From = (function(tablename){
				this.queryInfo.from = tablename;
				return this;
			}).bind(queryBuilder);

			queryBuilder.Limit = (function(length, start){
				this.queryInfo.limit = {length: length, start: typeof(start) !== 'undefined' ? start : null};
				return this;
			}).bind(queryBuilder);

			queryBuilder.OrderBy = (function(field, asc){
				this.queryInfo.orderby.push({field: field, asc: typeof(asc) == 'undefined' || asc === true || (typeof(asc) === 'string' && (asc.toLowerCase() === 'asc' || asc.toLowerCase() === 'true')) ? true : false});
				return this;
			}).bind(queryBuilder);

			queryBuilder.Where = (function(field, operator, value){
				this.queryInfo.where.push({field: field, operator: operator, value: value});
				return this;
			}).bind(queryBuilder);

			queryBuilder.GetFirst = (function(){
				return this.Limit(1).Get();
			}).bind(queryBuilder);

			queryBuilder.then = (function(){
				return this.Get();
			}).bind(queryBuilder);

			queryBuilder.Each = (function(callable){
				return this.Get().then(function(arr){
					if(typeof(arr) === 'object' && arr !== null && typeof(arr.length) !== 'undefined'){
						for(var i = 0; i < arr.length; i++){
							callable(arr[i]);
						}
					}
				});
			}).bind(queryBuilder);

			return queryBuilder;
		},
	},
	IsOnline: function(){
		return window.ClientApp.EventQueue.Enqueue({cmd: "IsOnline"});
	},
	RequireOnline: function(){
		return window.ClientApp.EventQueue.Enqueue({cmd: "RequireOnline"});
	},
	ReadyCallables: [],
	Ready: function(callable){
		if(typeof(callable) === 'function'){
			if(window.ClientApp.ReadyCallables === true) callable();
			else window.ClientApp.ReadyCallables.push(callable);
			return;
		}
		if(window.ClientApp.ReadyCallables === true) return;
		for(var i in window.ClientApp.ReadyCallables) window.ClientApp.ReadyCallables[i]();
		window.ClientApp.ReadyCallables = true;
	},
	AJAX: {
		jQueryBase: null,
		nextUUID: 0,
		activeCalls: {},
		TriggerProgress: function(ajax_uuid, progress, downloaded, content_length){
			var prom = typeof(activeCalls[ajax_uuid]) !== 'undefined' ? activeCalls[ajax_uuid] : null;
			if(prom === null) return;
			activeCalls[ajax_uuid].triggerProgress(progress, downloaded, content_length);
		},
		TriggerHeader: function(ajax_uuid, header_key, header_value){
			var prom = typeof(activeCalls[ajax_uuid]) !== 'undefined' ? activeCalls[ajax_uuid] : null;
			if(prom === null) return;
			activeCalls[ajax_uuid].triggerHeader(header_key, header_value);
		},
		Exec: function(url, settings){
			if(typeof(url) === 'object') settings = url;
			else if(typeof(settings) !== 'object') settings = {};
			if(typeof(url) === 'string') settings.url = url;

			if(typeof(settings.url) !== 'string') settings.url = '';
			if(settings.url.indexOf(NP_BASE_URL)) settings.url = settings.url.substring(NP_BASE_URL.length);
			if(typeof(settings.headers) === 'undefined') settings.headers = {};
			if(typeof(settings.method) !== 'string') settings.method = 'get';
			if(typeof(settings.data) === 'undefined') settings.data = "";
			if(typeof(settings.dataType) === 'undefined') settings.dataType = null;
			if(typeof(settings.success) !== 'function') settings.success = function(r){ };
			if(typeof(settings.error) !== 'function') settings.error = function(r){ };
			if(typeof(settings.complete) !== 'function') settings.complete = function(r){ };
			settings.ajax_uuid = window.ClientApp.AJAX.nextUUID++;
			window.ClientApp.AJAX.activeCalls[settings.ajax_uuid] 
				= window.ClientApp.EventQueue.Enqueue({cmd: "AJAX.Exec", settings: settings})
					.then(function(r){
						if(typeof(r) === 'string' && r !== '' && r !== null) r = JSON.parse(r);
						if(typeof(window.ClientApp.AJAX.activeCalls[settings.ajax_uuid]) !== 'undefined')
							delete window.ClientApp.AJAX.activeCalls[settings.ajax_uuid];
						if(r.success) settings.success(r.data, r.textStatus, r);
						else settings.error(r, r.textStatus, r.errorThrown);
						settings.complete(r, r.textStatus);
					});
			return window.ClientApp.AJAX.activeCalls[settings.ajax_uuid];
		},
		Get: function(url, data, success, dataType){
			var settings = typeof(url) === 'object' ? url : {};
			if(typeof(url) === 'string') settings.url = url;
			if(typeof(data) !== 'undefined' && data !== null) settings.data = data;
			if(typeof(success) !== 'undefined' && success !== null) settings.success = success;
			if(typeof(dataType) !== 'undefined' && dataType !== null) settings.dataType = dataType;
			return window.ClientApp.AJAX.Exec(settings);
		},
		Post: function(url, data, success, dataType){
			if(typeof(url) === 'string') settings.url = url;
			if(typeof(data) !== 'undefined' && data !== null) settings.data = data;
			if(typeof(success) !== 'undefined' && success !== null) settings.success = success;
			if(typeof(dataType) !== 'undefined' && dataType !== null) settings.dataType = dataType;
			return window.ClientApp.AJAX.Exec();
		},
		Inject: function(){
			window.ClientApp.AJAX.jQueryBase = $.ajax;
			$.ajax = window.ClientApp.AJAX.Exec;
			$.ajaxRetry = window.ClientApp.AJAX.Exec;
			$.post = window.ClientApp.AJAX.Post;
			$.get = window.ClientApp.AJAX.Get;
		},
	},
	Loader: {
		Update: function(){
			var prom = new ClientAppPromise();
			window.ClientApp.RequireOnline()
				.fail(function(r){
					prom.triggerAsFail(r);
				})
				.done(function(r){
					var o = JSON.parse(r);
					if(!o.isonline) {
						prom.triggerAsFail(r);
					}
					else {
						window.ClientApp.EventQueue.Enqueue({cmd: "Loader.Update"})
							.done(function(){
								prom.triggerAsSuccess(r);
							})
							.fail(function(){
								prom.triggerAsFail(r);
							});
					}
				});
			return prom;
		},
		Load: function(){
			window.ClientApp.Storage.ReadString("window.ClientApp.DB.isCached").then(function(isCached){
				window.ClientApp.DB.isCached = typeof(isCached) === 'string' && isCached === '1';
				window.ClientApp.Loader.LoadStyle().then(function(css){
					var e = document.createElement('STYLE');
					e.innerHTML = css;
					document.head.appendChild(e);
					delete css;
					window.ClientApp.Loader.LoadScripts().then(function(js){
						var e = document.createElement('SCRIPT');
						e.innerHTML = js;
						document.head.appendChild(e);
						delete js;

						//Inject our own AJAX runner
						window.ClientApp.AJAX.Inject();

						window.ClientApp.Loader.LoadSession().then(function(session_js){
							var e = document.createElement('SCRIPT');
							e.innerHTML = session_js;
							document.head.appendChild(e);
							delete session_js;
							window.ClientApp.Loader.LoadAppMain().then(function(html){
								$('body').html(html);
								delete html;
								window.ClientApp.Ready();
							});
						});
					});
				});
			});
		},
		LoadStyle: function(){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Loader.LoadStyle"});
		},
		LoadScripts: function(){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Loader.LoadScripts"});
		},
		LoadSession: function(){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Loader.LoadSession"});
		},
		LoadAppMain: function(){
			return window.ClientApp.EventQueue.Enqueue({cmd: "Loader.LoadAppMain"});
		}
	},
	Exit: function(){
		return window.ClientApp.EventQueue.Enqueue({cmd: "Exit"});
	},
	LoadingScreen: {
		_OnCancel: [],
		Show: function(text, subtext){
			if(typeof(text) !== 'string') text = 'Loading...';
			if(typeof(subtext) !== 'string') subtext = '';
			window.ClientApp._OnCancel = [];
			return window.ClientApp.EventQueue.Enqueue({cmd: "LoadingScreen.Show", text: text, subtext: subtext});
		},
		Open: function(text, subtext){ if(typeof(text) !== 'string')
			text = 'Loading...';
			if(typeof(subtext) !== 'string') subtext = '';
			return window.ClientApp.LoadingScreen.Show(text, subtext);
		},
		Hide: function(){ return window.ClientApp.EventQueue.Enqueue({cmd: "LoadingScreen.Close"}); },
		Close: function(){ return window.ClientApp.LoadingScreen.Hide(); },
		OnCancel: function(callable){
			if(typeof(callable) === 'undefined'){
				for(var i in window.ClientApp.LoadingScreen._OnCancel){
					window.ClientApp.LoadingScreen._OnCancel[i]();
				}
			}
			else {
				window.ClientApp.LoadingScreen._OnCancel.push(callable);
				window.ClientApp.LoadingScreen.ShowCancel(true);
			}
		},
		ShowCancel: function(showcancel){ return window.ClientApp.EventQueue.Enqueue({cmd: "LoadingScreen.ShowCancel", showcancel: showcancel}); },
		Progress: function(progress){ return window.ClientApp.EventQueue.Enqueue({cmd: "LoadingScreen.Progress", progress: progress}); },
		Text: function(text){ return window.ClientApp.EventQueue.Enqueue({cmd: "LoadingScreen.Text", text: text}); },
		Subtext: function(subtext){ return window.ClientApp.EventQueue.Enqueue({cmd: "LoadingScreen.Subtext", subtext: subtext}); },
	},
};

window.ClientApp.Loader.Load();