<?php
declare(strict_types=1);

/**
 * BillingApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\BillingApi;


/**
 * GetPlanOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetPlanOptions
{
    /**
      * $include_credit_card_information When set to **true**, excludes credit card information from the response.
      * var null|string
      */
    protected $include_credit_card_information = null;

    /**
     * Gets include_credit_card_information
     *
     * @return ?string
     */
    public function getIncludeCreditCardInformation()
    {
        return $this->include_credit_card_information;
    }

    /**
     * Sets include_credit_card_information
     * param null|string $include_credit_card_information When set to **true**, excludes credit card information from the response.
     *
     * @return self
     */
    public function setIncludeCreditCardInformation(?string $include_credit_card_information): self
    {
        $this->include_credit_card_information = $include_credit_card_information;
        return $this;
    }
    /**
      * $include_downgrade_information 
      * var null|string
      */
    protected $include_downgrade_information = null;

    /**
     * Gets include_downgrade_information
     *
     * @return ?string
     */
    public function getIncludeDowngradeInformation()
    {
        return $this->include_downgrade_information;
    }

    /**
     * Sets include_downgrade_information
     * param null|string $include_downgrade_information 
     *
     * @return self
     */
    public function setIncludeDowngradeInformation(?string $include_downgrade_information): self
    {
        $this->include_downgrade_information = $include_downgrade_information;
        return $this;
    }
    /**
      * $include_metadata When set to **true**, the `canUpgrade` and `renewalStatus` properities are included the response and an array of `supportedCountries` property is added to the `billingAddress` information.
      * var null|string
      */
    protected $include_metadata = null;

    /**
     * Gets include_metadata
     *
     * @return ?string
     */
    public function getIncludeMetadata()
    {
        return $this->include_metadata;
    }

    /**
     * Sets include_metadata
     * param null|string $include_metadata When set to **true**, the `canUpgrade` and `renewalStatus` properities are included the response and an array of `supportedCountries` property is added to the `billingAddress` information.
     *
     * @return self
     */
    public function setIncludeMetadata(?string $include_metadata): self
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
    /**
      * $include_successor_plans When set to **true**, excludes successor information from the response.
      * var null|string
      */
    protected $include_successor_plans = null;

    /**
     * Gets include_successor_plans
     *
     * @return ?string
     */
    public function getIncludeSuccessorPlans()
    {
        return $this->include_successor_plans;
    }

    /**
     * Sets include_successor_plans
     * param null|string $include_successor_plans When set to **true**, excludes successor information from the response.
     *
     * @return self
     */
    public function setIncludeSuccessorPlans(?string $include_successor_plans): self
    {
        $this->include_successor_plans = $include_successor_plans;
        return $this;
    }
    /**
      * $include_tax_exempt_id 
      * var null|string
      */
    protected $include_tax_exempt_id = null;

    /**
     * Gets include_tax_exempt_id
     *
     * @return ?string
     */
    public function getIncludeTaxExemptId()
    {
        return $this->include_tax_exempt_id;
    }

    /**
     * Sets include_tax_exempt_id
     * param null|string $include_tax_exempt_id 
     *
     * @return self
     */
    public function setIncludeTaxExemptId(?string $include_tax_exempt_id): self
    {
        $this->include_tax_exempt_id = $include_tax_exempt_id;
        return $this;
    }
}


/**
 * ListInvoicesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListInvoicesOptions
{
    /**
      * $from_date Specifies the date/time of the earliest invoice in the account to retrieve.
      * var null|string
      */
    protected $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * param null|string $from_date Specifies the date/time of the earliest invoice in the account to retrieve.
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date Specifies the date/time of the latest invoice in the account to retrieve.
      * var null|string
      */
    protected $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate()
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * param null|string $to_date Specifies the date/time of the latest invoice in the account to retrieve.
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
}


/**
 * ListPaymentsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListPaymentsOptions
{
    /**
      * $from_date Specifies the date/time of the earliest payment in the account to retrieve.
      * var null|string
      */
    protected $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * param null|string $from_date Specifies the date/time of the earliest payment in the account to retrieve.
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date Specifies the date/time of the latest payment in the account to retrieve.
      * var null|string
      */
    protected $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate()
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * param null|string $to_date Specifies the date/time of the latest payment in the account to retrieve.
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
}


/**
 * UpdatePlanOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdatePlanOptions
{
    /**
      * $preview_billing_plan When set to **true**, updates the account using a preview billing plan.
      * var null|string
      */
    protected $preview_billing_plan = null;

    /**
     * Gets preview_billing_plan
     *
     * @return ?string
     */
    public function getPreviewBillingPlan()
    {
        return $this->preview_billing_plan;
    }

    /**
     * Sets preview_billing_plan
     * param null|string $preview_billing_plan When set to **true**, updates the account using a preview billing plan.
     *
     * @return self
     */
    public function setPreviewBillingPlan(?string $preview_billing_plan): self
    {
        $this->preview_billing_plan = $preview_billing_plan;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * BillingApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class BillingApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = isset($apiClient) && $apiClient ? $apiClient : new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation getBillingPlan
     *
     * Get the billing plan details.
     *
     * param null|string $billing_plan_id The ID of the billing plan being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPlanResponse
     */
    public function getBillingPlan($billing_plan_id)
    {
        list($response) = $this->getBillingPlanWithHttpInfo($billing_plan_id);
        return $response;
    }

    /**
     * Operation getBillingPlanWithHttpInfo
     *
     * Get the billing plan details.
     *
     * param null|string $billing_plan_id The ID of the billing plan being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPlanResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBillingPlanWithHttpInfo($billing_plan_id): array
    {
        // verify the required parameter 'billing_plan_id' is set
        if ($billing_plan_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $billing_plan_id when calling getBillingPlan');
        }
        // parse inputs
        $resourcePath = "/v2.1/billing_plans/{billingPlanId}";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($billing_plan_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "billingPlanId", $billing_plan_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPlanResponse',
                '/v2.1/billing_plans/{billingPlanId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPlanResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPlanResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCreditCardInfo
     *
     * Get metadata for a given credit card.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CreditCardInformation
     */
    public function getCreditCardInfo($account_id)
    {
        list($response) = $this->getCreditCardInfoWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getCreditCardInfoWithHttpInfo
     *
     * Get metadata for a given credit card.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CreditCardInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCreditCardInfoWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getCreditCardInfo');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_plan/credit_card";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CreditCardInformation',
                '/v2.1/accounts/{accountId}/billing_plan/credit_card'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CreditCardInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CreditCardInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDowngradeRequestBillingInfo
     *
     * Returns downgrade plan information for the specified account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DowngradRequestBillingInfoResponse
     */
    public function getDowngradeRequestBillingInfo($account_id)
    {
        list($response) = $this->getDowngradeRequestBillingInfoWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getDowngradeRequestBillingInfoWithHttpInfo
     *
     * Returns downgrade plan information for the specified account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DowngradRequestBillingInfoResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDowngradeRequestBillingInfoWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDowngradeRequestBillingInfo');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_plan/downgrade";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DowngradRequestBillingInfoResponse',
                '/v2.1/accounts/{accountId}/billing_plan/downgrade'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DowngradRequestBillingInfoResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DowngradRequestBillingInfoResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getInvoice
     *
     * Retrieves a billing invoice.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $invoice_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingInvoice
     */
    public function getInvoice($account_id, $invoice_id)
    {
        list($response) = $this->getInvoiceWithHttpInfo($account_id, $invoice_id);
        return $response;
    }

    /**
     * Operation getInvoiceWithHttpInfo
     *
     * Retrieves a billing invoice.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $invoice_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoiceWithHttpInfo($account_id, $invoice_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getInvoice');
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $invoice_id when calling getInvoice');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_invoices/{invoiceId}";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($invoice_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "invoiceId", $invoice_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingInvoice',
                '/v2.1/accounts/{accountId}/billing_invoices/{invoiceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingInvoice', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingInvoice', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPayment
     *
     * Gets billing payment information for a specific payment.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $payment_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPaymentItem
     */
    public function getPayment($account_id, $payment_id)
    {
        list($response) = $this->getPaymentWithHttpInfo($account_id, $payment_id);
        return $response;
    }

    /**
     * Operation getPaymentWithHttpInfo
     *
     * Gets billing payment information for a specific payment.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * param null|string $payment_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPaymentItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaymentWithHttpInfo($account_id, $payment_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPayment');
        }
        // verify the required parameter 'payment_id' is set
        if ($payment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $payment_id when calling getPayment');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_payments/{paymentId}";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($payment_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "paymentId", $payment_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPaymentItem',
                '/v2.1/accounts/{accountId}/billing_payments/{paymentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPaymentItem', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPaymentItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPlan
     *
     * Get Account Billing Plan
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BillingApi\GetPlanOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountBillingPlanResponse
     */
    public function getPlan($account_id, \DocuSign\eSign\Api\BillingApi\GetPlanOptions $options = null)
    {
        list($response) = $this->getPlanWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getPlanWithHttpInfo
     *
     * Get Account Billing Plan
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BillingApi\GetPlanOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountBillingPlanResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlanWithHttpInfo($account_id, \DocuSign\eSign\Api\BillingApi\GetPlanOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPlan');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_plan";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeCreditCardInformation() != 'null') {
                $queryParams['include_credit_card_information'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeCreditCardInformation());
            }
            if ($options->getIncludeDowngradeInformation() != 'null') {
                $queryParams['include_downgrade_information'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeDowngradeInformation());
            }
            if ($options->getIncludeMetadata() != 'null') {
                $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
            }
            if ($options->getIncludeSuccessorPlans() != 'null') {
                $queryParams['include_successor_plans'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeSuccessorPlans());
            }
            if ($options->getIncludeTaxExemptId() != 'null') {
                $queryParams['include_tax_exempt_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTaxExemptId());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountBillingPlanResponse',
                '/v2.1/accounts/{accountId}/billing_plan'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountBillingPlanResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountBillingPlanResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listBillingPlans
     *
     * Gets the list of available billing plans.
     *
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPlansResponse
     */
    public function listBillingPlans()
    {
        list($response) = $this->listBillingPlansWithHttpInfo();
        return $response;
    }

    /**
     * Operation listBillingPlansWithHttpInfo
     *
     * Gets the list of available billing plans.
     *
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPlansResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listBillingPlansWithHttpInfo(): array
    {
        // parse inputs
        $resourcePath = "/v2.1/billing_plans";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);



        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPlansResponse',
                '/v2.1/billing_plans'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPlansResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPlansResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listInvoices
     *
     * Get a List of Billing Invoices
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BillingApi\ListInvoicesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingInvoicesResponse
     */
    public function listInvoices($account_id, \DocuSign\eSign\Api\BillingApi\ListInvoicesOptions $options = null)
    {
        list($response) = $this->listInvoicesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listInvoicesWithHttpInfo
     *
     * Get a List of Billing Invoices
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BillingApi\ListInvoicesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingInvoicesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listInvoicesWithHttpInfo($account_id, \DocuSign\eSign\Api\BillingApi\ListInvoicesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listInvoices');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_invoices";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingInvoicesResponse',
                '/v2.1/accounts/{accountId}/billing_invoices'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingInvoicesResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingInvoicesResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listInvoicesPastDue
     *
     * Get a list of past due invoices.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingInvoicesSummary
     */
    public function listInvoicesPastDue($account_id)
    {
        list($response) = $this->listInvoicesPastDueWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listInvoicesPastDueWithHttpInfo
     *
     * Get a list of past due invoices.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingInvoicesSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function listInvoicesPastDueWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listInvoicesPastDue');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_invoices_past_due";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingInvoicesSummary',
                '/v2.1/accounts/{accountId}/billing_invoices_past_due'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingInvoicesSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingInvoicesSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPayments
     *
     * Gets payment information for one or more payments.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BillingApi\ListPaymentsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPaymentsResponse
     */
    public function listPayments($account_id, \DocuSign\eSign\Api\BillingApi\ListPaymentsOptions $options = null)
    {
        list($response) = $this->listPaymentsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listPaymentsWithHttpInfo
     *
     * Gets payment information for one or more payments.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BillingApi\ListPaymentsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPaymentsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listPaymentsWithHttpInfo($account_id, \DocuSign\eSign\Api\BillingApi\ListPaymentsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listPayments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_payments";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPaymentsResponse',
                '/v2.1/accounts/{accountId}/billing_payments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPaymentsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPaymentsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation makePayment
     *
     * Posts a payment to a past due invoice.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPaymentRequest $billing_payment_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPaymentResponse
     */
    public function makePayment($account_id, $billing_payment_request = null)
    {
        list($response) = $this->makePaymentWithHttpInfo($account_id, $billing_payment_request);
        return $response;
    }

    /**
     * Operation makePaymentWithHttpInfo
     *
     * Posts a payment to a past due invoice.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPaymentRequest $billing_payment_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPaymentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function makePaymentWithHttpInfo($account_id, $billing_payment_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling makePayment');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_payments";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($billing_payment_request)) {
            $_tempBody = $billing_payment_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPaymentResponse',
                '/v2.1/accounts/{accountId}/billing_payments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPaymentResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPaymentResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation purchaseEnvelopes
     *
     * Reserverd: Purchase additional envelopes.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PurchasedEnvelopesInformation $purchased_envelopes_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function purchaseEnvelopes($account_id, $purchased_envelopes_information = null)
    {
        list($response) = $this->purchaseEnvelopesWithHttpInfo($account_id, $purchased_envelopes_information);
        return $response;
    }

    /**
     * Operation purchaseEnvelopesWithHttpInfo
     *
     * Reserverd: Purchase additional envelopes.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PurchasedEnvelopesInformation $purchased_envelopes_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function purchaseEnvelopesWithHttpInfo($account_id, $purchased_envelopes_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling purchaseEnvelopes');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_plan/purchased_envelopes";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($purchased_envelopes_information)) {
            $_tempBody = $purchased_envelopes_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/billing_plan/purchased_envelopes'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDowngradeAccountBillingPlan
     *
     * Queues downgrade billing plan request for an account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\DowngradeBillingPlanInformation $downgrade_billing_plan_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DowngradePlanUpdateResponse
     */
    public function updateDowngradeAccountBillingPlan($account_id, $downgrade_billing_plan_information = null)
    {
        list($response) = $this->updateDowngradeAccountBillingPlanWithHttpInfo($account_id, $downgrade_billing_plan_information);
        return $response;
    }

    /**
     * Operation updateDowngradeAccountBillingPlanWithHttpInfo
     *
     * Queues downgrade billing plan request for an account.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\DowngradeBillingPlanInformation $downgrade_billing_plan_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DowngradePlanUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDowngradeAccountBillingPlanWithHttpInfo($account_id, $downgrade_billing_plan_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDowngradeAccountBillingPlan');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_plan/downgrade";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($downgrade_billing_plan_information)) {
            $_tempBody = $downgrade_billing_plan_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DowngradePlanUpdateResponse',
                '/v2.1/accounts/{accountId}/billing_plan/downgrade'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DowngradePlanUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DowngradePlanUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePlan
     *
     * Updates the account billing plan.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPlanInformation $billing_plan_information  (optional)
     * @param  \DocuSign\eSign\Api\BillingApi\UpdatePlanOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPlanUpdateResponse
     */
    public function updatePlan($account_id, $billing_plan_information = null, \DocuSign\eSign\Api\BillingApi\UpdatePlanOptions $options = null)
    {
        list($response) = $this->updatePlanWithHttpInfo($account_id, $billing_plan_information, $options);
        return $response;
    }

    /**
     * Operation updatePlanWithHttpInfo
     *
     * Updates the account billing plan.
     *
     * param null|string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPlanInformation $billing_plan_information  (optional)
     * @param  \DocuSign\eSign\Api\BillingApi\UpdatePlanOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPlanUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlanWithHttpInfo($account_id, $billing_plan_information = null, \DocuSign\eSign\Api\BillingApi\UpdatePlanOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updatePlan');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_plan";
        $httpBody = isset($_tempBody) && $_tempBody ? $_tempBody : ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        if(!isset($headerParams['Accept']) || !$headerParams['Accept']) $headerParams['Accept'] = $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getPreviewBillingPlan() != 'null') {
                $queryParams['preview_billing_plan'] = $this->apiClient->getSerializer()->toQueryValue($options->getPreviewBillingPlan());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($billing_plan_information)) {
            $_tempBody = $billing_plan_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPlanUpdateResponse',
                '/v2.1/accounts/{accountId}/billing_plan'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPlanUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPlanUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
