<?php


require_once(__DIR__ . '/Client.php');
require_once(__DIR__ . '/Service.php');
require_once(__DIR__ . '/Service/Resource.php');
require_once(__DIR__ . '/Model.php');
require_once(__DIR__ . '/Collection.php');
require_once(__DIR__ . '/Exception.php');
require_once(__DIR__ . '/UriTemplate.php');
require_once(__DIR__ . '/../psr7/functions.php');
require_once(__DIR__ . '/../guzzle/Promise/functions_include.php');
$servicesClassMap = [
	'Google\\Client' => 'Google_Client',
	'Google\\Service' => 'Google_Service',
	'Google\\Service\\Resource' => 'Google_Service_Resource',
	'Google\\Model' => 'Google_Model',
	'Google\\Collection' => 'Google_Collection',
];
foreach ($servicesClassMap as $alias => $class) {
	class_alias($class, $alias);
}

spl_autoload_register(function ($class_name) {	
	

	//Google Logging
	if($class_name === "Google\\Noglog"){
		$filename = __DIR__.DIRECTORY_SEPARATOR.'Noglog.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Google_Service_Exception
	else if($class_name === "Google_Service_Exception"){
		$filename = __DIR__.DIRECTORY_SEPARATOR.'Service'.DIRECTORY_SEPARATOR.'Exception.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Guzzle Auth Handler
	else if($class_name === "Google_AuthHandler_Guzzle7AuthHandler"){
		$filename = __DIR__.DIRECTORY_SEPARATOR.'AuthHandler'.DIRECTORY_SEPARATOR.'Guzzle7AuthHandler.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Google Auth Factory
	else if($class_name === "Google_AuthHandler_AuthHandlerFactory"){
		$filename = __DIR__.DIRECTORY_SEPARATOR.'AuthHandler'.DIRECTORY_SEPARATOR.'AuthHandlerFactory.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Google Http
	else if(strpos($class_name, "Google_Http_") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'google'.DIRECTORY_SEPARATOR.'Http'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 12)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Google Auth Credentials
	else if(strpos($class_name, "Google\\Auth\\Credentials\\") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'google'.DIRECTORY_SEPARATOR.'Auth'.DIRECTORY_SEPARATOR.'Credentials'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 24)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Google Auth Http
	else if(strpos($class_name, "Google\\Auth\\HttpHandler\\") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'google'.DIRECTORY_SEPARATOR.'Auth'.DIRECTORY_SEPARATOR.'HttpHandler'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 24)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}
	//Google Auth
	else if(strpos($class_name, "Google\\Auth\\") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'google'.DIRECTORY_SEPARATOR.'Auth'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 12)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Google Task
	else if(strpos($class_name, "Google_Task_") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'google'.DIRECTORY_SEPARATOR.'Task'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 12)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Psr http-message
	else if(strpos($class_name, "Psr\\Http\\Message\\") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'http-message'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 17)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Psr http-client
	else if(strpos($class_name, "Psr\\Http\\Client\\") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'http-client'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 16)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//GPsr7
	else if(strpos($class_name, "GuzzleHttp\\Psr7\\") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'psr7'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 16)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Guzzle HTTP
	else if(strpos($class_name, "GuzzleHttp\\") === 0){
		$filename = CI_BASE_DIR.'application'.DIRECTORY_SEPARATOR.'third_party'.DIRECTORY_SEPARATOR.'guzzle'.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 11)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

	//Google Service
	else if(strpos($class_name, 'Google\\Service\\') === 0){
		$filename = __DIR__.DIRECTORY_SEPARATOR.str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, 15)).'.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}

});