<?php

namespace GuzzleHttp\Handler;

use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use GuzzleHttp\Psr7\Response;

/**
 * HTTP handler that uses cURL easy handles as a transport layer.
 *
 * When using the CurlObjectHandler, custom curl options can be specified as an
 * associative array of curl option constants mapping to values in the
 * **curl** key of the "client" key of the request.
 */
class CurlObjectHandler
{
    /**
     * @var CurlFactoryInterface
     */
    private $options;

    public function __construct(array $options = []){
        $this->options = $options;
    }

    public function __invoke(RequestInterface $request, array $options){
        if (isset($options['delay'])) {
			if(function_exists('\msleep')) \msleep($options['delay'] * 1000); else \usleep($options['delay'] * 1000);
        }

		//Start New Curl Object
		$curl = new \curlObject($request->getUri()->__toString());
		
		//Upload (Post & Put)
		switch($request->getMethod()){
			case 'POST':
				$curl->Post($request->getBody()->__toString());
				break;
			case 'PUT':
				$tmpFile = get_temp_filename('curl-put', 'bin');
				file_put_contents($tmpFile, $request->getBody()->__toString());
				$curl->Put($tmpFile);
				break;
		}

		//Set Headers
		$headers = $request->getHeaders();
		foreach($headers as $k => $v) foreach($v as $_v) $curl->Header($k, $_v);

		//Exec
		$rsp = $curl->GetResponse();

		//Get the http version
		$startLine = array_keys($rsp->headers);
		$startLine = @$startLine[0];
		$startLine = explode(' ', $startLine);
		$startLine = explode('/', $startLine[0]);
		$http_version = @$startLine[1];

		// HTTP-version SP status-code SP reason-phrase
		$rsp_headers = $rsp->headers;
		$unsetList = [];
		foreach($rsp_headers as $h => $_) if(preg_match('/^HTTP\//i', $h)) $unsetList[] = $h;
		foreach($unsetList as $h) unset($rsp_headers[$h]);
		$normalizedKeys = [];
		foreach($rsp_headers as $k => $v) $normalizedKeys[strtolower($k)] = $v;

		if (!empty($this->options['decode_content']) && isset($normalizedKeys['content-encoding'])) {
			$rsp_headers['x-encoded-content-encoding'] = $rsp_headers[$normalizedKeys['content-encoding']];
			unset($rsp_headers[$normalizedKeys['content-encoding']]);
			if (isset($normalizedKeys['content-length'])) {
				$rsp_headers['x-encoded-content-length'] = $rsp_headers[$normalizedKeys['content-length']];
				$bodyLength = strlen($rsp->text);
				if ($bodyLength) {
					$rsp_headers[$normalizedKeys['content-length']] = $bodyLength;
				} else {
					unset($rsp_headers[$normalizedKeys['content-length']]);
				}
			}
		}

		require_once(NP_BASE_DIR.'!/application/third_party/psr7/functions.php');

		$gresponse = new Response(
            $rsp->httpcode,
            $rsp_headers,
            \GuzzleHttp\Psr7\stream_for($rsp->text, $options),
            $http_version
        );

        return new \GuzzleHttp\Promise\FulfilledPromise($gresponse);
    }
}
