window.resizeControlsToViewSize_LastW = 0;
window.resizeControlsToViewSize_LastH = 0;
function resizeControlsToViewSize(){
	//Get View Size
	var viewW = $(window).width();
	var viewH = $(window).height();
	//Skip if size not changed
	if(window.resizeControlsToViewSize_LastH == viewH && window.resizeControlsToViewSize_LastW == viewW) return;
	window.resizeControlsToViewSize_LastH = viewH;
	window.resizeControlsToViewSize_LastW = viewW;
	//Lookup Container
	var container = $('.pos_layout_template');
	var tmplW = container[0]._initOffsetWidth;
	var tmplH = container[0]._initOffsetHeight;
	var scaleW = viewW / tmplW;
	var scaleH = viewH / tmplH;
	//Set Container to full page
	container.css({'width': viewW + 'px', 'height': viewH + 'px'});
	//Scale each control
	$('.pos_layout_template > .pos_control').each(function(){
		$(this).css({
			'width': (this._initOffsetWidth * scaleW)+'px',
			'height': (this._initOffsetHeight * scaleH)+'px',
			'top': (this._initOffsetTop * scaleH)+'px',
			'left': (this._initOffsetLeft * scaleW)+'px',
		});
		invalidateControlLayout(this);
	});
}

//Init
$(document).ready(function(){
	//Store Inital Position/Size info
	var container = $('.pos_layout_template');
	container[0]._initOffsetWidth = container[0].offsetWidth;
	container[0]._initOffsetHeight = container[0].offsetHeight;
	$('.pos_layout_template > .pos_control').each(function(){
		this._initOffsetTop = this.offsetTop;
		this._initOffsetLeft = this.offsetLeft;
		this._initOffsetHeight = this.offsetHeight;
		this._initOffsetWidth = this.offsetWidth;
	});
	//Resize Event
	UI.resize(resizeControlsToViewSize);
	//Init 1st Resize
	setTimeout(resizeControlsToViewSize, 1);
});