

window.itemoptiongroup = function(params){
	//Set Params From Constructor
	if(typeof(params) == 'object' && params !== null) for(var i in params) this[i] = params[i];
	//Set Default Values
	if(typeof(this.id) == 'undefined') this.id = null;
	if(typeof(this.name) == 'undefined') this.name = null;
	if(typeof(this.description) == 'undefined') this.description = null;
	if(typeof(this.optiontype) == 'undefined') this.optiontype = null;
	if(typeof(this.allowblank) == 'undefined') this.allowblank = null;
	if(typeof(this.default) == 'undefined') this.default = null;
	if(typeof(this.invoiceprintmode) == 'undefined') this.invoiceprintmode = null;
	if(typeof(this.invoiceprinthidezerototals) == 'undefined') this.invoiceprinthidezerototals = null;
	if(typeof(this.itemoptions) == 'undefined') this.itemoptions = [];
	//Functions
	this.title = function(){
		return this.name;
	};
	this.addItemOption = function(itemoption){
		this.itemoptions.push(itemoption);
	};
	this.renderInputControls = function(){
		switch(this.optiontype){
			default:
			case 'text': return this.renderInputControlsAsText();
			case 'checkbox': return this.renderInputControlsAsCheckbox();
			case 'select': return this.renderInputControlsAsSelect();
			case 'radio': return this.renderInputControlsAsRadio();
		}
	};
	this.renderInputControlsAsCheckbox = function(){
		var inputs = [];
		for(var i in this.itemoptions) inputs.push(this.itemoptions[i].render('checkbox'));
		return inputs;
	};
	this.renderInputControlsAsRadio = function(){
		var inputs = [];
		for(var i in this.itemoptions) inputs.push(this.itemoptions[i].render('radio'));
		return inputs;
	};
	this.renderInputControlsAsSelect = function(){
		var inputs = [];
		var select = $('<select onchange="lineitemEditControl_Change(event, this);" name="save_model[edit][lineitem][itemoption]['+this.id+']">');
		for(var i in this.itemoptions) select.append(this.itemoptions[i].render('select'));
		inputs.push(select);
		return inputs;
	};
	this.renderInputControlsAsText = function(){
		var inputs = [];
		for(var i in this.itemoptions) inputs.push(this.itemoptions[i].render('text'));
		return inputs;
	};

	//Return 'class' object
	return this;
};

window.itemoption = function(params){
	//Set Params From Constructor
	if(typeof(params) == 'object' && params !== null) for(var i in params) this[i] = params[i];
	//Set Default Values
	if(typeof(this.id) == 'undefined') this.id = null;
	if(typeof(this.itemoptiongroupid) == 'undefined') this.itemoptiongroupid = null;
	if(typeof(this.itemid) == 'undefined') this.itemid = null;
	if(typeof(this.optioncode) == 'undefined') this.optioncode = null;
	if(typeof(this.price) == 'undefined') this.price = null;
	if(typeof(this.cost) == 'undefined') this.cost = null;
	if(typeof(this.minqty) == 'undefined') this.minqty = null;
	if(typeof(this.maxqty) == 'undefined') this.maxqty = null;
	if(typeof(this.mainind) == 'undefined') this.mainind = null;
	if(typeof(this.rounding) == 'undefined') this.rounding = null;
	if(typeof(this.name) == 'undefined') this.name = null;
	if(typeof(this.description) == 'undefined') this.description = null;
	if(typeof(this.priceunitnameid) == 'undefined') this.priceunitnameid = null;
	if(typeof(this.priceunitnasalesunitnameidmeid) == 'undefined') this.salesunitnameid = null;
	if(typeof(this.saleunitperpriceunit) == 'undefined') this.saleunitperpriceunit = null;
	if(typeof(this.lbsperpriceunit) == 'undefined') this.lbsperpriceunit = null;
	if(typeof(this.defaultvalue) == 'undefined') this.defaultvalue = null;
	if(typeof(this.defaultoption) == 'undefined') this.defaultoption = null;
	if(typeof(this.displayorder) == 'undefined') this.displayorder = null;
	if(typeof(this.taxable) == 'undefined') this.taxable = null;
	if(typeof(this.salesglaccountid) == 'undefined') this.salesglaccountid = null;
	//
	this.render = function(type){
		if(typeof(STR_NONTAXABLE) == 'undefined') STR_NONTAXABLE = 'Nontaxable';
		if(type == 'select'){
			var title = this.name + (this.optioncode ? ' ('+this.optioncode+')' : '');
			title += ' +'+curvaljs(this.price, curr, 'pd', true);
			return $('<option item-id="'+this.itemid+'">').attr('value', this.id).text(title);
		}
		var name = 'save_model[edit][lineitem][itemoption]['+this.itemoptiongroupid+']' + (type == 'text' || type == 'checkbox' ? '['+this.id+']' : '');
		var label = $('<label for="'+(name+'['+this.id+']')+'">').text(this.name + (this.optioncode ? ' ('+this.optioncode+')' : ''));
		var input = type == 'text' ? $('<textarea onchange="lineitemEditControl_Change(event, this);">') : $('<input onchange="lineitemEditControl_Change(event, this);" type="'+type+'" value="'+this.id+'">');
		input.attr('name', name).attr('id', name+'['+this.id+']');
		var curr = typeof(window.pos_currency) != 'undefined' ? window.pos_currency : null;
		var overlay = (type == 'radio' || type == 'checkbox') ? $('<span class="'+type+'Overlay"></span>') : '';
		var container = type == 'text' ? $('<div>').append([label, input]) : $('<div>').append([input, overlay, label]);
		if(this.taxable === 0 || this.taxable === '0' || this.taxable === false) container.append($('<span class="itemoptionnontaxable">').text(' ('+STR_NONTAXABLE+')'));
		if(this.description) container.append($('<span class="itemoptiondescription">').text(this.description));
		return container;
	};
	//Return 'class' object
	return this;
};

window.itemoptiongroupitem = function(params){
	//Set Params From Constructor
	if(typeof(params) == 'object' && params !== null) for(var i in params) this[i] = params[i];
	//Set Default Values
	if(typeof(this.id) == 'undefined') this.id = null;
	if(typeof(this.itemoptiongroupid) == 'undefined') this.itemoptiongroupid = null;
	if(typeof(this.itemid) == 'undefined') this.itemid = null;
	if(typeof(this.sortorder) == 'undefined') this.sortorder = null;
	//Return 'class' object
	return this;
};