window.pos_admin_template_mode = true;
window.selectedAdminControls = null;
window.templateAdminPrevewScale = 1;
window.lastControlMouseEvent = null;
window.rightMouseDown = false;
window.isControlDraggingActive = false;
window.lastClickedElement = false;
window.isDragResizeActive = false;
window.dragResizeStartX = 0;
window.dragResizeStartY = 0;
window.dragResizeInitWidth = 0;
window.dragResizeInitHeight = 0;

/******** TASKBAR Events *********/
function btnSaveTemplate_Click(sender, e, onsuccess, onerror){
	if(typeof(onsuccess) != 'function') onsuccess = function(){};
	if(typeof(onerror) != 'function') onerror = function(){};
	//Set admin control focus
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;

	//Show As Loading
	var img = $(sender).is('img') || $(sender).is('input[type="image"]') ? $(sender) : $(sender).find('img, input[type="image"]');
	if(typeof(img[0].srcOrg) == 'undefined') img[0].srcOrg = img.attr('src');
	img.attr('src', 'images/loading.gif');

	//Send Save Request
	$.ajaxRetry({
		url: CI_BASE_URL + 'pos/pointofsaleadmin/layoutTemplate_Save',
		PostCompress: true,
		method: 'POST',
		data: getPosTemplateSaveData(),
		success: function(json){
			if(typeof(json.error) != 'undefined') alert(json.error);
			if(typeof(json.id) != 'undefined'){
				$('#template_id').val(json.id)
				img.attr('src', 'images/save.png');
				onsuccess();
			}
			else {
				img.attr('src', 'images/caution.png');
				onerror();
			}
		},
		error: function(){
			img.attr('src', 'images/caution.png');
			onerror();
		}
	});
}
function btnAddNewTemplate_Click(sender, e){
	//Set admin control focus
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;
	//Redirect
	UI.loadPost(CI_BASE_URL+"pos/pointofsaleadmin/layoutTemplate", {id: -1});
}
function btnDeleteTemplate_Click(sender, e){
	//Set admin control focus
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;
	//Confirm
	if(typeof(window.STR_ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS) == 'undefined') window.STR_ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS = 'Are you sure?';
	if(confirm(window.STR_ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS)){
		//Redirect
		UI.loadPost(CI_BASE_URL+"pos/pointofsaleadmin/layoutTemplate", {delete_id: $('#template_id').val()});
	}
}
function btnExportTemplate_Click(sender, e){
	//Set admin control focus
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;

	//Show As Loading
	var img = $(sender).is('img') || $(sender).is('input[type="image"]') ? $(sender) : $(sender).find('img, input[type="image"]');
	if(typeof(img[0].srcOrg) == 'undefined') img[0].srcOrg = img.attr('src');
	img.attr('src', 'images/loading.gif');

	//Send Save Request
	$.ajaxRetry({
		url: CI_BASE_URL + 'pos/pointofsaleadmin/layoutTemplate_Export',
		PostCompress: true,
		method: 'POST',
		data: getPosTemplateSaveData(),
		success: function(json){
			if(typeof(json.error) != 'undefined') alert(json.error);
			if(typeof(json.id) != 'undefined'){
				$('#template_id').val(json.id)
				img.attr('src', 'images/export.png');
				if(typeof(json.export_file) != 'undefined' && typeof(json.export_file_name) != 'undefined'){

					//Trigger JS Download
					var downloadFile = (function () {
						var a = document.createElement("a");
						a.style = "display: none";
						document.body.appendChild(a);
						return function (json, fileName) {
							var blob = new Blob([json], {type: "octet/stream"});
							a.href = window.URL.createObjectURL(blob);
							a.download = fileName;
							a.click();
							window.URL.revokeObjectURL(a.href);
							a.remove();
						};
					}());
					downloadFile(json.export_file, json.export_file_name);
				}
			}
			else {
				img.attr('src', 'images/caution.png');
			}
		},
		error: function(){
			img.attr('src', 'images/caution.png');
		}
	});

}
function btnImportTemplate_Click(sender, e){
	showImportDialog();
}
function btnCloneTemplate_Click(sender, e){
	btnSaveTemplate_Click(sender, e, function(){
		showCloneDialog($('#template_id').val());
	});
}

/******** PREVIEW Control Events *********/
function btnLayoutTmplAdminReal_click(sender, e){
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;
	window.templateAdminPrevewScale = 1;
	refreshZoom();
	return false;
}
function btnLayoutTmplAdminFit_click(sender, e){
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;
	//window.templateAdminPrevewScale
	var pad = 64;
	var pad2 = pad * 2;
	var view = $('#layout_template_admin_container_left');
	var view_w = view.width() - pad;
	var view_h = view.height() - pad;
	var page = $('#layout_template_preview_page');
	var page_w = page.width();
	var page_h = page.height();

	window.templateAdminPrevewScale = 1;
	if(page_w + pad2 > view_w || page_h + pad2 > view_h){
		window.templateAdminPrevewScale = Math.min(view_w / (page_w + pad2), view_h / (page_h + pad2));
	}
	refreshZoom();
	view[0].scrollTop = view[0].scrollTopMax / 2;
	view[0].scrollLeft = view[0].scrollLeftMax / 2;
	return false;
}
function btnLayoutTmplAdminZoomIn_click(sender, e){
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;
	if(window.templateAdminPrevewScale < 0.9) window.templateAdminPrevewScale += 0.1;
	refreshZoom();
	return false;
}
function btnLayoutTmplAdminZommOut_click(sender, e){
	window.lastClickedElement = sender;
	window.activeElement = sender;
	window.lastControlMouseEvent = e;
	if(window.templateAdminPrevewScale > 0.5) window.templateAdminPrevewScale -= 0.1;
	refreshZoom();
	return false;
}

/******** PREVIEW Helpers *********/
function getPosTemplateSaveData(){
	//Template Setup
	var data = $('#layout_template_control_panel_setup > form').serialize();
	data += "&id="+escape($('#template_id').val());

	//Add Controls
	var i = 0;
	$('#layout_template_preview_page > .pos_control').each(function(){
		for(var a = this.attributes.length - 1; a >= 0; a--) data += "&controls["+i+"]["+this.attributes[a].name+"]="+escape(this.attributes[a].value);
		i++;
	});

	//Done
	return data;
}
function refreshZoom(){
	$('#layout_template_preview_page').css('transform', 'scale('+window.templateAdminPrevewScale+')');
}
function updateTemplateSize(){
	var w = $('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][width]"]').val();
	var h = $('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][height]"]').val();
	$('#layout_template_preview_page').css({'width': w+'px', 'height': h+'px'});
}
function updatePointOfSaleTheme(){
	var link = $('#pos_themecsslink');
	var theme = $('select[name="save_model[pointofsalelayouttemplate_model][no_id_defined][theme]"]').val();
	if(typeof(theme) == 'undefined' || theme == '') theme = 'classic';
	$('#pos_themecsslink')
		.one('load', function(){
			//Relayout the whole page
			UI.resize();
			resizeAdminLayout();
			$('.pos_control').each(function(){
				invalidateControlLayout(this);
			});
		})
		.attr('href', NP_BASE_URL+LOCAL_CSS_URL+'index.php?r=!/views/pos/themes/'+theme+'.css?salt='+Math.random());
}
function updateSnapBackgroundSize(){
	var val = $('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][snap]"]').val();
	var page = $('#layout_template_preview_page');
	page.css('background-image', 'radial-gradient(#CCC 1px, transparent 0)');
	page.css('background-size', val+'px '+val+'px');
	page.css('background-position', '-'+(val / 2)+'px -'+(val / 2)+'px');
}
function resizeAdminLayout(){
	var elm = $('#layout_template_admin_container');
	elm.css('height', ($(window).height() - elm.offset().top)+'px');
}
function addControl(window_x, window_y, control_elm, prepend){
	if(window_x !== null && window_x !== false){
		//Skip drop of out of bounds elms
		var container = $('#layout_template_admin_container_left');
		var container_w = container.width();
		var container_h = container.height();
		var container_offset = container.offset();
		var container_x = container_offset.left;
		var container_y = container_offset.top;

		//Out Of Bounds (delete)
		if(window_x < container_x || window_y < container_y || window_y > container_y + container_h || window_x > container_x + container_w){
			control_elm.remove();
			return;
		}

		//Offset centered/zoomed control
		var tmplAdminContainerElm = $('#layout_template_admin_container')[0];
		var isNewControl = $(control_elm[0]).is('.preview_page_control') == false;
		window_x -= control_elm[0]._hw - (tmplAdminContainerElm.offsetLeft - 1);
		window_y -= control_elm[0]._hh - (tmplAdminContainerElm.offsetTop - 1);

		//Convert Window X/Y to preview page's X/y
		var pos = windowXYtoPreviewPageXY(window_x, window_y);

		//Not On Page
		if(pos == null){
			control_elm.remove();
			return;
		}

		//Set Location
		if(window.snapSize > 1){
			pos.x = Math.floor(pos.x / window.snapSize) * window.snapSize;
			pos.y = Math.floor(pos.y / window.snapSize) * window.snapSize;
		}
		control_elm.css({'left': pos.x+'px', 'top': pos.y+'px'}).addClass('preview_page_control');
	}

	//Init Drag Control
	var dragElm = $('<div class="control_drag_handle"><i class="fas fa-arrows-alt"></i></div>');
	control_elm.find('.control_drag_handle').remove();
	control_elm.append(dragElm);
	bindControlDraggingEvent(dragElm, '.pos_template_control');

	//Init Resizeable Control
	var resizeElm = $('<div class="control_resize_handle">');
	control_elm.find('.control_resize_handle').remove();
	control_elm.append(resizeElm);
	bindControlResizeEvent(resizeElm);

	//Bind Edit Params Events
	bindControlEditEvents(control_elm);

	//Append To Preview Page
	if(typeof(prepend) == 'undefined' || !prepend) $('#layout_template_preview_page').append(control_elm);
	else $('#layout_template_preview_page').prepend(control_elm);
	refreshControlLocationSizeJsonString(control_elm);
}
function windowXYtoPreviewPageXY(window_x, window_y){
	var x = window_x;
	var y = window_y;
	var container = $('#layout_template_admin_container_left');
	var container_w = container.width();
	var container_h = container.height();
	var container_offset = container.offset();
	var container_x = container_offset.left;
	var container_y = container_offset.top;
	var container_scroll_x = container[0].scrollLeft;
	var container_scroll_y = container[0].scrollTop;
	var page = $('#layout_template_preview_page');
	var page_w = page.width();
	var page_h = page.height();
	var page_offset = page.offset();
	var page_x = page_offset.left;
	var page_y = page_offset.top;

	//Calc: Relative to container's location
	x -= container_x;
	y -= container_y;
	
	//Calc: Relative to page's location withing the container
	x -= page_x;
	y -= page_y;

	//Calc: Zoom
	x /= window.templateAdminPrevewScale;
	y /= window.templateAdminPrevewScale;

	//Done
	return {x: x, y: y};
}
function previewPageXYtoWindowXY(page_x, page_y){
	var x = page_x;
	var y = page_y;
	var container = $('#layout_template_admin_container_left');
	var container_w = container.width();
	var container_h = container.height();
	var container_offset = container.offset();
	var container_x = container_offset.left;
	var container_y = container_offset.top;
	var container_scroll_x = container[0].scrollLeft;
	var container_scroll_y = container[0].scrollTop;
	var page = $('#layout_template_preview_page');
	var page_w = page.width();
	var page_h = page.height();
	var page_offset = page.offset();
	var _page_x = page_offset.left;
	var _page_y = page_offset.top;

	//Calc: Relative to container's location
	x += container_x;
	y += container_y;
	
	//Calc: Relative to page's location withing the container
	x += _page_x;
	y += _page_y;

	//Calc: Zoom
	x *= window.templateAdminPrevewScale;
	y *= window.templateAdminPrevewScale;

	//Done
	return {x: x, y: y};
}
function bindControlResizeEvent(jqElm){
	jqElm.mousedown(function(e){
		//Right click only
		if(e.which != 1 /*Right Button*/) return;
		if(window.isDragResizeActive) return;
		window.rightMouseDown = true;
		window.lastClickedElement = this;
		window.activeElement = this;
		var parent = this.parentNode ? this.parentNode : this;
		//Unselect Any Others
		if(window.selectedAdminControls === null || $(parent).closest('#layout_template_admin_accordian').length !== 0 || !e.shiftKey){
			if($(this.parentNode).is('.control_selected') == false){
				unselectAllControls(e);
			}
		}
		//Mark as Selected
		$(parent).addClass('control_selected');
		bringControlToFront(parent);
		if(window.selectedAdminControls == null) window.selectedAdminControls = $('').filter();
		window.selectedAdminControls = window.selectedAdminControls.add(parent);
		//Flag as resize Active
		window.isDragResizeActive = true;
		window.dragResizeStartX = e.screenX;
		window.dragResizeStartY = e.screenY;
		window.dragResizeInitWidth = $(parent).width();
		window.dragResizeInitHeight = $(parent).closest('.pos_template_control').height();
		//Disable View/Control Dragging
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
	});
}
function bindControlDraggingEvent(jqElm, parrentSelector){
	if(typeof(parrentSelector) == 'undefined') parrentSelector = null;
	if(parrentSelector){
		jqElm.each(function(){
			var parent = $(this).closest(parrentSelector)[0];
			if(typeof(parent) == 'undefined') return;
			$(parent).find('.pos_template_control_overlay').mouseup(function(e){
				//Right Click
				if(e.which == 3){
					
				}
				//Left Click
				else if(e.which == 1){
					//Unselect Any Others
					if(window.selectedAdminControls === null || $(parent).closest('#layout_template_admin_accordian').length !== 0 || !e.shiftKey){
						if($(parent).is('.control_selected') == false){
							unselectAllControls(e);
						}
					}
					//Select This Control
					$(parent).addClass('control_selected');
					bringControlToFront(parent);
					if(window.selectedAdminControls == null) window.selectedAdminControls = $('').filter();
					window.selectedAdminControls = window.selectedAdminControls.add(parent);
				}
			});
		});
	}
	jqElm.mousedown(function(e){
		if(window.isDragResizeActive) return;
		if(e.which != 1 /*Right Button*/) return;
		var parent = parrentSelector ? $(this).closest(parrentSelector)[0] : null;
		if(typeof(parent) == 'undefined' || !parent) parent = this;
		window.rightMouseDown = true;
		window.lastClickedElement = parent;
		window.activeElement = parent;
		var isNewControl = $(parent).is('.preview_page_control') == false;
		//Clone element if is new
		if(isNewControl){
			unselectAllControls(e);
			$(parent).addClass('control_selected');
			window.selectedAdminControls = $(parent).clone().width($(parent).width()).height($(parent).height());
			window.selectedAdminControls[0]._hw = window.selectedAdminControls.width() / 2;
			window.selectedAdminControls[0]._hh = window.selectedAdminControls.height() / 2;
		}
		else {
			//Unselect Any Others
			if(window.selectedAdminControls === null || $(parent).closest('#layout_template_admin_accordian').length !== 0 || !e.shiftKey){
				if($(parent).is('.control_selected') == false){
					unselectAllControls(e);
				}
			}
			//Update Other Selected Controls mouse-offset
			var relOffset = $(parent).offset();
			if(window.selectedAdminControls !== null){
				window.selectedAdminControls.each(function(){
					var offset = $(parent).offset();
					parent._hw = relOffset.left - offset.left + (e.offsetX * window.templateAdminPrevewScale);
					parent._hh = relOffset.top - offset.top + (e.offsetY * window.templateAdminPrevewScale);
				});
			}
			else {
				window.selectedAdminControls = $('').filter();
			}
			//Flag As Selected
			$(parent).addClass('control_selected');
			bringControlToFront(parent);
			parent._hw = e.offsetX * window.templateAdminPrevewScale;
			parent._hh = e.offsetY * window.templateAdminPrevewScale;
			//Append this to the list of selected elements
			if(window.selectedAdminControls == null) window.selectedAdminControls = $('').filter();
			window.selectedAdminControls = window.selectedAdminControls.add(parent);
		}
		//Update dragging position
		window.lastControlMouseEvent = e;
		window.isControlDraggingActive = false;
		updateDraggingControlLocation(e);
		//Disable View Dragging
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
	});
}
function unselectAllControls(e){
	if(!e.shiftKey || window.selectedAdminControls === null){
		if(window.selectedAdminControls !== null) window.selectedAdminControls.removeClass('control_selected');
		$('.preview_page_control.control_selected').removeClass('control_selected');
		window.selectedAdminControls = $('').filter();
		$('#control_config_diag').dialog('close').remove();
	}
}
function updateDraggingControlLocation(e){
	if(window.isDragResizeActive) return;
	//Skip Non Move Event
	if(!window.rightMouseDown || (window.lastControlMouseEvent != null && window.lastControlMouseEvent.pageX == e.pageX && window.lastControlMouseEvent.pageY == e.pageY)) return;
	window.lastControlMouseEvent = e;
	//Skip when no controls are selected
	if(window.selectedAdminControls === null || window.lastClickedElement === null || $(window.activeElement).is('.pos_template_control') === false) return;
	//Flag As Dragging
	window.isControlDraggingActive = true;
	if(window.selectedAdminControls.is('.dragging') == false){
		//Scale to preview
		window.selectedAdminControls.css('transform-origin', 'top left');
		window.selectedAdminControls.css('transform', 'scale('+window.templateAdminPrevewScale+')');
		//Show dragging cursor
		window.selectedAdminControls.addClass('dragging');
		$(document.body).addClass('dragging');
		//Append to body
		window.selectedAdminControls.appendTo('body');
	}
	//Set New Locations
	window.selectedAdminControls.each(function(){
		var left = e.pageX;
		var top = e.pageY;
		left -= this._hw;
		top -= this._hh;
		if(window.snapSize > 1 && window.templateAdminPrevewScale == 1){
			//Offset centered/zoomed control
			var pos = windowXYtoPreviewPageXY(left, top);
			pos.x = (Math.floor(pos.x / window.snapSize) * window.snapSize);
			pos.y = (Math.floor(pos.y / window.snapSize) * window.snapSize);
			pos = previewPageXYtoWindowXY(pos.x, pos.y);
			left = pos.x;
			top = pos.y - 8;
		}
		$(this).css({
			'z-index': 19,
			'position': 'fixed',
			'left': left+'px',
			'top': top+'px'
		});
		refreshControlLocationSizeJsonString(this);
	});
}
function updateDrageToResizeElmSizes(e){
	if(!window.isDragResizeActive) return;
	var x_diff = e.screenX - window.dragResizeStartX;
	var y_diff = e.screenY - window.dragResizeStartY;
	var w = window.dragResizeInitWidth + (x_diff / window.templateAdminPrevewScale);
	var h = window.dragResizeInitHeight + (y_diff / window.templateAdminPrevewScale);

	if(window.snapSize > 1){
		w = (Math.floor(w / window.snapSize) * window.snapSize);
		h = (Math.floor(h / window.snapSize) * window.snapSize);
	}

	if(w < 8) w = 8;
	if(h < 8) h = 8;

	window.selectedAdminControls.css({'width': w+'px', 'height': h+'px'});
	window.selectedAdminControls.each(function(){
		invalidateControlLayout(this);
	});
}
function setControlJsonStringParam(control, key, value){
	//Update the input-params attribute
	if(control === window.document){
		window.selectedAdminControls.each(function(){
			setControlJsonStringParam(this, key, value);
		});
		return;
	}

	var data = $(control).attr('input-params');

	try { data = JSON.parse(data); }
	catch (err) {
		console.log("Failed to parse as JSON: '"+data+"' [E64784568578095675343]");
		throw err;
	}
	if(typeof(key) == 'object'){
		for(var i in key) data[i] = key[i];
	}
	else {
		data[key] = value;
	}
	$(control).attr('input-params', JSON.stringify(data));
}
function refreshControlLocationSizeJsonString(control){
	$(control).each(function(){
		setControlJsonStringParam(this, {
			'width': this.offsetWidth,
			'height': this.offsetHeight,
			'left': this.offsetLeft,
			'top': this.offsetTop,
		});
	});
}
function sendControlToBack(control){
	addControl(null, null, $(control), true);
}
function bringControlToFront(control){
	addControl(null, null, $(control), false);
}

/******** INIT *********/
UI.onDocumentReady(function(){
	//Resize
	resizeAdminLayout();
	UI.resize(function(){ uiWaitForFinalEvent(resizeAdminLayout, 100, 'resizeAdminPosTmplLayout'); });
	//Set snap size and watch for changes
	window.snapSize = parseInt($('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][snap]"]').change(function(){ window.snapSize = parseInt($(this).val()); }).val());
	//Start with page fitted
	btnLayoutTmplAdminFit_click();
	//Set background snap grid
	updateSnapBackgroundSize();
	//Right control panel accordian
	$("#layout_template_admin_accordian").accordion({ 
		heightStyle: "fill",
		activate: function(event, ui){
			ui.newPanel.find('.pos_control').each(function(){ invalidateControlLayout(this); });
		}
	});
	//Init Prev Dragging
	initTemplatePreviewDragging();
	//Create Drag & Drop Controls Events
	initTemplateCreateControlDragAndDrop();
	//Create Drag-to-Resize Controls Events
	initControlResize();
	//Register keyboard events
	initKeyboardEvents();
	//Fix all toolbox groups being opened at once...
	setTimeout(function(){
		$("#layout_template_admin_accordian > h3").each(function(){
			$(this).click();
		}).get(0).click();
	});
});
function initTemplatePreviewDragging(){
	var elm = $('#layout_template_admin_container_left');
	elm[0].mouseDraggingStartMouseY = 0;
	elm[0].mouseDraggingStartMouseX = 0;
	elm[0].mouseDraggingStartScrollY = 0;
	elm[0].mouseDraggingStartScrollX = 0;
	elm[0].isDragging = false;
	//Start Dragging Events
	elm.mousedown(function(e){
		if(e.which != 1 /*Right Button*/) return;
		window.rightMouseDown = true;
		window.lastClickedElement = this;
		window.activeElement = this;
		if(e.isDefaultPrevented()) return;
		this.mouseDraggingStartScrollY = this.scrollTop;
		this.mouseDraggingStartScrollX = this.scrollLeft;
		this.mouseDraggingStartMouseY = e.screenY;
		this.mouseDraggingStartMouseX = e.screenX;
		this.isDragging = true;
		$(document.body).addClass('dragging');
		unselectAllControls(e);
	})
	//Doc Events
	$(document)
		//End Dragging
		.mouseup(function(e){
			if(e.which != 1 /*Right Button*/) return;
			window.rightMouseDown = false;
			elm[0].isDragging = false;
			$(document.body).removeClass('dragging');
			$(elm[0]).removeClass('dragging');
		})
		//End Dragging
		.mouseleave(function(){
			window.rightMouseDown = false;
			elm[0].isDragging = false;
			$(document.body).removeClass('dragging');
			$(elm[0]).removeClass('dragging');
		})
		//Update Dragging Postion
		.mousemove(function(e){
			if(elm[0].isDragging){
				var mouseYOffset = elm[0].mouseDraggingStartMouseY - e.screenY;
				var mouseXOffset = elm[0].mouseDraggingStartMouseX - e.screenX;
				elm[0].scrollTop = elm[0].mouseDraggingStartScrollY + mouseYOffset; 
				elm[0].scrollLeft = elm[0].mouseDraggingStartScrollX + mouseXOffset; 
			}
		});
}
function initTemplateCreateControlDragAndDrop(){

	//Control Resize/Drag
	$('#layout_template_preview_container .pos_template_control').each(function(){
		//Resize
		var resizeElm = $('<div class="control_resize_handle">');
		$(this).find('.control_resize_handle').remove();
		$(this).append(resizeElm);
		bindControlResizeEvent(resizeElm);
		//Drag
		var dragElm = $('<div class="control_drag_handle"><i class="fas fa-arrows-alt"></i></div>');
		$(this).find('.control_drag_handle').remove();
		$(this).append(dragElm);
		bindControlDraggingEvent(dragElm, '.pos_template_control');
	});

	//Control Drag New Control
	bindControlDraggingEvent($('#layout_template_admin_container_right .pos_template_control'));

	//Document Move/Release Events
	$(document.body)
		.mousemove(updateDraggingControlLocation)
		.mousedown(function(e){
			if(e.which != 1 /*Right Button*/) return;
			window.rightMouseDown = true;
			window.isControlDraggingActive = false;
			window.lastClickedElement = this;
			window.activeElement = this;
		})
		.mouseup(function(e){
			if(e.which != 1 /*Right Button*/) return;
			window.rightMouseDown = false;
			$(document.body).removeClass('dragging');
			//Stop Dragging (Add Control To Preview Page)
			if(window.selectedAdminControls !== null && window.selectedAdminControls.length > 0 && window.isControlDraggingActive){
				window.selectedAdminControls.filter('.dragging').each(function(){
					window.selectedAdminControls.css('transform', '');
					var y = e.pageY + 40;//?
					var x = e.pageX;
					if(typeof(window.chrome) !== 'undefined'){
						y -= 1;
						x -= 1;
					}
					addControl(x, y, $(this));
				});
				window.selectedAdminControls.removeClass('dragging');
			}
			window.lastControlMouseEvent = e;
			window.isControlDraggingActive = false;
		})
		.mouseleave(function(e){
			window.rightMouseDown = false;
			//Remove existing
			if(window.selectedAdminControls !== null && window.isControlDraggingActive){
				if(window.lastClickedElement !== null && $(window.activeElement).is('.pos_template_control')){
					window.selectedAdminControls.remove();
				}
			}
			window.lastControlMouseEvent = e;
			window.isControlDraggingActive = false;
		}); 
}
function initControlResize(){
	//Bind Mouse Down on existing controls
	bindControlResizeEvent($('.pos_template_control .control_resize_handle'));

	//Document Move/Release Events
	$(document.body)
		.mousemove(updateDrageToResizeElmSizes)
		.mousedown(function(e){
			if(e.which != 1 /*Right Button*/) return;
		})
		.mouseup(function(e){
			if(e.which != 1 /*Right Button*/) return;
			window.rightMouseDown = false;
			window.isDragResizeActive = false;
		})
		.mouseleave(function(e){
			window.rightMouseDown = false;
			window.isDragResizeActive = false;
		}); 
}
function initKeyboardEvents(){
	$(document).keydown(function(e){
		if(window.selectedAdminControls == null || window.selectedAdminControls.length == 0 || window.selectedAdminControls.closest('#layout_template_admin_container').length == 0) return;

		//Arrow Up
		if(e.keyCode == 38){
			window.selectedAdminControls.each(function(){$(this).css('top', Math.max(0, parseFloat($(this).css('top').replace('px', '')) - (!e.ctrlKey ? Math.max(1, parseInt($('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][snap]"]').val())) : 1))); });
			refreshControlLocationSizeJsonString(this);
		}

		//Arrow Down
		else if(e.keyCode == 40){
			window.selectedAdminControls.each(function(){$(this).css('top', Math.min($('#layout_template_preview_page').height() - 4, parseFloat($(this).css('top').replace('px', '')) + (!e.ctrlKey ? Math.max(1, parseInt($('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][snap]"]').val())) : 1))); });
			refreshControlLocationSizeJsonString(this);
		}

		//Arrow Left
		else if(e.keyCode == 37){
			window.selectedAdminControls.each(function(){$(this).css('left', Math.max(0, parseFloat($(this).css('left').replace('px', '')) - (!e.ctrlKey ? Math.max(1, parseInt($('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][snap]"]').val())) : 1))); });
			refreshControlLocationSizeJsonString(this);
		}

		//Arrow Right
		else if(e.keyCode == 39){
			window.selectedAdminControls.each(function(){$(this).css('left', Math.min($('#layout_template_preview_page').width() - 4, parseFloat($(this).css('left').replace('px', '')) + (!e.ctrlKey ? Math.max(1, parseInt($('[id="save_model[pointofsalelayouttemplate_model][no_id_defined][snap]"]').val())) : 1))); });
			refreshControlLocationSizeJsonString(this);
		}

		//Delete
		else if(e.keyCode == 8 /*Backspace*/ || e.keyCode == 46 /*Delete*/){
			if(window.getControlHTMLFromParamsAjax != null && window.getControlHTMLFromParamsAjax.readyState != 4){
				try{ window.getControlHTMLFromParamsAjax.abort(); } catch (err) {}
			}
			window.selectedAdminControls.each(function(){
				this.isUserDeleted = true;
				this.remove();
			});
			window.selectedAdminControls = null;
			unselectAllControls(e);
		}

	});
}