<?php

/**
 * Schema object for: SalesReceiptModRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_SalesReceiptModRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = 'SalesReceiptMod';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'TxnID' => 'IDTYPE',
  'EditSequence' => 'STRTYPE',
  'CustomerRef ListID' => 'IDTYPE',
  'CustomerRef FullName' => 'STRTYPE',
  'ClassRef ListID' => 'IDTYPE',
  'ClassRef FullName' => 'STRTYPE',
  'TemplateRef ListID' => 'IDTYPE',
  'TemplateRef FullName' => 'STRTYPE',
  'TxnDate' => 'DATETYPE',
  'RefNumber' => 'STRTYPE',
  'BillAddress Addr1' => 'STRTYPE',
  'BillAddress Addr2' => 'STRTYPE',
  'BillAddress Addr3' => 'STRTYPE',
  'BillAddress Addr4' => 'STRTYPE',
  'BillAddress Addr5' => 'STRTYPE',
  'BillAddress City' => 'STRTYPE',
  'BillAddress State' => 'STRTYPE',
  'BillAddress PostalCode' => 'STRTYPE',
  'BillAddress Country' => 'STRTYPE',
  'BillAddress Note' => 'STRTYPE',
  'ShipAddress Addr1' => 'STRTYPE',
  'ShipAddress Addr2' => 'STRTYPE',
  'ShipAddress Addr3' => 'STRTYPE',
  'ShipAddress Addr4' => 'STRTYPE',
  'ShipAddress Addr5' => 'STRTYPE',
  'ShipAddress City' => 'STRTYPE',
  'ShipAddress State' => 'STRTYPE',
  'ShipAddress PostalCode' => 'STRTYPE',
  'ShipAddress Country' => 'STRTYPE',
  'ShipAddress Note' => 'STRTYPE',
  'IsPending' => 'BOOLTYPE',
  'CheckNumber' => 'STRTYPE',
  'PaymentMethodRef ListID' => 'IDTYPE',
  'PaymentMethodRef FullName' => 'STRTYPE',
  'DueDate' => 'DATETYPE',
  'SalesRepRef ListID' => 'IDTYPE',
  'SalesRepRef FullName' => 'STRTYPE',
  'ShipDate' => 'DATETYPE',
  'ShipMethodRef ListID' => 'IDTYPE',
  'ShipMethodRef FullName' => 'STRTYPE',
  'FOB' => 'STRTYPE',
  'ItemSalesTaxRef ListID' => 'IDTYPE',
  'ItemSalesTaxRef FullName' => 'STRTYPE',
  'Memo' => 'STRTYPE',
  'CustomerMsgRef ListID' => 'IDTYPE',
  'CustomerMsgRef FullName' => 'STRTYPE',
  'IsToBePrinted' => 'BOOLTYPE',
  'IsToBeEmailed' => 'BOOLTYPE',
  'IsTaxIncluded' => 'BOOLTYPE',
  'CustomerSalesTaxCodeRef ListID' => 'IDTYPE',
  'CustomerSalesTaxCodeRef FullName' => 'STRTYPE',
  'DepositToAccountRef ListID' => 'IDTYPE',
  'DepositToAccountRef FullName' => 'STRTYPE',
  'Other' => 'STRTYPE',
  'SalesReceiptLineMod TxnLineID' => 'IDTYPE',
  'SalesReceiptLineMod ItemRef ListID' => 'IDTYPE',
  'SalesReceiptLineMod ItemRef FullName' => 'STRTYPE',
  'SalesReceiptLineMod Desc' => 'STRTYPE',
  'SalesReceiptLineMod Quantity' => 'QUANTYPE',
  'SalesReceiptLineMod UnitOfMeasure' => 'STRTYPE',
  'SalesReceiptLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'SalesReceiptLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'SalesReceiptLineMod Rate' => 'PRICETYPE',
  'SalesReceiptLineMod RatePercent' => 'PERCENTTYPE',
  'SalesReceiptLineMod PriceLevelRef ListID' => 'IDTYPE',
  'SalesReceiptLineMod PriceLevelRef FullName' => 'STRTYPE',
  'SalesReceiptLineMod ClassRef ListID' => 'IDTYPE',
  'SalesReceiptLineMod ClassRef FullName' => 'STRTYPE',
  'SalesReceiptLineMod Amount' => 'AMTTYPE',
  'SalesReceiptLineMod ServiceDate' => 'DATETYPE',
  'SalesReceiptLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'SalesReceiptLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'SalesReceiptLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'SalesReceiptLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'SalesReceiptLineMod Other1' => 'STRTYPE',
  'SalesReceiptLineMod Other2' => 'STRTYPE',
  'SalesReceiptLineGroupMod TxnLineID' => 'IDTYPE',
  'SalesReceiptLineGroupMod ItemGroupRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod ItemGroupRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod Quantity' => 'QUANTYPE',
  'SalesReceiptLineGroupMod UnitOfMeasure' => 'STRTYPE',
  'SalesReceiptLineGroupMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod TxnLineID' => 'IDTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod Desc' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod Quantity' => 'QUANTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod UnitOfMeasure' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod Rate' => 'PRICETYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod RatePercent' => 'PERCENTTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod Amount' => 'AMTTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod ServiceDate' => 'DATETYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other1' => 'STRTYPE',
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other2' => 'STRTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'TxnID' => 0,
  'EditSequence' => 16,
  'CustomerRef ListID' => 0,
  'CustomerRef FullName' => 209,
  'ClassRef ListID' => 0,
  'ClassRef FullName' => 209,
  'TemplateRef ListID' => 0,
  'TemplateRef FullName' => 209,
  'TxnDate' => 0,
  'RefNumber' => 11,
  'BillAddress Addr1' => 41,
  'BillAddress Addr2' => 41,
  'BillAddress Addr3' => 41,
  'BillAddress Addr4' => 41,
  'BillAddress Addr5' => 41,
  'BillAddress City' => 31,
  'BillAddress State' => 21,
  'BillAddress PostalCode' => 13,
  'BillAddress Country' => 31,
  'BillAddress Note' => 41,
  'ShipAddress Addr1' => 41,
  'ShipAddress Addr2' => 41,
  'ShipAddress Addr3' => 41,
  'ShipAddress Addr4' => 41,
  'ShipAddress Addr5' => 41,
  'ShipAddress City' => 31,
  'ShipAddress State' => 21,
  'ShipAddress PostalCode' => 13,
  'ShipAddress Country' => 31,
  'ShipAddress Note' => 41,
  'IsPending' => 0,
  'CheckNumber' => 25,
  'PaymentMethodRef ListID' => 0,
  'PaymentMethodRef FullName' => 209,
  'DueDate' => 0,
  'SalesRepRef ListID' => 0,
  'SalesRepRef FullName' => 209,
  'ShipDate' => 0,
  'ShipMethodRef ListID' => 0,
  'ShipMethodRef FullName' => 209,
  'FOB' => 13,
  'ItemSalesTaxRef ListID' => 0,
  'ItemSalesTaxRef FullName' => 209,
  'Memo' => 4095,
  'CustomerMsgRef ListID' => 0,
  'CustomerMsgRef FullName' => 209,
  'IsToBePrinted' => 0,
  'IsToBeEmailed' => 0,
  'IsTaxIncluded' => 0,
  'CustomerSalesTaxCodeRef ListID' => 0,
  'CustomerSalesTaxCodeRef FullName' => 209,
  'DepositToAccountRef ListID' => 0,
  'DepositToAccountRef FullName' => 209,
  'Other' => 29,
  'SalesReceiptLineMod TxnLineID' => 0,
  'SalesReceiptLineMod ItemRef ListID' => 0,
  'SalesReceiptLineMod ItemRef FullName' => 209,
  'SalesReceiptLineMod Desc' => 4095,
  'SalesReceiptLineMod Quantity' => 0,
  'SalesReceiptLineMod UnitOfMeasure' => 31,
  'SalesReceiptLineMod OverrideUOMSetRef ListID' => 0,
  'SalesReceiptLineMod OverrideUOMSetRef FullName' => 209,
  'SalesReceiptLineMod Rate' => 0,
  'SalesReceiptLineMod RatePercent' => 0,
  'SalesReceiptLineMod PriceLevelRef ListID' => 0,
  'SalesReceiptLineMod PriceLevelRef FullName' => 209,
  'SalesReceiptLineMod ClassRef ListID' => 0,
  'SalesReceiptLineMod ClassRef FullName' => 209,
  'SalesReceiptLineMod Amount' => 0,
  'SalesReceiptLineMod ServiceDate' => 0,
  'SalesReceiptLineMod SalesTaxCodeRef ListID' => 0,
  'SalesReceiptLineMod SalesTaxCodeRef FullName' => 209,
  'SalesReceiptLineMod OverrideItemAccountRef ListID' => 0,
  'SalesReceiptLineMod OverrideItemAccountRef FullName' => 209,
  'SalesReceiptLineMod Other1' => 29,
  'SalesReceiptLineMod Other2' => 29,
  'SalesReceiptLineGroupMod TxnLineID' => 0,
  'SalesReceiptLineGroupMod ItemGroupRef ListID' => 0,
  'SalesReceiptLineGroupMod ItemGroupRef FullName' => 209,
  'SalesReceiptLineGroupMod Quantity' => 0,
  'SalesReceiptLineGroupMod UnitOfMeasure' => 31,
  'SalesReceiptLineGroupMod OverrideUOMSetRef ListID' => 0,
  'SalesReceiptLineGroupMod OverrideUOMSetRef FullName' => 209,
  'SalesReceiptLineGroupMod SalesReceiptLineMod TxnLineID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef ListID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef FullName' => 209,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Desc' => 4095,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Quantity' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod UnitOfMeasure' => 31,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef ListID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef FullName' => 209,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Rate' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod RatePercent' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef ListID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef FullName' => 209,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef ListID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef FullName' => 209,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Amount' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ServiceDate' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef ListID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef FullName' => 209,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef ListID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef FullName' => 209,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other1' => 29,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other2' => 29,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'TxnID' => false,
  'EditSequence' => false,
  'CustomerRef ListID' => true,
  'CustomerRef FullName' => true,
  'ClassRef ListID' => true,
  'ClassRef FullName' => true,
  'TemplateRef ListID' => true,
  'TemplateRef FullName' => true,
  'TxnDate' => true,
  'RefNumber' => true,
  'BillAddress Addr1' => true,
  'BillAddress Addr2' => true,
  'BillAddress Addr3' => true,
  'BillAddress Addr4' => true,
  'BillAddress Addr5' => true,
  'BillAddress City' => true,
  'BillAddress State' => true,
  'BillAddress PostalCode' => true,
  'BillAddress Country' => true,
  'BillAddress Note' => true,
  'ShipAddress Addr1' => true,
  'ShipAddress Addr2' => true,
  'ShipAddress Addr3' => true,
  'ShipAddress Addr4' => true,
  'ShipAddress Addr5' => true,
  'ShipAddress City' => true,
  'ShipAddress State' => true,
  'ShipAddress PostalCode' => true,
  'ShipAddress Country' => true,
  'ShipAddress Note' => true,
  'IsPending' => true,
  'CheckNumber' => true,
  'PaymentMethodRef ListID' => true,
  'PaymentMethodRef FullName' => true,
  'DueDate' => true,
  'SalesRepRef ListID' => true,
  'SalesRepRef FullName' => true,
  'ShipDate' => true,
  'ShipMethodRef ListID' => true,
  'ShipMethodRef FullName' => true,
  'FOB' => true,
  'ItemSalesTaxRef ListID' => true,
  'ItemSalesTaxRef FullName' => true,
  'Memo' => true,
  'CustomerMsgRef ListID' => true,
  'CustomerMsgRef FullName' => true,
  'IsToBePrinted' => true,
  'IsToBeEmailed' => true,
  'IsTaxIncluded' => true,
  'CustomerSalesTaxCodeRef ListID' => true,
  'CustomerSalesTaxCodeRef FullName' => true,
  'DepositToAccountRef ListID' => true,
  'DepositToAccountRef FullName' => true,
  'Other' => true,
  'SalesReceiptLineMod TxnLineID' => false,
  'SalesReceiptLineMod ItemRef ListID' => true,
  'SalesReceiptLineMod ItemRef FullName' => true,
  'SalesReceiptLineMod Desc' => true,
  'SalesReceiptLineMod Quantity' => true,
  'SalesReceiptLineMod UnitOfMeasure' => true,
  'SalesReceiptLineMod OverrideUOMSetRef ListID' => true,
  'SalesReceiptLineMod OverrideUOMSetRef FullName' => true,
  'SalesReceiptLineMod Rate' => false,
  'SalesReceiptLineMod RatePercent' => false,
  'SalesReceiptLineMod PriceLevelRef ListID' => true,
  'SalesReceiptLineMod PriceLevelRef FullName' => true,
  'SalesReceiptLineMod ClassRef ListID' => true,
  'SalesReceiptLineMod ClassRef FullName' => true,
  'SalesReceiptLineMod Amount' => true,
  'SalesReceiptLineMod ServiceDate' => true,
  'SalesReceiptLineMod SalesTaxCodeRef ListID' => true,
  'SalesReceiptLineMod SalesTaxCodeRef FullName' => true,
  'SalesReceiptLineMod OverrideItemAccountRef ListID' => true,
  'SalesReceiptLineMod OverrideItemAccountRef FullName' => true,
  'SalesReceiptLineMod Other1' => true,
  'SalesReceiptLineMod Other2' => true,
  'SalesReceiptLineGroupMod TxnLineID' => false,
  'SalesReceiptLineGroupMod ItemGroupRef ListID' => true,
  'SalesReceiptLineGroupMod ItemGroupRef FullName' => true,
  'SalesReceiptLineGroupMod Quantity' => true,
  'SalesReceiptLineGroupMod UnitOfMeasure' => true,
  'SalesReceiptLineGroupMod OverrideUOMSetRef ListID' => true,
  'SalesReceiptLineGroupMod OverrideUOMSetRef FullName' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod TxnLineID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef ListID' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef FullName' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Desc' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Quantity' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod UnitOfMeasure' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef ListID' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef FullName' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Rate' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod RatePercent' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef ListID' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef FullName' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef ListID' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef FullName' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Amount' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ServiceDate' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef ListID' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef FullName' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef ListID' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef FullName' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other1' => true,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other2' => true,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'TxnID' => 0,
  'EditSequence' => 999.99,
  'CustomerRef ListID' => 999.99,
  'CustomerRef FullName' => 999.99,
  'ClassRef ListID' => 999.99,
  'ClassRef FullName' => 999.99,
  'TemplateRef ListID' => 999.99,
  'TemplateRef FullName' => 999.99,
  'TxnDate' => 999.99,
  'RefNumber' => 999.99,
  'BillAddress Addr1' => 999.99,
  'BillAddress Addr2' => 999.99,
  'BillAddress Addr3' => 999.99,
  'BillAddress Addr4' => 2,
  'BillAddress Addr5' => 6,
  'BillAddress City' => 999.99,
  'BillAddress State' => 999.99,
  'BillAddress PostalCode' => 999.99,
  'BillAddress Country' => 999.99,
  'BillAddress Note' => 6,
  'ShipAddress Addr1' => 999.99,
  'ShipAddress Addr2' => 999.99,
  'ShipAddress Addr3' => 999.99,
  'ShipAddress Addr4' => 2,
  'ShipAddress Addr5' => 6,
  'ShipAddress City' => 999.99,
  'ShipAddress State' => 999.99,
  'ShipAddress PostalCode' => 999.99,
  'ShipAddress Country' => 999.99,
  'ShipAddress Note' => 6,
  'IsPending' => 999.99,
  'CheckNumber' => 999.99,
  'PaymentMethodRef ListID' => 999.99,
  'PaymentMethodRef FullName' => 999.99,
  'DueDate' => 999.99,
  'SalesRepRef ListID' => 999.99,
  'SalesRepRef FullName' => 999.99,
  'ShipDate' => 999.99,
  'ShipMethodRef ListID' => 999.99,
  'ShipMethodRef FullName' => 999.99,
  'FOB' => 999.99,
  'ItemSalesTaxRef ListID' => 999.99,
  'ItemSalesTaxRef FullName' => 999.99,
  'Memo' => 999.99,
  'CustomerMsgRef ListID' => 999.99,
  'CustomerMsgRef FullName' => 999.99,
  'IsToBePrinted' => 999.99,
  'IsToBeEmailed' => 6,
  'IsTaxIncluded' => 6,
  'CustomerSalesTaxCodeRef ListID' => 999.99,
  'CustomerSalesTaxCodeRef FullName' => 999.99,
  'DepositToAccountRef ListID' => 999.99,
  'DepositToAccountRef FullName' => 999.99,
  'Other' => 6,
  'SalesReceiptLineMod TxnLineID' => 0,
  'SalesReceiptLineMod ItemRef ListID' => 999.99,
  'SalesReceiptLineMod ItemRef FullName' => 999.99,
  'SalesReceiptLineMod Desc' => 999.99,
  'SalesReceiptLineMod Quantity' => 999.99,
  'SalesReceiptLineMod UnitOfMeasure' => 7,
  'SalesReceiptLineMod OverrideUOMSetRef ListID' => 999.99,
  'SalesReceiptLineMod OverrideUOMSetRef FullName' => 999.99,
  'SalesReceiptLineMod Rate' => 999.99,
  'SalesReceiptLineMod RatePercent' => 999.99,
  'SalesReceiptLineMod PriceLevelRef ListID' => 999.99,
  'SalesReceiptLineMod PriceLevelRef FullName' => 999.99,
  'SalesReceiptLineMod ClassRef ListID' => 999.99,
  'SalesReceiptLineMod ClassRef FullName' => 999.99,
  'SalesReceiptLineMod Amount' => 999.99,
  'SalesReceiptLineMod ServiceDate' => 999.99,
  'SalesReceiptLineMod SalesTaxCodeRef ListID' => 999.99,
  'SalesReceiptLineMod SalesTaxCodeRef FullName' => 999.99,
  'SalesReceiptLineMod OverrideItemAccountRef ListID' => 999.99,
  'SalesReceiptLineMod OverrideItemAccountRef FullName' => 999.99,
  'SalesReceiptLineMod Other1' => 6,
  'SalesReceiptLineMod Other2' => 6,
  'SalesReceiptLineGroupMod TxnLineID' => 0,
  'SalesReceiptLineGroupMod ItemGroupRef ListID' => 999.99,
  'SalesReceiptLineGroupMod ItemGroupRef FullName' => 999.99,
  'SalesReceiptLineGroupMod Quantity' => 999.99,
  'SalesReceiptLineGroupMod UnitOfMeasure' => 7,
  'SalesReceiptLineGroupMod OverrideUOMSetRef ListID' => 999.99,
  'SalesReceiptLineGroupMod OverrideUOMSetRef FullName' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod TxnLineID' => 0,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef ListID' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef FullName' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Desc' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Quantity' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod UnitOfMeasure' => 7,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef ListID' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef FullName' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Rate' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod RatePercent' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef ListID' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef FullName' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef ListID' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef FullName' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Amount' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ServiceDate' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef ListID' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef FullName' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef ListID' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef FullName' => 999.99,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other1' => 6,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other2' => 6,
  'IncludeRetElement' => 999.99,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'TxnID' => false,
  'EditSequence' => false,
  'CustomerRef ListID' => false,
  'CustomerRef FullName' => false,
  'ClassRef ListID' => false,
  'ClassRef FullName' => false,
  'TemplateRef ListID' => false,
  'TemplateRef FullName' => false,
  'TxnDate' => false,
  'RefNumber' => false,
  'BillAddress Addr1' => false,
  'BillAddress Addr2' => false,
  'BillAddress Addr3' => false,
  'BillAddress Addr4' => false,
  'BillAddress Addr5' => false,
  'BillAddress City' => false,
  'BillAddress State' => false,
  'BillAddress PostalCode' => false,
  'BillAddress Country' => false,
  'BillAddress Note' => false,
  'ShipAddress Addr1' => false,
  'ShipAddress Addr2' => false,
  'ShipAddress Addr3' => false,
  'ShipAddress Addr4' => false,
  'ShipAddress Addr5' => false,
  'ShipAddress City' => false,
  'ShipAddress State' => false,
  'ShipAddress PostalCode' => false,
  'ShipAddress Country' => false,
  'ShipAddress Note' => false,
  'IsPending' => false,
  'CheckNumber' => false,
  'PaymentMethodRef ListID' => false,
  'PaymentMethodRef FullName' => false,
  'DueDate' => false,
  'SalesRepRef ListID' => false,
  'SalesRepRef FullName' => false,
  'ShipDate' => false,
  'ShipMethodRef ListID' => false,
  'ShipMethodRef FullName' => false,
  'FOB' => false,
  'ItemSalesTaxRef ListID' => false,
  'ItemSalesTaxRef FullName' => false,
  'Memo' => false,
  'CustomerMsgRef ListID' => false,
  'CustomerMsgRef FullName' => false,
  'IsToBePrinted' => false,
  'IsToBeEmailed' => false,
  'IsTaxIncluded' => false,
  'CustomerSalesTaxCodeRef ListID' => false,
  'CustomerSalesTaxCodeRef FullName' => false,
  'DepositToAccountRef ListID' => false,
  'DepositToAccountRef FullName' => false,
  'Other' => false,
  'SalesReceiptLineMod TxnLineID' => false,
  'SalesReceiptLineMod ItemRef ListID' => false,
  'SalesReceiptLineMod ItemRef FullName' => false,
  'SalesReceiptLineMod Desc' => false,
  'SalesReceiptLineMod Quantity' => false,
  'SalesReceiptLineMod UnitOfMeasure' => false,
  'SalesReceiptLineMod OverrideUOMSetRef ListID' => false,
  'SalesReceiptLineMod OverrideUOMSetRef FullName' => false,
  'SalesReceiptLineMod Rate' => false,
  'SalesReceiptLineMod RatePercent' => false,
  'SalesReceiptLineMod PriceLevelRef ListID' => false,
  'SalesReceiptLineMod PriceLevelRef FullName' => false,
  'SalesReceiptLineMod ClassRef ListID' => false,
  'SalesReceiptLineMod ClassRef FullName' => false,
  'SalesReceiptLineMod Amount' => false,
  'SalesReceiptLineMod ServiceDate' => false,
  'SalesReceiptLineMod SalesTaxCodeRef ListID' => false,
  'SalesReceiptLineMod SalesTaxCodeRef FullName' => false,
  'SalesReceiptLineMod OverrideItemAccountRef ListID' => false,
  'SalesReceiptLineMod OverrideItemAccountRef FullName' => false,
  'SalesReceiptLineMod Other1' => false,
  'SalesReceiptLineMod Other2' => false,
  'SalesReceiptLineGroupMod TxnLineID' => false,
  'SalesReceiptLineGroupMod ItemGroupRef ListID' => false,
  'SalesReceiptLineGroupMod ItemGroupRef FullName' => false,
  'SalesReceiptLineGroupMod Quantity' => false,
  'SalesReceiptLineGroupMod UnitOfMeasure' => false,
  'SalesReceiptLineGroupMod OverrideUOMSetRef ListID' => false,
  'SalesReceiptLineGroupMod OverrideUOMSetRef FullName' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod TxnLineID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef ListID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef FullName' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Desc' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Quantity' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod UnitOfMeasure' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef ListID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef FullName' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Rate' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod RatePercent' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef ListID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef FullName' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef ListID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef FullName' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Amount' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod ServiceDate' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef ListID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef FullName' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef ListID' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef FullName' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other1' => false,
  'SalesReceiptLineGroupMod SalesReceiptLineMod Other2' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'TxnID',
  1 => 'EditSequence',
  2 => 'CustomerRef ListID',
  3 => 'CustomerRef FullName',
  4 => 'ClassRef ListID',
  5 => 'ClassRef FullName',
  6 => 'TemplateRef ListID',
  7 => 'TemplateRef FullName',
  8 => 'TxnDate',
  9 => 'RefNumber',
  10 => 'BillAddress Addr1',
  11 => 'BillAddress Addr2',
  12 => 'BillAddress Addr3',
  13 => 'BillAddress Addr4',
  14 => 'BillAddress Addr5',
  15 => 'BillAddress City',
  16 => 'BillAddress State',
  17 => 'BillAddress PostalCode',
  18 => 'BillAddress Country',
  19 => 'BillAddress Note',
  20 => 'ShipAddress Addr1',
  21 => 'ShipAddress Addr2',
  22 => 'ShipAddress Addr3',
  23 => 'ShipAddress Addr4',
  24 => 'ShipAddress Addr5',
  25 => 'ShipAddress City',
  26 => 'ShipAddress State',
  27 => 'ShipAddress PostalCode',
  28 => 'ShipAddress Country',
  29 => 'ShipAddress Note',
  30 => 'IsPending',
  31 => 'CheckNumber',
  32 => 'PaymentMethodRef ListID',
  33 => 'PaymentMethodRef FullName',
  34 => 'DueDate',
  35 => 'SalesRepRef ListID',
  36 => 'SalesRepRef FullName',
  37 => 'ShipDate',
  38 => 'ShipMethodRef ListID',
  39 => 'ShipMethodRef FullName',
  40 => 'FOB',
  41 => 'ItemSalesTaxRef ListID',
  42 => 'ItemSalesTaxRef FullName',
  43 => 'Memo',
  44 => 'CustomerMsgRef ListID',
  45 => 'CustomerMsgRef FullName',
  46 => 'IsToBePrinted',
  47 => 'IsToBeEmailed',
  48 => 'IsTaxIncluded',
  49 => 'CustomerSalesTaxCodeRef ListID',
  50 => 'CustomerSalesTaxCodeRef FullName',
  51 => 'DepositToAccountRef ListID',
  52 => 'DepositToAccountRef FullName',
  53 => 'Other',
  54 => 'SalesReceiptLineMod TxnLineID',
  55 => 'SalesReceiptLineMod ItemRef ListID',
  56 => 'SalesReceiptLineMod ItemRef FullName',
  57 => 'SalesReceiptLineMod Desc',
  58 => 'SalesReceiptLineMod Quantity',
  59 => 'SalesReceiptLineMod UnitOfMeasure',
  60 => 'SalesReceiptLineMod OverrideUOMSetRef ListID',
  61 => 'SalesReceiptLineMod OverrideUOMSetRef FullName',
  62 => 'SalesReceiptLineMod Rate',
  63 => 'SalesReceiptLineMod RatePercent',
  64 => 'SalesReceiptLineMod PriceLevelRef ListID',
  65 => 'SalesReceiptLineMod PriceLevelRef FullName',
  66 => 'SalesReceiptLineMod ClassRef ListID',
  67 => 'SalesReceiptLineMod ClassRef FullName',
  68 => 'SalesReceiptLineMod Amount',
  69 => 'SalesReceiptLineMod ServiceDate',
  70 => 'SalesReceiptLineMod SalesTaxCodeRef ListID',
  71 => 'SalesReceiptLineMod SalesTaxCodeRef FullName',
  72 => 'SalesReceiptLineMod OverrideItemAccountRef ListID',
  73 => 'SalesReceiptLineMod OverrideItemAccountRef FullName',
  74 => 'SalesReceiptLineMod Other1',
  75 => 'SalesReceiptLineMod Other2',
  76 => 'SalesReceiptLineGroupMod TxnLineID',
  77 => 'SalesReceiptLineGroupMod ItemGroupRef ListID',
  78 => 'SalesReceiptLineGroupMod ItemGroupRef FullName',
  79 => 'SalesReceiptLineGroupMod Quantity',
  80 => 'SalesReceiptLineGroupMod UnitOfMeasure',
  81 => 'SalesReceiptLineGroupMod OverrideUOMSetRef ListID',
  82 => 'SalesReceiptLineGroupMod OverrideUOMSetRef FullName',
  83 => 'SalesReceiptLineGroupMod SalesReceiptLineMod TxnLineID',
  84 => 'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef ListID',
  85 => 'SalesReceiptLineGroupMod SalesReceiptLineMod ItemRef FullName',
  86 => 'SalesReceiptLineGroupMod SalesReceiptLineMod Desc',
  87 => 'SalesReceiptLineGroupMod SalesReceiptLineMod Quantity',
  88 => 'SalesReceiptLineGroupMod SalesReceiptLineMod UnitOfMeasure',
  89 => 'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef ListID',
  90 => 'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideUOMSetRef FullName',
  91 => 'SalesReceiptLineGroupMod SalesReceiptLineMod Rate',
  92 => 'SalesReceiptLineGroupMod SalesReceiptLineMod RatePercent',
  93 => 'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef ListID',
  94 => 'SalesReceiptLineGroupMod SalesReceiptLineMod PriceLevelRef FullName',
  95 => 'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef ListID',
  96 => 'SalesReceiptLineGroupMod SalesReceiptLineMod ClassRef FullName',
  97 => 'SalesReceiptLineGroupMod SalesReceiptLineMod Amount',
  98 => 'SalesReceiptLineGroupMod SalesReceiptLineMod ServiceDate',
  99 => 'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef ListID',
  100 => 'SalesReceiptLineGroupMod SalesReceiptLineMod SalesTaxCodeRef FullName',
  101 => 'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef ListID',
  102 => 'SalesReceiptLineGroupMod SalesReceiptLineMod OverrideItemAccountRef FullName',
  103 => 'SalesReceiptLineGroupMod SalesReceiptLineMod Other1',
  104 => 'SalesReceiptLineGroupMod SalesReceiptLineMod Other2',
  105 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>