<?php

ini_set('auto_detect_line_endings', true);
ini_set('display_errors', 1);//SAFE_DEBUG_ENABLED
error_reporting(E_ALL);//SAFE_DEBUG_ENABLED
define('NO_SESSION_CACHE_UPDATE', 1);
require_once(dirname(__FILE__).'/includes/session.php');
$headerpagetitle = 'NolaPro Business Management';
$product_name = 'NolaPro';
$isWhiteLabel = false;

// Get any white label definitions for title
if (file_exists(dirname(__FILE__).'/wl/'.@$_SESSION['wlhost'].'wl.php')) {
	include_once(dirname(__FILE__).'/wl/'.@$_SESSION['wlhost'].'wl.php');
	if (defined('WL_NAME') && defined('WL_SUBNAME')) {
		$headerpagetitle = htmlentities(strip_tags(WL_NAME.' '.WL_SUBNAME));
		$product_name = htmlentities(strip_tags(WL_NAME));
		$isWhiteLabel = true;
	}
}

$funcSetConnCharset = function(&$conn){
	if($conn){ 
		try {
			$set_charset = defined('DB_CHARSET') ? DB_CHARSET : 'utf8';
			mysqli_set_charset($conn, $set_charset);
		}
		catch(mysqli_sql_exception $e){
			//try again, using the utf8 alias
			if($set_charset === 'utf8mb3' || $set_charset === 'utf8mb4') {
				mysqli_set_charset($conn, 'utf8');
			}
		}
		@$conn->_connectionID = $conn;
	}
};

$showTaskbar = !isset($_REQUEST['phase']);

ini_set('display_errors', 1);//SAFE_DEBUG_ENABLED
error_reporting(E_ALL);//SAFE_DEBUG_ENABLED

getLock('installer_script', true);

global $conn;

?><!DOCTYPE html>
<html lang="en">
<head>
	<title><?php echo $headerpagetitle; ?> Installation</title>
	<link rel="stylesheet" type="text/css" href="<?= NP_BASE_URL ?>css/vars.css.php">
	<link rel="stylesheet" type="text/css" href="<?= NP_BASE_URL ?>css/style.css">
	<script src="<?= defined('JS_URL') ? JS_URL : 'js/' ?>jquery.min.js"></script>
	<style>
		<?php if($showTaskbar){ ?>
			:root {
				--ui-style-taskbar-height: 41px !important;
			}
		<?php } ?>
		#section_view {
			top: var(--ui-style-taskbar-height);
			height: calc(var(--ui-style-vh, 100vh) - var(--ui-style-taskbar-height)) !important;
			overflow: auto;
		}
		<?php if(!$isWhiteLabel){ ?>
			.npLogo {
				display: inline-block;
				background-size: contain;
				pointer-events: none;
				margin: -4px 0 0 2px;
				filter: drop-shadow(1px 1px 1px rgba(0, 0, 0, 0.9)) drop-shadow(-1px -1px 1px rgba(255, 255, 255, 0.5));
				height: 55px;
				width: 150px;
				background: url("images\/ico\/index.php?src=nolapro.svg&text=&animated=0") no-repeat scroll 0 0 / 100% auto transparent;
			}
			#npLogoHeader:not(.no-logo-background) {
				width: 149px;
				background-color: rgba(255,255,255,0.25);
				border-radius: 0 19px 20px 0;
			}
		<?php } ?>
		.emergency a {
			line-height: 1.5em;
			padding: 1px 4px;
			border-radius: 3px;
			background-color: var(--ui-style-highlight-light, rgba(255,255,255,0.33));
		}
		.report {
			max-width:  calc(100vw - 16px);
		}
		div.texttitle {
			font-weight: bold;
			border-bottom: 1px solid #193985;
		}
		div.texttitle {
			margin-top: 5px;
			font-size: 16px;
			text-align: left;
			padding-left: 4px;
			padding-right: 4px;
			padding-top: 4px;
			padding-bottom: 4px;
			font-weight: bold;
			font-family: Verdana, Arial, sans-serif;
			width: 750px;
			max-width: 100vw;
		}

		.redXMark, .greenCheckmark {
			font-size: 25px;
			line-height: 29px;
			display: inline-block;
			width: 29px;
			height: 29px;
			padding: 2px;
			text-align: center;
			text-shadow: 1px 1px 1px #000;
			background-color: rgba(255, 255, 255, 0.8);
			border-radius: 50%;
		}
		.greenCheckmark {
			color: green;
		}
		.redXMark {
			color: red;
		}
		.mysql_ok_log {
			text-align: center;
		}
	</style>
	<script>
		function postPushMessage(data){
			if(parent !== window && typeof(parent.postMessage) !== 'undefined') {
				try{ parent.postMessage({_src: 'header', 'postMessage': data, phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>}, '*'); } catch (err) { }
			}
			if(typeof(chrome) !== 'undefined' && typeof(chrome.webview) !== 'undefined'){
				chrome.webview.postMessage(data);
			}
		}
		$(document).ready(function(){
			if(typeof(npbrowser) !== 'undefined') {
				npbrowser.showClosePopupButton();
				$('.npbrowser-loginexit').click(function(){
					postPushMessage({_src: 'header', 'postMessage': 'ExitClient', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>});
				});
			}
			else {
				setTimeout(function(){ postPushMessage('ShowInternalTitlebar'); }, 10);
				setTimeout(function(){ postPushMessage('ShowInternalTitlebar'); }, 100);
				setTimeout(function(){ postPushMessage('ShowInternalTitlebar'); }, 1000);
			}
		});
	</script>
</head>
<body tmpl="default" class="loginBackgroundTmp mode_pos_only_hidden pace-done">
<!-- 08975231879-8962153780-7965218NPSIGCHECK9062430-97021687-7904638989-12346 -->
<div id="firstElmInBody"></div>
<div id="uiTopBar">
	<div id="npLogoHeader" style="display: inline-block; white-space: nowrap; pointer-events:none;">
		<span class="npLogo" style="pointer-events: none;"></span>
	</div>
	<span id="pagetitle" style="font-size: 16px; display: block; visibility: visible;" class="animated-page-title">
		<span class="pagetitle-title"><?php echo $headerpagetitle; ?> Initial Setup</span>
		<span id="pagesubtitle" class="pagetitle-subtitle"></span>
	</span>
	<div id="uiTopBarMenu" class="uiTopBarMenu">
		<div id="uiTopBarMenuItems">
		</div>
	</div>
</div>
<div id="content">
<?php if($showTaskbar){ ?>
<div class="uiTaskBarContainer" style="height: 0px; overflow: visible; margin-bottom: 41px;">
	<div class="uiTaskBarBackground" style="min-height: 40px; height: 40px;">
		<div class="uiTaskBar uiTaskBarTable" style="width: 100%;">
			<div class="mode_fo_only uiTaskBarButton uiTaskBarButtonFor_0" onclick="var url = location.href.replace(/[?&]salt=\d*/, ''); url += url.indexOf('?') >= 0 ? '&' : '?'; url += 'salt='+parseInt(Math.random() * 10000000); location.href = url;">
				<span class="uiTaskBarImgContainer">
					<input class="savebutton uiTaskBarCloneElm taskBarClickEventElm" type="image" src="images/refresh.png" onclick="location.href=location.href;" title="Refresh" id="uiTaskBar_0_clone" td_class="mode_fo_only">
				</span>
				Refresh
			</div>
		</div>
	</div>
</div>
<?php } ?>
<div id="section_view">
<?php 
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Check for System Dependencies
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	// Start output buffering so we can check the system state each time to make sure nothing changed
	ob_start();
?>
	<h2 style="text-align: center;">We will now check your system to make sure it<br>has everything it needs to run <?= $product_name ?> properly.</h2>
	<table style="width: 325px; max-width: 100vw; margin: auto;">
	<tr>
	<td><b class="greenCheckmark">&check;</b></td><td>Green checks mean this setting is OK.</td>
	</tr>
	<tr>
	<td><b class="redXMark">X</b></td><td>Red Xs mean this setting needs to be changed by you or a server administrator in order to continue.</td>
	</tr>
	<tr>
	<td colspan="2"><br>After modifying a system setting refresh this page so it can verify your new configuration.</td>
	</tr>
	</table>
	<br><br>
<?php

	$system_ok = 1;
	$ok_img = '<b class="greenCheckmark" style="margin-left: 8px;">&check;</b>';
	$bad_img = '<b class="redXMark" style="margin-left: 8px;">X</b>';
	$bad_style = ' class="emergency" ';
	$ok_style = ' class="standard" ';
	
	$required_extensions = array(	'gd' => array('title' => '<b>gd</b> - needed for creating dynamic charts',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with gd support or uncomment the ;extension= line in your php.ini file for gd.'),
									'session' => array('title' => '<b>session</b> - required for logging into the system',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with session support or uncomment the ;extension= line in your php.ini file for sessions. On Linux you may need to download a php-session rpm to get this functionality.'),
									'curl' => array('title' => '<b>curl</b> - required for credit card processing',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with curl support or uncomment the ;extension= line in your php.ini file for curl. On Linux you may need to download a php-curl rpm to get this functionality.'),
									'mbstring' => array('title' => '<b>mbstring</b> - required for multibyte string processing',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with mbstring support or uncomment the ;extension= line in your php.ini file for mbstring. On Linux you may need to download a php-mbstring rpm to get this functionality.'),
									'PDO' => array('title' => '<b>PDO</b> - required for database interaction',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with PDO support or uncomment the ;extension= line in your php.ini file for PDO. On Linux you may need to download a php-pdo rpm to get this functionality.'),
									'zlib' => array('title' => '<b>zlib</b> - required for working with PDF files',
										'resolution' => 'Please add this extension to your PHP installation. Either recompile with zlib support or uncomment the ;extension= line in your php.ini file for zlib. On Linux you may need to download a php-zlib rpm to get this functionality.'),
									'ionCube Loader' => array('title' => '<b>ionCube Loader</b> - used to load encoded '.$product_name.' files',
										'resolution' => 'The ionCube Loader could not be found. Please go to <a href=\"https://www.ioncube.com/loaders.php\">ionCube.com</a> to get and install a compatible loader.'),
									);
	if (!function_exists('utf8_encode')) {
		$required_extensions['xml'] = array('title' => '<b>xml</b> - UTF8 Support',
											'resolution' =>'Please add this extension to your PHP installation. Either recompile with session support or uncomment the ;extension= line in your php.ini file for sessions. On Linux you may need to download a php-xml rpm to get this functionality.');
	}	
	if (!class_exists('ZipArchive', false)) {
		$required_extensions['zip'] = array('title' => '<b>zip</b> - required for system updates',
											'resolution' =>'Please add this extension to your PHP installation. Either recompile with session support or uncomment the ;extension= line in your php.ini file for sessions. On Linux you may need to download a php-zip rpm to get this functionality.');
	}
	echo '<table class="report" width="500">';
	echo '<tr>';
	echo '<th class="header" colspan="2">Required Extensions</th>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>Extension</th>';
	echo '<th width="75">Status</th>';
	echo '</tr>';
	if (function_exists('mysqli_connect')) {
		$use_img = $ok_img;
		$res = "";
		$style = $ok_style;
	}
	else {
		$use_img = $bad_img;	
		$res = "<br><br>MySQLi must be installed and be precompiled or loaded as an extension with PHP.";
		$style = $bad_style;
		$system_ok = 0;
	}
	echo '<tr>';
	echo '<td'.$style.' style="text-align: left;"><b>MySQL</b> - back-end database '.$product_name.' utilizes'.$res.'</td>';
	echo '<td'.$style.' style="text-align: center;">';
	echo $use_img;
	echo '</td>';
	echo '</tr>';
	foreach ($required_extensions as $ext => $desc) {
		if (extension_loaded($ext)) {
			$use_img = $ok_img;
			$style = $ok_style;
			$res = "";
		}
		else {
			$use_img = $bad_img;
			$style = $bad_style;
			$res = "<br><br>$desc[resolution]";
			$system_ok = 0;
		}
		echo '<tr>';
		echo '<td'.$style.' style="text-align: left;">'.$desc['title'].$res.'</td>';
		echo '<td'.$style.' style="text-align: center;">';
		echo $use_img;
		echo '</td>';
		echo '</tr>';
	}
	echo '</table>';
	echo '<br><br>';
	echo '<table class="report" width="500">';
	echo '<tr>';
	echo '<th class="header" colspan="2">Required PHP Configuration Settings</th>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>Configuration Setting</th>';
	echo '<th width="75">Status</th>';
	echo '</tr>';
	$standard_setting_resolution = 'You can either change the setting in your php.ini file, add it to your Apache virtual host entry, 
	or use the htaccess.txt file in the main '.$product_name.' directory and rename it to .htaccess. 
	To use the .htaccess file Apache must be set up to allow overrides for your domain (via the AllowOverride setting).';
	$php_settings = array('short_open_tag' => array('default' => 'on',
										'title' => '<b>short_open_tag</b> must be <b>on</b>',
										'resolution' => $standard_setting_resolution),
						'session.auto_start' => array('default' => 'off',
											'title' => '<b>session.auto_start</b> must be <b>off</b>',
											'resolution' => $standard_setting_resolution),
						'file_uploads' => array('default' => 'on',
											'title' => '<b>file_uploads</b> must be <b>on</b>',
											'resolution' => $standard_setting_resolution),
						'auto_detect_line_endings' => array('default' => 'on',
											'title' => '<b>auto_detect_line_endings</b> must be <b>on</b>',
											'resolution' => $standard_setting_resolution),
						'safe_mode' => array('default' => 'off',
											'title' => '<b>safe_mode</b> must be <b>off</b>',
											'resolution' => $standard_setting_resolution),
						'register_globals' => array('default' => 'off',
											'title' => '<b>register_globals</b> must be <b>off</b>',
											'resolution' => $standard_setting_resolution));
	if (!defined('PHP_VERSION_ID')) {
		$version = explode('.', PHP_VERSION);
		define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
	}

	foreach ($php_settings as $setting => $details) {
		//Lookup setting
		$ini_setting = ini_get($setting);
		$cur_value = ($ini_setting && strtolower($ini_setting) != 'off') ? 'on' : 'off';
		
		//Prepare Output
		if ($cur_value == $details['default'] || $cur_value === null) {
			$use_img = $ok_img;
			$res = "";
			$style = $ok_style;
		} 
		else {
			$use_img = $bad_img;
			$res = ", current value is <b>$cur_value</b><br><br>$details[resolution]";
			$style = $bad_style;
			$system_ok = 0;
		}
		
		//Output Table Row
		echo '<tr>';
		echo '  <td'.$style.'>'.$details['title'].'<i>'.$res.'</i></td>';
		echo '  <td'.$style.'>';
		echo        $use_img;
		echo '  </td>';
		echo '</tr>';
	}
	if (!function_exists('session_start') || !@session_start()) {
		$system_ok = 0;
		echo '<tr>';
		echo '  <td'.$style.'><b>Session Failed to start a session.</b> <i>Check the php.ini \'session.save_path\' value and confirm the path is writable.</i></i></td>';
		echo '  <td '.$bad_style.'>';
		echo        $bad_img;
		echo '  </td>';
		echo '</tr>';
	}
	echo '</table>';
	
	echo '<br><br>';
	echo '<table class="report" width="500">';
	echo '<tr>';
	echo '<th class="header" colspan="2">Required Permissions for Files and Directories</th>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>File or Directory</th>';
	echo '<th width="75">Status</th>';
	echo '</tr>';
	$standard_directory_resolution = 'Change permissions to allow the web server to write files in this directory. For Linux this directory can have 777 permissions (read, write, execute for all)';
	$standard_file_resolution = 'Change permissions to allow the web server to write to this file. For Linux this file can have 777 permissions (read, write, execute for all)';
	$dir_check = array(	dirname(__FILE__) => array('title' => '<b>www (Linux) or htdocs (Windows)</b> main directory must be writable by the web server',
										'resolution' => $standard_directory_resolution),
						'uploads' => array('title' => '<b>uploads</b> directory must be writable',
										'resolution' => $standard_directory_resolution),
						'includes/my_defines.php' => array('title' => '<b>includes/my_defines.php</b> file must be writable',
											'resolution' => $standard_file_resolution),
						'install.php' => array('title' => '<b>install.php</b> file must be writable',
											'resolution' => $standard_file_resolution));
	
	if (file_exists(dirname(__FILE__).'/api/app/config/database.php')) {
		$dir_check[dirname(__FILE__).'/api/app/config/database.php'] = array('title' => '<b>api/app/config/database.php</b> file must be writable',
											'resolution' => $standard_file_resolution);
	}
	foreach ($dir_check as $dir => $details) {
		$isOK = is_writable($dir);
		if ($dir === 'install.php' && !file_exists('install.php')){
			$isOK = true;
			?>
			<script>
				postPushMessage({_src: 'script_end', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, progress: 1, error: 0, unlink_install: 1});
			</script>
			<?php
		}
		if($isOK) {
			$use_img = $ok_img;
			$res = "";
			$style = $ok_style;
		}
		else {
			$use_img = $bad_img;
			$res = "<br><br>$details[resolution]";
			$style = $bad_style;	
			$system_ok = 0;
		}
		echo '<tr>';
		echo '<td'.$style.' style="text-align: left;">'.$details['title'].'<i>'.$res.'</i></td>';
		echo '<td'.$style.' style="text-align: center;">';
		echo $use_img;
		echo '</td>';
		echo '</tr>';
	}
	echo '</table>';
	
	// Get the contents of the buffer and display if there was an error
	$html = ob_get_clean();
	
	// Dev install - Ignore missing ioncube (setup requirement)
	$ignore_phase_1 = isDevInstall() && @$_REQUEST['ignorephase1'];
	if($ignore_phase_1){
		$system_ok = 1;
		if(!isset($_POST['phase'])) $_POST['phase'] = @$_REQUEST['phase'];
	}

	$check_database = 0;
	if ($system_ok) {
		if ((!isset($_POST['phase']) && !isset($_GET['phase'])) || (isset($_POST['phase']) && $_POST['phase'] < 2)) {
			echo $html;
			echo '<form id="frmMain" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'">';
			echo '<table class="buttons">';
			echo '<tr><td><input type="image" src="images/next.png"</td></tr>';
			echo '<tr><td>Next</td></tr>';
			echo '</table>';
			echo '<input type="hidden" name="phase" value="2">';
			if($ignore_phase_1) echo '<input type="hidden" name="ignorephase1" value="1">';
			echo '</form>';
			if (stristr(php_uname('s'), 'Windows')) {
				// Move to the next page if this is windows
				echo '<META HTTP-EQUIV="refresh" content="0;URL='.htmlentities($_SERVER['PHP_SELF']).'?phase=2">';
			}
			else {
				?>
				<script>
					postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, lbl: 'Error! Wrong OS?', progress: 0, error: 1, errorid: 'E23581143491'});
				</script>
				<?php
			}
		}
		$check_database = 1;
	}
	else {
		echo $html;
		echo '<br><br><h2 style="text-align: center;">You must resolve the issues marked in red above before you can continue with the installation.</h2><br>';
		if(isDevInstall()){
			echo '<div style="text-align: center; padding: 8px; margin-bottom: 24px;"><a href="'.htmlentities($_SERVER['PHP_SELF']).'?phase=2&ignorephase1=1">(DEV INSTALL ONLY) Ignore &amp; Continue</a></div>';
		}
	} 

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Set up the database
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	if ($check_database) {
		include_once('includes/my_defines.inc.php');
		echo '<h2 style="margin-top: 32px; text-align: center;">'.$product_name.' Database Installation</h2>';

		if (isset($_GET['phase']) && $_GET['phase'] == 4) {

			//Start Logging
			$logfilename = dirname(__FILE__).'/'.(defined('IMAGE_UPLOAD_DIR') ? IMAGE_UPLOAD_DIR : 'uploads/').'log';
			if(!file_exists($logfilename)) mkdir($logfilename, 0777, true);
			$logfilename .= '/np_install.log';
			$fhLogFile = fopen($logfilename, 'w');
			ini_set('log_errors', 1);
			ini_set('error_log', $logfilename);
			error_reporting(E_ALL);
			$funcInstallLog = function($msg) use (&$fhLogFile){ fwrite($fhLogFile, '['.date('Y-m-d H:i:s').'] '.$msg."\n"); };
			if(!$fhLogFile) $funcInstallLog = function($msg){};

			//Missing session info?  Pull from disk or from the request data
			if(!isset($_SESSION['setup'])){
				$funcInstallLog('Using Setup Info From Defines');
				$_SESSION['setup'] = [
					'np_host' => DB_SERVER,
					'np_user' => DB_SERVER_USERNAME,
					'np_pass' => DB_SERVER_PASSWORD,
					'np_db'   => DB_DATABASE,
				];
			}
			if(!isset($_SESSION['np_mysql_port'])){
				$funcInstallLog('Using Alt Port Info From Request');
				$_SESSION['np_mysql_port'] = @$_REQUEST['np_mysql_port'];
			}

			// Load the database file now
			$funcInstallLog('Connecting to database...');
			/** @var MySQLI|stdClass */
			$conn = @mysqli_connect($_SESSION['setup']['np_host'].$_SESSION['np_mysql_port'], $_SESSION['setup']['np_user'], $_SESSION['setup']['np_pass']);
			if($conn) {
				$funcInstallLog('	Connected.');
				$funcSetConnCharset($conn);
				$conn->_connectionID = $conn;
			}
			$mysql_ok = 1;
			// Connect again and send back the person if it fails for some reason
			if ($conn == false || !@mysqli_select_db($conn,$_SESSION['setup']['np_db'])) {
				if($conn == false) $funcInstallLog('	Connection Failed!');
				else $funcInstallLog('	DB Schema Missing!');
				$mysql_ok = 0;
				$_POST['phase'] = 3;
			}

			//Start Progress File For AJAX Reads
			$funcInstallLog("Starting Progress File...");
			$fileProgressName = dirname(__FILE__).'/uploads/temp';
			if(!file_exists($fileProgressName)) mkdir($fileProgressName);
			$fileProgressName .= '/dbinstallprog.json';
			@file_put_contents($fileProgressName, json_encode(['lbl' => '', 'progress' => floatval(0)]));
			@chmod($fileProgressName, 0777);
			$lastUpdateWrite = 0;
			$funcWriteProgress = function($lbl, $progress, $lazy = true) use (&$fileProgressName, &$lastUpdateWrite){
				if($lazy && $lastUpdateWrite == time()) return;
				$max_len = 50;
				if(strlen($lbl) > $max_len) $lbl = substr($lbl, 0, $max_len - 2).'&hellip;';
				@file_put_contents($fileProgressName, json_encode(['lbl' => $lbl, 'progress' => floatval($progress)]));
				$lastUpdateWrite = time();
			};
			$funcInstallLog("	Done");

			if ($mysql_ok) {
				$funcInstallLog("Loading library database_structure...");
				require_once(dirname(__FILE__).'/!/application/libraries/database_structure.php');
				$table_charsets = Database_structure::$table_charsets;
				if(!is_array($table_charsets)) $table_charsets = [];
				$funcInstallLog("	Enforcing Table Charsets: ".json_encode($table_charsets));
				$funcInstallLog("	Done.");

				echo "<div class=\"mysql_ok_log\">";
				$width = 512;
				$height = 'height: 32px;';
				echo '<div class="AjaxProgressBar_Wapper" id="progDBProgBarContainer" style="visibility: hidden; display: block; width: '.$width.'px;'.$height.' left: 50%; margin-left: -'.($width/2).'px;">';
				echo 	'<div class="AjaxProgressBar_Label_Under progDBLbl" style="width: '.$width.'px;'.$height.'"></div>';
				echo 	'<div class="AjaxProgressBar_Progress" id="progDBProgBar">';
				echo		'<div class="AjaxProgressBar_Label_Over progressLabel_ progDBLbl" style="width: '.$width.'px;'.$height.'"></div>';
				echo 	'</div>';
				echo	'<div class="AjaxProgressBar_Progress_Waves" style="width: '.$width.'px; height: '.$width.'px;"></div>';
				echo '</div>';
				?>
				<script>
					function updateProgressBar(){ 
						$.fetch('uploads/temp/dbinstallprog.json',
							function(jsonString) {
								try{
									r = JSON.parse(jsonString);
									$('#progDBProgBarContainer').css('visibility', 'visible');
									$('.progDBLbl').html(r.lbl+' '+(r.progress * 100).toFixed(0)+'%');
									$('#progDBProgBar').css('width', (r.progress * 100)+'%');
									r._src = 'updateProgressBarAjax';
									postPushMessage(r);
								}
								catch(e){ }
								setTimeout(updateProgressBar, 1000);
							},
							function() { }
						);
					}
					setTimeout(updateProgressBar, 333);
				</script>
				<?php
				//Flush script to browser
				echo str_repeat(' ', 4096);
				ob_flush();flush();

				//Get current connection type
				$funcInstallLog("Checking Connection Type...");
				$data = mysqli_get_charset($conn);
				if(!is_array($data) && $data !== null && $data !== false) $data = (array)$data;
				if(!is_array($data) || !isset($data['charset']) || !isset($data['collation']) || !isset($data['max_length']))
					$data = ['charset' => 'utf8', 'collation' => 'utf8_general_ci', 'max_length' => 3];
				$isUTF8Connection = strpos(trim(strtolower($data['charset'])), 'utf8') === 0;
				$funcInstallLog("	UTF8 Detected: ".($isUTF8Connection ? 'Yes' : 'No'));
				$funcInstallLog("	Charset: ".$data['charset']);
				$funcInstallLog("	Collation: ".$data['collation']);
				$funcInstallLog("	Done.");

				//Confirm DB's default charset is correct
				$funcInstallLog("Checking Schemata Default Charset...");
				$sql = 'SELECT @@character_set_database as `charset`, @@collation_database as `collation`';
				$rsDBCharset = mysqli_query($conn, $sql);
				$dbDefaultCharsetInfo = mysqli_fetch_array($rsDBCharset, MYSQLI_ASSOC);
				$funcInstallLog("	Charset: ".$dbDefaultCharsetInfo['charset']);
				$funcInstallLog("	Collation: ".$dbDefaultCharsetInfo['collation']);
				if($data['charset'] != $dbDefaultCharsetInfo['charset'] || $data['collation'] != $dbDefaultCharsetInfo['collation']){
					$funcInstallLog("	Setting new defaults of ".$data['charset'].'/'.$data['collation'].'...');
					$sql = 'ALTER SCHEMA `'.$_SESSION['setup']['np_db'].'` DEFAULT CHARACTER SET '.$data['charset'].' DEFAULT COLLATE '.$data['collation'];
					mysqli_query($conn, $sql);
				}
				$funcInstallLog("	Done.");

				set_time_limit(0);
				// Read in the database file
				$funcInstallLog("Executing SQL Installation file...");
				echo "<h3>Creating $product_name tables...</h3>";
				//Open the file
				$fsize = filesize("nolapro.sql");
				$fh=@fopen("nolapro.sql","rb");
				if(!$fh) {
					endLock('installer_script');
					die(__('Database update file not found.'));
				}
				$query = "";
				$errorfound=0; // Whether any errors were found
				$create_views_sql = [];
				while($sql=fgets($fh)){
					$funcWriteProgress($sql, (ftell($fh) / $fsize) * 0.9);
					if (substr(trim($sql), 0, 2) != "--"){ // Ignore comments
						// Find out where semi-colon is
						if(substr(trim($sql),strlen(trim($sql))-1,1)==";")
						{
							$query .= trim($sql);
							if(preg_match('/^\s*(\/\*!50001\s*)?CREATE ALGORITHM=/i', $query)){
								$create_views_sql[] = $query;
							}
							else {

								//Fix table charsets (utf8 alias varies by mysql version, moving to a new standard of 4-bytes (vs 3) so don't override the 3 or 4 by alais of UTF8 via a direct SQL statment to set 3 or 4 bytes.
								$rx = "/DEFAULT CHARSET\\=[a-zA-Z0-9_\\-]+\\s+COLLATE\\=[a-zA-Z0-9_\\-]+(\\s*\bCOMMENT\\=.*?)?\\s*(;)?\\s*?$/i";
								if(strpos($query, 'COLLATE=') !== false){
									//Use charset from connection
									$charset = $data['charset'];
									$collation = $data['collation'];
									//Use the hard-coded charset defined by the database_structure, if found
									$tablename = false;
									$matches = [];
									if(preg_match("/^CREATE TABLE( IF NOT EXISTS)? `?([a-z0-9\\-_]+)`?[^a-z0-9\\-_]/i", $query, $matches)){
										$tablename = trim(strtolower($matches[2]));
										if(isset($table_charsets[$tablename])){
											if(isset($table_charsets[$tablename]['charset'])){
												$charset = is_array($table_charsets[$tablename]['charset']) ? $table_charsets[$tablename]['charset'][0] : $table_charsets[$tablename]['charset'];
												if($charset === '*') $charset = $data['charset'];
											}
											if(isset($table_charsets[$tablename]['collation'])){
												$collation = is_array($table_charsets[$tablename]['collation']) ? $table_charsets[$tablename]['collation'][0] : $table_charsets[$tablename]['collation'];
												if($collation === '*') $collation = $data['collation'];
											}
										}
									}
									//Update the query with new details
									$query = preg_replace($rx, 'DEFAULT CHARSET='.$charset.' COLLATE='.$collation.'$1$2', $query);
								}

								if(preg_match("/^CREATE TABLE( IF NOT EXISTS)? `?([a-z0-9\\-_]+)`?[^a-z0-9\\-_]/i", $query, $matches)){
									$tablename = trim(strtolower($matches[2]));
									$funcInstallLog("Creating table `{$tablename}`...");
								}

								// Execute this sql statement
								$res = mysqli_query($conn,$query);

								if(!$res) {
									echo htmlspecialchars($query)."<br><br><span class=\"emergency\" style=\"padding: 4px; line-height: 1.5em;\"><b>Error #".mysqli_errno($conn)."</b> ".mysqli_error($conn)."</span><hr><br>";
									$funcInstallLog("Error #".mysqli_errno($conn)." ".mysqli_error($conn)."\n{$query}");
									$errorfound=1;
								}
							}
							$query="";
						}
						else {
							$query .= $sql;
						}
					}
				}
				fclose($fh);

				//Create Views
				$funcInstallLog("Building Views...");
				$funcWriteProgress('Building Views&hellip;', 0.91, false);
				foreach($create_views_sql as $query){
					//Rewrite SQL: "CREATE" to "CREATE OR REPLACE"
					$sql = preg_replace('/^\s*(\/\*!50001\s*)?CREATE ALGORITHM=/i', '\1CREATE OR REPLACE ALGORITHM=', $query);
					//Rewrite SQL: Remove "SQL SECURITY DEFINER "
					$sql = preg_replace('/\/\*!50013 DEFINER=.*? SQL SECURITY DEFINER \*\//i', '', $sql);
					//Rewrite SQL: Rewrite DB target name
					$sql = preg_replace('/`([^`]+)`\.`([^`]+)`\.`([^`]+)`/i', '`'.DB_DATABASE.'`.`\2`.`\3`', $sql);
					if(mysqli_query($conn, $sql)===false){
						$funcWriteLog("$query<br/><span class=\"emergency\">Error #".mysqli_errno($conn)." ".mysqli_error($conn)."</span><br/>");
						$funcInstallLog("Error #".mysqli_errno($conn)." ".mysqli_error($conn)."\n{$query}");
						$errorfound=521456;
					}
				}
				$funcInstallLog("	Done.");

				//Save DB Version
				$funcInstallLog("Preparing App 1st Run...");
				$funcWriteProgress('Preparing for first run&hellip;', 0.95, false);
				function getBuildVersion(){
					define('LOAD_DEFINES_FOR_VERSION', 1);
					ob_start();
					require(dirname(__FILE__).'/includes/defines.php');
					ob_end_clean();
				}
				getBuildVersion();
				mysqli_query($conn,'DELETE FROM `serversetup` WHERE `definename` = \'np_build\'');
				$rs = mysqli_query($conn,'SELECT (MAX(`id`) + 1) as `next` FROM `serversetup`');
				if($rs){
					if($r = mysqli_fetch_assoc($rs)){
						$id = intval($r['next']);
						mysqli_query($conn,'INSERT INTO `serversetup` (`id`, `definename`, `definevalue`) VALUES ('.$id.', \'np_build\', \''.intval(BUILD_VERSION).'\')');
					}
				}
				$funcInstallLog("	Done.");

				//SQL File Exec Finished
				if (!$errorfound) {
					$funcInstallLog("Finished database schema installation");
					$funcWriteProgress('Ready!', 1, false);
					echo "<h3>The database has been created successfully!</h3>";
					?>
					<script>
						postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, lbl: 'Complete', progress: 1, complete: 1});
					</script>
					<?php
					$funcInstallLog("Removing Installation Script...");
					endLock('installer_script');
					@unlink('install.php');
					clearstatcache(true);
					?>
					<script>
						postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, progress: 1, error: 0, unlink_install: 1});
					</script>
					<?php
					if(file_exists('install.php')){
						$funcInstallLog("	ERROR!");
						echo "<h3>ERROR: Unable to delete install.php. You must delete this file before continuing!<br>".htmlentities(realpath('install.php'))."</h3>";
						echo "<h3><a href=\"index.php\">Click here to continue with the $product_name setup.</a></h3>";
					}
					else {
						$funcInstallLog("	Done.");
						echo "<h3><a href=\"index.php\">Click here to continue with the $product_name setup.</a></h3>";
						echo "<script>location.href='index.php';</script>";
					}
				}
				else {
					$funcInstallLog("Errors detected");
					echo "<h3>There was a problem creating the database.</h3>";
					?>
					<script>
						postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, lbl: 'Error!', progress: 0, error: 1, errorid: 'E49162104218137'});
					</script>
					<?php
					// Clean up the database by deleting all of the tables currently in there
					$funcInstallLog("Dropping App Tables...");
					$res = mysqli_query($conn,"show tables");
					while ($row = mysqli_fetch_row($res)) {
						$tablename=$row[0];
						$res2=mysqli_query($conn,"drop table $tablename");
					}
					$funcInstallLog("	Done.");
				}
				echo "</div>";

			}
			else {
				$funcInstallLog("Exiting! Bad mysql connection.");
				?>
				<script>
					postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, lbl: 'Error!', progress: 0, error: 1, errorid: 'E197246226236'});
				</script>
				<?php
			}

			//End Logging
			$funcInstallLog("Closing Log...");
			if($fhLogFile) fclose($fhLogFile);
		}
		
		if (isset($_POST['phase']) && $_POST['phase'] == 3) {
			$mysql_ok = 1;
			$error_msg = "";
			$host = preg_replace('/^\s*p:/i', '', $_POST['np_host']);
			$_SESSION['np_mysql_port'] = ":53306";
			$conn = false;
			// Verify the login information provided
			/** @var MySQLI|stdClass */
			try {
				$conn = @mysqli_connect($_POST['np_host'].$_SESSION['np_mysql_port'], $_POST['np_user'], $_POST['np_pass']);
				$funcSetConnCharset($conn);
			}
			catch(mysqli_sql_exception $e){ }
			// Try without alt 53306 port
			if ($conn == false) {
				$_SESSION['np_mysql_port'] = "";
				/** @var MySQLI|stdClass */
				$conn = @mysqli_connect($_POST['np_host'].$_SESSION['np_mysql_port'], $_POST['np_user'], $_POST['np_pass']);
				if($conn){
					$funcSetConnCharset($conn);
					$conn->_connectionID = $conn;
				}
			}
			if ($conn == false) {
				$mysql_ok = 0;
				$error_msg = "Could not connect to the MySQL database with the host,<br>user account and password provided. Please try again.";
				if($conn !== false) $error_msg .= "<br><br><span style='font-size: 8pt; font-style: italic;'>Error #".mysqli_errno($conn)." ".mysqli_error($conn)."</span>";
				$_POST['phase'] = 2;
			}
			
			// Make sure the database exists
			$funcDBTrySelect = function($conn, $db){
				try{
					return mysqli_select_db($conn, $db);
				}
				catch(mysqli_sql_exception $e){
					return false;
				}
			};
			if ($mysql_ok && !$funcDBTrySelect($conn, $_POST['np_db'])) { 
				// Attempt to create the mysql database if we couldn't connect
				$res = mysqli_query($conn, "create database if not exists `".sql_safe($_POST['np_db'])."`");
				if (!$res || !$funcDBTrySelect($conn,$_POST['np_db'])) {
					$mysql_ok = 0;
					$error_msg = "Could not connect to the <i>".html_safe($_POST['np_db'])."</i> MySQL database. <br>Make sure the database exists and that the user <i>".html_safe($_POST['np_user'])."</i><br>has the proper rights to access it.";
					$_POST['phase'] = 2;
				}
			}
			
			// See if the version of mysql is correct
			if ($mysql_ok) {
				$res = mysqli_query($conn,"select version()");
				if (!$res) {
					$mysql_ok = 0;
					$error_msg = "There was an error checking for the current version of mysql.";
					$_POST['phase'] = 2;
				}
				$row = mysqli_fetch_row($res);
				if ($mysql_ok && substr($row[0], 0, 3) < "5.1") {
					$mysql_ok = 0;
					$error_msg = "$product_name requires MySQL version 5.1.x or higher. MySQL ".html_safe($row[0])." is currently installed.<br>Please choose a 5.1.x or greater server for $product_name to connect to.";
					$_POST['phase'] = 2;
				}
			}
			
			// See if the database has any tables and display an error
			if ($mysql_ok) {
				$res = mysqli_query($conn,"show tables");
				if (!$res) {
					$mysql_ok = 0;
					$error_msg = "There was an error checking for existing tables in the <i>".html_safe($_POST['np_db'])."</i> database.<br>Make sure this user has rights for the database.";
					$_POST['phase'] = 2;
				}
				if ($mysql_ok && mysqli_num_rows($res) > 0) {
					$mysql_ok = 0;
					$error_msg = "There are some tables already in the <i>".html_safe($_POST['np_db'])."</i> database.<br>$product_name requires an empty database.";
					$_POST['phase'] = 2;
				}
			}
			
			// See if the mysql file exists
			if ($mysql_ok) {
				if (!file_exists("nolapro.sql")) {
					$mysql_ok = 0;
					$error_msg = "The database file, <i>nolapro.sql</i>, is missing. Cannot continue until this file is placed in the top-level $product_name directory.";
					$_POST['phase'] = 2;
					?>
						<script>
							postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, lbl: 'Error!', progress: 0, error: 1, errorid: 'E623297139'});
						</script>
					<?php
				}
				else {
					echo '<div style="text-align: center;">';
					echo "<h3>The database connection is OK.</h3>";
					echo "<h3>Reading in the database file...<br>
							<br>This may take a few minutes...</h3>";
					// Write the new values to my_defines.php
					include('includes/class.search_replace.inc');
					
					$hostname = 'p:'.preg_replace('/^p:/i', '', trim($_POST['np_host']));

					$files_to_change = array('includes/my_defines.php');
					$sr = new search_replace("define('DB_SERVER', '".addcslashes(DB_SERVER, '\'')."')", "define('DB_SERVER', '".addcslashes($hostname, '\'')."')", $files_to_change, '', 1, array('##'));
					$sr->set_search_function('normal');
					$sr->do_search();
					
					$sr->find = "define('DB_SERVER_USERNAME', '".addcslashes(DB_SERVER_USERNAME, '\'')."')";
					$sr->replace = "define('DB_SERVER_USERNAME', '".addcslashes($_POST['np_user'], '\'')."')";
					$sr->do_search();
					
					$sr->find = "define('DB_SERVER_PASSWORD', '".addcslashes(DB_SERVER_PASSWORD, '\'')."')";
					$sr->replace = "define('DB_SERVER_PASSWORD', '".addcslashes($_POST['np_pass'], '\'')."')";
					$sr->do_search();
					
					$sr->find = "define('DB_DATABASE', '".addcslashes(DB_DATABASE, '\'')."')";
					$sr->replace = "define('DB_DATABASE', '".addcslashes($_POST['np_db'], '\'')."')";
					$sr->do_search();
					
					$sr->find = "define('DB_SERVER',          '".addcslashes(DB_SERVER, '\'')."')";
					$sr->replace = "define('DB_SERVER',          '".addcslashes($hostname, '\'')."')";
					$sr->do_search();

					$sr->find = "define('DB_DATABASE',        '".addcslashes(DB_DATABASE, '\'')."')";
					$sr->replace = "define('DB_DATABASE',        '".addcslashes($_POST['np_db'], '\'')."')";
					$sr->do_search();
					
					if (file_exists(dirname(__FILE__).'/api/app/config/database.php')) {
						$files_to_change = array('api/app/config/database.php');
						$sr = new search_replace("'host' => '127.0.0.1',", "'host' => '".addcslashes($hostname, '\'')."',", $files_to_change, '', 1, array('##'));
						$sr->set_search_function('normal');
						$sr->do_search();
						
						$sr->find = "'login' => 'root',";
						$sr->replace = "'login' => '".addcslashes($_POST['np_user'], '\'')."',";
						$sr->do_search();
						
						$sr->find = "'password' => '',";
						$sr->replace = "'password' => '".addcslashes($_POST['np_pass'], '\'')."',";
						$sr->do_search();
						
						$sr->find = "'database' => 'nolapro',";
						$sr->replace = "'database' => '".addcslashes($_POST['np_db'], '\'')."',";
						$sr->do_search();
					}        
					$_SESSION['setup'] = array();
					$_SESSION['setup'] = $_POST;
					echo '</div>';
					echo '<form id="frmRedirectWithPostP4" method="POST" action="'.htmlentities($_SERVER['PHP_SELF']).'?phase=4">';
					foreach($_POST as $k => $v){
						if(is_array($v)) continue;
						echo '<input type="hidden" value="'.htmlentities($v).'" name="'.htmlentities($k).'">';
					}
					echo 	'<input type="hidden" value="'.htmlentities($_SESSION['np_mysql_port']).'" name="np_mysql_port">';
					if($ignore_phase_1) echo '<input type="hidden" name="ignorephase1" value="1">';
					echo '</form>';
					echo '<script>setTimeout(document.getElementById(\'frmRedirectWithPostP4\').submit(), 2000);</script>';
					echo '<div style="text-align: center;"><loading-64></loading-64></div>';
				}
			}
			else {
				?>
					<script>
						postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, lbl: 'Error!', progress: 0, error: 1, errorid: 'E84110202209'});
					</script>
				<?php
			}
		}
		
		if (isset($_POST['phase']) && $_POST['phase'] == 2 || isset($_GET['phase']) && $_GET['phase'] == 2) {
			if (isset($error_msg) && $error_msg != "") {
				echo '<div class="emergency" style="display: table; margin: auto; padding: 8px; border-radius: 3px; line-height: 20pt; text-align: center; font-size: 14pt;">'.$error_msg.'</div><br><br>';	
			}
			if(DIRECTORY_SEPARATOR === '\\' && file_exists(dirname(__FILE__).'/../filechecksumcache.bin')){
				echo '<div style="text-align: center; font-weight: bold;">* Windows users can accept all defaults and click the Next button</div><br><br>';
			} 
			?>
			<form method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']) ?>" name="mainform">
			<table align="center" width="600" class="report">
			<tr>
				<th colspan="2">Enter the host name of the MySQL server</th>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">MySQL Host Name:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_host" value="<?php echo html_safe(isset($_POST['np_host']) && $_POST['np_host'] != "" ? $_POST['np_host'] : DB_SERVER)?>"></td>
			</tr>
			<tr>
				<th colspan="2">Enter the name of the MySQL database <?= $product_name ?> should use</th>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">MySQL Database:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_db" value="<?php echo html_safe(isset($_POST['np_db']) && $_POST['np_db'] != "" ? $_POST['np_db'] : DB_DATABASE)?>"></td>
			</tr>
			<tr>
				<th colspan="2">Enter the MySQL user information for the account<br>you want to use to access your <?= $product_name ?> database<br>
				<span style="font-style: italic; font-size: 8pt; font-weight: normal;">(You can download a free administrative tool from<br><a href="http://www.mysql.com/products/tools" target="_blank">MySQL</a> to create a database and user account.)</span></th>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">MySQL User Account:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_user" value="<?php echo html_safe(isset($_POST['np_user']) && $_POST['np_user'] != "" ? $_POST['np_user'] : DB_SERVER_USERNAME)?>"></td>
			</tr>
			<tr>
				<td class="dollars" style="padding: 3px; font-weight: bold; border-right: 0px;" width="300">Password:</td>
				<td class="standard" style="padding: 3px;  border-left: 0px;" width="300"><input class="text" type="text" name="np_pass" value="<?php echo html_safe(isset($_POST['np_pass']) ? $_POST['np_pass'] : DB_SERVER_PASSWORD)?>"></td>
			</tr>
			</table>
			<table class="buttons">
			<tr><td><input type="image" src="images/next.png"></td></tr>
			<tr><td>Next</td></tr>
			</table>
			<input type="hidden" name="phase" value="3">
			<?php if($ignore_phase_1) echo '<input type="hidden" name="ignorephase1" value="1">'; ?>
			</form>
			<br><br>
			<?php
			if (stristr(php_uname('s'), 'Windows') && (!isset($error_msg) || $error_msg == "")) {
				// Move to the next page if this is windows
				?>
				<script>
				document.mainform.submit();
				</script>
				<?php
			}
			else {
				?>
					<script>
						postPushMessage({_src: 'np_install', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>, lbl: 'Error!', progress: 0, error: 1, errorid:'E2272009249'});
					</script>
				<?php
			}
		}
	}
	endLock('installer_script');
?>
</div>
</div>
<br>
<br>
<script>
	postPushMessage({_src: 'script_end', phase: 0<?php echo '+'.intval(@$_REQUEST['phase']) ?>});
</script>
</body>
</html>