CKEDITOR.plugins.add( 'item', {
    icons: 'item',
    init: function( editor ) {
        // Plugin logic goes here...
        
        editor.ui.addButton( 'item', {
            label: window.STR_INSERT_ITEM,
            command: 'insert_item',
            toolbar: 'insert'
        });
        
        editor.addCommand( 'insert_item', {
            exec: function( editor ) {
                //editor.insertHtml( 'The current date and time is: <em>' + now.toString() + '</em>' );
                
                $("#ckeditor_select_item").dialog({
                    title: window.STR_INSERT_ITEM,
                    modal: true,
                    height: 120,
                    width: 350,
                    buttons: [
                        {
                            text: window.STR_INSERT_ITEM,
                            icons: {
                                primary: "ui-icon-circle-plus"
                            },
                            click: function() {
                                
                                //editor
                                var itemid = $(this).find('#itemid').val();
                                $.ajax({
                                    url: CI_BASE_URL+'item/ckeditor_info/'+itemid,
                                    context: this
                                }).done(function(html) {
                                    editor.insertHtml(html);
                                    $(this).find('#ckeditor_select_item_select').show();
                                    $(this).find('#ckeditor_select_item_loading').hide();
                                    $(this).dialog("close");
                                });
                                $('.ui-widget-overlay').attr('style', 'z-index: 101 !important;');
                                $(this).find('#ckeditor_select_item_select').hide();
                                $(this).find('#ckeditor_select_item_loading').show();
                            }
                        },
                        {
                            text: window.STR_CANCEL,
                            icons: {
                                primary: "ui-icon-circle-close"
                            },
                            click: function() {
                                $( this ).dialog( "close" );
                            }
                        }
                    ]
                });
                
            }
        });
    }
});