<?php
/**
 * PrefillTabs
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * PrefillTabs Class Doc Comment
 *
 * @category    Class
 * @description Prefill tabs are tabs that the sender can fill in before the envelope is sent. They are sometimes called sender tags or pre-fill fields.  Only the following tab types can be prefill tabs:  - text - check boxes - radio buttons    [Pre-Fill Your Own Document Fields][app] describes how prefill tabs work in the web application.   [Customize your envelopes with pre-fill fields][catblog] shows how to use prefill tabs in your application using the eSignature SDKs.  [app]:      https://support.docusign.com/en/guides/ndse-user-guide-prefill-fields [catblog]:  https://www.docusign.com/blog/developers/common-api-tasks-customize-your-envelopes-pre-fill-fields
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PrefillTabs implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'prefillTabs';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'checkbox_tabs' => '\DocuSign\eSign\Model\Checkbox[]',
        'date_tabs' => '\DocuSign\eSign\Model\Date[]',
        'email_tabs' => '\DocuSign\eSign\Model\Email[]',
        'number_tabs' => '\DocuSign\eSign\Model\Number[]',
        'radio_group_tabs' => '\DocuSign\eSign\Model\RadioGroup[]',
        'sender_company_tabs' => '\DocuSign\eSign\Model\SenderCompany[]',
        'sender_name_tabs' => '\DocuSign\eSign\Model\SenderName[]',
        'ssn_tabs' => '\DocuSign\eSign\Model\Ssn[]',
        'tab_groups' => '\DocuSign\eSign\Model\TabGroup[]',
        'text_tabs' => '\DocuSign\eSign\Model\Text[]',
        'zip_tabs' => '\DocuSign\eSign\Model\Zip[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'checkbox_tabs' => null,
        'date_tabs' => null,
        'email_tabs' => null,
        'number_tabs' => null,
        'radio_group_tabs' => null,
        'sender_company_tabs' => null,
        'sender_name_tabs' => null,
        'ssn_tabs' => null,
        'tab_groups' => null,
        'text_tabs' => null,
        'zip_tabs' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'checkbox_tabs' => 'checkboxTabs',
        'date_tabs' => 'dateTabs',
        'email_tabs' => 'emailTabs',
        'number_tabs' => 'numberTabs',
        'radio_group_tabs' => 'radioGroupTabs',
        'sender_company_tabs' => 'senderCompanyTabs',
        'sender_name_tabs' => 'senderNameTabs',
        'ssn_tabs' => 'ssnTabs',
        'tab_groups' => 'tabGroups',
        'text_tabs' => 'textTabs',
        'zip_tabs' => 'zipTabs'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'checkbox_tabs' => 'setCheckboxTabs',
        'date_tabs' => 'setDateTabs',
        'email_tabs' => 'setEmailTabs',
        'number_tabs' => 'setNumberTabs',
        'radio_group_tabs' => 'setRadioGroupTabs',
        'sender_company_tabs' => 'setSenderCompanyTabs',
        'sender_name_tabs' => 'setSenderNameTabs',
        'ssn_tabs' => 'setSsnTabs',
        'tab_groups' => 'setTabGroups',
        'text_tabs' => 'setTextTabs',
        'zip_tabs' => 'setZipTabs'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'checkbox_tabs' => 'getCheckboxTabs',
        'date_tabs' => 'getDateTabs',
        'email_tabs' => 'getEmailTabs',
        'number_tabs' => 'getNumberTabs',
        'radio_group_tabs' => 'getRadioGroupTabs',
        'sender_company_tabs' => 'getSenderCompanyTabs',
        'sender_name_tabs' => 'getSenderNameTabs',
        'ssn_tabs' => 'getSsnTabs',
        'tab_groups' => 'getTabGroups',
        'text_tabs' => 'getTextTabs',
        'zip_tabs' => 'getZipTabs'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['checkbox_tabs'] = isset($data['checkbox_tabs']) ? $data['checkbox_tabs'] : null;
        $this->container['date_tabs'] = isset($data['date_tabs']) ? $data['date_tabs'] : null;
        $this->container['email_tabs'] = isset($data['email_tabs']) ? $data['email_tabs'] : null;
        $this->container['number_tabs'] = isset($data['number_tabs']) ? $data['number_tabs'] : null;
        $this->container['radio_group_tabs'] = isset($data['radio_group_tabs']) ? $data['radio_group_tabs'] : null;
        $this->container['sender_company_tabs'] = isset($data['sender_company_tabs']) ? $data['sender_company_tabs'] : null;
        $this->container['sender_name_tabs'] = isset($data['sender_name_tabs']) ? $data['sender_name_tabs'] : null;
        $this->container['ssn_tabs'] = isset($data['ssn_tabs']) ? $data['ssn_tabs'] : null;
        $this->container['tab_groups'] = isset($data['tab_groups']) ? $data['tab_groups'] : null;
        $this->container['text_tabs'] = isset($data['text_tabs']) ? $data['text_tabs'] : null;
        $this->container['zip_tabs'] = isset($data['zip_tabs']) ? $data['zip_tabs'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets checkbox_tabs
     *
     * @return \DocuSign\eSign\Model\Checkbox[]
     */
    public function getCheckboxTabs()
    {
        return $this->container['checkbox_tabs'];
    }

    /**
     * Sets checkbox_tabs
     *
     * @param \DocuSign\eSign\Model\Checkbox[] $checkbox_tabs Specifies a tag on the document in a location where the recipient can select an option.
     *
     * @return $this
     */
    public function setCheckboxTabs($checkbox_tabs)
    {
        $this->container['checkbox_tabs'] = $checkbox_tabs;

        return $this;
    }

    /**
     * Gets date_tabs
     *
     * @return \DocuSign\eSign\Model\Date[]
     */
    public function getDateTabs()
    {
        return $this->container['date_tabs'];
    }

    /**
     * Sets date_tabs
     *
     * @param \DocuSign\eSign\Model\Date[] $date_tabs Specifies a tab on the document where you want the recipient to enter a date. Date tabs are single-line fields that allow date information to be entered in any format. The tooltip for this tab recommends entering the date as MM/DD/YYYY, but this is not enforced. The format entered by the signer is retained.   If you need a particular date format enforced, DocuSign recommends using a Text tab with a Validation Pattern and Validation Message to enforce the format.
     *
     * @return $this
     */
    public function setDateTabs($date_tabs)
    {
        $this->container['date_tabs'] = $date_tabs;

        return $this;
    }

    /**
     * Gets email_tabs
     *
     * @return \DocuSign\eSign\Model\Email[]
     */
    public function getEmailTabs()
    {
        return $this->container['email_tabs'];
    }

    /**
     * Sets email_tabs
     *
     * @param \DocuSign\eSign\Model\Email[] $email_tabs Specifies a tag on the document where you want the recipient to enter an email. Email tags are single-line fields that accept any characters. The system checks that a valid email format (i.e. xxx@yyy.zzz) is entered in the tag. It uses the same parameters as a Text tab, with the validation message and pattern set for email information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.
     *
     * @return $this
     */
    public function setEmailTabs($email_tabs)
    {
        $this->container['email_tabs'] = $email_tabs;

        return $this;
    }

    /**
     * Gets number_tabs
     *
     * @return \DocuSign\eSign\Model\Number[]
     */
    public function getNumberTabs()
    {
        return $this->container['number_tabs'];
    }

    /**
     * Sets number_tabs
     *
     * @param \DocuSign\eSign\Model\Number[] $number_tabs Specifies a tag on the document where you want the recipient to enter a number. It uses the same parameters as a Text tab, with the validation message and pattern set for number information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.
     *
     * @return $this
     */
    public function setNumberTabs($number_tabs)
    {
        $this->container['number_tabs'] = $number_tabs;

        return $this;
    }

    /**
     * Gets radio_group_tabs
     *
     * @return \DocuSign\eSign\Model\RadioGroup[]
     */
    public function getRadioGroupTabs()
    {
        return $this->container['radio_group_tabs'];
    }

    /**
     * Sets radio_group_tabs
     *
     * @param \DocuSign\eSign\Model\RadioGroup[] $radio_group_tabs Specifies a tag on the document in a location where the recipient can select one option from a group of options using a radio button. The radio buttons do not have to be on the same page in a document.
     *
     * @return $this
     */
    public function setRadioGroupTabs($radio_group_tabs)
    {
        $this->container['radio_group_tabs'] = $radio_group_tabs;

        return $this;
    }

    /**
     * Gets sender_company_tabs
     *
     * @return \DocuSign\eSign\Model\SenderCompany[]
     */
    public function getSenderCompanyTabs()
    {
        return $this->container['sender_company_tabs'];
    }

    /**
     * Sets sender_company_tabs
     *
     * @param \DocuSign\eSign\Model\SenderCompany[] $sender_company_tabs 
     *
     * @return $this
     */
    public function setSenderCompanyTabs($sender_company_tabs)
    {
        $this->container['sender_company_tabs'] = $sender_company_tabs;

        return $this;
    }

    /**
     * Gets sender_name_tabs
     *
     * @return \DocuSign\eSign\Model\SenderName[]
     */
    public function getSenderNameTabs()
    {
        return $this->container['sender_name_tabs'];
    }

    /**
     * Sets sender_name_tabs
     *
     * @param \DocuSign\eSign\Model\SenderName[] $sender_name_tabs 
     *
     * @return $this
     */
    public function setSenderNameTabs($sender_name_tabs)
    {
        $this->container['sender_name_tabs'] = $sender_name_tabs;

        return $this;
    }

    /**
     * Gets ssn_tabs
     *
     * @return \DocuSign\eSign\Model\Ssn[]
     */
    public function getSsnTabs()
    {
        return $this->container['ssn_tabs'];
    }

    /**
     * Sets ssn_tabs
     *
     * @param \DocuSign\eSign\Model\Ssn[] $ssn_tabs Specifies a tag on the document where you want the recipient to enter a Social Security Number (SSN). A SSN can be typed with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for SSN information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.
     *
     * @return $this
     */
    public function setSsnTabs($ssn_tabs)
    {
        $this->container['ssn_tabs'] = $ssn_tabs;

        return $this;
    }

    /**
     * Gets tab_groups
     *
     * @return \DocuSign\eSign\Model\TabGroup[]
     */
    public function getTabGroups()
    {
        return $this->container['tab_groups'];
    }

    /**
     * Sets tab_groups
     *
     * @param \DocuSign\eSign\Model\TabGroup[] $tab_groups 
     *
     * @return $this
     */
    public function setTabGroups($tab_groups)
    {
        $this->container['tab_groups'] = $tab_groups;

        return $this;
    }

    /**
     * Gets text_tabs
     *
     * @return \DocuSign\eSign\Model\Text[]
     */
    public function getTextTabs()
    {
        return $this->container['text_tabs'];
    }

    /**
     * Sets text_tabs
     *
     * @param \DocuSign\eSign\Model\Text[] $text_tabs Specifies a that that is an adaptable field that allows the recipient to enter different text information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.
     *
     * @return $this
     */
    public function setTextTabs($text_tabs)
    {
        $this->container['text_tabs'] = $text_tabs;

        return $this;
    }

    /**
     * Gets zip_tabs
     *
     * @return \DocuSign\eSign\Model\Zip[]
     */
    public function getZipTabs()
    {
        return $this->container['zip_tabs'];
    }

    /**
     * Sets zip_tabs
     *
     * @param \DocuSign\eSign\Model\Zip[] $zip_tabs Specifies a tag on the document where you want the recipient to enter a ZIP code. The ZIP code can be a five numbers or the ZIP+4 format with nine numbers. The zip code can be typed with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for ZIP code information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.
     *
     * @return $this
     */
    public function setZipTabs($zip_tabs)
    {
        $this->container['zip_tabs'] = $zip_tabs;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

