<?php
/**
 * UserSettingsInformation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * UserSettingsInformation Class Doc Comment
 *
 * @category    Class
 * @description Properties that configure the settings for a user. Some elements of this object have a &#x60;metadata&#x60; property, which includes the following: - &#x60;rights&#x60;: The calling users permissions to edit this setting (can be &#x60;editable&#x60; or &#x60;read_only&#x60;) - &#x60;uiHint&#x60;: Internally used to build UIs (can be &#x60;available&#x60; or &#x60;hidden&#x60;) - &#x60;options&#x60;: The values supported for this setting (not all settings have this element)
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserSettingsInformation implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'userSettingsInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'account_management_granular' => '\DocuSign\eSign\Model\UserAccountManagementGranularInformation',
        'admin_only' => '?string',
        'admin_only_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_auto_tagging' => '?string',
        'allow_envelope_transfer_to' => '?string',
        'allow_envelope_transfer_to_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_eseal_recipients' => '?string',
        'allow_eseal_recipients_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelope' => '?string',
        'allow_power_forms_admin_to_access_all_power_form_envelope_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_recipient_language_selection' => '?string',
        'allow_recipient_language_selection_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_send_on_behalf_of' => '?string',
        'allow_send_on_behalf_of_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_supplemental_documents' => '?string',
        'allow_supplemental_documents_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'anchor_tag_versioned_placement_enabled' => '?string',
        'api_account_wide_access' => '?string',
        'api_account_wide_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'api_can_export_ac' => '?string',
        'api_can_export_ac_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'bulk_send' => '?string',
        'bulk_send_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_charge_account' => '?string',
        'can_charge_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_edit_shared_addressbook' => '?string',
        'can_edit_shared_addressbook_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_lock_envelopes' => '?string',
        'can_lock_envelopes_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_manage_account' => '?string',
        'can_manage_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_manage_distributor' => '?string',
        'can_manage_distributor_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_manage_templates' => '?string',
        'can_manage_templates_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_send_api_requests' => '?string',
        'can_send_api_requests_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_send_envelope' => '?string',
        'can_send_envelope_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_send_envelopes_via_sms' => '?string',
        'can_send_envelopes_via_sms_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_sign_envelope' => '?string',
        'can_sign_envelope_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_use_scratchpad' => '?string',
        'can_use_scratchpad_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_use_smart_contracts' => '?string',
        'can_use_smart_contracts_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_document_upload' => '?string',
        'disable_document_upload_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_other_actions' => '?string',
        'disable_other_actions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_ds_pro' => '?string',
        'enable_ds_pro_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_key_terms_suggestions_by_document_type' => '?string',
        'enable_key_terms_suggestions_by_document_type_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sequential_signing_api' => '?string',
        'enable_sequential_signing_api_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sequential_signing_ui' => '?string',
        'enable_sequential_signing_ui_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_signer_attachments' => '?string',
        'enable_signer_attachments_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sign_on_paper_override' => '?string',
        'enable_sign_on_paper_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_transaction_point' => '?string',
        'enable_transaction_point_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_vaulting' => '?string',
        'enable_vaulting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'express_send_only' => '?string',
        'locale' => '?string',
        'locale_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'locale_policy' => '\DocuSign\eSign\Model\LocalePolicy',
        'manage_clickwraps_mode' => '?string',
        'manage_clickwraps_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'modified_by' => '?string',
        'modified_by_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'modified_date' => '?string',
        'modified_date_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'modified_page' => '?string',
        'modified_page_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'new_send_ui' => '?string',
        'new_send_ui_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'power_form_mode' => '?string',
        'power_form_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'recipient_viewed_notification' => '?string',
        'recipient_viewed_notification_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'seal_identifiers' => '\DocuSign\eSign\Model\SealIdentifier[]',
        'self_signed_recipient_email_document' => '?string',
        'self_signed_recipient_email_document_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sender_email_notifications' => '\DocuSign\eSign\Model\SenderEmailNotifications',
        'signer_email_notifications' => '\DocuSign\eSign\Model\SignerEmailNotifications',
        'supplemental_document_include_in_download' => '?string',
        'supplemental_documents_must_accept' => '?string',
        'supplemental_documents_must_accept_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_read' => '?string',
        'supplemental_documents_must_read_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_view' => '?string',
        'supplemental_documents_must_view_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'template_active_creation' => '?string',
        'template_active_creation_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'template_apply_notify' => '?string',
        'template_apply_notify_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'template_auto_matching' => '?string',
        'template_auto_matching_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'template_matching_sensitivity' => '?string',
        'template_matching_sensitivity_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'template_page_level_matching' => '?string',
        'template_page_level_matching_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'timezone_dst' => '?string',
        'timezone_dst_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'timezone_mask' => '?string',
        'timezone_mask_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'timezone_offset' => '?string',
        'timezone_offset_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'timezone_sending_pref' => '?string',
        'timezone_sending_pref_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'timezone_signing_pref' => '?string',
        'timezone_signing_pref_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'transaction_point_site_name_url' => '?string',
        'transaction_point_site_name_url_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'transaction_point_user_name' => '?string',
        'transaction_point_user_name_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'vaulting_mode' => '?string',
        'vaulting_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'web_forms' => '?string',
        'web_forms_metadata' => '\DocuSign\eSign\Model\SettingsMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'account_management_granular' => null,
        'admin_only' => null,
        'admin_only_metadata' => null,
        'allow_auto_tagging' => null,
        'allow_envelope_transfer_to' => null,
        'allow_envelope_transfer_to_metadata' => null,
        'allow_eseal_recipients' => null,
        'allow_eseal_recipients_metadata' => null,
        'allow_power_forms_admin_to_access_all_power_form_envelope' => null,
        'allow_power_forms_admin_to_access_all_power_form_envelope_metadata' => null,
        'allow_recipient_language_selection' => null,
        'allow_recipient_language_selection_metadata' => null,
        'allow_send_on_behalf_of' => null,
        'allow_send_on_behalf_of_metadata' => null,
        'allow_supplemental_documents' => null,
        'allow_supplemental_documents_metadata' => null,
        'anchor_tag_versioned_placement_enabled' => null,
        'api_account_wide_access' => null,
        'api_account_wide_access_metadata' => null,
        'api_can_export_ac' => null,
        'api_can_export_ac_metadata' => null,
        'bulk_send' => null,
        'bulk_send_metadata' => null,
        'can_charge_account' => null,
        'can_charge_account_metadata' => null,
        'can_edit_shared_addressbook' => null,
        'can_edit_shared_addressbook_metadata' => null,
        'can_lock_envelopes' => null,
        'can_lock_envelopes_metadata' => null,
        'can_manage_account' => null,
        'can_manage_account_metadata' => null,
        'can_manage_distributor' => null,
        'can_manage_distributor_metadata' => null,
        'can_manage_templates' => null,
        'can_manage_templates_metadata' => null,
        'can_send_api_requests' => null,
        'can_send_api_requests_metadata' => null,
        'can_send_envelope' => null,
        'can_send_envelope_metadata' => null,
        'can_send_envelopes_via_sms' => null,
        'can_send_envelopes_via_sms_metadata' => null,
        'can_sign_envelope' => null,
        'can_sign_envelope_metadata' => null,
        'can_use_scratchpad' => null,
        'can_use_scratchpad_metadata' => null,
        'can_use_smart_contracts' => null,
        'can_use_smart_contracts_metadata' => null,
        'disable_document_upload' => null,
        'disable_document_upload_metadata' => null,
        'disable_other_actions' => null,
        'disable_other_actions_metadata' => null,
        'enable_ds_pro' => null,
        'enable_ds_pro_metadata' => null,
        'enable_key_terms_suggestions_by_document_type' => null,
        'enable_key_terms_suggestions_by_document_type_metadata' => null,
        'enable_sequential_signing_api' => null,
        'enable_sequential_signing_api_metadata' => null,
        'enable_sequential_signing_ui' => null,
        'enable_sequential_signing_ui_metadata' => null,
        'enable_signer_attachments' => null,
        'enable_signer_attachments_metadata' => null,
        'enable_sign_on_paper_override' => null,
        'enable_sign_on_paper_override_metadata' => null,
        'enable_transaction_point' => null,
        'enable_transaction_point_metadata' => null,
        'enable_vaulting' => null,
        'enable_vaulting_metadata' => null,
        'express_send_only' => null,
        'locale' => null,
        'locale_metadata' => null,
        'locale_policy' => null,
        'manage_clickwraps_mode' => null,
        'manage_clickwraps_mode_metadata' => null,
        'modified_by' => null,
        'modified_by_metadata' => null,
        'modified_date' => null,
        'modified_date_metadata' => null,
        'modified_page' => null,
        'modified_page_metadata' => null,
        'new_send_ui' => null,
        'new_send_ui_metadata' => null,
        'power_form_mode' => null,
        'power_form_mode_metadata' => null,
        'recipient_viewed_notification' => null,
        'recipient_viewed_notification_metadata' => null,
        'seal_identifiers' => null,
        'self_signed_recipient_email_document' => null,
        'self_signed_recipient_email_document_metadata' => null,
        'sender_email_notifications' => null,
        'signer_email_notifications' => null,
        'supplemental_document_include_in_download' => null,
        'supplemental_documents_must_accept' => null,
        'supplemental_documents_must_accept_metadata' => null,
        'supplemental_documents_must_read' => null,
        'supplemental_documents_must_read_metadata' => null,
        'supplemental_documents_must_view' => null,
        'supplemental_documents_must_view_metadata' => null,
        'template_active_creation' => null,
        'template_active_creation_metadata' => null,
        'template_apply_notify' => null,
        'template_apply_notify_metadata' => null,
        'template_auto_matching' => null,
        'template_auto_matching_metadata' => null,
        'template_matching_sensitivity' => null,
        'template_matching_sensitivity_metadata' => null,
        'template_page_level_matching' => null,
        'template_page_level_matching_metadata' => null,
        'timezone_dst' => null,
        'timezone_dst_metadata' => null,
        'timezone_mask' => null,
        'timezone_mask_metadata' => null,
        'timezone_offset' => null,
        'timezone_offset_metadata' => null,
        'timezone_sending_pref' => null,
        'timezone_sending_pref_metadata' => null,
        'timezone_signing_pref' => null,
        'timezone_signing_pref_metadata' => null,
        'transaction_point_site_name_url' => null,
        'transaction_point_site_name_url_metadata' => null,
        'transaction_point_user_name' => null,
        'transaction_point_user_name_metadata' => null,
        'vaulting_mode' => null,
        'vaulting_mode_metadata' => null,
        'web_forms' => null,
        'web_forms_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account_management_granular' => 'accountManagementGranular',
        'admin_only' => 'adminOnly',
        'admin_only_metadata' => 'adminOnlyMetadata',
        'allow_auto_tagging' => 'allowAutoTagging',
        'allow_envelope_transfer_to' => 'allowEnvelopeTransferTo',
        'allow_envelope_transfer_to_metadata' => 'allowEnvelopeTransferToMetadata',
        'allow_eseal_recipients' => 'allowEsealRecipients',
        'allow_eseal_recipients_metadata' => 'allowEsealRecipientsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelope' => 'allowPowerFormsAdminToAccessAllPowerFormEnvelope',
        'allow_power_forms_admin_to_access_all_power_form_envelope_metadata' => 'allowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata',
        'allow_recipient_language_selection' => 'allowRecipientLanguageSelection',
        'allow_recipient_language_selection_metadata' => 'allowRecipientLanguageSelectionMetadata',
        'allow_send_on_behalf_of' => 'allowSendOnBehalfOf',
        'allow_send_on_behalf_of_metadata' => 'allowSendOnBehalfOfMetadata',
        'allow_supplemental_documents' => 'allowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'allowSupplementalDocumentsMetadata',
        'anchor_tag_versioned_placement_enabled' => 'anchorTagVersionedPlacementEnabled',
        'api_account_wide_access' => 'apiAccountWideAccess',
        'api_account_wide_access_metadata' => 'apiAccountWideAccessMetadata',
        'api_can_export_ac' => 'apiCanExportAC',
        'api_can_export_ac_metadata' => 'apiCanExportACMetadata',
        'bulk_send' => 'bulkSend',
        'bulk_send_metadata' => 'bulkSendMetadata',
        'can_charge_account' => 'canChargeAccount',
        'can_charge_account_metadata' => 'canChargeAccountMetadata',
        'can_edit_shared_addressbook' => 'canEditSharedAddressbook',
        'can_edit_shared_addressbook_metadata' => 'canEditSharedAddressbookMetadata',
        'can_lock_envelopes' => 'canLockEnvelopes',
        'can_lock_envelopes_metadata' => 'canLockEnvelopesMetadata',
        'can_manage_account' => 'canManageAccount',
        'can_manage_account_metadata' => 'canManageAccountMetadata',
        'can_manage_distributor' => 'canManageDistributor',
        'can_manage_distributor_metadata' => 'canManageDistributorMetadata',
        'can_manage_templates' => 'canManageTemplates',
        'can_manage_templates_metadata' => 'canManageTemplatesMetadata',
        'can_send_api_requests' => 'canSendAPIRequests',
        'can_send_api_requests_metadata' => 'canSendAPIRequestsMetadata',
        'can_send_envelope' => 'canSendEnvelope',
        'can_send_envelope_metadata' => 'canSendEnvelopeMetadata',
        'can_send_envelopes_via_sms' => 'canSendEnvelopesViaSMS',
        'can_send_envelopes_via_sms_metadata' => 'canSendEnvelopesViaSMSMetadata',
        'can_sign_envelope' => 'canSignEnvelope',
        'can_sign_envelope_metadata' => 'canSignEnvelopeMetadata',
        'can_use_scratchpad' => 'canUseScratchpad',
        'can_use_scratchpad_metadata' => 'canUseScratchpadMetadata',
        'can_use_smart_contracts' => 'canUseSmartContracts',
        'can_use_smart_contracts_metadata' => 'canUseSmartContractsMetadata',
        'disable_document_upload' => 'disableDocumentUpload',
        'disable_document_upload_metadata' => 'disableDocumentUploadMetadata',
        'disable_other_actions' => 'disableOtherActions',
        'disable_other_actions_metadata' => 'disableOtherActionsMetadata',
        'enable_ds_pro' => 'enableDSPro',
        'enable_ds_pro_metadata' => 'enableDSProMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'enableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'enableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_sequential_signing_api' => 'enableSequentialSigningAPI',
        'enable_sequential_signing_api_metadata' => 'enableSequentialSigningAPIMetadata',
        'enable_sequential_signing_ui' => 'enableSequentialSigningUI',
        'enable_sequential_signing_ui_metadata' => 'enableSequentialSigningUIMetadata',
        'enable_signer_attachments' => 'enableSignerAttachments',
        'enable_signer_attachments_metadata' => 'enableSignerAttachmentsMetadata',
        'enable_sign_on_paper_override' => 'enableSignOnPaperOverride',
        'enable_sign_on_paper_override_metadata' => 'enableSignOnPaperOverrideMetadata',
        'enable_transaction_point' => 'enableTransactionPoint',
        'enable_transaction_point_metadata' => 'enableTransactionPointMetadata',
        'enable_vaulting' => 'enableVaulting',
        'enable_vaulting_metadata' => 'enableVaultingMetadata',
        'express_send_only' => 'expressSendOnly',
        'locale' => 'locale',
        'locale_metadata' => 'localeMetadata',
        'locale_policy' => 'localePolicy',
        'manage_clickwraps_mode' => 'manageClickwrapsMode',
        'manage_clickwraps_mode_metadata' => 'manageClickwrapsModeMetadata',
        'modified_by' => 'modifiedBy',
        'modified_by_metadata' => 'modifiedByMetadata',
        'modified_date' => 'modifiedDate',
        'modified_date_metadata' => 'modifiedDateMetadata',
        'modified_page' => 'modifiedPage',
        'modified_page_metadata' => 'modifiedPageMetadata',
        'new_send_ui' => 'newSendUI',
        'new_send_ui_metadata' => 'newSendUIMetadata',
        'power_form_mode' => 'powerFormMode',
        'power_form_mode_metadata' => 'powerFormModeMetadata',
        'recipient_viewed_notification' => 'recipientViewedNotification',
        'recipient_viewed_notification_metadata' => 'recipientViewedNotificationMetadata',
        'seal_identifiers' => 'sealIdentifiers',
        'self_signed_recipient_email_document' => 'selfSignedRecipientEmailDocument',
        'self_signed_recipient_email_document_metadata' => 'selfSignedRecipientEmailDocumentMetadata',
        'sender_email_notifications' => 'senderEmailNotifications',
        'signer_email_notifications' => 'signerEmailNotifications',
        'supplemental_document_include_in_download' => 'supplementalDocumentIncludeInDownload',
        'supplemental_documents_must_accept' => 'supplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'supplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'supplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'supplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'supplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'supplementalDocumentsMustViewMetadata',
        'template_active_creation' => 'templateActiveCreation',
        'template_active_creation_metadata' => 'templateActiveCreationMetadata',
        'template_apply_notify' => 'templateApplyNotify',
        'template_apply_notify_metadata' => 'templateApplyNotifyMetadata',
        'template_auto_matching' => 'templateAutoMatching',
        'template_auto_matching_metadata' => 'templateAutoMatchingMetadata',
        'template_matching_sensitivity' => 'templateMatchingSensitivity',
        'template_matching_sensitivity_metadata' => 'templateMatchingSensitivityMetadata',
        'template_page_level_matching' => 'templatePageLevelMatching',
        'template_page_level_matching_metadata' => 'templatePageLevelMatchingMetadata',
        'timezone_dst' => 'timezoneDST',
        'timezone_dst_metadata' => 'timezoneDSTMetadata',
        'timezone_mask' => 'timezoneMask',
        'timezone_mask_metadata' => 'timezoneMaskMetadata',
        'timezone_offset' => 'timezoneOffset',
        'timezone_offset_metadata' => 'timezoneOffsetMetadata',
        'timezone_sending_pref' => 'timezoneSendingPref',
        'timezone_sending_pref_metadata' => 'timezoneSendingPrefMetadata',
        'timezone_signing_pref' => 'timezoneSigningPref',
        'timezone_signing_pref_metadata' => 'timezoneSigningPrefMetadata',
        'transaction_point_site_name_url' => 'transactionPointSiteNameURL',
        'transaction_point_site_name_url_metadata' => 'transactionPointSiteNameURLMetadata',
        'transaction_point_user_name' => 'transactionPointUserName',
        'transaction_point_user_name_metadata' => 'transactionPointUserNameMetadata',
        'vaulting_mode' => 'vaultingMode',
        'vaulting_mode_metadata' => 'vaultingModeMetadata',
        'web_forms' => 'webForms',
        'web_forms_metadata' => 'webFormsMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account_management_granular' => 'setAccountManagementGranular',
        'admin_only' => 'setAdminOnly',
        'admin_only_metadata' => 'setAdminOnlyMetadata',
        'allow_auto_tagging' => 'setAllowAutoTagging',
        'allow_envelope_transfer_to' => 'setAllowEnvelopeTransferTo',
        'allow_envelope_transfer_to_metadata' => 'setAllowEnvelopeTransferToMetadata',
        'allow_eseal_recipients' => 'setAllowEsealRecipients',
        'allow_eseal_recipients_metadata' => 'setAllowEsealRecipientsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelope' => 'setAllowPowerFormsAdminToAccessAllPowerFormEnvelope',
        'allow_power_forms_admin_to_access_all_power_form_envelope_metadata' => 'setAllowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata',
        'allow_recipient_language_selection' => 'setAllowRecipientLanguageSelection',
        'allow_recipient_language_selection_metadata' => 'setAllowRecipientLanguageSelectionMetadata',
        'allow_send_on_behalf_of' => 'setAllowSendOnBehalfOf',
        'allow_send_on_behalf_of_metadata' => 'setAllowSendOnBehalfOfMetadata',
        'allow_supplemental_documents' => 'setAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'setAllowSupplementalDocumentsMetadata',
        'anchor_tag_versioned_placement_enabled' => 'setAnchorTagVersionedPlacementEnabled',
        'api_account_wide_access' => 'setApiAccountWideAccess',
        'api_account_wide_access_metadata' => 'setApiAccountWideAccessMetadata',
        'api_can_export_ac' => 'setApiCanExportAc',
        'api_can_export_ac_metadata' => 'setApiCanExportAcMetadata',
        'bulk_send' => 'setBulkSend',
        'bulk_send_metadata' => 'setBulkSendMetadata',
        'can_charge_account' => 'setCanChargeAccount',
        'can_charge_account_metadata' => 'setCanChargeAccountMetadata',
        'can_edit_shared_addressbook' => 'setCanEditSharedAddressbook',
        'can_edit_shared_addressbook_metadata' => 'setCanEditSharedAddressbookMetadata',
        'can_lock_envelopes' => 'setCanLockEnvelopes',
        'can_lock_envelopes_metadata' => 'setCanLockEnvelopesMetadata',
        'can_manage_account' => 'setCanManageAccount',
        'can_manage_account_metadata' => 'setCanManageAccountMetadata',
        'can_manage_distributor' => 'setCanManageDistributor',
        'can_manage_distributor_metadata' => 'setCanManageDistributorMetadata',
        'can_manage_templates' => 'setCanManageTemplates',
        'can_manage_templates_metadata' => 'setCanManageTemplatesMetadata',
        'can_send_api_requests' => 'setCanSendApiRequests',
        'can_send_api_requests_metadata' => 'setCanSendApiRequestsMetadata',
        'can_send_envelope' => 'setCanSendEnvelope',
        'can_send_envelope_metadata' => 'setCanSendEnvelopeMetadata',
        'can_send_envelopes_via_sms' => 'setCanSendEnvelopesViaSms',
        'can_send_envelopes_via_sms_metadata' => 'setCanSendEnvelopesViaSmsMetadata',
        'can_sign_envelope' => 'setCanSignEnvelope',
        'can_sign_envelope_metadata' => 'setCanSignEnvelopeMetadata',
        'can_use_scratchpad' => 'setCanUseScratchpad',
        'can_use_scratchpad_metadata' => 'setCanUseScratchpadMetadata',
        'can_use_smart_contracts' => 'setCanUseSmartContracts',
        'can_use_smart_contracts_metadata' => 'setCanUseSmartContractsMetadata',
        'disable_document_upload' => 'setDisableDocumentUpload',
        'disable_document_upload_metadata' => 'setDisableDocumentUploadMetadata',
        'disable_other_actions' => 'setDisableOtherActions',
        'disable_other_actions_metadata' => 'setDisableOtherActionsMetadata',
        'enable_ds_pro' => 'setEnableDsPro',
        'enable_ds_pro_metadata' => 'setEnableDsProMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'setEnableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'setEnableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_sequential_signing_api' => 'setEnableSequentialSigningApi',
        'enable_sequential_signing_api_metadata' => 'setEnableSequentialSigningApiMetadata',
        'enable_sequential_signing_ui' => 'setEnableSequentialSigningUi',
        'enable_sequential_signing_ui_metadata' => 'setEnableSequentialSigningUiMetadata',
        'enable_signer_attachments' => 'setEnableSignerAttachments',
        'enable_signer_attachments_metadata' => 'setEnableSignerAttachmentsMetadata',
        'enable_sign_on_paper_override' => 'setEnableSignOnPaperOverride',
        'enable_sign_on_paper_override_metadata' => 'setEnableSignOnPaperOverrideMetadata',
        'enable_transaction_point' => 'setEnableTransactionPoint',
        'enable_transaction_point_metadata' => 'setEnableTransactionPointMetadata',
        'enable_vaulting' => 'setEnableVaulting',
        'enable_vaulting_metadata' => 'setEnableVaultingMetadata',
        'express_send_only' => 'setExpressSendOnly',
        'locale' => 'setLocale',
        'locale_metadata' => 'setLocaleMetadata',
        'locale_policy' => 'setLocalePolicy',
        'manage_clickwraps_mode' => 'setManageClickwrapsMode',
        'manage_clickwraps_mode_metadata' => 'setManageClickwrapsModeMetadata',
        'modified_by' => 'setModifiedBy',
        'modified_by_metadata' => 'setModifiedByMetadata',
        'modified_date' => 'setModifiedDate',
        'modified_date_metadata' => 'setModifiedDateMetadata',
        'modified_page' => 'setModifiedPage',
        'modified_page_metadata' => 'setModifiedPageMetadata',
        'new_send_ui' => 'setNewSendUi',
        'new_send_ui_metadata' => 'setNewSendUiMetadata',
        'power_form_mode' => 'setPowerFormMode',
        'power_form_mode_metadata' => 'setPowerFormModeMetadata',
        'recipient_viewed_notification' => 'setRecipientViewedNotification',
        'recipient_viewed_notification_metadata' => 'setRecipientViewedNotificationMetadata',
        'seal_identifiers' => 'setSealIdentifiers',
        'self_signed_recipient_email_document' => 'setSelfSignedRecipientEmailDocument',
        'self_signed_recipient_email_document_metadata' => 'setSelfSignedRecipientEmailDocumentMetadata',
        'sender_email_notifications' => 'setSenderEmailNotifications',
        'signer_email_notifications' => 'setSignerEmailNotifications',
        'supplemental_document_include_in_download' => 'setSupplementalDocumentIncludeInDownload',
        'supplemental_documents_must_accept' => 'setSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'setSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'setSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'setSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'setSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'setSupplementalDocumentsMustViewMetadata',
        'template_active_creation' => 'setTemplateActiveCreation',
        'template_active_creation_metadata' => 'setTemplateActiveCreationMetadata',
        'template_apply_notify' => 'setTemplateApplyNotify',
        'template_apply_notify_metadata' => 'setTemplateApplyNotifyMetadata',
        'template_auto_matching' => 'setTemplateAutoMatching',
        'template_auto_matching_metadata' => 'setTemplateAutoMatchingMetadata',
        'template_matching_sensitivity' => 'setTemplateMatchingSensitivity',
        'template_matching_sensitivity_metadata' => 'setTemplateMatchingSensitivityMetadata',
        'template_page_level_matching' => 'setTemplatePageLevelMatching',
        'template_page_level_matching_metadata' => 'setTemplatePageLevelMatchingMetadata',
        'timezone_dst' => 'setTimezoneDst',
        'timezone_dst_metadata' => 'setTimezoneDstMetadata',
        'timezone_mask' => 'setTimezoneMask',
        'timezone_mask_metadata' => 'setTimezoneMaskMetadata',
        'timezone_offset' => 'setTimezoneOffset',
        'timezone_offset_metadata' => 'setTimezoneOffsetMetadata',
        'timezone_sending_pref' => 'setTimezoneSendingPref',
        'timezone_sending_pref_metadata' => 'setTimezoneSendingPrefMetadata',
        'timezone_signing_pref' => 'setTimezoneSigningPref',
        'timezone_signing_pref_metadata' => 'setTimezoneSigningPrefMetadata',
        'transaction_point_site_name_url' => 'setTransactionPointSiteNameUrl',
        'transaction_point_site_name_url_metadata' => 'setTransactionPointSiteNameUrlMetadata',
        'transaction_point_user_name' => 'setTransactionPointUserName',
        'transaction_point_user_name_metadata' => 'setTransactionPointUserNameMetadata',
        'vaulting_mode' => 'setVaultingMode',
        'vaulting_mode_metadata' => 'setVaultingModeMetadata',
        'web_forms' => 'setWebForms',
        'web_forms_metadata' => 'setWebFormsMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account_management_granular' => 'getAccountManagementGranular',
        'admin_only' => 'getAdminOnly',
        'admin_only_metadata' => 'getAdminOnlyMetadata',
        'allow_auto_tagging' => 'getAllowAutoTagging',
        'allow_envelope_transfer_to' => 'getAllowEnvelopeTransferTo',
        'allow_envelope_transfer_to_metadata' => 'getAllowEnvelopeTransferToMetadata',
        'allow_eseal_recipients' => 'getAllowEsealRecipients',
        'allow_eseal_recipients_metadata' => 'getAllowEsealRecipientsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelope' => 'getAllowPowerFormsAdminToAccessAllPowerFormEnvelope',
        'allow_power_forms_admin_to_access_all_power_form_envelope_metadata' => 'getAllowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata',
        'allow_recipient_language_selection' => 'getAllowRecipientLanguageSelection',
        'allow_recipient_language_selection_metadata' => 'getAllowRecipientLanguageSelectionMetadata',
        'allow_send_on_behalf_of' => 'getAllowSendOnBehalfOf',
        'allow_send_on_behalf_of_metadata' => 'getAllowSendOnBehalfOfMetadata',
        'allow_supplemental_documents' => 'getAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'getAllowSupplementalDocumentsMetadata',
        'anchor_tag_versioned_placement_enabled' => 'getAnchorTagVersionedPlacementEnabled',
        'api_account_wide_access' => 'getApiAccountWideAccess',
        'api_account_wide_access_metadata' => 'getApiAccountWideAccessMetadata',
        'api_can_export_ac' => 'getApiCanExportAc',
        'api_can_export_ac_metadata' => 'getApiCanExportAcMetadata',
        'bulk_send' => 'getBulkSend',
        'bulk_send_metadata' => 'getBulkSendMetadata',
        'can_charge_account' => 'getCanChargeAccount',
        'can_charge_account_metadata' => 'getCanChargeAccountMetadata',
        'can_edit_shared_addressbook' => 'getCanEditSharedAddressbook',
        'can_edit_shared_addressbook_metadata' => 'getCanEditSharedAddressbookMetadata',
        'can_lock_envelopes' => 'getCanLockEnvelopes',
        'can_lock_envelopes_metadata' => 'getCanLockEnvelopesMetadata',
        'can_manage_account' => 'getCanManageAccount',
        'can_manage_account_metadata' => 'getCanManageAccountMetadata',
        'can_manage_distributor' => 'getCanManageDistributor',
        'can_manage_distributor_metadata' => 'getCanManageDistributorMetadata',
        'can_manage_templates' => 'getCanManageTemplates',
        'can_manage_templates_metadata' => 'getCanManageTemplatesMetadata',
        'can_send_api_requests' => 'getCanSendApiRequests',
        'can_send_api_requests_metadata' => 'getCanSendApiRequestsMetadata',
        'can_send_envelope' => 'getCanSendEnvelope',
        'can_send_envelope_metadata' => 'getCanSendEnvelopeMetadata',
        'can_send_envelopes_via_sms' => 'getCanSendEnvelopesViaSms',
        'can_send_envelopes_via_sms_metadata' => 'getCanSendEnvelopesViaSmsMetadata',
        'can_sign_envelope' => 'getCanSignEnvelope',
        'can_sign_envelope_metadata' => 'getCanSignEnvelopeMetadata',
        'can_use_scratchpad' => 'getCanUseScratchpad',
        'can_use_scratchpad_metadata' => 'getCanUseScratchpadMetadata',
        'can_use_smart_contracts' => 'getCanUseSmartContracts',
        'can_use_smart_contracts_metadata' => 'getCanUseSmartContractsMetadata',
        'disable_document_upload' => 'getDisableDocumentUpload',
        'disable_document_upload_metadata' => 'getDisableDocumentUploadMetadata',
        'disable_other_actions' => 'getDisableOtherActions',
        'disable_other_actions_metadata' => 'getDisableOtherActionsMetadata',
        'enable_ds_pro' => 'getEnableDsPro',
        'enable_ds_pro_metadata' => 'getEnableDsProMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'getEnableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'getEnableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_sequential_signing_api' => 'getEnableSequentialSigningApi',
        'enable_sequential_signing_api_metadata' => 'getEnableSequentialSigningApiMetadata',
        'enable_sequential_signing_ui' => 'getEnableSequentialSigningUi',
        'enable_sequential_signing_ui_metadata' => 'getEnableSequentialSigningUiMetadata',
        'enable_signer_attachments' => 'getEnableSignerAttachments',
        'enable_signer_attachments_metadata' => 'getEnableSignerAttachmentsMetadata',
        'enable_sign_on_paper_override' => 'getEnableSignOnPaperOverride',
        'enable_sign_on_paper_override_metadata' => 'getEnableSignOnPaperOverrideMetadata',
        'enable_transaction_point' => 'getEnableTransactionPoint',
        'enable_transaction_point_metadata' => 'getEnableTransactionPointMetadata',
        'enable_vaulting' => 'getEnableVaulting',
        'enable_vaulting_metadata' => 'getEnableVaultingMetadata',
        'express_send_only' => 'getExpressSendOnly',
        'locale' => 'getLocale',
        'locale_metadata' => 'getLocaleMetadata',
        'locale_policy' => 'getLocalePolicy',
        'manage_clickwraps_mode' => 'getManageClickwrapsMode',
        'manage_clickwraps_mode_metadata' => 'getManageClickwrapsModeMetadata',
        'modified_by' => 'getModifiedBy',
        'modified_by_metadata' => 'getModifiedByMetadata',
        'modified_date' => 'getModifiedDate',
        'modified_date_metadata' => 'getModifiedDateMetadata',
        'modified_page' => 'getModifiedPage',
        'modified_page_metadata' => 'getModifiedPageMetadata',
        'new_send_ui' => 'getNewSendUi',
        'new_send_ui_metadata' => 'getNewSendUiMetadata',
        'power_form_mode' => 'getPowerFormMode',
        'power_form_mode_metadata' => 'getPowerFormModeMetadata',
        'recipient_viewed_notification' => 'getRecipientViewedNotification',
        'recipient_viewed_notification_metadata' => 'getRecipientViewedNotificationMetadata',
        'seal_identifiers' => 'getSealIdentifiers',
        'self_signed_recipient_email_document' => 'getSelfSignedRecipientEmailDocument',
        'self_signed_recipient_email_document_metadata' => 'getSelfSignedRecipientEmailDocumentMetadata',
        'sender_email_notifications' => 'getSenderEmailNotifications',
        'signer_email_notifications' => 'getSignerEmailNotifications',
        'supplemental_document_include_in_download' => 'getSupplementalDocumentIncludeInDownload',
        'supplemental_documents_must_accept' => 'getSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'getSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'getSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'getSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'getSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'getSupplementalDocumentsMustViewMetadata',
        'template_active_creation' => 'getTemplateActiveCreation',
        'template_active_creation_metadata' => 'getTemplateActiveCreationMetadata',
        'template_apply_notify' => 'getTemplateApplyNotify',
        'template_apply_notify_metadata' => 'getTemplateApplyNotifyMetadata',
        'template_auto_matching' => 'getTemplateAutoMatching',
        'template_auto_matching_metadata' => 'getTemplateAutoMatchingMetadata',
        'template_matching_sensitivity' => 'getTemplateMatchingSensitivity',
        'template_matching_sensitivity_metadata' => 'getTemplateMatchingSensitivityMetadata',
        'template_page_level_matching' => 'getTemplatePageLevelMatching',
        'template_page_level_matching_metadata' => 'getTemplatePageLevelMatchingMetadata',
        'timezone_dst' => 'getTimezoneDst',
        'timezone_dst_metadata' => 'getTimezoneDstMetadata',
        'timezone_mask' => 'getTimezoneMask',
        'timezone_mask_metadata' => 'getTimezoneMaskMetadata',
        'timezone_offset' => 'getTimezoneOffset',
        'timezone_offset_metadata' => 'getTimezoneOffsetMetadata',
        'timezone_sending_pref' => 'getTimezoneSendingPref',
        'timezone_sending_pref_metadata' => 'getTimezoneSendingPrefMetadata',
        'timezone_signing_pref' => 'getTimezoneSigningPref',
        'timezone_signing_pref_metadata' => 'getTimezoneSigningPrefMetadata',
        'transaction_point_site_name_url' => 'getTransactionPointSiteNameUrl',
        'transaction_point_site_name_url_metadata' => 'getTransactionPointSiteNameUrlMetadata',
        'transaction_point_user_name' => 'getTransactionPointUserName',
        'transaction_point_user_name_metadata' => 'getTransactionPointUserNameMetadata',
        'vaulting_mode' => 'getVaultingMode',
        'vaulting_mode_metadata' => 'getVaultingModeMetadata',
        'web_forms' => 'getWebForms',
        'web_forms_metadata' => 'getWebFormsMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account_management_granular'] = isset($data['account_management_granular']) ? $data['account_management_granular'] : null;
        $this->container['admin_only'] = isset($data['admin_only']) ? $data['admin_only'] : null;
        $this->container['admin_only_metadata'] = isset($data['admin_only_metadata']) ? $data['admin_only_metadata'] : null;
        $this->container['allow_auto_tagging'] = isset($data['allow_auto_tagging']) ? $data['allow_auto_tagging'] : null;
        $this->container['allow_envelope_transfer_to'] = isset($data['allow_envelope_transfer_to']) ? $data['allow_envelope_transfer_to'] : null;
        $this->container['allow_envelope_transfer_to_metadata'] = isset($data['allow_envelope_transfer_to_metadata']) ? $data['allow_envelope_transfer_to_metadata'] : null;
        $this->container['allow_eseal_recipients'] = isset($data['allow_eseal_recipients']) ? $data['allow_eseal_recipients'] : null;
        $this->container['allow_eseal_recipients_metadata'] = isset($data['allow_eseal_recipients_metadata']) ? $data['allow_eseal_recipients_metadata'] : null;
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelope'] = isset($data['allow_power_forms_admin_to_access_all_power_form_envelope']) ? $data['allow_power_forms_admin_to_access_all_power_form_envelope'] : null;
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelope_metadata'] = isset($data['allow_power_forms_admin_to_access_all_power_form_envelope_metadata']) ? $data['allow_power_forms_admin_to_access_all_power_form_envelope_metadata'] : null;
        $this->container['allow_recipient_language_selection'] = isset($data['allow_recipient_language_selection']) ? $data['allow_recipient_language_selection'] : null;
        $this->container['allow_recipient_language_selection_metadata'] = isset($data['allow_recipient_language_selection_metadata']) ? $data['allow_recipient_language_selection_metadata'] : null;
        $this->container['allow_send_on_behalf_of'] = isset($data['allow_send_on_behalf_of']) ? $data['allow_send_on_behalf_of'] : null;
        $this->container['allow_send_on_behalf_of_metadata'] = isset($data['allow_send_on_behalf_of_metadata']) ? $data['allow_send_on_behalf_of_metadata'] : null;
        $this->container['allow_supplemental_documents'] = isset($data['allow_supplemental_documents']) ? $data['allow_supplemental_documents'] : null;
        $this->container['allow_supplemental_documents_metadata'] = isset($data['allow_supplemental_documents_metadata']) ? $data['allow_supplemental_documents_metadata'] : null;
        $this->container['anchor_tag_versioned_placement_enabled'] = isset($data['anchor_tag_versioned_placement_enabled']) ? $data['anchor_tag_versioned_placement_enabled'] : null;
        $this->container['api_account_wide_access'] = isset($data['api_account_wide_access']) ? $data['api_account_wide_access'] : null;
        $this->container['api_account_wide_access_metadata'] = isset($data['api_account_wide_access_metadata']) ? $data['api_account_wide_access_metadata'] : null;
        $this->container['api_can_export_ac'] = isset($data['api_can_export_ac']) ? $data['api_can_export_ac'] : null;
        $this->container['api_can_export_ac_metadata'] = isset($data['api_can_export_ac_metadata']) ? $data['api_can_export_ac_metadata'] : null;
        $this->container['bulk_send'] = isset($data['bulk_send']) ? $data['bulk_send'] : null;
        $this->container['bulk_send_metadata'] = isset($data['bulk_send_metadata']) ? $data['bulk_send_metadata'] : null;
        $this->container['can_charge_account'] = isset($data['can_charge_account']) ? $data['can_charge_account'] : null;
        $this->container['can_charge_account_metadata'] = isset($data['can_charge_account_metadata']) ? $data['can_charge_account_metadata'] : null;
        $this->container['can_edit_shared_addressbook'] = isset($data['can_edit_shared_addressbook']) ? $data['can_edit_shared_addressbook'] : null;
        $this->container['can_edit_shared_addressbook_metadata'] = isset($data['can_edit_shared_addressbook_metadata']) ? $data['can_edit_shared_addressbook_metadata'] : null;
        $this->container['can_lock_envelopes'] = isset($data['can_lock_envelopes']) ? $data['can_lock_envelopes'] : null;
        $this->container['can_lock_envelopes_metadata'] = isset($data['can_lock_envelopes_metadata']) ? $data['can_lock_envelopes_metadata'] : null;
        $this->container['can_manage_account'] = isset($data['can_manage_account']) ? $data['can_manage_account'] : null;
        $this->container['can_manage_account_metadata'] = isset($data['can_manage_account_metadata']) ? $data['can_manage_account_metadata'] : null;
        $this->container['can_manage_distributor'] = isset($data['can_manage_distributor']) ? $data['can_manage_distributor'] : null;
        $this->container['can_manage_distributor_metadata'] = isset($data['can_manage_distributor_metadata']) ? $data['can_manage_distributor_metadata'] : null;
        $this->container['can_manage_templates'] = isset($data['can_manage_templates']) ? $data['can_manage_templates'] : null;
        $this->container['can_manage_templates_metadata'] = isset($data['can_manage_templates_metadata']) ? $data['can_manage_templates_metadata'] : null;
        $this->container['can_send_api_requests'] = isset($data['can_send_api_requests']) ? $data['can_send_api_requests'] : null;
        $this->container['can_send_api_requests_metadata'] = isset($data['can_send_api_requests_metadata']) ? $data['can_send_api_requests_metadata'] : null;
        $this->container['can_send_envelope'] = isset($data['can_send_envelope']) ? $data['can_send_envelope'] : null;
        $this->container['can_send_envelope_metadata'] = isset($data['can_send_envelope_metadata']) ? $data['can_send_envelope_metadata'] : null;
        $this->container['can_send_envelopes_via_sms'] = isset($data['can_send_envelopes_via_sms']) ? $data['can_send_envelopes_via_sms'] : null;
        $this->container['can_send_envelopes_via_sms_metadata'] = isset($data['can_send_envelopes_via_sms_metadata']) ? $data['can_send_envelopes_via_sms_metadata'] : null;
        $this->container['can_sign_envelope'] = isset($data['can_sign_envelope']) ? $data['can_sign_envelope'] : null;
        $this->container['can_sign_envelope_metadata'] = isset($data['can_sign_envelope_metadata']) ? $data['can_sign_envelope_metadata'] : null;
        $this->container['can_use_scratchpad'] = isset($data['can_use_scratchpad']) ? $data['can_use_scratchpad'] : null;
        $this->container['can_use_scratchpad_metadata'] = isset($data['can_use_scratchpad_metadata']) ? $data['can_use_scratchpad_metadata'] : null;
        $this->container['can_use_smart_contracts'] = isset($data['can_use_smart_contracts']) ? $data['can_use_smart_contracts'] : null;
        $this->container['can_use_smart_contracts_metadata'] = isset($data['can_use_smart_contracts_metadata']) ? $data['can_use_smart_contracts_metadata'] : null;
        $this->container['disable_document_upload'] = isset($data['disable_document_upload']) ? $data['disable_document_upload'] : null;
        $this->container['disable_document_upload_metadata'] = isset($data['disable_document_upload_metadata']) ? $data['disable_document_upload_metadata'] : null;
        $this->container['disable_other_actions'] = isset($data['disable_other_actions']) ? $data['disable_other_actions'] : null;
        $this->container['disable_other_actions_metadata'] = isset($data['disable_other_actions_metadata']) ? $data['disable_other_actions_metadata'] : null;
        $this->container['enable_ds_pro'] = isset($data['enable_ds_pro']) ? $data['enable_ds_pro'] : null;
        $this->container['enable_ds_pro_metadata'] = isset($data['enable_ds_pro_metadata']) ? $data['enable_ds_pro_metadata'] : null;
        $this->container['enable_key_terms_suggestions_by_document_type'] = isset($data['enable_key_terms_suggestions_by_document_type']) ? $data['enable_key_terms_suggestions_by_document_type'] : null;
        $this->container['enable_key_terms_suggestions_by_document_type_metadata'] = isset($data['enable_key_terms_suggestions_by_document_type_metadata']) ? $data['enable_key_terms_suggestions_by_document_type_metadata'] : null;
        $this->container['enable_sequential_signing_api'] = isset($data['enable_sequential_signing_api']) ? $data['enable_sequential_signing_api'] : null;
        $this->container['enable_sequential_signing_api_metadata'] = isset($data['enable_sequential_signing_api_metadata']) ? $data['enable_sequential_signing_api_metadata'] : null;
        $this->container['enable_sequential_signing_ui'] = isset($data['enable_sequential_signing_ui']) ? $data['enable_sequential_signing_ui'] : null;
        $this->container['enable_sequential_signing_ui_metadata'] = isset($data['enable_sequential_signing_ui_metadata']) ? $data['enable_sequential_signing_ui_metadata'] : null;
        $this->container['enable_signer_attachments'] = isset($data['enable_signer_attachments']) ? $data['enable_signer_attachments'] : null;
        $this->container['enable_signer_attachments_metadata'] = isset($data['enable_signer_attachments_metadata']) ? $data['enable_signer_attachments_metadata'] : null;
        $this->container['enable_sign_on_paper_override'] = isset($data['enable_sign_on_paper_override']) ? $data['enable_sign_on_paper_override'] : null;
        $this->container['enable_sign_on_paper_override_metadata'] = isset($data['enable_sign_on_paper_override_metadata']) ? $data['enable_sign_on_paper_override_metadata'] : null;
        $this->container['enable_transaction_point'] = isset($data['enable_transaction_point']) ? $data['enable_transaction_point'] : null;
        $this->container['enable_transaction_point_metadata'] = isset($data['enable_transaction_point_metadata']) ? $data['enable_transaction_point_metadata'] : null;
        $this->container['enable_vaulting'] = isset($data['enable_vaulting']) ? $data['enable_vaulting'] : null;
        $this->container['enable_vaulting_metadata'] = isset($data['enable_vaulting_metadata']) ? $data['enable_vaulting_metadata'] : null;
        $this->container['express_send_only'] = isset($data['express_send_only']) ? $data['express_send_only'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['locale_metadata'] = isset($data['locale_metadata']) ? $data['locale_metadata'] : null;
        $this->container['locale_policy'] = isset($data['locale_policy']) ? $data['locale_policy'] : null;
        $this->container['manage_clickwraps_mode'] = isset($data['manage_clickwraps_mode']) ? $data['manage_clickwraps_mode'] : null;
        $this->container['manage_clickwraps_mode_metadata'] = isset($data['manage_clickwraps_mode_metadata']) ? $data['manage_clickwraps_mode_metadata'] : null;
        $this->container['modified_by'] = isset($data['modified_by']) ? $data['modified_by'] : null;
        $this->container['modified_by_metadata'] = isset($data['modified_by_metadata']) ? $data['modified_by_metadata'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
        $this->container['modified_date_metadata'] = isset($data['modified_date_metadata']) ? $data['modified_date_metadata'] : null;
        $this->container['modified_page'] = isset($data['modified_page']) ? $data['modified_page'] : null;
        $this->container['modified_page_metadata'] = isset($data['modified_page_metadata']) ? $data['modified_page_metadata'] : null;
        $this->container['new_send_ui'] = isset($data['new_send_ui']) ? $data['new_send_ui'] : null;
        $this->container['new_send_ui_metadata'] = isset($data['new_send_ui_metadata']) ? $data['new_send_ui_metadata'] : null;
        $this->container['power_form_mode'] = isset($data['power_form_mode']) ? $data['power_form_mode'] : null;
        $this->container['power_form_mode_metadata'] = isset($data['power_form_mode_metadata']) ? $data['power_form_mode_metadata'] : null;
        $this->container['recipient_viewed_notification'] = isset($data['recipient_viewed_notification']) ? $data['recipient_viewed_notification'] : null;
        $this->container['recipient_viewed_notification_metadata'] = isset($data['recipient_viewed_notification_metadata']) ? $data['recipient_viewed_notification_metadata'] : null;
        $this->container['seal_identifiers'] = isset($data['seal_identifiers']) ? $data['seal_identifiers'] : null;
        $this->container['self_signed_recipient_email_document'] = isset($data['self_signed_recipient_email_document']) ? $data['self_signed_recipient_email_document'] : null;
        $this->container['self_signed_recipient_email_document_metadata'] = isset($data['self_signed_recipient_email_document_metadata']) ? $data['self_signed_recipient_email_document_metadata'] : null;
        $this->container['sender_email_notifications'] = isset($data['sender_email_notifications']) ? $data['sender_email_notifications'] : null;
        $this->container['signer_email_notifications'] = isset($data['signer_email_notifications']) ? $data['signer_email_notifications'] : null;
        $this->container['supplemental_document_include_in_download'] = isset($data['supplemental_document_include_in_download']) ? $data['supplemental_document_include_in_download'] : null;
        $this->container['supplemental_documents_must_accept'] = isset($data['supplemental_documents_must_accept']) ? $data['supplemental_documents_must_accept'] : null;
        $this->container['supplemental_documents_must_accept_metadata'] = isset($data['supplemental_documents_must_accept_metadata']) ? $data['supplemental_documents_must_accept_metadata'] : null;
        $this->container['supplemental_documents_must_read'] = isset($data['supplemental_documents_must_read']) ? $data['supplemental_documents_must_read'] : null;
        $this->container['supplemental_documents_must_read_metadata'] = isset($data['supplemental_documents_must_read_metadata']) ? $data['supplemental_documents_must_read_metadata'] : null;
        $this->container['supplemental_documents_must_view'] = isset($data['supplemental_documents_must_view']) ? $data['supplemental_documents_must_view'] : null;
        $this->container['supplemental_documents_must_view_metadata'] = isset($data['supplemental_documents_must_view_metadata']) ? $data['supplemental_documents_must_view_metadata'] : null;
        $this->container['template_active_creation'] = isset($data['template_active_creation']) ? $data['template_active_creation'] : null;
        $this->container['template_active_creation_metadata'] = isset($data['template_active_creation_metadata']) ? $data['template_active_creation_metadata'] : null;
        $this->container['template_apply_notify'] = isset($data['template_apply_notify']) ? $data['template_apply_notify'] : null;
        $this->container['template_apply_notify_metadata'] = isset($data['template_apply_notify_metadata']) ? $data['template_apply_notify_metadata'] : null;
        $this->container['template_auto_matching'] = isset($data['template_auto_matching']) ? $data['template_auto_matching'] : null;
        $this->container['template_auto_matching_metadata'] = isset($data['template_auto_matching_metadata']) ? $data['template_auto_matching_metadata'] : null;
        $this->container['template_matching_sensitivity'] = isset($data['template_matching_sensitivity']) ? $data['template_matching_sensitivity'] : null;
        $this->container['template_matching_sensitivity_metadata'] = isset($data['template_matching_sensitivity_metadata']) ? $data['template_matching_sensitivity_metadata'] : null;
        $this->container['template_page_level_matching'] = isset($data['template_page_level_matching']) ? $data['template_page_level_matching'] : null;
        $this->container['template_page_level_matching_metadata'] = isset($data['template_page_level_matching_metadata']) ? $data['template_page_level_matching_metadata'] : null;
        $this->container['timezone_dst'] = isset($data['timezone_dst']) ? $data['timezone_dst'] : null;
        $this->container['timezone_dst_metadata'] = isset($data['timezone_dst_metadata']) ? $data['timezone_dst_metadata'] : null;
        $this->container['timezone_mask'] = isset($data['timezone_mask']) ? $data['timezone_mask'] : null;
        $this->container['timezone_mask_metadata'] = isset($data['timezone_mask_metadata']) ? $data['timezone_mask_metadata'] : null;
        $this->container['timezone_offset'] = isset($data['timezone_offset']) ? $data['timezone_offset'] : null;
        $this->container['timezone_offset_metadata'] = isset($data['timezone_offset_metadata']) ? $data['timezone_offset_metadata'] : null;
        $this->container['timezone_sending_pref'] = isset($data['timezone_sending_pref']) ? $data['timezone_sending_pref'] : null;
        $this->container['timezone_sending_pref_metadata'] = isset($data['timezone_sending_pref_metadata']) ? $data['timezone_sending_pref_metadata'] : null;
        $this->container['timezone_signing_pref'] = isset($data['timezone_signing_pref']) ? $data['timezone_signing_pref'] : null;
        $this->container['timezone_signing_pref_metadata'] = isset($data['timezone_signing_pref_metadata']) ? $data['timezone_signing_pref_metadata'] : null;
        $this->container['transaction_point_site_name_url'] = isset($data['transaction_point_site_name_url']) ? $data['transaction_point_site_name_url'] : null;
        $this->container['transaction_point_site_name_url_metadata'] = isset($data['transaction_point_site_name_url_metadata']) ? $data['transaction_point_site_name_url_metadata'] : null;
        $this->container['transaction_point_user_name'] = isset($data['transaction_point_user_name']) ? $data['transaction_point_user_name'] : null;
        $this->container['transaction_point_user_name_metadata'] = isset($data['transaction_point_user_name_metadata']) ? $data['transaction_point_user_name_metadata'] : null;
        $this->container['vaulting_mode'] = isset($data['vaulting_mode']) ? $data['vaulting_mode'] : null;
        $this->container['vaulting_mode_metadata'] = isset($data['vaulting_mode_metadata']) ? $data['vaulting_mode_metadata'] : null;
        $this->container['web_forms'] = isset($data['web_forms']) ? $data['web_forms'] : null;
        $this->container['web_forms_metadata'] = isset($data['web_forms_metadata']) ? $data['web_forms_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets account_management_granular
     *
     * @return \DocuSign\eSign\Model\UserAccountManagementGranularInformation
     */
    public function getAccountManagementGranular()
    {
        return $this->container['account_management_granular'];
    }

    /**
     * Sets account_management_granular
     *
     * @param \DocuSign\eSign\Model\UserAccountManagementGranularInformation $account_management_granular Describes which account management capabilities a user has.
     *
     * @return $this
     */
    public function setAccountManagementGranular($account_management_granular)
    {
        $this->container['account_management_granular'] = $account_management_granular;

        return $this;
    }

    /**
     * Gets admin_only
     *
     * @return ?string
     */
    public function getAdminOnly()
    {
        return $this->container['admin_only'];
    }

    /**
     * Sets admin_only
     *
     * param null|string $admin_only 
     *
     * @return $this
     */
    public function setAdminOnly($admin_only)
    {
        $this->container['admin_only'] = $admin_only;

        return $this;
    }

    /**
     * Gets admin_only_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAdminOnlyMetadata()
    {
        return $this->container['admin_only_metadata'];
    }

    /**
     * Sets admin_only_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $admin_only_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setAdminOnlyMetadata($admin_only_metadata)
    {
        $this->container['admin_only_metadata'] = $admin_only_metadata;

        return $this;
    }

    /**
     * Gets allow_auto_tagging
     *
     * @return ?string
     */
    public function getAllowAutoTagging()
    {
        return $this->container['allow_auto_tagging'];
    }

    /**
     * Sets allow_auto_tagging
     *
     * param null|string $allow_auto_tagging 
     *
     * @return $this
     */
    public function setAllowAutoTagging($allow_auto_tagging)
    {
        $this->container['allow_auto_tagging'] = $allow_auto_tagging;

        return $this;
    }

    /**
     * Gets allow_envelope_transfer_to
     *
     * @return ?string
     */
    public function getAllowEnvelopeTransferTo()
    {
        return $this->container['allow_envelope_transfer_to'];
    }

    /**
     * Sets allow_envelope_transfer_to
     *
     * param null|string $allow_envelope_transfer_to 
     *
     * @return $this
     */
    public function setAllowEnvelopeTransferTo($allow_envelope_transfer_to)
    {
        $this->container['allow_envelope_transfer_to'] = $allow_envelope_transfer_to;

        return $this;
    }

    /**
     * Gets allow_envelope_transfer_to_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopeTransferToMetadata()
    {
        return $this->container['allow_envelope_transfer_to_metadata'];
    }

    /**
     * Sets allow_envelope_transfer_to_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_transfer_to_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setAllowEnvelopeTransferToMetadata($allow_envelope_transfer_to_metadata)
    {
        $this->container['allow_envelope_transfer_to_metadata'] = $allow_envelope_transfer_to_metadata;

        return $this;
    }

    /**
     * Gets allow_eseal_recipients
     *
     * @return ?string
     */
    public function getAllowEsealRecipients()
    {
        return $this->container['allow_eseal_recipients'];
    }

    /**
     * Sets allow_eseal_recipients
     *
     * param null|string $allow_eseal_recipients 
     *
     * @return $this
     */
    public function setAllowEsealRecipients($allow_eseal_recipients)
    {
        $this->container['allow_eseal_recipients'] = $allow_eseal_recipients;

        return $this;
    }

    /**
     * Gets allow_eseal_recipients_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEsealRecipientsMetadata()
    {
        return $this->container['allow_eseal_recipients_metadata'];
    }

    /**
     * Sets allow_eseal_recipients_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_eseal_recipients_metadata Metadata about the `allowEsealRecipientsMetadata` property.
     *
     * @return $this
     */
    public function setAllowEsealRecipientsMetadata($allow_eseal_recipients_metadata)
    {
        $this->container['allow_eseal_recipients_metadata'] = $allow_eseal_recipients_metadata;

        return $this;
    }

    /**
     * Gets allow_power_forms_admin_to_access_all_power_form_envelope
     *
     * @return ?string
     */
    public function getAllowPowerFormsAdminToAccessAllPowerFormEnvelope()
    {
        return $this->container['allow_power_forms_admin_to_access_all_power_form_envelope'];
    }

    /**
     * Sets allow_power_forms_admin_to_access_all_power_form_envelope
     *
     * param null|string $allow_power_forms_admin_to_access_all_power_form_envelope 
     *
     * @return $this
     */
    public function setAllowPowerFormsAdminToAccessAllPowerFormEnvelope($allow_power_forms_admin_to_access_all_power_form_envelope)
    {
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelope'] = $allow_power_forms_admin_to_access_all_power_form_envelope;

        return $this;
    }

    /**
     * Gets allow_power_forms_admin_to_access_all_power_form_envelope_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata()
    {
        return $this->container['allow_power_forms_admin_to_access_all_power_form_envelope_metadata'];
    }

    /**
     * Sets allow_power_forms_admin_to_access_all_power_form_envelope_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_power_forms_admin_to_access_all_power_form_envelope_metadata Metadata about the `allowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata` property.
     *
     * @return $this
     */
    public function setAllowPowerFormsAdminToAccessAllPowerFormEnvelopeMetadata($allow_power_forms_admin_to_access_all_power_form_envelope_metadata)
    {
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelope_metadata'] = $allow_power_forms_admin_to_access_all_power_form_envelope_metadata;

        return $this;
    }

    /**
     * Gets allow_recipient_language_selection
     *
     * @return ?string
     */
    public function getAllowRecipientLanguageSelection()
    {
        return $this->container['allow_recipient_language_selection'];
    }

    /**
     * Sets allow_recipient_language_selection
     *
     * param null|string $allow_recipient_language_selection 
     *
     * @return $this
     */
    public function setAllowRecipientLanguageSelection($allow_recipient_language_selection)
    {
        $this->container['allow_recipient_language_selection'] = $allow_recipient_language_selection;

        return $this;
    }

    /**
     * Gets allow_recipient_language_selection_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowRecipientLanguageSelectionMetadata()
    {
        return $this->container['allow_recipient_language_selection_metadata'];
    }

    /**
     * Sets allow_recipient_language_selection_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_recipient_language_selection_metadata Metadata for allowRecipientLanguageSelection.
     *
     * @return $this
     */
    public function setAllowRecipientLanguageSelectionMetadata($allow_recipient_language_selection_metadata)
    {
        $this->container['allow_recipient_language_selection_metadata'] = $allow_recipient_language_selection_metadata;

        return $this;
    }

    /**
     * Gets allow_send_on_behalf_of
     *
     * @return ?string
     */
    public function getAllowSendOnBehalfOf()
    {
        return $this->container['allow_send_on_behalf_of'];
    }

    /**
     * Sets allow_send_on_behalf_of
     *
     * param null|string $allow_send_on_behalf_of 
     *
     * @return $this
     */
    public function setAllowSendOnBehalfOf($allow_send_on_behalf_of)
    {
        $this->container['allow_send_on_behalf_of'] = $allow_send_on_behalf_of;

        return $this;
    }

    /**
     * Gets allow_send_on_behalf_of_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSendOnBehalfOfMetadata()
    {
        return $this->container['allow_send_on_behalf_of_metadata'];
    }

    /**
     * Sets allow_send_on_behalf_of_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_send_on_behalf_of_metadata Metadata for allowSendOnBehalfOf.
     *
     * @return $this
     */
    public function setAllowSendOnBehalfOfMetadata($allow_send_on_behalf_of_metadata)
    {
        $this->container['allow_send_on_behalf_of_metadata'] = $allow_send_on_behalf_of_metadata;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents
     *
     * @return ?string
     */
    public function getAllowSupplementalDocuments()
    {
        return $this->container['allow_supplemental_documents'];
    }

    /**
     * Sets allow_supplemental_documents
     *
     * param null|string $allow_supplemental_documents 
     *
     * @return $this
     */
    public function setAllowSupplementalDocuments($allow_supplemental_documents)
    {
        $this->container['allow_supplemental_documents'] = $allow_supplemental_documents;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSupplementalDocumentsMetadata()
    {
        return $this->container['allow_supplemental_documents_metadata'];
    }

    /**
     * Sets allow_supplemental_documents_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_supplemental_documents_metadata Metadata that indicates whether the `allowSupplementalDocuments` property is editable.
     *
     * @return $this
     */
    public function setAllowSupplementalDocumentsMetadata($allow_supplemental_documents_metadata)
    {
        $this->container['allow_supplemental_documents_metadata'] = $allow_supplemental_documents_metadata;

        return $this;
    }

    /**
     * Gets anchor_tag_versioned_placement_enabled
     *
     * @return ?string
     */
    public function getAnchorTagVersionedPlacementEnabled()
    {
        return $this->container['anchor_tag_versioned_placement_enabled'];
    }

    /**
     * Sets anchor_tag_versioned_placement_enabled
     *
     * param null|string $anchor_tag_versioned_placement_enabled 
     *
     * @return $this
     */
    public function setAnchorTagVersionedPlacementEnabled($anchor_tag_versioned_placement_enabled)
    {
        $this->container['anchor_tag_versioned_placement_enabled'] = $anchor_tag_versioned_placement_enabled;

        return $this;
    }

    /**
     * Gets api_account_wide_access
     *
     * @return ?string
     */
    public function getApiAccountWideAccess()
    {
        return $this->container['api_account_wide_access'];
    }

    /**
     * Sets api_account_wide_access
     *
     * param null|string $api_account_wide_access 
     *
     * @return $this
     */
    public function setApiAccountWideAccess($api_account_wide_access)
    {
        $this->container['api_account_wide_access'] = $api_account_wide_access;

        return $this;
    }

    /**
     * Gets api_account_wide_access_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getApiAccountWideAccessMetadata()
    {
        return $this->container['api_account_wide_access_metadata'];
    }

    /**
     * Sets api_account_wide_access_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $api_account_wide_access_metadata Metadata for apiAccountWideAccess.
     *
     * @return $this
     */
    public function setApiAccountWideAccessMetadata($api_account_wide_access_metadata)
    {
        $this->container['api_account_wide_access_metadata'] = $api_account_wide_access_metadata;

        return $this;
    }

    /**
     * Gets api_can_export_ac
     *
     * @return ?string
     */
    public function getApiCanExportAc()
    {
        return $this->container['api_can_export_ac'];
    }

    /**
     * Sets api_can_export_ac
     *
     * param null|string $api_can_export_ac 
     *
     * @return $this
     */
    public function setApiCanExportAc($api_can_export_ac)
    {
        $this->container['api_can_export_ac'] = $api_can_export_ac;

        return $this;
    }

    /**
     * Gets api_can_export_ac_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getApiCanExportAcMetadata()
    {
        return $this->container['api_can_export_ac_metadata'];
    }

    /**
     * Sets api_can_export_ac_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $api_can_export_ac_metadata Metadata about the `apiCanExportACMetadata` property.
     *
     * @return $this
     */
    public function setApiCanExportAcMetadata($api_can_export_ac_metadata)
    {
        $this->container['api_can_export_ac_metadata'] = $api_can_export_ac_metadata;

        return $this;
    }

    /**
     * Gets bulk_send
     *
     * @return ?string
     */
    public function getBulkSend()
    {
        return $this->container['bulk_send'];
    }

    /**
     * Sets bulk_send
     *
     * param null|string $bulk_send 
     *
     * @return $this
     */
    public function setBulkSend($bulk_send)
    {
        $this->container['bulk_send'] = $bulk_send;

        return $this;
    }

    /**
     * Gets bulk_send_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getBulkSendMetadata()
    {
        return $this->container['bulk_send_metadata'];
    }

    /**
     * Sets bulk_send_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $bulk_send_metadata Metadata that indicates whether the `bulkSend` property is editable.
     *
     * @return $this
     */
    public function setBulkSendMetadata($bulk_send_metadata)
    {
        $this->container['bulk_send_metadata'] = $bulk_send_metadata;

        return $this;
    }

    /**
     * Gets can_charge_account
     *
     * @return ?string
     */
    public function getCanChargeAccount()
    {
        return $this->container['can_charge_account'];
    }

    /**
     * Sets can_charge_account
     *
     * param null|string $can_charge_account 
     *
     * @return $this
     */
    public function setCanChargeAccount($can_charge_account)
    {
        $this->container['can_charge_account'] = $can_charge_account;

        return $this;
    }

    /**
     * Gets can_charge_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanChargeAccountMetadata()
    {
        return $this->container['can_charge_account_metadata'];
    }

    /**
     * Sets can_charge_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_charge_account_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setCanChargeAccountMetadata($can_charge_account_metadata)
    {
        $this->container['can_charge_account_metadata'] = $can_charge_account_metadata;

        return $this;
    }

    /**
     * Gets can_edit_shared_addressbook
     *
     * @return ?string
     */
    public function getCanEditSharedAddressbook()
    {
        return $this->container['can_edit_shared_addressbook'];
    }

    /**
     * Sets can_edit_shared_addressbook
     *
     * param null|string $can_edit_shared_addressbook 
     *
     * @return $this
     */
    public function setCanEditSharedAddressbook($can_edit_shared_addressbook)
    {
        $this->container['can_edit_shared_addressbook'] = $can_edit_shared_addressbook;

        return $this;
    }

    /**
     * Gets can_edit_shared_addressbook_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanEditSharedAddressbookMetadata()
    {
        return $this->container['can_edit_shared_addressbook_metadata'];
    }

    /**
     * Sets can_edit_shared_addressbook_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_edit_shared_addressbook_metadata Metadata about the `canEditSharedAddressbookMetadata` property.
     *
     * @return $this
     */
    public function setCanEditSharedAddressbookMetadata($can_edit_shared_addressbook_metadata)
    {
        $this->container['can_edit_shared_addressbook_metadata'] = $can_edit_shared_addressbook_metadata;

        return $this;
    }

    /**
     * Gets can_lock_envelopes
     *
     * @return ?string
     */
    public function getCanLockEnvelopes()
    {
        return $this->container['can_lock_envelopes'];
    }

    /**
     * Sets can_lock_envelopes
     *
     * param null|string $can_lock_envelopes 
     *
     * @return $this
     */
    public function setCanLockEnvelopes($can_lock_envelopes)
    {
        $this->container['can_lock_envelopes'] = $can_lock_envelopes;

        return $this;
    }

    /**
     * Gets can_lock_envelopes_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanLockEnvelopesMetadata()
    {
        return $this->container['can_lock_envelopes_metadata'];
    }

    /**
     * Sets can_lock_envelopes_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_lock_envelopes_metadata Metadata about the `canLockEnvelopes` property.
     *
     * @return $this
     */
    public function setCanLockEnvelopesMetadata($can_lock_envelopes_metadata)
    {
        $this->container['can_lock_envelopes_metadata'] = $can_lock_envelopes_metadata;

        return $this;
    }

    /**
     * Gets can_manage_account
     *
     * @return ?string
     */
    public function getCanManageAccount()
    {
        return $this->container['can_manage_account'];
    }

    /**
     * Sets can_manage_account
     *
     * param null|string $can_manage_account 
     *
     * @return $this
     */
    public function setCanManageAccount($can_manage_account)
    {
        $this->container['can_manage_account'] = $can_manage_account;

        return $this;
    }

    /**
     * Gets can_manage_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanManageAccountMetadata()
    {
        return $this->container['can_manage_account_metadata'];
    }

    /**
     * Sets can_manage_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_manage_account_metadata Metadata about the `canManageAccountMetadata` property.
     *
     * @return $this
     */
    public function setCanManageAccountMetadata($can_manage_account_metadata)
    {
        $this->container['can_manage_account_metadata'] = $can_manage_account_metadata;

        return $this;
    }

    /**
     * Gets can_manage_distributor
     *
     * @return ?string
     */
    public function getCanManageDistributor()
    {
        return $this->container['can_manage_distributor'];
    }

    /**
     * Sets can_manage_distributor
     *
     * param null|string $can_manage_distributor 
     *
     * @return $this
     */
    public function setCanManageDistributor($can_manage_distributor)
    {
        $this->container['can_manage_distributor'] = $can_manage_distributor;

        return $this;
    }

    /**
     * Gets can_manage_distributor_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanManageDistributorMetadata()
    {
        return $this->container['can_manage_distributor_metadata'];
    }

    /**
     * Sets can_manage_distributor_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_manage_distributor_metadata Metadata about the `canManageDistributor` property.
     *
     * @return $this
     */
    public function setCanManageDistributorMetadata($can_manage_distributor_metadata)
    {
        $this->container['can_manage_distributor_metadata'] = $can_manage_distributor_metadata;

        return $this;
    }

    /**
     * Gets can_manage_templates
     *
     * @return ?string
     */
    public function getCanManageTemplates()
    {
        return $this->container['can_manage_templates'];
    }

    /**
     * Sets can_manage_templates
     *
     * param null|string $can_manage_templates 
     *
     * @return $this
     */
    public function setCanManageTemplates($can_manage_templates)
    {
        $this->container['can_manage_templates'] = $can_manage_templates;

        return $this;
    }

    /**
     * Gets can_manage_templates_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanManageTemplatesMetadata()
    {
        return $this->container['can_manage_templates_metadata'];
    }

    /**
     * Sets can_manage_templates_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_manage_templates_metadata Metadata about the `canManageTemplates` property.
     *
     * @return $this
     */
    public function setCanManageTemplatesMetadata($can_manage_templates_metadata)
    {
        $this->container['can_manage_templates_metadata'] = $can_manage_templates_metadata;

        return $this;
    }

    /**
     * Gets can_send_api_requests
     *
     * @return ?string
     */
    public function getCanSendApiRequests()
    {
        return $this->container['can_send_api_requests'];
    }

    /**
     * Sets can_send_api_requests
     *
     * param null|string $can_send_api_requests 
     *
     * @return $this
     */
    public function setCanSendApiRequests($can_send_api_requests)
    {
        $this->container['can_send_api_requests'] = $can_send_api_requests;

        return $this;
    }

    /**
     * Gets can_send_api_requests_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanSendApiRequestsMetadata()
    {
        return $this->container['can_send_api_requests_metadata'];
    }

    /**
     * Sets can_send_api_requests_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_send_api_requests_metadata Metadata about the `canSendAPIRequests` property.
     *
     * @return $this
     */
    public function setCanSendApiRequestsMetadata($can_send_api_requests_metadata)
    {
        $this->container['can_send_api_requests_metadata'] = $can_send_api_requests_metadata;

        return $this;
    }

    /**
     * Gets can_send_envelope
     *
     * @return ?string
     */
    public function getCanSendEnvelope()
    {
        return $this->container['can_send_envelope'];
    }

    /**
     * Sets can_send_envelope
     *
     * param null|string $can_send_envelope 
     *
     * @return $this
     */
    public function setCanSendEnvelope($can_send_envelope)
    {
        $this->container['can_send_envelope'] = $can_send_envelope;

        return $this;
    }

    /**
     * Gets can_send_envelope_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanSendEnvelopeMetadata()
    {
        return $this->container['can_send_envelope_metadata'];
    }

    /**
     * Sets can_send_envelope_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_send_envelope_metadata Metadata about the `canSendEnvelope` property.
     *
     * @return $this
     */
    public function setCanSendEnvelopeMetadata($can_send_envelope_metadata)
    {
        $this->container['can_send_envelope_metadata'] = $can_send_envelope_metadata;

        return $this;
    }

    /**
     * Gets can_send_envelopes_via_sms
     *
     * @return ?string
     */
    public function getCanSendEnvelopesViaSms()
    {
        return $this->container['can_send_envelopes_via_sms'];
    }

    /**
     * Sets can_send_envelopes_via_sms
     *
     * param null|string $can_send_envelopes_via_sms 
     *
     * @return $this
     */
    public function setCanSendEnvelopesViaSms($can_send_envelopes_via_sms)
    {
        $this->container['can_send_envelopes_via_sms'] = $can_send_envelopes_via_sms;

        return $this;
    }

    /**
     * Gets can_send_envelopes_via_sms_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanSendEnvelopesViaSmsMetadata()
    {
        return $this->container['can_send_envelopes_via_sms_metadata'];
    }

    /**
     * Sets can_send_envelopes_via_sms_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_send_envelopes_via_sms_metadata 
     *
     * @return $this
     */
    public function setCanSendEnvelopesViaSmsMetadata($can_send_envelopes_via_sms_metadata)
    {
        $this->container['can_send_envelopes_via_sms_metadata'] = $can_send_envelopes_via_sms_metadata;

        return $this;
    }

    /**
     * Gets can_sign_envelope
     *
     * @return ?string
     */
    public function getCanSignEnvelope()
    {
        return $this->container['can_sign_envelope'];
    }

    /**
     * Sets can_sign_envelope
     *
     * param null|string $can_sign_envelope 
     *
     * @return $this
     */
    public function setCanSignEnvelope($can_sign_envelope)
    {
        $this->container['can_sign_envelope'] = $can_sign_envelope;

        return $this;
    }

    /**
     * Gets can_sign_envelope_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanSignEnvelopeMetadata()
    {
        return $this->container['can_sign_envelope_metadata'];
    }

    /**
     * Sets can_sign_envelope_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_sign_envelope_metadata Metadata about the `canSignEnvelope` property.
     *
     * @return $this
     */
    public function setCanSignEnvelopeMetadata($can_sign_envelope_metadata)
    {
        $this->container['can_sign_envelope_metadata'] = $can_sign_envelope_metadata;

        return $this;
    }

    /**
     * Gets can_use_scratchpad
     *
     * @return ?string
     */
    public function getCanUseScratchpad()
    {
        return $this->container['can_use_scratchpad'];
    }

    /**
     * Sets can_use_scratchpad
     *
     * param null|string $can_use_scratchpad 
     *
     * @return $this
     */
    public function setCanUseScratchpad($can_use_scratchpad)
    {
        $this->container['can_use_scratchpad'] = $can_use_scratchpad;

        return $this;
    }

    /**
     * Gets can_use_scratchpad_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanUseScratchpadMetadata()
    {
        return $this->container['can_use_scratchpad_metadata'];
    }

    /**
     * Sets can_use_scratchpad_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_use_scratchpad_metadata Metadata about the `canUseScratchpad` property.
     *
     * @return $this
     */
    public function setCanUseScratchpadMetadata($can_use_scratchpad_metadata)
    {
        $this->container['can_use_scratchpad_metadata'] = $can_use_scratchpad_metadata;

        return $this;
    }

    /**
     * Gets can_use_smart_contracts
     *
     * @return ?string
     */
    public function getCanUseSmartContracts()
    {
        return $this->container['can_use_smart_contracts'];
    }

    /**
     * Sets can_use_smart_contracts
     *
     * param null|string $can_use_smart_contracts 
     *
     * @return $this
     */
    public function setCanUseSmartContracts($can_use_smart_contracts)
    {
        $this->container['can_use_smart_contracts'] = $can_use_smart_contracts;

        return $this;
    }

    /**
     * Gets can_use_smart_contracts_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanUseSmartContractsMetadata()
    {
        return $this->container['can_use_smart_contracts_metadata'];
    }

    /**
     * Sets can_use_smart_contracts_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_use_smart_contracts_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setCanUseSmartContractsMetadata($can_use_smart_contracts_metadata)
    {
        $this->container['can_use_smart_contracts_metadata'] = $can_use_smart_contracts_metadata;

        return $this;
    }

    /**
     * Gets disable_document_upload
     *
     * @return ?string
     */
    public function getDisableDocumentUpload()
    {
        return $this->container['disable_document_upload'];
    }

    /**
     * Sets disable_document_upload
     *
     * param null|string $disable_document_upload 
     *
     * @return $this
     */
    public function setDisableDocumentUpload($disable_document_upload)
    {
        $this->container['disable_document_upload'] = $disable_document_upload;

        return $this;
    }

    /**
     * Gets disable_document_upload_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableDocumentUploadMetadata()
    {
        return $this->container['disable_document_upload_metadata'];
    }

    /**
     * Sets disable_document_upload_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_document_upload_metadata Metadata that indicates whether the `disableDocumentUpload` property is editable.
     *
     * @return $this
     */
    public function setDisableDocumentUploadMetadata($disable_document_upload_metadata)
    {
        $this->container['disable_document_upload_metadata'] = $disable_document_upload_metadata;

        return $this;
    }

    /**
     * Gets disable_other_actions
     *
     * @return ?string
     */
    public function getDisableOtherActions()
    {
        return $this->container['disable_other_actions'];
    }

    /**
     * Sets disable_other_actions
     *
     * param null|string $disable_other_actions 
     *
     * @return $this
     */
    public function setDisableOtherActions($disable_other_actions)
    {
        $this->container['disable_other_actions'] = $disable_other_actions;

        return $this;
    }

    /**
     * Gets disable_other_actions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableOtherActionsMetadata()
    {
        return $this->container['disable_other_actions_metadata'];
    }

    /**
     * Sets disable_other_actions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_other_actions_metadata Metadata that indicates whether the `disableOtherActions` property is editable.
     *
     * @return $this
     */
    public function setDisableOtherActionsMetadata($disable_other_actions_metadata)
    {
        $this->container['disable_other_actions_metadata'] = $disable_other_actions_metadata;

        return $this;
    }

    /**
     * Gets enable_ds_pro
     *
     * @return ?string
     */
    public function getEnableDsPro()
    {
        return $this->container['enable_ds_pro'];
    }

    /**
     * Sets enable_ds_pro
     *
     * param null|string $enable_ds_pro 
     *
     * @return $this
     */
    public function setEnableDsPro($enable_ds_pro)
    {
        $this->container['enable_ds_pro'] = $enable_ds_pro;

        return $this;
    }

    /**
     * Gets enable_ds_pro_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDsProMetadata()
    {
        return $this->container['enable_ds_pro_metadata'];
    }

    /**
     * Sets enable_ds_pro_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_ds_pro_metadata Metadata that indicates whether the `enableDSPro` property is editable.
     *
     * @return $this
     */
    public function setEnableDsProMetadata($enable_ds_pro_metadata)
    {
        $this->container['enable_ds_pro_metadata'] = $enable_ds_pro_metadata;

        return $this;
    }

    /**
     * Gets enable_key_terms_suggestions_by_document_type
     *
     * @return ?string
     */
    public function getEnableKeyTermsSuggestionsByDocumentType()
    {
        return $this->container['enable_key_terms_suggestions_by_document_type'];
    }

    /**
     * Sets enable_key_terms_suggestions_by_document_type
     *
     * param null|string $enable_key_terms_suggestions_by_document_type 
     *
     * @return $this
     */
    public function setEnableKeyTermsSuggestionsByDocumentType($enable_key_terms_suggestions_by_document_type)
    {
        $this->container['enable_key_terms_suggestions_by_document_type'] = $enable_key_terms_suggestions_by_document_type;

        return $this;
    }

    /**
     * Gets enable_key_terms_suggestions_by_document_type_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableKeyTermsSuggestionsByDocumentTypeMetadata()
    {
        return $this->container['enable_key_terms_suggestions_by_document_type_metadata'];
    }

    /**
     * Sets enable_key_terms_suggestions_by_document_type_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_key_terms_suggestions_by_document_type_metadata 
     *
     * @return $this
     */
    public function setEnableKeyTermsSuggestionsByDocumentTypeMetadata($enable_key_terms_suggestions_by_document_type_metadata)
    {
        $this->container['enable_key_terms_suggestions_by_document_type_metadata'] = $enable_key_terms_suggestions_by_document_type_metadata;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_api
     *
     * @return ?string
     */
    public function getEnableSequentialSigningApi()
    {
        return $this->container['enable_sequential_signing_api'];
    }

    /**
     * Sets enable_sequential_signing_api
     *
     * param null|string $enable_sequential_signing_api 
     *
     * @return $this
     */
    public function setEnableSequentialSigningApi($enable_sequential_signing_api)
    {
        $this->container['enable_sequential_signing_api'] = $enable_sequential_signing_api;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_api_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSequentialSigningApiMetadata()
    {
        return $this->container['enable_sequential_signing_api_metadata'];
    }

    /**
     * Sets enable_sequential_signing_api_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sequential_signing_api_metadata Metadata that indicates whether the `enableSequentialSigningAPI` property is editable.
     *
     * @return $this
     */
    public function setEnableSequentialSigningApiMetadata($enable_sequential_signing_api_metadata)
    {
        $this->container['enable_sequential_signing_api_metadata'] = $enable_sequential_signing_api_metadata;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_ui
     *
     * @return ?string
     */
    public function getEnableSequentialSigningUi()
    {
        return $this->container['enable_sequential_signing_ui'];
    }

    /**
     * Sets enable_sequential_signing_ui
     *
     * param null|string $enable_sequential_signing_ui 
     *
     * @return $this
     */
    public function setEnableSequentialSigningUi($enable_sequential_signing_ui)
    {
        $this->container['enable_sequential_signing_ui'] = $enable_sequential_signing_ui;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_ui_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSequentialSigningUiMetadata()
    {
        return $this->container['enable_sequential_signing_ui_metadata'];
    }

    /**
     * Sets enable_sequential_signing_ui_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sequential_signing_ui_metadata Metadata that indicates whether the `enableSequentialSigningUI` property is editable.
     *
     * @return $this
     */
    public function setEnableSequentialSigningUiMetadata($enable_sequential_signing_ui_metadata)
    {
        $this->container['enable_sequential_signing_ui_metadata'] = $enable_sequential_signing_ui_metadata;

        return $this;
    }

    /**
     * Gets enable_signer_attachments
     *
     * @return ?string
     */
    public function getEnableSignerAttachments()
    {
        return $this->container['enable_signer_attachments'];
    }

    /**
     * Sets enable_signer_attachments
     *
     * param null|string $enable_signer_attachments 
     *
     * @return $this
     */
    public function setEnableSignerAttachments($enable_signer_attachments)
    {
        $this->container['enable_signer_attachments'] = $enable_signer_attachments;

        return $this;
    }

    /**
     * Gets enable_signer_attachments_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSignerAttachmentsMetadata()
    {
        return $this->container['enable_signer_attachments_metadata'];
    }

    /**
     * Sets enable_signer_attachments_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_signer_attachments_metadata Metadata that indicates whether the `enableSignerAttachments` property is editable.
     *
     * @return $this
     */
    public function setEnableSignerAttachmentsMetadata($enable_signer_attachments_metadata)
    {
        $this->container['enable_signer_attachments_metadata'] = $enable_signer_attachments_metadata;

        return $this;
    }

    /**
     * Gets enable_sign_on_paper_override
     *
     * @return ?string
     */
    public function getEnableSignOnPaperOverride()
    {
        return $this->container['enable_sign_on_paper_override'];
    }

    /**
     * Sets enable_sign_on_paper_override
     *
     * param null|string $enable_sign_on_paper_override 
     *
     * @return $this
     */
    public function setEnableSignOnPaperOverride($enable_sign_on_paper_override)
    {
        $this->container['enable_sign_on_paper_override'] = $enable_sign_on_paper_override;

        return $this;
    }

    /**
     * Gets enable_sign_on_paper_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSignOnPaperOverrideMetadata()
    {
        return $this->container['enable_sign_on_paper_override_metadata'];
    }

    /**
     * Sets enable_sign_on_paper_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sign_on_paper_override_metadata Metadata that indicates whether the `enableSignOnPaperOverride` property is editable.
     *
     * @return $this
     */
    public function setEnableSignOnPaperOverrideMetadata($enable_sign_on_paper_override_metadata)
    {
        $this->container['enable_sign_on_paper_override_metadata'] = $enable_sign_on_paper_override_metadata;

        return $this;
    }

    /**
     * Gets enable_transaction_point
     *
     * @return ?string
     */
    public function getEnableTransactionPoint()
    {
        return $this->container['enable_transaction_point'];
    }

    /**
     * Sets enable_transaction_point
     *
     * param null|string $enable_transaction_point 
     *
     * @return $this
     */
    public function setEnableTransactionPoint($enable_transaction_point)
    {
        $this->container['enable_transaction_point'] = $enable_transaction_point;

        return $this;
    }

    /**
     * Gets enable_transaction_point_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableTransactionPointMetadata()
    {
        return $this->container['enable_transaction_point_metadata'];
    }

    /**
     * Sets enable_transaction_point_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_transaction_point_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setEnableTransactionPointMetadata($enable_transaction_point_metadata)
    {
        $this->container['enable_transaction_point_metadata'] = $enable_transaction_point_metadata;

        return $this;
    }

    /**
     * Gets enable_vaulting
     *
     * @return ?string
     */
    public function getEnableVaulting()
    {
        return $this->container['enable_vaulting'];
    }

    /**
     * Sets enable_vaulting
     *
     * param null|string $enable_vaulting 
     *
     * @return $this
     */
    public function setEnableVaulting($enable_vaulting)
    {
        $this->container['enable_vaulting'] = $enable_vaulting;

        return $this;
    }

    /**
     * Gets enable_vaulting_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableVaultingMetadata()
    {
        return $this->container['enable_vaulting_metadata'];
    }

    /**
     * Sets enable_vaulting_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_vaulting_metadata Metadata that indicates whether the `enableVaulting` property is editable.
     *
     * @return $this
     */
    public function setEnableVaultingMetadata($enable_vaulting_metadata)
    {
        $this->container['enable_vaulting_metadata'] = $enable_vaulting_metadata;

        return $this;
    }

    /**
     * Gets express_send_only
     *
     * @return ?string
     */
    public function getExpressSendOnly()
    {
        return $this->container['express_send_only'];
    }

    /**
     * Sets express_send_only
     *
     * param null|string $express_send_only 
     *
     * @return $this
     */
    public function setExpressSendOnly($express_send_only)
    {
        $this->container['express_send_only'] = $express_send_only;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return ?string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * param null|string $locale 
     *
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets locale_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getLocaleMetadata()
    {
        return $this->container['locale_metadata'];
    }

    /**
     * Sets locale_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $locale_metadata Metadata about the `locale` property.
     *
     * @return $this
     */
    public function setLocaleMetadata($locale_metadata)
    {
        $this->container['locale_metadata'] = $locale_metadata;

        return $this;
    }

    /**
     * Gets locale_policy
     *
     * @return \DocuSign\eSign\Model\LocalePolicy
     */
    public function getLocalePolicy()
    {
        return $this->container['locale_policy'];
    }

    /**
     * Sets locale_policy
     *
     * @param \DocuSign\eSign\Model\LocalePolicy $locale_policy Reserved for DocuSign.
     *
     * @return $this
     */
    public function setLocalePolicy($locale_policy)
    {
        $this->container['locale_policy'] = $locale_policy;

        return $this;
    }

    /**
     * Gets manage_clickwraps_mode
     *
     * @return ?string
     */
    public function getManageClickwrapsMode()
    {
        return $this->container['manage_clickwraps_mode'];
    }

    /**
     * Sets manage_clickwraps_mode
     *
     * param null|string $manage_clickwraps_mode 
     *
     * @return $this
     */
    public function setManageClickwrapsMode($manage_clickwraps_mode)
    {
        $this->container['manage_clickwraps_mode'] = $manage_clickwraps_mode;

        return $this;
    }

    /**
     * Gets manage_clickwraps_mode_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getManageClickwrapsModeMetadata()
    {
        return $this->container['manage_clickwraps_mode_metadata'];
    }

    /**
     * Sets manage_clickwraps_mode_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $manage_clickwraps_mode_metadata Metadata about the `manageClickwrapsMode` property.
     *
     * @return $this
     */
    public function setManageClickwrapsModeMetadata($manage_clickwraps_mode_metadata)
    {
        $this->container['manage_clickwraps_mode_metadata'] = $manage_clickwraps_mode_metadata;

        return $this;
    }

    /**
     * Gets modified_by
     *
     * @return ?string
     */
    public function getModifiedBy()
    {
        return $this->container['modified_by'];
    }

    /**
     * Sets modified_by
     *
     * param null|string $modified_by 
     *
     * @return $this
     */
    public function setModifiedBy($modified_by)
    {
        $this->container['modified_by'] = $modified_by;

        return $this;
    }

    /**
     * Gets modified_by_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getModifiedByMetadata()
    {
        return $this->container['modified_by_metadata'];
    }

    /**
     * Sets modified_by_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $modified_by_metadata Metadata about the `modifiedBy` property.
     *
     * @return $this
     */
    public function setModifiedByMetadata($modified_by_metadata)
    {
        $this->container['modified_by_metadata'] = $modified_by_metadata;

        return $this;
    }

    /**
     * Gets modified_date
     *
     * @return ?string
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     *
     * param null|string $modified_date 
     *
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets modified_date_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getModifiedDateMetadata()
    {
        return $this->container['modified_date_metadata'];
    }

    /**
     * Sets modified_date_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $modified_date_metadata Metadata about the `modifiedDate` property.
     *
     * @return $this
     */
    public function setModifiedDateMetadata($modified_date_metadata)
    {
        $this->container['modified_date_metadata'] = $modified_date_metadata;

        return $this;
    }

    /**
     * Gets modified_page
     *
     * @return ?string
     */
    public function getModifiedPage()
    {
        return $this->container['modified_page'];
    }

    /**
     * Sets modified_page
     *
     * param null|string $modified_page 
     *
     * @return $this
     */
    public function setModifiedPage($modified_page)
    {
        $this->container['modified_page'] = $modified_page;

        return $this;
    }

    /**
     * Gets modified_page_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getModifiedPageMetadata()
    {
        return $this->container['modified_page_metadata'];
    }

    /**
     * Sets modified_page_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $modified_page_metadata Metadata about the `modifiedPage` property.
     *
     * @return $this
     */
    public function setModifiedPageMetadata($modified_page_metadata)
    {
        $this->container['modified_page_metadata'] = $modified_page_metadata;

        return $this;
    }

    /**
     * Gets new_send_ui
     *
     * @return ?string
     */
    public function getNewSendUi()
    {
        return $this->container['new_send_ui'];
    }

    /**
     * Sets new_send_ui
     *
     * param null|string $new_send_ui 
     *
     * @return $this
     */
    public function setNewSendUi($new_send_ui)
    {
        $this->container['new_send_ui'] = $new_send_ui;

        return $this;
    }

    /**
     * Gets new_send_ui_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getNewSendUiMetadata()
    {
        return $this->container['new_send_ui_metadata'];
    }

    /**
     * Sets new_send_ui_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $new_send_ui_metadata Metadata about the `newSendUI` property.
     *
     * @return $this
     */
    public function setNewSendUiMetadata($new_send_ui_metadata)
    {
        $this->container['new_send_ui_metadata'] = $new_send_ui_metadata;

        return $this;
    }

    /**
     * Gets power_form_mode
     *
     * @return ?string
     */
    public function getPowerFormMode()
    {
        return $this->container['power_form_mode'];
    }

    /**
     * Sets power_form_mode
     *
     * param null|string $power_form_mode 
     *
     * @return $this
     */
    public function setPowerFormMode($power_form_mode)
    {
        $this->container['power_form_mode'] = $power_form_mode;

        return $this;
    }

    /**
     * Gets power_form_mode_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPowerFormModeMetadata()
    {
        return $this->container['power_form_mode_metadata'];
    }

    /**
     * Sets power_form_mode_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $power_form_mode_metadata Metadata about the `powerFormMode` property.
     *
     * @return $this
     */
    public function setPowerFormModeMetadata($power_form_mode_metadata)
    {
        $this->container['power_form_mode_metadata'] = $power_form_mode_metadata;

        return $this;
    }

    /**
     * Gets recipient_viewed_notification
     *
     * @return ?string
     */
    public function getRecipientViewedNotification()
    {
        return $this->container['recipient_viewed_notification'];
    }

    /**
     * Sets recipient_viewed_notification
     *
     * param null|string $recipient_viewed_notification 
     *
     * @return $this
     */
    public function setRecipientViewedNotification($recipient_viewed_notification)
    {
        $this->container['recipient_viewed_notification'] = $recipient_viewed_notification;

        return $this;
    }

    /**
     * Gets recipient_viewed_notification_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRecipientViewedNotificationMetadata()
    {
        return $this->container['recipient_viewed_notification_metadata'];
    }

    /**
     * Sets recipient_viewed_notification_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $recipient_viewed_notification_metadata Metadata about the `recipientViewedNotification` property.
     *
     * @return $this
     */
    public function setRecipientViewedNotificationMetadata($recipient_viewed_notification_metadata)
    {
        $this->container['recipient_viewed_notification_metadata'] = $recipient_viewed_notification_metadata;

        return $this;
    }

    /**
     * Gets seal_identifiers
     *
     * @return \DocuSign\eSign\Model\SealIdentifier[]
     */
    public function getSealIdentifiers()
    {
        return $this->container['seal_identifiers'];
    }

    /**
     * Sets seal_identifiers
     *
     * @param \DocuSign\eSign\Model\SealIdentifier[] $seal_identifiers 
     *
     * @return $this
     */
    public function setSealIdentifiers($seal_identifiers)
    {
        $this->container['seal_identifiers'] = $seal_identifiers;

        return $this;
    }

    /**
     * Gets self_signed_recipient_email_document
     *
     * @return ?string
     */
    public function getSelfSignedRecipientEmailDocument()
    {
        return $this->container['self_signed_recipient_email_document'];
    }

    /**
     * Sets self_signed_recipient_email_document
     *
     * param null|string $self_signed_recipient_email_document 
     *
     * @return $this
     */
    public function setSelfSignedRecipientEmailDocument($self_signed_recipient_email_document)
    {
        $this->container['self_signed_recipient_email_document'] = $self_signed_recipient_email_document;

        return $this;
    }

    /**
     * Gets self_signed_recipient_email_document_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSelfSignedRecipientEmailDocumentMetadata()
    {
        return $this->container['self_signed_recipient_email_document_metadata'];
    }

    /**
     * Sets self_signed_recipient_email_document_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $self_signed_recipient_email_document_metadata Metadata that indicates whether the `selfSignedRecipientEmailDocument` property is editable.
     *
     * @return $this
     */
    public function setSelfSignedRecipientEmailDocumentMetadata($self_signed_recipient_email_document_metadata)
    {
        $this->container['self_signed_recipient_email_document_metadata'] = $self_signed_recipient_email_document_metadata;

        return $this;
    }

    /**
     * Gets sender_email_notifications
     *
     * @return \DocuSign\eSign\Model\SenderEmailNotifications
     */
    public function getSenderEmailNotifications()
    {
        return $this->container['sender_email_notifications'];
    }

    /**
     * Sets sender_email_notifications
     *
     * @param \DocuSign\eSign\Model\SenderEmailNotifications $sender_email_notifications An array of email notifications that sets the email the user receives when they are a sender. When the specific email notification is set to true, the user will receive those types of email notifications from DocuSign.   The user inherits the default account sender email notification settings when the user is created. The email notifications are:  * envelopeComplete * changedSigner  * senderEnvelopeDeclined  * withdrawnConsent  * recipientViewed  * deliveryFailed
     *
     * @return $this
     */
    public function setSenderEmailNotifications($sender_email_notifications)
    {
        $this->container['sender_email_notifications'] = $sender_email_notifications;

        return $this;
    }

    /**
     * Gets signer_email_notifications
     *
     * @return \DocuSign\eSign\Model\SignerEmailNotifications
     */
    public function getSignerEmailNotifications()
    {
        return $this->container['signer_email_notifications'];
    }

    /**
     * Sets signer_email_notifications
     *
     * @param \DocuSign\eSign\Model\SignerEmailNotifications $signer_email_notifications An array of email notifications that specifies the email the user receives when they are a recipient. When the specific email notification is set to true, the user receives those types of email notifications from DocuSign. The user inherits the default account email notification settings when the user is created.
     *
     * @return $this
     */
    public function setSignerEmailNotifications($signer_email_notifications)
    {
        $this->container['signer_email_notifications'] = $signer_email_notifications;

        return $this;
    }

    /**
     * Gets supplemental_document_include_in_download
     *
     * @return ?string
     */
    public function getSupplementalDocumentIncludeInDownload()
    {
        return $this->container['supplemental_document_include_in_download'];
    }

    /**
     * Sets supplemental_document_include_in_download
     *
     * param null|string $supplemental_document_include_in_download 
     *
     * @return $this
     */
    public function setSupplementalDocumentIncludeInDownload($supplemental_document_include_in_download)
    {
        $this->container['supplemental_document_include_in_download'] = $supplemental_document_include_in_download;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustAccept()
    {
        return $this->container['supplemental_documents_must_accept'];
    }

    /**
     * Sets supplemental_documents_must_accept
     *
     * param null|string $supplemental_documents_must_accept 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustAccept($supplemental_documents_must_accept)
    {
        $this->container['supplemental_documents_must_accept'] = $supplemental_documents_must_accept;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustAcceptMetadata()
    {
        return $this->container['supplemental_documents_must_accept_metadata'];
    }

    /**
     * Sets supplemental_documents_must_accept_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_accept_metadata Metadata that indicates whether the `supplementalDocumentsMustAccept` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustAcceptMetadata($supplemental_documents_must_accept_metadata)
    {
        $this->container['supplemental_documents_must_accept_metadata'] = $supplemental_documents_must_accept_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustRead()
    {
        return $this->container['supplemental_documents_must_read'];
    }

    /**
     * Sets supplemental_documents_must_read
     *
     * param null|string $supplemental_documents_must_read 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustRead($supplemental_documents_must_read)
    {
        $this->container['supplemental_documents_must_read'] = $supplemental_documents_must_read;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustReadMetadata()
    {
        return $this->container['supplemental_documents_must_read_metadata'];
    }

    /**
     * Sets supplemental_documents_must_read_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_read_metadata Metadata that indicates whether the `supplementalDocumentsMustRead` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustReadMetadata($supplemental_documents_must_read_metadata)
    {
        $this->container['supplemental_documents_must_read_metadata'] = $supplemental_documents_must_read_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustView()
    {
        return $this->container['supplemental_documents_must_view'];
    }

    /**
     * Sets supplemental_documents_must_view
     *
     * param null|string $supplemental_documents_must_view 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustView($supplemental_documents_must_view)
    {
        $this->container['supplemental_documents_must_view'] = $supplemental_documents_must_view;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustViewMetadata()
    {
        return $this->container['supplemental_documents_must_view_metadata'];
    }

    /**
     * Sets supplemental_documents_must_view_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_view_metadata Metadata that indicates whether the `supplementalDocumentsMustView` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustViewMetadata($supplemental_documents_must_view_metadata)
    {
        $this->container['supplemental_documents_must_view_metadata'] = $supplemental_documents_must_view_metadata;

        return $this;
    }

    /**
     * Gets template_active_creation
     *
     * @return ?string
     */
    public function getTemplateActiveCreation()
    {
        return $this->container['template_active_creation'];
    }

    /**
     * Sets template_active_creation
     *
     * param null|string $template_active_creation 
     *
     * @return $this
     */
    public function setTemplateActiveCreation($template_active_creation)
    {
        $this->container['template_active_creation'] = $template_active_creation;

        return $this;
    }

    /**
     * Gets template_active_creation_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTemplateActiveCreationMetadata()
    {
        return $this->container['template_active_creation_metadata'];
    }

    /**
     * Sets template_active_creation_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $template_active_creation_metadata Metadata about the `templateActiveCreation` property.
     *
     * @return $this
     */
    public function setTemplateActiveCreationMetadata($template_active_creation_metadata)
    {
        $this->container['template_active_creation_metadata'] = $template_active_creation_metadata;

        return $this;
    }

    /**
     * Gets template_apply_notify
     *
     * @return ?string
     */
    public function getTemplateApplyNotify()
    {
        return $this->container['template_apply_notify'];
    }

    /**
     * Sets template_apply_notify
     *
     * param null|string $template_apply_notify 
     *
     * @return $this
     */
    public function setTemplateApplyNotify($template_apply_notify)
    {
        $this->container['template_apply_notify'] = $template_apply_notify;

        return $this;
    }

    /**
     * Gets template_apply_notify_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTemplateApplyNotifyMetadata()
    {
        return $this->container['template_apply_notify_metadata'];
    }

    /**
     * Sets template_apply_notify_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $template_apply_notify_metadata Metadata about the `templateApplyNotify` property.
     *
     * @return $this
     */
    public function setTemplateApplyNotifyMetadata($template_apply_notify_metadata)
    {
        $this->container['template_apply_notify_metadata'] = $template_apply_notify_metadata;

        return $this;
    }

    /**
     * Gets template_auto_matching
     *
     * @return ?string
     */
    public function getTemplateAutoMatching()
    {
        return $this->container['template_auto_matching'];
    }

    /**
     * Sets template_auto_matching
     *
     * param null|string $template_auto_matching 
     *
     * @return $this
     */
    public function setTemplateAutoMatching($template_auto_matching)
    {
        $this->container['template_auto_matching'] = $template_auto_matching;

        return $this;
    }

    /**
     * Gets template_auto_matching_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTemplateAutoMatchingMetadata()
    {
        return $this->container['template_auto_matching_metadata'];
    }

    /**
     * Sets template_auto_matching_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $template_auto_matching_metadata Metadata about the `templateAutoMatching` property.
     *
     * @return $this
     */
    public function setTemplateAutoMatchingMetadata($template_auto_matching_metadata)
    {
        $this->container['template_auto_matching_metadata'] = $template_auto_matching_metadata;

        return $this;
    }

    /**
     * Gets template_matching_sensitivity
     *
     * @return ?string
     */
    public function getTemplateMatchingSensitivity()
    {
        return $this->container['template_matching_sensitivity'];
    }

    /**
     * Sets template_matching_sensitivity
     *
     * param null|string $template_matching_sensitivity 
     *
     * @return $this
     */
    public function setTemplateMatchingSensitivity($template_matching_sensitivity)
    {
        $this->container['template_matching_sensitivity'] = $template_matching_sensitivity;

        return $this;
    }

    /**
     * Gets template_matching_sensitivity_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTemplateMatchingSensitivityMetadata()
    {
        return $this->container['template_matching_sensitivity_metadata'];
    }

    /**
     * Sets template_matching_sensitivity_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $template_matching_sensitivity_metadata Metadata about the `tempalteMatchingSensitivity` property.
     *
     * @return $this
     */
    public function setTemplateMatchingSensitivityMetadata($template_matching_sensitivity_metadata)
    {
        $this->container['template_matching_sensitivity_metadata'] = $template_matching_sensitivity_metadata;

        return $this;
    }

    /**
     * Gets template_page_level_matching
     *
     * @return ?string
     */
    public function getTemplatePageLevelMatching()
    {
        return $this->container['template_page_level_matching'];
    }

    /**
     * Sets template_page_level_matching
     *
     * param null|string $template_page_level_matching 
     *
     * @return $this
     */
    public function setTemplatePageLevelMatching($template_page_level_matching)
    {
        $this->container['template_page_level_matching'] = $template_page_level_matching;

        return $this;
    }

    /**
     * Gets template_page_level_matching_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTemplatePageLevelMatchingMetadata()
    {
        return $this->container['template_page_level_matching_metadata'];
    }

    /**
     * Sets template_page_level_matching_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $template_page_level_matching_metadata Metadata about the `templatePageLevelMatching` property.
     *
     * @return $this
     */
    public function setTemplatePageLevelMatchingMetadata($template_page_level_matching_metadata)
    {
        $this->container['template_page_level_matching_metadata'] = $template_page_level_matching_metadata;

        return $this;
    }

    /**
     * Gets timezone_dst
     *
     * @return ?string
     */
    public function getTimezoneDst()
    {
        return $this->container['timezone_dst'];
    }

    /**
     * Sets timezone_dst
     *
     * param null|string $timezone_dst 
     *
     * @return $this
     */
    public function setTimezoneDst($timezone_dst)
    {
        $this->container['timezone_dst'] = $timezone_dst;

        return $this;
    }

    /**
     * Gets timezone_dst_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimezoneDstMetadata()
    {
        return $this->container['timezone_dst_metadata'];
    }

    /**
     * Sets timezone_dst_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $timezone_dst_metadata Metadata about the `timezoneDST` property.
     *
     * @return $this
     */
    public function setTimezoneDstMetadata($timezone_dst_metadata)
    {
        $this->container['timezone_dst_metadata'] = $timezone_dst_metadata;

        return $this;
    }

    /**
     * Gets timezone_mask
     *
     * @return ?string
     */
    public function getTimezoneMask()
    {
        return $this->container['timezone_mask'];
    }

    /**
     * Sets timezone_mask
     *
     * param null|string $timezone_mask 
     *
     * @return $this
     */
    public function setTimezoneMask($timezone_mask)
    {
        $this->container['timezone_mask'] = $timezone_mask;

        return $this;
    }

    /**
     * Gets timezone_mask_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimezoneMaskMetadata()
    {
        return $this->container['timezone_mask_metadata'];
    }

    /**
     * Sets timezone_mask_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $timezone_mask_metadata Metadata about the `timezoneMask` property.
     *
     * @return $this
     */
    public function setTimezoneMaskMetadata($timezone_mask_metadata)
    {
        $this->container['timezone_mask_metadata'] = $timezone_mask_metadata;

        return $this;
    }

    /**
     * Gets timezone_offset
     *
     * @return ?string
     */
    public function getTimezoneOffset()
    {
        return $this->container['timezone_offset'];
    }

    /**
     * Sets timezone_offset
     *
     * param null|string $timezone_offset 
     *
     * @return $this
     */
    public function setTimezoneOffset($timezone_offset)
    {
        $this->container['timezone_offset'] = $timezone_offset;

        return $this;
    }

    /**
     * Gets timezone_offset_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimezoneOffsetMetadata()
    {
        return $this->container['timezone_offset_metadata'];
    }

    /**
     * Sets timezone_offset_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $timezone_offset_metadata Metadata about the `timezoneOffset` property.
     *
     * @return $this
     */
    public function setTimezoneOffsetMetadata($timezone_offset_metadata)
    {
        $this->container['timezone_offset_metadata'] = $timezone_offset_metadata;

        return $this;
    }

    /**
     * Gets timezone_sending_pref
     *
     * @return ?string
     */
    public function getTimezoneSendingPref()
    {
        return $this->container['timezone_sending_pref'];
    }

    /**
     * Sets timezone_sending_pref
     *
     * param null|string $timezone_sending_pref 
     *
     * @return $this
     */
    public function setTimezoneSendingPref($timezone_sending_pref)
    {
        $this->container['timezone_sending_pref'] = $timezone_sending_pref;

        return $this;
    }

    /**
     * Gets timezone_sending_pref_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimezoneSendingPrefMetadata()
    {
        return $this->container['timezone_sending_pref_metadata'];
    }

    /**
     * Sets timezone_sending_pref_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $timezone_sending_pref_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setTimezoneSendingPrefMetadata($timezone_sending_pref_metadata)
    {
        $this->container['timezone_sending_pref_metadata'] = $timezone_sending_pref_metadata;

        return $this;
    }

    /**
     * Gets timezone_signing_pref
     *
     * @return ?string
     */
    public function getTimezoneSigningPref()
    {
        return $this->container['timezone_signing_pref'];
    }

    /**
     * Sets timezone_signing_pref
     *
     * param null|string $timezone_signing_pref 
     *
     * @return $this
     */
    public function setTimezoneSigningPref($timezone_signing_pref)
    {
        $this->container['timezone_signing_pref'] = $timezone_signing_pref;

        return $this;
    }

    /**
     * Gets timezone_signing_pref_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimezoneSigningPrefMetadata()
    {
        return $this->container['timezone_signing_pref_metadata'];
    }

    /**
     * Sets timezone_signing_pref_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $timezone_signing_pref_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setTimezoneSigningPrefMetadata($timezone_signing_pref_metadata)
    {
        $this->container['timezone_signing_pref_metadata'] = $timezone_signing_pref_metadata;

        return $this;
    }

    /**
     * Gets transaction_point_site_name_url
     *
     * @return ?string
     */
    public function getTransactionPointSiteNameUrl()
    {
        return $this->container['transaction_point_site_name_url'];
    }

    /**
     * Sets transaction_point_site_name_url
     *
     * param null|string $transaction_point_site_name_url 
     *
     * @return $this
     */
    public function setTransactionPointSiteNameUrl($transaction_point_site_name_url)
    {
        $this->container['transaction_point_site_name_url'] = $transaction_point_site_name_url;

        return $this;
    }

    /**
     * Gets transaction_point_site_name_url_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTransactionPointSiteNameUrlMetadata()
    {
        return $this->container['transaction_point_site_name_url_metadata'];
    }

    /**
     * Sets transaction_point_site_name_url_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $transaction_point_site_name_url_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setTransactionPointSiteNameUrlMetadata($transaction_point_site_name_url_metadata)
    {
        $this->container['transaction_point_site_name_url_metadata'] = $transaction_point_site_name_url_metadata;

        return $this;
    }

    /**
     * Gets transaction_point_user_name
     *
     * @return ?string
     */
    public function getTransactionPointUserName()
    {
        return $this->container['transaction_point_user_name'];
    }

    /**
     * Sets transaction_point_user_name
     *
     * param null|string $transaction_point_user_name 
     *
     * @return $this
     */
    public function setTransactionPointUserName($transaction_point_user_name)
    {
        $this->container['transaction_point_user_name'] = $transaction_point_user_name;

        return $this;
    }

    /**
     * Gets transaction_point_user_name_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTransactionPointUserNameMetadata()
    {
        return $this->container['transaction_point_user_name_metadata'];
    }

    /**
     * Sets transaction_point_user_name_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $transaction_point_user_name_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setTransactionPointUserNameMetadata($transaction_point_user_name_metadata)
    {
        $this->container['transaction_point_user_name_metadata'] = $transaction_point_user_name_metadata;

        return $this;
    }

    /**
     * Gets vaulting_mode
     *
     * @return ?string
     */
    public function getVaultingMode()
    {
        return $this->container['vaulting_mode'];
    }

    /**
     * Sets vaulting_mode
     *
     * param null|string $vaulting_mode 
     *
     * @return $this
     */
    public function setVaultingMode($vaulting_mode)
    {
        $this->container['vaulting_mode'] = $vaulting_mode;

        return $this;
    }

    /**
     * Gets vaulting_mode_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getVaultingModeMetadata()
    {
        return $this->container['vaulting_mode_metadata'];
    }

    /**
     * Sets vaulting_mode_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $vaulting_mode_metadata Metadata about the `vaultingMode` property.
     *
     * @return $this
     */
    public function setVaultingModeMetadata($vaulting_mode_metadata)
    {
        $this->container['vaulting_mode_metadata'] = $vaulting_mode_metadata;

        return $this;
    }

    /**
     * Gets web_forms
     *
     * @return ?string
     */
    public function getWebForms()
    {
        return $this->container['web_forms'];
    }

    /**
     * Sets web_forms
     *
     * param null|string $web_forms 
     *
     * @return $this
     */
    public function setWebForms($web_forms)
    {
        $this->container['web_forms'] = $web_forms;

        return $this;
    }

    /**
     * Gets web_forms_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getWebFormsMetadata()
    {
        return $this->container['web_forms_metadata'];
    }

    /**
     * Sets web_forms_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $web_forms_metadata 
     *
     * @return $this
     */
    public function setWebFormsMetadata($web_forms_metadata)
    {
        $this->container['web_forms_metadata'] = $web_forms_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

