
function updateShipToPendingLoadValues(){

	//Get IDs to load
	var load = [];
	var tds = $('td.pendingLoad:not(.pendingLoadActive):not(.shipToDataLoaded)').each(function(){
		load.push({customerid: $(this).attr('customer-id'), shiptoid: $(this).attr('shipto-id')});
	}).addClass('pendingLoadActive');

	//Nothing to do...
	if(load.length == 0) return;

	//Load the set of IDs
	$.ajaxRetry({
		url: CI_BASE_URL+'shipto/massEditGetShipToValues/?&tmpl=json',
		method: 'post',
		dataType: 'json',
		data: {load: load},
		complete: function(status, rsp){

			if(typeof(rsp.responseJSON) == 'undefined' || typeof(rsp.responseJSON.shiptos) == 'undefined'){
				for(var i in load){
					$('td[customer-id="'+load.customerid+'"][shipto-id="'+load.shiptoid+'"]').addClass('pendingLoad');
				}
			}
			var shiptos = rsp.responseJSON.shiptos;
			var set_shipto_ids = rsp.responseJSON.set_shipto_ids;
			
			//Change Ship-To Ids
			for(var i in set_shipto_ids){
				var r = set_shipto_ids[i];
				var tr = $('tr[customer-id="'+r.customerid.toString()+'"][shipto-id="'+r.old_shiptoid.toString()+'"]');
				tr.attr('shipto-id', r.shiptoid);
				var td = $('td[customer-id="'+r.customerid.toString()+'"][shipto-id="'+r.old_shiptoid.toString()+'"]');
				td.attr('shipto-id', r.shiptoid);
				td.find('[name]').each(function(){
					var newname = $(this).attr('name');
					newname = newname.replace(/save_model\[shipto\]\[[^\]]*\]/i, 'save_model[shipto]['+r.shiptoid.toString()+']');
					$(this).attr('name', newname);
				});
			}

			//Set Ship To Field Values
			for(var i in shiptos){
				var fields = shiptos[i];
				for(var f in fields){ 
					var css = '[name="save_model[shipto]['+i.toString()+']['+f+']"]';
					var elm = $(css);
					elm.val(fields[f]);
				}
			}

			//Flag As Loaded
			tds.addClass('shipToDataLoaded').removeClass('pendingLoad').removeClass('pendingLoadActive');
		},
		error: function(){
			//Reset flags to try again
			for(var i in load){
				$('td[customer-id="'+load.customerid+'"][shipto-id="'+load.shiptoid+'"]').addClass('pendingLoad').removeClass('pendingLoadActive');
			}
		}
	});
}


function updateShipToPendingSaves(){
	//Build Save Data
	var save = {};
	var count = 0;
	var tds = $('td.pendingShipToSave:not(.pendingShipToSaveActive):not(.pendingLoad)').each(function(){
		var input = $(this).find('input, select, textarea');
		var key = $(this).attr('shipto-id')+'_'+$(this).attr('customer-id');
		if(typeof(save[key]) == 'undefined') save[key] = {customerid: $(this).attr('customer-id'), shiptoid: $(this).attr('shipto-id')};
		save[key][$(this).attr('shipto-field')] = input.val();
		count++;
	}).addClass('pendingShipToSaveActive');

	//Nothing to do...
	if(count == 0) return;

	//Send the save data
	$.ajaxRetry({
		url: CI_BASE_URL+'shipto/massEditSaveShipToValues/?&tmpl=json',
		method: 'post',
		dataType: 'json',
		data: {save: save},
		complete: function(status, rsp){
			//Error
			if(typeof(rsp.responseJSON) == 'undefined' || typeof(rsp.responseJSON.set_shipto_ids) == 'undefined'){
				//Retry
				tds.removeClass('pendingShipToSaveActive');
				return;
			}
			
			//Change Ship-To Ids
			var set_shipto_ids = rsp.responseJSON.set_shipto_ids;
			for(var i in set_shipto_ids){
				var r = set_shipto_ids[i];
				var tr = $('tr[customer-id="'+r.customerid+'"][shipto-id="'+r.old_shiptoid+'"]');
				tr.attr('shipto-id', r.shiptoid);
				var td = $('td[customer-id="'+r.customerid+'"][shipto-id="'+r.old_shiptoid+'"]');
				td.attr('shipto-id', r.shiptoid);
				td.find('[name]').each(function(){
					var newname = $(this).attr('name');
					newname = newname.replace(/save_model\[shipto\]\[[^\]]*\]/i, 'save_model[shipto]['+r.shiptoid+']');
					$(this).attr('name', newname);
				});
			}

			//Remove Pending-Save flags
			tds.addClass('pendingShipToSaveCompleted');
			setTimeout(function(){ tds.addClass('pendingShipToSaveCompleteConfirmed'); }, 500);
			setTimeout(function(){ tds.removeClass('pendingShipToSaveCompleted'); }, 1000);
			setTimeout(function(){ tds.addClass('pendingShipToSaveCompleteConfirmed'); }, 1500);
			tds.removeClass('pendingShipToSave').removeClass('pendingShipToSaveActive');
		},
		error: function(){
			//Retry
			tds.removeClass('pendingShipToSaveActive');
		}
	});
}

$(function(){ setInterval(updateShipToPendingLoadValues, 333); });
$(function(){ setInterval(updateShipToPendingSaves, 333); });

function customerValueHeader_Click(sender, event){
	var tr = $(sender).closest('tr');
	var shiptoid = tr.attr('shipto-id');
	var customerid = tr.attr('customer-id');
	var css = 'td[shipto-field][shipto-id="'+shiptoid+'"][customer-id="'+customerid+'"]';
	$(css).each(function(){
		var input = $(this).find('input, select, textarea');
		var customerVal = $(this).prev().attr('customer-value');
		if(typeof(customerVal) == 'undefined' || customerVal === null || customerVal.trim() === '') customerVal = '';
		if(customerVal !== '' && input.val() != customerVal) input.val(customerVal).closest('td').addClass('pendingShipToSave').removeClass('pendingShipToSaveCompleted').removeClass('pendingShipToSaveCompleteConfirmed')
	});
}

function shipToValueHeader_Click(sender, event){
	var tr = $(sender).closest('tr');
	var shiptoid = tr.attr('shipto-id');
	var customerid = tr.attr('customer-id');
	var css = 'td[shipto-field][shipto-id="'+shiptoid+'"][customer-id="'+customerid+'"]';
	$(css).each(function(){
		var input = $(this).find('input, select, textarea');
		var initVal = input.attr('init-value');
		if(typeof(initVal) == 'undefined' || initVal === null) initVal = '';
		if(input.val() != initVal) input.val(initVal).closest('td').addClass('pendingShipToSave').removeClass('pendingShipToSaveCompleted').removeClass('pendingShipToSaveCompleteConfirmed')
	});
}

function cellCustomerField_Click(sender, event){
	var val = $(sender).attr('customer-value');
	var input = $(sender).closest('td').next().find('input, select, textarea');
	if(input.val() != val) input.val(val).closest('td').addClass('pendingShipToSave').removeClass('pendingShipToSaveCompleted').removeClass('pendingShipToSaveCompleteConfirmed')
}

function shipToInput_Change(sender, event){
	$(sender).closest('td').addClass('pendingShipToSave').removeClass('pendingShipToSaveCompleted').removeClass('pendingShipToSaveCompleteConfirmed')
}

function shipToInput_KeyUp(sender, event){
	uiWaitForFinalEvent((function(){
		$(this).closest('td').addClass('pendingShipToSave').removeClass('pendingShipToSaveCompleted').removeClass('pendingShipToSaveCompleteConfirmed')
	}).bind(sender), 500, $(sender).attr('name'));
}

function autoUpdateMissingVals_Change(sender, event){
	var set = $('[name="auto_mode"]').val() == 'update' ? 'inline-block' : 'none';
	$('.cbUpdateFieldAction').css('display', set);
	UI.resize();
}

$(function(){
	autoUpdateMissingVals_Change(null, null);
});