<?php

/**
 * Schema object for: SalesReceiptAddRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_SalesReceiptAddRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = 'SalesReceiptAdd';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'CustomerRef ListID' => 'IDTYPE',
  'CustomerRef FullName' => 'STRTYPE',
  'ClassRef ListID' => 'IDTYPE',
  'ClassRef FullName' => 'STRTYPE',
  'TemplateRef ListID' => 'IDTYPE',
  'TemplateRef FullName' => 'STRTYPE',
  'TxnDate' => 'DATETYPE',
  'RefNumber' => 'STRTYPE',
  'BillAddress Addr1' => 'STRTYPE',
  'BillAddress Addr2' => 'STRTYPE',
  'BillAddress Addr3' => 'STRTYPE',
  'BillAddress Addr4' => 'STRTYPE',
  'BillAddress Addr5' => 'STRTYPE',
  'BillAddress City' => 'STRTYPE',
  'BillAddress State' => 'STRTYPE',
  'BillAddress PostalCode' => 'STRTYPE',
  'BillAddress Country' => 'STRTYPE',
  'BillAddress Note' => 'STRTYPE',
  'ShipAddress Addr1' => 'STRTYPE',
  'ShipAddress Addr2' => 'STRTYPE',
  'ShipAddress Addr3' => 'STRTYPE',
  'ShipAddress Addr4' => 'STRTYPE',
  'ShipAddress Addr5' => 'STRTYPE',
  'ShipAddress City' => 'STRTYPE',
  'ShipAddress State' => 'STRTYPE',
  'ShipAddress PostalCode' => 'STRTYPE',
  'ShipAddress Country' => 'STRTYPE',
  'ShipAddress Note' => 'STRTYPE',
  'IsPending' => 'BOOLTYPE',
  'CheckNumber' => 'STRTYPE',
  'PaymentMethodRef ListID' => 'IDTYPE',
  'PaymentMethodRef FullName' => 'STRTYPE',
  'DueDate' => 'DATETYPE',
  'SalesRepRef ListID' => 'IDTYPE',
  'SalesRepRef FullName' => 'STRTYPE',
  'ShipDate' => 'DATETYPE',
  'ShipMethodRef ListID' => 'IDTYPE',
  'ShipMethodRef FullName' => 'STRTYPE',
  'FOB' => 'STRTYPE',
  'ItemSalesTaxRef ListID' => 'IDTYPE',
  'ItemSalesTaxRef FullName' => 'STRTYPE',
  'Memo' => 'STRTYPE',
  'CustomerMsgRef ListID' => 'IDTYPE',
  'CustomerMsgRef FullName' => 'STRTYPE',
  'IsToBePrinted' => 'BOOLTYPE',
  'IsToBeEmailed' => 'BOOLTYPE',
  'IsTaxIncluded' => 'BOOLTYPE',
  'CustomerSalesTaxCodeRef ListID' => 'IDTYPE',
  'CustomerSalesTaxCodeRef FullName' => 'STRTYPE',
  'DepositToAccountRef ListID' => 'IDTYPE',
  'DepositToAccountRef FullName' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 'INTTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 'INTTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 'ENUMTYPE',
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 'ENUMTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 'INTTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 'ENUMTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 'ENUMTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 'ENUMTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 'STRTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 'INTTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 'ENUMTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 'DATETIMETYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 'INTTYPE',
  'CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 'STRTYPE',
  'Other' => 'STRTYPE',
  'SalesReceiptLineAdd ItemRef ListID' => 'IDTYPE',
  'SalesReceiptLineAdd ItemRef FullName' => 'STRTYPE',
  'SalesReceiptLineAdd Desc' => 'STRTYPE',
  'SalesReceiptLineAdd Quantity' => 'QUANTYPE',
  'SalesReceiptLineAdd UnitOfMeasure' => 'STRTYPE',
  'SalesReceiptLineAdd Rate' => 'PRICETYPE',
  'SalesReceiptLineAdd RatePercent' => 'PERCENTTYPE',
  'SalesReceiptLineAdd PriceLevelRef ListID' => 'IDTYPE',
  'SalesReceiptLineAdd PriceLevelRef FullName' => 'STRTYPE',
  'SalesReceiptLineAdd ClassRef ListID' => 'IDTYPE',
  'SalesReceiptLineAdd ClassRef FullName' => 'STRTYPE',
  'SalesReceiptLineAdd Amount' => 'AMTTYPE',
  'SalesReceiptLineAdd ServiceDate' => 'DATETYPE',
  'SalesReceiptLineAdd SalesTaxCodeRef ListID' => 'IDTYPE',
  'SalesReceiptLineAdd SalesTaxCodeRef FullName' => 'STRTYPE',
  'SalesReceiptLineAdd IsTaxable' => 'BOOLTYPE',
  'SalesReceiptLineAdd OverrideItemAccountRef ListID' => 'IDTYPE',
  'SalesReceiptLineAdd OverrideItemAccountRef FullName' => 'STRTYPE',
  'SalesReceiptLineAdd Other1' => 'STRTYPE',
  'SalesReceiptLineAdd Other2' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 'INTTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 'INTTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 'ENUMTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 'ENUMTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 'INTTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 'ENUMTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 'ENUMTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 'ENUMTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 'STRTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 'INTTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 'ENUMTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 'DATETIMETYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 'INTTYPE',
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 'STRTYPE',
  'SalesReceiptLineAdd DataExt OwnerID' => 'GUIDTYPE',
  'SalesReceiptLineAdd DataExt DataExtName' => 'STRTYPE',
  'SalesReceiptLineAdd DataExt DataExtValue' => 'STRTYPE',
  'SalesReceiptLineGroupAdd ItemGroupRef ListID' => 'IDTYPE',
  'SalesReceiptLineGroupAdd ItemGroupRef FullName' => 'STRTYPE',
  'SalesReceiptLineGroupAdd Desc' => 'STRTYPE',
  'SalesReceiptLineGroupAdd Quantity' => 'QUANTYPE',
  'SalesReceiptLineGroupAdd UnitOfMeasure' => 'STRTYPE',
  'SalesReceiptLineGroupAdd ServiceDate' => 'DATETYPE',
  'SalesReceiptLineGroupAdd DataExt OwnerID' => 'GUIDTYPE',
  'SalesReceiptLineGroupAdd DataExt DataExtName' => 'STRTYPE',
  'SalesReceiptLineGroupAdd DataExt DataExtValue' => 'STRTYPE',
  'DiscountLineAdd Amount' => 'AMTTYPE',
  'DiscountLineAdd RatePercent' => 'PERCENTTYPE',
  'DiscountLineAdd IsTaxable' => 'BOOLTYPE',
  'DiscountLineAdd AccountRef ListID' => 'IDTYPE',
  'DiscountLineAdd AccountRef FullName' => 'STRTYPE',
  'SalesTaxLineAdd Amount' => 'AMTTYPE',
  'SalesTaxLineAdd RatePercent' => 'PERCENTTYPE',
  'SalesTaxLineAdd AccountRef ListID' => 'IDTYPE',
  'SalesTaxLineAdd AccountRef FullName' => 'STRTYPE',
  'ShippingLineAdd Amount' => 'AMTTYPE',
  'ShippingLineAdd AccountRef ListID' => 'IDTYPE',
  'ShippingLineAdd AccountRef FullName' => 'STRTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'CustomerRef ListID' => 0,
  'CustomerRef FullName' => 209,
  'ClassRef ListID' => 0,
  'ClassRef FullName' => 209,
  'TemplateRef ListID' => 0,
  'TemplateRef FullName' => 209,
  'TxnDate' => 0,
  'RefNumber' => 11,
  'BillAddress Addr1' => 41,
  'BillAddress Addr2' => 41,
  'BillAddress Addr3' => 41,
  'BillAddress Addr4' => 41,
  'BillAddress Addr5' => 41,
  'BillAddress City' => 31,
  'BillAddress State' => 21,
  'BillAddress PostalCode' => 13,
  'BillAddress Country' => 31,
  'BillAddress Note' => 41,
  'ShipAddress Addr1' => 41,
  'ShipAddress Addr2' => 41,
  'ShipAddress Addr3' => 41,
  'ShipAddress Addr4' => 41,
  'ShipAddress Addr5' => 41,
  'ShipAddress City' => 31,
  'ShipAddress State' => 21,
  'ShipAddress PostalCode' => 13,
  'ShipAddress Country' => 31,
  'ShipAddress Note' => 41,
  'IsPending' => 0,
  'CheckNumber' => 25,
  'PaymentMethodRef ListID' => 0,
  'PaymentMethodRef FullName' => 209,
  'DueDate' => 0,
  'SalesRepRef ListID' => 0,
  'SalesRepRef FullName' => 209,
  'ShipDate' => 0,
  'ShipMethodRef ListID' => 0,
  'ShipMethodRef FullName' => 209,
  'FOB' => 13,
  'ItemSalesTaxRef ListID' => 0,
  'ItemSalesTaxRef FullName' => 209,
  'Memo' => 4095,
  'CustomerMsgRef ListID' => 0,
  'CustomerMsgRef FullName' => 209,
  'IsToBePrinted' => 0,
  'IsToBeEmailed' => 0,
  'IsTaxIncluded' => 0,
  'CustomerSalesTaxCodeRef ListID' => 0,
  'CustomerSalesTaxCodeRef FullName' => 209,
  'DepositToAccountRef ListID' => 0,
  'DepositToAccountRef FullName' => 209,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 25,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 0,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 0,
  'CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 41,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 41,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 18,
  'CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 24,
  'CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 0,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 60,
  'CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 24,
  'CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 32,
  'CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 12,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 84,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 0,
  'CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 16,
  'Other' => 29,
  'SalesReceiptLineAdd ItemRef ListID' => 0,
  'SalesReceiptLineAdd ItemRef FullName' => 209,
  'SalesReceiptLineAdd Desc' => 4095,
  'SalesReceiptLineAdd Quantity' => 0,
  'SalesReceiptLineAdd UnitOfMeasure' => 31,
  'SalesReceiptLineAdd Rate' => 0,
  'SalesReceiptLineAdd RatePercent' => 0,
  'SalesReceiptLineAdd PriceLevelRef ListID' => 0,
  'SalesReceiptLineAdd PriceLevelRef FullName' => 209,
  'SalesReceiptLineAdd ClassRef ListID' => 0,
  'SalesReceiptLineAdd ClassRef FullName' => 209,
  'SalesReceiptLineAdd Amount' => 0,
  'SalesReceiptLineAdd ServiceDate' => 0,
  'SalesReceiptLineAdd SalesTaxCodeRef ListID' => 0,
  'SalesReceiptLineAdd SalesTaxCodeRef FullName' => 209,
  'SalesReceiptLineAdd IsTaxable' => 0,
  'SalesReceiptLineAdd OverrideItemAccountRef ListID' => 0,
  'SalesReceiptLineAdd OverrideItemAccountRef FullName' => 209,
  'SalesReceiptLineAdd Other1' => 29,
  'SalesReceiptLineAdd Other2' => 29,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 25,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 41,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 41,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 18,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 24,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 60,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 24,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 32,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 12,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 84,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 16,
  'SalesReceiptLineAdd DataExt OwnerID' => 0,
  'SalesReceiptLineAdd DataExt DataExtName' => 31,
  'SalesReceiptLineAdd DataExt DataExtValue' => 0,
  'SalesReceiptLineGroupAdd ItemGroupRef ListID' => 0,
  'SalesReceiptLineGroupAdd ItemGroupRef FullName' => 209,
  'SalesReceiptLineGroupAdd Desc' => 4095,
  'SalesReceiptLineGroupAdd Quantity' => 0,
  'SalesReceiptLineGroupAdd UnitOfMeasure' => 31,
  'SalesReceiptLineGroupAdd ServiceDate' => 0,
  'SalesReceiptLineGroupAdd DataExt OwnerID' => 0,
  'SalesReceiptLineGroupAdd DataExt DataExtName' => 31,
  'SalesReceiptLineGroupAdd DataExt DataExtValue' => 0,
  'DiscountLineAdd Amount' => 0,
  'DiscountLineAdd RatePercent' => 0,
  'DiscountLineAdd IsTaxable' => 0,
  'DiscountLineAdd AccountRef ListID' => 0,
  'DiscountLineAdd AccountRef FullName' => 209,
  'SalesTaxLineAdd Amount' => 0,
  'SalesTaxLineAdd RatePercent' => 0,
  'SalesTaxLineAdd AccountRef ListID' => 0,
  'SalesTaxLineAdd AccountRef FullName' => 209,
  'ShippingLineAdd Amount' => 0,
  'ShippingLineAdd AccountRef ListID' => 0,
  'ShippingLineAdd AccountRef FullName' => 209,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'CustomerRef ListID' => true,
  'CustomerRef FullName' => true,
  'ClassRef ListID' => true,
  'ClassRef FullName' => true,
  'TemplateRef ListID' => true,
  'TemplateRef FullName' => true,
  'TxnDate' => true,
  'RefNumber' => true,
  'BillAddress Addr1' => true,
  'BillAddress Addr2' => true,
  'BillAddress Addr3' => true,
  'BillAddress Addr4' => true,
  'BillAddress Addr5' => true,
  'BillAddress City' => true,
  'BillAddress State' => true,
  'BillAddress PostalCode' => true,
  'BillAddress Country' => true,
  'BillAddress Note' => true,
  'ShipAddress Addr1' => true,
  'ShipAddress Addr2' => true,
  'ShipAddress Addr3' => true,
  'ShipAddress Addr4' => true,
  'ShipAddress Addr5' => true,
  'ShipAddress City' => true,
  'ShipAddress State' => true,
  'ShipAddress PostalCode' => true,
  'ShipAddress Country' => true,
  'ShipAddress Note' => true,
  'IsPending' => true,
  'CheckNumber' => true,
  'PaymentMethodRef ListID' => true,
  'PaymentMethodRef FullName' => true,
  'DueDate' => true,
  'SalesRepRef ListID' => true,
  'SalesRepRef FullName' => true,
  'ShipDate' => true,
  'ShipMethodRef ListID' => true,
  'ShipMethodRef FullName' => true,
  'FOB' => true,
  'ItemSalesTaxRef ListID' => true,
  'ItemSalesTaxRef FullName' => true,
  'Memo' => true,
  'CustomerMsgRef ListID' => true,
  'CustomerMsgRef FullName' => true,
  'IsToBePrinted' => true,
  'IsToBeEmailed' => true,
  'IsTaxIncluded' => true,
  'CustomerSalesTaxCodeRef ListID' => true,
  'CustomerSalesTaxCodeRef FullName' => true,
  'DepositToAccountRef ListID' => true,
  'DepositToAccountRef FullName' => true,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => true,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => true,
  'CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => true,
  'CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => true,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => true,
  'CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => true,
  'Other' => true,
  'SalesReceiptLineAdd ItemRef ListID' => true,
  'SalesReceiptLineAdd ItemRef FullName' => true,
  'SalesReceiptLineAdd Desc' => true,
  'SalesReceiptLineAdd Quantity' => true,
  'SalesReceiptLineAdd UnitOfMeasure' => true,
  'SalesReceiptLineAdd Rate' => false,
  'SalesReceiptLineAdd RatePercent' => false,
  'SalesReceiptLineAdd PriceLevelRef ListID' => true,
  'SalesReceiptLineAdd PriceLevelRef FullName' => true,
  'SalesReceiptLineAdd ClassRef ListID' => true,
  'SalesReceiptLineAdd ClassRef FullName' => true,
  'SalesReceiptLineAdd Amount' => true,
  'SalesReceiptLineAdd ServiceDate' => true,
  'SalesReceiptLineAdd SalesTaxCodeRef ListID' => true,
  'SalesReceiptLineAdd SalesTaxCodeRef FullName' => true,
  'SalesReceiptLineAdd IsTaxable' => true,
  'SalesReceiptLineAdd OverrideItemAccountRef ListID' => true,
  'SalesReceiptLineAdd OverrideItemAccountRef FullName' => true,
  'SalesReceiptLineAdd Other1' => true,
  'SalesReceiptLineAdd Other2' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => true,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => true,
  'SalesReceiptLineAdd DataExt OwnerID' => false,
  'SalesReceiptLineAdd DataExt DataExtName' => false,
  'SalesReceiptLineAdd DataExt DataExtValue' => false,
  'SalesReceiptLineGroupAdd ItemGroupRef ListID' => true,
  'SalesReceiptLineGroupAdd ItemGroupRef FullName' => true,
  'SalesReceiptLineGroupAdd Desc' => true,
  'SalesReceiptLineGroupAdd Quantity' => true,
  'SalesReceiptLineGroupAdd UnitOfMeasure' => true,
  'SalesReceiptLineGroupAdd ServiceDate' => true,
  'SalesReceiptLineGroupAdd DataExt OwnerID' => false,
  'SalesReceiptLineGroupAdd DataExt DataExtName' => false,
  'SalesReceiptLineGroupAdd DataExt DataExtValue' => false,
  'DiscountLineAdd Amount' => true,
  'DiscountLineAdd RatePercent' => false,
  'DiscountLineAdd IsTaxable' => true,
  'DiscountLineAdd AccountRef ListID' => true,
  'DiscountLineAdd AccountRef FullName' => true,
  'SalesTaxLineAdd Amount' => true,
  'SalesTaxLineAdd RatePercent' => false,
  'SalesTaxLineAdd AccountRef ListID' => true,
  'SalesTaxLineAdd AccountRef FullName' => true,
  'ShippingLineAdd Amount' => true,
  'ShippingLineAdd AccountRef ListID' => true,
  'ShippingLineAdd AccountRef FullName' => true,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'CustomerRef ListID' => 999.99,
  'CustomerRef FullName' => 999.99,
  'ClassRef ListID' => 999.99,
  'ClassRef FullName' => 999.99,
  'TemplateRef ListID' => 999.99,
  'TemplateRef FullName' => 999.99,
  'TxnDate' => 999.99,
  'RefNumber' => 999.99,
  'BillAddress Addr1' => 999.99,
  'BillAddress Addr2' => 999.99,
  'BillAddress Addr3' => 999.99,
  'BillAddress Addr4' => 2,
  'BillAddress Addr5' => 6,
  'BillAddress City' => 999.99,
  'BillAddress State' => 999.99,
  'BillAddress PostalCode' => 999.99,
  'BillAddress Country' => 999.99,
  'BillAddress Note' => 6,
  'ShipAddress Addr1' => 999.99,
  'ShipAddress Addr2' => 999.99,
  'ShipAddress Addr3' => 999.99,
  'ShipAddress Addr4' => 2,
  'ShipAddress Addr5' => 6,
  'ShipAddress City' => 999.99,
  'ShipAddress State' => 999.99,
  'ShipAddress PostalCode' => 999.99,
  'ShipAddress Country' => 999.99,
  'ShipAddress Note' => 6,
  'IsPending' => 999.99,
  'CheckNumber' => 999.99,
  'PaymentMethodRef ListID' => 999.99,
  'PaymentMethodRef FullName' => 999.99,
  'DueDate' => 999.99,
  'SalesRepRef ListID' => 999.99,
  'SalesRepRef FullName' => 999.99,
  'ShipDate' => 999.99,
  'ShipMethodRef ListID' => 999.99,
  'ShipMethodRef FullName' => 999.99,
  'FOB' => 999.99,
  'ItemSalesTaxRef ListID' => 999.99,
  'ItemSalesTaxRef FullName' => 999.99,
  'Memo' => 999.99,
  'CustomerMsgRef ListID' => 999.99,
  'CustomerMsgRef FullName' => 999.99,
  'IsToBePrinted' => 999.99,
  'IsToBeEmailed' => 6,
  'IsTaxIncluded' => 6,
  'CustomerSalesTaxCodeRef ListID' => 999.99,
  'CustomerSalesTaxCodeRef FullName' => 999.99,
  'DepositToAccountRef ListID' => 999.99,
  'DepositToAccountRef FullName' => 999.99,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 999.99,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 0,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 999.99,
  'CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 999.99,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 999.99,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 999.99,
  'CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 999.99,
  'CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 6,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 7,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 6,
  'CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 999.99,
  'CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 6,
  'Other' => 6,
  'SalesReceiptLineAdd ItemRef ListID' => 999.99,
  'SalesReceiptLineAdd ItemRef FullName' => 999.99,
  'SalesReceiptLineAdd Desc' => 999.99,
  'SalesReceiptLineAdd Quantity' => 999.99,
  'SalesReceiptLineAdd UnitOfMeasure' => 7,
  'SalesReceiptLineAdd Rate' => 999.99,
  'SalesReceiptLineAdd RatePercent' => 999.99,
  'SalesReceiptLineAdd PriceLevelRef ListID' => 999.99,
  'SalesReceiptLineAdd PriceLevelRef FullName' => 999.99,
  'SalesReceiptLineAdd ClassRef ListID' => 999.99,
  'SalesReceiptLineAdd ClassRef FullName' => 999.99,
  'SalesReceiptLineAdd Amount' => 999.99,
  'SalesReceiptLineAdd ServiceDate' => 999.99,
  'SalesReceiptLineAdd SalesTaxCodeRef ListID' => 999.99,
  'SalesReceiptLineAdd SalesTaxCodeRef FullName' => 999.99,
  'SalesReceiptLineAdd IsTaxable' => 4,
  'SalesReceiptLineAdd OverrideItemAccountRef ListID' => 999.99,
  'SalesReceiptLineAdd OverrideItemAccountRef FullName' => 999.99,
  'SalesReceiptLineAdd Other1' => 6,
  'SalesReceiptLineAdd Other2' => 6,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => 0,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => 6,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => 7,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => 6,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => 999.99,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => 6,
  'SalesReceiptLineAdd DataExt OwnerID' => 999.99,
  'SalesReceiptLineAdd DataExt DataExtName' => 999.99,
  'SalesReceiptLineAdd DataExt DataExtValue' => 999.99,
  'SalesReceiptLineGroupAdd ItemGroupRef ListID' => 999.99,
  'SalesReceiptLineGroupAdd ItemGroupRef FullName' => 999.99,
  'SalesReceiptLineGroupAdd Desc' => 999.99,
  'SalesReceiptLineGroupAdd Quantity' => 999.99,
  'SalesReceiptLineGroupAdd UnitOfMeasure' => 7,
  'SalesReceiptLineGroupAdd ServiceDate' => 999.99,
  'SalesReceiptLineGroupAdd DataExt OwnerID' => 999.99,
  'SalesReceiptLineGroupAdd DataExt DataExtName' => 999.99,
  'SalesReceiptLineGroupAdd DataExt DataExtValue' => 999.99,
  'DiscountLineAdd Amount' => 999.99,
  'DiscountLineAdd RatePercent' => 999.99,
  'DiscountLineAdd IsTaxable' => 4,
  'DiscountLineAdd AccountRef ListID' => 999.99,
  'DiscountLineAdd AccountRef FullName' => 999.99,
  'SalesTaxLineAdd Amount' => 999.99,
  'SalesTaxLineAdd RatePercent' => 999.99,
  'SalesTaxLineAdd AccountRef ListID' => 999.99,
  'SalesTaxLineAdd AccountRef FullName' => 999.99,
  'ShippingLineAdd Amount' => 999.99,
  'ShippingLineAdd AccountRef ListID' => 999.99,
  'ShippingLineAdd AccountRef FullName' => 999.99,
  'IncludeRetElement' => 4,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'CustomerRef ListID' => false,
  'CustomerRef FullName' => false,
  'ClassRef ListID' => false,
  'ClassRef FullName' => false,
  'TemplateRef ListID' => false,
  'TemplateRef FullName' => false,
  'TxnDate' => false,
  'RefNumber' => false,
  'BillAddress Addr1' => false,
  'BillAddress Addr2' => false,
  'BillAddress Addr3' => false,
  'BillAddress Addr4' => false,
  'BillAddress Addr5' => false,
  'BillAddress City' => false,
  'BillAddress State' => false,
  'BillAddress PostalCode' => false,
  'BillAddress Country' => false,
  'BillAddress Note' => false,
  'ShipAddress Addr1' => false,
  'ShipAddress Addr2' => false,
  'ShipAddress Addr3' => false,
  'ShipAddress Addr4' => false,
  'ShipAddress Addr5' => false,
  'ShipAddress City' => false,
  'ShipAddress State' => false,
  'ShipAddress PostalCode' => false,
  'ShipAddress Country' => false,
  'ShipAddress Note' => false,
  'IsPending' => false,
  'CheckNumber' => false,
  'PaymentMethodRef ListID' => false,
  'PaymentMethodRef FullName' => false,
  'DueDate' => false,
  'SalesRepRef ListID' => false,
  'SalesRepRef FullName' => false,
  'ShipDate' => false,
  'ShipMethodRef ListID' => false,
  'ShipMethodRef FullName' => false,
  'FOB' => false,
  'ItemSalesTaxRef ListID' => false,
  'ItemSalesTaxRef FullName' => false,
  'Memo' => false,
  'CustomerMsgRef ListID' => false,
  'CustomerMsgRef FullName' => false,
  'IsToBePrinted' => false,
  'IsToBeEmailed' => false,
  'IsTaxIncluded' => false,
  'CustomerSalesTaxCodeRef ListID' => false,
  'CustomerSalesTaxCodeRef FullName' => false,
  'DepositToAccountRef ListID' => false,
  'DepositToAccountRef FullName' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => false,
  'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => false,
  'CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => false,
  'Other' => false,
  'SalesReceiptLineAdd ItemRef ListID' => false,
  'SalesReceiptLineAdd ItemRef FullName' => false,
  'SalesReceiptLineAdd Desc' => false,
  'SalesReceiptLineAdd Quantity' => false,
  'SalesReceiptLineAdd UnitOfMeasure' => false,
  'SalesReceiptLineAdd Rate' => false,
  'SalesReceiptLineAdd RatePercent' => false,
  'SalesReceiptLineAdd PriceLevelRef ListID' => false,
  'SalesReceiptLineAdd PriceLevelRef FullName' => false,
  'SalesReceiptLineAdd ClassRef ListID' => false,
  'SalesReceiptLineAdd ClassRef FullName' => false,
  'SalesReceiptLineAdd Amount' => false,
  'SalesReceiptLineAdd ServiceDate' => false,
  'SalesReceiptLineAdd SalesTaxCodeRef ListID' => false,
  'SalesReceiptLineAdd SalesTaxCodeRef FullName' => false,
  'SalesReceiptLineAdd IsTaxable' => false,
  'SalesReceiptLineAdd OverrideItemAccountRef ListID' => false,
  'SalesReceiptLineAdd OverrideItemAccountRef FullName' => false,
  'SalesReceiptLineAdd Other1' => false,
  'SalesReceiptLineAdd Other2' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp' => false,
  'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID' => false,
  'SalesReceiptLineAdd DataExt OwnerID' => false,
  'SalesReceiptLineAdd DataExt DataExtName' => false,
  'SalesReceiptLineAdd DataExt DataExtValue' => false,
  'SalesReceiptLineGroupAdd ItemGroupRef ListID' => false,
  'SalesReceiptLineGroupAdd ItemGroupRef FullName' => false,
  'SalesReceiptLineGroupAdd Desc' => false,
  'SalesReceiptLineGroupAdd Quantity' => false,
  'SalesReceiptLineGroupAdd UnitOfMeasure' => false,
  'SalesReceiptLineGroupAdd ServiceDate' => false,
  'SalesReceiptLineGroupAdd DataExt OwnerID' => false,
  'SalesReceiptLineGroupAdd DataExt DataExtName' => false,
  'SalesReceiptLineGroupAdd DataExt DataExtValue' => false,
  'DiscountLineAdd Amount' => false,
  'DiscountLineAdd RatePercent' => false,
  'DiscountLineAdd IsTaxable' => false,
  'DiscountLineAdd AccountRef ListID' => false,
  'DiscountLineAdd AccountRef FullName' => false,
  'SalesTaxLineAdd Amount' => false,
  'SalesTaxLineAdd RatePercent' => false,
  'SalesTaxLineAdd AccountRef ListID' => false,
  'SalesTaxLineAdd AccountRef FullName' => false,
  'ShippingLineAdd Amount' => false,
  'ShippingLineAdd AccountRef ListID' => false,
  'ShippingLineAdd AccountRef FullName' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'CustomerRef ListID',
  1 => 'CustomerRef FullName',
  2 => 'ClassRef ListID',
  3 => 'ClassRef FullName',
  4 => 'TemplateRef ListID',
  5 => 'TemplateRef FullName',
  6 => 'TxnDate',
  7 => 'RefNumber',
  8 => 'BillAddress Addr1',
  9 => 'BillAddress Addr2',
  10 => 'BillAddress Addr3',
  11 => 'BillAddress Addr4',
  12 => 'BillAddress Addr5',
  13 => 'BillAddress City',
  14 => 'BillAddress State',
  15 => 'BillAddress PostalCode',
  16 => 'BillAddress Country',
  17 => 'BillAddress Note',
  18 => 'ShipAddress Addr1',
  19 => 'ShipAddress Addr2',
  20 => 'ShipAddress Addr3',
  21 => 'ShipAddress Addr4',
  22 => 'ShipAddress Addr5',
  23 => 'ShipAddress City',
  24 => 'ShipAddress State',
  25 => 'ShipAddress PostalCode',
  26 => 'ShipAddress Country',
  27 => 'ShipAddress Note',
  28 => 'IsPending',
  29 => 'CheckNumber',
  30 => 'PaymentMethodRef ListID',
  31 => 'PaymentMethodRef FullName',
  32 => 'DueDate',
  33 => 'SalesRepRef ListID',
  34 => 'SalesRepRef FullName',
  35 => 'ShipDate',
  36 => 'ShipMethodRef ListID',
  37 => 'ShipMethodRef FullName',
  38 => 'FOB',
  39 => 'ItemSalesTaxRef ListID',
  40 => 'ItemSalesTaxRef FullName',
  41 => 'Memo',
  42 => 'CustomerMsgRef ListID',
  43 => 'CustomerMsgRef FullName',
  44 => 'IsToBePrinted',
  45 => 'IsToBeEmailed',
  46 => 'IsTaxIncluded',
  47 => 'CustomerSalesTaxCodeRef ListID',
  48 => 'CustomerSalesTaxCodeRef FullName',
  49 => 'DepositToAccountRef ListID',
  50 => 'DepositToAccountRef FullName',
  51 => 'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber',
  52 => 'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth',
  53 => 'CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear',
  54 => 'CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard',
  55 => 'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress',
  56 => 'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode',
  57 => 'CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode',
  58 => 'CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode',
  59 => 'CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType',
  60 => 'CreditCardTxnInfo CreditCardTxnResultInfo ResultCode',
  61 => 'CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage',
  62 => 'CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID',
  63 => 'CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber',
  64 => 'CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode',
  65 => 'CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet',
  66 => 'CreditCardTxnInfo CreditCardTxnResultInfo AVSZip',
  67 => 'CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch',
  68 => 'CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID',
  69 => 'CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode',
  70 => 'CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus',
  71 => 'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime',
  72 => 'CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp',
  73 => 'CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID',
  74 => 'Other',
  75 => 'SalesReceiptLineAdd',
  76 => 'SalesReceiptLineAdd ItemRef',
  77 => 'SalesReceiptLineAdd ItemRef ListID',
  78 => 'SalesReceiptLineAdd ItemRef FullName',
  79 => 'SalesReceiptLineAdd Desc',
  80 => 'SalesReceiptLineAdd Quantity',
  81 => 'SalesReceiptLineAdd UnitOfMeasure',
  82 => 'SalesReceiptLineAdd Rate',
  83 => 'SalesReceiptLineAdd RatePercent',
  84 => 'SalesReceiptLineAdd PriceLevelRef ListID',
  85 => 'SalesReceiptLineAdd PriceLevelRef FullName',
  86 => 'SalesReceiptLineAdd ClassRef ListID',
  87 => 'SalesReceiptLineAdd ClassRef FullName',
  88 => 'SalesReceiptLineAdd Amount',
  89 => 'SalesReceiptLineAdd ServiceDate',
  90 => 'SalesReceiptLineAdd SalesTaxCodeRef ListID',
  91 => 'SalesReceiptLineAdd SalesTaxCodeRef FullName',
  92 => 'SalesReceiptLineAdd IsTaxable',
  93 => 'SalesReceiptLineAdd OverrideItemAccountRef ListID',
  94 => 'SalesReceiptLineAdd OverrideItemAccountRef FullName',
  95 => 'SalesReceiptLineAdd Other1',
  96 => 'SalesReceiptLineAdd Other2',
  97 => 'SalesReceiptLineAdd',
  98 => 'SalesReceiptLineAdd CreditCardTxnInfo',
  99 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo',
  100 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardNumber',
  101 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationMonth',
  102 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo ExpirationYear',
  103 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo NameOnCard',
  104 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardAddress',
  105 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardPostalCode',
  106 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CommercialCardCode',
  107 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo TransactionMode',
  108 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnInputInfo CreditCardTxnType',
  109 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultCode',
  110 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ResultMessage',
  111 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CreditCardTransID',
  112 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo MerchantAccountNumber',
  113 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AuthorizationCode',
  114 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSStreet',
  115 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo AVSZip',
  116 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo CardSecurityCodeMatch',
  117 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ReconBatchID',
  118 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentGroupingCode',
  119 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo PaymentStatus',
  120 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationTime',
  121 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo TxnAuthorizationStamp',
  122 => 'SalesReceiptLineAdd CreditCardTxnInfo CreditCardTxnResultInfo ClientTransID',
  123 => 'SalesReceiptLineAdd DataExt OwnerID',
  124 => 'SalesReceiptLineAdd DataExt DataExtName',
  125 => 'SalesReceiptLineAdd DataExt DataExtValue',
  126 => 'SalesReceiptLineGroupAdd ItemGroupRef ListID',
  127 => 'SalesReceiptLineGroupAdd ItemGroupRef FullName',
  128 => 'SalesReceiptLineGroupAdd Desc',
  129 => 'SalesReceiptLineGroupAdd Quantity',
  130 => 'SalesReceiptLineGroupAdd UnitOfMeasure',
  131 => 'SalesReceiptLineGroupAdd ServiceDate',
  132 => 'SalesReceiptLineGroupAdd DataExt OwnerID',
  133 => 'SalesReceiptLineGroupAdd DataExt DataExtName',
  134 => 'SalesReceiptLineGroupAdd DataExt DataExtValue',
  135 => 'DiscountLineAdd Amount',
  136 => 'DiscountLineAdd RatePercent',
  137 => 'DiscountLineAdd IsTaxable',
  138 => 'DiscountLineAdd AccountRef ListID',
  139 => 'DiscountLineAdd AccountRef FullName',
  140 => 'SalesTaxLineAdd Amount',
  141 => 'SalesTaxLineAdd RatePercent',
  142 => 'SalesTaxLineAdd AccountRef ListID',
  143 => 'SalesTaxLineAdd AccountRef FullName',
  144 => 'ShippingLineAdd Amount',
  145 => 'ShippingLineAdd AccountRef ListID',
  146 => 'ShippingLineAdd AccountRef FullName',
  147 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>