//This function puts the right number of days in the day box for the given month
//It also makes sure that the ending day is not before the beginning day
function date_check(calling_object, start_day, start_month, start_year, end_day, end_month, end_year){
    //Check to see if begin is after end
    verify_span_result = verify_span(calling_object, start_day, start_month, start_year, end_day, end_month, end_year);

    //If the span was negative and the end date needs to match the begin date
    //and the start month or year was the calling_object
    if(verify_span_result == false &&(calling_object == start_year || calling_object == start_month))
    {
        //Update the start day box
        fill_days(calling_object, start_day, start_month, start_year, end_day, end_month, end_year);
        //Update the end day box
        fill_days(end_month, start_day, start_month, start_year, end_day, end_month, end_year);
    }

    //If the span is ok and the start month or year was the calling object then update the days in the start day box
    if(verify_span_result == true &&(calling_object == start_year || calling_object == start_month))
    {
        //Update the start day box
        fill_days(calling_object, start_day, start_month, start_year, end_day, end_month, end_year);
    }

    //If the end month or year was the calling object then update the days in the end day box
    if(calling_object == end_year || calling_object == end_month)
    {
        //Update the end day box
        fill_days(calling_object, start_day, start_month, start_year, end_day, end_month, end_year);

        //Verify the span one more time because fill_days resets day to 1 and the end date may jump
        //before the start date (i.e.  start->2-13-2002 end->3-15-2002 change end to ->2-15-2002
        //the first verify_span will be ok but then the end day will be reset to 1 and this will
        //be an inconsistent state; calling verify_span again will set end to 2-13-2002)
        verify_span(calling_object, start_day, start_month, start_year, end_day, end_month, end_year);
    }

}

//This function fills the day boxes with the appropriate number of days for the given month
function fill_days(calling_object, start_day, start_month, start_year, end_day, end_month, end_year){
    //If the calling_object is start then fill the start day box
    //If the calling_object is end then fill the end box
    if(calling_object == start_year || calling_object == start_month)
    {
        timeA = new Date(start_year.options[start_year.selectedIndex].text, start_month.options[start_month.selectedIndex].value,1);
        timeDifference = timeA - 86400000;
        timeB = new Date(timeDifference);

        //Get the days in the month
        var daysInMonth = timeB.getDate();

        //Nullify all the current options
        for (var i = 0; i < start_day.length; i++)
        {
            start_day.options[0] = null;
        }

        //Fill day box with appropriate number of days
        for (var i = 0; i < daysInMonth; i++)
        {
            start_day.options[i] = new Option(i+1);
            start_day.options[i].value = i+1;
        }
        start_day.options[0].selected = true;//Set the first of the month as selected
    }
    if(calling_object == end_year || calling_object == end_month)
    {
        timeA = new Date(end_year.options[end_year.selectedIndex].text, end_month.options[end_month.selectedIndex].value,1);
        timeDifference = timeA - 86400000;
        timeB = new Date(timeDifference);

        //Get the days in the month
        var daysInMonth = timeB.getDate();

        //Nullify all the current options
        for (var i = 0; i < end_day.length; i++)
        {
            end_day.options[0] = null;
        }

        //Fill day box with appropriate number of days
        for (var i = 0; i < daysInMonth; i++)
        {
            end_day.options[i] = new Option(i+1);
            end_day.options[i].value = i+1;
        }
        end_day.options[0].selected = true;//Set the first of the month as selected
    }
}

//This function determines whether the end date is before the beginning date
//If so, it sets the end date to be equal to the begin date
function verify_span(calling_object, start_day, start_month, start_year, end_day, end_month, end_year){
    //Create date objects for start and end times
    var start_time = new Date(start_year.value, start_month.value-1, start_day.value);
    var end_time = new Date(end_year.value, end_month.value-1, end_day.value);

    //Get the time difference in milliseconds and convert it to hours
    var hours = (end_time - start_time)/(1000*60*60)-0;

    //Check to see if end time is before start time
    if(end_time < start_time) //If so then set end boxes equal to start boxes
    {
        //If it's an end day then fill the day box first
        if(calling_object == end_year || calling_object == end_month)
        {
            //Update the end day box
            fill_days(calling_object, start_day, start_month, start_year, end_day, end_month, end_year);
        }
        end_day.options[start_day.selectedIndex].selected = true;
        end_month.options[start_month.selectedIndex].selected = true;
        end_year.options[start_year.selectedIndex].selected = true;

        return false;
    }
    else
    {
        return true;
    }
}