window.nogDataTables = [];
function nogDataTable(options){
	for(var i in options){
		if(i == 'dataTable') for(var d in options[i]) this[d] = options[i][d];
		else this[i] = options[i];
	}
	if(typeof(this.dataTableId) == 'undefined') this.dataTableId = 0;
	if(typeof(this.cache_id) == 'undefined') this.cache_id = 0;
	if(typeof(this.suspend_load) == 'undefined') this.suspend_load = 0;
	if(typeof(this.remember_inputs) == 'undefined') this.remember_inputs = 0;
	if(typeof(this.headers) == 'undefined') this.headers = null;
	if(typeof(this.userTableSettings) == 'undefined') this.userTableSettings = {};
	if(typeof(this.fromCacheReload) == 'undefined') this.fromCacheReload = false;
	if(typeof(this.dtIndex) == 'undefined') this.dtIndex = null;
	if(typeof(this.aLengthMenu) == 'undefined') this.aLengthMenu = null;
	if(typeof(this.iDisplayLength) == 'undefined') this.iDisplayLength = null;
	
	this.GeneratePagination_resize_event_id = 0;
	this.needs_refreshed = false;
	this.has_loaded = false;
	this.rememberedInputValues = {};

	this.RefreshIfNeeded = function(){
		if(!this.needs_refreshed) return;
		this.Refresh();
		this.needs_refreshed = false;
	};

	this.UpdateHeaderPos = function(){
		if(window.slow_cpu) return;
		
		var tbl = $('#'+this.dataTableId);
		if(tbl.is(':visible')){
			var header = tbl.find('.data_table_header_row');
			tbl.removeClass('floating_dt_header');
			header.find('th').css('top', '0px');
			
			//header.css('top', '0px');
			var topH = $('#uiTopBar').height();
			if(topH == null) topH = 0;
			var tabViewParent = tbl.parents('.tabsView');
			if(tabViewParent && tabViewParent.length > 0){
				var h = tabViewParent.find('.uiTaskBar').height();
				if(h) topH += h;
			}
			var mainTaskBar = $('body > .uiTaskBarIFrameBackground > .uiTaskBar');
			if(mainTaskBar && mainTaskBar.length > 0){
				var h = mainTaskBar.height();
				if(h) topH += h;
			}

			var headerOffset = parseInt(header.position().top);
			var offsetParent = header;
			var i = 0;
			while(offsetParent.length > 0 && !offsetParent.is('html, body, #section_view, #content, .section_content, .main_index_page')){
				offsetParent = offsetParent.offsetParent();	
				headerOffset += parseInt(offsetParent.position().top);
				i++;
				if(i > 32){
					console.log('Failed to resolve dataTable header offset!');
					break;
				}
			}
			headerOffset += 3;
			
			var start  = header.offset().top - topH;
			if(start < 0){
				var view = $('#section_view');
				if(view.length == 0) view = $('body');
				var offset = (this.request_tmpl == 'iframe' || this.request_tmpl == 'blank' ? topH : 0) - headerOffset;
			
				tbl.addClass('floating_dt_header');
				header.find('th').css('top', offset+'px');
			}
		}
		else if(tbl.is('floating_dt_header')){
			tbl.removeClass('floating_dt_header');
			tbl.find('.data_table_header_row').css('top', '0px');
		}
	};
	
	this.Make = function(){
		if(typeof(this.Make.made) == 'undefined'){
			if(typeof(window.STR_SEARCH) == 'undefined') window.STR_SEARCH = 'Search';
			if(typeof(window.STR_FIRST) == 'undefined') window.STR_FIRST = 'First';
			if(typeof(window.STR_LAST) == 'undefined') window.STR_LAST = 'Last';
			if(typeof(window.STR_NEXT) == 'undefined') window.STR_NEXT = 'Next';
			if(typeof(window.STR_PREVIOUS) == 'undefined') window.STR_PREVIOUS = 'Prev';
			if(typeof(window.STR_SHOW) == 'undefined') window.STR_SHOW = 'Show';
			if(typeof(window.STR_PROCESSING) == 'undefined') window.STR_PROCESSING = 'Processing';
			if(typeof(window.STR_NO_RECORDS_FOUND) == 'undefined') window.STR_NO_RECORDS_FOUND = 'No Records Found';
			if(typeof(window.STR_FILTERED_FROM) == 'undefined') window.STR_FILTERED_FROM = 'filtered from';
			if(typeof(window.STR_ENTRIES) == 'undefined') window.STR_ENTRIES = 'entries';
			if(typeof(window.STR_OF) == 'undefined') window.STR_OF = 'of';
			if(typeof(window.STR_EXPORT) == 'undefined') window.STR_EXPORT = 'Export';
			if(typeof(window.STR_REFRESH) == 'undefined') window.STR_REFRESH = 'Refresh';
			if(typeof(window.STR_EDIT_REPORT) == 'undefined') window.STR_EDIT_REPORT = 'Edit Report';
			if(typeof(window.STR_USER_SETTINGS) == 'undefined') window.STR_USER_SETTINGS = 'User Settings';

			this.Make.made = true;
			this.needs_refreshed = false;

			var elm = $('#'+this.dataTableId);
			if(this.dtIndex !== null && this.dtIndex !== false) elm[0].dtIndex = this.dtIndex;
			UI.show_loading();
			var auto_parent_frame_resize_count = 0;
			var ops = {
				"bProcessing": true,
				"bServerSide": true,
				"sAjaxSource": this.src_url,
				"fnServerParams": (function ( aoData ) {
					aoData.push( { "name": "nosearch", "value": this.nosearch } );
					for(var i in this.userTableSettings){
						aoData.push( { "name": "userTableSettings["+i+"]", "value": this.userTableSettings[i] } );
					}

					$('#'+this.dataTableId+'_covertop').remove();
					//Show Loading Spinner(s)
					UI.show_loading();
					var table = $('#'+this.dataTableId);
					var icon = $(table[0].parentNode).find('div.dataTables_filter .css-search-and-refresh-control');
					table[0].refreshHeaderSortClasses();
					$(icon).addClass('animate');
				}).bind(this),
				"fnDrawCallback": (function( oSettings ) {
					this.has_loaded = true;
					this.needs_refreshed = false;
					var table = $('#'+this.dataTableId);
					table.css('width', '100%');

					//Hide Loading Spinner
					var table = $('#'+this.dataTableId);
					table[0].refreshHeaderSortClasses();
					var icon = $(table[0].parentNode).find('div.dataTables_filter .css-search-and-refresh-control');
					$(icon).removeClass('animate');
					
					//Update Export Dialog Information
					var export_dialog = $('#'+this.dataTableId+'_export_dialog');
					export_dialog.find('[name="call"]').val(oSettings.sAjaxSource);
					export_dialog.find('[name="search"]').val($('#'+this.dataTableId+'_filter').find('.uiSearchSettings').val());//uiSearchSettings
					export_dialog.find('[name="length"]').val(oSettings._iDisplayLength);
					export_dialog.find('[name="start"]').val(oSettings._iDisplayStart);
					export_dialog.find('[name="sortCol"]').val(oSettings.aaSorting[0][0]);
					export_dialog.find('[name="sortDir"]').val(oSettings.aaSorting[0][1]);
					if(typeof(oSettings.oInstance[0]) != 'undefined'){
						export_dialog.find('[name="sorting"]').val(JSON.stringify(oSettings.oInstance[0].dataTableSortHistory.history));
					}

					//Copy TH classes to TD
					var copy_classes = [];
					$('#'+this.dataTableId+' > thead > tr.data_table_header_row > th').each(function(index){
						copy_classes[index] = [];
						var _copy_classes = $(this).attr('copy_classes');
						_copy_classes     = _copy_classes.split(' ');
						for(var i in _copy_classes){
							var copy_class = _copy_classes[i];
							if(copy_class == '') continue;
							if(copy_classes[index].indexOf(copy_class) == -1){
								copy_classes[index].push(copy_class);
							}
						}
					});
					$('#'+this.dataTableId+' > tbody > tr').each(function(){
						$(this).children('*').each(function(i){
							var _copy_classes = copy_classes[i];
							for(var x in _copy_classes){
								$(this).addClass(_copy_classes[x]);   
							}
						}); 
					});
					
					var sColumns = '';
					var sColumnNames = '';
					for(var i in oSettings.aoColumns){
						sColumns     += oSettings.aoColumns[i]['sName']+',';
						sColumnNames += oSettings.aoColumns[i]['sTitle']+',';
					}
					export_dialog.find('[name="sColumns"]').val(sColumns);
					export_dialog.find('[name="sColumnNames"]').val(sColumnNames);
					
					if(this.isSelectable){
						$(table).find('tr').css('cursor', 'pointer').click(function(event){
							if($(event.target).is('input')) return;
							event.preventDefault();
							$(this).find('input[type="radio"]').click();
						});
						
						$(table).find('tr').each(function(){
							$(this).children().css('width', '99%');
							$(this).children().first().css('width', '30px');
						});
						
						if(this.fnSelectCallBack){
							var _this = this;
							$(table).find('tr').find('input[type="radio"]').click(function(){
								eval(_this.fnSelectCallBack+'(this.value);');
							});
						}
					}
					
					this.GeneratePagination.current_page = Math.floor(oSettings._iDisplayStart / oSettings._iDisplayLength);
					this.GeneratePagination.page_count = Math.ceil(oSettings._iRecordsDisplay / oSettings._iDisplayLength);
					this.GeneratePagination();
					
					if(typeof(oSettings.json) != 'undefined' && typeof(oSettings.json.footer) != 'undefined'){
						//Append Footer
						var thead = $($(table).children('thead')[0]);
						var th_headers = $(thead).find('tr.data_table_header_row > th');
						var footer_tr = $('<tr class="data_table_footer_row">');
						th_headers.each(function(){
							var db_field = $(this).attr('db_field');
							var td = $('<td style="border-top-width: 2px;" class="'+$(this).attr('copy_classes')+'">');
							td.html(typeof(oSettings.json.footer[db_field]) != 'undefined' ? oSettings.json.footer[db_field] : '');
							td.appendTo(footer_tr);
						});
						var tbody = $($(table).children('tbody')[0]);
						tbody.append(footer_tr);
					}
					
					if(typeof(this.fnDrawCallBack) != 'undefined' && this.fnDrawCallBack){
						eval(this.fnDrawCallBack+"(table, oSettings.json)");
					}

					this.MakeEditiables();
					
					UI.hide_loading();
					setTimeout('MetaMenu.processView_createMetaMenus($(\'#'+this.dataTableId+'\')[0]);', 1);
					setTimeout('UI.processView_SetNavHooks();', 2);
					setTimeout((function(){
						$('.section_content').css('overflow', 'hidden');
						this.AutoFillHeight();
						this.AutoFillWidth();
						$('.section_content').css('overflow', 'auto');
						UI.resize();
						if(window != top) top.UI.resize();
					}).bind(this), 3);
					this.revalidateUIFilterSearchInColumnStyle();
					
					if(this.request_tmpl == 'iframe' && (!this.suspend_auto_parent_frame_resize || this.suspend_auto_parent_frame_resize && auto_parent_frame_resize_count == 0)){
						if(typeof(window.frameElement) != 'undefined' && window.frameElement != null){
							var funcResizeParentFrame = (function(){
								if(top.UI.menuType === 'mdi') return;
								auto_parent_frame_resize_count++;
								if (this.suspend_auto_parent_frame_resize && auto_parent_frame_resize_count > 1) return;
								var paddingBottom = 4;
								var minShrinkBySize = 64;
								var dtw = $('#'+this.dataTableId+'_wrapper');
								var offsetTop = {top: 0};
								try{
									offsetTop = dtw.offset();
								}
								catch(err){
									return;//Parent window not loaded yet
								}
								offsetTop = offsetTop.top;
								var currMinHeight = window.frameElement.contentWindow.$(window.frameElement).css('min-height');
								if(typeof(currMinHeight) == 'undefined' || currMinHeight == null) currMinHeight = '';
								currMinHeight = parseFloat(currMinHeight.replace(/px$/, ''));
								var newMinHeight = dtw.fullHeight() + offsetTop + paddingBottom;
								if(currMinHeight == 0 || currMinHeight < newMinHeight  || Math.abs(newMinHeight - currMinHeight) > minShrinkBySize){
									window.frameElement.contentWindow.$(window.frameElement).css('min-height', newMinHeight);
								}
							}).bind(this);
							UI.resize(funcResizeParentFrame);
							funcResizeParentFrame();
						}
					}
					if(this.remember_inputs) this.hookInputsToRemember();
				}).bind(this),
				'aaSorting': [[this.defaultSortByIndex, this.defaultSortDir]],
				"aoColumnDefs": this.columnDefs,
				"oLanguage": {
					"sSearch": '<span style="position: relative; top: 5px; padding-right: 8px;">'+window.STR_SEARCH+" </span><div style=\"display: inline-block; position: relative;\">"+$('#search_and_refresh_control_proto_'+this.dataTableId+'').html()+" <span id=\"search_"+this.dataTableId+"_anchor\"></span> _INPUT_ <span onclick=\"$(this.parentNode).find('input[type=\\'text\\']').val('').keyup(); window.datatable_instance_"+this.dataTableId+".revalidateUIFilterSearchInColumnStyle();\" class=\"btnClearSearch\">X</span></div>",
					"oPaginate": {
						"sFirst": STR_FIRST,
						"sLast": STR_LAST,
						"sNext": STR_NEXT,
						"sPrevious": STR_PREVIOUS
					},
					"sLengthMenu": STR_SHOW+' _MENU_',
					"sProcessing":   STR_PROCESSING,
					"sZeroRecords": STR_NO_RECORDS_FOUND,
					"sEmptyTable":   STR_NO_RECORDS_FOUND,
					"sInfoEmpty":    STR_NO_RECORDS_FOUND,
					"sInfoFiltered": '('+STR_FILTERED_FROM+' _MAX_ '+STR_ENTRIES+')',
					"sInfo":         '_START_ - _END_ '+STR_OF+' _TOTAL_',
				}
			};
			if(this.aLengthMenu != null) ops['aLengthMenu'] = this.aLengthMenu;
			if(this.iDisplayLength != null) ops['iDisplayLength'] = this.iDisplayLength;
			if(this.suspend_load) ops['iDeferLoading'] = 0;
			elm.dataTable(ops).fnSetFilteringDelay(500);
			elm[0].nogDataTable = this;
			
			setTimeout((function(){
				$('#'+this.dataTableId+'_wrapper .css-search-and-refresh-control').removeClass('event-bound');
				if(typeof(seachAndRefreshBindEvents) === 'undefined') $(document).ready(seachAndRefreshBindEvents);
				else seachAndRefreshBindEvents();
				this.AddColumSearchUI();
				var _elm = $(elm[0].parentNode)[0];
				if(typeof(_elm.tabEventHooked) != 'undefined') return;
				_elm.tabEventHooked = true;
				var search = $(_elm).find('.uiSearchSettings');
				if(search.length > 0 && top.UI.mouseConfirmed)
					if(!document.activeElement || document.activeElement.tagName == 'BODY')
						search[0].focus();
				search.keypress((function(e){
					if(e.keyCode == 9 || e.keyCode == 13){
						e.preventDefault();
						var tbody = $(elm).children('tbody')[0];
						var aLinks = $(tbody).find('a');
						if(aLinks.length > 0) aLinks[0].focus();
					}
					this.revalidateUIFilterSearchInColumnStyle();
				}).bind(this));
			}).bind(this), 100);
			
			var funcBindScrollEvent = null;
			funcBindScrollEvent = (function(){
				if(elm.is(':visible') == false){
					setTimeout(funcBindScrollEvent, 200);
					return;
				}
				var cssNext = '#section_view, .main_index_page, body, .section_content, #content';
				var view = elm.closest(cssNext);
				for(var i = 0; i < 8; i++){
					var s = getComputedStyle(view[0]).getPropertyValue('overflow-y');
					if(s === 'auto' || s === 'scroll') break;
					view = view.closest(cssNext);
					if(view.length == 0 || view.is('body')) break;
				}
				view.scroll((function() { 
					uiWaitForFinalEvent(this.UpdateHeaderPos(), 10, 'ID_DT_SCROLL_EVENT_'+this.dataTableId+'');
				}).bind(this));
			}).bind(this);
			funcBindScrollEvent();
			
			UI.resize((function(){
				this.UpdateHeaderPos();
			}).bind(this));
			
			$('#search_'+this.dataTableId+'_anchor').parent('div').find('input[type="text"], input[type="search"]').attr('tabindex', '1').addClass('focus-on-tab-activate').addClass('uiSearchSettings');
			$('#search_'+this.dataTableId+'_anchor').remove();
			
			$('#'+this.dataTableId+' .dataTableHeader_NoSort').each(function(){
				this.onclick = null; 
				$(this).unbind();
			});
			
			//Refresh Button
			var btnRefresh = $('<div>').text(window.STR_REFRESH);
			btnRefresh.click((function(){
				var now = Math.round(Date.now() / 1000);
				if(typeof(this.lastRefreshTime) === 'undefined' || this.lastRefreshTime != now){
					this.Refresh();
					this.lastRefreshTime = now;
				}
			}).bind(this));
			btnRefresh.addClass('uiTaskBarButton').addClass('uiTaskBarButton-Refresh').css('float', 'right').css('margin-left', '4px').css('user-select', 'none');
			btnRefresh.appendTo($('#'+this.dataTableId+'_length'));
			var btnRefreshImg = $('<img>');
			btnRefreshImg.attr('src', 'images/refresh.png').attr('alt', '[X]').css('height', '24px').css('margin-bottom', '-7px').css('margin-right', '4px');
			btnRefreshImg.attr('title', window.STR_REFRESH);
			btnRefreshImg.prependTo(btnRefresh);

			//Export Button
			if(!this.hide_export){
				var btnExport = $('<div>').text(STR_EXPORT);
				btnExport.click((function(){ this.Export(); }).bind(this));
				btnExport.addClass('uiTaskBarButton').addClass('uiTaskBarButton-Export').css('float', 'right').css('margin-left', '12px').css('user-select', 'none');
				btnExport.appendTo($('#'+this.dataTableId+'_length'));
				var btnExportImg = $('<img>');
				btnExportImg.attr('src', 'images/save.png').attr('alt', '[X]').css('height', '24px').css('margin-bottom', '-7px').css('margin-right', '4px');
				btnExportImg.attr('title', STR_EXPORT);
				btnExportImg.prependTo(btnExport);
			}

			//Is From Custom Query Builder
			if(this.queriesid && this.hasAccessRights_custom_queries_view){
				var btnCustQueriesEdit = $('<div>');
				btnCustQueriesEdit.click(function(){
					UI.load(CI_BASE_URL+'custom_queries/?&cmd=edit&id='+parseInt(this.queriesid));
				});
				btnCustQueriesEdit.addClass('uiTaskBarButton').addClass('uiTaskBarButton-CustomQueryEdit').css('float', 'right').css('margin-left', '8px').css('margin-right', '-7px').css('user-select', 'none');
				btnCustQueriesEdit.appendTo($('#'+this.dataTableId+'_length'));
				var btnCustQueriesEditImg = $('<img src="images/edit.png" style="height: 24px; width: 24px;">');
				btnCustQueriesEditImg.attr('title', STR_EDIT_REPORT);
				btnCustQueriesEditImg.prependTo(btnCustQueriesEdit);
			}

			//User Settings Menu
			if(!this.hideUserSettingsMenu && !this.queriesid){
				var btnSettings = $('<div>');
				btnSettings.click((function(){ this.UserSettings(); }).bind(this));
				btnSettings.addClass('uiTaskBarButton').addClass('uiTaskBarButton-Settings').css('float', 'right').css('margin-left', '8px').css('margin-right', '-7px').css('user-select', 'none');
				btnSettings.appendTo($('#'+this.dataTableId+'_length'));
				var btnSettingsImg = $('<span class="imgIcon24 imgDTSettings"></span>');
				btnSettingsImg.attr('title', STR_USER_SETTINGS);
				btnSettingsImg.prependTo(btnSettings);
			}

			$('#'+this.dataTableId+'_length > label').css('position', 'relative').css('top', '7px');
		}
		
		//Register Use Tables
		if(typeof(UI) != 'undefined' && typeof(UI.dataTable_RegisterTableUse) != 'undefined'){
			for(var i in this.usesTablesList){
				UI.dataTable_RegisterTableUse(this, this.usesTablesList[i]);
			}
		}

		//Needs Refreshed?
		if(this.needs_refreshed){
			this.needs_refreshed = false;
			if(this.has_loaded)
				this.Refresh();
		}
	};
	
	this.GeneratePagination = function(resize_event_id){
		
		//Needs Refreshed?
		if(this.needs_refreshed){
			this.needs_refreshed = false;
			if(this.has_loaded)
				this.Refresh();
			return;
		}

		var event_id = this.GeneratePagination_resize_event_id;
		if(typeof(resize_event_id) != 'undefined' && event_id < resize_event_id) return;

		var current_page = this.GeneratePagination.current_page;
		var page_count   = this.GeneratePagination.page_count;
		var wInfo        = $('#'+this.dataTableId+'_info').width();
		var oInfo        = $('#'+this.dataTableId+'_info').offset();
		var wNextPrev    = $('#'+this.dataTableId+'_paginate').width();
		var wWrapper     = $('#'+this.dataTableId+'_wrapper').width();
		var width        = (wWrapper - (wInfo + wNextPrev)) - 12;
		var maxPageLinks = 30;//Each direction
		
		var pre_pages = [];
		for(var i = maxPageLinks; i > 0; i--){
			if(current_page - i >= 0)
				pre_pages.push(current_page - i);
		}
		
		var post_pages = [];
		for(var i = 1; i < maxPageLinks; i++){
			if(current_page + i < page_count)
				post_pages.push(current_page + i);
		}
		
		//Create custom Paginate area (if not exists)
		if($('#'+this.dataTableId+'_custom_pageinate').length == 0)
			$('<div id="'+this.dataTableId+'_custom_pageinate" class="datatable_custom_pageinate"></div>').appendTo($('#'+this.dataTableId+'_wrapper')[0]);
		var elm = $('#'+this.dataTableId+'_custom_pageinate');
		elm.width(width);
		elm.css('left', (wInfo+8)+'px');
		
		//Get Perfered height (just one line)
		elm.html('8Hgj|');
		var hPerfered = elm.height()+2;
		var hCurrent  = elm.height();
		elm.html(' ');

		//Add the page items to the area... and try again if there are too many (>1 line)
		var i = 0;
		while((i == 0 || hCurrent > hPerfered) && i <= maxPageLinks){
			var html = '';
			
			//Prev Pages
			var html_first = pre_pages.length > 0;
			for(var p in pre_pages){
				if(p < i) continue;
				var sPage = parseInt(pre_pages[p]) + 1;
				if(parseInt(pre_pages[p]) == 0) html_first = false;
				html += '<a href="javascript:$(\'#'+this.dataTableId+'\').dataTable().fnPageChange('+parseInt(pre_pages[p])+')">'+sPage+'</a> ';
			}
			if(html_first) html_first = '<a href="javascript:$(\'#'+this.dataTableId+'\').dataTable().fnPageChange(0);">'+STR_FIRST+'</a> ';
			else html_first = '';
			
			//Current Page
			html += '<span>'+(parseInt(current_page)+1)+'</span>';
			
			//Next Pages
			var html_last  = post_pages.length > 0;
			for(var p in post_pages){
				if(p >= maxPageLinks - i) continue;
				var sPage = parseInt(post_pages[p]) + 1;
				if(parseInt(post_pages[p]) == page_count - 1) html_last = false;
				html += '<a href="javascript:$(\'#'+this.dataTableId+'\').dataTable().fnPageChange('+parseInt(post_pages[p])+')">'+sPage+'</a> ';
			}
			if(html_last ) html_last  = '<a href="javascript:$(\'#'+this.dataTableId+'\').dataTable().fnPageChange('+(parseInt(page_count)-1)+');">'+STR_LAST+'</a> ';
			else html_last = '';
			
			//Update HTML
			elm.html(html_first+html+html_last);
			hCurrent = elm.height();
			i++;
		}
		if(maxPageLinks <= i - 1){
			elm.html(' ');
		}
	};
	
	this.MakeEditiables_LabelFromValue = function(value, type){
		var str = '';
		if(type == 'namepicker'){
			var company = URL_Param.decode(value.match(/company=([^&]+)?/)[1]);
			var fname   = URL_Param.decode(value.match(/fname=([^&]+)?/)[1]);
			var lname   = URL_Param.decode(value.match(/lname=([^&]+)?/)[1]);
			var mname   = URL_Param.decode(value.match(/mname=([^&]+)?/)[1]);

			if(typeof(company) != 'undefined' && company != 'undefined' && company.trim() != '')
				str = company.trim();
			else{
				str += typeof(fname) != 'undefined' && fname != '' ? fname.trim()+' ' : '';
				str += typeof(mname) != 'undefined' && mname != '' ? mname.trim()+' ' : '';
				str += typeof(lname) != 'undefined' && lname != '' ? lname.trim()+' ' : '';
			}
		}
		else str = value;
		str = str.replace('&', '&amp;').replace('<', '&lt;').replace('>', '&gt;').trim();
		return str;
	};
	
	this.MakeEditiables = function(){
		$('#'+this.dataTableId+' .editable').each(function(){
			var hidden_id = $(this).attr('target_id');
			var _type = 'text';
			if($(this).is('.date'))        _type = 'datepicker';
			if($(this).is('.textarea'))    _type = 'textarea';
			if($(this).is('.namepicker'))  _type = 'namepicker';
			if($(this).is('.statepicker')) _type = 'statepicker';

			$(this).editable(
				function(value, settings){
					var link  = $(settings.sender.parentNode).attr('href');
					var filteredValue = this.MakeEditiables_LabelFromValue(value, _type);
					if(filteredValue && link){
						filteredValue = '<a onclick="event.preventDefault(); event.stopPropagation(); UI.load(this, null, null, null, true); return false;" href="'+link+'">'+filteredValue+'</a>'
					}
					if($(settings.sender).is('.statepicker'))
						$(settings.sender).text($.editable.states[$(settings.sender).text()]);
					else
						$(settings.sender).html(filteredValue ? filteredValue : settings.orgVal);
					$(settings.sender).find('input').val(value);
					
					if(typeof(settings.sender.lastSentValue) == 'undefined') settings.sender.lastSentValue = settings.orgVal;
					
					if(settings.sender.lastSentValue != value){
						$.ajax({
							type: "POST",
							url:  CI_BASE_URL+"datatable_ajax/SaveFromDataTableEdit",
							data: {'value': value, 'name': settings.hiddenid},
							success: function(data, status){
								if(data){
									alert(data);
									$(settings.sender).html(settings.orgVal);
									$(settings.sender).find('input').val(settings.orgVal);
								}
								else{
									//JSON encode...
									var json = '';
									if($(settings.sender).is('.statepicker')){
										var vals = {'id': value};
										json = JSON.stringify(vals);
									}
									else{
										var _vals = [];
										parse_str(value, _vals)
										var vals = {};
										for(var i in _vals) vals[i] = _vals[i];
										json = JSON.stringify(vals);
									}
									
									
									$(settings.sender.parentNode).attr('type_data', json);
									if($(settings.sender).is('.statepicker')){
										$(settings.sender).text($.editable.states[$(settings.sender).text()]);
									}
									else{
										$(settings.sender).html(filteredValue ? filteredValue : settings.orgVal);
									}
									$(settings.sender).find('input').val(value);
									settings.sender.lastSentValue = value;
								}
							},
							error: function(jq, status, error){
								alert(STR_ERROR_SAVING_FIELD+' '+error);
							}
						});
					}
					return(filteredValue); 
				}, 
				{
					type: _type,
					datepicker: {
						dateFormat: 'yy-mm-dd', 
						numberOfMonths: 1 
					},
					rows: 3,
					sender: this,
					orgVal: $(this).text(),
					onblur: 'submit',
					indicator: "<img src='img/indicator.gif'>",
					tooltip: '',
					placeholder: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
					height: 18,
					width: 125,
					style: "inherit",
					select: true,
					hiddenid: hidden_id
				}
			);
			
			$(this).click(function(event){
				event.preventDefault();
				event.stopPropagation();
			});
			
			var cellParent = $(this).parents('td, th')[0];
			$(cellParent).addClass('datatable_cell_editable');
			$(cellParent).click(function(event){
			$(this).find('.editable').click();
			event.preventDefault();
			});
		});
		
		$('#'+this.dataTableId+' .datatable_editible_sub_meta').each(function(){
			MetaMenu.metaMenu_Make(this, $(this).attr('menu_type'));
		});
	};
	
	this.AutoFillHeight = function(){
		//Shink down members of a generic-stack-view that is fullscreen
		var table = $('#'+this.dataTableId)[0];
		var parent = $(table).closest('.generic-stack-view-item-fullscreen-part');
		if(parent.length > 0){
			var view = parent[0];
			var padding_top    = parseInt($(view).css('padding-top').replace(/[^\d]/g));
			var padding_bottom = parseInt($(view).css('padding-bottom').replace(/[^\d]/g));
			var padding = padding_top+padding_bottom;
			var viewOffset  = $(view).offset();
			var tableOffset = $(table).offset();
			if(tableOffset.top == 0) return;
			var topOffset   = tableOffset.top - viewOffset.top;
			var pb          = $('#'+this.dataTableId+'_wrapper').css('padding-bottom');
			var viewH = $(view).height();
			var minH        = ((viewH - topOffset) + padding) - parseInt(pb != null ? pb.replace('px', '') : 0) - 1;
			if(viewH < minH) minH = viewH;
			if($(table).height() > minH){
				$(table).hide().css('height', minH+'px').show();
			}
		}
	};
	
	this.AutoFillWidth = function(){
		var view  = $('.section_content')[0];
		if(typeof(view) == 'undefined') view = $('body')[0];
		var table = $('#'+this.dataTableId)[0];
		$(table).find('td, th').show();
		$(table).css('width', '100%');
		
		if($(table).width() > $(view).width()){
			var priorities = [];
			var columns = [];
			var i = 0;
			$(table).find('.data_table_header_row th').each(function(){
				$(this).attr('index', i); i++;
				var imp = parseInt($(this).attr('importance'));
				if(priorities.indexOf(imp) == -1) priorities.push(imp);
				if(typeof(columns[imp]) == 'undefined') columns[imp] = [];
				columns[imp].push(this);
			});
			priorities.sort();
			priorities.reverse(); 
			
			for(var p in priorities){
				var imp = priorities[p];
				if(imp == 0) break;
				columns[imp].reverse();
				for(var i in columns[imp]){
					if($(table).width() > $(view).width()){
						var header = columns[imp][i];
						this.AutoFillWidth_HideCol(parseInt($(header).attr('index')));
					}
					else{
						break;   
					}
				}
			}
		}
	};
	
	this.AutoFillWidth_HideCol = function(index){
		index++;
		$('#'+this.dataTableId+' tbody tr td:nth-child('+index+')').hide();
		$('#'+this.dataTableId+' .data_table_header_row th:nth-child('+index+')').hide();
	};
	
	this.UserSettings = function(){
		var btns = {};
		var _this = this;
		btns[STR_SAVE] = function() {
			//Build Save Data
			var saveData = {instancename: _this.instanceName};
			$(this).find('input, select, textarea').each(function(){
				//Get Name
				var name = $(this).attr('name');
				if(typeof(name) == 'undefined') return;
				//Parse Name Into Parts
				var parts = name.split('[');
				if(parts.length != 5 || parts[0] != 'dataTableSetting') return;
				var groupname = escape(parts[2].replace(/\]/g, ''));
				var propname = escape(parts[3].replace(/\]/g, ''));
				var pramname = escape(parts[4].replace(/\]/g, ''));
				//Get Value
				var val = $(this).is('[type="checkbox"]') ? (this.checked ? 1 : 0) : $(this).val();
				//Append input values to save data
				if(typeof(saveData[groupname]) == 'undefined') saveData[groupname] = {};
				if(typeof(saveData[groupname][propname]) == 'undefined') saveData[groupname][propname] = {};
				saveData[groupname][propname][pramname] = val;
			});
			//Make AJAX Call
			$.ajaxRetry({
				url: CI_BASE_URL+'datatable_ajax/SaveSettings/',
				method: 'post',
				data: saveData,
				success: function(){
					setTimeout(function(){ _this.ReloadUI(); }, 333);
				}
			});
			//Close The Diag
			$(this).dialog("close");
		};
		btns[STR_CANCEL] = function() {
			$(this).dialog("close");
		};
		$('#'+this.dataTableId+'_settings_dialog').dialog({
			height: (($(window).height() - 48) < 720) ? ($(window).height() - 48) : 720,
			width: (($(window).width() - 32) < 900) ? ($(window).width() - 32) : 900,
			modal:  true,
			buttons: btns
		});
		this.searchmode_change();
	};

	this.Export = function(){
		var btns = {};
		var _this = this;
		btns[STR_SAVE] = function() {
			var sizes = [];
			$('#'+_this.dataTableId+' .data_table_header_row > th').each(function(){
				sizes.push({
					class: $(this).attr('copy_classes'),
					db_field: $(this).attr('db_field'),
					width: $(this).outerWidth(),
				});
			});
			var frm = $('#'+_this.dataTableId+'_export_dialog > form');
			frm.find('input[name="cell_sizes"]').val(JSON.stringify(sizes));
			frm.submit();
			$(this).dialog("close");
		};
		btns[STR_CANCEL] = function() {
			$(this).dialog("close");
		};
		$('#'+this.dataTableId+'_export_dialog').dialog({
			resizable: false,
			height: 210,
			width:  350,
			modal:  true,
			buttons: btns
		});
	};
	
	this.Refresh = function(){
		//Update cache id...
		this.cache_id++;
		$('#'+this.dataTableId).setDataTableVarible('cache_id', this.cache_id);
		this.revalidateUIFilterSearchInColumnStyle();
	};
	
	this.ReloadUI = function(){
		//Update cache id...
		this.cache_id++;
		var elm = $('#'+this.dataTableId)[0];
		var dtIndex = typeof(elm) !== 'undefined' && typeof(elm.dtIndex) !== 'undefined' ? elm.dtIndex : 0;
		//Request New UI HTML
		$.ajaxRetry({
			url: CI_BASE_URL+'datatable_ajax/ReloadUI/?&tmpl=json&dtIndex='+dtIndex+'&instanceName='+this.instanceName+'&_='+this.cache_id,
			data: 'instanceName='+this.instanceName+'&_='+this.cache_id,
			method: 'post',
			dataType: 'json',
			success: (function(r){
				if(typeof(r.success) !== 'undefined' && r.success == 1){
					//Get Loaction of new HTML to Insert
					var appendAfter = $('#search_and_refresh_control_proto_'+this.dataTableId)[0];
					$(appendAfter).attr('id', $(appendAfter).attr('id')+'_PENDING_REMOVE').css('display', 'none');

					//Remove Old UI
					$('#'+this.dataTableId+', #'+this.dataTableId+'_init_script, #'+this.dataTableId+'_wrapper, #'+this.dataTableId+'_covertop, #'+this.dataTableId+'_covertop_script, #'+this.dataTableId+'_export_dialog, #'+this.dataTableId+'_settings_dialog').remove();

					//Append New UI
					$(r.html).insertAfter(appendAfter);
					appendAfter.remove();
				}
			}).bind(this),
			error: (function(r){
				
			}).bind(this),
		});
	};

	this.searchInColumn = function(value, td_sender){
		if(value == '') return;
		var search = $('#'+this.dataTableId+'_filter .uiSearchSettings');
		search.val($(td_sender).text()+decodeURIComponent("%C2%BB")+value);
		search.val(search.val().replace(decodeURIComponent("%C3%83"), ''));
		search.keyup();
		this.revalidateUIFilterSearchInColumnStyle();
	};

	this.revalidateUIFilterSearchInColumnStyle = function(){
		var search = $('#'+this.dataTableId+'_filter .uiSearchSettings');
		if(typeof(search[0]) == 'undefined') return;
		var items  = $('.dataTableFilterContainer');
		if(search.val().indexOf(decodeURIComponent("%C2%BB")) >= 0){
			items.each(function(){
				if(!$(this).is('.persistOpacity')) $(this).css('opacity', 0.5);
			});
		}
		else{
			items.each(function(){
				if(!$(this).is('.persistOpacity')) $(this).css('opacity', 1);
			});
		}
	};

	this.AddColumSearchUI = function(){
		var _this = this;
		var headers = $('#'+this.dataTableId+' .data_table_header_row > th[canColumnSearch]');
		headers.each(function(){
			//Skip user disabled search
			var this_header = this;
			var div_search_pane_container = $('<div class="data_table_header_search_container">');
			var div_search_pane    = $('<div class="data_table_header_search_area">');
			var div_search_padding = $('<div class="data_table_header_search_area_padding">');
			var input_search = $('<input type="text" value="">');
			input_search.click(function(e){
				e.preventDefault();
				e.stopPropagation();
			});
			input_search.focusout(function(){
				this_header.__onMouseLeave();
			});
			input_search.keydown(function(e){
				if(e.keyCode == 13){//keyCode 13 is Enter 
					e.preventDefault();
					e.stopPropagation();
					
					var i = $('<input type="text">').css('height', '0').css('position', 'fixed');
					i.appendTo($('body'));
					i.get(0).focus();
					i.remove();
					
					this_header.__onMouseLeave();
				}
			});
			
			this.__onMouseLeave = (function(){
				var inverse = $(this).closest('.dataTableFull').is('.floating_dt_header');
				var div = $($(this).find('.data_table_header_search_area').get(0));
				var inp = $(div.find('input').get(0));
				var tdh = inverse ? 0 : $(this).height();
				if(inp.is(':focus')) return;
				div.stop(true, false).animate({height: '0px', top: -tdh+'px'}, 160);
				if(inp.val()) _this.searchInColumn(inp.val(), this);
				inp.val('');
				$(this).removeClass('columnSearchShown');
			}).bind(this);
			
			$(this).append(div_search_pane_container.append(div_search_pane.append(div_search_padding.append(input_search))));
			
			$(this).mouseenter(function(){
				if($(this).is('.columnSearchShown')) return;
				var inverse = $(this).closest('.dataTableFull').is('.floating_dt_header');
				$(this).addClass('columnSearchShown').addClass('columnSearchShown-'+(inverse ? 'Under' : 'Over'));
				var div = $($(this).find('.data_table_header_search_area').get(0));
				var h   = $(div.find('.data_table_header_search_area_padding').get(0)).fullHeight();
				var tdh = inverse ? 0 : $(this).height();
				var y   = inverse ? 0 : -(h+tdh);
				div.stop(true, false).css('top', -tdh+'px').animate({height: h+'px', top: y+'px'}, 160);
			}).mouseleave(function(){
				this.__onMouseLeave();
			});
			
			$(this).append('<div class="data_table_header_search_icon imgSearch imgIcon24"></div>');
		});
	};

	this.hookInputsToRemember = function(){
		$('#'+this.dataTableId+' > tbody input, #'+this.dataTableId+' > tbody select, #'+this.dataTableId+' > tbody textarea').each(function(){
			var rememberedValue = this.rememberedInputValues[$(this).attr('id')];
			if(typeof(rememberedValue) != 'undefined'){
				if($(this).is('[type="checkbox"]')){
					$(this).prop('checked', rememberedValue ? true : false);
				}
				else{
					$(this).val(rememberedValue);
				}
			}
			$(this).change(function(){
				this.rememberedInputValues[$(this).attr('id')] = $(this).is('[type="checkbox"]') ? ($(this).is(':checked') ? 1 : 0) : $(this).val();
			});
		});
	};

	this.getRememberedValuesQueryString = function(clear_after){
		var str = '';
		for(var id in this.rememberedInputValues)
			str += '&'+id+'='+escape(this.rememberedInputValues[id]);
		if(typeof(clear_after) != 'undefined' && clear_after)
			this.rememberedInputValues = [];
		return str;
	};

	this.searchmode_change = function(sender, event){
		if(typeof(sender) == 'undefined' || sender === null) sender = $('[name="dataTableSetting['+this.instanceName+'][general][general][searchmode]"]')[0];
		if(typeof(sender) == 'undefined') return;
		var value = sender.value;
		var find = '';
		for(var i = 0; i <= value; i++){
			if(find !== '') find += ', ';
			find += '.dtset-searchmode-'+i.toString();
		}
		$('.dtset-searchmode').css('display', 'none').filter(find).css('display', '');
	};

	window.nogDataTables[this.dataTableId] = this;

    $(document).ready((function(){
		if(!this.headers || this.headers.length == 0){
			console.log('ERROR: Datatable is missing headers...');
			$('#'+this.dataTableId).hide();
			return;
		}
        var elm = $("#"+this.dataTableId);
        var tabView = elm.parents((UI.mainMenuMode == 'main_index' ? '.main_index_page ' : '')+'.tabsView');
        if(tabView.length == 0 || this.fromCacheReload) this.Make();
        else{
            //Get Parent Tab
            var tab = elm.parents('div[role="tabpanel"]');
            var prev = tab.prev();
            elm[0].tabId = tab[0].id.replace('tabs-', '');
            if(typeof(prev) != 'undefined' && prev.is('ul.ui-tabs-nav')){
                this.Make();
			}
			tabView.on("tabsactivate", (function( event, ui ) {
				var elm = $("#"+this.dataTableId);
				var i = $(ui.newTab[0]).attr('rel');
				if(i == elm[0].tabId) this.Make();
			}).bind(this));
        }
        this.AutoFillHeight();

		//Override popUpCalendar to fix calendar display inside of $.dialog()
		if(typeof(window.popUpCalendar) != 'undefined' && typeof(window.dt_org_popUpCalendar) == 'undefined'){
			window.dt_org_popUpCalendar = window.popUpCalendar;
			window.popUpCalendar = function(ctl, ctl2, format, offset_left, offset_top){
				window.dt_org_popUpCalendar(ctl, ctl2, format, offset_left, offset_top);
				$('#calendar').each(function(){
					$(this).css('z-index', 99999);
				});
				var element = $('#calendar').detach();
				$('body').append(element);
			};
		}
    }).bind(this));

    UI.resize((function(){
    	if(!$("#"+this.dataTableId).is(':visible')) return;
        this.AutoFillHeight();
        this.AutoFillWidth();
        this.GeneratePagination_resize_event_id++;
        setTimeout((function(){
			this.GeneratePagination(this.GeneratePagination_resize_event_id.toString());
		}).bind(this), 10);
    }).bind(this));

	return this;
}