window.nog_auto_complete_box_defaultappendTo = null;
function nog_auto_complete_box(options){

	//Wait for jquery load
	if(typeof($.fn) == 'undefined'){
		$(document).ready((function(){
			nog_auto_complete_box(this);
		}).bind(options));
		return this;
	}

	for(var i in options) this[i] = options[i];
	this.textname_css_select = this.textname.replace('/\[/ig', '\\\\[', this.textname).replace('/\]/ig', '\\\\]', this.textname);
	this.idname_css_select = this.textname.replace('/\[/ig', '\\\\[', this.textname).replace('/\]/ig', '\\\\]', this.textname);
	var txtElm = $(document.getElementById(this.textname_css_select));
	var idElm = $(document.getElementById(this.idname_css_select));
	this.txtElm = txtElm;
	this.idElm = idElm;
	
	//Either: Text input missing or Hidden input missing
	if(typeof(txtElm[0]) == 'undefined' || typeof(idElm[0]) == 'undefined')	return this;

	txtElm[0].nogAutoCompleteBox = this;
	idElm[0].nogAutoCompleteBox = this;

	this.funcBuildRanOnce = false;
	this.funcBuild = (function(){

		if(this.funcBuildRanOnce) return;
		this.funcBuildRanOnce = true;

		var txtElm = this.txtElm;
		var idElm = this.idElm;

		if(typeof(this.layoutEngine) != 'undefined'){
			if(this.layoutEngine != '' || this.layoutEngine != 'horizontal') this.layoutEngine = '';
		}	
		if(typeof(this.acceptNewValues) === 'undefined') this.acceptNewValues = false;
		this.clearAfterNextSearch = false;
		var appendTo = 'body';
		if(!this.appendTo){
			if(window.nog_auto_complete_box_defaultappendTo === null){
				if($$('#subpage .section_content').length > 0) window.nog_auto_complete_box_defaultappendTo = '#subpage .section_content';
				else if(template != 'main_index' && $('#section_view').length > 0) window.nog_auto_complete_box_defaultappendTo = '#section_view';
				else window.nog_auto_complete_box_defaultappendTo = 'body';
			}
			appendTo = window.nog_auto_complete_box_defaultappendTo;
		}
		else {
			appendTo = this.appendTo;
		}
		this.appendTo = appendTo;

		var _this = this;
		txtElm[0].afterTextChanged = (function(){
			$(this).removeClass('auto-complete-field-no-value');
			var comp_org_a = $('[id="'+_this.idname+'"]')[0].label;
			var comp_org_b = $(this).val();
			if(typeof(comp_org_a) == 'undefined' || comp_org_a == false || comp_org_a == null) comp_org_a = '';
			if(typeof(comp_org_b) == 'undefined' || comp_org_b == false || comp_org_b == null) comp_org_b = '';
			var comp_ent_a = comp_org_a.replace(/[\u00A0-\u9999]/gim, function(i) { return '&#'+i.charCodeAt(0)+';'; }).replace(/[\x00-\x1F\x7F-\x9F]/g, "");
			var comp_ent_b = comp_org_b.replace(/[\u00A0-\u9999]/gim, function(i) { return '&#'+i.charCodeAt(0)+';'; }).replace(/[\x00-\x1F\x7F-\x9F]/g, "");
			if(comp_org_b.trim() === ''){
				$(this).addClass('auto-complete-field-no-value');
				$('[id="'+_this.idname+'"]')[0].label = false;
				$('[id="'+_this.idname+'"]').attr('extra', '').val('').change();
				$('[id="'+_this.idname+'"]').removeData();
			}
			if(comp_org_b != '' && comp_org_a != comp_org_b && comp_ent_a != comp_ent_b){
				var elm = $$('#'+_this.textname_css_select);
				if(document.activeElement.id == elm[0].id) return;
				$('[id="'+_this.idname+'"]').val('');
				if(!_this.acceptNewValues){
					$(this).val('');
					elm.css('transition', 'transform 500ms');
					var shake_size  = 20;
					var shake_time  = 50;
					var shake_count = 5;
					var wait_end = 0;
					for(var i = 0; i < shake_count; i++){
						var time = (i == 0 ? shake_time / 2 : shake_time);
						var wait = i - 1 >= 0 ? (shake_time / 2) + ((i - 1) * shake_time) : 0;
						var odd  = i % 2 == 0;
						wait_end = wait + time;
						setTimeout((function(){
							elm.css({
							"transform": "translate("+(this.o ? '-' : '')+shake_size+"px, 0px)",
							"transition": "transform "+this.t+'ms'
							});
						}).bind({'t': time, 'w': wait, 'o': odd}), wait);
					}
					var notice = $$('#'+_this.textname_css_select+'_noval');
					notice.animate({'height': '100px'}, 333);
					setTimeout((function(){
						elm.css({
						"transform": "translate(0px, 0px)",
						"transition": "transform "+this.t+'ms'
						});
					}).bind({'t': shake_time / 2}), wait_end + 10);
					setTimeout(function(){
						elm.css({
						"transform": "translate(0px, 0px)",
						"transition": "transform 0ms"
						});
					}, wait_end + shake_time);
					
					setTimeout(function(){
						notice.animate({'height': '0px'}, 333);
					}, wait_end + shake_time + 500);
				}
			}
			if ($('[id="'+_this.idname+'"]').val()*1 == 0) {
				_this.auto_complete_field_check(false, null);
			}
			else {
				$(this).addClass('auto-complete-field-linked-value');
			}
		}).bind(txtElm[0]);

		txtElm.keyup(function(){
			if (this.value === '') {
				$('[id="'+_this.idname+'"]')[0].label = false;
				$('[id="'+_this.idname+'"]').attr('extra', '').val('').change();
				$('[id="'+_this.idname+'"]').removeData();
			}
		});

		txtElm[0].__autocomplete_page_start = 0;
		txtElm[0].uiAutoMenu = null;
		txtElm.autocomplete({
			layoutEngine: this.layoutEngine,
			acceptNewValues: this.acceptNewValues,
			appendTo: appendTo,
			source: '',//See: buildSourceURL
			delay: this.autocompletedelay,
			select: function(event, ui){
				_this.clearAfterNextSearch = false;
				if(typeof(ui.item.extra) == 'undefined') ui.item.extra = '';
				$('[id="'+_this.idname+'"]').val(ui.item.id).attr('extra', ui.item.extra);
				if(typeof(ui.item.extra_fields) !== 'undefined') {
					try {
						let extra_fields = JSON.parse(ui.item.extra_fields);
						if (typeof extra_fields === 'object' && extra_fields !== null && !Array.isArray(extra_fields)) $('[id="'+_this.idname+'"]').data(extra_fields);
						else $('[id="'+_this.idname+'"]').removeData();
					} catch (err) {
						$('[id="'+_this.idname+'"]').removeData();
					}
				} else $('[id="'+_this.idname+'"]').removeData();
				if (!_this.showautocompleteidboxes) {
					if (ui.item.id != '') $('[id="'+_this.textname+'"]').css('border-width', '2px');
					else $('[id="'+_this.textname+'"]').css('border-width', '1px');
				}
				_this.auto_complete_field_check(true, ui);
				$('[id="'+_this.idname+'"]').change();
				$('[id="'+_this.textname+'"]').change();
				((_this.js_after_select).bind(ui.item))();
			},
			focus: function(event, ui) {
				$('[id="'+_this.idname+'"]')[0].label = ui.item.value;
				$('[id="'+_this.idname+'"]').val(ui.item.id);
			},
			response: function(event, ui){
				this.auto_select = false;
				var rs = ui.content;
				if(rs.length == 1){
					var r = rs[0];
					if(typeof(r.exact) != 'undefined'){
						if(r.exact == this.value){
							this.auto_select = true;
						}
					}
				}
				
				//Revert the UI so that base autocomplete can append to the menu elm correctly.
				var self = $$('#'+_this.textname_css_select);
				if(self.autocomplete('option', 'layoutEngine') != ''){
					var widget = $(this).data('ui-autocomplete');
					var menu = widget.menu.element;
					if(typeof(self[0]._org_autocomplete_elm) == 'undefined') self[0]._org_autocomplete_elm = menu.clone();
					var oldMenuEmu = self[0]._org_autocomplete_elm.clone();
					widget.menu.element.replaceWith(oldMenuEmu);
					widget.menu.element = $(oldMenuEmu[0]);
				}
				
				$$('#'+_this.textname_css_select+'_loading').css('display', 'none');
			},
			set_menu_position: function(target_elm, event, ui){
				if(txtElm[0].uiAutoMenu === null) txtElm[0].uiAutoMenu = target_elm;
				if($(target_elm).css('display') == 'block'){
					if(typeof(window.template) !== 'undefined' && window.template === 'pm' && $(target_elm).css('top') === '0px'){
						$(target_elm).css('top', Math.max(0, ($(event.target).offset().top - $(window).scrollTop()) + $(event.target).height() + 6) + 'px');
					}					
					if($(target_elm).offset().left < 0){
						$(target_elm).css('left', '0px');
					}
					if(typeof(event.target.auto_select) != 'undefined' && event.target.auto_select){
						var children = $(target_elm).find('li');
						if(children.length == 1){
							var a = $(children[0]).find('a').first();
							if(a.length > 0) a.click();
							else setTimeout(function(){ $(children).mousedown() }, 10);
						}
					}
				}
			},
			buildSourceURL: function(){
				var self = $$('#'+_this.textname_css_select);
				if(typeof(_this.active_company) == 'undefined' && typeof(window.active_company) != 'undefined') _this.active_company = window.active_company;
				var url = NP_BASE_URL+'autofunctionsdb.php?pf='+_this.phpfunction+'&textname='+_this.textname+"&srcompanyid="+(typeof(_this.active_company) == 'undefined' ? -1 : _this.active_company);
				if(_this.intercompany){
					url += '&companyid='+_this.selcompanyid;
				}
				url += '&layoutEngine='+_this.layoutEngine+_this.append_ajax_url();
				if(self.autocomplete('option', 'layoutEngine') == 'horizontal'){
					url += '&start='+self[0].__autocomplete_page_start;
					url += '&limit=31'
				}
				return url;
			},
			open: function(event, ui) {
				if(txtElm[0].uiAutoMenu === null) txtElm[0].uiAutoMenu = $(".ui-autocomplete:visible");
				var menu = $(txtElm[0].uiAutoMenu);
				if(menu !== null && !menu.is('.animations-suspended')){
					var h = menu.removeClass('no-height').css('height', 'auto').css('visiblity', 'hidden').height();
					menu.addClass('no-height').addClass('animated').css('height', h+'px').css('visiblity', '')
					setTimeout(function(){ 
						menu.removeClass('no-height'); 
						setTimeout(function(){
							if(menu.is('.animated')) menu.addClass('animations-suspended')
						}, 500);
					}, 1);
				}
				else menu.removeClass('no-height').css('height', 'auto')

				$(".ui-autocomplete li.ui-menu-item:odd a").addClass("ui-menu-item-alternate");
				if($("#"+_this.textname_css_select).length > 0) $(".ui-autocomplete").position({of: "#"+_this.textname_css_select, my: "left top", at: "left bottom"});
				$(".ui-autocomplete").each(function(){
					$$('#'+_this.textname_css_select).autocomplete('option', 'set_menu_position')(this, event, ui);
				});

				//Layout
				if($$('#'+_this.textname_css_select).autocomplete('option', 'layoutEngine') == 'horizontal'){
					($$('#'+_this.textname_css_select).autocomplete('option', 'layout_horizontal').bind(this))(event, ui);
				}

				_this.afterOpen(event, ui);
				
				$$('#'+_this.textname_css_select+'_loading').css('display', 'none');
			},
			layout_horizontal: function(event, ui){
				//Settings
				var lines_per_col  = 10;
				var number_of_cols =  3;

				//Get Existing Menu
				var self = $$('#'+_this.textname_css_select);
				var widget = $(this).data('ui-autocomplete');
				var menu = widget.menu.element;
				var li_height = widget.menu.element.find('li').fullHeight();

				//Col Sizing
				var view = $(widget.menu.element[0].parentNode);
				var viewPaddingLeft = view.paddingLeft();
				var viewWidth = view.width() - 24;
				var colSize = 299;
				if((colSize * number_of_cols) - 8 > viewWidth) colSize = Math.floor((viewWidth - 8) / number_of_cols);

				//Setup Keyboard events
				if(typeof(self.uiControlsSet) == 'undefined'){
					self.uiControlsSet = true;
					self.hasKeyboardControl = false;
					self.keydown(function(e, ui){
						//Get Target
						var activeli = widget.menu.element.find('li.hover');

						//Skip when select box is not shown
						if($(widget.menu.element).css('display') == 'none') return;

						if(e.keyCode == 13 || e.keyCode == 9){//Enter OR Tab
							e.stopPropagation();
							e.preventDefault();
							activeli.mousedown();
						}
						else if(e.keyCode == 37){//Left
							var n = activeli.index();
							var ul = $(activeli[0].parentNode);
							var next = ul.next();
							if(typeof(next) != 'undefined' && next != null && next.length != 0){
								var next_li = $(next).find('li')[n];
								if(typeof(next_li) != 'undefined' && next != null && next.length != 0){
									activeli.removeClass('hover');
									$(next_li).addClass('hover');
								}
							}
						}
						else if(e.keyCode == 39){//Right
							var n = activeli.index();
							var ul = $(activeli[0].parentNode);
							var next = ul.prev();
							if(typeof(next) != 'undefined' && next != null && next.length != 0){
								var next_li = $(next).find('li')[n];
								if(typeof(next_li) != 'undefined' && next != null && next.length != 0){
									activeli.removeClass('hover');
									$(next_li).addClass('hover');
								}
							}
						}
						else if(e.keyCode == 38){//Up
							var prev = activeli.prev();
							if(typeof(prev) != 'undefined' && prev != null && prev.length != 0){
								activeli.removeClass('hover');
								prev.addClass('hover');
							}
							e.stopPropagation();
							e.preventDefault();
						}
						else if(e.keyCode == 40){//Down
							if(activeli.length == 0){
								self.hasKeyboardControl = true;
								widget.menu.element.find('li').removeClass('hover');
								widget.menu.element.find('ul:last').find('li:first').addClass('hover');
							}
							else{
								var next = activeli.next();
								if(typeof(next) != 'undefined' && next != null && next.length != 0){
									activeli.removeClass('hover');
									next.addClass('hover');
								}
							}
							e.stopPropagation();
							e.preventDefault();
						}
						else{//All other keys (remove hover, will re-hover on new search results)
							self.hasKeyboardControl = false;
							widget.menu.element.find('li').removeClass('hover');
						}
					});
				}

				//Build New Menu
				var newMenu = $('<div class="ui-autocomplete ui-front ui-menu ui-widget ui-widget-content ui-corner-all" style="border: 0; height: '+((li_height * lines_per_col) + 2)+'px;"></div>');
				newMenu.css('left', widget.menu.element.css('left'));
				newMenu.css('top', widget.menu.element.css('top'));
				//--Append Columns
				var ul_col = null;
				var li_index = 0;
				var col_count = 0;
				var r_index = 0;
				var hasMoreRecords = false;
				menu.find('li').each(function(){
					li_index++;
					//Start New Col
					if(li_index % lines_per_col == 1){
						r_index = col_count % 2;
						if(number_of_cols <= col_count){
							hasMoreRecords = true;
							return false;
						}
						ul_col = $('<ul class="ui-menu ui-menu-autocomplete-layout-horizontal">');
						ul_col.appendTo(newMenu);
						col_count++;
					}
					//Copy the <li>
					var data = $(this).data("ui-autocomplete-item");
					var newli = $('<li class="ui-menu-item" role="presentation">').html($(this).find('a').html()).appendTo(ul_col);
					//--Alt Row Color
					if(r_index % 2 == 1) newli.addClass('ui-menu-item-alternate');
					//--Clone autocomplete-item info (id, label, value, extra...)
					newli.data("ui-autocomplete-item", data);
					r_index++;
				});

				//Replace Existing Menu
				widget.menu.element.replaceWith(newMenu);
				widget.menu.element = $(newMenu[0]);
				self.autocomplete('option', 'set_menu_position')(widget.menu.element[0], event, ui);

				//Layout the new menu
				var next_left = 0;
				newMenu.find('ul.ui-menu').each(function(){
					var w = colSize;
					$(this).css('width', w+'px').css('top', 0).css('left', next_left+'px');
					next_left += w;
					$(this).prependTo(newMenu);//Reverse the DOM order (for hover overflow)
					$(this).find('li').each(function(){ $(this).css('min-width', w +'px').css('box-sizing', 'border-box'); });
				});

				//Rebind Jquery-UI select event
				newMenu.find('ul.ui-menu li').mousedown((function(e){
					var i = null;
					if($(e.target).is('li')) i = $(e.target).data("ui-autocomplete-item");
					else i = $($(e.target).closest('li')[0]).data("ui-autocomplete-item");
					var _widget = this._widget;
					//Prevent Existing <ul> click
					e.preventDefault();
					//Close the menu
					_widget.close(e);
					//Set the selected values
					$('[id="'+_this.idname+'"]')[0].label = i.value;
					$('[id="'+_this.idname+'"]').val(i.id);
					$$('#'+_this.textname_css_select).val(i.value);
					_widget.term = i.value;
					_widget.selectedItem = e.target;
					//Trigger the autocomplete.select
					var ui = {item: i};
					($$('#'+_this.textname_css_select).autocomplete('option', 'select').bind(this))(e, ui);
				}).bind({_this: this, _widget: widget}));

				//Hide <li> when mouse moves out of <ul> range
				newMenu.find('ul.ui-menu li').mousemove(function(e){
					var pWidth = $(this.parentNode).width();
					newMenu.find('ul.ui-menu li.hover').removeClass('hover');
					if(e.offsetX > pWidth){
						$(this).css('width', pWidth+'px').css('overflow', 'hidden');
						setTimeout((function(){ $(this).css('width', '').css('overflow', ''); }).bind(this), 10);
					}
					else{
						$(e.currentTarget).addClass('hover');
					}
				});

				//Build Pagination Controls
				var hasPageination = self[0].__autocomplete_page_start > 0 || hasMoreRecords;
				if(hasPageination){
					//Get Control Width
					var w = h = 0;
					$(newMenu).find('ul').each(function(){ w += $(this).width(); h = Math.max(h, $(this).height()) });
					//Build the container
					var pageControlContainer = $('<div class="auto_complete_box_horizonal_pagecontrol" style="background: #CCC; border: 1px solid #333; position: absolute; left: 0px; width: '+w+'px; top: '+(h-2)+'px;">');
					var tbl = $('<table style="width: 100%;">').appendTo(pageControlContainer);
					var tr = $('<tr>').appendTo(tbl);
					var td_back = $('<td style="text-align: left; white-space: nowrap; line-height: 24px;">').appendTo(tr);
					var td_midd = $('<td style="text-align: center; width: 95%;">').appendTo(tr);
					var td_next = $('<td style="text-align: right; white-space: nowrap; line-height: 24px;">').appendTo(tr);
					//Add the Back / Next controls
					if(self[0].__autocomplete_page_start > 0){
						td_back.text(STR_BACK).css('cursor', 'pointer');
						$('<img style="height: 24px; margin-bottom: -7px; margin-right: 8px;">').attr('src', 'images/back.png').prependTo(td_back);
						td_back.mousedown(function(e){
							e.preventDefault();
							$$('#'+_this.textname_css_select)[0].__autocomplete_page_start -= 30;
							setTimeout(function(){
								$$('#'+_this.textname_css_select).autocomplete('search', $$('#'+_this.textname_css_select).val());
							}, 33);
						});
					}
					if(hasMoreRecords){
						td_next.text(STR_NEXT).css('cursor', 'pointer');
						$('<img style="height: 24px; margin-bottom: -7px; margin-left: 8px;">').attr('src', 'images/next.png').appendTo(td_next);
						td_next.mousedown(function(e){
							e.preventDefault();
							$$('#'+_this.textname_css_select)[0].__autocomplete_page_start += 30;
							setTimeout(function(){
								$$('#'+_this.textname_css_select).autocomplete('search', $$('#'+_this.textname_css_select).val());
							}, 33);
						});
					}
					pageControlContainer.appendTo(newMenu);
				}
				
				//Position Menu
				//--Align Menu-left-edge with input-left-edge 
				var autoCompleteLabelTextBox = $(widget.element[0]);
				var left = 0;
				//----Get position in first offset parent
				var apos = $(autoCompleteLabelTextBox).position();
				left += apos.left;
				//----Append other offset parents
				var autoCompleteMenuOffsetParent = $(widget.menu.element[0]).offsetParent();
				var offsetParent = $(autoCompleteLabelTextBox).offsetParent();
				var loopIndex = 0;
				while(offsetParent[0] != autoCompleteMenuOffsetParent[0] && offsetParent != null && loopIndex < 16){
					apos = $(offsetParent).position();
					left += apos.left;
					offsetParent = $(offsetParent).offsetParent();
					loopIndex++;
				}
				$(widget.menu.element[0]).css('left', left+'px');
				//--Shift Left if offscreen
				var pos = $(widget.menu.element[0]).position();
				var width = $(widget.menu.element[0]).children('ul').length * colSize;
				var viewLeftSpaceAvailable = viewWidth - (pos.left + width);
				if(viewLeftSpaceAvailable < 0){
					var newX = pos.left + viewLeftSpaceAvailable + viewPaddingLeft;
					if(newX < viewPaddingLeft) newX = viewPaddingLeft;
					$(widget.menu.element[0]).css('left', newX+'px');
				}

				//Scroll view to bottom of first column
				var target_bottom = parseInt($(newMenu).css('top').replace('/[^\d\.]/', '')) + $(newMenu).find('ul').height() + (hasPageination ? 48 : 16);
				var target_view_top = (target_bottom - ($(window).height() - view.offset().top));
				if(view[0].scrollTop < target_view_top){
					view.animate({
						scrollTop: target_view_top
					}, 333);
				}

				//Select First
				var activeli = widget.menu.element.find('li.hover');
				if(activeli.length == 0){
					widget.menu.element.find('li').removeClass('hover');
					widget.menu.element.find('ul:last').find('li:first').addClass('hover');
				}
			},
			autoFocus: true,
			search: function(event, ui){
				$$('#'+_this.textname_css_select+'_loading').css('display', 'inline-block');
				var self = $$('#'+_this.textname_css_select);
				self.autocomplete({source: function( request, response ) {
						var url = (self.autocomplete('option', 'buildSourceURL'))();
						var data = {};
						for(var k in request) data[k] = request[k];
						$.ajax({
							url: url,
							data: data,
							success: function(data){
								if(typeof(_this.afterSearch) === 'function')
									_this.afterSearch(data);
								response(data);
							},
							error: function(jqXHR, textStatus, errorThrown){
								//Show Error Dialog
								if(typeof(jqXHR.responseJSON) != 'undefined'){
									if(typeof(jqXHR.responseJSON.error) == 'string'){
										var diag = $('<div style="text-align: center; padding: 8px;"><img src="images/error.png" style="width: 32px; height: 32px;"></div>').attr('title', STR_ERROR);
										var buttons = {};
										if(typeof(jqXHR.responseJSON.buttons) != 'undefined'){
											for(var i in jqXHR.responseJSON.buttons){
												buttons[i] = function(){ eval(jqXHR.responseJSON.buttons[i]); }.bind(diag[0]);
											}
										}
										var msg = $('<div>');
										if(typeof(jqXHR.responseJSON.errorIsHtml) != 'undefined' && jqXHR.responseJSON.errorIsHtml) msg.html(jqXHR.responseJSON.error);
										else msg.text(jqXHR.responseJSON.error);
										msg.appendTo(diag);
										diag.dialog({modal: true, buttons: buttons});
										diag.closest('.ui-dialog').find('.ui-dialog-buttonset').find('button').css('width', '100%');
									}
								}
								$$('#'+_this.textname_css_select+'_loading').css('display', 'none');
							},
							dataType: 'json'
						});
					}
				});
				if(typeof(_this.last_search) == 'undefined' || _this.last_search != $(this).val())
					$$('#'+_this.textname_css_select)[0].__autocomplete_page_start = 0;
				_this.last_search = $(this).val();
			},
			close: function(event, ui){
				if(typeof(_this.clearAfterNextSearch) != 'undefined' && _this.clearAfterNextSearch){
					_this.clearAfterNextSearch = false;
					$(this).val('');
					$('[id="'+_this.idname+'"]').attr('extra', '').val('');
					$('[id="'+_this.idname+'"]').removeData();
				}
				$$('#'+_this.textname_css_select)[0].afterTextChanged();
				setTimeout(function(){
					if(txtElm[0].uiAutoMenu !== null && $(txtElm[0].uiAutoMenu).is(':visible') == false)
						txtElm[0].uiAutoMenu.removeClass('animated').removeClass('animations-suspended');
				}, 1000);
			},
			change: function(event, ui){
				$$('#'+_this.textname_css_select)[0].afterTextChanged();
			}
		})
		.keydown(function(){
			$$('#'+_this.textname_css_select)[0].__autocomplete_page_start = 0;
		})
		.bind("autocompleteresponse", function(event, contents) {
			if (contents.length == 0) {
				$('[id="'+_this.idname+'"]').attr('extra', '').val('');
				$('[id="'+_this.idname+'"]').removeData();
				if(!_this.showautocompleteidboxes){
					$('[id="'+_this.textname+'"]').css('border-width', '1px');
				}
			}
		})
		.dblclick(function(event){
			$$('#'+_this.textname_css_select)[0].__autocomplete_page_start = 0;
			if(typeof(_this.last_search) == 'undefined') _this.last_search = false;
			var val = $(this).val();
			if(val.replace(/\s/g, '') == ''){
				if(val != '') $(this).val("");
				val = ' ';
			}
			if(val == ' ') {
				if(_this.last_search != ' ') _this.last_search = ' ';
				else _this.last_search = '  ';
				$(this).val(_this.last_search);
				$(this).keydown();
				_this.clearAfterNextSearch = true;
			}
		});
	}).bind(this);

	if(typeof(this.suspendCreateWidget) != 'undefined' && this.suspendCreateWidget){
		txtElm.addClass('suspended-create-widget');
		txtElm.on('focus', this.funcBuild);
	}
	else {
		txtElm.addClass('not-suspended-create-widget');
		this.funcBuild();
	}
	return this;
}