window.tableToCard = {
	nextUUID: 0,
	init: function(table, autoCard){
		//Skip double init
		if(typeof(table.tableToCard) !== 'undefined') return;

		//Init args
		if(typeof(table[0]) !== 'undefined') table = table[0];
		if(typeof(autoCard) === 'undefined') autoCard = true;

		//Set classes
		$(table).addClass('table-to-card');
		$(table).addClass('table-to-card-as-table');
		if(autoCard) $(table).addClass('auto-table-to-card');

		//Start the tableToCard Object
		table.tableToCard = {uuid: window.tableToCard.nextUUID++, children: []};
		table.tableToCard.tableWidth = $(table).outerWidth();
		table.tableToCard.isCard = false;
		table.tableToCard.cardStyle = typeof($(table).attr('card-style')) === 'string' ? $(table).attr('card-style') : '';
		table.tableToCard.headerColumns = null;
		table.tableToCard.cardContainer = null;
		if(typeof(table.tableToCardParent) === 'undefined')
			table.tableToCardParent = $(table).parent().closest('.table-to-card, .auto-table-to-card')[0];

		//Set parent
		$(table).find('table.table-to-card, table.auto-table-to-card').each(function(){
			if(typeof(this.tableToCardParent) === 'undefined') this.tableToCardParent = table;
			table.tableToCard.children.push(this);
		});

		//Switch To Card
		table.tableToCard.switchToCard = (function(){
			if(this.tableToCard.isCard) return;
			this.tableToCard.isCard = true;
			$(this).removeClass('table-to-card-as-table');
			$(this).addClass('table-to-card-as-card');

			//Find the header titles
			if(this.tableToCard.headerColumns === null){
				this.tableToCard.headerColumns = [];
				if(this.childElementCount > 0){
					//Get the THEAD (or TABLE without a THEAD) to look at each TR in
					var thead = this.children[0].tagName === 'THEAD' ? this.children[0] : this;
					for(var i = 0; i < thead.childElementCount & i < 3; i++){
						var tr = thead.children[i];
						if(tr.tagName !== 'TR') continue;
						//Check if the TR is a header-only row
						var isHeaderRow = true;
						for(var c = 0; c < tr.childElementCount; c++){
							if(tr.children[c].tagName !== 'TH') {
								isHeaderRow = false;
								break;
							}
						}
						//Stop going thru the TRs, as the header has ended
						if(!isHeaderRow) break;
						//Append the header columns
						var cIndex = 0;
						for(var c = 0; c < tr.childElementCount; c++){
							var lbl = tr.children[c].innerText.trim();
							var colSpan = $(tr.children[c]).attr('colspan');
							if(typeof(colSpan) === 'undefined') colSpan = 1;
							else if (colSpan < 1) colSpan = 1;
							for(var s = 0; s < colSpan; s++){
								this.tableToCard.headerColumns[cIndex++] = lbl;
							}
						}
					}
				}
			}

			//Create the flex card-group layout
			if(this.tableToCard.cardContainer === null){
				this.tableToCard.cardContainer = $('<div class="table-to-card-cards-layout" style="display: flex; justify-content: space-evenly; align-items: flex-start; flex-wrap: wrap; gap: 5px;">').insertAfter(this)[0];
				this.tableToCard.cardContainer.parentTable = this;
			}
			$(this.tableToCard.cardContainer).html('');
			this.tableToCard.cardContainer.tableToCardRestoreChildrenElms = [];

			//Convert the TBODY entries
			if(this.childElementCount > 0){
				//Get the THEAD (or TABLE without a THEAD) to look at each TR in
				var lastConvertedIntoTBODY = null;
				var tbody = this.children[0].tagName === 'TBODY' ? this.children[0] : (this.childElementCount > 1 && this.children[1].tagName === 'TBODY' ? this.children[1] : this);
				if(tbody.childElementCount > 0){
					for(var i = 0; i < tbody.childElementCount; i++){
						var tr = tbody.children[i];
						if(tr.tagName !== 'TR') continue;

						var isSubRow = lastConvertedIntoTBODY !== null && $(tr).is('.auto-table-to-card-sub-row');

						//Generate new card for this row
						var newTbody = null;
						if(!isSubRow){
							var cardContainer = $('<div class="table-to-card-card-container">').appendTo(this.tableToCard.cardContainer);
							var card = $('<table class="report table-to-card-card-table notablesorter no_row_over">').appendTo(cardContainer);
							card.attr('style', this.tableToCard.cardStyle);
							newTbody = $('<tbody>').appendTo(card);
						}
						else {
							newTbody = lastConvertedIntoTBODY;
							$('<th colspan="2" class="table-to-card-card-table-row-split"></th>').appendTo($('<tr>').appendTo(newTbody));
						}
						//--Get the TD to be moved
						var tds = [];
						for(var c = 0; c < tr.childElementCount; c++){
							var td = tr.children[c];
							if(td.tagName !== 'TD' && td.tagName !== 'TH') continue;
							tds.push(td);
						}
						//--Move the TD cells to the new body
						for(var c = 0; c < tds.length; c++){
							var td = tds[c];
							if(td.tagName !== 'TD' && td.tagName !== 'TH') continue;
							if(typeof(td.tableToCardParentTR) === 'undefined') td.tableToCardParentTR = tr;
							var newTr = $('<tr>').appendTo(newTbody);
							var newTh = $('<th>').appendTo(newTr);
							if(typeof(this.tableToCard.headerColumns[c]) === 'string')
								newTh.text(this.tableToCard.headerColumns[c]);
							newTr[0].appendChild(td);
							this.tableToCard.cardContainer.tableToCardRestoreChildrenElms.push(td);
						}
						lastConvertedIntoTBODY = newTbody;
					}
				}
			}

			//Hide the orignal table
			$(this).css('display', 'none');

			//Change all the sub tables into cards as well
			for(var i = 0; i < this.tableToCard.children.length; i++){
				if(typeof(this.tableToCard.children[i].tableToCard) !== 'undefined')
					this.tableToCard.children[i].tableToCard.switchToCard();
			}

		}).bind(table);

		//Switch To Table
		table.tableToCard.switchToTable = (function(){
			if(!table.tableToCard.isCard) return;
			this.tableToCard.isCard = false;
			$(this).addClass('table-to-card-as-table');
			$(this).removeClass('table-to-card-as-card');

			//Move back all the card cells to the parent TRs
			for(var i = 0; i < this.tableToCard.cardContainer.tableToCardRestoreChildrenElms.length; i++){
				var td = this.tableToCard.cardContainer.tableToCardRestoreChildrenElms[i];
				td.tableToCardParentTR.appendChild(td);
			}

			//Clear the flex layout cards
			$(this.tableToCard.cardContainer).html('');
			this.tableToCard.cardContainer.tableToCardRestoreChildrenElms = [];

			//Restore the the orignal table display
			$(this).css('display', '');

		}).bind(table);

		//Auto Card
		if(autoCard){
			table.tableToCard.lastAutoSizeScreenWidth = $(window).width();
			if(typeof(table.tableToCardParent) !== 'undefined' && table.tableToCardParent.tableToCard.isCard) table.tableToCard.switchToCard();
			else if(table.tableToCard.tableWidth <= table.tableToCard.lastAutoSizeScreenWidth) table.tableToCard.switchToTable();
			else table.tableToCard.switchToCard();
			UI.resize((function(){
				uiWaitForFinalEvent((function(){
					if(typeof(this.tableToCardParent) !== 'undefined'){
						if(this.tableToCardParent.tableToCard.isCard){
							this.tableToCard.switchToCard();
							return;
						}
					}
					var w = $(window).width();
					if(table.tableToCard.lastAutoSizeScreenWidth === w) return;
					table.tableToCard.lastAutoSizeScreenWidth = w;
					if(this.tableToCard.tableWidth <= w) this.tableToCard.switchToTable();
					else this.tableToCard.switchToCard();
				}).bind(this), 50, 'tableToCardUIResize_'+this.tableToCard.uuid);
			}).bind(table));
		}
	},
	documentReady: function(){
		$('table.auto-table-to-card').each(function(){
			window.tableToCard.init(this, true);
		});
	}
};

if(typeof(UI) !== 'undefined') UI.ready(window.tableToCard.documentReady);
else $(document).ready(window.tableToCard.documentReady);