var UI = {
	/*Vars*/
	mouseConfirmed: false,
	warnOnWindowUnload: true,
	uiOnLoadResizeDone: false,
	footerLoadedFinished: false,
	postDocumentLoadFinished: false,
	uiView: null,
	mainMenu: null,
	mainMenuMode: typeof(window.UI_mainMenuMode) != 'undefined' ? window.UI_mainMenuMode : 'default',
	defaultPage: null,
	menuType: 'left_wide',
	menuShown: false,
	flyOutTime: 100,
	table_modified_times: {serversetup: 0, genuser: 0, genusercompany: 0, feature_activation: 0, lang: 0, gencompany: 0, arcompany: 0, apcompany: 0, invcompany: 0, prcompany: 0, glcompany: 0, footer_logo: 0, setup: 0, emailtemplate: 0, nprightsgroup: 0, nprightsgroupdefaults: 0, nprightsuserdefaults: 0, uialertmessage: 0, inventorylocation: 0},
	small_ui_max_width: 980,
	animationSpeedFloatingPanes: 300,
	mobileMenuSlideSpeed: 300,
	leftMenuIconHolderSizeWidth: 40,
	leftMenuIconHolderSizeHeight: 40,
	enableSettingsSearch: false,
	menuIconLeftOffsetCorrection: 4,
	resize_callbacks: {},
	onTableModifiedTimeChange_callbacks: {},
	onviewshows_callbacks: [],
	onviewhide_callbacks: [],
	altKeyEvents: [],
	autoHide_FullFrameOverlayView: true,
	suspend_layout: false,
	large_page_mode: false,
	window_width: 0,
	window_height: 0,
	loadFromMenuPageStack: [],
	onWindowResize_UpdateUITaskBar_isAuto: false,
	lastActiveIframeView: null,
	hold_onWindowResize_ResizeUITabsOverflow: false,
	onDocumentReady_Callables: [],
	dataTable_RegisteredTableUse: [],
	pushMessagesPending: [],
	dbupdatepending: false,
	hideLeftMenu: false,
	isDocumentReady: false,
	taskbarbaritemMaxClickRate: 333,
	uiStyleLeftMenuBackgroundWidth: 0,
	uiStyleLeftMenuWidth: 0,
	uiStyleTaskbarHeight: 0,
	jqUISuspendedEvents: 0,
	onSupportOnlineStatusChanged_Callables: [],

	/*Cached Elements*/
	elmUISearchSettings: function(set){
		if(typeof(set) != 'undefined') { UI.elmUISearchSettingsCache = set; return; }
		if(typeof(UI.elmUISearchSettingsCache) == 'undefined' || UI.elmUISearchSettingsCache === null || UI.elmUISearchSettingsCache.length == 0)
			UI.elmUISearchSettingsCache = $('#uiSearchSettings');
		return UI.elmUISearchSettingsCache;
	},
	elmUISearchSettingsContainer: function(set){
		if(typeof(set) != 'undefined') { UI.elmUISearchSettingsContainerCache = set; return; }
		if(typeof(UI.elmUISearchSettingsContainerCache) == 'undefined' || UI.elmUISearchSettingsContainerCache === null || UI.elmUISearchSettingsContainerCache.length == 0)
			UI.elmUISearchSettingsContainerCache = $('#uiSearchSettingsContainer');
		return UI.elmUISearchSettingsContainerCache;
	},
	elmUITopBarMenu: function(set){
		if(typeof(set) != 'undefined') { UI.elmUITopBarMenuCache = set; return; }
		if(typeof(UI.elmUITopBarMenuCache) == 'undefined' || UI.elmUITopBarMenuCache === null || UI.elmUITopBarMenuCache.length == 0)
			UI.elmUITopBarMenuCache = $('#uiTopBarMenu');
		return UI.elmUITopBarMenuCache;
	},

	/*DOM EVENTS*/

	/***
	 * Triggers, or registers a callback for, the UI resize event.  Registers when func arg is a callable, triggers the event(s) otherwise.
	 *
	 * @param {?callable} func - Function to call when the UI resize event is triggered
	 * @param {?number} priority - Higher values are called first.  Use negative to deprioritize a call.
	 */
	resize: function(func, priority){
		if(typeof(func) == 'function'){
			if(typeof(priority) == 'undefined') priority = 0;
			if(typeof(UI.resize_callbacks[priority]) == 'undefined') UI.resize_callbacks[priority] = [];
			UI.resize_callbacks[priority].push(func);
		}
		else if(typeof(func) == 'undefined'){
			UI.onWindowResize();
		}
	},
	onSearch: function(func_or_iframeelement, frameElement, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(frameElement) === 'undefined') frameElement = null;
		event.func_or_iframeelement = func_or_iframeelement;
		event.frameElement = frameElement;
		if(typeof(func_or_iframeelement) == 'object' && typeof(func_or_iframeelement.onSearchCallbacks) != 'undefined'){
			for(var i in func_or_iframeelement.onSearchCallbacks){
				func_or_iframeelement.onSearchCallbacks[i](frameElement);
			}
			event.term = frameElement;
			window.np_analytics.event('UI.onSearch', event, '', sender);
			return;
		}
		if(typeof(frameElement) == 'undefined' || frameElement === null) frameElement = window.frameElement;
		if(frameElement != null){
			if(window.UI != top.UI){
				if(typeof(func_or_iframeelement) == 'function') return top.UI.onSearch(func_or_iframeelement, frameElement, event, sender);
				return;
			}
			if(typeof(func_or_iframeelement) == 'function'){
				if(typeof(frameElement.onSearchCallbacks) == 'undefined') frameElement.onSearchCallbacks = [];
				frameElement.onSearchCallbacks.push(func_or_iframeelement);
				UI.showSearchBox();
				if(typeof(window.uiShowSearchBoxHookSet) == 'undefined'){
					window.uiShowSearchBoxHookSet = true;
					UI.elmUISearchSettings().keyup(function(e){
						var activeFrame = $('.main_index_page_active > iframe.frame-view');
						if(activeFrame.length > 0) UI.onSearch(activeFrame[0], $(this).val(), e, this);
					});
				}
			}
		}
	},
	clearSearch: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if($('#uiSearchSettings').val() != '') window.np_analytics.event('UI.clearSearch', event, '', sender);
		if(typeof(window.closeAllSettingsMapSearches) === 'function'){
			try{ window.closeAllSettingsMapSearches();} catch(err) { console.log(err+' [E941223611069420]'); var stack = err.stack || err.stacktrace || ""; console.log(stack); }
		}
		if(typeof(window.closeAllControlPanelSearches) === 'function') {
			try{ window.closeAllControlPanelSearches(); } catch(err) { console.log(err+' [E414612141157]'); var stack = err.stack || err.stacktrace || ""; console.log(stack); }
		}
		try{ $('#uiSearchSettings').val('').change(); } catch(err) { console.log(err+' [E203204212543124]'); var stack = err.stack || err.stacktrace || ""; console.log(stack); }
	},
	onViewShown: function(func_or_iframeelement, frameElement, event, sender){
		if(typeof(frameElement) == 'undefined' || frameElement === null) frameElement = window.frameElement;
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		event.iframeelement = func_or_iframeelement;
		event.frameElement = frameElement;
		if(typeof(func_or_iframeelement) == 'object'){

			var mainIndexView = $(func_or_iframeelement).closest('.main_index_page');
			var isViewActive = mainIndexView.length == 0 || mainIndexView.is('.main_index_page_active');
			if(!isViewActive) return;

			for(var i in UI.onviewshows_callbacks){
				if(UI.onviewshows_callbacks[i].frameElement == func_or_iframeelement || (typeof(func_or_iframeelement.length) != 'undefined' && UI.onviewshows_callbacks[i].frameElement == func_or_iframeelement[0]))
					UI.onviewshows_callbacks[i]();
			}

			var targetElm = $(func_or_iframeelement)[0];
			if(typeof(targetElm) != 'undefined' && targetElm !== null){
				if((typeof(targetElm.onSearchCallbacks) === 'undefined' || targetElm.onSearchCallbacks.length == 0)
				  && (typeof(targetElm.classList) === 'undefined' || !targetElm.classList.contains('ui-searchable-frame-view'))){
					UI.hideSearchBox();
				}
				else{
					UI.clearSearch();
					UI.showSearchBox();
				}
			}
			window.np_analytics.event('UI.onViewShown', event, '', sender);
			return;
		}
		if(window.UI != top.UI && frameElement != null){
			if(typeof(func_or_iframeelement) == 'function') return top.UI.onViewShown(func_or_iframeelement, frameElement, event, sender);
			return;
		}
		if(typeof(func_or_iframeelement) == 'function'){
			func_or_iframeelement.frameElement = frameElement;
			UI.onviewshows_callbacks.push(func_or_iframeelement);
		}
	},
	onViewHide: function(func_or_iframeelement, frameElement){
		if(typeof(func_or_iframeelement) == 'object'){
			for(var i in UI.onviewhide_callbacks){
				if(UI.onviewhide_callbacks[i].frameElement == func_or_iframeelement || (typeof(func_or_iframeelement.length) != 'undefined' && UI.onviewhide_callbacks[i].frameElement == func_or_iframeelement[0]))
					UI.onviewhide_callbacks[i]();
			}
			return;
		}
		if(typeof(frameElement) == 'undefined') frameElement = window.frameElement;
		if(window.UI != top.UI && frameElement != null){
			if(typeof(func_or_iframeelement) == 'function') return top.UI.onViewHide(func_or_iframeelement, frameElement);
			return;
		}
		if(typeof(func_or_iframeelement) == 'function'){
			func_or_iframeelement.frameElement = frameElement;
			UI.onviewhide_callbacks.push(func_or_iframeelement);
		}
	},
	onDocumentReady: function(func){
		//Append New Callable For Event
		if(typeof(func) == 'function' && typeof(func.attr) == 'undefined'){
			UI.onDocumentReady_Callables.push(func);
			return;
		}

		//Define any missing window vars that are expected to be set by header file
		{
			if(typeof(window.STR_SHOW_TAB) == 'undefined') window.STR_SHOW_TAB = 'Show Tab';
			if(typeof(window.STR_HIDE_TAB) == 'undefined') window.STR_HIDE_TAB = 'Hide Tab';
			if(typeof(window.STR_OPEN_IN_NEW_TAB) == 'undefined') window.STR_OPEN_IN_NEW_TAB = 'Open In New Tab';
			if(typeof(window.STR_TO_ENSURE_A_CORRECT_PRINT_PLEASE_USE_PRINT_FROM_THE_LINKS_MENU) == 'undefined') window.STR_TO_ENSURE_A_CORRECT_PRINT_PLEASE_USE_PRINT_FROM_THE_LINKS_MENU = 'To ensure a correct print please use print from the links menu.';
			if(typeof(window.STR_REFRESH) == 'undefined') window.STR_REFRESH = 'Refresh';
			if(typeof(window.STR_SETTINGS) == 'undefined') window.STR_SETTINGS = 'Settings';
			if(typeof(window.STR_LOADING) == 'undefined') window.STR_LOADING = 'Loading';
			if(typeof(window.STR_CONNECTION_FAILED) == 'undefined') window.STR_CONNECTION_FAILED = 'Connection Failed';
			if(typeof(window.STR_ALL) == 'undefined') window.STR_ALL = 'All';
			if(typeof(window.STR_LIST) == 'undefined') window.STR_LIST = 'List';
			if(typeof(window.STR_LOGIN_REQUIRED) == 'undefined') window.STR_LOGIN_REQUIRED = 'Login Required';
			if(typeof(window.STR_PAGE) == 'undefined') window.STR_PAGE = 'Page';
			if(typeof(window.STR_SAVE) == 'undefined') window.STR_SAVE = 'Save';
			if(typeof(window.STR_SAVE_CHANGES) == 'undefined') window.STR_SAVE_CHANGES = 'Save Changes';
			if(typeof(window.STR_BACK) == 'undefined') window.STR_BACK = 'Back';
			if(typeof(window.STR_CLOSE) == 'undefined') window.STR_CLOSE = 'Close';
			if(typeof(window.STR_CLOSE_WINDOW) == 'undefined') window.STR_CLOSE_WINDOW = 'Close Window';
			if(typeof(window.STR_NEXT) == 'undefined') window.STR_NEXT = 'Next';
			if(typeof(window.STR_HELP) == 'undefined') window.STR_HELP = 'Help';
			if(typeof(window.HOSTED) == 'undefined') window.HOSTED = true;
			if(typeof(window.PRODUCT_NAME) == 'undefined') window.PRODUCT_NAME = '';
			if(typeof(window.NUMBER_VERSION) == 'undefined') window.NUMBER_VERSION = '';
			if(typeof(window.BUILD_VERSION) == 'undefined') window.BUILD_VERSION = '';
			if(typeof(window.CI_BASE_URL) == 'undefined') window.CI_BASE_URL = '!/index.php?/';
			if(typeof(window.NP_BASE_URL) == 'undefined') window.NP_BASE_URL = '';
			if(typeof(window.JS_URL) == 'undefined') window.JS_URL = '';
			if(typeof(window.CSS_URL) == 'undefined') window.CSS_URL = '';
			if(typeof(window.LOCAL_JS_URL) == 'undefined') window.LOCAL_JS_URL = '';
			if(typeof(window.LOCAL_CSS_URL) == 'undefined') window.LOCAL_CSS_URL = '';
			if(typeof(window.meta_menu_adv_rights) == 'undefined') window.meta_menu_adv_rights = {};
			if(typeof(window.user_rights) == 'undefined'){
				var n = {read: false, write: false, setup: false};
				window.user_rights = {ar: n, ap: n, inv: n, pr: n, pay: n, gl: n, admin: n, sc: n, est: n, fix: n, imp: n};
			}
		}

		UI.window_width  = $(window).width();
		UI.window_height = $(window).height();

		//Set the pixel/view CSS info
		if(document.body !== null) {
			document.documentElement.style.setProperty('--ui-style-dpi', window.devicePixelRatio);
			if(UI.window_width  > 0) document.documentElement.style.setProperty('--ui-style-vw', UI.window_width +'px');
			if(UI.window_height > 0) document.documentElement.style.setProperty('--ui-style-vh', UI.window_height+'px');
		}

		UI.suspendOnWindowResize();
		//Reset page's parrent iframe to no min-height (as sometimes set by a datatable)
		if(window.template && typeof(window.frameElement) != 'undefined' && window.frameElement != null)
			window.frameElement.contentWindow.$(window.frameElement).css('min-height', '');

		UI.createMenu();
		UI.uiView = $('#content');
		if(UI.uiView.length == 0) UI.uiView = $('body');
		UI.uiViewSection = $('#section_view');
		if(UI.uiViewSection.length == 0) UI.uiViewSection = $('.section_content');
		if(UI.uiViewSection.length == 0) UI.uiViewSection = UI.uiView;

		UI.uiView.click(function(){
			UI.animateLeftMenuSizes(-1);
			top.UI.hideAllMenuPanes(true);
			top.UI.QuickSearchMenu.isOpen = $('#uiTopBar_QuickSearch').is('.uiTopBarFloatingMenuOpened');
			if(top.UI.QuickSearchMenu.isOpen) top.UI.toggleQuickSearchPane();
			$('.searchHighlighed').removeClass('searchHighlighed');
		});
		UI.uiView.mouseenter(function(){ if(!UI.menuShown){ UI.animateLeftMenuSizes(-1); }});
		if(UI.enableSettingsSearch) UI.startSettingsSearch();
		UI.processView();
		UI.onWindowResize();
		setTimeout('UI.onWindowResize(); if(UI.suspendOnWindowResize.depth == 0) UI.uiOnLoadResizeDone = true;', 10);

		//Set scrollbar size & position as css vars
		var vscrollwidth = UI.uiViewSection[0].offsetWidth - UI.uiViewSection[0].clientWidth;
		if(!isNaN(vscrollwidth)){
			if(vscrollwidth < 0) vscrollwidth = 0;
			document.documentElement.style.setProperty('--ui-style-vscroll-width', (UI.uiViewSection[0].offsetWidth - UI.uiViewSection[0].clientWidth)+'px');
		}
		document.documentElement.style.setProperty('--ui-style-vscroll', UI.uiViewSection[0].scrollTop+'px');
		document.documentElement.style.setProperty('--ui-style-hscroll', UI.uiViewSection[0].scrollLeft+'px');
		UI.uiViewSection.one('scroll', function(){
			var vscrollwidth = UI.uiViewSection[0].offsetWidth - UI.uiViewSection[0].clientWidth;
			if(!isNaN(vscrollwidth)){
				if(vscrollwidth < 0) vscrollwidth = 0;
				document.documentElement.style.setProperty('--ui-style-vscroll-width', (UI.uiViewSection[0].offsetWidth - UI.uiViewSection[0].clientWidth)+'px');
			}
		});
		UI.uiViewSection.on('scroll', function(){
			document.documentElement.style.setProperty('--ui-style-vscroll', UI.uiViewSection[0].scrollTop+'px');
			document.documentElement.style.setProperty('--ui-style-hscroll', UI.uiViewSection[0].scrollLeft+'px');
		});

		if(top !== window && typeof(top.UI) !== 'undefined' && top.UI != UI){
			if(typeof(frameElement) != 'undefined' && frameElement != null){
				top.UI.onViewShown(frameElement);
				frameElement.uiLastViewWidth = frameElement.offsetWidth;
			}
		}

		setTimeout(function(){
			//Focus First Found Form/Input
			if(top === window || top.UI.mouseConfirmed){
				var textBoxes = $('#section_view form input[type="text"], #section_view form input[type="search"], .section_content form input[type="text"], .section_content form input[type="search"]');
				if(textBoxes.length > 0){
					textBoxes[0].focus();
				}
			}
		}, 15);

		//Size Top Menu Logo Container
		var imageSrc = $('.npLogo').css('background-image');
		imageSrc = typeof(imageSrc) != 'undefined' && imageSrc != '' && imageSrc != null ? imageSrc.replace(/url\((['"])?(.*?)\1\)/gi, '$2').split(',')[0] : null;

		// I just broke it up on newlines for readability
		if(imageSrc != '' && imageSrc != null){
			var image = new Image();
			image.src = imageSrc;
			image.onload = function(){
				var width = image.width;
				var height = image.height;
				var maxHeight = $('.npLogo').height();
				var k = maxHeight / height;
				var newW = k*width;
				$('.npLogo').css('width', newW+'px');
				var menuSandwich = $('#uiTopBarMobileSandwich').css('display') != 'none' ? $('#uiTopBarMobileSandwich').fullWidth() : 0;
				var mL = $('.npLogo').css('margin-left');  mL = typeof(mL) != 'undefined' && mL != null ? parseInt(mL.replace(/[^\d]/g, '')) : 0;
				var mR = $('.npLogo').css('margin-right'); mR = typeof(mR) != 'undefined' && mR != null ? parseInt(mR.replace(/[^\d]/g, '')) : 0;
				$('#npLogoHeader').css('width', (menuSandwich+newW+mL+mR)+'px');
				UI.onWindowResize_CenterPageTitle();
				UI.onWindowResize_CollapseTopMenu();
			}
			image.onerror = function(){
				$('#pagetitle').css('visibility', 'visible');
				$('#pagesubtitle').css('visibility', 'visible');
			}
		}
		else{
			$('#pagetitle').css('visibility', 'visible');
			$('#pagesubtitle').css('visibility', 'visible');
		}

		//Hightlight main menu if needed...
		var label = $('#pagetitle').text();
		$('.menu-left .itemText').each(function(){
			if($(this).text() == label){
				$($(this).parents('li')[0]).addClass('activateMenuItem');
			}
		});

		//Show the page's content
		$('#section_view').show();

		//Detect Print (Chrome)
		if(typeof(window.matchMedia) != 'undefined'){
			var mediaQueryList = window.matchMedia('print');
			if(mediaQueryList != null){
				mediaQueryList.addListener(function(mql) {
					if (mql.matches)
						window.onbeforeprint();
					else
						setTimeout(function(){window.onafterprint(false);}, 1000);
				});
			}
			else{
				$(window).on('beforeprint', window.onbeforeprint);
				$(window).on('afterprint', window.onafterprint);
			}
		}

		//Prevent <form> double submit
		_('form').each(function(){
			if(typeof(this.target) == 'undefined' || this.target == '' || this.target == '_self'){
				if(typeof($(this).attr('newtab')) == 'undefined'){
					var _this = $(this);
					if(typeof(_this.preventDoubleSubmission) != 'undefined') _this.preventDoubleSubmission();
				}
			}
			if(typeof(window.active_company) != 'undefined' && this.name != 'company'){
				$('<input type="hidden" value="'+window.active_company+'" name="submitted_companyid">').appendTo(this);
			}
		});

		for(var i = 0; i < UI.onDocumentReady_Callables.length; i++) UI.onDocumentReady_Callables[i]();

		//Search Menu Key Event
		UI.isWaitingOnKeyUpdateEvent = false;
		$(document).on('keydown', function ( e ) {
			if(top.UI.isWaitingOnKeyUpdateEvent) return;
			if(!UI.uiOnLoadResizeDone || !UI.isDocumentReady) return;
			//Menu Search
			if ((e.metaKey || e.ctrlKey) && (e.key == ';' || String.fromCharCode(e.which).toLowerCase() == ';') ) {
				top.UI.isWaitingOnKeyUpdateEvent = true;
				top.UI.toggleQuickSearchPane(null, true);
				if(top.UI.QuickSearchMenu.isOpen) top.UI.QuickSearchMenu.SetSearchType('menu');
				e.preventDefault();
				return;
			}
			//Toggle Quick Search UI
			if ((e.metaKey || e.ctrlKey) && e.shiftKey && (e.key == 'F' || String.fromCharCode(e.which).toLowerCase() == 'f') ) {
				top.UI.isWaitingOnKeyUpdateEvent = true;
				top.UI.toggleQuickSearchPane(null, true);
				e.preventDefault();
				return;
			}
			//Send Key To QuickSearch Menu
			if(top.UI.QuickSearchMenu.isOpen){
				if(top.UI.QuickSearchMenu.OnKeyDown(e)){
					e.preventDefault();
					return;
				}
			}
		});

		//
		$(document).on('keyup', function ( e ) {
			top.UI.isWaitingOnKeyUpdateEvent = false;
		});

		UI.resumeOnWindowResize();
		UI.isDocumentReady = true;
	},
	ready: function(func){
		return typeof(func) == 'undefined' ? UI.onDocumentReady() : UI.onDocumentReady(func);
	},
	onWindowResize: function(){
		UI.window_width  = $(window).width();
		UI.window_height = $(window).height();

		if(document.body !== null) {
			if(UI.window_width  > 0) document.documentElement.style.setProperty('--ui-style-vw', UI.window_width +'px');
			if(UI.window_height > 0) document.documentElement.style.setProperty('--ui-style-vh', UI.window_height+'px');
		}

		if(typeof(window.top) != 'undefined' && window.top != null && typeof(window.top.UI) != 'undefined' && window.top.UI.suspend_layout) return;

		var hWindow   = UI.window_height;
		var wWindow   = UI.window_width;
		var hTopMenu  = $('#uiTopBar').height();
		var hView     = hWindow - hTopMenu;

		if(wWindow > UI.small_ui_max_width)
			$('body').removeClass('small-ui');
		else if(!$('body').is('.small-ui'))
			$('body').addClass('small-ui');

		//Mobile Menus
		var wLeftMenu = 0;
		var leftBackground = $('#uiLeftBarBackground');
		if(leftBackground.length > 0){
			var mTop = leftBackground.css('margin-top');
			mTop = typeof(mTop) == 'undefined' || mTop == null ? 0 : parseInt(mTop.replace(/[^\d]/ig, ''));
			var mBottom = leftBackground.css('margin-bottom');
			mBottom = typeof(mBottom) == 'undefined' || mBottom == null ? 0 : parseInt(mBottom.replace(/[^\d]/ig, ''));
			if(window.template == 'timecard') leftBackground.css('height', '100vh');
			else if(UI.menuType == 'left') leftBackground.css('height', 'calc(100vh - var(--ui-style-top-menu-height))');
			else if(UI.menuType == 'left_wide') leftBackground.css('max-height', 'calc(100vh - '+(mBottom + mTop)+'px - var(--ui-style-top-menu-height))');
			UI.onWindowResize_UpdateLeftBarSize();
			var wLeftMenu = leftBackground[0]._width;
		}

		//Top-Menu floating panes
		$('.uiTopBar_FloatingPane').css('max-height', hView+'px');

		//Reposition the mobile menu
		if(window.isMobile){
			if(typeof(UI.MobileToogleLeftMenu_LastValue) == 'undefined') UI.MobileToogleLeftMenu_LastValue = false;
			if(UI.MobileToogleLeftMenu_LastValue)
				UI.MobileShowLeftMenu(true);
			else
				UI.MobileHideLeftMenu(true);
		}

		//Resize Sub-Functions
		UI.onWindowResize_UpdateUITaskBar();
		UI.onWindowResize_UpdateViewPortal(wLeftMenu, hWindow, wWindow, hTopMenu, hView);
		UI.onWindowResize_ResizeUITabsOverflow();
		UI.onWindowResize_CenterPageTitle();
		UI.onWindowResize_CollapsePopertySets();
		UI.onWindowResize_CollapseTopMenu(wWindow);
		UI.onWindowResize_FullFrameOverlayView();
		UI.hideAllMenuPanes(UI.suspendOnWindowResize.depth > 0 || UI.uiOnLoadResizeDone == false || UI.isDocumentReady == false);
		UI.show_mobile_nav_resize();
		if(typeof(FloatingHeader) != 'undefined'){
			FloatingHeader.SyncFloatingCellsToParent();
			FloatingHeader.InvalidateLocations();
		}

		//Trigger callbacks in order of priority
		var priority_keys = [];
		for(var priority in UI.resize_callbacks) priority_keys.push(priority);
		priority_keys.sort();
		for(var p in priority_keys){
			for(var i in UI.resize_callbacks[priority_keys[p]]) {
				try {
					UI.resize_callbacks[priority_keys[p]][i]();
				}
				catch (err) {
					console.log('ERROR triggering UI.resize_callbacks['+priority_keys[p]+']['+i+']: '+err+' [E17011412223219]');
					var stack = err.stack || err.stacktrace || "";
					console.log(stack);
				}
			}
		}

		UI.onWindowResize_FixIOSIframeLocations();

		try {
			if(top.UI !== window.UI && top.template === 'timecard'){
				var org = window.UI.resize;
				window.UI.resize = function(){};
				top.UI.resize();
				window.UI.resize = org;
			}
		}
		catch(e){ }
	},
	onWindowResize_FixIOSIframeLocations: function(){
		var ua = navigator.userAgent.toLowerCase();
		var isIOS = ua.match( /iPad/i ) || ua.match( /iPhone/i ) || ua.match( /iPod/i );
		if(isIOS){
			if(typeof(window.frameElement) != 'undefined'){
				if($(window.frameElement).is('.frame-view')){
					if(typeof(window.frameElement.parentElement) != 'undefined'){
						if($(window.frameElement.parentElement).is('.main_index_page_active')){
							var org_val = $(window.frameElement).css('left');
							setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 500);
							setTimeout(function(){ $(window.frameElement).css('left', org_val); },  501);
							setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 1000);
							setTimeout(function(){ $(window.frameElement).css('left', org_val); },  1001);
							setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 2000);
							setTimeout(function(){ $(window.frameElement).css('left', org_val); },  2001);
							setTimeout(function(){ $(window.frameElement).css('left', '-0.1px'); }, 5000);
							setTimeout(function(){ $(window.frameElement).css('left', org_val); },  5001);
						}
					}
				}
			}
		}
	},
	onWindowResize_UpdateViewPortal: function(wLeftMenu, hWindow, wWindow, hTopMenu, hView){
		if(typeof(wLeftMenu) == 'undefined') wLeftMenu = $('#uiLeftBarBackground').length > 0 ? $('#uiLeftBarBackground')[0]._width : 0;
		if(typeof(hWindow) == 'undefined')   hWindow   = UI.window_height;
		if(typeof(wWindow) == 'undefined')   wWindow   = UI.window_width;
		if(typeof(hTopMenu) == 'undefined')  hTopMenu  = $('#uiTopBar').height();
		if(hTopMenu === null) hTopMenu = 0;
		if(typeof(hView) == 'undefined') hView = hWindow - hTopMenu;

		if(window.isMobile) wLeftMenu = 0;
		$('#uiTopBarMobileSandwich').css('display', window.isMobile ? 'inline-block' : 'none');
		if(window.isMobile){
			$('body').css('position', 'fixed').css('left', '0px').css('top', '0px').css('height', window.availHeight+'px');
			$('body').css('top', window.innerHeight - window.availHeight + 'px');
		}

		var taskBarHeight = null;
		if(window.template !== 'iframe'){
			var taskBarBack = $('.uiTaskBarBackground:not(.uiTaskBarIsInSectionContent)');
			taskBarHeight = taskBarBack.css('position') == 'fixed' ? taskBarBack.height() : 0;
			if(typeof(taskBarHeight) == 'undefined' || taskBarHeight == null) taskBarHeight = 0;
		}
		else {
			var taskBarBack = $('.uiTaskBarIFrameBackground:not(.uiTaskBarIsInSectionContent)');
			if(taskBarBack.length > 0){
				taskBarHeight = taskBarBack.height();
				if(typeof(taskBarHeight) == 'undefined' || taskBarHeight == null) taskBarHeight = 0;
			}
		}
		if(taskBarHeight !== null) {
			if(document.body !== null) document.documentElement.style.setProperty('--ui-style-taskbar-height', taskBarHeight + 'px');
			UI.uiStyleTaskbarHeight = taskBarHeight;
		}

		var internal_tabs = $('#section_view').children('.main_index_page_container').children('.main_index_internal_tab');
		if(internal_tabs.length > 0){
			var leftBackground = $('#uiLeftBarBackground');
			var lBW = (typeof(leftBackground[0]) != 'undefined' && typeof(leftBackground[0]._width) != 'undefined') ? leftBackground[0]._width : 0;
			var vWidth = UI.window_width - lBW - 24;
			var hViewIn = hView;
			if(leftBackground.length > 0){
				internal_tabs.each(function(){
					$(this).children('iframe').css('max-width', 'calc(calc(100vw - var(--ui-style-left-menu-width)) - 24px)').width(vWidth+'px').height(hViewIn+'px');
				});
			}
		}
	},
	onWindowResize_CenterPageTitle: function(){
		var uiTopBar = $('#uiTopBar');
		var uiSearchSettingsContainer = UI.elmUISearchSettingsContainer();
		var uiTopBarMenu = uiTopBar.find('.uiTopBarMenu');
		var pt = uiTopBar.find('#pagetitle');
		if(typeof(pt[0]) == 'undefined' || pt[0].innerHTML == '') return;
		var fontSize = 16;

		//Get Sizing Info
		var padding = 8;
		var logo = uiTopBar.find('.npLogo');
		var logoW = logo.length > 0 ? logo[0].offsetWidth + 8 : 0;
		var topRightMenuW = uiTopBarMenu[0].offsetWidth + 8;
		var sandwichMenu = uiTopBar.find('#uiTopBarMobileSandwich');
		var sandwichW = sandwichMenu.length > 0 && sandwichMenu[0].style.display != 'none' ? sandwichMenu[0].offsetWidth : 0;
		var vs = uiSearchSettingsContainer.is('.uiSearchSettings-Hidden') ? 0 : uiSearchSettingsContainer.outerWidth() + 28;
		var fixAdj = 30;

		//Set New Styles
		pt[0].style.fontSize = fontSize+'px';
		pt[0].style.left = (logoW + vs + padding + sandwichW)+'px';
		pt[0].style.width = 'calc(100vw - '+((logoW + vs + topRightMenuW + sandwichW + fixAdj) - (padding * 2))+'px)';
		if(pt[0].style.display != 'block') pt[0].style.display = 'block';
		if(pt[0].style.visibility != 'visible') pt[0].style.visibility = 'visible';
		if(typeof(pt[0].appendAnimatedClassOnce) == 'undefined'){
			pt[0].appendAnimatedClassOnce = true;
			setTimeout(function(){ pt[0].classList.add('animated-page-title'); }, 5);
		}

	},
	onWindowResize_CollapseTopMenu: function(wWindow){
		if(window.template == 'iframe') return;

		//Elms
		var logo = $('#npLogoHeader');
		var menu = UI.elmUITopBarMenu();

		//Measure
		var menuOffset = menu.offset();
		var menuOffsetLeft = typeof(menuOffset) != 'undefined' ? menuOffset.left : 0;
		var logoWidth = logo.width();
		var uiTopSearch = $('#uiSearchSettingsContainer');
		if(uiTopSearch.length == 0) return;
		var uiTopSearchW = uiTopSearch.is('.uiSearchSettings-Hidden') ? 0 : uiTopSearch[0].offsetWidth + 24;

		//Hide Logo
		if(typeof(uiTopSearch[0].isLogoHidden) == 'undefined') uiTopSearch[0].isLogoHidden = false;
		if(logoWidth + uiTopSearchW + 4 > menuOffsetLeft) {
			if(!uiTopSearch[0].isLogoHidden){
				logo.addClass('no-logo-background').find('.npLogo').hide();
				uiTopSearch[0].isLogoHidden = true;
				uiTopSearch.addClass('no-logo-layout');
				UI.onWindowResize_CenterPageTitle();
			}
		}
		else if(uiTopSearch[0].isLogoHidden){
			logo.addClass('no-logo-background').find('.npLogo').css('display', 'inline-block');
			uiTopSearch[0].isLogoHidden = false;
			uiTopSearch.removeClass('no-logo-layout');
			UI.onWindowResize_CenterPageTitle();
		}
	},
	onWindowResize_UpdateLeftBarSize: function(){
		if(UI.menuType != 'left' && UI.menuType != 'left_wide') return;

		//Calc View Sizes
		var ul = $("#uiLeftItems");
		if(ul.length == 0) return;
		var hWindow  = UI.window_height;
		var hTopMenu = $('#uiTopBar').height();
		var htView   = hWindow - hTopMenu;
		var liCount  = $("#uiLeftItems > li").length;

		//Account for padding
		var padding = 0;
		var li = $($("#uiLeftItems > li")[0]);
		if(typeof(li.css) != 'undefined'){
			var mt = li.css('marginTop');
			var pt = li.css('paddingTop');
			var mb = li.css('marginBottom');
			var pb = li.css('paddingBottom');
			if(typeof(mt) != 'undefined') padding += parseInt(mt.replace(/[^\d]/gi, ''));
			if(typeof(pt) != 'undefined') padding += parseInt(pt.replace(/[^\d]/gi, ''));
			if(typeof(mb) != 'undefined') padding += parseInt(mb.replace(/[^\d]/gi, ''));
			if(typeof(pb) != 'undefined') padding += parseInt(pb.replace(/[^\d]/gi, ''));
		}
		htView -= (padding * liCount) + (UI.menuType == 'left_wide' ? 10 : 0);

		//Calc Icon Sizes
		var maxSize  = UI.leftMenuIconHolderSizeHeight;
		var avgSize  = htView / liCount;
		var minSize  = (htView - maxSize) / (liCount - 1);
		ul[0].maxSize = parseInt(maxSize);
		ul[0].avgSize = parseInt(Math.min(ul[0].maxSize, avgSize));
		ul[0].minSize = parseInt(Math.min(ul[0].avgSize, minSize));
		UI.animateLeftMenuSizes(null, true);

		//Update View's Padding & Width
		var elm_back  = $('#uiLeftBarBackground');
		var wLeftMenu = elm_back.length > 0 ? elm_back[0]._width : 0;
		var wWindow   = UI.window_width;
		if(window.isMobile) wLeftMenu = 0;
		var paddingLeft = window.isMobile ? 0 : wLeftMenu;
		$('#content > .uiTaskBarContainer > .uiTaskBarBackground div.uiTaskBar').css('padding-left', paddingLeft+'px');
		$('.ui-tabs-panel > .uiTaskBarContainer > .uiTaskBarBackground div.uiTaskBar').css('padding-left', '0px');
	},
	onWindowResize_UpdateUITaskBar: function(){
		if($('.uiTaskBarContainer').is('.uiTaskBarContainerUnderTabs')){//Resize Each in its tab
			if(!UI.onWindowResize_UpdateUITaskBar_isAuto){
				UI.onWindowResize_UpdateUITaskBar_isAuto = true;
				$('.uiTaskBarContainerUnderTabs').css('height', 'auto');
				$('.uiTaskBarBackground').css('height', 'auto');
				$('.uiTaskBar').css('height', 'auto');
				var taskbarBack = $('.uiTaskBarBackground:not(.uiTaskBarIsInSectionContent)')
				if(taskbarBack.length > 0) {
					if(document.body !== null) document.documentElement.style.setProperty('--ui-style-taskbar-height', taskbarBack[0].offsetHeight+'px');
					UI.uiStyleTaskbarHeight = taskbarBack[0].offsetHeight;
				}
			}
		}
		else{//Resize single taskbar
			UI.onWindowResize_UpdateUITaskBar_isAuto = false;
			var tb_tbl = $('.uiTaskBarTable');
			var h = tb_tbl.outerHeight();
			if(h !== null) $('.uiTaskBarBackground').css('min-height', h+'px');
			$('.uiTaskBarContainer').css('margin-bottom', $('.uiTaskBarBackground').outerHeight()+'px');
			if(h !== null) {
				tb_tbl = $('.uiTaskBarTable:not(.uiTaskBarIsInSectionContent)');
				if(tb_tbl.length > 0){
					if(document.body !== null) document.documentElement.style.setProperty('--ui-style-taskbar-height', h+'px');
					UI.uiStyleTaskbarHeight = h;
				}
			}
			else {
				h = $('.uiTaskBarBackground:not(.uiTaskBarIsInSectionContent)').height();
				if(h !== null) {
					document.documentElement.style.setProperty('--ui-style-taskbar-height', h+'px');
					UI.uiStyleTaskbarHeight = h;
				}
			}
		}

		//Taskbar In Frame
		$('body > div.uiTaskBarIFrameBackground, #section_view > div.uiTaskBarIFrameBackground, .section_content > div.uiTaskBarIFrameBackground, #content > div.uiTaskBarContainer > div.uiTaskBarBackground').each(function(){
			var backW = $(this).width(); if(!backW) backW = 99999;
			var viewW = $(UI.uiView).width(); if(!viewW) viewW = 99999;
			var isInBody = $(this.parentNode).is('body');

			if(!isInBody) $(this).children('.uiTaskBarTable').css('width', '100%');
			else $(this).children('.uiTaskBarTable').css('width', $(this).width()+'px');
			var h = $(this).children('.uiTaskBarTable').height();
			if(h != null){
				$(this).height(h+'px');
				if($(this).is('.uiTaskBarIsInSectionContent') == false){
					if(document.body !== null) document.documentElement.style.setProperty('--ui-style-taskbar-height', (h+1)+'px');
					UI.uiStyleTaskbarHeight = (h+1);
				}
			}
		});

	},
	onWindowResize_CollapsePopertySets: function(){
		if(UI.large_page_mode) return;

		var targetViewPortal = $('#section_view');
		if(targetViewPortal.length == 0) targetViewPortal = UI.uiView;
		if(targetViewPortal == null) targetViewPortal = $('body');

		$('.properties_set:not(.no_auto_size)').css('margin-left', '').css('width', '');
		$('.properties_set:not(.no_auto_size) td, .properties_set:not(.no_auto_size) th').css('display', 'table-cell');
		var maxWidth = targetViewPortal.width() - 24;
		$('.properties_set:not(.no_auto_size)').each(function(){
			if($(this).outerWidth() > maxWidth){
				$(this).find('td, th').css('display', 'block');
				$(this).css('margin-left', '0').css('width', maxWidth+'px');
			}
		});
	},
	onWindowResize_FullFrameOverlayView: function(){
		var leftBackground = $('#uiLeftBarBackground');
		if(leftBackground.length > 0){
			$('.frame-overlay-view').width('0px');
			$('.frame-overlay-view').width((UI.window_width - leftBackground[0]._width)+'px').css('left', leftBackground[0]._width+'px');
		}
	},
	onBeforePrint: function(e){

	},
	onAfterPrint: function(e){
		window.np_analytics.event('UI.onAfterPrint', e, '', null);
		if(typeof(e) != 'undefined' && e === false) return;
		top.had_print = true;
	},
	onWindowResize_ResizeUITabsOverflow: function(){
		if(UI.hold_onWindowResize_ResizeUITabsOverflow) return;
		$('#section_view .ui-tabs-nav:not(.no-resize)').each(function(){
			if(!$(this).is(':visible')) return;

			//Vars
			var tabContainer = $(this);
			var window_width = $(tabContainer[0].parentNode).width();
			var tabs = tabContainer.children('li:visible');

			//Reset
			tabContainer.addClass('ui-tabs-nav-multi-line').removeClass('ui-tabs-nav-multi-line-no-wrap');
			var newW = Math.floor(window_width - (tabContainer.marginWidth() + tabContainer.paddingWidth()));
			tabContainer.css('width', newW+ 'px');
			tabs.css('width', 'auto');

			//Group Groups based on DOM elm wrapping (by y-value)
			var wrappingGroups = {};
			tabs.each(function(){
				if(typeof(this) == 'undefined') return;
				var t = $(this).offset().top;
				if(typeof(t) == 'undefined') return;
				if(typeof(wrappingGroups[t]) == 'undefined') wrappingGroups[t] = [];
				wrappingGroups[t.toString()].push(this);
			});
			var groupCount = 0;
			for(var i in wrappingGroups) groupCount++;
			if(groupCount <= 1){
				tabContainer.removeClass('ui-tabs-nav-multi-line');
				return;
			}
			tabContainer.addClass('ui-tabs-nav-multi-line-no-wrap');

			//Divide tabs into even groups
			var avg_per_group = Math.ceil(tabs.length / groupCount);
			if(avg_per_group <= 0) avg_per_group = 1;
			var newWrappingGroups = [];
			var c = 0;
			for(var i in wrappingGroups){
				for(var x in wrappingGroups[i]){
					var li = wrappingGroups[i][x];
					var line = Math.floor(c/avg_per_group);
					if(typeof(newWrappingGroups[line]) == 'undefined') newWrappingGroups[line] = [];
					newWrappingGroups[line].push(li);
					c++;
				}
			}
			wrappingGroups = newWrappingGroups;

			//Size Each <li>
			var targetWidth = newW;
			var c = 0;
			for(var t in wrappingGroups){
				if(typeof(wrappingGroups[t]) == 'undefined') continue;

				//Get Current Width of tabs in this row...
				var currentWidth = 0;
				for(var i in wrappingGroups[t]) currentWidth += Math.floor($(wrappingGroups[t][i]).outerWidth());

				//Apply Extra Width to each...
				var addWidth = Math.floor(((targetWidth - currentWidth) / wrappingGroups[t].length));
				var appliedWidth = 0;
				var last_i = null;
				for(var i in wrappingGroups[t]) last_i = i;
				for(var i in wrappingGroups[t]){
					var w    = Math.ceil($(wrappingGroups[t][i]).width());
					var setW = Math.floor(w + addWidth);
					if(last_i == i){
						$(wrappingGroups[t][i]).width('0px').addClass('ui-tabs-nav-multi-line-last-li');
						setW = Math.floor(targetWidth - appliedWidth - ($(wrappingGroups[t][i]).outerWidth()));
					}
					else {
						setW -= 10;
						$(wrappingGroups[t][i]).removeClass('ui-tabs-nav-multi-line-last-li');
					}
					$(wrappingGroups[t][i]).width(setW+'px');
					appliedWidth += Math.floor($(wrappingGroups[t][i]).outerWidth());
				}
				c++;
			}

		});
	},
	onTableModifiedTimeChange: function(tablename, func, priority){
		if(typeof(UI.onTableModifiedTimeChange_callbacks[tablename]) == 'undefined') UI.onTableModifiedTimeChange_callbacks[tablename] = {};
		//Register event
		if(typeof(func) == 'function'){
			if(typeof(priority) == 'undefined') priority = 0;
			if(typeof(UI.onTableModifiedTimeChange_callbacks[tablename][priority]) == 'undefined') UI.onTableModifiedTimeChange_callbacks[tablename][priority] = [];
			UI.onTableModifiedTimeChange_callbacks[tablename][priority].push(func);
		}
		//Trigger event
		else if(typeof(func) == 'undefined'){
			var priority_keys = [];
			for(var priority in UI.onTableModifiedTimeChange_callbacks[tablename]) priority_keys.push(priority);
			priority_keys.sort();
			for(var p in priority_keys){
				for(var i in UI.onTableModifiedTimeChange_callbacks[tablename][priority_keys[p]]) {
					UI.onTableModifiedTimeChange_callbacks[tablename][priority_keys[p]][i]();
				}
			}
		}
	},

	/**/
	suspendOnWindowResize: function(){
		if(typeof(UI.suspendOnWindowResize.depth) == 'undefined') UI.suspendOnWindowResize.depth = 0;
		UI.suspendOnWindowResize.depth++;
		if(UI.suspendOnWindowResize.depth == 1){
			UI.suspendOnWindowResize.pendingCallOnResume = false;
			UI.onWindowResizeOrg = UI.onWindowResize;
			UI.onWindowResize = function(){ UI.suspendOnWindowResize.pendingCallOnResume = true; };
		}
	},
	resumeOnWindowResize: function(){
		if(UI.suspendOnWindowResize.depth >= 1){
			UI.suspendOnWindowResize.depth--;
			if(UI.suspendOnWindowResize.depth == 0){
				UI.onWindowResize = UI.onWindowResizeOrg;
				UI.onWindowResizeOrg = null;
				if(UI.suspendOnWindowResize.pendingCallOnResume){
					UI.suspendOnWindowResize.pendingCallOnResume = false;
					UI.onWindowResize();
					UI.uiOnLoadResizeDone = true;
				}
			}
		}
	},

	/*UI.load Page Methods*/
	load: function(href_or_elm, elm, as_template, ignore_target, dont_open_new_ui_tab, is_redirect, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		//Default
		if(typeof(href_or_elm) == 'object' && typeof(href_or_elm.jquery) != 'undefined') href_or_elm = href_or_elm[0];
		if(typeof(dont_open_new_ui_tab) == 'undefined' || dont_open_new_ui_tab == null) dont_open_new_ui_tab = true;
		if(typeof(as_template) == 'undefined' || as_template == '' || as_template == null) as_template = window.template;
		if(typeof(ignore_target) == 'undefined' || ignore_target == '' || ignore_target == null) ignore_target = false;
		if(typeof(is_redirect) == 'undefined' || is_redirect == '' || is_redirect == null) is_redirect = false;

		//Get Elm
		if(typeof(href_or_elm) == 'object'){
			href = href_or_elm.href;
			elm  = href_or_elm;
		}
		else{
			elm = $('<a>').addClass('ui-load-gen')[0];
			elm.href = href_or_elm;
			href = href_or_elm;
		}

		//Nav
		var target = $(elm).attr('target');
		if(target && !ignore_target){
			var a = $('<form>');
			a.attr('action', href);
			a.attr('target', target);
			a.attr('method', 'post');
			a.appendTo('body');
			if(href.match(/[\?&]trackdownload=1/)){
				a.attr('trackdownload', '1');
				UI.processView_FormTrackDownload();
			}
			event.href = href;
			event.refelm = elm;
			window.np_analytics.event('UI.load', event, '', typeof(sender) !== 'object' || sender === null ? a : sender);
			a[0].submit();
		}
		else{
			if(typeof(as_template) != 'undefined' && as_template == 'main_index') as_template = '';
			if(typeof(as_template) != 'undefined' && as_template != '' && !href.match(/(&|\?)tmpl=/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl='+as_template;
			UI.Navigate(elm, href, event, $(elm).parents((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView'), dont_open_new_ui_tab, is_redirect, sender);
		}

		return false;
	},
	popup: function(url_or_elm, name, specs, replace_history, do_not_append_caller_one, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;

		//Default Values
		var elm  = null;
		var href = url_or_elm;
		if(typeof(url_or_elm) == 'undefined' || url_or_elm == null) url_or_elm = location.href;
		if(typeof(specs) == 'undefined' || specs == null) specs = {};
		if(typeof(name) == 'undefined' || name == null) name = '_blank';
		if(typeof(replace_history) == 'undefined' || replace_history == null) replace_history  = false;
		if(typeof(do_not_append_caller_one) == 'undefined' || do_not_append_caller_one == null) do_not_append_caller_one  = false;

		//Parse Href
		if(typeof(href) != 'string'){
			elm = href;
			if(typeof(url_or_elm.href) != 'undefined')
				href = elm.href;
			else if(typeof(url_or_elm.action) != 'undefined')
				href = elm.action;
			else if(typeof(url_or_elm.src) != 'undefined')
				href = elm.src;
			else
				href = location.href;
		}
		//if(!do_not_append_caller_one && !href.match(/(\?|&)caller=1/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&')+'caller=1';

		//Set Specs (width, height, toolbars, etc...)
		if(typeof(specs) == 'string'){
			var _specs = {};
			var cParts = specs.split(',');
			for(var i in cParts){
				var kvp = cParts[i].split('=',2);
				if(kvp.length >= 2)
					_specs[kvp[0]] = kvp[1];
			}
			specs = _specs;
		}

		var w = Math.min(screen.width, 800);
		var l = (screen.width - w) / 2;
		var _specs = {
			top: 0,
			left: l,
			width: w,
			height: screen.height,
			toolbar: null,
			scrollbars: 1,
			menubar: null,
			location: 0,
			resizable: 1,
			channelmode: null,
			directories: null,
			fullscreen: null,
			status: null,
			titlebar: 1,
			dependent: 1
		}
		for(var i in specs) _specs[i] = specs[i];
		var sSpecs = '';
		for(var i in _specs){
			if(_specs[i] == null) continue;
			sSpecs += i+'='+_specs[i]+',';
		}

		event.href = href;
		event.popup = {href: href, name: name, sSpecs: sSpecs, replace_history: replace_history};
		window.np_analytics.event('UI.popup', event, '', sender);

		//Open the window
		var win = window.open(href, name, sSpecs, replace_history);
		win.focus();
		return win;
	},
	browserTab: function(url, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var form = document.createElement("form");
		form.method = "POST";
		form.action = url;
		form.target = "_blank";
		document.body.appendChild(form);
		event.href = url;
		window.np_analytics.event('UI.browserTab', event, '', typeof(sender) !== 'object' || sender === null ? form : sender);
		form.submit();
	},
	viewReady: function(func){
		if(confirm(func))
			func();
		return $(document);
	},
	viewShown: function(view_iframe, func){
		try {
			if(typeof(view_iframe.contentWindow.onViewShownFuncs) == 'undefined') view_iframe.contentWindow.onViewShownFuncs = [];

			if(typeof(func) != 'undefined'){
				view_iframe.contentWindow.onViewShownFuncs.push(func);
			}
			else{
				UI.lastActiveIframeView = view_iframe.id;
				for(var i = 0; i < view_iframe.contentWindow.onViewShownFuncs.length; i++) view_iframe.contentWindow.onViewShownFuncs[i]();
			}
		}
		catch(err){
			/* Uncaught DOMException: Permission denied to access property -- Triggered when frame fails to load and is about:blank*/		
		}
	},
	processView: function(){
		UI.processView_ElementsStyle();
		UI.processView_GetInfoFromFooter();
		UI.processView_createAcordianFieldSets();
		MetaMenu.processView_createMetaMenus();
		UI.processView_uiTaskBar();
		UI.processView_SetNavHooks();
		UI.processView_FormTrackDownload();
		UI.processView_SetAltKeyShortcuts();
		UI.processView_CollapseMobileTables();
		UI.processView_AlphaSortPropTables();
		UI.processView_ConvertMissingTHeadTables();
		UI.onWindowResize();
		setTimeout('UI.processView_PostDocumentLoad()', 100);
	},
	processView_ElementsStyle: function(section){
		if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu){
			if(typeof(window.processView_ElementsStyle_noCBFix) == 'undefined'){
				$('<style> input[type="checkbox"]:not(.system-style) { display: inline-block !important; height: auto !important; visibility: visible !important; width: auto !important; } </style>').appendTo( "head" )
				window.processView_ElementsStyle_noCBFix = true;
			}
			return;
		}

		if(UI.uiView === null || UI.uiView.length == 0){
			UI.uiView = $('#content');
			if(UI.uiView.length == 0) UI.uiView = $('body');
		}

		var view = null;
		if(typeof(section) == 'undefined') view = UI.uiView;
		else {
			view = $(section);
			if(view.length == 0) view = UI.uiView;
		}

		//Checkboxes
		foreachSelectorIn(view, 'input[type="checkbox"]:not(.system-style):not(.was-styled)',function(){
			var siblingElmPreCreated = this.nextElementSibling !== null && this.nextElementSibling.matches('span.checkboxOverlay');
			var overlay = siblingElmPreCreated ? $(this.nextElementSibling) : $('<span class="checkboxOverlay"></span>')
			overlay.attr('title', $(this).attr('title'));
			if($(overlay).is('.event-set') === false) {
				$(overlay).addClass('event-set').click(function(){
					var cb = $(this.previousElementSibling);
					if(cb.is('[readonly]')) return;
					cb.click();
					if(document.selection)
						document.selection.empty();
					else
						window.getSelection().removeAllRanges();
				});
			}
			$(this).addClass('was-styled')
			if(!siblingElmPreCreated) $(this).after(overlay);
		});

		//Radios
		foreachSelectorIn(view, 'input[type="radio"]:not(.system-style):not(.was-styled)', function(){
			var siblingElmPreCreated = this.nextElementSibling !== null && this.nextElementSibling.matches('span.radioOverlay');
			var overlay = siblingElmPreCreated ? $(this.nextElementSibling) : $('<span class="radioOverlay"></span>');
			overlay.attr('title', $(this).attr('title'));
			$(this).change(function(){
				if($(this).is(':checked')){
					$('input[type="radio"][name="'+$(this).attr('name')+'"]').removeAttr('checked').each(function(){this.checked=false;});
					$(this).attr('checked', 'checked');
					this.checked = true;
				}
			});
			if($(overlay).is('.event-set') === false) {
				$(overlay).addClass('event-set').click(function(){
					var cb = $($(this).prev()[0]);
					if(cb.is('[readonly]')) return;
					$(cb).click();
					if(document.selection)
						document.selection.empty();
					else
						window.getSelection().removeAllRanges();
				});
			}
			$(this).addClass('was-styled')
			if(!siblingElmPreCreated) $(this).after(overlay);
		});
	},
	processView_GetInfoFromFooter: function(){
		$('#footer_QuickLinks').appendTo($('#uiTopBar_LinkPane'));
		$('#footer_HelpLinks').appendTo($('#uiTopBar_HelpPane').empty());
		$('#walkthrough_links').appendTo($('#uiTopBar_WalkthroughsPane').empty());
		if($('#uiTopBar_HelpPane a').length == 0) $('#uiTopBarMenuItems .btnHelp').hide();
		if($('#uiTopBar_LinkPane a').length == 0) $('#uiTopBarMenuItems .btnLinks').hide();
		if(!window.userHasUpdateAccess || HOSTED)
			$('<div class="version_text_in_help">'+PRODUCT_NAME+' v'+NUMBER_VERSION+'.'+BUILD_VERSION+'</div>').appendTo($('#uiTopBar_HelpPane'));
		else
			$('<div class="version_text_in_help"><a newtab href="'+CI_BASE_URL+'update">'+PRODUCT_NAME+' v'+NUMBER_VERSION+'.'+BUILD_VERSION+'</a></div>').appendTo($('#uiTopBar_HelpPane'));
	},
	processView_PostDocumentLoad: function(){

		//Tabs click on LI vs A tag
		$('ul.ui-tabs-nav > li').css('cursor', 'pointer');
		$('ul.ui-tabs-nav > li > a').css('text-decoration', 'none');
		$('ul.ui-tabs-nav > li').click(function(event){
			var ul = $(this).parent('ul');
			if(ul[0].matches('.tabs-emulated')){
				UI.load($(this).find('a')[0]);
			}
			else{
				var div = ul.parent('div');
				div.tabs({ active: $(this).index() });
			}
			UI.resize();
			return false;
		});

		$('ul.ui-tabs-nav').contents().filter(function() {
			return this.nodeType == 3; //Node.TEXT_NODE
		}).remove();
		UI.postDocumentLoadFinished = true;
	},
	processView_createAcordianFieldSets: function(){
		if(UI.large_page_mode) return;

		if(!window.no_adv_options && !window.slow_cpu && typeof($('').accordion) != 'undefined'){
			$(".jqui_accordion").accordion(
				{
					header:'h3',
					autoHeight: false,
					heightStyle: "content",
					change: function(event, ui){
						this.activePane = $(ui.oldContent[0]).is('.advanced_body') ? 1 : 2;
						UI.resize();
					},
				}
			);
			_(".ui-accordion-header").click(function(){
				setTimeout(function(){ UI.resize(); }, 300);
			});
			_(".advanced.ui-accordion-header").click(function(){
				var basic = $(this.parentNode).find('.basic')[0];

				if(typeof(this.advText)   == 'undefined') this.advText = $(this).html();
				if(typeof(this.basicText) == 'undefined') this.basicText = $(basic).html();
				if(typeof(this.parentNode._activePane) == 'undefined') this.parentNode._activePane = 1;

				if(this.parentNode._activePane == 2){
					this.parentNode._activePane = 1;
					$(basic).click();
					$(this).html(this.advText);
				}
				else{
					this.parentNode._activePane = 2;
					$(this).html(this.basicText);
				}
			});
		}
		else{
			//No advanced section
			_('.jqui_accordion h3.advanced').css('display', 'none');
		}
	},
	processView_uiTaskBar: function(){

		var btnId       = 0;
		var elm_SelectA = '#section_view '+(UI.mainMenuMode == 'main_index' ? '.main_index_page' : '')+' .uiTaskBar';
		var elm_SelectB = '#section_view .uiTaskBarConvertOld';
		var elms = $(elm_SelectA+', '+elm_SelectB);
		var uiTaskBarConvertOldCount = 0;
		if(elms.length > 0){
			var floatingDivContainer = null;
			elms.each(function(){
				if(this.matches('.uiTaskBarConverted')) return;
				$(this).addClass('uiTaskBarConverted');

				var showOnlyInTabs = this.matches('.uiTaskBarShowOnlyInTabs');
				var isOld = this.matches('.uiTaskBarConvertOld');
				var elm = $(this);
				var parent = null;
				if(UI.mainMenuMode == 'main_index')
					parent = elm.parents('.main_index_page')[0];
				else
					parent = $('#content')[0];

				var floatingDivContainerCreated = false;
				floatingDivContainer = $(parent).find('.uiTaskBarContainer')[0];
				if(typeof(floatingDivContainer) == 'undefined'){
					floatingDivContainer = document.createElement('div');
					floatingDivContainerCreated = true
					$(floatingDivContainer).addClass('uiTaskBarContainer');
					$(floatingDivContainer).css('height', 0).css('overflow', 'visible');
					if(showOnlyInTabs) $(floatingDivContainer).css('display', 'none');

					var floatingDiv = document.createElement('div');
					$(floatingDiv).addClass('uiTaskBarBackground');
					if(window.template == 'iframe') $(floatingDiv).addClass('uiTaskBarIFrameBackground');
					$(floatingDiv).attr('id', floatingDiv.id);
					$(floatingDiv).appendTo(floatingDivContainer);

					//Append Copy...
					if(floatingDivContainerCreated){
						$(floatingDivContainer).prependTo(parent);
					}
				}

				elm.find('input, a').each(function(i){
					if(typeof(this.id) == 'undefined' || this.id == '') this.id = 'uiTaskBar_'+btnId.toString();
					btnId++;
				});

				var copy = elm.clone(true, true);
				copy.find('input, a').addClass('uiTaskBarCloneElm').each(function(){
					this.id += '_clone';
				});

				if(isOld){
					uiTaskBarConvertOldCount++;
					var rows = copy.find('tr');
					if(rows.length != 2){
						console.log('UI ERROR: Failed to convert the following to uiTaskBar, table should be 2 rows.');
						console.log(elm);
						return;
					}

					a = [];
					icons = [];
					texts = [];
					title = [];

					//Clone the text, title & icon from the orginal buttons table
					$(rows[1]).find('th, td').each(function(i){
						texts[i] = $(this).html();
						title[i] = $(this).attr('title');
					});
					$(rows[0]).find('th, td').each(function(i){
						if($(this).find('a').length > 0){
							icons[i] = $($(this).find('a')[0]).clone();
						}
						else{
							icons[i] = $($(this).find('img, input[type="image"]')[0]).clone();
							//Prevent event bubbling on click
							if(typeof(icons[i].attr('onclick')) != 'undefined'){
								icons[i].attr('onclick', 'UI.MobileHideLeftMenu(false, event, this); event.stopPropagation(); '+icons[i].attr('onclick'));
							}
						}
						$(icons[i]).attr('td_class', $(this).attr('class')).addClass("taskBarClickEventElm");
						if(typeof(title[i]) == 'undefined' || !title[i]) title[i] = $(this).attr('title');
					});

					//Find the taskbar container, or create a new one if none exist
					var divTaskBarTable = null;
					divTaskBarTable = $('.uiTaskBarConvertedFromOld')[0];
					if(typeof(divTaskBarTable) == 'undefined'){
						divTaskBarTable = $('.uiTaskBarBackground > .uiTaskBar')[0];
						if(typeof(divTaskBarTable) == 'undefined'){
							divTaskBarTable = $(document.createElement('div'));
							divTaskBarTable.addClass('uiTaskBar uiTaskBarTable uiTaskBarConvertedFromOld');
							divTaskBarTable.appendTo(floatingDiv);
						}
					}

					//Check for the trailing .taskbar_clear element to insertBefore
					var taskbar_clear = $(divTaskBarTable).find('.taskbar_clear');
					taskbar_clear = taskbar_clear.length > 0 ? taskbar_clear[taskbar_clear.length - 1] : null;

					//Append the buttons-table clone to the top taskbar
					for(var i = 0; i < icons.length; i++){
						var spanImg = $('<span>').addClass('uiTaskBarImgContainer');
						spanImg.append(icons[i]);

						var divButton = $(document.createElement('div'));
						divButton.attr('class', $(icons[i]).attr('td_class'));
						divButton.addClass('uiTaskBarButton');
						divButton.addClass('uiTaskBarButtonFor_0');
						divButton.addClass('uiTaskBarButtonFor-src-uiprocview-uitaskbar');
						divButton.append(spanImg);
						divButton.append(texts[i]);
						if(taskbar_clear === null){
							divButton.appendTo(divTaskBarTable);
						}
						else {
							divButton.insertBefore(taskbar_clear);
						}


						if(typeof(title[i]) != 'undefined' && title[i] != ''){
							divButton.attr('title', title[i].replace(/<br\/?>/i, "\n"));
						}
						divButton.click(function(event){

							//Prevent Double Click
							if(!this.matches('.no-click-limit')){
								var tempFnc = function(){
									if(!UI.taskbarbaritemMaxClickRate || UI.taskbarbaritemMaxClickRate == '0') return true;
									if(typeof(this.lastClickEventTime) == 'undefined') this.lastClickEventTime = 0;
									var now = (new Date()).getTime();
									var span = now - this.lastClickEventTime;
									if(span < UI.taskbarbaritemMaxClickRate) return true;
									this.lastClickEventTime = now;
									UI.fadeOutAndIn(this);
									return false;
								}
								if((tempFnc).bind(this)()) return true;
							}

							window.np_analytics.event('uiTaskBarConvertOld.click', event, '', this);

							var alink = $(this).find('.taskBarClickEventElm')[0];
							UI.MobileHideLeftMenu(false, event, this);
							event.stopImmediatePropagation();
							event.preventDefault();
							event.stopPropagation();
							var id = alink.id.replace(/_clone$/, '');
							var p  = $('#'+id);
							if(p.length > 0){
								p[0].click();
							}
							else if(typeof(alink) != 'undefined'){
								$(alink).click();
							}
						});
					}

					$(divTaskBarTable).find('.uiTaskBarTableClearFloats').remove();
					$(divTaskBarTable).append($('<div style="clear:both; width: 1px;" class="uiTaskBarTableClearFloats"></div>'));
				}
				else{
					copy.appendTo(floatingDiv);
				}

				$(floatingDiv).find('input, a').each(function(){
					$(this).data('onclick', this.onclick);
					if(this.matches('input')) $(this).attr('onclick', 'return false;');
					else $(this).attr('onclick', '');
					$(this).onclick = function(event){ };
				});

				elm.hide();
			});
			if(typeof(floatingDivContainer) !== 'undefined' && floatingDivContainer !== null){
				setTimeout(function(){
					var hElm = $(floatingDivContainer).find('.uiTaskBarBackground')[0];
					h = typeof(h) == 'undefined' ? null : hElm.offsetHeight - 1;
					if(h !== null && $(hElm).is('.uiTaskBarIsInSectionContent') == false){
						if(document.body !== null) document.documentElement.style.setProperty('--ui-style-taskbar-height', h + 'px');
						UI.uiStyleTaskbarHeight = h;
					}
				}, 1);
			}
		}
		if(uiTaskBarConvertOldCount > 0){
			if(typeof(frameElement) !== 'undefined' && frameElement !== null) {
				if(typeof(frameElement.autoAppendFramePageButtons) === 'function'){
					frameElement.autoAppendFramePageButtons();
				}
			}
		}
		UI.elmUISearchSettings().keyup(function(e){
			if (e.keyCode == 27){
				UI.clearSearch(e, this);
			}
		});
	},
	processView_SetNavHooks: function(){
		//Set target for <a> & <form>
		//--Append tmpl= to URLs
		$('a:not(.nav-animated-link), form:not(.nav-animated-form)').each(function(){
			if(window.template != 'iframe'){//Normal Page Load
				if(typeof($(this).attr('tab')) != 'undefined' && typeof($(this).attr('target')) == 'undefined'){
					this.target = '_blank';
					$(this).attr('target', this.target);
				}
			}
			else{//Am running in IFrame
				if(typeof($(this).attr('self')) != 'undefined' && typeof($(this).attr('target')) == 'undefined'){
					this.target = '_self';
					$(this).attr('target', this.target);
				}

				var urlIsLink = typeof(this.href) != 'undefined' && this.href != '' && this.href.indexOf('#') == -1 && this.href.indexOf('javascript:') != 0;
				var targetsSelf = typeof(this.target) == 'undefined' || this.target == '' || this.target == '_self';
				if(urlIsLink && targetsSelf){
					var href = this.href;
					if(!href.match(/(&|\?)tmpl=/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe';
					this.href = href;
				}
			}
		});

		//Open new browser tabs as left-menu tabs instead (top.UI.loadInternalTab)
		//--Set the menu title text
		//--Prevent double click
		$('a:not(.nav-animated-link)').each(function(){
			$(this).addClass("nav-animated-link");
			$(this).click(function(e){
				e.href = $(this).attr('href');
				window.np_analytics.event('a.click', e, '', this);
			});

			var isTab           = typeof($(this).attr('newtab')) != 'undefined';
			var isMainViewFrame = typeof(top.UI) != 'undefined' && top.UI.mainMenuMode == 'main_index' && window != top && $(window.frameElement).is('.staticFrame');
			var targetsSelf     = typeof(this.target) == 'undefined' || this.target == '' || this.target == '_self';
			var urlIsLink       = false;
			var scriptIsInteral = null;
			if(typeof(this.href) != 'undefined'){
				var __link = '';
				try{ __link = this.href; }
				catch(err) { if(err.message.indexOf('A security problem occurred.') == 0) log("[UI.processView_SetNavHooks() EXCEPTION OK] "+err.message); else log(err); }
				if(__link != '')
					if(__link.indexOf('#') == -1)
						if(__link.indexOf('javascript:') != 0)
							urlIsLink = true;
						else
							scriptIsInteral = !__link.match(/(window|UI)\s*.\s*(open|browserTab|popup)\s*\(/i);
			}
			var isMainUITabChild = $(this).parents('.main_index_page').length > 0;
			if(!urlIsLink) $(this).attr('target', '_self');

			//Open in Internal Tab?
			if(typeof(top.UI) != 'undefined' && top.UI.mainMenuMode == 'main_index'){
				if(((isMainViewFrame && targetsSelf) || isTab || isMainUITabChild) && urlIsLink){
					$(this).click(function(event){
						//Event not canceled
						if(!event.isPropagationStopped() && !event.isImmediatePropagationStopped() && !event.isDefaultPrevented()){
							if(typeof(this.lastClick) == 'undefined') this.lastClick == null;
							var d = new Date();
							var now = d.getTime();
							if(this.lastClick != now){//Prevent double event fire (IT BURNS!!)
								this.lastClick = now;
								var href = this.href;

								//Get the new tab's temporiay title
								var title = false;
								{
									//Get from <a>'s t4ext
									title = $(this).contents().filter(function(){return this.nodeType === 3;})[0];
									if(typeof(title) != 'undefined') title = $(title).text();
									else title = false;
									//Get from a's title attribute
									if(title == null || title == '' || title == false){
										title = $(this).attr('title');
									}
									//Get from a > img's title attribute
									if(title == null || title == '' || title == false){
										var img = $(this).find('img[title]');
										if(img.length > 0){
											title = img.attr('title');
										}
									}
									//Get from a > img's alt attribute
									if(title == null || title == '' || title == false){
										var img = $(this).find('img[alt]');
										if(img.length > 0){
											title = img.attr('alt');
										}
									}
									//Default to "loading..."
									if(title == null || title == '' || title == false){
										title = window.STR_LOADING+'...';
									}
								}
								top.UI.loadInternalTab(href, title);

								UI.MobileHideLeftMenu(false, event, this);
								event.preventDefault();
								event.stopPropagation();
								event.stopImmediatePropagation();
								return false;
							}
						}
					});
				}
				else {
					if(!scriptIsInteral && !targetsSelf){
						$(this).addClass('non-internal-tab-link');
					}
				}
			}
			else if((urlIsLink && typeof(top.UI) != 'undefined' && top.UI.mainMenuMode == 'main_index') || isTab){
				if(!scriptIsInteral){
					if(urlIsLink) $(this).attr('target', '_blank');
					$(this).addClass('non-internal-tab-link');
				}
			}

		});

		$('form:not(.nav-animated-form)').each(function(){
			$(this).addClass("nav-animated-form");
			$(this).submit(function(e){ 
				e.href = $(this).attr('action');
				window.np_analytics.event('form.submit', e, '', this);
			});

			var isTab  = typeof($(this).attr('newtab')) != 'undefined';
			if(isTab){
				if(top.UI.mainMenuMode != 'main_index') $(this).attr('target', '_blank');
				else {
					$(this).submit(function(){
						var frame = top.UI.loadInternalTab(NP_BASE_URL+'blank.php?tmpl=iframe', '...');
						$(this).attr('target', $(frame).attr('name'));
						if(typeof(this.reAllowSubmit) === 'function') this.reAllowSubmit();
					});
				}
			}

			var target = $(this).attr('target');
			var action = $(this).attr('action');

			if((typeof(target) == 'undefined' || target == null || target == '' || target == '_self')
			&& (typeof(action) == 'string' && action != '' && action != null && action.indexOf('#') == -1 && action.indexOf('javascript:') != 0)){

				if(typeof(window.template) != 'undefined' && window.template != '' && !action.match(/(&|\?)tmpl=/i)){
					action += (action.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl='+window.template;
					$(this).attr('action', action);
					var input = $('<input type="hidden" name="tmpl" value="'+window.template+'">');
					input.appendTo(this);
				}

				$(this).submit(function(event){
					var parentTabs = $(this).parents((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView');
					if(parentTabs.length > 0 && !action.match(/(&|\?)tmpl=/i)) action += (action.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&')+'tmpl=iframe';
					$(this).attr('action', action);
					return UI.Navigate(this, action, event, parentTabs);
				});
			}
		});

		if(!window.np_analytics.disabled){
			//Capture all button presses
			$('button:not(.nav-animated-form), input[type="button"]:not(.nav-animated-form), input[type="submit"]:not(.nav-animated-form), input[type="image"]:not(.nav-animated-form)').each(function(e){
				$(this).addClass("nav-animated-form");
				$(this).click(function(){ window.np_analytics.event('button.click', e, '', this); });
			});
			//Capture input changes
			$('input:not(.nav-animated-form):not([type="image"]):not([type="submit"]):not([type="button"]),textarea:not(.nav-animated-form),select:not(.nav-animated-form)').each(function(e){
				$(this).addClass("nav-animated-form");
				$(this).change(function(){ window.np_analytics.event('input.onchange', e, '', this); });
			});
		}

		//Rewrite <a href=... target=_blank> URLs to use window.open, so that window.close will work (browser security rules have changed)
		$('a.non-internal-tab-link[target="_blank"][href], a.non-internal-tab-link[target="_new"][href]').each(function(){
			if(this.href.match(/^javascript:/)) return;
			$(this).attr('href', 'javascript:window.open('+JSON.stringify(this.href)+', \''+$(this).attr('target')+'\');void(0);');
			$(this).removeAttr('target');
		});
	},
	processView_SetAltKeyShortcuts: function(){
		if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
		$('#uiLeftItems .itemText').each(function(){ UI.AssignAltKey(this); });
	},
	processView_ajaxSuccess: function(){
		UI.processView_ElementsStyle();
	},
	processView_CollapseMobileTables: function(){
		if(window.isMobile){
			$('table.mobile_collapse').each(function(){

				//Find Title & Headers
				var Title = '';
				var HeaderRow = null;
				{
					var header_rows = new Array();
					var trs = $(this).children('thead').children('tr');
					var found_as_headers = 0;
					trs.each(function(index){
						//Check if is header row
						var isHeaderRow = (this.childNodes.length > 0);
						for(var i = 0; i < this.childNodes.length; i++){
							var node = this.childNodes[i];
							if(typeof(node.tagName) != 'undefined'){
								var tag  = node.tagName.toLowerCase();
								if(tag != "th" && !$(node).hasClass('sub_header')){
									isHeaderRow = false;
									break;
								}
							}
						}
						if(isHeaderRow){
							found_as_headers++;
							header_rows.push(this);
						}
					});
					if(found_as_headers == 0){
						return;
					}
					else if(found_as_headers > 2){
						return;
					}
					else if(found_as_headers == 1){
						HeaderRow = header_rows[0];
					}
					else{
						Title = $(header_rows[0]).text();
						HeaderRow = header_rows[1];
					}
				}

				//Generate HTML control
				var table = $('<table style="margin-top: 24px;" id="'+get_uuid()+'" class="report mobile_collapse_control notablesorter nofloat"><tbody></tbody></table>');
				table.insertAfter(this);
				table[0].active_row = -1;
				table[0].parent = this;
				table[0].header_title = 'test'+ Title;
				table[0].header_row = HeaderRow;
				table[0].data_length = $(this).children('tbody').children('tr').length;
				UI.MobileCollapsedTableOpenRecord(table[0], 0);
			});
		}
	},
	processView_AlphaSortPropTables: function(){
		$('.properties_table_alphasort').each(function(){
			if(typeof(this.properties_table_alphasort_once) == 'undefined') this.properties_table_alphasort_once = false;
			if(this.properties_table_alphasort_once) return;
			this.properties_table_alphasort_once = true;
			var tbodies = $(this).children('tbody').length > 0 ? $(this).children('tbody') : $(this);
			tbodies.each(function(){
				var trs = $(this).children('tr');
				var trBuffer = new Array();

				var funcGetTrTextKey = null;
				funcGetTrTextKey = function(tr){
					var keyText = '';
					if($(tr).attr('sortkeygroup') != null) keyText += $(tr).attr('sortkeygroup');
					if($(tr).attr('sortkey') != null) keyText += $(tr).attr('sortkey');
					else if($(tr).find('label').length > 0) keyText += $(tr).find('label').text();
					else if($(tr).find('th').length > 0) keyText += $(tr).find('th').text();
					else keyText += $(tr).find('td').text();
					if(keyText.match(/^(\s|&nbsp;)*(&#9492;|└)/i)){
						var prev = $(tr).prev();
						keyText += (prev.length > 0 ? funcGetTrTextKey(prev[0])+' ' : '')+keyText;
					}
					return keyText;
				};

				//Get <tr>s to sort
				trs.each(function(){
					var keyText = funcGetTrTextKey(this);
					trBuffer.push({
						key: keyText,
						tr: this
					});
				});

				//Sort the buffer
				trBuffer.sort(function(a, b){
					if(a.key < b.key) return -1;
					if(a.key > b.key) return 1;
					return 0;
				})

				//Append Sorted DOM <tr>s
				for(var i in trBuffer){
					var tr_elm = trBuffer[i].tr;
					$(this).append(trBuffer[i].tr);
				}
			});

		});
	},
	processView_FormTrackDownload: function(){
		//Only for <form>s in <iframe> views
		if(typeof(window.frameElement) == 'undefined') return;
		//Hook all <form trackdownload> elements
		$('form[trackdownload]:not(.trackdownload_hooked)').each(function(){
			//Don't hook twice
			$(this).addClass('trackdownload_hooked');
			//Wrap the <form>.submit() with our hook
			this._processView_FormTrackDownload_submit = this.submit;
			this.submit = (function(a,b,c,d,e){ top.UI.processView_FormTrackDownload_formOnSumbit.call(this, a, b, c, d, e, this); }).bind(this);
		});
	},
	processView_FormTrackDownload_formOnSumbit: function(a,b,c,d,e,form){
		//Append tracking ID
		window.processView_FormTrackDownload_uuid = get_uuid();
		window.processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
		$('<input type="hidden" name="form_track_download_uuid">').val(window.processView_FormTrackDownload_uuid).appendTo(this);

		//Get Frame Object
		var _frame = typeof(this.ownerDocument.defaultView) != 'undefined' ? this.ownerDocument.defaultView.frameElement : this.ownerDocument.parentWindow.frameElement;
		if(typeof(_frame) == 'undefined' || _frame == null){
			if(typeof($(this).attr('target')) != 'undefined' && typeof(window.frames[$(this).attr('target')]) != 'undefined' && typeof(window.frames[$(this).attr('target')].frameElement) != 'undefined')
				_frame = window.frames[$(this).attr('target')].frameElement;
		}
		if(typeof(_frame) == 'undefined' || _frame == null)
			_frame = window.frameElement;

		//Submit
		var result = this._processView_FormTrackDownload_submit(form,b,c,d,e);
		if(typeof(result) == 'undefined' || result !== false){
			//Show as loading
			top.UI.setFrameContentsAsLoading(_frame);
			//Watch for complete signal
			window.processView_FormTrackDownload_IsComplete = false;
			window.processView_FormTrackDownload_functionCheckIsComplete = (function(){
				var url = NP_BASE_URL+'frmDownloadProgress.php?v='+IMAGE_UPLOAD_DIR.replace(/[\\\/ ]+$/, '').replace(/[\\\/ ]+/, '')+'&uuid='+window.processView_FormTrackDownload_uuid
				$.fetch(url,
					function(r){
						//Success, file found
						window.processView_FormTrackDownload_lastSuccess = (new Date()).getTime();

						//Complete
						if(r != '0'){
							var setTitle = null;
							var setSubTitle = null;
							if(r != '1'){
								var lines = r.split("\n");
								setTitle = typeof(lines[0]) == 'undefined' ? null : lines[0];
								setSubTitle = typeof(lines[1]) == 'undefined' ? null : lines[1];
							}
							//Reset loading image on save/next/download button back to orginal source
							if(typeof(form) != 'undefined'){
								$(form).find('input[src="images/loading.gif"]').each(function(){
									if(typeof(this.__preventDoubleSubmission_org_src) != 'undefined'){
										$(this).attr('src', this.__preventDoubleSubmission_org_src).removeClass('rotate');
									}
								});
							}
							window.processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(_frame, setTitle, setSubTitle);
						}
					},
					function(){
						//Timeout, never found the tracking file...
						if((new Date()).getTime() - window.processView_FormTrackDownload_lastSuccess > 8000 /*8s*/){
							window.processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(_frame);
						}

						//Try again...
						else if(!window.processView_FormTrackDownload_IsComplete){
							setTimeout(window.processView_FormTrackDownload_functionCheckIsComplete, 1000);
						}
					});
			});
			window.processView_FormTrackDownload_functionCheckIsComplete();
		}
	},
	processView_ConvertMissingTHeadTables: function(){
		//Add <thead> to all .report tables that don't already have one
		//--Look at all report tables
		$('table.report').each(function(){
			//Skip floating headers
			if(this.matches('.floating_header') || this.matches('.floating_header_h')) return;
			//Exclude tables that already have a <thead>
			if($(this).children('thead').length > 0) return;

			//Get the header rows
			var pop_rows = new Array();
			var trs = $.merge($(this).children('tr'), $(this).find('tbody > tr'));
			var found_as_headers = 0;
			trs.each(function(index){
				if(found_as_headers > 5) return false;//Too many <thead> rows...
				//Check if is header row
				var isHeaderRow = (this.childNodes.length > 0);
				for(var i = 0; i < this.childNodes.length; i++){
					var node = this.childNodes[i];
					if(typeof(node.tagName) != 'undefined'){
						var tag  = node.tagName.toLowerCase();
						if(tag != "th" || $(node).hasClass('nofloat') || $(node).hasClass('sub_header')){
							isHeaderRow = false;
							break;
						}
					}
				}
				if(isHeaderRow){
					found_as_headers++;
					pop_rows[index] = this;
				}
				else
					return false;
			});

			//No Header found?
			if(pop_rows.length == 0) return;

			//Add <thead> to report table
			$(this).addClass('AutoTHead');
			var thead = $('<thead>');
			$(this).prepend(thead);

			//Move the <tr>s to the <thead>
			for(var i in pop_rows){
				$(pop_rows[i]).detach().appendTo(thead);
			}

			//Format the first <tbody> row
			//--Find first <tr>
			var firstTbodyRow = thead.next();
			if(typeof(firstTbodyRow) == 'undefined') return;
			if(firstTbodyRow.is('tbody') || firstTbodyRow.is('tfoot')) firstTbodyRow = $(firstTbodyRow[0].children[0]);
			//--No Round always
			firstTbodyRow.children('td, th').addClass('no-round');
			//--Sub header type <tr>
			if(firstTbodyRow.children('td.sub_header, th.sub_header').length > 0) firstTbodyRow.addClass('sub_header');

			//Set HTML2PDF <tr> header count
			var parentNode = this.parentNode;
			if(parentNode.matches('form')) parentNode = parentNode.parentNode;
			$(parentNode).children('#form_pdf_generate').append($('<input type="hidden" name="AutoTHeadCount" value="'+pop_rows.length+'">'));
		});
	},

	/*Menu Methods*/
	createMenu: function(){
		if(UI.mainMenu == null) { return; }
		if($('#uiLeftBar').length == 0) return;
		if($('#uiLeftBar > *').length != 0) return;
		$('#uiLeftBar').addClass('menu-type-'+UI.menuType);
		UI.mainMenu.createMenu(UI.menuType);
		UI.onWindowResize();
	},
	createMenu_sub: function(menu, elm){
		if(UI.menuType == 'mdi'){
			$.ajaxRetry({
				url: CI_BASE_URL + 'main/mdiMenu/?&tmpl=blank',
				success: function(r){

					var fnOnElmMouseOver = function(timeout){
						if(typeof(timeout) === 'undefined') timeout = 24;
						uiWaitForFinalEvent((function(){
							if($(this).is('#uiMDIMenuOverlay')){
								$(this).trigger('click');
							}
							else if($('#uiMDIMenuBar').is('.mdi-menu-open') && !$(this).closest('.mdi-menu-level').is('.mdi-menu-level-open')) {
								$('.mdi-menu-level-open').removeClass('mdi-menu-level-open');
								$(this).parents('.mdi-menu-level').addClass('mdi-menu-level-open');
								var next = $(this).next();
								if(next.length > 0){
									var m = ($(window).height() - $(this).offset().top);
									var t = next[0].children[0].children[0];
									$(t).css('max-height', m + 'px');
								}
							}
						}).bind(this), timeout, 'mdi-menu-hover-change');
					};

					$('#uiMDIMenuBar').html(r);
					$('.mdi-menu-level-0-title').on('click', function(){
						if($('#uiMDIMenuBar').is('.mdi-menu-open') && $(this).closest('.mdi-menu-level').is('.mdi-menu-level-open')) {
							$('#uiMDIMenuBar').removeClass('mdi-menu-open');
							$('#uiMDIMenuOverlay').css('display', 'none');
							$('.mdi-menu-level-open').removeClass('mdi-menu-level-open');
						}
						else {
							$('#uiMDIMenuBar').addClass('mdi-menu-open');
							var t = Math.max($('#uiMDIMenuBar').offset().top, $('#uiTopBar').height());
							$('#uiMDIMenuOverlay').css('display', 'block').css('top', t+'px').css('height', 'calc(100vh - '+t+'px)');
							if(!$('#uiMDIMenuOverlay').is('.uiMDIMenuOverlay-events-bound')){
								$('#uiMDIMenuOverlay')
									.addClass('uiMDIMenuOverlay-events-bound')
									.on('click', function(){
										$('#uiMDIMenuBar').removeClass('mdi-menu-open');
										$('#uiMDIMenuOverlay').css('display', 'none');
										$('.mdi-menu-level-open').removeClass('mdi-menu-level-open');
									})
									.on('mouseover', function(){
										(fnOnElmMouseOver.bind(this))(500);
									});
							}
						}
						$(this).trigger('mouseover');
					});
					$('.mdi-menu-level-title:not(.mdi-menu-level-0-title)').on('click', function(){
						$('.mdi-menu-level-open').removeClass('mdi-menu-level-open');
						$(this).parents('.mdi-menu-level').addClass('mdi-menu-level-open');
						var href = $(this).attr('x-href');
						if(typeof(href) === 'string'){
							UI.open(href);
							$('.mdi-menu-level-open').removeClass('mdi-menu-level-open');
							$('#uiMDIMenuBar').removeClass('mdi-menu-open');
						}
					});
					$('.mdi-menu-level-title').on('mouseover', function(){
						((fnOnElmMouseOver).bind(this))();
					});
				},
				error: function(r){
					console.log('ERROR LOADING MAIN MDI MENU [E8717234138216]');
					console.log(r);
				}
			});
		}
		else {
			for(var m in menu.items){
				if(parseInt(m) != m) continue;
				var elms = menu.items[m].getElement();
				for(var i in elms){
					if(parseInt(i) != i) continue;
					elm.appendChild(elms[i]);
				}
			}
		}
	},
	animateLeftMenuSizes: function(selected_index, resize){
		if(typeof(selected_index) == 'undefined' || selected_index == null) selected_index = UI.animateLeftMenuSizes.lastSelectedIndex;
		if(typeof(selected_index) == 'undefined' || selected_index == null) selected_index = -1;
		if(typeof(resize) == 'undefined' || resize == null) resize = false;
		UI.animateLeftMenuSizes.lastSelectedIndex = selected_index;

		if(resize) {
			var ul = $("#uiLeftItems")[0];
			if(typeof(ul) == 'undefined') return;
			var longestText = 0;
			var scroll_padding = 0;

			var elmCompTitle = $('#uiLeftBarBackground > div.menu-left-company-title');

			var innerHeight = $('#uiLeftItems').height() + $('#uiLeftBarBackground > div.menu-left-company-title').height();
			if(innerHeight > $('#uiLeftBarBackground').height()){
				$('#uiLeftBarBackground').css('overflow-y', 'auto').css('overflow-x', 'hidden');
				scroll_padding = 24;
				if(typeof(elmCompTitle[0]) !== 'undefined' && elmCompTitle[0] !== null)
					elmCompTitle[0].animateLeftMenuSizesPadding = 2;
			}
			else{
				if(typeof(elmCompTitle[0]) == 'undefined' || elmCompTitle[0] === null || typeof(elmCompTitle[0].animateLeftMenuSizesPadding) == 'undefined' || elmCompTitle[0].animateLeftMenuSizesPadding != 14){
					$('#uiLeftBarBackground').css('overflow-y', 'hidden').css('overflow-x', 'hidden');
					if(typeof(elmCompTitle[0]) !== 'undefined' && elmCompTitle[0] !== null) {
						elmCompTitle[0].animateLeftMenuSizesPadding = 14;
					}
				}
			}

			$("#uiLeftItems > li .itemText").css('width', 'auto');
			$("#uiLeftItems > li .itemText").each(function(){
				var width = $(this).outerWidth() + 32 + 4;
				if(width > longestText) longestText = width;
			});

			//Update Menu Background Width
			var elm_back = $("#uiLeftBarBackground");
			elm_back[0]._width = longestText + scroll_padding;
			if(elm_back[0]._width < 128) elm_back[0]._width = 128;
			elm_back[0].parentNode._width = elm_back[0]._width + 20;
			if(UI.uiStyleLeftMenuBackgroundWidth != elm_back[0]._width || UI.uiStyleLeftMenuWidth != elm_back[0].parentNode._width){
				UI.uiStyleLeftMenuBackgroundWidth = elm_back[0]._width;
				UI.uiStyleLeftMenuWidth = elm_back[0].parentNode._width;
				if(!isMobile){
					document.documentElement.style.setProperty('--ui-style-left-menu-background-width', elm_back[0]._width+'px');
					document.documentElement.style.setProperty('--ui-style-left-menu-width', elm_back[0].parentNode._width+'px');
				}
			}
		}
	},
	flyOut: function(){

	},
	loadFromMainMenu: function(page, sender, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(page) == 'undefined') return;
		event.loadFromMainMenu_page = page;

		//Get Sender
		if(typeof(sender) == 'undefined' || !sender){
			sender = $('.menu-level-0[menu_link="'+page+'"]')[0];
		}

		//Prevent jquery-ui collapseAll() from triggering temp
		UI.jqUISuspendedEvents++;

		//Animations
		UI.hightLightTab($('#uiLeftItems > li.activateMenuItem'), true);
		UI.hightLightTab(sender);

		//Remember
		if(UI.loadFromMenuPageStack.length == 0 || UI.loadFromMenuPageStack[UI.loadFromMenuPageStack.length - 1] !== page){
			if(UI.loadFromMenuPageStack.length > 64) UI.loadFromMenuPageStack.shift();
			UI.loadFromMenuPageStack.push(page);
		}

		//Get Index
		var index = $(sender).index();
		var lastIndex = UI.loadFromMainMenu.lastIndex;
		UI.loadFromMainMenu.lastIndex = index;

		//Handle Link Action
		if(UI.mainMenuMode == 'main_index'){
			
			//Skip when already here...
			if(index == lastIndex) {
				UI.jqUISuspendedEvents--;
				return;
			}

			//Show or Hide the Top-left UI sub-search
			var searchContainer = UI.elmUISearchSettingsContainer();
			var showSearchBoxTopMenu = false;
			switch(page){
				case 'tools': case 'admin': case 'reports': showSearchBoxTopMenu = true; break;
			}
			if(showSearchBoxTopMenu){
				if(UI.menuType !== 'mdi'){
					if(searchContainer.is('.uiSearchSettings-Hidden') == true) searchContainer[0].classList.remove('uiSearchSettings-Hidden');
				}
			}
			else {
				if(searchContainer.is('.uiSearchSettings-Hidden') == false) searchContainer[0].classList.add('uiSearchSettings-Hidden');
			}

			//Init Vars
			if(typeof(UI.loadFromMenuCallUUID) == 'undefined') UI.loadFromMenuCallUUID = 0;
			UI.loadFromMenuCallUUID++;
			var myCallUUID = UI.loadFromMenuCallUUID;
			var animationTime = UI.footerLoadedFinished ? 400 : 0;
			var id            = 'main_index_page_'+page.toLowerCase();

			//Reset Scroll
			var section_view = $('#section_view');
			if(section_view.length != 0) section_view[0].scrollTop=0;

			//Clear Search Bar
			UI.clearSearch();

			//Highlight Selected Menu Item
			$('#uiLeftItems > li.activateMenuItem').each(function(){
				this.classList.remove('activateMenuItem');
			});
			sender.classList.add('activateMenuItem');
			//Fix to require chrome to rerender the page, as it seems to not always render the final frame of the iframe parent's transition animation (causing blury text)
			sender.style.opacity = 0.999;
			setTimeout(function(){ sender.style.opacity = 1; }, 10);

			//Hide / Fly-out View Animation
			{
				var hideViews = $('.main_index_page_active, .frame-overlay-view');

				//Quick Hide
				if(!UI.footerLoadedFinished){
					hideViews.hide()
							.removeClass(lastIndex < index ? 'main_index_page_position_below' : 'main_index_page_position_above')
							.addClass(lastIndex < index ? 'main_index_page_position_above' : 'main_index_page_position_below')
							.addClass('main_index_page_inactive')
							.removeClass('main_index_page_preactive')
							.removeClass('main_index_page_active');
					UI.jqUISuspendedEvents--;
				}

				//Animated Hide
				else {
					hideViews.addClass('is-in-animation');
					//After Animation
					var funcAfterHide = function(){
						UI.jqUISuspendedEvents--;
						hideViews.each(function(){
							var hiddenFrameView = $(this).children('iframe.frame-view');
							UI.onViewHide(hiddenFrameView);
							hiddenFrameView.uiLastViewWidth = hiddenFrameView.offsetWidth;
						});
						if(myCallUUID !== UI.loadFromMenuCallUUID) return;
						hideViews.removeClass('is-in-animation').hide();
						$('.main_index_page:not(.main_index_page_active)').addClass('main_index_page_inactive');
						if(UI.autoHide_FullFrameOverlayView) $('.frame-overlay-view').remove();
					};
					var setTimeoutHide = !bindTransitionEndEvent(hideViews, function(){ setTimeout(funcAfterHide, 1); }, true);
					//Start Flyout
					if(hideViews.length > 0){
						hideViews[0].classList.add('animate');
						hideViews[0].classList.remove(lastIndex < index ? 'main_index_page_position_below' : 'main_index_page_position_above');
						hideViews[0].classList.add(lastIndex < index ? 'main_index_page_position_above' : 'main_index_page_position_below');
						hideViews[0].classList.remove('main_index_page_active');
						hideViews[0].classList.remove('main_index_page_preactive');
						hideViews.css('user-select', 'none');
					}
					//After Animation (timer based, transitionend not supported by browser)
					if(setTimeoutHide) setTimeout(funcAfterHide, animationTime);
				}
			}

			//Show / Fly-in View Animation
			{

				var showView = $('#'+id);
				showView.addClass('is-in-animation').addClass('main_index_page_preactive');
				var shownFrameView = showView.children('iframe.frame-view');
				shownFrameView.css('filter', 'blur(0.001)');//Fix to require chrome to rerender the page

				var flaggedActiveOnce = false;
				var funcFlagViewAsActive = function(){
					if(myCallUUID !== UI.loadFromMenuCallUUID) return;
					if(!flaggedActiveOnce){
						flaggedActiveOnce = true;
						showView.removeClass('main_index_page_preactive')
						if(showView.length > 0) showView[0].classList.add('main_index_page_active');
						UI.refreshTopTitle();
					}
				};

				//After Animation
				var ranOnce = false;
				var funcAfterFlyInAnimation = function funcAfterFlyInAnimation(){
					if(myCallUUID !== UI.loadFromMenuCallUUID || ranOnce) return;
					ranOnce = true;
					funcFlagViewAsActive();
					setTimeout(function(){
						if(myCallUUID !== UI.loadFromMenuCallUUID) return;
						if(UI.mouseConfirmed && UI.elmUISearchSettings().is(':focus') == false) UI.elmUISearchSettings()[0].focus();
					}, 200);
					if(showView.length > 0){
						showView.css('user-select', '');
						showView[0].classList.remove('main_index_page_inactive')
					}
					//Trigger OnView Event
					UI.onViewShown(shownFrameView, null, event, sender);
					setTimeout(function(){
						if(myCallUUID !== UI.loadFromMenuCallUUID) return;
						//UI.setTextHelp('');
						UI.refreshTopTitle();
					}, 201);
					var iframe_view = $('#'+id+' > .frame-view');
					if(iframe_view.length > 0) UI.viewShown(iframe_view[0]);
					//Resize View
					if(shownFrameView.length > 0){
						var w = shownFrameView[0].offsetWidth;
						if(UI.lastViewWidth != w){
							shownFrameView[0].uiLastViewWidth = w;
							UI.resize();
						}
					}
					//invalidateTab of new sub-page
					showView.find('.tabsView').each(function(){
						var instanceVarName = $(this).attr('tabsViewInstance');
						if(instanceVarName && typeof(window[instanceVarName]) != 'undefined'){
							var instance = window[instanceVarName];
							instance.invalidateTab(event);
						}
					});
					//Ensure no animations failed to end
					setTimeout(function(){
						if(myCallUUID !== UI.loadFromMenuCallUUID) return;
						var e = $('.main_index_page.animate:not(.main_index_page_active)');
						if(e.length > 0){
							e[0].classList.remove('animate')
							e.hide();
						}
					}, 100);
					
					//Fix to require chrome to rerender the page, as it seems to not always render the final frame of the iframe parent's transition animation (causing blury text)
					if(typeof(window.UI.afterFlyInAnimationReqAnimationFrameUUID) !== 'undefined' && window.UI.afterFlyInAnimationReqAnimationFrameUUID !== null){
						cancelAnimationFrame(window.UI.afterFlyInAnimationReqAnimationFrameUUID);
						window.UI.afterFlyInAnimationReqAnimationFrameUUID = null;
					}
					var waitXFrames = 8;
					var funcReqAnimationFrame = function(){
						if(waitXFrames <= 0){
							//Correct the opacity
							shownFrameView.css('filter', 'blur(0px)');//Fix to require chrome to rerender the page
							//End the frame listener
							cancelAnimationFrame(window.UI.afterFlyInAnimationReqAnimationFrameUUID);
							window.UI.afterFlyInAnimationReqAnimationFrameUUID = null;
						}
						else {
							waitXFrames--;
							window.UI.afterFlyInAnimationReqAnimationFrameUUID = window.requestAnimationFrame(funcReqAnimationFrame)
						}
					};
					window.UI.afterFlyInAnimationReqAnimationFrameUUID = window.requestAnimationFrame(funcReqAnimationFrame);

				};
				var setTimeoutShow = !bindTransitionEndEvent(showView, function(){ setTimeout(funcAfterFlyInAnimation, 10); }, true);

				//Start Fly-In
				if(showView.length > 0){
					showView[0].classList.remove('animate', 'main_index_page_active', lastIndex < index ? 'main_index_page_position_above' : 'main_index_page_position_below');
					showView[0].classList.add(lastIndex < index ? 'main_index_page_position_below' : 'main_index_page_position_above', 'animate');
					showView.css('user-select', 'none');
					showView.show();
				}

				//Append the `main_index_page_active` class
				setTimeout(function(){
					funcFlagViewAsActive();
					//After Animation (timer based, transitionend not supported by browser)
					if(setTimeoutShow) setTimeout(funcAfterFlyInAnimation, animationTime + 11);
				}, 1);
			}

		}
		else {
			setTimeout(function(){ UI.load(CI_BASE_URL+'main/index?&menu_page='+page); UI.jqUISuspendedEvents--; }, UI.flyOut() ? UI.flyOutTime : 0);
		}
	},
	refreshTopTitle: function(){
		var activeLeftTab = $('#uiLeftItems > li.activateMenuItem > div > .itemText > div');
		if(activeLeftTab.length > 1){
			UI.texttitle($(activeLeftTab[0]).text(), $(activeLeftTab[1]).text());
		}
		else{
			UI.texttitle($('#uiLeftItems > li.activateMenuItem > div > .itemText').text());
		}
	},
	loadFromTaskBar: function(sender){
		//Not a tabbed taskbar
		var taskBar = sender.matches('.uiTaskBarButton_sub') ? sender.parentElement.parentElement.parentElement.parentElement : sender.parentElement;
		if(!taskBar.matches('.uiTaskBarShowOnlyInTabs')) return UI.load(sender);
		if(sender.matches('.uiTaskBarButton_sub')){
			$(sender.parentElement).css('visibility', 'hidden');
			setTimeout(function(){ $(sender.parentElement).css('visibility', 'visible'); }, 100);
		}
		var text = $(sender).attr('title');
		if(!text) text = "";
		if(text == "")
			$(sender).contents().filter(function() { return this.nodeType === Node.TEXT_NODE; }).each(function(){
				var t = $(this).text().trim();
				if(t != ""){
					if(text != "") text += " ";
					text += t;
				}
			});
		var frame = UI.loadInternalTab(sender.href, text, sender);
	},
	open: function(url, target, options, label, event, sender){/*replacment for window.open when it should default to an internal tab*/
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(top.UI.mainMenu == null){
			event.href = url;
			event.openParams = {href: url, target: target, options: options, label: label};
			window.np_analytics.event('UI.open', event, '', sender);
			return window.open(url, target, options);
		}
		else{
			return top.UI.loadInternalTab(url, label);
		}
	},
	loadPost: function(url, post_data, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		//Set URL as tmpl=iframe
		if(!url.match(/(&|\?)tmpl=/i)) url += (url.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe';
		//Create POST Form With Data
		var tmpForm = $('<form>').attr('action', url).attr('method', 'POST')
		for(var i in post_data){
			var data = post_data[i];
			if(Array.isArray(data)){
				for(var x in data){
					$('<input type="hidden">').attr('value', data[x]).attr('name', i+'[]').appendTo(tmpForm);
				}
			}
			else{
				$('<input type="hidden">').attr('value', post_data[i]).attr('name', i).appendTo(tmpForm);
			}
		}
		$('body').append(tmpForm);
		//Add Download Tracking
		if(url.match(/[\?&]trackdownload=1/)){
			tmpForm.attr('trackdownload', '1');
			UI.processView_FormTrackDownload();
			top.UI.processView_FormTrackDownload();
		}
		event.href = url;
		event.form = $(tmpForm)[0];
		window.np_analytics.event('UI.loadPost', event, '', typeof(sender) !== 'object' || sender === null ? $(tmpForm)[0] : sender);
		//Submit Form
		$(tmpForm)[0].submit();
	},
	openPost: function(url, post_data, label, options, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		target = "openPost_"+get_uuid();
		var frameOrWindow = UI.open('blank.php?no_home=true', target, options, label);
		var isFrame = frameOrWindow instanceof Window ? false : true;
		if(isFrame) $(frameOrWindow).attr('name', target);
		var tmpForm = $('<form>').attr('action', url).attr('target', target).attr('method', 'POST')
		for(var i in post_data){
			var data = post_data[i];
			if(Array.isArray(data)){
				for(var x in data){
					$('<input type="hidden">').attr('value', data[x]).attr('name', i+'[]').appendTo(tmpForm);
				}
			}
			else{
				$('<input type="hidden">').attr('value', post_data[i]).attr('name', i).appendTo(tmpForm);
			}
		}
		top.$('body').append(tmpForm);
		if(url.match(/[\?&]trackdownload=1/)){
			tmpForm.attr('trackdownload', '1');
			UI.processView_FormTrackDownload();
			top.UI.processView_FormTrackDownload();
		}
		event.href = url;
		event.form = $(tmpForm)[0];
		window.np_analytics.event('UI.openPost', event, '', typeof(sender) !== 'object' || sender === null ? $(tmpForm)[0] : sender);
		$(tmpForm)[0].submit();
		tmpForm.remove();
	},
	openHidden: function(url, params, method, onLoadComplete, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(method) == 'undefined') method = 'POST';
		if(typeof(params) == 'undefined') params = null;
		if(typeof(onLoadComplete) == 'undefined') onLoadComplete = function(){};

		if($('#uiOpenHiddenFrame').length == 0) $('<iframe name="uiOpenHiddenFrame" id="uiOpenHiddenFrame" style="display: none;">').appendTo('body');
		var iframe = $('#uiOpenHiddenFrame')[0];

		if($('#uiOpenHiddenForm').length == 0) $('<form id="uiOpenHiddenForm" target="uiOpenHiddenFrame" style="display: none;">').appendTo('body');
		var form = $('#uiOpenHiddenForm');
		form.attr('method', method);
		form.attr('action', url);
		form.empty();

		var funcParamsToInput = null;
		funcParamsToInput = function(params, prefix){
			if(params && (typeof(params.length) != 'undefined' || params instanceof Object)){
				for(var i in params){
					if(params[i] instanceof Array || params[i] instanceof Object){
						funcParamsToInput(params[i], prefix == '' ? i : prefix + '[' + i + ']');
					}
					else {
						var name = prefix != '' ? prefix + '[' + i + ']' : i;
						$('<input type="hidden">').val(params[i]).attr('name', name).appendTo(form);
					}
				}
			}
		}
		funcParamsToInput(params, '');

		iframe.onLoadComplete = onLoadComplete;
		iframe.checkIframeLoaded = (function(){
			var iframeDoc = this.contentDocument || this.contentWindow.document;
			if (iframeDoc.readyState == 'complete') return this.onLoadComplete();
			window.setTimeout((this.checkIframeLoaded).bind(this), 100);
		}).bind(iframe);

		event.href = url;
		event.form = form[0];
		window.np_analytics.event('UI.openHidden', event, '', typeof(sender) !== 'object' || sender === null ? form[0] : sender);
		form[0].submit();
		iframe.checkIframeLoaded();
		return $('#uiOpenHiddenFrame')[0];
	},
	loadInternalTab: function(href, label, sender, dont_auto_open){
		if(top.UI.mainMenuMode != 'main_index') return UI.load($("<a></a>").attr('href', href).attr('target', '_blank'));
		if(window.isMobile) return UI.load($("<a></a>").attr('href', href));

		//Prepare
		if(typeof(sender) == 'undefined') sender = false;
		if(typeof(dont_auto_open) == 'undefined') dont_auto_open = false;
		if(typeof(UI.loadInternalTabIndex) == 'undefined') UI.loadInternalTabIndex = 0;
		if(typeof(window.CI_BASE_URL) == 'undefined') window.CI_BASE_URL = '!/index.php?/';

		//Set URL as tmpl=iframe
		if(!href.match(/(&|\?)tmpl=/i)) href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe';

		//Append View
		UI.loadInternalTabIndex++;
		var internal_frame_id = 'frame__iview_'+UI.loadInternalTabIndex;
		var page = 'internal_'+UI.loadInternalTabIndex;
		var view = $('<div id="main_index_page_'+page+'" class="main_index_page main_index_internal_tab"></div>');
		var frame = $('<iframe id="'+internal_frame_id+'" seemless="" class="frame-view" ui-auto-grow="0" style="display: inline;"><!DOCTYPE html><html><head></head><body></body></html></iframe>');
		if(UI.menuType === 'mdi'){
			view.addClass('mdi-window').attr('mdi-window-state', 'default');
			
			var ww = $(window).width();
			var w = Math.min(1040, ww);
			view.css('width', w+'px');

			var wh = $(window).height() - 64;
			var h = Math.min(700, wh);
			view.css('height', h+'px');

			if(typeof(UI.lastMDIWindowLeftOpen) === 'undefined') UI.lastMDIWindowLeftOpen = 24;
			var left = UI.lastMDIWindowLeftOpen;
			left += 64;
			if(ww < (w + left)) left = 24;
			UI.lastMDIWindowLeftOpen = left;
			view.css('left', left+'px');

			if(typeof(UI.lastMDIWindowTopOpen) === 'undefined') UI.lastMDIWindowTopOpen = 24;
			var _top = UI.lastMDIWindowTopOpen;
			_top += 24;
			if(wh < (h + _top)) _top = 24;
			UI.lastMDIWindowTopOpen = _top;
			view.css('top', _top+'px');

			view[0].restoreMdiWindowLeft = '0px';
			view[0].restoreMdiWindowTop = '0px';
			view[0].restoreMdiWindowWidth = '0px';
			view[0].restoreMdiWindowHeight = '0px';
			view[0].mdiWindowAnimationDepth = 0;
			view[0].bringToFront = (function(){
				if(!$(this).is('.mdi-window-active')){
					$('.mdi-window').addClass('mdi-window-inactive');
					$('.mdi-window-active').removeClass('mdi-window-active');
					$(this).removeClass('mdi-window-inactive').addClass('mdi-window-active');
					var maxZIndex = 0;
					var elmZindexes = [];
					var _this = this;
					$('.mdi-window').each(function(){
						if(_this !== this){
							var z = $(this).css('z-index');
							if(typeof(z) !== 'undefined' && z !== null){
								z = parseInt(z);
								if(z > maxZIndex) maxZIndex = z;
							}
							else {
								z = 0;
							}
							elmZindexes.push({elm: this, z: z});
						}
					});
					$(this).css('z-index', maxZIndex + 1);
					elmZindexes.push({elm: this, z: maxZIndex + 1});
					elmZindexes.sort(function(a, b){ return a.z - b.z; });
					var z = 1;
					for(var i in elmZindexes){
						$(elmZindexes[i].elm).css('z-index', z++);
					}
				}
			}).bind(view[0]);
			view[0].maximizeWindow = (function(){
				$(this).find('.mdi-window-title > .mdi-window-title-window-minimize').show();
				if($(this).attr('mdi-window-state') == 'default'){
					this.restoreMdiWindowLeft = $(this).css('left');
					this.restoreMdiWindowTop = $(this).css('top');
					this.restoreMdiWindowWidth = $(this).css('width');
					this.restoreMdiWindowHeight = $(this).css('height');
				}
				$(this).find('.mdi-window-title > .mdi-window-title-window-maximize').html('<i class="far fa-window-restore"></i>');
				$(this).attr('mdi-window-state', 'max');
				$(this).addClass('mdi-window-animated');
				this.mdiWindowAnimationDepth++;
				$(this).css('left', '0px');
				$(this).css('top', '0px');
				$(this).css('width', $(window).width()+'px');
				$(this).css('height', ($(window).height() - $('#uiTopBar').height()) + 'px');
				setTimeout((function(){ this.mdiWindowAnimationDepth--; if(this.mdiWindowAnimationDepth <= 0) $(this).removeClass('mdi-window-animated'); }).bind(this), 120);
			}).bind(view[0]);
			view[0].restoreWindow = (function(){
				$(this).find('.mdi-window-title > .mdi-window-title-window-minimize').show();
				$(this).find('.mdi-window-title > .mdi-window-title-window-maximize').html('<i class="far fa-window-maximize"></i>');
				$(this).attr('mdi-window-state', 'default');
				$(this).addClass('mdi-window-animated');
				this.mdiWindowAnimationDepth++;
				if(typeof(this.restoreMdiWindowLeft) !== 'undefined') $(this).css('left', this.restoreMdiWindowLeft);
				if(typeof(this.restoreMdiWindowTop) !== 'undefined') $(this).css('top', this.restoreMdiWindowTop);
				if(typeof(this.restoreMdiWindowWidth) !== 'undefined' && this.restoreMdiWindowWidth != '0px') $(this).css('width', this.restoreMdiWindowWidth);
				if(typeof(this.restoreMdiWindowHeight) !== 'undefined' && this.restoreMdiWindowHeight != '0px') $(this).css('height', this.restoreMdiWindowHeight);
				setTimeout((function(){ this.mdiWindowAnimationDepth--; if(this.mdiWindowAnimationDepth <= 0) $(this).removeClass('mdi-window-animated'); }).bind(this), 120);
			}).bind(view[0]);
			view[0].minimizeWindow = (function(){
				$(this).find('.mdi-window-title > .mdi-window-title-window-maximize').html('<i class="far fa-window-restore"></i>');
				$(this).find('.mdi-window-title > .mdi-window-title-window-minimize').hide();
				if($(this).attr('mdi-window-state') == 'default'){
					this.restoreMdiWindowLeft = $(this).css('left');
					this.restoreMdiWindowTop = $(this).css('top');
					this.restoreMdiWindowWidth = $(this).css('width');
					this.restoreMdiWindowHeight = $(this).css('height');
				}
				$(this).attr('mdi-window-state', 'min');
				$(this).addClass('mdi-window-animated');
				this.mdiWindowAnimationDepth++;
				var titleHeight = 32;
				var titleNewWidth = 300;
				var tilePaddingX = 4;
				var tilePaddingY = 4;
				var x = tilePaddingX;
				var y = top.$('.main_index_page_container').height() - (titleHeight + tilePaddingY);
				var maxX = top.$('.main_index_page_container').width() - (titleNewWidth + tilePaddingX);
				$(this).css('left', x + 'px').css('top', y + 'px').css('height', titleHeight + 'px').css('width', titleNewWidth + 'px');
				var _this = this;
				var colElms = top.$('.main_index_page_container').children('.mdi-window[mdi-window-state="min"]').filter(function(){ return _this != this; });
				var fnFindCollision = function(x, y, w, h){
					var x2 = x + w;

					var y2 = y + h;
					//Check for collision
					var found = false;
					colElms.each(function(){
						var _x =$(this).css('left').replace(/px$/, '');
						var _y = $(this).css('top').replace(/px$/, '');
						var _x2 = $(this).width() + _x;
						var _y2 = $(this).height() + _y;
						if(x <= _x2 && x2 >= _x){
							if(y <= _y2 && y2 >= _y){
								found = this;
							}
						}
					});
					return found;
				};
				for(i = 0; i < 999; i++){
					var colElm = fnFindCollision(x, y, titleNewWidth, titleHeight);
					if(colElm === false) break;
					var pos = $(colElm).position();
					x = pos.left + titleNewWidth + tilePaddingX;
					if(x > maxX){
						x = tilePaddingX;
						y -= (titleHeight + tilePaddingY);
					}
				}
				$(this).css('left', x + 'px').css('top', y + 'px');
				setTimeout((function(){ this.mdiWindowAnimationDepth--; if(this.mdiWindowAnimationDepth <= 0) $(this).removeClass('mdi-window-animated'); }).bind(this), 120);
			}).bind(view[0]);
			view.on('mousedown', (function(){
				this.bringToFront();
			}).bind(view[0]));
			var mdiTitleBar = $('<div class="mdi-window-title">');
			var mdiTitleBarTitle = $('<span class="mdi-window-title-text">');
			var mdiTitleBarClose = $('<span class="mdi-window-title-close" style="font-weight: bold; font-family: monospace; font-size: 19px;">').text('X');
			var mdiTitleBarWinMax = $('<span class="mdi-window-title-window-maximize">').html('<i class="far fa-window-maximize"></i>');
			var mdiTitleBarWinMin = $('<span class="mdi-window-title-window-restore">').html('<i class="far fa-window-minimize"></i>');
			mdiTitleBarTitle.appendTo(mdiTitleBar);
			mdiTitleBarClose.appendTo(mdiTitleBar);
			mdiTitleBarClose.on('click', (function(){
				window.top.UI.mainMenu.removeItem(page);
				window.top.$('#'+internal_frame_id).remove();
				window.top.$('#main_index_page_'+page).remove();
				window.top.UI.resize();
				window.top.UI.showLastInternalPage();
			}).bind(frame[0]));
			mdiTitleBar.on('mousedown', function(e){
				window.mdiWindowMouseDragActive = true;
				window.mdiWindowMouseDragTarget = view;
				window.mdiWindowMouseDragTarget.find('.mdi-window-border-dragging-overlay').css('display', 'block');
				window.mdiWindowMouseResizeMouseStartX = e.clientX;
				window.mdiWindowMouseResizeMouseStartY = e.clientY;
				window.mdiWindowMouseResizeWindowStartX = view.offset().left - $('#content').offset().left;
				window.mdiWindowMouseResizeWindowStartY = view.offset().top - $('#content').offset().top;
				window.mdiWindowMouseResizeMinTop = 0;
				window.mdiWindowMouseResizeMaxTop = $(window).height() - ($('#uiTopBar').height() + 34);
				window.mdiWindowMouseResizeMaxLeft = $(window).width() - 250;
			});
			mdiTitleBar.appendTo(view);
			mdiTitleBarWinMax.appendTo(mdiTitleBar);
			mdiTitleBarWinMax.on('click', (function(){
				if($(this).attr('mdi-window-state') == 'max' || $(this).attr('mdi-window-state') == 'min'){
					this.restoreWindow();
				}
				else {
					this.maximizeWindow();
				}
			}).bind(view[0]));
			mdiTitleBarWinMin.appendTo(mdiTitleBar);
			mdiTitleBarWinMin.on('click', (function(){
				if($(this).attr('mdi-window-state') == 'min'){
					this.restoreWindow();
				}
				else {
					this.minimizeWindow();
				}
			}).bind(view[0]));
			mdiTitleBarTitle.on('dblclick', (function(){
				if($(this).attr('mdi-window-state') == 'max' || $(this).attr('mdi-window-state') == 'min'){
					this.restoreWindow();
				}
				else {
					this.maximizeWindow();
				}
			}).bind(view[0]));

			var mdiBorderDraggingOverlay = $('<div class="mdi-window-border-dragging-overlay">').appendTo(view);
			var mdiBorderTopLeft = $('<div class="mdi-window-border mdi-window-border-top-left" resize-top resize-left>');
			var mdiBorderTopRight = $('<div class="mdi-window-border mdi-window-border-top-right" resize-top resize-right>');
			var mdiBorderBottomLeft = $('<div class="mdi-window-border mdi-window-border-bottom-left" resize-bottom resize-left>');
			var mdiBorderBottomRight = $('<div class="mdi-window-border mdi-window-border-bottom-right" resize-bottom resize-right>');
			var mdiBorderTop = $('<div class="mdi-window-border mdi-window-border-top" resize-top>');
			var mdiBorderBottom = $('<div class="mdi-window-border mdi-window-border-bottom" resize-bottom>');
			var mdiBorderLeft = $('<div class="mdi-window-border mdi-window-border-left" resize-left>');
			var mdiBorderRight = $('<div class="mdi-window-border mdi-window-border-right" resize-right>');
			var mdiBorderElms = [mdiBorderTopLeft, mdiBorderTopRight, mdiBorderBottomLeft, mdiBorderBottomRight, mdiBorderTop, mdiBorderBottom, mdiBorderLeft, mdiBorderRight];
			for(var i in mdiBorderElms) {
				mdiBorderElms[i].appendTo(view)
					.on('mousedown', function(e){
						if(view.attr('mdi-window-state') !== 'default') return;
						window.mdiWindowMouseDragTarget = view;
						window.mdiWindowMouseDragTarget.find('.mdi-window-border-dragging-overlay').css('display', 'block');
						window.mdiWindowMouseResizeActive = true;
						window.mdiWindowMouseResizeMinTop = $('#uiMDIMenuBar').height() + 1;
						window.mdiWindowMouseResizeMaxTop = $(window).height() - (window.mdiWindowMouseResizeMinTop + 42);
						window.mdiWindowMouseResizeMaxLeft = $(window).width() - 250;
						window.mdiWindowMouseResizeMouseStartX = e.clientX;
						window.mdiWindowMouseResizeMouseStartY = e.clientY;
						window.mdiWindowMouseResizeWindowStartX = view.offset().left - $('#content').offset().left;
						window.mdiWindowMouseResizeWindowStartY = view.offset().top - $('#content').offset().top;
						window.mdiWindowMouseResizeWindowStartW = view.width();
						window.mdiWindowMouseResizeWindowStartH = view.height();
						window.mdiWindowMouseDragTarget.resizeType = {
							top: $(this).is('[resize-top]'),
							bottom: $(this).is('[resize-bottom]'),
							left: $(this).is('[resize-left]'),
							right: $(this).is('[resize-right]'),
						};
					})
			}

			if(typeof(window.fnMdiWindowMouseMove) === 'undefined'){
				window.mdiWindowMouseDragActive = false;
				window.mdiWindowMouseDragTarget = null;
				window.mdiWindowMouseResizeActive = false;
				window.mdiWindowMouseDragTarget = null;
				window.mdiWindowMouseResizeMouseStartX = null;
				window.mdiWindowMouseResizeMouseStartY = null;
				window.mdiWindowMouseResizeWindowStartX = null;
				window.mdiWindowMouseResizeWindowStartY = null;
				window.mdiWindowMouseResizeWindowStartW = null;
				window.mdiWindowMouseResizeWindowStartH = null;
				window.mdiWindowMouseResizeMaxTop = 99999;
				window.mdiWindowMouseResizeMaxLeft = 99999;
				window.fnMdiWindowMouseMove = function(e){
					if(window.mdiWindowMouseDragTarget === null) return;
					if(window.mdiWindowMouseResizeActive) {
						if(e.clientX < 0) e.clientX = 0;
						if(e.clientY < 0) e.clientY = 0;
						var x = e.clientX - window.mdiWindowMouseResizeMouseStartX;
						var y = e.clientY - window.mdiWindowMouseResizeMouseStartY;
						var resizeType = window.mdiWindowMouseDragTarget.resizeType;
						if(resizeType.right) window.mdiWindowMouseDragTarget.css('width', Math.max(250, x + window.mdiWindowMouseResizeWindowStartW));
						if(resizeType.bottom) window.mdiWindowMouseDragTarget.css('height', Math.max(100, y + window.mdiWindowMouseResizeWindowStartH));
						if(resizeType.left) {
							window.mdiWindowMouseDragTarget
								.css('left', Math.max(0, x + window.mdiWindowMouseResizeWindowStartX))
								.css('width', Math.max(250, window.mdiWindowMouseResizeWindowStartW - x))
						}
						if(resizeType.top) {
							window.mdiWindowMouseDragTarget
								.css('top', Math.min(window.mdiWindowMouseResizeMaxTop, Math.max(window.mdiWindowMouseResizeMinTop, y + window.mdiWindowMouseResizeWindowStartY)))
								.css('height', Math.max(100, window.mdiWindowMouseResizeWindowStartH - y))
						}
					}
					else if(mdiWindowMouseDragActive){
						var x = e.clientX - window.mdiWindowMouseResizeMouseStartX;
						var y = e.clientY - window.mdiWindowMouseResizeMouseStartY;
						window.mdiWindowMouseDragTarget
							.css('top', Math.min(window.mdiWindowMouseResizeMaxTop, Math.max(window.mdiWindowMouseResizeMinTop, y + window.mdiWindowMouseResizeWindowStartY)))
							.css('left', Math.min(window.mdiWindowMouseResizeMaxLeft, Math.max(0, x + window.mdiWindowMouseResizeWindowStartX)));
					}
				};
				$(window).on('mousemove', window.fnMdiWindowMouseMove);
				$(window).on('mouseup', function(){
					if(window.mdiWindowMouseResizeActive) {
						$('.mdi-window-border-dragging-overlay').css('display', '');
						window.mdiWindowMouseDragTarget = null;
						window.mdiWindowMouseResizeActive = false;
					}
					else if(window.mdiWindowMouseDragActive) {
						$('.mdi-window-border-dragging-overlay').css('display', '');
						window.mdiWindowMouseDragTarget = null;
						window.mdiWindowMouseDragActive = false;
					}
				});
			}

			frame[0].titleElm = mdiTitleBarTitle;
			frame.appendTo(view);
		}
		else {
			frame.appendTo(view);
		}
		view.appendTo('#section_view > .main_index_page_container');
		if(UI.menuType === 'mdi') view[0].bringToFront();

		//Frame Load/Unload Events
		frame[0].parentUI = UI;
		frame[0].contentWindow.uiScriptLoadedOnce = false;
		frame[0].autoAppendFramePageButtons = (function(){

			//Find Parent UI
			var targetUI = null;
			try {
				if(typeof(this.contentWindow) === 'undefined' || this.contentWindow === null || typeof(this.contentWindow.UI) == 'undefined') return;
				this.contentWindow.internal_frame_id = this.internal_frame_id;
				targetUI = this.contentWindow.UI;
			}
			catch (e) { }
			if(targetUI == null) return;


			//Check for existing close & refresh buttons
			var hasRefresh = false;
			var TaskBar = this.contentWindow.$('#content > .uiTaskBarContainer > .uiTaskBarBackground > .uiTaskBar');
			TaskBar.attr('ui-menu-type', window.top.UI.menuType);
			TaskBar.children('.uiTaskBarButton').each(function(){
				var txt = $(this).text();
				if(txt == window.STR_CLOSE || txt == window.STR_CLOSE_WINDOW) $(this).remove();
				else if(txt == window.STR_REFRESH) hasRefresh = true;
			});

			//Run once
			if(TaskBar.is('.uiTaskBarButton-AutoAppendPageButtons')) return;
			TaskBar.addClass('uiTaskBarButton-AutoAppendPageButtons');

			//Append Close to frame
			if(window.top.UI.menuType !== 'mdi'){
				targetUI.addTaskbarItem(window.STR_CLOSE, 'images/closewindow.png', internal_frame_id, page, function(event){
					var id = $(this).attr('frame_id');
					var page = $(this).attr('internal_page');
					window.top.UI.mainMenu.removeItem(page);
					window.top.$('#'+id).remove();
					if(window.top.UI.menuType === 'mdi') window.top.$('#main_index_page_'+page).remove();
					window.top.UI.resize();
					window.top.UI.showLastInternalPage();
				}, true);
			}
			
			//Append Refresh to frame
			if(!hasRefresh){
				targetUI.addTaskbarItem(window.STR_REFRESH, '<i class="fas fa-sync"></i>', null, null, (function(event){
					this.contentWindow.location.reload();
				}).bind(this), true);
			}

			//Trigger TaskBar UI event after changes to DOM
			targetUI.onWindowResize_UpdateUITaskBar();
		}).bind(frame[0]);
		frame[0].uiScriptLoadedInner = (function(){

			//Run Only Once
			if(this.contentWindow === null || (typeof(this.contentWindow.uiScriptLoadedOnce) != 'undefined' && this.contentWindow.uiScriptLoadedOnce)) return;
			this.contentWindow.uiScriptLoadedOnce = true;

			//Show load complete UI
			this.parentUI.setFrameContentsAsNotLoading(this);

			this.autoAppendFramePageButtons();
		}).bind(frame[0]);
		frame[0].uiScriptLoaded = (function(){
			try {
				//Wait until window is not-missing
				if(this.contentDocument === null){
					setTimeout((function(){ this.uiScriptLoaded(); }).bind(this), 10);
					return;
				}
				//Trigger once dom content is loaded
				if(this.contentDocument.readyState == 'loading'){
					//
					this.contentDocument.addEventListener('DOMContentLoaded', (function(){ this.uiScriptLoadedInner(); }).bind(this));
					//Trigger-fallback
					setTimeout((function(){ this.uiScriptLoadedInner(); }).bind(this),  200);
				}
				else if(this.contentDocument.readyState == 'complete'){
					this.uiScriptLoadedInner();
				}
			}
			catch (err) {
				setTimeout((function(){ this.uiScriptLoaded(); }).bind(this), 10);
				return;
			}
		}).bind(frame[0]);

		$(frame).load((function(){
			this.uiScriptLoaded();
			//Set Hook for next unload (to show as loading)
			if(this.contentWindow != null){
				try {
					 /* !!! Uncaught SecurityError: Blocked a frame with origin "NP_BASE_URL" from accessing a cross-origin frame. !!! */
					this.contentWindow.onunload = (function(){
						if(this.contentWindow != null) this.contentWindow.uiScriptLoadedOnce = false;
						this.parentUI.setFrameContentsAsLoading(this);
					}).bind(this);
				}
				catch(err){ }
			}
		}).bind(frame[0]));

		//Track Download?
		var trackDownload = false;
		if(href.match(/(fpdf|fileopen)\.php/))
			href += href.indexOf('?') != -1 ? '&trackdownload=1' : '?trackdownload=1';
		else if(href.match(/!\/index\.php\?\/+[^\/]+\/[^\/]*pdf\//i) || href.match(/!\/index\.php\?\/+[^\/]+\/pdf[^\/]*\//i))
			href += href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&trackdownload=1' : '&trackdownload=1';
		if(href.match(/[\?&]trackdownload=1/)){
			//Append tracking ID
			frame[0].processView_FormTrackDownload_uuid = get_uuid();
			frame[0].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
			href += '&form_track_download_uuid='+frame[0].processView_FormTrackDownload_uuid;
			trackDownload = true;
		}

		//Append Menu Item
		if(UI.mainMenu != null){
			if(label == null || label == '' || label == false) label = window.STR_LOADING+'...';
			var item = new MenuItem(label, 'internal_tab imgIcon32 imgGeneral __'+internal_frame_id, page);
			item.internal_frame_id = UI.loadInternalTabIndex;
			UI.mainMenu.addItem(item);
			if(!dont_auto_open) $('#uiLeftItems li:last').click();
			frame[0].menu_item = item;
		}
		frame[0].internal_frame_id = item.internal_frame_id;
		frame[0].setTitle = (function(title, subtitle){
			if(typeof(title) == 'undefined' || title == null) title = frame[0].uiFrameTitle;
			if(typeof(subtitle) == 'undefined' || subtitle == null) title = frame[0].uiFrameSubTitle;
			frame[0].uiFrameTitle = title;
			frame[0].uiFrameSubTitle = subtitle;
			for(var i in UI.mainMenu.items){
				if(UI.mainMenu.items[i].link == 'internal_'+this.internal_frame_id){
					UI.mainMenu.items[i].text = title;
					UI.mainMenu.items[i].subTitle = subtitle;
				}
			}
			var htmlTitle = UI.MenuItemGetTabTitleHtml(title, subtitle);
			$('#uiLeftItems li[menu_link="internal_'+this.internal_frame_id+'"] .itemText').html(htmlTitle);
			if(UI.menuType == 'mdi'){
				this.titleElm.html(htmlTitle);
				$('.mdi-menu-level-0-open-windows [mdi-window-id="main_index_page_internal_'+this.internal_frame_id+'"] > .mdi-menu-level-title').html(htmlTitle);
			}
			top.UI.resize();
		}).bind(frame[0]);

		if(typeof(frame[0].uiFrameTitle) != 'undefined') frame[0].setTitle();
		UI.setFrameContentsAsLoading(frame);

		if(trackDownload){
			frame[0].processView_FormTrackDownload_IsComplete = false;
			frame[0].processView_FormTrackDownload_functionCheckIsComplete = (function(){
				var url = NP_BASE_URL+'frmDownloadProgress.php?v='+IMAGE_UPLOAD_DIR.replace(/[\\\/ ]+$/, '').replace(/[\\\/ ]+/, '')+'&uuid='+frame[0].processView_FormTrackDownload_uuid
				$.fetch(url,
					function(r){
						//Success, file found
						frame[0].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();

						//Complete
						if(r != '0'){
							var setTitle = null;
							var setSubTitle = null;
							if(r != '1'){
								var lines = r.split("\n");
								setTitle = typeof(lines[0]) == 'undefined' ? null : lines[0];
								setSubTitle = typeof(lines[1]) == 'undefined' ? null : lines[1];
							}
							frame[0].processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(frame[0], setTitle, setSubTitle);
						}
					},
					function(){
						//Timeout, never found the tracking file...
						if((new Date()).getTime() - frame[0].processView_FormTrackDownload_lastSuccess > 8000 /*8s*/){
							frame[0].processView_FormTrackDownload_IsComplete = true;
							top.UI.setFrameContentsAsNotLoading(frame[0]);
						}

						//Try again...
						else if(!frame[0].processView_FormTrackDownload_IsComplete){
							setTimeout(frame[0].processView_FormTrackDownload_functionCheckIsComplete, 1000);
						}
					});
			});
			frame[0].processView_FormTrackDownload_functionCheckIsComplete();
		}

		frame.attr('src', href);
		frame.attr('name', internal_frame_id);

		return frame[0];
	},
	loadBrowserTab: function(href, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		event.href = href;
		window.np_analytics.event('UI.loadBrowserTab', event, '', sender);
		return window.open(href, '_blank');
	},
	closeInternalTab: function(internal_frame_id, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var page = 'internal_'+internal_frame_id;
		var li = $('#main_index_page_'+page);
		event.internal_frame_id = internal_frame_id;
		event.page = page;
		event.menuitem = li;
		window.np_analytics.event('UI.closeInternalTab', event, 'left-menu', typeof(sender) !== 'object' || sender === null ? li[0] : sender);
		UI.mainMenu.removeItem(page);
		li.remove();
		UI.showLastInternalPage();
	},
	showLastInternalPage: function(event){
		if(typeof(event) !== 'object' || event === null) event = {};
		while(UI.loadFromMenuPageStack.length > 0){
			var page = UI.loadFromMenuPageStack.pop();
			var sender = $('.menu-level-0[menu_link="'+page+'"]');
			if(sender.length == 0 || typeof(sender[0]) == 'undefined') continue;
			UI.loadFromMainMenu.lastIndex = -1;
			return UI.loadFromMainMenu(page, sender[0], event);
		}

		var defaultFirst = $('#uiLeftItems > li[menu_link]:visible');
		var page = defaultFirst.attr('menu_link');
		return UI.loadFromMainMenu(page, typeof(sender) == 'undefined' || typeof(sender[0]) == 'undefined' ? false : sender[0], event);

	},
	setFrameContentsAsLoading: function(frame){

		//Show Menu Item As Loading
		var _frame = (typeof(frame[0]) != 'undefined') ? frame[0] : frame;
		if(typeof(_frame) != 'undefined' && typeof(_frame.menu_item) != 'undefined'){
			$('#uiLeftItems [menu_link="'+_frame.menu_item.link+'"]').addClass('menu_item_loading');
		}

		var baseHref = $('base').attr('href');

		var menuElm = top.$('#uiTopBar')[0];
		var compstyle = typeof(menuElm) != 'undefined' ? getComputedStyle(menuElm) : null;
		var str = typeof(compstyle) != 'undefined' && compstyle != null ? compstyle.backgroundImage : '';
		var matches = str.match(/rgba?\([^\)]*\)/ig);
		if(typeof(matches) == 'undefined' || matches == null) matches = [];
		var color  = (typeof(matches[1]) != 'undefined') ? matches[1] : '#CCCCCC';
		var colorB = (typeof(matches[0]) != 'undefined') ? matches[0] : '#FFFFFF';

		var head = '';
		head += '<style>';
		head += '* { box-sizing: border-box; } ';
		head += '.main { opacity: 0.5; }';
		head += '.small2 {   position: absolute;   height: 100px;   width: 100px;   background-color: transparent;   top: 50vh;   left: 50%;   transform: translate(-50%, -50%); } ';
		head += '.small1 {   position: absolute;   height: 100px;   width: 100px;   top: 50vh;   left: 50%;   transform-origin: center;   transform: translate(-50%, -50%) rotate(45deg);   background-color: transparent; }';
		head += '.bigcon {   position: absolute;   height: 95px;   width: 95px;     top: 50vh;   left: 50%;   transform-origin: center;   transform: translate(-50%, -50%) rotate(-45deg);   background-color: transparent;   animation: bigcon 2s infinite linear;   animation-delay: 0.25s; }';
		head += '.ball {   border-radius: 50%;   position: absolute; }';
		head += '.small {   width: 25px;   height: 25px;   animation: small 2s infinite ease;   box-shadow: 0px 2px rgba(0,0,0,0.3); background-color: '+color+'; }';
		head += '.small:nth-child(1) {   top: 0%;   left: 0%; }';
		head += '.small:nth-child(2) {   top: 0%;   right: 0%; }';
		head += '.small:nth-child(3) {   right: 0%;   bottom: 0%; }';
		head += '.small:nth-child(4) {   bottom: 0%;   left: 0%; }';
		head += '.big {   width: 20px;   height: 20px;   border-radius: 15px;   box-shadow:0px 0px 10px '+colorB+', 0px 0px 20px '+colorB+', 0px 0px 30px '+colorB+', 0px 0px 50px '+colorB+', 0px 0px 60px '+colorB+' ;   z-index: 1;   background-color: '+colorB+';   animation: bigball 1s infinite linear; }';
		head += '.smallball1{   animation-delay: -1.75s; }';
		head += '.smallball6{   animation-delay: -1.5s; }';
		head += '.smallball2{   animation-delay: -1.25s; }';
		head += '.smallball7{   animation-delay: -1s; }';
		head += '.smallball3{   animation-delay: -0.75s; }';
		head += '.smallball8{   animation-delay: -0.5s; }';
		head += '.smallball4{   animation-delay: -0.25s; }';
		head += '.smallball5{   animation-delay: -0s; } ';
		head += '@keyframes bigcon {   0% {     transform-origin: center;     transform: translate(-50%, -50%) rotate(45deg);   }   100% {     transform-origin: center;     transform: translate(-50%, -50%) rotate(405deg);   } }';
		head += '@keyframes small {   0% {     transform: scale(1);      background-color: '+color+';   }   10% {     transform: scale(1.3);     background-color: '+colorB+';   }   15% {     transform: scale(1);   }   25%{ transform: scale(1);      background-color: '+color+';   }   100%{     transform: scale(1);      background-color: '+color+';   } }';
		head += '</style>';

		var body = '';
		body += '<div class="main">';
		body += '	<div class="small1">';
		body += '		<div class="small ball smallball1"></div>';
		body += '		<div class="small ball smallball2"></div>';
		body += '		<div class="small ball smallball3"></div>';
		body += '		<div class="small ball smallball4"></div>';
		body += '	</div>';
		body += '	<div class="small2">';
		body += '		<div class="small ball smallball5"></div>';
		body += '		<div class="small ball smallball6"></div>';
		body += '		<div class="small ball smallball7"></div>';
		body += '		<div class="small ball smallball8"></div>';
		body += '	</div>';
		body += '	<div class="bigcon"><div class="big ball"></div></div>';
		body += '</div>';

		//Confirm frame has parent window...
		if(typeof(frame[0]) != 'undefined' && ((typeof(frame[0].contentWindow) != 'undefined' && frame[0].contentWindow != null) || (typeof(frame[0].contentDocument) != 'undefined' && frame[0].contentDocument != null))){
			frame.contents().find('head').html(head);
			frame.contents().find('body').html(body);
			frame.contents().find('body').addClass('pace-running');
		}
	},
	setFrameContentsAsNotLoading: function(frame, setTitleText, setTitleSubText){
		//Show Menu Item As NOT Loading
		var _frame = (typeof(frame[0]) != 'undefined') ? frame[0] : frame;
		if(typeof(_frame) != 'undefined' && typeof(_frame.menu_item) != 'undefined'){
			$('#uiLeftItems [menu_link="'+_frame.menu_item.link+'"]').removeClass('menu_item_loading');
		}

		//Auto Select a title if not set
		if(typeof(setTitleText) == 'undefined' || !setTitleText){
			if(_frame.contentDocument == null){
				setTitleText = 'PDF';
			}
			else {
				if(typeof(_frame.contentWindow.$) == 'function'){
					var header = _frame.contentWindow.$('h1')[0];
					if(typeof(header) == 'undefined'){
						header = _frame.contentWindow.$('h2')[0];
						if(typeof(header) == 'undefined'){
							header = _frame.contentWindow.$('table.report > thead > th.header, table.report > th.header, table.report > tbody > th.header')[0];
							if(typeof(header) == 'undefined'){
								header = _frame.contentWindow.$('legend')[0];
							}
						}
					}
					if(typeof(header) != 'undefined'){
						setTitleText = _frame.contentWindow.$(header).text();
					}
				}
			}
		}
		if(typeof(setTitleText) == 'undefined' || !setTitleText) setTitleText = '######';

		//Remove "Loading..." text
		var text = $('#uiLeftItems li[menu_link="internal_'+_frame.internal_frame_id+'"] .itemText').text();
		if(text == window.STR_LOADING+'...'){
			if(typeof(_frame.setTitle) != 'undefined') _frame.setTitle(setTitleText, setTitleSubText);
			else $('#uiLeftItems li[menu_link="internal_'+_frame.internal_frame_id+'"] .itemText').text(setTitleText);
		}

		//Update Header Text
		if($('#pagetitle').text() == window.STR_LOADING+'...'){
			if($('#uiLeftItems li[menu_link="internal_'+_frame.internal_frame_id+'"]').is('.activateMenuItem')){
				$('#pagetitle').text(setTitleText);
			}
		}

	},
	showFrameReturnTaskBarItem: function(frame, TaskBar, return_label, return_btn_class){
		//Dont show on if location is my_src
		if(frame.contentWindow.location.href == 'about:blank') return false;
		if(frame.contentWindow.location.href.indexOf($(frame).attr('my_src')) == frame.contentWindow.location.href.length - $(frame).attr('my_src').length) return false;

		//Defaults
		if(typeof(return_label) == 'undefined' || return_label == null) return_label = $(frame).attr('return_label') ? $(frame).attr('return_label') : window.STR_LIST;
		if(typeof(return_btn_class) == 'undefined' || return_btn_class == null) return_btn_class = '';
		if(typeof(TaskBar) == 'undefined') TaskBar = $($($(frame).parent('.ui-tabs-panel')[0]).children('.uiTaskBarContainer')[0]).find('.uiTaskBar')[0];

		if(typeof(frame.taskBarUID) == 'undefined'){
			if(typeof(window.top.tasBarUIDNext) == 'undefined') window.top.tasBarUIDNext = 0;
			frame.taskBarUID = window.top.tasBarUIDNext++;
		}

		var frameUIDClass = 'uiTaskBarButtonReturnIframe_'+frame.taskBarUID;
		frame = $(frame);
		TaskBar = $(TaskBar);

		if(TaskBar && TaskBar.find('.'+frameUIDClass).length == 0){
			var return_elm = $('<div class="uiTaskBarButton  uiTaskBarButtonFor_ '+return_btn_class+' '+frameUIDClass+'">  <input type="image" title="'+return_label+'" alt="'+return_label+'" src="images/back.png"> '+return_label+'</div>');
			return_elm.prependTo(TaskBar);
			return_elm.click(function(){
				frame.attr('src', frame.attr('my_src'));
				$(this).remove();
			});
		}

		return true;
	},
	addTaskbarItem: function(label, img, frame_id, page, onclick, prepend){
		var isCloseButton = label === window.STR_CLOSE || label === window.STR_CLOSE_WINDOW;
		var isRefreshButton = label === window.STR_REFRESH;
		var isSettingsButton = label === window.STR_SETTINGS;
		var isSaveButton = label === window.STR_SAVE;
		var isHelpButton = label === window.STR_HELP;
		var preprocessButtonCallable = function(btn){};
		var title = label;
		var img = '<input type="image" title="'+title+'" alt="'+label+'" src="'+img+'">';
		if(isCloseButton || isRefreshButton || isSettingsButton || isSaveButton || isHelpButton){
			label = '';
			var preprocessButtonCallable = function(btn){
				btn.addClass('uiTaskBarButton-pageoption');
				if(isCloseButton) btn.css('order', 10);
				else if(isRefreshButton) btn.css('order', 12);
				else if(isSettingsButton) btn.css('order', 13);
				else if(isSaveButton) btn.css('order', 11);
				else if(isHelpButton) btn.css('order', 14);
			};
			if(isCloseButton) img = '<i class="far fa-window-close"></i>';
			else if(isRefreshButton) img = '<i class="fas fa-sync"></i>';
			else if(isSettingsButton) img = '<i class="fas fa-cog"></i>';
			else if(isSaveButton) img = '<i class="fas fa-save"></i>';
			else if(isHelpButton) img = '<i class="fas fa-question"></i>';
		}
		return UI.addTaskbarHTMLItem('<span class="uiTaskBarImgContainer">'+img+'</span>'+(label === '' ? '' : ' '+label), frame_id, page, onclick, prepend, preprocessButtonCallable);
	},
	addTaskbarHTMLItem: function(html, frame_id, page, onclick, prepend, preprocessButtonCallable){
		if(typeof(frame_id) == 'undefined') frame_id = null;
		if(typeof(page) == 'undefined') page = null;
		if(typeof(onclick) == 'undefined') onclick = null;
		if(typeof(prepend) == 'undefined') prepend = false;
		if(typeof(preprocessButtonCallable) !== 'function') preprocessButtonCallable = function(x){};

		//Create the taskbar if it doesnt exist already
		var TaskBar = $('#content > .uiTaskBarContainer > .uiTaskBarBackground > .uiTaskBar');
		var uiNeedsResized = false;
		if(TaskBar.length == 0){
			TaskBar = $('<div class="uiTaskBarContainer"><div class="uiTaskBarBackground'+(window.template == 'iframe' ? ' uiTaskBarIFrameBackground' : '')+'"><div class="uiTaskBar uiTaskBarTable"></div></div></div>');
			TaskBar.prependTo('#content');
			TaskBar = $('#content > .uiTaskBarContainer > .uiTaskBarBackground > .uiTaskBar');
			uiNeedsResized = true;
		}

		//Remember the starting height for the taskbar (if changed, ui is resized)
		var heightBeforeAdd = uiNeedsResized ? null : TaskBar.height();

		//Add the new button element
		//--Create the element
		var return_elm = $('<div class="uiTaskBarButton" frame_id="'+frame_id+'" internal_page="'+page+'">'+html+'</div>');
		preprocessButtonCallable(return_elm);
		if(onclick !== null) return_elm.click(onclick);
		//--Insert into DOM
		if(prepend) return_elm.prependTo(TaskBar);
		else{
			var clearFloatDiv = TaskBar.find('.uiTaskBarTableClearFloats');
			if(clearFloatDiv.length == 0) return_elm.appendTo(TaskBar);
			else return_elm.insertBefore(clearFloatDiv[clearFloatDiv.length - 1]);
		}

		//Resize UI if new item changed the taskbar's height
		var newHeight = TaskBar.height();
		if(newHeight !== null && TaskBar.is('.uiTaskBarIsInSectionContent') == false) {
			if(document.body !== null) document.documentElement.style.setProperty('--ui-style-taskbar-height', newHeight + 'px');
			UI.uiStyleTaskbarHeight = newHeight;
		}
		if(heightBeforeAdd != newHeight) uiNeedsResized = true;
		if(uiNeedsResized) UI.resize();

		return return_elm;
	},
	hightLightTab: function(internal_frame_id, useAltAnimation){
		if(window.slow_cpu) return;
		if(typeof(useAltAnimation) == 'undefined') useAltAnimation = false;

		var elm = null;
		if(typeof(internal_frame_id) == 'object' && typeof(internal_frame_id.jquery) == 'undefined') internal_frame_id = $(internal_frame_id);
		if(typeof(internal_frame_id) == 'object') elm = internal_frame_id;
		else elm = $('#uiLeftItems > li').filter(function(index){ return this.internal_frame_id == internal_frame_id; });
		if(elm.length == 0) return;
		if(useAltAnimation){
			//Fade In/Out
			elm.addClass('fadeOut');
			if(typeof(elm[0].__fadeOutIndex) == 'undefined') elm[0].__fadeOutIndex = 0;
			elm[0].__fadeOutIndex++;
			var thisFadeOutIndex = elm[0].__fadeOutIndex;
			setTimeout(function(){ if(thisFadeOutIndex == elm[0].__fadeOutIndex) elm.removeClass('fadeOut'); }, 300);
		}
		else{
			//Bounce Right
			elm.addClass('bounceRight');
			if(typeof(elm[0].__bouceRightIndex) == 'undefined') elm[0].__bouceRightIndex = 0;
			elm[0].__bouceRightIndex++;
			var thisBoucherIndex = elm[0].__bouceRightIndex;
			setTimeout(function(){ if(thisBoucherIndex == elm[0].__bouceRightIndex) elm.removeClass('bounceRight'); }, 167);
		}
	},
	promptfornewpassword:function(){
		$('#promptfornewpassword').dialog({
			modal:true,
			dialogClass:'no-close',
			closeOnEscape: false,
			width:$(window).width()*0.8,
			height:$(window).height()*0.8
		});
	},

	/*MENU PANES*/
	hideAllMenuPanes: function(ignoreUserOpenedMenus, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(ignoreUserOpenedMenus) == 'undefined') ignoreUserOpenedMenus = false;
		if(UI.uiOnLoadResizeDone == false || UI.isDocumentReady == false || UI.footerLoadedFinished == false || UI.postDocumentLoadFinished == false) ignoreUserOpenedMenus = true;
		$('.uiTopBarButtonTooltipActive'+(ignoreUserOpenedMenus ? ':not(.userOpenedMenu)' : '')).removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		$('body > .uiTopBar_FloatingPane'+(ignoreUserOpenedMenus ? ':not(.userOpenedMenu)' : '')).each(function(){
			if(this._isOpened){
				this._isOpened = false;
				event._isOpened = this._isOpened;
				event.panel = this;
				window.np_analytics.event('UI.hideAllMenuPanes', event, '', sender);
				$(this).removeClass('uiTopBarFloatingMenuOpened');
			}
		});
		var qsm = $('#uiTopBar_QuickSearch');
		if(typeof(qsm) !== 'undefined' && qsm.is('.uiTopBarFloatingMenuOpened')){
			try {
				top.UI.QuickSearchMenu.isOpen = false;
				top.UI.QuickSearchMenu.Abort();
			}
			catch(err){ console.log('WARNING: Error Setting QSM Open State! [E23411615824148]'); }
		}
	},
	positionPane: function(pane_elm, btn_elm){
		//Get Button Location
		var offset = $(btn_elm).offset();
		//Get Pane Width
		$(pane_elm).css('display', 'inline-block').css('position', 'relative').css('width', 'auto').css('left', '0px');
		var width  = $(pane_elm).width();
		$(pane_elm).css('display', 'block').css('width', width+'px').css('position', 'fixed');
		//Get Window Size
		var ww = UI.window_width - 24;
		//Position Pane
		var x = (offset.left + width > ww) ? ww - width : offset.left;
		if(x < 2) x = 2;
		if(pane_elm && pane_elm.id && pane_elm.id == 'uiTopBar_SettingsPane'){
			$(pane_elm).css('right', x+'px');
			$(pane_elm).css('left','');
		} else {
			$(pane_elm).css('left', x+'px');
		}
	},
	toggleLinksPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var elm = $('#uiTopBar_LinkPane')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}

		if(elm._isOpened){
			UI.hideLinksPane();
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBar .btnLinks')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			if(typeof(sender) != 'undefined'){
				if(typeof(window.event) != 'undefined' && window.event !== null){
					$(sender).addClass('userOpenedMenu');
				}
			}
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleLinksPane', event, '', sender);
		}
	},
	hideLinksPane: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_LinkPane')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		$(elm).removeClass('uiTopBarFloatingMenuOpened');
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideUserSettingsPane', event, '', sender);
		}
	},
	toggleUserSettingsPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var elm = $('#uiTopBar_SettingsPane')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}

		if(elm._isOpened){
			UI.hideUserSettingsPane();
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBar .btnSettings')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			if(typeof(sender) != 'undefined'){
				$(sender).addClass('uiTopBarButtonTooltipActive');
				if(typeof(window.event) != 'undefined' && window.event !== null){
					$(sender).addClass('userOpenedMenu');
				}
			}
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleUserSettingsPane', event, '', sender);
		}
	},
	hideUserSettingsPane: function(instant, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(instant) == 'undefined') instant = false;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_SettingsPane')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		if(!instant) $(elm).removeClass('uiTopBarFloatingMenuOpened');
		else {
			$(elm).addClass('noanimation').removeClass('uiTopBarFloatingMenuOpened');
			setTimeout(function(){ $(elm).removeClass('noanimation') }, 1);
		}
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideUserSettingsPane', event, '', sender);
		}
	},
	toggleUserDevPane: function(sender, isUserEvent){
		var elm = $('#uiTopBar_DevPane')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}

		if(elm._isOpened){
			UI.hideUserDevPane();
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBar .btnDebug')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
		}
	},
	hideUserDevPane: function(){
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_DevPane')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		$(elm).removeClass('uiTopBarFloatingMenuOpened');
	},
	toggleHelpPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var elm = $('#uiTopBar_HelpPane')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}

		if(elm._isOpened){
			UI.hideHelpPane();
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBar .btnHelp')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			if(typeof(sender) != 'undefined'){
				$(sender).addClass('uiTopBarButtonTooltipActive');
				if(typeof(window.event) != 'undefined' && window.event !== null){
					$(sender).addClass('userOpenedMenu');
				}
			}
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleHelpPane', event, '', sender);
		}
	},
	hideHelpPane: function(instant, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(instant) == 'undefined') instant = false;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_HelpPane')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		if(!instant) $(elm).removeClass('uiTopBarFloatingMenuOpened');
		else {
			$(elm).addClass('noanimation').removeClass('uiTopBarFloatingMenuOpened');
			setTimeout(function(){ $(elm).removeClass('noanimation') }, 1);
		}
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideHelpPane', event, '', sender);
		}
	},
	toggleQuickLinksPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var elm = $('#uiTopBar_LinksPane')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}

		if(elm._isOpened){
			UI.hideQuickLinksPane();
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBar .btnLinks')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			if(typeof(sender) != 'undefined'){
				$(sender).addClass('uiTopBarButtonTooltipActive');
				if(typeof(window.event) != 'undefined' && window.event !== null){
					$(sender).addClass('userOpenedMenu');
				}
			}
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleQuickLinksPane', event, '', sender);
		}
	},
	hideQuickLinksPane: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_LinksPane')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		$(elm).removeClass('uiTopBarFloatingMenuOpened');
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideQuickLinksPane', event, '', sender);
		}
	},
	startSettingsSearch: function(){
		if(UI.menuType === 'mdi') return;
		var labels = $('#section_view label');
		if($('#section_view label').length == 0) return;
		if(UI.menuType !== 'mdi'){
			UI.elmUISearchSettingsContainer().removeClass('uiSearchSettings-Hidden');
		}
		var parent = $('#uiTopBar_SearchResultsPane')[0];
		$(parent).empty();

		var arr = [];
		var keys = [];
		function sortObj(arr){
			// Setup Arrays
			var sortedKeys = new Array();
			var sortedObj = {};

			// Separate keys and sort them
			for (var i in arr) sortedKeys.push(i);
			sortedKeys.sort();

			// Reconstruct sorted obj based on keys
			for (var i in sortedKeys) sortedObj[sortedKeys[i]] = arr[sortedKeys[i]];
			return sortedObj;
		}

		var labels = $('#section_view label');
		labels.each(function(){
			var txt = $(this).text().trim().replace(/\s*:\s*$/gi, '');
			var elmid = $(this).attr('for');
			arr[txt] = elmid;
		});

		arr = sortObj(arr);
		for(var txt in arr){
			keys.push({label: txt, value: arr[txt]});
		}

		var txbxSearch = UI.elmUISearchSettings();
		txbxSearch.autocomplete({
			source: keys,
			select: function(event, ui){
				var id = ui.item.value;
				UI.searchSettingSelected(id);
				UI.elmUISearchSettings().css('color', 'white');
				setTimeout(function(){ UI.elmUISearchSettings().css('color', ''); UI.clearSearch(event, txbxSearch[0]); }, 10);
			},
			open: function(){
				$('.ui-autocomplete').css('padding-top', '8px');
			}
		});
	},
	searchSettingSelected: function(id){
		$('.searchHighlighed').removeClass('searchHighlighed');
		var elm = $('#'+id);
		var lbl = $('label[for='+id+']');
		lbl.addClass('searchHighlighed');
		elm.addClass('searchHighlighed');
		if(elm.is(':focus') == false) elm[0].focus();
	},
	toggleCollapsedTopMenuPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		UI.hideAllMenuPanes();

		//Build Contents
		var menu = $('#collapsedTopMenuPaneContents').empty();
		if(typeof(menu[0]._isOpened) == 'undefined'){
			menu.removeClass('userOpenedMenu');
			menu[0]._isOpened = false;
		}

		if(menu[0]._isOpened){
			menu.removeClass('userOpenedMenu');
			menu[0]._isOpened = false;
			UI.hideCollapsedTopMenuPane();
		}
		else{
			if(isUserEvent) $(menu).addClass('userOpenedMenu');
			menu[0]._isOpened = true;
			menu.html(UI.elmUITopBarMenu().html()).css('height', 'auto').css('display', 'block');
			var h = menu.height();
			menu.css('height', 0).animate({height: h+'px'}, UI.animationSpeedFloatingPanes);
			menu.click(function(event){ if(event.isPropagationStopped()) return; event.stopPropagation(); UI.hideCollapsedTopMenuPane(); return false; });
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleCollapsedTopMenuPane', event, '', sender);
		}
	},
	hideCollapsedTopMenuPane: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var menu = $('#collapsedTopMenuPaneContents');
		menu.removeClass('userOpenedMenu');
		menu.animate({height: 0}, UI.animationSpeedFloatingPanes);
		menu.removeClass('userOpenedMenu');
		var wasOpen = menu[0]._isOpened;
		menu[0]._isOpened = false;
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideCollapsedTopMenuPane', event, '', sender);
		}
	},
	toggleUIAlertsPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(isUserEvent) == 'undefined') isUserEvent = false;
		var elm = $('#uiTopBar_AlertsPane')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}

		if(elm._isOpened){
			UI.hideUIAlertsPane(isUserEvent);
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{
			$($('#uiTopBarAlertsBtn .imgAlert').removeClass('animation_shake')[0].parentElement).removeClass('imgAlert_animated');
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBarAlertsBtn')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleUIAlertsPane', event, '', sender);
		}
	},
	hideUIAlertsPane: function(isUserEvent, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		if(typeof(isUserEvent) == 'undefined') isUserEvent = false;
		if(isUserEvent) {
			$($('#uiTopBarAlertsBtn .imgAlert').removeClass('animation_shake')[0].parentElement).removeClass('imgAlert_animated');
		}
		var elm = $('#uiTopBar_AlertsPane')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		$(elm).removeClass('uiTopBarFloatingMenuOpened');
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideUIAlertsPane', event, '', sender);
		}
	},
	toggleUIQuickAddPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var elm = $('#uiTopBar_QuickAdd')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			elm._isOpened = false;
			$(elm).removeClass('userOpenedMenu');
		}
		if(elm._isOpened){
			UI.hideUIQuickAddPane(isUserEvent);
			elm._isOpened = false;
			$(elm).removeClass('userOpenedMenu');
		}
		else{
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBarAddBtn')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleUIQuickAddPane', event, '', sender);
		}
	},
	hideUIQuickAddPane: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_QuickAdd')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		$(elm).removeClass('uiTopBarFloatingMenuOpened');
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideUIQuickAddPane', event, '', sender);
		}
	},
	toggleQuickSearchPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var elm = $('#uiTopBar_QuickSearch')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			elm._isOpened = false;
		}

		if(elm._isOpened){//Close the panel
			UI.hideQuickSearchPane();
			top.UI.QuickSearchMenu.isOpen = false;
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{//Open the panel
			UI.hideAllMenuPanes();
			top.UI.QuickSearchMenu.SetSearchType('menu');
			top.UI.QuickSearchMenu.isOpen = true;
			$('#uiTopBarQSearchBtn')[0].focus();
			UI.QuickSearchMenu.View(0);
			UI.positionPane(elm, $('#uiTopBarQSearchBtn')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			if(typeof(sender) != 'undefined'){
				$(sender).addClass('uiTopBarButtonTooltipActive');
				if(typeof(window.event) != 'undefined' && window.event !== null){
					$(sender).addClass('userOpenedMenu');
				}
			}
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleQuickSearchPane', event, '', sender);
		}
	},
	hideQuickSearchPane: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		UI.QuickSearchMenu.View(0, true);
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_QuickSearch')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		top.UI.QuickSearchMenu.isOpen = false;
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		$(elm).removeClass('uiTopBarFloatingMenuOpened');
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideQuickSearchPane', event, '', sender);
		}
	},
	toggleWalkThroughPane: function(sender, isUserEvent, event){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		var elm = $('#uiTopBar_WalkthroughsPane')[0];
		if(typeof(elm) == 'undefined') return;
		if(typeof(elm._isOpened) == 'undefined'){
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}

		if(elm._isOpened){
			UI.hideWalkThroughPane();
			$(elm).removeClass('userOpenedMenu');
			elm._isOpened = false;
		}
		else{
			UI.hideAllMenuPanes();
			UI.positionPane(elm, $('#uiTopBar .btnHelp')[0]);
			if(isUserEvent) $(elm).addClass('userOpenedMenu');
			elm._isOpened = true;
			$(elm).addClass('uiTopBarFloatingMenuOpened');
			if(typeof(sender) != 'undefined'){
				$(sender).addClass('uiTopBarButtonTooltipActive');
				if(typeof(window.event) != 'undefined' && window.event !== null){
					$(sender).addClass('userOpenedMenu');
				}
			}
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.toggleWalkThroughPane', event, '', sender);
		}
	},
	hideWalkThroughPane: function(instant, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(instant) == 'undefined') instant = false;
		$('.uiTopBarButtonTooltipActive').removeClass('userOpenedMenu').removeClass('uiTopBarButtonTooltipActive');
		var elm = $('#uiTopBar_WalkthroughsPane')[0];
		if(typeof(elm) == 'undefined') return;
		$(elm).removeClass('userOpenedMenu');
		var wasOpen = elm._isOpened;
		elm._isOpened = false;
		if(!instant) $(elm).removeClass('uiTopBarFloatingMenuOpened');
		else {
			$(elm).addClass('noanimation').removeClass('uiTopBarFloatingMenuOpened');
			setTimeout(function(){ $(elm).removeClass('noanimation') }, 1);
		}
		if(wasOpen) {
			event._isOpened = elm._isOpened;
			event.panel = elm;
			window.np_analytics.event('UI.hideWalkThroughPane', event, '', sender);
		}
	},

	QuickSearchMenu: {
		menuItemSelectedIndex: -1,
		lastTermSearched: null,
		ajax: null,
		isOpen: false,
		SearchType: null,
		LastViewIndex: 0,
		View: function(index, forClose){
			top.UI.QuickSearchMenu.menuItemSelectedIndex = -1;
			if(index == 1) top.$('#uiTopBar_QuickSearch_Term').css('display', '')[0].focus();
			else top.$('#uiTopBar_QuickSearch_Term').css('display', 'none');
			top.$('#uiTopBar_QuickSearch')[0].scrollLeft = 0;
			top.UI.QuickSearchMenu.LastViewIndex = index;
			top.UI.QuickSearchMenu.SetSelectionCursorIndex(false);
			if(typeof(forClose) == 'undefined') forClose = false;
			if(!forClose) top.UI.QuickSearchMenu.ResizeHeight();
			top.$('#uiTopBar_QuickSearch > div > div').css('left', (-1*index*top.$('#uiTopBar_QuickSearch > div').width())+'px');
		},
		SetSearchTypeFromKey: function(char){
			var search_type = top.$('#uiTopBar_QuickSearch li[data-altkey="'+char.toLowerCase()+'"]').attr('data-table');
			if(typeof(search_type) == 'undefined') return false;
			top.UI.QuickSearchMenu.SetSearchType(search_type);
			return true;
		},
		SetSearchType: function(search_type){
			top.UI.QuickSearchMenu.lastTermSearched = null;
			top.$('#uiTopBar_QuickSearch_Term').val('');
			window.np_analytics.suspend();
			top.UI.QuickSearchMenu.Search('');
			window.np_analytics.resume();
			var txbxSearch = top.$('#uiTopBar_QuickSearch_Term');
			txbxSearch.attr('placeholder', txbxSearch.attr('data-prefixplaceholder')+': '+top.$('#uiTopBar_QuickSearch li[data-table="'+search_type+'"] > span').text());
			top.UI.QuickSearchMenu.SearchType = search_type;
			top.UI.QuickSearchMenu.View(1);
		},
		Search: function(term, salt, event, sender){
			if(typeof(event) !== 'object' || event === null) event = {};
			if(typeof(sender) !== 'object') sender = null;
			if(typeof(salt) === 'undefined') salt = null;
			term = term.trim();
			if(term === top.UI.QuickSearchMenu.lastTermSearched && salt === null) return;
			if(top.UI.QuickSearchMenu.ajax != null){
				top.UI.QuickSearchMenu.ajax.abort();
				top.UI.QuickSearchMenu.ajax = null;
			}
			top.UI.QuickSearchMenu.lastTermSearched = term;
			var ul = top.$('#uiTopBar_QuickSearch_Results');
			ul.empty();
			if(term == ''){
				top.UI.QuickSearchMenu.ResizeHeight();
				return;
			}
			top.$('<li>').text(window.STR_LOADING+'...').appendTo(ul);
			top.$('#uiTopBar_QuickSearch_SearchBar .css-search-and-refresh-control').addClass('animate');
			top.UI.QuickSearchMenu.ResizeHeight();
			var url = CI_BASE_URL+'quicksearch/search/'+escape(top.UI.QuickSearchMenu.SearchType)+'/'+escape(term);
			if(salt !== null) url += '?&s='+salt;
			top.UI.QuickSearchMenu.ajax = $.getRetry(url, function(data){
				var ul = top.$('#uiTopBar_QuickSearch_Results');
				ul.empty();
				event.searchterm = term;
				window.np_analytics.event('UI.QuickSearchMenu.Search', event, '', sender);
				top.$('#uiTopBar_QuickSearch_SearchBar .css-search-and-refresh-control').removeClass('animate');
				var elm = $('#uiTopBar_QuickSearch')[0];
				if(typeof(elm) != 'undefined' && typeof(elm._isOpened) != 'undefined' && !elm._isOpened) return;
				if(data.results.length == 0){
					ul.html('<div style="text-align: center; font-style: italic; font-size: 16px; line-height: 32px; color: #333;">'+window.STR_NO_RECORDS_FOUND+'</div>');
				}
				else {
					for(var i in data.results){
						var url = data.url.replace('{id}', i.replace('#', ''));
						var onclick = '';
						if(!url.match(/^javascript:/i)){
							url += (url.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe'
							onclick = 'top.UI.open(\''+url+'\')';
						}
						else {
							onclick = url.replace(/^javascript:/i, '');
						}
						top.$('<li>').attr('onclick', onclick).html(data.results[i]).appendTo(ul);
					}
					top.UI.QuickSearchMenu.SetSelectionCursorIndex(0);
				}
				top.UI.QuickSearchMenu.ResizeHeight();
				top.UI.QuickSearchMenu.ajax = null;
			});
		},
		Refresh: function(event, sender){
			if(typeof(event) !== 'object' || event === null) event = {};
			if(typeof(sender) !== 'object') sender = null;
			var salt = (new Date()).getTime();
			top.UI.QuickSearchMenu.Search(top.UI.QuickSearchMenu.lastTermSearched, salt, event, sender);
		},
		ResizeHeight: function(){
			top.$('#uiTopBar_QuickSearch').css('height', top.$('#uiTopBar_QuickSearch > div > div > div:nth-child('+(top.UI.QuickSearchMenu.LastViewIndex + 1)+')').height()+'px');
		},
		SetSelectionCursorIndex: function(index){
			//Get Active <ul> to cursor thru
			var ul = top.$(top.UI.QuickSearchMenu.LastViewIndex  == 0 ? '#uiTopBar_QuickSearch_SelectType' : '#uiTopBar_QuickSearch_Results');
			//Put index in bounds
			if(index !== false){
				var maxIndex = -1;
				var liLen = ul.children('li').length;
				if(liLen > 0) maxIndex = liLen - 1;
				if(index < 0) index = 0;
				if(index > maxIndex) index = maxIndex;
				top.UI.QuickSearchMenu.menuItemSelectedIndex = index;
				//Assign New Selected Class
				ul.find('li.selected:not(:nth-child('+(top.UI.QuickSearchMenu.menuItemSelectedIndex + 1)+'))').removeClass('selected');
				if(index >= 0) ul.find('li:nth-child('+(top.UI.QuickSearchMenu.menuItemSelectedIndex + 1)+')').addClass('selected');
			}
			else {
				top.UI.QuickSearchMenu.menuItemSelectedIndex = -1;
				ul.find('li.selected').removeClass('selected');
			}
		},
		OnKeyDown: function(e){
			if(!top.UI.QuickSearchMenu.isOpen) return;
			//ESC: Close Quick Search UI
			if(e.keyCode == 27){
				top.UI.hideAllMenuPanes();
				return true;
			}
			//Array Down
			if(e.keyCode == 40){
				top.UI.QuickSearchMenu.SetSelectionCursorIndex(top.UI.QuickSearchMenu.menuItemSelectedIndex + 1);
				return true;
			}
			//Arrow Up
			if(e.keyCode == 38){
				top.UI.QuickSearchMenu.SetSelectionCursorIndex(top.UI.QuickSearchMenu.menuItemSelectedIndex - 1);
				return true;
			}
			//Enter || Arrow Right
			if(e.keyCode == 13 || e.keyCode == 39){
				$(top.UI.QuickSearchMenu.LastViewIndex == 0 ? '#uiTopBar_QuickSearch_SelectType' : '#uiTopBar_QuickSearch_Results').children('li.selected').click();
				return true;
			}
			//Alt Key Search Type Select
			if(top.UI.QuickSearchMenu.LastViewIndex == 0){
				if(top.UI.QuickSearchMenu.SetSearchTypeFromKey(e.key)) return true;
			}
			//Key Not Handled
			return false;
		},
		Abort: function(){
			top.$('#uiTopBar_QuickSearch_SearchBar .css-search-and-refresh-control').removeClass('animate');
			if(top.UI.QuickSearchMenu.ajax != null){
				top.UI.QuickSearchMenu.ajax.abort();
				top.UI.QuickSearchMenu.ajax = null;
			}
		}
	},

	shake: function(elm){
		if(typeof(elm) == 'undefined' || elm == null) return;
		elm = $(elm);
		if(typeof(elm[0]) == 'undefined') return;
		if(!elm.is('.uishake')){
			elm.addClass('uishake');
			setTimeout(function(){
				elm.removeClass('uishake');
			}, 333);
		}
	},

	bounce: function(elm, bounce_count){
		if(typeof(elm) == 'undefined' || elm == null) return;
		elm = $(elm);
		if(typeof(elm[0]) == 'undefined') return;
		var shake_size  = 5;
		var shake_time  = 116;
		var shake_count = typeof(bounce_count) == 'undefined' ? 1 : bounce_count;
		var wait_end = 0;
		for(var i = 0; i < shake_count; i++){
			var time = (i == 0 ? shake_time / 2 : shake_time);
			var wait = i - 1 >= 0 ? (shake_time / 2) + ((i - 1) * shake_time) : 0;
			var odd  = i % 2 == 0;
			wait_end = wait + time;
			setTimeout((function(){
				elm.css({
				"transform": "translate(0px, "+(this.o ? '-' : '')+shake_size+"px)",
				"transition": "transform "+this.t+'ms'
				});
			}).bind({'t': time, 'w': wait, 'o': odd}), wait);
		}
		var _wait = shake_count - 1 >= 0 ? (shake_time / 2) + (shake_count - 1 * shake_time) : shake_time;

		setTimeout((function(){
			elm.css({
			"transform": "translate(0px, 0px)",
			"transition": "transform "+this.t+'ms'
			});
		}).bind({'t': shake_time / 2}), wait_end + 10);
		setTimeout(function(){
			elm.css({
			"transform": "translate(0px, 0px)",
			"transition": "transform 0ms"
			});
		}, wait_end + shake_time);
	},

	showTooltip: function(elm, message, timespan_ms, position){
		//Default Params
		if(typeof(elm) == 'undefined') return;
		if(typeof(message) == 'undefined') message = 'UNDEFINED';
		if(typeof(timespan_ms) == 'undefined') timespan_ms = 3000;
		if(typeof(position) == 'undefined') position = {};
		elm = $(elm);

		//Show Tooltip
		var elmTooltip = $('<div class="ui-tooltip">').html(message).appendTo(elm[0].parentNode);
		elmTooltip.position(position);

		//Hide
		var funcHide = (function(){
			if(typeof(this) != 'undefined') $(this).animate({opacity: 0}, 166, (function(){ $(this).remove(); }).bind(this));
		}).bind(elmTooltip);
		//--Hide On Unfocus
		if(elm.is('input') || elm.is('textarea')) elm.one('blur', funcHide);
		//--Auto Hide Tooltip
		if(timespan_ms > 0) setTimeout(funcHide, timespan_ms);
		//--Hide when clicked
		$(elmTooltip).click(funcHide);

		return elmTooltip;
	},

	tooltip: function(elm, message, timespan_ms, position){ return UI.showTooltip(elm, message, timespan_ms, position); },

	fadeOutAndIn: function(elm){
		if(typeof(elm.navigator) != 'undefined') return;
		if(typeof(elm) == 'undefined' || elm == null) return;
		elm = $(elm);
		if(typeof(elm[0]) == 'undefined') return;
		if(!elm.is('.fadeOutAndInAnimation')){
			elm.addClass('fadeOutAndInAnimation').animate({'opacity': 0.333}, 116);
			setTimeout(function(){
				elm.animate({'opacity': 1}, 116);
				setTimeout(function(){
					elm.removeClass('fadeOutAndInAnimation')
				}, 116);
			}, 116);
		}
	},

	setTextHelp: function(html){
		$('#text_help_link').html(html);
		if(html == '') $('#text_help_link').css('display', 'none');
		else $('#text_help_link').css('display', 'list-item');
		if(html != '') UI.hideHelpPane(true);
	},

	show_mobile_nav: function(options){
		//options = {id, text, link, image}
		var background = document.createElement('div');
		$(background).addClass('mobile_nav_background');
		$(background).click(function(){ $('.mobile_nav_background').remove(); });
		$('body')[0].appendChild(background);

		var container  = document.createElement('div');
		$(container).addClass('mobile_nav_container');
		background.appendChild(container);

		var max_width = 0;
		var first = true;
		for(var o in options){
			if(!first){
				var br = document.createElement('hr');
				container.appendChild(br);
			}
			first = false;

			var option = options[o];
			var li = document.createElement('span');
			$(li)[0].parentLinkId = option.id;
			$(li).text(option.text).css('cursor', 'pointer');
			$(li).click(function(){
				var confirmed = UI.mouseConfirmed;
				UI.mouseConfirmed = true;
				isIE = function(){ return false; };
				$('#'+this.parentLinkId)[0].onclick();
				UI.mouseConfirmed = confirmed;
			});
			container.appendChild(li);

			var _w = $(li).outerWidth();
			if(_w > max_width) max_width = _w;
		}
		container.max_width = max_width;
		UI.show_mobile_nav_resize();
	},
	show_mobile_nav_resize: function(){
		var background = $('.mobile_nav_background');
		var container  = $('.mobile_nav_container');
		if(background.length == 0) return;
		if(container.length  == 0) return;

		$(background).css('width', UI.window_width+'px');
		$(background).css('height', UI.window_height+'px');

		var max_width = container[0].max_width + 2;
		$(container).css('width', max_width+'px');
		$(container).css('margin-top',  (UI.window_height / 2) - ($(container).height() / 2)+'px');
		$(container).css('margin-left', (UI.window_width  / 2) - (max_width             / 2)+'px');
	},

	showSearchBox: function(){
		if(UI.menu === 'mdi') return;
		if(UI.elmUISearchSettingsContainer().length > 0 && UI.elmUISearchSettingsContainer().is('.uiSearchSettings-Hidden')){
			UI.elmUISearchSettingsContainer().removeClass('uiSearchSettings-Hidden');
			UI.onWindowResize_CenterPageTitle();
			UI.onWindowResize_CollapseTopMenu();
		}
	},
	hideSearchBox: function(){
		if(UI.elmUISearchSettingsContainer().length > 0 && UI.elmUISearchSettingsContainer().is('.uiSearchSettings-Hidden') == false){
			UI.elmUISearchSettingsContainer().addClass('uiSearchSettings-Hidden');
			UI.onWindowResize_CenterPageTitle();
			UI.onWindowResize_CollapseTopMenu();
		}
	},

	Navigate: function(sender, href, event, parentTabs, dont_open_new_ui_tab, is_redirect, event_sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(event_sender) !== 'object') event_sender = null;
		event.href = href;
		if(typeof(is_redirect) == 'undefined' || is_redirect == '' || is_redirect == null) is_redirect = false;
		if(typeof(sender.matches) == 'undefined' && typeof(sender.length) != 'undefined'){
			if(sender.length == 0) sender.matches = function(){ return false; };
			else sender = sender[0];
		}

		//New Browser Tab on Ctrl+Click
		if(top.ctrlIsDown && typeof(sender) == 'object' && (sender.matches('form') || sender.matches('a.ui-load-gen'))) top.ctrlIsDown = false;
		if(top.ctrlIsDown){
			top.ctrlIsDown = false;
			if(typeof(href) == 'undefined' || href == '' || href == null) href = sender.href;
			href = href.replace(/(\?)?&?tmpl=[^&]*/, '$1');
			event.target = '_blank';
			window.np_analytics.event('UI.Navigate', event, '', sender);
			window.open(href, '_blank');
			return;
		}

		//Prepare what Window is targeted and lookup Tabs Control
		if(typeof(dont_open_new_ui_tab) == 'undefined' || dont_open_new_ui_tab == null){
			dont_open_new_ui_tab = false;
			if(typeof(window.frameElement) != 'undefined'){
				if($(window.frameElement).is('.staticFrame')){
					dont_open_new_ui_tab = true;
				}
			}
		}

		var _window = window;
		if(typeof(sender) != 'undefined' && sender != null && sender.target != '_self' && sender.matches('a')){
			if(window != top) _window = top;
			if(typeof(parentTabs) == 'undefined' || parentTabs == null || parentTabs.length == 0) parentTabs = _window.$((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView');
		}

		//Back on mobile window close
		if(isMobile && window.opener == null && window.top == null && href.match(/close\.html/)){
			event.target = '_self';
			window.np_analytics.event('UI.Navigate', event, '', sender);
			location.href = CI_BASE_URL;
			return;
		}

		//Handel Close Event (href = close.html)
		if(href.match(/close\.html\?tmpl=iframe/)){
			if(window != top) _window = top;
			if(typeof(parentTabs) == 'undefined' || parentTabs == null) parentTabs = _window.$((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView');
			if(typeof(parentTabs) != 'undefined' && parentTabs.length > 0) window.frameElement.closeTab();
			return false;
		}

		//Don't load Save/Back/Delete as tab...
		var img = $(sender).find('img');
		if(img.length > 0 && img.attr('src').match(/(save|delete|back)\.(png|gif)/i)) dont_open_new_ui_tab = true;

		//Load as tab?
		if(typeof(parentTabs) != 'undefined' && parentTabs.length > 0 && (parentTabs.find(sender).length != 0 || window != top) && !dont_open_new_ui_tab){
			var parentTab = $(sender).parents('.ui-tabs-panel');
			return UI.NavigateNewTab(href, parentTabs, _window, event, event_sender === null ? sender : event_sender);
		}
		else{
			if(!sender.matches('form')){
				//Track Download?
				var _frameElm = window.frameElement;
				if(href.match(/(fpdf|fileopen)\.php/)) href += href.indexOf('?') != -1 ? '&trackdownload=1' : '?trackdownload=1';
				if(href.match(/[\?&]trackdownload=1/) && typeof(_frameElm) != 'undefined' && _frameElm){
					frameUITrackObjIndex = 'frameTrackDownload_'+_frameElm.internal_frame_id;

					//Append tracking ID
					if(href.match(/(fileopen)\.php/)) top.UI.setFrameContentsAsNotLoading(_frameElm);
					else {
						top.UI.setFrameContentsAsLoading(_frameElm);
						top.UI[frameUITrackObjIndex] = {};
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_uuid = get_uuid();
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete = false;
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_functionCheckIsComplete = (function(frameUITrackObjIndex){
							top.$.fetch(this.url,
								function(r){
									//Success, file found
									top.UI[frameUITrackObjIndex].processView_FormTrackDownload_lastSuccess = (new Date()).getTime();
									//Complete
									if(r != '0'){
										var setTitle = null;
										var setSubTitle = null;
										if(r != '1'){
											var lines = r.split("\n");
											setTitle = typeof(lines[0]) == 'undefined' ? null : lines[0];
											setSubTitle = typeof(lines[1]) == 'undefined' ? null : lines[1];
										}
										top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete = true;
										top.UI.setFrameContentsAsNotLoading(_frameElm, setTitle, setSubTitle);
									}
								},
								function(){
									//Timeout, never found the tracking file...
									if((new Date()).getTime() - top.UI[frameUITrackObjIndex].processView_FormTrackDownload_lastSuccess > 8000 /*8s*/){
										top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete = true;
										top.UI.setFrameContentsAsNotLoading(top.UI[frameUITrackObjIndex]);
									}

									//Try again...
									else if(!top.UI[frameUITrackObjIndex].processView_FormTrackDownload_IsComplete){
										setTimeout(function(){
											top.UI[frameUITrackObjIndex].processView_FormTrackDownload_functionCheckIsComplete(frameUITrackObjIndex);
										}, 1000);
									}
								});
						}).bind({
							url: NP_BASE_URL+'frmDownloadProgress.php?v='+IMAGE_UPLOAD_DIR.replace(/[\\\/ ]+$/, '').replace(/^[\\\/ ]+/, '')+'&uuid='+top.UI[frameUITrackObjIndex].processView_FormTrackDownload_uuid
						});
						top.UI[frameUITrackObjIndex].processView_FormTrackDownload_functionCheckIsComplete(frameUITrackObjIndex);
						href += '&form_track_download_uuid='+top.UI[frameUITrackObjIndex].processView_FormTrackDownload_uuid;
					}
				}

				if(is_redirect)
					location.href = href;
				else
					location.replace(href);
			}
			else{
				return true;
			}
		}

		return false;
	},
	NavigateNewTab: function(href, parentTabs, _window, event, sender){
		if(typeof(event) !== 'object' || event === null) event = typeof(window.event) !== 'undefined' && window.event !== null ? window.event : {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(_window) == 'undefined') _window = window;
		if(typeof(window.NavigateTabCount) == 'undefined') window.NavigateTabCount = -1;
		window.NavigateTabCount++;

		var tabTemplate = "<li><a href='#{href}'>#{label}</a></li>";
		var label = "...";
		var id = 'tabs-Navigate-'+window.NavigateTabCount;
		var li = _window.$( tabTemplate.replace( /#\{href\}/g, "#" + id ).replace( /#\{label\}/g, label ) );
		var dl = _window.$("<span class='ui-icon ui-icon-close' role='presentation'>X</span>");
		li.addClass('ui-tabs-iframed').addClass('tabsViewItem');
		dl.click(function(){
			var tabs = _window.$(this.parentNode.parentNode);
			var li = this.parentNode;
			var div = _window.$('div[aria-labelledby="'+_window.$(li).attr('aria-labelledby')+'"]');
			li.remove();
			div.remove();
			var lis = tabs.find('li');
			lis = lis[lis.length - 1];
			_window.$(lis).find('a').click();
		});
		li.append(dl);
		var tabContentHtml = "Tab Content.";

		event.href = href;
		event.parentTabs = parentTabs;
		event.tabItem = li[0];
		window.np_analytics.event('UI.NavigateNewTab', event, '', sender == null ? li[0] : sender);

		parentTabs.find( ".ui-tabs-nav" ).append( li );
		parentTabs.tabs( "refresh" );
		var a = li.find('a');
		li.css('cursor', 'pointer').click(function(e){
			if(e.target != this) return;
			_window.$(this).find('a').click();
		});
		a.click();

		var div = _window.$('div[aria-labelledby="'+a[0].id+'"]');
		var frame = _window.$('<iframe>');
		href += (href.replace(CI_BASE_URL, '').indexOf('?') == -1 ? '?&' : '&') + 'tmpl=iframe';
		frame.attr('src', href);
		frame.attr('seemless', 'seemless');
		frame.addClass('tabed-frame');
		div.append(frame);
		frame[0].tab      = li.find('a')[0];
		frame[0].closeTab = function(){ dl.click(); }
		frame[0].setTitle = function(title, subtitle){
			var html = UI.MenuItemGetTabTitleHtml(title, subtitle);
			$(frame[0].tab).html(html);
			top.UI.resize();
		}
		frame.load(function(){
			var elm  = frame[0].contentWindow.document.getElementById('pagetitle');
			var elm2 = frame[0].contentWindow.document.getElementById('pagesubtitle');
			if(elm != null || elm2 != null) frame[0].setTitle((elm != null) ? $(elm).html() : '', (elm2 != null) ? $(elm2).html() : '');
		});

		if(typeof(event) != 'undefined' && event != null){
			UI.MobileHideLeftMenu(false, event, sender);
			event.preventDefault();
			event.stopPropagation();
		}

		return false;
	},

	revalidateFrameSize: function(frame, applyMinHeight, growToInnerHeight){
		if(typeof(frame) == 'undefined' || frame == null) frame = window.frameElement;
		if(frame === null || typeof(frame.contentWindow) == 'undefined') return;
		if(typeof(growToInnerHeight) == 'undefined') {
			growToInnerHeight = $(frame).attr('ui-auto-grow');
			if(typeof(growToInnerHeight) === 'string' && growToInnerHeight === '0') growToInnerHeight = false;
			else growToInnerHeight = true;
		}
		if(typeof(applyMinHeight) == 'undefined') {
			applyMinHeight = $(frame).attr('ui-apply-min');
			if(typeof(applyMinHeight) !== 'number'){
				if(typeof(applyMinHeight) !== 'string') applyMinHeight = true;
				else if(parseInt(applyMinHeight) > 0) applyMinHeight = parseInt(applyMinHeight);
				else if(applyMinHeight === '0' || applyMinHeight.toLowerCase() === 'false') applyMinHeight = false;
				else applyMinHeight = true;
			}
		}
		if($(frame.parentNode).is('.ui-tabs-panel')){
			if($(frame.parentNode).attr('aria-hidden') == 'true')
				return;//Parent Tab is hidden
			if($(frame.parentNode.parentNode.parentNode).is('.main_index_page') && (frame.parentNode.parentNode.parentNode.style.display != 'block' && frame.parentNode.parentNode.parentNode.style.display != ''))
				return;//Parent of parent tab is hidden
		}
		frame.style.maxWidth = '100%';
		var view        = top.UI.uiView;
		var view_pt     = 0;
		var view_pb     = 0;
		if(typeof(view) != 'undefined' && view != null){
			view_pt = $(view).css('padding-top');    view_pt = typeof(view_pt) != 'undefined' && view_pt != null ? parseInt(view_pt.replace(/[^\d]/g)) : 0;
			view_pb = $(view).css('padding-bottom'); view_pb = typeof(view_pb) != 'undefined' && view_pb != null ? parseInt(view_pb.replace(/[^\d]/g)) : 0;
		}
		var padding     = view_pt + view_pb;
		var viewOffset  = $(view).offset();
		//Calc frame elm offset up to the .main_index_page container
		{
			var style = getComputedStyle(document.body);
			var frameOffsetTop = parseInt(style.getPropertyValue('--ui-style-top-menu-height').replace(/px$/i, ''));
			if(typeof(frameOffsetTop) !== 'number' || isNaN(frameOffsetTop)) frameOffsetTop = 0;
			else frameOffsetTop += 1;
			var offsetParent = frame;
			while(offsetParent !== null && offsetParent.matches('.main_index_page') == false){
				frameOffsetTop += offsetParent.offsetTop;
				offsetParent = typeof(offsetParent.offsetParent) == 'undefined' ? null : offsetParent.offsetParent;
			}
		}
		var topOffset   = Math.max(0, frameOffsetTop - (typeof(viewOffset) != 'undefined' ? viewOffset.top : 0));
		var viewHeight  = $(view).height();
		var minH        = typeof(applyMinHeight) !== 'number' && applyMinHeight ? (viewHeight - topOffset) - padding : 0;
		if(typeof(applyMinHeight) === 'number' && minH < applyMinHeight) minH = applyMinHeight;
		var setHeight  = minH;
		var frameInnerBody = frame.contentDocument.body;
		if(typeof(frameInnerBody) == 'undefined' || frameInnerBody == null) frameInnerBody = null;
		else frameInnerBody = $(frameInnerBody);
		var content = frame.contentWindow.document.getElementById('.content');
		var innerViewScroll = frame.contentWindow.document.querySelector('.section_content');
		var dashboard_contents = innerViewScroll ? innerViewScroll.querySelector('#dashboard_contents') : null;
		if(frameInnerBody !== null) {
			frameInnerBody[0].style.height = 'auto';
			frameInnerBody[0].style.overflow = 'visible';
		}
		var frameInnerHeightScrollHeight = frameInnerBody ? frameInnerBody[0].scrollHeight : 0;
		var frameInnerHeightHeight = frameInnerBody ? frameInnerBody.height() : 0;
		var contentScrollHeight = content === null ? 0 : content.scrollHeight + content.offsetTop;
		var dashboard_contents_height = dashboard_contents ? dashboard_contents.scrollHeight : 0;
		var maxH = null;
		if(growToInnerHeight){
			if(innerViewScroll !== null) {
				innerViewScroll.style.height = 'auto';
				innerViewScroll.style.overflow = 'visible';
			}
			var innerViewScrollHeight = innerViewScroll == null ? 0 : innerViewScroll.scrollHeight;
			if(setHeight < contentScrollHeight) setHeight = contentScrollHeight;
			if(setHeight < frameInnerHeightScrollHeight) setHeight = frameInnerHeightScrollHeight;
			if(setHeight < frameInnerHeightHeight) setHeight = frameInnerHeightHeight;
			if(setHeight < innerViewScrollHeight) setHeight = innerViewScrollHeight;
			if(innerViewScroll !== null){
				maxH = innerViewScroll.offsetTop + innerViewScroll.offsetHeight;
				var op2 = content === null ? null : content.offsetTop + content.offsetHeight;
				if(op2 !== null && op2 > maxH) maxH = op2;
				if(dashboard_contents_height > 0 && maxH > dashboard_contents_height) maxH = dashboard_contents_height;
			}
			if(innerViewScroll !== null) innerViewScroll.style.overflow = 'hidden';
		}
		if(template == 'timecard') minH += 43;//Timecard Top Tabs height
		if(maxH !== null && maxH < setHeight) setHeight = maxH;
		if(minH > setHeight) setHeight = minH;
		frame.style.height = setHeight+'px';
	},
	reload_css: function(){
		//Get the LINK css tags to reload
		var elms = [];
		$('head link').each(function(){
			var aType = $(this).attr("type");
			if(typeof(aType) == 'string' && aType.indexOf("css") > -1) elms.push(this);
			else {
				var aRel = $(this).attr("rel");
				if(typeof(aRel) == 'string' && aRel.toLocaleLowerCase() === 'stylesheet') elms.push(this);
			}
		});

		//Reload Each, and resize UI when all are done
		var obj = {pendingLoad: elms.length, elms: elms};
		for(var i in elms){
			var elm = $('<link>');
			for(var a in elms[i].attributes){
				if(elms[i].attributes[a].name == 'href') continue;
				var value = elms[i].attributes[a].name == 'id' ? elms[i].attributes[a].value+'_temp' : elms[i].attributes[a].value;
				elm.attr(elms[i].attributes[a].name, value);
			}
			elm.on('load', (function(){
				this.pendingLoad--;
				if(this.pendingLoad == 0){
					for(var i in this.elms){
						var id = $(this.elms[i]).attr('id');
						$(this.elms[i]).remove();
						if(typeof(id) != 'undefined') $('#'+id+'_temp').attr('id', id);
					}
					UI.resize();
				}
			}).bind(obj));
			var href = $(elms[i]).attr('href')
			href = href.replace(/&jsrefresh=\d+/, '')+'&jsrefresh='+new Date().getMilliseconds();
			elm.attr('href', href);
			elm.appendTo('head');
		}
	},

	HandleGlobalKeyPress: function(e){
		var chr = String.fromCharCode(e.which);
		var scroll_speed = 32;
		var page_down_speed = UI.window_height / 2;

		//Handle Alt Shortcuts
		if(e.altKey && e.ctrlKey && typeof(UI.altKeyEvents[chr]) != 'undefined') return $(UI.altKeyEvents[chr]).click();

		//Handle View Scroll Keys
		if(e.keyCode >= 37 && e.keyCode <= 40){
			if(e.keyCode == 40)//Down
				UI.Scroll(0, scroll_speed);
			else if(e.keyCode == 38)//Up
				UI.Scroll(0, -scroll_speed);
			else if(e.keyCode == 37)//Left
				UI.Scroll(-scroll_speed, 0);
			else if(e.keyCode == 39)//Right
				UI.Scroll(scroll_speed, 0);
		}
		if(e.keyCode == 34)//Page Down
			UI.Scroll(0, page_down_speed);
		else if (e.keyCode == 33)//Page Up
			UI.Scroll(0, -page_down_speed);
	},
	AssignAltKey: function(elm){
		return false;
		/*var assigned = '';
		for(var i in UI.altKeyEvents) assigned += i;

		if(typeof(elm.assignAltKeyRanOnce) != 'undefined') return;
		elm.assignAltKeyRanOnce = true;

		var val = $(elm).text();
		var key = false;
		var orgKey = false;
		for(var i in val){
			var c = val[i].toLowerCase();
			if(assigned.indexOf(c) == -1){
				key = c;
				orgKey = val[i];
				break;
			}
		}
		if(key){
			$(elm).html($(elm).html().replace(new RegExp(key, 'i'), '<u>'+orgKey+'</u>'));
			$(elm).attr('title', 'CTRL + ALT + '+ key.toUpperCase());
			assigned += key;
			UI.altKeyEvents[key] = elm;
		}*/
	},
	DirectAssignAltKey: function(elm, key){
		if(1) return false;//Doesn't work in chrome... so skipping
		var assigned = '';
		for(var i in UI.altKeyEvents) assigned += i;

		if(typeof(elm.assignAltKeyRanOnce) != 'undefined') return;
		elm.assignAltKeyRanOnce = true;

		$(elm).html($(elm).html().replace(new RegExp(key.toUpperCase(), ''), '<u>'+key.toUpperCase()+'</u>').replace(new RegExp(key.toLowerCase(), ''), '<u>'+key.toLowerCase()+'</u>'));
		$(elm).attr('title', 'CTRL + ALT + '+ key.toUpperCase());
		assigned += key;
		UI.altKeyEvents[key] = elm;
	},
	Scroll: function(x, y){
		if(!$(document.activeElement).is('iframe')){
			var target = null;
			var activeIframe = $((UI.mainMenuMode == 'main_index' ? '.main_index_page_active ' : '')+'.tabsView > div[aria-hidden="false"] > iframe');
			if(activeIframe.length > 0)
				if($(activeIframe[0].contentDocument.body).css('overflow') != 'hidden')
					target = activeIframe[0].contentDocument.body;
				else
					target = $(activeIframe[0].contentDocument.body).find('#section_view')[0];
			else
				target = $('#section_view')[0];

			if(typeof(target) == 'undefined' || target == null) {
				if(activeIframe.length > 0)
					if($(activeIframe[0].contentDocument.body).css('overflow') != 'hidden')
						target = activeIframe[0].contentDocument.body;
					else
						target = $(activeIframe[0].contentDocument.body).find('.section_content')[0];
				else
					target = $('.section_content')[0];
			}

			if(typeof(target) == 'undefined' || target == null) target = document.body;

			if(target !== null){
				target.scrollTop  = Math.max(0, Math.min(target.scrollHeight, target.scrollTop  + y));
				target.scrollLeft = Math.max(0, Math.min(target.scrollWidth,  target.scrollLeft + x));
			}
		}
	},

	show_loading: function(elm){
		if(typeof(elm) == 'undefined') return;
		if(top != self) return top.UI.show_loading();
		elm = $(elm);
		if(typeof(elm[0].ui_loading_elm) == 'undefined' || elm.ui_loading_elm === null){
			var loadingelm = $('<div><img style="width: 16px; height: 16px;" src="images/loading_small.gif"></div>');
			var parent = elm[0].parentElement;
			while(parent.matches('.checkboxOverlay, .radioOverlay, .ui-autocomplete-input-container')) parent = parent.parentElement;
			var position = $(parent).position();
			loadingelm.css('position', 'absolute').css('left', (position.left+(elm.outerWidth())-20)+'px').css('top', (position.top+4)+'px');
			loadingelm.appendTo(parent);
			elm[0].ui_loading_elm = loadingelm[0];
		}
	},
	hide_loading: function(elm){
		if(typeof(elm) == 'undefined'){
			if(top != self && typeof(top.UI) !== 'undefined') return top.UI.hide_loading();
		}
		else{
			elm = $(elm);
			if(typeof(elm[0].ui_loading_elm) == 'undefined') elm[0].ui_loading_elm = false;
			if(elm[0].ui_loading_elm !== false){
				$(elm[0].ui_loading_elm).remove();
				elm[0].ui_loading_elm = false;
			}
		}
	},

	invalidate_db_table: function(table, window_target){
		if(typeof(window_target) == 'undefined') window_target = top;
		if(typeof(window_target.$) == 'undefined') return;
		window_target.$('iframe[refresh_by_db_table]').each(function(){
			if($(this).attr('refresh_by_db_table') == table){
				this.contentWindow.location.reload();
			}
		});

		window_target.$('iframe').each(function(){
			UI.invalidate_db_table(table, this.contentWindow);
		});
	},

	selectTabFromTabView: function(sender, tab_title){
		var tabsView = $(sender).parents('.tabsView');
		if(tabsView.length == 0 && typeof(window.frameElement) != 'undefined')
			tabsView = window.frameElement.contentWindow.$(window.frameElement).parents('.tabsView');
		if(tabsView.length == 0) return false;//not found..
		var target = $($(tabsView).get(0)).find('ul.ui-tabs-nav > li.tabsViewItem[tab_title="'+tab_title+'"] > a');
		target[0].click();
	},

	bindContextMenu: function(target_elm, items, appendTo){
		if(typeof(appendTo) == 'undefined') appendTo = $('body')[0];
		if(typeof(target_elm) == 'undefined') return;
		if(typeof(target_elm.length) != 'undefined') target_elm = target_elm[0];

		target_elm.context_items = items;
		$(target_elm).bind("contextmenu", function(event) {
			event.preventDefault();
			var html = '';

			var menu = $("<div class=\"context-menu\">");
			var menu_inner = $("<div class=\"context-menu-inner\">");
			menu_inner.appendTo(menu);

			for(var item_index in this.context_items){
				var item = this.context_items[item_index];
				var a = $('<a>');
				a.appendTo(menu_inner);

				//img
				if(typeof(item.image) != 'undefined'){
					var a_img = $('<img>');
					a_img.attr('src', item.image);
					a_img.addClass('context-menu-inner-list-icon');
					a_img.appendTo(a);
				}

				//Label
				var a_label = $('<span>');
				a_label.text(item.label);
				a_label.appendTo(a);

				//Href
				if(typeof(item.href) != 'undefined') a.attr('href', item.href);
				else a.attr('href', 'javascript:void(0);');

				//Click
				if(typeof(item.onclick) != 'undefined'){
					a[0]._onclick = item.onclick;
					a[0]._menu = menu;
					a.click(function(e){
						if(!(this._onclick.bind(target_elm))(e)){
							if(e.which == 1)//Left Mouse
								$(this._menu).remove();
						}
					});
				}

			}

			menu.appendTo(appendTo)
				.css({top: (event.pageY - 20) + "px", left: (event.pageX - 20) + "px", position: 'fixed'})
				.css('z-index', 9999)
				.mouseover(function(){ this.hasMouse = true; })
				.mouseleave(function(){ if(typeof(this.hasMouse) != 'undefined'){ $(this).remove(); } })
		});
	},

	MenuItemGetTabTitleHtml: function(title, subtitle){
		var html = '';
		if(title && subtitle){
			if(UI.menuType === 'mdi'){
				html = title+' - '+subtitle;
			}
			else {
				html = '<div style="font-size: 10px; margin-top: 5px; text-decoration: underline; overflow: hidden; line-height: 11px; text-overflow: ellipsis;">'+title+'</div><div style="overflow: hidden; line-height: 20px; text-overflow: ellipsis;">'+subtitle+'</div>';
			}
		}
		else if(title && !subtitle){
			html = title;
		}
		else if(!title && subtitle){
			html = subtitle;
		}
		return html;
	},

	texttitle: function(title, subtitle){
		if(UI.menuType === 'mdi') return;
		if(typeof(title) === 'undefined' || title === null) title = '';
		if(typeof(subtitle) === 'undefined' || subtitle === null) subtitle = '';
		if(title.trim() !== '' || subtitle.trim() !== ''){
			if(title) {
				var elm_pagetitle        = document.getElementById('pagetitle');
				var elm_pagetitle_hidden = document.getElementById('pagetitle_hidden');
				var pageTitle = '<'+'span class="pagetitle-title"> '+title+'<'+'/'+'span>';
				if(subtitle != '') pageTitle += '<'+'span id="pagesubtitle" class="pagetitle-subtitle"> '+subtitle+'<'+'/'+'span>';
				if (elm_pagetitle)        elm_pagetitle.innerHTML = pageTitle;
				if (elm_pagetitle_hidden) elm_pagetitle_hidden.style.display = 'block';
			}
			if(typeof(window.frameElement) != 'undefined' && window.frameElement != null && typeof(window.frameElement.setTitle) != 'undefined'){
				window.frameElement.setTitle(title, subtitle);
			}
		}
		UI.onWindowResize_CenterPageTitle();
		UI.onWindowResize_CollapseTopMenu();
	},

	listenForUIAlerts: function(){
		UI.refreshUIAlerts(true, true);
	},
	refreshUIAlerts: function(isFirstCall, auto_call_again){
		if(UI.dbupdatepending) return;
		if(typeof(isFirstCall) == 'undefined') isFirstCall = false;
		if(typeof(auto_call_again) == 'undefined') auto_call_again = false;
		UI.refreshUIAlerts_ProcessBuffer();
		var url = window.CI_BASE_URL+'main/uiAlertMessages/?&ref='+encodeURIComponent(NP_BASE_URL.replace(/^https?:\/\//, ''))+'&NO_USER_ACTIVITY=1';
		if(isFirstCall) url += '&isFirstCall=1';
		$.get(url).done(function(data){
			var something_removed = false;
			for(var _uuid in data){
				var uuid = 'uialert_uuid_'+_uuid;
				var r = data[_uuid];
				r.uuid = uuid;
				if(typeof(r.suspenedsecs) != 'undefined' && r.suspenedsecs > 0){
					var isUialertmessageProcessed = false;
					if(typeof(UI.refreshUIAlerts_Buffer[_uuid]) !== 'undefined') isUialertmessageProcessed = UI.refreshUIAlerts_Buffer[_uuid];
					r.isUialertmessageProcessed = isUialertmessageProcessed;
					r.suspendeduntil = new Date();
					r.suspendeduntil.setSeconds(r.suspendeduntil.getSeconds() + r.suspenedsecs);
					UI.refreshUIAlerts_Buffer[_uuid] = r;
				}
				else {
					UI.refreshUIAlerts_ProcessUiAlertMessageObj(r);
					if(typeof(r['delete']) != 'undefined') something_removed = true;
				}
			}
			if(something_removed) UI.revalidateUIAlertsButtonVisiblity();
			var elm = $('#uiTopBar_AlertsPane')[0];
			if(typeof(elm) != 'undefined'){
				if(typeof(elm._isOpened) == 'undefined') elm._isOpened = false;
				if(!elm._isOpened) UI.hideUIAlertsPane();
			}
		}).always(function(){
			if(auto_call_again) {
				setTimeout(function(){ UI.refreshUIAlerts(false, true) }, 60000);
				setTimeout(function(){ UI.refreshUIAlerts_ProcessBuffer() }, 30000);
			}
			UI.refreshUIAlerts_ProcessBuffer();
		});
	},
	refreshUIAlerts_Buffer: {},
	refreshUIAlerts_ProcessBuffer: function(){
		var t = new Date();
		for(var i in UI.refreshUIAlerts_Buffer){
			if(typeof(UI.refreshUIAlerts_Buffer[i].isUialertmessageProcessed) !== 'undefined'){
				if(!UI.refreshUIAlerts_Buffer[i].isUialertmessageProcessed){
					if(UI.refreshUIAlerts_Buffer[i].suspendeduntil <= t){
						UI.refreshUIAlerts_ProcessUiAlertMessageObj(UI.refreshUIAlerts_Buffer[i]);
					}
				}
			}
		}
	},
	refreshUIAlerts_ProcessUiAlertMessageObj: function(uialertmessageObj){
		uialertmessageObj.isUialertmessageProcessed = true;
		var type = typeof(uialertmessageObj['type']) !== 'undefined' ? uialertmessageObj['type'] : null;
		if(type === 'script'){
			var appendTo = typeof(uialertmessageObj['appendTo']) !== 'undefined' ? uialertmessageObj['appendTo'] : 'body';
			$(uialertmessageObj['html']).appendTo(appendTo);
		}
		else if(typeof(uialertmessageObj['delete']) != 'undefined'){
			$('#'+uialertmessageObj.uuid).remove();
		}
		else if(typeof(uialertmessageObj['text']) != 'undefined'){
			$('#'+uialertmessageObj.uuid).remove();
			UI.addUIAlert(uialertmessageObj);
		}
	},
	addUIAlert: function(msg_object) {
		if(typeof(msg_object) == 'undefined') msg_object = {};
		var uuid    = typeof(msg_object.uuid)    == 'undefined' ? 'uialert_uuid_is_undefined' : msg_object.uuid;
		var text    = typeof(msg_object.text)    == 'undefined' ? '' : msg_object.text;
		var onclick = typeof(msg_object.onclick) == 'undefined' ? '' : msg_object.onclick;
		var auto_remove = typeof(msg_object.auto_remove) == 'undefined' ? true : (msg_object.auto_remove ? true : false);
		var elm = $('<div class="uiAlertMessage">').attr('id', uuid)
					.html('<span class="imgSmallMail" style="margin-right: 8px;"></span>'+text)
					.attr('onclick', (auto_remove ? 'setTimeout((function(){ $(this).remove(); UI.revalidateUIAlertsButtonVisiblity(); }).bind(this), 10);' : '')+'UI.hideUIAlertsPane(true);UI.revalidateUIAlertsButtonVisiblity();'+(typeof(onclick) === 'string' ? onclick : ''));
		elm.appendTo('#uiTopBar_AlertsPane');
		if(typeof(onclick) === 'function') elm.on('click', onclick);
		UI.showUIAlertsButton(true);
	},
	showUIAlertsButton: function(ring_animation){
		$('#uiTopBarAlertsBtn').css('display', '');
		UI.onWindowResize_CenterPageTitle();
		UI.onWindowResize_CollapseTopMenu();

		if(ring_animation){
			var bell = $('#uiTopBarAlertsBtn .imgAlert');
			if(bell.length > 0 && !bell.is('animation_shake')) {
				$(bell.addClass('animation_shake')[0].parentElement).addClass('imgAlert_animated');
			}
		}
	},
	hideUIAlertsButton: function(){
		$($('#uiTopBarAlertsBtn .imgAlert').removeClass('animation_shake')[0].parentElement).removeClass('imgAlert_animated');
		$('#uiTopBarAlertsBtn').css('display', 'none');
		UI.onWindowResize_CenterPageTitle();
		UI.onWindowResize_CollapseTopMenu();
	},
	revalidateUIAlertsButtonVisiblity: function(){
		if($('#uiTopBar_AlertsPane > div.uiAlertMessage').length == 0){
			UI.hideUIAlertsButton();
		}
		else{
			UI.showUIAlertsButton();
		}
	},

	refreshUIPaxTerminalDetails: function(){
		$('.menuTopPaxTerminalDetails').load(window.CI_BASE_URL+'ccterminal/selectedTerminalDetails/', '', function(){
			//Reposition the settings menu (in case size changed)
			var elm = $('#uiTopBar_SettingsPane')[0];
			if(typeof(elm) != 'undefined'){
				if(!elm._isOpened){
					UI.hideUserSettingsPane(true);
				}
			}
		});
	},
	showPaxTerminalSelect: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		$.post(CI_BASE_URL+'ccterminal/selectTerminal/', {}, function(r){
			if(r.assigned){	}
			else{
				window.np_analytics.event('UI.showPaxTerminalSelect', event, '', sender);
				window.UI_collectPaxTerminalPaymentAjax_active_select_dialog = $('<div>').html(r.html).dialog({modal: true, width: 400, title: window.STR_SELECT_A_CC_TERMINAL});
			}
		});
		UI.refreshUIPaxTerminalDetails();
	},
	detachPaxTerminalSelection: function(){
		$.get(window.CI_BASE_URL+'ccterminal/selectTerminal/?&unset=1', function(){ UI.refreshUIPaxTerminalDetails(); });
	},

	MobileCollapsedTableOpenRecord: function(collapsed_table, row_index){
		var body = $('<tbody>');
		var data = $(collapsed_table.parent).children('tbody');
		if(typeof(data) == 'undefined') return;
		var record_count = data.children('tr').length;
		data = data.children('tr')[row_index];
		if(typeof(data) == 'undefined') return;
		data = $(data).children('th, td');

		//Set On Change Hooks
		var c = 0;
		data.each(function(){
			if(typeof(this.MobileCollapsedTableOpenRecord_OnChangeHook) == 'undefined'){
				this.MobileCollapsedTableOpenRecord_OnChangeHook = true;
				$(this).find('input, textarea, select').each(function(){
					this.parent_collapsed_table = collapsed_table;
					this.parent_collapsed_table_row_index = row_index;
					this.parent_collapsed_table_data_index = c;
					$(this).change(function(){
						UI.MobileCollapsedTableOpenRecord_ParentInputOnChange(this);
					});
				});
			}
			c++;
		});

		//Clone Elms
		var i = 0;
		$(collapsed_table.header_row).children('*').each(function(){
			if(typeof(data[i]) != 'undefined'){

				$(data[i]).find('input').each(function(){
					if(this.matches('[type="checkbox"]'))
						if(this.checked)
							$(this).attr('checked', 'checked');
						else
							$(this).removeAttr('checked');
					$(this).attr('value', $(this).val());
				});

				var value = $(data[i]).html();


				var title = $(this).text().trim() != '' ? $(this).html().replace(/\:$\s*$/, '')+': ' : '';
				var tr = $('<tr>');
				var th = $('<th style="text-align: left; border-radius: 0;">').html(title).appendTo(tr);
				var td = $('<td>').html(value).appendTo(tr);
				td.find('script').remove();
				td.find('span.checkboxOverlay').remove();
				td.find('input[type="checkbox"].was-styled').removeClass('was-styled');
				td.find('input, select, textarea').each(function(){
					this.parent_collapsed_table = collapsed_table;
					this.parent_collapsed_table_row_index = row_index;
					this.parent_collapsed_table_data_index = i;
					this.parent_collapsed_table_td = data[i];
					$(this).change(function(){
						UI.MobileCollapsedTableOpenRecord_ChildInputOnChange(this);
					});
				});
				tr.appendTo(body);
			}
			i++;
		});

		//Build Navigation Controls
		{
			var thead = $('<thead>');
			var tfoot = $('<tfoot>');
			var trNav = $('<tr>');
			var thNav = $('<th colspan=2>').appendTo(trNav);
			var tableNav = $('<table class="report notablesorter" style="width: 100%; border: 0; outline: 0; margin: 0; padding: 0; box-shadow: none; margin-bottom: 4px;">').appendTo(thNav);
			var tableNavTR = $('<tr>').appendTo(tableNav);

			//Back Button
			var backEnabled = row_index > 0;
			var tdBack = $('<th class="nofloat" style="font-size: 0.8em; text-align: left; '+(backEnabled ? '' : 'visibility: hidden;')+'"></th>').appendTo(tableNavTR);
			var aBack = $('<a onclick="UI.MobileCollapsedTableOpenRecord($(\'#'+$(collapsed_table).attr('id')+'\')[0], '+(row_index - 1)+')" href="javascript:void(0);" style="line-height: 16px;"><img style="width: 24px; height: 24px; margin-bottom: -8px; margin-right: 8px;" src="images/back.png">'+window.STR_BACK+'</a>').appendTo(tdBack);

			//Title
			var tdTitle = $('<th class="nofloat" style="font-size: 0.8em; text-align: center;"></td>');
			$('<span>').text(window.STR_PAGE+': '+(row_index+1)+'/'+record_count.toString()).appendTo(tdTitle);
			tdTitle.appendTo(tableNavTR);

			//Next Button
			var nextEnabled = row_index + 1 < record_count;
			var tdNext = $('<th class="nofloat" style="font-size: 0.8em; text-align: right; '+(nextEnabled ? '' : 'visibility: hidden;')+'"></th>').appendTo(tableNavTR);
			var aNext = $('<a onclick="UI.MobileCollapsedTableOpenRecord($(\'#'+$(collapsed_table).attr('id')+'\')[0], '+(row_index + 1)+')" href="javascript:void(0);" style="line-height: 16px;">'+window.STR_NEXT+'<img style="width: 24px; height: 24px; margin-bottom: -8px; margin-left: 8px;" src="images/next.png"></a>').appendTo(tdNext);

			thead.append(trNav.clone());
			tfoot.append(trNav);
		}

		//Update Display's HTML
		collapsed_table.active_row = -1;
		$(collapsed_table).empty().append(thead).append(body).append(tfoot);
		UI.processView_ElementsStyle(collapsed_table);
		collapsed_table.active_row = row_index;
	},
	MobileCollapsedTableOpenRecord_ParentInputOnChange: function(sender){
		var tbody = $(sender.parent_collapsed_table).children('tbody');
		if(sender.parent_collapsed_table.active_row == sender.parent_collapsed_table_row_index){
			var tr = tbody.children('tr')[sender.parent_collapsed_table_data_index];
			var td = $(tr).children('td')[0];
			$(td).find(sender.tagName).each(function(){
				if($(this).attr('name') == $(sender).attr('name') && $(this).attr('id') == $(sender).attr('id')){
					if(sender.tagName == 'INPUT' && $(this).attr('type').toLowerCase() == 'checkbox'){
						this.checked = sender.checked;
						$(this).prop('checked', this.checked);
					}
					else
						$(this).val($(sender).val());
				}
			});
		}
	},
	MobileCollapsedTableOpenRecord_ChildInputOnChange: function(sender){
		$(sender.parent_collapsed_table_td).find(sender.tagName).each(function(){
			if($(this).attr('name') == $(sender).attr('name') && $(this).attr('id') == $(sender).attr('id')){
				if(sender.tagName == 'INPUT' && $(this).attr('type').toLowerCase() == 'checkbox'){
					this.checked = sender.checked;
					$(this).prop('checked', this.checked);
				}
				else
					$(this).val($(sender).val());
			}
		});
	},

	MobileToogleLeftMenu: function(instant, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		if(typeof(instant) == 'undefined') instant = false;
		if(typeof(UI.MobileToogleLeftMenu_LastValue) == 'undefined') UI.MobileToogleLeftMenu_LastValue = false;
		if(UI.MobileToogleLeftMenu_LastValue){
			UI.MobileHideLeftMenu(instant, event, sender);
		}
		else{
			UI.MobileShowLeftMenu(instant, event, sender);
		}
	},
	MobileHideLeftMenu: function(instant, event, sender){
		if(!window.isMobile) return;
		if(typeof(instant) == 'undefined') instant = false;
		UI.MobileToogleLeftMenu_LastValue = false;
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;

		window.np_analytics.event('UI.MobileHideLeftMenu', event, '', sender);

		var h = $('#uiLeftBarBackground').fullHeight();
		if(instant){
			$('#uiLeftBar, #uiMDIMenuBar').css('position', 'relative').stop(true, true).css('top', (-1*h)+'px');
		}
		else{
			var x = window.isMobile;
			$('#uiLeftBar, #uiMDIMenuBar').css('position', 'relative').stop(true, false).org_animate({top: (-1*h)+'px'}, 333);
		}
	},
	MobileShowLeftMenu: function(instant, event, sender){
		if(!window.isMobile) return;
		if(typeof(instant) == 'undefined') instant = false;
		UI.MobileToogleLeftMenu_LastValue = true;
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;

		window.np_analytics.event('UI.MobileShowLeftMenu', event, '', sender);

		//Style as mobile
		var uiLeftBar = $('#uiLeftBar');
		uiLeftBar[0].focus();
		if(!uiLeftBar.is('.uiLeftBarMobile')){
			uiLeftBar.attr('tabindex', '-1');
			uiLeftBar.addClass('uiLeftBarMobile');
		}

		//Exit when clicking out of the menu
		if(typeof(window.mobileMenuCloseListeningForExit) == 'undefined') window.mobileMenuCloseListeningForExit = false;
		if(!window.mobileMenuCloseListeningForExit){
			var onClickEvent = null;
			onClickEvent = function(e){
				if($(e.target).closest('#uiLeftBar, #uiTopBar').length == 0){
					UI.MobileHideLeftMenu(false, e, this);
					window.mobileMenuCloseListeningForExit = false;
					$(document).off('click', null, onClickEvent);
					uiLeftBar.off('blur', null, onClickEvent);
				}
			};

			window.mobileMenuCloseListeningForExit = true;
			$(document).on('click', null, null, onClickEvent);
			uiLeftBar.on('blur', null, null, onClickEvent);
		}

		//Create the mobile menu if it's been hidden and not yet generated
		if(UI.hideLeftMenu){
			UI.hideLeftMenu = false;
			UI.createMenu();
		}

		//Position the menu on screen
		var top = $('#uiTopBar').fullHeight();
		if(instant){
			uiLeftBar.css('position', 'relative').stop(true, true).css('top', top+'px');
			//$('#uiMDIMenuBar').css('position', 'relative').stop(true, true).css('top', top+'px');
		}
		else{
			uiLeftBar.css('position', 'relative').stop(true, false).org_animate({'top': top+'px'}, 333);
			//$('#uiMDIMenuBar').css('position', 'relative').stop(true, false).org_animate({'top': top+'px'}, 333);
		}
	},

	onTableChange: function(tablename_params){
		for(var i in arguments){
			var tablename = arguments[i];
			if(top.UI != window.UI){
				top.UI.onTableChange(tablename);
			}
			else {
				if(typeof(UI.dataTable_RegisteredTableUse[tablename]) != 'undefined'){
					for(var i in UI.dataTable_RegisteredTableUse[tablename]){
						UI.dataTable_RegisteredTableUse[tablename][i].needs_refreshed = true;
					}
				}
			}
		}
	},
	dataTable_RegisterTableUse: function(datatable, tablename){
		if(top.UI != window.UI && typeof(top.UI) !== 'undefined') return top.UI.dataTable_RegisterTableUse(datatable, tablename);
		if(typeof(UI.dataTable_RegisteredTableUse[tablename]) == 'undefined') UI.dataTable_RegisteredTableUse[tablename] = [];
		UI.dataTable_RegisteredTableUse[tablename].push(datatable);
	},

	layoutContainerAsColumns_isDragging: null,
	layoutContainerAsColumns: function(options, retry_with_options){
		if(typeof(retry_with_options) !== 'object' || retry_with_options === null) retry_with_options = {};
		if(typeof(options.margin_top) == 'undefined') options.margin_top = 11;
		if(typeof(options.margin_left) == 'undefined') options.margin_left = 11;
		if(typeof(options.margin_right) == 'undefined') options.margin_right = 28;
		if(typeof(options.col_gap) == 'undefined') options.col_gap = 11;
		if(typeof(options.row_gap) == 'undefined') options.row_gap = 11;
		if(typeof(options.container) == 'undefined') return;
		if(typeof(options.items) == 'undefined') options.items = '*';
		if(typeof(options.layout_width) == 'undefined' || (typeof(options.layout_width) !== 'function' && options.layout_width <= 0)) options.layout_width = $(options.container).width();
		if(typeof(options.min_report_width) == 'undefined') options.min_report_width = 470;
		if(typeof(options.internal_name) == 'undefined') options.internal_name = null;
		if(typeof(options.order) == 'undefined') options.order = null;
		if(options.col_gap < 0) options.col_gap = 0;
		if(options.row_gap < 0) options.row_gap = 0;
		options.margin_right -= options.col_gap;
		if(options.margin_right < options.col_gap) options.margin_right = options.col_gap;
		if(options.margin_right < 0) options.margin_right = 0;
		if(options.margin_right < 0) options.margin_right = 0;

		//Get Report Tables Area Width
		var report_views_width = (typeof(options.layout_width) === 'function' ? options.layout_width() : options.layout_width) - (options.margin_right + options.margin_left);

		//Get Column Count
		var col_count = typeof(retry_with_options.col_count) !== 'undefined' ? retry_with_options.col_count : (typeof(options.col_count) !== 'undefined' ? options.col_count : Math.floor(report_views_width / options.min_report_width));
		if(col_count < 1) col_count = 1;

		//Get Col Widths
		var col_widths = [];
		for(var i = 0; i < col_count; i++) col_widths.push(options.min_report_width);
		var index = 0;

		//Drag Events
		var container = $(options.container);
		var functionEndDrag = function(){
			if(UI.layoutContainerAsColumns_isDragging === null) return;
			var to = container.find('.layoutContainerAsColumns_DragTargetActive');
			if(to.length > 0){
				var order = parseInt(to.attr('layout-order'));
				var from_order = parseInt(UI.layoutContainerAsColumns_isDragging.target.attr('layout-order'));
				to.attr('layout-order', from_order);
				UI.layoutContainerAsColumns_isDragging.target.attr('layout-order', order);
			}
			container.find('.layoutContainerAsColumns_DragTargetActive').removeClass('layoutContainerAsColumns_DragTargetActive');
			container.find('.layoutContainerAsColumns_DraggingItem').removeClass('layoutContainerAsColumns_DraggingItem');
			UI.layoutContainerAsColumns_isDragging = null;
			UI.layoutContainerAsColumns(options);
			//Save
			var order = [];
			items.each(function(){
				order.push($(this).attr('layout-order'));
			});
			$.postRetry(CI_BASE_URL+'main/layoutContainerAsColumnsSave/', {
				internal_name: options.internal_name,
				order: order,
			});
		};

		//Init the container events & methods
		if(typeof(container[0].layoutContainerAsColumnsOptions) == 'undefined'){
			container[0].layoutContainerAsColumnsOptions = options;
			container[0].layoutColContainerHeight = -1;
			//Set drag/order events
			if(options.internal_name){
				container.mouseup(function(){
					//End The Drag Event
					if(UI.layoutContainerAsColumns_isDragging === null) return;
					functionEndDrag();
				});
				container.mousemove(function(event){
					//Update the drag event (if active)
					if(UI.layoutContainerAsColumns_isDragging === null) return;
					//Position The dragging table
					var xd = UI.layoutContainerAsColumns_isDragging.start_clientX - event.clientX;
					var yd = UI.layoutContainerAsColumns_isDragging.start_clientY - event.clientY;
					var left = UI.layoutContainerAsColumns_isDragging.elm_left - xd;
					var top = UI.layoutContainerAsColumns_isDragging.elm_top - yd;
					UI.layoutContainerAsColumns_isDragging.target.css({
						'left': left+'px',
						'top': top+'px',
					});
					items.each(function(){
						if(this == UI.layoutContainerAsColumns_isDragging.target[0]) return;
						var w = $(this).width();
						var h = $(this).height();
						var x = parseFloat($(this).css('left').replace('px', ''));
						var y = parseFloat($(this).css('top').replace('px', ''));
						if(left >= x && left <= x + w){
							if(top >= y && top <= y + h){
								if(!this.matches('.layoutContainerAsColumns_DragTargetActive')){
									container.find('.layoutContainerAsColumns_DragTargetActive').removeClass('layoutContainerAsColumns_DragTargetActive');
									$(this).addClass('layoutContainerAsColumns_DragTargetActive');
								}
							}
						}
					});
				});
			}
			//Triggered after containers height is changed
			container[0].afterColLayoutHeightChanged = function(){
				if(top !== window){
					top.UI.revalidateFrameSize(window.frameElement);
				}
			};
			//Hook UI Resize event
			container[0].layoutContainerAsColumnsRefresh = (function(){
				if($(this._container).is(':visible') == false) return;
				this._window.UI.layoutContainerAsColumns(this._container.layoutContainerAsColumnsOptions);
			}).bind({_window: window, _container: container[0]});
			UI.resize((function(){ this.layoutContainerAsColumnsRefresh(); }).bind(container[0]));
		}

		//Initalize each item in the layout
		var usedOrderValues = [];
		var items = container.children(options.items);
		items.filter(function(){ return $(this).is('.window_whole_overflow_fix'); }).each(function(){$(this).removeClass('window_whole_overflow_fix').removeClass('window_whole')});
		items.each(function(){
			if(typeof(this.orignalLoadedAsWidth) == 'undefined' || !this.orignalLoadedAsWidth){
				this.orignalLoadedAsWidth = $(this).width();
				if(options.internal_name && !this.matches('.layoutContainerAsColumns_MovableItem')){
					$(this).addClass('layoutContainerAsColumns_MovableItem');
					var th = this.matches('table.report') ? $(this).first().find('th').first() : $(this).find('table.report').first().find('th').first();
					if(th.length == 0) th = this.matches('table.report-light') ? $(this).first().find('th').first() : $(this).find('table.report-light').first().find('th').first();
					var div = $('<div class="layoutContainerAsColumns_MovableItemCtl">').appendTo(th);
					$('<i class="fas fa-arrows-alt">').appendTo(div);
					div.mousedown(function(e){
						if(UI.layoutContainerAsColumns_isDragging === null) functionEndDrag();
						var target = $(this).closest('.layoutContainerAsColumns_MovableItem');
						$(target).addClass('layoutContainerAsColumns_DraggingItem');
						UI.layoutContainerAsColumns_isDragging = {
							dest: null,
							target: target,
							start_clientX: e.clientX,
							start_clientY: e.clientY,
							elm_left: parseFloat(target.css('left').replace('px', '')),
							elm_top: parseFloat(target.css('top').replace('px', '')),
						};
					});
				}
				if(options.order && typeof(options.order[index]) != 'undefined') $(this).attr('layout-order', options.order[index]);
				else if(typeof($(this).attr('layout-order')) == 'undefined') $(this).attr('layout-order', 10000);
			}
			usedOrderValues[index] = parseInt($(this).attr('layout-order'));
			if(this.orignalLoadedAsWidth > col_widths[index % col_count]) col_widths[index % col_count] = this.orignalLoadedAsWidth;
			index++;
		});

		//Define the Ordering
		var ordered_indices = [];//[index-on-page => index-to-show,...]
		{
			var funcGetNextSmallestNumber = function(largerthan){
				var bestFound = null;
				for(var i in usedOrderValues){
					if((bestFound == null || usedOrderValues[i] < bestFound) && (largerthan === null || largerthan === false || usedOrderValues[i] > largerthan)){
						bestFound = usedOrderValues[i];
					}
				}
				return bestFound;
			};
			//Create indexed-order list
			var num = funcGetNextSmallestNumber(null);
			index = 0;
			while(num != null){
				for(var i in usedOrderValues)
					if(usedOrderValues[i] == num){
						ordered_indices.push(parseInt(i));
					}
				num = funcGetNextSmallestNumber(num);
				if(index++ > 1000){
					console.log('[E064644573054689087634]');
					break;
				}
			}
			//Write the new orders to dom
			index = 0;
			items.each(function(){
				$(this).attr('layout-order', ordered_indices.indexOf(index));
				index++;
			});
		}

		//Get Total Width
		var total_width = 0;
		for(var i = 0; i < col_count; i++){
			total_width += col_widths[i];
		}

		//Scale Sizes To Fit-To-Page
		var overflow = 0;
		var k = report_views_width / total_width;
		for(var i = 0; i < col_count; i++){
			col_widths[i] *= k;
			if(col_widths[i] < options.min_report_width){
				overflow += options.min_report_width - col_widths[i];
				col_widths[i] = options.min_report_width;
			}
		}

		//Remove Overflow From avaiable cols
		if(overflow > 0){
			for(var i = 0; i < col_count && overflow > 0; i++){
				if(col_widths[i] > options.min_report_width){
					var avail = col_widths[i] - options.min_report_width;
					if(avail > overflow) avail = overflow;
					overflow -= avail;
					col_widths[i] -= avail;
				}
			}
		}

		//Reduce Col-Count and retry if overflow still exists
		if(col_count > 1){
			//Check for overflow
			var col_widths_total = 0;
			for(var i in col_widths) col_widths_total += col_widths[i];
			if(col_widths_total > container.width()) {
				//Reduce col-count and retry
				UI.layoutContainerAsColumns(options, {col_count: col_count - 1});
				return;
			}
		}

		//Calc Column X positions
		var col_xs = [];
		var next_x = options.margin_left;
		for(var i = 0; i < col_count; i++){
			col_xs.push(next_x);
			next_x += col_widths[i];
		}

		//Set Starting Y Points
		var col_ys = [];
		for(var i = 0; i < col_count; i++) col_ys.push(options.margin_top);

		//Layout the Tables
		container.addClass('layoutContainerAsColumnsContainer');
		index = 0;
		var max_y = 0;

		var callablesRenderWholeWindows = [];
		var flushWholdWindowRenders = function(){
			for(var c in callablesRenderWholeWindows){
				callablesRenderWholeWindows[c]();
			}
			callablesRenderWholeWindows = [];
		};

		items.sort(function(a,b) { return parseInt($(a).attr('layout-order')) > parseInt($(b).attr('layout-order')); }).each(function(){
			if($(this).is(':visible') == false) return;
			var oindex = index;
			var column_index = oindex % col_count;
			
			var renderAsWholeWindow = $(this).is('.window_whole');

			if(!renderAsWholeWindow){
				index++;
				$(this).css({
					width: (col_widths[column_index] - options.row_gap)+'px',
					top: col_ys[column_index]+'px',
					left: col_xs[column_index]+'px',
					position: 'absolute',
				});

				//Check for overflow
				var foundOverflow = false;
				if($(this).width() > col_widths[column_index] + 2){
					foundOverflow = true;
				}
				else {
					$(this).children('*').each(function(){
						if($(this).width() > col_widths[column_index] + 2){
							foundOverflow = true;
							return false;//break;
						}
					});
				}
				//Flag as needing the 'window_whole' layout to fit
				if(foundOverflow) {
					$(this).addClass('window_whole').addClass('window_whole_overflow_fix');
					renderAsWholeWindow = true;
				}
			}

			if(renderAsWholeWindow){
				//Add to list of controls to render when col-index is at zero
				callablesRenderWholeWindows.push((function(){
					var largest = max_y;
					for(var ci in col_ys){
						if(col_ys[ci] > largest) {
							largest = col_ys[ci];
						}
					}
					column_index = 0;
					var w = 0;
					for(var wi in col_widths) w += col_widths[wi];
					index += (col_count - column_index);
					$(this).css({
						width: (w - options.row_gap)+'px',
						top: largest+'px',
						left: col_xs[column_index]+'px',
						position: 'absolute',
					});

					max_y = $(this).height() + options.row_gap + largest;
					for(var cy in col_ys) col_ys[cy] = max_y;
				}).bind(this));
			}

			else {
				var h = $(this).height();
				$(this).attr('layout-row', Math.floor(oindex / col_count)).attr('layout-col', column_index).attr('layout-height', h);
				col_ys[column_index] += h + options.row_gap;
				if(col_ys[column_index] > max_y) max_y = col_ys[column_index];
			}
			
			//Is at col-index 0? Flush all pending 'whole_window' layouts
			if(column_index === 0) flushWholdWindowRenders();

		});

		//Flush any pending 'whole_window' layouts
		flushWholdWindowRenders();

		var containerHeightChanged = max_y != container[0].layoutColContainerHeight;
		if(containerHeightChanged){
			container[0].layoutColContainerHeight = max_y;
			container.css('height', max_y+'px');
		}
		var noAnimation = typeof(options.animate) !== 'undefined' && !options.animate;
		if(!options.container.match('.animateLayout')){
			if(document.readyState == 'loading'){
				$(document).ready(function(){
					if(noAnimation) {
						container.addClass('layoutDocReady');
						if(containerHeightChanged) container[0].afterColLayoutHeightChanged();
					}
					else setTimeout(function(){
						container.addClass('layoutDocReady').addClass('animateLayout');
						if(containerHeightChanged) container[0].afterColLayoutHeightChanged();
					}, 1);
				});
			}
			else if(document.readyState == 'complete'){
				setTimeout(function(){
					if(noAnimation) {
						container.addClass('layoutDocReady');
						if(containerHeightChanged) container[0].afterColLayoutHeightChanged();
					}
					else setTimeout(function(){
						container.addClass('layoutDocReady').addClass('animateLayout');
						if(containerHeightChanged) container[0].afterColLayoutHeightChanged();
					}, 1);
				}, 1);
			}
			if(containerHeightChanged) container[0].afterColLayoutHeightChanged();
		}
		else {
			if(containerHeightChanged) container[0].afterColLayoutHeightChanged();
		}

	},

	makeuitag: function(text, color, background){
		text = text.trim();
		if(text === '') text = '&#62556;';
		var b = $('<span class="npuitag">').html(text.match(/^&#\d+;$/) ? text : $('<span>').html(text).text());
		if(text.match(/^&#\d+;$/)) b.addClass('fa fas');
		b.css('color', '#'+color);
		b.css('background-color', '#'+background);
		return b;
	},

	loadSelectBox_Cache: [],
	loadSelectBox: function(sender, recordType, defaultID, callback){
		if(typeof(sender.matches) == 'undefined' && typeof(sender.length) != 'undefined'){
			if(sender.length == 0) sender.matches = function(){ return false; };
			else sender = sender[0];
		}
		if(typeof(UI.loadSelectBox_Cache[recordType]) == 'undefined'){
			if(sender.matches('.loadonce')) return;
			$(sender).addClass('loadonce');

			UI.loadSelectBox_Cache[recordType] = 'pending';
			$(sender).addClass('loading');
			$.getRetry(CI_BASE_URL+'main/loadSelectBox/'+recordType, function(r){
				//Error, or user may have been logged out, try again later...
				if(r != '' && !r.match(/^<option/)){
					console.log('User may have been logged out, UI.loadSelectBox() failed... Retrying.... [E25406046826]');
					setTimeout(function(){ UI.loadSelectBox(sender, recordType, defaultID, callback); }, 5000);
					return;
				}
				UI.loadSelectBox_Cache[recordType] = r;
				$(sender).html(r).removeClass('loading').val(defaultID);
				$(sender).find('option[value="'+defaultID+'"]').attr('selected', 'SELECTED');
				if(typeof(callback) != 'undefined') callback(sender);
			});
		}
		else if(UI.loadSelectBox_Cache[recordType] == 'pending'){
			setTimeout(function(){ UI.loadSelectBox(sender, recordType, defaultID, callback); }, 100);
		}
		else {
			$(sender).html(UI.loadSelectBox_Cache[recordType]).val(defaultID);
			$(sender).find('option[value="'+defaultID+'"]').attr('selected', 'SELECTED');
			if(typeof(callback) != 'undefined') callback(sender);
		}
	},

	foreachFrameView: function(callable){
		$('iframe.frame-view').each(function(){
			(callable.bind(this))(this.contentWindow, this.contentDocument);
		});
	},

	recoverLogin: function(callback, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		window.np_analytics.event('UI.recoverLogin', event, '', sender);
		var iframe = $('<iframe seemless style="width: 100%; border: 0; box-sizing: border-box; height: 100%;" src="'+CI_BASE_URL+'?recover_login=1&logincompanyid='+window.active_company+'">');
		var diag = $('<div style="padding: 0; overflow: hidden;">').append(iframe);
		iframe.on('load', function(e){
			this.contentWindow.__recover_from_logout_callback = function(){
				diag.dialog('close');
				if(typeof(callback) == 'function') callback();
			};
		});
		diag.dialog({
			modal: true,
			title: STR_LOGIN_REQUIRED,
			width: Math.min($(window).width(), 407),
			height: Math.min($(window).height(), 254),
		});
	},

	setMenuType: function(menuType, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		event.menutype = menuType;
		$('body').attr('np-menu-type', menuType);
		window.np_analytics.event('UI.setMenuType', event, '', sender);
		$('#uiLeftItems > .menu-level-0 > li').removeClass('menu-type-'+UI.menuType);
		$('#uiLeftBar').removeClass('menu-type-'+UI.menuType);
		UI.menuType = menuType;
		$('#uiLeftBarBackground').css('height', '').css('max-height', '');
		$('#uiLeftBar').addClass('menu-type-'+UI.menuType);
		$('#uiLeftItems > .menu-level-0 > li').addClass('menu-type-'+UI.menuType);
		UI.mainMenu.createMenu();
		UI.resize();
	},

	pushMessage: function(html_title, html_body_or_element, buttons, message_type, timeout, clearQueue, useTopMostWindow){
		if(typeof(html_title) != 'string') html_title = '';
		if(typeof(message_type) == 'undefined') message_type = null;
		if(typeof(buttons) == 'undefined') buttons = null;
		if(typeof(buttons) == 'undefined') timeout = null;
		if(typeof(clearQueue) == 'undefined') clearQueue = false;
		if(typeof(useTopMostWindow) == 'undefined') useTopMostWindow = false;
		if(useTopMostWindow && window.UI != top.UI) return top.UI.pushMessage(html_title, html_body_or_element, buttons, message_type, timeout, clearQueue);
		var elm = $('<div class="uiPushMessage">');

		var headerIcon = '';
		if(message_type === 'error') headerIcon = '<i class="fas fa-exclamation-triangle"></i>';
		else if(message_type === 'warning') headerIcon = '<i class="fas fa-exclamation-circle"></i>';
		else if(message_type === 'notice') headerIcon = '<i class="fas fa-info-circle"></i>';
		else if(typeof(message_type) == 'string') headerIcon = message_type;

		if(html_title != '') {
			var header = $('<div class="ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix">');
			if(headerIcon !== '') header.append($(headerIcon));
			header.append($('<span class="ui-dialog-title">').html(html_title));
			header.append($('<button class="ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only ui-dialog-titlebar-close" role="button" aria-disabled="false" title="" onclick="UI.pushMessageClose();"><span class="ui-button-icon-primary ui-icon ui-icon-closethick"></span><span class="ui-button-text"> </span></button>'));
			header.appendTo(elm);
		}
		else if(headerIcon != ''){
			var header = $('<div style="float: left; padding: 12px; font-size: 16pt; display: inline-block;">');
			if(headerIcon !== '') header.append($(headerIcon));
			header.appendTo(elm);
		}
		if(typeof(html_body_or_element) == 'string') elm.html(elm.html() + '<div class="uiPushMessageBody">' + html_body_or_element + '</div>');
		else elm.append($('<div class="uiPushMessageBody">').append(html_body_or_element));
		if(typeof(buttons) == 'object' && buttons !== null){
			var divClearFix = $('<div class="ui-dialog-buttonpane ui-widget-content ui-helper-clearfix">');
			var buttonset = $('<div class="ui-dialog-buttonset">').appendTo(divClearFix);
			var bcount = 0;
			for(var i in buttons){
				bcount++;
				var btn = $('<button type="button" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only" role="button" aria-disabled="false">').appendTo(buttonset);
				$($('<span class="ui-button-text">').text(i)).appendTo(btn);
				btn.on('click', buttons[i]);
			}
			if(bcount > 0) elm.append(divClearFix);
		}
		if(clearQueue) {
			UI.pushMessagesPending = [];
			UI.pushMessageClose();
			UI.uiView.children('div.uiPushMessage:not(.uiPushMessage-Active)').remove();
			var msg = UI.uiView.children('div.uiPushMessage.uiPushMessage-Active');
			if(msg.length > 0){
				msg.attr('class', 'uiPushMessage uiPushMessage-Inactive uiPushMessage-Inactive-Fast');
				setTimeout(function(){
					msg.remove();
				}, 300);
			}
			setTimeout(UI.pushMessageShowNext, 100);
		}
		UI.pushMessagesPending.push({
			type: message_type,
			title: $('<span>').html(html_title).text(),
			content: elm,
			buttons: buttons,
			timeout: timeout,
			fast: clearQueue
		});
		setTimeout(UI.pushMessageShowNext, 1);
	},

	pushMessageShowNext: function(){
		if(window.UI != top.UI) return top.UI.pushMessageShowNext();

		//Nothing to show...
		if(UI.pushMessagesPending.length == 0) return;

		//Waiting of current message...
		if(UI.uiView.children('div.uiPushMessage:not(.uiPushMessage-Inctive)').length > 0){
			setTimeout(UI.pushMessageShowNext, 100);
			return;
		}

		//Show New Message
		var showMsg = UI.pushMessagesPending.shift();
		UI.uiView.append(showMsg.content);
		setTimeout(function(){ showMsg.content.addClass('uiPushMessage-Active'); if(showMsg.fast) showMsg.content.addClass('uiPushMessage-Active-Fast');  }, 1);

		//Timeout?
		if(showMsg.timeout > 0) {
			setTimeout(function(){
				var active = UI.uiView.children('div.uiPushMessage.uiPushMessage-Active');
				if(active.length > 0 && active[0] === showMsg.content[0]){
					UI.pushMessageClose();
				}
			}, showMsg.timeout + 900 /* 800 (Animation Speed) + 50 (uiPushMessage-Active wait) */);
		}
	},

	pushMessageClose: function(){
		if(window.UI != top.UI) return top.UI.pushMessageClose();
		var msg = UI.uiView.children('div.uiPushMessage.uiPushMessage-Active');
		if(msg.length > 0){
			msg.attr('class', 'uiPushMessage uiPushMessage-Inactive');
			setTimeout(function(){
				msg.remove();
			}, 1000);
		}
		setTimeout(UI.pushMessageShowNext, 100);
	},

	alert: function(msg, title, message_type){
		var promise = new PromiseObj();
		promise._dialog = [];
		promise.dialog = (function(data){
			if(typeof(data) == 'function') this._dialog.push(data);
			else for(var i in this._dialog) this._dialog[i](data);
			return this;
		}).bind(promise);
		promise._shown = [];
		promise.shown = (function(data){
			if(typeof(data) == 'function') this._shown.push(data);
			else for(var i in this._shown) this._shown[i](data);
			return this;
		}).bind(promise);
		promise._ok = [];
		promise.ok = (function(data){
			if(typeof(data) == 'function') this._ok.push(data);
			else for(var i in this._ok) this._ok[i](data);
			return this;
		}).bind(promise);

		if(typeof(title) === 'undefined') title = null;
		if(typeof($.ui) === 'undefined'){
			setTimeout((function(){
				window.alert((title != '' ? "["+title+"]\n" : '') + msg);
				this.promise.shown();
				this.promise.ok();
				this.promise.done();
				this.promise.always();
				this.promise.then();
			}).bind({promise: promise}), 10);
		}
		else {
			var buttons = {};
			var lblOK = typeof(window.STR_OK) !== 'undefined' ? window.STR_OK : 'OK';
			buttons['<i class="fas fa-check" style="float: left; color: green; font-size: 1.25em; margin-right: -17px;"></i> ' + lblOK] = (function(){ 
				this.promise.ok();
				this.promise.done();
				this.promise.always();
				this.promise.then();
			}).bind({promise: promise});
			var t = title === null || title === false || title === '' ? (typeof(window.STR_NOTICE) === 'string' ? window.STR_NOTICE : 'Notice') : title;
			var mt = typeof(message_type) === 'undefined' || message_type === null ? 'alert' : message_type;
			var before = (function(){
				var conf = {};
				conf.minHeight = 180;
				var uconf = this.promise.dialog();
				if(typeof(uconf) !== 'object' || uconf === null) uconf = {};
				for(var i in uconf) conf[i] = uconf[i];
				return conf;
			}).bind({promise: promise});
			var after = (function(diag){
				diag.closest('.ui-dialog').children('.ui-dialog-titlebar').children('.ui-dialog-titlebar-close').remove();
				var newBtn = $('<button role="button" aria-disabled="false" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only ui-dialog-titlebar-close"><span class="ui-button-icon-primary ui-icon ui-icon-closethick"></span></button>');
				newBtn.on('click', (function(){ this.promise.ok(); this.diag.dialog('close'); }).bind({diag: diag, promise: promise}));
				diag.closest('.ui-dialog').children('.ui-dialog-titlebar').append(newBtn);
				this.promise.shown();
			}).bind({promise: promise});
			setTimeout((function(){
				UI.dialog(this.t, this.msg, this.buttons, this.mt, this.after, this.before);
			}).bind({t: t, msg: msg, buttons: buttons, mt: mt, after: after, before: before}), 10);
		}
		return promise;
	},

	confirm: function(msg, title, message_type){
		var promise = new PromiseObj();
		promise._dialog = [];
		promise.dialog = (function(data){
			if(typeof(data) == 'function') this._dialog.push(data);
			else for(var i in this._dialog) this._dialog[i](data);
			return this;
		}).bind(promise);
		promise._shown = [];
		promise.shown = (function(data){
			if(typeof(data) == 'function') this._shown.push(data);
			else for(var i in this._shown) this._shown[i](data);
			return this;
		}).bind(promise);
		promise._ok = [];
		promise.ok = (function(data){
			if(typeof(data) == 'function') this._ok.push(data);
			else for(var i in this._ok) this._ok[i](data);
			return this;
		}).bind(promise);
		promise._cancel = [];
		promise.cancel = (function(data){
			if(typeof(data) == 'function') this._cancel.push(data);
			else for(var i in this._cancel) this._cancel[i](data);
			return this;
		}).bind(promise);

		if(typeof(title) === 'undefined') title = null;
		if(typeof($.ui) === 'undefined'){
			setTimeout((function(){
				if(window.confirm((title != '' ? "["+title+"]\n" : '') + msg)){
					this.promise.shown();
					this.promise.ok();
					this.promise.done();
					this.promise.always();
					this.promise.then();
				}
				else {
					this.promise.shown();
					this.promise.cancel();
					this.promise.fail();
					this.promise.always();
					this.promise.then();
				}
			}).bind({promise: promise}), 10);
		}
		else {
			var buttons = {};
			var lblOK = typeof(window.STR_OK) !== 'undefined' ? window.STR_OK : 'OK';
			var lblCancel = typeof(window.STR_CANCEL) !== 'undefined' ? window.STR_CANCEL : 'Cancel';
			buttons['<i class="fas fa-check" style="float: left; color: green; font-size: 1.25em; margin-right: -17px;"></i> ' + lblOK] = (function(){
				this.promise.ok();
				this.promise.done();
				this.promise.always();
				this.promise.then();
			}).bind({promise: promise});
			buttons['<i class="fas fa-times" style="float: left; color: red; font-size: 1.25em; margin-right: -17px;"></i> ' + lblCancel] = (function(){
				this.promise.cancel();
				this.promise.fail();
				this.promise.always();
				this.promise.then();
			}).bind({promise: promise});
			var t = title === null || title === false || title === '' ? (typeof(window.STR_CONFIRM) === 'string' ? window.STR_CONFIRM : 'Confirm') : title;
			var mt = typeof(message_type) === 'undefined' || message_type === null ? 'confirm' : message_type;
			var before = (function(){
				var conf = {};
				conf.minHeight = 220;
				var uconf = this.promise.dialog();
				if(typeof(uconf) !== 'object' || uconf === null) uconf = {};
				for(var i in uconf) conf[i] = uconf[i];
				return conf;
			}).bind({promise: promise});
			var after = (function(diag){
				diag.closest('.ui-dialog').children('.ui-dialog-titlebar').children('.ui-dialog-titlebar-close').remove();
				var newBtn = $('<button role="button" aria-disabled="false" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only ui-dialog-titlebar-close"><span class="ui-button-icon-primary ui-icon ui-icon-closethick"></span></button>');
				newBtn.on('click', (function(){ this.promise.cancel(); this.diag.dialog('close'); }).bind({diag: diag, promise: promise}));
				diag.closest('.ui-dialog').children('.ui-dialog-titlebar').append(newBtn);
				this.promise.shown();
			}).bind({promise: promise});
			setTimeout((function(){
				UI.dialog(this.t, this.msg, this.buttons, this.mt, this.after, this.before);
			}).bind({t: t, msg: msg, buttons: buttons, mt: mt, after: after, before: before}), 10);
		}
		return promise;
	},

	dialog: function(title, msg, buttons, message_type, after_shown, before_shown){
		if(typeof($.ui) === 'undefined'){
			setTimeout((function(){
				UI.dialog(this.title, this.msg, this.buttons, this.message_type, this.after_shown); }
			).bind({title: title, msg: msg, buttons: buttons, message_type: message_type, after_shown: after_shown}), 1500);
			return;
		}
		var headerIcon = '';
		if(message_type === 'error') headerIcon = '<i class="fas fa-exclamation-triangle"></i>';
		else if(message_type === 'warning') headerIcon = '<i class="fas fa-exclamation-circle"></i>';
		else if(message_type === 'notice' || message_type === 'alert') headerIcon = '<i class="fas fa-info-circle"></i>';
		else if(message_type === 'confirm') headerIcon = '<i class="fas fa-question-circle"></i>';
		else if(typeof(message_type) == 'string') headerIcon = message_type;
		var diag = $('<div class="nog-ui-dialog">');
		if(typeof(msg) === 'string') diag.text(msg);
		else diag.append(msg);
		for(var i in buttons){
			if(typeof(buttons[i]) === 'function'){
				var org = buttons[i];
				buttons[i] = (function(){ if(this.org(this.diag) !== false) this.diag.dialog('close'); }).bind({diag: diag, org: org});
			}
		}
		var settings = { modal: true, title: title, buttons: buttons, closeOnEscape: false };
		if(typeof(before_shown) === 'function') {
			var cnf = before_shown();
			for(var c in cnf) settings[c] = cnf[c];
		}
		diag.dialog(settings);
		if(headerIcon !== '' && headerIcon !== null && headerIcon !== false)
			diag.closest('.ui-dialog').find('.ui-dialog-title').html(headerIcon + (headerIcon != '' ? ' ' : '') + $('<span class="np-ui-dialog-title-text">').text(title).html());
		diag.closest('.ui-dialog')
			.children('.ui-dialog-buttonpane')
				.css({padding: 0, width: '100%', margin: 0, border: 0})
				.children('.ui-dialog-buttonset')
					.css({padding: 0, width: '100%', margin: 0, border: 0})
					.children('button')
						.css({width: '100%', margin: 0, borderLeft: 0, borderRight: 0, borderRadius: 0, borderBottom: 0})
						.each(function(){ $(this).children('span').html($(this).text()).css('padding', '10px'); })
						.filter(':last')
							.css('border-bottom', 0);
		if(typeof(after_shown) == 'function') after_shown(diag);
	},

	isDarkMode: function(){
		var style = getComputedStyle(document.body);
		return style.getPropertyValue('--ui-style-is-dark-mode') == '1';
	},

	startChat: function(chat_uuid, opener_ref, mode, ticketid, event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		window.np_analytics.event('UI.startChat', {chat_uuid: chat_uuid, opener_ref: opener_ref, mode: mode, ticketid: ticketid}, '', null);
		if(typeof(mode) !== 'string') mode = '';
		if(typeof(opener_ref) !== 'string') opener_ref = '';
		if(typeof(chat_uuid) == 'undefined') chat_uuid = '';
		if(typeof(ticketid) == 'undefined') ticketid = '';
		if(typeof(UI.chatWindow) !== 'undefined' && UI.chatWindow !== null && (typeof(UI.chatWindow.closed) == 'undefined' || !UI.chatWindow.closed)) return;
		UI.chatWindowUUID = chat_uuid;
		event.chat = {
			uuid: chat_uuid,
			opener_ref: opener_ref,
			mode: mode,
			ticketid: ticketid
		};
		var url = CI_BASE_URL+'support/chatDialog/?&mode='+encodeURIComponent(mode)+'&ticketid='+encodeURIComponent(ticketid)+'&uuid='+encodeURIComponent(chat_uuid)+'&caller=1&opener_ref=' + encodeURIComponent(opener_ref);
		try {
			UI.chatWindow = window.open(url, 'npsupportchat', 'dependent=yes,width=350,height=500,menubar=no,scrollbars=no,resizable=yes,titlebar=no');
		}
		catch(err){ console.log("Failed to open chat window: \"" + err + '" [E170051372203]'); }
		
		var funcOnClose = function(){
			window.np_analytics.event('UI.startChat.funcOnClose', event, '', sender);
			$.ajax({
				url: CI_BASE_URL + 'support/chat/close/',
				dataType: 'json',
				data: {close: 1, chat_uuid: chat_uuid},
				success: function(){ },
				error: function(){ }
			});
			UI.chatWindow = null;
		};

		//Was open window blocked?
		if(typeof(UI.chatWindow) === 'undefined' || UI.chatWindow === null || !UI.chatWindow || typeof(UI.chatWindow.closed)=='undefined' || UI.chatWindow.closed) {
			var iframe = $('<iframe>').attr('src', url+"&tmpl=iframe&isJQDiag=1").css('width', '100%').css('height', '466px').css('border', '0').prop('seemless', true);
			$('<div style="padding: 0; overflow: hidden;">').append(iframe).dialog({model: false, close: funcOnClose, position: ['middle',20], minHeight: 500, maxHeight: 500, minWidth: 350 });
			UI.chatWindow = iframe[0].contentWindow;
		}

		//Close chat on window close
		else {
			UI.chatWindow.addEventListener("beforeunload", funcOnClose);
		}
	},

	onLogOut: function(event, sender){
		if(typeof(event) !== 'object' || event === null) event = {};
		if(typeof(sender) !== 'object') sender = null;
		window.np_analytics.event('UI.onLogOut', event, '', sender);
		window.np_analytics.flush();
		if(typeof(UI.chatWindow) !== 'undefined' && UI.chatWindow !== null) {
			$.ajax({
				url: CI_BASE_URL + 'support/chat/close/',
				dataType: 'json',
				data: {close: 1, chat_uuid: UI.chatWindowUUID},
				success: function(){ },
				error: function(){ }
			});
			try { UI.chatWindow.close(); } catch (err){};
			UI.chatWindow = null;
		}
	},
	
	onSupportOnlineStatusChanged: function(callback){
		if(typeof(callback) === 'undefined'){
			for(var i in UI.onSupportOnlineStatusChanged_Callables){
				UI.onSupportOnlineStatusChanged_Callables[i]();
			}
		}
		else if(typeof(callback) === 'function'){
			UI.onSupportOnlineStatusChanged_Callables.push(callback);
		}
	},

	setSupportOnlineStatus: function(status, event_bubble){
		if(typeof(event_bubble) === 'undefined') event_bubble = true;
		var hasChanged = window.supportOnlineStatus !== status;
		window.supportOnlineStatus = status;
		if(status){
			var elms = $('.support-online-only.support-is-offline, .support-offline-only.support-is-offline, .support-online-only:not(.support-is-online), .support-offline-only:not(.support-is-online)');
			if(elms.length > 0){
				elms.removeClass('support-is-offline').addClass('support-is-online');
				UI.resize();
			}
		}
		else {
			var elms = $('.support-online-only.support-is-online, .support-offline-only.support-is-online, .support-online-only:not(.support-is-offline), .support-offline-only:not(.support-is-offline)');
			if(elms.length > 0){
				elms.removeClass('support-is-online').addClass('support-is-offline');
				UI.resize();
			}
		}
		if(event_bubble){
			//Notify top window
			if(window != top){
				try {
					if(typeof(top.UI) !== 'undefined'){
						top.UI.setSupportOnlineStatus(status);
					}
				}
				catch(err){}
			}
			//Notify sub windows
			else {
				$('.main_index_internal_tab > iframe.frame-view').each(function(){
					try {
						if(typeof(this.contentWindow.UI) !== 'undefined') 
							this.contentWindow.UI.setSupportOnlineStatus(status, false);
					}
					catch(err){}
				});
			}
		}
		if(hasChanged) UI.onSupportOnlineStatusChanged();
	},

	refreshSupportOnlineStatus: function(callback){
		if(typeof(window.refreshSupportChatOnlineStatusIsRunning) !== 'undefined' && window.refreshSupportChatOnlineStatusIsRunning) return;
		if(typeof(window.refreshSupportChatOnlineStatusIsRunning) === 'undefined') window.refreshSupportChatOnlineStatusCallback = [];
		if(typeof(callback) === 'function') window.refreshSupportChatOnlineStatusCallback.push(callback);
		window.refreshSupportChatOnlineStatusIsRunning = true;
		$.ajax({
			url: CI_BASE_URL + 'support/chat/checksupportonlinestatus/',
			method: 'post',
			dataType: 'json',
			data: {},
			success: function(r){
				window.refreshSupportChatOnlineStatusIsRunning = false;
				window.lastIsSupportOnlineCheckTime = Date.now();
				if(window != top) top.lastIsSupportOnlineCheckTime = window.lastIsSupportOnlineCheckTime;
				if(typeof(r) !== 'object' || r === null) return;
				if(typeof(r.data) !== 'object' || r.data === null) return;
				if(typeof(r.data.isSupportOnline) !== 'undefined') {
					if(window.supportOnlineStatus != r.data.isSupportOnline){
						UI.setSupportOnlineStatus(r.data.isSupportOnline);
					}
					for(var i in window.refreshSupportChatOnlineStatusCallback) {
						window.refreshSupportChatOnlineStatusCallback[i](window.supportOnlineStatus);
					}
					window.refreshSupportChatOnlineStatusCallback = [];
				}
				if(typeof(r.table_modified_times) === 'object' && r.table_modified_times !== null)
					UI.setTableModifiedTimes(r.table_modified_times);
			},
			error: function(){
				window.refreshSupportChatOnlineStatusIsRunning = false;
			}
		});
	},

	setTableModifiedTimes: function(table_modified_times){
		var isLoaded = UI.table_modified_times.genuser > 0;
		var changedTables = [];
		for(var k in table_modified_times){
			var v = table_modified_times[k];
			if(typeof(v) === 'string') v = parseInt(table_modified_times[k]);
			if(typeof(UI.table_modified_times[k]) === 'undefined') UI.table_modified_times[k] = 0;
			else if(typeof(UI.table_modified_times[k]) === 'string') UI.table_modified_times[k] = parseInt(UI.table_modified_times[k]);
			if(UI.table_modified_times[k] != v){
				var hadValue = UI.table_modified_times[k] > 0;
				UI.table_modified_times[k] = v;
				if(hadValue) changedTables.push(k);
			}
		}
		if(isLoaded){
			for(var i in changedTables){
				UI.onTableModifiedTimeChange(changedTables[i]);
			}
		}
		if(window !== top) top.UI.setTableModifiedTimes(table_modified_times);
	},

	refreshMainViewChunks: function(){
		$('.html_control_panel[refresh-href]').each(function(){
			var url = $(this).attr('refresh-href');
			var refresh_control_panel_id = $(this).attr('control-panel-id');
			$.ajax({
				url: url,
				data: {refresh_control_panel_id: refresh_control_panel_id},
				method: 'post',
				success: (function(r){
					var p = this.parentElement;
					$('[control-panel-id="'+refresh_control_panel_id+'"]').remove();
					p.innerHTML = p.innerHTML + r;
				}).bind(this),
			});
		});
	},
}

window.np_analytics = {
	_buffer: [],
	_interval: null,
	_isFlushing: false,
	_isSuspended: 0,
	_lastAdd: null,
	_nextViewUUID: 0,
	_flushInterval: 60000,
	disabled: null,
	add: function(data){
		if(top != window) return top.np_analytics.add(data);
		if(!UI.isDocumentReady) return false;
		if(window.np_analytics._isSuspended > 0) return false;
		if(window.np_analytics.disabled) return false;
		if(typeof(data) !== 'object' || data === null) return false;
		if(typeof(data.eventtype) !== 'string') data.eventtype = '';
		if(typeof(data.path) !== 'string') data.path = '';
		if(typeof(data.menuitemtitle) !== 'string') data.menuitemtitle = '';
		if(typeof(data.pagetitle) !== 'string') data.pagetitle = '';
		//Skip duplicate
		if(window.np_analytics._lastAdd !== null) {
			var et1 = window.np_analytics._lastAdd.eventtype.replace('uiTaskBarConvertOld.click', 'a.click').replace('button.click', 'a.click');
			var et2 = data.eventtype.replace('uiTaskBarConvertOld.click', 'a.click').replace('button.click', 'a.click');
			if(et1 === et2){
				if(window.np_analytics._lastAdd.path === data.path){
					if(window.np_analytics._lastAdd.menuitemtitle === data.menuitemtitle){
						if(window.np_analytics._lastAdd.pagetitle === data.pagetitle){
							return false;
						}
					}
				}
			}
		}
		data.clienttime = Date.now();
		if(window.np_analytics._buffer.length > 100) window.np_analytics._buffer.shift();
		window.np_analytics._buffer.push(data);
		window.np_analytics.start_update();
		window.np_analytics._lastAdd = data;
		return true;
	},
	suspend: function(){
		window.np_analytics._isSuspended++;
	},
	resume: function(){
		window.np_analytics._isSuspended--;
		if(window.np_analytics._isSuspended < 0) window.np_analytics._isSuspended = 0;
	},
	event: function(eventtype, event, sendertype, sender){
		if(typeof(event) === 'undefined' || event === null) event = {};
		if(typeof(event.type) !== 'string'){
			if(typeof(window.event) !== 'undefined' && window.event !== null) {
				if(typeof(window.event.type) === 'string' && window.event.type !== 'mousemove'){
					for(var i in window.event) event[i] = window.event[i];
				}
			}
		}
		if(typeof(event.type) !== 'string') event.type = '';
		if(typeof(event.np_analytics_depth) === 'undefined') {
			var _event = event;
			for(var i = 0; i < 32; i++){
				if(typeof(_event.originalEvent) === 'undefined' || _event.originalEvent === null) break;
				_event = _event.originalEvent;
				if(typeof(_event.np_analytics_depth) !== 'undefined') {
					event.np_analytics_depth = _event.np_analytics_depth;
					break;
				}
			}
		}
		if(typeof(event.np_analytics_depth) === 'undefined') {
			event.np_analytics_depth = 0;
		}
		else {
			event.np_analytics_depth++;
		}
		if(typeof(sender) !== 'object' || sender === null) {
			sender = null;
			if(typeof(event) === 'object' && event !== null && typeof(event.target) === 'object') sender = event.target;
		}

		//Skip search input on-change to blank event
		if(sender !== null && sender.id === 'uiSearchSettings' && sender.value === ''){
			return;
		}

		//Tag the active view element with a generated ID
		var viewUUID = null;
		if(typeof(UI.uiViewSection) === 'object' && UI.uiViewSection.length > 0){
			var activeView = UI.uiViewSection.find('div.main_index_page_container > div.main_index_page_active');
			if(activeView.length > 0){
				if(typeof(activeView[0].uiViewSectionUUID) === 'undefined') activeView[0].uiViewSectionUUID = window.np_analytics._nextViewUUID++;
				viewUUID = activeView[0].uiViewSectionUUID;
			}
		}

		//Get Active Tab & Page Title
		var page_title = top.$('#pagetitle').text().trim();
		var menuitem_title = '';
		top.$('#uiLeftItems > .activateMenuItem .itemText > div').each(function(){
			var text = $(this).text();
			if(menuitem_title !== '') menuitem_title += "\n";
			menuitem_title += text;
		});
		menuitem_title = menuitem_title.trim();
		if(menuitem_title === '') menuitem_title = top.$('#uiLeftItems > .activateMenuItem .itemText').text().trim();

		//Skip logging the 'loading' view event
		if(eventtype === 'UI.onViewShown'){
			if(page_title === 'Loading...' || page_title === 'Loading' || page_title === STR_LOADING || page_title === STR_LOADING+"..." || page_title === '') {
				return;
			}
		}

		var imageOrInputImgTagToText = function(elm){
			var img = $(elm);
			var imgTitle = '';

			//Try using <label for="..."> text
			if(typeof(elm.id) === 'string'){
				var lbls = $('label[for="'+elm.id+'"]');
				if(lbls.length > 0 && lastLabelUsed !== lbls[0]) {
					imgTitle = $(lbls[0]).text().trim();
					lastLabelUsed = lbls[0];
				}
			}
			//Try using title="..." text
			if(typeof(imgTitle) !== 'string' || imgTitle.trim() === '' || imgTitle === '[]') {
				imgTitle = img.attr('title');
				if(typeof(imgTitle) !== 'string' || imgTitle.trim() === '' || imgTitle === '[]') {
					//Try using alt="..." text
					imgTitle = img.attr('alt');
					if(typeof(imgTitle) !== 'string' || imgTitle.trim() === '' || imgTitle === '[]') {
						//Try pulling from .buttons table (use text from row below current column)
						var pTable = img.closest('table');
						if(pTable.is('.buttons')){
							var pCell = img.closest('td, th');
							if(pCell.length > 0){
								var cell_index = Array.prototype.indexOf.call(pCell[0].parentNode.children, pCell[0]);
								if(cell_index >= 0){
									var text_cell = null;
									try{text_cell = pCell[0].parentElement.nextElementSibling.children[cell_index]; } catch(err){}
									if(typeof(text_cell) !== 'undefined' && text_cell !== null){
										imgTitle = $(text_cell).text().trim();
									}
								}
							}
						}
						//Try pulling from .form type table (from tr's 1st th)
						else if(pTable.is('.form') || pTable.is('.properties_table')){
							var pCell = img.closest('td, th');
							if(pCell.length > 0){
								var thCell = $(pCell[0].parentElement).find('th');
								if(thCell.length === 0) thCell = $(pCell[0].parentElement).find('td');
								if(thCell !== pCell[0]){
									imgTitle = thCell.text().trim();
								}
							}
						}			
						//Use the img name
						if(typeof(imgTitle) !== 'string' || imgTitle.trim() === '' || imgTitle === '[]') {
							imgTitle = img.attr('src');
							if(typeof(imgTitle) === 'string') {
								imgTitle = imgTitle.replace(/.*\//, '');
							}
						}
					}
				}
			}
			if(typeof(imgTitle) !== 'string') imgTitle = '';
			imgTitle = imgTitle.replace(/[\r\n\t].*$/im, '');
			imgTitle = imgTitle.trim();
			return imgTitle;
		};

		//Get Headers/Groups/Tabs that this item belongs to
		var parents = [];
		var win = window;
		var lastLabelUsed = null;
		var lastCurrentNode = null;
		if(sender !== null && typeof(sender.parentElement) === 'object'){
			var currentNode = sender;
			for(var i = 0; i < 32 && currentNode !== null; i++) {
				if(currentNode === null) break;
				var jqCurrentNode = $(currentNode);
				//Report Table
				if(currentNode.tagName === 'TABLE' && jqCurrentNode.is('.report')){
					var elm = jqCurrentNode.find('th.header');
					if(elm.length > 0) parents.push({type: currentNode.tagName, text: $(elm[0]).text().trim(), ref: '94493'});
				}
				//Report Table (Light/Dashboard)
				else if(currentNode.tagName === 'TABLE' && jqCurrentNode.is('.report-light')){
					var elm = jqCurrentNode.find('th.header');
					if(elm.length == 0) elm = jqCurrentNode.find('th');
					if(elm.length > 0) parents.push({type: currentNode.tagName, text: $(elm[0]).text().trim(), ref: '13214665'});
				}
				//Check for nested iframe content
				else if(currentNode.tagName === 'BODY'){
					if(typeof(win.frameElement) === 'object' && win.frameElement !== null){
						currentNode = frameElement;
						win = win.parent;
					}
					else{
						break;
					}
				}
				//Input
				else if(currentNode.tagName === 'INPUT' || currentNode.tagName === 'TEXTAREA'){
					var itype = $(currentNode).attr('type');
					if(typeof(itype) !== 'string') itype = '';
					if(itype == 'checkbox' || itype == 'radio') {
						parents.push({type: 'value', text: (currentNode.checked ? 'Checked' : 'Unchecked'), ref: '15734144'});
					}
					else if(itype !== 'submit' && itype !== 'image' && itype !== 'button') {
						var val = $(currentNode).val().trim();
						var hasVal = val !== '' && currentNode.value != '0' && currentNode.value !== null;
						parents.push({type: 'value', text: (hasVal ? 'Set' : 'Unset'), ref: '772015'});
					}
					var imgTitle = imageOrInputImgTagToText(currentNode).trim();
					if(imgTitle !== '') {
						parents.push({type: 'input', text: imgTitle, ref: '246105'});
					}
				}
				//Select
				else if(currentNode.tagName === 'SELECT'){
					var option = $(currentNode).find('option[value="'+currentNode.value+'"]');
					if(option.length > 0){
						parents.push({type: 'option', text: $(option[0]).text().trim(), ref: '30583345'});
					}
					var imgTitle = imageOrInputImgTagToText(currentNode).trim();
					if(imgTitle !== '') {
						parents.push({type: 'input', text: imgTitle, ref: '214220236'});
					}
				}
				//Link
				else if(currentNode.tagName === 'A'){

					//Include image inside of targeted a-tag

					//Skip double-tab title, when tab's inner a-tag was clicked
					if($(currentNode.parentElement).is('[role="tab"]')) {
						parents.push({type: 'tabpanel', text: jqCurrentNode.text().trim(), ref: '209235'});
						try { currentNode = currentNode.parentElement.parentElement.parentElement; } catch(err) { currentNode = null; break; }
					}

					//Add as a-tag
					else {
						//Get link's text
						var txt = jqCurrentNode.text().trim();
						if(txt !== '' && txt !== 'x' && txt !== 'X' && txt !== '[]') parents.push({type: 'a', text: txt, ref: '12616'});
						//Append Image as link's text, when link has no text
						else {
							if(i === 0){
								var imgs = $(jqCurrentNode).find('img');
								if(imgs.length > 0){
									var imgTitle = imageOrInputImgTagToText(imgs[0]).trim();
									if(imgTitle !== '') {
										parents.push({type: 'img', text: imgTitle, ref: '11934'});
									}
								}
							}
						}
					}
				}
				//Fieldset
				else if(currentNode.tagName === 'FIELDSET'){
					var elm = jqCurrentNode.find('legend');
					if(elm.length > 0) parents.push({type: 'fieldset', text: $(elm[0]).text().replace(/\t.*$/gm, '').trim(), ref: '12253201'});
				}
				//DD
				else if(currentNode.tagName === 'DD'){
					var elm = jqCurrentNode.prev();
					if(elm.length > 0 && elm[0].tagName === 'DT') {
						var lbl = $(elm[0]).find('label');
						if(lbl.length > 0) {
							if(lbl[0] != lastLabelUsed) {
								parents.push({type: 'setting', text: $(lbl[0]).text().trim(), ref: '5125130'});
								lastLabelUsed = lbl[0];
							}
						}
						else parents.push({type: 'setting', text: $(elm[0]).text().trim(), ref: '1642316'});
					}
				}
				//DT
				else if(currentNode.tagName === 'DT'){
					parents.push({type: 'setting', text: jqCurrentNode.text().trim(), ref: '4024513'});
				}
				//Check attrs
				else {
					//Try 'aria' labelled objects (like tabs)
					var ariaLabel = jqCurrentNode.attr('aria-labelledby');
					if(typeof(ariaLabel) === 'string' && ariaLabel !== ''){
						var ariaRole = jqCurrentNode.attr('aria-role');
						if(typeof(ariaRole) !== 'string') ariaRole = 'aria-labelled';
						var elm = win.$('#'+ariaRole);
						if(elm.length > 0) parents.push({type: ariaRole, aria: true, text: $(elm[0]).text().trim(), ref: '19320681'});
					}
					//TaskBar
					/*else if(jqCurrentNode.is('.uiTaskBar')) {
						parents.push({type: 'taskbar', text: '', ref: '118240200'});
					}*/
					//Dialog
					else if(jqCurrentNode.is('.ui-dialog')) {
						var elm = jqCurrentNode.find('.ui-dialog-title');
						if(elm.length > 0) parents.push({type: 'dialog', text: $(elm[0]).text().trim(), ref: '10424939'});
					}
					//Meta Menu
					else if(jqCurrentNode.is('.menu-meta-drop-menu')) {
						parents.push({type: 'meta-menu', text: '', ref: '167168201'});
					}
					//Fieldset (via .properties_set)
					else if(jqCurrentNode.is('.properties_set')) {
						var elm = jqCurrentNode.find('.properties_set_title');
						if(elm.length > 0) {
							var txt = $(elm[0]).text().trim();
							parents.push({type: 'fieldset', text: txt.replace(/\t.*$/gm, '').trim(), ref: '214137130'});
						}
					}
					//UI Tab set
					else if(jqCurrentNode.is('.ui-tabs')) {
						var elm = jqCurrentNode.find('ul.ui-tabs-nav > li.ui-tabs-active > .ui-tabs-anchor');
						if(elm.length == 0) elm = jqCurrentNode.find('ul.ui-tabs-nav > li.ui-tabs-active');
						if(elm.length > 0) parents.push({type: 'tabpanel', text: $(elm[0]).text().trim(), ref: '19018206'});
					}
					//Meta Menu link
					else if(jqCurrentNode.is('.menu-meta-link-holder')){
						var links = jqCurrentNode.find('a');
						if(links.length > 0 && lastCurrentNode !== links[0]){
							var txt = jqCurrentNode.text().trim();
							if(txt !== '') parents.push({type: 'a', text: txt, ref: '121153230'});
						}
					}
					//Include the 1st entry
					else if(i === 0){
						//Skip form-senders, view-senders, and left-menu senders (as page will duplicate the left menu entry)
						if(currentNode.tagName !== 'FORM' && !jqCurrentNode.is('.menu-level-0') && !jqCurrentNode.is('.main_index_page')) {
							var t = '';
							if(typeof(sendertype) !== 'string' || sendertype === ''){
								if(typeof(currentNode) === 'object' && currentNode !== null){
									if(typeof(currentNode.tagName) === 'string'){
										t = currentNode.tagName.toLowerCase();
									}
								}
							}
							else {
								t = sendertype;
							}
							parents.push({type: t, isFirstInStack: true, text: $(currentNode).text().trim(), ref: '9918613'});
						}
					}
				}
				//Yield next parentElement up the stack
				lastCurrentNode = currentNode;
				if(currentNode.parentElement !== null){
					currentNode = currentNode.parentElement;
				}
				else {
					if(typeof(currentNode._parentElement) === 'object'){
						currentNode = currentNode._parentElement;
					}
					else {
						currentNode = null;
						break;
					}
				}
			}
		}
		parents.push({type: 'page', text: page_title !== '' ? page_title : menuitem_title, ref: '2345837'});
		parents.reverse();

		//Get name
		var sender_name = '';
		if(sender !== null && typeof(sender.name) === 'string') sender_name = sender.name;

		//Build full path string
		var menuPath = [];
		for(var i in parents){
			var text = parents[i].text === '' ? parents[i].type.trim() : parents[i].text.trim();
			text = text.replace(/➜/g, '->').replace(/\s*-?[\t\r\n>:]\s*$/, '').replace(/[\r\n\t].*$/, '').trim();
			if(text !== '') menuPath.push(text);
		}
		menuPath = menuPath.join(' -> ');

		//Resolve href
		var href = typeof(event.href) === 'string' ? event.href.replace(CI_BASE_URL, '!/').replace(NP_BASE_URL, '').trim() : '';
		if(href.match(/^\s*javascript:/i) || href.match(/#/i)) href = '';
		var src = typeof(location.href) === 'string' ? location.href.replace(CI_BASE_URL, '!/').replace(NP_BASE_URL, '').trim() : '';

		//Append to queue
		var data = {eventtype: eventtype, sendertype: sendertype, sendername: sender_name, path: menuPath, pagetitle: page_title, menuitemtitle: menuitem_title, href: href, src: src, depth: event.np_analytics_depth, viewuuid: viewUUID};
		window.np_analytics.add(data);
	},
	flush: function(){
		if(!UI.isDocumentReady) return;
		if(window.np_analytics._isSuspended > 0) return;
		if(window.np_analytics.disabled === true || window.np_analytics.disabled === null) return;
		if(window.np_analytics._buffer.length == 0) return;
		if(window.np_analytics._isFlushing) return;
		window.np_analytics._isFlushing = true;
		var buffer = window.np_analytics._buffer;
		window.np_analytics._buffer = [];
		$.ajax({
			url: CI_BASE_URL + 'support/sendAnalytics/?&tmpl=json&caller=1&ajax=1',
			data: {data: JSON.stringify(buffer)},
			method: 'post',
			dataType: 'json',
			complete: function(){ window.np_analytics._isFlushing = false; }
		});
	},
	update: function(){
		if(!UI.isDocumentReady) return;
		if(window.np_analytics._isSuspended > 0) return;
		if(window.np_analytics.disabled) return;
		if(window.np_analytics._buffer.length == 0) {
			window.np_analytics.stop_update();
			return;
		}
		window.np_analytics.flush();
	},
	start_update: function(){
		if(window.np_analytics.disabled) return;
		if(window.np_analytics._interval !== null) return;
		window.np_analytics._interval = setInterval(window.np_analytics.update, window.np_analytics._flushInterval);
	},
	stop_update: function(){
		window.np_analytics._buffer = [];
		if(window.np_analytics._interval !== null){
			clearInterval(window.np_analytics._interval);
			window.np_analytics._interval = null;
		}
	},
};

var Menu = function(text, _class){
	this.text  = text;
	this.items = [];
	this._class = _class;

	this.createMenu = function(){
		if(UI.menuType == 'mdi'){
			$('#pagetitle').html('');
			$('#uiLeftBarBackground').addClass('mdi-hidden');
			$('.main_index_page').remove();
			$('.mdi-menu-level-0-open-windows').css('display', 'none');
			if($('#uiMDIMenuBar').length === 0){
				$('<div id="uiMDIMenuBar">').insertBefore('#content');
				$('#npLogoHeader').hide();
				$('#uiSearchSettingsContainer').hide();
			}
			if($('#uiMDIMenuOverlay').length === 0){
				$('<div id="uiMDIMenuOverlay">').insertBefore('#content');
			}
			UI.hideSearchBox();
			document.documentElement.style.setProperty('--ui-style-left-menu-background-width', '0px');
			document.documentElement.style.setProperty('--ui-style-left-menu-width', '0px');
		}
		else {

			//Skip if target container doesn't exist
			if($('#uiLeftBar').length == 0) return;

			//Get & Clear Target Container
			$('#uiMDIMenuBar, #uiMDIMenuOverlay').remove();
			$('#uiLeftBarBackground').removeClass('mdi-hidden');
			var oldBackGroundStyle = $('#uiLeftBarBackground').attr('style');
			var eLoc = $('#uiLeftBar').empty()[0];

			//Do not build if menu should be hidden
			if(typeof(UI.hideLeftMenu) != 'undefined' && UI.hideLeftMenu) return;

			//Append The Background Container
			var eBackground = document.createElement('div');
			eBackground.id  = 'uiLeftBarBackground';
			eBackground.setAttribute('style', oldBackGroundStyle);
			eLoc.appendChild(eBackground);

			//Append Company Name to menu
			if(typeof(UI.companyname) != 'undefined'){
				var lblCompName = $('<div>').addClass('menu-left-company-title');
				lblCompName.text(UI.companyname);
				lblCompName.appendTo(eBackground);
				lblCompName.click(function(){ top.UI.toggleUserSettingsPane(this, true); });
			}

			//Append the main menu list container
			var eList = document.createElement('ul');
			eList.id = 'uiLeftItems';
			eBackground.appendChild(eList);
		}

		//Append the main menu items
		UI.createMenu_sub(UI.mainMenu, eList);
	};

	this.addItem = function(menu_item){
		this.items.push(menu_item);
		if(UI.menuType !== 'mdi') this.createMenu(UI.menuType);
		else {
			var openWindowsMenu = $('.mdi-menu-level-0-open-windows');
			openWindowsMenu.css('display', '');
			var menuContainer = $('.mdi-menu-level-0-open-windows .mdi-menu-level-0-contents-inner');
			var menuItem = $('<div class="mdi-menu-level mdi-menu-level-1">').attr('mdi-window-id', 'main_index_page_internal_'+menu_item.internal_frame_id).appendTo(menuContainer);
			var menuItemTitle = $('<div class="mdi-menu-level-title mdi-menu-level-1-title">').appendTo(menuItem);
			menuItemTitle.text(menu_item.text + (menu_item.subTitle != '' ? ' - ' + menu_item.subTitle : ''));
			menuItemTitle.on('click', function(){
				var elm = $('#'+$(this).closest('.mdi-menu-level').attr('mdi-window-id'));
				if(elm.length > 0) {
					elm[0].bringToFront();
					$('.mdi-menu-level-open').removeClass('mdi-menu-level-open');
					$('.mdi-menu-open').removeClass('mdi-menu-open');
					$('#uiMDIMenuOverlay').css('display', 'none');
				}
				else {
					$(this).closest('.mdi-menu-level')[0].remove();
				}
			});
		}
		uiWaitForFinalEvent(UI.onWindowResize, 25, "ID_Resize_WaitA");
	};

	this.removeItem = function(page){
		var found = -1;
		for(var i = 0; i < this.items.length; i++){
			if(this.items[i].link == page){
				found = i;
				break;
			}
		}
		if(found == -1) return;

		this.items.splice(found, 1);

		if(UI.menuType !== 'mdi'){
			this.createMenu(UI.menuType);
			uiWaitForFinalEvent(UI.onWindowResize, 25, "ID_Resize_WaitA");
		}
		else {
			var e = $('.mdi-menu-level-0-open-windows [mdi-window-id="main_index_page_'+page+'"]');
			if(e.length > 0) e[0].remove();
			var elms = $('.mdi-menu-level-0-open-windows [mdi-window-id]');
			if(elms.length === 0){
				$('.mdi-menu-level-0-open-windows').css('display', 'none');
			}
		}
	};
}
var MenuItem = function(text, _class, link, action, subTitle){
	this.text     = text;
	this.subTitle = typeof(subTitle) == 'undefined' ? '' : subTitle;
	this._class   = _class;
	this.link     = link;
	this.action   = typeof(action) == 'undefined' ? false : action;//On Click Function(sender)
	this.menu     = null;
	this.internal_frame_id = null;

	this.getElement = function(){

		var li = document.createElement('li');
		li.internal_frame_id = this.internal_frame_id;
		li.link = this.link;
		li.doDrag = false;
		li.doDragStartX = 0;
		li.doDragStartY = 0;
		$(li).addClass('menu-level-0 menu-left menu-left-level-0 menu-type-'+UI.menuType);
		if(this.action)
			$(li).click(function(e){
				//Close the search
				if(!$('#uiTopBar_QuickSearch').is('.uiTopBarFloatingMenuOpened')){
					top.UI.QuickSearchMenu.isOpen = false;
					top.UI.QuickSearchMenu.Abort();
				}
				UI.MobileHideLeftMenu(false, e, this);
				this.action(e);
		 	});
		else
			$(li).click(function(event){
				if(!event.isDefaultPrevented()){
					//Close the search
					if(!$('#uiTopBar_QuickSearch').is('.uiTopBarFloatingMenuOpened')){
						top.UI.QuickSearchMenu.isOpen = false;
						top.UI.QuickSearchMenu.Abort();
					}

					UI.MobileHideLeftMenu(false, event, this);
					UI.loadFromMainMenu(this.link, this, event);
					event.preventDefault();
				}
			});
		$(li).css('user-select', 'none');
		$(li).css('overflow', 'visible');
		$(li).attr('menu_link', this.link);
		$(li).mouseenter(function(){ UI.animateLeftMenuSizes( $(this).index() );} );

		//Drag & Close Gesture
		li.startDrag = function(x, y){
			if(typeof(this.internal_frame_id) == 'undefined' || this.internal_frame_id == null) return;
			this.doDrag = true;
			this.doDragStartX = x;
			this.doDragStartY = y;
		};
		li.endDrag = function(){
			this.doDrag = false;
			$(this).css('margin-left', '0px');
		};
		li.updateDrag = function(x, y){
			if(!this.doDrag) return;
			var xDiff = x - this.doDragStartX;
			$(this).css('margin-left', xDiff+'px');

			var min = UI.mouseConfirmed ? 24 : 10;

			if(xDiff * -1 > min){
				if(typeof(this.internal_frame_id) != 'undefined')
					UI.closeInternalTab(this.internal_frame_id);
			}
		};
		$(li).mousedown(function(event){ this.startDrag(event.pageX, event.pageY); });
		$(li).mouseleave(function(){ this.endDrag(); });
		$(li).mouseup(function(){ this.endDrag(); });
		$(li).mousemove(function(event){
			var x = event.pageX;
			var y = event.pageY;
			this.updateDrag(x, y);
		});
		$(li).on('touchstart', function(event){
			var x = event.originalEvent.touches[0].pageX;
			var y = event.originalEvent.touches[0].pageY;
			this.startDrag(x, y);
		});
		$(li).on('touchmove', function(event){
			var x = event.originalEvent.touches[0].pageX;
			var y = event.originalEvent.touches[0].pageY;
			this.updateDrag(x, y);
		});
		$(li).on('touchend', function(event){ this.endDrag(); });
		$(li).on('touchleave', function(event){ this.endDrag(); });

		var header = document.createElement('div');
		var headerImage = document.createElement('span');
		var headerText  = document.createElement('span');
		$(headerImage).addClass(this._class);
		$(headerImage).css('user-select', 'none');
		$(header).css('user-select', 'none');
		$(headerText).html(UI.MenuItemGetTabTitleHtml(this.text, this.subTitle));
		$(headerText).addClass('itemText');
		$(headerText).css('user-select', 'none');
		$(li).bind("contextmenu", function(event) {
			event.preventDefault();

			var internal_tab = $(this).find('.internal_tab').length > 0;

			var html = '';
			html += "<div class=\"context-menu\">";
			html += "   <div class=\"context-menu-inner\">";
			if(internal_tab){
				html += "   <a href=\"javascript:void(0);\" onclick=\"$('#main_index_page_"+$(this).attr('menu_link')+"').children('iframe').get(0).contentWindow.location.reload();\">";
				html += "		<img src=\"images/refresh.png\" class=\"context-menu-inner-list-icon\" >";
				html +=         window.STR_REFRESH;
				html += "   </a>";
				html += "   <a onclick=\"UI.closeInternalTab('"+this.internal_frame_id+"'); $($(this).parents('.context-menu')[0]).remove();\" href=\"javascript:void(0);\">";
				html += "		<img src=\"images/closewindow.png\" class=\"context-menu-inner-list-icon\" >";
				html +=         window.STR_CLOSE;
				html += "   </a>";
			}
			else{
				html += "   <a href=\"javascript:void(0);\" onclick=\"UI.browserTab('"+CI_BASE_URL+"main/index/?&menu_page="+$(this).attr('menu_link')+"'); $($(this).parents('.context-menu')[0]).remove();\">";
				html += "		<img src=\"images/add.png\" class=\"context-menu-inner-list-icon\" >";
				html +=         window.STR_OPEN_IN_NEW_TAB;
				html += "   </a>";
			}
			html += "   </div>";
			html += "</div>";

			$(html)
				.appendTo("body")
				.css({top: (event.pageY - 20) + "px", left: (event.pageX - 20) + "px", position: 'fixed'})
				.css('z-index', 9999)
				.mouseover(function(){ this.hasMouse = true; })
				.mouseleave(function(){ if(typeof(this.hasMouse) != 'undefined'){ $(this).remove(); } })
		});

		header.appendChild(headerImage);
		header.appendChild(headerText);
		li.appendChild(header);

		//Close & Refresh Btn
		if(typeof(li.internal_frame_id) != 'undefined' && li.internal_frame_id != null){
			var btnClose = $('<div>');
			btnClose.addClass('menu-left-level-0-close');
			btnClose.text('X');
			btnClose[0].internal_frame_id = li.internal_frame_id;
			btnClose.click(function(){
				UI.closeInternalTab(this.internal_frame_id);
			});
			li.appendChild(btnClose[0]);
			$(li).addClass('menu-left-closable-item');

			var btnRefresh = $('<div><i class="fas fa-sync"></i></div>');
			btnRefresh.addClass('menu-left-level-0-refresh');
			btnRefresh[0].internal_frame_id = li.internal_frame_id;
			btnRefresh.click(function(){
				$('#main_index_page_'+$(this).closest('li').attr('menu_link')).children('iframe').get(0).contentWindow.location.reload();
			});
			li.appendChild(btnRefresh[0]);
		}

		return [li];
	}
}

var MetaMenu = {

	debug_hold_destroy: false,

	processView_createMetaMenus: function(parent){
		if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
		if(typeof(parent) == 'undefined') parent = $('body')[0];
		MetaMenu.processView_createMetaMenus_AutoTagMenuLinks(parent);
		if(window.meta_menu_adv_rights.arinvoice)      $(parent).find('.menu-invoice[menu_id], .menu-arinvoice[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'arinvoice'); });
		if(window.meta_menu_adv_rights.arorder)        $(parent).find('.menu-order[menu_id], .menu-arorder[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'arorder');   });
		if(window.meta_menu_adv_rights.job)            $(parent).find('.menu-job[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'job');});
		if(window.meta_menu_adv_rights.customer)       $(parent).find('.menu-customer[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'customer');});
		if(window.meta_menu_adv_rights.chk)            $(parent).find('.menu-check[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'check');});
		if(window.meta_menu_adv_rights.gltransvoucher) $(parent).find('.menu-voucher[menu_id], .menu-gltransvoucher[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'gltransvoucher');});
		if(window.meta_menu_adv_rights.vendor)         $(parent).find('.menu-vendor[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'vendor');});
		if(window.meta_menu_adv_rights.item)           $(parent).find('.menu-item[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'item');});
		if(window.meta_menu_adv_rights.arordership)    $(parent).find('.menu-shipment[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'arordership');});
		if(window.meta_menu_adv_rights.glbudgets) 	   $(parent).find('.menu-glbudgets[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'glbudgets');});
		if(window.meta_menu_adv_rights.apbill) 	   	   $(parent).find('.menu-apbill[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'apbill');});
		if(window.meta_menu_adv_rights.invpo) 	   	   $(parent).find('.menu-invpo[menu_id]').each(function(){ MetaMenu.metaMenu_Make(this, 'invpo');});
	},
	processView_createMetaMenus_AutoTagMenuLinks: function(parent){
		if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
		if(typeof(parent) == 'undefined') parent = $('body')[0];
		$(parent).find('.report a:not([menu_id]), .dataTable a:not([menu_id]), .report-light a:not([menu_id]), .form a:not([menu_id])').each(function(){
			if(typeof(this.menu_id) == 'undefined'){
				this.menu_id = null;
				if($(this).text() != "" && this.href.indexOf('#') == -1 && this.href.indexOf('javascript:') == -1){
					//Match Orders
					if(user_rights.ar.read)
						if(this.href.match(/(arordshipview\.php)/i) && this.href.match(/[&?](ordershipid)=([^&]*)/i)){
							var id = this.href.match(/[&?](ordershipid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							this.menu_id = id;
							$(this).attr('menu_id', id).addClass('menu-shipment');
							return;
						}
						else if(this.href.match(/(arordshipview\.php|arordpicktick\.php|arserviceordtick\.php|arserviceordupd\.php|nporder\.php)/i)){
							var id = this.href.match(/[&?](id|orderid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							var ordernumber = this.href.match(/[&?]ordernumber=([^&]*)/i);
							ordernumber = ordernumber != null ? ordernumber[1] : null;
							id = id != null ? id : ordernumber;
							this.menu_id = id;
							$(this).attr('menu_id', id).addClass('menu-order');
							return;
						}

					//Match Invoices
					if(user_rights.ar.read)
						if(this.href.match(/(arinvoiceview\.php)/i)){
							var id = this.href.match(/[&?](id|invoiceid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-arinvoice');
							}
							return;
						}

					//Match Jobs
					if(user_rights.ar.read || user_rights.ap.read)
						if(this.href.match(/(jobupd\.php)/i)){
							var id = this.href.match(/[&?](jobid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-job');
							}
							return;
						}

					//Match Checks
					if(user_rights.ap.read)
						if(this.href.match(/(checks\.php)/i)){
							var id = this.href.match(/[&?](checknbr)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-check');
							}
							return;
						}

					//Match Vouchers
					if(user_rights.gl.read)
						if(this.href.match(/(voucherdetail\.php)/i)){
							var id = this.href.match(/[&?](voucherid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-voucher');
							}
							return;
						}

					//Match Items
					if(user_rights.ar.read || user_rights.ap.read || user_rights.inv.read)
						if(this.href.match(/(invitemupd\.php)/i)){
							var id = this.href.match(/[&?](itemid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-item');
							}
							return;
						}

					//Match Customers
					if(user_rights.ar.read)
						if(this.href.match(/(arinvoicerepcust\.php|arcustupd\.php)/i)){
							var id = this.href.match(/[&?](customerid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-customer');
							}
							return;
						}

					//Match Vendors
					if(user_rights.ap.read)
						if(this.href.match(/(apvendupd\.php)/i)){
							var id = this.href.match(/[&?](id)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-vendor');
							}
							return;
						}

					//Match Budgets
					if(user_rights.gl.read)
						if(this.href.match(/(glbudadd\.php|glrepbudvariance\.php)/i)){
							var id = this.href.match(/[&?](glbudgetsid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-glbudgets');
							}
							return;
						}

					//Match Bills
					if(user_rights.ap.read)
						if(this.href.match(/(apbillupd\.php)/i)){
							var id = this.href.match(/[&?](apbillid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-apbill');
							}
							return;
						}

					//Match POs
					if(user_rights.ap.read)
						if(this.href.match(/(invpoupd\.php)/i)){
							var id = this.href.match(/[&?](invpoid)=([^&]*)/i);
							id = id != null ? id[2] : null;
							if(id != null){
								this.menu_id = id;
								$(this).attr('menu_id', id).addClass('menu-invpo');
							}
							return;
						}
				}
			}
		});
	},

	metaMenu_Make: function(elm, type){
		if(typeof(elm.matches) == 'undefined' && typeof(elm.length) != 'undefined'){
			if(elm.length == 0) elm.matches = function(){ return false; };
			else elm = elm[0];
		}
		if(typeof(window.slow_cpu) != 'undefined' && window.slow_cpu) return;
		if(elm.matches('.menu-disabled')) return;
		if(elm.matches('.meta-menu-hooked')) return;
		$(elm).addClass('meta-menu-hooked');

		var isMobileClickShow = elm.matches('.menu-meta-mobile-first');
		var isClickShowAlways = elm.matches('.menu-meta-always');

		var metaLinkContainer = $('<span>');
		metaLinkContainer.addClass('menu-meta-link-holder');
		if(!MetaMenu.debug_hold_destroy){
			metaLinkContainer.click((function(e){
				var showMetaMenuOnClick = this.isClickShowAlways || (this.isMobileClickShow && !UI.mouseConfirmed);

				if(!$(e.target).is('a') || showMetaMenuOnClick){
					e.preventDefault();
					e.stopImmediatePropagation();

					if(showMetaMenuOnClick){
						if($(e.target).is('a')){
							$(e.target.parentNode).find('.menu-meta-drop-icon-span').click();
						}
						else if($(e.target).is('.menu-meta-link-holder')){
							$(e.target).find('.menu-meta-drop-icon-span').click();
						}
					}

					return true;
				}
			}).bind({isMobileClickShow: isMobileClickShow, isClickShowAlways: isClickShowAlways}));
			metaLinkContainer.mouseleave(function(){
				$(this).find('.menu-meta-drop-menu-moat').remove();
				$('.menu-meta-temp-style').each(function(){
					$(this).css('z-index', this.org_z);
					$(this).css('overflow', this.org_overflow);
				});
			});
		}

		$(metaLinkContainer).insertAfter(elm);
		$(metaLinkContainer).prepend($(elm).detach());

		var dropSpan = document.createElement('span');
		dropSpan.metaType = type;
		dropSpan.metaId = $(elm).attr('menu_id');
		$(dropSpan).addClass('menu-meta-drop-icon-span');
		$(dropSpan).attr('menu-menu-extra-uri', $(elm).attr('menu-menu-extra-uri'));
		$(dropSpan).appendTo(metaLinkContainer);
		$(dropSpan).click(function(event){ MetaMenu.metaMenu_DropIcon_OnClick(event, this); });

		var dropIcon = document.createElement('span');
		$(dropIcon).addClass('menu-meta-drop-icon');
		$(dropIcon).appendTo(dropSpan);
	},

	metaMenu_DropIcon_OnClick: function(event, sender){
		if(event.isDefaultPrevented()) return;
		if(typeof(sender.matches) == 'undefined' && typeof(sender.length) != 'undefined'){
			if(sender.length == 0) elm.matches = function(){ return false; };
			else sender = sender[0];
		}
		UI.MobileHideLeftMenu(false, event, sender);
		event.preventDefault();
		event.stopPropagation();

		//Fixup <td> under-flow error
		var tdParent = null;
		var parentNode = sender.parentNode;
		for(var i = 0; i < 4; i++){
			parentNode = parentNode.parentNode;
			if(parentNode.tagName == 'TD' || parentNode.tagName == 'TH'){
				tdParent = parentNode;
				break;
			}
		}
		if(tdParent != null && ($(tdParent).css('z-index') == 'auto' || $(tdParent).css('z-index') == '0' || $(tdParent).css('z-index') == '1' || $(tdParent).css('z-index') == '' || $(tdParent).css('z-index') == null)){
			tdParent.org_z = $(tdParent).css('z-index');
			tdParent.org_overflow = $(tdParent).css('overflow');
			$(tdParent).css('z-index', '2').css('overflow', 'visible').addClass('menu-meta-temp-style');
		}

		//Show Loading Menu...
		var menuMoat = document.createElement('div');
		menuMoat._parentElement = sender;
		$(menuMoat).addClass('menu-meta-drop-menu-moat');
		$(menuMoat).appendTo(sender);

		var menuContainer = document.createElement('div');
		$(menuContainer).addClass('menu-meta-drop-menu menu-meta-drop-menu-loading menu-meta-drop-menu-'+sender.metaType);
		$(menuContainer).text('...');
		$(menuContainer).appendTo(menuMoat);
		$(menuContainer).click(function(event2){
			event2.preventDefault();
		});
		var metaType  = typeof(sender.metaType) == 'undefined' ? $(sender).attr('menu_type') : sender.metaType;
		var metaId    = typeof(sender.metaId)   == 'undefined' ? $(sender).attr('menu_id')   : sender.metaId;
		var menuData  = typeof(sender.menuData) == 'undefined' ? (sender.matches('a') ? $(sender).attr('menu_data') : $(sender).parents('.menu-meta-link-holder').find('a').attr('menu_data')) : sender.menuData;
		var extra_uri = typeof($(sender).attr('menu-menu-extra-uri')) == 'undefined' ? '' : $(sender).attr('menu-menu-extra-uri');
		var url       = CI_BASE_URL+escape(metaType)+'/metaMenu/'+parseInt(metaId)+'/?&tmpl=iframe&_salt='+Math.floor((Math.random()*999999)+1)+(!menuData ? '': '&'+menuData)+extra_uri;

		window.np_analytics.event('metaMenu_DropIcon_OnClick', event, '', sender);

		//Make AJAX Call...
		$.ajax({
			url: url,
			success: function(data, status, XHR){
				$(menuContainer).html(data);

				$(menuContainer).find('a').each(function(){
					var href = $(this).attr('href');

					var target = $(this).attr('target');
					if((typeof(target) == 'undefined')) $(this).attr('newtab', 'newtab');

					if(typeof(href) == 'undefined' || !href.match(/^javascript:/)){
						$(this).click(function(e){
							if(top.UI.mainMenuMode != 'main_index'){
								e.stopPropagation();
							}
							else{
								var target = $(this).attr('target');
								if((typeof(target) != 'undefined' && (target == '_blank' || target == '_new'))){
									top.UI.browserTab(href);
									event.stopImmediatePropagation();
									event.preventDefault();
									event.stopPropagation();
									$('.menu-meta-drop-menu-moat').remove();
									return false;
								}
								else{
									top.UI.open(href);
									event.stopImmediatePropagation();
									event.preventDefault();
									event.stopPropagation();
									$('.menu-meta-drop-menu-moat').remove();
									return false;
								}
							}
						});
					}
				});
				MetaMenu.processView_createMetaMenus($(menuContainer)[0]);
				UI.processView_SetNavHooks();

				//Position Menu
				{
					//Get Bounds
					var wW = UI.window_width;
					var wH = UI.window_height;

					//Get Position On Screen
					var off = $(menuContainer).offset();
					var x = off.left;
					var y = off.top;
					var w = $(menuContainer).width();
					var h = $(menuContainer).height();

					//Flip Left
					if(x+w>wW){
						var marginLeft = w-12;
						if(x - marginLeft < 0){
							marginLeft = x - $('#uiLeftBarBackground').width();
						}

						$(menuContainer).css('margin-left', '-'+marginLeft+'px');
					}

					//Flip Up
					if(y+h>wH){
						if(y-h<0){//Maxed out to top...
							$(menuContainer).css('margin-top', '-'+(y-8)+'px');
							UI.revalidateFrameSize(window.frameElement);
						}
						else{
							$(menuContainer).css('margin-top', '-'+(h+2)+'px');
						}
					}
				}

				$(menuContainer).find('.meta-menu-table-menu-expand').mouseenter(function(){
					var menu = $(this).children('.meta-menu-table-menu-expand-content-moat');
					$(menu).css('margin-left', '0').css('margin-top', '0');

					//Get Bounds
					var wW = UI.window_width;
					var wH = UI.window_height;

					//Get Position On Screen
					var off = $(menu).offset();
					var x = off.left;
					var y = off.top;
					var w = $(menu).outerWidth();
					var h = $(menu).outerHeight();

					//Flip Left
					if(x+w>wW){
						$(menu).css('margin-left', '-'+(w+$(this).outerWidth())+'px');
					}

					//Flip Up
					if(y+h>wH){
						var offY = (wH - (y+h));
						$(menu).css('margin-top', offY+'px');
					}
				});
			},
			error: function(){
				$(menuContainer).text('Connection error, failed to load.');
			}
		});
	}
}

var load = UI.load;
var popup = UI.popup;
top.shiftIsDown = false;
top.ctrlIsDown = false;
top.altIsDown = false;
if(typeof(window.IS_PM) == 'undefined') window.IS_PM = false;
if(typeof(window.IS_B2B) == 'undefined') window.IS_B2B = false;

//Disable JS Animations if is a mobile device or an old (XP) machine
var ua = navigator.userAgent.toLowerCase();
var isAndroid = ua.indexOf("android") > -1;
var isWinXP = ua.indexOf('windows nt 5.1') > 0;
var isIOS = ua.match( /iPad/i ) || ua.match( /iPhone/i ) || ua.match( /iPod/i );
var isWinsTablet = ua.match( /Edge/i ) && (navigator.maxTouchPoints > 1);
window.isMobile = isAndroid || isIOS || isWinsTablet;
if(typeof(window.slow_cpu) == 'undefined') window.slow_cpu = false;

var uiWaitForFinalEvent = (function () {
	var timer_list = {};
	return function (callback, ms, Timer_Id){
		if (!Timer_Id) Timer_Id = "???";
		if (timer_list[Timer_Id]) clearTimeout (timer_list[Timer_Id]);
		timer_list[Timer_Id] = setTimeout(callback, ms);
	};
})();

if(typeof(window.devicePixelRatio) == 'undefined') window.devicePixelRatio = 1;

window.window_open_org = window.open;
window.open = function(url, windowName, windowFeatures){
	if(typeof(url) == 'undefined') url = '';
	if(typeof(windowName) == 'undefined') windowName = '';
	if(typeof(windowFeatures) == 'undefined') windowFeatures = '';
	if(url == 'close.html'){
		if(typeof(window.frameElement) != 'undefined' && window.frameElement != null){
			top.UI.closeInternalTab(window.frameElement.parentNode.id.replace('main_index_page_internal_', ''));
		}
		window.close();
	}
	return window.window_open_org(url, windowName, windowFeatures);
};

window.parse_str = function(str, array) {
	var strArr = String(str).replace(/^&/, '').replace(/&$/, '').split('&'),
		sal = strArr.length,
		i, j, ct, p, lastObj, obj, lastIter, undef, chr, tmp, key, value,
		postLeftBracketPos, keys, keysLen,
		funcUnescapeWithSp = function(str) { return unescape(str.replace(/\+/g, '%20')); };

	if (!array) array = this.window;

	for (i = 0; i < sal; i++) {
		tmp = strArr[i].split('=');
		key = funcUnescapeWithSp(tmp[0]);
		value = (tmp.length < 2) ? '' : funcUnescapeWithSp(tmp[1]);
		while (key.charAt(0) === ' ') key = key.slice(1);
		if (key.indexOf('\x00') > -1) key = key.slice(0, key.indexOf('\x00'));
		if (key && key.charAt(0) !== '[') {
			keys = [];
			postLeftBracketPos = 0;
			for (j = 0; j < key.length; j++) {
				if (key.charAt(j) === '[' && !postLeftBracketPos) postLeftBracketPos = j + 1;
				else if (key.charAt(j) === ']') {
					if (postLeftBracketPos) {
						if (!keys.length) keys.push(key.slice(0, postLeftBracketPos - 1));
						keys.push(key.substr(postLeftBracketPos, j - postLeftBracketPos));
						postLeftBracketPos = 0;
						if (key.charAt(j + 1) !== '[') break;
					}
				}
			}
			if (!keys.length) keys = [key];
			for (j = 0; j < keys[0].length; j++) {
				chr = keys[0].charAt(j);
				if (chr === ' ' || chr === '.' || chr === '[') keys[0] = keys[0].substr(0, j) + '_' + keys[0].substr(j + 1);
				if (chr === '[') break;
			}

			obj = array;
			for (j = 0, keysLen = keys.length; j < keysLen; j++) {
				key = keys[j].replace(/^['"]/, '').replace(/['"]$/, '');
				lastIter = j !== keys.length - 1;
				lastObj = obj;
				if ((key !== '' && key !== ' ') || j === 0) {
					if (obj[key] === undef) obj[key] = {};
					obj = obj[key];
				}
				else {
					ct = -1;
					for (p in obj) {
						if (obj.hasOwnProperty(p)) {
							if (+p > ct && p.match(/^\d+$/g)) {
								ct = +p;
							}
						}
					}
					key = ct + 1;
				}
			}
			lastObj[key] = value;
		}
	}
}

window.initMainUIScriptFunc = function(){
	$(window).resize(function(){ uiWaitForFinalEvent(UI.onWindowResize, 25, "ID_Resize_WaitA"); });
	$(document).ready(UI.onDocumentReady);
	$(document).mousemove(function(e){
		if(typeof(e.originalEvent) != 'undefined') e = e.originalEvent;

		if(!UI.mouseConfirmed){
			//Safari fix to detect mouse, as movementX/movementY is always 0
			if(typeof(e.webkitForce) != 'undefined'){
				var isSafari = /constructor/i.test(window.HTMLElement) || (function (p) { return p.toString() === "[object SafariRemoteNotification]"; })(!window['safari'] || (typeof safari !== 'undefined' && window['safari'].pushNotification));
				var isIPad = /iP(ad|od|hone)/i.test(typeof(Navigator.userAgent) == 'undefined' ? '' : Navigator.userAgent);
				if(isSafari && !isIPad){
					UI.mouseConfirmed = true;
				}
			}

			var x = typeof(e.movementX) != 'undefined' ? e.movementX : (typeof(e.mozMovementX) != 'undefined' ? e.mozMovementX : (-1));
			var y = typeof(e.movementY) != 'undefined' ? e.movementY : (typeof(e.mozMovementY) != 'undefined' ? e.mozMovementY : (-1));
			if(x != 0 || y != 0) UI.mouseConfirmed = true;
		}

		if(!top.had_safe_print && top.had_print && !top.unsafe_print_warning_shown){
			top.unsafe_print_warning_shown = true;
			top.setTimeout(function(){
				top.UI.toggleLinksPane(null, false);
				$('.print_link').css('color', 'red');
				setTimeout(function(){
					alert(STR_TO_ENSURE_A_CORRECT_PRINT_PLEASE_USE_PRINT_FROM_THE_LINKS_MENU);
				}, 10);
				setTimeout(function(){
					$('.print_link').css('color', '');
				}, 3000);
			}, 1);
		}
	});
	$(document).keypress(function(e){ top.UI.HandleGlobalKeyPress(e) });
	$(document).keydown(function(event){
		if(event.which=="16")
			top.shiftIsDown = true;
		else if(event.which=="17")
			top.ctrlIsDown = true;
		else if(event.which=="18")
			top.altIsDown = true;
	});
	$(document).keyup(function(event){
		if(event.which=="16")
			top.shiftIsDown = false;
		else if(event.which=="17")
			top.ctrlIsDown = false;
		else if(event.which=="18")
			top.altIsDown = false;
	});
	$(document).ajaxSuccess(function() { uiWaitForFinalEvent(UI.processView_ajaxSuccess, 50, "ID_AJAX_SUCCCESS_WaitA"); });
	document.addEventListener('pointerdown', function(e){
		if((typeof(e.originalEvent) == 'undefined' || e.target === e.originalEvent.target) && $(e.target).is('.menu-left-company-title') == false && $(e.target).closest('.uiTopBar_FloatingPane, .uiTopBarMenu').length == 0){
			try { top.UI.hideAllMenuPanes(); } catch(e) { }
		}
		UI.mouseConfirmed = true;
	});
	document.addEventListener('touchstart', function(e){
		if((typeof(e.originalEvent) == 'undefined' || e.target === e.originalEvent.target) && $(e.target).is('.menu-left-company-title') == false && $(e.target).closest('.uiTopBar_FloatingPane, .uiTopBarMenu').length == 0){
			try { top.UI.hideAllMenuPanes(); } catch(e) { }
		}
		UI.mouseConfirmed = false;
	});

	window.onbeforeprint = UI.onBeforePrint;
	window.onafterprint = UI.onAfterPrint;

	UI.createMenu();

	if(isIOS) $(document).ready(function(){ $('#iosHeaderGrip').show(); });

	$.fn.org_animate = $.fn.animate;
	if(isAndroid || isWinXP || isIOS || window.slow_cpu || window.isMobile){
		(function ($) {
			$.fn.animate = function(props, duration, easing, callback) {
				$(this).css(props);
				if(typeof(callback) != 'undefined'){
					(callback.bind(this))();
				}
			};
		})(jQuery);
	}

	if(window.isMobile) {
		$('<style>table.mobile_collapse { display: none; } table.mobile_collapse_control .mobile_collapse_excluded { display: none; } </style>').appendTo($('head'));

		var funcInitMobileWindow = function(){
			var orgCloseAction = typeof(window.closeAction) != 'undefined' ? window.closeAction : function(){ return true; };
			window.closeAction = function(){
				location.href = CI_BASE_URL;
				return orgCloseAction();
			}
			document.documentElement.style.setProperty('--ui-style-left-menu-background-width', '0px');
			document.documentElement.style.setProperty('--ui-style-left-menu-width', '0px');
		};
		if(document.readyState !== 'complete') $(document).ready(funcInitMobileWindow);
		else funcInitMobileWindow();

		//Append Close to frame
		$(document).ready(function(){
			UI.addTaskbarItem(window.STR_CLOSE, 'images/closewindow.png', null, null, function(event){
				location.href = CI_BASE_URL;
			}, true);
			UI.addTaskbarItem(window.STR_REFRESH, '<i class="fas fa-sync"></i>', null, null, function(event){
				location.reload();
			}, true);
			UI.onWindowResize_UpdateUITaskBar();
		});

	}

	//Custom Printing Method
	jQuery(document).bind("keyup keydown", function(e){
		if(msieversion() != false) return;
		if((e.ctrlKey || e.metaKey) && e.keyCode == 80){
			e.preventDefault();
			e.returnValue = false;
			if(e.type == 'keydown')
				top.window.print();
			return false;
		}
	});

	if(typeof(top.had_safe_print) == 'undefined') top.had_safe_print = false;
	if(typeof(top.had_print) == 'undefined') top.had_print = false;
	if(typeof(top.unsafe_print_warning_shown) == 'undefined') top.unsafe_print_warning_shown = false;
	window.org_print = window.print;
	window.print = function(){
		top.had_safe_print = true;

		var frame = $('.main_index_page_active > iframe.frame-view:visible');
		if(frame.length > 0){
			frame[0].contentWindow.focus();
			frame[0].contentWindow.print();
		}
		else
			window.org_print();
	};
	window.msieversion_cache = null;
	window.msieversion = function() {
		if(window.msieversion_cache !== null) return window.msieversion_cache;

		if(navigator.appName == "Netscape"){
			if(navigator.appVersion.indexOf('Safari') != -1) return false;
			else if(window.navigator.userAgent.indexOf('Firefox') != -1) return false;
			else if(window.navigator.userAgent.indexOf('Chrome') != -1) return false;
			else if(navigator.appVersion.indexOf('Trident') === -1) window.msieversion_cache = 12;
			else window.msieversion_cache = 11;
		}
		else{
			var ua = window.navigator.userAgent;
			var msie = ua.indexOf("MSIE ");
			if (msie > 0) window.msieversion_cache = parseInt(ua.substring(msie + 5, ua.indexOf(".", msie)));
			else window.msieversion_cache = false;
		}
		return window.msieversion_cache;
	};

	$.fn.animateRotate = function(angle, duration, easing, complete) {
		var args = $.speed(duration, easing, complete);
		var step = args.step;
		var last_offset = typeof(this._animateRotate_last_offset) == 'undefined' ? 0 : this._animateRotate_last_offset;
		return this.each(function(i, e) {
			args.complete = $.proxy(args.complete, e);
			args.step = function(now) {
			this._animateRotate_last_offset = now+last_offset;
			$.style(e, 'transform', 'rotate(' + (this._animateRotate_last_offset) + 'deg)');
			if (step) return step.apply(e, arguments);
			};

			$({deg: 0}).animate({deg: angle}, args);
		});
	};

	window.prefix_uuid = (new Date()).getTime();
	window.next_uuid = 0;
	window.get_uuid = function(){
		return 'uuid_'+window.prefix_uuid+"_"+(++window.next_uuid);
	};

	$.fn.OnTransitionEnd = function(callable){
		var transitionEndEventName = '';
		var agents = {
			"transition": "transitionend",
			"WebkitTransition": "webkitTransitionEnd",
			"OTransition": "oTransitionEnd",
			"MozTransition": "transitionend",
		};
		for(var n in agents)
			if(typeof(document.body.style[n]) != 'undefined'){
				transitionEndEventName = agents[n];
				break;
			}
		if(transitionEndEventName == '') return;

		for(var i = 0; i < this.length; i++){
			var callback = function(){ };
			callback = (function(){
				this.removeEventListener(transitionEndEventName, callback);
				callable();
			}).bind(this[i]);
			this[i].addEventListener(transitionEndEventName, callback);
		}

		return this;
	};

	//Trigger Frame's OnLoad UI Event
	if(frameElement !== null && typeof(frameElement.uiScriptLoaded) != 'undefined') {
		if(document.readyState !== 'complete') $(document).ready(frameElement.uiScriptLoaded);
		else frameElement.uiScriptLoaded();
	}

	window.seachAndRefreshBindEvents = function(){
		$('.css-search-and-refresh-control:not(.event-bound)').each(function(){
			$(this).addClass('event-bound');

			$(this).mouseover(function(){
				if(!$(this).is('.refresh'))
					$(this).addClass('refresh')
			});
			$(this).mouseleave(function(){
				if($(this).is('.refresh'))
					$(this).removeClass('refresh')
			});
		});
	}

};

//Copy top window vars
if(window != top) {
	try {
		if(typeof(top.lastIsSupportOnlineCheckTime) !== 'undefined') window.lastIsSupportOnlineCheckTime = top.lastIsSupportOnlineCheckTime;
	}
	catch(err){ }
}

//Init the class once jQuery & General.js is ready
if(typeof($) !== 'undefined' && (typeof($.fn) === 'undefined' || typeof(foreachSelectorIn) === 'undefined')){
	window.funcTryLoadUIScript = null;
	window.funcTryLoadUIScript = function(){
		$(document).ready(function(){
			if(typeof(foreachSelectorIn) === 'undefined') setTimeout(window.funcTryLoadUIScript, 10);
			else window.initMainUIScriptFunc();
		});
	};
	window.funcTryLoadUIScript();
}
else {
	window.initMainUIScriptFunc();
}