var userActivityTimeout = {
	secondsRemaining:null,//from php
	lastCheckedTime:null,//js time of last ajax call
	warningLead:120,//how many seconds before timeout do we show the warning?
	interval:null,
	warningInProgress:false,
	warningTextGeneral:'',
	warningTextTitle:'',
	warningTextRemaining:'',
	warningTextRenew:'',
	warningTextLogout:'',
	warningChecks:0,
	warningShown:false,
	autoRenewSession:false,
	initDelayed:function(){
		setTimeout(userActivityTimeout.init, 2000);
	},
	init:function(){
		//force startup settings
		if(this.interval) clearInterval(this.interval);
		if(this.warningShown && typeof($) != 'undefined') $(".ui-dialog-content").dialog("close");
		this.warningShown = false;
		this.warningInProgress = false;
		
		//don't run unless this is the top window
		if(self != top) return null;
		
		//set current time for accurate internal tracking
		this.lastCheckedTime = (new Date()).getTime();//this one is usually a couple seconds late from server, it'll correct itself
		
		//call to get time remaining if was not set by php
		if(this.secondsRemaining === null) this.getSecondsRemaining();
		
		//start an interval that checks actual time to when response received, not number of intervals called
		this.interval = setInterval('userActivityTimeout.checkRemaining();',1000);
	},
	checkRemaining:function(){
		//ignore if secondsRemaining has not been set yet or warning is in progress
		if(this.secondsRemaining === null || this.warningInProgress) return null;
		
		//see how much time has passed while running, compare to secondsRemaining
		var inferredSecondsRemaining = this.secondsRemaining - (((new Date()).getTime() - this.lastCheckedTime) / 1000);
		
		//console.log(inferredSecondsRemaining);
		
		//when it hits the warning window, confirm time remaining before showing warning
		if(inferredSecondsRemaining <= this.warningLead){
			this.warningInProgress = true;
			this.getSecondsRemaining();
		}
	},
	initWarning:function(){

		if(userActivityTimeout.autoRenewSession) return userActivityTimeout.checkin();

		//clear checkRemaining interval, start a new one for checkWarning
		clearInterval(this.interval);
		
		//show the warning and start checkWarning
		if(typeof($) == 'undefined') return;
		var warningDiv = $('<div/>').html(this.warningTextGeneral+'<br/><br/>'+this.warningTextRemaining+': <span class="userActivityTimeoutRemaining">'+this.formatSecToMin(this.secondsRemaining)+'</span>');
		$(warningDiv).dialog({
			modal:true,
			title:this.warningTextTitle,
			minWidth:400,
			minHeight:200,
			closeOnEscape:false,
			dialogClass:'no-close',
			buttons:[{
				text:this.warningTextRenew,
				click:function(){
					userActivityTimeout.checkin();
				}
			},{
				text:this.warningTextLogout,
				click:function(){
					userActivityTimeout.logout();
				}
			}]
		});
		
		//start checkwarning
		this.warningShown = true;
		this.warningChecks = 0;
		this.interval = setInterval('userActivityTimeout.checkWarning();',1000);
	},
	checkWarning:function(){
		//see how much time has passed while running, compare to secondsRemaining
		var inferredSecondsRemaining = this.secondsRemaining - (((new Date()).getTime() - this.lastCheckedTime) / 1000);
		
		//check if need to log out first
		if(inferredSecondsRemaining <= 0){
			this.logout();
			return null;
		}
		
		//check if session renewed, start over
		if(inferredSecondsRemaining > this.warningLead){
			this.init();
			return null;
		}
		
		//update remaining timer
		if(typeof($) == 'undefined') return;
		$('.userActivityTimeoutRemaining').html(this.formatSecToMin(inferredSecondsRemaining));
		
		//check with server more as time expires
		if(inferredSecondsRemaining <= 110 && this.warningChecks < 1){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 100 && this.warningChecks < 2){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 90 && this.warningChecks < 3){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 80 && this.warningChecks < 4){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 70 && this.warningChecks < 5){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 60 && this.warningChecks < 6){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 50 && this.warningChecks < 7){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 40 && this.warningChecks < 8){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 35 && this.warningChecks < 9){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 30 && this.warningChecks < 10){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 25 && this.warningChecks < 11){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 20 && this.warningChecks < 12){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 15 && this.warningChecks < 13){
			this.warningChecks++;
			this.getSecondsRemaining();
		}
		if(inferredSecondsRemaining <= 10 && this.warningChecks < 14){
			this.warningChecks++;
			this.getSecondsRemaining();
		} else if(inferredSecondsRemaining < 10){
			this.getSecondsRemaining();
		}
	},
	getSecondsRemaining:function(){
		//update object with ajax, possibly trigger warning
		if(typeof($) == 'undefined') return;
		$.ajax({
			url:CI_BASE_URL+'useractivitytimeout/getSecondsRemaining/?&NO_USER_ACTIVITY=1'
		}).done(function(actualSecondsRemaining){
			if(typeof(actualSecondsRemaining) != 'number'){
				if(typeof(actualSecondsRemaining) == 'undefined' || actualSecondsRemaining == null || typeof(actualSecondsRemaining.indexOf) == 'undefined') return;
				if(!actualSecondsRemaining.match(/^[0-9\-\.]+$/)) return;
				actualSecondsRemaining = parseInt(actualSecondsRemaining);//this needs to turn the login page into a 0 response
			}
			if(isNaN(actualSecondsRemaining)) actualSecondsRemaining = -99;
			userActivityTimeout.lastCheckedTime = (new Date()).getTime();
			userActivityTimeout.secondsRemaining = actualSecondsRemaining;
			if(actualSecondsRemaining <= userActivityTimeout.warningLead){
				if(userActivityTimeout.warningInProgress && !userActivityTimeout.warningShown){
					userActivityTimeout.initWarning();
				}
			} else {
				userActivityTimeout.warningInProgress = false;
			}
		});
	},
	checkin:function(){
		if(typeof($) == 'undefined') return;
		//renew the session for the user
		$.ajax({
			url:CI_BASE_URL+'useractivitytimeout/getSecondsRemaining/'
		}).done(function(actualSecondsRemaining){
			userActivityTimeout.lastCheckedTime = (new Date()).getTime();
			userActivityTimeout.secondsRemaining = actualSecondsRemaining;
			userActivityTimeout.init();//start over
		});
	},
	logout:function(){
		//redirect to logout page
		clearInterval(this.interval);
		if(top.UI && top.UI.warnOnWindowUnload) top.UI.warnOnWindowUnload = false;
		top.window.location.href = NP_BASE_URL+'?logout=1&NO_USER_ACTIVITY=1';
	},
	formatSecToMin:function(seconds){
		if(seconds <= 0) return '0:00';
		seconds = parseInt(seconds);
		var minutes = Math.floor(seconds / 60);
		seconds = (seconds % 60);
		return minutes+':'+(seconds<10?'0':'')+seconds;
	}
}

if (document.readyState === "complete" || document.readyState === "loaded") userActivityTimeout.initDelayed();
else document.addEventListener('DOMContentLoaded', userActivityTimeout.initDelayed);