<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
* osCommerce Order Management v2.12                                  *
* (C) 2006 Stone Edge Technologies Inc.  All rights reserved.        *
*                                                                    *
* Processes requests for data transfer between osCommerce's          *
* backend and the Order Manager. Follows XML specifications.         *
* By Mark Setzer, June 2003 for use with osCommerce v2.2 MS2.        *
*                                                                    *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

define('API_KEY', '');
if (!isset($_REQUEST['api_key']) || $_REQUEST['api_key'] != API_KEY || API_KEY == '') {
	sendHeader();
	echo "<SETIFailure><Response><ResponseCode>5</ResponseCode><ResponseDescription>Invalid API Key</ResponseDescription></Response></SETIFailure>";
	die();
}

// Suppress E_NOTICE errors from PHP. (recommended)
error_reporting(E_ERROR | E_PARSE);

// Pull site configuration variables from osCommerce. (recommended)
require('includes/configure.php');
include('includes/database_tables.php');

// Include the standard payment method language files (if available)
$language = "english"; // name of folder containing local language files
@include_once "includes/languages/$language/modules/payment/authorizenet.php";
@include_once "includes/languages/$language/modules/payment/cc.php";
@include_once "includes/languages/$language/modules/payment/moneyorder.php";
@include_once "includes/languages/$language/modules/payment/cod.php";
@include_once "includes/languages/$language/modules/payment/paypal.php";
@include_once "includes/languages/$language/modules/payment/payflowpro.php";

// Override language settings?
define('LANGUAGE_ID', 1); // (default 1, English)
define('AUTHNET_TITLE', MODULE_PAYMENT_AUTHORIZENET_TEXT_TITLE);
define('PAYFLOW_TITLE', MODULE_PAYMENT_PAYFLOWPRO_TEXT_TITLE);
define('MONEYORDER_TITLE', MODULE_PAYMENT_MONEYORDER_TEXT_TITLE);
define('COD_TITLE', MODULE_PAYMENT_COD_TEXT_TITLE);
define('CC_TITLE', MODULE_PAYMENT_CC_TEXT_TITLE);
define('PAYPAL_TITLE', MODULE_PAYMENT_PAYPAL_TEXT_TITLE);

// Limit imported orders to the following status code (-1 = all, default all)
define('USE_STATUS', -1);

// Which tax class should your products have to be considered "Taxable Goods"? (default 1)
define('TAXABLE_GOODS', 1);

// Import all product tax classes or only a specific one? (-1 = all, default all)
define('TAX_CLASS_TO_IMPORT', -1);

// Update order status after import? (default false)
define('UPDATE_ORDER_STATUS', true);

// Order status ID for updated status? (default 2, "Processed")
define('UPDATE_STATUS_TO', 2);

// Consider the customer notified when doing so? (1 = yes, 0 = no; default 0 - set to 1 if automatically e-mailing confirmations from OM)
define('UPDATE_STATUS_CUSTOMER_NOTIFIED', 1);

// Delete credit card numbers after import? (default false)
define('DELETE_CC', false);

// Date formatting? 
//define('DATESTRING_PHP', 'F d, Y H:i:s'); 	// (PHP syntax, default is 'd F Y H:i:s' and produces dates like '11 November 1918 11:00:00')
//define('DATESTRING_MYSQL', '%M %d, %Y %T');	// (MySQL syntax, default is '%d %M %Y %T')
define('DATESTRING_PHP', 'Y-m-d H:i:s');
define('DATESTRING_MYSQL', '%Y-%m-%d %H:%i:%s');

// Customer checkout comments (default '---')
define('COMMENTS_SEPARATOR', '---');

// Call requested function; authenticate if necessary
$debug = (isset($_REQUEST["debug"]) ? true : false);
$function = strtolower($_REQUEST["setifunction"]);
if ($function == "downloadorders") {
	//check_secure();
	authenticate();
	downloadorders();
	exit();
} elseif ($function == "sendversion") {
	sendversion();
} else {
	authenticate();
	switch ($function) {
		case "ordercount":
			itemcount("orders");
			break;
		case "getproductscount":
			itemcount("products");
			break;
		case "getcustomerscount":
			itemcount("customers");
			break;
			
		case "downloadqoh":
			downloadQOH();
			break;
		case "invupdate":
			$input = explode("~", $_REQUEST['update']);
			invupdate($input[0], $input[1]);
			break;
		case "qohreplace":
			$update = explode("|", $_REQUEST['update']);
			echo "SETIResponse\r\n";
			$count = count($update);
			for ($n=0; $n < $count; $n++) 
			{
				$input = explode("~", $update[$n]);
				if (isset($input[0]) && isset($input[1]))
					qohreplace($input[0], $input[1]);
			}
			echo "SETIEndOfData\r\n";
			break;
		
		case "downloadprods":
			downloadprods();
			break;
		case "downloadcustomers":
			downloadcustomers();
			break;
		case "updatestatus":
			updatestatus();
			break;
		default:
			echo "SETIError: Function '$function' is invalid.";
			break;
	}
}

function authenticate () {
	// Username and Password (from Order Manager)
	$user = $_REQUEST['setiuser'];
	$pass = $_REQUEST['password'];
	
	$db = mysql_connect(DB_SERVER, $user, $pass) or die("SETIError: Invalid username or password!");
	mysql_select_db(DB_DATABASE,$db) or die("SETIError: Could not connect to database.");

	return;
}

function check_secure () {
	global $debug;
	if ($debug) print_r($_SERVER);
	if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] != '1') && ($_SERVER['HTTPS'] != 'on')) { die("SETIError: Connection not secure; aborting"); } 
	elseif (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] != 443) { die("SETIError: Connection not secure; aborting");}
	return;
}

function url_encode ($text) {
	$text = str_replace("&#39", "&apos;", $text); // apostrophe
	$text = str_replace("<", "&lt;", $text); // less-than
	$text = str_replace(">", "&gt;", $text); // greater-than
	$text = str_replace("&", "&amp;", $text); // ampersand
	$text = str_replace("\"", "&quot;", $text); // double quotation
	$text = str_replace("'", "&apos;", $text); // apostrophe
	return $text;
}

function sendVersion () {
	echo "SetiResponse: Version=2.12";
	return;
}

function sendHeader () {
	header("Content-Type: text/xml");
	echo "<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>\r\n";
	return;
}

function downloadQOH () {
	global $debug;
	
	$startnum =  (isset($_REQUEST[startnum]) ? ((int)$_REQUEST[startnum] > 0 ? (int)$_REQUEST[startnum] - 1 : 0) : 0);
	$batchsize = (isset($_REQUEST[batchsize]) ? $_REQUEST[batchsize] : 100);

	$xmloutput = "<SETIProducts>\r\n";
	
	$sql = "SELECT products_model, products_quantity FROM " .TABLE_PRODUCTS. " ORDER BY products_id LIMIT $startnum,$batchsize";
	if ($debug) { echo "Executing SQL: $sql\r\n"; }
	$result = mysql_query($sql) or die("SETIError: MySQL Error in downloadQOH(): Server failed to list products.");
	
	if (@mysql_num_rows($result) > 0) {
		$xmloutput .= "<Response>"
					. "<ResponseCode>1</ResponseCode>"
					. "<ResponseDescription>Success</ResponseDescription>"
					. "</Response>\r\n";			
		while ($row = mysql_fetch_assoc($result)) {
			$xmloutput .= "<Product>"
						. "<Code>" .url_encode($row["products_model"]). "</Code>"
						. "<QOH>" .url_encode($row["products_quantity"]). "</QOH>"
						. "</Product>\r\n";
		}
	} else {
		$xmloutput .= "<Response>"
					. "<ResponseCode>2</ResponseCode>"
					. "<ResponseDescription>Success</ResponseDescription>"
					. "</Response>\r\n";
	}

	$xmloutput .= "</SETIProducts>";

	sendHeader();
	echo $xmloutput;

	return;
}

function itemcount($which) {
	global $debug;
	$sql = "SELECT COUNT(*) as cnt FROM ";
	switch ($which) {
		case "orders":
			$txt = "ordercount";
			$lastorder = (isset($_REQUEST['lastorder']) ? $_REQUEST['lastorder'] : 0);
			if (strtoupper($lastorder) == "ALL") { $lastorder = 0; }
			$sql .= TABLE_ORDERS
				. ((USE_STATUS >= 0) ? " WHERE orders.orders_status = ".USE_STATUS. " AND" : " WHERE")
				. " orders_id > $lastorder";
			break;
		case "products":
			$txt = "itemcount";
			$sql .= TABLE_PRODUCTS;
			break;			
		case "customers":
			$txt = "itemcount";
			$sql .= TABLE_CUSTOMERS;
			break;
		default:
			echo "SETIError: Invalid count command: '$which'.";
			return;
			break;
	}
	if ($debug) { echo "itemcount SQL: $sql\r\n"; }
	
	$r = mysql_query($sql) or die("SETIError: [itemcount] Count for $txt failed; SQL: '$sql', Error: ".mysql_error());
	$count = mysql_result($r, 0);
	echo "SETIResponse: $txt=$count";
	return;
}

function invupdate ($sku, $qoh) {
	global $debug;
	if ($debug) { echo "SKU: $sku, QOH delta: $qoh\r\n"; }
	$sql = "SELECT products_id FROM " . TABLE_PRODUCTS . " WHERE products_model='$sku'";
	$r = mysql_query($sql);
	if ((int)@mysql_num_rows($r) < 1) {
		echo "SETIResponse = False;SKU=$sku;Note=ProductNotFound";
	} else {
		$id = mysql_result($r, 0); if ($debug) { echo "id: $id\r\n"; }
		$sql = "UPDATE " .TABLE_PRODUCTS. " SET products_quantity = products_quantity + '$qoh', products_last_modified = NOW() WHERE products_id=$id";
		mysql_query($sql) or die("SETIError: Could not update inventory: ".mysql_error());
		$sql = "SELECT products_model, products_quantity FROM " . TABLE_PRODUCTS . " WHERE products_id=$id";
		$row = mysql_fetch_assoc(mysql_query($sql));
		$qoh = (int)$row["products_quantity"];
		
		// Change status based on QOH
		if ($qoh < 1) { $active = 1; } else { $active = 1; }
		if ($debug) { echo "active: $active\r\n"; }
		$sql = "UPDATE " .TABLE_PRODUCTS. " SET products_status = $active WHERE products_id=$id";
		mysql_query($sql) or die("SETIError: Could not activate product '$sku': " .mysql_error());
		echo "SETIResponse=OK;SKU=$sku;QOH=$qoh";
	}
	return;
}

function qohreplace ($sku, $qoh) {
	global $debug;
	if ($debug) { echo "SKU: $sku, New QOH: $qoh\r\n"; }
	$r = mysql_query("SELECT products_id FROM " .TABLE_PRODUCTS. " WHERE products_model='$sku'");
		
	if ((int)@mysql_num_rows($r) < 1) {
		echo "$sku=NF" . "\r\n";
	} else {
		$id = mysql_result($r, 0); if ($debug) { echo "id: $id\r\n"; }
		if ($qoh < 1) { $active = 0; } else { $active = 1; }
		$sql = "UPDATE " .TABLE_PRODUCTS. " SET products_quantity = '$qoh', products_last_modified = NOW(), products_status = $active WHERE products_id=$id";
		mysql_query($sql) or die("SETIError: Update failed - SQL error.");
		echo "$sku=OK" . "\r\n";
	}
	return;
}

function downloadcustomers () {
	global $debug;
	
	$startnum =  (isset($_REQUEST[startnum]) ? ((int)$_REQUEST[startnum] > 0 ? (int)$_REQUEST[startnum] - 1 : 0) : 0);
	$batchsize = (isset($_REQUEST[batchsize]) ? $_REQUEST[batchsize] : 100);

	sendHeader();
	echo "<SETICustomers>";
	
    $sql = "SELECT ".TABLE_CUSTOMERS.".customers_id, customers_email_address, customers_password, customers_firstname, customers_lastname, customers_email_address, entry_company, customers_telephone, customers_fax, entry_street_address, entry_city, entry_state, entry_postcode, countries_name ";
    $sql .= "FROM " . TABLE_ADDRESS_BOOK . ", " . TABLE_CUSTOMERS . ", " . TABLE_COUNTRIES . " ";
    $sql .= "WHERE " . TABLE_CUSTOMERS . ".customers_id=" . TABLE_ADDRESS_BOOK . ".customers_id AND " . TABLE_ADDRESS_BOOK . ".entry_country_id=" . TABLE_COUNTRIES . ".countries_id ";
    $sql .= "ORDER BY ".TABLE_CUSTOMERS.".customers_id ";
	$sql .= "LIMIT $startnum,$batchsize";
	if ($debug) { echo "Executing SQL: $sql\r\n"; }
    
    $result = mysql_query($sql) or die("SETIError: SQL error in downloadcustomers(): ".mysql_error());

  echo "<Response>"
   . "<ResponseCode>1</ResponseCode>"
   . "<ResponseDescription>success</ResponseDescription>"
   . "</Response>\r\n";

    while ($cust = mysql_fetch_array($result)) {
		echo "<Customer>"
				."<WebID>" .url_encode($cust["customers_id"]). "</WebID>\r\n"
				."<ShipAddr>"
					."<FirstName>" .url_encode($cust["customers_firstname"]). "</FirstName>\r\n"
					."<LastName>" .url_encode($cust["customers_lastname"]). "</LastName>\r\n"
					."<Email>" .url_encode($cust["customers_email_address"]). "</Email>\r\n"
					."<Company>" .url_encode($cust["entry_company"]). "</Company>\r\n"
					."<Phone>" .url_encode($cust["customers_telephone"]). "</Phone>\r\n"
					."<Fax>" .url_encode($cust["customers_fax"]). "</Fax>\r\n"
					."<Addr1>" .url_encode($cust["entry_street_address"]). "</Addr1>\r\n"
					."<City>" .url_encode($cust["entry_city"]). "</City>\r\n"
					."<State>" .url_encode($cust["entry_state"]). "</State>\r\n"
					."<Zip>" .url_encode($cust["entry_postcode"]). "</Zip>\r\n"
					."<Country>" .url_encode($cust["countries_name"]). "</Country>\r\n"
				."</ShipAddr>"
				."<BillAddr>"
					."<FirstName>" .url_encode($cust["customers_firstname"]). "</FirstName>\r\n"
					."<LastName>" .url_encode($cust["customers_lastname"]). "</LastName>\r\n"
					."<Email>" .url_encode($cust["customers_email_address"]). "</Email>"
					."<Company>" .url_encode($cust["entry_company"]). "</Company>\r\n"
					."<Phone>" .url_encode($cust["customers_telephone"]). "</Phone>\r\n"
					."<Fax>" .url_encode($cust["customers_fax"]). "</Fax>\r\n"
					."<Addr1>" .url_encode($cust["entry_street_address"]). "</Addr1>\r\n"
					."<City>" .url_encode($cust["entry_city"]). "</City>\r\n"
					."<State>" .url_encode($cust["entry_state"]). "</State>\r\n"
					."<Zip>" .url_encode($cust["entry_postcode"]). "</Zip>\r\n"
					."<Country>" .url_encode($cust["countries_name"]). "</Country>\r\n"
				."</BillAddr>\r\n"
		."</Customer>\r\n";
    }    
    echo "</SETICustomers>";
    
    return;
}

function downloadprods () {
	global $debug;
	$startnum =  (isset($_REQUEST[startnum]) ? ((int)$_REQUEST[startnum] > 0 ? (int)$_REQUEST[startnum] - 1 : 0) : 0);
	$batchsize = (isset($_REQUEST[batchsize]) ? $_REQUEST[batchsize] : 100);

	$sql = "SELECT ".TABLE_PRODUCTS.".products_id, products_name, products_price, products_description, products_weight, products_image, products_tax_class_id, UNIX_TIMESTAMP(products_date_available) as products_date_available, products_quantity, products_model ";
	$sql .= "FROM " .TABLE_PRODUCTS. ", " .TABLE_PRODUCTS_DESCRIPTION;
	if (TAX_CLASS_TO_IMPORT > -1) { $sql .= ", " .TABLE_TAX_CLASS; }
	$sql .= " WHERE " .TABLE_PRODUCTS. ".products_id=" .TABLE_PRODUCTS_DESCRIPTION. ".products_id AND " .TABLE_PRODUCTS_DESCRIPTION. ".language_id=".LANGUAGE_ID." ";
	if (TAX_CLASS_TO_IMPORT > -1) { $sql .= "AND " .TABLE_PRODUCTS. ".products_tax_class_id=" .TABLE_TAX_CLASS. ".tax_class_id AND products.products_tax_class_id='".TAX_CLASS_TO_IMPORT."' ";}
	$sql .= "ORDER BY ".TABLE_PRODUCTS.".products_id ";
	$sql .= "LIMIT $startnum,$batchsize";
	if ($debug) { echo "Executing SQL: $sql\r\n"; }
	$result = mysql_query($sql) or die("SETIError: SQL server failed to generate a product list: ".mysql_error());
	
	$xmloutput = "<SETIProducts>" . "\r\n";

    $xmloutput 	.= "<Response>"
    			. "<ResponseCode>1</ResponseCode>"
    			. "<ResponseDescription>success</ResponseDescription>"
    			. "</Response>\r\n";

	while ($prod = mysql_fetch_assoc($result)) {
		$products_tax_class = (($prod["products_tax_class_id"] == TAXABLE_GOODS) ? "Yes" : "No");
		$products_discontinued = ((time() > $prod["products_date_available"]) ? "No" : "Yes");
		$sku = (($prod["products_model"] != '') ? $prod["products_model"] : $prod["products_name"]);
		
		$xmloutput .= "<Product>\r\n"
					. "<Code>" .url_encode($sku). "</Code>\r\n"
					. "<WebID>" .$prod["products_id"]. "</WebID>\r\n"
					. "<Name>" .url_encode($prod["products_name"]). "</Name>\r\n"
					. "<Price>$prod[products_price]</Price>\r\n"
					. "<Description>" .url_encode($prod["products_description"]). "</Description>\r\n"
					. "<Weight>" .$prod["products_weight"]. "</Weight>\r\n"
					. "<Thumb/>\r\n"
					. "<Image>".url_encode($prod["products_image"])."</Image>\r\n"
					. "<Taxable>" .url_encode($products_tax_class). "</Taxable>\r\n"
					. "<Discontinued>" .url_encode($products_discontinued). "</Discontinued>\r\n"
					. "<QOH>" .$prod["products_quantity"]. "</QOH>\r\n";

		// Does this product have options?
		$opt_sql = "SELECT * FROM " .TABLE_PRODUCTS_ATTRIBUTES." as pa, ".TABLE_PRODUCTS_OPTIONS." as po"
		         . " WHERE pa.products_id = ".$prod["products_id"]
		         . " AND pa.options_id = po.products_options_id";
		$opt_result = mysql_query($opt_sql) or die("SETIError: MySQL Error in downloadprods(), no options response from product ".$prod["products_id"].": ".mysql_error());
		if (@mysql_num_rows($opt_result) > 0) {
			$xmloutput .= "<OptionLists>\r\n";		
			// Options exist - find out IDs, then get a list w/ any necessary value changes
			$optlist_sql = "SELECT DISTINCT options_id, products_options_name FROM ".TABLE_PRODUCTS_OPTIONS." AS po, ".TABLE_PRODUCTS_ATTRIBUTES." AS pa"
							. " WHERE pa.options_id = po.products_options_id AND po.language_id=".LANGUAGE_ID." AND pa.products_id ='".$prod["products_id"]."'"
							. " ORDER BY products_options_name";
			$optlist_result = mysql_query($optlist_sql) or die("SETIError: MySQL Error in downloadprods(), no option list response");
			while ($opt = mysql_fetch_assoc($optlist_result)) {
				$xmloutput .= "<ProductOption>\r\n"
							. "<WebID>" .url_encode($opt["options_id"]). "</WebID>\r\n" 
							. "<Name>" .url_encode($opt["products_options_name"]). "</Name>\r\n";
				// Take each option ID and output a list of possible values
				$optval_sql = "SELECT options_values_price, price_prefix, products_options_values_name, products_options_name"
							. " FROM ".TABLE_PRODUCTS_ATTRIBUTES." AS pa, ".TABLE_PRODUCTS_OPTIONS_VALUES." AS pov, ".TABLE_PRODUCTS_OPTIONS." AS po"
							. " WHERE pov.products_options_values_id = pa.options_values_id AND po.products_options_id = pa.options_id AND pov.language_id=".LANGUAGE_ID." AND po.language_id=".LANGUAGE_ID
							. " AND pa.products_id = '".$prod["products_id"]."' AND pa.options_id = '".$opt["options_id"]."'"
							. " ORDER BY products_options_values_name";
				
				$optval_result = mysql_query($optval_sql) or die("SETIError: MySQL Error in downloadprods(), no option values returned");
				while ($optval = mysql_fetch_assoc($optval_result)) {
					$price_prefix = (($optval["price_prefix"] == "+") ? "" : "-");
					$xmloutput .= "<OptionValue>\r\n"
								. "<Name>" .url_encode($optval["products_options_values_name"]). "</Name>\r\n"
								. "<Price>" .$price_prefix . $optval["options_values_price"]. "</Price>\r\n"
								. "</OptionValue>\r\n";	
				}			
				$xmloutput .= "</ProductOption>\r\n";
			}	
			// End of option lists.
			$xmloutput .= "</OptionLists>\r\n";
		}
		// End of product loop.	
		$xmloutput .= "</Product>\r\n";		
	}
	$xmloutput .= "</SETIProducts>";
	
	sendHeader();
	echo $xmloutput;

	return;
}

function downloadorders () {
	global $seti_authnet, $debug;
	$error = ""; $xmloutput = "";	$output = array(0 => ""); $i = 0;
	$sdate = DATESTRING_MYSQL;
	$startnum =  (isset($_REQUEST['startnum']) ? ((int)$_REQUEST['startnum'] > 0 ? (int)$_REQUEST['startnum'] - 1 : 0) : 0);
	$batchsize = (isset($_REQUEST['batchsize']) ? $_REQUEST['batchsize'] : 100);
	$lastorder = (isset($_REQUEST['lastorder']) ? $_REQUEST['lastorder'] : 0); 
	if (strtoupper($lastorder) == "ALL") { $lastorder = 0; }
	
	$sql = "SELECT *,DATE_FORMAT(date_purchased, '$sdate') as purchase_date"
		. " FROM " .TABLE_ORDERS
		. " WHERE orders_id > $lastorder"
		. ((USE_STATUS >= 0) ? " AND orders.orders_status = '".USE_STATUS."'" : "")
		. " ORDER BY orders_id"
		. " LIMIT $startnum,$batchsize";
		
	if ($debug) { echo "Executing SQL: $sql\r\n"; }
	$ord_result = mysql_query($sql) or die(mysql_error());
	
	if (mysql_num_rows($ord_result) < 1) {
		sendHeader();
		echo "<SETIOrders>\r\n";
		echo "<Response><ResponseCode>2</ResponseCode><ResponseDescription>success</ResponseDescription></Response>\r\n";
		echo "</SETIOrders>";
		return;
	}

	//Check if we're using a SETI Authnet module:
	$sql = "SELECT configuration_key, configuration_value FROM ".TABLE_CONFIGURATION." WHERE configuration_key LIKE '%AUTHORIZENET_SETI%'";
	$result = mysql_query($sql);
	if (@mysql_num_rows($result) > 0) {
		while ($arr = mysql_fetch_assoc($result)) {
			$seti_authnet[$arr[configuration_key]] = $arr[configuration_value];
		}
	}

	// Start array, step through array with each result
	while ($ord = mysql_fetch_assoc($ord_result)) {
		// Initialize ALL output variables.
		$item = ""; $item2 = ""; $attr = ""; $arr = ""; $sql = "";
		$ot_prodtotal = 0; $ot_total = 0; $ot_tax = 0; $ot_subtotal = 0; $total_weight = 0;
		$output_text = ""; $ot_shipping = 0; $ot_shipping_method = ""; $ot_lowordfee = 0; $ot_lowordfee_text = "";
		$ot_gv_amt = 0; $ot_coupon_amt = 0; $ot_gv_name = ""; $ot_coupon_name = ""; $comments = ""; $sku = "";
		$ot_disc_amt = 0; $ot_disc_name = "";
		
		$li_sql = "SELECT products_id, products_name, products_model, products_price, final_price, products_quantity, orders_products_id FROM ".TABLE_ORDERS_PRODUCTS." WHERE ".TABLE_ORDERS_PRODUCTS.".orders_id='".$ord["orders_id"]."'";
		$li_result = mysql_query($li_sql) or die(mysql_error());
		if (mysql_num_rows($li_result) < 1) 
			continue; //skip this order if there aren't any line items present.
		
		// Customer checkout comments
		$sql = "SELECT ".TABLE_ORDERS.".orders_id, ".TABLE_ORDERS_STATUS_HISTORY.".comments FROM ".TABLE_ORDERS.", ".TABLE_ORDERS_STATUS_HISTORY." WHERE ".TABLE_ORDERS.".orders_id=".TABLE_ORDERS_STATUS_HISTORY.".orders_id AND orders.orders_id=$ord[orders_id]";
		$result = mysql_query($sql) or die("SETIError: Error getting customer checkout comments: ".mysql_error());
		while ($arr = mysql_fetch_assoc($result)) {
			if ($comments != '') { $comments .= "\r\n" .COMMENTS_SEPARATOR. "\r\n"; }
			$comments .= $arr[comments];
		}
		
		$sql = "SELECT final_price, products_tax, products_quantity FROM ".TABLE_ORDERS_PRODUCTS." WHERE ".TABLE_ORDERS_PRODUCTS.".orders_id='".$ord["orders_id"]."'";
		$result = mysql_query($sql) or die("SETIError: Could not determine order subtotal.");
		while ($arr = mysql_fetch_assoc($result)) {
			$ot_subtotal += ($arr["final_price"] * $arr["products_quantity"]);
		}
		
		// Pull totals from orders_total.
		$sql = "SELECT title, value, class FROM ".TABLE_ORDERS_TOTAL." AS ot WHERE ot.orders_id ='".$ord["orders_id"]."'";
		$result = mysql_query($sql) or die("SETIError: Could not determine final totals.");
		while ($arr = mysql_fetch_assoc($result)) {
			if ($arr["class"] == "ot_shipping") {
				 $ot_shipping = $arr["value"]; 
				 $ot_shipping_method = $arr["title"]; 
				 //$ot_shipping_method = str_replace(":", "", $ot_shipping_method);
			} 
			elseif ($arr["class"] == "ot_tax") { $ot_tax = $arr["value"]; } 
			elseif ($arr["class"] == "ot_total") { $ot_total = $arr["value"]; }
			elseif ($arr["class"] == "ot_loworderfee") { 
				$ot_lowordfee = $arr["value"]; 
				$ot_lowordfee_text = $arr["title"];
				$ot_lowordfee_text = str_replace(":", "", $ot_lowordfee_text);
			}
			elseif ($arr["class"] == "ot_coupon") { 
				$ot_coupon_amt = $arr["value"]; 
				$ot_coupon_name = $arr["title"];
				$ot_coupon_name = str_replace("Discount Coupons:", "", $ot_coupon_name);
				$ot_coupon_name = str_replace(":", "", $ot_coupon_name);
			}
			elseif ($arr["class"] == "ot_gv") {
				$ot_gv_amt = $arr["value"];
				$ot_gv_name = $arr["title"];
				$ot_gv_name = str_replace("s:", " ", $ot_gv_name);
			}
			elseif ($arr["class"] == "ot_lev_discount" || $arr["class"] == "ot_group_pricing") { 
				$ot_disc_amt += $arr["value"];
				$ot_disc_name .= $arr["title"]. " ";
				$ot_disc_name = str_replace(":", "", $ot_disc_name);
			}
		}
		
		// Calculate total product weight
		$sql = "SELECT ".TABLE_ORDERS.".orders_id, ".TABLE_ORDERS_PRODUCTS.".products_id, ".TABLE_ORDERS_PRODUCTS.".products_quantity, ".TABLE_PRODUCTS.".products_weight FROM ".TABLE_ORDERS.", ".TABLE_ORDERS_PRODUCTS.", ".TABLE_PRODUCTS;
		$sql .= " WHERE ".TABLE_ORDERS.".orders_id=".TABLE_ORDERS_PRODUCTS.".orders_id AND ".TABLE_ORDERS_PRODUCTS.".products_id=".TABLE_PRODUCTS.".products_id AND ".TABLE_ORDERS.".orders_id ='".$ord["orders_id"]."'";
		$result = mysql_query($sql) or die("SETIError: SQL server failed to provide product weight info.");
		while ($arr = mysql_fetch_assoc($result)) {
			$total_weight += ($arr["products_quantity"] * $arr["products_weight"]);
		}
		
		//Start populating $output_text with the new order.		
		$output_text .= "<Order>"
		. "<OrderNumber>" . $ord["orders_id"] . "</OrderNumber>\r\n"
		. "<OrderDate>" . url_encode($ord["purchase_date"]) . "</OrderDate>\r\n";

		//Check if we have an actual billing address - if not, use delivery address
		if(($ord["billing_name"] == "" || $ord["billing_street_address"] == "") && $ord["billing_postcode"] == "") {
		$output_text .= "<Billing>\r\n"
			. "<CustomerId>" . url_encode($ord["customers_id"]) . "</CustomerId>\r\n"
			. "<FullName>" . url_encode($ord["delivery_name"]) . "</FullName>\r\n"
			. "<Company>" . url_encode($ord["delivery_company"]) . "</Company>\r\n"
			. "<Phone>" . url_encode($ord["customers_telephone"]) . "</Phone>\r\n"
			. "<Address>\r\n"
			. "<Street1>" . url_encode($ord["delivery_street_address"]) . "</Street1>\r\n"
			. "<Street2>" . url_encode($ord["delivery_suburb"]) . "</Street2>\r\n"
			. "<City>" . url_encode($ord["delivery_city"]) . "</City>\r\n"
			. "<State>" . url_encode($ord["delivery_state"]) . "</State>\r\n"
			. "<Code>" . url_encode($ord["delivery_postcode"]) . "</Code>\r\n"
			. "<Country>" . url_encode($ord["delivery_country"]) . "</Country>\r\n"
			. "</Address>\r\n"
			. "</Billing>\r\n";
		} else {
		$output_text .= "<Billing>\r\n"
			. "<CustomerId>" . url_encode($ord["customers_id"]) . "</CustomerId>\r\n"
			. "<FullName>" . url_encode($ord["billing_name"]) . "</FullName>\r\n"
			. "<Email>" . url_encode($ord["customers_email_address"]) . "</Email>\r\n"
			. "<Company>" . url_encode($ord["billing_company"]) . "</Company>\r\n"
			. "<Phone>" . url_encode($ord["customers_telephone"]) . "</Phone>\r\n"
			. "<Address>\r\n"
			. "<Street1>" . url_encode($ord["billing_street_address"]) . "</Street1>\r\n"
			. "<Street2>" . url_encode($ord["billing_suburb"]) . "</Street2>\r\n"
			. "<City>" . url_encode($ord["billing_city"]) . "</City>\r\n"
			. "<State>" . url_encode($ord["billing_state"]) . "</State>\r\n"
			. "<Code>" . url_encode($ord["billing_postcode"]) . "</Code>\r\n"
			. "<Country>" . url_encode($ord["billing_country"]) . "</Country>\r\n"
			. "</Address>\r\n"
			. "</Billing>\r\n";
		}
		
		$output_text .= "<Shipping>\r\n"
		. "<FullName>" . url_encode($ord["delivery_name"]) . "</FullName>\r\n"
		. "<Company>" . url_encode($ord["delivery_company"]) . "</Company>\r\n"
		. "<Phone>" . url_encode($ord["customers_telephone"]) . "</Phone>\r\n"
		. "<Address>"
		. "<Street1>" . url_encode($ord["delivery_street_address"]) . "</Street1>\r\n"
		. "<Street2>" . url_encode($ord["delivery_suburb"]) . "</Street2>\r\n"
		. "<City>" . url_encode($ord["delivery_city"]) . "</City>\r\n"
		. "<State>" . url_encode($ord["delivery_state"]) . "</State>\r\n"
		. "<Code>" . url_encode($ord["delivery_postcode"]) . "</Code>\r\n"
		. "<Country>" . url_encode($ord["delivery_country"]) . "</Country>\r\n"
		. "</Address>\r\n";
		
		//Handle each line item.
		$li_sql = "SELECT products_id, products_name, products_model, products_price, final_price, products_quantity, orders_products_id FROM ".TABLE_ORDERS_PRODUCTS." WHERE ".TABLE_ORDERS_PRODUCTS.".orders_id='".$ord["orders_id"]."'";
		$li_result = mysql_query($li_sql) or die(mysql_error());
		while ($item = mysql_fetch_assoc($li_result)) {
			$item2_sql = "select products_tax_class_id, products_weight from " .TABLE_PRODUCTS. " where products_id=" .$item["products_id"]. "";
			$item2_result = mysql_query($item2_sql);
			$item2 = mysql_fetch_assoc($item2_result);
			$taxable = (($item2["products_tax_class_id"] == TAXABLE_GOODS) ? "Yes" : "No");
			$sku = (($item["products_model"] != '') ? $item["products_model"] : $item["products_name"]);

			$output_text .= "<Product>\r\n"
			. "<ProdType></ProdType>\r\n"
			. "<Name>" . url_encode($item["products_name"]) . "</Name>\r\n"
			. "<SKU>" . url_encode($sku) . "</SKU>\r\n"
			. "<Taxable>" . url_encode($taxable) . "</Taxable>\r\n"
			. "<Quantity>" . url_encode($item["products_quantity"]) . "</Quantity>\r\n"
			. "<ItemPrice>$item[final_price]</ItemPrice>\r\n"
			. "<Weight>$item2[products_weight]</Weight>\r\n"
			. "<Dimension></Dimension>\r\n";
			
			$ot_prodtotal += $item["products_quantity"] * $item["final_price"];
			
			//Get each product's options, if set.
			$att_sql = "SELECT * FROM ".TABLE_ORDERS_PRODUCTS." op, ".TABLE_ORDERS_PRODUCTS_ATTRIBUTES." opa"
					. " WHERE op.orders_id=" .$ord["orders_id"]. " AND op.products_id=" .$item["products_id"]
					. " AND op.orders_products_id=" . $item["orders_products_id"] . " AND op.orders_products_id = opa.orders_products_id"
					. " ORDER BY opa.products_options";
			$att_result = mysql_query($att_sql) or die("SETIError: SQL server did not list product attributes.");
			if (mysql_num_rows($att_result) > 0) {
				while ($attr = mysql_fetch_assoc($att_result)) {
					$attr["price_prefix"] = ((float)$attr["options_values_price"] > 0 ? "" : "-");
					
					$output_text .= "<OrderOption>\r\n"
					. "<OptionName>" . url_encode($attr["products_options"]) . "</OptionName>\r\n"
					. "<SelectedOption>" . url_encode($attr["products_options_values"]) . "</SelectedOption>\r\n"
					. "<OptionPrice>" . $attr["price_prefix"] . round($attr["options_values_price"], 2) . "</OptionPrice>\r\n"
					. "</OrderOption>";
				}
			}
			$output_text .= "</Product>\r\n";
			
		} 	//End of Line Items (</Shipping>)
		$output_text .= "</Shipping>\r\n";
		
		// Payment section
		$output_text .= get_order_payment($ord["payment_method"], $ord);
		
		// Begin <Totals>...
		$output_text .= "<Totals>\r\n"
		. "<ProductTotal>$ot_prodtotal</ProductTotal>\r\n"
		. "<Subtotal>$ot_subtotal</Subtotal>\r\n"
		. "<Tax>\r\n"
		. "<TaxShipping>No</TaxShipping>\r\n" // Assume no; can be overridden in OM
		. "<TaxAmount>$ot_tax</TaxAmount>\r\n"
		. "<TaxRate></TaxRate>\r\n"
		. "</Tax>\r\n"
		. "<GrandTotal>$ot_total</GrandTotal>\r\n"
		. "<ShippingTotal>\r\n"
		. "<Total>$ot_shipping</Total>\r\n"
		. "<Description>".url_encode($ot_shipping_method)."</Description>\r\n"
		. "</ShippingTotal>\r\n";
		
		if ($ot_lowordfee > 0) {
			$output_text .= "<Surcharge>\r\n" // Currently, just the Low Order fee...
			. 	"<Total>$ot_lowordfee</Total>\r\n"
			. 	"<Description>".url_encode($ot_lowordfee_text)."</Description>\r\n"
			. "</Surcharge>\r\n";
		}
		
		if ($ot_disc_amt > 0) { 
			$output_text .= "<Discount>\r\n"
			.	"<Description>".url_encode($ot_disc_name)."</Description>\r\n"
			.	"<Amount>$ot_disc_amt</Amount>\r\n"
			. "</Discount>\r\n";
		}
		
		$output_text .=	"</Totals>\r\n";
		
		// Check for a coupon amount > 0, and output if exists, otherwise output closed tag.
		if ($ot_coupon_amt > 0) {
			$output_text .= "<Coupon>\r\n"
			. "<Name>".url_encode($ot_coupon_name)."</Name>\r\n"
			. "<Total>$ot_coupon_amt</Total>\r\n"
			. "</Coupon>\r\n";			
		} else {
			$output_text .= "<Coupon></Coupon>\r\n";
		}		
		// Ditto for gift vouchers
		if ($ot_gv_amt > 0) {
			$output_text .= "<GiftCertificate>\r\n"
			. "<Name>".url_encode($ot_gv_name)."</Name>\r\n"
			. "<Total>$ot_gv_amt</Total>\r\n"
			. "</GiftCertificate>\r\n";		
		}
		$output_text .= "<Other>\r\n"
		. "<Associate/>\r\n"
		. "<OrderInstructions/>\r\n"
		. "<Comments>" .url_encode($comments). "</Comments>\r\n"
		. "<TotalOrderWeight>$total_weight</TotalOrderWeight>\r\n"
		. "</Other>\r\n"
		. "</Order>\r\n";
		
		$output[$i][0] = $output_text;
		$output[$i][1] = $ord["orders_id"];
		$i++;
		
	} // End of while() statement
	// Do some error checking before we output the orders
	sendHeader();
	if (mysql_error() || $error != '') {
		echo "<Response><ResponseCode>3</ResponseCode><ReponseDescription>\r\n";
		if (mysql_error()) { echo mysql_errno() . ": " .mysql_error() ."\n"; } 
		else if ($error != '') {
			echo "Error: $error\r\n";
			echo "</ResponseDescription></Response>";
		}
	} else {
		$xmloutput .= "<SETIOrders>";
		$xmloutput .=
		"<Response>\r\n"
		. "<ResponseCode>1</ResponseCode>\r\n"
		. "<ResponseDescription>success</ResponseDescription>\r\n"
		. "<ScriptVersion>2.12</ScriptVersion>\r\n"
		. "<XMLImportVersion>1.0</XMLImportVersion>\r\n"
		. "<StoreType>osCommerce</StoreType>\r\n"
		. "<CreateDate>" .date(DATESTRING_PHP). "</CreateDate>\r\n"
		. "</Response>\r\n";
		
		// Any additional error checking on the actual input can be done here.
		for ($j=0; $j <= $i; $j++) {
			if (isset($output[$j])) {
				$xmloutput .= $output[$j][0];
				
				// Update the order status, if UPDATE_ORDER_STATUS is true
				if (UPDATE_ORDER_STATUS) { 
					$sql = "INSERT INTO `orders_status_history` ( `orders_status_history_id` , `orders_id` , `orders_status_id` , `date_added` , `customer_notified` , `comments` )"
								 ." VALUES ('', '".$output[$j][1]."', '".UPDATE_STATUS_TO."', NOW( ) , '".UPDATE_STATUS_CUSTOMER_NOTIFIED."', 'Order downloaded on ".date(DATESTRING_PHP)."');";
					@mysql_query($sql);
					$sql = "UPDATE `orders` SET `orders_status` = '".UPDATE_STATUS_TO."' WHERE orders_id = '".$output[$j][1]."'";
					@mysql_query($sql);
				}
				// Delete the credit card number from the order, if DELETE_CC is true
				if (DELETE_CC) { 
					$sql = "UPDATE orders SET cc_number = '0000', cc_expires = '00', cc_type = 'deleted', cc_owner = 'deleted' WHERE orders_id = '".$output[$j][1]."'";
					@mysql_query($sql);
				}	
			}
		}
		$xmloutput .= "</SETIOrders>";
	}
	echo $xmloutput;
	return;
}

function get_order_payment($method, &$order) {
	global $seti_authnet, $debug;
	
	$method = substr($method, 0, 30);
	if ($debug) { echo "[get_order_payment] method is $method\r\n"; }
	
	$authnet = (stristr($method, substr(AUTHNET_TITLE, 0, 30)) && !empty($seti_authnet[MODULE_PAYMENT_AUTHORIZENET_SETI_USECRYPT]));
	$credit = (stristr($method, substr(AUTHNET_TITLE, 0, 30)) || stristr($method, substr(CC_TITLE, 0, 30)) || stristr($method, substr(PAYFLOW_TITLE, 0, 30)));
	$paypal = (stristr($method, "paypal") || stristr($method, substr(PAYPAL_TITLE, 0, 30)));
	$cod = (stristr($method, substr(COD_TITLE, 0, 30)));
	$check = (stristr($method, "check") || stristr($method, substr(MONEYORDER_TITLE, 0, 30)));
	
	if ($authnet) {	
		$ok = false;
		if ($seti_authnet[MODULE_PAYMENT_AUTHORIZENET_SETI_USECRYPT] == 'True') {
			$key = $seti_authnet[MODULE_PAYMENT_AUTHORIZENET_SETI_ENCKEY];
			for ($a=0; $a<10; $a++) {
				$r = mysql_query("select seti_authnet_data, seti_authnet_hash from seti_authnet where seti_authnet_id='$order[orders_id]'");
				if (@mysql_num_rows($r)>0) {
					$arr = mysql_fetch_assoc($r);
					$cc = setienc(urldecode($arr[seti_authnet_data]), true, $key);
					if (md5($cc) == $arr[seti_authnet_hash]) { $ok = true; break; }
					elseif ($arr[seti_authnet_hash] == null) { $ok = true; break; }
				} else {
					$cc = "MISSING DATA FROM seti_authnet TABLE.";
					break;
				}
			}
			if (!$ok && !$cc) { $cc = "DECRYPTION FAILED."; }
		} else {
			$ok = true;
			$arr = @mysql_fetch_assoc(mysql_query("select seti_authnet_data from seti_authnet where seti_authnet_id='$order[orders_id]'"));
			if (isset($arr[seti_authnet_data])) { $cc = urldecode($arr[seti_authnet_data]); }
			else { $ok = false; $cc = "MISSING DATA FROM seti_authnet TABLE."; }
		}
		
		if ($ok) { list($cc_num, $cc_exp, $auth_code, $trans_id, $cvv2, $avs, $owner, $type) = explode(";", $cc); }
		else { $cc_num = "4111111111111111"; $cc_exp = "0199"; $authcode=0; $trans_id=0; $avs="N"; $owner=""; $type="Visa"; }	
			$return = "<Payment>\r\n<CreditCard>\r\n"
				."<Issuer>".url_encode($type)."</Issuer>\r\n"
				."<Number>".url_encode($cc_num)."</Number>\r\n"
				."<VerificationValue>".url_encode($cvv2)."</VerificationValue>\r\n"
				."<FullName>".url_encode($owner)."</FullName>\r\n"
				."<Company></Company>\r\n"
				."<ExpirationDate>".url_encode($cc_exp)."</ExpirationDate>\r\n"
				."<BankName></BankName>\r\n"
				."<OrderProcessingInfo>".url_encode("$method: $cc")."</OrderProcessingInfo>\r\n"
				."<AVS>".url_encode($avs)."</AVS>\r\n"
				."<TransID>".url_encode($trans_id)."</TransID>\r\n"
				."<AuthCode>".url_encode($auth_code)."</AuthCode>\r\n"
				."<ProcessLevel/>\r\n"
				."</CreditCard>\r\n</Payment>\r\n";
	} elseif ($credit) {
			$return = "<Payment>\r\n<CreditCard>\r\n"
			."<Issuer>".url_encode($order[cc_type])."</Issuer>\r\n" 
			. "<Number>".url_encode($order[cc_number])."</Number>\r\n" 
			. "<FullName>".url_encode($order[cc_owner])."</FullName>\r\n"
			. "<ExpirationDate>".url_encode($order[cc_expires])."</ExpirationDate>\r\n"
			. "</CreditCard>\r\n</Payment>\r\n";
	} elseif ($paypal) { 
		$return = "<Payment>\r\n<PayPal></PayPal>\r\n</Payment>\r\n";
	} elseif ($cod) {
		$return = "<Payment><COD></COD></Payment>\r\n";
	} elseif ($check) {
		$return = "<Payment><Check></Check></Payment>\r\n";
	} else {
		$return = "<Payment>\r\n<Generic1>\r\n<Name>".url_encode($method)."</Name>\r\n<Description>UNKNOWN PAYMENT TYPE</Description>\r\n</Generic1>\r\n</Payment>\r\n";
	}
	return $return;
}

function updatestatus() {
	global $debug;
	$status = $_REQUEST['orderstatus'];
	$ordernum = $_REQUEST['ordernumber'];
	$status_id = false;

	if ($debug) { echo "status: $status, ordernum: $ordernum\r\n"; }
	$sql = "SELECT orders_status_id FROM ". TABLE_ORDERS_STATUS ." WHERE orders_status_name='$status'";
	$r = mysql_query($sql) or die("SETIError: " .mysql_error());
	$status_id = @mysql_result($r, 0, 0);
	if ($debug) { echo "status_id: $status_id\r\n"; }
	
	if ((int)$status_id > 0) {
		$sql = "INSERT INTO " .TABLE_ORDERS_STATUS_HISTORY. " (orders_id, orders_status_id, date_added, customer_notified) VALUES ($ordernum, $status_id, NOW(), '1')";
		mysql_query($sql) or die("SETIError: [updatestatus] ".mysql_error());
		$sql = "UPDATE " .TABLE_ORDERS . " SET orders_status='$status_id' WHERE orders_id='$ordernum'";
		mysql_query($sql) or die("SETIError: [updatestatus] ".mysql_error());
		echo "SETIResponse=OK";
	} else { echo "SETIError: Status name '$status' is invalid."; }
	return;
}

function setienc_initialize ($pwd) {
  global $sbox;

  $intLength = strlen($pwd);
  for ($a = 0; $a < 256; $a++) {
    $skey[$a] = ord(substr($pwd, ($a % $intLength) + 1, 1));
    $sbox[$a] = $a;
  }

  $b = 0;
  for ($a = 0; $a < 256; $a++) {
    $b = ($b + $sbox[$a] + $skey[$a]) % 256;
    $tempSwap = $sbox[$a];
    $sbox[$a] = $sbox[$b];
    $sbox[$b] = $tempSwap;
  }

  return;
}

function setienc($t, $show, $pwd) {
  global $sbox;

	if ($t == "") { return $t; }
  $x = substr($t, 0, 1);
  if ($show) {
    if ($x != "~") { return false; }
    $t = substr($t, 1);
  } else if ($x == "~") { return false; }

  $i = 0; $j = 0; 
  $pwd = md5($pwd).md5(md5($pwd));
  setienc_initialize($pwd);
  for ($a = 1; $a <= strlen($t); $a++) {
    $i = (($i++) % 256);
    $j = (($j + $sbox[$i]) % 256);
    $temp = $sbox[$i];
    $sbox[$i] = $sbox[$j];
    $k = ($sbox[($sbox[$i] + $sbox[$j])] % 256);
    $d1 = ord(substr($t, ($a-1), 1));
    $x = $d1 ^ $k;
    $c .= chr($x);
  }

  if ($show) { return $c; } else { return "~" . $c; }
}
