<?php
include_once(dirname(__FILE__)."/npapi.php");
ini_set('display_errors', 'on'); error_reporting(E_ALL&~E_NOTICE);

$api = new npapi();

// Create voucher and gltransaction records

// First select the model (usually a db table name) we will be attaching data to
$api->set_model('gltransvoucher');

$data = array(	"voucher" => "TSTVCHR",
				"description" => "A Test Voucher from the API Test Page",
				// wherefrom -> 1=Accounts Payable  2=Accounts Receivable  3=General Ledger  4=Inventory  6=Payroll
				"wherefrom" => "2");
$api->set_data($data);

// For this example record a customer deposit made (debit checking account and credit deposit liability account)
$api->set_model('gltransaction');
$trans_total = 78.35;
$deposit_account = 1985; // ID from glaccount table
$checking_account = 1937; // ID from glaccount table
$data = array(
			array('glaccountid' => $checking_account, 'amount' => $trans_total),  // The Debit  
			array('glaccountid' => $deposit_account, 'amount' => -1*$trans_total) // The Credit
		);
$api->set_data($data);

// Set the action to perform on the API
// The format is controller/action where controller is the NolaPro entity (usually a db table name) that 
// you want to perform an action on
$api->action = "gltransvoucher/save";
$api->call_api();

// After call_api is run it clear out $api's data

$voucherid = 0;
if ($api->ok) {
	// The XML response from the API is stored as an object at $api->rsp using SimpleXMLElement
	$voucherid = (string) $api->rsp->gltransvoucher['id'];
	echo "Voucher added successfully: $voucherid";
} else {
	echo "Problem with transaction: ".$api->errorcode." ".$api->errormsg;
}

if ($voucherid) {
	
	// A shortcut to view a single record  (controller/view/id)
	$api->action = "gltransvoucher/view/$voucherid";
	$api->call_api();
	if ($api->ok) {
		echo "<br/><br/>Retrieved Details About Voucher ID $voucherid<br/>";
		echo "Entry Date: ".$api->rsp->gltransvoucher->entrydate."<br/>";
		echo "Entry User ID: ".$api->rsp->gltransvoucher->entryuserid."<br/>";
		echo "Voucher: ".$api->rsp->gltransvoucher->voucher."<br/>";
		echo "Description: ".$api->rsp->gltransvoucher->description."<br/>";

	} else {
		echo "Problem retrieving voucher: ".$api->errorcode." ".$api->errormsg;
	}
}