<?php
include_once(dirname(__FILE__)."/npapi.php");
ini_set('display_errors', 'on'); error_reporting(E_ALL&~E_NOTICE);

$api = new npapi();

// Use the URL format to pass in a parameter to the view action on the gencompany controller
// controller/action/param1/param2/param3...  This can also be accomplished using data[]
// post fields (data[fieldname]=1)
$api->action = "gencompany/view/1";
$api->call_api();

if ($api->ok) {
	// The XML response from the API is stored as an object at $api->rsp using SimpleXMLElement
	$companyname = (string) $api->rsp->gencompany->name;
	$email = (string) $api->rsp->gencompany->email;
	echo "<b>The API has been set up properly:</b> Company = $companyname (email: $email)<br/>";
	echo "<b>API URL:</b> $api->baseurl<br/>";
	echo "<b>API User ID:</b> $api->userid<br/>";
	echo "<b>API Company ID:</b> $api->companyid<br/>";
	echo "<b>API Trans ID:</b> $api->transid<br/>";
} else {
	echo "<b>Error returned from API:</b> $api->errorcode $api->errormsg<br/>";
	echo "<b>API Trans ID:</b> $api->transid<br/>";
	echo "<br/><br/>Be sure to activate the API add-on inside NolaPro and create an API key for at least one NolaPro user
		(Admin -> Setup -> User Add/Update).<br/>";
}

echo '<br/>Adjust the access fields at the top of npapi.php if needed ($npapi->userid, $npapi->companyid, $npapi->apikey, $npapi->baseurl).';
